
##############################################################################
#
# Copyright (c) 2003-2018 by The University of Queensland
# http://www.uq.edu.au
#
# Primary Business: Queensland, Australia
# Licensed under the Apache License, version 2.0
# http://www.apache.org/licenses/LICENSE-2.0
#
# Development until 2012 by Earth Systems Science Computational Center (ESSCC)
# Development 2012-2013 by School of Earth Sciences
# Development from 2014 by Centre for Geoscience Computing (GeoComp)
#
##############################################################################

from __future__ import print_function, division

__copyright__="""Copyright (c) 2003-2018 by The University of Queensland
http://www.uq.edu.au
Primary Business: Queensland, Australia"""
__license__="""Licensed under the Apache License, version 2.0
http://www.apache.org/licenses/LICENSE-2.0"""
__url__="https://launchpad.net/escript-finley"

"""
test for util operations for overloaded operations with tagged data

:remark: use see `test_util`
:var __author__: name of author
:var __copyright__: copyrights
:var __license__: licence agreement
:var __url__: url entry point on documentation
:var __version__: version
:var __date__: date of the version
"""

__author__="Lutz Gross, l.gross@uq.edu.au"

import esys.escriptcore.utestselect as unittest
import numpy
from esys.escript import *
from test_util_base  import Test_util_base

class Test_util_overloaded_binary_with_tagged_data(Test_util_base):
   """
   test for the overloaded operation +,*,-,** with tagged data
   """
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_float_rank0_taggedData_rank0(self):
      arg0=1.50451915133
      arg1=Data(2.72325184184,self.functionspace)
      arg1.setTaggedValue(1,-1.53110709808)
      res=arg0+arg1
      ref=Data(4.22777099317,self.functionspace)
      ref.setTaggedValue(1,-0.0265879467509)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_float_rank0_taggedData_rank1(self):
      arg0=4.85605770106
      arg1=Data(numpy.array([-4.3395065978127692, 0.60570049803379078]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([3.6501698136790175, 0.70663115395075415]))
      res=arg0+arg1
      ref=Data(numpy.array([0.51655110324225273, 5.4617581990888127]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([8.5062275147340394, 5.562688855005776]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_float_rank0_taggedData_rank2(self):
      arg0=-0.780040057582
      arg1=Data(numpy.array([[-0.43060722082989589, 4.9082210391037382, 3.0578289131250784, 3.7154492608955145, 
-2.3626698799747436], [-0.57744974579734798, 2.4341887960972821, 4.392772957150715, 1.1127940295848067, 0.44760835221981043], 
[-1.2193145533313352, -4.152462252060988, -4.2706830150788546, 4.5776144799277265, 0.65256256561792725], [-3.5327414050156101, 
2.3429801833558228, 1.4911702077299269, 2.8354223660854627, -0.26430257253103662]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[0.62130507833962412, -0.60045590874861698, 3.6234790358177822, -3.2788882822646626, 
-1.7438996590963152], [1.6721327727259316, 2.5390633030555261, 0.2829910346978437, 4.4539799434081377, 4.8840434912316528], 
[1.0851664329233426, -4.1944097108842797, 4.48550041534744, -0.7995182652802324, 3.135820962425024], [-4.5233071721581997, 
-1.5517102324890244, 4.3016103217286847, 1.7505119284463921, -1.705700729131002]]))
      res=arg0+arg1
      ref=Data(numpy.array([[-1.2106472784119626, 4.1281809815216715, 2.2777888555430117, 2.9354092033134478, 
-3.1427099375568104], [-1.3574898033794147, 1.6541487385152154, 3.6127328995686483, 0.33275397200273993, -0.3324317053622563], 
[-1.9993546109134019, -4.9325023096430547, -5.0507230726609214, 3.7975744223456598, -0.12747749196413949], 
[-4.3127814625976768, 1.5629401257737561, 0.71113015014786018, 2.055382308503396, -1.0443426301131034]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-0.15873497924244262, -1.3804959663306837, 2.8434389782357155, -4.0589283398467293, 
-2.5239397166783819], [0.8920927151438649, 1.7590232454734593, -0.49704902288422304, 3.673939885826071, 4.1040034336495861], 
[0.30512637534127585, -4.9744497684663465, 3.7054603577653733, -1.5795583228622991, 2.3557809048429572], [-5.3033472297402664, 
-2.3317502900710911, 3.521570264146618, 0.9704718708643254, -2.4857407867130688]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_float_rank0_taggedData_rank3(self):
      arg0=-1.25914761233
      arg1=Data(numpy.array([[[0.19880757909490221, 4.8460446335920828], [-3.1936192381699593, -1.1635220076802821]], 
[[1.4494533624381942, 2.5120339844502562], [-0.35838448192140149, 1.4590384789751418]], [[1.0904907042678804, 
-0.067519620819761705], [4.1431187422890794, 4.5472209967452688]], [[-2.5307687929933698, 3.6280121891219128], 
[1.8967142492061004, -4.9774431504202123]], [[-2.7027107601548082, 4.0579406806771487], [4.7102647693500383, 
1.8455023011836724]], [[-0.15878543942385726, -4.674729135281984], [2.4553707998877892, 
-1.5005871755549594]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[-4.4150211333004101, -4.6483235818952746], [-2.8399942762013075, 
4.5545530874004285]], [[-1.0494102272714168, 0.38330716008635868], [0.47865871849273134, 1.9327811922167619]], 
[[-3.0520059219429161, 4.7770058078546924], [0.42240461921480588, -3.8976847108053612]], [[-0.29672647979847788, 
-2.6943000503383074], [1.1002722489088104, -3.3713019279768011]], [[2.2759639615152256, 2.2169706569433547], 
[0.66018965728197632, 1.7904065463009822]], [[-3.4048208571366354, -0.72965243796581802], [-4.2087531569166874, 
-4.3094586983873393]]]))
      res=arg0+arg1
      ref=Data(numpy.array([[[-1.0603400332361872, 3.5868970212609934], [-4.4527668505010487, -2.4226696200113715]], 
[[0.19030575010710482, 1.2528863721191668], [-1.6175320942524909, 0.19989086664405242]], [[-0.16865690806320899, 
-1.3266672331508511], [2.88397112995799, 3.2880733844141794]], [[-3.7899164053244592, 2.3688645767908234], 
[0.63756663687501103, -6.2365907627513018]], [[-3.9618583724858976, 2.7987930683460593], [3.4511171570189489, 
0.58635468885258302]], [[-1.4179330517549467, -5.9338767476130734], [1.1962231875566998, 
-2.7597347878860488]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-5.6741687456314995, -5.907471194226364], [-4.0991418885323974, 3.2954054750693391]], 
[[-2.3085578396025062, -0.87584045224473073], [-0.78048889383835807, 0.67363357988567252]], [[-4.3111535342740055, 
3.517858195523603], [-0.83674299311628353, -5.1568323231364506]], [[-1.5558740921295673, -3.9534476626693968], 
[-0.15887536342227904, -4.6304495403078905]], [[1.0168163491841362, 0.95782304461226531], [-0.59895795504911309, 
0.53125893396989277]], [[-4.6639684694677248, -1.9888000502969074], [-5.4679007692477768, -5.5686063107184287]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_float_rank0_taggedData_rank4(self):
      arg0=0.258837220901
      arg1=Data(numpy.array([[[[3.8062917703913275, 1.5925302766342977, 2.375938618782051, 4.8408768651589646], 
[2.3442481475157093, -2.7496872132044894, 0.42271389992884512, -4.6454317947654209], [0.25224402422534897, 4.4179040454873881, 
-4.1624635493109476, -2.8403555046960669]], [[-1.7402014581620042, -0.39647776942146074, 1.6582392346191055, 
0.95100047115282837], [-2.5115869863610718, -4.0631674532788677, -3.3491982210982729, -0.79371461870273752], 
[-3.8811105449584025, -4.7756827547949623, -3.0355606009359448, -3.4495126246826024]]], [[[0.54052831056647754, 
1.3131371291603413, 1.5109369820155161, -4.5038693330152828], [-2.7757717507070034, -3.4702732547886708, -4.0345723932511053, 
-1.5176135064856702], [0.20132378821251606, -1.3011996084005704, -3.3627285656617367, -3.8790318668262955]], 
[[-2.8343704701651595, -3.2040830091023831, 1.7955913209143679, -1.1120062362187557], [2.4678677745222242, 4.6779889710192393, 
-2.9039968423280191, 4.5620672547251822], [-2.9707917064914815, 0.40203349974764357, -4.1595643750239395, 
-4.8398423972146425]]], [[[0.90209465588452176, 0.25241726058184, 0.82206430484315174, 0.23910272220713846], 
[1.1998005688428934, 2.7432470837000986, 3.405738144982422, 2.2153056603059262], [4.2665609582282773, -2.4440559784399052, 
-0.21844804372131499, -2.6740342714550636]], [[-0.35286002435519581, -3.2544391698145017, 1.6101760802462861, 
2.852727295232742], [3.3031205880381211, -4.0910259111112541, -3.572261502523383, -1.6576439736314965], [-4.0708535566068971, 
0.89830610466834404, -2.1444076751959695, -4.5363920893045249]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[3.1767399278718287, -4.6569253000973454, -3.0756556601909657, -1.1833991361679908], 
[1.0050292771371456, 4.4691598561558283, -1.7916826017675005, -4.7342403422875856], [-0.7786507136749119, 1.6960644379951892, 
3.3133891953253585, 1.7522779008527145]], [[4.3662508335717725, -0.48897498526348748, -3.8147567535836204, 1.6120397979566716], 
[-3.1407449215468439, 3.783252247124409, 0.53165610812556174, -4.8767350509416021], [3.3399571491607158, -3.5835576415323525, 
-4.7823600282016088, -3.9888663220494758]]], [[[-0.70505421666153545, -0.96931454128354222, 3.5579576363997862, 
-4.8922170382559234], [-1.0101891756408499, 4.0449327618070345, 1.4287287933352335, 2.7932127127424602], [-1.1844659178082537, 
-3.1172167429375932, 3.7586512122849509, -1.9672827094129763]], [[-0.19893429465188639, -4.5909962617427658, 
4.8074518840957854, 0.3484829166820882], [-4.6647394483178628, -2.4786438939387256, 3.3568201792741235, -2.64715841657718], 
[-1.2323878832119703, 4.4122940094846452, 4.1747597400695202, 1.495047169558279]]], [[[-1.2345115692788191, 2.7793548546816895, 
-4.1091272044165015, 0.99053747681914128], [1.9767217399787373, 0.56366188553849472, -2.4759659981403725, 
-0.57675651539819661], [-2.3169645738968283, 1.2766938617838406, 4.2235507133142391, -1.8551394597968351]], 
[[-4.7213055834195528, 4.5081688737256265, 2.9347524827688005, 0.84567000788663726], [4.9663286321498799, -2.4877697764151128, 
3.1377121807484567, -3.4121462498955077], [-0.99483360775740248, -1.9631730125917768, 0.015480068819933024, 
-3.8237441774442193]]]]))
      res=arg0+arg1
      ref=Data(numpy.array([[[[4.0651289912922941, 1.8513674975352643, 2.6347758396830177, 5.0997140860599313], 
[2.6030853684166759, -2.4908499923035228, 0.68155112082981173, -4.3865945738644543], [0.51108124512631559, 4.6767412663883547, 
-3.903626328409981, -2.5815182837951003]], [[-1.4813642372610376, -0.13764054852049412, 1.9170764555200721, 1.209837692053795], 
[-2.2527497654601052, -3.8043302323779011, -3.0903610001973063, -0.5348773978017709], [-3.6222733240574359, 
-4.5168455338939957, -2.7767233800349782, -3.1906754037816358]]], [[[0.79936553146744416, 1.5719743500613079, 
1.7697742029164827, -4.2450321121143162], [-2.5169345298060368, -3.2114360338877042, -3.7757351723501387, -1.2587762855847036], 
[0.46016100911348268, -1.0423623874996037, -3.1038913447607701, -3.6201946459253289]], [[-2.5755332492641929, 
-2.9452457882014165, 2.0544285418153345, -0.8531690153177891], [2.7267049954231908, 4.9368261919202059, -2.6451596214270525, 
4.8209044756261488], [-2.7119544855905149, 0.66087072064861019, -3.9007271541229729, -4.5810051763136759]]], 
[[[1.1609318767854884, 0.51125448148280661, 1.0809015257441184, 0.49793994310810508], [1.45863778974386, 3.0020843046010652, 
3.6645753658833886, 2.4741428812068929], [4.5253981791292439, -2.1852187575389386, 0.040389177179651625, -2.4151970505540969]], 
[[-0.094022803454229198, -2.995601948913535, 1.8690133011472527, 3.1115645161337087], [3.5619578089390878, -3.8321886902102875, 
-3.3134242816224164, -1.3988067527305299], [-3.8120163357059305, 1.1571433255693107, -1.8855704542950029, 
-4.2775548684035583]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[3.4355771487727953, -4.3980880791963788, -2.8168184392899991, -0.92456191526702414], 
[1.2638664980381122, 4.727997077056795, -1.5328453808665339, -4.475403121386619], [-0.51981349277394528, 1.9549016588961559, 
3.5722264162263251, 2.0111151217536811]], [[4.6250880544727391, -0.23013776436252087, -3.5559195326826538, 1.8708770188576382], 
[-2.8819077006458773, 4.0420894680253756, 0.79049332902652836, -4.6178978300406355], [3.5987943700616825, -3.3247204206313858, 
-4.5235228073006422, -3.7300291011485092]]], [[[-0.44621699576056884, -0.71047732038257561, 3.8167948573007529, 
-4.6333798173549567], [-0.75135195473988325, 4.3037699827080012, 1.6875660142362001, 3.0520499336434268], 
[-0.92562869690728711, -2.8583795220366266, 4.0174884331859175, -1.7084454885120097]], [[0.059902926249080224, 
-4.3321590408417991, 5.066289104996752, 0.60732013758305481], [-4.4059022274168962, -2.219806673037759, 3.6156574001750901, 
-2.3883211956762134], [-0.97355066231100373, 4.6711312303856118, 4.4335969609704868, 1.7538843904592456]]], 
[[[-0.9756743483778525, 3.0381920755826561, -3.8502899835155349, 1.2493746977201079], [2.235558960879704, 0.82249910643946134, 
-2.2171287772394059, -0.31791929449723], [-2.0581273529958617, 1.5355310826848072, 4.4823879342152058, -1.5963022388958685]], 
[[-4.4624683625185861, 4.7670060946265931, 3.1935897036697671, 1.1045072287876039], [5.2251658530508465, -2.2289325555141462, 
3.3965494016494233, -3.1533090289945411], [-0.73599638685643587, -1.7043357916908102, 0.27431728972089964, 
-3.5649069565432527]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_constData_rank0_taggedData_rank0(self):
      arg0=Data(-4.66455045755,self.functionspace)
      arg1=Data(-2.99001630489,self.functionspace)
      arg1.setTaggedValue(1,1.71689552484)
      res=arg0+arg1
      ref=Data(-7.65456676244,self.functionspace)
      ref.setTaggedValue(1,-2.94765493271)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_constData_rank0_taggedData_rank1(self):
      arg0=Data(0.370498134707,self.functionspace)
      arg1=Data(numpy.array([-2.6887132164569882, 1.5445437459391336]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([-3.4873445431549221, -0.71518467757424187]))
      res=arg0+arg1
      ref=Data(numpy.array([-2.3182150817500586, 1.9150418806460632]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-3.1168464084479925, -0.34468654286731226]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_constData_rank0_taggedData_rank2(self):
      arg0=Data(4.19816380923,self.functionspace)
      arg1=Data(numpy.array([[-4.7192788556165777, 0.96664005764470229, -3.5536084501834408, -4.0765460640065072, 
-1.661066134307092], [-1.8698305076456467, 1.3585630353673768, -2.9520256153421887, -4.0115384815141901, 4.1648807596676622], 
[0.52651496482039839, 4.5335182579006243, 1.5182681645431, -2.0386298757410359, 1.3497292187808991], [3.3327260230683571, 
-0.49979354291428546, 2.1074572526054176, -2.3550325002712693, 2.273541867139822]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[2.0517873872737935, 0.38787431151255269, 3.5863158456115105, 2.3662852559311744, 
4.0659321476022274], [-3.1739511723873095, -1.2814654983823082, 1.0017851807449105, -3.5533612778457471, -2.2221538754612635], 
[0.84394690277536544, -3.1120306326191924, 0.27412555780823489, -2.035372239239428, -0.66379142365820076], [3.9021924769148715, 
3.0731542562026597, -1.1750835017113772, -3.8392491786372251, -1.8483038189693612]]))
      res=arg0+arg1
      ref=Data(numpy.array([[-0.52111504638209638, 5.1648038668791836, 0.64455535905104044, 0.12161774522797408, 
2.5370976749273892], [2.3283333015888346, 5.5567268446018581, 1.2461381938922926, 0.18662532772029117, 8.3630445689021435], 
[4.7246787740548797, 8.7316820671351056, 5.7164319737775813, 2.1595339334934454, 5.5478930280153804], [7.5308898323028384, 
3.6983702663201958, 6.3056210618398989, 1.843131308963212, 6.4717056763743033]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[6.2499511965082748, 4.586038120747034, 7.7844796548459918, 6.5644490651656557, 
8.2640959568367087], [1.0242126368471718, 2.9166983108521731, 5.1999489899793918, 0.64480253138873422, 1.9760099337732178], 
[5.0421107120098467, 1.0861331766152889, 4.4722893670427162, 2.1627915699950533, 3.5343723855762805], [8.1003562861493528, 
7.271318065437141, 3.0230803075231041, 0.35891463059725615, 2.34985999026512]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_constData_rank0_taggedData_rank3(self):
      arg0=Data(3.89946370173,self.functionspace)
      arg1=Data(numpy.array([[[-2.958761930822206, 3.1298083647148758], [1.0740766505503316, -0.56319010720496898]], 
[[-1.7943140652533938, 3.690403381090702], [0.36937042492057159, 3.2658468930198374]], [[1.8835789033218173, 
-1.4148302296368787], [-3.5673817752537063, -2.2485863527891392]], [[0.16128627738663681, 3.0703162517774825], 
[3.7378380068614732, 3.9111432927270524]], [[-2.1021476970927955, 3.0961226816017913], [0.68225570534855073, 
3.1886903197536505]], [[-3.2791062855901467, 1.0997870451532412], [-3.4354171329994623, 
-4.2682463123274079]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[-2.0234674745266847, -3.7749655132841555], [-2.1362659699809128, 
2.474175793074985]], [[2.5297943416808, -2.1243559170453974], [-3.4313241405664572, 0.34198337719133054]], 
[[-3.9325455447252953, 4.7074989384395032], [3.9514592903761727, 0.92749369879626808]], [[2.3893484525653763, 
-2.9348922671770907], [3.4801665184590522, 1.4061197053956462]], [[3.2979060909501019, -3.4211971590117596], 
[-2.634829438986559, -2.6073070108817142]], [[-2.1869149767885343, 4.8263853115242767], [0.23104772756879122, 
2.7034659990243881]]]))
      res=arg0+arg1
      ref=Data(numpy.array([[[0.94070177090306473, 7.0292720664401465], [4.9735403522756023, 3.3362735945203017]], 
[[2.1051496364718769, 7.5898670828159727], [4.2688341266458423, 7.1653105947451081]], [[5.783042605047088, 2.484633472088392], 
[0.33208192647156443, 1.6508773489361315]], [[4.0607499791119075, 6.9697799535027531], [7.6373017085867438, 
7.8106069944523231]], [[1.7973160046324752, 6.995586383327062], [4.5817194070738214, 7.0881540214789212]], 
[[0.62035741613512396, 4.9992507468785119], [0.46404656872580841, -0.36878261060213724]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[1.8759962271985859, 0.12449818844111515], [1.7631977317443579, 6.3736394948002557]], 
[[6.4292580434060707, 1.7751077846798733], [0.4681395611588135, 4.2414470789166012]], [[-0.033081843000024591, 
8.6069626401647739], [7.8509229921014434, 4.8269574005215388]], [[6.288812154290647, 0.96457143454817995], [7.3796302201843229, 
5.3055834071209169]], [[7.1973697926753726, 0.4782665427135111], [1.2646342627387117, 1.2921566908435564]], 
[[1.7125487249367364, 8.7258490132495474], [4.1305114292940619, 6.6029297007496588]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_constData_rank0_taggedData_rank4(self):
      arg0=Data(4.13858568877,self.functionspace)
      arg1=Data(numpy.array([[[[0.13175013949509395, 1.3587679164977704, 1.230138204659478, 1.6198580303286221], 
[1.5153336575053098, -4.2526602333060337, -2.3168164343901312, 1.3904766393917001], [-4.7958861831605004, 1.2701544083884784, 
-1.6823608322632033, -1.7201124691387335]], [[4.6468317780236443, 4.4127955763926092, 0.31673493242051265, 
-2.8905384569080228], [-2.7913299715813524, -0.3374615600001647, -0.01446183703812487, 1.2161604506861723], 
[-0.91940202299142371, -1.9567662570206745, 0.031137893828368846, -2.5209323098234182]]], [[[-0.031722186835536625, 
-1.1948269447712869, 3.9794746474538361, 0.98566305681893951], [2.2904104445616404, -4.0514518037958602, -4.7984963012094486, 
3.2249867504024508], [1.0109233879894894, 2.2623268701952393, -1.4339465114083092, 2.0614584017864592]], [[4.3344566195583063, 
1.6406524222057639, 1.5922292351054921, 3.3529595245331709], [-0.15022125891499183, -3.6179617746160773, 4.2196942009020848, 
1.4409116931856261], [4.4422587441753301, 2.0033045455934273, 3.7037373472747142, -2.504798746956578]]], 
[[[-3.3600706973199337, 1.6542963995949487, -3.3948661029138405, -0.97633586924857152], [3.2449158099150548, 
-1.0094062333732468, -1.9883401045866114, -2.8575077660346269], [3.8328322929814416, -0.36894673930713928, -2.1777279139379679, 
3.9748750412071558]], [[0.71205519166902143, 2.7874466298425258, -4.3775332948678507, 2.7582637172786972], [3.0658466748756403, 
-3.7775671377240618, -4.3030172803829023, -4.1024191753816339], [3.4660156077327304, -1.5408899094499242, -0.45273239596408921, 
4.1942719729845308]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[1.7078293929986188, 1.597184054166445, 0.53172139995994705, 0.37598767762412866], 
[-4.7153868472501923, -4.836115964305848, 3.3382192795335737, 0.32916380702422288], [-1.042832518792137, -2.5933137193252485, 
-4.9571485633186949, 2.38472674259289]], [[-2.5277161336880551, 2.3036719277395008, 1.8451909915911973, -1.7104640528407842], 
[4.789616256307923, 4.615854384167438, 1.4240273080754857, -1.5109891694225466], [3.5444680569850604, 3.2153528591575338, 
-1.8778645807771688, -3.4211520168783571]]], [[[2.0279600181836734, 1.3913400074142395, 4.7266972207219258, 
-0.041751739987586411], [4.4694412096063054, -0.20301014054466915, -1.4400390824000087, -1.3937378294351612], 
[-4.2164692430070074, 0.32301335083063698, -0.38037743922377842, 3.394970950833363]], [[-0.42098850226019113, 
3.4618707762478937, -3.2891591601163315, -4.6415242845849694], [3.7322526190152701, -0.37586050159968831, 1.0289109951324695, 
0.37112092161696086], [-4.6466108515169324, -3.4039550614647771, 0.38514840891958535, -4.1255144542454589]]], 
[[[4.4409907142382679, -4.0885450651543387, 2.5510413569729584, 2.0454434817263518], [4.4376165821152895, -2.6852229033020136, 
0.21782034539436257, 2.4970368184639957], [-3.0162244468929513, -2.38809874101951, 3.8343147304687317, 0.52050559575242428]], 
[[2.5529377889837477, 0.38395922477480493, -3.9715068749558267, 2.6328023561731193], [0.60295943010967434, -1.3993044422742642, 
4.7889894291480886, 0.3603777140784814], [-2.6294316083078542, 2.4753104938309303, 0.45790305184353119, 2.1547344969887909]]]]))
      res=arg0+arg1
      ref=Data(numpy.array([[[[4.2703358282612038, 5.4973536052638803, 5.3687238934255879, 5.758443719094732], 
[5.6539193462714197, -0.11407454453992383, 1.8217692543759787, 5.52906232815781], [-0.65730049439439053, 5.4087400971545883, 
2.4562248565029066, 2.4184732196273764]], [[8.7854174667897542, 8.5513812651587191, 4.4553206211866225, 1.2480472318580871], 
[1.3472557171847575, 3.8011241287659452, 4.124123851727985, 5.3547461394522822], [3.2191836657746862, 2.1818194317454354, 
4.1697235825944787, 1.6176533789426917]]], [[[4.1068635019305733, 2.943758743994823, 8.1180603362199459, 5.1242487455850494], 
[6.4289961333277503, 0.087133884970249653, -0.65991061244333871, 7.3635724391685606], [5.1495090767555993, 6.4009125589613491, 
2.7046391773578007, 6.2000440905525691]], [[8.4730423083244162, 5.7792381109718738, 5.730814923871602, 7.4915452132992808], 
[3.9883644298511181, 0.52062391415003262, 8.3582798896681947, 5.5794973819517359], [8.5808444329414399, 6.1418902343595372, 
7.842323036040824, 1.6337869418095319]]], [[[0.7785149914461762, 5.7928820883610586, 0.74371958585226938, 3.1622498195175384], 
[7.3835014986811647, 3.1291794553928631, 2.1502455841794985, 1.281077922731483], [7.9714179817475515, 3.7696389494589706, 
1.9608577748281419, 8.1134607299732657]], [[4.8506408804351313, 6.9260323186086357, -0.23894760610174082, 6.8968494060448071], 
[7.2044323636417502, 0.36101855104204805, -0.16443159161679244, 0.036166513384475962], [7.6046012964988403, 2.5976957793161857, 
3.6858532928020207, 8.3328576617506407]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[5.8464150817647287, 5.7357697429325549, 4.6703070887260569, 4.5145733663902385], 
[-0.57680115848408242, -0.69753027553973812, 7.4768049682996836, 4.4677494957903328], [3.0957531699739729, 1.5452719694408614, 
-0.81856287455258503, 6.5233124313589999]], [[1.6108695550780547, 6.4422576165056107, 5.9837766803573071, 2.4281216359253257], 
[8.9282019450740329, 8.7544400729335479, 5.5626129968415956, 2.6275965193435633], [7.6830537457511703, 7.3539385479236437, 
2.2607211079889411, 0.71743367188775276]]], [[[6.1665457069497833, 5.5299256961803493, 8.8652829094880357, 4.0968339487785235], 
[8.6080268983724153, 3.9355755482214407, 2.6985466063661012, 2.7448478593309487], [-0.077883554240897546, 4.4615990395967469, 
3.7582082495423315, 7.5335566395994729]], [[3.7175971865059187, 7.6004564650140036, 0.84942652864977841, -0.50293859581885947], 
[7.8708383077813799, 3.7627251871664216, 5.1674966838985794, 4.5097066103830707], [-0.50802516275082255, 0.73463062730133277, 
4.5237340976856952, 0.013071234520650954]]], [[[8.5795764030043777, 0.050040623611771196, 6.6896270457390683, 
6.1840291704924617], [8.5762022708813994, 1.4533627854640963, 4.3564060341604725, 6.6356225072301056], [1.1223612418731586, 
1.7504869477465999, 7.9729004192348416, 4.6590912845185342]], [[6.6915234777498576, 4.5225449135409148, 0.16707881381028322, 
6.7713880449392292], [4.7415451188757842, 2.7392812464918457, 8.9275751179141984, 4.4989634028445913], [1.5091540804582557, 
6.6138961825970402, 4.5964887406096411, 6.2933201857549008]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_constData_rank1_taggedData_rank0(self):
      arg0=Data(numpy.array([4.5897569702707663, 3.4489828945022865]),self.functionspace)
      arg1=Data(0.812494849561,self.functionspace)
      arg1.setTaggedValue(1,-0.798066999908)
      res=arg0+arg1
      ref=Data(numpy.array([5.4022518198315126, 4.2614777440630327]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([3.7916899703627909, 2.650915894594311]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_constData_rank1_taggedData_rank1(self):
      arg0=Data(numpy.array([4.1004534466760507, -4.3530930416109834]),self.functionspace)
      arg1=Data(numpy.array([1.197002325888791, -3.123782523761276]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([-3.6778967700359919, 1.2367952159033369]))
      res=arg0+arg1
      ref=Data(numpy.array([5.2974557725648417, -7.4768755653722589]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([0.4225566766400588, -3.1162978257076466]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_constData_rank2_taggedData_rank0(self):
      arg0=Data(numpy.array([[-1.3415049980194151, 1.3459186798218408, 1.9114294317354288, 2.9179835052428356, 
-2.3044429511392064], [-1.9007005643963581, -4.3338357233493765, 0.94077516828007823, 4.0387790864748414, -1.2725002850564615], 
[4.243575031818219, 0.64089360532133988, -1.8118570052736027, -4.1902989094547962, -2.957929628039182], [4.3122818225512596, 
-1.947482103007653, -1.9434128036289944, -2.7112973647894343, 3.3719312192315645]]),self.functionspace)
      arg1=Data(3.38131858631,self.functionspace)
      arg1.setTaggedValue(1,-2.24010374318)
      res=arg0+arg1
      ref=Data(numpy.array([[2.0398135882931143, 4.7272372661343702, 5.2927480180479582, 6.299302091555365, 
1.0768756351733231], [1.4806180219161713, -0.95251713703684704, 4.3220937545926077, 7.4200976727873709, 2.108818301256068], 
[7.6248936181307485, 4.0222121916338693, 1.5694615810389267, -0.80898032314226676, 0.42338895827334744], [7.693600408863789, 
1.4338364833048765, 1.4379057826835351, 0.67002122152309518, 6.7532498055440939]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-3.581608741203584, -0.89418506336232806, -0.32867431144874004, 0.67787976205866673, 
-4.5445466943233752], [-4.1408043075805274, -6.5739394665335453, -1.2993285749040906, 1.7986753432906726, -3.5126040282406303], 
[2.0034712886340502, -1.599210137862829, -4.0519607484577715, -6.430402652638965, -5.1980333712233513], [2.0721780793670908, 
-4.1875858461918218, -4.1835165468131628, -4.9514011079736031, 1.1318274760473956]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_constData_rank2_taggedData_rank2(self):
      arg0=Data(numpy.array([[-2.6226681875421876, -0.43563964563251734, -1.4626141982483021, 1.0662819329818385, 
-0.69420446751041176], [-1.2707395630813445, 1.3375857552296422, -4.5642260803519559, -1.1361520399586924, 
-0.68323132594976776], [-3.0170524494571516, -4.9703645483246675, -2.4863945922654676, 4.9784873698674375, 1.8479915169807821], 
[1.5490113944965085, -1.0077428228109255, 1.5359630073957211, -4.7057403097533301, 4.0675177351019869]]),self.functionspace)
      arg1=Data(numpy.array([[-0.040763387896243231, 0.60676905546922022, -3.3009918603427013, 0.3984414318528362, 
1.4046712983461234], [4.612933819098787, 4.0243208678834339, 2.8784202902614089, 1.4754979228393053, 1.8208651871692805], 
[-2.9887385211383197, 4.0131064195259167, -2.9346520178259738, 2.5683381317973151, 2.9637756504799819], [1.6083685448216078, 
-1.7585502037053713, -1.47587346390329, 2.056837208721614, -4.2067142370058583]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[4.2084992139808168, 4.1492653597313272, 0.41940775480631309, -1.3432384465213651, 
3.7094693015752451], [0.17022165623481023, 4.9532436500597985, -1.0113318446498187, 4.2710146112490364, -4.0530763504693477], 
[1.8658547298935266, 0.19133091000646729, -4.1563396395827423, 0.62695789643655431, 3.543936176447259], [1.0428723192529255, 
4.2374508021339281, -3.0218647799829155, -4.433868685270081, 4.4695313555926024]]))
      res=arg0+arg1
      ref=Data(numpy.array([[-2.6634315754384308, 0.17112940983670288, -4.7636060585910034, 1.4647233648346747, 
0.7104668308357116], [3.3421942560174425, 5.3619066231130761, -1.685805790090547, 0.33934588288061285, 1.1376338612195127], 
[-6.0057909705954717, -0.95725812879875072, -5.421046610091441, 7.5468255016647525, 4.811767167460764], [3.1573799393181163, 
-2.7662930265162968, 0.060089543492431119, -2.6489031010317161, -0.13919650190387145]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[1.5858310264386293, 3.7136257140988098, -1.043206443441989, -0.27695651353952666, 
3.0152648340648334], [-1.1005179068465343, 6.2908294052894407, -5.5755579250017746, 3.134862571290344, -4.7363076764191154], 
[-1.1511977195636249, -4.7790336383182002, -6.6427342318482099, 5.6054452663039918, 5.3919276934280411], [2.5918837137494339, 
3.2297079793230026, -1.4859017725871944, -9.1396089950234121, 8.5370490906945893]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_constData_rank3_taggedData_rank0(self):
      arg0=Data(numpy.array([[[2.0861950273295804, 2.4920761560019047], [-4.0767262373503979, -1.7275341661236698]], 
[[4.6406069429505195, 4.0345928257798782], [0.37803900859143447, 2.4445371923229517]], [[1.85363770864444, 3.6585915234726212], 
[2.0214578834221006, 0.56085179178200306]], [[2.402010491646239, 4.6824728700135161], [0.6414001733226975, 
0.94107549517639644]], [[2.3300385491886431, 4.4807079902307159], [-0.92067660734824752, 3.0509292574928253]], 
[[1.2602889332645431, -1.9292487970408709], [0.086280004211073624, -1.510551626961151]]]),self.functionspace)
      arg1=Data(-0.0456895613642,self.functionspace)
      arg1.setTaggedValue(1,-4.19507957525)
      res=arg0+arg1
      ref=Data(numpy.array([[[2.040505465965424, 2.4463865946377483], [-4.1224157987145542, -1.7732237274878262]], 
[[4.5949173815863631, 3.9889032644157218], [0.33234944722727811, 2.3988476309587954]], [[1.8079481472802836, 
3.6129019621084648], [1.9757683220579443, 0.5151622304178467]], [[2.3563209302820827, 4.6367833086493597], 
[0.59571061195854114, 0.89538593381224008]], [[2.2843489878244867, 4.4350184288665595], [-0.96636616871240388, 
3.0052396961286689]], [[1.2145993719003867, -1.9749383584050273], [0.040590442846917263, 
-1.5562411883253073]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-2.1088845479219822, -1.7030034192496579], [-8.2718058126019613, 
-5.9226137413752324]], [[0.44552736769895684, -0.1604867494716844], [-3.8170405666601281, -1.7505423829286109]], 
[[-2.3414418666071226, -0.53648805177894143], [-2.173621691829462, -3.6342277834695595]], [[-1.7930690836053236, 
0.48739329476195348], [-3.5536794019288651, -3.2540040800751662]], [[-1.8650410260629195, 0.28562841497915326], 
[-5.1157561825998101, -1.1441503177587373]], [[-2.9347906419870196, -6.1243283722924335], [-4.108799571040489, 
-5.7056312022127136]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_constData_rank3_taggedData_rank3(self):
      arg0=Data(numpy.array([[[0.12269628182933001, 1.4672076166497297], [-1.7618606919578217, -0.41822274378038404]], 
[[-3.4777278267882261, 0.91150063442493234], [-3.2215653702862177, -4.7251769553640743]], [[-3.6955005566118668, 
-4.0386807920581376], [0.20974179785768499, 4.971379194453883]], [[-4.6416039854065438, -2.4174671355821378], 
[-0.93956661100576255, -4.5631114286217205]], [[-2.4447858378665765, -3.8232081969915432], [0.73666084872135418, 
-1.0254596806300853]], [[-2.257416342898372, -2.4415592322477275], [-3.9887385162301858, 
0.4695282522578168]]]),self.functionspace)
      arg1=Data(numpy.array([[[-4.5676240214260098, 0.41306837628522963], [4.9465358871512777, 2.2848713951104838]], 
[[4.362008173640664, 3.9502909364101217], [2.071996380966926, 3.7834488332881868]], [[-0.49584216533182879, 
-3.4801056681326905], [4.9917325907476382, 1.4377979885864516]], [[2.886717011735934, -2.6277020978762042], 
[4.6176020186796425, 4.7990380634049767]], [[-0.52564559772442099, 4.7895678381879687], [1.5708429802060175, 
-3.0844085844104274]], [[-1.2250025565880893, 4.6458577871452373], [-4.4222951788247409, 
4.0433895321815427]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[-0.1370599544392892, -2.8015059749984528], [-1.9961054277296473, 
-0.36073771651563291]], [[1.3182553792598579, -4.0991476254507635], [-0.44276061226265018, 1.6680349385432987]], 
[[-3.4001027933348835, -4.8109813236985541], [-2.0495682790514227, 1.8167133342381812]], [[-3.7963346870977945, 
-4.5535645028017635], [-1.1522389797685193, 1.3511939157749344]], [[-4.8040131382947049, 0.90793035526919397], 
[1.484793978312382, -1.5421914315510179]], [[1.3343050159588525, 2.4655013863417548], [-0.32507168642112561, 
4.3599790448251685]]]))
      res=arg0+arg1
      ref=Data(numpy.array([[[-4.4449277395966797, 1.8802759929349593], [3.184675195193456, 1.8666486513300997]], 
[[0.88428034685243784, 4.8617915708350541], [-1.1495689893192917, -0.94172812207588752]], [[-4.1913427219436956, 
-7.5187864601908281], [5.2014743886053232, 6.4091771830403346]], [[-1.7548869736706099, -5.045169233458342], 
[3.6780354076738799, 0.23592663478325626]], [[-2.9704314355909975, 0.96635964119642548], [2.3075038289273717, 
-4.1098682650405127]], [[-3.4824188994864613, 2.2042985548975098], [-8.4110336950549272, 
4.5129177844393595]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-0.014363672609959188, -1.3342983583487231], [-3.757966119687469, 
-0.77896046029601695]], [[-2.1594724475283682, -3.1876469910258312], [-3.6643259825488679, -3.0571420168207757]], 
[[-7.0956033499467503, -8.8496621157566917], [-1.8398264811937377, 6.7880925286920641]], [[-8.4379386725043375, 
-6.9710316383839013], [-2.0918055907742819, -3.2119175128467861]], [[-7.2487989761612814, -2.9152778417223493], 
[2.2214548270337362, -2.5676511121811032]], [[-0.92311132693951947, 0.023942154094027224], [-4.313810202651311, 
4.8295072970829853]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_constData_rank4_taggedData_rank0(self):
      arg0=Data(numpy.array([[[[-2.1127878043948121, -2.6734038420995878, -3.7174721921481515, -2.8921743181221125], 
[0.2764377633408408, 3.9296684147946799, -4.9171677374972944, -4.9642653378267347], [-0.61947409364464079, -4.015974028229059, 
-0.18805511679418441, 1.5629814684169734]], [[-4.0866231608688022, 3.2830805381014763, -4.2608142895301615, 
0.15599594849717491], [1.1040385772304564, -1.5708094985664434, -4.9568379032803538, 1.241738387463192], [1.3931769799891995, 
-2.5248595019765432, 2.8757000225849128, -4.3771668987515238]]], [[[-1.2735518422958148, -4.1105568099668019, 
0.48891138673857082, 1.4980039331184702], [0.35357088368984879, 2.5316174846688497, -4.1543988785548382, -4.1135564535496218], 
[-3.9584256991852951, -2.1520765455378479, 2.3736171509491202, -4.6215845057314446]], [[-2.0397394988533204, 
2.2745130371463276, 2.8688375760074738, -4.2614754860809034], [4.0992062066155928, -3.4288780684757336, 4.1516896671562513, 
0.75074434486774599], [-3.193022825807692, -0.53192123868369112, 3.0812135258882254, 0.39050867400707112]]], 
[[[-4.2892765756816296, -4.9695959583850904, 3.9513254018501112, -3.3406585194566842], [4.5700536659667463, 4.6852713683538294, 
-0.36959280283832463, -0.9385962664742884], [-4.9454116885258355, 0.89580928044739849, 3.0409142595966561, 
2.2367353588478478]], [[-4.0564078271004345, -4.0254892597622485, -4.8815665092731431, 4.0704491239176814], 
[-3.2284258591070278, -1.8775365569400213, 3.4160847683724587, 0.86462311694064553], [-3.9639979460065278, 0.33482686945185947, 
-4.5669429197924236, 2.3298939078133687]]]]),self.functionspace)
      arg1=Data(-0.392470993711,self.functionspace)
      arg1.setTaggedValue(1,-4.1075693295)
      res=arg0+arg1
      ref=Data(numpy.array([[[[-2.5052587981061238, -3.0658748358108996, -4.1099431858594633, -3.2846453118334242], 
[-0.11603323037047097, 3.5371974210833681, -5.3096387312086062, -5.3567363315380465], [-1.0119450873559526, 
-4.4084450219403708, -0.58052611050549618, 1.1705104747056616]], [[-4.479094154580114, 2.8906095443901645, -4.6532852832414733, 
-0.23647504521413687], [0.71156758351914462, -1.9632804922777551, -5.3493088969916656, 0.84926739375188021], 
[1.0007059862778878, -2.917330495687855, 2.483229028873601, -4.7696378924628355]]], [[[-1.6660228360071265, 
-4.5030278036781137, 0.096440393027259042, 1.1055329394071585], [-0.038900110021462986, 2.1391464909575379, -4.54686987226615, 
-4.5060274472609336], [-4.3508966928966064, -2.5445475392491597, 1.9811461572378084, -5.0140554994427564]], 
[[-2.4322104925646322, 1.8820420434350158, 2.476366582296162, -4.6539464797922152], [3.706735212904281, -3.8213490621870454, 
3.7592186734449395, 0.35827335115643422], [-3.5854938195190038, -0.9243922323950029, 2.6887425321769136, 
-0.0019623197042406559]]], [[[-4.6817475693929413, -5.3620669520964022, 3.5588544081387994, -3.733129513167996], 
[4.1775826722554346, 4.2928003746425176, -0.76206379654963641, -1.3310672601856002], [-5.3378826822371472, 0.50333828673608672, 
2.6484432658853443, 1.844264365136536]], [[-4.4488788208117462, -4.4179602534735603, -5.2740375029844548, 3.6779781302063697], 
[-3.6208968528183396, -2.2700075506513331, 3.0236137746611469, 0.47215212322933375], [-4.3564689397178391, 
-0.057644124259452312, -4.9594139135037354, 1.9374229141020569]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-6.2203571338967052, -6.7809731716014809, -7.8250415216500446, -6.9997436476240056], 
[-3.8311315661610523, -0.17790091470721325, -9.0247370669991867, -9.071834667328627], [-4.7270434231465339, 
-8.1235433577309522, -4.2956244462960775, -2.5445878610849197]], [[-8.1941924903706962, -0.82448879140041686, 
-8.3683836190320555, -3.9515733810047182], [-3.0035307522714367, -5.678378828068336, -9.0644072327822478, -2.8658309420387011], 
[-2.7143923495126936, -6.6324288314784363, -1.2318693069169804, -8.4847362282534178]]], [[[-5.3811211717977079, 
-8.2181261394686942, -3.6186579427633223, -2.6095653963834229], [-3.7539984458120443, -1.5759518448330434, -8.2619682080567323, 
-8.2211257830515159], [-8.0659950286871887, -6.259645875039741, -1.7339521785527729, -8.7291538352333369]], 
[[-6.1473088283552135, -1.8330562923555656, -1.2387317534944193, -8.3690448155827966], [-0.008363122886300367, 
-7.5364473979776267, 0.044120337654358188, -3.3568249846341471], [-7.3005921553095856, -4.6394905681855843, 
-1.0263558036136677, -3.717060655494822]]], [[[-8.3968459051835218, -9.0771652878869844, -0.15624392765178197, 
-7.4482278489585774], [0.46248433646485321, 0.57770203885193627, -4.4771621323402178, -5.0461655959761815], 
[-9.0529810180277295, -3.2117600490544946, -1.0666550699052371, -1.8708339706540453]], [[-8.1639771566023285, 
-8.1330585892641416, -8.9891358387750362, -0.037120205584211696], [-7.335995188608921, -5.9851058864419144, 
-0.69148456112943446, -3.2429462125612476], [-8.0715672755084213, -3.7727424600500337, -8.6745122492943167, 
-1.7776754216885244]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_constData_rank4_taggedData_rank4(self):
      arg0=Data(numpy.array([[[[-3.8003570791748298, 4.8039102010737356, -0.9012319374709632, -2.714251428030491], 
[-0.13737907408573857, -2.5873579113483403, -0.056424615348640295, 2.5619294488986437], [-1.2194985042398065, 
3.6964005336565648, 0.01956618682329303, -3.8152983947862182]], [[-4.5942303653681336, 1.2221344064392001, -3.1401340907797506, 
3.0332806597492041], [-0.30067217703961013, -1.8502913620814132, 4.6304390527587529, -2.9091770278724027], [-2.915704726643499, 
-0.58894436293405761, -1.6459855274088921, 4.2171038502583507]]], [[[-1.661264209710259, -3.5924830185239909, 
-3.926714691053216, 4.6488313215887835], [0.83917305781474383, -1.747805522640109, -2.3037471044809568, -4.723628872515131], 
[-1.3382488286504115, -4.476446065957167, -0.99674404736242117, -4.3661969295354117]], [[1.0598595170076077, 
-0.19226332818609659, 1.2647338833662918, 2.6316764694963517], [3.8022221337176685, 3.3216545470545302, 1.6558043870946477, 
-3.192283503714922], [4.6471912279344192, -2.2585314149952729, -3.3396046798740664, 2.9535871562084974]]], 
[[[2.4927259412055687, -1.7682078466809212, -3.8436595638128401, 1.8856569517823241], [-3.5778072979055366, 
-1.4520098978531992, -1.8690036465447903, -2.1824703474806597], [-2.9494885498413606, -4.8915793099194635, -3.4081990339500292, 
-0.8325694914483126]], [[3.7007217572430982, -0.85098659594840331, 3.5872717949533595, 0.5736466573049519], 
[-0.26908808722230049, -3.7092505231319697, -2.7143082150073807, -2.5313662195555042], [-2.4795935752348308, 
2.9266176041709162, 4.384995828125648, -0.63102761878910663]]]]),self.functionspace)
      arg1=Data(numpy.array([[[[-3.2508426969032245, -1.0024100704270476, 3.4982723131945033, -1.9964708455849953], 
[-0.17088222487315718, -4.1965255167604374, -3.7888777373790661, -2.4246951783662607], [1.1505367855332729, 
0.28395927321886116, -1.7554266087733303, 0.94491437841475978]], [[-0.89427035290860957, 1.8691557996484756, 
-1.9158166741239491, -1.5451752659177087], [-4.6771609087788333, 3.4028194286871418, -3.5294614439386374, 4.0704745267453557], 
[-1.0631533489506384, -4.9816737586177524, -2.4923293159836248, -3.7317207478568291]]], [[[-0.37541928486144993, 
-3.9155448396414849, -3.4686214797886672, 2.5161469033474919], [2.934519412599137, 2.4688331676196551, 0.37822121190445301, 
4.6859180214754375], [0.78377840608527816, 2.7151033454639864, -4.6497212398777554, -2.3740861584197459]], 
[[-3.0821070954331709, 1.0016455130728072, 4.8011875842658664, 0.64487679809045062], [-3.0532069302855316, 3.3985897915071916, 
-2.7489875284261869, -1.0364823343231322], [-0.49636722863105032, 0.29453601459294632, -3.8802708526396454, 
0.77885118565126987]]], [[[-4.7626905454198702, 0.90176813974784054, 4.9948206097093522, -3.1295052840376449], 
[1.2834126334200455, 3.3715963540365195, 2.691170782305595, 1.648946257595143], [-2.4182052053755179, 3.2858262338086952, 
-4.7506720266598901, -1.1427747305253986]], [[2.3960188186004681, -1.9529728608578023, 3.5793004760451623, 3.5066349819851972], 
[0.015787978368537736, 4.9429338610678588, -4.6168224651124508, 3.0778272166624312], [4.8412694957514155, 0.49646030889916126, 
4.8390734364274763, 3.7965138490932322]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[-4.0512216409646857, -2.2488251354790876, 2.5741189624243601, -3.1464509962959553], 
[3.5415207508726958, -0.11521243824542182, -4.4855498595431964, -0.12427356351934904], [1.1501777533571165, 
-1.3551735389474553, -3.9489356911688231, 0.29907845937935384]], [[4.670218220299132, -3.5990452055623399, 
-0.40586052741102385, 1.7019941790632975], [-3.7963057399912046, 1.3670161485907508, 0.037023966175839362, 4.6917488690819038], 
[1.1524780921030517, 2.8803462050022404, 3.2171956094985568, 4.4310334421540123]]], [[[-0.74645446908803592, 1.487833202764878, 
4.2525680945504511, 1.4866479997013213], [-3.105845513592703, -1.3728295712031069, -0.29708694386510448, -2.4105997731600115], 
[-1.841124729214505, -3.3249823745199869, -3.0105601297540776, 0.45738474091793258]], [[3.4778516956290044, 1.5583028940067232, 
-4.9202667144405607, 0.7768547421186609], [4.3208195532293594, -1.4519944496992023, -3.1798996962547554, -0.62587527866007164], 
[-0.74085414403452354, 0.7874909108666337, 2.2525577786747597, -2.23785743903401]]], [[[4.3433251772547781, 4.365892846063538, 
2.4671798191855299, 1.1895325637549146], [-0.52970986057913017, 4.2827660014035924, -3.8150353293719927, 4.709830625622887], 
[-0.75876286632995615, -0.22282821598760449, -2.8025089483451913, 0.50702160519610828]], [[-0.63931412488187611, 
3.0113958705998272, -3.8428191253982069, -0.44348303745008], [1.3044314495288791, 0.85661911039063199, 3.0504178786209266, 
0.98856020664162081], [1.8826398310117467, -1.0396561564326445, 2.0962423161913426, -1.0118098533838027]]]]))
      res=arg0+arg1
      ref=Data(numpy.array([[[[-7.0511997760780538, 3.801500130646688, 2.5970403757235401, -4.7107222736154863], 
[-0.30826129895889576, -6.7838834281087781, -3.8453023527277064, 0.13723427053238302], [-0.06896171870653367, 
3.980359806875426, -1.7358604219500373, -2.8703840163714585]], [[-5.4885007182767431, 3.0912902060876757, -5.0559507649036997, 
1.4881053938314954], [-4.9778330858184434, 1.5525280666057286, 1.1009776088201155, 1.161297498872953], [-3.9788580755941374, 
-5.57061812155181, -4.138314843392517, 0.4853831024015216]]], [[[-2.0366834945717089, -7.5080278581654758, -7.3953361708418832, 
7.1649782249362755], [3.7736924704138808, 0.72102764497954608, -1.9255258925765038, -0.037710851039693516], 
[-0.55447042256513335, -1.7613427204931806, -5.6464652872401766, -6.7402830879551576]], [[-2.0222475784255631, 
0.80938218488671065, 6.0659214676321582, 3.2765532675868023], [0.7490152034321369, 6.7202443385617219, -1.0931831413315392, 
-4.2287658380380542], [4.1508239993033689, -1.9639954004023266, -7.2198755325137114, 3.7324383418597673]]], 
[[[-2.2699646042143016, -0.8664397069330807, 1.151161045896512, -1.2438483322553209], [-2.2943946644854911, 1.9195864561833202, 
0.82216713576080469, -0.53352408988551669], [-5.3676937552168784, -1.6057530761107683, -8.1588710606099184, 
-1.9753442219737112]], [[6.0967405758435662, -2.8039594568062056, 7.1665722709985218, 4.0802816392901491], 
[-0.25330010885376275, 1.2336833379358891, -7.3311306801198315, 0.54646099710692697], [2.3616759205165847, 3.4230779130700775, 
9.2240692645531244, 3.1654862303041256]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-7.851578720139516, 2.555085065594648, 1.6728870249533969, -5.8607024243264458], 
[3.4041416767869572, -2.7025703495937621, -4.5419744748918367, 2.4376558853792947], [-0.069320750882690074, 2.3412269947091096, 
-3.9293695043455301, -3.5162199354068644]], [[0.075987854930998466, -2.3769107991231397, -3.5459946181907744, 
4.7352748388125017], [-4.0969779170308147, -0.48327521349066238, 4.6674630189345923, 1.7825718412095011], [-1.7632266345404473, 
2.2914018420681828, 1.5712100820896646, 8.648137292412363]]], [[[-2.4077186787982949, -2.1046498157591129, 0.32585340349723513, 
6.1354793212901049], [-2.2666724557779592, -3.1206350938432159, -2.6008340483460612, -7.134228645675142], [-3.1793735578649165, 
-7.8014284404771539, -4.0073041771164988, -3.9088121886174791]], [[4.5377112126366121, 1.3660395658206266, -3.655532831074269, 
3.4085312116150126], [8.1230416869470279, 1.8696600973553279, -1.5240953091601077, -3.8181587823749936], [3.9063370838998956, 
-1.4710405041286392, -1.0870469011993067, 0.71572971717448741]]], [[[6.8360511184603467, 2.5976849993826168, 
-1.3764797446273103, 3.0751895155372386], [-4.1075171584846668, 2.8307561035503932, -5.6840389759167831, 2.5273602781422273], 
[-3.7082514161713167, -5.114407525907068, -6.2107079822952205, -0.32554788625220432]], [[3.061407632361222, 2.1604092746514238, 
-0.25554733044484745, 0.1301636198548719], [1.0353433623065786, -2.8526314127413377, 0.33610966361354588, -1.5428060129138834], 
[-0.59695374422308412, 1.8869614477382717, 6.4812381443169906, -1.6428374721729093]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_float_rank0(self):
      arg0=Data(2.29296097295,self.functionspace)
      arg0.setTaggedValue(1,-0.865149407705)
      arg1=1.84752327157
      res=arg0+arg1
      ref=Data(4.14048424452,self.functionspace)
      ref.setTaggedValue(1,0.982373863864)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_array_rank0(self):
      arg0=Data(3.03165079659,self.functionspace)
      arg0.setTaggedValue(1,-2.13856118931)
      arg1=numpy.array(3.16421773497)
      res=arg0+arg1
      ref=Data(6.19586853156,self.functionspace)
      ref.setTaggedValue(1,1.02565654566)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_array_rank1(self):
      arg0=Data(-3.39036425876,self.functionspace)
      arg0.setTaggedValue(1,-1.9982705161)
      arg1=numpy.array([0.20395812629873866, -3.6283864462390367])
      res=arg0+arg1
      ref=Data(numpy.array([-3.1864061324580195, -7.0187507049957949]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-1.7943123898010662, -5.626656962338842]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_array_rank2(self):
      arg0=Data(-2.4360484545,self.functionspace)
      arg0.setTaggedValue(1,4.51542461912)
      arg1=numpy.array([[2.1081715059736279, 1.5276320644975154, -3.5919376793793631, 2.49668285250495, 2.0560683812000384], 
[-1.8968708676974897, -1.3909914778934382, -3.8972446549153341, 4.4648337345436762, -3.4134205109734883], [4.813110307018281, 
2.5414393459775635, -3.7296494961802864, 3.5859706166020082, 4.7695162754414113], [1.5733478639386531, -4.8511134286581665, 
3.5242887252078354, -2.4340148304684419, -3.5714922585679201]])
      res=arg0+arg1
      ref=Data(numpy.array([[-0.32787694852410354, -0.90841639000021601, -6.0279861338770946, 0.060634398007218593, 
-0.37998007329769301], [-4.3329193221952211, -3.8270399323911697, -6.3332931094130656, 2.0287852800459447, 
-5.8494689654712193], [2.3770618525205496, 0.10539089147983205, -6.1656979506780178, 1.1499221621042768, 2.3334678209436799], 
[-0.86270059055907833, -7.287161883155898, 1.088240270710104, -4.8700632849661734, -6.0075407130656515]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[6.6235961250938011, 6.0430566836176887, 0.92348693974081009, 7.0121074716251233, 
6.5714930003202117], [2.6185537514226835, 3.124433141226735, 0.61817996420483912, 8.9802583536638494, 1.1020041081466849], 
[9.3285349261384543, 7.0568639650977367, 0.78577512293988683, 8.1013952357221815, 9.2849408945615846], [6.0887724830588263, 
-0.33568880953799329, 8.0397133443280087, 2.0814097886517313, 0.94393236055225316]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_array_rank3(self):
      arg0=Data(-3.24208975985,self.functionspace)
      arg0.setTaggedValue(1,2.62527982452)
      arg1=numpy.array([[[-0.41404840239016316, 1.7801109686638803], [-1.2039450965390741, -2.3347839202577081]], 
[[-3.5114328978873468, 2.1533305358449084], [-4.6106167476145608, -0.62953884006243932]], [[-1.4956222356435731, 
3.7031850577772545], [-3.2630348889887628, 2.3059455186166176]], [[4.8324963451520286, 2.942652657805878], 
[-3.5862292403076612, -3.9654056615935951]], [[-0.50974622785371348, -1.1838710587598564], [-2.8798848007442124, 
1.5559414527111812]], [[2.5767525820163169, 3.0650856225295975], [3.1433748459083439, -2.1130873478359726]]])
      res=arg0+arg1
      ref=Data(numpy.array([[[-3.6561381622414144, -1.461978791187371], [-4.4460348563903249, -5.5768736801089593]], 
[[-6.7535226577385981, -1.0887592240063428], [-7.852706507465812, -3.8716285999136906]], [[-4.7377119954948244, 
0.46109529792600323], [-6.5051246488400141, -0.93614424123463369]], [[1.5904065853007774, -0.29943710204537322], 
[-6.8283190001589125, -7.2074954214448468]], [[-3.7518359877049647, -4.4259608186111077], [-6.1219745605954632, 
-1.68614830714007]], [[-0.6653371778349344, -0.17700413732165377], [-0.098714913942907323, 
-5.3551771076872239]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[2.2112314221260982, 4.4053907931801417], [1.4213347279771873, 0.29049590425855332]], 
[[-0.8861530733710854, 4.7786103603611698], [-1.9853369230982993, 1.9957409844538221]], [[1.1296575888726883, 
6.3284648822935159], [-0.63775506447250141, 4.931225343132879]], [[7.45777616966829, 5.5679324823221394], 
[-0.96094941579139981, -1.3401258370773337]], [[2.1155335966625479, 1.441408765756405], [-0.25460497622795097, 
4.1812212772274426]], [[5.2020324065325783, 5.6903654470458589], [5.7686546704246053, 0.51219247668028878]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_array_rank4(self):
      arg0=Data(-2.19530486292,self.functionspace)
      arg0.setTaggedValue(1,-2.52768715312)
      arg1=numpy.array([[[[0.38393400062398442, -2.6147123620008395, 4.8241838964862076, -1.1882915245803547], 
[-4.8584169558915544, -4.2515286929515366, -3.3859152328281192, -2.0952380674002469], [0.61629231289259589, 
-1.9596662627806283, 0.4856917994251031, -1.5260646850614537]], [[-4.5619792635413425, 3.5356801539889666, -1.2989305375592961, 
-0.70326837185152513], [1.5284830556150446, -3.2136918579264586, 1.4558473460696941, 2.1187716690776579], [1.9160649368111882, 
-2.9242831605548969, 3.0296911633727355, -4.4653077280479092]]], [[[4.8996679916559458, 0.88461077080015027, 
-0.27560328112553911, -4.3227022752991759], [0.41423872610300982, 1.1100151635069704, -1.9738227060660538, 
-2.6025963782287374], [0.77693900848882702, -1.7199330644894273, 1.9446959337570879, -0.16278879482562836]], 
[[4.2852363930005097, 4.7709650025354264, -2.6703711254031282, 4.1494469236895721], [1.3543103275247157, -3.3369007278217633, 
-3.3113027260158736, -2.3541119413122216], [-0.99647461479252719, 1.5894087520747844, 0.54302955182696167, 
1.1042832544674379]]], [[[-1.4721726792199084, 3.6742560454540119, -0.046524751054013436, 0.21301683274857908], 
[-0.18494596344052727, -4.8879168863640698, 1.4217501368556835, 3.6166116051506467], [3.5834284464806814, -2.6687331265922145, 
2.7545281197211366, 0.29769138648064519]], [[-1.7029022954648418, -2.5974944149521271, 3.9562327933765697, 1.1432944512268648], 
[-2.0064742753156506, -4.6283696182621981, 0.52662000619486449, -4.0178647609846019], [3.7212667864529632, 1.1699706335673135, 
2.0951843835822892, 1.0356135330496885]]]])
      res=arg0+arg1
      ref=Data(numpy.array([[[[-1.8113708622929359, -4.8100172249177593, 2.6288790335692873, -3.383596387497275], 
[-7.0537218188084747, -6.4468335558684569, -5.5812200957450395, -4.2905429303171676], [-1.5790125500243244, 
-4.1549711256975481, -1.7096130634918172, -3.7213695479783739]], [[-6.7572841264582628, 1.3403752910720463, 
-3.4942354004762164, -2.8985732347684454], [-0.66682180730187568, -5.4089967208433789, -0.73945751684722616, 
-0.076533193839262381], [-0.27923992610573212, -5.1195880234718167, 0.83438630045581519, -6.6606125909648295]]], 
[[[2.7043631287390255, -1.31069409211677, -2.4709081440424594, -6.5180071382160962], [-1.7810661368139105, -1.0852896994099499, 
-4.1691275689829741, -4.7979012411456576], [-1.4183658544280933, -3.9152379274063476, -0.25060892915983235, 
-2.3580936577425486]], [[2.0899315300835895, 2.5756601396185062, -4.8656759883200484, 1.9541420607726518], 
[-0.84099453539220459, -5.532205590738684, -5.5066075889327939, -4.5494168042291419], [-3.1917794777094475, 
-0.6058961108421359, -1.6522753110899586, -1.0910216084494824]]], [[[-3.6674775421368286, 1.4789511825370916, 
-2.2418296139709337, -1.9822880301683412], [-2.3802508263574476, -7.0832217492809901, -0.77355472606123676, 
1.4213067422337264], [1.3881235835637611, -4.8640379895091348, 0.55922325680421636, -1.8976134764362751]], 
[[-3.8982071583817621, -4.7927992778690474, 1.7609279304596495, -1.0520104116900555], [-4.2017791382325704, 
-6.8236744811791183, -1.6686848567220558, -6.2131696239015222], [1.5259619235360429, -1.0253342293496068, -0.10012047933463109, 
-1.1596913298672318]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-2.143753152496318, -5.1423995151211415, 2.2964967433659051, -3.7159786777006572], 
[-7.3861041090118569, -6.779215846071839, -5.9136023859484217, -4.6229252205205498], [-1.9113948402277066, -4.4873534159009303, 
-2.0419953536951994, -4.0537518381817561]], [[-7.089666416661645, 1.0079930008686642, -3.8266176906795986, 
-3.2309555249718276], [-0.99920409750525785, -5.7413790110467611, -1.0718398070506083, -0.40891548404264455], 
[-0.61162221630911429, -5.4519703136751989, 0.50200401025243302, -6.9929948811682117]]], [[[2.3719808385356433, 
-1.6430763823201522, -2.8032904342458416, -6.8503894284194784], [-2.1134484270172926, -1.4176719896133321, -4.5015098591863563, 
-5.1302835313490398], [-1.7507481446314754, -4.2476202176097297, -0.58299121936321452, -2.6904759479459308]], 
[[1.7575492398802073, 2.243277849415124, -5.1980582785234306, 1.6217597705692697], [-1.1733768255955868, -5.8645878809420662, 
-5.8389898791361761, -4.881799094432524], [-3.5241617679128296, -0.93827840104551807, -1.9846576012933408, 
-1.4234038986528645]]], [[[-3.9998598323402108, 1.1465688923337094, -2.5742119041743159, -2.3146703203717234], 
[-2.7126331165608297, -7.4156040394843723, -1.1059370162646189, 1.0889244520303443], [1.0557412933603789, -5.196420279712517, 
0.22684096660083419, -2.2299957666396573]], [[-4.2305894485851443, -5.1251815680724295, 1.4285456402562673, 
-1.3843927018934377], [-4.5341614284359526, -7.1560567713825005, -2.001067146925438, -6.5455519141049043], [1.1935796333326607, 
-1.357716519552989, -0.43250276953801325, -1.4920736200706139]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_constData_rank0(self):
      arg0=Data(3.86230529087,self.functionspace)
      arg0.setTaggedValue(1,1.18808616797)
      arg1=Data(2.05080033163,self.functionspace)
      res=arg0+arg1
      ref=Data(5.9131056225,self.functionspace)
      ref.setTaggedValue(1,3.2388864996)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_constData_rank1(self):
      arg0=Data(3.67849774954,self.functionspace)
      arg0.setTaggedValue(1,-4.11303757292)
      arg1=Data(numpy.array([1.8331631361731038, -2.954600680409345]),self.functionspace)
      res=arg0+arg1
      ref=Data(numpy.array([5.5116608857128035, 0.72389706913035479]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-2.2798744367464749, -7.0676382533289237]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_constData_rank2(self):
      arg0=Data(2.7324622393,self.functionspace)
      arg0.setTaggedValue(1,-4.50382859082)
      arg1=Data(numpy.array([[3.3641860429263062, -1.8077339556933514, -1.2834744556811017, -4.4787445140634405, 
-0.27698598603725344], [-1.2127736585101703, -3.4779249046318683, 2.0899273379433154, 3.4999307572361626, 
-0.47171298019905628], [-0.24400762141580135, -2.7594431028750286, 0.34535610045476872, 0.85446598867582235, 
1.2445562714632903], [-1.9601875932982784, -2.9526655521925105, -4.1058310669425326, -1.5162723691050051, 
-0.55946914666192527]]),self.functionspace)
      res=arg0+arg1
      ref=Data(numpy.array([[6.096648282228764, 0.92472828360910642, 1.4489877836213561, -1.7462822747609827, 
2.4554762532652044], [1.5196885807922875, -0.74546266532941052, 4.8223895772457732, 6.2323929965386204, 2.2607492591034015], 
[2.4884546178866565, -0.02698086357257079, 3.0778183397572265, 3.5869282279782801, 3.9770185107657481], [0.77227464600417939, 
-0.22020331289005268, -1.3733688276400748, 1.2161898701974527, 2.1729930926405325]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-1.1396425478896504, -6.3115625465093075, -5.7873030464970583, -8.9825731048793962, 
-4.78081457685321], [-5.7166022493261268, -7.9817534954478244, -2.4139012528726411, -1.0038978335797939, -4.9755415710150128], 
[-4.7478362122317579, -7.2632716936909851, -4.1584724903611878, -3.6493626021401342, -3.2592723193526663], [-6.464016184114235, 
-7.4564941430084666, -8.6096596577584883, -6.0201009599209616, -5.0632977374778818]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_constData_rank3(self):
      arg0=Data(2.19032016387,self.functionspace)
      arg0.setTaggedValue(1,-2.56680802473)
      arg1=Data(numpy.array([[[-3.9751171199690436, 4.8899184336489103], [-3.9690433069117983, 1.6926749155014509]], 
[[1.4258065830516582, -4.4135341836058659], [1.8500348031722673, -1.1915908985412393]], [[3.544916706225667, 
-2.776918511293518], [4.9193199901841584, 3.1529485219215143]], [[-3.7019570594296858, -4.8151732460070686], 
[-4.1507319417463107, -0.34538259128676607]], [[1.8900885748804575, -4.230946658400395], [-1.6413217851779405, 
0.16987378532215747]], [[1.4069100800246268, 3.9494846877176126], [3.7590990052833391, 
3.9137483255036276]]]),self.functionspace)
      res=arg0+arg1
      ref=Data(numpy.array([[[-1.784796956098651, 7.080238597519303], [-1.7787231430414057, 3.8829950793718435]], 
[[3.6161267469220508, -2.2232140197354733], [4.04035496704266, 0.99872926532915329]], [[5.7352368700960596, 
-0.58659834742312533], [7.1096401540545511, 5.3432686857919069]], [[-1.5116368955592931, -2.624853082136676], 
[-1.960411777875918, 1.8449375725836266]], [[4.0804087387508501, -2.0406264945300023], [0.54899837869245216, 
2.3601939491925501]], [[3.5972302438950194, 6.1398048515880053], [5.9494191691537317, 6.1040684893740202]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-6.5419251447033178, 2.3231104089146362], [-6.5358513316460725, 
-0.87413310923282328]], [[-1.141001441682616, -6.9803422083401401], [-0.71677322156200685, -3.7583989232755135]], 
[[0.97810868149139285, -5.3437265360277921], [2.3525119654498843, 0.58614049718724015]], [[-6.2687650841639595, 
-7.3819812707413428], [-6.7175399664805848, -2.9121906160210402]], [[-0.67671944985381671, -6.7977546831346691], 
[-4.2081298099122151, -2.3969342394121167]], [[-1.1598979447096474, 1.3826766629833385], [1.1922909805490649, 
1.3469403007693534]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_constData_rank4(self):
      arg0=Data(-4.51699258956,self.functionspace)
      arg0.setTaggedValue(1,-1.9314688415)
      arg1=Data(numpy.array([[[[-4.6121210823866949, -0.39911898335550067, 1.0220065408994135, -3.2218202106106064], 
[-4.4798179661148883, 1.6143909899455444, -2.3591942868887896, -2.9651695050083071], [-3.8395108579430892, -1.1467597560894651, 
-1.8053166109441077, -3.8527182892474032]], [[4.3553230739546791, -1.8189069903443835, 2.7530356959031845, 4.8870107409366597], 
[-2.9869746864590274, 4.6069455536235466, -2.2979092144214155, -4.7536745870998223], [2.7714827290157151, -4.8302972276294343, 
0.85624201495125618, -2.4558344865559869]]], [[[0.49954928283636946, 2.2844233040722539, -2.4563680004188804, 
-4.3546980978260494], [4.496792018950849, 0.63856672806402415, -4.9019667438169936, 4.4200698743379512], [0.3509823037673776, 
3.8629058866223751, 3.9690404219111493, 2.7242082796739417]], [[0.55407991883350682, 4.8933550440969764, 3.1042639625705473, 
1.5801801735882108], [3.358785928282531, -1.1342388303370043, 0.94125142292867814, -2.7267726407066739], [-2.2057107224085848, 
-0.71140132170168435, 0.83804467851579911, -3.4878274475552251]]], [[[0.54558900719122949, 4.7734486675017749, 
0.30998287401196656, -3.4865707041166907], [-0.45750091834826456, 2.8340184453393551, -3.4634119343162881, 
-3.5403928817814165], [0.55810424653144697, -3.5771474761557887, 0.0016539868301510552, 3.1961208949540154]], 
[[-0.99132469275235646, -2.7321990677958894, 2.3084406702263518, 4.788854508284718], [3.7243726115726581, -1.9281248799270445, 
-3.5895232826834467, -4.4406635256688363], [-4.8095798476927962, -3.9675427987674583, -0.48206923849554961, 
4.9910922710559742]]]]),self.functionspace)
      res=arg0+arg1
      ref=Data(numpy.array([[[[-9.1291136719436636, -4.9161115729124694, -3.4949860486575552, -7.7388128001675751], 
[-8.9968105556718569, -2.9026015996114243, -6.8761868764457583, -7.4821620945652754], [-8.3565034475000584, 
-5.6637523456464338, -6.3223092005010759, -8.3697108788043728]], [[-0.16166951560228959, -6.3358995799013522, 
-1.7639568936537842, 0.37001815137969096], [-7.5039672760159961, 0.089952964066577934, -6.8149018039783842, 
-9.2706671766567901], [-1.7455098605412536, -9.3472898171864038, -3.6607505746057125, -6.9728270761129556]]], 
[[[-4.0174433067205992, -2.2325692854847148, -6.9733605899758491, -8.871690687383019], [-0.020200570606119683, 
-3.8784258614929445, -9.4189593333739623, -0.096922715219017519], [-4.1660102857895911, -0.65408670293459359, 
-0.54795216764581944, -1.7927843098830269]], [[-3.9629126707234619, 0.37636245454000772, -1.4127286269864214, 
-2.9368124159687579], [-1.1582066612744377, -5.651231419893973, -3.5757411666282906, -7.2437652302636426], [-6.722703311965553, 
-5.228393911258653, -3.6789479110411696, -8.0048200371121929]]], [[[-3.9714035823657392, 0.25645607794480618, 
-4.2070097155450021, -8.0035632936736594], [-4.9744935079052333, -1.6829741442176136, -7.9804045238732568, 
-8.0573854713383852], [-3.9588883430255217, -8.0941400657127573, -4.5153386027268176, -1.3208716946029533]], 
[[-5.5083172823093252, -7.2491916573528581, -2.2085519193306169, 0.27186191872774934], [-0.79261997798431061, 
-6.4451174694840132, -8.1065158722404149, -8.9576561152258058], [-9.3265724372497658, -8.4845353883244279, -4.9990618280525183, 
0.4740996814990055]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-6.5435899238906536, -2.3305878248594589, -0.9094623006045448, -5.1532890521145642], 
[-6.411286807618847, -0.31707785155841384, -4.2906631283927474, -4.8966383465122654], [-5.7709796994470475, 
-3.0782285975934234, -3.7367854524480659, -5.784187130751361]], [[2.4238542324507208, -3.7503758318483418, 0.82156685439922628, 
2.9555418994327014], [-4.9184435279629852, 2.6754767121195884, -4.2293780559253733, -6.6851434286037801], [0.84001388751175687, 
-6.7617660691333921, -1.0752268265527021, -4.3873033280599447]]], [[[-1.4319195586675888, 0.35295446256829566, 
-4.3878368419228391, -6.2861669393300073], [2.5653231774468908, -1.2929021134399341, -6.8334355853209523, 2.4886010328339929], 
[-1.5804865377365807, 1.9314370451184169, 2.037571580407191, 0.79273943816998349]], [[-1.3773889226704514, 2.9618862025930182, 
1.172795121066589, -0.35128866791574742], [1.4273170867785727, -3.0657076718409626, -0.99021741857528012, -4.6582414822106326], 
[-4.137179563912543, -2.6428701632056426, -1.0934241629881591, -5.4192962890591829]]], [[[-1.3858798343127288, 
2.8419798259978166, -1.6214859674919917, -5.4180395456206494], [-2.3889697598522228, 0.90254960383539684, -5.3948807758202459, 
-5.4718617232853752], [-1.3733645949725113, -5.5086163176597474, -1.9298148546738072, 1.2646520534500572]], 
[[-2.9227935342563147, -4.6636679092998481, 0.37697182872239354, 2.8573856667807598], [1.7929037700686998, -3.8595937214310028, 
-5.5209921241874049, -6.3721323671727941], [-6.741048689196754, -5.8990116402714161, -2.4135380799995079, 
3.0596234295520159]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_taggedData_rank0(self):
      arg0=Data(1.06708017249,self.functionspace)
      arg0.setTaggedValue(1,-3.25402063702)
      arg1=Data(3.25656129909,self.functionspace)
      arg1.setTaggedValue(1,4.18992375174)
      res=arg0+arg1
      ref=Data(4.32364147158,self.functionspace)
      ref.setTaggedValue(1,0.935903114728)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_taggedData_rank1(self):
      arg0=Data(1.13367068898,self.functionspace)
      arg0.setTaggedValue(1,4.8318093292)
      arg1=Data(numpy.array([3.5486323025573778, -3.9595252320239371]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([-1.0212988849549043, 1.0947512998903388]))
      res=arg0+arg1
      ref=Data(numpy.array([4.682302991536087, -2.825854543045228]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([3.8105104442471212, 5.9265606290923643]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_taggedData_rank2(self):
      arg0=Data(4.05203768321,self.functionspace)
      arg0.setTaggedValue(1,2.99934891978)
      arg1=Data(numpy.array([[4.0109727121693535, -3.3123747036063866, -0.65378998028351365, -0.35226199859120033, 
-2.7572843697414138], [4.9956655041848723, -0.52363648179708377, 3.0308238090085062, -0.65374074249569603, 
-1.8312194682127378], [-4.0547465724550946, -2.1425959490010813, 3.6853966663310445, 1.29599873905227, -4.2870260966385585], 
[0.97570023159799746, -2.4295885899745651, 2.3547450346064194, -1.9262018603048023, -3.5168056866523143]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[1.9020762439355519, 0.58831211015719376, 0.10478411615355832, -1.8221758784968278, 
-3.0312868921401148], [0.037363898105802207, -2.7440657037866978, 0.81830228900701574, 2.7443631180739736, 
-0.39768901470796614], [4.0097173958047012, 1.8501996956563289, -2.3414143509717134, 0.91838369541387799, 0.59960873643829338], 
[-3.0057595650064162, 1.0215009286287717, 4.7967180404588881, 1.3855216718432262, -2.0978337313153483]]))
      res=arg0+arg1
      ref=Data(numpy.array([[8.0630103953776899, 0.73966297960194982, 3.3982477029248228, 3.6997756846171361, 
1.2947533134669227], [9.0477031873932088, 3.5284012014112527, 7.0828614922168427, 3.3982969407126404, 2.2208182149955986], 
[-0.0027088892467581616, 1.9094417342072552, 7.7374343495393809, 5.3480364222606065, -0.23498841343022203], 
[5.0277379148063339, 1.6224490932337714, 6.4067827178147558, 2.1258358229035341, 0.53523199655602216]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[4.9014251637164747, 3.5876610299381166, 3.1041330359344812, 1.1771730412840951, 
-0.031937972359191935], [3.0367128178867251, 0.2552832159942251, 3.8176512087879386, 5.7437120378548965, 2.6016599050729567], 
[7.0090663155856241, 4.8495486154372518, 0.65793456880920953, 3.9177326151948009, 3.5989576562192163], [-0.0064106452254932833, 
4.0208498484096946, 7.7960669602398109, 4.384870591624149, 0.90151518846557455]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_taggedData_rank3(self):
      arg0=Data(3.12009271362,self.functionspace)
      arg0.setTaggedValue(1,3.99467141204)
      arg1=Data(numpy.array([[[3.3288751112597943, 3.2288364226226065], [-4.27743713114298, -4.442729193623367]], 
[[4.5455517418177553, -2.0690283359018968], [-0.082854446843692031, 2.2659297408978514]], [[0.76045293122690438, 
0.53338980129996738], [-4.2717178158989064, -3.5128239879426149]], [[-3.576563246865605, 4.4557168791105219], 
[-3.0564832230809493, -2.2774467938837395]], [[3.0182590083997773, -1.2942577764404284], [4.1939707887791382, 
0.099513539962120312]], [[0.047346570263790966, 1.3536116492480819], [-3.9155684845507377, 
-2.4106487782682704]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[4.3824375423470112, -3.0548925346523461], [-2.2027484362284913, 
4.9046875731599719]], [[-3.3913827366940872, 0.62004007366019565], [-2.8047455003075319, 4.1933603818190139]], 
[[4.3888182133246172, 0.43417544351516213], [-3.9814144765755834, 3.7079574744230399]], [[2.6849666718347613, 
2.7377998782056565], [-0.44184043133623518, 4.2701294690757265]], [[-2.5727508790835674, -4.5792308970455329], 
[-4.2503187020974629, -2.422324104904563]], [[2.8687560027339636, -4.3606027447498192], [3.8522492880998378, 
-4.8958542589689369]]]))
      res=arg0+arg1
      ref=Data(numpy.array([[[6.4489678248748774, 6.3489291362376896], [-1.1573444175278969, -1.3226364800082839]], 
[[7.6656444554328385, 1.0510643777131863], [3.0372382667713911, 5.3860224545129345]], [[3.8805456448419875, 
3.6534825149150505], [-1.1516251022838233, -0.39273127432753174]], [[-0.45647053325052189, 7.5758095927256051], 
[0.063609490534133784, 0.84264591973134362]], [[6.1383517220148605, 1.8258349371746547], [7.3140635023942213, 
3.2196062535772034]], [[3.1674392838788741, 4.473704362863165], [-0.79547577093565458, 
0.70944393534681272]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[8.3771089543902697, 0.93977887739091237], [1.7919229758147672, 8.8993589852032304]], 
[[0.6032886753491713, 4.6147114857034541], [1.1899259117357266, 8.1880317938622724]], [[8.3834896253678757, 
4.4288468555584206], [0.013256935467675035, 7.7026288864662984]], [[6.6796380838780198, 6.732471290248915], 
[3.5528309807070233, 8.264800881118985]], [[1.4219205329596911, -0.58455948500227439], [-0.25564729005420439, 
1.5723473071386955]], [[6.8634274147772221, -0.36593133270656075], [7.8469207001430963, -0.9011828469256784]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_taggedData_rank4(self):
      arg0=Data(2.15814625848,self.functionspace)
      arg0.setTaggedValue(1,-1.54003280216)
      arg1=Data(numpy.array([[[[0.77780005294718713, -1.8382701985491856, 2.8100456369937827, -0.65810303243679069], 
[-2.1502736112542364, -1.4510218903103098, -1.5455760408573758, -1.4977089764499252], [-2.5953726210537633, 
-4.6546473323104536, -0.54591572151648293, 2.5113871518187194]], [[4.6959353612419346, 3.3929207698716883, 2.4231508860787923, 
2.1568247294679228], [0.6083428437426841, 1.8094573710100095, 0.02078668160692132, -4.8695311945788653], [-1.6274091057385895, 
2.2743846291290595, -3.9917322493800667, 1.2104668018060059]]], [[[4.3578682288142652, -1.2148719293193899, 1.6151062451585769, 
2.5389231571768907], [2.0847460368699489, -2.6371013066373292, -4.3128248972532282, -3.0862601028789016], [4.0056188040004201, 
-1.9978831797736527, -2.4500282498142676, -3.8325019614790445]], [[2.4697811385291022, 1.0560478923301559, -3.2230874470411464, 
-1.9841475766189243], [-3.3269063240286201, 4.9754981707012451, -4.4072017166499027, -0.91796175383308753], 
[-4.7344459695107091, -4.621147653927002, -3.0867207598129074, 0.8965523811884113]]], [[[3.5445124209697223, 
-3.0199283387289344, -1.528283508837732, -4.786148180744048], [-0.35470208273686055, -4.3474467871167235, -0.10276294298889344, 
-3.3058859932770277], [1.5664759758131472, 4.1975423480902805, 4.2621171908026447, -3.5242591731006967]], [[4.4604848904395418, 
-0.70395998272948201, 4.2306795259333043, 2.0541522282931366], [0.55995884155478493, -0.75426183047508388, -1.9599710043821581, 
-1.6294664185384833], [1.2524026757554871, 2.1411345566794449, -2.4133729721536277, 1.9717912124502925]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[-4.7359919800579018, 4.2877861963492876, 3.3360222421510439, -0.44502880337905815], 
[-4.0811223509556829, -2.7223067630246334, 2.4296395934435164, 2.5736676638070097], [-0.11127098696252347, 2.8074971386955347, 
2.6525779943222707, 3.3888428826645498]], [[2.5151122596628293, -3.5825231259309067, -0.84037584988397551, 
-2.9457005983983708], [4.37344391291915, -3.3756222178332482, -0.54012114472092598, 2.2744302346921472], [4.8295754080945503, 
3.5280915927913021, 2.5435630360725048, 3.5794559102558523]]], [[[4.9881715999119951, -1.3360108202830503, 0.27231734407299424, 
0.093541956761064249], [-3.7030315282506709, -1.720443027344094, 2.9082251077274073, -1.6486380943156895], 
[-3.6430509796093915, -0.50281057430209941, -2.1489577359826906, -2.326140037132717]], [[-0.44208092369812846, 
0.54251358359656976, -1.9506879824973442, -4.8923447980001384], [2.6740432644895096, 0.96759509048760162, -4.4888456526637857, 
-4.5703420233074539], [-2.1168450502607286, 2.728347633438208, 0.060457837844900553, 0.79597703415686105]]], 
[[[-3.5708016875179305, 2.9229444002153757, 1.6915457329603578, 4.4351993450760645], [1.7044185662286804, -3.9080889584190581, 
-4.5785323214991633, -3.7550313887910471], [4.0955914016162005, -0.81735560297289211, -3.6317111111680767, 
4.9265087581458182]], [[3.3543634551075687, -4.4178680501476189, 0.50223464800697037, 1.612344692779426], [-1.5335820692975766, 
-0.92638120941575863, 3.6344592515716183, 0.580472109300187], [-4.0159977836528249, 0.15919761767340557, -3.3482184838181994, 
-3.3711951688903827]]]]))
      res=arg0+arg1
      ref=Data(numpy.array([[[[2.9359463114245807, 0.319876059928208, 4.9681918954711763, 1.5000432260406029], 
[0.0078726472231571698, 0.70712436816708379, 0.61257021762001784, 0.66043728202746843], [-0.43722636257636971, 
-2.49650107383306, 1.6122305369609107, 4.669533410296113]], [[6.8540816197193282, 5.5510670283490819, 4.5812971445561859, 
4.3149709879453164], [2.7664891022200777, 3.9676036294874031, 2.1789329400843149, -2.7113849361014717], [0.53073715273880406, 
4.4325308876064531, -1.833585990902673, 3.3686130602833995]]], [[[6.5160144872916588, 0.94327432915800369, 3.7732525036359705, 
4.6970694156542843], [4.2428922953473425, -0.47895504815993561, -2.1546786387758345, -0.92811384440150801], 
[6.1637650624778137, 0.1602630787037409, -0.29188199133687398, -1.6743557030016509]], [[4.6279273970064958, 3.2141941508075496, 
-1.0649411885637527, 0.17399868185846934], [-1.1687600655512265, 7.1336444291786387, -2.2490554581725091, 1.2401845046443061], 
[-2.5762997110333155, -2.4630013954496084, -0.92857450133551378, 3.0546986396658049]]], [[[5.7026586794471159, 
-0.86178208025154079, 0.6298627496396616, -2.6280019222666544], [1.8034441757405331, -2.1893005286393299, 2.0553833154885002, 
-1.1477397347996341], [3.7246222342905408, 6.3556886065676741, 6.4202634492800383, -1.3661129146233031]], [[6.6186311489169354, 
1.4541862757479116, 6.3888257844106979, 4.2122984867705302], [2.7181051000321785, 1.4038844280023097, 0.19817525409523551, 
0.52867983993891032], [3.4105489342328807, 4.2992808151568385, -0.25522671367623406, 4.1299374709276861]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-6.2760247822162274, 2.747753394190962, 1.7959894399927183, -1.9850616055373838], 
[-5.6211551531140085, -4.262339565182959, 0.88960679128519082, 1.0336348616486841], [-1.6513037891208491, 1.2674643365372091, 
1.1125451921639451, 1.8488100805062242]], [[0.97507945750450364, -5.1225559280892323, -2.3804086520423011, 
-4.4857334005566969], [2.8334111107608244, -4.9156550199915738, -2.0801539468792516, 0.73439743253382161], [3.2895426059362247, 
1.9880587906329765, 1.0035302339141792, 2.0394231080975267]]], [[[3.4481387977536695, -2.8760436224413759, -1.2677154580853314, 
-1.4464908453972614], [-5.2430643304089966, -3.2604758295024197, 1.3681923055690817, -3.1886708964740151], 
[-5.1830837817677171, -2.042843376460425, -3.6889905381410162, -3.8661728392910426]], [[-1.9821137258564541, 
-0.99751921856175585, -3.4907207846556698, -6.432377600158464], [1.134010462331184, -0.57243771167072399, -6.0288784548221113, 
-6.1103748254657795], [-3.6568778524190542, 1.1883148312798824, -1.4795749643134251, -0.74405576800146456]]], 
[[[-5.1108344896762556, 1.3829115980570501, 0.15151293080203221, 2.8951665429177389], [0.16438576407035477, 
-5.4481217605773837, -6.1185651236574889, -5.2950641909493728], [2.5555585994578749, -2.3573884051312177, -5.1717439133264023, 
3.3864759559874926]], [[1.8143306529492431, -5.9579008523059445, -1.0377981541513552, 0.072311890621100439], 
[-3.0736148714559022, -2.4664140115740842, 2.0944264494132927, -0.95956069285813861], [-5.5560305858111505, -1.38083518448492, 
-4.8882512859765246, -4.9112279710487083]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_expandedData_rank0(self):
      arg0=Data(-4.63468002965,self.functionspace)
      arg0.setTaggedValue(1,1.14356055602)
      arg1=Data(-4.65964295112,self.functionspace)
      arg1.setTaggedValue(1,-4.7660123087)
      arg1.expand()
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*(-9.29432298077)+(1.-msk_ref)*(-3.62245175268)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_expandedData_rank1(self):
      arg0=Data(-4.01450571576,self.functionspace)
      arg0.setTaggedValue(1,-4.79948070273)
      arg1=Data(numpy.array([-1.4945676498042371, 4.1636484610154358]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([2.9957636820561273, 0.014275220903869013]))
      arg1.expand()
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-5.5090733655635802, 0.14914274525609272])+(1.-msk_ref)*numpy.array([-1.8037170206697795, 
-4.7852054818220378])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_expandedData_rank2(self):
      arg0=Data(-3.08759004952,self.functionspace)
      arg0.setTaggedValue(1,-4.07326584633)
      arg1=Data(numpy.array([[-3.8440802942459351, 0.88599006342616082, -2.8336927986832161, -4.7384929433468779, 
-4.0673014725646546], [1.7716479746027858, -2.7545291447892764, -4.8623255165868153, 3.5684412287608787, -3.2808927507342456], 
[0.35044628569508962, -3.7369045820769187, -0.32354208711663279, 0.91717888748089571, 1.267897144188459], [0.13581192877645165, 
3.3970653631389105, 0.65945030380393543, -3.0329169703593828, 1.5109917182520052]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[-1.6273366897325858, 1.6242521101541367, -0.80676284755454475, -1.6069618658885654, 
-1.0788495762977179], [-1.2440133192838223, -1.2245262816512206, 1.136458628155613, 3.3710510861186389, -2.5234305665624279], 
[-1.5268581953041673, -4.8285404364668754, -4.1367972745599779, 2.6562968470356179, -1.4664095591971824], 
[-0.80564004575783876, 4.5332607444869986, -1.5579578106602341, 3.4148196223228453, 0.4401427283465642]]))
      arg1.expand()
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-6.9316703437696958, -2.2015999860975999, -5.9212828482069764, -7.8260829928706386, 
-7.1548915220884153], [-1.3159420749209749, -5.8421191943130371, -7.949915566110576, 0.48085117923711795, -6.3684828002580058], 
[-2.7371437638286711, -6.8244946316006789, -3.4111321366403935, -2.170411162042865, -1.8196929053353017], [-2.9517781207473091, 
0.30947531361514979, -2.4281397457198253, -6.1205070198831439, 
-1.5765983312717555]])+(1.-msk_ref)*numpy.array([[-5.7006025360634585, -2.4490137361767363, -4.8800286938854178, 
-5.6802277122194385, -5.152115422628591], [-5.3172791656146954, -5.2977921279820936, -2.93680721817526, -0.70221476021223417, 
-6.5966964128933014], [-5.6001240416350404, -8.9018062827977484, -8.210063120890851, -1.4169689992952552, -5.5396754055280555], 
[-4.8789058920887118, 0.45999489815612549, -5.6312236569911072, -0.65844622400802777, -3.6331231179843089]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_expandedData_rank3(self):
      arg0=Data(1.63167315478,self.functionspace)
      arg0.setTaggedValue(1,2.64313681569)
      arg1=Data(numpy.array([[[3.5334428304641676, 1.3448302882853946], [-1.7150552323119617, 2.2920488201700726]], 
[[-2.9862367264684297, 2.0373955638738908], [2.5290307264649243, -4.3808795762986534]], [[1.6103243035130141, 
0.74719893397661163], [2.9015732099646216, -2.4448771982405582]], [[2.7477489691732533, -3.4418842879887745], 
[-1.8345470547207188, -1.5100089248910775]], [[-4.6075046600131788, -4.6490151849699659], [-0.16476620232660277, 
2.6496236687303263]], [[-4.6647269931052673, 1.7702333145101843], [1.5712821220566049, 
-0.7508154357640926]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[1.6886237093282404, -0.23175646823888929], [0.85841863308994881, 
-2.5932811961296665]], [[1.6386382570817055, -4.1684829457584982], [0.63215378656443022, -2.5684567044235562]], 
[[-4.6521563239928696, 3.4268278211702281], [2.7498874453882038, 1.5931865656880086]], [[1.0738958310620896, 
-3.6839761141127028], [-3.1756281291393695, -1.7426866362281879]], [[-2.3556188316851721, -3.7576159053131231], 
[-3.7150188217025484, 3.7066885523068436]], [[4.6360179917754412, -3.4602983191359549], [-1.2433685887379262, 
-0.30651291778588963]]]))
      arg1.expand()
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[5.1651159852439346, 2.9765034430651616], [-0.083382077532194732, 3.9237219749498395]], 
[[-1.3545635716886628, 3.6690687186536577], [4.1607038812446913, -2.7492064215188865]], [[3.2419974582927811, 
2.3788720887563786], [4.5332463647443886, -0.81320404346079123]], [[4.3794221239530202, -1.8102111332090076], 
[-0.20287389994095184, 0.12166422988868941]], [[-2.9758315052334119, -3.017342030190199], [1.4669069524531642, 
4.2812968235100932]], [[-3.0330538383255004, 3.4019064692899512], [3.2029552768363718, 
0.88085771901567433]]])+(1.-msk_ref)*numpy.array([[[4.3317605250229523, 2.4113803474558226], [3.5015554487846607, 
0.049855619565045473]], [[4.2817750727764174, -1.5253461300637863], [3.2752906022591421, 0.074680111271155702]], 
[[-2.0090195082981577, 6.06996463686494], [5.3930242610829158, 4.2363233813827206]], [[3.7170326467568016, 
-1.0408392984179908], [-0.53249131344465761, 0.90045017946652406]], [[0.28751798400953987, -1.1144790896184111], 
[-1.0718820060078365, 6.3498253680015555]], [[7.2791548074701531, -0.81716150344124294], [1.3997682269567857, 
2.3366238979088223]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank0_expandedData_rank4(self):
      arg0=Data(0.992473939243,self.functionspace)
      arg0.setTaggedValue(1,-1.037051364)
      arg1=Data(numpy.array([[[[-3.7528037800257996, 3.0722001030772574, 3.844311442589559, -2.4972694662129911], 
[-4.4728102728435033, 0.82818983681654323, -0.3972546627607132, 0.93595044805815419], [-0.58164237903709726, 
4.9941207762144906, 2.6765854525000048, 1.125129814972591]], [[-2.4615801620204381, 4.3728792389646909, 0.65377634851031186, 
-4.1445737599419852], [2.9042843598417925, -0.39456021501178284, -3.6375703795869341, 0.4364281599640929], 
[-4.1110858230442284, -3.6510182664681166, -2.6222582929342684, 1.2119932766749404]]], [[[-2.827547406038704, 
-3.3943097060358851, 0.46338629741950044, 3.646342157966707], [2.0683435895541677, 1.6357810515153854, 1.9501369424726427, 
1.7586361176709868], [-4.6055825014138572, -2.7021944088022787, 4.5160538390164913, -0.6515211590136154]], 
[[-1.6577009983290147, 0.74153690934879446, -3.5188883222272804, -3.1580483724287389], [0.280149774405829, -3.3842996329151855, 
-0.9655712177669562, -1.0977386984372028], [-1.6087159489947789, -4.2301987770776597, 2.0642471241094986, 
3.7815603426115967]]], [[[0.78810996983231263, 1.1713150153718574, 0.48373756798196332, 0.32802865245343682], 
[-4.2602436248986253, 2.6815635506192663, -2.749303435729388, 1.5113175928058986], [4.0386932510584224, -2.7660006446367005, 
-3.8899026980541276, -2.8478500989409197]], [[-4.4201889577523721, 4.3370720480505369, -1.183106794306763, -2.753346380339762], 
[2.6759596440025799, 1.9298136613277137, -1.7777245668218522, 3.4346965652205288], [4.1697038349452935, -3.3432034263924648, 
0.95038013386971976, -0.65446331432793681]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[2.0789104434484473, -4.508777400348567, 1.5331083546332334, 4.49336212858152], 
[1.8802207328030187, -4.9436312011442958, 0.95995390941115755, 1.0409397140712962], [4.4029806285991455, -3.0508353519497589, 
-1.4319920162676967, 4.9324859166792496]], [[-0.80321564842726545, -0.31379127954498109, 4.8077178833583769, 
-0.44518932196249672], [3.1138068395754708, 3.9312599291722865, -2.1753619070696049, -4.3496776617454689], 
[-1.9317238107094825, 3.7498607559317403, -4.8409100962982947, -3.4067761660017215]]], [[[-1.6530285997714733, 
-3.3014759260717632, 0.77334729141762182, -1.6425686289050088], [3.3938981157540375, -2.9780304165754012, 0.16193154805455467, 
-3.9008003597439656], [1.2224442501270545, -2.341507950209909, -3.2027558874601425, 1.1725104185480788]], [[2.0639107295459134, 
1.6561771765853468, 2.4027523947915554, -3.5099301386055703], [-0.88931997894950499, -2.5704542848111291, -0.9665448709263309, 
1.7051997753467312], [4.6367791768868933, -2.4669021358046725, -1.6153774579581026, -4.1453553191414851]]], 
[[[2.4407751157254607, 2.79182158971678, -2.7425933984344186, -2.9283084218787003], [-1.6452839946246556, -2.7502841719075741, 
-0.082291147475465287, 1.3415023360316187], [-4.2509674661666601, 1.9941709432672905, 0.38029069702154583, 
1.4827772847029141]], [[2.4884780660954249, 3.8913177374430621, -0.48481698674975604, 0.063994223713578435], 
[4.2954488325747491, -4.04061057745737, 3.2654677239706196, 2.3177058434320053], [-1.4208522341319494, 1.3867401579820982, 
-0.23356359719482889, 0.82529852322257735]]]]))
      arg1.expand()
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-2.760329840783089, 4.0646740423199681, 4.8367853818322697, -1.5047955269702804], 
[-3.4803363336007926, 1.8206637760592539, 0.59521927648199746, 1.9284243873008649], [0.4108315602056134, 5.9865947154572012, 
3.6690593917427154, 2.1176037542153017]], [[-1.4691062227777274, 5.3653531782074015, 1.6462502877530225, -3.1520998206992745], 
[3.8967582990845031, 0.59791372423092781, -2.6450964403442234, 1.4289020992068036], [-3.1186118838015178, -2.6585443272254059, 
-1.6297843536915577, 2.204467215917651]]], [[[-1.8350734667959934, -2.4018357667931745, 1.4558602366622111, 
4.6388160972094177], [3.0608175287968784, 2.6282549907580961, 2.9426108817153533, 2.7511100569136975], [-3.6131085621711465, 
-1.709720469559568, 5.5085277782592019, 0.34095278022909525]], [[-0.66522705908630408, 1.7340108485915051, -2.5264143829845698, 
-2.1655744331860283], [1.2726237136485397, -2.3918256936724749, 0.026902721475754454, -0.10526475919449219], 
[-0.61624200975206822, -3.237724837834949, 3.0567210633522093, 4.7740342818543073]]], [[[1.7805839090750233, 
2.1637889546145681, 1.476211507224674, 1.3205025916961475], [-3.2677696856559146, 3.674037489861977, -1.7568294964866773, 
2.5037915320486093], [5.031167190301133, -1.7735267053939898, -2.8974287588114169, -1.855376159698209]], [[-3.4277150185096614, 
5.3295459872932476, -0.19063285506405236, -1.7608724410970513], [3.6684335832452906, 2.9222876005704244, -0.78525062757914155, 
4.4271705044632395], [5.1621777741880042, -2.3507294871497542, 1.9428540731124304, 
0.33801062491477385]]]])+(1.-msk_ref)*numpy.array([[[[1.0418590794461204, -5.5458287643508939, 0.49605699063090647, 
3.4563107645791931], [0.84316936880069182, -5.9806825651466227, -0.077097454591169345, 0.0038883500689692596], 
[3.3659292645968186, -4.0878867159520862, -2.4690433802700236, 3.8954345526769227]], [[-1.8402670124295923, -1.350842643547308, 
3.77066651935605, -1.4822406859648236], [2.0767554755731439, 2.8942085651699596, -3.2124132710719318, -5.3867290257477958], 
[-2.9687751747118094, 2.7128093919294134, -5.8779614603006216, -4.4438275300040484]]], [[[-2.6900799637738002, 
-4.3385272900740901, -0.26370407258470507, -2.6796199929073357], [2.3568467517517107, -4.0150817805777281, 
-0.87511981594777222, -4.9378517237462924], [0.1853928861247276, -3.3785593142122359, -4.2398072514624694, 
0.13545905454575191]], [[1.0268593655435865, 0.61912581258301991, 1.3657010307892286, -4.5469815026078972], 
[-1.9263713429518319, -3.607505648813456, -2.0035962349286578, 0.66814841134440428], [3.5997278128845664, -3.5039534998069994, 
-2.6524288219604295, -5.182406683143812]]], [[[1.4037237517231338, 1.7547702257144531, -3.7796447624367455, 
-3.9653597858810272], [-2.6823353586269825, -3.787335535909901, -1.1193425114777922, 0.30445097202929183], [-5.288018830168987, 
0.9571195792649636, -0.65676066698078106, 0.44572592070058725]], [[1.451426702093098, 2.8542663734407352, -1.5218683507520829, 
-0.97305714028874846], [3.2583974685724222, -5.0776619414596968, 2.2284163599682927, 1.2806544794296784], [-2.4579035981342763, 
0.34968879397977126, -1.2706149611971558, -0.21175284077974954]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank1_float_rank0(self):
      arg0=Data(numpy.array([0.77060031153569675, -1.3817994380303675]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([1.6634127860225503, -2.7078568290675706]))
      arg1=3.86062100315
      res=arg0+arg1
      ref=Data(numpy.array([4.6312213146824686, 2.4788215651164043]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([5.5240337891693221, 1.1527641740792012]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank1_array_rank0(self):
      arg0=Data(numpy.array([0.8330368484658992, -3.8536117424482876]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-2.3219104272463884, -0.16998894311123447]))
      arg1=numpy.array(-3.41743191676)
      res=arg0+arg1
      ref=Data(numpy.array([-2.5843950682962324, -7.2710436592104193]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-5.7393423440085201, -3.5874208598733661]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank1_array_rank1(self):
      arg0=Data(numpy.array([-0.82388051485507408, 2.114226584227139]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([4.453631118191856, -2.1394222743677727]))
      arg1=numpy.array([4.9078106479825809, -4.8863294229071252])
      res=arg0+arg1
      ref=Data(numpy.array([4.0839301331275069, -2.7721028386799862]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([9.3614417661744369, -7.0257516972748979]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank1_constData_rank0(self):
      arg0=Data(numpy.array([-3.6902347666151303, -0.58660523369265949]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-0.44136073280632893, 0.85453049881865795]))
      arg1=Data(-4.03256730928,self.functionspace)
      res=arg0+arg1
      ref=Data(numpy.array([-7.7228020758964639, -4.6191725429739936]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-4.473928042087663, -3.1780368104626762]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank1_constData_rank1(self):
      arg0=Data(numpy.array([-2.3236410413581385, 1.1424547463624464]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([1.7315293100419948, 2.9472023907502862]))
      arg1=Data(numpy.array([0.24526033511790857, -0.62856457346454153]),self.functionspace)
      res=arg0+arg1
      ref=Data(numpy.array([-2.07838070624023, 0.51389017289790484]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([1.9767896451599034, 2.3186378172857447]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank1_taggedData_rank0(self):
      arg0=Data(numpy.array([3.250804124545235, -4.7072533845050515]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([4.8151288535086021, 1.6749423702866508]))
      arg1=Data(-1.76802800894,self.functionspace)
      arg1.setTaggedValue(1,0.0791226334447)
      res=arg0+arg1
      ref=Data(numpy.array([1.482776115604735, -6.4752813934455515]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([4.8942514869532605, 1.7540650037313092]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank1_taggedData_rank1(self):
      arg0=Data(numpy.array([3.77276028340113, 4.1683610081694074]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-3.7893460722139438, 1.6567058129165879]))
      arg1=Data(numpy.array([-0.43505674793302695, 1.0770635472649905]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([-0.27397524975019394, 2.5332381590653208]))
      res=arg0+arg1
      ref=Data(numpy.array([3.3377035354681031, 5.2454245554343979]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-4.0633213219641373, 4.1899439719819087]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank1_expandedData_rank0(self):
      arg0=Data(numpy.array([-1.8155390835633369, -4.7505185696184622]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([1.4996755999113409, 2.3303341570595428]))
      arg1=Data(3.30044094165,self.functionspace)
      arg1.setTaggedValue(1,-0.696765436453)
      arg1.expand()
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([1.4849018580868396, -1.4500776279682857])+(1.-msk_ref)*numpy.array([0.80291016345810284, 
1.6335687206063048])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank1_expandedData_rank1(self):
      arg0=Data(numpy.array([-2.0881112217928557, 3.2182191824441464]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([3.9673343175705948, 3.6406271121742666]))
      arg1=Data(numpy.array([4.1668427726605373, 3.2532073033389075]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([1.1775322453437855, 4.813387928423996]))
      arg1.expand()
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([2.0787315508676816, 6.4714264857830539])+(1.-msk_ref)*numpy.array([5.1448665629143804, 
8.4540150405982626])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank2_float_rank0(self):
      arg0=Data(numpy.array([[1.386017414613514, -2.6231033049796491, 4.1399139685583908, -0.4757835738745344, 
-0.61334801364286129], [-3.8767016009847644, -1.6792352087895104, -0.95761952002154782, 1.1610341120860461, 
3.4637568772172447], [-1.7853768713915863, 0.35745707386269476, 3.7798020283050562, -3.9919450276392543, 3.1640627937763064], 
[2.9013425069641361, -2.8869815673409507, -4.312642079255081, -4.9524261759161403, -1.8116853894426921]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-2.5356642364263884, -3.0570803163456386, -4.6171329170636088, 1.9734766655043776, 
1.3166736709207738], [-1.7765368820484162, 3.9569210044414262, -1.9541458254032404, 2.5822803597859618, 2.4896901790436416], 
[3.3049498054625701, 0.76686506584124547, -2.6786032665790271, 2.6474811802420275, 3.3463506827302432], [-1.3139676283316692, 
-0.82038525203303791, -2.872733478437338, -0.12661190695077096, -2.8155829413606206]]))
      arg1=-0.216609625179
      res=arg0+arg1
      ref=Data(numpy.array([[1.1694077894347013, -2.8397129301584618, 3.923304343379578, -0.69239319905334717, 
-0.82995763882167406], [-4.0933112261635767, -1.8958448339683232, -1.1742291452003606, 0.94442448690723335, 
3.2471472520384319], [-2.0019864965703991, 0.14084744868388199, 3.5631924031262434, -4.2085546528180675, 2.9474531685974936], 
[2.6847328817853233, -3.1035911925197635, -4.5292517044338938, -5.1690358010949531, -2.0282950146215049]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-2.7522738616052012, -3.2736899415244514, -4.8337425422424216, 1.7568670403255648, 
1.100064045741961], [-1.993146507227229, 3.7403113792626135, -2.1707554505820532, 2.3656707346071491, 2.2730805538648289], 
[3.0883401802837573, 0.5502554406624327, -2.8952128917578399, 2.4308715550632147, 3.1297410575514304], [-1.530577253510482, 
-1.0369948772118507, -3.0893431036161507, -0.34322153212958373, -3.0321925665394334]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank2_array_rank0(self):
      arg0=Data(numpy.array([[2.4137267936710236, -1.7997061421593341, -4.3052651661982146, 1.422565293989992, 
1.3119752649866125], [-1.867490006105438, 3.4459978054658507, 3.3903338466998747, -2.7244221932931776, -4.9994433194947332], 
[2.887482695252567, -1.2425761277091008, 4.3966556575758293, -0.80645263643906517, -4.4144393270588109], [4.2850786693861949, 
1.6079208854026508, 1.5947218470081435, 3.5128021603521589, -4.2079688653726057]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[1.459759384010888, -1.9479503872148651, 3.5309699220761104, 3.0359150905241492, 
-3.1457670377866931], [1.3682366622215465, 0.50922176186034473, 0.95246664873011611, -1.6386073301391599, -1.9215088718744666], 
[-3.5382218714137545, 0.051369530298007504, 3.7079476159772717, 1.9237179458203642, -3.173801338946467], [0.74824107325503775, 
-0.86187078329955646, -4.0404653917936519, 1.9417938026751607, 3.0054838548030745]]))
      arg1=numpy.array(3.0741666769)
      res=arg0+arg1
      ref=Data(numpy.array([[5.4878934705717777, 1.27446053474142, -1.2310984892974606, 4.4967319708907461, 
4.3861419418873666], [1.206676670795316, 6.5201644823666047, 6.4645005236006288, 0.34974448360757648, -1.9252766425939791], 
[5.961649372153321, 1.8315905491916533, 7.4708223344765834, 2.2677140404616889, -1.3402726501580569], [7.3592453462869489, 
4.6820875623034048, 4.6688885239088975, 6.5869688372529129, -1.1338021884718517]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[4.5339260609116421, 1.1262162896858889, 6.6051365989768644, 6.1100817674249033, 
-0.071600360885939018], [4.4424033391223006, 3.5833884387610988, 4.0266333256308702, 1.4355593467615941, 1.1526578050262875], 
[-0.46405519451300048, 3.1255362071987616, 6.7821142928780258, 4.9978846227211182, -0.099634662045712918], [3.8224077501557918, 
2.2122958936011976, -0.96629871489289787, 5.0159604795759147, 6.0796505317038285]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank2_array_rank2(self):
      arg0=Data(numpy.array([[1.2506390651794561, -0.81212430724736251, 2.105991202484951, 4.8892117700344286, 
-0.0050442144267703881], [-3.8820044898664197, 1.3406927502362631, -0.23088072914886837, -0.38035879572400599, 
1.2942940423142701], [-4.5802823766916632, 0.49821714750866253, 4.2560215108958648, -4.6716137548953709, 1.0230637798676661], 
[-3.0502712063126713, -3.2098377736123842, 2.4503144503949628, 4.4188362288635155, -3.4130650656038961]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-0.58366893823899346, -0.30578291202832286, -0.70518265514781131, 
-4.5433921860219613, 4.4223880923402685], [-4.3895956831875038, -1.5410087563236963, 3.2510935557298453, -1.5749788082821792, 
0.83922854502163169], [0.010854086788042672, -4.9929781682524697, -3.0946822958514852, -4.8579683590423244, 
4.9755727587445708], [-4.4925003399736605, -1.6488568907328292, -4.9543455366941869, -4.9154233168876873, 1.9139071819041575]]))
      arg1=numpy.array([[-3.2676629202056806, -2.584733409576232, 4.5922217778649639, 0.24306513744928182, 1.7499931410105738], 
[3.5198734053410359, -4.2999142549125882, 2.8381096319323484, 4.2641555681844761, -4.0435985738597804], [-2.7255609991860164, 
-1.4958445671148599, 1.0485609110046656, -2.2929896081868817, -2.9438760379556816], [4.4201220490292439, 0.99062584324820335, 
1.7945690505804581, -1.1140220053731751, -0.021807228780941657]])
      res=arg0+arg1
      ref=Data(numpy.array([[-2.0170238550262245, -3.3968577168235945, 6.6982129803499149, 5.1322769074837105, 
1.7449489265838034], [-0.36213108452538378, -2.9592215046763251, 2.6072289027834801, 3.8837967724604701, -2.7493045315455102], 
[-7.3058433758776795, -0.99762741960619739, 5.3045824219005304, -6.9646033630822526, -1.9208122580880156], [1.3698508427165725, 
-2.2192119303641809, 4.2448835009754209, 3.3048142234903404, -3.4348722943848378]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-3.8513318584446741, -2.8905163216045549, 3.8870391227171526, -4.3003270485726794, 
6.1723812333508423], [-0.86972227784646794, -5.8409230112362849, 6.0892031876621937, 2.6891767599022969, -3.2043700288381487], 
[-2.7147069123979737, -6.4888227353673296, -2.0461213848468196, -7.1509579672292061, 2.0316967207888892], 
[-0.072378290944416612, -0.6582310474846258, -3.1597764861137287, -6.0294453222608624, 1.8920999531232159]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank2_constData_rank0(self):
      arg0=Data(numpy.array([[3.2502711739066772, 3.2753975916638893, 3.0532889358162603, 3.1034472492746978, 
0.052087591586211346], [0.3118677005964372, 4.1867697777823274, 4.9732669856910903, -2.8913821270923865, 4.3506736027981177], 
[-4.6860528744832539, -3.4816077401156855, -4.050480862180895, -3.0253108061921274, 4.3701610891655633], [-1.8781144439384989, 
-3.2927924838989853, 0.13729260877135019, -2.6590842182483412, -3.8264934109034687]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-2.5126373635568386, -4.0203532509495528, 1.9451568388068647, 2.4982439625427251, 
2.9930450949074183], [-2.5812279189579614, -3.749322717853306, 4.4612126484341932, 1.3961025240678806, -3.8192483460549722], 
[-4.9184023616989752, -1.884407900259506, 3.2580704584995797, 2.0881656141612464, 3.1255171708748826], [-2.5882910223927782, 
4.0479258279003485, 4.5180373392458577, 0.89432107783419745, 2.5875919720936968]]))
      arg1=Data(-1.32485890265,self.functionspace)
      res=arg0+arg1
      ref=Data(numpy.array([[1.9254122712609725, 1.9505386890181846, 1.7284300331705555, 1.7785883466289931, 
-1.2727713110594934], [-1.0129912020492675, 2.8619108751366227, 3.6484080830453856, -4.2162410297380912, 3.0258147001524129], 
[-6.0109117771289586, -4.8064666427613902, -5.3753397648265997, -4.3501697088378322, 3.0453021865198586], [-3.2029733465842036, 
-4.61765138654469, -1.1875662938743545, -3.9839431208940459, -5.1513523135491734]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-3.8374962662025434, -5.3452121535952575, 0.62029793616116002, 1.1733850598970204, 
1.6681861922617136], [-3.9060868216036662, -5.0741816204990107, 3.1363537457884885, 0.071243621422175885, -5.1441072487006769], 
[-6.2432612643446799, -3.2092668029052107, 1.9332115558538749, 0.76330671151554164, 1.8006582682291778], [-3.9131499250384829, 
2.7230669252546438, 3.193178436600153, -0.43053782481150726, 1.2627330694479921]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank2_constData_rank2(self):
      arg0=Data(numpy.array([[4.4929441538499244, 0.76193006655289963, -3.6013136757956854, 3.5435545395461094, 
4.6801677558118886], [-0.50863290555282781, -4.9812485221410361, 4.8716203583858455, -0.15520714654011591, 3.452894058218277], 
[-2.7745470074273104, 1.3053804084041101, -0.64948784175483443, 4.3919626388781534, -2.0707892516302664], [0.87150750288468792, 
1.7804985374774942, 2.3087331960876654, -1.9056365362023397, 0.51051839622696082]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-3.1324888331494991, -3.5699394355850878, -3.0678800115448732, -0.3644669804906151, 
-3.9828541815822427], [-2.6636704756502603, 0.06436393161746512, -1.7408779765126727, 0.91575332404404364, 
0.91622940428564892], [4.4774322156401869, -2.7257448457653934, 3.4237112377253567, -3.0344203953362312, -3.0359056845343702], 
[-4.0585903966166175, 2.9772620147258335, 3.8956599105893766, 3.8436466421257407, -2.4231294458602815]]))
      arg1=Data(numpy.array([[-4.6808035192748845, 0.41480396326348057, 2.5020316812530554, -0.65741734172914068, 
4.6963871561039721], [0.18380341233428688, 2.5396208452698055, -1.2543606017962086, -2.0770288834594339, 1.0772324852437016], 
[-1.4521523688895757, -3.4076521920397829, -1.5600849021061594, -4.1373563737852281, 2.2625941689331288], [1.5040586623691752, 
0.81395372076508465, 1.9361886507462316, -4.118885441779403, 0.221244016978277]]),self.functionspace)
      res=arg0+arg1
      ref=Data(numpy.array([[-0.18785936542496007, 1.1767340298163802, -1.09928199454263, 2.8861371978169688, 
9.3765549119158607], [-0.32482949321854093, -2.4416276768712306, 3.6172597565896369, -2.2322360299995498, 4.5301265434619786], 
[-4.2266993763168861, -2.1022717836356728, -2.2095727438609938, 0.25460626509292528, 0.19180491730286242], [2.3755661652538631, 
2.5944522582425789, 4.244921846833897, -6.0245219779817427, 0.73176241320523783]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-7.8132923524243836, -3.1551354723216072, -0.5658483302918178, -1.0218843222197558, 
0.71353297452172937], [-2.4798670633159734, 2.6039847768872706, -2.9952385783088813, -1.1612755594153903, 1.9934618895293506], 
[3.0252798467506112, -6.1333970378051763, 1.8636263356191973, -7.1717767691214593, -0.77331151560124134], [-2.5545317342474423, 
3.7912157354909182, 5.8318485613356081, -0.27523879965366227, -2.2018854288820044]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank2_taggedData_rank0(self):
      arg0=Data(numpy.array([[-1.5969664428610941, -3.2419841195939281, -2.9076578064597189, -2.663828637524861, 
-0.49007057704686918], [-0.73550009313364662, 2.4813542932190549, -2.4501659858142699, 2.9561483677548086, 
-1.5272511879848425], [-1.2709683653380441, -4.43899272012131, -3.5574532003475969, 2.4970287876685493, 0.4238165463937662], 
[1.3508619199672944, -1.2951957666490319, 1.9550173863352462, 2.1322019832699501, 3.280542130798235]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[4.6589854912149171, 1.5511453854096926, 4.965722583293072, 0.40914248208395421, 
3.1262650987087408], [1.8333709579258421, -1.0804912813756076, -2.4738467577704073, 4.6775561610173995, -1.4554092041385038], 
[-4.235651383182538, -1.51389228517673, 4.7363198261615729, -3.8384727366907931, -1.1276673590418538], [-4.5417407083761097, 
2.4944134708644761, 3.1122535744006861, -4.7532602042912266, -0.70506740860247952]]))
      arg1=Data(4.06929400439,self.functionspace)
      arg1.setTaggedValue(1,-1.27259899399)
      res=arg0+arg1
      ref=Data(numpy.array([[2.472327561531205, 0.82730988479837109, 1.1616361979325802, 1.4054653668674382, 3.57922342734543], 
[3.3337939112586525, 6.550648297611354, 1.6191280185780292, 7.0254423721471078, 2.5420428164074567], [2.798325639054255, 
-0.36969871572901081, 0.51184080404470222, 6.5663227920608485, 4.4931105507860654], [5.4201559243595936, 2.7740982377432672, 
6.0243113907275454, 6.2014959876622493, 7.3498361351905341]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[3.386386497222615, 0.27854639141739046, 3.6931235893007699, -0.86345651190834793, 
1.8536661047164387], [0.56077196393354001, -2.3530902753679097, -3.7464457517627094, 3.4049571670250973, -2.728008198130806], 
[-5.5082503771748401, -2.7864912791690322, 3.4637208321692707, -5.1110717306830953, -2.4002663530341559], [-5.8143397023684118, 
1.2218144768721739, 1.8396545804083839, -6.0258591982835288, -1.9776664025947817]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank2_taggedData_rank2(self):
      arg0=Data(numpy.array([[-2.7360673699569205, 1.2813661236117664, 2.6181299621874201, -4.5835559155379793, 
-0.59706551109364803], [-2.1154300756810418, 2.4637685424667488, 0.63920743759821086, -1.0304928260655464, 
-3.0388241860196241], [-4.1804742653319753, 0.6265873235154098, 4.1438730590828747, 1.849159394466878, 3.6496665209304968], 
[2.8275694342930962, -4.9054452894236142, 2.5745677599446983, 4.3161246638088855, 4.5501700481233502]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-2.7236826094989421, -0.88947616716594524, -4.4642382826987994, 0.17930131398277283, 
1.0115273959196971], [3.9769705807623996, -0.074299515250104697, 4.1143692155325695, 2.2366876970030658, -2.3250367186365315], 
[-1.4454031669851197, -4.4238920625528246, -2.4576577266829713, 3.4261333775559635, 4.4134638287533328], [-3.1326412064023601, 
0.79829173838552148, 2.1440271770141326, -0.53338236178293474, -0.86557615032601642]]))
      arg1=Data(numpy.array([[-0.34303101101440525, -3.0437444667922242, 1.7963357003006442, 4.641240443255148, 
2.3121754708917299], [0.24577874602811445, -3.4121443132010674, -2.4780610072246922, 3.2029389228011116, -2.6107739248212125], 
[-0.80894957852706195, 1.685116172854749, 0.98006258074479735, -1.5668088640997455, 4.5294248564398192], [4.5451471347708114, 
-2.3164981697303144, 2.4194654332001155, 4.12271616233609, 2.5345931657528089]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[0.13923134421935401, -2.093025836240745, 0.2383924930725172, 1.9334391571212448, 
-2.0297150413850664], [0.58917596374259418, 1.5141919749518173, -1.742979285515859, 2.2212871451907557, -2.3728597502891411], 
[-2.1854792436148793, 1.2704115116701509, -3.5210504563312295, -2.5225278742388313, 0.48400984500320376], [1.5022249811374566, 
3.7240252724976308, -2.3046587086938422, -3.1465250919681012, 1.1149804764495732]]))
      res=arg0+arg1
      ref=Data(numpy.array([[-3.0790983809713257, -1.7623783431804578, 4.4144656624880643, 0.057684527717168699, 
1.7151099597980819], [-1.8696513296529274, -0.94837577073431856, -1.8388535696264814, 2.1724460967355652, -5.6495981108408362], 
[-4.9894238438590373, 2.3117034963701588, 5.1239356398276721, 0.28235053036713254, 8.179091377370316], [7.3727165690639076, 
-7.2219434591539287, 4.9940331931448139, 8.4388408261449754, 7.0847632138761591]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-2.5844512652795881, -2.9825020034066902, -4.2258457896262822, 2.1127404711040176, 
-1.0181876454653693], [4.5661465445049938, 1.4398924597017126, 2.3713899300167105, 4.4579748421938215, -4.6978964689256726], 
[-3.6308824105999991, -3.1534805508826738, -5.9787081830142004, 0.90360550331713219, 4.8974736737565365], [-1.6304162252649035, 
4.5223170108831523, -0.16063153167970956, -3.6799074537510359, 0.24940432612355679]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank2_expandedData_rank0(self):
      arg0=Data(numpy.array([[3.3576395108597357, 0.079713165091237492, -2.6235923382139359, -2.4807258180332816, 
-4.8370100240939191], [-0.5398609461216104, 1.880841302085507, 3.1363957779485592, -2.9098856610703172, -4.6277814188713133], 
[-3.0338075061550054, 3.1245825256445681, -1.4594132431522064, -1.459261449706891, 1.1852708370783631], [4.9187832984000064, 
3.9954625802675601, 0.87526688509385853, 0.077022043938886675, -3.827320331241737]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[0.90743867327562278, -0.37083095320971715, -4.4522087231605321, 
-0.082706136946488762, 0.53865736074087245], [-1.247002155185152, -1.8859527986403943, -1.4542237645525455, 
-4.2286317889507465, 3.9126875182879424], [3.3235710528580977, 2.8887880357286093, -2.7944378032785555, -1.8479879876981586, 
-0.59871595592754723], [3.9369222314456351, -0.13778647296883584, 4.2599185492697718, -2.096145057917572, 
-1.3163660993963342]]))
      arg1=Data(2.09640121669,self.functionspace)
      arg1.setTaggedValue(1,3.46900141878)
      arg1.expand()
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[5.4540407275500078, 2.1761143817815096, -0.52719112152366376, -0.3843246013430095, 
-2.740608807403647], [1.5565402705686617, 3.9772425187757792, 5.2327969946388313, -0.81348444438004508, -2.5313802021810412], 
[-0.93740628946473326, 5.2209837423348402, 0.63698797353806569, 0.63713976698338115, 3.2816720537686352], [7.0151845150902785, 
6.0918637969578322, 2.9716681017841307, 2.1734232606291588, 
-1.7309191145514649]])+(1.-msk_ref)*numpy.array([[4.3764400920563293, 3.0981704655709894, -0.98320730437982551, 
3.3862952818342178, 4.007658779521579], [2.2219992635955546, 1.5830486201403122, 2.014777654228161, -0.75963037017003998, 
7.3816889370686489], [6.7925724716388043, 6.3577894545093159, 0.67456361550215105, 1.6210134310825479, 2.8702854628531593], 
[7.4059236502263417, 3.3312149458118707, 7.7289199680504783, 1.3728563608631346, 2.1526353193843724]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank2_expandedData_rank2(self):
      arg0=Data(numpy.array([[-4.1064984952518904, -2.5817913277651172, 1.070919986237393, -1.9117883202469499, 
2.5967941151396978], [2.7118184129118648, 4.2744441954963239, 2.5256592712367727, 4.3910740288571368, -0.81749389358698643], 
[3.8318241411112126, -4.1533353343123878, -3.4061675616762876, -3.2448939320059655, -1.610901735482928], [3.2338835693575607, 
-0.31809141540401686, -4.7534320077399776, -1.2412351366339225, 0.6532662566750318]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-0.40824575124749529, -1.1397163699023203, 4.3190911430696115, 4.6534260983827291, 
-4.3545886555451307], [-1.5915630931214961, 1.8930546282940952, 0.2688051310628321, -0.47170297113425885, -4.3407392420432416], 
[3.6309440228956191, -2.9357231326721989, -0.1783352163025862, -0.57435606905517922, -0.43100972576898045], 
[2.3487562956081289, -3.1045804777101704, 3.4505268527573953, -0.61355607556301095, 3.168156501374618]]))
      arg1=Data(numpy.array([[2.4607689719589088, -0.99212543029652789, -4.851919296706444, 1.0162795867954477, 
4.466136877963427], [3.9784857577676753, -4.3613136494122271, 0.74369268877859085, 2.3950886713274544, -4.9923265580599585], 
[-0.56506422921060384, -3.0930047243706591, 2.5908424730857584, 4.5603160077698419, 2.423946547489491], [-0.93743775047951594, 
-0.3673394818316309, -2.7773248295488195, 1.798394956797825, 1.8256162509613905]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[-4.5533463764192907, -2.5680501286088098, -2.1595429923626455, -2.7191228050860241, 
-2.7088788101250261], [3.7258720533049789, 1.284927684183641, -1.1675681000724514, 0.69945198751573212, -4.9965536747752903], 
[-2.522137040044564, -3.5846235768258961, 4.2167459240643232, -3.2345633958568532, -3.1123818128654279], [-1.5173196493114371, 
4.2228271484661324, -0.97650304976789037, 4.2862261537218433, 2.4227338308583484]]))
      arg1.expand()
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-1.6457295232929816, -3.5739167580616451, -3.7809993104690509, -0.89550873345150217, 
7.0629309931031248], [6.6903041706795401, -0.086869453915903172, 3.2693519600153635, 6.7861627001845912, -5.8098204516469449], 
[3.2667599119006088, -7.2463400586830469, -0.81532508859052921, 1.3154220757638764, 0.81304481200656298], [2.2964458188780448, 
-0.68543089723564776, -7.5307568372887967, 0.55715982016390253, 
2.4788825076364223]])+(1.-msk_ref)*numpy.array([[-4.961592127666786, -3.70776649851113, 2.159548150706966, 1.934303293296705, 
-7.0634674656701568], [2.1343089601834828, 3.1779823124777362, -0.89876296900961927, 0.22774901638147327, -9.3372929168185319], 
[1.1088069828510552, -6.5203467094980949, 4.0384107077617371, -3.8089194649120324, -3.5433915386344084], [0.83143664629669178, 
1.118246670755962, 2.474023802989505, 3.6726700781588324, 5.5908903322329664]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank3_float_rank0(self):
      arg0=Data(numpy.array([[[-1.2997878184398806, -1.2757776752263328], [-0.65735390665819349, -0.15144535875971332]], 
[[-1.8284156635868642, 3.9061628403768758], [1.0946776903405722, -1.4680134418913218]], [[-0.12619686336832103, 
-0.900530098453034], [-4.0957109781348606, -1.2811650332192626]], [[-3.3769583942459755, 1.1610757349701473], 
[-2.2121718663533327, 0.22865265651723199]], [[-3.9930636796669425, -2.3455436184607481], [-1.2328786986274709, 
-2.9643499384056069]], [[0.65263245468386089, 4.8724244596949013], [4.3333122178432699, 
-4.8825328594467896]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-1.2720075505394899, -1.7304994593212895], [2.1606764296864265, 
1.2437847274545586]], [[2.8635205231903837, -3.5966141698322729], [0.98503937600877123, 3.9749742799690289]], 
[[1.0901011372250924, -4.6495372464590021], [-3.1258189450265226, 2.8715761147792565]], [[4.417553202393071, 
-1.057695667510834], [4.6763256344107678, 1.3550277772429284]], [[1.2148338989634366, 1.671510325227513], [-1.8038190400917009, 
3.0780814772040532]], [[1.6741066406160163, 3.9250458753936961], [0.82880372228847676, 1.213470068514809]]]))
      arg1=-1.55127288174
      res=arg0+arg1
      ref=Data(numpy.array([[[-2.8510607001811232, -2.8270505569675755], [-2.2086267883994362, -1.702718240500956]], 
[[-3.3796885453281069, 2.3548899586356331], [-0.45659519140067051, -3.0192863236325644]], [[-1.6774697451095637, 
-2.4518029801942767], [-5.6469838598761033, -2.8324379149605052]], [[-4.9282312759872182, -0.3901971467710954], 
[-3.7634447480945754, -1.3226202252240107]], [[-5.5443365614081852, -3.8968165002019908], [-2.7841515803687136, 
-4.5156228201468496]], [[-0.89864042705738179, 3.3211515779536587], [2.7820393361020272, 
-6.4338057411880323]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-2.8232804322807326, -3.2817723410625321], [0.60940354794518381, 
-0.30748815428668408]], [[1.3122476414491411, -5.147887051573516], [-0.56623350573247144, 2.4237013982277862]], 
[[-0.46117174451615028, -6.2008101282002448], [-4.6770918267677652, 1.3203032330380138]], [[2.8662803206518284, 
-2.6089685492520767], [3.1250527526695251, -0.19624510449831423]], [[-0.33643898277780604, 0.1202374434862703], 
[-3.3550919218329436, 1.5268085954628106]], [[0.12283375887477366, 2.3737729936524534], [-0.72246915945276591, 
-0.33780281322643368]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank3_array_rank0(self):
      arg0=Data(numpy.array([[[2.4427920649917194, 2.80217002888058], [-4.3925867488504515, 3.5898352354801837]], 
[[0.81567382374813402, -4.8665560856352119], [-4.1561296525194589, 1.5306689879249333]], [[-1.9015553918776495, 
1.1522594478647292], [3.7040048522405051, 3.8976929980497523]], [[-0.82497889582516226, -2.6736276545664159], 
[-1.2814412837197442, -3.035891431715779]], [[2.4520443258674876, -0.15207139022792493], [2.8256275406494966, 
0.22466824419197806]], [[1.0590111629700436, 4.9794941950448806], [-3.2362531545901363, 
-4.7347310059144707]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-0.63728168544871711, 4.2451706888736442], [-3.5110777047073647, 
0.76629595651110183]], [[2.3489491111837886, 1.0215957806707827], [-3.459269509284153, -1.1952162872723617]], 
[[3.4315918746214429, -1.5013203994548352], [1.1160231840663934, 2.4567420615775895]], [[2.6513553422863412, 
-4.5382970231648443], [3.6512015372741828, 2.5341634160287088]], [[1.1959413388746052, 3.9743703993780688], 
[-3.4989354736232969, -2.8155121097950198]], [[2.8809398518858966, -4.6999882891913298], [-3.3336277982940343, 
-3.1929419534633263]]]))
      arg1=numpy.array(-1.63203584107)
      res=arg0+arg1
      ref=Data(numpy.array([[[0.8107562239205417, 1.1701341878094023], [-6.0246225899216288, 1.957799394409006]], 
[[-0.8163620173230437, -6.4985919267063892], [-5.7881654935906361, -0.10136685314624438]], [[-3.5335912329488273, 
-0.47977639320644849], [2.0719690111693274, 2.2656571569785746]], [[-2.45701473689634, -4.3056634956375941], 
[-2.9134771247909219, -4.6679272727869563]], [[0.82000848479630983, -1.7841072312991026], [1.1935916995783189, 
-1.4073675968791997]], [[-0.57302467810113411, 3.3474583539737028], [-4.868288995661314, 
-6.366766846985648]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-2.2693175265198948, 2.6131348478024665], [-5.143113545778542, 
-0.86573988456007589]], [[0.71691327011261086, -0.610440060400395], [-5.0913053503553307, -2.8272521283435395]], 
[[1.7995560335502652, -3.1333562405260129], [-0.51601265700478427, 0.82470622050641174]], [[1.0193195012151635, 
-6.1703328642360216], [2.0191656962030051, 0.90212757495753104]], [[-0.43609450219657253, 2.3423345583068911], 
[-5.1309713146944746, -4.4475479508661975]], [[1.2489040108147189, -6.3320241302625071], [-4.9656636393652125, 
-4.8249777945345045]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank3_array_rank3(self):
      arg0=Data(numpy.array([[[0.31917310763958895, -3.5515451495799621], [-3.718971091595936, 1.5386433092095917]], 
[[2.3357357923776609, 4.5645794968830931], [2.1186400866631914, -0.51755282637387801]], [[-1.1071675171380324, 
2.8068684530417958], [0.94189546205659624, 1.1910362805300565]], [[3.4468679467165924, 1.006131044842288], 
[-3.5462192516382252, -0.41561960499380568]], [[-2.0651391129052921, -3.8762786749366498], [0.44047838236076586, 
4.0704313697496808]], [[3.0083402167960127, 4.3879696887221318], [1.9259203465021359, 
-4.9981755932897869]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-0.77637009857172856, 0.94781626387318152], [4.4914773288916585, 
-1.8241112102418677]], [[4.9952740743939135, -0.47141930443296687], [1.1478215759652564, 1.9029209110237204]], 
[[2.8078916833095899, -2.0842274466071684], [1.1783007597484243, -1.1498187669628592]], [[-1.4196212623658075, 
-4.2820956196071265], [3.337409137923963, 1.6177366753773903]], [[2.7756440510587899, -3.382984690251555], 
[-4.1798305502190969, -2.6150479858595341]], [[3.5217312097872604, 4.1836069146853205], [-0.52039453105849365, 
1.6466546455411146]]]))
      arg1=numpy.array([[[1.3469197096068548, 4.3476759743611808], [-2.9491253550464416, 0.1297037958924534]], 
[[-4.4172410740793886, 1.1568230611126129], [-1.8137906109459601, 4.8447805060491191]], [[2.3601993829840584, 
3.7374735496880582], [4.528666004046606, -1.2474994690367525]], [[2.1247834581673173, -3.0630841688534929], 
[3.0851375677735771, -3.1251781301121651]], [[1.7649956230261266, 2.467546423340039], [2.8342627622713215, 
0.48744502296701953]], [[-3.5213033924689761, 4.6465127879738155], [2.2018400068809747, -3.9708346903513734]]])
      res=arg0+arg1
      ref=Data(numpy.array([[[1.6660928172464438, 0.79613082478121866], [-6.6680964466423776, 1.6683471051020451]], 
[[-2.0815052817017277, 5.721402557995706], [0.30484947571723131, 4.3272276796752411]], [[1.253031865846026, 6.544342002729854], 
[5.4705614661032023, -0.05646318850669596]], [[5.5716514048839096, -2.0569531240112049], [-0.4610816838646481, 
-3.5407977351059707]], [[-0.3001434898791655, -1.4087322515966108], [3.2747411446320873, 4.5578763927167003]], 
[[-0.51296317567296335, 9.0344824766959473], [4.1277603533831106, -8.9690102836411612]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[0.57054961103512625, 5.2954922382343623], [1.5423519738452169, -1.6944074143494143]], 
[[0.57803300031452487, 0.68540375667964604], [-0.6659690349807037, 6.7477014170728395]], [[5.1680910662936483, 
1.6532461030808898], [5.7069667637950303, -2.3973182359996117]], [[0.70516219580150974, -7.3451797884606194], 
[6.42254670569754, -1.5074414547347748]], [[4.5406396740849164, -0.91543826691151597], [-1.3455677879477754, 
-2.1276029628925146]], [[0.00042781731828434033, 8.830119702659136], [1.6814454758224811, -2.3241800448102587]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank3_constData_rank0(self):
      arg0=Data(numpy.array([[[-2.8210454777698404, -3.4217707115382625], [2.1171931397381574, 2.6950906491858699]], 
[[4.4063672073366149, -4.1150624825312665], [-0.20619185189900513, 3.6298688570246167]], [[-0.5123674843738435, 
-1.2876695824800102], [-3.4007350435993313, -1.7224417342800757]], [[-1.2022562263835326, -3.0205104949494963], 
[1.0804079954631698, 1.6798514610394264]], [[-3.9750150243167512, -3.6717642006321203], [-1.0074759955485932, 
-0.0027274770069656284]], [[-0.50402170304039373, -0.82562381306776178], [0.017163887092507046, 
0.24298818691586277]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[0.52779485824058359, -4.9422201372698114], [-0.58929488689681797, 
-1.9977706922011604]], [[3.725646291123466, 0.66681409512529299], [1.4886149904608637, -1.0996317910519684]], 
[[3.3456204986696285, -1.5747030524647441], [0.10490442714460979, 4.2301071863566282]], [[4.0344462421951235, 
-1.4476621231960007], [3.1870510385249133, -3.2366025935356202]], [[4.0806287044527245, -1.6326612932604965], 
[-3.7889698613359912, -4.4314145203076825]], [[-2.5133034554522649, -3.4737658986451123], [2.0813742995032589, 
-4.8764170297129343]]]))
      arg1=Data(2.73803499699,self.functionspace)
      res=arg0+arg1
      ref=Data(numpy.array([[[-0.083010480779381446, -0.68373571454780357], [4.8552281367286163, 5.4331256461763289]], 
[[7.1444022043270738, -1.3770274855408076], [2.5318431450914538, 6.3679038540150756]], [[2.2256675126166154, 
1.4503654145104488], [-0.66270004660887238, 1.0155932627103832]], [[1.5357787706069264, -0.28247549795903737], 
[3.8184429924536287, 4.4178864580298853]], [[-1.2369800273262923, -0.93372920364166134], [1.7305590014418657, 
2.7353075199834933]], [[2.2340132939500652, 1.9124111839226972], [2.755198884082966, 2.9810231839063217]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[3.2658298552310425, -2.2041851402793524], [2.148740110093641, 0.7402643047892985]], 
[[6.4636812881139249, 3.4048490921157519], [4.2266499874513226, 1.6384032059384905]], [[6.0836554956600875, 
1.1633319445257149], [2.8429394241350687, 6.9681421833470871]], [[6.7724812391855824, 1.2903728737944582], [5.9250860355153723, 
-0.49856759654516125]], [[6.8186637014431835, 1.1053737037299625], [-1.0509348643455323, -1.6933795233172235]], 
[[0.22473154153819408, -0.73573090165465338], [4.8194092964937179, -2.1383820327224754]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank3_constData_rank3(self):
      arg0=Data(numpy.array([[[-0.47096700853224327, -1.9522286296005733], [-1.0658047271834858, -3.4096964985517975]], 
[[0.96949518882925378, 1.6475269299751059], [-0.62090212768980102, 2.3702548578783418]], [[1.1612999891474374, 
0.72067991486352589], [-2.1597864609168926, 3.7014615272065594]], [[-4.6650533012636757, -0.72559395941643068], 
[1.7091966692212166, -4.3919239471813709]], [[-0.59417459256082061, 1.0243089267292333], [-1.6973527467734693, 
0.29098597486111366]], [[0.54197662904973853, -1.6867380691844036], [1.6548783566133993, 
0.28778280143183199]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-1.8748672080092965, 4.3617879277745804], [1.9081086899666211, 
-3.4258603348943284]], [[3.1528090589516733, -4.2885134261580218], [4.1159665261035343, 4.1530718731948149]], 
[[0.81108614452451544, -3.9712442140485669], [4.64723189223443, -2.7753268821800638]], [[-0.88602857435270721, 
4.8742258990691809], [1.7280166668429864, 3.7191126262019782]], [[-2.5529612680445735, -4.3162019941407106], 
[-1.7065042564276132, 1.6649865182845183]], [[3.1076813152331368, -0.47645773433606298], [-4.834709528117072, 
-3.0732299970931196]]]))
      arg1=Data(numpy.array([[[0.38081686149340932, -0.12561401029626662], [-0.47267367652429826, 0.85723849547148046]], 
[[-4.2277778979663214, 0.29910480673373918], [4.059679115529768, -1.5899700933256398]], [[3.7286730317778058, 
0.019079665982769001], [0.65683454127360541, -4.6363980749491844]], [[-2.0410322297090779, 1.00239030504056], 
[-2.8483396779950967, -2.9681138872934665]], [[-4.7675870663356834, -1.301532912831973], [-0.5015722378248082, 
4.247977439406128]], [[4.5670566525874463, 0.91288837003611434], [-3.7080840440083698, 
2.0202635489539622]]]),self.functionspace)
      res=arg0+arg1
      ref=Data(numpy.array([[[-0.09015014703883395, -2.0778426398968399], [-1.5384784037077841, -2.552458003080317]], 
[[-3.2582827091370676, 1.946631736708845], [3.438776987839967, 0.78028476455270201]], [[4.8899730209252432, 
0.7397595808462949], [-1.5029519196432872, -0.93493654774262502]], [[-6.7060855309727536, 0.27679634562412936], 
[-1.1391430087738801, -7.3600378344748378]], [[-5.361761658896504, -0.27722398610273968], [-2.1989249845982775, 
4.5389634142672417]], [[5.1090332816371848, -0.77384969914828927], [-2.0532056873949704, 
2.3080463503857942]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-1.4940503465158872, 4.2361739174783137], [1.4354350134423228, -2.5686218394228479]], 
[[-1.0749688390146481, -3.9894086194242826], [8.1756456416333023, 2.5631017798691751]], [[4.5397591763023213, 
-3.9521645480657979], [5.3040664335080354, -7.4117249571292483]], [[-2.9270608040617851, 5.8766162041097409], 
[-1.1203230111521103, 0.75099873890851176]], [[-7.3205483343802573, -5.6177349069726841], [-2.2080764942524214, 
5.9129639576906463]], [[7.6747379678205832, 0.43643063570005136], [-8.5427935721254418, -1.0529664481391574]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank3_taggedData_rank0(self):
      arg0=Data(numpy.array([[[-2.77213374577719, 3.8175247853740437], [-4.3578721765707087, 3.0005484157113713]], 
[[-4.6386603451262696, -3.8563761317763499], [-1.4852241554726362, 0.38857004951119656]], [[2.9222332691377826, 
1.6923051930588748], [0.30085877388243087, 2.1522074406521785]], [[-3.4464086791036941, -0.63552745300504654], 
[-4.8700187583105752, -4.5753181764286532]], [[0.65918512755418668, -0.38289184193305914], [-1.3338342635044609, 
-3.0717881242821266]], [[-0.39784573416263669, 2.7401013994849812], [1.6971148789255555, 
-1.1822905596970621]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[1.8943785565648668, -2.4747326244629173], [-0.23157835576301, -2.1863096808838058]], 
[[3.084915267753491, -3.8041276142005644], [-3.7077539164197248, -2.2281312895796801]], [[-3.5271540745576244, 
-0.30969872820660171], [4.3522864510595376, 1.3338960268806357]], [[0.65947508204485317, 1.9330005623286706], 
[-1.0132685477999583, -0.66208052775642923]], [[-4.7530716871765497, -0.76936405181359646], [-3.444003775274076, 
-4.4656040487057735]], [[0.383854720217645, -4.3199032543230329], [0.98492701990625786, 2.8611845972002117]]]))
      arg1=Data(1.08370007113,self.functionspace)
      arg1.setTaggedValue(1,-1.61546335612)
      res=arg0+arg1
      ref=Data(numpy.array([[[-1.6884336746471669, 4.9012248565040668], [-3.2741721054406856, 4.0842484868413944]], 
[[-3.5549602739962465, -2.7726760606463268], [-0.40152408434261311, 1.4722701206412196]], [[4.0059333402678057, 
2.7760052641888979], [1.384558845012454, 3.2359075117822016]], [[-2.362708607973671, 0.44817261812497655], 
[-3.7863186871805521, -3.4916181052986301]], [[1.7428851986842098, 0.70080822919696395], [-0.25013419237443779, 
-1.9880880531521035]], [[0.6858543369673864, 3.8238014706150043], [2.7808149500555785, 
-0.098590488567039003]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[0.27891520044604867, -4.0901959805817354], [-1.8470417118818281, 
-3.8017730370026239]], [[1.4694519116346729, -5.4195909703193825], [-5.3232172725385425, -3.8435946456984982]], 
[[-5.1426174306764425, -1.9251620843254198], [2.7368230949407195, -0.2815673292381824]], [[-0.95598827407396492, 
0.31753720620985249], [-2.6287319039187764, -2.2775438838752473]], [[-6.3685350432953678, -2.3848274079324145], 
[-5.0594671313928945, -6.0810674048245916]], [[-1.2316086359011731, -5.935366610441851], [-0.63053633621256022, 
1.2457212410813936]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank3_taggedData_rank3(self):
      arg0=Data(numpy.array([[[3.0999704341790579, -2.1368850512830209], [-4.1614101762320432, -0.28811741134597924]], 
[[-3.036719027857866, 1.9451406831243423], [4.5539526177848426, -3.4072595450593415]], [[1.8259798226800594, 
-3.8017735745557646], [-4.7269662575423084, -4.1499666999210501]], [[1.7934785241410642, -4.6873007226520453], 
[2.3569452131701496, -2.9689095593087433]], [[-2.7425902126600654, -3.4952895783077773], [0.22564261641125327, 
3.5916579754992668]], [[-4.5128373012219161, -2.2233808100865504], [-4.5956375124314857, 
-1.4657958530898529]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[2.1961737709455766, 4.5561492238051997], [1.3323004328555212, 2.5760714767847857]], 
[[3.7761790525397583, -3.2598311484246754], [-3.4866875984314727, -3.7474259334034321]], [[3.1210107314646081, 
2.3762836994400951], [3.0966860416753264, -1.9773787652223018]], [[-1.0741225554644593, -1.3214351024114102], 
[-4.5798839978418195, 1.7205169612568403]], [[-1.3160891100365379, 4.8106693608424909], [2.0146140171185811, 
-0.37205085081784883]], [[-3.7863403761557723, 4.2179799987051538], [2.4737687017551107, -4.3943704465839319]]]))
      arg1=Data(numpy.array([[[3.7930028184928855, 0.74521751208453857], [4.4847095846025393, -1.7830762197802699]], 
[[-2.5057973764886055, -2.9563522299729317], [2.7529593815263258, 0.48292843407461739]], [[-3.0458552313152545, 
4.2713334489390178], [-4.9127772710577853, 3.1175552007676774]], [[-0.2743949745927079, -3.3774907685127999], 
[-0.89006146507890449, -3.0975301132793378]], [[-0.82350018133067504, -4.2749920154045284], [-2.0284520439069418, 
3.2413268838608218]], [[1.1253521343375859, 4.3890827253584401], [-3.3978743559562128, 
-3.5124546051556194]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[-2.3628721681361862, 3.8974683231077023], [0.76235716341701032, 
2.5412583826555233]], [[-2.773278329515807, 3.4959019739944672], [2.6845044210467686, -4.9074297296405778]], 
[[-1.2434917807453951, -3.0537165935820787], [-1.5874774764708919, 0.3750357775252251]], [[-0.77245416605846717, 
-4.2340919743151426], [-0.017802906555869136, -2.1823946035944806]], [[3.6542664252022519, -1.1250262117533127], 
[-4.9641003807321615, -3.4471856385372202]], [[4.2428404046751709, 0.1351522794648643], [-0.82248359553912831, 
2.5308594813065657]]]))
      res=arg0+arg1
      ref=Data(numpy.array([[[6.8929732526719434, -1.3916675391984823], [0.32329940837049609, -2.0711936311262491]], 
[[-5.5425164043464719, -1.0112115468485894], [7.3069119993111684, -2.9243311109847241]], [[-1.2198754086351951, 
0.4695598743832532], [-9.6397435286000928, -1.0324114991533726]], [[1.5190835495483563, -8.0647914911648453], 
[1.4668837480912451, -6.0664396725880811]], [[-3.5660903939907405, -7.7702815937123058], [-1.8028094274956885, 
6.8329848593600886]], [[-3.3874851668843302, 2.1657019152718897], [-7.9935118683876984, 
-4.9782504582454727]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-0.16669839719060953, 8.453617546912902], [2.0946575962725316, 5.1173298594403089]], 
[[1.0029007230239513, 0.23607082556979186], [-0.80218317738470413, -8.6548556630440103]], [[1.8775189507192129, 
-0.6774328941419836], [1.5092085652044345, -1.6023429876970767]], [[-1.8465767215229265, -5.5555270767265528], 
[-4.5976869043976887, -0.46187764233764028]], [[2.3381773151657139, 3.6856431490891781], [-2.9494863636135804, 
-3.819236489355069]], [[0.45650002851939853, 4.3531322781700181], [1.6512851062159823, -1.8635109652773663]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank3_expandedData_rank0(self):
      arg0=Data(numpy.array([[[-1.3458184728197056, -4.1114751126701288], [-3.6045681069514659, 4.5806213213322273]], 
[[4.7239945126027472, 4.8588256785970394], [2.9504811980717776, -3.8539131451192468]], [[4.0728056138639204, 
4.6876161203799995], [-4.8648382531748968, 2.60299615049259]], [[4.0499624144867443, -1.8705326646228979], 
[-4.5137216106750619, 3.612363945651154]], [[0.55893281778826065, 0.077924603172351503], [-1.4184375288520021, 
-1.3443492271526059]], [[-3.1393174376436352, 3.4724333511279522], [-1.5776418446925145, 
2.4734391212870976]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-1.8904372043887854, -4.5190956411614884], [4.5734968239898439, 
1.0082590467907497]], [[3.8636750869329113, 3.9753055079778292], [3.6817316456165035, -2.2852953305529211]], 
[[-3.2057768482574458, -3.0762564976518258], [3.4829401591047322, 0.34248983143272849]], [[2.8151134382597567, 
-1.4178792410543095], [-2.8304335165614161, -4.7381849088962147]], [[-0.68136449721731918, 2.3501860858438821], 
[-3.2348502809261737, 4.5616086950336996]], [[0.33619385608899499, -2.6984211096433608], [-1.7513895835664259, 
3.4613766908350989]]]))
      arg1=Data(-2.95834976602,self.functionspace)
      arg1.setTaggedValue(1,-1.20958161923)
      arg1.expand()
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-4.3041682388437552, -7.0698248786941784], [-6.5629178729755155, 1.6222715553081777]], 
[[1.7656447465786975, 1.9004759125729898], [-0.0078685679522720875, -6.8122629111432964]], [[1.1144558478398707, 
1.7292663543559499], [-7.8231880191989465, -0.35535361553145961]], [[1.0916126484626947, -4.8288824306469476], 
[-7.4720713766991116, 0.6540141796271044]], [[-2.399416948235789, -2.8804251628516981], [-4.3767872948760518, 
-4.3026989931766551]], [[-6.0976672036676849, 0.51408358510390251], [-4.5359916107165645, 
-0.484910644736952]]])+(1.-msk_ref)*numpy.array([[[-3.1000188236147102, -5.7286772603874132], [3.3639152047639191, 
-0.20132257243517504]], [[2.6540934677069865, 2.7657238887519044], [2.4721500263905787, -3.4948769497788459]], 
[[-4.4153584674833706, -4.2858381168777502], [2.2733585398788074, -0.86709178779319629]], [[1.6055318190338319, 
-2.6274608602802343], [-4.0400151357873408, -5.9477665281221395]], [[-1.890946116443244, 1.1406044666179573], 
[-4.4444319001520984, 3.3520270758077748]], [[-0.87338776313692978, -3.9080027288692856], [-2.9609712027923507, 
2.2517950716091741]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank3_expandedData_rank3(self):
      arg0=Data(numpy.array([[[0.48926485996388269, -4.2191465750376889], [-4.744994863225438, 4.7046031899712801]], 
[[-2.8802960414294931, -2.4397652993130245], [-2.3767544016720201, 2.4899243773104516]], [[-0.69880406189109756, 
4.9221904063963127], [-4.4442326066637925, -0.2423584515896291]], [[1.1873033499824093, -1.0359438602577908], 
[4.2099858094002389, -1.5188077642735309]], [[2.9762396657235834, 4.3565192054045294], [1.219861957512971, 
1.4186261054086193]], [[4.3881045375767531, -3.9515704899784074], [1.1881691193434287, 
-2.9515833814121994]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-2.9106692115097141, 1.1448509156703413], [-3.5747488270547203, 
4.3467479963579088]], [[1.9209411370244993, -4.4198148135632334], [-2.5439015312858881, 1.3155452706180606]], 
[[4.882640318602391, 0.34062975670052342], [0.2675381340109908, 4.2282940767774946]], [[4.3446095982723918, 
1.2060888712992277], [-2.8602079679237544, -4.5554211184908189]], [[4.5197831670681712, -4.2971679069891131], 
[3.6540620189148285, 4.6439542912634053]], [[1.6231944870566544, 4.6979308382991469], [-0.19481446900334376, 
1.9492126729664037]]]))
      arg1=Data(numpy.array([[[2.245745493494093, -2.0932114202393137], [3.5219400155970852, -1.0913747330679024]], 
[[1.2517416754427471, 2.7925988721213093], [-3.0719773913271564, -4.9990692573699933]], [[-1.9652009035875997, 
-3.1559304476140495], [0.02098892529537455, -0.25642222230972767]], [[0.55579717516428229, 4.2674028872779584], 
[4.9489668916843392, 1.7091559277184496]], [[-1.0997466757887455, 3.7830842865513592], [3.8155570798943668, 
-0.37081868296405851]], [[-0.86365585363381214, -3.3797412393172843], [-3.2312119408856352, 
3.3812609513235756]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[2.4170980236834101, -1.4418678544662491], [3.2265265882639937, 3.7842533566507583]], 
[[-1.8863396046980343, -3.6268725404156674], [-1.1549271336130018, 0.44272481604552549]], [[-0.33548547307548304, 
-0.10639012269721082], [-0.63541902485729196, 1.1408369737290194]], [[-1.9207718677721619, -1.1024972053357009], 
[-3.0868443868761175, 2.3061615690186024]], [[-3.564701225801775, -1.2916378277150353], [-1.5425736650453423, 
3.879975564160695]], [[-0.74759224895991316, 2.2399027760878099], [4.7240453344637139, -2.0896612148746141]]]))
      arg1.expand()
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[2.7350103534579757, -6.3123579952770026], [-1.2230548476283527, 3.6132284569033777]], 
[[-1.6285543659867461, 0.35283357280828476], [-5.4487317929991761, -2.5091448800595417]], [[-2.6640049654786973, 
1.7662599587822632], [-4.4232436813684179, -0.49878067389935676]], [[1.7431005251466916, 3.2314590270201675], 
[9.1589527010845782, 0.19034816344491867]], [[1.8764929899348379, 8.1396034919558886], [5.0354190374073378, 
1.0478074224445608]], [[3.524448683942941, -7.3313117292956917], [-2.0430428215422065, 
0.42967756991137618]]])+(1.-msk_ref)*numpy.array([[[-0.49357118782630405, -0.29701693879590785], [-0.34822223879072656, 
8.1310013530086671]], [[0.034601532326465012, -8.0466873539788999], [-3.69882866489889, 1.7582700866635861]], 
[[4.547154845526908, 0.2342396340033126], [-0.36788089084630116, 5.369131050506514]], [[2.4238377305002299, 
0.10359166596352676], [-5.9470523547998724, -2.2492595494722165]], [[0.95508194126639623, -5.5888057347041489], 
[2.1114883538694862, 8.5239298554241003]], [[0.8756022380967412, 6.9378336143869568], [4.5292308654603701, 
-0.14044854190821043]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank4_float_rank0(self):
      arg0=Data(numpy.array([[[[-2.4529918809417106, -4.2922716314173073, -4.7156912115011096, -4.9665561982246746], 
[-1.4801764375397228, -4.4380184594221186, -0.77360067331613269, -0.62622465894651036], [-1.0383450397120608, 
4.3040588789471954, 1.8106404043363975, 3.3893757878301294]], [[-1.992289067921309, -3.1704484515550044, 2.7872361600501936, 
-4.3322042469760804], [3.3604551208120839, 4.5663459688482622, -1.1238907281506529, 3.2787783020231913], [0.37186673546918136, 
-2.7641073556156828, -2.9035982677677898, 3.4758479506814339]]], [[[-3.6715006002612363, -0.73535868535250515, 
-0.27862633060145559, -1.0849832854789812], [-1.7022039443705039, 2.6060508744937936, -3.6536519425931813, 
-4.4081965675132473], [0.25471824064491599, -4.8782858092956758, 2.2337084769842255, 1.7096031580788216]], 
[[-2.2800898096116939, 3.658070109038098, -0.64746211000437448, -2.5044787022167636], [-2.6363559628733837, 
0.36216711358316278, -4.784316045543763, -3.0624579975364155], [2.287328835683617, 3.4578710762326086, 4.5781909364892712, 
-0.58253946841442605]]], [[[2.4432878816470822, 4.022871516449646, -1.245913498225375, -3.9051739614761392], 
[1.7066164592051036, -3.1983290935319211, -3.6728950000164931, -2.2473670296312633], [1.8958706148145694, -1.0284070864612218, 
-3.8956053902818399, 0.018998278733047158]], [[-0.26980316811500504, 2.8297007469536295, 1.094475544130554, 
-3.981764683657488], [-3.500356503088037, 4.171864849032481, -2.9012065649260022, -2.7283607393157738], [0.60051307561372358, 
-2.0886052678452236, 1.2447330012264244, 3.0604213102691027]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[4.6721490384002102, 2.7851789029326524, 4.5054527711787866, 3.9375455613431978], 
[2.9257854596657591, 0.82402496914787804, 2.7017427533937264, 0.41822359843216272], [-3.7659685225025186, -2.6058944363342693, 
2.1359178881116865, 3.1808871103282819]], [[0.45581546580998999, -0.10662460000334306, -3.4919407799771562, 
-0.17355947876977584], [0.03952563899673045, -2.6072367334090685, -2.5370380281116733, -3.8483713943551812], 
[-4.010882400107123, -3.4482767288174623, -1.1815070692881005, 4.7423057544944598]]], [[[-3.3134550400559935, 
2.1408457597292552, -3.4582025350264045, -4.5821067638126909], [-2.8683575747100418, 2.2751475609698915, 1.7742294946693047, 
4.2185654465528852], [3.0758297909260701, 4.6772884924460438, -3.9614574660248749, -0.5111517395111056]], 
[[0.95962586866565402, 0.00843194395573299, 2.5356218891094695, 3.7087356801306459], [2.3738352824593445, -4.2325312189114284, 
-0.014371828530438613, -4.907829300190504], [-0.55877429015129731, -3.949423986219569, 3.843079130599067, 
1.3423867592639551]]], [[[0.77407506136274673, 3.8197454797177119, -4.1508734783832555, 3.5956050476759103], 
[4.4484484321893323, -0.56814010775082302, -1.2446933884228697, -0.70841810762899993], [4.8091159200619913, 
-3.5828505478333539, -3.4733836136848772, 3.2289915076176143]], [[-3.8201817000007141, 3.5381725656161844, -2.2292796342354624, 
4.0231422110513453], [-4.1117126981322283, -0.13568148027115701, -2.3319889682031869, -1.5673291164601331], [4.304323986562391, 
0.27776805927176884, 1.3068734997189786, -4.9815181925099932]]]]))
      arg1=3.50847335696
      res=arg0+arg1
      ref=Data(numpy.array([[[[1.0554814760232061, -0.78379827445239059, -1.2072178545361929, -1.458082841259758], 
[2.0282969194251939, -0.9295451024572019, 2.734872683648784, 2.8822486980184063], [2.4701283172528559, 7.8125322359121121, 
5.3191137613013142, 6.8978491447950461]], [[1.5161842890436077, 0.33802490540991226, 6.2957095170151103, -0.82373089001116373], 
[6.8689284777770006, 8.0748193258131788, 2.3845826288142637, 6.787251658988108], [3.8803400924340981, 0.74436600134923392, 
0.60487508919712685, 6.9843213076463506]]], [[[-0.16302724329631957, 2.7731146716124115, 3.2298470263634611, 
2.4234900714859355], [1.8062694125944128, 6.1145242314587103, -0.14517858562826458, -0.8997232105483306], [3.7631915976098327, 
-1.3698124523307591, 5.7421818339491422, 5.2180765150437383]], [[1.2283835473532227, 7.1665434660030147, 2.8610112469605422, 
1.0039946547481531], [0.87211739409153299, 3.8706404705480795, -1.2758426885788463, 0.44601535942850123], [5.7958021926485337, 
6.9663444331975253, 8.0866642934541879, 2.9259338885504906]]], [[[5.9517612386119989, 7.5313448734145627, 2.2625598587395417, 
-0.39670060451122247], [5.2150898161700203, 0.31014426343299561, -0.16442164305157636, 1.2611063273336534], 
[5.4043439717794861, 2.4800662705036949, -0.38713203331692325, 3.5274716356979638]], [[3.2386701888499116, 6.3381741039185462, 
4.6029489010954707, -0.47329132669257135], [0.0081168538768796594, 7.6803382059973977, 0.60726679203891454, 
0.78011261764914286], [4.1089864325786403, 1.4198680891196931, 4.7532063581913411, 6.5688946672340194]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[8.1806223953651269, 6.293652259897569, 8.0139261281437033, 7.4460189183081145], 
[6.4342588166306758, 4.3324983261127947, 6.2102161103586431, 3.9266969553970794], [-0.25749516553760188, 0.90257892063064737, 
5.6443912450766032, 6.6893604672931986]], [[3.9642888227749067, 3.4018487569615736, 0.01653257698776045, 3.3349138781951408], 
[3.5479989959616471, 0.90123662355584822, 0.97143532885324335, -0.33989803739026447], [-0.50240904314220636, 
0.060196628147454412, 2.3269662876768162, 8.2507791114593765]]], [[[0.19501831690892324, 5.6493191166941719, 
0.050270821938512178, -1.0736334068477742], [0.64011578225487487, 5.7836209179348081, 5.2827028516342214, 7.7270388035178019], 
[6.5843031478909868, 8.1857618494109605, -0.45298410905995823, 2.9973216174538111]], [[4.4680992256305707, 3.5169053009206497, 
6.0440952460743862, 7.2172090370955626], [5.8823086394242612, -0.72405786194651167, 3.4941015284344781, -1.3993559432255873], 
[2.9496990668136194, -0.44095062925465234, 7.3515524875639837, 4.8508601162288718]]], [[[4.2825484183276634, 
7.3282188366826286, -0.6424001214183388, 7.104078404640827], [7.956921789154249, 2.9403332492140937, 2.263779968542047, 
2.8000552493359168], [8.317589277026908, -0.074377190868437193, 0.035089743280039443, 6.737464864582531]], 
[[-0.31170834303579742, 7.0466459225811011, 1.2791937227294543, 7.531615568016262], [-0.60323934116731159, 3.3727918766937597, 
1.1764843887617298, 1.9411442405047836], [7.8127973435273077, 3.7862414162366855, 4.8153468566838953, -1.4730448355450765]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank4_array_rank0(self):
      arg0=Data(numpy.array([[[[-0.46207075677734633, 4.6698653897341345, -3.1705589727730543, -1.3306190935272397], 
[3.5035371433589511, 2.4668772871461178, -3.2183351553104655, 2.4890776154597125], [2.1590844561338329, -2.3293778519085384, 
4.1107294137463697, 1.3689584764976672]], [[3.1136045839093001, -4.9390107738434175, 0.013156994502951491, 2.6683561592866081], 
[-3.6392387533662895, 0.96405076390185052, -4.0374447373167568, 0.85110065183239048], [-3.6953433190555374, 
-2.9571838686603646, -4.2771489403203136, -2.3472302939394138]]], [[[2.3131401311130206, 0.44033159636800612, 
-1.4214592260669754, 1.114858411747722], [-0.044916961278937073, -4.451651772019015, 4.8141790791054717, 1.4473497409062386], 
[-4.435470371835283, 1.9393919139025648, -1.2373670614327348, -3.6513529895403627]], [[2.9069249098655545, 3.6546254402892124, 
0.38527334298935401, 3.1234745684507317], [-4.6742846659384698, 4.5579138997776614, -1.0760665717102116, 3.4502674193106646], 
[1.4291704303525998, -0.12465720470982067, -1.0631942635238523, -4.7981723992255096]]], [[[1.5733747686267368, 
2.317117655927305, 0.57472357542811991, 4.6326736619427944], [0.66382238367749657, -0.23995158565173469, 3.022448130845655, 
4.9063918202723205], [3.9445456317199419, -1.5278174221675034, -1.870380291826248, -4.8277303827291993]], 
[[-4.8743895138728996, -2.3430657752600559, 3.800457954477455, 1.6419712899899332], [-4.576480758273437, 2.2299074197499262, 
-3.1565674373163812, -3.9162904236934573], [1.4877734138214569, -2.3975739501472946, 1.1375942963439769, 
2.010404696238508]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[0.1323050310828231, -2.3887492563951565, -4.1234158314752758, 3.4104899693912785], 
[-2.572982840387307, 4.4651205636485596, 4.2218665940516864, 3.2040976743486311], [0.90688483880528814, 2.2299154059973088, 
-0.70335687253032386, -4.4369420060041502]], [[1.3649300492405523, -1.1956713341316982, -2.1701465126700525, 
2.7698837035899029], [-1.9527049619445003, -2.5229900614459408, 0.35085346730302902, 2.352886195746084], [4.7003680223167628, 
-4.3746965447565778, -2.8198916811003825, -1.3116299449720472]]], [[[4.9659903663750278, 4.4242662141239499, 
-2.1659956690494209, 1.7686638008157027], [-4.1257089059625311, -2.2352834732352802, -0.25112828864904735, 
-0.48431649850257763], [0.92535523162620059, -3.6070786310331346, 1.1980747042357649, 1.1519098920254844]], 
[[-3.6070792364213142, -3.4536627959899024, 2.1688256985319923, 4.0071052514082393], [4.8788837876475082, 0.30087592860476953, 
-0.64959234172727598, -1.5420909024547114], [1.6655700945560952, -3.6933106001531968, -0.50295250260945856, 
-0.34152943299684857]]], [[[3.4990381386111498, -2.7688576121566513, -1.0294055868305794, 4.9797921269252718], 
[1.3004419357745869, -1.4492529012743969, -4.0682227606453143, 4.4694454868429307], [-4.6619778264757317, 4.0501370985963661, 
1.920306184056467, 2.3137686558171211]], [[1.891053851662754, -4.4134156919544871, 1.8589617637210596, -0.8652874428028916], 
[-1.3853542382362183, -1.4243866321640541, -4.7588659316730855, -3.4574488800334988], [1.3577642152790883, 0.70851867665501089, 
-0.81689674898252029, 2.5665335545746277]]]]))
      arg1=numpy.array(2.48395797545)
      res=arg0+arg1
      ref=Data(numpy.array([[[[2.0218872186705195, 7.1538233651820002, -0.68660099732518853, 1.1533388819206261], 
[5.9874951188068168, 4.9508352625939835, -0.73437717986259976, 4.9730355909075783], [4.6430424315816987, 0.15458012353932737, 
6.5946873891942355, 3.852916451945533]], [[5.5975625593571658, -2.4550527983955517, 2.4971149699508173, 5.1523141347344739], 
[-1.1552807779184238, 3.4480087393497163, -1.553486761868891, 3.3350586272802563], [-1.2113853436076716, -0.47322589321249886, 
-1.7931909648724478, 0.13672768150845194]]], [[[4.7970981065608864, 2.9242895718158719, 1.0624987493808904, 
3.5988163871955878], [2.4390410141689287, -1.9676937965711492, 7.2981370545533375, 3.9313077163541044], [-1.9515123963874172, 
4.4233498893504306, 1.246590914015131, -1.1673950140924969]], [[5.3908828853134203, 6.1385834157370782, 2.8692313184372198, 
5.6074325438985975], [-2.190326690490604, 7.0418718752255272, 1.4078914037376542, 5.9342253947585304], [3.9131284058004656, 
2.3593007707380451, 1.4207637119240135, -2.3142144237776439]]], [[[4.0573327440746025, 4.8010756313751708, 3.0586815508759857, 
7.1166316373906602], [3.1477803591253624, 2.2440063897961311, 5.5064061062935208, 7.3903497957201862], [6.4285036071678077, 
0.9561405532803624, 0.6135776836216178, -2.3437724072813335]], [[-2.3904315384250339, 0.1408922001878099, 6.2844159299253208, 
4.125929265437799], [-2.0925227828255712, 4.713865395197792, -0.67260946186851545, -1.4323324482455915], [3.9717313892693227, 
0.08638402530057121, 3.6215522717918427, 4.4943626716863738]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[2.6162630065306889, 0.095208719052709334, -1.63945785602741, 5.8944479448391442], 
[-0.089024864939441173, 6.9490785390964254, 6.7058245694995522, 5.6880556497964969], [3.3908428142531539, 4.7138733814451745, 
1.7806011029175419, -1.9529840305562844]], [[3.8488880246884181, 1.2882866413161675, 0.31381146277781324, 5.2538416790377687], 
[0.53125301350336551, -0.039032085998075061, 2.8348114427508948, 4.8368441711939498], [7.1843259977646285, -1.890738569308712, 
-0.33593370565251668, 1.1723280304758186]]], [[[7.4499483418228936, 6.9082241895718157, 0.31796230639844492, 
4.2526217762635685], [-1.6417509305146654, 0.24867450221258558, 2.2328296867988184, 1.9996414769452882], [3.4093132070740664, 
-1.1231206555852689, 3.6820326796836307, 3.6358678674733502]], [[-1.1231212609734484, -0.96970482054203666, 4.652783673979858, 
6.491063226856105], [7.362841763095374, 2.7848339040526353, 1.8343656337205898, 0.94186707299315442], [4.149528070003961, 
-1.209352624705331, 1.9810054728384072, 2.1424285424510172]]], [[[5.9829961140590155, -0.28489963670878549, 1.4545523886172864, 
7.4637501023731376], [3.7843999112224527, 1.0347050741734689, -1.5842647851974485, 6.9534034622907965], [-2.1780198510278659, 
6.5340950740442318, 4.4042641595043328, 4.7977266312649869]], [[4.3750118271106198, -1.9294577165066213, 4.3429197391689254, 
1.6186705326449742], [1.0986037372116475, 1.0595713432838116, -2.2749079562252197, -0.97349090458563303], [3.8417221907269541, 
3.1924766521028767, 1.6670612264653455, 5.0504915300224935]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank4_array_rank4(self):
      arg0=Data(numpy.array([[[[-1.3180258853817617, 4.4274973030499467, 4.0523231102533703, 4.5902748815255112], 
[2.1559601758310007, -2.1828151723093079, 4.2265015869584097, 3.9950326499948918], [-1.2098085673782943, -2.7545715510095281, 
4.8769522388341144, 0.26866852438456768]], [[-1.9806955320994888, 1.8104279894085531, -0.39762853496196726, 
2.7921460326069667], [2.791864700599584, -4.4790099485221653, -2.705958561080072, -4.1679386355484649], [-2.8832978276147969, 
4.1507637863510141, -2.9960018011735623, 2.9663193959875631]]], [[[-2.3654690639206741, 1.5336828414544188, 1.4610867306234159, 
3.1697086286660188], [-2.8754818130199302, -4.4793581441908126, 4.1501045050252294, 1.7581685285933668], [-4.7498732939497685, 
-1.1660483079158368, 2.7184637504847728, -2.60626176003665]], [[2.0854990135659026, -2.906199352162655, 2.8509095473230932, 
-0.33059775891538834], [-2.6203853002349851, 1.1101383438611876, -0.4054203516122632, -0.22934222218146694], 
[-1.0878665949471156, -0.48215791106113048, 1.0585964834322699, -3.2243478438221693]]], [[[-3.9017884876610931, 
1.1927128733419838, 2.1381629017975481, 4.187422311217615], [-1.7490225713627128, -0.7703793421173728, 2.0470983204875548, 
-1.554077093040005], [2.1736029049098846, -2.8956924955257279, 2.4640200389111904, -4.2945812950549982]], 
[[-0.23745342950770265, -1.6232273445635901, 4.3637065624608304, 0.85663493697235449], [1.632853526390484, 
-0.66589756896742536, -3.4840468291056914, -1.5510506940949309], [1.2208727796032628, 0.22912127300815932, 4.9226786747843612, 
2.3837199295321829]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[0.88800253969785192, -0.75602202958885911, -0.98413088327408538, 
2.3486894488999965], [-1.4865622734515305, 1.2567889146021924, -0.74875541021503533, 3.9547645375504015], 
[-0.41531751862917776, 4.6063387918737035, -3.9459156135098263, 3.7517614649521907]], [[3.2918275053288735, 
-1.3406642233528334, -2.90654914373222, -1.3209276396385903], [-2.3761143172462318, 2.1558923180501104, 1.7421185094873328, 
2.1811660461082338], [4.5252125974381592, -2.0954459053454046, -0.11141200183876787, 1.396008486419646]]], 
[[[1.4732832742742099, 1.3687222645618764, 0.083180258143978669, -4.0800865581150534], [2.2613064282935085, 3.2247006313790223, 
-0.98542178825565685, -2.7900876556151211], [-1.0367512751049732, 0.43906807336941611, 4.7178351127500235, 
4.6686990552993546]], [[2.5584010191005735, 4.6311480136461149, -2.1303736175234178, -3.2543007731999971], [2.4642783316561587, 
-3.5194898118736861, -4.2343923086155133, -2.0945115445853757], [-0.13663371776906708, 3.8528597358706147, -4.9668675228842218, 
-0.75385476335294133]]], [[[0.64449554956748045, 2.0873257313963904, -2.6127641559793879, -4.0421429294492874], 
[-1.9396654022058355, -3.0761997221929374, 0.84460482892300437, -4.493799600039182], [-0.72284626269142027, 
-1.2372897298350916, -0.3165271055821206, 0.22216611976427991]], [[-4.4542080408414044, -0.79651545313163652, 
-2.724109186694208, 4.1276997067585182], [-1.7241314667264795, -4.2071385857066579, -1.9030902669143543, -1.9742005521782091], 
[-4.7097199987993381, 0.001126719615230698, -3.0072719422045688, 2.9449798238007672]]]]))
      arg1=numpy.array([[[[-1.9608570956622606, -3.5411557923846679, 0.39301719021199233, 2.631230653607318], 
[1.1789054291980747, 1.9648532444904934, -4.68209210361338, -2.5068800807653426], [-3.4739560367044477, 2.4719147246416533, 
2.5713888809938421, -2.9696461625781034]], [[3.8736125229044021, -2.6570755917937969, 2.4921199136826324, 1.4189857980991096], 
[2.6300613213212474, -3.6935995210496984, 4.7292759377028215, 0.86833508694746619], [-3.9095941791871578, -4.175616887608494, 
3.1816330655045242, -4.623156350177994]]], [[[-3.5597318492173269, -3.9506928145363074, -0.9458912023240309, 
-4.9143171580870799], [2.0430972756525323, -2.3649235144525038, 2.4648104738749863, -1.3209476687035506], [-2.8041746784465049, 
3.5821550752059608, -3.4331029006745686, -2.8733245481895975]], [[-1.1126248013006035, 1.19628059030667, 0.26348265602038534, 
2.843833223154669], [1.7584561001326158, -0.7340180688736524, -3.0154533119064597, 3.414358089921528], [0.6750242275291285, 
-2.4881380127867314, -3.5043477509096399, 1.0914548651152316]]], [[[0.8266769272626453, 0.58419544360662634, 
-0.11819603883991192, 3.2008931914812937], [-4.1958152320495898, 3.8351978206627315, -0.53155547097190059, 
-2.9807833581877761], [3.792642706701324, 1.5079892540497841, 4.3890473712025795, 1.438724529923503]], [[-1.7447786535758461, 
0.30380450784928215, 1.3103861669415586, -3.8299777136976862], [-0.7192862782938878, 4.0467801021266396, 4.2821659270938923, 
-4.6144001703290023], [-1.7083028714147472, -4.7709853606005641, -2.3741017143412946, -3.8057883888956399]]]])
      res=arg0+arg1
      ref=Data(numpy.array([[[[-3.2788829810440223, 0.88634151066527878, 4.4453403004653627, 7.2215055351328292], 
[3.3348656050290755, -0.21796192781881452, -0.4555905166549703, 1.4881525692295492], [-4.6837646040827421, 
-0.28265682636787481, 7.4483411198279565, -2.7009776381935358]], [[1.8929169908049133, -0.84664760238524384, 
2.0944913787206652, 4.2111318307060763], [5.4219260219208314, -8.1726094695718636, 2.0233173766227495, -3.2996035486009987], 
[-6.7928920068019547, -0.02485310125747997, 0.18563126433096189, -1.6568369541904309]]], [[[-5.925200913138001, 
-2.4170099730818886, 0.51519552829938497, -1.7446085294210611], [-0.83238453736739793, -6.8442816586433164, 6.6149149789002157, 
0.43722085988981618], [-7.5540479723962735, 2.416106767290124, -0.71463915018979574, -5.4795863082262475]], 
[[0.97287421226529913, -1.709918761855985, 3.1143922033434785, 2.5132354642392807], [-0.86192920010236929, 0.3761202749875352, 
-3.4208736635187229, 3.1850158677400611], [-0.41284236741798708, -2.9702959238478619, -2.44575126747737, 
-2.1328929787069377]]], [[[-3.0751115603984478, 1.7769083169486102, 2.0199668629576362, 7.3883155026989087], 
[-5.9448378034123026, 3.0648184785453587, 1.5155428495156542, -4.5348604512277806], [5.9662456116112086, -1.3877032414759438, 
6.8530674101137699, -2.8558567651314952]], [[-1.9822320830835487, -1.3194228367143079, 5.6740927294023891, 
-2.9733427767253318], [0.91356724809659617, 3.3808825331592143, 0.79811909798820091, -6.1654508644239332], 
[-0.48743009181148444, -4.5418640875924048, 2.5485769604430666, -1.4220684593634569]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-1.0728545559644087, -4.297177821973527, -0.59111369306209305, 4.9799201025073145], 
[-0.30765684425345574, 3.2216421590926858, -5.4308475138284154, 1.4478844567850588], [-3.8892735553336255, 7.0782535165153568, 
-1.3745267325159842, 0.78211530237408722]], [[7.1654400282332755, -3.9977398151466303, -0.41442923004958754, 
0.098058158460519351], [0.25394700407501558, -1.537707202999588, 6.4713944471901543, 3.0495011330557], [0.61561841825100139, 
-6.2710627929538987, 3.0702210636657563, -3.2271478637583479]]], [[[-2.086448574943117, -2.581970549974431, 
-0.86271094418005223, -8.9944037162021324], [4.3044037039460408, 0.85977711692651848, 1.4793886856193295, -4.1110353243186717], 
[-3.8409259535514781, 4.0212231485753769, 1.284732212075455, 1.7953745071097571]], [[1.44577621779997, 5.8274286039527849, 
-1.8668909615030325, -0.41046755004532809], [4.2227344317887745, -4.253507880747339, -7.249845620521973, 1.3198465453361523], 
[0.53839050976006142, 1.3647217230838833, -8.4712152737938613, 0.33760010176229027]]], [[[1.4711724768301258, 
2.6715211750030168, -2.7309601948192999, -0.84124973796799374], [-6.1354806342554253, 0.75899809846979416, 0.31304935795110378, 
-7.4745829582269581], [3.0697964440099037, 0.27069952421469257, 4.0725202656204589, 1.6608906496877829]], 
[[-6.1989866944172505, -0.49271094528235437, -1.4137230197526494, 0.29772199306083191], [-2.4434177450203673, 
-0.16035848358001825, 2.379075660179538, -6.588600722507211], [-6.4180228702140854, -4.7698586409853334, -5.381373656545863, 
-0.86080856509487269]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank4_constData_rank0(self):
      arg0=Data(numpy.array([[[[-2.5708709288175391, 0.53581714653008561, 1.5360357521615526, 3.3951069767450566], 
[1.631732366076589, -0.5427283165247907, -4.1885665290237508, -1.7897530714409191], [-3.8687105480477681, -0.39103270374183552, 
4.9773978525962015, -1.5678906966200081]], [[-1.0005683385010009, -2.9043747824697563, 0.52026402593778887, 
2.3711689398047229], [2.7147649908653868, 4.3288849229920672, 3.2431311550744564, -1.1132028016748805], [3.9299119784057766, 
0.62724954538448063, -2.7068757404196955, 1.181410703546721]]], [[[-0.34737446837366726, 4.987848985374665, 3.1973650222296222, 
-2.6286186197645698], [4.7697186939677731, -1.9224177923759544, -4.0526602572447192, -4.3571373540293141], [3.4866059675370842, 
-2.6489651106670706, -1.8717782337675626, 1.546373157153587]], [[3.5839002968406248, -1.384604409647574, 0.77445258028805863, 
0.38130810244305291], [-3.6940285594614233, 4.8144411720619509, 2.0499133176164372, 2.0909884928187594], [-1.4769885010131603, 
4.718520386152635, -4.9705846174160007, -4.8886301302242448]]], [[[-0.0510002896129782, 0.014536311769425048, 
-2.311437231120177, 0.57574480584209553], [-1.3007980134702999, 0.7917745830722307, -2.6391625354871695, -0.33085679953840774], 
[-3.9418084807010634, -3.684162035082533, 0.2377992710428849, -0.53538299867439143]], [[0.28649909817135022, 
-3.8770359804364016, -2.8530785371915082, 0.78157992719722014], [-0.19928069036189822, -2.4240318308100495, 
-0.70055294248943945, 0.003486010919440119], [3.959215432772929, 3.1979221207054849, -4.0911992648566553, 
-0.6462422071730316]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[0.41693261177274721, -4.9020932423048089, 4.2088530824741905, 0.99953568795707426], 
[-4.2440395293604496, -3.4955448152614474, 2.0227037247513842, 2.8364324320081042], [2.692259108861923, 4.925400273320248, 
0.70036207432236708, 2.1012385837662118]], [[1.8298810984965028, -4.5775869134782159, -0.38144270148458759, 
0.35079862122661787], [-2.1940977888345534, 0.0015419838471322223, 1.0896534350975928, -2.3553944644521652], 
[2.1790715455306309, 0.89089931264249689, -1.6492115072152833, -3.645084483417115]]], [[[-2.3704484397063541, 
1.4384674683145491, -2.3336729429871719, -1.4310707759225281], [2.9384377821646845, 1.8515293306597371, -1.3377054510628508, 
4.7857793959119128], [1.2037955735438288, 3.652868648715927, -2.7501542031542914, 2.2786571327611682]], [[3.6883495085690114, 
-4.9232370846676172, -0.67363766625767507, -4.997957770198532], [3.6557645359812092, 3.6053506753372471, 1.4639322237519998, 
3.9081063252140531], [-1.4158862611806509, 2.5871057245553084, 0.37498808076538381, -4.0225794056588615]]], 
[[[4.0345672933604675, -3.6800976851511003, -4.6100225072463523, 3.6199177196679972], [-0.27709658645554835, 
-0.86922799724775857, 2.6875848512691727, -0.32499406365029593], [-2.90499641344377, -1.4629445128154206, -4.9827409146946033, 
0.91172398342859573]], [[1.5300744301386313, 2.9533568198190894, -2.7451811965834061, -0.081332757254997112], 
[-0.81834027054480174, -3.1786285020802172, 2.0595238370511204, -3.1723591443001355], [-0.27708852552600671, 
-3.4361857808835197, -3.3974132118757194, 4.2106883319056578]]]]))
      arg1=Data(-4.97117242623,self.functionspace)
      res=arg0+arg1
      ref=Data(numpy.array([[[[-7.5420433550515629, -4.4353552797039386, -3.4351366740724716, -1.5760654494889677], 
[-3.3394400601574352, -5.5139007427588149, -9.1597389552577759, -6.7609254976749433], [-8.8398829742817924, 
-5.3622051299758597, 0.0062254263621772665, -6.5390631228540324]], [[-5.9717407647350251, -7.8755472087037806, 
-4.4509084002962354, -2.6000034864293013], [-2.2564074353686374, -0.64228750324195705, -1.7280412711595678, 
-6.0843752279089047], [-1.0412604478282477, -4.3439228808495436, -7.6780481666537197, -3.7897617226873033]]], 
[[[-5.3185468946076915, 0.016676559140640812, -1.7738074040044021, -7.599791045998594], [-0.20145373226625107, 
-6.8935902186099787, -9.0238326834787443, -9.3283097802633392], [-1.48456645869694, -7.6201375369010949, -6.8429506600015868, 
-3.4247992690804372]], [[-1.3872721293933994, -6.3557768358815983, -4.1967198459459656, -4.5898643237909713], 
[-8.6652009856954475, -0.15673125417207334, -2.921259108617587, -2.8801839334152648], [-6.4481609272471845, 
-0.2526520400813892, -9.9417570436500249, -9.8598025564582699]]], [[[-5.0221727158470024, -4.9566361144645992, 
-7.2826096573542012, -4.3954276203919287], [-6.2719704397043241, -4.1793978431617935, -7.6103349617211933, -5.302029225772432], 
[-8.912980906935088, -8.6553344613165564, -4.7333731551911393, -5.5065554249084157]], [[-4.684673328062674, 
-8.8482084066704267, -7.8242509634255324, -4.1895924990368041], [-5.1704531165959224, -7.3952042570440737, -5.6717253687234637, 
-4.9676864153145841], [-1.0119569934610952, -1.7732503055285394, -9.0623716910906786, 
-5.6174146334070558]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-4.554239814461277, -9.8732656685388331, -0.76231934375983368, -3.97163673827695], 
[-9.2152119555944729, -8.4667172414954717, -2.9484687014826401, -2.13473999422592], [-2.2789133173721012, 
-0.045772152913776232, -4.2708103519116571, -2.8699338424678125]], [[-3.1412913277375214, -9.548759339712241, 
-5.3526151277186118, -4.6203738050074064], [-7.1652702150685776, -4.969630442386892, -3.8815189911364314, -7.3265668906861894], 
[-2.7921008807033934, -4.0802731135915273, -6.6203839334493075, -8.6162569096511383]]], [[[-7.3416208659403779, 
-3.5327049579194751, -7.3048453692211961, -6.4022432021565523], [-2.0327346440693397, -3.1196430955742871, -6.308877877296875, 
-0.18539303032211141], [-3.7673768526901954, -1.3183037775180972, -7.7213266293883152, -2.692515293472856]], 
[[-1.2828229176650128, -9.8944095109016423, -5.6448100924916993, -9.9691301964325554], [-1.315407890252815, 
-1.3658217508967772, -3.5072402024820244, -1.0630661010199711], [-6.3870586874146751, -2.3840667016787158, -4.5961843454686404, 
-8.9937518318928866]]], [[[-0.93660513287355673, -8.6512701113851236, -9.5811949334803757, -1.351254706566027], 
[-5.2482690126895726, -5.8404004234817828, -2.2835875749648515, -5.2961664898843201], [-7.8761688396777938, 
-6.4341169390494448, -9.9539133409286276, -4.0594484428054285]], [[-3.4410979960953929, -2.0178156064149348, 
-7.7163536228174303, -5.0525051834890213], [-5.789512696778826, -8.1498009283142423, -2.9116485891829038, -8.1435315705341598], 
[-5.2482609517600309, -8.407358207117543, -8.3685856381097441, -0.76048409432836639]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank4_constData_rank4(self):
      arg0=Data(numpy.array([[[[3.1331519622030566, 1.3119133890156967, -3.2392134494651281, -0.01569818056179173], 
[2.634556632080769, -1.189410178309064, 1.914015632778888, 1.4647992886672521], [-2.2199841553264141, -0.10166420825437594, 
-4.8324250114128073, 2.4067957844997796]], [[2.8462822657787656, 0.44011683322179529, -4.1076589232352152, 
-1.3423498632813602], [0.53632410068613634, 0.0070867373485814511, 2.4846431596065042, -3.0396972435073586], 
[-2.0963056738902139, -0.87930193181326199, 2.1183278730678801, 2.7346792811999157]]], [[[1.0681951676174828, 
-0.41818912340588632, -4.8476480835060221, -3.3146157083317318], [-3.8083861936585564, 1.4265322003908585, 4.7612563224989977, 
0.33388900779590891], [1.7709086691219635, 1.0164110436214449, 0.91720421535314767, -3.892946374145716]], 
[[-0.21322716600495095, 0.019664103154569901, -2.5389160047351456, -2.6874594544011874], [1.5242890831948088, 
-2.8188899113562407, -4.2375755921717264, -2.3465708679537944], [-4.5890727168846723, -3.1073959874736845, 2.6256214303516154, 
2.306166602974149]]], [[[-0.39742270642111865, 3.7780144318629709, -2.1528178473535831, 0.38956987471308402], 
[4.2072808591264188, -0.31273624034917979, -2.6254592071622618, -2.1252487243623053], [0.51571349096633412, 
0.022274290842354105, 0.62015453029442025, -1.064637557237802]], [[4.6645141713645693, -2.1015608157949028, 
-1.6892077968270183, 4.8090459955855884], [0.123339918957873, -4.0752931091395421, 4.5803954303973242, -1.126002876662453], 
[3.0746694309474041, -3.6358444246511268, -1.2950974062337561, 2.7843326629814573]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[4.9227582350105621, 3.6036118955387906, -2.708445126257264, -0.010623154617936947], 
[3.9376047613219214, 2.353994660542881, 2.3471841350779759, 2.0773573229030653], [-1.143142450361645, -1.3786062401477817, 
4.3976570759022806, 4.3735781169914141]], [[-3.3610620753879128, -3.0010619584716736, 0.64095586188100917, 
-0.12119915059537245], [-3.7982069708990496, -2.4694132998194931, -0.52396914706805209, 4.4213016710158008], 
[2.7529768001123189, -0.96581203501230384, 0.77711645282180974, -2.1096868341727748]]], [[[-0.89235105065349618, 
-1.6771008391848028, 2.7651378950555952, -2.7729116554651956], [-2.3362287803320192, -1.9906576742577862, -2.1830603808815665, 
1.4573837859578749], [4.4160251954589782, 0.84023453476264631, 3.2257525974331731, -1.9574021443725833]], 
[[-3.2661887452158744, -4.6851142104549934, 0.82658483006030536, 1.089439663075976], [2.2488299456094722, -3.6873618309339316, 
0.73900683253748589, -1.1677601689326709], [1.0896285725439974, 3.6562970341003762, -3.2012161242939707, 4.0200778747597266]]], 
[[[-3.9207539144034111, 2.6592808898097484, -1.564140703303496, 0.85878875556931877], [2.4733407841500243, 3.3426483456035267, 
-3.3511808065342477, 2.2157775754136484], [3.7229225805005655, 3.4572070633959182, -3.4277821650720464, -2.1240040336435726]], 
[[3.5468172315497917, 3.0128640257101509, -4.9995373443318147, -4.8329137141251168], [4.0556325671795879, 1.2780420444496885, 
4.6606825048100671, -3.3263939358085293], [3.3914884553245415, -4.6894048812889171, -4.0645164474469446, 
2.3415536814852942]]]]))
      arg1=Data(numpy.array([[[[1.6463450974122074, -2.4953937193344977, 4.2733641267117779, 4.5330294346296274], 
[3.1444543220966743, 0.15056244203574209, 3.1308214912647401, 3.9466546675293763], [3.9989575987236705, 1.2959694095047523, 
3.2763312879330879, 1.3003779658425287]], [[3.3695184798944968, 2.195722881116553, -0.88074509562310244, 0.35302477558533329], 
[3.6987700783165351, -0.30739620781974253, 0.57688786177728968, 0.80022403922436958], [3.6502466700047584, 1.3021084553118376, 
-4.0179617826950071, -4.6393640417561164]]], [[[-1.499731500376662, -2.405147810094844, -1.4862333895483228, 
4.3818154977298267], [-1.6735911082216215, -3.1357887521787928, 2.6673233589095986, 4.4975056851447039], [0.98131927050915113, 
3.9906279719071769, 3.9254722688653665, -3.9078676082622419]], [[-2.4806631673946908, -4.310842055095967, 4.3279233073924352, 
3.4103293802177301], [3.0090369783976865, -1.6550843346417499, 0.62407465515388783, -4.8401477225380773], [2.208243718706, 
4.4163329158494768, 2.481684970533844, -4.8744613593287216]]], [[[-4.0971312364070167, 2.128584318877631, 3.8224151974197262, 
-3.8623076683567636], [-2.7280491484206237, -3.9114308472374248, -4.5128299957491569, -2.4948564083412608], 
[3.4052773595518673, -0.6146492343146619, 2.1414392608980855, -3.3746448909504592]], [[1.6739065084581464, 3.1970768469416235, 
3.3598674616350124, -1.6991949526555938], [2.9155653699560604, -4.378569739274778, 0.42764140152916053, -3.1546307165838106], 
[-0.26171465472001199, 2.672547314914727, -1.8219051584334212, -4.0597059773120669]]]]),self.functionspace)
      res=arg0+arg1
      ref=Data(numpy.array([[[[4.7794970596152639, -1.1834803303188011, 1.0341506772466498, 4.5173312540678356], 
[5.7790109541774433, -1.0388477362733219, 5.0448371240436281, 5.4114539561966284], [1.7789734433972564, 1.1943052012503763, 
-1.5560937234797194, 3.7071737503423083]], [[6.2158007456732625, 2.6358397143383483, -4.9884040188583176, 
-0.98932508769602689], [4.2350941790026715, -0.30030947047116108, 3.0615310213837938, -2.239473204282989], [1.5539409961145445, 
0.42280652349857561, -1.8996339096271271, -1.9046847605562007]]], [[[-0.43153633275917924, -2.8233369335007303, 
-6.3338814730543449, 1.0671997893980949], [-5.4819773018801783, -1.7092565517879343, 7.4285796814085963, 4.8313946929406129], 
[2.7522279396311147, 5.0070390155286217, 4.8426764842185142, -7.8008139824079574]], [[-2.6938903333996418, -4.2911779519413971, 
1.7890073026572897, 0.72286992581654275], [4.5333260615924953, -4.4739742459979901, -3.6135009370178386, -7.1867185904918713], 
[-2.3808289981786723, 1.3089369283757923, 5.1073064008854594, -2.5682947563545726]]], [[[-4.4945539428281354, 
5.9065987507406019, 1.6695973500661432, -3.4727377936436796], [1.4792317107057951, -4.2241670875866042, -7.1382892029114187, 
-4.620105132703566], [3.9209908505182014, -0.59237494347230779, 2.7615937911925057, -4.4392824481882611]], 
[[6.3384206798227156, 1.0955160311467207, 1.6706596648079941, 3.1098510429299946], [3.0389052889139334, -8.453862848414321, 
5.0080368319264847, -4.2806335932462636], [2.8129547762273921, -0.96329710973639981, -3.1170025646671773, 
-1.2753733143306096]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[6.5691033324227694, 1.1082181762042929, 1.5649190004545139, 4.5224062800116904], 
[7.0820590834185957, 2.5045571025786231, 5.4780056263427159, 6.0240119904324416], [2.8558151483620255, -0.082636830643029402, 
7.6739883638353685, 5.6739560828339428]], [[0.0084564045065840254, -0.80533907735512056, -0.23978923374209327, 
0.23182562498996084], [-0.099436892582514425, -2.7768095076392356, 0.052918714709237591, 5.2215257102401704], 
[6.4032234701170774, 0.33629642029953377, -3.2408453298731974, -6.7490508759288907]]], [[[-2.3920825510301582, 
-4.0822486492796468, 1.2789045055072723, 1.6089038422646311], [-4.0098198885536407, -5.126446426436579, 0.48426297802803209, 
5.9548894711025788], [5.3973444659681293, 4.8308625066698232, 7.1512248662985396, -5.8652697526348252]], [[-5.7468519126105653, 
-8.9959562655509604, 5.1545081374527406, 4.4997690432937061], [5.2578669240071587, -5.3424461655756819, 1.3630814876913737, 
-6.0079078914707482], [3.2978722912499974, 8.0726299499498531, -0.71953115376012677, -0.85438348456899504]]], 
[[[-8.0178851508104287, 4.7878652086873794, 2.2582744941162303, -3.0035189127874449], [-0.2547083642705994, 
-0.5687825016338981, -7.8640108022834045, -0.27907883292761237], [7.1281999400524327, 2.8425578290812563, -1.2863429041739609, 
-5.4986489245940318]], [[5.220723740007938, 6.2099408726517744, -1.6396698826968024, -6.5321086667807107], [6.9711979371356483, 
-3.1005276948250895, 5.0883239063392276, -6.4810246523923398], [3.1297738006045295, -2.0168575663741901, -5.8864216058803658, 
-1.7181522958267728]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank4_taggedData_rank0(self):
      arg0=Data(numpy.array([[[[1.0601531822977677, 4.0726745619023657, 3.6495957472642591, -4.5853746548448457], 
[4.8031956869743624, 1.2922001324316899, -2.6038108121498285, -1.6853805692426715], [0.59635781747329641, -4.7739890492747978, 
-2.991829369254396, -0.99026007351987833]], [[4.1004501612408912, -0.71221999944871772, -2.4257763498665632, 
-4.2477319700162806], [3.7347500468428674, -0.41423651785688165, -0.94677070639313499, 2.6151816677807496], 
[-0.37477785819362452, 4.7491854335909025, 4.4755854873113048, -3.7922402823612011]]], [[[-2.3375624135978779, 
3.6743639421545318, -3.2953137207261305, -4.7343836049299579], [-1.1293147135669335, -2.6145629134141899, -1.7544972255926892, 
4.9030233031737218], [-4.9678403571315357, -3.1894934503219705, 4.2473033937755904, -4.1801669702549411]], 
[[3.8422382434248306, 1.7130957815427017, -4.0127435846118917, -0.0026619250493880031], [-2.9168221244052503, 
2.4740021579204416, -2.0539398312727633, -3.1024688730966976], [-0.84232290631693907, 0.055624764862427512, 
-1.3381599247004794, -0.82758169195057274]]], [[[-4.1263214859140485, -3.6307795610760349, -0.0076760095589829547, 
-1.218946255623381], [2.5053902771663674, -3.9039324327414926, 2.4384267679153693, -1.0053652842886951], [0.82760324835353138, 
0.036949319751261811, -4.1521739644823628, -4.0593244662714687]], [[-4.1015263277201246, -2.3504672175092587, 
4.8967336738456702, 1.5712918827128775], [3.1643696304401931, 2.5471229856578992, 1.6225127637431225, -2.8479171224373676], 
[0.094212258010476724, -3.1221298986331778, 1.5839929906775971, -0.2422789755390955]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[0.33783179069622893, -1.7416762009781186, -2.3752352662009626, 1.0538156387949495], 
[2.3103445909667544, 4.9379831389624727, -1.1815444628895522, 0.9483596323812673], [-3.1455866789282041, -4.9093114789590642, 
2.0831341254654125, -0.37398976668950645]], [[-4.4661822068043353, 2.6239149763920402, 3.1007400255377391, 
-1.8587358170529935], [-0.21689598075010696, 3.6631674321147205, 3.5158926843530072, -2.0086638209418393], [3.9557509506035782, 
-3.2177807686526085, 3.0993150985243094, -0.70474975624957548]]], [[[4.804821491853966, -3.8952588296984434, 
-1.1426442995369013, 3.8146426584851092], [-1.8178876140511524, 1.7791684879288692, -3.2173608676359269, -2.0671894883697775], 
[4.1853396517114891, -2.3369501503351731, 0.43120754239429981, -0.46623877778020528]], [[1.1562225740765841, 
-1.338923522434976, -4.0670070817941086, 2.201628633350766], [-0.00028437091238409096, 4.817033338220325, -3.8045904649367834, 
-1.7330917243963539], [3.2265481370009557, -1.3548091899665939, -1.5553622629183508, 2.9420132778352901]]], 
[[[-3.3452399358965392, -0.047814239049344565, 4.7566190312827299, 4.0979275750740971], [3.022004721710335, 
-3.3522097945021745, 3.3811714091977443, 1.8950199314273473], [-4.1201649545047117, -3.3753627897528382, -4.363202023325691, 
-3.1491085169538158]], [[-4.8912776091420129, -1.7293548927326716, -3.7081326188032051, -4.2779046281308872], 
[1.1859734840524814, -3.081187929250718, -2.4229874756702219, 3.5596112695803974], [4.9409662334423547, 1.7440276392348366, 
1.9629092477137977, -1.7230445817030082]]]]))
      arg1=Data(-1.85688075123,self.functionspace)
      arg1.setTaggedValue(1,-1.92083167105)
      res=arg0+arg1
      ref=Data(numpy.array([[[[-0.79672756893443708, 2.2157938106701609, 1.7927149960320543, -6.4422554060770505], 
[2.9463149357421576, -0.5646806188005149, -4.4606915633820332, -3.5422613204748763], [-1.2605229337589083, -6.6308698005070026, 
-4.8487101204866008, -2.8471408247520831]], [[2.2435694100086865, -2.5691007506809225, -4.282657101098768, 
-6.1046127212484853], [1.8778692956106626, -2.2711172690890864, -2.8036514576253397, 0.75830091654854481], 
[-2.2316586094258293, 2.8923046823586978, 2.6187047360791, -5.6491210335934063]]], [[[-4.1944431648300826, 1.817483190922327, 
-5.1521944719583352, -6.5912643561621627], [-2.9861954647991382, -4.4714436646463946, -3.6113779768248939, 3.0461425519415171], 
[-6.8247211083637405, -5.0463742015541753, 2.3904226425433857, -6.0370477214871459]], [[1.9853574921926258, 
-0.14378496968950305, -5.8696243358440965, -1.8595426762815928], [-4.7737028756374551, 0.6171214066882369, -3.910820582504968, 
-4.9593496243289028], [-2.6992036575491438, -1.8012559863697772, -3.1950406759326841, -2.6844624431827775]]], 
[[[-5.9832022371462532, -5.4876603123082397, -1.8645567607911877, -3.0758270068555857], [0.64850952593416267, 
-5.7608131839736973, 0.58154601668316452, -2.8622460355208998], [-1.0292775028786734, -1.8199314314809429, -6.0090547157145675, 
-5.9162052175036735]], [[-5.9584070789523293, -4.2073479687414634, 3.0398529226134654, -0.2855888685193273], 
[1.3074888792079884, 0.69024223442569443, -0.23436798748908227, -4.7047978736695724], [-1.762668493221728, -4.9790106498653826, 
-0.27288776055460762, -2.0991597267713002]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-1.5829998803569181, -3.6625078720312656, -4.2960669372541096, 
-0.86701603225819746], [0.38951291991360737, 3.0171514679093256, -3.1023761339426992, -0.9724720386718797], 
[-5.0664183499813511, -6.8301431500122112, 0.16230245441226554, -2.2948214377426535]], [[-6.3870138778574823, 
0.70308330533889318, 1.1799083544845921, -3.7795674881061405], [-2.137727651803254, 1.7423357610615735, 1.5950610132998602, 
-3.9294954919949863], [2.0349192795504312, -5.1386124397057555, 1.1784834274711624, -2.6255814273027225]]], 
[[[2.883989820800819, -5.8160905007515904, -3.0634759705900483, 1.8938109874319622], [-3.7387192851042994, 
-0.14166318312427784, -5.1381925386890739, -3.9880211594229245], [2.2645079806583421, -4.2577818213883205, -1.4896241286588472, 
-2.3870704488333523]], [[-0.76460909697656287, -3.259755193488123, -5.9878387528472556, 0.28079696229761897], 
[-1.9211160419655311, 2.896201667167178, -5.7254221359899304, -3.653923395449501], [1.3057164659478087, -3.2756408610197409, 
-3.4761939339714978, 1.0211816067821431]]], [[[-5.2660716069496862, -1.9686459101024916, 2.8357873602295829, 
2.1770959040209501], [1.101173050657188, -5.2730414655553215, 1.4603397381445973, -0.025811739625799746], [-6.0409966255578587, 
-5.2961944608059852, -6.284033694378838, -5.0699401880069628]], [[-6.8121092801951599, -3.6501865637858186, 
-5.6289642898563521, -6.1987362991840342], [-0.73485818700066563, -5.0020196003038651, -4.3438191467233693, 
1.6387795985272504], [3.0201345623892077, -0.17680403181831039, 0.042077576660650706, -3.6438762527561552]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank4_taggedData_rank4(self):
      arg0=Data(numpy.array([[[[-1.7990919183368304, 0.93184397396384711, -3.7330585278423802, 4.6907149947481948], 
[1.2582588875202454, 2.1897390191621238, 0.54483074076905069, -0.12283657170321938], [-3.6466931314993891, 3.7096556826842111, 
-2.6307798886737075, -2.7149637797948922]], [[-2.349947605764763, 0.28447613909407465, -2.0993400716304214, 
3.1956758477293477], [2.1974065966472178, 1.3730307476321171, 0.78701614666569419, -3.6076351467098347], [-4.8186980641756874, 
-1.9758416393400191, 2.6943224698178492, -0.82203672052128063]]], [[[2.1972761713627325, 3.139218320997772, 
-3.5987132438121283, -4.2244258583758585], [-4.4096726479599617, -2.0640702496273122, 3.1894070668564787, -1.0761145547937589], 
[1.5153364154318734, -2.7229445465769162, -3.5080709349001449, 0.17378689776656042]], [[-4.5169909102900876, 
-2.4754816871957139, 3.873148454381095, 2.0228575477523716], [-4.4699177427705896, 4.8708191331970276, 3.5271580262369291, 
0.48503175720727221], [0.26855779864747209, -2.1997779296540978, 3.8010248130325337, 4.1651880321116739]]], 
[[[3.4607515645929858, 1.5529183069597776, 0.054641037367643364, 2.3691311182312802], [-4.960665137967867, 3.5686665782767513, 
0.27576813232611386, -2.5652906093608685], [-3.8353908921177373, -0.86938404303642169, 3.3894256634996545, 
-3.8536914202267436]], [[1.4853362193091417, -0.53606432985992569, -1.9713315849327895, 4.4402517000376456], 
[-2.6282155021433784, 0.04973835118059533, -4.8622374887315631, -3.6104233101506678], [-4.1119736416305201, 1.1744302205364301, 
-1.6687048562530404, -1.8060350265348815]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[4.5846061409465779, -2.9399688578819658, 0.30825711547837109, 2.3573107373453812], 
[-4.5455942746014024, -2.3545811939649952, -0.33415079495292854, -3.583185346538651], [-2.9933886201094815, 
-1.2938945826618351, -1.4843026949749061, -2.1523921428095285]], [[3.4322630137240804, -2.7381170276080558, 0.1724980341609772, 
1.3395082552409443], [-0.21838018698504857, 3.2450808551347041, -1.9816165055734611, 1.0084038872740075], [-2.4700161314040523, 
-0.70546991518164592, -3.5475617729209996, -4.6546266494693045]]], [[[4.3602245210617632, -2.9266401106553519, 
2.9558169933091545, -3.540231720477812], [1.9246426732334321, -1.3035598362833598, 2.853783811312649, 1.8820758276310396], 
[4.6934574449949693, 0.83510455661471816, -3.8795376301389748, 2.0833270505986672]], [[4.8734742216206062, 2.473371494381059, 
-3.3430799353419727, 2.6981490223343183], [-2.7339505937714348, -2.1756456484894873, -0.64539707084804032, 
-2.0022088914596212], [-3.2533433842042903, -0.49336822108599598, 1.4501619221400119, 3.0094368144300248]]], 
[[[-4.3768865299997897, -0.61404980791096264, 3.3706224552886841, 4.5591898894702716], [-3.1783866468476951, 
3.5723753038884016, -1.3476064062893247, 0.14669844254866327], [1.4487167217365551, 4.256738889596118, 1.6825657424181486, 
-2.8787583026391648]], [[-4.0947258926848562, 1.8985626248872123, -3.2018335101346684, 2.8749930077782473], 
[4.8650803974003551, -0.17794687566387335, -4.5963109719060586, -4.646909655331001], [-2.6605573935498148, 2.5769852321341276, 
-4.5295819718924086, -1.7583310338449087]]]]))
      arg1=Data(numpy.array([[[[4.4656365903094457, -4.9150861484816346, -3.3045248504181979, -4.4528992593777197], 
[4.0331617479768287, -0.48352162671466026, -3.274836667089839, -1.5801395084402459], [-4.9188357669531255, -1.4829832471079349, 
-1.3431415309841057, -2.3395734650814424]], [[4.1749401548527061, 2.2110612332190316, 3.1269979635415126, 0.80974070701623724], 
[3.8129667447467313, -1.8032702733257411, -3.4528040216422804, -4.3718963749644466], [0.39635568268175625, 3.8258517505576695, 
-1.900625824984016, -4.0924527892973916]]], [[[-0.28406204806047697, -4.8519913675852635, -0.025524852023748323, 
2.3268385269563163], [3.6652171909914255, 1.2173070491755533, 3.5817870177953921, -2.8375445910551402], [0.88074433991492818, 
3.0191028774442792, 4.9794288579848835, -0.61041237408038462]], [[1.2872095660037175, -3.5846452728087765, -1.6102701820698648, 
2.1281719062450613], [-2.3751194002324327, -3.671977417636445, -4.6699550381579176, 1.5445397316548846], [0.31232446087630272, 
2.9276048261923755, 2.3156455536056875, 4.9740453582556725]]], [[[4.2075448669960824, 3.6290949233964795, -0.80349349904871481, 
-3.209057048715561], [-4.5561614792229506, 0.34538810627403027, -0.28392980919979216, -3.5972276911942327], 
[-0.47879086912418245, -3.8389654556022057, 3.3938679759851951, -0.8446509989207307]], [[-4.9027050630779812, 
3.8828776109802625, -4.1016817123081513, 0.55926088418936093], [2.2369503807152755, -0.91038607974924801, 1.0298081300954394, 
1.453986780885077], [-0.51898697067416233, -2.7623316264607602, -0.18857368671852814, 2.988515091434123]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[-0.31241989554702787, 4.6825336233164077, -4.7431962405480776, 1.570560531825782], 
[-0.24411786764566301, -4.7990161009499479, -3.0347465925110919, -2.3145821774522881], [1.1421601164562123, 
-2.2280507594786947, -4.68700782862292, -2.9466655903159533]], [[-2.8533448580007201, 4.6948927387559376, -2.414098617960839, 
4.2816869394728965], [3.7174014415796091, 0.51726168781737591, 2.6713923268820903, -2.0286672158710428], [-4.1612504013566367, 
4.9503826471738162, 4.5705628160830294, 3.0578420984404069]]], [[[3.1159725239567724, -0.32962099090097396, 
-2.1963839503787117, -0.87587825251936646], [-0.53359482512976975, -4.8423566099615432, -2.9384468411925049, 
-3.4414365444039428], [-2.0722391447545476, 1.2640433217746772, -2.1866613497909135, 0.18759767517210779]], 
[[0.21072876950637998, 0.42953462170173395, -3.5287078002501349, -1.1592519691194769], [-0.22187126677921398, 
3.6036975722714377, 1.2203602056005733, -0.19408363115915339], [-3.3153151464697395, -4.7322399510154423, 1.27155787986755, 
3.2549029841265167]]], [[[0.99311889379529994, 2.8740902846233487, -4.495107709244758, -2.7127818882019805], 
[-3.0859386969508638, 1.2639805770466497, -0.28957901167847311, -0.22690859722752421], [-1.3076650762404918, 
-3.8889612176069823, 1.6952852909518592, 3.8430682444002784]], [[1.9778109086353997, 0.27433873636489103, -2.5576836533759839, 
1.8170036890459915], [-3.5455380237002898, -1.6926898420012715, 0.41175235147042244, 1.1768922106298874], [4.5612978880640398, 
1.3543112710963126, -4.2549615676374577, 4.4941127949188839]]]]))
      res=arg0+arg1
      ref=Data(numpy.array([[[[2.6665446719726154, -3.9832421745177875, -7.0375833782605781, 0.23781573537047507], 
[5.2914206354970741, 1.7062173924474635, -2.7300059263207883, -1.7029760801434652], [-8.5655288984525146, 2.2266724355762761, 
-3.9739214196578132, -5.0545372448763342]], [[1.8249925490879431, 2.4955373723131062, 1.0276578919110912, 4.0054165547455849], 
[6.0103733413939491, -0.430239525693624, -2.6657878749765862, -7.9795315216742813], [-4.4223423814939311, 1.8500101112176504, 
0.79369664483383318, -4.9144895098186723]]], [[[1.9132141233022555, -1.7127730465874915, -3.6242380958358766, 
-1.8975873314195422], [-0.74445545696853621, -0.8467632004517589, 6.7711940846518708, -3.9136591458488992], 
[2.3960807553468015, 0.29615833086736298, 1.4713579230847387, -0.4366254763138242]], [[-3.2297813442863701, 
-6.0601269600044905, 2.2628782723112302, 4.1510294539974328], [-6.8450371430030224, 1.1988417155605826, -1.1427970119209885, 
2.0295714888621568], [0.58088225952377481, 0.7278268965382777, 6.1166703666382212, 9.1392333903673464]]], 
[[[7.6682964315890683, 5.1820132303562572, -0.74885246168107145, -0.83992593048428077], [-9.5168266171908176, 
3.9140546845507815, -0.008161676873678303, -6.1625183005551012], [-4.3141817612419198, -4.7083494986386274, 6.7832936394848495, 
-4.6983424191474743]], [[-3.4173688437688394, 3.3468132811203368, -6.0730132972409407, 4.9995125842270065], 
[-0.39126512142810288, -0.86064772856865268, -3.8324293586361238, -2.1564365292655907], [-4.6309606123046825, 
-1.5879014059243302, -1.8572785429715686, 1.1824800648992415]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[4.2721862453995501, 1.7425647654344418, -4.4349391250697066, 3.9278712691711632], 
[-4.7897121422470654, -7.1535972949149436, -3.3688973874640205, -5.8977675239909395], [-1.8512285036532692, 
-3.5219453421405298, -6.1713105235978265, -5.0990577331254823]], [[0.57891815572336025, 1.9567757111478818, 
-2.2416005837998618, 5.6211951947138408], [3.4990212545945605, 3.76234254295208, 0.68977582130862913, -1.0202633285970353], 
[-6.631266532760689, 4.2449127319921702, 1.0230010431620298, -1.5967845510288976]]], [[[7.4761970450185355, 
-3.2562611015563259, 0.75943304293044278, -4.4161099729971784], [1.3910478481036623, -6.145916446244903, -0.084663029879855856, 
-1.5593607167729031], [2.6212183002404217, 2.0991478783893953, -6.0661989799298883, 2.270924725770775]], [[5.0842029911269861, 
2.9029061160827929, -6.8717877355921075, 1.5388970532148414], [-2.9558218605506488, 1.4280519237819504, 0.57496313475253302, 
-2.1962925226187746], [-6.5686585306740302, -5.2256081721014382, 2.7217198020075619, 6.2643397985565414]]], 
[[[-3.3837676362044897, 2.2600404767123861, -1.1244852539560739, 1.8464080012682911], [-6.2643253437985589, 4.8363558809350513, 
-1.6371854179677978, -0.080210154678860945], [0.1410516454960633, 0.36777767198913569, 3.3778510333700078, 
0.96430994176111362]], [[-2.1169149840494565, 2.1729013612521033, -5.7595171635106528, 4.6919966968242388], 
[1.3195423737000653, -1.8706367176651448, -4.1845586204356362, -3.4700174447011136], [1.900740494514225, 3.9312965032304401, 
-8.7845435395298672, 2.7357817610739752]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank4_expandedData_rank0(self):
      arg0=Data(numpy.array([[[[-1.9822678236600955, 4.7519319188346589, 1.9525679733009849, 0.89806120397498557], 
[-1.4759442276593706, -0.01889348557776227, -0.041659617091004186, 1.2158996733355689], [-3.9115826514884544, 
-1.0110007051318028, 3.6259455645448178, 0.65067680977141862]], [[4.836462464183148, 0.5634478224956343, 0.64779235942283186, 
-3.5749405256049052], [0.95871040462842316, -2.9408912569945036, 1.671154111231532, -1.6859042910157784], [-1.9016689039927259, 
-4.0543118027509619, 1.7409191914027611, 1.7992704725411581]]], [[[4.8748059918500228, -3.2109535160850267, 2.5132752885143272, 
-4.5220721330748717], [-3.5946795904440032, 2.9550986164892308, 2.3366659113342241, -1.830283303410567], [1.8574895822311754, 
2.8434038998337288, 4.4101370925668331, 1.2387553366937141]], [[0.39377902972405199, 1.1009795786782419, -1.3165687598999645, 
-3.3183731093521129], [3.0370904342726526, 3.7020134143909118, 4.6898077548757673, 3.8709642247220248], [3.5187362855296129, 
-1.9938034359064871, 0.86424334989254259, 0.82622082781977824]]], [[[2.443577520413406, 1.7811103902825129, 4.3104594566205865, 
-0.46348593998584775], [1.2519131997200761, -2.3803701233648624, 3.2863434910999132, -0.95277586683536253], 
[-3.7379755865565665, 0.11386770333318452, 0.4419257992398844, 1.5591409014109452]], [[3.1373736276389028, -4.6011668563748511, 
0.012935569164921112, 1.8754757728947844], [0.7116556516471757, -4.8795792796619466, 1.7970936720816386, 1.8176893668785628], 
[0.13378369318859296, -4.1464542122601289, -0.30919253407308567, 3.1936033080149233]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[-2.5752545375698999, 0.21763548830149659, -0.24087248769822267, 
-3.2114557879599079], [0.57699590546700907, -2.0556364308538377, -1.0610327961222357, -3.993137315515737], [1.9165363873422141, 
1.1305158547734537, -4.6727011277065316, 3.2468610218798268]], [[1.2599874644844444, -0.43273449711841305, 4.3863149700246691, 
1.8040006747435564], [-2.8611246475076522, 1.2688489416081747, -3.7903974069954027, 0.7240886815771006], [1.5249729830082437, 
0.51236318403081071, -3.8271421610901513, -4.1359940246528328]]], [[[-4.6212698824412533, -3.8758222403886644, 
-0.31455792217787515, 4.2612873845009887], [-3.3314502674753266, 2.8619209963041561, -2.552604395062934, -1.9196994243451537], 
[2.9204739684380439, 0.69041716540978548, 0.052012334574987662, -2.377187810552126]], [[-3.5289417755246069, 
-3.0632637531348461, 0.24243420054816767, 3.2989986707593228], [4.5227762932585502, 3.5153693618300927, 3.9778614937690584, 
-4.2807255734068672], [2.9420271023401234, 4.1408019168701546, 4.0224722423379085, 2.5902491013040665]]], 
[[[-0.73398250083622241, 3.5873512282657138, 0.76070289110872746, 1.079154802735351], [-4.9455430434738563, 1.8977224230213894, 
-1.7938713824241139, 0.72234058698535542], [-0.61555738406516802, 2.2510985441163385, -2.5437936118518256, 3.439436712560294]], 
[[1.0841400617861128, -1.6117980259100206, 3.7870225863291775, 0.88038632923927462], [1.0981013695896946, -3.0404445271306821, 
3.3477956146500887, -0.77883732568979802], [-1.9348980004567853, -2.8835451055953421, 2.1220700699769175, 
-2.572383937263174]]]]))
      arg1=Data(-1.12990383074,self.functionspace)
      arg1.setTaggedValue(1,0.99139756726)
      arg1.expand()
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-3.1121716544045164, 3.622028088090238, 0.82266414255656395, -0.23184262676943534], 
[-2.6058480584037915, -1.1487973163221832, -1.1715634478354251, 0.085995842591148008], [-5.0414864822328749, 
-2.1409045358762238, 2.4960417338003968, -0.47922702097300229]], [[3.706558633438727, -0.56645600824878661, 
-0.48211147132158905, -4.7048443563493265], [-0.17119342611599775, -4.0707950877389241, 0.5412502804871111, 
-2.8158081217601993], [-3.0315727347371468, -5.1842156334953824, 0.61101536065834017, 0.66936664179673722]]], 
[[[3.7449021611056019, -4.3408573468294476, 1.3833714577699063, -5.651975963819293], [-4.7245834211884237, 1.8251947857448099, 
1.2067620805898032, -2.9601871341549879], [0.72758575148675453, 1.7135000690893079, 3.2802332618224121, 0.10885150594929316]], 
[[-0.73612480102036892, -0.02892425206617899, -2.4464725906443854, -4.4482769400965338], [1.9071866035282317, 
2.5721095836464909, 3.5599039241313464, 2.7410603939776039], [2.388832454785192, -3.123707266650908, -0.26566048085187832, 
-0.30368300292464268]]], [[[1.3136736896689851, 0.65120655953809203, 3.1805556258761656, -1.5933897707302687], 
[0.12200936897565517, -3.5102739541092833, 2.1564396603554923, -2.0826796975797834], [-4.8678794173009869, -1.0160361274112364, 
-0.68797803150453651, 0.42923707066652428]], [[2.0074697968944819, -5.7310706871192725, -1.1169682615794998, 
0.74557194215036349], [-0.41824817909724521, -6.009483110406368, 0.6671898413372177, 0.68778553613414184], 
[-0.99612013755582796, -5.2763580430045494, -1.4390963648175066, 
2.0636994772705024]]]])+(1.-msk_ref)*numpy.array([[[[-1.5838569703103769, 1.2090330555610196, 0.75052507956130032, 
-2.2200582207003849], [1.5683934727265321, -1.0642388635943147, -0.069635228862712673, -3.001739748256214], 
[2.9079339546017371, 2.1219134220329767, -3.6813035604470086, 4.2382585891393498]], [[2.2513850317439674, 0.55866307014110994, 
5.3777125372841921, 2.7953982420030794], [-1.8697270802481292, 2.2602465088676977, -2.7989998397358797, 1.7154862488366236], 
[2.5163705502677667, 1.5037607512903337, -2.8357445938306283, -3.1445964573933098]]], [[[-3.6298723151817303, 
-2.8844246731291414, 0.67683964508164784, 5.2526849517605116], [-2.3400527002158036, 3.8533185635636791, -1.561206827803411, 
-0.92830185708563073], [3.9118715356975668, 1.6818147326693085, 1.0434099018345107, -1.385790243292603]], 
[[-2.5375442082650839, -2.0718661858753231, 1.2338317678076907, 4.2903962380188458], [5.5141738605180732, 4.5067669290896157, 
4.9692590610285814, -3.2893280061473442], [3.9334246695996464, 5.1321994841296776, 5.0138698095974314, 3.5816466685635895]]], 
[[[0.25741506642330059, 4.5787487955252368, 1.7521004583682505, 2.070552369994874], [-3.9541454762143333, 2.8891199902809124, 
-0.80247381516459093, 1.7137381542448784], [0.37584018319435497, 3.2424961113758615, -1.5523960445923026, 4.430834279819817]], 
[[2.0755376290456358, -0.62040045865049764, 4.7784201535887005, 1.8717838964987976], [2.0894989368492176, -2.0490469598711591, 
4.3391931819096117, 0.21256024156972497], [-0.94350043319726229, -1.8921475383358191, 3.1134676372364405, 
-1.5809863700036511]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_taggedData_rank4_expandedData_rank4(self):
      arg0=Data(numpy.array([[[[2.7272765192400907, 2.6591477436263746, -1.9677339084308034, 1.6154400570356557], 
[-4.0240290833984806, -1.5196611865148268, -3.2456886671894472, -3.2320272536713892], [-4.5295490931361311, 4.7353190644761671, 
-3.3681891780945783, 1.2311718620525536]], [[3.0212175601276243, -4.4264576323217888, 1.2599854067838612, 0.26652531640301991], 
[-4.7290342820430995, 3.2998142410219735, 0.43982343872097296, -4.1031800264620664], [-3.8533311953775415, 4.6540095368781902, 
4.4444412872113741, 3.1659832185014647]]], [[[2.5165398584440091, -3.1822077995078777, -4.3818804918282837, 
-0.5347978434313756], [-2.9057681205735131, 0.38896972952242237, -3.6235001068953943, 4.8996286196355729], 
[-4.2498560950204283, -3.8375149408539331, 0.21067427408396533, 2.4488305973470803]], [[3.0118948839306441, 
-2.2521346297114517, -0.1362863957550946, 3.0729040604076356], [-2.4600203726673788, -1.0820116221675882, 0.28592882406212627, 
-4.548978701453807], [2.2280965379671036, -3.5052761503293919, 4.3540476914357633, -2.2044615175721427]]], 
[[[3.6559648209607598, -4.7964030679331078, 0.22369552872524867, -0.87013449962459877], [-3.6542834470984333, 
2.5989274472091424, -0.08509633321545973, 1.582056187852662], [4.3865368186502121, -4.7564370606598203, 4.645447269787903, 
-3.8803351995491466]], [[4.823758822520297, 4.6393697233219235, -2.2813677934859355, 1.8701781174876846], 
[0.068284150791402709, -3.6552386864603514, -4.290829679596686, 1.946806812169144], [4.0964493240446629, 4.7524157155589126, 
3.3615986115746441, 4.7106143316817199]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[1.5583271560856087, -0.57188170650901515, 4.5987935549514507, 1.6229382124856393], 
[1.0930528088745772, -2.476942681865768, -3.7190197395924249, 2.1198658276210827], [4.84538812867949, -4.5059575453081946, 
-0.54172262363297463, -4.3002070541233977]], [[0.92036983348850931, -3.9224136869028192, -2.7889876415999248, 
-3.5084772387743746], [-2.9013345680932465, 0.58589647442178183, -2.0920050799029655, -3.1409900010481442], 
[-2.7420845956149833, 4.1074046417372365, 1.3867486883914815, 4.5451162756095513]]], [[[3.3683719218586248, 1.5799088089294955, 
-3.1465858851790331, 4.4703286608278212], [1.4939486272868674, -1.7522211337649707, -2.0619197920695043, 1.5157769907583418], 
[-2.2077198449407733, 2.4452361243571188, 4.3535191284057948, 4.8304487989957536]], [[-1.1852975050587511, -2.9668147799297353, 
2.962820649358453, 1.5283772239661992], [4.8168685753698739, -0.69400978717268025, -3.7156743122177804, -3.6798538189836369], 
[-4.9895035487123698, -0.17697414292558022, 3.6622532455378689, 0.70896914819390666]]], [[[2.2097366510461942, 
-3.4354509041832504, -1.3231013787049228, 1.650254486621864], [2.2808153822479031, -1.3407037245690869, -0.56740268309922648, 
-3.0130984431850316], [2.7248745996878307, -2.0484359960038132, 2.864279632909362, -0.46538263268766578]], 
[[-3.1303225329853501, 2.2753776981136493, -4.9093928172487233, -3.8618668874772477], [3.4552753549380242, 
-0.32590259667711674, 3.0088285177260872, 0.1587313961630743], [0.9763965135959296, 3.3021740769130226, -0.49847508158638121, 
-2.1804151918058801]]]]))
      arg1=Data(numpy.array([[[[-3.9352015837525012, -2.860507758449089, -1.40480970150616, -3.2884906364088593], 
[-2.6641914531889785, 2.3567927196544725, -3.0647603676776658, -2.657564673520314], [4.3550987899555622, 1.2449618188852707, 
-1.6245614393033634, 0.740100169122762]], [[2.1792800323083448, 3.9009778255384866, 0.39170775186276963, -1.1084579996773316], 
[3.7426276863906498, -3.6006174422971169, 3.399054453890475, -0.25946559533034286], [-1.6293504259430502, 0.73697175438579254, 
4.5698107938284167, -1.9301486908396424]]], [[[-3.0451206231866337, 0.059522695060061359, 1.1890046142035802, 
-4.1386620004158985], [-4.7080516265904535, -2.1163299056965466, 4.7817687816767052, -1.5613428930206261], [-2.441703931823842, 
1.4256216389912977, 4.1865178116027728, -4.6269972536109769]], [[-3.4688971842932936, -4.4541720815112464, -3.5455264634812877, 
-3.0894435828611986], [0.10995066174123735, 1.7705183124544259, -2.8551895522553226, -3.9293179424501092], 
[-4.4981867698670026, -2.2068211647301403, 3.3297516680559678, -2.9777303410918532]]], [[[-1.7089632453448855, 
0.98170709248907162, -0.93759768502700158, 3.8705304492417874], [3.2318666551687194, -1.0303297302967938, 1.281933588930249, 
-2.3094708665372652], [3.633148399675882, 3.0556409313577575, -2.027475399013372, -0.35650894422181345]], [[1.7299822857353062, 
-1.197810983529485, 0.019592034278305803, -2.0826999972176652], [3.3064900012250238, 1.8275170577207964, 4.4414628502968334, 
-0.042407266142218347], [-4.5428273658782494, -4.8025574849624642, 4.1085195900166909, 
0.59866195183762461]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[0.17685229581819506, -2.6418260019332296, 1.8152859574414713, 
-0.17422650860980582], [-3.0656107510341979, 4.9320158007392347, -2.3739933036036778, -1.727158988720876], 
[-4.3033749993411243, 3.0297371725772884, 3.6973630604953485, 3.4610253682100343]], [[2.9051779182260384, -2.3439490391761355, 
1.6412219506533612, -2.0607558121035821], [4.1058694903700648, -0.24894078631454342, -3.1119594376409321, 2.8885272366579118], 
[-0.37125406663187199, 3.0534547182012197, 2.2894748907295739, 0.21522805657280308]]], [[[2.2981218187940646, 
-3.6656246871999132, 4.2545411655242074, 2.2897154559086328], [3.6767534010233476, -3.5560546299506091, -0.9901205486583855, 
4.4152870211386563], [4.9020505922163053, -1.6219020776727042, -1.5742379804728932, 1.3916514850663706]], 
[[-0.70973150607027691, -2.1567765158018579, 0.22119552262824005, -0.34821322131399857], [-3.4877804383375932, 
-1.7497272583616477, 1.5421358963340595, 1.7443065416113832], [2.5285541017248381, -0.19955258681344645, 2.848375269287347, 
2.0512786837871353]]], [[[-3.3843072498095439, -1.5940503647429551, 3.5750742741926658, 4.0691219718682294], 
[-2.7474692989588947, 4.4842033510677819, -1.7884429081284372, -1.9908286216121973], [-1.1356650955168979, 3.1646135578769279, 
-4.2652795322719284, -1.0145055587718597]], [[3.5491986069707764, -3.8496376856759418, -2.3580124339985629, 
4.8646784843044237], [-3.4700320591409142, -0.37857516050742213, 0.68417599483544844, -0.61110575699124325], 
[1.1825308970273287, 4.5923941948064968, -3.976110142790886, 0.84623620521280429]]]]))
      arg1.expand()
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-1.2079250645124104, -0.20136001482271437, -3.3725436099369634, -1.6730505793732036], 
[-6.6882205365874592, 0.83713153313964561, -6.3104490348671129, -5.8895919271917032], [-0.17445030318056887, 
5.9802808833614378, -4.9927506173979417, 1.9712720311753156]], [[5.2004975924359691, -0.52547980678330219, 1.6516931586466308, 
-0.8419326832743117], [-0.9864065956524497, -0.30080320127514337, 3.838877892611448, -4.3626456217924092], 
[-5.4826816213205918, 5.3909812912639827, 9.0142520810397908, 1.2358345276618223]]], [[[-0.52858076474262461, 
-3.1226851044478163, -3.1928758776247035, -4.6734598438472741], [-7.6138197471639666, -1.7273601761741242, 1.1582686747813109, 
3.3382857266149468], [-6.6915600268442699, -2.4118933018626354, 4.3971920856867381, -2.1781666562638966]], 
[[-0.45700230036264955, -6.7063067112226982, -3.6818128592363824, -0.016539522453562938], [-2.3500697109261415, 
0.68850669028683775, -2.5692607281931963, -8.4782966439039171], [-2.270090231899899, -5.7120973150595322, 7.6837993594917311, 
-5.1821918586639963]]], [[[1.9470015756158743, -3.8146959754440362, -0.71390215630175291, 3.0003959496171886], 
[-0.42241679192971393, 1.5685977169123486, 1.1968372557147893, -0.72741467868460319], [8.019685218326094, -1.7007961293020628, 
2.617971870774531, -4.2368441437709601]], [[6.5537411082556032, 3.4415587397924385, -2.2617757592076297, -0.2125218797299806], 
[3.3747741520164265, -1.827721628739555, 0.15063317070014737, 1.9043995460269256], [-0.44637804183358654, 
-0.050141769403551528, 7.470118201591335, 5.3092762835193446]]]])+(1.-msk_ref)*numpy.array([[[[1.7351794519038037, 
-3.2137077084422447, 6.414079512392922, 1.4487117038758335], [-1.9725579421596207, 2.4550731188734667, -6.0930130431961027, 
0.39270683890020663], [0.54201312933836565, -1.4762203727309062, 3.1556404368623738, -0.8391816859133634]], 
[[3.8255477517145478, -6.2663627260789543, -1.1477656909465637, -5.5692330508779566], [1.2045349222768182, 0.33695568810723842, 
-5.2039645175438975, -0.25246276439023241], [-3.1133386622468553, 7.1608593599384562, 3.6762235791210554, 
4.7603443321823544]]], [[[5.6664937406526894, -2.0857158782704177, 1.1079552803451742, 6.760044116736454], [5.170702028310215, 
-5.3082757637155797, -3.0520403407278898, 5.9310640118969982], [2.694330747275532, 0.82333404668441457, 2.7792811479329016, 
6.2221002840621242]], [[-1.895029011129028, -5.1235912957315932, 3.1840161719866931, 1.1801640026522007], [1.3290881370322807, 
-2.4437370455343279, -2.173538415883721, -1.9355472773722537], [-2.4609494469875317, -0.37652672973902668, 6.5106285148252159, 
2.760247831981042]]], [[[-1.1745705987633497, -5.0295012689262055, 2.2519728954877429, 5.7193764584900935], 
[-0.46665391671099155, 3.143499626498695, -2.3558455912276637, -5.0039270647972289], [1.5892095041709329, 1.1161775618731147, 
-1.4009998993625663, -1.4798881914595254]], [[0.41887607398542626, -1.5742599875622925, -7.2674052512472862, 
1.002811596827176], [-0.014756704202889992, -0.70447775718453887, 3.6930045125615356, -0.45237436082816895], 
[2.1589274106232583, 7.8945682717195194, -4.4745852243772672, -1.3341789865930758]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_expandedData_rank0_taggedData_rank0(self):
      arg0=Data(-2.45784045862,self.functionspace)
      arg0.setTaggedValue(1,2.31030870049)
      arg0.expand()
      arg1=Data(4.71282017112,self.functionspace)
      arg1.setTaggedValue(1,-2.25991979071)
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*(2.2549797125)+(1.-msk_ref)*(0.0503889097804)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_expandedData_rank0_taggedData_rank1(self):
      arg0=Data(-3.34652279676,self.functionspace)
      arg0.setTaggedValue(1,1.53745765087)
      arg0.expand()
      arg1=Data(numpy.array([3.4318238351668242, -2.4405324320070108]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([4.0029001743376895, 0.8331733937495267]))
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([0.085301038404434149, -5.7870552287694004])+(1.-msk_ref)*numpy.array([5.5403578252095276, 
2.3706310446213648])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_expandedData_rank0_taggedData_rank2(self):
      arg0=Data(1.3020473667,self.functionspace)
      arg0.setTaggedValue(1,-1.41545525971)
      arg0.expand()
      arg1=Data(numpy.array([[-1.7265053885136048, -1.4712749422840155, -3.9397527194745861, 3.9946837913205648, 
3.2536122309452349], [2.6811114679007675, -0.35502412921027648, -2.0171850629782559, 3.4766836568162436, 1.9033728554633011], 
[-0.38926087127955622, -3.4136043824343307, -1.2239369279432877, -1.6851226164974911, 4.6805851296611714], 
[-0.78452517138582234, -0.52550491644668007, -1.4976649257548837, -3.0117235953484576, -1.445916954142128]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[2.4203560418898551, -0.15178680088626173, -0.4650356945912808, -4.6364495067205382, 
1.9033486051459665], [1.2273854524783046, 0.21092228466745766, 4.8470184150547357, 3.913879288546763, -1.4050943298594443], 
[0.15549981790659295, 1.669223411329436, -1.1600981262339305, 0.42745663088461683, -0.93765281059660399], [3.2240645611139822, 
3.2390127861390656, 3.7189423355380171, -1.8504341549489203, -2.0187445625097675]]))
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-0.42445802181486592, -0.16922757558527657, -2.6377053527758472, 5.2967311580193037, 
4.5556595976439738], [3.9831588345995064, 0.9470232374884624, -0.71513769627951707, 4.7787310235149825, 3.20542022216204], 
[0.91278649541918266, -2.1115570157355918, 0.078110438755451206, -0.38307524979875218, 5.9826324963599102], 
[0.51752219531291654, 0.77654245025205881, -0.19561755905614486, -1.7096762286497187, 
-0.14386958744338907]])+(1.-msk_ref)*numpy.array([[1.0049007821792477, -1.5672420605968691, -1.8804909543018882, 
-6.0519047664311456, 0.48789334543535912], [-0.18806980723230282, -1.2045329750431497, 3.4315631553441284, 2.4984240288361557, 
-2.8205495895700516], [-1.2599554418040144, 0.2537681516188286, -2.5755533859445379, -0.98799862882599054, 
-2.3531080703072114], [1.8086093014033748, 1.8235575264284583, 2.3034870758274097, -3.2658894146595276, -3.4341998222203749]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_expandedData_rank0_taggedData_rank3(self):
      arg0=Data(0.315281958619,self.functionspace)
      arg0.setTaggedValue(1,4.77792091009)
      arg0.expand()
      arg1=Data(numpy.array([[[4.4612381157591621, 1.6766847385633765], [0.55547241809476677, 3.9108329142717704]], 
[[-4.2625148810224145, 2.4593624806361785], [1.795349158317201, 4.9399022768230889]], [[4.0485392348311553, 
4.4029734037448343], [0.53445127507420143, -3.8294024239678159]], [[1.7612024555912518, -0.44610857712610752], 
[3.7107985081585486, -4.8852486051357866]], [[-1.2990748638147744, 4.6643028470068124], [1.1225809895178305, 
-2.5642529820575408]], [[2.9058154474972229, 3.4284582491247182], [-4.9949860171650915, 
4.1011822172104893]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[1.1817929544003682, -1.084893198888448], [-3.9435086414503995, 3.1166096639915644]], 
[[-3.9597903752567234, -3.7934860412669389], [4.4675879323673779, -0.9183536179828975]], [[3.4707470880613371, 
-0.43531931805617763], [1.4983404381224386, -0.70992222772275682]], [[-1.2911879862443354, -4.4064631190639449], 
[2.6343603975717009, 0.53848635999957395]], [[-2.4633346053218999, 3.1157428164448504], [-1.3456159141155535, 
-1.6635238716224823]], [[0.85670654879524744, -4.5186020294485978], [-2.023880376756968, -4.4654642289716939]]]))
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[4.7765200743780838, 1.9919666971822982], [0.87075437671368849, 4.2261148728906921]], 
[[-3.9472329224034928, 2.7746444392551002], [2.1106311169361227, 5.2551842354420106]], [[4.363821193450077, 4.718255362363756], 
[0.84973323369312315, -3.5141204653488942]], [[2.0764844142101735, -0.1308266185071858], [4.0260804667774703, 
-4.5699666465168649]], [[-0.98379290519585272, 4.9795848056257341], [1.4378629481367522, -2.2489710234386191]], 
[[3.2210974061161446, 3.7437402077436399], [-4.6797040585461698, 
4.416464175829411]]])+(1.-msk_ref)*numpy.array([[[5.9597138644941428, 3.6930277112053265], [0.83441226864337503, 
7.8945305740853389]], [[0.81813053483705112, 0.98443486882683562], [9.2455088424611525, 3.859567292110877]], 
[[8.2486679981551116, 4.3426015920375969], [6.2762613482162131, 4.0679986823710177]], [[3.4867329238494391, 
0.37145779102982956], [7.4122813076654754, 5.3164072700933485]], [[2.3145863047718747, 7.8936637265386249], [3.432304995978221, 
3.1143970384712922]], [[5.6346274588890219, 0.25931888064517672], [2.7540405333368065, 0.31245668112208058]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_expandedData_rank0_taggedData_rank4(self):
      arg0=Data(-0.626675121515,self.functionspace)
      arg0.setTaggedValue(1,3.05709423837)
      arg0.expand()
      arg1=Data(numpy.array([[[[-2.2040119703487737, 0.22207585226900939, -3.9418794262070769, 2.0859785399087185], 
[1.7904551067882419, 1.9190078021454715, -0.13723968162950939, -3.2815182493831885], [-0.91571535407697002, 3.0995577411718731, 
0.10326371715132865, -1.2257029064659122]], [[-3.4339587435216492, -1.7174314509114286, -3.8212321032447538, 
1.3141536610711295], [-3.0867159602503822, -1.328832259691648, 0.00045833706937159491, 3.7279300198570748], 
[0.7141427717444957, -3.3772016134720029, -4.0342641506650709, -1.2974928280252405]]], [[[-0.03925290280549909, 
-4.0358075605674912, 2.5240986142622281, -0.9106800040300298], [4.2713554750433751, -2.065335819573674, 3.9574485785983331, 
3.1928077430143595], [-3.1332757872420802, -2.5585886089202092, 0.36453095035546923, -2.3244180120835702]], 
[[-1.8307102339182526, -0.5174914843013676, -4.329919822379118, -2.9965928508652429], [-3.6142489775730979, 3.9342435492751342, 
-2.904750033176644, -3.5850262587817463], [2.1729113810705956, -4.2032434203199367, -1.6213604268260662, 
-3.8270575512982408]]], [[[-3.5663986534145176, 0.3601394756264229, 2.1915112832756067, -1.8858770292987579], 
[-0.35941895324789463, -4.8139117948938415, -3.6559003431824988, 2.2368494410808069], [1.3959636989705739, 4.2049437171968158, 
0.50083863087043579, -1.2890449546507088]], [[0.55413677919310089, 3.6679690886311356, 4.1412457734605272, -4.997372949226687], 
[-1.0508856720949833, -1.9665649518812991, -0.88999850896384824, -2.3477813714010387], [0.0034178612916049289, 
-0.40189153578178072, -4.2806039766499211, 3.2437347497163689]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[-0.99776878669975311, 1.6476931814330831, 2.8134436212555602, -4.557103818579737], 
[-3.9194236310417963, -0.44874006777794762, -4.0015924911850709, -4.1479737214740631], [4.4143713534846736, 1.2628305661237951, 
-1.4628196920853656, -1.0526083796531038]], [[4.8722998661963874, -0.016885382913489622, -2.8681215766737953, 
-3.155053610744126], [1.8931366327126469, 4.3677862809546966, -3.0939100462373723, -2.9519037772918413], [-2.6456837564583537, 
2.2433665611851232, -4.195097963023823, 3.3064145489222678]]], [[[-2.3036330080317837, -2.5103773239877336, 
-2.8401783867137933, -3.7340814752319105], [-4.0465179785957428, -1.6680856153080601, 0.14748528212714618, 1.7351453309708731], 
[-3.0063672320853563, -3.7939238676857281, 2.2278136033940479, 2.8797022453974979]], [[4.7200475755279676, -3.9124149796924845, 
-4.8073872954662935, 1.6550061951322173], [1.0558427554413807, 2.8568918144276081, -0.47343170358816078, 4.7025021023732236], 
[4.8300795973213546, 4.1857494293375481, 1.0533939531371566, -1.9001756817409343]]], [[[-1.7738212126204833, 
0.79011696107876794, -1.0395268559811721, 4.8741438965592838], [-2.0735520996350107, 3.5965422597627512, 3.4232317673958885, 
-3.5727502064729366], [4.2562185560687897, -4.176059848306048, -1.5929478277090716, -3.989642732338968]], 
[[-3.8259833544798463, -2.3805718022145994, -2.6347056156230462, 2.4050273266781517], [3.6976298148616138, 3.854254396967022, 
3.0669052624585316, 0.032625206805732887], [4.6774122914027529, -0.20282020601598383, 0.079177633110205647, 
1.7288047845163357]]]]))
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-2.8306870918637581, -0.404599269245975, -4.5685545477220613, 1.4593034183937341], 
[1.1637799852732575, 1.2923326806304871, -0.76391480314449378, -3.9081933708981729], [-1.5423904755919544, 2.4728826196568887, 
-0.52341140436365574, -1.8523780279808966]], [[-4.0606338650366336, -2.344106572426413, -4.4479072247597387, 
0.68747853955614513], [-3.7133910817653666, -1.9555073812066324, -0.6262167844456128, 3.1012548983420904], 
[0.087467650229511307, -4.0038767349869868, -4.6609392721800553, -1.9241679495402249]]], [[[-0.66592802432048348, 
-4.6624826820824756, 1.8974234927472438, -1.5373551255450142], [3.6446803535283907, -2.6920109410886583, 3.3307734570833487, 
2.5661326214993752], [-3.7599509087570646, -3.1852637304351936, -0.26214417115951516, -2.9510931335985546]], 
[[-2.457385355433237, -1.144166605816352, -4.9565949438941024, -3.6232679723802272], [-4.2409240990880823, 3.3075684277601498, 
-3.5314251546916284, -4.2117013802967307], [1.5462362595556112, -4.8299185418349211, -2.2480355483410506, 
-4.4537326728132252]]], [[[-4.193073774929502, -0.26653564588856149, 1.5648361617606223, -2.5125521508137423], 
[-0.98609407476287902, -5.4405869164088259, -4.2825754646974836, 1.6101743195658225], [0.76928857745558954, 3.5782685956818314, 
-0.1258364906445486, -1.9157200761656932]], [[-0.072538342321883498, 3.0412939671161512, 3.5145706519455429, 
-5.6240480707416713], [-1.6775607936099677, -2.5932400733962835, -1.5166736304788326, -2.9744564929160231], 
[-0.62325726022337946, -1.0285666572967651, -4.9072790981649055, 
2.6170596282013845]]]])+(1.-msk_ref)*numpy.array([[[[2.0593254516723132, 4.7047874198051494, 5.8705378596276265, 
-1.5000095802076707], [-0.86232939266972997, 2.6083541705941187, -0.94449825281300459, -1.0908794831019968], 
[7.4714655918567399, 4.3199248044958614, 1.5942745462867007, 2.0044858587189625]], [[7.9293941045684537, 3.0402088554585767, 
0.18897266169827098, -0.097959372372059761], [4.9502308710847132, 7.4248805193267629, -0.036815807865306027, 
0.10519046108022501], [0.41141048191371254, 5.3004607995571895, -1.1380037246517567, 6.3635087872943341]]], 
[[[0.75346123034028256, 0.54671691438433268, 0.21691585165827298, -0.67698723685984419], [-0.98942374022367652, 
1.3890086230640062, 3.2045795204992125, 4.7922395693429394], [0.050727006286710008, -0.7368296293136618, 5.2849078417661142, 
5.9367964837695641]], [[7.7771418139000339, -0.85532074132041824, -1.7502930570942272, 4.7121004335042835], [4.112936993813447, 
5.9139860527996744, 2.5836625347839055, 7.7595963407452899], [7.8871738356934209, 7.2428436677096144, 4.1104881915092228, 
1.156918556631132]]], [[[1.283273025751583, 3.8472111994508342, 2.0175673823908942, 7.9312381349313501], [0.98354213873705554, 
6.6536364981348175, 6.4803260057679548, -0.51565596810087033], [7.313312794440856, -1.1189656099339818, 1.4641464106629947, 
-0.93254849396690176]], [[-0.76888911610777999, 0.67652243615746688, 0.42238862274902012, 5.462121565050218], 
[6.7547240532336801, 6.9113486353390883, 6.1239995008305979, 3.0897194451777992], [7.7345065297748192, 2.8542740323560825, 
3.1362718714822719, 4.785899022888402]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_expandedData_rank1_taggedData_rank0(self):
      arg0=Data(numpy.array([0.80929201712783261, -3.0232613540115971]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([4.9079126176914869, 1.7942738720511633]))
      arg0.expand()
      arg1=Data(-0.180910647951,self.functionspace)
      arg1.setTaggedValue(1,1.81047511659)
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([0.62838136917635179, -3.2041720019630779])+(1.-msk_ref)*numpy.array([6.718387734277651, 
3.6047489886373274])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_expandedData_rank1_taggedData_rank1(self):
      arg0=Data(numpy.array([-3.9207435107391619, -0.18616363765785415]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-1.3020411507337224, -1.9274563263847377]))
      arg0.expand()
      arg1=Data(numpy.array([2.6409002669088242, -0.16509632064916602]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([-1.1457474088113937, 0.047187044765728103]))
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-1.2798432438303378, -0.35125995830702017])+(1.-msk_ref)*numpy.array([-2.4477885595451161, 
-1.8802692816190096])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_expandedData_rank2_taggedData_rank0(self):
      arg0=Data(numpy.array([[-0.70236061896644753, -2.8316337434429686, -2.5230799831500939, -0.27478750881053227, 
-0.32207917758465854], [-0.72751176042763177, 1.2534020127531598, 2.7850214758180369, 0.7744273344355328, -1.85117007682158], 
[1.1682965882407093, 4.1219321024378441, 1.8298951431235242, -0.45836701135850078, 4.0375395909036946], [1.2358207568680957, 
-0.74904193312522072, -2.90501248696027, -1.1549577720689874, 1.0802322344956528]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-1.135259255437834, -4.0605164126395561, 1.9602014586240548, 1.99013820885272, 
-1.1636665482056054], [2.4143402295483511, 2.381395234151845, 3.2465414012138343, -4.2126622637372879, -2.985807298859986], 
[-3.3799959148332737, 2.4924718786761426, -3.1968806678282489, 2.9049273768454409, -3.132726627661083], [-1.9599902064707297, 
-1.6877144690519552, -2.8522135517282776, -1.7299899908812231, -1.3734312068273677]]))
      arg0.expand()
      arg1=Data(3.05652242336,self.functionspace)
      arg1.setTaggedValue(1,-2.96654705618)
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[2.3541618043940966, 0.22488867991757555, 0.53344244021045029, 2.7817349145500119, 
2.7344432457758856], [2.3290106629329124, 4.3099244361137039, 5.8415438991785811, 3.8309497577960769, 1.2053523465389642], 
[4.2248190116012534, 7.1784545257983883, 4.8864175664840683, 2.5981554120020434, 7.0940620142642388], [4.2923431802286398, 
2.3074804902353234, 0.1515099364002741, 1.9015646512915567, 
4.1367546578561969]])+(1.-msk_ref)*numpy.array([[-4.1018063116145704, -7.0270634688162925, -1.0063455975526812, 
-0.976408847324016, -4.130213604382341], [-0.55220682662838483, -0.58515182202489102, 0.2799943450370983, -7.1792093199140243, 
-5.9523543550367215], [-6.3465429710100096, -0.47407517750059336, -6.1634277240049844, -0.061619679331295085, 
-6.0992736838378185], [-4.9265372626474662, -4.6542615252286907, -5.8187606079050136, -4.6965370470579586, 
-4.3399782630041042]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_expandedData_rank2_taggedData_rank2(self):
      arg0=Data(numpy.array([[-4.0115580793347396, -3.9115411000693956, 3.3422015498583431, 3.2471032583186918, 
0.075007607652982422], [-2.424844342892686, -0.96964930869070187, 2.6313094080828989, -2.4632679204807326, 
-0.85914190427453274], [3.1182053239320826, -0.63833050606772268, 2.5635646833134009, -0.29733590393634568, 4.762028519345046], 
[3.9458513710283309, -4.5852711463383109, 2.1396489207037295, -1.2471322746621416, -2.5133185113433254]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-0.98651600462453004, 3.3372687384897102, -3.4523962784095783, 0.4908688183780372, 
-3.4460049101024994], [-4.4862055715577913, -0.71280684687539875, 3.5969814126816111, 3.8189390853205456, -1.386541004551173], 
[1.3200548644920316, 2.2830021271361032, 3.0891943774822721, -2.1329983975916478, -3.1036293829535677], [1.2714342105214502, 
-1.3794435044637741, 2.6610639918086481, -2.4262466165940513, 0.60269422760232239]]))
      arg0.expand()
      arg1=Data(numpy.array([[1.0775481350434992, -2.5617765385565394, -3.9385244095842853, 4.7186191248444782, 
0.19372823432001862], [-1.5079653848711096, 2.4629539584803615, 4.4790296730645363, -4.0052819904932422, 1.3366594216822358], 
[2.4530596993840925, -2.8563451472667745, 3.8959844577989209, -2.4355882126877382, 4.7620117137490432], [-3.9847457542944129, 
-1.2419638119020169, -4.628173872721475, -1.2316129038081316, -2.542915611693374]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[3.2801422551722208, -3.2001379019042728, 1.9386060509276328, -0.6343578038092792, 
2.4970640529954551], [3.3339989661476412, 0.13020858986709172, -3.5889649965363732, 4.2746678182879556, -3.1309201312340198], 
[3.3987174890818821, -0.12045536368415277, -3.7271839724906597, -2.8025546425558079, 3.1377656385129189], [0.41768192493044776, 
-2.3514163371400922, -0.40411830993402731, -0.18622924410114905, -3.5850464751678004]]))
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-2.9340099442912404, -6.473317638625935, -0.59632285972594223, 7.9657223831631701, 
0.26873584197300104], [-3.9328097277637957, 1.4933046497896596, 7.1103390811474352, -6.4685499109739748, 0.4775175174077031], 
[5.5712650233161751, -3.4946756533344971, 6.4595491411123218, -2.7329241166240839, 9.5240402330940892], [-0.038894383266081967, 
-5.8272349582403278, -2.4885249520177455, -2.4787451784702732, 
-5.0562341230366989]])+(1.-msk_ref)*numpy.array([[2.2936262505476908, 0.13713083658543734, -1.5137902274819455, 
-0.143488985431242, -0.94894085710704434], [-1.1522066054101501, -0.58259825700830703, 0.008016416145237848, 
8.0936069036085012, -4.5174611357851928], [4.7187723535739137, 2.1625467634519504, -0.63798959500838759, -4.9355530401474557, 
0.034136255559351181], [1.689116135451898, -3.7308598416038663, 2.2569456818746207, -2.6124758606952003, -2.982352247565478]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_expandedData_rank3_taggedData_rank0(self):
      arg0=Data(numpy.array([[[1.3613762104190652, 1.3843361659253368], [-4.8882025721388933, 2.3768353989384003]], 
[[-1.5651455508396883, -1.1080692401066794], [3.19018492430558, 2.8815842210053075]], [[0.87225464224080795, 
3.6505059346158646], [3.5824501099399484, -2.5770601275617677]], [[-0.78308001983235176, -4.998338383289731], 
[-2.6029389154959781, -3.1441348974279659]], [[-2.7351228596818791, 2.6420212856489567], [-1.4028160029441206, 
3.2376128121254588]], [[0.0023433351289172677, 2.0452237305785905], [-2.4436198400353915, 
-4.9098269992558317]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[1.6407191815663937, -4.9712820456137061], [2.5677485452510105, 
-0.38854616011846232]], [[1.1274666373448436, -3.5503229193973187], [-0.27975212822824069, 3.7157570943364249]], 
[[2.2436838212484433, 1.3050846542375361], [-4.5216280952072641, 0.23229862769504006]], [[3.8565267209400638, 
-2.0842611242937092], [-1.5286611676183282, 2.3717581363524909]], [[0.19484150706488812, 1.1849044110413836], 
[-2.3697892585564984, -4.3130582185511193]], [[-0.37362413938585881, 4.4645720254756487], [-0.93847747999767961, 
3.3763498356594255]]]))
      arg0.expand()
      arg1=Data(0.877236153856,self.functionspace)
      arg1.setTaggedValue(1,3.39944902862)
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[2.2386123642755074, 2.261572319781779], [-4.0109664182824512, 3.2540715527948425]], 
[[-0.68790939698324616, -0.23083308625023724], [4.0674210781620221, 3.7588203748617497]], [[1.7494907960972501, 
4.5277420884723067], [4.4596862637963905, -1.6998239737053256]], [[0.094156134024090399, -4.1211022294332889], 
[-1.725702761639536, -2.2668987435715238]], [[-1.8578867058254369, 3.5192574395053988], [-0.52557984908767841, 
4.114848965981901]], [[0.87957948898535943, 2.9224598844350327], [-1.5663836861789493, 
-4.0325908453993895]]])+(1.-msk_ref)*numpy.array([[[5.0401682101872334, -1.5718330169928665], [5.9671975738718501, 
3.0109028685023773]], [[4.5269156659656833, -0.15087389077647906], [3.1196969003925989, 7.1152061229572645]], 
[[5.643132849869283, 4.7045336828583757], [-1.1221790665864244, 3.6317476563158797]], [[7.2559757495609034, 
1.3151879043271304], [1.8707878610025115, 5.7712071649733305]], [[3.5942905356857278, 4.5843534396622232], [1.0296597700643413, 
-0.91360918993027962]], [[3.0258248892349808, 7.8640210540964883], [2.46097154862316, 6.7757988642802651]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_expandedData_rank3_taggedData_rank3(self):
      arg0=Data(numpy.array([[[-0.49433211035442781, -3.1765458851202233], [-4.1893284008452403, 4.2517707082428231]], 
[[-2.1824291577499477, 4.9652666631782942], [-0.8740708277257534, -2.6209817768842436]], [[1.9106108321510762, 
2.7906668899216012], [2.9500709780113885, 2.6968994240656361]], [[-1.2814325545684788, 3.9514616844641726], 
[-1.0113518291487389, 4.1636168724772915]], [[3.6064448093308279, -2.7713757478360601], [2.939428921495626, 
-3.5601557586759136]], [[-2.4084878771765519, -3.869092458801302], [1.0735422879837673, 
3.5276360855231594]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-0.24197860318896058, 4.0067713139938395], [-4.5255720512712241, 
-2.3954846037942703]], [[-4.8107535798266765, -0.47762042161175611], [0.29501719287529227, -2.9909445490373878]], 
[[-3.1808045122862696, -2.5604962735248393], [-2.9056229938036005, -0.33285255602072183]], [[2.8498953423489004, 
3.0792398005565911], [1.4992987159092062, 0.22318145473081774]], [[0.5154616895678128, -1.5441935253973837], 
[4.0106872170360734, 1.627819624898649]], [[2.6946371585565831, 0.63028875672097406], [2.1199068884445662, 
4.2261442345706541]]]))
      arg0.expand()
      arg1=Data(numpy.array([[[-4.7299390917499338, 3.5251272477839226], [-1.6631345678465026, -4.2129608920047579]], 
[[2.3585633451710306, -0.63258988887624312], [4.5316808451203858, 2.3411219579553775]], [[0.049999481040123861, 
4.4213584054115547], [1.5777788806916728, 4.4382516213399281]], [[2.5230536746068992, 2.2871490792573628], [4.5151731102077992, 
-3.9328431151465812]], [[-2.3307881563968227, 1.6236877584919345], [4.9548760146371169, 1.0649177732508743]], 
[[1.0892879127863067, 3.6475714584078922], [2.480803001738769, 1.115865198388053]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[-4.5168295451453364, -4.9759944775001568], [-4.3122999509575957, 
0.57817113141019405]], [[4.8256436296695941, -3.2980771820521273], [-1.9115461324156002, -3.2336020872104312]], 
[[-2.3147622754959296, 4.0866177069951082], [4.4952728317858757, -3.6588289454448217]], [[2.0631653606906806, 
0.36867447796300379], [0.26914745682765062, -2.6399989236996522]], [[-4.5578928544524171, 3.8373599989536906], 
[-3.0989196371388394, 1.1501446987116672]], [[1.6686999744944764, -1.8061409555768924], [1.9663186665535779, 
4.9627344692016973]]]))
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-5.2242712021043616, 0.34858136266369932], [-5.8524629686917429, 0.038809816238065231]], 
[[0.17613418742108289, 4.3326767743020511], [3.6576100173946324, -0.27985981892886613]], [[1.9606103131912, 
7.2120252953331558], [4.5278498587030613, 7.1351510454055642]], [[1.2416211200384204, 6.2386107637215353], [3.5038212810590603, 
0.23077375733071026]], [[1.2756566529340052, -1.1476879893441256], [7.8943049361327429, -2.4952379854250393]], 
[[-1.3191999643902452, -0.22152100039340983], [3.5543452897225363, 
4.6435012839112124]]])+(1.-msk_ref)*numpy.array([[[-4.758808148334297, -0.96922316350631732], [-8.8378720022288206, 
-1.8173134723840763]], [[0.014890049842917641, -3.7756976036638834], [-1.616528939540308, -6.224546636247819]], 
[[-5.4955667877821988, 1.5261214334702689], [1.5896498379822752, -3.9916815014655436]], [[4.913060703039581, 
3.4479142785195949], [1.7684461727368568, -2.4168174689688344]], [[-4.0424311648846043, 2.2931664735563069], 
[0.911767579897234, 2.7779643236103162]], [[4.3633371330510595, -1.1758521988559183], [4.0862255549981441, 
9.1888787037723514]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_expandedData_rank4_taggedData_rank0(self):
      arg0=Data(numpy.array([[[[-2.4670392294058718, -2.1717241516917807, 3.3149797881216347, -0.63156956386832341], 
[1.8411356708754152, -4.2710445580609067, -4.9016457136475484, 2.3498397075023529], [-3.8611613457679352, -4.7966887572831389, 
-3.6822657503249081, 4.4339648393893487]], [[-0.35722154387227789, -0.75729799875302461, 1.7556459457049822, 
3.7321418993475657], [2.8966627313499824, 2.3214925950484675, -4.2180152634433474, -4.262561307572823], [-0.12493798968600522, 
-2.6037054443164873, -3.3576044058042043, -4.9740423364133957]]], [[[-2.6782453692939168, -0.41258793353016543, 
1.0550093451397906, -2.7153538521757445], [-3.7507591136182592, 1.5862517667809577, -4.8056125125113951, 2.3204066257049067], 
[0.24151004086578443, 3.0049126605399383, -1.7206116498350585, -2.2714155931801772]], [[3.8122961293074393, 
-3.2965687415664102, 3.0751008671417228, 0.21840262799808663], [-3.0621265029594404, -4.4538180263260578, -2.1983384619060597, 
0.8952051693609171], [2.3311589374421624, 2.0581259782752772, -4.3383532680774683, 2.0910505776362225]]], 
[[[-0.95797296297193313, -0.51383561763351082, -2.0247725735326947, -1.3631950968466136], [2.0826868449445666, 
-0.41696113305525806, -4.497826433287285, -0.78294182636422072], [-1.7637079765908514, 2.9527264178147572, 0.51405258722394365, 
-3.4504391400785019]], [[4.8636798396573919, -1.105829341603294, 1.6065955731858867, 4.6992242901612276], [0.30753189038131179, 
0.70097861710806342, 3.9439111486689953, -4.5801498290231741], [3.8878772950275291, 1.342731269940316, 3.8162519888287676, 
-4.260106052214705]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[2.0083473459413685, -3.2949928452634158, -1.9959950629475163, -3.4084261712842565], 
[-4.2870982025005642, -4.7150193724018425, 3.9664031071544521, -0.10661388970505481], [-3.6905987841883938, 3.2332213195638246, 
-0.48443240888530426, -3.034664574850634]], [[-4.5389896736265287, -3.8243670800480292, -4.968675999778382, 
-1.3980710183170784], [-4.3270437629039087, -1.1680198433843092, 0.15408998012602648, 2.7411686705566476], [-2.700768322316347, 
2.1293493224079016, 1.1963627696265631, -2.2786623738313749]]], [[[4.2390004903035834, -1.8857659193087963, 
-0.49967866382512938, -2.4376331862798759], [-0.65571043092810033, -2.0136112041546941, -1.3833181751640233, 
0.76229182116326033], [1.3965577922917936, -4.296139128579302, 4.5661531718371826, 4.343662409846047]], [[0.8809476841802466, 
-4.117945134933402, 2.3985199189466213, 3.1538007275587496], [-0.99305189944676275, -3.2687725605641536, 2.969337331717278, 
3.1876036603472855], [-1.084628238314381, 0.23054877654551298, -2.1994486007823646, 4.2968600406788902]]], 
[[[3.6114962861852522, 0.7063441206652854, -3.898292706215909, 3.4420251667724404], [2.7781453491755315, 2.9903760203971519, 
-1.0709754945607211, -4.3563936413693813], [0.67217466929971881, -3.5549569786984794, -2.8177228917486885, 
4.7360290638166767]], [[-0.23824265289269952, -1.1933440031154552, 2.2134826854452303, 4.9816465253804747], 
[-4.522756527654872, -1.1842822842700604, -0.8773402851242853, 4.7433213464057413], [-4.3008962551228258, 0.4466377408854143, 
-4.2663641086967505, -1.8141139538407125]]]]))
      arg0.expand()
      arg1=Data(-0.493921840889,self.functionspace)
      arg1.setTaggedValue(1,-4.24596595664)
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-2.9609610702950793, -2.6656459925809881, 2.8210579472324273, -1.1254914047575308], 
[1.3472138299862078, -4.7649663989501141, -5.3955675545367558, 1.8559178666131455], [-4.3550831866571427, -5.2906105981723464, 
-4.1761875912141155, 3.9400429985001413]], [[-0.85114338476148532, -1.251219839642232, 1.2617241048157748, 3.2382200584583583], 
[2.402740890460775, 1.8275707541592601, -4.7119371043325549, -4.7564831484620305], [-0.61885983057521265, -3.0976272852056947, 
-3.8515262466934117, -5.4679641773026031]]], [[[-3.1721672101831242, -0.90650977441937286, 0.56108750425058318, 
-3.209275693064952], [-4.2446809545074666, 1.0923299258917503, -5.2995343534006025, 1.8264847848156993], [-0.25241180002342301, 
2.5109908196507309, -2.214533490724266, -2.7653374340693846]], [[3.3183742884182319, -3.7904905824556177, 2.5811790262525154, 
-0.2755192128911208], [-3.5560483438486479, -4.9477398672152653, -2.6922603027952672, 0.40128332847170967], [1.837237096552955, 
1.5642041373860698, -4.8322751089666758, 1.5971287367470151]]], [[[-1.4518948038611406, -1.0077574585227183, 
-2.5186944144219021, -1.857116937735821], [1.5887650040553591, -0.91088297394446549, -4.9917482741764925, -1.2768636672534281], 
[-2.2576298174800589, 2.4588045769255498, 0.020130746334736216, -3.9443609809677094]], [[4.3697579987681845, 
-1.5997511824925015, 1.1126737322966793, 4.2053024492720201], [-0.18638995050789564, 0.20705677621885599, 3.4499893077797879, 
-5.0740716699123816], [3.3939554541383217, 0.84880942905110857, 3.3223301479395602, 
-4.7540278931039124]]]])+(1.-msk_ref)*numpy.array([[[[-2.2376186106955638, -7.5409588019003486, -6.2419610195844486, 
-7.6543921279211888], [-8.5330641591374956, -8.960985329038774, -0.27956284948248022, -4.3525798463419871], 
[-7.9365647408253261, -1.0127446370731077, -4.7303983655222366, -7.2806305314875663]], [[-8.784955630263461, 
-8.0703330366849606, -9.2146419564153135, -5.6440369749540107], [-8.5730097195408419, -5.4139858000212415, -4.0918759765109058, 
-1.5047972860802847], [-6.9467342789532793, -2.1166166342290307, -3.0496031870103693, -6.5246283304683068]]], 
[[[-0.0069654663333489353, -6.1317318759457287, -4.7456446204620617, -6.6835991429168082], [-4.9016763875650327, 
-6.2595771607916264, -5.6292841318009561, -3.483674135473672], [-2.8494081643451388, -8.5421050852162352, 0.32018721520025029, 
0.097696453209114686]], [[-3.3650182724566857, -8.3639110915703334, -1.847446037690311, -1.0921652290781827], 
[-5.2390178560836951, -7.5147385172010859, -1.2766286249196543, -1.0583622962896468], [-5.3305941949513134, 
-4.0154171800914193, -6.4454145574192969, 0.050894084041957832]]], [[[-0.63446967045168012, -3.5396218359716469, 
-8.1442586628528417, -0.80394078986449191], [-1.4678206074614009, -1.2555899362397804, -5.3169414511976534, 
-8.6023595980063128], [-3.5737912873372135, -7.8009229353354117, -7.0636888483856204, 0.49006310717974433]], 
[[-4.4842086095296319, -5.4393099597523875, -2.032483271191702, 0.73568056874354237], [-8.7687224842918035, 
-5.4302482409069928, -5.1233062417612176, 0.497355389768809], [-8.546862211759759, -3.799328215751518, -8.512330065333682, 
-6.0600799104776453]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_add_overloaded_expandedData_rank4_taggedData_rank4(self):
      arg0=Data(numpy.array([[[[-4.7054781107127974, -1.4116130410076746, 2.714334175205626, 1.9250621125283836], 
[-4.5468059590885703, 4.9179842285111715, 0.033743125509129612, -0.71232182747602035], [3.2347025724030622, -4.004944945462098, 
4.5215230445846686, -2.8576488232783923]], [[-0.5804333785546989, -2.1744146096170978, 1.8122435628275904, 1.8166701356980806], 
[3.4457810107765301, -4.7141760010833087, -4.5679815731647633, 4.6246918604602953], [0.90794415750508151, 4.5081465366007514, 
3.717516097109506, -0.1305193864600307]]], [[[-2.9028984821613522, -1.4138464565433981, 1.365541067767011, 
0.39348601233827463], [-1.363317163746375, -4.3256750717726682, -3.4345691090931254, 4.2989770418290334], [-2.3372500742519584, 
4.8363057878893212, 3.3968022788164394, -0.13837785112691048]], [[0.64766290881155619, 3.1076336202757489, -1.8044252528487115, 
-2.5402070277492186], [-3.3941267904706915, 4.3144181832757713, 4.3880286262231643, 4.3163485193123492], [-4.0277567617899814, 
3.7335239284341633, -1.1069127234267628, 2.2366323585363244]]], [[[0.14584015602855072, 0.43579836015438822, 
-4.4009796646991726, 0.25273893761006683], [-4.2098106138810607, 1.7523623238501731, -3.4464752064990032, 0.96757386379993093], 
[0.17599394257364587, -1.6977529114570764, 0.42045176975052367, -0.23188051189599435]], [[-3.9007247156707447, 
0.58924374484124264, -1.29215639690372, 2.9597859831415576], [-3.6154789619537988, 0.67718659825155569, -0.45859334722689482, 
-0.9168635982010187], [-0.18050555742376417, 0.44702138875273434, 4.6425827755726381, 
2.7183898347419619]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[-2.4372489425641364, 0.89694567587970297, -1.3743322216798437, 1.5351393688574593], 
[2.4169012856644834, -2.5679466025636701, 1.2377139715512886, -4.709612004218612], [1.705624246813592, 3.6310154360026221, 
4.0146058539537073, -2.7658583539257586]], [[-3.8411464996918609, 4.834194526145847, -1.2783176271934527, 
-0.46426689345233996], [-2.3018814310857003, -2.2545943443649277, 0.46239592757490033, 2.924494402530522], 
[0.96678112834927177, -1.8297145893093147, 3.523768564351176, 0.41439057070577334]]], [[[1.3933082041938558, 
-1.1715016547469803, -4.4765266133560209, 0.41089405019281511], [-3.2948108505301921, -2.0290960333424932, -2.9275772709955206, 
2.1054103413883762], [-2.3651766616621748, -1.6061393387634215, -3.2846191528893143, 4.478642907241623]], [[-2.040482885766528, 
-3.1420495356307452, -4.8710187828583154, 4.5877755899757435], [4.9411169434284616, -1.7680112260062142, -0.93264792274807906, 
1.665205762815023], [-4.6674511105618199, 2.7845375819494382, 0.56908671378237052, -4.3458243472767677]]], 
[[[3.9108671878375123, -1.2081792206276463, -1.4710258177612201, -2.8127836532183412], [4.445090641367889, -1.4153177942108597, 
4.4910411246426563, -4.8555326878166145], [2.970427569864893, 4.150328544271698, -4.9829204756684753, -4.4863195269932579]], 
[[2.3071472115563516, 2.3512446945872112, 2.4900629727483583, -2.2157497627914022], [-2.8150148015348222, -1.1085485669835138, 
3.1851857647582822, 2.5499597943510732], [0.31179086064204586, 3.2422197077768402, 0.8136416125391861, -3.4554147204177053]]]]))
      arg0.expand()
      arg1=Data(numpy.array([[[[2.9319165341354214, -1.1830229990079588, -2.5147038609579564, -0.73241804251354736], 
[1.5358899950889118, 4.5913636836205303, -2.6633350526879807, 1.0016857219956519], [-2.0707132919920292, -2.2131691830173095, 
4.0269638544497806, 2.8000625212547625]], [[-1.5210489031766139, -1.6606361092694186, -1.3884018523686938, 1.1247628455235423], 
[3.8256187219297217, 3.4751676357835848, 2.9831429461594894, -3.3236453258988066], [0.60032886740104807, -0.99401949114208055, 
3.9102144863542598, 4.0928168283069475]]], [[[-4.8633753019535622, 2.9945457364900649, -3.4907335109291369, 
-3.8315717507052005], [3.8005019867171459, -4.2293311745177222, -2.8990623693543394, 0.11330902535641663], 
[-1.6801976774973229, -0.10856001195497278, 1.005529481849341, 4.0132800810116223]], [[1.550334744198957, -0.70561280144328631, 
4.5995296848949749, -1.9444144256571483], [1.5330371027830783, -0.20500519521782223, 0.53492289156470729, 3.467441465543077], 
[-2.2160479747528372, -4.5427710210627437, -3.6886933034995986, -3.9306876973570115]]], [[[2.9287841476065175, 
0.73117768469728794, -0.32947077132669556, -1.0624405707998177], [-2.3898086943096097, -3.9513293566967511, 
-0.2878823021803818, -2.4471043217610355], [-4.7431801222810801, -3.6238404805102951, -2.0277903869170268, 
-4.1279069100541328]], [[1.2998472637072052, -1.8960629918083702, -3.4776604844668082, 2.5749293450379973], 
[0.67616417091072556, -4.6879370894952519, 4.3237819217077185, 4.1935774669636334], [-3.3266490685983765, 2.9881945924724285, 
0.57753415146789866, -2.3896587103693556]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[-0.2012934520522025, -2.9201458788401458, -2.8759121049090162, 4.2983485984695733], 
[0.30097735113351209, -1.1590380729278724, 0.833876439342081, -0.35100511117572619], [1.1879356108592525, 1.1357991021886686, 
-1.1034194130098216, 3.4197046703623393]], [[-4.3944798112503953, -3.0897847255520352, 4.1216726135889168, 
0.28314873938209306], [2.1233133380948512, -0.1142827384533307, 1.5715126215691608, 2.8581110877262041], [0.43529014265034149, 
-4.0431161990840261, 0.28517150386755574, 1.1630004946746428]]], [[[-0.40090647848700911, -0.033958262665528594, 
-4.4046266720225402, -1.0174464891618706], [-1.2928092051399309, -3.1377860979606176, 2.8953199135128314, 4.298600537254984], 
[2.7079316736133929, 0.59649279625180363, 3.4342585300929187, -1.4025729378588334]], [[4.8668497777227806, -4.0730751636431659, 
-3.1108293386157069, -1.0010286808478797], [1.2255117879225157, -1.7574474629526824, -1.3657737681314064, -2.9904846031384813], 
[-0.83078235278007995, 2.1535446966353486, -4.8933233652356725, 4.7718296568892367]]], [[[-1.4857526121737976, 
3.3637722951763429, 1.7148007856717502, -0.90792789244099303], [-2.4288260081949007, -3.2223337912639272, 3.1839565592321488, 
-0.82691647771790322], [-1.7756994676030455, 0.17382075500737137, 1.4842870166456779, 2.5875967429437043]], 
[[-2.7219626333962887, -4.3789117218553306, 0.45213782278823356, -4.6410462583353755], [-4.9255613877949287, 
-3.4882296997458884, 2.9986183389018786, -4.6623658743604315], [-4.7340321240993024, 1.77401322635549, -3.5218646283090504, 
3.2587336617460316]]]]))
      res=arg0+arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-1.773561576577376, -2.5946360400156334, 0.19963031424766964, 1.1926440700148362], 
[-3.0109159639996586, 9.5093479121317017, -2.629591927178851, 0.28936389451963151], [1.163989280411033, -6.2181141284794075, 
8.5484868990344491, -0.057586302023629798]], [[-2.1014822817313128, -3.8350507188865164, 0.42384171045889651, 
2.9414329812216229], [7.2713997327062518, -1.2390083652997239, -1.5848386270052739, 1.3010465345614888], [1.5082730249061296, 
3.5141270454586708, 7.6277305834637659, 3.9622974418469168]]], [[[-7.7662737841149143, 1.5806992799466668, -2.1251924431621259, 
-3.4380857383669259], [2.4371848229707709, -8.5550062462903895, -6.3336314784474652, 4.41228606718545], [-4.0174477517492813, 
4.7277457759343484, 4.4023317606657804, 3.8749022298847118]], [[2.1979976530105132, 2.4020208188324625, 2.7951044320462635, 
-4.4846214534063673], [-1.8610896876876133, 4.1094129880579491, 4.9229515177878715, 7.7837899848554262], [-6.2438047365428186, 
-0.80924709262858041, -4.795606026926361, -1.6940553388206872]]], [[[3.0746243036350682, 1.1669760448516762, 
-4.7304504360258681, -0.80970163318975086], [-6.59961930819067, -2.198967032846578, -3.734357508679385, -1.4795304579611046], 
[-4.5671861797074342, -5.3215933919673715, -1.6073386171665032, -4.3597874219501271]], [[-2.6008774519635396, 
-1.3068192469671276, -4.7698168813705282, 5.5347153281795549], [-2.9393147910430732, -4.0107504912436962, 3.8651885744808236, 
3.2767138687626147], [-3.5071546260221407, 3.4352159812251628, 5.2201169270405368, 
0.32873112437260632]]]])+(1.-msk_ref)*numpy.array([[[[-2.6385423946163389, -2.0232002029604428, -4.2502443265888594, 
5.8334879673270326], [2.7178786367979955, -3.7269846754915426, 2.0715904108933696, -5.0606171153943382], [2.8935598576728445, 
4.7668145381912908, 2.9111864409438857, 0.65384631643658064]], [[-8.2356263109422567, 1.7444098005938118, 2.8433549863954641, 
-0.1811181540702469], [-0.17856809299084908, -2.3688770828182584, 2.0339085491440612, 5.7826054902567261], [1.4020712709996133, 
-5.8728307883933404, 3.8089400682187318, 1.5773910653804162]]], [[[0.9924017257068467, -1.2054599174125089, 
-8.8811532853785611, -0.60655243896905553], [-4.587620055670123, -5.1668821313031108, -0.032257357482689208, 
6.4040108786433603], [0.34275501195121816, -1.0096465425116179, 0.14963937720360443, 3.0760699693827895]], 
[[2.8263668919562526, -7.2151246992739111, -7.9818481214740222, 3.5867469091278639], [6.1666287313509773, -3.5254586889588966, 
-2.2984216908794854, -1.3252788403234583], [-5.4982334633418999, 4.9380822785847869, -4.3242366514533019, 
0.42600530961246896]]], [[[2.4251145756637147, 2.1555930745486966, 0.2437749679105301, -3.7207115456593343], 
[2.0162646331729883, -4.6376515854747868, 7.6749976838748051, -5.6824491655345177], [1.1947281022618474, 4.3241492992790693, 
-3.4986334590227974, -1.8987227840495535]], [[-0.41481542183993714, -2.0276670272681194, 2.9422007955365919, 
-6.8567960211267778], [-7.7405761893297509, -4.5967782667294017, 6.1838041036601608, -2.1124060800093583], 
[-4.4222412634572565, 5.0162329341323302, -2.7082230157698644, -0.19668105867167363]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_float_rank0_taggedData_rank0(self):
      arg0=2.24633892242
      arg1=Data(2.12331690395,self.functionspace)
      arg1.setTaggedValue(1,-3.57945011345)
      res=arg0-arg1
      ref=Data(0.12302201847,self.functionspace)
      ref.setTaggedValue(1,5.82578903587)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_float_rank0_taggedData_rank1(self):
      arg0=4.36937077047
      arg1=Data(numpy.array([-0.8596348478870528, 4.9634041759958727]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([1.7796254796584527, 0.29688626044431388]))
      res=arg0-arg1
      ref=Data(numpy.array([5.2290056183616418, -0.5940334055212837]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([2.5897452908161362, 4.0724845100302751]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_float_rank0_taggedData_rank2(self):
      arg0=-3.61750107712
      arg1=Data(numpy.array([[-1.4971895854479502, -4.3382182424687556, -4.746147516186209, 2.7830979159397078, 
3.6315907342794382], [-3.8468185460872286, 2.8342418655175532, -0.026796419492885803, -2.9627548546321325, -3.705469064070245], 
[-4.0382593327174368, -4.0755855410260029, -2.9961923784962172, 4.0269129356067186, -4.0804410511199398], [3.1517955168355059, 
4.9670475785543857, 3.1343680969174219, 0.11943878269518127, 0.41324038781581418]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[1.1785908847416771, -4.3645441489070036, 1.6337481333804336, -0.10034452865834709, 
-2.1875540224321091], [2.3849168435941177, -4.7967726523464451, 1.3872226467081408, 4.5127180252194812, -1.9306808054309901], 
[-2.9522583030391223, 4.4345991252371793, -3.8122990278625801, 4.1399154587564553, -2.8122237852911702], [-2.5444378920775677, 
0.39323904870532811, -0.28112845979059742, 4.337251242767131, -0.46239162049305005]]))
      res=arg0-arg1
      ref=Data(numpy.array([[-2.1203114916712815, 0.7207171653495239, 1.1286464390669773, -6.4005989930589395, 
-7.24909181139867], [0.22931746896799687, -6.4517429426367849, -3.5907046576263459, -0.65474622248709924, 
0.087967986951013266], [0.42075825559820501, 0.45808446390677116, -0.62130869862301452, -7.6444140127259503, 
0.46293997400070808], [-6.7692965939547376, -8.5845486556736184, -6.7518691740366537, -3.736939859814413, 
-4.0307414649350459]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-4.7960919618609088, 0.74704307178777185, -5.2512492104996653, -3.5171565484608847, 
-1.4299470546871227], [-6.0024179207133495, 1.1792715752272134, -5.0047237238273725, -8.1302191023387138, -1.6868202716882417], 
[-0.66524277408010946, -8.0521002023564101, 0.19479795074334838, -7.757416535875687, -0.80527729182806151], 
[-1.0730631850416641, -4.0107401258245599, -3.3363726173286343, -7.9547523198863628, -3.1551094566261817]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_float_rank0_taggedData_rank3(self):
      arg0=-1.81931893096
      arg1=Data(numpy.array([[[-4.7434926794164367, 3.0404560011878594], [-2.5884243950167929, 0.37329702651201391]], 
[[0.33126396800144065, -3.2881284307415894], [-1.2510206104014978, 4.3904149422069487]], [[3.0552670030174909, 
-2.7655569610848163], [4.2072012978003244, 0.086014727108176814]], [[1.4980997623462269, -3.783344188558877], 
[0.14598797174621936, 3.4128042687217217]], [[2.3703197483353167, 0.48125867599148719], [-3.9587282772907972, 
-1.867708198016762]], [[-0.47788235243159605, -1.9748182761911872], [-2.9383131474487225, 
2.732060889687828]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[-1.6924722762250886, 1.50437936350718], [-3.4230909990573966, -1.3705958394745554]], 
[[0.7861262779488829, 1.7289037456780267], [3.0191345201237834, -2.7628573155436187]], [[-4.4609466717161785, 
3.9437622422665815], [-4.9525230015153152, -4.2434856753843881]], [[-3.3328287941537438, -3.1592945368805534], 
[3.6337692644740009, 1.5774167134124903]], [[0.32077929918608028, 2.708525022489523], [4.152804097840546, 2.9541045856849752]], 
[[3.9963443256490834, -0.62536733843375902], [1.6310965920678013, 4.1177408597808132]]]))
      res=arg0-arg1
      ref=Data(numpy.array([[[2.924173748461091, -4.8597749321432051], [0.7691054640614472, -2.1926159574673596]], 
[[-2.1505828989567863, 1.4688094997862438], [-0.56829832055384788, -6.2097338731622944]], [[-4.8745859339728366, 
0.94623803012947061], [-6.0265202287556701, -1.9053336580635225]], [[-3.3174186933015726, 1.9640252576035313], 
[-1.9653069027015651, -5.2321231996770674]], [[-4.1896386792906624, -2.3005776069468329], [2.1394093463354515, 
0.04838926706141633]], [[-1.3414365785237496, 0.15549934523584152], [1.1189942164933768, 
-4.5513798206431737]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-0.12684665473025714, -3.3236982944625257], [1.6037720681020509, 
-0.44872309148079026]], [[-2.6054452089042286, -3.5482226766333724], [-4.8384534510791291, 0.94353838458827299]], 
[[2.6416277407608328, -5.7630811732219271], [3.1332040705599695, 2.4241667444290425]], [[1.5135098631983981, 
1.3399756059252077], [-5.4530881954293466, -3.396735644367836]], [[-2.140098230141426, -4.5278439534448687], 
[-5.9721230287958917, -4.7734235166403209]], [[-5.8156632566044291, -1.1939515925215867], [-3.450415523023147, 
-5.9370597907361589]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_float_rank0_taggedData_rank4(self):
      arg0=-2.35990788127
      arg1=Data(numpy.array([[[[1.4490282451737571, 2.3605192834281858, 0.86968066039672909, 1.5931146382109524], 
[3.0214271376186055, 0.50478169677473517, -1.6727134436396787, -4.4228851790088992], [-3.3894625264107772, -3.6510232513544505, 
0.43690738625072978, 0.93545726357107917]], [[0.44329603471090095, -2.6214395325650752, -2.1052527609772884, 
-1.4368313432274151], [-1.8619862775452001, 3.9542151143337314, 3.8018899083553688, 3.6103539644974862], [-2.8313827904879729, 
4.6045263679305766, 4.5440159813162904, -1.9698756214064881]]], [[[-0.8794560684105992, 2.9372094142722514, 
-1.9007976599328105, 3.7353687352824352], [-4.2468946588432912, 4.1696963154117412, 2.6428060884485651, 4.5527182041967293], 
[-4.4338626306741986, 4.66763566368639, -2.4467615047330646, -3.5701378978417675]], [[-0.42054167773123829, 
-4.7103818614047501, 4.3600139646072549, -4.2188829513157291], [3.4671576591234814, -2.411069602764786, -2.3208999529564212, 
-1.7918136861741663], [-3.2415044575976868, 4.7168476663607066, -1.773197824333578, 4.897987022168266]]], 
[[[-2.2865004728494687, 1.3009363510240952, 1.4483142164586855, -4.0167688655453375], [-3.0117026579788408, 
-0.66045912885668479, 1.5570503715959081, 0.2923747234273506], [3.2623249764746376, -2.5189769096307648, 4.1654673369225321, 
1.9158153502212016]], [[4.6460755268725205, 4.0710599159347858, -2.2358353571619514, -2.2147854102227638], 
[-0.098880866897934183, -3.7113546793396823, 1.0502710938596769, -0.10767157406930483], [4.8755455863454387, 
-0.77518644176752538, 1.7949360750718402, -2.3673513023258752]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[1.1144779753097191, -1.3096324062462106, -4.6546641994473195, -4.0417931125670359], 
[2.8428722940145512, 1.948567902364954, -4.2092453089473363, -2.9901618819150855], [3.8800758289905897, 4.1780816624682551, 
1.2789333796174374, -2.988575730939167]], [[-4.8364462068258192, -2.2253041218685956, -0.83849756549164489, 
2.1084940204786822], [1.3896395086263036, 0.046815714473162018, 1.0040852123853075, -3.4699614240370922], [2.1674909919459964, 
2.5651115860351181, 3.3915270725589455, 4.600652505220582]]], [[[2.8234551674238091, -4.7166513417043863, 2.854142805899178, 
-1.6316341984331451], [4.9581182311390073, 4.723600574910531, -0.044209996347966296, 0.59263089022569382], [2.6362996392842408, 
1.4273104931599896, -1.8221536972115837, 0.94547031644500734]], [[-0.65051152225504172, -4.310465167883927, 3.9717429215240312, 
4.9245829804720014], [0.50820209799610616, 3.8544913057316563, -2.9418779852485821, -2.3497450313556421], 
[-0.65657711141949715, 0.22281556830768956, -4.4173046617695979, 4.9864207816900965]]], [[[2.243584684090413, 
2.2716561925075514, 2.314858500936964, 4.9448131751454518], [4.8579435535668605, -0.38247010453868224, -0.018381968238843527, 
-3.0270183441609033], [-3.5483983592519164, 2.8978127566849077, 1.953082571423761, -1.1328371836370978]], [[4.8401171037423953, 
-4.3168782844562639, 4.4270520230403712, 3.9392340955972056], [1.6723405232517834, -3.3767085090388016, 3.8489750880363438, 
-0.68535604066899491], [-2.1419240758294555, 3.1712701903287837, 0.83280945683256569, -0.40557550977455303]]]]))
      res=arg0-arg1
      ref=Data(numpy.array([[[[-3.808936126440039, -4.7204271646944678, -3.229588541663011, -3.9530225194772344], 
[-5.3813350188848874, -2.8646895780410171, -0.68719443762660326, 2.0629772977426173], [1.0295546451444952, 1.2911153700881686, 
-2.7968152675170117, -3.2953651448373611]], [[-2.8032039159771829, 0.2615316512987933, -0.25465512028899351, 
-0.9230765380388668], [-0.49792160372108185, -6.3141229956000133, -6.1617977896216507, -5.9702618457637682], 
[0.471474909221691, -6.9644342491968585, -6.9039238625825723, -0.39003225985979384]]], [[[-1.4804518128556827, 
-5.2971172955385333, -0.45911022133347146, -6.0952766165487171], [1.8869867775770093, -6.5296041966780232, -5.0027139697148471, 
-6.9126260854630113], [2.0739547494079167, -7.027543544952672, 0.086853623466782715, 1.2102300165754856]], 
[[-1.9393662035350436, 2.3504739801384682, -6.7199218458735368, 1.8589750700494472], [-5.8270655403897633, 
0.051161721498504065, -0.039007928309860773, -0.56809419509211567], [0.88159657633140487, -7.0767555476269886, 
-0.58671005693270395, -7.2578949034345479]]], [[[-0.073407408416813258, -3.6608442322903771, -3.8082220977249674, 
1.6568609842790556], [0.65179477671255892, -1.6994487524095971, -3.91695825286219, -2.6522826046936325], [-5.6222328577409195, 
0.15906902836448289, -6.5253752181888141, -4.2757232314874836]], [[-7.0059834081388024, -6.4309677972010677, 
-0.12407252410433056, -0.14512247104351816], [-2.2610270143683477, 1.3514467980734004, -3.4101789751259588, 
-2.2522363071969771], [-7.2354534676117206, -1.5847214394987565, -4.1548439563381221, 
0.0074434210595932804]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-3.4743858565760011, -1.0502754750200713, 2.2947563181810375, 1.681885231300754], 
[-5.2027801752808331, -4.308475783631236, 1.8493374276810544, 0.63025400064880355], [-6.2399837102568716, -6.537989543734537, 
-3.6388412608837193, 0.62866784967288503]], [[2.4765383255595372, -0.13460375939768632, -1.521410315774637, 
-4.4684019017449641], [-3.7495473898925855, -2.4067235957394439, -3.3639930936515894, 1.1100535427708103], 
[-4.5273988732122783, -4.9250194673014001, -5.7514349538252274, -6.9605603864868639]]], [[[-5.183363048690091, 
2.3567434604381043, -5.2140506871654599, -0.72827368283313687], [-7.3180261124052892, -7.0835084561768129, -2.3156978849183156, 
-2.9525387714919757], [-4.9962075205505228, -3.7872183744262715, -0.53775418405469821, -3.3053781977112893]], 
[[-1.7093963590112402, 1.950557286617645, -6.3316508027903131, -7.2844908617382833], [-2.8681099792623881, -6.2143991869979383, 
0.5819701039823002, -0.010162849910639871], [-1.7033307698467848, -2.5827234495739715, 2.057396780503316, 
-7.3463286629563784]]], [[[-4.6034925653566949, -4.6315640737738333, -4.6747663822032459, -7.3047210564117337], 
[-7.2178514348331424, -1.9774377767275997, -2.3415259130274384, 0.66711046289462139], [1.1884904779856345, -5.2577206379511896, 
-4.3129904526900429, -1.2270706976291841]], [[-7.2000249850086773, 1.9569704031899819, -6.7869599043066531, 
-6.2991419768634875], [-4.0322484045180653, 1.0168006277725197, -6.2088829693026257, -1.674551840597287], 
[-0.21798380543682638, -5.5311780715950656, -3.1927173380988476, -1.9543323714917289]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_constData_rank0_taggedData_rank0(self):
      arg0=Data(1.02809037016,self.functionspace)
      arg1=Data(-0.791181091107,self.functionspace)
      arg1.setTaggedValue(1,-3.70038627455)
      res=arg0-arg1
      ref=Data(1.81927146126,self.functionspace)
      ref.setTaggedValue(1,4.72847664471)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_constData_rank0_taggedData_rank1(self):
      arg0=Data(0.0129868918069,self.functionspace)
      arg1=Data(numpy.array([1.3098988208403224, 1.4483182923512326]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([0.67840096743806733, 2.3936442083617324]))
      res=arg0-arg1
      ref=Data(numpy.array([-1.2969119290334534, -1.4353314005443636]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-0.66541407563119837, -2.3806573165548635]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_constData_rank0_taggedData_rank2(self):
      arg0=Data(-0.0812480403954,self.functionspace)
      arg1=Data(numpy.array([[3.7712418305630031, -4.8971484005214769, -4.8369259312379356, -2.325746346367489, 
0.39845660941676009], [-2.9238071941965229, -4.8270989481313773, 3.7843268434582509, -3.4365906356425424, -3.3560960707045417], 
[1.6931267557626182, -2.8831333485991371, -4.0977632060559364, 4.1883564759729062, -1.5076727028578585], [-3.7331595256322925, 
3.7026209875552158, 4.4405981370042298, 2.4415868047073994, 2.0784116901490979]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[4.8509861732696749, 2.9017918975409929, -0.7723392962684823, -3.0499830139961768, 
3.4904822817726089], [1.0008665282717661, -1.0770520581464726, 1.7709908453386625, -1.2607955341433676, 3.3163818940717142], 
[-1.6888199195870057, -4.2346882738893097, 1.0574091718155625, -3.4849277958535971, 3.1682280666210225], [-0.12829543685832689, 
2.1672438291221949, -4.2912153519093268, -4.9541883027385829, 4.9746273742365492]]))
      res=arg0-arg1
      ref=Data(numpy.array([[-3.8524898709584283, 4.8159003601260517, 4.7556778908425104, 2.2444983059720638, 
-0.4797046498121853], [2.8425591538010977, 4.7458509077359521, -3.8655748838536761, 3.3553425952471172, 3.2748480303091165], 
[-1.7743747961580434, 2.8018853082037118, 4.0165151656605111, -4.2696045163683314, 1.4264246624624333], [3.6519114852368673, 
-3.7838690279506411, -4.521846177399655, -2.5228348451028246, -2.1596597305445231]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-4.9322342136651001, -2.9830399379364181, 0.69109125587305709, 2.9687349736007516, 
-3.5717303221680341], [-1.0821145686671914, 0.99580401775104743, -1.8522388857340877, 1.1795474937479424, -3.3976299344671395], 
[1.6075718791915805, 4.1534402334938845, -1.1386572122109877, 3.4036797554581719, -3.2494761070164477], [0.047047396462901681, 
-2.2484918695176201, 4.2099673115139016, 4.8729402623431577, -5.0558754146319744]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_constData_rank0_taggedData_rank3(self):
      arg0=Data(3.44000453865,self.functionspace)
      arg1=Data(numpy.array([[[-3.9388746105101511, 1.4831954073571421], [-3.1023759318661757, -1.1839172454640301]], 
[[0.66794146558085465, 2.6025800491600819], [0.14744126409518543, -1.1543290517588991]], [[4.0958375013525927, 
2.6435957916771367], [-3.7500086450772541, 4.1581189413381896]], [[4.2161409721148342, 3.4796037958276571], 
[-1.933937331361447, -2.2455781965867483]], [[2.6319175595302946, 3.457588897790858], [-0.38187011758422251, 
0.092522201476533894]], [[-1.8040619210028641, -4.2794719022397674], [0.76252797907423098, 
0.22263766388314377]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[-3.1472858218607156, 3.2754514313462089], [-2.6995560873357691, 
-4.0404368140687819]], [[-2.3259291209339708, -3.6247326137991118], [4.1102222038009852, 1.9635641777177684]], 
[[-2.3225803186958185, 1.9328486371072948], [-0.50945128097783599, -0.47060679522847959]], [[-1.8786275652505333, 
3.6243179748405119], [1.0713650100376606, -1.6868464763806621]], [[2.882871567183849, 2.7305396448594692], 
[-4.6527320802468548, 1.9221159768841281]], [[2.7917968308513128, 2.5730963265889875], [0.45869264002980792, 
-2.1472241774415735]]]))
      res=arg0-arg1
      ref=Data(numpy.array([[[7.3788791491562513, 1.9568091312889582], [6.5423804705122759, 4.6239217841101308]], 
[[2.7720630730652456, 0.83742448948601833], [3.2925632745509148, 4.5943335904049993]], [[-0.65583296270649249, 
0.79640874696896358], [7.1900131837233543, -0.71811440269208937]], [[-0.77613643346873396, -0.039599257181556879], 
[5.3739418700075472, 5.685582735232849]], [[0.80808697911580563, -0.017584359144757755], [3.8218746562303227, 
3.3474823371695663]], [[5.2440664596489643, 7.7194764408858676], [2.6774765595718693, 3.2173668747629565]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[6.5872903605068158, 0.16455310729989137], [6.1395606259818694, 7.4804413527148821]], 
[[5.765933659580071, 7.0647371524452121], [-0.67021766515488501, 1.4764403609283319]], [[5.7625848573419187, 
1.5071559015388054], [3.9494558196239362, 3.9106113338745798]], [[5.3186321038966335, -0.18431343619441165], 
[2.3686395286084396, 5.1268510150267623]], [[0.55713297146225127, 0.70946489378663102], [8.092736618892955, 
1.5178885617619722]], [[0.64820770779478742, 0.86690821205711277], [2.9813118986162923, 5.5872287160876741]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_constData_rank0_taggedData_rank4(self):
      arg0=Data(4.97460274863,self.functionspace)
      arg1=Data(numpy.array([[[[-4.9939654358053129, 2.8121895923780276, -3.3132189880007532, 3.2883910500567239], 
[-3.7668966821996461, -4.7163569658069591, 4.865475483012272, 0.70178121597830678], [-0.78797850297611749, 0.5026508650424022, 
-0.11218034048783743, 4.8110859443140832]], [[-0.22737228521368102, 0.31330308437283527, -0.23233430891622309, 
1.4071716498924705], [4.3178613088512829, 4.5155219035339123, 1.5287773021107265, -4.2045559500897953], [-4.1147557416535232, 
-4.4072946725614681, 0.31866103551489555, 0.5672702652081929]]], [[[1.8477313057068114, 2.372709118337605, -1.452379027650518, 
-3.8685846326277487], [2.9606045771913294, -2.7549712378631153, 0.6737510540049696, -2.3611293889411202], [-4.6605145671510577, 
-2.186091110202061, -3.2002318799712604, 1.6500333799128644]], [[-3.3041893953903676, -2.006991711167716, 0.29364524725016494, 
3.494664271449226], [-3.411455440593234, -1.3814323969755717, 0.21466485192673002, -4.2114205453609719], [1.0430098398789962, 
-0.29160913549397804, 4.7554390307005505, 2.9782292939496067]]], [[[-2.7818092271044339, -0.10587476898033366, 
0.083626053133941447, 4.9094043412224337], [-2.6135110784222517, 0.32994502575664875, 3.0600967191960908, 4.4336883375063767], 
[-1.4094707002186766, 3.5071594943447053, 4.7346697340452533, 2.4212993404080159]], [[4.9668733723745966, -2.8618627588242584, 
-0.86663188371572808, -0.21063551167715655], [-3.5805670477769658, -3.6648213026105116, 1.1106487824151303, 
2.8506957841193969], [-4.4180869040538262, 2.2886269655814404, 3.4061890748233168, -0.76685528936654102]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[-4.0783112227489218, 4.1950957573806456, 4.1628770934316979, 4.1560047372684519], 
[4.6570893725412503, 0.71747291148839043, 1.4400808124530027, 1.8637759059170147], [4.4147878467456305, 0.46126741843091423, 
-4.0297303517253011, 2.7202250336251499]], [[-2.4166221864765847, 1.8089640972185972, -2.6299310125853603, 0.6245840780532621], 
[-1.6730139037128899, 1.8264717286533925, 0.74518684445651218, -2.8545127387744982], [-0.7610429982033482, -1.7250893561452409, 
-0.76151488774043674, -3.0602982250270205]]], [[[-0.24391000630833126, 3.7031222364454948, -1.8026059626186774, 
2.6935768774093907], [-3.1279150230919606, 2.7026378705781893, -4.61777217852425, -4.413757664588597], [-3.9929537923619565, 
1.647444640842135, 4.3017959650511077, 0.89206851539878329]], [[-0.31324451849494839, 3.8280725186576845, 3.056128734015358, 
0.4454572852211669], [-3.5257356135444118, -2.9600105721177563, -4.146701151131273, 3.7344978222617957], [-2.4807880051425126, 
2.2631452772119722, -1.7711183470918135, 0.75085178485126391]]], [[[4.6395781393482878, 3.9583438115541831, 
-1.9692732936234334, -2.5266629403937326], [1.3242465522981162, -3.3286905542266765, -0.6623109616851508, 2.9998719044863993], 
[-0.3186266244866065, 3.7404850389828663, 2.6258647394991952, 4.3361646526434789]], [[4.2902500691540251, 1.3515071925423792, 
1.4971141405134736, 2.5271836341642162], [-3.1289885078146398, -0.81501688109510173, -1.9675782437227198, -4.8653339604630341], 
[-4.046657308109066, -3.5782875338252706, -0.090828356135278732, -3.1093305846714081]]]]))
      res=arg0-arg1
      ref=Data(numpy.array([[[[9.9685681844332912, 2.1624131562499507, 8.2878217366287323, 1.6862116985712543], 
[8.7414994308276235, 9.6909597144349373, 0.10912726561570629, 4.2728215326496715], [5.7625812516040957, 4.471951883585576, 
5.0867830891158157, 0.16351680431389504]], [[5.2019750338416593, 4.661299664255143, 5.2069370575442013, 3.5674310987355078], 
[0.6567414397766953, 0.45908084509406599, 3.4458254465172518, 9.1791586987177745], [9.0893584902815014, 9.3818974211894464, 
4.6559417131130827, 4.4073324834197853]]], [[[3.1268714429211668, 2.6018936302903732, 6.4269817762784962, 8.8431873812557278], 
[2.0139981714366488, 7.7295739864910935, 4.3008516946230086, 7.3357321375690985], [9.635117315779036, 7.1606938588300393, 
8.174834628599239, 3.3245693687151139]], [[8.2787921440183467, 6.9815944597956943, 4.6809575013778133, 1.4799384771787523], 
[8.3860581892212132, 6.35603514560355, 4.7599378967012482, 9.1860232939889492], [3.931592908748982, 5.2662118841219563, 
0.21916371792742773, 1.9963734546783716]]], [[[7.7564119757324121, 5.0804775176083119, 4.8909766954940368, 
0.065198407405544501], [7.58811382705023, 4.6446577228713295, 1.9145060294318874, 0.54091441112160155], [6.3840734488466548, 
1.4674432542832729, 0.23993301458272498, 2.5533034082199624]], [[0.007729376253381659, 7.8364655074522371, 5.8412346323437063, 
5.1852382603051348], [8.5551697964049431, 8.639424051238489, 3.8639539662128479, 2.1239069645085813], [9.3926896526818044, 
2.6859757830465378, 1.5684136738046615, 5.7414580379945193]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[9.0529139713768991, 0.77950699124733269, 0.81172565519628037, 0.81859801135952637], 
[0.31751337608672792, 4.2571298371395878, 3.5345219361749756, 3.1108268427109635], [0.55981490188234773, 4.513335330197064, 
9.0043331003532785, 2.2543777150028284]], [[7.3912249351045629, 3.1656386514093811, 7.6045337612133386, 4.3500186705747161], 
[6.6476166523408686, 3.1481310199745858, 4.2294159041714661, 7.8291154874024764], [5.7356457468313264, 6.6996921047732192, 
5.736117636368415, 8.0349009736549988]]], [[[5.2185127549363095, 1.2714805121824835, 6.7772087112466561, 2.2810258712185876], 
[8.1025177717199384, 2.271964878049789, 9.5923749271522283, 9.3883604132165743], [8.9675565409899356, 3.3271581077858432, 
0.67280678357687052, 4.082534233229195]], [[5.2878472671229266, 1.1465302299702937, 1.9184740146126202, 4.5291454634068113], 
[8.5003383621723891, 7.9346133207457346, 9.1213038997592513, 1.2401049263661825], [7.4553907537704909, 2.711457471416006, 
6.7457210957197917, 4.2237509637767143]]], [[[0.33502460927969047, 1.0162589370737951, 6.9438760422514116, 7.5012656890217109], 
[3.6503561963298621, 8.3032933028546552, 5.636913710313129, 1.974730844141579], [5.2932293731145847, 1.2341177096451119, 
2.3487380091287831, 0.6384380959844993]], [[0.68435267947395317, 3.6230955560855991, 3.4774886081145047, 2.447419114463762], 
[8.103591256442618, 5.78961962972308, 6.9421809923506981, 9.8399367090910133], [9.0212600567370451, 8.552890282453248, 
5.065431104763257, 8.0839333332993863]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_constData_rank1_taggedData_rank0(self):
      arg0=Data(numpy.array([-0.79901038736793328, 2.6255255493107992]),self.functionspace)
      arg1=Data(-1.58758117759,self.functionspace)
      arg1.setTaggedValue(1,1.70642894705)
      res=arg0-arg1
      ref=Data(numpy.array([0.78857079022078391, 4.2131067268995164]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-2.5054393344144543, 0.91909660226427814]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_constData_rank1_taggedData_rank1(self):
      arg0=Data(numpy.array([1.0797249744752113, 1.3178333885770313]),self.functionspace)
      arg1=Data(numpy.array([0.25021284632176677, 4.3877975913201368]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([-2.2185901691982957, 4.7563957983664356]))
      res=arg0-arg1
      ref=Data(numpy.array([0.82951212815344455, -3.0699642027431056]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([3.298315143673507, -3.4385624097894043]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_constData_rank2_taggedData_rank0(self):
      arg0=Data(numpy.array([[-4.8787391783131007, -3.8470588922147164, -0.19444963496452505, -3.5305645297945984, 
0.26950949151662762], [0.36577826024208093, 0.66607224318265246, 3.1821242393966802, -0.4809469911610833, 
0.095270811015792489], [0.80254201804662451, -2.9257712286386339, -2.4023882810966359, -4.2785292458633961, 
-4.3163400282394502], [-1.7337230594936202, -1.5191423984004979, 0.65547710341808507, 2.9089252042771445, 
-0.65587650991568047]]),self.functionspace)
      arg1=Data(3.0324779868,self.functionspace)
      arg1.setTaggedValue(1,-4.09906381745)
      res=arg0-arg1
      ref=Data(numpy.array([[-7.9112171651180709, -6.8795368790196871, -3.2269276217694953, -6.5630425165995687, 
-2.7629684952883427], [-2.6666997265628893, -2.3664057436223178, 0.14964625259170994, -3.5134249779660536, 
-2.9372071757891778], [-2.2299359687583458, -5.9582492154436046, -5.4348662679016062, -7.3110072326683664, 
-7.3488180150444204], [-4.7662010462985904, -4.5516203852054682, -2.3770008833868852, -0.12355278252782576, 
-3.6883544967206507]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-0.77967536086561395, 0.25200492523277029, 3.9046141824829617, 0.56849928765288826, 
4.3685733089641143], [4.4648420776895676, 4.7651360606301392, 7.2811880568441669, 3.6181168262864034, 4.1943346284632792], 
[4.9016058354941112, 1.1732925888088528, 1.6966755363508508, -0.1794654284159094, -0.21727621079196346], [2.3653407579538666, 
2.5799214190469888, 4.7545409208655718, 7.0079890217246312, 3.4431873075318062]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_constData_rank2_taggedData_rank2(self):
      arg0=Data(numpy.array([[0.98905346764633162, 1.3732248609436306, 4.397429151220507, -2.1129094157822639, 
4.3837047847887156], [4.5116511446458798, -0.67040467095014833, -2.9903032062327917, 1.5075577468246992, 1.7401774884837762], 
[0.66639756874447986, 1.4708216135024177, 2.9889520580811002, -3.1085299934775534, -2.804748217043854], [4.8129148276455833, 
4.5328088209804172, -2.6567224088936148, 2.6162044585469166, 3.9074765378289769]]),self.functionspace)
      arg1=Data(numpy.array([[-4.1696250451578054, 4.2290989594734913, -0.76289244885488738, -4.4131471239015898, 
1.8589554494474205], [4.1102411375854828, -2.4563968045845117, -0.65743961033977971, -1.507073795796563, 3.0994379254382274], 
[3.376505682443419, -2.5007430025299113, 0.3294329804708962, -3.9447846538174614, -3.3161406293886078], [4.773267482001323, 
0.95507869873370943, -3.5479426661416333, -4.9926441756825755, -2.5687760491529019]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[3.1749293660570785, -2.6958238484112149, -0.96353826041844481, -3.6729701793790346, 
-1.6796272716534775], [1.7424657771105103, -1.586088605322221, 2.0613762968625213, -1.9943430386097214, 0.25088816671456904], 
[-4.5765209786996923, 2.6045227458177047, 3.255421072957386, -0.90993339191823086, -3.144682517667424], [-1.8717645915890535, 
-1.4516156344177333, 4.1114902476456372, 4.5373004945801636, 3.2704894931398165]]))
      res=arg0-arg1
      ref=Data(numpy.array([[5.158678512804137, -2.8558740985298607, 5.1603216000753944, 2.3002377081193259, 
2.5247493353412951], [0.40141000706039698, 1.7859921336343634, -2.332863595893012, 3.0146315426212622, -1.3592604369544512], 
[-2.7101081136989391, 3.971564616032329, 2.659519077610204, 0.83625466033990792, 0.51139241234475374], [0.039647345644260312, 
3.5777301222467077, 0.89122025724801857, 7.6088486342294921, 6.4762525869818788]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-2.1858758984107469, 4.0690487093548455, 5.3609674116389519, 1.5600607635967707, 
6.0633320564421931], [2.7691853675353695, 0.91568393437207263, -5.051679503095313, 3.5019007854344206, 1.4892893217692071], 
[5.2429185474441722, -1.133701132315287, -0.26646901487628583, -2.1985966015593226, 0.33993430062357], [6.6846794192346373, 
5.98442445539815, -6.7682126565392515, -1.921096036033247, 0.63698704468916034]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_constData_rank3_taggedData_rank0(self):
      arg0=Data(numpy.array([[[4.236932874534812, 0.36231717567629129], [-2.7021996462745657, 1.2918971009948619]], 
[[-1.8810105350153572, 0.99785564605686083], [2.4630012062774416, -2.6240283895118042]], [[3.8683487796304217, 
2.8288868071202433], [-3.0128087934781744, 2.9990955503788932]], [[-0.44413018146576633, -3.1280754100888397], 
[3.6361909927794915, 3.7794623229626065]], [[0.627202122716505, 0.222859782853984], [0.62533976690390247, 
-0.026241189025421718]], [[-2.4586528943705277, -2.8344522287970997], [3.0528657653021511, 
4.711670793694001]]]),self.functionspace)
      arg1=Data(0.533961288905,self.functionspace)
      arg1.setTaggedValue(1,3.52203863285)
      res=arg0-arg1
      ref=Data(numpy.array([[[3.7029715856295562, -0.17164411322896456], [-3.2361609351798215, 0.75793581208960603]], 
[[-2.414971823920613, 0.46389435715160499], [1.9290399173721857, -3.15798967841706]], [[3.3343874907251658, 
2.2949255182149875], [-3.5467700823834303, 2.4651342614736373]], [[-0.97809147037102218, -3.6620366989940956], 
[3.1022297038742357, 3.2455010340573507]], [[0.093240833811249146, -0.31110150605127185], [0.091378477998646623, 
-0.56020247793067757]], [[-2.9926141832757835, -3.3684135177023555], [2.5189044763968953, 
4.1777095047887451]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[0.71489424168651006, -3.1597214571720107], [-6.2242382791228676, 
-2.2301415318534401]], [[-5.4030491678636592, -2.5241829867914412], [-1.0590374265708604, -6.1460670223601062]], 
[[0.34631014678211969, -0.69315182572805867], [-6.5348474263264764, -0.52294308246940879]], [[-3.9661688143140683, 
-6.6501140429371421], [0.11415235993118955, 0.25742369011430455]], [[-2.894836510131797, -3.299178849994318], 
[-2.8966988659443995, -3.5482798218737237]], [[-5.9806915272188297, -6.3564908616454012], [-0.46917286754615084, 
1.189632160845699]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_constData_rank3_taggedData_rank3(self):
      arg0=Data(numpy.array([[[-3.0640096190446311, 4.7017226581116613], [0.7835284279388155, -0.39745635348845898]], 
[[3.3394629033960559, -2.6398055740667816], [1.8101359197249147, -4.6424820498580548]], [[1.7990719378793596, 
0.34596976722902362], [-0.14975504354193792, 1.1840728911924137]], [[2.5830929041789386, 0.51945706960248472], 
[-1.8880859777705039, 3.4885645256457121]], [[-0.62662328640254827, -2.6611938699196225], [-1.3239809568400087, 
-0.99933881412536785]], [[3.5044044929634506, 1.7999656430608777], [-1.5980186230745463, 
4.7128813082795311]]]),self.functionspace)
      arg1=Data(numpy.array([[[-2.0341188021233325, 1.1017493104773823], [2.8349335939877038, 4.9429070168874514]], 
[[4.7581711560376938, 4.1060652658105887], [-0.7764640406994836, 0.25851573919548709]], [[-4.3750026272939646, 
3.8326337762192146], [-2.6194779336500371, -3.3761892152605997]], [[4.4103575905452495, 2.3471047022411717], 
[-1.0191389412099507, -4.3536825783894866]], [[2.0873855516463999, 1.3544036667691026], [-2.9054129900167167, 
-3.5681986840949431]], [[-0.24703412063181585, -3.0673636292773496], [-0.99786809352444106, 
-0.072707306487659551]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[-3.326278190258396, 3.3963170583122935], [0.67107252485796032, 
0.79211696655970609]], [[4.6618300492243971, 3.8467191542733588], [-4.2630503121038421, -1.0700913416381139]], 
[[3.8777523597532735, 2.2939322713976331], [4.6626206688494225, -2.6259991574282426]], [[-3.8959499665788542, 
0.17593723058782373], [-3.1998135800875382, 0.50213444837038779]], [[-1.2351921485003881, 2.7135281131869675], 
[4.5286463874414711, -3.7466543137362707]], [[-4.3514670070612782, 4.529842779179889], [-3.3269370565727687, 
3.2318630247675415]]]))
      res=arg0-arg1
      ref=Data(numpy.array([[[-1.0298908169212986, 3.599973347634279], [-2.0514051660488883, -5.3403633703759104]], 
[[-1.4187082526416379, -6.7458708398773704], [2.5865999604243983, -4.9009977890535419]], [[6.1740745651733242, 
-3.486664008990191], [2.4697228901080992, 4.5602621064530133]], [[-1.8272646863663109, -1.827647632638687], 
[-0.86894703656055317, 7.8422471040351986]], [[-2.7140088380489482, -4.0155975366887251], [1.581432033176708, 
2.5688598699695753]], [[3.7514386135952664, 4.8673292723382273], [-0.60015052955010528, 
4.7855886147671907]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[0.2622685712137649, 1.3054055997993679], [0.11245590308085518, -1.1895733200481651]], 
[[-1.3223671458283413, -6.4865247283401404], [6.0731862318287568, -3.5723907082199409]], [[-2.0786804218739139, 
-1.9479625041686095], [-4.8123757123913604, 3.8100720486206563]], [[6.4790428707577927, 0.34351983901466099], 
[1.3117276023170343, 2.9864300772753243]], [[0.60856886209783978, -5.37472198310659], [-5.8526273442814798, 
2.7473154996109028]], [[7.8558715000247288, -2.7298771361190113], [1.7289184334982224, 1.4810182835119896]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_constData_rank4_taggedData_rank0(self):
      arg0=Data(numpy.array([[[[4.7645334673911215, -1.6640716365214692, -1.8498911578421673, -4.1099760509780818], 
[-4.1033162336762832, 2.1614516321025254, -3.7994551617676664, 0.21838858365096847], [-0.10956684632366542, 2.4514696582435036, 
-2.0755268534803295, -4.2205971477663056]], [[2.5039023219008216, -3.0920842447864239, 0.10113919198296095, 
1.7327288166909156], [2.928438884474339, 4.4925008594251015, 0.0083800973706171789, 3.9720226048327163], [4.2182309555189299, 
-0.32880078406276425, -2.1291997709672184, 4.6723526688860559]]], [[[1.2822136429831534, -2.9845140214724273, 
-2.0374290275397011, 0.50431688950829923], [0.87204172192047658, 0.22090731215247494, -3.8301554380534562, 
-2.1743564629110725], [3.2703775353546529, -3.3477412383077123, 3.4894735027581962, -3.2915124649598204]], 
[[-4.1373042110105365, 4.7488108534899816, 3.0184563239275484, -3.2438026613473001], [-1.6480135433215182, -3.607789345939393, 
-4.9634324636707117, -1.8846586837493362], [4.359293636505857, -4.5807352655461662, 3.407245466585632, -2.0177313457288557]]], 
[[[-2.9727877945150105, -0.79959466384059397, 4.170877062070188, 4.7449158045847], [-2.1572441453156244, 1.7811334193717663, 
1.0689606688558513, -2.5167434518635048], [-3.3147284837478153, -4.9553709385185929, -2.0347599526162199, 
-2.7940901065872046]], [[-0.71075650333327633, 3.6453052020442041, 4.2781623057903069, 4.6013084425621003], 
[2.6804504967028109, -4.2006549155601061, -4.099482464131694, -0.32570685423412815], [4.7512293350713648, 1.312420965253299, 
-0.91741803710156589, 3.8457976599770873]]]]),self.functionspace)
      arg1=Data(4.94528770508,self.functionspace)
      arg1.setTaggedValue(1,-3.32077577255)
      res=arg0-arg1
      ref=Data(numpy.array([[[[-0.18075423768472731, -6.609359341597318, -6.7951788629180161, -9.0552637560539306], 
[-9.048603938752132, -2.7838360729733234, -8.7447428668435148, -4.7268991214248803], [-5.0548545513995142, -2.4938180468323452, 
-7.0208145585561788, -9.1658848528421544]], [[-2.4413853831750272, -8.0373719498622727, -4.8441485130928879, 
-3.2125588883849332], [-2.0168488206015098, -0.45278684565074734, -4.9369076077052316, -0.97326510024313251], 
[-0.7270567495569189, -5.2740884891386131, -7.0744874760430676, -0.27293503618979287]]], [[[-3.6630740620926954, 
-7.9298017265482761, -6.9827167326155504, -4.4409708155675496], [-4.0732459831553722, -4.7243803929233739, -8.775443143129305, 
-7.1196441679869213], [-1.6749101697211959, -8.2930289433835611, -1.4558142023176526, -8.2368001700356697]], 
[[-9.0825919160863862, -0.19647685158586725, -1.9268313811483004, -8.189090366423148], [-6.593301248397367, 
-8.5530770510152418, -9.9087201687465605, -6.829946388825185], [-0.58599406856999181, -9.5260229706220159, -1.5380422384902168, 
-6.9630190508047045]]], [[[-7.9180754995908593, -5.7448823689164428, -0.77441064300566076, -0.20037190049114884], 
[-7.1025318503914736, -3.1641542857040825, -3.8763270362199975, -7.4620311569393536], [-8.2600161888236645, 
-9.9006586435944417, -6.9800476576920687, -7.7393778116630534]], [[-5.6560442084091251, -1.2999825030316448, 
-0.66712539928554193, -0.34397926251374855], [-2.2648372083730379, -9.1459426206359549, -9.044770169207542, 
-5.270994559309977], [-0.194058370004484, -3.6328667398225498, -5.8627057421774147, -1.0994900450987615]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[8.0853092399406705, 1.6567041360280799, 1.4708846147073817, -0.7892002784285328], 
[-0.78254046112673414, 5.4822274046520745, -0.47867938921811737, 3.5391643562005175], [3.2112089262258836, 5.7722454307930526, 
1.2452489190692195, -0.89982137521675654]], [[5.8246780944503707, 0.22869152776312518, 3.42191496453251, 5.0535045892404646], 
[6.249214657023888, 7.8132766319746505, 3.3291558699201662, 7.2927983773822653], [7.5390067280684789, 2.9919749884867848, 
1.1915760015823307, 7.993128441435605]]], [[[4.6029894155327025, 0.33626175107712175, 1.2833467450098479, 3.8250926620578483], 
[4.1928174944700256, 3.541683084702024, -0.50937966550390712, 1.1464193096384765], [6.591153307904202, -0.026965465758163276, 
6.8102492753077453, 0.029263307589728615]], [[-0.81652843846098744, 8.0695866260395306, 6.3392320964770974, 
0.076973111202248923], [1.6727622292280309, -0.28701357338984401, -1.6426566911211626, 1.4361170888002128], [7.680069409055406, 
-1.2599594929966171, 6.728021239135181, 1.3030444268206933]]], [[[0.34798797803453851, 2.5211811087089551, 7.4916528346197371, 
8.065691577134249], [1.1635316272339247, 5.1019091919213153, 4.3897364414054003, 0.80403232068604424], [0.0060472888017337745, 
-1.6345951659690439, 1.2860158199333291, 0.52668566596234445]], [[2.6100192692162727, 6.9660809745937531, 7.5989380783398559, 
7.9220842151116493], [6.0012262692523599, -0.87987914301055703, -0.77870669158214501, 2.9950689183154209], [8.0720051076209138, 
4.633196737802848, 2.4033577354479831, 7.1665734325266364]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_constData_rank4_taggedData_rank4(self):
      arg0=Data(numpy.array([[[[4.3104751456554879, -2.7607367678134342, -4.7122072217303712, 1.5331789224919845], 
[3.868573041826588, 4.9903113202139124, 3.7025310195034269, -0.59308369710770492], [-3.0181183265579756, -0.94828795768009577, 
3.8425928028384266, 2.2609715480342238]], [[1.3677657268465273, -0.44152065083012726, 2.3894950476542682, -1.2268812079846425], 
[4.8469265421239456, 1.2078602620300058, 4.2112950542370537, 0.69932729706676167], [3.8574554227969617, -2.3840030772030305, 
-2.4834200277652108, 1.6929044341032053]]], [[[-2.273054474607199, -2.4962635869053242, 3.3003203501298053, 
-3.2778371949870957], [0.10921044861611495, -4.8001004010585921, -3.5477788121465661, 3.5774954532517196], 
[-3.9346256580553032, -1.9913899200545924, 3.0080527216347672, -1.0331868148431225]], [[1.9503654682714808, 
0.74389775415694448, 4.9631943042802398, 1.350519840904453], [4.9177285132168809, -4.1893796843768261, 0.55529670950590138, 
1.5409995671036159], [2.2272395923616619, 4.4385726760719031, 3.9749207464654983, -4.4364918239866649]]], 
[[[0.17461987769469012, -2.6773901970389558, -3.7575141867485673, -1.1724207778542253], [-1.9705466137367535, 
-2.1093977134476951, -3.6499303698222074, -1.4470116472923458], [-2.4211615178889048, 0.48585393227154849, -3.9413355262439085, 
-1.7705915625955848]], [[0.60628108698177385, -1.0162839511458435, -4.4374767994295823, -2.1953657644216475], 
[0.87085879598093818, 2.7633543977937558, -4.8766223050745472, 1.7658080074974771], [0.089646894193396776, 4.4906177638767701, 
-2.4102246078300347, -3.5493027309928991]]]]),self.functionspace)
      arg1=Data(numpy.array([[[[3.3644440626127583, 1.6791499948339785, 0.17453132971140306, 3.5197475469092492], 
[3.7856674660475207, 2.5269060744232705, 1.2471255348413637, -0.45505571814686441], [2.4514923792397925, 2.1778866546442455, 
3.3809437126012192, 2.0913291102559786]], [[1.9975118729855783, 2.2518441184243922, -0.99676771660712404, 3.1697502324553852], 
[-1.602912704607875, 3.3009303565870933, -1.6799613658895671, 3.2986132022149164], [4.244303243465458, 0.13215454314040453, 
-3.2932057059489228, 0.86217973494882028]]], [[[-0.025948795150369186, 1.6233063307977469, -2.9300756887142954, 
2.6988064043430784], [-1.5451098245533679, -4.7443682500895505, 4.278254864682113, 4.7084155756140493], [-3.7516032923286047, 
2.3599878033465647, -1.5786012987434872, -4.0324504744519816]], [[-0.56558825233137178, 1.9802451340055143, 
-0.98020837055452947, -2.6414566901878853], [3.7241277031827629, 2.606747648116424, -1.4722493621330601, -2.775670923969924], 
[-1.168235598161762, -0.028943572901726, -3.3854351660711721, -3.9761371126622533]]], [[[2.4843499566660068, 
-4.8132040710658082, 1.1648004257740769, 3.3188972148342177], [-1.1627428024579656, 4.305469992929762, -2.3594919785545434, 
-0.68057089668826087], [-3.9720534932879725, -1.7050451881167881, 2.758726671671468, -3.9951750732745586]], 
[[1.1109454689296951, 2.9085521233466629, -3.3146578602898158, 3.3821909297528734], [2.3376002373317917, -4.0463967681392248, 
-0.96316673173395451, 3.062381431287859], [2.9126837503075906, -3.3111284363596214, -4.903849679783967, 
-2.8970076302315881]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[0.801148565810891, -3.843453574294613, 4.8404862482054618, -1.3329252720503391], 
[-3.0235816319906617, -1.8103811986492646, -0.62529761823082897, 1.8164747180800003], [4.4465638190752959, 2.7083405303057102, 
1.9270344218625457, 2.4568367922473788]], [[0.74821662608906969, -2.4545974189863684, 2.6779743609490394, 1.0505675148390399], 
[-3.8618991961171822, -0.73311076168038003, -1.8106572170792457, -1.7704171289252049], [0.28255973844341575, 
-4.9932662703881245, -2.1854710524075438, -2.1477470537912611]]], [[[-2.2883082608821095, -2.6812279078991641, 
-3.5896288405889329, -4.6960851070251604], [-1.2182562055106958, -4.6475200113742723, 0.31975965492226166, 
-2.2634472887339419], [-0.67638149909951828, -1.3276458626412388, -3.7955528530005358, 0.46118466593714214]], 
[[1.8987185969808191, 1.2465753491271681, 3.0550701896955204, -4.2399817856397659], [0.26279598537741933, -0.62786312848506309, 
3.8454442689260997, -4.83367461227735], [-3.1412308139006075, 3.9244079100182976, 2.9556978128980855, 3.2491442414188239]]], 
[[[-4.0303930464513629, -3.9352365571459114, -2.8256980118828245, 1.2259341665479937], [2.1191481695886996, 
-2.0500673419885596, -1.7238581327460367, -1.4121816398564766], [2.9768430924271474, -0.70172743500396884, -2.0194146489618059, 
1.329748802073297]], [[-2.0315936621558484, -1.6579282957203931, 1.1320549735163254, 3.9403244520749023], [4.1494126815767629, 
3.6309050029024768, -0.89515385026624195, 2.3904595946015679], [-0.92321253354858168, -1.192789115995283, -2.6172141919396674, 
-4.0458897422666915]]]]))
      res=arg0-arg1
      ref=Data(numpy.array([[[[0.94603108304272965, -4.4398867626474132, -4.8867385514417743, -1.9865686244172647], 
[0.08290557577906732, 2.4634052457906419, 2.4554054846620632, -0.13802797896084051], [-5.4696107057977681, -3.1261746123243412, 
0.46164909023720746, 0.16964243777824528]], [[-0.629746146139051, -2.6933647692545195, 3.3862627642613923, 
-4.3966314404400277], [6.4498392467318206, -2.0930700945570875, 5.8912564201266209, -2.5992859051481547], 
[-0.38684782066849621, -2.516157620343435, 0.80978567818371205, 0.83072469915438507]]], [[[-2.2471056794568298, 
-4.1195699177030711, 6.2303960388441002, -5.9766435993301741], [1.6543202731694828, -0.055732150969041605, -7.8260336768286791, 
-1.1309201223623297], [-0.1830223657266985, -4.351377723401157, 4.5866540203782549, 2.9992636596088591]], [[2.5159537206028526, 
-1.2363473798485698, 5.9434026748347693, 3.9919765310923383], [1.193600810034118, -6.7961273324932501, 2.0275460716389615, 
4.3166704910735394], [3.3954751905234239, 4.4675162489736291, 7.3603559125366704, -0.46035471132441153]]], 
[[[-2.3097300789713167, 2.1358138740268524, -4.9223146125226442, -4.491317992688443], [-0.80780381127878798, 
-6.4148677063774571, -1.290438391267664, -0.7664407506040849], [1.5508919753990678, 2.1908991203883366, -6.7000621979153765, 
2.2245835106789738]], [[-0.50466438194792129, -3.9248360744925064, -1.1228189391397665, -5.5775566941745209], 
[-1.4667414413508535, 6.8097511659329806, -3.9134555733405927, -1.2965734237903819], [-2.8230368561141939, 7.8017462002363915, 
2.4936250719539323, -0.65229510076131092]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[3.5093265798445969, 1.0827168064811787, -9.5526934699358321, 2.8661041945423236], 
[6.8921546738172497, 6.800692518863177, 4.3278286377342559, -2.4095584151877052], [-7.4646821456332715, -3.656628487985806, 
1.9155583809758809, -0.19586524421315499]], [[0.61954910075745762, 2.0130767681562411, -0.28847931329477117, 
-2.2774487228236824], [8.7088257382411278, 1.9409710237103859, 6.0219522713162998, 2.4697444259919665], [3.574895684353546, 
2.609263193185094, -0.29794897535766696, 3.8406514878944664]]], [[[0.015253786274910475, 0.18496432099383986, 
6.8899491907187382, 1.4182479120380647], [1.3274666541268108, -0.15258038968431986, -3.8675384670688278, 5.8409427419856614], 
[-3.2582441589557849, -0.66374405741335352, 6.803605574635303, -1.4943714807802646]], [[0.0516468712906617, 
-0.50267759497022357, 1.9081241145847194, 5.5905016265442189], [4.6549325278394615, -3.561516555891763, -3.2901475594201983, 
6.3746741793809658], [5.3684704062622695, 0.5141647660536055, 1.0192229335674128, -7.6856360654054887]]], [[[4.205012924146053, 
1.2578463601069556, -0.93181617486574275, -2.398354944402219], [-4.0896947833254531, -0.059330371459135556, 
-1.9260722370761707, -0.03483000743586917], [-5.3980046103160522, 1.1875813672755173, -1.9219208772821026, 
-3.1003403646688819]], [[2.6378747491376222, 0.64164434457454966, -5.5695317729459077, -6.1356902164965499], 
[-3.2785538855958247, -0.86755060510872095, -3.9814684548083052, -0.62465158710409074], [1.0128594277419785, 
5.6834068798720532, 0.20698958410963275, 0.49658701127379246]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_float_rank0(self):
      arg0=Data(1.71003252331,self.functionspace)
      arg0.setTaggedValue(1,-2.5807346363)
      arg1=-0.844104189763
      res=arg0-arg1
      ref=Data(2.55413671308,self.functionspace)
      ref.setTaggedValue(1,-1.73663044653)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_array_rank0(self):
      arg0=Data(-0.451380315905,self.functionspace)
      arg0.setTaggedValue(1,3.21861125061)
      arg1=numpy.array(3.32611031515)
      res=arg0-arg1
      ref=Data(-3.77749063105,self.functionspace)
      ref.setTaggedValue(1,-0.107499064539)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_array_rank1(self):
      arg0=Data(1.40176626623,self.functionspace)
      arg0.setTaggedValue(1,2.04348712993)
      arg1=numpy.array([-3.2765781149232973, -4.699220621572092])
      res=arg0-arg1
      ref=Data(numpy.array([4.6783443811523968, 6.1009868878011915]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([5.3200652448562922, 6.7427077515050868]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_array_rank2(self):
      arg0=Data(-3.37995853633,self.functionspace)
      arg0.setTaggedValue(1,1.54248653088)
      arg1=numpy.array([[2.4698251551733028, -0.64735384648264205, -4.6862775683054192, -3.3915873689973983, 
-2.2870449580280994], [-2.1349753970928154, 1.6236140681686431, -1.2664478821894098, -4.4812444888764809, -1.4943763722457049], 
[1.9421567854898081, -2.2626541565198366, -4.9921430651918328, 2.0575958115930657, -3.5036869486684008], [-3.899527379973009, 
0.6574322107215016, 0.97530743947579168, -0.10169084138355267, 1.7779645010962568]])
      res=arg0-arg1
      ref=Data(numpy.array([[-5.8497836914998764, -2.7326046898439316, 1.3063190319788456, 0.011628832670824707, 
-1.0929135782984742], [-1.2449831392337583, -5.0035726044952167, -2.1135106541371638, 1.1012859525499072, -1.8855821640808688], 
[-5.3221153218163817, -1.117304379806737, 1.6121845288652592, -5.4375543479196393, 0.12372841234182719], [0.51956884364643541, 
-4.0373907470480752, -4.3552659758023653, -3.2782676949430209, -5.1579230374228304]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-0.92733862429497194, 2.1898403773609729, 6.2287640991837501, 4.9340738998757292, 
3.8295314889064302], [3.6774619279711462, -0.081127537290312191, 2.8089344130677407, 6.0237310197548117, 3.0368629031240357], 
[-0.3996702546114772, 3.8051406873981675, 6.5346295960701637, -0.51510928071473483, 5.0461734795467317], [5.4420139108513403, 
0.88505432015682928, 0.56717909140253919, 1.6441773722618835, -0.23547797021792594]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_array_rank3(self):
      arg0=Data(-0.538125230827,self.functionspace)
      arg0.setTaggedValue(1,-2.88588950751)
      arg1=numpy.array([[[-4.3397959186930537, -2.325704490575097], [-0.23287889770386005, 3.4477826257883741]], 
[[2.6511811180695544, -3.4472350508590024], [4.0841375138191829, 2.4562181941546593]], [[2.5281780669519263, 
4.877589928366076], [0.72338654723613338, -0.47389742926744738]], [[0.88024667177481142, -2.7048192913663325], 
[1.7012949461824309, -2.6551989837148926]], [[-1.1134143412764343, -2.5593636480143056], [-4.9321858334230946, 
1.8987790675956964]], [[0.025806261074618142, 0.81430896125168939], [-2.5676891986715611, -1.1829645868017469]]])
      res=arg0-arg1
      ref=Data(numpy.array([[[3.8016706878663555, 1.7875792597483988], [-0.30524633312283811, -3.9859078566150723]], 
[[-3.1893063488962525, 2.9091098200323042], [-4.622262744645881, -2.9943434249813574]], [[-3.0663032977786244, 
-5.4157151591927741], [-1.2615117780628315, -0.064227801559250786]], [[-1.4183719026015096, 2.1666940605396343], 
[-2.2394201770091291, 2.1170737528881944]], [[0.57528911044973619, 2.0212384171876074], [4.3940606025963964, 
-2.4369042984223945]], [[-0.56393149190131631, -1.3524341920783876], [2.0295639678448629, 
0.64483935597504871]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[1.4539064111874258, -0.56018501693053091], [-2.6530106098017678, 
-6.3336721332940016]], [[-5.5370706255751827, 0.5613455433533745], [-6.9700270213248103, -5.3421077016602876]], 
[[-5.4140675744575546, -7.7634794358717034], [-3.6092760547417613, -2.4119920782381805]], [[-3.7661361792804393, 
-0.18107021613929541], [-4.5871844536880584, -0.23069052379073529]], [[-1.7724751662291935, -0.32652585949132229], 
[2.0462963259174667, -4.7846685751013247]], [[-2.911695768580246, -3.7001984687573173], [-0.3182003088340668, 
-1.702924920703881]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_array_rank4(self):
      arg0=Data(3.76364777204,self.functionspace)
      arg0.setTaggedValue(1,0.815129527037)
      arg1=numpy.array([[[[2.6498297799370985, 3.9476585386223828, 2.4282752360723521, -0.65033259761532847], 
[1.8759255251046429, 0.16510404195789974, 1.0817021684022974, 2.9780808694961891], [-2.0135435850116732, 0.056895278903279944, 
0.24183815601845371, 0.5514309864474809]], [[-2.0797876820774297, -1.6893727085233734, 3.0561523856224611, 2.8880499802198836], 
[4.9578197799682684, 2.9799608118773939, 3.0975143214553196, 4.82650681155671], [-3.0609422784376195, -3.6192588989695542, 
3.9263189626107948, -4.5802292247771899]]], [[[-0.57810216994370922, -3.9569081351752677, -0.12291733942454819, 
0.29316433310018208], [1.805683470267577, 0.68153808006859684, 3.4414052738296093, -2.2582860698105467], [0.48121599243841295, 
0.18575954313812559, -4.8387104279071513, 4.8449818517421779]], [[-0.42045608992668271, -1.8105279418131115, 
-4.9012217461557679, -0.31734868295748164], [-4.1824940846963221, 0.98697677383539251, -3.034027878914094, 
-1.6615215754131576], [-4.5411693032812783, -3.2983848717299411, -0.56960354264920721, -0.86015136866716801]]], 
[[[-1.3491647854481794, 3.2315180265311376, 2.2584848114034894, 2.0915800021198603], [-4.2614682597183631, -3.6322337583906741, 
-4.8365935452764752, 3.1114418050720243], [1.5415572200081131, 3.2535703624015646, -0.61099457720896222, 1.3266361509927114]], 
[[0.60814479680330624, 0.85545252579860609, -4.1851091357405927, 4.5339718557570201], [1.0054663612576658, 3.8507598660410896, 
-1.0153737686191002, 1.8092606691504134], [-4.977404388689175, 0.43878965902429901, -3.5087714184634731, 
-1.8411601868237346]]]])
      res=arg0-arg1
      ref=Data(numpy.array([[[[1.1138179920982232, -0.18401076658706117, 1.3353725359629696, 4.4139803696506501], 
[1.8877222469306787, 3.5985437300774219, 2.6819456036330243, 0.78556690253913253], [5.7771913570469948, 3.7067524931320417, 
3.5218096160168679, 3.2122167855878407]], [[5.8434354541127513, 5.4530204805586955, 0.70749538641286058, 0.87559779181543806], 
[-1.1941720079329468, 0.78368696015792771, 0.66613345058000206, -1.0628590395213884], [6.8245900504729411, 7.3829066710048759, 
-0.16267119057547319, 8.3438769968125115]]], [[[4.3417499419790309, 7.7205559072105894, 3.8865651114598698, 
3.4704834389351396], [1.9579643017677446, 3.0821096919667248, 0.32224249820571238, 6.0219338418458683], [3.2824317795969087, 
3.577888228897196, 8.6023581999424721, -1.0813340797068562]], [[4.1841038619620043, 5.5741757138484331, 8.6648695181910895, 
4.0809964549928033], [7.9461418567316437, 2.7766709981999291, 6.7976756509494152, 5.4251693474484792], [8.3048170753165991, 
7.0620326437652627, 4.3332513146845288, 4.6237991407024897]]], [[[5.1128125574835011, 0.53212974550418402, 1.5051629606318322, 
1.6720677699154614], [8.0251160317536847, 7.3958815304259957, 8.6002413173117969, 0.65220596696329736], [2.2220905520272085, 
0.51007740963375703, 4.3746423492442839, 2.4370116210426103]], [[3.1555029752320154, 2.9081952462367155, 7.9487569077759144, 
-0.77032408372169847], [2.7581814107776559, -0.087112094005767915, 4.7790215406544219, 1.9543871028849082], 
[8.7410521607244966, 3.3248581130110226, 7.2724191904987947, 5.6048079588590562]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-1.8347002529003476, -3.1325290115856319, -1.6131457090356012, 1.4654621246520794], 
[-1.060795998067892, 0.65002548507885116, -0.26657264136554648, -2.1629513424594382], [2.8286731120484241, 0.75823424813347096, 
0.57329137101829719, 0.26369854058927]], [[2.8949172091141806, 2.5045022355601243, -2.2410228585857102, -2.0729204531831327], 
[-4.1426902529315175, -2.164831284840643, -2.2823847944185687, -4.0113772845199591], [3.8760718054743704, 4.4343884260063051, 
-3.1111894355740439, 5.3953587518139408]]], [[[1.3932316969804601, 4.7720376622120186, 0.93804686646129909, 
0.52196519393656882], [-0.99055394323082613, 0.13359144696815406, -2.6262757467928584, 3.0734155968472976], 
[0.33391353459833795, 0.62936998389862531, 5.6538399549439022, -4.029852324705427]], [[1.2355856169634336, 2.6256574688498624, 
5.7163512731925188, 1.1324782099942325], [4.997623611733073, -0.17184724679864161, 3.8491574059508449, 2.4766511024499085], 
[5.3562988303180292, 4.113514398766692, 1.3847330696859581, 1.6752808957039189]]], [[[2.1642943124849303, -2.4163884994943867, 
-1.4433552843667385, -1.2764504750831094], [5.076597786755114, 4.447363285427425, 5.6517230723132261, -2.2963122780352734], 
[-0.72642769297136223, -2.4384408353648137, 1.4261241042457131, -0.51150662395596047]], [[0.20698473023344466, 
-0.040322998761855189, 5.0002386627773436, -3.7188423287202692], [-0.19033683422091485, -3.0356303390043387, 
1.8305032956558511, -0.99413114211366249], [5.7925339157259259, 0.37633986801245189, 4.323900945500224, 2.6562897138604855]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_constData_rank0(self):
      arg0=Data(0.267698109761,self.functionspace)
      arg0.setTaggedValue(1,0.050947023036)
      arg1=Data(-1.97500370619,self.functionspace)
      res=arg0-arg1
      ref=Data(2.24270181595,self.functionspace)
      ref.setTaggedValue(1,2.02595072923)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_constData_rank1(self):
      arg0=Data(4.56674556359,self.functionspace)
      arg0.setTaggedValue(1,-4.52928613326)
      arg1=Data(numpy.array([2.5216603006223712, 4.6894057811765588]),self.functionspace)
      res=arg0-arg1
      ref=Data(numpy.array([2.0450852629716048, -0.12266021758258283]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-7.050946433886339, -9.2186919144405266]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_constData_rank2(self):
      arg0=Data(-0.167243699323,self.functionspace)
      arg0.setTaggedValue(1,-2.46352803976)
      arg1=Data(numpy.array([[4.6542448318061922, 2.6995505547257199, 2.7102016501744206, -0.15273216412903334, 
4.5819767355203744], [0.66005610153358951, -3.2013279411816442, 2.171862567171309, 4.0033350301234591, 3.799249245665747], 
[-4.0620850485446001, -3.8153702776938712, -0.4359511838975525, -2.0683173454619208, 4.3770806856171518], [-2.4665656429848126, 
-1.2819192345945285, -0.38154628978331129, 0.93355701252648782, -1.5845736194272808]]),self.functionspace)
      res=arg0-arg1
      ref=Data(numpy.array([[-4.8214885311293667, -2.8667942540488944, -2.8774453494975951, -0.014511535194141167, 
-4.7492204348435489], [-0.82729980085676402, 3.0340842418584697, -2.3391062664944835, -4.1705787294466337, 
-3.9664929449889215], [3.8948413492214256, 3.6481265783706966, 0.26870748457437799, 1.9010736461387463, -4.5443243849403263], 
[2.2993219436616381, 1.114675535271354, 0.21430259046013678, -1.1008007118496623, 1.4173299201041063]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-7.1177728715640862, -5.1630785944836139, -5.1737296899323146, -2.3107958756288607, 
-7.0455047752782685], [-3.1235841412914835, 0.73779990142375018, -4.635390606929203, -6.4668630698813532, -6.262777285423641], 
[1.598557008786706, 1.3518422379359771, -2.0275768558603415, -0.39521069429597322, -6.8406087253750458], 
[0.0030376032269185949, -1.1816088051633655, -2.0819817499745827, -3.3970850522843818, -0.87895442033061322]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_constData_rank3(self):
      arg0=Data(-4.65253696389,self.functionspace)
      arg0.setTaggedValue(1,2.86500945645)
      arg1=Data(numpy.array([[[-4.264379056296951, -3.9913025952341141], [-1.6726952880310106, 4.3173580709434258]], 
[[-0.64386879846191469, -1.7363592860084784], [0.52500637197845279, 3.778635019053862]], [[-3.0944216355168619, 
-3.0997038973128044], [2.1936081635110147, 2.1351426969377743]], [[-1.9883478593255175, -4.7933187615525332], 
[-4.9399393113387333, 0.78546734930798046]], [[2.9360183805889308, 4.488666079729386], [2.1713919702383189, 
-4.7957276504776143]], [[-1.3383618495475091, 0.76405075629438901], [2.921505010857393, 
4.1287171356156307]]]),self.functionspace)
      res=arg0-arg1
      ref=Data(numpy.array([[[-0.38815790758935442, -0.66123436865219132], [-2.9798416758552948, -8.9698950348297313]], 
[[-4.0086681654243908, -2.916177677877827], [-5.1775433358647582, -8.4311719829401675]], [[-1.5581153283694436, 
-1.5528330665735011], [-6.8461451273973202, -6.7876796608240797]], [[-2.6641891045607879, 0.14078179766622778], 
[0.28740234745242788, -5.4380043131942859]], [[-7.5885553444752363, -9.1412030436156915], [-6.8239289341246243, 
0.14319068659130885]], [[-3.3141751143387963, -5.4165877201806945], [-7.5740419747436984, 
-8.7812540995019361]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[7.1293885127470986, 6.8563120516842613], [4.5377047444811582, -1.4523486144932782]], 
[[3.5088782549120623, 4.601368742458626], [2.3400030844716948, -0.91362556260371441]], [[5.9594310919670095, 
5.964713353762952], [0.67140129293913287, 0.72986675951237334]], [[4.8533573157756651, 7.6583282180026808], 
[7.8049487677888809, 2.0795421071421671]], [[-0.071008924138783236, -1.6236566232792384], [0.69361748621182873, 
7.6607371069277619]], [[4.2033713059976563, 2.1009587001557586], [-0.056495554407245407, -1.2637076791654831]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_constData_rank4(self):
      arg0=Data(-3.54835004425,self.functionspace)
      arg0.setTaggedValue(1,-1.59020961265)
      arg1=Data(numpy.array([[[[4.9737863631272337, 3.9512098829181763, 3.4733837492965112, -4.6212192525155071], 
[-2.4644600059461941, -3.2067827474379729, 0.29251545563854719, -4.2079699988499861], [4.7955912839437111, 3.6889992007518551, 
-3.9279621045548172, 4.0444978689765883]], [[-3.9343062324754619, 4.5408830600522414, 4.9987649273814601, -2.9953814759228403], 
[-4.3007122550027574, -2.9881542076986447, 3.1779818640737716, -2.5073362095484875], [-2.5925976356292546, -4.7579626040340646, 
-1.6708963556821397, -4.053457733314545]]], [[[-2.0866984628487275, 2.7757901879703963, -4.7346424224476138, 
-4.5582572556802177], [0.067705745275526752, 1.5357197681123411, -1.2800822812006283, 4.4504837558828427], 
[-1.8495207355725651, 3.5239692817094124, 2.8817584161802765, -0.13236330920306827]], [[0.83601473572533447, 
-1.671106482360798, -0.17306575484707309, 1.5156410088238337], [-4.1646864066350755, 2.3683177323815041, 0.072761312731732808, 
-1.4611666923921431], [-4.3816186518888154, 3.6671834370077363, 4.4849142768771202, 1.6069030013683676]]], 
[[[-1.0218709572493734, -3.7514854095267971, 3.8288398425423136, -1.8777543395841958], [3.3473645170472128, 
-3.5848342007156688, -4.6345092686379736, 2.3467116215570138], [-3.7268495146538694, 0.77616814815380053, -3.2775695615673941, 
-2.788111461539188]], [[3.8526016320550198, 0.69622468672735227, -0.21826602245438487, 3.7758035262098666], 
[-0.8771213387128407, 1.6423606928402146, 2.3167802459656519, -0.64900142442344677], [0.19569743332784029, -4.1684508140525187, 
-0.026339972751976859, -2.9310913341966072]]]]),self.functionspace)
      res=arg0-arg1
      ref=Data(numpy.array([[[[-8.522136407372777, -7.4995599271637206, -7.0217337935420554, 1.0728692082699629], 
[-1.0838900382993502, -0.34156729680757136, -3.8408654998840914, 0.65961995460444189], [-8.3439413281892563, 
-7.2373492449973993, 0.37961206030927297, -7.5928479132221325]], [[0.38595618822991762, -8.0892331042977865, 
-8.5471149716270034, -0.55296856832270391], [0.75236221075721321, -0.56019583654689953, -6.7263319083193158, 
-1.0410138346970568], [-0.95575240861628963, 1.2096125597885203, -1.8774536885634046, 0.50510768906900072]]], 
[[[-1.4616515813968167, -6.3241402322159406, 1.1862923782020696, 1.0099072114346734], [-3.616055789521071, -5.0840698123578854, 
-2.268267763044916, -7.998833800128387], [-1.6988293086729791, -7.0723193259549566, -6.4301084604258207, -3.415986735042476]], 
[[-4.3843647799708787, -1.8772435618847463, -3.3752842893984711, -5.0639910530693779], [0.61633636238953127, 
-5.9166677766270483, -3.621111356977277, -2.0871833518534011], [0.83326860764327115, -7.2155334812532805, -8.0332643211226653, 
-5.1552530456139118]]], [[[-2.5264790869961709, 0.20313536528125287, -7.3771898867878578, -1.6705957046613484], 
[-6.8957145612927571, 0.036484156470124596, 1.0861592243924294, -5.8950616658025581], [0.17849947040832514, 
-4.3245181923993448, -0.27078048267815014, -0.76023858270635625]], [[-7.4009516763005641, -4.2445747309728965, 
-3.3300840217911594, -7.3241535704554108], [-2.6712287055327035, -5.1907107370857588, -5.8651302902111961, 
-2.8993486198220975], [-3.7440474775733845, 0.62010076980697448, -3.5220100714935674, 
-0.61725871004893706]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-6.5639959757738362, -5.5414194955647789, -5.0635933619431137, 3.0310096398689046], 
[0.87425039329959153, 1.6165731347913703, -1.8827250682851497, 2.6177603862033836], [-6.3858008965903137, -5.2792088133984576, 
2.3377524919082147, -5.6347074816231908]], [[2.3440966198288593, -6.1310926726988439, -6.5889745400280626, 1.4051718632762378], 
[2.7105026423561549, 1.3979445950520422, -4.7681914767203741, 0.91712659690188492], [1.0023880229826521, 3.167752991387462, 
0.080686743035537134, 2.4632481206679424]]], [[[0.49648885020212496, -4.3659998006169989, 3.1444328098010113, 
2.9680476430336151], [-1.6579153579221293, -3.1259293807589437, -0.31012733144597426, -6.0406933685294453], 
[0.25931112292596259, -5.1141788943560149, -4.471968028826879, -1.4578463034435343]], [[-2.426224348371937, 
0.080896869714195407, -1.4171438577995294, -3.1058506214704362], [2.574476793988473, -3.9585273450281067, -1.6629709253783354, 
-0.1290429202544594], [2.7914090392422128, -5.2573930496543388, -6.0751238895237227, -3.1971126140149702]]], 
[[[-0.56833865539722916, 2.1612757968801946, -5.4190494551889161, 0.28754472693759325], [-4.9375741296938154, 
1.9946245880690663, 3.0442996559913711, -3.9369212342036164], [2.1366399020072668, -2.3663777608004031, 1.6873599489207916, 
1.1979018488925854]], [[-5.4428112447016224, -2.2864342993739548, -1.3719435901922177, -5.3660131388564691], 
[-0.71308827393376184, -3.2325703054868171, -3.9069898586122545, -0.94120818822315577], [-1.7859070459744428, 
2.5782412014059162, -1.5638696398946257, 1.3408817215500046]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_taggedData_rank0(self):
      arg0=Data(-0.298383943283,self.functionspace)
      arg0.setTaggedValue(1,1.96695279107)
      arg1=Data(3.35258734835,self.functionspace)
      arg1.setTaggedValue(1,-1.85793458451)
      res=arg0-arg1
      ref=Data(-3.65097129163,self.functionspace)
      ref.setTaggedValue(1,3.82488737558)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_taggedData_rank1(self):
      arg0=Data(0.433362615437,self.functionspace)
      arg0.setTaggedValue(1,1.10382327241)
      arg1=Data(numpy.array([0.66864921472270034, 0.033031674717114434]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([0.50254756514531707, -4.0259240927772275]))
      res=arg0-arg1
      ref=Data(numpy.array([-0.23528659928579199, 0.40033094071979392]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([0.60127570726895474, 5.1297473651914993]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_taggedData_rank2(self):
      arg0=Data(-2.51112697639,self.functionspace)
      arg0.setTaggedValue(1,3.03412941576)
      arg1=Data(numpy.array([[-3.2511967041263903, 4.7171303473892436, -4.3432152759762275, 4.2001430854881967, 
-3.1450354454635301], [-0.32066407419477638, -4.3131301752380153, -0.45715485891635765, 2.348843893322984, 4.0290692636151491], 
[2.721893625776759, -0.076876967244096761, -3.15348862776779, 4.4278417385362907, 1.9842288538413397], [2.3885962428558285, 
-3.0592902409276999, -4.4116241662084255, -4.4904517708271996, 3.0570320381236105]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[-0.4963458683188815, -3.997640331727037, -2.6214367474237745, -4.6144667391452723, 
-0.5661032468298588], [0.59517260135558381, -1.4081917413537237, 1.7739181045438777, -2.7959311890720553, 4.2599955697879572], 
[0.6239370141516094, -0.42676392855667356, 1.2796563536137828, -2.8050001754870069, 1.0806906986160127], [2.7208423712544221, 
-4.1732157406266621, -1.7686970229615406, -1.1173678978269406, -0.033814616947406506]]))
      res=arg0-arg1
      ref=Data(numpy.array([[0.74006972773270174, -7.2282573237829322, 1.8320882995825389, -6.7112700618818852, 
0.63390846906984155], [-2.1904629021989122, 1.8020031988443268, -2.0539721174773309, -4.8599708697166726, -6.5401962400088376], 
[-5.2330206021704475, -2.4342500091495918, 0.64236165137410151, -6.9389687149299792, -4.4953558302350283], [-4.899723219249517, 
0.54816326453401132, 1.9004971898147369, 1.9793247944335111, -5.568159014517299]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[3.5304752840827476, 7.0317697474909036, 5.6555661631876406, 7.6485961549091384, 
3.6002326625937249], [2.4389568144082823, 4.4423211571175898, 1.2602113112199884, 5.8300606048359214, -1.2258661540240912], 
[2.4101924016122567, 3.4608933443205396, 1.7544730621500833, 5.8391295912508729, 1.9534387171478533], [0.313287044509444, 
7.2073451563905282, 4.8028264387254067, 4.1514973135908066, 3.0679440327112726]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_taggedData_rank3(self):
      arg0=Data(3.64946707503,self.functionspace)
      arg0.setTaggedValue(1,1.68558911828)
      arg1=Data(numpy.array([[[3.2336881361969745, 3.0421791813696828], [-3.1779926146241069, 2.4507314368547197]], 
[[4.6006222808183743, 4.8133029711413471], [2.8176892654475036, 4.270603435408141]], [[1.6885585322607968, 
-1.7516981446455149], [-1.3247350398668392, -0.45970124002548474]], [[3.6813532160357703, -2.1567226778145967], 
[2.5793383691613272, -0.79795369992929288]], [[4.1261745599452944, 4.5301737204055001], [3.9993231287366271, 
2.6545962238922751]], [[3.6132604031584581, 1.8889528752665026], [-3.387072501168368, 
-0.6896307440087881]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[2.0754300046243213, -2.7597591622034132], [-2.6328751085317803, 
-2.808982081049102]], [[1.0084876640723923, 4.4854950936472324], [-0.7401750910657432, 0.72281683647404904]], 
[[-4.3608646551893893, 4.6010786822416438], [4.7458257447953862, -2.3155327163554427]], [[0.72116999155787909, 
-0.18586888091778864], [2.6620620089346483, -3.2732288374966156]], [[-4.7650314476876074, -4.2483812625103967], 
[1.0226778292265344, -1.0619374938033999]], [[-0.1883950459567636, -1.3358197834990158], [2.2654414472034414, 
0.43934146263656437]]]))
      res=arg0-arg1
      ref=Data(numpy.array([[[0.41577893883308015, 0.60728789366037184], [6.8274596896541615, 1.1987356381753349]], 
[[-0.95115520578831969, -1.1638358961112925], [0.83177780958255099, -0.62113636037808639]], [[1.9609085427692579, 
5.4011652196755691], [4.9742021148968938, 4.1091683150555394]], [[-0.031886141005715629, 5.8061897528446513], 
[1.0701287058687274, 4.4474207749593475]], [[-0.47670748491523973, -0.88070664537544552], [-0.34985605370657247, 
0.99487085113777951]], [[0.036206671871596541, 1.7605141997635521], [7.0365395761984226, 
4.3390978190388427]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-0.38984088634253666, 4.4453482804851978], [4.3184642268135649, 4.4945711993308866]], 
[[0.67710145420939227, -2.7999059753654478], [2.4257642093475278, 0.96277228180773555]], [[6.0464537734711739, 
-2.9154895639598593], [-3.0602366265136016, 4.0011218346372273]], [[0.96441912672390551, 1.8714579991995732], 
[-0.97647289065286369, 4.9588179557784002]], [[6.450620565969392, 5.9339703807921813], [0.66291128905525021, 
2.7475266120851844]], [[1.8739841642385482, 3.0214089017808003], [-0.57985232892165683, 1.2462476556452202]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_taggedData_rank4(self):
      arg0=Data(1.65415744684,self.functionspace)
      arg0.setTaggedValue(1,-1.3578282545)
      arg1=Data(numpy.array([[[[-1.9534667136679404, 1.8085010423934014, 0.54400349002870385, -1.5318882056547469], 
[-2.667233722430101, 0.24699106963006834, 2.5318530559448558, -2.6478151783785342], [-2.4335335340539799, 
-0.026273532677302036, -2.0133768944136254, 2.1649660046888952]], [[-4.9378517767629564, -2.7905677546643135, 
-3.5620427141239652, -1.6262682994121058], [-4.4914450871136227, 4.5095078205433623, 3.5872337637671183, 3.8874670132757299], 
[-3.289113445839118, -3.7622093112881618, 1.5990449875800739, -0.83672339204276103]]], [[[1.1048874936666708, 
1.9657922680939999, 0.086645832099073061, 1.5812612133361181], [4.1753856590337808, 3.0116638097658441, 2.2497213957833875, 
0.3919031386571783], [-4.4856543129226223, -2.6404864309341569, -1.3653043518569841, -0.59206931377936733]], 
[[-1.6517516856716852, 3.0553535906448364, -0.50710970081973006, 4.49333932498282], [0.7675186144415358, 3.5402882067836305, 
4.1806971560502522, -4.1965865791683035], [-4.5043819749229002, -0.63003500916034927, -0.65415983221964158, 
-4.5042795574923602]]], [[[1.5241942172111314, -3.1146056928718346, -2.0488521508854984, -3.190735559436745], 
[-0.38199202519408182, -3.8836495599772034, 0.68730490551975532, -4.535956911653475], [1.5290499018533987, 2.7948701140991261, 
-0.92842615891784863, -2.8961536921806372]], [[-1.6241520505994886, 4.6229028790781541, 1.6317902742992469, 
-1.1787642785467467], [-2.0092480118383662, 0.21139330006492507, -4.9901272534770316, -2.7451412764928005], 
[-3.4732052952859895, -2.247667118157862, -4.7579027658815303, 3.9152337212355022]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[-1.2664736843727828, -1.0127613225173171, -0.12698089166399384, 
-2.6296726171690779], [1.568544934784355, 3.7673194948413986, -1.4034134159100811, 0.74710799359715896], [-0.28935744658767693, 
-4.0853538302226919, -1.8638191052183295, -1.5471542389738149]], [[-1.4766455785729935, -3.8406261898612639, 
3.6467277176720163, 4.7184378937814326], [-1.0017599063074831, 0.65144422804580771, 4.9377960066242483, -4.035182938626888], 
[-3.8416098894902118, -0.77347984584628637, -1.6127147097764172, 1.2399636462117218]]], [[[-1.825677385425879, 
-3.7766067490763664, 3.7505695083092565, -2.4084010209035878], [1.82054538748379, 0.7726724933217568, 1.5193389216990081, 
2.7624546393882801], [-3.8023495821110584, 0.06823482795620528, 4.0603300257922204, -2.9887910449101307]], 
[[-2.3502863868006063, -0.76390343096689151, 3.9124042386386968, 0.71817873754970663], [-4.4971318912641731, 
-4.4171519386654809, 4.5714362192546183, -0.40406162970976123], [-2.7569876348250966, -2.8703861552223939, 
-0.60827477369102656, 2.1059715428376089]]], [[[0.15909257613445149, -3.7491396647860151, -4.3027200962573762, 
0.99243241340489163], [0.72655086752273057, 4.7216945905319179, -0.19856408864913888, 0.86882148389023683], 
[-1.9723592297032799, 2.7699180493626576, -1.7795420968937039, -3.3744251679723503]], [[-0.87320825365357546, 
3.5791659828818823, 4.6311622196102, -2.1571781032932691], [4.8440549668127026, 4.2001073247437333, -3.5309717586086209, 
0.36179210414568352], [-4.8649353968212505, -3.8480312290099361, 3.5226370377149934, 0.33932994804966654]]]]))
      res=arg0-arg1
      ref=Data(numpy.array([[[[3.6076241605038213, -0.15434359555752053, 1.110153956807177, 3.1860456524906278], 
[4.3213911692659819, 1.4071663772058125, -0.87769560910897493, 4.3019726252144146], [4.0876909808898603, 1.6804309795131829, 
3.6675343412495063, -0.51080855785301438]], [[6.5920092235988372, 4.4447252015001943, 5.2162001609598461, 3.2804257462479867], 
[6.1456025339495035, -2.8553503737074815, -1.9330763169312375, -2.233309566439849], [4.9432708926749989, 5.4163667581240427, 
0.055112459255806989, 2.4908808388786419]]], [[[0.54926995316921001, -0.31163482125811903, 1.5675116147368078, 
0.072896233499762708], [-2.5212282121978999, -1.3575063629299633, -0.59556394894750664, 1.2622543081787025], 
[6.1398117597585031, 4.2946438777700378, 3.0194617986928649, 2.2462267606152482]], [[3.305909132507566, -1.4011961438089555, 
2.1612671476556109, -2.8391818781469391], [0.88663883239434504, -1.8861307599477497, -2.5265397092143713, 5.8507440260041843], 
[6.158539421758781, 2.2841924559962301, 2.3083172790555224, 6.158437004328241]]], [[[0.12996322962474949, 4.7687631397077155, 
3.7030095977213793, 4.8448930062726259], [2.0361494720299627, 5.5378070068130842, 0.96685254131612552, 6.1901143584893559], 
[0.12510754498248211, -1.1407126672632453, 2.5825836057537295, 4.5503111390165181]], [[3.2783094974353695, -2.9687454322422733, 
0.022367172536633895, 2.8329217253826275], [3.6634054586742471, 1.4427641467709558, 6.6442847003129124, 4.3992987233286813], 
[5.1273627421218704, 3.9018245649937429, 6.4120602127174111, -2.2610762743996213]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-0.091354570123906242, -0.34506693197937199, -1.2308473628326952, 
1.2718443626723888], [-2.9263731892810441, -5.1251477493380877, 0.045585161413391972, -2.1049362480938481], 
[-1.0684708079090122, 2.7275255757260028, 0.50599085072164041, 0.18932598447712579]], [[0.11881732407630441, 
2.4827979353645748, -5.0045559721687054, -6.0762661482781217], [-0.35606834818920596, -2.0092724825424968, -6.2956242611209374, 
2.6773546841301989], [2.4837816349935227, -0.58434840865040272, 0.25488645527972809, -2.5977919007084109]]], 
[[[0.46784913092918989, 2.4187784945796773, -5.1083977628059456, 1.0505727664068987], [-3.1783736419804791, 
-2.1305007478184459, -2.8771671761956972, -4.1202828938849692], [2.4445213276143694, -1.4260630824528944, -5.4181582802889094, 
1.6309627904134416]], [[0.99245813230391722, -0.59392482352979759, -5.2702324931353859, -2.0760069920463957], 
[3.139303636767484, 3.0593236841687919, -5.9292644737513074, -0.95376662478692786], [1.3991593803284075, 1.5125579007257048, 
-0.74955348080566253, -3.463799797334298]]], [[[-1.5169208306311406, 2.391311410289326, 2.9448918417606871, 
-2.3502606679015807], [-2.0843791220194197, -6.079522845028607, -1.1592641658475502, -2.2266497383869259], 
[0.61453097520659083, -4.1277463038593467, 0.42171384239701482, 2.0165969134756612]], [[-0.48462000084311363, 
-4.9369942373785713, -5.9889904741068891, 0.79934984879658], [-6.2018832213093917, -5.5579355792404224, 2.1731435041119318, 
-1.7196203586423726], [3.5071071423245614, 2.490202974513247, -4.8804652922116825, -1.6971582025463556]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_expandedData_rank0(self):
      arg0=Data(-3.21137136183,self.functionspace)
      arg0.setTaggedValue(1,-0.567186838815)
      arg1=Data(-1.25476077872,self.functionspace)
      arg1.setTaggedValue(1,0.371545778797)
      arg1.expand()
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*(-1.95661058311)+(1.-msk_ref)*(-0.938732617612)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_expandedData_rank1(self):
      arg0=Data(4.75204794782,self.functionspace)
      arg0.setTaggedValue(1,-3.77784707919)
      arg1=Data(numpy.array([0.70563098343477648, -0.69610374331112634]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([0.67663064328439493, -4.944100470984953]))
      arg1.expand()
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([4.0464169643896959, 5.4481516911355987])+(1.-msk_ref)*numpy.array([-4.4544777224694307, 
1.1662533917999172])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_expandedData_rank2(self):
      arg0=Data(-4.05196515387,self.functionspace)
      arg0.setTaggedValue(1,0.942568478461)
      arg1=Data(numpy.array([[-2.2611654363757863, 4.7670864554948018, 3.8263643327440366, 4.9466534906112098, 
4.3687232493044057], [-0.30999478184874274, -0.54322972337562803, -4.1338353654373039, -2.5896294050158764, 
0.69570051613073947], [2.5657675734388787, -2.4729991703720513, 2.7352689845169511, -4.7625900234753828, 0.45081174042230643], 
[-0.79162223517735963, 2.6763216523859858, -0.64011256425331009, -3.517588051391749, 2.2593852687715987]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[-2.6540364830821561, 0.10303800430975585, 2.9222312468745058, -4.6200200835244978, 
-1.7081006854533265], [0.56916319209395549, -0.10225901722417863, 2.0554395269174393, 3.7047606016258054, 0.6754239150428285], 
[-3.8565025784025755, 1.4687459457567131, 3.4535172717478808, -3.0334073063028355, 4.6730653812852463], [-4.1580370432467841, 
4.3554895048399676, -4.5795866721254193, 2.7487905319316663, 1.2578573464449496]]))
      arg1.expand()
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-1.7907997174931634, -8.8190516093637505, -7.8783294866129863, -8.9986186444801604, 
-8.4206884031733544], [-3.7419703720202069, -3.5087354304933216, 0.081870211568354279, -1.4623357488530733, 
-4.7476656699996891], [-6.6177327273078284, -1.5789659834968983, -6.7872341383859007, 0.71062486960643323, -4.502776894291256], 
[-3.26034291869159, -6.7282868062549355, -3.4118525896156395, -0.53437710247720061, 
-6.3113504226405484]])+(1.-msk_ref)*numpy.array([[3.5966049615433837, 0.83953047415147175, -1.9796627684132782, 
5.5625885619857254, 2.6506691639145541], [0.3734052863672721, 1.0448274956854062, -1.1128710484562117, -2.7621921231645779, 
0.26714456341839909], [4.7990710568638031, -0.52617746729548553, -2.5109487932866532, 3.9759757847640631, -3.7304969028240187], 
[5.1006055217080117, -3.41292102637874, 5.5221551505866469, -1.8062220534704387, -0.31528886798372202]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_expandedData_rank3(self):
      arg0=Data(-0.315525863867,self.functionspace)
      arg0.setTaggedValue(1,-3.36147755936)
      arg1=Data(numpy.array([[[-2.4956579139050405, 1.760859601717164], [-0.0644845194842949, 0.87692569214872673]], 
[[3.7467215241105087, -1.3571398605788354], [1.3831095672972671, -3.9097279642413918]], [[-3.0789060289614021, 
-3.0000940056577097], [0.62827567206659829, -0.4846502984961365]], [[0.41469671371845518, 1.5797527460429253], 
[3.4220955857383899, 0.72821755122647414]], [[2.2010857934407602, 2.1043187293141985], [-4.1911189193345066, 
-4.8429202120938832]], [[2.6877839239485777, -1.9063574433285444], [1.9344865187429594, 
-3.2831696393967249]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[2.8018880136320368, 0.87924276182235506], [-1.9749750374286537, 
0.036453764365615093]], [[-1.0266181230272409, 0.30399252889133876], [3.5845048519126728, 3.5584166272329103]], 
[[-0.34264522072760606, -1.2537520493397381], [-1.5422797409951663, -4.2806975891973149]], [[4.6497581488408599, 
3.2951638754765593], [3.371328141586611, 4.3462647579266189]], [[-4.3409374278520216, -2.4712169161472151], 
[4.2212655320810839, 0.16994497050107427]], [[-4.5015474985122159, -1.6638792528779933], [-4.3161405541809783, 
-1.3946086978932879]]]))
      arg1.expand()
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[2.1801320500380172, -2.0763854655841874], [-0.2510413443827284, -1.19245155601575]], 
[[-4.062247387977532, 1.0416139967118121], [-1.6986354311642904, 3.5942021003743685]], [[2.7633801650943788, 
2.6845681417906864], [-0.94380153593362159, 0.1691244346291132]], [[-0.73022257758547848, -1.8952786099099486], 
[-3.7376214496054132, -1.0437434150934974]], [[-2.5166116573077835, -2.4198445931812218], [3.8755930554674833, 
4.5273943482268599]], [[-3.003309787815601, 1.5908315794615211], [-2.2500123826099827, 
2.9676437755297016]]])+(1.-msk_ref)*numpy.array([[[-6.1633655729956249, -4.2407203211859432], [-1.3865025219349345, 
-3.3979313237292033]], [[-2.3348594363363473, -3.6654700882549269], [-6.9459824112762609, -6.9198941865964985]], 
[[-3.0188323386359821, -2.1077255100238501], [-1.8191978183684219, 0.91922002983372675]], [[-8.011235708204449, 
-6.6566414348401475], [-6.7328057009501991, -7.7077423172902071]], [[0.97945986848843347, -0.8902606432163731], 
[-7.5827430914446721, -3.5314225298646624]], [[1.1400699391486278, -1.6975983064855948], [0.95466299481739014, 
-1.9668688614703003]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank0_expandedData_rank4(self):
      arg0=Data(-1.97798318505,self.functionspace)
      arg0.setTaggedValue(1,4.00745335857)
      arg1=Data(numpy.array([[[[-1.4052316633091966, -3.6140948875274947, -3.9027797564233691, 3.4620260737549984], 
[-1.0961828611797806, -4.0041391384127634, 3.4185945012685863, -3.2436817421387909], [-4.4931978445668666, 1.4434903980023197, 
-4.0713944577754724, -4.915399348707008]], [[2.5885642367428963, -3.8184799646251397, -0.12535048944855376, 
-4.3823391284661302], [0.18942057543962587, 2.26614180969354, 2.4241087956958189, -3.630644899290111], [4.134101474801172, 
0.3698692708630027, -3.3220642103020825, 3.4024982997979656]]], [[[-4.9699250346339321, -2.2487094827099154, 
-2.6439714228237832, 2.2017234832841179], [3.8947432481218041, 4.8501332736396403, 1.9198947599704592, -4.6375640404079208], 
[-4.8549530447402862, 1.2690793081129552, 3.1813143761789888, 4.6705101268535145]], [[2.1710957641562647, -4.2512214148661691, 
-3.9842991290506236, -2.4602464419807122], [-4.556618359604709, 1.9643839000624519, 4.374189395509255, 3.3779222459465768], 
[-1.1792805265475104, -2.6564113870337556, 2.5239444593422222, 0.50018124893985494]]], [[[3.2518766257370917, 
-0.064577868313779874, -1.1700460638634027, -0.82300249829171168], [-4.0564362335170898, -0.1983688998416806, 
4.9765304712166056, -1.1207613743540779], [-1.9334614180044452, 1.602489886678061, 3.7837681868624848, 2.2043891714658397]], 
[[1.4250956429779658, -1.5467109404711432, 4.9280756887864712, 3.6294900172425386], [-4.3839947658521261, -1.451392022235348, 
-0.27966173883524181, -1.3234966003068016], [0.54322084176755325, 3.3543863791556721, 3.631375550895088, 
3.24399794256008]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[4.2940845692648164, -3.4848266815985687, -4.9864008378443625, -4.2182299295896373], 
[0.88082524200220647, -1.9593689867233532, -1.8614573173328877, -3.0558049350459084], [0.738138936082116, -4.2426817207089602, 
1.0645255584126057, -4.9777179838930818]], [[1.8383103692543621, 3.3325204482740354, -4.6309192893180295, -2.315271433458157], 
[1.7856513158819745, 0.027075822387927495, -1.9365727960673684, 3.4439176400874079], [3.9946878058557722, -3.3951691607520273, 
-0.90283316867909935, -1.0958400994550779]]], [[[-4.3933164163971972, 3.8587885058511979, 3.1777330322394945, 
-4.3708983168556648], [-3.8532981909799013, -4.2406169394840347, 3.1884657189399128, -0.74029677363911262], 
[0.2322432935169978, 0.30415583117616585, -2.5056320810005217, 0.28708035376410912]], [[-3.9465999880422387, 
-1.4209576762016898, -1.4812181927057777, 4.902710041489291], [-2.9916256701733013, -2.8564210513175272, -3.9186030335308821, 
4.9655651018781573], [3.6305364660762542, 2.3182120707133977, 0.58713868253069901, -1.882972931560972]]], 
[[[-4.7918584115903906, -2.6623736477954441, -4.2155923788428842, -1.9161153319936086], [4.6938134280443364, 
-4.2051684469777237, 1.2381437471357675, 0.89629855611710862], [3.2479546229154206, -1.2950382801722951, -1.9530130806157473, 
-3.0191445612749268]], [[-2.0859130183345034, 1.8867183929804288, -3.96296859185999, 4.5801626190003617], [1.4212012319532485, 
-0.15691862318594652, 1.5233448034154833, 0.0070488401299417802], [4.8501883821168725, 1.8722102574072528, 1.0975788012041754, 
-0.92365502229974883]]]]))
      arg1.expand()
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-0.5727515217404533, 1.6361117024778449, 1.9247965713737192, -5.4400092588046487], 
[-0.88180032386986928, 2.0261559533631135, -5.3965776863182366, 1.265698557089141], [2.5152146595172167, -3.4214735830519696, 
2.0934112727258225, 2.9374161636573581]], [[-4.5665474217925457, 1.8404967795754898, -1.8526326956010961, 2.4043559434164803], 
[-2.1674037604892757, -4.2441249947431903, -4.4020919807454693, 1.6526617142404612], [-6.1120846598508223, -2.3478524559126526, 
1.3440810252524327, -5.3804814848476159]]], [[[2.9919418495842822, 0.27072629766026557, 0.6659882377741333, 
-4.1797066683337682], [-5.8727264331714544, -6.8281164586892906, -3.8978779450201091, 2.6595808553582709], [2.8769698596906363, 
-3.2470624931626051, -5.1592975612286391, -6.6484933119031648]], [[-4.149078949205915, 2.2732382298165192, 2.0063159440009737, 
0.48226325693106231], [2.5786351745550591, -3.9423670851121018, -6.3521725805589053, -5.3559054309962271], 
[-0.79870265850213951, 0.67842820198410569, -4.5019276443918717, -2.4781644339895048]]], [[[-5.229859810786742, 
-1.91340531673587, -0.80793712118624716, -1.1549806867579382], [2.0784530484674399, -1.7796142852079693, -6.9545136562662559, 
-0.85722181069557202], [-0.044521767045204719, -3.5804730717277109, -5.7617513719121352, -4.18237235651549]], 
[[-3.4030788280276156, -0.43127224457850666, -6.9060588738361215, -5.6074732022921889], [2.4060115808024762, 
-0.52659116281430185, -1.6983214462144081, -0.65448658474284827], [-2.5212040268172031, -5.3323695642053224, 
-5.6093587359447383, -5.2219811276097303]]]])+(1.-msk_ref)*numpy.array([[[[-0.28663121069612174, 7.4922800401672633, 
8.9938541964130572, 8.2256832881583328], [3.1266281165664882, 5.9668223452920479, 5.8689106759015823, 7.0632582936146031], 
[3.2693144224865787, 8.2501350792776549, 2.942927800156089, 8.9851713424617756]], [[2.1691429893143326, 0.67493291029465929, 
8.6383726478867242, 6.3227247920268521], [2.2218020426867202, 3.9803775361807672, 5.9440261546360631, 0.56353571848128681], 
[0.012765552712922457, 7.4026225193207225, 4.910286527247794, 5.1032934580237725]]], [[[8.4007697749658909, 
0.14866485271749674, 0.82972032632920012, 8.3783516754243585], [7.8607515495485956, 8.2480702980527294, 0.81898763962878185, 
4.7477501322078073], [3.7752100650516969, 3.7032975273925288, 6.5130854395692168, 3.7203730048045855]], [[7.9540533466109338, 
5.4284110347703844, 5.4886715512744724, -0.89525668292059635], [6.9990790287419955, 6.8638744098862219, 7.9260563920995768, 
-0.95811174330946258], [0.37691689249244043, 1.6892412878552969, 3.4203146760379957, 5.8904262901296667]]], 
[[[8.7993117701590862, 6.6698270063641392, 8.223045737411578, 5.9235686905623037], [-0.68636006947564177, 8.2126218055464193, 
2.7693096114329272, 3.111154802451586], [0.75949873565327408, 5.3024916387409897, 5.960466439184442, 7.0265979198436215]], 
[[6.093366376903198, 2.1207349655882659, 7.9704219504286851, -0.57270926043166703], [2.5862521266154461, 4.1643719817546412, 
2.4841085551532114, 4.0004045184387529], [-0.84273502354817786, 2.1352431011614419, 2.9098745573645193, 4.9311083808684435]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank1_float_rank0(self):
      arg0=Data(numpy.array([-1.9480699676741322, 3.3533622550524491]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-2.6122633139496845, -3.9263834492073846]))
      arg1=-2.89537402896
      res=arg0-arg1
      ref=Data(numpy.array([0.94730406128325129, 6.2487362840098326]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([0.28311071500769902, -1.0310094202500011]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank1_array_rank0(self):
      arg0=Data(numpy.array([-0.75568602482371183, 1.1298095769089791]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([0.41698265074729068, -3.7394208471673309]))
      arg1=numpy.array(-3.09003548898)
      res=arg0-arg1
      ref=Data(numpy.array([2.3343494641592999, 4.2198450658919908]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([3.5070181397303024, -0.64938535818431919]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank1_array_rank1(self):
      arg0=Data(numpy.array([1.6145328675093982, -2.7150102794808695]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([2.8122030494757713, -1.7761463653945988]))
      arg1=numpy.array([-1.7855041288119233, -4.6115558498119515])
      res=arg0-arg1
      ref=Data(numpy.array([3.4000369963213215, 1.8965455703310821]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([4.5977071782876946, 2.8354094844173527]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank1_constData_rank0(self):
      arg0=Data(numpy.array([0.49033663014567352, 2.3918922397301507]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-4.1545466028038085, 1.533071644997829]))
      arg1=Data(3.14670808715,self.functionspace)
      res=arg0-arg1
      ref=Data(numpy.array([-2.6563714570077899, -0.75481584742331265]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-7.3012546899572719, -1.6136364421556344]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank1_constData_rank1(self):
      arg0=Data(numpy.array([-3.9777337336925989, 3.4154940122014672]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-4.9734585753556875, -1.749644525876719]))
      arg1=Data(numpy.array([-3.9501521549817054, 0.3414722041311693]),self.functionspace)
      res=arg0-arg1
      ref=Data(numpy.array([-0.027581578710893506, 3.0740218080702979]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-1.0233064203739821, -2.0911167300078883]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank1_taggedData_rank0(self):
      arg0=Data(numpy.array([1.0425239218307736, 1.9898898779904304]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-0.67886047372861658, 4.6186996704352765]))
      arg1=Data(-4.92655796097,self.functionspace)
      arg1.setTaggedValue(1,2.68152308776)
      res=arg0-arg1
      ref=Data(numpy.array([5.9690818828049341, 6.9164478389645909]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-3.3603835614839133, 1.9371765826799798]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank1_taggedData_rank1(self):
      arg0=Data(numpy.array([0.75217192070860062, 0.60192813287826397]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-3.8835437318928703, 2.4872191826246013]))
      arg1=Data(numpy.array([-0.607950487027205, -3.8153791307846197]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([4.4538955764057029, 1.279782124452657]))
      res=arg0-arg1
      ref=Data(numpy.array([1.3601224077358056, 4.4173072636628836]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-8.337439308298574, 1.2074370581719442]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank1_expandedData_rank0(self):
      arg0=Data(numpy.array([0.25574033693643639, -4.6873291746938754]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-2.3386654935959128, -2.9592248542442023]))
      arg1=Data(-2.8425019828,self.functionspace)
      arg1.setTaggedValue(1,0.59937916853)
      arg1.expand()
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([3.0982423197346876, -1.8448271918956243])+(1.-msk_ref)*numpy.array([-2.9380446621264116, 
-3.5586040227747011])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank1_expandedData_rank1(self):
      arg0=Data(numpy.array([1.2486131905458375, -0.34577659306947428]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-4.8184093429381232, 2.4081587820325421]))
      arg1=Data(numpy.array([2.2971436598222024, -4.1671940092572175]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([-0.31753835706848577, 1.0456955316580547]))
      arg1.expand()
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-1.0485304692763648, 3.8214174161877432])+(1.-msk_ref)*numpy.array([-4.5008709858696374, 
1.3624632503744873])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank2_float_rank0(self):
      arg0=Data(numpy.array([[2.6185232343377436, -3.9331249049927353, -3.1840821009101248, -2.6934255305115307, 
-1.7483418773000414], [-2.8360256670657726, 0.11541830260639152, -3.4411242880044481, -4.2965592320743067, 2.9409772976250377], 
[3.5933293394038586, 4.9278006428447121, 4.9009652921594036, -2.2296500449127032, 4.7933637287295916], [0.15326900449458414, 
-0.14591972059339753, -3.4180701819393491, -1.0273958174025477, 3.8787366978085611]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-1.0207562933083558, 4.8383907535769186, -0.11515874431430184, 3.4013649718441705, 
1.7851921492999843], [-2.2176810320920968, -0.49809437128613165, -4.6212108440534481, -1.0755889722743692, 
-4.2178196557269505], [3.3934163816606873, -2.2635572380697857, 1.9133023692254971, -1.1242601666273999, 0.84096684362424412], 
[-0.40397469882202852, -4.2469653790322308, 4.1067259724217493, -0.69361430785466727, -3.1540256572644241]]))
      arg1=-3.20707696307
      res=arg0-arg1
      ref=Data(numpy.array([[5.8256001974113376, -0.72604794191914124, 0.022994862163469243, 0.51365143256206336, 
1.4587350857735526], [0.37105129600782139, 3.3224952656799855, -0.23404732493085412, -1.0894822690007127, 6.1480542606986317], 
[6.8004063024774526, 8.1348776059183052, 8.1080422552329985, 0.97742691816089078, 8.0004406918031847], [3.3603459675681782, 
3.0611572424801965, -0.21099321886575506, 2.1796811456710463, 7.0858136608821551]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[2.1863206697652382, 8.0454677166505135, 3.0919182187592922, 6.6084419349177645, 
4.9922691123735783], [0.98939593098149725, 2.7089825917874624, -1.414133880979854, 2.1314879907992248, -1.0107426926533565], 
[6.6004933447342813, 0.94351972500380832, 5.1203793322990911, 2.0828167964461941, 4.0480438066978381], [2.8031022642515655, 
-1.0398884159586368, 7.3138029354953433, 2.5134626552189268, 0.053051305809169946]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank2_array_rank0(self):
      arg0=Data(numpy.array([[-1.1189832603329775, -1.0370097180581594, -2.7088043616098001, 0.2701693244098422, 
-2.2581783371668163], [-1.1734699609229415, -1.2483144865095808, -2.4822141284810098, 3.5625714926069012, 0.41321358232217698], 
[3.8407425092891057, 3.6903178317501286, 4.9415901906337201, 1.6993787081797276, 4.6954305085853161], [-2.7633216941818572, 
-2.4408778011833498, 3.8225098038213154, -3.9407957210603417, -3.5665351541125179]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-1.4815229131220855, 0.017238384336575763, 1.2169003903716282, 1.3146809192630045, 
-2.8851121093680918], [-0.80862275106393344, -4.3804509874152782, -3.5329116323736995, 2.8815983731256676, 3.696215140067169], 
[-4.4404167188468051, 2.7070464465558084, 1.3842550790614014, 4.5190426017346841, -2.5259397597385966], [0.97225286621864626, 
-0.134196570550146, -3.1901998026200418, -0.94036177911590713, -2.5442509820786396]]))
      arg1=numpy.array(-0.100958465964)
      res=arg0-arg1
      ref=Data(numpy.array([[-1.0180247943688849, -0.93605125209406692, -2.6078458956457076, 0.37112779037393473, 
-2.1572198712027237], [-1.072511494958849, -1.1473560205454882, -2.3812556625169172, 3.6635299585709937, 0.5141720482862695], 
[3.9417009752531982, 3.7912762977142211, 5.0425486565978126, 1.8003371741438201, 4.7963889745494086], [-2.6623632282177647, 
-2.3399193352192573, 3.923468269785408, -3.8398372550962492, -3.4655766881484253]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-1.380564447157993, 0.11819685030066829, 1.3178588563357208, 1.415639385227097, 
-2.7841536434039993], [-0.70766428509984092, -4.2794925214511856, -3.431953166409607, 2.9825568390897601, 3.7971736060312615], 
[-4.3394582528827126, 2.8080049125199009, 1.485213545025494, 4.6200010676987766, -2.4249812937745041], [1.0732113321827388, 
-0.033238104586053474, -3.0892413366559492, -0.8394033131518146, -2.4432925161145471]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank2_array_rank2(self):
      arg0=Data(numpy.array([[4.5862048435294049, 3.3575522657502272, 3.8547677165806231, -4.9259725969082382, 
-1.1064410783249201], [-1.5861167402897767, -4.700064212769659, -0.44660958791784822, 3.4960893550686691, 1.9796417080196527], 
[-4.0904795185818754, -0.10579672003586893, -2.287299816751216, -3.421265708896728, 3.5970339860030709], [-4.6643592232929096, 
3.1486177805641393, -1.4797643584497377, 0.19973070633845325, -4.1555475107727711]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-4.7011689453860619, 4.0783669899156969, -4.5001635356475767, 1.9166763236072173, 
-3.1510681588574441], [-1.9389745109374532, -1.8327041132000321, 3.4958001383079029, 1.6137352533925231, -3.8174312879520578], 
[-0.28870158605105978, 4.947752398315993, 4.6170126504540381, 2.1140604460907673, -3.0247484473611239], [2.8447244186797853, 
2.3961734624009337, 4.1455415749362317, 4.5919517221786421, -4.1588497709937293]]))
      arg1=numpy.array([[-2.4317497197554481, -4.8306064615274593, -0.91062571270759118, -0.54888328298383993, 
0.11961929447881126], [-0.87455332062802604, -3.7924103534447928, -3.5240408484498911, -3.5450627801077204, 
-2.3736207275644894], [-4.1219652233324897, 2.7746221641502844, -1.5156557243169821, -2.6791328472690603, 3.3536371930488844], 
[-4.5896087199092053, 4.2846928050008213, -1.7376988529802961, 4.9815826463341875, -2.8945924564915773]])
      res=arg0-arg1
      ref=Data(numpy.array([[7.017954563284853, 8.1881587272776866, 4.7653934292882143, -4.3770893139243983, 
-1.2260603728037314], [-0.71156341966175063, -0.9076538593248662, 3.0774312605320429, 7.0411521351763895, 4.3532624355841421], 
[0.031485704750614296, -2.8804188841861533, -0.77164409243423382, -0.74213286162766767, 0.24339679295418648], 
[-0.07475050338370437, -1.136075024436682, 0.25793449453055839, -4.7818519399957342, -1.2609550542811938]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-2.2694192256306138, 8.9089734514431562, -3.5895378229399855, 2.4655596065910572, 
-3.2706874533362553], [-1.0644211903094272, 1.9597062402447607, 7.019840986757794, 5.1587980335002435, -1.4438105603875684], 
[3.8332636372814299, 2.1731302341657086, 6.1326683747710202, 4.7931932933598276, -6.3783856404100083], [7.4343331385889906, 
-1.8885193425998876, 5.8832404279165278, -0.38963092415554534, -1.2642573145021521]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank2_constData_rank0(self):
      arg0=Data(numpy.array([[0.9102735071194612, 0.16366737866134162, 1.278024060999261, -3.8434630927779221, 
-1.7737644592528712], [-0.98630779892823028, 1.6811115730185398, -2.4931380649196369, 0.75137413522620822, 
-1.0999607592083747], [-2.2017636056509637, 4.6037993073748034, 1.2763556756618062, -1.4791491799966181, 1.6303426163262058], 
[-1.5349973920457574, 2.27818076400892, 4.2600576787714655, 4.9952110704459738, 1.1132225693753792]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-0.2652664936965401, -3.7734999714245223, 2.6384857839467539, -1.0484170181906558, 
3.4357095269608564], [-1.4756965062939442, 1.3838835727528176, 4.580303250148976, -1.003301218523668, -0.60961718652792296], 
[4.0121276475253378, -0.28884713410886143, 3.83066356649298, -1.4858538988139824, 0.27555259066312487], [2.1714791710387349, 
3.2579341946392848, 4.7643710668911972, 0.97584463083414708, -2.9846945979561132]]))
      arg1=Data(-4.147237021,self.functionspace)
      res=arg0-arg1
      ref=Data(numpy.array([[5.0575105281151238, 4.3109043996570042, 5.4252610819949236, 0.30377392821774052, 
2.3734725617427914], [3.1609292220674323, 5.8283485940142024, 1.6540989560760258, 4.8986111562218708, 3.0472762617872879], 
[1.9454734153446989, 8.751036328370466, 5.4235926966574688, 2.6680878409990445, 5.7775796373218684], [2.6122396289499052, 
6.4254177850045826, 8.4072946997671281, 9.1424480914416364, 5.2604595903710418]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[3.8819705272991225, 0.37373704957114029, 6.7857228049424165, 3.0988200028050068, 
7.582946547956519], [2.6715405147017184, 5.5311205937484802, 8.7275402711446386, 3.1439358024719946, 3.5376198344677396], 
[8.1593646685210004, 3.8583898868868012, 7.9779005874886426, 2.6613831221816802, 4.4227896116587875], [6.3187161920343975, 
7.4051712156349474, 8.9116080878868598, 5.1230816518298097, 1.1625424230395494]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank2_constData_rank2(self):
      arg0=Data(numpy.array([[-2.090784428052237, 2.2757817938540885, -0.60070552753307815, 4.5981804115372462, 
-2.136552009126004], [3.2049666607300047, -4.041885089009515, -2.1398466961541529, 3.92055820881491, 0.72948065669860185], 
[-3.5547023365530563, -0.54706266631278844, 3.4282472796201908, 1.2673725524744217, 1.9686470611846376], [-3.3384247025870408, 
-3.3701188705158791, -4.0262426993211387, -1.4655536075371378, -4.9634193675184761]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[2.2238200738610576, -3.8058994923027178, 2.8012759536048719, -2.3341444078185059, 
-3.348138423613535], [-3.2728720756729981, -4.6930607390952321, 0.5521966285136406, 2.4196295356977648, 0.50674106517230566], 
[2.6055684269734094, 3.3391656454199659, 4.0038684001911076, -4.2332016578050915, 2.3953043914282137], [4.510135755204784, 
-2.4210706295915618, 3.8621308935968539, -2.975309548420757, -2.5659491010856894]]))
      arg1=Data(numpy.array([[-1.8782503565687234, 0.94780410368283796, 4.5554496067860892, 0.95696267810471891, 
1.1661109467823074], [1.0819188808560307, -0.60408815138317706, -0.86204490580554261, -1.3921324476148165, -2.30670053342245], 
[0.47697326383766647, -0.98453896021013776, -3.5664140361461074, -1.864461610315967, -4.0352451204201323], 
[-0.21262179668857151, 2.1163272015995531, -2.3795285842202443, -1.3045305130960583, -2.358955581909381]]),self.functionspace)
      res=arg0-arg1
      ref=Data(numpy.array([[-0.21253407148351355, 1.3279776901712506, -5.1561551343191674, 3.6412177334325273, 
-3.3026629559083114], [2.123047779873974, -3.437796937626338, -1.2778017903486103, 5.3126906564297265, 3.0361811901210518], 
[-4.0316756003907228, 0.43747629389734932, 6.9946613157662982, 3.1318341627903887, 6.0038921816047699], [-3.1258029058984693, 
-5.4864460721154327, -1.6467141151008944, -0.16102309444107954, -2.6044637856090951]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[4.102070430429781, -4.7537035959855558, -1.7541736531812173, -3.2911070859232248, 
-4.5142493703958424], [-4.3547909565290288, -4.0889725877120551, 1.4142415343191832, 3.8117619833125813, 2.8134415985947556], 
[2.1285951631357429, 4.3237046056301036, 7.570282436337215, -2.3687400474891245, 6.430549511848346], [4.7227575518933556, 
-4.5373978311911145, 6.2416594778170982, -1.6707790353246987, -0.20699351917630837]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank2_taggedData_rank0(self):
      arg0=Data(numpy.array([[-3.7206175882976056, -0.5171111700354043, 4.4061828165744572, 4.6796920778579754, 
-0.61003781158786108], [-1.3538713894031282, -1.3133229979364813, 4.7008103864146698, -1.9855901823948385, 
0.80476558779592189], [-0.15072131832439517, 4.1942067921448771, 0.053352153926018886, 3.5656510726162249, 
-4.8234989574741931], [2.5979489220431233, 0.58145058535685212, 3.8410964110625123, 0.51684572048726096, 
3.4265201107495411]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-3.9229860312170031, 2.4668957781976051, -3.4148633635056393, 1.0926288796421346, 
4.5637875434555557], [2.8717705517983916, 1.8835768722805488, -0.53547194593091785, -1.6885537506731216, 1.5212192916267666], 
[-2.6779950900349725, 3.8489129397213766, 4.6433732297027763, 3.2255516194154161, 3.7714253091658652], [3.1727692176307478, 
4.8127260162993828, 2.2178309763568667, -0.33807593736518093, 1.1121578772175678]]))
      arg1=Data(1.43117959078,self.functionspace)
      arg1.setTaggedValue(1,2.00210455504)
      res=arg0-arg1
      ref=Data(numpy.array([[-5.15179717908177, -1.9482907608195683, 2.9750032257902932, 3.2485124870738114, 
-2.0412174023720251], [-2.7850509801872922, -2.7445025887206453, 3.2696307956305057, -3.4167697731790025, 
-0.62641400298824212], [-1.5819009091085592, 2.7630272013607131, -1.3778274368581451, 2.1344714818320609, -6.2546785482583571], 
[1.1667693312589593, -0.84972900542731189, 2.4099168202783483, -0.91433387029690305, 1.9953405199653771]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-5.9250905862591123, 0.46479122315549581, -5.4169679185477486, -0.90947567539997465, 
2.5616829884134464], [0.86966599675628231, -0.11852768276156045, -2.5375765009730271, -3.6906583057152309, 
-0.48088526341534266], [-4.6800996450770818, 1.8468083846792673, 2.6412686746606671, 1.2234470643733069, 1.7693207541237559], 
[1.1706646625886385, 2.8106214612572735, 0.21572642131475739, -2.3401804924072902, -0.88994667782454151]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank2_taggedData_rank2(self):
      arg0=Data(numpy.array([[-0.71339343666589095, 1.2901822404685879, -1.7987903909889171, 4.1948030511324408, 
4.7237205905336754], [-3.7537546207223658, 3.0813201230911229, -4.0865084644367808, -0.98444317250984259, 4.7165844944255895], 
[0.8892549890276058, 4.8650068651218614, -0.075266025775004408, -4.9825719666280266, 2.5048895018793012], 
[0.050621524835331222, 3.915545905385807, -1.2538213357593211, 1.8403702654885077, -1.6068637923446296]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-3.0503014800183825, -0.22741787885719678, 3.0212691200295865, 1.7156438228542612, 
-2.7397939335648216], [-1.3138343785527229, 4.2589283868423973, -2.3310411778812035, 2.0066512808128332, 0.72243688895000346], 
[-2.5454136109728176, -3.5906757361140738, -2.7775002055147171, 0.55447761709998122, 3.4079192664470295], [2.5449108101682292, 
-2.8143411172951716, 0.77565557146171393, 0.53091941681531551, -4.3485928577474899]]))
      arg1=Data(numpy.array([[2.8091395657514777, -2.1760902773494806, 1.1002025548672725, 1.982847280879529, 
-2.3207027580987241], [1.4386064901849158, -4.8060072051640681, -3.2068102836318859, -1.6216645703690782, 4.1918886114257781], 
[4.2381820261089302, -1.412807706077329, 4.2758382872860192, 3.6215427370000004, 0.55248234240391092], [-3.0972928061563696, 
-3.7489759080915661, 4.4689827767741814, 1.9241097556291482, 0.3295534680766119]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[-1.4128229000324355, -4.4589616549726401, -0.8703409016424537, -2.783539508266113, 
3.759530078373766], [4.1929422010449464, -0.65925394052930564, -0.46141573726296325, 3.4853205140883539, 0.78744039851618286], 
[-1.3956591701966206, -0.26802316733995291, 1.7226210526246541, -3.3487801265067363, -0.55224895915462202], 
[3.9852896606069645, -3.9607644392777552, 1.1244672354605498, 3.5348828565660178, -4.9087492692457513]]))
      res=arg0-arg1
      ref=Data(numpy.array([[-3.5225330024173687, 3.4662725178180684, -2.8989929458561896, 2.2119557702529118, 
7.0444233486323995], [-5.1923611109072816, 7.887327328255191, -0.87969818080489492, 0.63722139785923559, 0.5246958829998114], 
[-3.3489270370813244, 6.2778145711991904, -4.3511043130610236, -8.6041147036280279, 1.9524071594753902], [3.1479143309917008, 
7.6645218134773732, -5.7228041125335025, -0.083739490140640527, -1.9364172604212415]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-1.637478579985947, 4.2315437761154433, 3.8916100216720402, 4.4991833311203742, 
-6.4993240119385876], [-5.5067765795976698, 4.9181823273717029, -1.8696254406182402, -1.4786692332755207, 
-0.065003509566179396], [-1.149754440776197, -3.3226525687741209, -4.5001212581393712, 3.9032577436067175, 3.9601682256016515], 
[-1.4403788504387354, 1.1464233219825837, -0.3488116639988359, -3.0039634397507022, 0.56015641149826134]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank2_expandedData_rank0(self):
      arg0=Data(numpy.array([[-0.10324532952324894, 3.0249985469862501, 2.3588223359065967, -0.98635065335656247, 
1.2651113533170877], [-1.7145904201684425, -0.33745707925003821, 2.8631613866793435, -2.3796584274295149, 3.4715772084769476], 
[-0.3628567075256548, -0.97319192042435532, 1.8963877845448875, -1.8689291879285239, -2.392917374555533], [-1.7000645900429854, 
-1.6966685913544688, 3.954922119164749, 1.6648713268074324, -0.025066901259910068]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-3.869544361165441, 1.3370236386072989, -2.104609986418672, 0.60501643362563939, 
-3.3268640034341654], [3.5916621719418416, -0.10918454664665767, 4.7536114920313661, 1.119062407849114, 1.7667216678834574], 
[-4.210194994545243, -4.5797597882319296, -1.1320430256478389, 3.552913679599067, 3.7699825125082498], [-0.58501648521557392, 
-1.249586446784944, -4.9202876801904383, -2.75428605860079, 2.9649100772899448]]))
      arg1=Data(-1.28883513458,self.functionspace)
      arg1.setTaggedValue(1,-2.20061734812)
      arg1.expand()
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[1.1855898050603368, 4.3138336815698359, 3.6476574704901825, 0.30248448122702332, 
2.5539464879006735], [-0.42575528558485676, 0.95137805533354758, 4.1519965212629293, -1.0908232928459292, 4.7604123430605334], 
[0.92597842705793099, 0.31564321415923047, 3.1852229191284733, -0.58009405334493813, -1.1040822399719472], 
[-0.4112294554593996, -0.40783345677088301, 5.2437572537483348, 2.9537064613910182, 
1.2637682333236757]])+(1.-msk_ref)*numpy.array([[-1.6689270130467047, 3.5376409867260352, 0.096007361700064298, 
2.8056337817443757, -1.1262466553154291], [5.7922795200605783, 2.0914328014720787, 6.9542288401501029, 3.3196797559678504, 
3.9673390160021937], [-2.0095776464265067, -2.3791424401131933, 1.0685743224708975, 5.7535310277178038, 5.9705998606269866], 
[1.6156008629031624, 0.95103090133379231, -2.7196703320717019, -0.55366871048205368, 5.1655274254086816]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank2_expandedData_rank2(self):
      arg0=Data(numpy.array([[1.0733991337308693, -1.7905653187977388, -4.2977680785757144, 4.1439425460692068, 
4.0115352968631761], [3.5662770328571352, -3.1631208612895234, 3.1922382783179373, -4.2827984000526484, 3.2361280103214742], 
[0.27828861228668345, -3.6236203887011174, -3.6979358106898186, 4.7827831371197984, -2.1098076954565292], [-1.1677270354111178, 
0.095230984508081207, -3.9242762853228639, -1.9588929049469828, 3.5285874653059288]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-2.6030112919394899, -0.95432344632345956, -3.4013722116970611, 2.1274826148013473, 
-4.0087414971735829], [-3.709070567310484, -4.4956712881321987, -2.9623636732024785, 2.2288400237923964, 4.8177395994558303], 
[-2.4861995240618295, 2.7352445120403424, -2.3163218034121447, -0.68580963080163038, 4.4575635167355081], [1.8230840428285013, 
-3.8409116407310862, 1.1494403175441494, 4.2104244498378005, 3.778142620377924]]))
      arg1=Data(numpy.array([[1.0294513303323702, -1.1079239805583119, 3.9663380151979908, -3.6145160212803873, 
-3.5066168496621861], [4.4121218480260378, 2.2623925031615331, -1.6337455623904429, 0.080872704041821564, 1.8565154383779481], 
[2.4585255021051697, -3.4107650423964717, -4.7311011528660627, -0.82462656376569399, 1.8685306219853999], [1.079366582050465, 
0.39898024724296022, 2.1588969632330297, -4.1999066839914736, -3.8554275616868749]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[3.5045030055565025, -3.5892770280361797, -3.4148688887524759, 3.3592497321666155, 
-0.28644735225971196], [-1.7358902239678065, 4.8856026696308543, 0.33106895748375198, -1.1253088705662515, 
-2.2293960685996996], [-0.34840765401143514, 0.59971933196959348, 1.0817405530990678, 1.0802196241802218, 1.467389528385791], 
[-1.577450845614127, -1.620538186098528, 1.1678537414069865, -3.781889085191966, 1.780637296356602]]))
      arg1.expand()
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[0.043947803398499019, -0.68264133823942696, -8.2641060937737052, 7.758458567349594, 
7.5181521465253622], [-0.84584481516890264, -5.4255133644510565, 4.8259838407083802, -4.36367110409447, 1.3796125719435262], 
[-2.1802368898184863, -0.21285534630464564, 1.0331653421762441, 5.6074097008854924, -3.9783383174419291], [-2.2470936174615828, 
-0.30374926273487901, -6.0831732485558936, 2.2410137790444908, 
7.3840150269928042]])+(1.-msk_ref)*numpy.array([[-6.1075142974959924, 2.6349535817127201, 0.013496677055414796, 
-1.2317671173652682, -3.7222941449138709], [-1.9731803433426776, -9.3812739577630531, -3.2934326306862305, 3.3541488943586479, 
7.0471356680555299], [-2.1377918700503944, 2.1355251800707489, -3.3980623565112125, -1.7660292549818521, 2.9901739883497171], 
[3.4005348884426283, -2.2203734546325582, -0.018413423862837064, 7.9923135350297665, 1.9975053240213221]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank3_float_rank0(self):
      arg0=Data(numpy.array([[[4.2564785073173752, -4.1066180374396772], [3.0760399730208672, 2.3895694320243237]], 
[[-3.5250137386118521, 1.3065626802357837], [-4.8613216067671994, -3.4485384026728507]], [[-1.1240798459978665, 
0.00079525940719449295], [-1.9278385762349446, -1.1582627268357903]], [[-3.468479072154703, 0.79369661121277346], 
[3.1496161550128594, -2.587759976703615]], [[2.1001056885427669, 4.5738392568360187], [3.1688561731311875, 
-0.070581056985457913]], [[3.6415791337810184, -2.4135715430416638], [-3.2861076766263753, 
3.2982806115162617]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[4.4193599790360398, 4.669779703485025], [-4.9301321572257333, -4.9839341283225247]], 
[[1.1375963438419854, -2.3050276774157998], [-0.93189942288600225, 1.1073658425286448]], [[-4.2174201494338259, 
0.41292920568215408], [0.56036906139348996, -3.3231003366937042]], [[-1.2891028184617581, 1.2575154250770399], 
[-1.2790167925323068, 1.4111962662775115]], [[-4.0788962526327124, -0.32689803328133493], [-3.5905783452308517, 
1.0516157171730747]], [[4.4557873606530052, -1.5483458047892631], [-1.9425752206251534, 1.6318664448295301]]]))
      arg1=1.75917024823
      res=arg0-arg1
      ref=Data(numpy.array([[[2.4973082590912146, -5.8657882856658379], [1.3168697247947065, 0.63039918379816307]], 
[[-5.2841839868380127, -0.45260756799037694], [-6.62049185499336, -5.2077086508990114]], [[-2.8832500942240271, 
-1.7583749888189661], [-3.6870088244611052, -2.917432975061951]], [[-5.2276493203808636, -0.96547363701338718], 
[1.3904459067866988, -4.3469302249297757]], [[0.34093544031660628, 2.814669008609858], [1.4096859249050269, 
-1.8297513052116186]], [[1.8824088855548577, -4.1727417912678249], [-5.0452779248525363, 
1.5391103632901011]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[2.6601897308098792, 2.9106094552588644], [-6.6893024054518939, -6.7431043765486853]], 
[[-0.62157390438417526, -4.0641979256419605], [-2.6910696711121629, -0.65180440569751585]], [[-5.9765903976599866, 
-1.3462410425440066], [-1.1988011868326707, -5.0822705849198648]], [[-3.0482730666879188, -0.50165482314912069], 
[-3.0381870407584675, -0.34797398194864915]], [[-5.838066500858873, -2.0860682815074956], [-5.3497485934570124, 
-0.70755453105308597]], [[2.6966171124268445, -3.3075160530154237], [-3.7017454688513141, -0.1273038033966305]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank3_array_rank0(self):
      arg0=Data(numpy.array([[[-3.9891561721915214, 4.9969424832792395], [-2.2200117626623426, -4.6104090599073455]], 
[[0.14161635289919428, -1.2865953985056211], [-4.4493283032274515, -4.1160039987101174]], [[0.43385777386316526, 
-2.4527378116849521], [4.0603101214840471, -0.58988476103894794]], [[1.2894714377062, 1.2693817417425102], [3.0174143932363187, 
-0.6940592488351438]], [[-4.1873869949776275, -2.0558049566696122], [-2.603242779107644, 3.5288072476948589]], 
[[2.8370885771195864, -0.98594945588719707], [3.932425952160802, 4.197380047835761]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-1.941108499976385, -4.7400748996230471], [-3.7825952914698178, 
4.4639082394557015]], [[-4.5391630659585056, -4.865805111249716], [0.72935706666979438, 2.7516759342197039]], 
[[3.59666956354787, 3.8744530968809165], [-3.1224619912963103, 3.405762664728444]], [[3.4018945662807116, -2.7762509224043352], 
[4.5471711190173334, -4.7755197510423937]], [[-0.85624863402519935, 2.5169880135988461], [-1.9448195879848229, 
-1.679925898880005]], [[2.5271477912365974, 4.0064997736050962], [0.922895223638454, 1.4947692601300258]]]))
      arg1=numpy.array(-1.13486717569)
      res=arg0-arg1
      ref=Data(numpy.array([[[-2.8542889964974938, 6.1318096589732676], [-1.085144586968315, -3.4755418842133179]], 
[[1.2764835285932219, -0.15172822281159348], [-3.3144611275334239, -2.9811368230160897]], [[1.5687249495571929, 
-1.3178706359909245], [5.1951772971780752, 0.54498241465507968]], [[2.4243386134002276, 2.4042489174365378], 
[4.1522815689303467, 0.44080792685888381]], [[-3.0525198192835998, -0.92093778097558454], [-1.4683756034136164, 
4.6636744233888869]], [[3.971955752813614, 0.14891771980683055], [5.0672931278548301, 5.3322472235297891]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-0.8062413242823574, -3.6052077239290194], [-2.6477281157757901, 
5.5987754151497295]], [[-3.404295890264478, -3.7309379355556884], [1.864224242363822, 3.8865431099137315]], 
[[4.7315367392418981, 5.0093202725749446], [-1.9875948156022827, 4.5406298404224721]], [[4.5367617419747397, 
-1.6413837467103076], [5.6820382947113615, -3.6406525753483661]], [[0.27861854166882827, 3.6518551892928737], 
[-0.80995241229079529, -0.54505872318597737]], [[3.662014966930625, 5.1413669492991243], [2.0577623993324816, 
2.6296364358240534]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank3_array_rank3(self):
      arg0=Data(numpy.array([[[4.8971048411358549, 1.9239720317083284], [-1.7974662160983534, -1.7073504726049582]], 
[[4.9202114968567017, -4.5214077971964519], [0.72650775747922047, 2.8230337545948005]], [[2.4253623643557942, 
-4.7090189921197076], [-3.894123497364931, 4.5432421231968316]], [[-0.19093845966376843, 1.0294618514246263], 
[4.2545571838803742, -4.2530931123770639]], [[-0.37916144795255757, 1.8618639784273157], [-2.1300258776939907, 
3.8848577672871478]], [[2.5781669150500433, -0.22701174053596773], [0.48850530081253041, 
1.233142232351943]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[1.6533732409662214, 1.7920457478427956], [3.0556702512032921, 4.1101396797640799]], 
[[1.8255036539373943, -0.43911519788338094], [-4.6908480597911772, 4.2770630845281747]], [[4.3077477133428275, 
3.6269334682712113], [3.2922552842500128, 2.3810133908681497]], [[-3.6755568892870647, 3.6419751400544147], 
[-1.9413458586104317, -1.5169446128613693]], [[-0.74062749841019659, 4.1579730399796606], [4.1373390876206422, 
2.8506541923128452]], [[-3.9886465741242483, 4.0265553569139012], [-3.3895396487996097, -3.7847981154740582]]]))
      arg1=numpy.array([[[-3.4399729133944845, 3.4448277514325341], [-0.72284399493198404, 0.76428871852450797]], 
[[3.5458319400063196, -2.7347001608218378], [3.0238675877320365, 3.2643360192241957]], [[3.8963117222511023, 
-0.33861305802489827], [3.8264368674031992, -0.2455723607353546]], [[3.5472163555594438, -0.55282994825627707], 
[-4.7517248185874585, 1.0943894196479063]], [[4.6376040885331768, -4.3235842129183899], [-4.495759535277025, 
1.6904328461349039]], [[1.4603054229873056, 1.5291622757470673], [-3.7328337423962807, 1.1452899978426672]]])
      res=arg0-arg1
      ref=Data(numpy.array([[[8.3370777545303394, -1.5208557197242056], [-1.0746222211663694, -2.4716391911294662]], 
[[1.374379556850382, -1.7867076363746142], [-2.297359830252816, -0.44130226462939515]], [[-1.4709493578953081, 
-4.3704059340948094], [-7.7205603647681302, 4.7888144839321862]], [[-3.7381548152232122, 1.5822917996809034], 
[9.0062820024678327, -5.3474825320249701]], [[-5.0167655364857344, 6.1854481913457056], [2.3657336575830343, 
2.194424921152244]], [[1.1178614920627377, -1.756174016283035], [4.2213390432088111, 
0.087852234509275817]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[5.0933461543607059, -1.6527820035897385], [3.7785142461352761, 3.3458509612395719]], 
[[-1.7203282860689253, 2.2955849629384568], [-7.7147156475232137, 1.012727065303979]], [[0.41143599109172513, 
3.9655465262961096], [-0.53418158315318642, 2.6265857516035043]], [[-7.2227732448465085, 4.1948050883106918], 
[2.8103789599770268, -2.6113340325092755]], [[-5.3782315869433734, 8.4815572528980496], [8.6330986228976663, 
1.1602213461779414]], [[-5.4489519971115534, 2.4973930811668339], [0.34329409359667107, -4.9300881133167254]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank3_constData_rank0(self):
      arg0=Data(numpy.array([[[-0.3874407043998449, 2.7437813276070413], [-3.8690736521945746, 0.49649462282000201]], 
[[-3.3676937292338893, -3.0678899265906621], [3.7204552222458904, -0.5264205520698173]], [[0.34941136431141295, 
0.55768469116307973], [0.82345769377248157, 3.2156933114223065]], [[3.1638549777413374, 2.4807826698537427], 
[0.76856921059179761, 3.4091726738049033]], [[2.061518562893748, 1.1212297167679921], [4.2357238187549768, 
4.9237662346662585]], [[-4.9085459977421388, 0.20870032455748699], [1.096935031387086, 
0.77701997496095032]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[1.0067096581520989, 4.1592404458026344], [4.4808554539494327, 0.44410039054845463]], 
[[-1.1111903679883604, 3.7964318991423855], [4.6318492211267568, 3.7629286617376874]], [[2.4978325481532417, 
4.6568360140027849], [-1.6352702911933772, 3.3002224813994587]], [[3.8503347284023661, -2.7502187736317616], 
[-0.28581753468802873, -3.4167639838117747]], [[3.654745915433713, -1.5250518616334876], [4.3711183603272765, 
-0.75515267118169582]], [[-4.5053760627744976, 3.903683291803425], [-0.2614931137375045, -4.7545562842000608]]]))
      arg1=Data(0.134425143309,self.functionspace)
      res=arg0-arg1
      ref=Data(numpy.array([[[-0.52186584770877342, 2.6093561842981128], [-4.0034987955035035, 0.36206947951107349]], 
[[-3.5021188725428178, -3.2023150698995906], [3.5860300789369619, -0.66084569537874582]], [[0.21498622100248443, 
0.42325954785415121], [0.68903255046355305, 3.081268168113378]], [[3.0294298344324089, 2.3463575265448142], 
[0.63414406728286909, 3.2747475304959748]], [[1.9270934195848195, 0.98680457345906358], [4.1012986754460483, 
4.78934109135733]], [[-5.0429711410510674, 0.074275181248558475], [0.96250988807815752, 
0.6425948316520218]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[0.87228451484317038, 4.0248153024937059], [4.3464303106405042, 0.30967524723952611]], 
[[-1.2456155112972889, 3.662006755833457], [4.4974240778178283, 3.6285035184287588]], [[2.3634074048443132, 
4.5224108706938564], [-1.7696954345023057, 3.1657973380905302]], [[3.7159095850934376, -2.8846439169406901], 
[-0.42024267799695725, -3.5511891271207032]], [[3.5203207721247844, -1.6594770049424161], [4.236693217018348, 
-0.88957781449062434]], [[-4.6398012060834262, 3.7692581484944965], [-0.39591825704643302, -4.8889814275089893]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank3_constData_rank3(self):
      arg0=Data(numpy.array([[[-1.7239636201807196, -2.1894428046404557], [-0.75346816425067598, -1.9324217120928022]], 
[[-3.8839523476557969, -0.28985995277461463], [-0.9341707360418674, -4.8909895202216962]], [[2.9673338142268904, 
-3.1419755627781187], [-1.5741891117434759, 1.4833163928695292]], [[3.2316179312401676, 3.5300095598203765], 
[-1.3670625657812483, 4.0491101489598833]], [[0.59802261570008586, 0.054626133783393094], [4.8554948831353855, 
-4.9204766721813717]], [[2.4816837177392976, 3.5743021152631442], [-3.9224239710267295, 
2.4263498665751442]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-3.5515041934641567, 1.9459352187371763], [3.5402443085051125, 
-2.1660687725529923]], [[-0.21629800630426388, 4.8840936101489518], [4.5983036970667506, 3.3280514826517464]], 
[[3.0020050653663812, 3.0631909020095751], [3.1276310345505625, 1.3008772165056186]], [[-1.359898082940779, 
-3.2577035773531882], [-2.2979719774869478, 1.6062235716191111]], [[-3.8043803806288166, -0.19817894087733823], 
[3.7340613897252091, 0.058266628892274852]], [[-2.9488899932635402, 4.6799276575256581], [3.6745242642721667, 
3.2585187857842559]]]))
      arg1=Data(numpy.array([[[0.68176693705702007, -1.5797769914803572], [0.83669037659734524, -1.8437736898652188]], 
[[3.3243881407853628, 0.97543110028839219], [1.2942355021142298, 0.42761599927037253]], [[-3.211752859170236, 
-1.5421963833963703], [4.8408415393753561, -2.7094150742832159]], [[-3.0586367841206643, 3.8843536628289872], 
[0.73701988910910199, 2.325407867337443]], [[4.1111978648099878, -4.424188068128613], [-2.2848675639896801, 
4.7710014462925106]], [[-3.7503885320832211, 4.2650196603384174], [-2.008762036246682, 
-0.31544056222811889]]]),self.functionspace)
      res=arg0-arg1
      ref=Data(numpy.array([[[-2.4057305572377397, -0.60966581316009849], [-1.5901585408480212, -0.08864802222758339]], 
[[-7.2083404884411593, -1.2652910530630068], [-2.2284062381560972, -5.3186055194920687]], [[6.1790866733971264, 
-1.5997791793817484], [-6.4150306511188315, 4.1927314671527451]], [[6.2902547153608319, -0.35434410300861074], 
[-2.1040824548903503, 1.7237022816224403]], [[-3.513175249109902, 4.4788142019120061], [7.1403624471250655, 
-9.6914781184738814]], [[6.2320722498225187, -0.69071754507527316], [-1.9136619347800474, 
2.7417904288032631]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-4.2332711305211763, 3.5257122102175336], [2.7035539319077673, 
-0.32229508268777352]], [[-3.5406861470896267, 3.9086625098605596], [3.3040681949525208, 2.9004354833813739]], 
[[6.2137579245366172, 4.6053872854059454], [-1.7132105048247936, 4.0102922907888345]], [[1.6987387011798853, 
-7.1420572401821758], [-3.0349918665960498, -0.71918429571833187]], [[-7.9155782454388044, 4.2260091272512748], 
[6.0189289537148891, -4.7127348174002357]], [[0.80149853881968092, 0.4149079971872407], [5.6832863005188488, 
3.5739593480123748]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank3_taggedData_rank0(self):
      arg0=Data(numpy.array([[[0.66027501713658676, -0.085351180813194816], [-1.5248157036941654, 0.40304265519344629]], 
[[-4.961187808722328, -3.044122959439719], [-4.6005820676281752, -1.1754248280154433]], [[1.5075904831961324, 
4.6002847833353737], [-1.5861082697346318, 3.781564618049595]], [[-2.4359452508560011, -4.6899478361221005], 
[-2.5528282625721821, -2.8609481997806907]], [[-3.0298194425829958, -3.0084937816592761], [0.131267151748653, 
4.0108734397142562]], [[1.9321694609335953, -4.9204224634724012], [1.4381287284223907, 
-4.1554161532032889]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-0.45801734360267243, -0.32876484549741569], [-2.779225713206861, 
4.5779222714250025]], [[3.3761884729756932, 3.0222858473537322], [-3.6664863553290794, 0.79789343483881314]], 
[[1.0797996184317977, -3.9068082849397912], [1.7773349222780146, -1.1703257271034739]], [[-4.4129117281517978, 
1.5978248145323644], [2.6065693994403247, 1.3950742595891139]], [[-1.5489480402691083, -3.0606281277028846], 
[-3.7231531120877803, -2.213187267624932]], [[1.9610208865205028, -3.3832781731148129], [0.68866013613574939, 
-1.1693414234632593]]]))
      arg1=Data(0.24684801615,self.functionspace)
      arg1.setTaggedValue(1,-4.02030755935)
      res=arg0-arg1
      ref=Data(numpy.array([[[0.41342700098668583, -0.33219919696309574], [-1.7716637198440663, 0.15619463904354536]], 
[[-5.2080358248722289, -3.2909709755896199], [-4.8474300837780762, -1.4222728441653443]], [[1.2607424670462315, 
4.3534367671854728], [-1.8329562858845327, 3.5347166018996941]], [[-2.682793267005902, -4.9367958522720015], 
[-2.799676278722083, -3.1077962159305916]], [[-3.2766674587328968, -3.255341797809177], [-0.11558086440124793, 
3.7640254235643553]], [[1.6853214447836944, -5.1672704796223021], [1.1912807122724898, 
-4.4022641693531899]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[3.5622902157523262, 3.6915427138575829], [1.2410818461481377, 8.5982298307800011]], 
[[7.3964960323306919, 7.0425934067087308], [0.35382120402591921, 4.8182009941938118]], [[5.1001071777867963, 
0.11349927441520746], [5.7976424816330132, 2.8499818322515247]], [[-0.39260416879679916, 5.618132373887363], 
[6.6268769587953233, 5.4153818189441125]], [[2.4713595190858904, 0.959679431652114], [0.29715444726721829, 
1.8071202917300666]], [[5.9813284458755014, 0.63702938624018568], [4.708967695490748, 2.8509661358917393]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank3_taggedData_rank3(self):
      arg0=Data(numpy.array([[[-4.3840689888045334, 4.8441554311942383], [-2.0693097333909529, -3.9078953490260604]], 
[[-3.1797346121224077, -1.8466459702867621], [-4.9873278593220771, 3.8278172261134529]], [[-2.6624996635188891, 
2.1843837334191321], [4.1085249191216526, 0.24745683652938855]], [[-2.1495688603395449, -1.0055602897159654], 
[3.0751798627353679, 4.8697671978018846]], [[-2.1982239534152814, 3.3412459001836705], [0.13874429133832411, 
4.862907346772543]], [[0.63690723448301334, -0.71797054110956005], [1.0721045628526227, 
-4.0077852094497137]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-4.9851613825397267, 1.5201397429853856], [-0.41409260317009977, 
-2.908866457451702]], [[-2.1300627048643319, 4.8285553870485352], [-0.55644825093165373, -2.3201094193155694]], 
[[0.49666491020370351, 4.1838782219369968], [-3.0769917857109084, -4.4252750114477983]], [[3.7493519056357982, 
-0.8670859015139154], [-2.4864227931070437, -4.5700129932748208]], [[0.98848430688134759, 1.4522096166745433], 
[3.1184776602968096, 3.2955426878406584]], [[1.8153272152914743, -1.9193099602016739], [-3.8001950531820547, 
3.1336491121570464]]]))
      arg1=Data(numpy.array([[[2.90754418942476, 2.5673771495266475], [-0.57994459290255129, -1.0482341245482751]], 
[[2.4431643668660286, 0.88145299047172276], [4.9018142433794036, 0.54519139109125181]], [[-0.66206946871496264, 
-2.3752031499600932], [-3.0603556375073926, -4.8693530250567978]], [[2.7195970979292108, -4.9106730127436808], 
[-1.5262359526693139, 2.3251995139787667]], [[-4.0354147708400001, 3.4345715021583167], [0.32456898200307549, 
-3.5610075715667344]], [[-0.27590668734124613, 1.7665721623445023], [0.30268509953699319, 
4.7042504930929887]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[-3.5682937023589867, -0.79344027262286598], [2.9508482294081748, 
1.1296930108465633]], [[-0.090110017388136399, 2.8266189936443711], [2.9741243982747996, 2.8905848497783007]], 
[[0.81590228465056747, 2.8408340198746309], [4.494848916476224, 3.0436601510457102]], [[-4.0847879668210734, 
-0.030178592751468614], [4.4582833302943481, 2.3488731366763007]], [[-2.8863698192010911, 0.36313212045064347], 
[3.7669228189103254, 2.1630884895816758]], [[3.4734748797966812, 0.85753156379785977], [3.3129429088456757, 
-3.4548935566548589]]]))
      res=arg0-arg1
      ref=Data(numpy.array([[[-7.2916131782292934, 2.2767782816675908], [-1.4893651404884016, -2.8596612244777853]], 
[[-5.6228989789884363, -2.7280989607584849], [-9.8891421027014808, 3.2826258350222011]], [[-2.0004301948039265, 
4.5595868833792252], [7.1688805566290448, 5.1168098615861863]], [[-4.8691659582687556, 3.9051127230277154], 
[4.6014158154046818, 2.5445676838231179]], [[1.8371908174247187, -0.093325601974646233], [-0.18582469066475138, 
8.4239149183392783]], [[0.91281392182425947, -2.4845427034540624], [0.76941946331562949, 
-8.7120357025427033]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-1.4168676801807401, 2.3135800156082515], [-3.3649408325782746, 
-4.0385594682982653]], [[-2.0399526874761955, 2.0019363934041641], [-3.5305726492064533, -5.21069426909387]], 
[[-0.31923737444686395, 1.3430442020623659], [-7.5718407021871323, -7.4689351624935085]], [[7.8341398724568716, 
-0.83690730876244679], [-6.9447061234013923, -6.9188861299511215]], [[3.8748541260824387, 1.0890774962238998], 
[-0.64844515861351582, 1.1324541982589826]], [[-1.6581476645052069, -2.7768415239995337], [-7.1131379620277304, 
6.5885426688119058]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank3_expandedData_rank0(self):
      arg0=Data(numpy.array([[[2.3344343398801239, 3.9489966110641834], [2.4872535525906532, 2.133774302311096]], 
[[-0.13076296404283028, -2.5462902248083195], [-0.082504268140121795, -3.5681806697458573]], [[-0.059674720157508077, 
-3.9552714572669778], [3.5177260793156417, -1.0116938693436559]], [[-1.6310881346311024, 3.3807396886826719], 
[-2.3971422194333725, 0.56965872678742446]], [[-2.5927110672716047, 3.5995398121620408], [1.0423059159410553, 
2.476206880844801]], [[4.7147000643768475, 1.3175511028780651], [4.0096958295869598, 4.3873472145537082]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-4.6166799964011771, 4.066432073393365], [-3.0532951593533344, 4.793898779177276]], 
[[2.9357465740317688, 4.0833152266666843], [-0.89588216732851045, -0.0065197042905502656]], [[-1.7644319276125184, 
-2.0618868550937828], [1.0591236393975283, -0.82498451988248434]], [[0.25767783313384829, 4.4502581688104677], 
[4.1884936391204128, 3.0892118721583106]], [[2.840480091583971, 2.1635641367987537], [2.8125917050724079, 
-2.5202479118127572]], [[2.5087641814213129, 2.5708519675757868], [0.31873801926657386, -4.9371456135743728]]]))
      arg1=Data(1.62170315022,self.functionspace)
      arg1.setTaggedValue(1,-0.0826614910499)
      arg1.expand()
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[0.71273118966479476, 2.3272934608488542], [0.86555040237532399, 0.51207115209576681]], 
[[-1.7524661142581595, -4.1679933750236486], [-1.704207418355451, -5.189883819961187]], [[-1.6813778703728373, 
-5.576974607482307], [1.8960229291003126, -2.6333970195589851]], [[-3.2527912848464315, 1.7590365384673428], 
[-4.0188453696487016, -1.0520444234279047]], [[-4.2144142174869339, 1.9778366619467116], [-0.57939723427427392, 
0.85450373062947182]], [[3.0929969141615183, -0.30415204733726409], [2.3879926793716306, 
2.7656440643383791]]])+(1.-msk_ref)*numpy.array([[[-4.5340185053512547, 4.1490935644432874], [-2.970633668303412, 
4.8765602702271984]], [[3.0184080650816911, 4.1659767177166067], [-0.81322067627858807, 0.07614178675937211]], 
[[-1.6817704365625961, -1.9792253640438604], [1.1417851304474507, -0.74232302883256196]], [[0.34033932418377066, 
4.53291965986039], [4.2711551301703352, 3.171873363208233]], [[2.9231415826338933, 2.2462256278486761], [2.8952531961223302, 
-2.4375864207628348]], [[2.5914256724712352, 2.6535134586257092], [0.40139951031649623, -4.8544841225244504]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank3_expandedData_rank3(self):
      arg0=Data(numpy.array([[[0.26391586986843318, -0.8378850468651784], [-4.1810753809731205, 3.6014566818456508]], 
[[-4.820804809906277, 1.5260873510157777], [-1.8776112202204587, -1.2211688685744351]], [[0.34257583543327552, 
-0.32763058155846547], [3.3654760459296735, -0.79876945144976208]], [[-0.67748150818170672, -1.1553467344634805], 
[4.2319795520235655, -3.3833839986961922]], [[3.8920871902373619, -4.1678952208257556], [-2.6442249175846202, 
-1.446517078186166]], [[-0.43143892830716446, 0.66496498805753834], [4.9865193158626173, 
-0.59793943236097036]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-1.3042182665864233, -4.834778215206553], [-4.5344508150423142, 
4.6440981687671297]], [[1.8878023823547165, 4.8948108938159471], [-3.9273144945356862, 1.1219168589951209]], 
[[-4.6546090432410931, 3.1144442356646103], [0.80975047426259383, 4.1662805586165668]], [[-2.7999494371816747, 
-2.7561078282707019], [0.30604567774842018, 2.5574676994530758]], [[-2.9668103927481981, -0.27827434746351187], 
[3.4783932196222356, 3.188683719409104]], [[-2.1679334345587211, -4.6031786966653785], [-3.134039200406419, 
-0.81125053682391446]]]))
      arg1=Data(numpy.array([[[1.3035321556663444, 2.0466445470335977], [-3.3912336614749772, 3.729342744575499]], 
[[-3.4677146253325342, 1.5803012351182266], [-0.9639120745384675, 2.880853651392683]], [[-0.21200570634323324, 
1.3074613547227321], [-4.218792966938576, 2.1873759000951329]], [[0.059909470639398776, 0.71862333611470408], 
[0.41162811182007353, 4.2308428500254287]], [[3.5454039544604274, 2.5121160969553911], [-1.0441529901145365, 
-0.46457052013903688]], [[-1.9608611517817156, 0.91444435227208842], [-4.339716402225875, 
0.30415977232108737]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[1.6751320801094352, -0.58441613274973747], [-2.1190427546290023, 
-3.9719327176624128]], [[-2.5712630296622772, -4.5832722752045152], [-1.8298924405466055, 4.9889065956491248]], 
[[-1.5503035275737096, -3.8993402038267666], [-3.6228407127246687, -2.8846985209270515]], [[-1.7250094602720534, 
-3.0581215633824277], [-0.55522503998568862, 0.64365580973355385]], [[4.0273019615281136, -4.0722867383534211], 
[4.0734551862118114, -2.2248424007430847]], [[-3.3057527663612554, -0.76747186823799929], [2.5595050352440216, 
-2.2780727900372733]]]))
      arg1.expand()
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-1.0396162857979112, -2.8845295938987761], [-0.7898417194981433, -0.12788606272984815]], 
[[-1.3530901845737429, -0.054213884102448873], [-0.91369914568199118, -4.1020225199671181]], [[0.55458154177650876, 
-1.6350919362811975], [7.5842690128682495, -2.986145351544895]], [[-0.73739097882110549, -1.8739700705781845], 
[3.8203514402034919, -7.6142268487216214]], [[0.3466832357769345, -6.6800113177811467], [-1.6000719274700836, 
-0.98194655804712916]], [[1.5294222234745511, -0.24947936421455008], [9.3262357180884923, 
-0.90209920468205773]]])+(1.-msk_ref)*numpy.array([[[-2.9793503466958584, -4.2503620824568156], [-2.4154080604133119, 
8.6160308864295416]], [[4.4590654120169937, 9.4780831690204614], [-2.0974220539890807, -3.8669897366540038]], 
[[-3.1043055156673836, 7.0137844394913769], [4.4325911869872625, 7.0509790795436178]], [[-1.0749399769096213, 
0.3020137351117258], [0.86127071773410879, 1.913811889719522]], [[-6.9941123542763117, 3.7940123908899093], 
[-0.59506196658957577, 5.4135261201521887]], [[1.1378193318025343, -3.8357068284273792], [-5.6935442356504407, 
1.4668222532133588]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank4_float_rank0(self):
      arg0=Data(numpy.array([[[[0.70901541214897357, 0.59625495783189741, -1.9603322200648687, -0.31596849871918664], 
[-3.472608140881551, 3.725039349508787, -3.461377184840817, -4.6278846603742476], [0.47648237988634534, -0.8491760439464251, 
-1.8110807262178987, 1.8417660315203062]], [[-1.1595795431846554, -2.0394767648507193, -1.5467347339797111, 
-2.1299382457045803], [-2.6531446979396933, -3.4516033903885326, 0.73764764664182447, -3.6002715567130306], 
[0.23080007865882379, 1.9006907131520778, -3.7597046500968623, 3.8088925293190528]]], [[[-4.993198908331995, 
2.4880510258873176, 1.929057893921911, 3.8439106871234632], [2.6478663312638293, 3.5803349373812239, -2.7270696016179166, 
-2.0288959324685587], [-3.9927829706200022, -4.3651076128011246, 0.30241402955823027, -2.9209581671116447]], 
[[-2.7403755328743462, 4.1773726144283394, -3.3554296460361934, -2.7427563019188081], [-1.9648594892804616, 2.4172181344436492, 
4.6819254377497064, -4.5804025077225088], [3.4052678187076211, -0.38536827366193549, -3.8027872363306425, 
4.3450089093217983]]], [[[3.3905623068473432, 3.7491775371384612, -3.7239623314922801, 4.6121851793348139], 
[-1.4125300688927176, 1.3356241650042318, -1.7207865099238564, 4.6416684964804453], [4.8884307860345864, -1.8519605243401847, 
3.484563841041485, 4.7476466768532291]], [[-1.1826399246360788, -3.3456911064071635, -3.3760975793909118, -3.7917281076856844], 
[-4.3139545461189366, 1.0811644839153089, 4.6196641161492344, -2.4656136242591264], [1.2929906398723805, -2.127384744409536, 
-1.454918466647622, -2.6917750826298348]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[1.812665996442572, -2.5540038759939887, -1.1027312967639382, 3.3580550288139115], 
[1.0653703911905721, -4.8803062686744001, 2.0804399023921327, -0.35116686405810871], [3.1543920027030552, -2.7905755906930585, 
-0.17892611974893136, -2.5296325439560805]], [[0.074588662814632833, -0.93105092660139466, -1.6090661654270955, 
-4.9200834405600542], [-2.4309334454648166, 1.7252264468805301, -4.5213217448319609, 2.6399010140937449], [0.81657678103727527, 
0.69604902938024793, 2.382245544389928, 4.7613850087301657]]], [[[-1.4981401420001763, 2.0746808767900839, -2.2511176394935939, 
-2.402585088421346], [1.4189285617894214, -1.480607267615397, 2.4925327398541093, 2.8952832858751085], [-2.8358406998209373, 
0.061508520876957462, -2.196332435408781, 1.8176356797049493]], [[0.8744567636409819, 3.0991035031936001, 3.536726941675898, 
-0.2971247765692473], [2.6090994095187003, 1.080812841536396, 2.2318315534903812, -0.68244218055381811], [3.5004285588156314, 
1.7899017929070027, 4.5275453717845551, -0.65771645594568806]]], [[[-3.195215371481078, -2.2218764474400929, 
3.1211047312489484, -1.2642237490839845], [2.9800760762573466, 1.6717951757797227, -4.7552678099869219, 0.30297900300230918], 
[-0.96366168823298626, 1.4966217429394195, -3.2423356522218905, 4.6637343160525973]], [[2.9843697399717763, 
-4.8906286874764016, -0.79445349036124213, 2.7595368231279842], [0.97584552906878042, -3.0195848245483803, 0.49797035481315, 
-1.3000844105242306], [0.32959678179791752, -3.9901987007137896, 0.75942521638303795, 4.1478027405587543]]]]))
      arg1=2.3333476588
      res=arg0-arg1
      ref=Data(numpy.array([[[[-1.6243322466516714, -1.7370927009687476, -4.2936798788655137, -2.6493161575198316], 
[-5.805955799682196, 1.391691690708142, -5.794724843641462, -6.9612323191748926], [-1.8568652789142996, -3.1825237027470701, 
-4.1444283850185437, -0.49158162728033883]], [[-3.4929272019853004, -4.3728244236513643, -3.880082392780356, 
-4.4632859045052253], [-4.9864923567403387, -5.7849510491891776, -1.5957000121588205, -5.9336192155136755], 
[-2.1025475801418212, -0.43265694564856716, -6.0930523088975068, 1.4755448705184078]]], [[[-7.32654656713264, 
0.15470336708667265, -0.40428976487873403, 1.5105630283228182], [0.31451867246318432, 1.2469872785805789, -5.0604172604185615, 
-4.3622435912692037], [-6.3261306294206472, -6.6984552716017696, -2.0309336292424147, -5.2543058259122901]], 
[[-5.0737231916749916, 1.8440249556276944, -5.6887773048368384, -5.0761039607194531], [-4.2982071480811062, 
0.083870475643004205, 2.3485777789490614, -6.9137501665231538], [1.0719201599069761, -2.7187159324625805, -6.1361348951312875, 
2.0116612505211533]]], [[[1.0572146480466982, 1.4158298783378163, -6.0573099902929251, 2.2788375205341689], 
[-3.7458777276933626, -0.99772349379641323, -4.0541341687245014, 2.3083208376798003], [2.5550831272339414, -4.1853081831408296, 
1.15121618224084, 2.4142990180525841]], [[-3.5159875834367238, -5.6790387652078085, -5.7094452381915568, -6.1250757664863293], 
[-6.6473022049195816, -1.252183174885336, 2.2863164573485895, -4.7989612830597714], [-1.0403570189282645, -4.4607324032101809, 
-3.788266125448267, -5.0251227414304793]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-0.52068166235807301, -4.8873515347946341, -3.4360789555645832, 1.0247073700132665], 
[-1.2679772676100729, -7.2136539274750451, -0.25290775640851226, -2.6845145228587537], [0.82104434390241021, 
-5.1239232494937035, -2.5122737785495763, -4.8629802027567255]], [[-2.2587589959860122, -3.2643985854020396, 
-3.9424138242277404, -7.2534310993606992], [-4.7642811042654616, -0.60812121192011492, -6.8546694036326059, 
0.30655335529309991], [-1.5167708777633697, -1.6372986294203971, 0.048897885589282986, 2.4280373499295207]]], 
[[[-3.8314878008008213, -0.25866678201056104, -4.5844652982942389, -4.735932747221991], [-0.91441909701122359, 
-3.8139549264160419, 0.15918508105346429, 0.56193562707446354], [-5.1691883586215823, -2.2718391379236875, -4.529680094209426, 
-0.51571197909569566]], [[-1.4588908951596631, 0.76575584439295508, 1.203379282875253, -2.6304724353698923], 
[0.27575175071805536, -1.252534817264249, -0.10151610531026378, -3.0157898393544631], [1.1670809000149864, -0.5434458658936423, 
2.1941977129839101, -2.991064114746333]]], [[[-5.528563030281723, -4.5552241062407379, 0.7877570724483034, 
-3.5975714078846295], [0.64672841745670162, -0.66155248302092229, -7.0886154687875669, -2.0303686557983358], 
[-3.2970093470336312, -0.83672591586122547, -5.5756833110225354, 2.3303866572519523]], [[0.65102208117113136, 
-7.2239763462770465, -3.1278011491618871, 0.42618916432733922], [-1.3575021297318646, -5.3529324833490257, -1.835377303987495, 
-3.6334320693248756], [-2.0037508770027275, -6.3235463595144346, -1.573922442417607, 1.8144550817581093]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank4_array_rank0(self):
      arg0=Data(numpy.array([[[[3.887589148175616, 0.41672113628062135, -4.1723951112076882, -2.4477201546168126], 
[3.0808823140815296, -3.2089975544786729, 1.7865487690320787, -1.3389756129441519], [-0.41667649360353387, 1.3386002975578704, 
0.68112108538798743, 0.071577369741708807]], [[3.6516729361391871, -2.873182782420729, -4.6125652135356043, 
-2.1215002685698678], [-0.71279224575689604, -1.7383191518702876, -1.4913314047375623, -0.48819119899356611], 
[-3.8352436571286095, -2.7641735526009836, 0.46597879687011279, 2.4195109500759386]]], [[[-3.0248135219390262, 
1.104604670433627, 2.338986179968801, 1.189541771763782], [0.26465730445872548, -0.64247839385358585, -3.6822118818503613, 
4.0134413219500011], [-3.3723814272751005, 3.4871310418009607, 2.8414273338435301, 3.3041350979922299]], [[-2.0205647169095342, 
1.3903765781761077, -3.9770961236438462, 2.3301047996820392], [4.4716931784839868, 2.7007472775832824, -3.2639533798496698, 
2.6683897190349439], [0.40132971205891632, 1.1314829162464441, 0.75517925066440483, 1.8089175773921049]]], 
[[[1.3241626096479875, 2.3770668332995717, -1.1276994366185034, 2.9683007187577886], [-0.29301711484102277, 4.1431205123956598, 
-3.4152611334003415, 1.0053817824634841], [3.9185320338842473, -4.8215929896541638, 1.0226632910141511, 4.6572763109677098]], 
[[1.1884542487063374, -0.12216159583094566, 0.47804832518655083, -0.80241441712779604], [3.595912581650607, 
-4.0912858289191609, -4.5989779438488476, -0.074684529806569699], [-3.941286765986769, -1.9099503406336238, 3.2569023537610686, 
-4.8864465435949631]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[3.3791506113586696, 3.1400479575980906, -2.2848937571975512, -3.9943841528953481], 
[-0.24230460876573012, 2.37610949474265, -0.60079249820573555, -4.1378580996118686], [0.0073330881986208851, 
3.2949138232256363, -1.6851692532326301, -3.3382974309378577]], [[-2.3936563434027223, -2.6641488479481423, 
-1.9623014818346629, 0.61112954400354358], [-2.860784043855551, -1.9788880040997734, 2.684886564270867, 4.6827631908489131], 
[-3.7418276922015394, 2.0456506902502003, 2.4904261129871506, -1.1564567243600701]]], [[[3.3434667916442802, 4.620612181281178, 
-0.24999687839081197, 0.93682482641808562], [-4.6814944232921736, 3.6776460569938454, 1.573660755361427, -4.0136768754652934], 
[3.9905863110394009, -2.0277901939344822, -0.47604282412043819, 3.3049405058320893]], [[0.21666572987841981, 
0.012869503825401196, -0.41123443146777028, -4.6141567305980491], [3.1093133098051027, -1.8174735335326342, 
-2.1890596521497487, -0.64000145324016433], [1.1453288204536172, 2.4914824975363379, 4.5330095860371173, 4.9028900718585611]]], 
[[[-1.4952584367320751, 1.720196285398047, 1.4934587890959614, -1.7652801133431009], [4.4696809923972811, -2.102205564176558, 
-0.38954208686292535, -2.149195473588883], [-3.9229637463348044, -3.1906837571343605, -1.0421418759708256, 
2.0376142222867077]], [[4.3438135616787346, -3.0622359543313946, 0.99698897808466302, -3.5171498370202725], 
[-1.8007255100439004, -2.5772750649939713, 1.3565264315235197, 2.9946212776810679], [-2.2674760730886669, -2.3174187858826834, 
-4.5621532594858563, 0.65487965167204365]]]]))
      arg1=numpy.array(0.793657361215)
      res=arg0-arg1
      ref=Data(numpy.array([[[[3.0939317869607672, -0.3769362249342274, -4.966052472422537, -3.2413775158316613], 
[2.2872249528666808, -4.0026549156935216, 0.99289140781722995, -2.1326329741590007], [-1.2103338548183826, 0.5449429363430216, 
-0.11253627582686132, -0.72207999147313995]], [[2.8580155749243383, -3.6668401436355778, -5.4062225747504531, 
-2.9151576297847166], [-1.5064496069717448, -2.5319765130851364, -2.2849887659524111, -1.2818485602084149], 
[-4.6289010183434582, -3.5578309138158324, -0.32767856434473597, 1.6258535888610899]]], [[[-3.818470883153875, 
0.31094730921877822, 1.5453288187539522, 0.3958844105489332], [-0.52900005675612327, -1.4361357550684346, -4.4758692430652101, 
3.2197839607351524], [-4.1660387884899492, 2.6934736805861119, 2.0477699726286813, 2.5104777367773812]], [[-2.814222078124383, 
0.59671921696125896, -4.7707534848586945, 1.5364474384671905], [3.6780358172691381, 1.9070899163684336, -4.0576107410645186, 
1.8747323578200952], [-0.39232764915593243, 0.33782555503159539, -0.038478110550443922, 1.0152602161772561]]], 
[[[0.53050524843313873, 1.5834094720847229, -1.9213567978333521, 2.1746433575429398], [-1.0866744760558715, 3.3494631511808111, 
-4.2089184946151903, 0.21172442124863533], [3.1248746726693986, -5.6152503508690126, 0.22900592979930234, 3.863618949752861]], 
[[0.39479688749148867, -0.91581895704579441, -0.31560903602829793, -1.5960717783426448], [2.8022552204357583, 
-4.8849431901340097, -5.3926353050636964, -0.86834189102141845], [-4.7349441272016177, -2.7036077018484725, 2.4632449925462199, 
-5.6801039048098119]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[2.5854932501438208, 2.3463905963832419, -3.0785511184123999, -4.7880415141101969], 
[-1.0359619699805789, 1.5824521335278012, -1.3944498594205843, -4.9315154608267173], [-0.78632427301622787, 2.5012564620107876, 
-2.4788266144474789, -4.1319547921527064]], [[-3.187313704617571, -3.4578062091629911, -2.7559588430495117, 
-0.18252781721130518], [-3.6544414050703997, -2.7725453653146221, 1.8912292030560183, 3.8891058296340644], 
[-4.5354850534163882, 1.2519933290353515, 1.6967687517723018, -1.9501140855749188]]], [[[2.5498094304294314, 
3.8269548200663293, -1.0436542396056607, 0.14316746520323687], [-5.4751517845070223, 2.8839886957789966, 0.78000339414657827, 
-4.8073342366801421], [3.1969289498245521, -2.821447555149331, -1.2697001853352869, 2.5112831446172406]], 
[[-0.57699163133642895, -0.78078785738944756, -1.204891792682619, -5.4078140918128978], [2.3156559485902539, 
-2.6111308947474829, -2.9827170133645975, -1.4336588144550131], [0.35167145923876841, 1.6978251363214891, 3.7393522248222686, 
4.1092327106437123]]], [[[-2.2889157979469239, 0.92653892418319828, 0.69980142788111266, -2.5589374745579496], 
[3.6760236311824324, -2.8958629253914068, -1.1831994480777741, -2.9428528348037317], [-4.7166211075496527, -3.9843411183492092, 
-1.8357992371856744, 1.243956861071859]], [[3.5501562004638858, -3.8558933155462434, 0.20333161686981427, -4.3108071982351213], 
[-2.5943828712587491, -3.3709324262088201, 0.56286907030867095, 2.2009639164662191], [-3.0611334343035157, -3.1110761470975321, 
-5.355810620700705, -0.13877770954280511]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank4_array_rank4(self):
      arg0=Data(numpy.array([[[[4.2273674552009854, 1.7600767981034977, -3.9207778565132454, -3.1294959749037874], 
[2.4220791748486361, -0.67808038709858653, 1.1876517051483946, 0.38076774463138285], [4.7357541798312699, 1.9361901873593057, 
3.5771773419947674, 0.84466418200217053]], [[4.3832854348216692, -2.0992108039820776, 0.89426152208811782, 1.6490838790585052], 
[4.2766794438785602, 1.2395388904999454, 4.868697963623994, 4.6723392147242162], [-1.336922931105049, -3.7732416908467137, 
-2.2357598092404807, -2.7269535981793935]]], [[[-0.83949413085808811, 0.7527050208719297, -3.3941646545672244, 
0.28244177983269658], [3.8048445709517615, -0.27883073356100407, 1.923100217324003, 2.4499555508919455], [-0.78487550059829303, 
2.5001054007954382, -0.15935433112604169, 3.1623886429708854]], [[0.78088728704731558, 1.2046038842231876, 2.3735639862265199, 
1.5483647699051053], [1.0441588202911127, -0.3022151562250297, -3.0792071649384276, 2.7383658966459903], [1.6260828472562538, 
-4.2514696486097012, -0.34711370542960385, -0.57189811378187372]]], [[[-0.34374094667689725, -4.4846912943593864, 
0.19385464487479709, -1.4496570052596489], [0.33556459077355516, -3.0215854783059291, -4.965244692963628, 
-0.06301172534706545], [3.2825207595430079, -4.5782998483919339, -1.9257972102594545, -2.3733643798217532]], 
[[0.13714333697774084, 4.5313099327742528, 4.2745074022126932, 2.976223656361773], [4.2366681501527808, -2.8092506470296841, 
-1.3059198495723101, -0.67156640019732006], [-2.4709523830471958, 2.0467987249310147, -4.7518843501277361, 
-2.947415578171241]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[0.29223359442862051, -3.9135935906705601, 0.68406684349609215, 
-3.6170689339696924], [4.9649616675425143, 0.55399317681801374, 2.6289160559668536, 4.6432000214285214], [-4.4460427643722236, 
2.4695717835597595, -3.5169173474634952, -3.6724063449838216]], [[4.3687549940927752, -4.0109528483131509, 
-0.93938246832415029, -2.5532564140250447], [2.4080123470614794, -1.847518311505346, 1.7398648517561801, -1.1184772465856851], 
[-4.7705304352339137, -3.5089945565836644, -3.887655544500308, -1.1171329587293255]]], [[[-1.8359126146319662, 
1.593322233508502, -3.5169978049454054, 3.2558357470168993], [-3.9912910266115231, 1.0610054025088944, 2.3144285512198728, 
-0.092560651953823125], [-4.5425717330322311, -4.949113454751723, -0.20892742619409876, -3.519463839582623]], 
[[-1.2312690113963667, 1.0169346653083675, 0.93382445128821079, 1.1038699950914967], [-0.79026949993049911, 
-3.9594380151278719, -2.2165365925752334, 3.6952285309920043], [-0.88557504107653973, 1.4946440007247226, -4.5742530170662103, 
0.60123722730387463]]], [[[-0.20005048530261682, -1.8581121832192995, -3.5619761531838599, 0.92630912626160988], 
[-2.2888416409641685, 0.49001694631168036, 4.2142178632957421, -3.1916948103599543], [-4.6144071286132107, -3.315540699612467, 
-4.132488662572614, 1.7882494986497655]], [[1.8713313072220696, -4.5131720305105496, 0.74001240895357157, 4.8418845153186485], 
[-0.7123157561751281, 1.5654197118926767, 0.85956836199613562, -1.8209459600313957], [2.7043987305849093, 0.58285507051636909, 
4.1801718743182761, -4.2647130939931923]]]]))
      arg1=numpy.array([[[[-3.244796874263407, 3.803378791431637, 0.58812305897576689, -0.99427467655370005], 
[-1.0808046927211681, 4.6688974235937177, 2.0475299744871487, -1.1726006527262878], [-1.6085772187064729, 0.53404112441030449, 
1.9107043924318798, -2.834616843087463]], [[-4.6216156584126376, 4.3835250991977084, -4.5893639433388884, 
-0.16602616993551322], [2.1887639005131039, -0.62251732629784762, 3.0061303180919481, 4.5427486249797067], 
[-1.3874610891479899, 2.0092675037240912, -4.0945840694728481, 3.8848719299422783]]], [[[-1.8154230817302808, 
-2.3965350952464504, 1.8830616174289485, 0.2693782713982138], [2.4705918545541516, 1.4536752049757364, 4.9519095402029478, 
-4.0577908284785424], [0.4492398323388036, 4.5910719149559238, 4.3019981903173008, 0.65375890024195726]], 
[[-0.34477045984455579, 1.4773987816730338, 2.0571389671144225, -1.8248806534747573], [1.2582249368878049, 0.91498611572663702, 
2.7211603438229961, -3.4659584590891992], [-2.3533736278543991, -4.9102007157808645, 0.014693300023125744, 
-3.99691575243709]]], [[[0.53218521559267273, 1.3865078611585275, 0.72353672998870167, -4.9312522981589177], 
[0.88829194239569453, -4.1528361748409113, -2.1812074776122756, -4.6096979322268004], [1.3583373972129458, 
-0.86601967082433262, 4.4165092245857096, 0.92105369512490842]], [[-4.5724165298706962, -4.8085119808469354, 
0.32831351435035039, -1.2373038647301371], [-4.5694178945394013, 2.9253641938728379, -1.3498533431326343, -3.686470431545418], 
[-0.75560776737227187, 3.6267069332060533, 3.0176904706032399, 3.1719262359043441]]]])
      res=arg0-arg1
      ref=Data(numpy.array([[[[7.4721643294643929, -2.0433019933281393, -4.5089009154890123, -2.1352212983500873], 
[3.5028838675698042, -5.3469778106923043, -0.85987826933875411, 1.5533683973576706], [6.3443313985377427, 1.4021490629490012, 
1.6664729495628876, 3.6792810250896335]], [[9.0049010932343059, -6.482735903179786, 5.4836254654270062, 1.8151100489940184], 
[2.0879155433654564, 1.862056216797793, 1.8625676455320459, 0.12959058974450954], [0.050538158042940928, -5.7825091945708049, 
1.8588242602323675, -6.6118255281216722]]], [[[0.97592895087219267, 3.1492401161183801, -5.2772262719961729, 
0.013063508434482785], [1.3342527163976099, -1.7325059385367405, -3.0288093228789448, 6.5077463793704879], 
[-1.2341153329370966, -2.0909665141604856, -4.4613525214433425, 2.5086297427289281]], [[1.1256577468918714, 
-0.2727948974498462, 0.31642501911209742, 3.3732454233798626], [-0.21406611659669217, -1.2172012719516667, -5.8003675087614237, 
6.2043243557351895], [3.9794564751106529, 0.65873106717116325, -0.36180700545272959, 3.4250176386552162]]], 
[[[-0.87592616226956999, -5.8711991555179139, -0.52968208511390458, 3.4815952928992688], [-0.55272735162213937, 
1.1312506965349822, -2.7840372153513524, 4.5466862068797349], [1.9241833623300622, -3.7122801775676013, -6.3423064348451641, 
-3.2944180749466616]], [[4.7095598668484371, 9.3398219136211882, 3.9461938878623428, 4.2135275210919101], [8.8060860446921829, 
-5.7346148409025215, 0.043933493560324166, 3.0149040313480979], [-1.7153446156749239, -1.5799082082750386, -7.7695748207309761, 
-6.1193418140755851]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[3.5370304686920275, -7.7169723821021972, 0.095943784520325259, -2.6227942574159924], 
[6.0457663602636824, -4.114904246775704, 0.58138608147970494, 5.8158006741548096], [-2.8374655456657507, 1.935530659149455, 
-5.4276217398953754, -0.83778950189635859]], [[8.9903706525054119, -8.3944779475108593, 3.6499814750147381, 
-2.3872302440895314], [0.2192484465483755, -1.2250009852074983, -1.266265466335768, -5.6612258715653923], [-3.3830693460859238, 
-5.5182620603077552, 0.20692852497254011, -5.0020048886716033]]], [[[-0.020489532901685426, 3.9898573287549524, 
-5.4000594223743539, 2.9864574756186855], [-6.4618828811656748, -0.39266980246684202, -2.637480988983075, 3.9652301765247193], 
[-4.9918115653710347, -9.5401853697076469, -4.5109256165113996, -4.1732227398245803]], [[-0.8864985515518109, 
-0.46046411636466633, -1.1233145158262117, 2.928750648566254], [-2.048494436818304, -4.8744241308545089, -4.937696936398229, 
7.1611869900812035], [1.4677985867778593, 6.4048447165055871, -4.5889463170893361, 4.5981529797409646]]], 
[[[-0.73223570089528955, -3.244620044377827, -4.2855128831725615, 5.8575614244205276], [-3.1771335833598631, 
4.6428531211525916, 6.3954253409080177, 1.4180031218668461], [-5.9727445258261564, -2.4495210287881344, -8.5489978871583236, 
0.86719580352485703]], [[6.4437478370927659, 0.29533995033638583, 0.41169889460322118, 6.0791883800487856], 
[3.8571021383642732, -1.3599444819801612, 2.2094217051287699, 1.8655244715140222], [3.4600064979571812, -3.0438518626896842, 
1.1624814037150362, -7.4366393298975364]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank4_constData_rank0(self):
      arg0=Data(numpy.array([[[[-4.5975898115619174, 2.700309915350438, -0.55264843478487435, 0.37706379770368237], 
[-1.7717732432561863, -4.3607565636527763, -1.8003247703591105, 0.032562171371965931], [0.36205923584056254, 
0.55686527071426628, 0.5842028657285514, 0.649302977796264]], [[0.34019092577746601, 0.71410151089389018, -1.6224501701548144, 
1.1223314014847974], [-3.6224791725660199, 0.72652650565345311, -4.0623364685264498, -2.4282737612415097], [4.619082133862241, 
-3.0616229646721003, 2.2116614209361627, -3.2546113126683585]]], [[[-3.4228832928071795, -4.6385757799467946, 
4.8816489445385081, 1.5180428859788906], [-0.62647925312178199, -4.1158743505188022, -0.22308834774480513, 
-1.8094401800885529], [1.3811483586359765, 4.1229423571248311, 4.4615918325202433, -0.5316529460843018]], 
[[-3.6980831495890665, -1.1230979722063958, -4.5494345824620979, -3.0952675357379578], [1.0414858112865613, 
-3.7829652962191385, 0.15008187576424348, -0.32927207489029797], [3.5240557599132654, -2.9032586428436047, 4.4994663281798815, 
1.0327046578946675]]], [[[0.67067109323934559, -4.0942299070638146, -0.040419263366652025, -2.364457134847564], 
[-0.34799388670933951, 0.52200020237208289, -1.5377891197987714, 3.3362812043492944], [-4.091056534199212, -3.243052108500093, 
-4.3164865620099473, -0.50780146837895668]], [[3.8116213274961179, -1.1375883954135557, 3.8694001491355614, 
-4.8725252822447196], [-3.506035307064217, 2.0381690486483306, -0.10557248053550961, 2.2536321190734308], [-1.2529373600236884, 
-0.098598949650604339, -0.15956769706389817, 0.70215679162951705]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[-3.5221105769440566, 2.8761688084350627, -1.1700125938019843, -2.9498244781405871], 
[2.9884721167613097, -1.1040396839724198, -0.15612059933395894, -4.6004754232203382], [-3.8897029810458763, 
-2.0331994221205054, 4.9977712270182657, 3.3546781608478895]], [[4.4039542063556709, 2.5343641358879125, -2.7984940364800117, 
-4.6300257603213577], [-0.14429025959141395, -0.20969865061809578, 0.83040309291074976, -2.7301583172233004], 
[-1.9762452990628141, -2.3562947922436415, 1.6207307804879196, -2.5670805037950961]]], [[[-3.7034782166355917, 
4.7006626543845531, 4.4561536268096802, 2.1821829437444613], [4.3017401269310884, 0.31173824690634433, 3.4634298882534189, 
0.42840107278366979], [-1.5890714339827881, 4.4021947785539055, 4.9626896684761608, 2.7081287232790894]], [[4.0331739810553291, 
-4.7793218661017125, -0.42586000437054139, -4.8367396492305117], [-4.5170975041820061, 4.1158573548949278, 2.2088938430451801, 
1.0759376339623925], [-1.6720452727991351, 2.74694243701299, 2.4996976038000316, -0.8716250167360009]]], [[[4.553160181214297, 
3.3245246486978388, 2.0458728690872725, 4.3726320791510478], [2.3048636309086969, -2.9486422791367528, 2.4319709938380454, 
-1.6836957421089571], [-3.4740220120170573, 1.432937076421144, 4.442803201696389, -4.8487551127671358]], [[1.0573209062306024, 
-1.310578510847098, 0.12318656559843522, 1.0432431702535236], [2.4606554785210051, 1.6224286865718041, -4.4162535044422082, 
3.3024591460228887], [0.1312669532307229, -0.94304043037619678, -0.8271584073317042, 2.0905145361020203]]]]))
      arg1=Data(2.86668379671,self.functionspace)
      res=arg0-arg1
      ref=Data(numpy.array([[[[-7.4642736082706556, -0.16637388135830022, -3.4193322314936125, -2.4896199990050558], 
[-4.6384570399649245, -7.2274403603615145, -4.6670085670678487, -2.8341216253367723], [-2.5046245608681756, 
-2.3098185259944719, -2.2824809309801868, -2.2173808189124742]], [[-2.5264928709312722, -2.152582285814848, 
-4.4891339668635526, -1.7443523952239408], [-6.4891629692747586, -2.1401572910552851, -6.929020265235188, -5.2949575579502479], 
[1.7523983371535028, -5.9283067613808385, -0.65502237577257549, -6.1212951093770966]]], [[[-6.2895670895159181, 
-7.5052595766555328, 2.0149651478297699, -1.3486409107298476], [-3.4931630498305202, -6.9825581472275404, -3.0897721444535433, 
-4.6761239767972906], [-1.4855354380727617, 1.256258560416093, 1.5949080358115051, -3.39833674279304]], [[-6.5647669462978051, 
-3.989781768915134, -7.4161183791708361, -5.961951332446696], [-1.8251979854221769, -6.6496490929278771, -2.7166019209444947, 
-3.1959558715990362], [0.65737196320452718, -5.7699424395523433, 1.6327825314711433, -1.8339791388140707]]], 
[[[-2.1960127034693926, -6.9609137037725528, -2.9071030600753902, -5.2311409315563022], [-3.2146776834180777, 
-2.3446835943366553, -4.40447291650751, 0.46959740764055624], [-6.9577403309079502, -6.1097359052088311, -7.1831703587186855, 
-3.3744852650876949]], [[0.94493753078737974, -4.0042721921222935, 1.0027163524268232, -7.7392090789534578], 
[-6.3727191037729547, -0.82851474806040759, -2.9722562772442478, -0.61305167763530743], [-4.1196211567324266, 
-2.9652827463593425, -3.0262514937726364, -2.1645270050792211]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-6.3887943736527948, 0.0094850117263245437, -4.0366963905107225, 
-5.8165082748493253], [0.12178832005257156, -3.970723480681158, -3.0228043960426971, -7.4671592199290764], 
[-6.7563867777546145, -4.8998832188292436, 2.1310874303095275, 0.48799436413915132]], [[1.5372704096469327, 
-0.33231966082082565, -5.6651778331887499, -7.4967095570300959], [-3.0109740563001521, -3.076382447326834, -2.0362807037979884, 
-5.5968421139320386], [-4.8429290957715523, -5.2229785889523797, -1.2459530162208186, -5.4337643005038343]]], 
[[[-6.5701620133443299, 1.8339788576758149, 1.589469830100942, -0.68450085296427687], [1.4350563302223502, -2.5549455498023939, 
0.59674609154468072, -2.4382827239250684], [-4.4557552306915262, 1.5355109818451673, 2.0960058717674226, 
-0.15855507342964881]], [[1.1664901843465909, -7.6460056628104507, -3.2925438010792796, -7.7034234459392499], 
[-7.3837813008907442, 1.2491735581861896, -0.65778995366355808, -1.7907461627463457], [-4.5387290695078732, 
-0.11974135969574817, -0.3669861929087066, -3.7383088134447391]]], [[[1.6864763845055588, 0.45784085198910063, 
-0.82081092762146568, 1.5059482824423096], [-0.56182016580004124, -5.8153260758454905, -0.4347128028706928, 
-4.5503795388176957], [-6.3407058087257955, -1.4337467202875942, 1.5761194049876508, -7.715438909475874]], 
[[-1.8093628904781358, -4.1772623075558357, -2.743497231110303, -1.8234406264552145], [-0.40602831818773311, 
-1.2442551101369341, -7.2829373011509464, 0.43577534931415052], [-2.7354168434780153, -3.809724227084935, -3.6938422040404424, 
-0.77616926060671787]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank4_constData_rank4(self):
      arg0=Data(numpy.array([[[[-3.7370584149402064, 2.4260044551730831, -2.7018828649743454, 1.4719652690337242], 
[-3.7892805274504813, 1.2398037108059974, 1.5924756311131301, 0.035721608494889701], [-0.12901863125384683, 
-3.0983538131858603, -0.75237069596481376, -2.7312272098180568]], [[0.75192761862791446, -4.44298524163412, -2.042871576713611, 
0.28456005299768883], [1.3635058293323574, -0.59517281264221999, -1.4686867448354644, 2.4009141372358549], 
[-0.15253394414099652, -4.6499255683136376, 3.6652002587962187, -2.283752956917545]]], [[[-1.5474238002277421, 
-2.7174883582580964, -0.23352324212656228, 1.8098200812003471], [-2.0400652672438335, 0.017043100225180297, 
-4.5069504376487206, 4.2299506944651473], [-0.74495017243645378, -2.7756995841276488, 2.984207570824811, -1.7411467060956309]], 
[[-4.4608393296542692, -1.0006375142005028, -2.8383389673596691, -4.947903123736844], [-2.5204711305720795, 
-3.8298929087724565, -4.2974069300342688, -3.6581808853830147], [-0.15140957628290508, -2.3766140789821133, 2.741887239454198, 
-0.6860405558972591]]], [[[1.2244715673258373, -4.1040186198793318, -0.098635348815872881, -1.2177842026915089], 
[2.7024928137131701, -2.74756414282048, 1.0850251935478195, 1.9509623092092241], [1.0085553496772217, 0.065334992519680668, 
-2.2993643985548151, -1.1007924558002911]], [[-2.0947603088955526, 1.0959905984546703, 3.7023710621469164, 
0.094908210009293725], [1.0949912517065847, -3.4888393816020113, 4.3708685603171986, -0.6958836713668104], [3.9631547390749269, 
-4.405952868968054, -4.8518933471843013, -2.592787527572229]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[-0.55617928125915839, 3.6341719415522373, -3.9660249784661117, 
-0.3773636885162297], [-4.2598538818368867, 2.0141095278486629, -2.5387101079363794, -0.50986974532434459], 
[4.8795827884367782, -3.6196158865395809, 3.16827233568727, 0.71657225927344381]], [[3.5705403976795669, -3.6300951370512227, 
4.465797475548289, 3.2055038360580426], [1.3739798487942316, -0.90833756169357827, -2.6318712128812258, 3.2928168795433272], 
[-3.1155876455767908, 0.87775634574256856, 1.7422753002128797, -0.83032023027208002]]], [[[3.667776668595689, 
-2.9348111698821047, -2.7456991525064844, 4.8877693853508539], [-3.7193783851362694, -4.6740975853125724, 3.6612328440916873, 
2.5697557317694821], [-4.59508177738845, -3.7685784983395196, 0.84368434661179403, 1.9712011217858114]], [[0.66059582127070637, 
0.78800527926592512, -2.1784557885201181, -1.0870627490649176], [2.8928042985451636, -1.6105244770736258, -3.1373740363552862, 
-2.5216836550990585], [1.8492649945263437, -0.98186641758255888, 0.17357876783797188, -1.6418437630807525]]], 
[[[-0.65255812562799242, -1.544055661127286, -2.4994843524131962, 4.7095918452734011], [2.3066678240266212, 
-0.25587438388778505, 3.0831759251770734, -1.6547253343439614], [-1.0184318647780932, 3.138518774194818, -4.9480883087962333, 
-1.9481928897014864]], [[0.22954333269005645, -4.3816942829319148, 4.3944482827096838, 1.8858585001446393], 
[2.6224730676058599, 4.1438933041445267, -4.3417533647630391, 1.4965171534264643], [-2.6372525997536922, -3.6875723195735888, 
-4.1601585046111866, 3.1925433393113067]]]]))
      arg1=Data(numpy.array([[[[1.2809594758663643, 0.36614546319594332, -3.3224012964497183, 0.72705936270792382], 
[2.4444430778794244, -1.2467644958618331, 4.579892836164543, -1.7261523956764036], [2.9117263196468999, -4.0937271509845576, 
1.7996859423754028, 2.9318562930234107]], [[1.8786135239342974, -1.2501299758663951, 1.5035629028893549, 3.53770446276949], 
[-3.202487508574221, 1.8306249520483693, 2.6637070204200146, -1.2988361053293049], [0.65907450053626704, -0.20922397902545953, 
-1.8287720721488854, 3.7031561868616425]]], [[[4.7500178129583812, -2.6596034449867947, -4.8134760563507033, 
-1.469990044658406], [-0.30454262794900089, 3.5265523216188406, -1.4481810260031311, -4.2910701255593633], [4.311581858027731, 
4.5210643298923703, -2.2453019232164406, 2.2314060470622801]], [[4.2130381927502683, -2.0841916758075718, -0.59051235548306558, 
2.9549158274042542], [-3.3761651991270112, -2.6047260951283748, -0.0077171700114018194, 4.1868823032214788], 
[-4.8401105936327937, -2.0848111300818752, -4.4230239641470916, -4.9456703812446046]]], [[[-0.85418377881926766, 
-2.6549252791150337, 2.1612991148970266, 1.1691767385493224], [-0.9692318519106351, 3.1340410313936289, 1.8120605408563373, 
-3.269731779918895], [3.4176404366110216, 0.98238015439809612, 4.2488533318224562, 1.4290964548898089]], [[3.2892305811583959, 
3.8221030099805091, 3.9688737706562875, -2.1833121915287714], [-4.8072092694391948, -2.3750269615015474, 1.6843187149024308, 
4.2436192770219368], [0.63505035941578214, 2.5421490072782005, -3.1392939759702418, 0.80894111899082777]]]]),self.functionspace)
      res=arg0-arg1
      ref=Data(numpy.array([[[[-5.0180178908065702, 2.0598589919771397, 0.62051843147537289, 0.74490590632580034], 
[-6.2337236053299057, 2.4865682066678305, -2.9874172050514129, 1.7618740041712933], [-3.0407449509007467, 0.9953733377986973, 
-2.5520566383402166, -5.6630835028414674]], [[-1.1266859053063829, -3.1928552657677249, -3.5464344796029659, 
-3.2531444097718012], [4.565993337906578, -2.4257977646905893, -4.132393765255479, 3.6997502425651598], [-0.81160844467726356, 
-4.440701589288178, 5.4939723309451036, -5.9869091437791875]]], [[[-6.2974416131861233, -0.057884913271301741, 
4.579952814224141, 3.2798101258587531], [-1.7355226392948326, -3.5095092213936603, -3.0587694116455895, 8.5210208200245106], 
[-5.0565320304641848, -7.2967639140200191, 5.2295094940412516, -3.972552753157911]], [[-8.6738775224045384, 1.083554161607069, 
-2.2478266118766035, -7.9028189511410982], [0.85569406855493169, -1.2251668136440816, -4.2896897600228669, 
-7.8450631886044935], [4.6887010173498886, -0.29180294890023806, 7.1649112036012896, 4.2596298253473455]]], 
[[[2.0786553461451049, -1.4490933407642981, -2.2599344637128995, -2.3869609412408312], [3.6717246656238052, 
-5.8816051742141084, -0.72703534730851782, 5.2206940891281191], [-2.4090850869337999, -0.91704516187841545, 
-6.5482177303772708, -2.5298889106900999]], [[-5.3839908900539486, -2.7261124115258388, -0.26650270850937119, 
2.2782204015380652], [5.9022005211457795, -1.113812420100464, 2.6865498454147678, -4.9395029483887471], [3.3281043796591447, 
-6.9481018762462545, -1.7125993712140595, -3.4017286465630567]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-1.8371387571255227, 3.268026478356294, -0.64362368201639342, -1.1044230512241535], 
[-6.7042969597163111, 3.2608740237104961, -7.1186029441009229, 1.216282650352059], [1.9678564687898783, 0.47411126444497675, 
1.3685863933118672, -2.2152840337499669]], [[1.6919268737452695, -2.3799651611848276, 2.9622345726589341, 
-0.33220062671144746], [4.5764673573684522, -2.7389625137419475, -5.2955782333012404, 4.5916529848726322], 
[-3.7746621461130578, 1.0869803247680281, 3.5710473723617651, -4.5334764171337225]]], [[[-1.0822411443626923, 
-0.27520772489530998, 2.0677769038442189, 6.3577594300092599], [-3.4148357571872685, -8.2006499069314138, 5.1094138700948184, 
6.8608258573288454], [-8.9066636354161801, -8.2896428282318908, 3.0889862698282347, -0.26020492527646866]], 
[[-3.5524423714795619, 2.8721969550734969, -1.5879434330370525, -4.0419785764691714], [6.2689694976721748, 0.99420161805474905, 
-3.1296568663438844, -6.7085659583205377], [6.6893755881591375, 1.1029447124993164, 4.5966027319850635, 3.303826618163852]]], 
[[[0.20162565319127523, 1.1108696179877477, -4.6607834673102229, 3.5404151067240788], [3.2758996759372563, -3.3899154152814139, 
1.2711153843207361, 1.6150064455749336], [-4.4360723013891148, 2.1561386197967218, -9.1969416406186895, -3.3772893445912953]], 
[[-3.0596872484683395, -8.203797292912423, 0.42557451205339625, 4.0691706916734107], [7.4296823370450547, 6.5189202656460736, 
-6.0260720796654699, -2.7471021235954725], [-3.2723029591694743, -6.2297213268517897, -1.0208645286409448, 
2.383602220320479]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank4_taggedData_rank0(self):
      arg0=Data(numpy.array([[[[0.01135194183319399, -4.9785479029831876, -1.4712660503069506, 1.5141512196801941], 
[1.1548155563469296, -2.9854719632114692, 3.9339293237191413, -2.6910209597958525], [1.1124045008328407, -1.7425919517513631, 
-1.5841323767605822, -1.5249655191666567]], [[0.77789261118966735, -2.5794005097811121, 1.6533993149526314, 
-4.5285076188195239], [3.4427295849745789, -2.2189592748730669, -4.1716124743315239, -3.983795187522372], [-2.1622303023564338, 
-4.3635249398599782, -1.0844844142101007, 4.3691526490925945]]], [[[2.3388827084196793, 2.5869520161923054, 
-0.50568135076855558, 0.80047939327703244], [-1.1172930257102074, 1.7141980769644425, 3.8657014083391665, -1.4478920022721686], 
[4.341151814495694, -2.9214381483694583, -0.34791364686587034, 3.6629900307887802]], [[-2.4895920792024229, 
-1.0808639277714582, 2.95145361346062, -2.505082874653366], [2.9044431445861267, -3.6255605266754198, 0.9224393134617177, 
-2.1678234773889695], [1.7819159707331798, 0.86206296994317455, -3.9977372106574647, 4.5328880039046755]]], 
[[[0.34636517973926662, 3.4802106078211352, 1.1815723364090402, 4.4368602109169153], [4.0388522903102952, 2.5758973288189768, 
-0.81101509716135212, -1.3321756418216033], [-4.6687184448740044, 2.5234679018789574, -1.3297050929907348, 
-3.2962557535249468]], [[2.5068261209985154, -2.6660012095199157, 1.2152038679113621, 4.7437042663843787], 
[-2.4603170267105012, -1.1121957909867297, 0.86728247168370221, -0.38944561297860503], [3.3124604121643344, 
-1.3032146331540773, -0.39035423972031147, -3.2922463078391697]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[2.3779133693429007, 0.3485276879640935, 1.9423218730664029, 2.9192477810750539], 
[-2.2714486185518092, -4.9448665292565197, 4.1796543518259544, 4.62284389739958], [4.5252803539922191, -0.83588087489538143, 
-2.0763388057277075, -0.70948762277037591]], [[-2.7412666796161336, -0.85768107488231671, 2.7565685604583461, 
2.9531817032097987], [0.99650013580760266, 3.397253365489405, 4.0403421758732545, -0.94362709356438224], [-2.7465116165898786, 
-2.7352286635244036, -4.429698974620818, -3.8962458486699014]]], [[[0.53820770690966935, -4.1953223973140918, 
-3.7816386954405123, -0.58627302004707449], [1.1420110819742746, -2.0984986344668508, -4.4825410756979043, 
-3.4722131828643343], [2.9068720329289688, -0.50706387804422981, 3.6120151453156488, 4.9067642374187699]], 
[[1.1226672417387515, 0.17201241295864644, -3.7572824630148904, 3.1963739180604325], [-1.4324703386402216, 4.962825985088287, 
-2.6731042500048821, 2.0888117327222631], [-2.4327983399488664, -0.95082321412309767, -2.0260561079718387, 
-0.96442323262818075]]], [[[2.7987768842205449, -0.81984841006370246, 2.0546178350382052, 4.9317041606093177], 
[-0.95982463897540615, -0.3443753161051486, 1.0923910624658371, -0.33270493773144239], [-2.873837525673324, 3.1247305778060284, 
3.6902465856943341, -3.1396340195450509]], [[0.79524145523957479, -2.3244739969765584, -1.9966895568489997, 
-2.0456977637294358], [0.16856798846409404, -1.6051156720539526, 0.56901426924804799, 2.906872073160347], [2.3684975909375519, 
0.41273978735919847, -1.370722073297185, -1.7386926551880122]]]]))
      arg1=Data(3.54198671837,self.functionspace)
      arg1.setTaggedValue(1,2.49724646832)
      res=arg0-arg1
      ref=Data(numpy.array([[[[-3.5306347765393902, -8.5205346213557718, -5.0132527686795347, -2.0278354986923901], 
[-2.3871711620256546, -6.5274586815840534, 0.39194260534655712, -6.2330076781684367], [-2.4295822175397435, 
-5.2845786701239472, -5.1261190951331663, -5.0669522375392404]], [[-2.7640941071829168, -6.1213872281536963, 
-1.8885874034199528, -8.070494337192109], [-0.099257133398005237, -5.7609459932456506, -7.7135991927041081, 
-7.5257819058949558], [-5.7042170207290184, -7.9055116582325624, -4.6264711325826848, 0.82716593072001032]]], 
[[[-1.2031040099529049, -0.95503470218027875, -4.0476680691411397, -2.7415073250955517], [-4.6592797440827916, 
-1.8277886414081417, 0.32371468996658237, -4.9898787206447528], [0.79916509612310982, -6.4634248667420424, -3.8899003652384545, 
0.121003312416196]], [[-6.0315787975750066, -4.6228506461440428, -0.5905331049119642, -6.0470695930259506], 
[-0.63754357378645743, -7.167547245048004, -2.6195474049108665, -5.7098101957615537], [-1.7600707476394044, 
-2.6799237484294096, -7.5397239290300488, 0.99090128553209134]]], [[[-3.1956215386333175, -0.061776110551448937, 
-2.3604143819635439, 0.89487349254433113], [0.49686557193771108, -0.96608938955360735, -4.3530018155339363, 
-4.8741623601941875], [-8.2107051632465886, -1.0185188164936267, -4.871691811363319, -6.838242471897531]], 
[[-1.0351605973740687, -6.2079879278924999, -2.326782850461222, 1.2017175480117945], [-6.0023037450830854, -4.6541825093593143, 
-2.674704246688882, -3.9314323313511892], [-0.22952630620824976, -4.8452013515266614, -3.9323409580928956, 
-6.8342330262117539]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-0.11933309897905531, -2.1487187803578625, -0.55492459525555304, 
0.42200131275309793], [-4.7686950868737652, -7.4421129975784757, 1.6824078835039984, 2.1255974290776241], [2.0280338856702631, 
-3.3331273432173374, -4.5735852740496634, -3.2067340910923319]], [[-5.2385131479380895, -3.3549275432042727, 
0.25932209213639013, 0.45593523488784271], [-1.5007463325143533, 0.90000689716744908, 1.5430957075512985, -3.4408735618863382], 
[-5.2437580849118346, -5.2324751318463596, -6.9269454429427739, -6.3934923169918569]]], [[[-1.9590387614122866, 
-6.6925688656360478, -6.2788851637624683, -3.0835194883690304], [-1.3552353863476814, -4.5957451027888068, -6.9797875440198602, 
-5.9694596511862903], [0.40962556460701283, -3.0043103463661858, 1.1147686769936929, 2.4095177690968139]], 
[[-1.3745792265832044, -2.3252340553633095, -6.2545289313368464, 0.69912744973847651], [-3.9297168069621775, 2.465579516766331, 
-5.170350718326838, -0.4084347355996929], [-4.9300448082708224, -3.4480696824450536, -4.5233025762937942, 
-3.4616697009501367]]], [[[0.30153041589858898, -3.3170948783856584, -0.44262863328375079, 2.4344576922873618], 
[-3.4570711072973621, -2.8416217844271046, -1.4048554058561189, -2.8299514060533983], [-5.3710839939952795, 
0.62748410948407241, 1.1930001173723781, -5.6368804878670069]], [[-1.7020050130823812, -4.8217204652985144, 
-4.4939360251709557, -4.5429442320513918], [-2.3286784798578619, -4.1023621403759085, -1.928232199073908, 0.40962560483839106], 
[-0.1287488773844041, -2.0845066809627575, -3.8679685416191409, -4.2359391235099686]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank4_taggedData_rank4(self):
      arg0=Data(numpy.array([[[[-4.5659432914191447, -3.0756237255376506, -4.2334075265772695, 2.5929330369108445], 
[2.7267406356848536, -2.7318840479606488, 0.84605645832083809, 1.9255260912499033], [-3.637166180085869, -3.3209740346558494, 
0.53003436106076229, -3.6357692060789306]], [[3.1939641722011007, -1.9017315481536992, 2.3881451628326236, 4.9612534359086631], 
[1.4304893730991672, 0.19150631957665887, -0.88645184048219772, -3.3224836614727984], [3.8887846756642332, -4.2942206890083288, 
-4.7718061081431156, -4.1407487287744305]]], [[[4.1592166114652454, 4.6621742881692203, 3.5713538942515068, 
-4.8528910738723781], [0.3700304466092863, -3.0214354664831058, 4.0724937995954953, -1.2327380701595478], [2.8849672382022433, 
3.8386120117226668, -0.80967249727746715, 3.649285175406261]], [[-3.4723467040314859, 2.035994214495263, -2.3704706933816189, 
-0.2338883236889906], [2.2888572470359261, -0.44616855344587059, -4.2330846991367608, -0.72329985466043922], 
[-2.9203165864940406, -4.8292478194148405, 3.8945293435569273, -1.9962381133663074]]], [[[-3.3013418776435843, 
1.5319159315194932, 3.4124953218157295, -3.056341107999395], [-4.628128467574852, 1.9951034936794434, 1.8744210697066084, 
4.5036284557407811], [2.6625838831022239, 2.8799533014409793, 4.3877800188309202, -2.4212214733944384]], [[4.2804485881905769, 
2.1338881683829305, -3.6936048767445504, 0.025421155798426298], [-4.1072602280904347, -2.4786354989794948, -3.4210996044458684, 
3.6955951721324851], [-1.6567808551398109, -4.2531286426166215, -4.5477164001862613, 2.6298758994954872]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[4.0971383199392442, 0.67289894639753012, -0.41337479932236931, 
-1.6040355030623097], [2.7663670452552083, 4.7778112770129351, -0.23538110356264763, 3.274569091560851], [1.8591857079493801, 
-2.5564506206009643, -3.4527283012567258, -0.1244083143057626]], [[-3.0422736977964893, 0.84055401562984322, 
1.6312867016500308, -4.1434821434734452], [-3.0791805270142838, 1.6090297271238772, 0.46200885600550023, 4.6027749935955597], 
[-1.4604110489056064, 4.1087032184213932, -4.7748069167830032, -3.9375478580469272]]], [[[3.7245924273770097, 
0.14457305823715938, -4.7766409700178638, -4.0118734170551731], [-1.9242977623721034, 0.75782322535984292, -3.4592194001776013, 
-0.73597711044123315], [3.7202720723660292, 1.0162216128808339, 1.8875348400652046, -3.2698914819298839]], [[4.042008021662987, 
1.3874714829976451, -4.3612366170734447, 4.237533799370393], [3.3987727334289044, -1.9020527953358082, 0.41208097802024923, 
2.2972312833983093], [1.2788027080279853, 1.934727085602451, 3.5688517003664018, -4.7134377884352716]]], 
[[[-3.7142775922442506, -4.2409932880667087, 3.1242184458440434, 1.5924931509226372], [-3.7879757101683174, 
-1.6296203312148085, -2.4322338983234548, -1.7242960935939378], [2.588946161392867, 3.9712542813479867, -3.5445007044105701, 
1.484796169340469]], [[-2.8643211208501249, -4.672945125699405, 1.3864731718489676, 4.120153829637248], [0.86161543700965648, 
-0.10187999113779611, -2.1959309136488727, -2.796583897967817], [1.7309521408967026, 1.8211448932897722, 2.0040088387425961, 
3.3153330545042543]]]]))
      arg1=Data(numpy.array([[[[1.3081118028027792, 1.2664772306758145, -4.194416094320772, 4.0987285830313915], 
[-0.30636930226957215, 1.9469908736138315, 3.8109567386131697, -3.7368912458676973], [-4.665802751403425, 1.2739584253772209, 
1.7888545951932038, 4.0138277003896015]], [[1.4600004388366727, 3.5856749297338677, -0.019878597295229561, -2.839254454697433], 
[-4.3377748509589082, 0.016121428575479158, 4.289311151775637, 0.59518141555984894], [-3.828190301292469, -3.5985834623958768, 
4.4240065384841927, -2.5780726026240499]]], [[[2.5914245649742806, 4.9560615770761771, 4.9173483411224606, 
-2.1064952349014696], [-0.29142087573003828, 1.7482786762917604, -3.4649801324904339, 0.77634912443965121], 
[0.89070417493265186, 3.7962118430719283, 1.7166564302525513, 1.6532196510943535]], [[3.7861751385490532, 3.9389916024747933, 
-4.935100033304531, -3.8077581683199044], [-0.15022442350296838, 3.5541996739371822, -1.2081588823183651, 1.804784831714902], 
[3.1621380116007636, -1.7913546331365984, 3.6637940814629282, 4.3275335560484578]]], [[[3.6296143264485501, 2.4827188586391289, 
1.8648597021883031, -2.2644641182101832], [0.046459685559315567, 4.2050584414034269, 2.1482593464398079, 1.9035239549579064], 
[1.9855182586418909, 2.6811017488044939, 2.5154156557381055, -0.83798145100794397]], [[-4.6534277693055, -0.81957376827895967, 
-2.3032997740639893, 0.78956560389316088], [4.2054976581662586, -1.4562701383338315, -3.1428198511893268, -2.6155674722341349], 
[1.3828402563877553, -1.6930963454216719, 2.1702276021520142, 0.9051958851200661]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[-4.9491525040523285, -3.7781776323338701, -1.8054560490171734, 
0.52157647560613452], [-0.4053506909414164, 4.8528549961669487, -2.9167883066678666, -1.3668568373780623], 
[-0.82669591660092134, -3.7124036992776088, 1.1864729870554402, -3.9117046189627711]], [[1.2914077837600288, 
1.0929441209921595, -1.9022033003642234, -3.9950486036244204], [1.4569406893034822, 3.951949944059832, -2.073463794396464, 
1.3072055097113058], [2.1324898605347826, -3.3953907364792171, -1.8465958923480672, 1.527932064124256]]], 
[[[-4.9025247462748878, -0.42756451144568963, -4.8220513411163957, -4.8457973433721522], [-2.7472266906784713, 
3.718378785325628, -1.7595199047703911, 4.038130077572605], [-0.0074025325464512903, -0.64341331331365215, 0.45164031140387628, 
4.814170996429926]], [[0.8908633306435032, 1.7604592874258991, -0.87906671411341364, 2.2097729431628688], [2.2732249770241157, 
1.8681124902331279, 3.0008484624394498, 3.343604306388702], [-3.3754340312749553, -2.2066386918686676, -1.7711563233619243, 
-0.30788054744443194]]], [[[-2.9537832940669539, 1.6180726591672556, 1.3658713285938155, -1.41045026087945], 
[1.0256223433601264, -0.15491291414390762, -0.3721366150682579, -2.7594523223915357], [-1.0484730269905396, 
-0.36235911137710808, -0.94774016668602457, -4.2763949284526035]], [[4.5943665006963617, 1.6683206706103206, 
-0.91259256178866188, -1.497238978684269], [1.915765680686814, -2.9600050317326332, 2.3237598933172503, -1.4366593755343136], 
[-2.7804211969822292, -2.6315582061257881, 2.8146906707148922, -1.2730702426189477]]]]))
      res=arg0-arg1
      ref=Data(numpy.array([[[[-5.8740550942219238, -4.3421009562134651, -0.038991432256497482, -1.505795546120547], 
[3.0331099379544257, -4.6788749215744803, -2.9649002802923317, 5.662417337117601], [1.028636571317556, -4.5949324600330703, 
-1.2588202341324415, -7.6495969064685321]], [[1.733963733364428, -5.4874064778875669, 2.4080237601278531, 7.8005078906060961], 
[5.7682642240580755, 0.17538489100117971, -5.1757629922578348, -3.9176650770326473], [7.7169749769567026, -0.69563722661245198, 
-9.1958126466273082, -1.5626761261503805]]], [[[1.5677920464909647, -0.29388728890695681, -1.3459944468709537, 
-2.7463958389709084], [0.66145132233932458, -4.7697141427748662, 7.5374739320859288, -2.009087194599199], [1.9942630632695915, 
0.042400168650738479, -2.5263289275300185, 1.9960655243119074]], [[-7.2585218425805387, -1.9029973879795303, 
2.5646293399229121, 3.5738698446309138], [2.4390816705388945, -4.0003682273830528, -3.0249258168183957, -2.5280846863753412], 
[-6.0824545980948042, -3.0378931862782421, 0.23073526209399908, -6.3237716694147652]]], [[[-6.9309562040921344, 
-0.95080292711963565, 1.5476356196274264, -0.79187698978921173], [-4.6745881531341675, -2.2099549477239835, 
-0.27383827673319949, 2.6001045007828747], [0.67706562446033303, 0.19885155263648535, 1.8723643630928146, 
-1.5832400223864944]], [[8.9338763574960769, 2.9534619366618902, -1.3903051026805611, -0.76414444809473459], 
[-8.3127578862566942, -1.0223653606456633, -0.27827975325654153, 6.31116264436662], [-3.0396211115275662, -2.5600322971949496, 
-6.7179440023382755, 1.7246800143754211]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[9.0462908239915727, 4.4510765787314002, 1.3920812496948041, -2.1256119786684442], 
[3.1717177361966247, -0.075043719154013644, 2.681407203105219, 4.6414259289389133], [2.6858816245503014, 1.1559530786766445, 
-4.639201288312166, 3.7872963046570085]], [[-4.3336814815565177, -0.25239010536231632, 3.5334900020142541, 
-0.14843353984902485], [-4.536121216317766, -2.3429202169359549, 2.5354726504019642, 3.295569483884254], [-3.592900909440389, 
7.5040939549006103, -2.928211024434936, -5.4654799221711832]]], [[[8.6271171736518966, 0.57213756968284901, 
0.045410371098531854, 0.83392392631697909], [0.82292892830636788, -2.9605555599657851, -1.6996994954072102, 
-4.7741071880138382], [3.7276746049124805, 1.659634926194486, 1.4358945286613283, -8.0840624783598098]], [[3.1511446910194838, 
-0.37298780442825397, -3.482169902960031, 2.0277608562075242], [1.1255477564047887, -3.770165285568936, -2.5887674844192006, 
-1.0463730229903927], [4.6542367393029407, 4.141365777471119, 5.3400080237283261, -4.4055572409908397]]], 
[[[-0.76049429817729663, -5.8590659472339643, 1.7583471172502279, 3.0029434118020872], [-4.8135980535284437, 
-1.4747074170709009, -2.0600972832551969, 1.0351562287975979], [3.6374191883834066, 4.3336133927250948, -2.5967605377245455, 
5.7611910977930725]], [[-7.4586876215464866, -6.3412657963097256, 2.2990657336376294, 5.617392808321517], [-1.0541502436771575, 
2.8581250405948371, -4.519690806966123, -1.3599245224335035], [4.5113733378789318, 4.4527030994155599, -0.81068183197229615, 
4.5884032971232021]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank4_expandedData_rank0(self):
      arg0=Data(numpy.array([[[[1.2274233779150299, -2.3741739489326728, -4.813381946114804, 2.8974974454967537], 
[3.51748039533007, -3.9213842313389269, 0.25222153675751358, 2.7717433179896283], [-4.3365195359378621, -1.3646126172915141, 
-2.3630022887893021, 2.1312171365858701]], [[-1.0861582798732461, -0.35773602286518447, -2.789404016688092, 
2.9353748207420018], [2.8156118372167862, 0.51870718032887098, 4.1472392186711637, 2.0323190555084656], [1.5895554647232046, 
3.4572440442200634, -2.2507733653596795, 0.50180674172946382]]], [[[2.6297214829824949, 1.3208407276119951, 
-3.7021295591479761, -4.6164041742291779], [-2.1678167275552598, -0.35548440664220227, 2.2077448658165064, 
-1.3920979937745082], [-1.2391562608305295, -0.65995644630944295, -4.6494643841811003, 2.2991246454105196]], 
[[4.4506882416523119, -4.5207451419382565, -3.7617883534215721, 0.92207146680956598], [0.10623197241413429, 4.3760542740964095, 
0.50534926606255404, -4.6967820479675986], [-2.7353783940182472, -0.43844976891582643, -4.6232821757150653, 
2.6159182055902761]]], [[[-2.0581208858704301, -2.7678959825017846, 3.6046917227350921, 1.8970844668817985], 
[-2.6175236451557424, -4.0157304476315954, -2.1000968961256783, 1.8564484539679125], [3.7089426931259677, -3.103672243647738, 
-2.7929694366809157, 0.88678668918070436]], [[4.184107722443736, -1.5609016281259445, 1.0524083000942719, -4.2038755776336831], 
[-4.3388371886558748, -3.0503486763132095, 4.4613361037985371, 1.4988613936037769], [2.2027270031620692, -3.6865138755815909, 
1.1524278055831658, -2.9653509548487413]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[-1.5370269651238813, -1.8438899804272104, -4.0702713745194021, 1.9795950777123199], 
[1.1236516724903858, 0.54587548801110763, 3.2804836622685425, 3.8065592265918387], [-4.4760634105655042, -4.2869450970665079, 
-4.2111306642059638, 1.7445772071465457]], [[4.6270874364839827, -4.1463564939434283, 4.8550786057780346, -1.9533024224259199], 
[0.81165205147049413, 3.9392440966443587, -1.4858710308948209, -0.83280630416634338], [2.0647887685913258, -0.8616506118323386, 
0.44681156898010332, 4.9978053540084826]]], [[[3.714281341999774, 0.90780461097629228, 0.14305381423850427, 
-2.6977823619390606], [-2.3965262381787578, 1.0378821709113808, -2.1644851471048785, 3.4942452146397773], [2.2982320761009252, 
3.6948686876642949, 1.5984661794651629, 1.0976723739103322]], [[1.145723216237875, 0.87257263824348197, 0.67759195786388648, 
-0.17393140172009236], [0.69438810115922323, 3.9987073685299777, 2.835197068606913, 1.5302938513407938], [-2.4750370102850141, 
1.3029068415209935, -3.2140631936764752, -1.4282643575500495]]], [[[-0.18916099135129016, -2.7829496644601504, 
1.2047383145572175, -0.3541555585650924], [-0.89108637082273923, -0.58723824434794558, -0.76299006506560207, 
-1.1012915192729356], [-3.7498611848373917, 4.7248398707937618, 2.3599213927080855, 0.8027903217886232]], 
[[0.51887913001739694, 1.2586599853978564, -2.4629850811433815, 3.747337452522018], [0.40216702269540416, -0.67856529616969841, 
-0.10334440239049947, 4.3605278839529031], [-2.5982702975908465, -1.7846169679935509, -0.72457519015928007, 
4.2997963568353352]]]]))
      arg1=Data(-3.60908005899,self.functionspace)
      arg1.setTaggedValue(1,-2.36551635685)
      arg1.expand()
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[4.8365034369003821, 1.2349061100526795, -1.2043018871294517, 6.5065775044821059], 
[7.1265604543154222, -0.31230417235357466, 3.8613015957428658, 6.3808233769749805], [-0.72743947695250988, 2.2444674416938382, 
1.2460777701960501, 5.7402971955712223]], [[2.5229217791121061, 3.2513440361201678, 0.81967604229726021, 6.5444548797273541], 
[6.4246918962021384, 4.1277872393142232, 7.756319277656516, 5.6413991144938178], [5.1986355237085569, 7.0663241032054156, 
1.3583066936256727, 4.110886800714816]]], [[[6.2388015419678471, 4.9299207865973473, -0.093049500162623922, 
-1.0073241152438257], [1.4412633314300924, 3.25359565234315, 5.8168249248018586, 2.2169820652108441], [2.3699237981548227, 
2.9491236126759093, -1.0403843251957481, 5.9082047043958719]], [[8.0597683006376641, -0.91166508295290427, 
-0.15270829443621992, 4.5311515257949182], [3.7153120313994865, 7.9851343330817617, 4.1144293250479063, -1.0877019889822463], 
[0.873701664967105, 3.1706302900695258, -1.0142021167297131, 6.2249982645756283]]], [[[1.5509591731149222, 0.84118407648356763, 
7.2137717817204443, 5.5061645258671508], [0.9915564138296098, -0.40665038864624314, 1.5089831628596739, 5.4655285129532647], 
[7.3180227521113199, 0.50540781533761425, 0.81611062230443654, 4.4958667481660566]], [[7.7931877814290882, 2.0481784308594078, 
4.6614883590796241, -0.59479551864833091], [-0.72975712967052253, 0.55873138267214273, 8.0704161627838893, 5.1079414525891291], 
[5.8118070621474214, -0.077433816596238714, 4.761507864568518, 
0.64372910413661089]]]])+(1.-msk_ref)*numpy.array([[[[0.82848939172620373, 0.52162637642287457, -1.7047550176693171, 
4.3451114345624049], [3.4891680293404708, 2.9113918448611926, 5.6460000191186275, 6.1720755834419236], [-2.1105470537154192, 
-1.921428740216423, -1.8456143073558788, 4.1100935639966307]], [[6.9926037933340677, -1.7808401370933433, 7.2205949626281196, 
0.4122139344241651], [3.1771684083205791, 6.3047604534944437, 0.87964532595526412, 1.5327100526837416], [4.4303051254414108, 
1.5038657450177464, 2.8123279258301883, 7.3633217108585676]]], [[[6.079797698849859, 3.2733209678263773, 2.5085701710885893, 
-0.33226600508897564], [-0.031009881328672773, 3.4033985277614658, 0.2010312097452065, 5.8597615714898623], 
[4.6637484329510102, 6.0603850445143799, 3.9639825363152479, 3.4631887307604172]], [[3.51123957308796, 3.238088995093567, 
3.0431083147139715, 2.1915849551299926], [3.0599044580093082, 6.3642237253800626, 5.200713425456998, 3.8958102081908788], 
[-0.10952065343492912, 3.6684231983710784, -0.84854683682639021, 0.93725199930003544]]], [[[2.1763553654987948, 
-0.41743330761006536, 3.5702546714073025, 2.0113607982849926], [1.4744299860273458, 1.7782781125021394, 1.6025262917844829, 
1.2642248375771494], [-1.3843448279873067, 7.0903562276438468, 4.7254377495581705, 3.1683066786387082]], [[2.8843954868674819, 
3.6241763422479414, -0.09746872429329656, 6.112853809372103], [2.7676833795454892, 1.6869510606803866, 2.2621719544595855, 
6.7260442408029881], [-0.2327539407407615, 0.58089938885653414, 1.6409411666908049, 6.6653127136854202]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_taggedData_rank4_expandedData_rank4(self):
      arg0=Data(numpy.array([[[[-1.3314523083437448, 2.1979867343200175, 2.534332494165926, -4.8043153407797456], 
[-0.62335911950374445, -1.3198118141293689, -0.78049387074066878, 1.1923493139476724], [0.63653441929640842, 
-2.9801344554303766, -4.3777052247207395, -3.1201701010090535]], [[1.4687086738617232, -2.7934803759500126, 1.5065730646025921, 
2.9662345431772366], [4.5161790191893836, -2.2651441650707116, 2.9057415293191511, 2.412261694361586], [2.752920882305661, 
-3.5265826398391509, -1.4115070946506703, -3.5639193169236227]]], [[[-1.8856251658962053, -3.5325330512403372, 
0.77585534312531657, 2.8375770494409522], [-2.5918453841169686, -0.80669232997283036, 1.8127700858366724, 4.6947893194514432], 
[3.50080486493267, 2.0128616343932224, 1.5451532244415738, -2.7905038760766789]], [[3.7837519897808463, 4.9835196096957173, 
0.72684422408201321, 0.87293198511608683], [0.68501345412279235, -3.1500002233774884, 2.0982992009652337, 0.53859938582049605], 
[3.0020675665519576, -1.3595402186721395, 3.753824399561104, -0.088248133651715577]]], [[[-1.1876585624097737, 
-4.7864632104652429, -3.1775012147286552, 3.9377295541314652], [2.1526736252031045, -2.6132964893173751, 1.2490891118775966, 
-4.9057055163069769], [-4.2334779695696687, 1.9227319727101566, 1.0421873406967075, 0.75509556207822826]], 
[[1.0699737598641139, 2.2910271707220033, 3.0566440507307924, -3.6538978202104735], [-4.1197261677293149, 4.5831261551468856, 
-3.8978439397957954, -4.7642702847154066], [2.0040056151958385, -4.8026435703241344, 0.36067982042442459, 
2.0379113078622781]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[-1.5992094412986511, -0.70601191590808376, -3.0395433121495907, 
2.7809777598202707], [1.1786736323055012, 0.48419783306097752, -4.8737885668481091, 0.37110842333237848], [3.3613561109552297, 
-3.2838308626999169, -4.8319723867805164, -4.6113278010412557]], [[4.4829414015279294, -3.115303967614178, -3.1805112075748099, 
2.8592090097297786], [-4.3216333142320256, 1.4824381226321046, 0.032205603421481044, 3.3309652000134999], [4.7897102900278945, 
4.8508970064648818, -3.457013661336573, -3.39235796234858]]], [[[3.2162248175993149, -3.3837536744350682, 0.46950521022967706, 
-1.5607230543946993], [3.3401021575996914, 3.3114861722144209, 3.350113537826175, -4.0481675946895468], [0.89708697648934077, 
-2.9790603311449351, 4.9453360163714351, 2.7684105401028178]], [[-2.6009920245386042, -0.68785625379644966, 4.1811533363849467, 
-1.8573939267420716], [-2.0332437399761227, -0.63248544447657284, 1.0160005810187478, -4.3524242119760013], 
[-3.9615434289422904, 1.1908728210182842, -2.4374047787860698, -2.8794421281641061]]], [[[1.6261174367320343, 
-2.7152054460173058, -0.43643853126431154, 1.274936150456849], [2.3392320018490356, 4.5854540370707042, 4.1902050687211272, 
3.2000514834926932], [3.2197945213969366, -0.94758298890660342, 0.88242044344833914, 1.3994277360423464]], 
[[-0.89121120333787385, 4.5943991474136983, -3.4019161138155249, 0.74480322135949262], [-2.7697747924148794, 
1.3644086516790761, 3.5378810633845674, -4.8123342702533467], [4.6756479803029158, -1.7668237659520281, 2.4592526655536044, 
-0.97165317243246108]]]]))
      arg1=Data(numpy.array([[[[-4.7682592546519746, 3.6910374256033744, -1.0501306262663954, 2.3682542154863366], 
[2.2782999396763088, 3.8861756542396151, 3.4076376223335867, -0.96362240534523202], [2.5187654051436397, 0.26271823591924814, 
1.7673043297547508, -0.024434348074749757]], [[-0.68297458002074674, 1.6288147837162956, 2.1228988839905742, 
3.0285230203051796], [-0.5750845977891581, -0.32357174542898992, -4.5846298204124958, -0.35210983997043055], 
[1.9779738885793563, 3.1398038334435654, -4.2458729744789538, -3.3399254228996709]]], [[[3.0198934495360206, 
-4.9890777442331959, -0.96532711110701719, 4.5158848636431692], [1.1479071866096202, 3.1327843655758816, -4.3626397792319036, 
-0.97531256190698201], [-0.91027701949158857, 0.7129992765413693, 3.2021154814861923, -2.8209150218625298]], 
[[4.069763576205796, -0.75746047143555195, 1.6255954142756686, -4.9374322460206468], [3.1986298808862035, 4.5283551199569612, 
-4.5668384651835838, 0.55301777910003214], [0.95433483160328603, 0.024705017091953607, -1.2188411694303802, 
-3.2698537591926513]]], [[[-2.9787662576241116, -0.050777180976908198, 0.48300550143113874, -4.2214624011320057], 
[-1.9233957509420585, 1.0221076235925999, 2.1260223520988646, -1.4910604833332872], [-3.8880768422556233, -0.62066231060154831, 
-3.2935962278343167, -2.3455744937018852]], [[-1.6511374845621796, 2.7192236569108825, -3.6576928982692913, 
2.6355596712551748], [1.438312521537993, -4.5889505671898352, -4.8773090142909687, -1.9332108158813566], [-3.8099632003414508, 
-3.4906622315093392, -3.4562407852145816, -4.437214867406718]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[3.4275496404270935, 1.1537395362139415, 4.359241778306636, -2.7956873451882904], 
[-0.57905750667620914, -1.4963390157180143, -1.0546590645254406, -0.60106896650343877], [2.4006800952787479, 
1.6046540297517788, 3.3601603786265883, 0.012849540806637805]], [[3.6308664591201794, 0.19028810794039952, 3.6826698054572677, 
-4.4845402026276036], [-0.58192639991331063, -2.9051693400605574, -1.7742099133525722, -2.1559572966583063], 
[-1.7677449333712669, 3.3892288138670708, -0.86589132863376772, -2.1674350506515494]]], [[[4.3616447130022689, 
-1.3671103803034725, -4.1188908609134414, -2.10985376747576], [-2.198249892038584, 1.0265269002665081, -2.542133483398433, 
4.4393130960272362], [2.7859993179084146, -0.38087906420919548, -1.6619343907139852, -4.5308017494556143]], 
[[-4.7515480793480345, 1.7382817373010093, 2.8977641251131914, -3.2913130914447217], [-0.41984372612900422, 1.6462696640680772, 
0.99681798638913222, -4.8573493031921302], [-2.7943028597843309, -1.7984177902458964, -2.6921702498473046, 
4.3733743180738038]]], [[[0.75333195636036621, -2.117631678772808, 1.9553735547204809, -2.9397756019429178], 
[4.0253539232471116, -0.67099660655985716, -4.0766290699129986, 2.4219228629964649], [-3.226477257261501, 2.4243676560286422, 
1.68788169038812, -1.6838948467025983]], [[-4.9953466953627501, -4.8906431446689433, -2.4669191502700025, 
-0.91707314335864609], [-3.1394725703363777, 2.4689920763259732, -2.9952182306520658, 0.071409338916285314], 
[4.976415123142381, -2.0939008155336247, -3.6245017728257798, 1.6225161002674326]]]]))
      arg1.expand()
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[3.4368069463082298, -1.493050691283357, 3.5844631204323214, -7.1725695562660823], 
[-2.9016590591800533, -5.205987468368984, -4.1881314930742555, 2.1559717192929044], [-1.8822309858472313, -3.2428526913496247, 
-6.1450095544754904, -3.0957357529343037]], [[2.1516832538824699, -4.4222951596663087, -0.61632581938798214, 
-0.062288477127943054], [5.0912636169785417, -1.9415724196417217, 7.4903713497316469, 2.7643715343320165], 
[0.77494699372630471, -6.6663864732827163, 2.8343658798282836, -0.22399389402395187]]], [[[-4.9055186154322259, 
1.4565446929928587, 1.7411824542323338, -1.678307814202217], [-3.7397525707265888, -3.9394766955487119, 6.175409865068576, 
5.6701018813584252], [4.4110818844242585, 1.2998623578518531, -1.6569622570446185, 0.030411145785850913]], 
[[-0.28601158642494973, 5.7409800811312692, -0.89875119019365535, 5.8103642311367336], [-2.5136164267634111, 
-7.6783553433344496, 6.6651376661488175, -0.01441839327953609], [2.0477327349486716, -1.3842452357640931, 4.9726655689914843, 
3.1816056255409357]]], [[[1.7911076952143379, -4.7356860294883347, -3.6605067161597939, 8.15919195526347], [4.0760693761451634, 
-3.635404112909975, -0.87693324022126795, -3.4146450329736897], [-0.34540112731404538, 2.5433942833117049, 4.3357835685310242, 
3.1006700557801135]], [[2.7211112444262935, -0.42819648618887918, 6.7143369490000833, -6.2894574914656483], 
[-5.5580386892673079, 9.1720767223367208, 0.97946507449517339, -2.83105946883405], [5.8139688155372893, -1.3119813388147952, 
3.8169206056390061, 6.4751261752689961]]]])+(1.-msk_ref)*numpy.array([[[[-5.0267590817257446, -1.8597514521220253, 
-7.3987850904562267, 5.5766651050085612], [1.7577311389817103, 1.9805368487789918, -3.8191295023226686, 0.97217738983581725], 
[0.96067601567648175, -4.8884848924516957, -8.1921327654071057, -4.6241773418478935]], [[0.85207494240775006, 
-3.3055920755545776, -6.8631810130320776, 7.3437492123573822], [-3.7397069143187149, 4.387607462692662, 1.8064155167740532, 
5.4869224966718058], [6.5574552233991614, 1.461668192597811, -2.5911223327028052, -1.2249229116970306]]], 
[[[-1.145419895402954, -2.0166432941315957, 4.5883960711431184, 0.54913071308106076], [5.5383520496382754, 2.2849592719479128, 
5.8922470212246081, -8.487480690716783], [-1.8889123414190738, -2.5981812669357396, 6.6072704070854202, 7.2992122895584322]], 
[[2.1505560548094302, -2.426137991097459, 1.2833892112717553, 1.4339191647026501], [-1.6134000138471185, -2.27875510854465, 
0.019182594629615579, 0.50492509121612894], [-1.1672405691579595, 2.9892906112641806, 0.25476547106123482, 
-7.2528164462379099]]], [[[0.87278548037166814, -0.59757376724449784, -2.3918120859847924, 4.2147117523997668], 
[-1.686121921398076, 5.2564506436305614, 8.2668341386341258, 0.77812862049622833], [6.4462717786584376, -3.3719506449352457, 
-0.80546124693978083, 3.0833225827449446]], [[4.1041354920248763, 9.4850422920826425, -0.93499696354552242, 
1.6618763647181387], [0.36969777792149827, -1.1045834246468971, 6.5330992940366333, -4.883743609169632], [-0.30076714283946515, 
0.32707704958159667, 6.0837544383793842, -2.5941692726998937]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_expandedData_rank0_taggedData_rank0(self):
      arg0=Data(3.17101385252,self.functionspace)
      arg0.setTaggedValue(1,-4.73422719756)
      arg0.expand()
      arg1=Data(1.49330239803,self.functionspace)
      arg1.setTaggedValue(1,-0.394831269588)
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*(1.67771145449)+(1.-msk_ref)*(-4.33939592797)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_expandedData_rank0_taggedData_rank1(self):
      arg0=Data(1.87992074504,self.functionspace)
      arg0.setTaggedValue(1,2.03352794703)
      arg0.expand()
      arg1=Data(numpy.array([4.9437145112959939, 2.3602255702550181]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([4.495042735040661, 2.3596043462768872]))
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-3.0637937662581818, -0.48030482521720597])+(1.-msk_ref)*numpy.array([-2.4615147880153874, 
-0.32607639925161358])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_expandedData_rank0_taggedData_rank2(self):
      arg0=Data(-3.34216831774,self.functionspace)
      arg0.setTaggedValue(1,-1.67202537118)
      arg0.expand()
      arg1=Data(numpy.array([[2.9607349389540447, 1.2346562919204924, 3.2248067687088806, 4.410431430682042, 
-1.4385503346776818], [2.8801282203104384, -3.3626154777806394, -1.9138065252059389, -0.77082418824998022, 1.8543421030467533], 
[-4.8003280788129343, -1.990793178189584, -4.334780022136421, 4.4298037487619695, 4.5074438698269077], [-4.8731182229950631, 
0.82250560532754236, 2.0839604460045393, 0.91449348838600741, 4.1979286714627353]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[1.8306776016002413, -3.4320614753317322, 0.70843103988525513, 0.16581736115784285, 
-3.4735853602523017], [-0.84345724935692257, 0.56922138789655108, 3.4748227446778461, 1.9066801555076696, -4.4494240875894597], 
[-2.703721845369349, 3.7477639849749451, 0.79474041105253246, 1.8253488488760024, -0.51691832141356642], [2.9111241352978068, 
-0.35741271997786583, 2.9591137166025643, -1.8084855943001701, -1.734196333658109]]))
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-6.3029032566893735, -4.5768246096558212, -6.5669750864442094, -7.7525997484173708, 
-1.903617983057647], [-6.2222965380457671, 0.020447160045310664, -1.4283617925293899, -2.5713441294853485, -5.196510420782082], 
[1.4581597610776056, -1.3513751395457447, 0.99261170440109225, -7.7719720664972982, -7.8496121875622364], [1.5309499052597344, 
-4.1646739230628711, -5.4261287637398681, -4.2566618061213362, 
-7.540096989198064]])+(1.-msk_ref)*numpy.array([[-3.5027029727779579, 1.7600361041540156, -2.3804564110629718, 
-1.8378427323355595, 1.801559989074585], [-0.82856812182079409, -2.2412467590742677, -5.1468481158555628, -3.5787055266853862, 
2.7773987164117431], [1.0316964741916324, -5.4197893561526618, -2.4667657822302491, -3.497374220053719, -1.1551070497641502], 
[-4.5831495064755234, -1.3146126511998508, -4.6311390877802809, 0.13646022312245343, 0.062170962480392333]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_expandedData_rank0_taggedData_rank3(self):
      arg0=Data(0.242225230034,self.functionspace)
      arg0.setTaggedValue(1,1.90348519574)
      arg0.expand()
      arg1=Data(numpy.array([[[-0.38859363912276379, -3.8655940437693506], [1.2372058043757503, -3.6981890814624419]], 
[[-1.7110370764060532, 4.7633455767824433], [4.220015693408353, -1.2227453197124949]], [[-2.4261547829344088, 
2.2943927957934021], [3.6357399642456567, -2.5486037966857777]], [[4.5562345353097378, -1.0313978065887697], 
[-1.0137739634170373, 0.40119430675345136]], [[2.3016542394417536, 3.0664555484251146], [-3.0512752382819919, 
-0.36799778867223942]], [[2.0723061564323286, -0.64109521299597283], [3.107404153629103, 
-3.9281332513057512]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[-1.2856101096388626, 1.3680707455500389], [-2.4186465039993754, 
2.4960568170568376]], [[0.82253804470592762, 0.53980908351343793], [3.6011972376632748, -4.1912506045579869]], 
[[0.47746443496173008, 2.7894584759997265], [4.9390109080200162, 0.70233564372741508]], [[-4.5214911128029591, 
3.312738538531967], [-4.5022471680501308, 0.58369234117255964]], [[-0.82168273117425006, 3.9294867883898981], 
[-1.2964113826365664, -4.4986385574468093]], [[-4.8892869138604302, 4.3034396899953968], [-3.0618673306030186, 
4.6842350868401219]]]))
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[0.63081886915650109, 4.1078192738030879], [-0.99498057434201304, 3.9404143114961792]], 
[[1.9532623064397905, -4.521120346748706], [-3.9777904633746157, 1.4649705497462322]], [[2.6683800129681461, 
-2.0521675657596647], [-3.3935147342119194, 2.790829026719515]], [[-4.3140093052760005, 1.273623036622507], 
[1.2559991934507746, -0.15896907671971405]], [[-2.0594290094080163, -2.8242303183913773], [3.2935004683157292, 
0.61022301870597673]], [[-1.8300809263985913, 0.88332044302971013], [-2.8651789235953657, 
4.1703584813394885]]])+(1.-msk_ref)*numpy.array([[[3.1890953053791744, 0.53541445019027289], [4.3221316997396872, 
-0.59257162131652574]], [[1.0809471510343842, 1.3636761122268739], [-1.697712041922963, 6.0947358002982988]], 
[[1.4260207607785818, -0.88597328025941469], [-3.0355257122797044, 1.2011495520128967]], [[6.424976308543271, 
-1.4092533427916552], [6.4057323637904426, 1.3197928545677522]], [[2.7251679269145619, -2.0260015926495862], 
[3.1998965783768782, 6.4021237531871211]], [[6.7927721096007421, -2.399954494255085], [4.9653525263433309, 
-2.7807498910998101]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_expandedData_rank0_taggedData_rank4(self):
      arg0=Data(-2.07497989968,self.functionspace)
      arg0.setTaggedValue(1,-4.45668198436)
      arg0.expand()
      arg1=Data(numpy.array([[[[1.1070967571335197, 2.425506495267765, 1.3626853478931817, -2.3231092040501133], 
[0.96095778699872447, 2.78158480325955, -3.3493051495548021, -0.8778143616266556], [2.2536799630205975, 1.5662885951200503, 
2.949840775878938, 4.8973599808545725]], [[-3.9597592325552555, -3.6723875629521938, -4.0088513759967617, 1.2436693006020674], 
[1.0962965894721837, -4.019786434400574, -1.2708576031681384, -0.65369549114807768], [4.4878601358938681, -3.0937496673014508, 
-0.91297627821981031, 1.871300603481405]]], [[[-2.9748408617998123, -4.9928100290225776, -3.4156665951840894, 
2.3564538027176898], [1.7013230531922288, -2.0167416231886683, 4.2431267291968062, 3.1787413747984097], [-2.5333762579652097, 
-1.0208631923447173, 4.8003725080831359, 4.8990328227271966]], [[2.2124768117878446, -3.3466686848835838, -3.7739682945651545, 
-1.7545581357733142], [-3.1358589036073048, -3.9825618915958696, -4.1239970966405091, 4.7396008354038646], [-1.028506989413259, 
1.9320919845912945, -0.97488100363227836, -1.1945703437434707]]], [[[-4.2154741282819543, -1.3065968270118091, 
1.4373333249271338, -0.74992889556488951], [2.2292676071590947, -0.96157224278878672, -1.8089712098656809, 
-1.5751354701120679], [-3.7080742250116594, -2.6594392898091481, -1.1622477296056566, -3.7987151048982923]], 
[[-4.7744791605666483, 4.8761231577890491, 4.4144999991317455, -4.3167310937852434], [-4.2860032609091263, 1.1007405879828935, 
-4.7056427379011367, -3.2538412733918953], [-4.9117190563275521, -4.3074109840732682, 1.4166344901831271, 
1.6919996524343395]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[4.6826630936804392, -3.4479316311819543, -0.46138304935556373, 2.5724304159739644], 
[-3.3476980832889347, -4.4258287083342402, 2.4874045927070201, -4.8604934104112454], [1.0406108018117353, -4.1341101769631958, 
1.4170109525076846, -1.4087374088326277]], [[-3.1671171563985681, -4.0170648986562387, -2.0120400672785244, 
-4.3208315709083447], [2.053090278756903, 0.51807780568038364, 3.8577526447177348, 2.6816106397201871], [-0.57722141083414691, 
2.6734024608325155, 2.2431285412305915, -4.4536445759482408]]], [[[-4.9420814555701122, 3.6185027437996204, 3.1267314573456773, 
2.8606940502356135], [-3.0170509356636535, 0.1133467426763346, -3.2570011018490099, -4.9001968270618761], [-3.8196075451416567, 
-4.316644209520919, -4.9037109579078741, -1.3743398848466546]], [[-0.59101363421098707, 3.2524103126382151, 
-0.25703237818845004, 2.7572769382975508], [-3.3738171874601042, -1.1691381153059321, -3.3978395916867585, 4.7016453562028975], 
[-0.073980865635848048, -2.4358233768289561, 0.30156336202946221, -0.057291833973129869]]], [[[2.6386675246844327, 
-3.383548823136552, 0.96688199605574621, 3.5605519584347451], [0.65967445196876895, 0.65927600216991777, -4.3262284188237965, 
1.9731595501032642], [0.50912095748670705, -3.1187297696837257, -0.72419329691201462, -3.1413743098870031]], 
[[3.3832674891640941, -1.1782943800921233, -1.9621839559354504, -1.7461881185529071], [2.97445213838391, -3.1665653054900678, 
3.3458810843013289, -3.9798554205797165], [4.7661884747654497, 0.88923319350258367, -0.55854949766054407, 
-3.1278032901325115]]]]))
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-3.1820766568174959, -4.5004863949517411, -3.4376652475771579, 0.24812930436613723], 
[-3.0359376866827006, -4.8565647029435262, 1.274325249870826, -1.1971655380573205], [-4.3286598627045736, -3.6412684948040264, 
-5.0248206755629141, -6.9723398805385486]], [[1.8847793328712794, 1.5974076632682177, 1.9338714763127856, -3.3186492002860435], 
[-3.1712764891561598, 1.9448065347165979, -0.80412229651583766, -1.4212844085358984], [-6.5628400355778442, 1.0187697676174747, 
-1.1620036214641658, -3.9462805031653811]]], [[[0.89986096211583622, 2.9178301293386015, 1.3406866955001133, 
-4.4314337024016659], [-3.7763029528762049, -0.058238276495307773, -6.3181066288807823, -5.2537212744823858], 
[0.4583963582812336, -1.0541167073392588, -6.875352407767112, -6.9740127224111728]], [[-4.2874567114718207, 1.2716887851996077, 
1.6989883948811784, -0.32042176391066191], [1.0608790039233287, 1.9075819919118935, 2.0490171969565329, -6.8145807350878407], 
[-1.0464729102707171, -4.0070718842752706, -1.1000988960516977, -0.88040955594050541]]], [[[2.1404942285979782, 
-0.76838307267216699, -3.51231322461111, -1.3250510041190866], [-4.3042475068430708, -1.1134076568951894, -0.26600868981829517, 
-0.49984442957190822], [1.6330943253276833, 0.58445939012517201, -0.91273217007831953, 1.7237352052143162]], 
[[2.6994992608826722, -6.9511030574730253, -6.4894798988157216, 2.2417511941012673], [2.2110233612251502, -3.1757204876668697, 
2.6306628382171606, 1.1788613737079192], [2.836739156643576, 2.2324310843892921, -3.4916143898671033, 
-3.7669795521183156]]]])+(1.-msk_ref)*numpy.array([[[[-9.1393450780410923, -1.0087503531786988, -3.9952989350050894, 
-7.0291124003346175], [-1.1089839010717184, -0.030853276026412857, -6.9440865770676732, 0.40381142605059228], 
[-5.4972927861723884, -0.32257180739745728, -5.8736929368683377, -3.0479445755280254]], [[-1.289564827962085, 
-0.43961708570441438, -2.4446419170821287, -0.13585041345230842], [-6.5097722631175561, -4.9747597900410367, 
-8.3144346290783879, -7.1382926240808402], [-3.8794605735265062, -7.1300844451931686, -6.6998105255912446, 
-0.0030374084124122902]]], [[[0.48539947120945914, -8.0751847281602736, -7.5834134417063304, -7.3173760345962666], 
[-1.4396310486969996, -4.5700287270369877, -1.1996808825116432, 0.44351484270122299], [-0.63707443921899642, 
-0.14003777483973412, 0.44702897354722104, -3.0823420995139985]], [[-3.865668350149666, -7.7090922969988682, 
-4.1996496061722031, -7.2139589226582039], [-1.0828647969005489, -3.287543869054721, -1.0588423926738946, -9.1583273405635506], 
[-4.3827011187248051, -2.020858607531697, -4.7582453463901153, -4.3993901503875232]]], [[[-7.0953495090450858, 
-1.0731331612241011, -5.4235639804163993, -8.0172339427953982], [-5.1163564363294221, -5.1159579865305709, 
-0.13045356553685661, -6.4298415344639173], [-4.9658029418473602, -1.3379522146769274, -3.7324886874486385, 
-1.31530767447365]], [[-7.8399494735247472, -3.2783876042685298, -2.4944980284252027, -2.710493865807746], 
[-7.4311341227445631, -1.2901166788705853, -7.802563068661982, -0.47682656378093657], [-9.2228704591261028, 
-5.3459151778632368, -3.898132486700109, -1.3288786942281416]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_expandedData_rank1_taggedData_rank0(self):
      arg0=Data(numpy.array([0.58310614555755347, -4.7980493007725098]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-4.5363148494134977, -2.3109616254147425]))
      arg0.expand()
      arg1=Data(4.16702373077,self.functionspace)
      arg1.setTaggedValue(1,-3.94348061009)
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-3.5839175852129719, -8.9650730315430351])+(1.-msk_ref)*numpy.array([-0.59283423932806967, 
1.6325189846706856])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_expandedData_rank1_taggedData_rank1(self):
      arg0=Data(numpy.array([0.29665193013295799, 3.0395106094200717]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-1.038386128683193, -3.9935834571079387]))
      arg0.expand()
      arg1=Data(numpy.array([-0.90426980258475353, -1.4566496238880644]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([3.4486204702499172, 4.6383573932787581]))
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([1.2009217327177115, 4.4961602333081361])+(1.-msk_ref)*numpy.array([-4.4870065989331103, 
-8.6319408503866963])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_expandedData_rank2_taggedData_rank0(self):
      arg0=Data(numpy.array([[2.902576629033863, -1.9225148627109325, -0.79789484568108993, -3.4664382416992767, 
-3.088574372743099], [-3.7527136928056271, -4.1464627919350381, 0.39145677117463062, -4.2801581829315456, 
-0.30613491023407047], [-3.5215438693484225, -0.35004741594255329, -0.1665662866156854, 0.32859400207717648, 
-3.4873527480792523], [2.9286842893906044, 2.9451176687738299, -3.7466733249776518, -4.4133582769206878, 
-4.4527044818563351]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[3.7737931609727742, 3.1918583735138721, 1.0866679517742304, -0.1707635662037843, 
-1.500069959574696], [0.96623882470123945, 0.39831154297715798, 3.9268456341528477, -3.4547436301669188, 4.6741682373872546], 
[-2.494403422692042, 2.2843233160304326, -2.9489627615917877, 3.0346021356053967, 3.0517377451247718], [2.8243747821973813, 
-4.5107891142321774, 3.9549317704929479, 2.2890154872912793, -2.8650373090081018]]))
      arg0.expand()
      arg1=Data(2.05779568301,self.functionspace)
      arg1.setTaggedValue(1,2.00554352282)
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[0.84478094602043186, -3.9803105457243637, -2.8556905286945211, -5.5242339247127079, 
-5.1463700557565302], [-5.8105093758190582, -6.2042584749484693, -1.6663389118388006, -6.3379538659449768, 
-2.3639305932475017], [-5.5793395523618532, -2.4078430989559845, -2.2243619696291166, -1.7292016809362547, 
-5.5451484310926835], [0.87088860637717325, 0.88732198576039867, -5.8044690079910826, -6.471153959934119, 
-6.5105001648697662]])+(1.-msk_ref)*numpy.array([[1.7682496381531294, 1.1863148506942274, -0.9188755710454144, 
-2.1763070890234291, -3.5056134823943408], [-1.0393046981184053, -1.6072319798424868, 1.9213021113332029, -5.4602871529865631, 
2.6686247145676099], [-4.4999469455116863, 0.27877979321078783, -4.9545062844114325, 1.0290586127857519, 1.046194222305127], 
[0.81883125937773649, -6.5163326370518222, 1.9493882476733031, 0.28347196447163459, -4.8705808318277466]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_expandedData_rank2_taggedData_rank2(self):
      arg0=Data(numpy.array([[-0.71602762973101086, 0.79506575049833472, -3.363198727282132, -4.9708120789315835, 
-3.8226414024270805], [-0.11675975951193163, -2.7827251889820781, 2.6866262193751043, -0.80512052304157677, 
4.2033490092587797], [-4.4742584980710545, -1.4878262015071964, 2.7191163335382216, 2.0489294903135082, 3.8393252560777906], 
[-1.1274469876499182, 4.0758995005663774, 1.222029409101749, 0.23232778465920312, -2.3170066488578667]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[2.755494749862307, -2.2701979550112519, 4.1183381028523094, -3.2820180243672126, 
4.245996340019861], [-1.8843585543264618, 1.8009160549874839, 4.186575967836486, -2.3008775816635696, 2.6296313902958559], 
[2.6361281138700914, 1.4335468917639185, -4.4755002513276798, 3.5353284927489561, -1.3015790472928748], [-0.48710300923621475, 
4.5288541398197264, 0.30499279152559122, 3.9662040676318426, -0.88045863148790815]]))
      arg0.expand()
      arg1=Data(numpy.array([[-3.6969039900763532, 0.63754561218925776, -0.26377189998807715, -2.0296015927880795, 
-3.5494373015120342], [0.30373691147410398, -4.6479396763365841, 3.2422313872139092, -0.48134778786284027, 
-1.4246001457248747], [1.9812097178834716, -2.6665688788095188, 3.0843892824777335, 3.0579320843705897, -2.2318898317497093], 
[2.0389547451005532, -3.61769571494328, -1.8918821138452326, -3.453245233672174, -2.2647814249829921]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[4.8792902901253719, 3.778008919866819, 2.1152788558614439, -4.1948201175985407, 
-3.0213949315898425], [-0.8238796084134794, -0.35562909163246381, -3.5669602400497578, 0.60269792932727828, 
-4.6592704686812469], [-1.357746098824828, 1.3226298581827223, 3.2383983210723262, -4.4884046897579957, 1.8888299746954598], 
[0.19251750716918359, -3.0145207884350809, 2.6531224469641748, 4.916822506765774, 3.6755746050181735]]))
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[2.9808763603453423, 0.15752013830907696, -3.0994268272940548, -2.941210486143504, 
-0.27320410091504632], [-0.4204966709860356, 1.865214487354506, -0.55560516783880498, -0.3237727351787365, 5.6279491549836544], 
[-6.455468215954526, 1.1787426773023224, -0.3652729489395119, -1.0090025940570815, 6.0712150878275004], [-3.1664017327504714, 
7.6935952155096574, 3.1139115229469816, 3.6855730183313771, 
-0.052225223874874604]])+(1.-msk_ref)*numpy.array([[-2.1237955402630648, -6.0482068748780708, 2.0030592469908655, 
0.9128020932313281, 7.2673912716097036], [-1.0604789459129824, 2.1565451466199477, 7.7535362078862438, -2.9035755109908479, 
7.2889018589771029], [3.9938742126949194, 0.1109170335811962, -7.713898572400006, 8.0237331825069518, -3.1904090219883345], 
[-0.67962051640539833, 7.5433749282548073, -2.3481296554385835, -0.9506184391339314, -4.5560332365060816]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_expandedData_rank3_taggedData_rank0(self):
      arg0=Data(numpy.array([[[4.8464268236913455, 4.9745853433614418], [1.5553954123047307, 1.0978648858920543]], 
[[-0.67574784770147112, 4.5721936643504044], [3.94809923682255, -0.51918977421707257]], [[-2.1733780328375185, 
-0.67874222113248095], [0.75405329507134855, -4.9733400822223448]], [[1.9375143439040112, 3.4078107652442711], 
[-0.30183338446807184, -2.6833362251054185]], [[-4.9772146222353246, 4.2257930798577732], [2.9251748165669147, 
-1.3678123989128279]], [[-3.9513053356810826, 4.2572586692972489], [3.5639757011846722, 
2.2433938546818633]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-0.97598877247762506, 4.5126621611251903], [-3.9795403757019407, 
0.86058342286366329]], [[2.973279516064343, 4.0043891968554366], [-4.1741870563462946, -0.33252550368031919]], 
[[4.80320953210577, 1.5598823939637043], [1.2255994624330233, 2.5030934511075991]], [[-1.6651029359877034, 
-4.9991030814428425], [4.2258441380282417, 3.6778433727921875]], [[0.94736119865070201, 2.270157163600901], 
[-4.1145487043791382, -1.2877383188370795]], [[0.58272386061157633, -2.3924411745793908], [-3.1865237341487704, 
1.8651731296110086]]]))
      arg0.expand()
      arg1=Data(-2.17232750985,self.functionspace)
      arg1.setTaggedValue(1,0.886498918103)
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[7.0187543335370908, 7.1469128532071871], [3.727722922150476, 3.2701923957377996]], 
[[1.4965796621442742, 6.7445211741961497], [6.1204267466682953, 1.6531377356286727]], [[-0.0010505229917732173, 
1.4935852887132643], [2.9263808049170938, -2.8010125723765995]], [[4.1098418537497565, 5.5801382750900164], 
[1.8704941253776735, -0.51100871525967317]], [[-2.8048871123895793, 6.3981205897035185], [5.09750232641266, 
0.80451511093291739]], [[-1.7789778258353373, 6.4295861791429942], [5.7363032110304175, 
4.4157213645276086]]])+(1.-msk_ref)*numpy.array([[[-1.8624876905807382, 3.6261632430220772], [-4.8660392938050538, 
-0.025915495239449804]], [[2.0867805979612299, 3.1178902787523235], [-5.0606859744494077, -1.2190244217834323]], 
[[3.9167106140026569, 0.67338347586059122], [0.33910054432991021, 1.616594533004486]], [[-2.5516018540908165, 
-5.8856019995459556], [3.3393452199251286, 2.7913444546890744]], [[0.060862280547588909, 1.3836582454977879], 
[-5.0010476224822513, -2.1742372369401926]], [[-0.30377505749153677, -3.2789400926825039], [-4.0730226522518835, 
0.97867421150789546]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_expandedData_rank3_taggedData_rank3(self):
      arg0=Data(numpy.array([[[2.5345305341231095, -3.9380411524134349], [3.2549053250861864, -3.4167795425745648]], 
[[-2.8374769741887764, -2.8525506996132268], [3.6507388651537038, 4.9310971144704201]], [[4.9617065736707584, 
-3.2366362694851123], [2.4442729631215645, 0.68395869036750412]], [[1.7964484483842931, -0.14685365167379949], 
[-0.22580505147559471, -4.1952625824572474]], [[-1.3339867788188453, -0.47481766386604374], [-3.2413800916311897, 
1.894533055397285]], [[1.8348832002953692, 1.7345137753756763], [-4.0724433289229207, 
-0.79856100700433164]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-2.8189944574042358, -3.2261245088497925], [4.8950253892363769, 
2.5770741661283969]], [[1.2401341585946604, -1.5734637345208782], [-0.79590735036694316, 0.61779352376283381]], 
[[-3.4076935213958439, 0.031656368716429739], [1.9652944560154086, 1.0977149000942967]], [[1.777028113661002, 
-1.2822419020267484], [4.2114885262273329, 0.54816589622414735]], [[0.39856562268161433, -0.62202129632333936], 
[-0.30235148375231446, 1.9339782945676101]], [[-1.0460000631020594, 2.7763881026031543], [-2.8684475704144861, 
-3.092357561997392]]]))
      arg0.expand()
      arg1=Data(numpy.array([[[-2.7809554116716861, -2.4178938679382367], [-4.8550344800907128, -1.3392464366072021]], 
[[-1.0721381112004833, 1.1790546106017548], [-4.3780111006207409, 2.5971837154005772]], [[-2.9209670997448089, 
-2.3219529735447173], [-3.1629563486862642, -4.4528979670530617]], [[-2.4843612359932008, -3.5404399210405701], 
[3.8873295946375634, -3.1843267630781682]], [[-3.6931314427777062, -3.2005241845659169], [-4.6285703902121709, 
0.72112814987959162]], [[2.955645134420922, -2.7369867700605455], [-2.6907088961225698, 
-3.6848201723394434]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[-0.89010941147334144, -3.4446449903731615], [0.73205018935046162, 
-0.26865385057991276]], [[4.3657591102606137, -3.191196432227513], [-3.1555416523953452, -0.5714040859047973]], 
[[0.86596134594382779, 0.74755779385562793], [1.5989548429397962, -4.5608378319881746]], [[1.3446996853579023, 
4.899342632739538], [1.3177489248840963, 0.71693174792304859]], [[-2.6075034765860741, -0.6236129612256347], 
[-1.9605243915090864, 0.40432285104030363]], [[2.5461915142326479, -3.169606578641079], [-2.0459471227330415, 
-1.4124514842052016]]]))
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[5.3154859457947961, -1.5201472844751982], [8.1099398051769001, -2.0775331059673627]], 
[[-1.7653388629882931, -4.0316053102149816], [8.0287499657744448, 2.3339133990698429]], [[7.8826736734155674, 
-0.91468329594039499], [5.6072293118078287, 5.1368566574205659]], [[4.2808096843774939, 3.3935862693667707], 
[-4.1131346461131582, -1.0109358193790792]], [[2.3591446639588609, 2.7257065206998732], [1.3871902985809812, 
1.1734049055176934]], [[-1.1207619341255528, 4.4715005454362213], [-1.3817344328003509, 
2.8862591653351117]]])+(1.-msk_ref)*numpy.array([[[-1.9288850459308944, 0.218520481523369], [4.1629751998859152, 
2.8457280167083097]], [[-3.1256249516659533, 1.6177326977066349], [2.3596343020284021, 1.1891976096676311]], 
[[-4.2736548673396717, -0.71590142513919819], [0.36633961307561247, 5.6585527320824713]], [[0.4323284283030997, 
-6.1815845347662863], [2.8937396013432366, -0.16876585169890124]], [[3.0060690992676884, 0.0015916649022953422], 
[1.658172907756772, 1.5296554435273064]], [[-3.5921915773347073, 5.9459946812442332], [-0.82250044768144459, 
-1.6799060777921904]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_expandedData_rank4_taggedData_rank0(self):
      arg0=Data(numpy.array([[[[-1.0293310173558465, 4.6126759744818635, -3.999412383049342, 2.7796097211507291], 
[-4.7890791446154433, -2.3018966565208689, 0.07580104120589759, 0.5665707172883323], [0.061749667348783177, 
-3.5085266424547989, 1.444744551724134, -4.1388562419147323]], [[0.33406300551935253, 2.9158621368829198, -0.53929798267315032, 
3.0778545782652209], [-2.1203431658201599, 0.29435063613809742, 2.593662975224893, -2.4308263408931929], [2.792053002348065, 
0.5136620509227372, 4.7565526720184295, 2.655449695302444]]], [[[1.1426533357282311, -1.4271839669909845, 1.0474252544316247, 
0.33216594717015013], [-3.0705702644491426, 0.088981689370346118, -0.82609155712682458, 1.7363364482066057], 
[2.6148552875264439, -1.5310549094943959, 2.1063290975490032, 4.9841308707881371]], [[-1.4981664502280037, -4.2238867634910449, 
4.9917344954983296, 4.8356579820959897], [0.32487263805379563, -1.0490227000292185, 3.6081307181086526, -4.300908372948653], 
[-0.9869809000786276, -3.0372552309205103, -4.5717851811824639, -3.9062093994107929]]], [[[-4.3448299408435211, 
1.0641084537882222, 3.4814964247010813, 4.9068823487053361], [-3.3874111557747435, -3.0767954473566084, 4.043170372233714, 
-4.4165617511937052], [-0.371247577538103, 4.3583664727328912, 0.33203267502543188, -4.4164994169518401]], 
[[4.6019969595185941, -4.4734211673138793, -3.0386851699039861, 4.5210520239567682], [-4.3975465889902505, 4.6206688648895486, 
-1.4739855341349148, 2.9999851651464731], [-2.9124198688452161, -4.6930033632838732, -3.5540137842888564, 
-0.716912242653307]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[-1.576438788500222, 0.70025677948006226, -4.7560168070959534, 2.6780136033834427], 
[0.37176901610982949, 1.0462351073220724, -4.1053316817922338, 4.2527305068812833], [1.7929803186649726, 3.6556561213602699, 
-3.0936881892505506, -1.499138804620709]], [[-4.5106648330373291, -1.732249656275183, -0.33031143646472039, 
-2.5373948767327281], [1.0363094710920375, -4.8050643216130053, -3.0031915181633928, -4.6095956293321692], [3.8853936452141653, 
4.7967493707497653, 1.349880144870772, 3.6416093608584923]]], [[[-3.1160073264244073, 4.5439537194504034, 4.0257904032522376, 
-2.7566448000235622], [-4.2986454606174407, 1.9577726462428613, 4.2542363241774712, -1.695205624373588], [4.5244366587286873, 
-4.5581838677637556, 3.6913126795024862, 2.6280247968511183]], [[2.2406137530578203, 3.6873462208957175, 2.015971502082861, 
4.2743086951646454], [0.65115492904243411, -1.1896871625779659, -3.6145924781587748, -1.4963812058290049], 
[-4.6797762414840305, 1.3772001846138302, -1.2283231709743525, 3.4713278020936205]]], [[[-0.8562829777023282, 
-3.903145505071163, -0.094092641795811005, 3.5995946839729136], [-2.1495532361763914, -2.1941082150492219, -4.1426532860691054, 
-1.0945982744444693], [-1.6770989318138096, 4.2461621183871792, -1.3143949751193285, 4.9430970095692697]], 
[[-2.5593583474362225, 1.3212924630638359, 0.62358576878583261, -3.4465685074807659], [-0.17991280971259549, 
-4.3147306495724997, 0.44015169640713925, -2.7250228598759421], [0.027215973338657662, 3.8214735982372634, 4.6709300624308483, 
-2.0262918462527422]]]]))
      arg0.expand()
      arg1=Data(2.44063652232,self.functionspace)
      arg1.setTaggedValue(1,-1.69573285841)
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-3.4699675396795282, 2.1720394521581818, -6.4400489053730237, 0.33897319882704746], 
[-7.2297156669391249, -4.7425331788445506, -2.3648354811177841, -1.8740658050353494], [-2.3788868549748985, 
-5.9491631647784811, -0.9958919705995477, -6.579492764238414]], [[-2.1065735168043291, 0.47522561455923817, -2.979934504996832, 
0.63721805594153924], [-4.560979688143842, -2.1462858861855842, 0.15302645290121131, -4.871462863216875], [0.3514164800243833, 
-1.9269744714009445, 2.3159161496947478, 0.21481317297876235]]], [[[-1.2979831865954505, -3.8678204893146662, 
-1.393211267892057, -2.1084705751535315], [-5.5112067867728243, -2.3516548329533355, -3.2667280794505063, 
-0.70430007411707596], [0.17421876520276225, -3.9716914318180776, -0.33430742477467845, 2.5434943484644554]], 
[[-3.9388029725516853, -6.6645232858147265, 2.5510979731746479, 2.3950214597723081], [-2.115763884269886, -3.4896592223529002, 
1.1674941957849709, -6.7415448952723347], [-3.4276174224023093, -5.477891753244192, -7.0124217035061456, 
-6.3468459217344746]]], [[[-6.7854664631672028, -1.3765280685354595, 1.0408599023773997, 2.4662458263816545], 
[-5.8280476780984252, -5.51743196968029, 1.6025338499100323, -6.8571982735173869], [-2.8118840998617847, 1.9177299504092096, 
-2.1086038472982498, -6.8571359392755218]], [[2.1613604371949124, -6.914057689637561, -5.4793216922276677, 2.0804155016330865], 
[-6.8381831113139322, 2.180032342565867, -3.9146220564585965, 0.5593486428227914], [-5.3530563911688978, -7.1336398856075549, 
-5.9946503066125381, -3.1575487649769887]]]])+(1.-msk_ref)*numpy.array([[[[0.11929406991214453, 2.3959896378924288, 
-3.0602839486835869, 4.3737464617958093], [2.067501874522196, 2.7419679657344389, -2.4095988233798673, 5.9484633652936498], 
[3.4887131770773392, 5.3513889797726364, -1.397955330838184, 0.19659405379165751]], [[-2.8149319746249626, 
-0.036516797862816475, 1.3654214219476462, -0.84166201832036158], [2.7320423295044041, -3.1093314632006388, 
-1.3074586597510263, -2.9138627709198026], [5.5811265036265318, 6.4924822291621318, 3.0456130032831386, 5.3373422192708588]]], 
[[[-1.4202744680120407, 6.2396865778627699, 5.7215232616646041, -1.0609119416111956], [-2.6029126022050741, 3.6535055046552278, 
5.9499691825898378, 0.00052723403877852348], [6.2201695171410538, -2.8624510093513891, 5.3870455379148527, 
4.3237576552634849]], [[3.9363466114701868, 5.383079079308084, 3.7117043604952276, 5.9700415535770119], [2.3468877874548006, 
0.50604569583440062, -1.9188596197464083, 0.19935165258336163], [-2.9840433830716639, 3.0729330430261967, 0.46740968743801403, 
5.167060660505987]]], [[[0.83944988071003834, -2.2074126466587964, 1.6016402166165555, 5.2953275423852801], 
[-0.45382037776402484, -0.49837535663685539, -2.4469204276567389, 0.60113458396789721], [0.018633926598556894, 
5.9418949767995457, 0.38133788329303808, 6.6388298679816362]], [[-0.86362548902385594, 3.0170253214762024, 2.3193186271981991, 
-1.7508356490683994], [1.515820048699771, -2.6189977911601332, 2.1358845548195058, -1.0292900014635755], [1.7229488317510242, 
5.5172064566496299, 6.3666629208432148, -0.33055898784037563]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_sub_overloaded_expandedData_rank4_taggedData_rank4(self):
      arg0=Data(numpy.array([[[[2.4610526498759153, -1.1152083887031083, -0.12299890546029868, 1.5683008457043695], 
[-4.0873508766928746, -2.7053546016947139, -3.7549465288785786, 3.9519633674029766], [-1.1735542140484201, -4.3149336273557832, 
-4.9863600479956371, -0.76492187743278617]], [[-0.14640199013260258, 0.29230440531820534, -2.4637366351006937, 
3.397426805290042], [3.7918911827417183, 4.9924007596180644, -2.6900730542812479, -1.7018381155601201], [-4.3660009059416227, 
1.9330088481865824, -3.4398429543905804, -0.22840088606586395]]], [[[-1.4318793112753001, 1.8781857942423983, 
-2.9812845903507315, 4.5682960127185694], [3.1562935505738761, -1.0677552555821568, 3.9772244762997264, 1.4974583007966569], 
[-0.37626415988588402, -1.1040801109983511, -4.7497076983177156, -4.680162152309757]], [[-3.2224793134211991, 
2.8433807560533246, -4.0134164708704851, 0.32213028157934342], [-4.4784422366493857, -1.2076577234633987, -2.8455899233443436, 
-3.2252897094642341], [4.9447006393286763, 2.7488346987839138, -4.2584850826432197, 3.9531681073127505]]], 
[[[2.339406980990586, -3.8485997875342424, 1.8232133414068201, 4.641729222089765], [3.235569154060558, 2.0845420560974421, 
3.3265167386531385, -1.5533297283327832], [-4.9644588385718684, -0.18489288441876894, 1.5479186108278506, 
-0.10098647924617055]], [[0.49086477552784391, -3.9076399749835531, 3.0699560885428845, 2.7786404417275934], 
[3.9669008458002839, -2.5117771484873486, 1.2300199561524465, 0.45049163982235818], [-1.9539504414544604, -0.60749245511551919, 
-2.7299083807273972, 1.4092765444937232]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[-3.1425047006175664, 2.2599630583169716, -4.6012970632571122, 4.103331240795038], 
[1.982921376115713, 4.2985776731903869, -3.0168240650206082, -3.7017681674875513], [3.7698477521790217, 3.9228061048205394, 
3.9980766969192647, -1.573681648907499]], [[-4.9848997532948118, 0.13380642815295829, -2.3000670355179809, 
-3.2404640807016474], [3.6505272390042762, 3.4627566349105763, -1.1276653226956865, -2.049106933432391], [-4.5415093280683312, 
-3.8315066164861076, 1.1761174623348749, -0.40637173625883261]]], [[[4.7303359414781827, -0.606621994561511, 
-2.7421095615684168, -3.8223798480454665], [-3.8663586623759683, -0.86372098382471751, -3.8617042047906001, 
-1.3292070526426105], [-1.4752779034682462, -3.7800183717709759, 0.06947407358268709, 0.038002869101983805]], 
[[1.8686552089801021, 0.093196052856119316, 4.8841051848003119, -1.2038083511841338], [4.1968833964266352, 3.5543650377451463, 
4.8819354407300501, -4.3631319297022406], [1.3982168379220239, 2.8839900209936618, -1.297483970876343, 0.68677137119766307]]], 
[[[1.7031375139454683, 4.3365381850676439, 1.7233924568156942, 4.6567026710174826], [-3.5037413796872885, 4.0987115372044798, 
-1.6645967599658809, 1.5159418671597278], [-1.7404625414133035, -2.2041008668378428, -4.5210918758254737, 4.4618549526581646]], 
[[-2.6784227595876544, 2.6778420831760021, -0.42594740586745417, -2.7584626585183845], [0.68773998092638511, 
4.4042023379993154, 0.89768232177684304, 2.6032871056255402], [-2.9757441693780717, -0.19968345216364458, 2.0082108224547284, 
-1.6864306443569443]]]]))
      arg0.expand()
      arg1=Data(numpy.array([[[[0.71311729860168338, -0.4590454520801277, 4.2209684449423754, -3.7906842218683146], 
[1.3099668605379442, -1.4949132034437551, -0.30893632453454245, -1.5901713124060968], [3.9956640595819977, 3.2208549290813142, 
3.7023612209837005, 4.0505257586441825]], [[1.9542344919370276, 0.027347040687369706, -3.8275314728317946, 
-1.0574193466451676], [1.7849254536663857, -4.7032412978314122, -1.7392436727290859, 4.1732856970946468], [4.8532866105701853, 
-4.1031561510970258, 4.9768717755896237, 3.2685598627695391]]], [[[3.2140096662203614, -0.39955633611762575, 
4.1121477330464256, -1.9894164806605508], [1.8494049067199327, 0.81159007591113586, 0.89265135138401064, 0.98411830781439757], 
[-4.2372137613894409, -1.7152902164583783, -1.6910874490775507, -3.5050427921285565]], [[-1.9808395120126034, 
1.3961764556662191, 2.1965140261575939, -2.7903384490769323], [4.6140333307873895, -0.81430209988718438, -0.52978713445453351, 
-3.5522449011752455], [-1.2909567757019067, -3.2463454691699623, -3.0846952502115297, 2.2824501369715753]]], 
[[[-1.2953778400152629, -4.6831592784454044, 3.6228303452263049, -1.7992304332116884], [-4.2387896751914811, 
4.9147712615469654, 2.3327959702376235, 0.1366801501974777], [-1.3544539462704042, 4.7223750696839222, 2.9919623367491521, 
-2.8105847868644238]], [[-1.0555797867368124, -3.9786281318389105, 4.5082291952933211, -4.0455660332832677], 
[4.8386620351374727, 3.0249339217377873, -4.7421279297683832, 3.6304735395290244], [2.0914040620048135, 3.545525620916921, 
0.3492323166655007, -1.7221793634932014]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[-1.9787638924171089, 0.96159058841968559, 1.9018809442784352, -2.7908386405345986], 
[1.3537885612921299, -1.5849268934015184, -3.4397420797660128, -4.6401461953658849], [1.2269380278332545, 3.908436642118934, 
1.7892125683603517, 2.5952229687053405]], [[-4.3313348763811845, -4.8033572826178981, -4.8047415805971028, 1.5423546059821858], 
[2.3810531019674546, -0.10675403866078526, -0.805370416100609, 4.7305830742832295], [3.0698413781572711, -4.880702023456208, 
-1.9921204832219033, -3.2188093111343941]]], [[[2.0787752833356663, -3.9195628776115834, 1.9974565060569311, 
-2.5056481007738398], [1.6287706273172553, 4.9876032199844005, 1.5392560225537819, 4.6984463473428111], [3.7085194601874534, 
4.6026804988550083, 0.54709362337146494, -3.1543583674368736]], [[3.6487332552696738, 2.8379483688101805, -4.5750749147537926, 
4.3775544828477457], [4.5475977434079944, 4.3855163392081948, 1.6839954167795952, 2.0183031449671152], [-4.5191782857262091, 
4.4085036590365902, -3.5652545560700375, -4.2599220257328954]]], [[[3.3547857420878522, -0.20012217563206924, 
-2.4567646420151013, 2.2082847218892407], [4.3339634797609179, -4.7010641375406266, -0.14346395498221298, 0.47483722602866507], 
[3.7422615472598579, -0.93697765038622283, 4.9458896499731786, -4.475035158319062]], [[4.6640514092572598, 3.3314669356401811, 
1.1097112499521025, -3.1044883841299686], [-4.6271005643898322, -4.1347119676538995, -4.7852954895670603, -2.5321129591212097], 
[-2.1269317157104126, -2.0989394248805358, 2.5900992104319105, 0.030120144769069768]]]]))
      res=arg0-arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[1.7479353512742319, -0.65616293662298064, -4.3439673504026741, 5.358985067572684], 
[-5.3973177372308188, -1.2104413982509588, -3.4460102043440362, 5.5421346798090738], [-5.1692182736304177, -7.5357885564370974, 
-8.6887212689793376, -4.8154476360769687]], [[-2.1006364820696302, 0.26495736463083563, 1.3637948377311009, 
4.4548461519352092], [2.0069657290753327, 9.6956420574494757, -0.95082938155216201, -5.8751238126547669], [-9.2192875165118089, 
6.0361649992836082, -8.4167147299802032, -3.4969607488354031]]], [[[-4.6458889774956615, 2.277742130360024, -7.093432323397157, 
6.5577124933791202], [1.3068886438539433, -1.8793453314932926, 3.0845731249157158, 0.5133399929822593], [3.8609496015035569, 
0.61121010546002719, -3.0586202492401648, -1.1751193601812004]], [[-1.2416398014085956, 1.4472043003871056, 
-6.2099304970280791, 3.1124687306562757], [-9.0924755674367752, -0.39335562357621434, -2.3158027888898101, 
0.32695519171101139], [6.235657415030583, 5.9951801679538761, -1.17378983243169, 1.6707179703411752]]], [[[3.6347848210058489, 
0.83455949091116199, -1.7996170038194848, 6.4409596553014534], [7.4743588292520391, -2.8302292054495233, 0.99372076841551493, 
-1.6900098785302609], [-3.6100048923014643, -4.9072679541026911, -1.4440437259213015, 2.7095983076182533]], 
[[1.5464445622646563, 0.07098815685535742, -1.4382731067504366, 6.8242064750108611], [-0.87176118933718882, 
-5.5367110702251363, 5.9721478859208297, -3.1799818997066662], [-4.0453545034592739, -4.1530180760324402, -3.0791406973928979, 
3.1314559079869246]]]])+(1.-msk_ref)*numpy.array([[[[-1.1637408082004574, 1.2983724698972861, -6.5031780075355474, 
6.8941698813296366], [0.62913281482358308, 5.8835045665919052, 0.42291801474540458, 0.93837802787833358], [2.5429097243457672, 
0.014369462701605329, 2.208864128558913, -4.1689046176128395]], [[-0.6535648769136273, 4.9371637107708564, 2.5046745450791219, 
-4.7828186866838331], [1.2694741370368217, 3.5695106735713615, -0.32229490659507753, -6.7796900077156206], 
[-7.6113507062256023, 1.0491954069701004, 3.1682379455567782, 2.8124375748755615]]], [[[2.6515606581425164, 3.3129408830500724, 
-4.7395660676253479, -1.3167317472716267], [-5.4951292896932236, -5.851324203809118, -5.400960227344382, -6.0276533999854216], 
[-5.1837973636556995, -8.3826988706259833, -0.47761954978877785, 3.1923612365388574]], [[-1.7800780462895718, 
-2.7447523159540612, 9.4591800995541035, -5.5813628340318795], [-0.35071434698135917, -0.8311513014630485, 3.197940023950455, 
-6.3814350746693558], [5.9173951236482329, -1.5245136380429285, 2.2677705851936945, 4.9466933969305584]]], 
[[[-1.6516482281423839, 4.5366603606997131, 4.1801570988307954, 2.4484179491282418], [-7.8377048594482064, 8.7997756747451064, 
-1.5211328049836679, 1.0411046411310627], [-5.4827240886731614, -1.26712321645162, -9.4669815257986514, 8.9368901109772274]], 
[[-7.3424741688449142, -0.65362485246417901, -1.5356586558195566, 0.34602572561158418], [5.3148405453162173, 
8.5389143056532149, 5.6829778113439033, 5.1354000647467499], [-0.84881245366765912, 1.8992559727168912, -0.58188838797718212, 
-1.7165507891260141]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_float_rank0_taggedData_rank0(self):
      arg0=-1.18466090014
      arg1=Data(-2.11347188762,self.functionspace)
      arg1.setTaggedValue(1,-3.09345091018)
      res=arg0*arg1
      ref=Data(2.5037475088,self.functionspace)
      ref.setTaggedValue(1,3.66469033978)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_float_rank0_taggedData_rank1(self):
      arg0=-0.0760429120714
      arg1=Data(numpy.array([0.81195422853676824, -2.9970955850840006]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([0.94197141908976256, -0.087319053811368619]))
      res=arg0*arg1
      ref=Data(numpy.array([-0.061743364006643722, 0.22790787604620072]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-0.071630249795638867, 0.0066399951311379895]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_float_rank0_taggedData_rank2(self):
      arg0=-1.88916958802
      arg1=Data(numpy.array([[4.2814050899288887, 3.3773860970228, -2.2219522353232724, 0.44950438964603467, 
2.6192494842040004], [-0.89922712309034925, -4.2058456016742776, -2.3662264704001892, 1.9499563668068163, -4.3712433388138088], 
[-0.53607923278882286, -3.6216381162245295, 2.9949711467840121, -3.9861116510035597, -1.8526273479160835], 
[0.53169296364021434, 3.1054234703825205, 2.635672733400666, 1.9108766786007392, -1.8686773299280213]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[3.860559972594098, -3.1880419262864312, -3.8745084798673557, 3.4379427480933007, 
-2.7189056367143003], [-3.710838662766399, -1.9503175783889803, 3.8032938920236319, 4.4568777403467017, 0.088778774273520433], 
[4.2791541704403322, 2.7538879857713381, -4.164974425588202, -4.1538715119247902, -3.3907947863772838], [3.8610183271038103, 
-0.37504315880826589, -0.830718574183404, -1.7044539781135626, 4.1181647052901891]]))
      res=arg0*arg1
      ref=Data(numpy.array([[-8.0883002898863392, -6.3804551014959729, 4.1976445890050833, -0.84919002260063903, 
-4.9482064689944423], [1.6987925336647212, 7.9455556025893967, 4.4702030862471975, -3.6837982661367938, 8.2580199775206733], 
[1.0127445833535689, 6.8418885879842799, -5.6580084075007937, 7.5304409055268584, 3.4999272436166278], [-1.0044581770731487, 
-5.8666715781692051, -4.9792327719132512, -3.6099701076685813, 3.5302483815218437]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-7.2932524929508764, 6.0227518524720187, 7.3196035886897857, -6.494856885050682, 
5.1364738415759525], [7.0104035477459146, 3.6844806560726586, -7.1850671551120664, -8.4197978845848809, -0.16771816041919915], 
[-8.0840479212434762, -5.202561431531997, 7.8683430197009852, 7.8473677328696594, 6.4057863896396672], [-7.294118402351156, 
0.70852012981541268, 1.569368266550361, 3.2200026196313112, -7.7799115196902715]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_float_rank0_taggedData_rank3(self):
      arg0=-0.226190478398
      arg1=Data(numpy.array([[[4.1026592738991283, -3.0919986530003607], [-0.70453928097790808, 0.063306401117266375]], 
[[-1.0040804161967376, -3.5800513017917126], [-4.8894453062047569, -3.8861648209132174]], [[4.7492080509862404, 
3.7719753075405329], [-2.410614727977948, 0.86649344185660659]], [[-4.6353684799424286, -0.55653570869464275], 
[4.283716076044259, 0.96523296349203846]], [[-0.13060945131532975, -1.4783210259750601], [3.0056137180380329, 
1.2393171416088764]], [[-4.32133559000519, -0.91301626612091713], [-3.8981037705661992, 
3.661730058912493]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[1.1265942134336004, 4.8764741511527703], [-0.78597487490635221, 
-0.1968319671029386]], [[-4.5562065027691041, -1.0061606040024893], [2.3883397540024749, -1.5203059769615166]], 
[[-4.5191039175003631, -2.119246085176294], [3.8441882146553628, -0.57287933991346573]], [[-0.75383898289223517, 
-2.7125641284670268], [-0.72642791125381478, -1.5066035621638205]], [[1.0006161886628444, -0.18148135300851997], 
[-1.4317991991022714, 2.2312826779725947]], [[3.2355365441215191, 2.2577041978958388], [-3.2688559042617094, 
2.2902532434960419]]]))
      res=arg0*arg1
      ref=Data(numpy.array([[[-0.92798246386803407, 0.69938065452872533], [0.15936007701471316, -0.01431930515438249]], 
[[0.22711342968979856, 0.80977351664234731], [1.1059459729122616, 0.8790134799765954]], [[-1.0742256410651356, 
-0.85318489931877084], [0.54525809855506613, -0.19599256614244417]], [[1.0484762140300907, 0.12588307819531958], 
[-0.96893578856248841, -0.21832650577797141]], [[0.029542614276340161, 0.33438214009140887], [-0.67984120476319942, 
-0.28032173714759501]], [[0.97744496442241902, 0.20651558601922371], [0.88171395671017527, 
-0.82824847379046651]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-0.25482488409718396, -1.1030120211456758], [0.17778003296402906, 
0.044521516803071405]], [[1.0305705285423095, 0.22758394836473961], [-0.54021971153524651, 0.34387873624056026]], 
[[1.022178277030563, 0.47935328584952724], [-0.86951877132559863, 0.12957985195946883]], [[0.1705112001756032, 
0.61355617790373895], [0.1643110767683017, 0.34077938048225886]], [[-0.22632985440662703, 0.041049354057348789], 
[0.32385934581509485, -0.50469489637222631]], [[-0.7318475587896881, -0.51067119260367222], [0.73938408079971951, 
-0.51803347679938683]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_float_rank0_taggedData_rank4(self):
      arg0=2.19507677123
      arg1=Data(numpy.array([[[[2.5814432285455178, 4.7756453538262065, -1.6500435096507857, 3.820693003901404], 
[3.6035686845656265, -2.0914949127364748, -1.5638742073689582, -4.1367385093150499], [1.6879752260239798, -3.0514035215794424, 
1.2148877355318088, 2.5419723280014956]], [[-3.0424467708074889, -3.6440754533652386, 4.3200719069126752, -3.3287164159459959], 
[2.1703306035431504, -4.3082584948576441, -1.0296881430401248, 0.95748979711457949], [4.0173198710612912, 2.9730316106004615, 
-1.8723152089045314, 4.1077605793785317]]], [[[3.9221717703069103, -4.6761561690160551, -0.82591709012849357, 
-0.8113672172607469], [-2.4031249875351257, 4.1612196840572775, -1.0955830368129362, -4.8682975643034911], [3.3713536414862517, 
4.3070775269217236, -3.6288532435357821, -0.17968220307800919]], [[-1.0673141372606532, 3.1006567925769506, 
-3.4333264270178789, 4.0742691752391771], [-3.3215237350377436, -3.9000852316474441, -0.23532875492759597, 
-1.9435525130353248], [0.62902015766625574, -4.6483961122489594, 2.8768897842100349, -1.4964434994630538]]], 
[[[4.3131923598919037, -0.53962086637760187, -4.284179246548212, 3.4580070935891332], [-2.6419142419709796, 
0.58965228471713438, 3.5169226569258552, 4.1511072333826], [-2.3760892510796761, -3.7364538360531196, -4.2312656812651719, 
-4.1775609855229625]], [[-3.9079940770258101, -0.32122705596397338, -4.1345830794028871, -3.3420196028733926], 
[-1.1972473821065535, 2.9999981288366415, 4.7968874390488914, 1.8022891482585592], [0.44190478144459, -1.3461516604578527, 
-0.23477668118784578, 1.6756715441603394]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[-3.8941187146768943, -0.15157398983043535, 2.6826837936556336, 2.3426731237745724], 
[1.0699340271657096, 1.8184124535543482, 2.3939173556036479, -4.2553492759322236], [-0.80230498111941184, 4.0577030250130246, 
2.2657403417908615, 2.0240660996833295]], [[-4.7134502690766764, 1.9775729479489463, -1.5562834878753486, -4.1665035106079955], 
[-4.5333438437164162, 2.5836187325574675, -0.44931671433271703, -3.8746759635010952], [-3.8280694324637574, 
-2.6622613116535767, -4.543554470525927, 1.9054102437585785]]], [[[-2.6873058703918931, -0.35131888871283046, 
2.1441618301666319, -2.6349411562619549], [0.28629454369960694, -1.6158654250573812, 4.099553186471196, -2.5178179147303172], 
[3.5995792843137622, 1.2252902912721542, -3.5513147611721574, 0.62598168581237346]], [[-4.0965822944937456, 
0.045952122330320755, -4.9091333575478604, 4.0263836385094756], [-3.2072068887081184, 2.0787757739406345, 4.5869941097929257, 
0.94652896302847989], [1.7135571119617516, 3.817055808409922, -4.4593433546858421, -0.89391305861621717]]], 
[[[2.8679551116751059, -3.0480178742757547, -3.7761029437086191, -2.3646763903194259], [-1.9890487675522319, 
-0.17920350107151251, -0.78024039350506236, 4.4039982138055027], [3.2814565517313294, -1.2260122176619581, 4.3179154800118908, 
-1.2096335257748239]], [[3.8505119217904795, 2.274601422398109, 2.9592775253624835, -3.9277332916345986], [0.89406717516633627, 
-4.3825506680678492, -1.8287610918503705, -2.9401732495594946], [3.5563117879660417, 0.12106674262117068, 1.2934610658883869, 
-1.2570854708310621]]]]))
      res=arg0*arg1
      ref=Data(numpy.array([[[[5.6664660672390417, 10.482908183834509, -3.6219721795595281, 8.3867144628794481], 
[7.9101099130355337, -4.5909919001014918, -3.4328239457272649, -9.0804586104657865], [3.7052352090633547, -6.698064989880038, 
2.6667718479227012, 5.5798244103151795]], [[-6.678404234314792, -7.9990253803052997, 9.4828894929237038, -7.306788082667671], 
[4.764042293735395, -9.456958146532692, -2.2602445244022404, 2.1017636123395738], [8.8183255315825892, 6.5260326285728736, 
-4.109875623494089, 9.0168498295836947]]], [[[8.609468145789636, -10.26452178526876, -1.8129514195060659, -1.7810133315496703], 
[-5.2750438385098608, 9.1341966684749654, -2.4048888750658572, -10.686286898856661], [7.4003800660409427, 9.4543658312489818, 
-7.9656114611018136, -0.39441623018065169]], [[-2.3428364703102993, 6.8061797009539511, -7.5364150880100711, 
8.9433336263213938], [-7.2909995958830693, -8.5609864978212844, -0.51656468354493668, -4.2662469750369114], [1.380747536731018, 
-10.203586329491177, 6.3149939387192564, -3.2848083651351629]]], [[[9.4677883590617977, -1.1845092290585302, 
-9.4041023478998866, 7.5905910458991981], [-5.7992045841422399, 1.2943320332875183, 7.7199152304437897, 9.1119990628987342], 
[-5.2156983214233046, -8.2018030223076135, -9.2879530098639229, -9.1700670797340198]], [[-8.5783470205986152, 
-0.70511804883833662, -9.0757272763335752, -7.3359895992753801], [-2.6280499178825685, 6.5852262063541653, 10.529536191679394, 
3.9561630443891067], [0.97001492084616703, -2.9549062404288371, -0.51535283930280285, 
3.6782276828038274]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-8.5478895350140576, -0.33271654420001628, 5.8886968800188395, 5.1423473565912801], 
[2.3485873297840785, 3.9915549373194041, 5.2548323795390033, -9.340818349085378], [-1.7611210275003903, 8.9069696547711974, 
4.9734739939124424, 4.4429804788566658]], [[-10.346385198015899, 4.3409244414630734, -3.4161617336898913, -9.1457950733996753], 
[-9.9510377673576382, 5.6712414655613985, -0.9862846825588385, -8.5052112035391829], [-8.4029062898713356, -5.8438679641651845, 
-9.9734508770869326, 4.1825217657453813]]], [[[-5.8988426932974631, -0.77117193190920519, 4.7065998271649176, 
-5.7838981256785376], [0.62843850260598622, -3.5469486599832818, 8.9988339720604138, -5.5268036188208347], [7.9013528732115121, 
2.6896062563897978, -7.7954085395886992, 1.3740778577445134]], [[-8.9923126360908672, 0.10086843631618091, -10.775924600042282, 
8.8382211969679645], [-7.0400653419442056, 4.5630724139806436, 10.068804220192696, 2.077703740043829], [3.7613894126497103, 
8.3787305395436587, -9.7886010128266836, -1.9622077904710131]]], [[[6.2953816465792531, -6.6906332341281223, 
-8.2888358575223489, -5.1906462158751534], [-4.3661147465051151, -0.39336544252584782, -1.7126875637612788, 
9.6671141796795883], [7.2030490525183932, -2.691190940238597, 9.478155970324929, -2.6552384541339533]], [[8.4521692768810848, 
4.9929247461214414, 6.4958413555574186, -8.6216761120687657], [1.9625460881302423, -9.6200351702308904, -4.0142709928569031, 
-6.4539060035110341], [7.8063773970291876, 0.26575079449667233, 2.839246340226905, -2.7593991164767644]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_constData_rank0_taggedData_rank0(self):
      arg0=Data(-2.94329920099,self.functionspace)
      arg1=Data(-4.11119199005,self.functionspace)
      arg1.setTaggedValue(1,-1.58550879356)
      res=arg0*arg1
      ref=Data(12.1004680995,self.functionspace)
      ref.setTaggedValue(1,4.66662676526)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_constData_rank0_taggedData_rank1(self):
      arg0=Data(0.266988311155,self.functionspace)
      arg1=Data(numpy.array([3.9337011058963984, -3.0016324806379768]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([-1.9652353473487292, -3.8594212881553513]))
      res=arg0*arg1
      ref=Data(numpy.array([1.0502522148531663, -0.8014007867145424]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-0.52469486641141205, -1.0304203717615579]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_constData_rank0_taggedData_rank2(self):
      arg0=Data(1.86468101149,self.functionspace)
      arg1=Data(numpy.array([[2.8955672412516105, 3.5442988816927876, 1.7685063792811864, 2.6510011263927034, 
-1.8410336765318025], [4.7538427445859899, -4.5423673734107481, -4.8403947578584745, -4.1507857230400678, -3.1475718453564894], 
[-4.0722392722409673, 0.23579544037913713, -2.6626267768577216, -3.4944958921823099, 0.70992319536823345], 
[-2.5547708010061454, 0.79243466557276676, 3.955985875472571, 2.0609048858278145, 0.31944566319878742]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[0.027051640087560891, -0.28704863502092781, -4.7124479570524302, -2.4275641587163079, 
3.1848729701387537], [2.7059160672354778, 2.1441881149445514, 4.5114000462244626, -1.2449015335946658, 0.55804507767741818], 
[4.1659679939762171, -3.416197590121961, -0.0015392664018900604, 0.099833188154200059, -0.2936353796573421], 
[-4.4036561016432252, 1.2704330207252488, -4.421413548936826, 2.0738292065572583, -1.7850914999930878]]))
      res=arg0*arg1
      ref=Data(numpy.array([[5.3993092522454385, 6.6089868237268599, 3.29770026413911, 4.9432714618149056, 
-3.4329405381368012], [8.8644002974243499, -8.4700661883967285, -9.025792193079516, -7.739891320503812, -5.8692174523270841], 
[-7.5934272451790381, 0.43968328027017273, -4.9649495914832089, -6.5161201348713904, 1.3237803020172625], [-4.7638326013373833, 
1.4776378737375244, 7.376651743704155, 3.8429302070837408, 0.59566426236862435]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[0.050442679600853108, -0.53525413909676289, -8.7872122231359864, -4.5266327909245145, 
5.9387721514156766], [5.0456703092513546, 3.9982268629930342, 8.4123220014159603, -2.3213442508649171, 1.0405760598988238], 
[7.7682014128296997, -6.3701187777877903, -0.0028702408312241867, 0.18615705026733759, -0.5475363167477979], 
[-8.2114139138526276, 2.3689523301123376, -8.2445258886334845, 3.8670299425343013, -3.3286262238038109]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_constData_rank0_taggedData_rank3(self):
      arg0=Data(-0.0843317854058,self.functionspace)
      arg1=Data(numpy.array([[[1.8920259872550629, 0.37887878086653259], [3.6030726159133266, 4.2477623911196147]], 
[[4.7772605961463004, 1.0560603640247725], [4.283006791043281, 2.8071804443950903]], [[4.6006017346236803, 
0.71567334578417441], [-0.18270341034165138, 4.0425397819622777]], [[4.7303491031610161, -3.7500623252723031], 
[-0.73600943710390165, -2.4609753945175337]], [[0.18781628678023665, 4.8646886090563513], [-2.995584658263899, 
2.234138449486478]], [[4.1796490628897338, -2.9995697743009666], [-2.8738135038353207, 
-2.7089554461091847]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[1.4671526950709648, -0.99545779734949935], [0.3126326184678021, 
-2.0490638642928016]], [[4.6963437141683038, -1.4395553490454684], [-2.4647395708004103, 1.3090707513740654]], 
[[-0.14506075304915544, 0.17385962995774129], [-1.660829226811058, 0.8351933040175048]], [[2.7797362060279749, 
0.2585381285797812], [4.4105804059669875, 2.6242136817042541]], [[4.0941140603786259, -0.033136516889650025], 
[-2.3063497924797138, 0.38072722993406138]], [[4.6647989589030665, 2.9125078979491672], [1.0783181921338327, 
0.052875111490830129]]]))
      res=arg0*arg1
      ref=Data(numpy.array([[[-0.15955792953941036, -0.03195152404285146], [-0.30385354664675429, -0.35822138642277107]], 
[[-0.40287491542184328, -0.089059455994519046], [-0.36119360959389024, -0.23673453883211401]], [[-0.38797695822188294, 
-0.060354011017329283], [0.015407704793841851, -0.34091459738689406]], [[-0.39891878546234211, 0.31624945127327792], 
[0.062068989906497486, 0.20753844885943204]], [[-0.015838882792467049, -0.41024787584503014], [0.25262300256564879, 
-0.18840888428896346]], [[-0.35247726784321326, 0.252959074516104], [0.24235382370176012, 
0.22845104935518093]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-0.12372760623828087, 0.083948733346618593], [-0.026364866891483259, 
0.172801214086341]], [[-0.39605105029516763, 0.12140027277548882], [0.20785588856594925, -0.11039627368590056]], 
[[0.012233232296946622, -0.01466189300432983], [0.14006069395112802, -0.070433342486773909]], [[-0.23442011721151254, 
-0.021802981978609904], [-0.37195212031107977, -0.2213046250644746]], [[-0.34526394836676105, 0.0027944616314339752], 
[0.1944985957701344, -0.032107407052947866]], [[-0.39339082476346082, -0.24561699104257687], [-0.09093649837821173, 
-0.0044590525555529819]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_constData_rank0_taggedData_rank4(self):
      arg0=Data(2.11565746579,self.functionspace)
      arg1=Data(numpy.array([[[[-4.4837373506986822, 0.33676356197060908, -0.51174680796996075, -2.1055330601564179], 
[0.11582671844057035, 1.2519996892368344, 0.48197942015732842, 4.7085792749874553], [-2.4680454410540085, 4.6912692253173169, 
1.767622766333603, -1.7250336188518869]], [[-0.094982045315847863, 1.4686170622000638, -2.3484247206937079, 
1.5228816525976177], [3.2802629706674331, -3.6316325963187923, -2.3133816251581329, -0.9420944106118192], [2.7018922484742882, 
-3.44228116146992, 4.3202433676626875, 1.9381358150075068]]], [[[-2.293250366688977, -1.9298686135647323, -0.86527034887814569, 
-0.68046562395513455], [1.1607977919707224, 2.014359430496599, -2.6436787495721847, -0.01735831259085785], [3.2696077680177211, 
-3.2711717266170828, -4.1791092559979193, -3.0308333113256101]], [[1.8986463705575538, 0.30560271412789319, 
-0.44703908594656205, -2.6911000033518464], [-4.2726346438568283, 0.5598501047037141, -2.0774979647399441, 
0.46611300628541308], [-2.3041640738312195, -3.3056557450585378, 2.8431013996827792, -0.61441234929706923]]], 
[[[2.5960951039175644, -3.9028538303114511, -0.44816017688009957, -3.9869423938741786], [-2.3942967490483094, 
-2.3435545047501893, 2.70969368261588, -0.67499030643439184], [0.4568549335019858, -1.7035813277188749, 3.4129796545092859, 
0.72060479691313439]], [[-1.7941857412504247, -4.593713551476708, 0.50388019707008436, 4.7343579310422061], 
[-0.13990392766073612, -2.8216545514019242, -4.9850750509435615, -3.0330893769340426], [-0.38418480812986022, 
1.9024626662105302, -3.6121233734264346, -2.1998522784819752]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[-3.5753889232277167, -1.2997199654362355, -4.6586461783605433, 
-1.5764040037369931], [-0.29831227661554216, -3.9860033341878234, -0.21969794399859222, -4.1083934396061856], 
[3.3917999779499581, 3.3737619985720979, 4.77594298116761, -1.1084758902608471]], [[4.6375627748567183, 3.9562841239409625, 
3.1173402728910649, -2.2428067338771362], [2.3069568209406697, -1.5460966343625069, 0.048001088828868888, 1.3098190596129324], 
[3.2630585250369375, 4.5154346702466501, -0.48737162203114881, 2.7552684469586666]]], [[[-0.48971966935503897, 
2.0760307615338194, 4.2771051813445808, 2.3370956101975526], [-2.8561926872474483, 0.91046165139725055, 4.8979202559859516, 
3.8286666209736495], [3.0790099254803991, -4.4130231478615753, -1.1929455556462818, 2.3329873750009948]], [[4.3519572572265997, 
-3.9542095171716642, 4.8226055069648801, -0.14276384960824728], [1.9296227978862168, -2.8196224624118527, 1.1081014993474945, 
-2.5826240306980406], [-3.3878909765577525, -4.5956677562515624, 0.84360584487849444, 2.8171225896033656]]], 
[[[1.0027316292141251, -3.0590102834104069, 2.3584630976773546, -3.187014404635955], [-4.3606777451059653, -3.0168214579849262, 
2.4603141866730018, 1.120987472067875], [-0.95576817950255855, -4.7390260407256335, -0.014369025719758177, 
3.9222803511556137]], [[-4.8661946434197674, 2.3384897584300637, -3.6902304303938527, 2.1539173466517987], 
[-3.5131121889029169, 4.1547706022694157, -4.7290470660360304, -3.4065707204335718], [-4.448213338013403, 1.7678275851732508, 
1.5610523918681274, -1.2189369720872465]]]]))
      res=arg0*arg1
      ref=Data(numpy.array([[[[-9.4860524006632829, 0.71247634409036475, -1.0826809548776912, -4.4545867381951707], 
[0.24504966160716588, 2.6488024897051754, 1.0197033586147222, 9.9617408964082248], [-5.2215387632837711, 9.9251187605903386, 
3.7396843023004229, -3.6495802544689457]], [[-0.20094947328881954, 3.1070906520354287, -4.9684622931898925, 
3.2218959378382452], [6.9399128436588473, -7.6832906154212477, -4.894323106495535, -1.9931490732933164], [5.7162785072544837, 
-7.2826878386245006, 9.1401551348408479, 4.1004315067425949]]], [[[-4.8517322592194443, -4.0829409402889691, 
-1.8306156735338817, -1.4396321775365806], [2.4558505148595851, 4.2616945679218734, -5.593118683692281, -0.036724243626427455], 
[6.9173700846234398, -6.9206788853103713, -8.8415636978191348, -6.4122051226819643]], [[4.0168853687720105, 
0.64655066371146441, -0.94578157968439069, -5.6934458132885153], [-9.0394313828840769, 1.1844510537417412, -4.3952740792730713, 
0.98613546165123334], [-4.8748219252144152, -6.9936352563766002, 6.015028702247105, -1.2998860738661295]]], 
[[[5.4924479885134065, -8.2571018439995694, -0.94815342408776293, -8.4350044412889122], [-5.0655117924494011, 
-4.9581585844689604, 5.7327836696400398, -1.4280482811462307], [0.96654855084811486, -3.6041945545750109, 7.2206958866642319, 
1.5245529184759536]], [[-3.7958824584968851, -9.7187243708989293, 1.0660379007968743, 10.016279702548584], 
[-0.29598878904928411, -5.9696545175639715, -10.546711249070157, -6.4169781847297651], [-0.81280345756442041, 
4.0249593431619051, -7.6420157823571992, -4.6541338966134518]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-7.5642982685424585, -2.7497622483161712, -9.8560995677393048, -3.3351308996130911], 
[-0.63112659515955727, -8.4330177126526493, -0.46480559544012584, -8.691953252920273], [7.1758869458283963, 7.1377247600897951, 
10.104259424311795, -2.3451552928825685]], [[9.8114943077120991, 8.3701420436163882, 6.5952242217610388, -4.7450108108593225], 
[4.8807304214865965, -3.2710108873273951, 0.10155386194701822, 2.7711284723088525], [6.9035141298158491, 9.5531130714105874, 
-1.0311114107661365, 5.8292042600736398]]], [[[-1.0360790746169615, 4.3921699798561971, 9.048889508896151, 4.9444937759879011], 
[-6.0427253825201488, 1.9262249900973629, 10.362321556438378, 8.1001471206976561], [6.5141303360952021, -9.3364453694933154, 
-2.5238641710883503, 4.9358021575230673]], [[9.2072508620660933, -8.3657528863163364, 10.202981345387578, 
-0.30203940426912307], [4.082420878513509, -5.9653553133209698, 2.3443632099516085, -5.4639478118842684], [-7.1676168378491791, 
-9.7228587988205391, 1.7847810039043042, 5.9600664387501601]]], [[[2.1214366575342436, -6.4718179440366228, 4.9897000603997954, 
-6.7426308187598032], [-9.225700427353436, -6.3825608405521415, 5.2051820772326449, 2.3716255143414942], [-2.0220780845325455, 
-10.02615582365147, -0.030399936540186641, 8.2982017078579169]], [[-10.295201027355855, 4.9474433161044358, 
-7.8072635605614833, 4.5569513151462191], [-7.432542030622951, 8.7900714433510601, -10.005043731348447, -7.2071367774391684], 
[-9.4108957580107262, 3.740117628807659, 3.3026521473507597, -2.578853105328228]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_constData_rank1_taggedData_rank0(self):
      arg0=Data(numpy.array([-1.8021292916234133, 0.52610779274754549]),self.functionspace)
      arg1=Data(-2.10992701792,self.functionspace)
      arg1.setTaggedValue(1,-0.103414543531)
      res=arg0*arg1
      ref=Data(numpy.array([3.8023612821737358, -1.1100490462541024]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([0.18636637807672213, -0.054407197234984987]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_constData_rank1_taggedData_rank1(self):
      arg0=Data(numpy.array([4.4723367401807721, 0.10886597086815009]),self.functionspace)
      arg1=Data(numpy.array([3.6591992748934796, 3.1165977113137693]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([-4.3434168978267547, -2.0254374137442532]))
      res=arg0*arg1
      ref=Data(numpy.array([16.365171356748949, 0.33929143564762804]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-19.425222970072589, -0.22050121047994312]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_constData_rank2_taggedData_rank0(self):
      arg0=Data(numpy.array([[1.2998676807413592, 4.5859761834730222, 2.7288279226718393, -0.53434785328079126, 
0.40321735497507483], [-0.63909969785278609, 1.4472518705167969, -4.4716694997896287, 4.9126653418331028, -3.0157412130889849], 
[2.2188285385347717, -2.9128193743526829, 3.3058348191726985, 1.7519649145046383, 2.8041268590351365], [-1.6442986283969963, 
4.0979742201868987, 0.20921551378530268, -1.6380327347964583, -0.86160817132382572]]),self.functionspace)
      arg1=Data(-4.59316552067,self.functionspace)
      arg1.setTaggedValue(1,4.94648709344)
      res=arg0*arg1
      ref=Data(numpy.array([[-5.9705074126093685, -21.064147684524013, -12.533958326247081, 2.4543481357312569, 
-1.8520440522056809], [2.9354906964455134, -6.6474673913772122, 20.539118166247768, -22.564685062678947, 13.851798559211961], 
[-10.191446739467777, 13.379061518204827, -15.184246508441356, -8.0470648387193648, -12.879818804493805], [7.5525357656315766, 
-18.822673892740845, -0.96096148430708694, 7.5237554791894237, 3.9575089448487315]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[6.4297787059612395, 22.684472002352493, 13.498112099703015, -2.6431447596584698, 
1.9945094422334606], [-3.1612984068474175, 7.1588126984619098, -22.119055466819159, 24.300435707745983, -14.917324987686575], 
[10.97540672840889, -14.408223440744793, 16.352269266067864, 8.6660718377492501, 13.870577316573495], [-8.1335019431196507, 
20.270576589386437, 1.0348818386855039, -8.1025077812957491, -4.2619336990519789]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_constData_rank2_taggedData_rank2(self):
      arg0=Data(numpy.array([[4.1256943231465559, 1.4403418166238868, -0.27837797239285056, -3.1493910008722006, 
-1.5007537872801171], [-3.9537387594544415, -4.3652087156895476, -1.5023220469684739, 0.72389140754330583, 
-4.6261774750026596], [-2.8076534427104205, -2.0816390501398829, 0.9734117268077549, -1.7425201651856383, -2.9737729433540583], 
[2.2126916377732941, 1.8558210447240322, 1.1807119316509738, 2.0703566636652795, 0.95173429451861491]]),self.functionspace)
      arg1=Data(numpy.array([[1.2691335167597924, 2.183791126213503, -0.49630019001269599, 2.128937869230513, 
1.9163689714349763], [-1.7369122501251, 1.3359337199650838, -4.9943290248391916, -4.4144868576194209, -2.2481022519156113], 
[3.8292508050160112, -4.921373890571644, -3.9226910959808023, -0.15921452626965671, -2.9625072947370623], [0.16897065883080042, 
-0.35161686760537325, 0.70739182746213469, -4.9675056138541365, 0.29310740913735422]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[-1.9032071569828943, 1.6718776578668502, 1.2443690289447904, 4.3436101425734215, 
2.2002835397504406], [1.9294846871497455, 0.17656695710001813, 1.4016875754307501, -2.6257311697682439, 1.808728710787463], 
[-2.1607627148632402, -4.2258892450771066, 4.7810865984671835, -4.6150098009242582, 2.6198823235918205], [2.0674393552341828, 
-4.3146282325708789, -3.7555016231847116, 0.56682980920143233, -2.8579888620473026]]))
      res=arg0*arg1
      ref=Data(numpy.array([[5.2360569454108994, 3.1454056778574806, 0.13815904059392076, -6.7048577667706155, 
-2.8759979917071434], [6.8672972850908351, -5.8316295179751432, 7.5030906038304765, -3.1956091049435478, 10.400119999314756], 
[-10.751209205704853, 10.244524070952776, -3.8183935134720772, 0.27743452261535534, 8.8098240375781032], [0.37387996382395633, 
-0.65253798258199547, 0.83522597103692942, -10.284508349437596, 0.27896037325351886]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-7.8520509633362234, 2.4080753029048281, -0.3464049271861111, -13.679726694317949, 
-3.3020838553705758], [-7.6286783933577764, -0.77075162003578157, -2.1057861475314015, -1.900744232313865, 
-8.3675000202355623], [6.0666728752660912, 8.7967760741186556, 4.6539657618313566, 8.041747640639878, -7.7909351686689172], 
[4.5746057729300871, -8.0071778741654924, -4.4341655758287883, 1.1735398726443045, -2.7200460133626487]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_constData_rank3_taggedData_rank0(self):
      arg0=Data(numpy.array([[[2.3920121506856153, -2.6582441720172234], [-3.0548946250616869, -1.1037694850695114]], 
[[2.9519273835177176, -0.35994757882076378], [-1.2634169750553816, 1.8117510543033628]], [[-0.37146508067199324, 
-0.8995152669986517], [3.0145889260519265, -1.1452787540820877]], [[-0.2294423262721228, 3.8879515231030393], 
[3.3962426382870774, -1.5528306483083263]], [[3.5611822763312322, -2.2817322047226685], [-3.7391197992876801, 
4.0526236971932299]], [[2.3155204848676298, 2.3238670649617958], [-0.92009148803469198, 
2.937920467549425]]]),self.functionspace)
      arg1=Data(-1.46010897054,self.functionspace)
      arg1.setTaggedValue(1,2.87334173124)
      res=arg0*arg1
      ref=Data(numpy.array([[[-3.4925983988547022, 3.8813261614457524], [4.4604790461043899, 1.6116237265573676]], 
[[-4.3101356530543695, 0.52556268876004353], [1.8447264588097951, -2.6453539667720953]], [[0.54237949653122486, 
1.3133903104816462], [-4.4016283334163875, 1.6722317826031527]], [[0.33501079881129603, -5.6768328959040826], 
[-4.9588843422904976, 2.2673019593231047]], [[-5.199714187396248, 3.3315776604836311], [5.4595223608604728, 
-5.9172722144913541]], [[-3.380912231422379, -3.3930991478911943], [1.343433835396165, 
-4.2896840293994769]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[6.8730683341980114, -7.6380439112824865], [-8.7777562107303773, 
-3.1715069231194626]], [[8.4818961386514253, -1.0342523992844832], [-3.630228718383576, 5.205779910947836]], 
[[-1.0673461179932542, -2.5846147545546754], [8.6619441637588359, -3.2907772380065632]], [[-0.65926621099046367, 
11.171413360369902], [9.7585657020067398, -4.4618131033327062]], [[10.232493647134623, -6.5561963633437887], 
[-10.743768957398851, 11.644572790157257]], [[6.6532816387111327, 6.6772642156088367], [-2.6437372691287471, 
8.4416494824737605]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_constData_rank3_taggedData_rank3(self):
      arg0=Data(numpy.array([[[3.0680634552148174, 0.19761751931992055], [4.4838657140061713, -4.553950302001919]], 
[[-3.5077472630815176, 3.8926967274596223], [-3.9400454692416087, 0.68959660644564202]], [[0.46074952899980026, 
1.339993356079753], [-4.5533337973974692, 4.8816334725949897]], [[-4.6680038701735613, 2.6061190329937256], [4.789456089702286, 
-0.4871554714302162]], [[-4.1557569161287846, 2.2461535449712038], [-4.5737053039500513, -1.7306500986598419]], 
[[1.9387596385527033, 3.8876423248726546], [-4.1254496207451545, -0.058599040045427486]]]),self.functionspace)
      arg1=Data(numpy.array([[[-2.0118111638368497, 2.1046298672437622], [-3.0757196838667245, 3.1252224754372246]], 
[[3.2589692539148469, 1.8659476309283036], [-1.8097442552198939, -1.6837180878484159]], [[-1.6619058864792082, 
-1.7933960640117128], [0.43340640013714449, 3.0085840060711817]], [[2.3853433618447397, -0.85980031844693805], 
[3.3359319034102288, 2.5416857271814139]], [[-4.279813053039665, -3.5254374763050746], [-3.7885486787882137, 
-2.2701224423435171]], [[1.8080802495959647, 1.0151286984375503], [-1.7776530705901514, 
-0.15595642516486041]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[4.9972169205401116, -0.8407807028465335], [4.2911097150180577, 
-2.9180201580396545]], [[1.649361987236114, 0.57291650341532296], [1.7952224324814683, 2.2024607867098709]], 
[[-4.2024270411736753, -1.2850953061353767], [4.4187631457629912, -2.0737902127180607]], [[-4.724005038328583, 
1.9669800886766806], [-0.64618690228166109, -2.2209022249944277]], [[-1.9282222983289388, 0.56936115245469843], 
[4.4197989115883729, -3.7050182857483871]], [[-0.10772728599756753, -0.61751385898003086], [-2.6297913293272037, 
-0.28931928973704757]]]))
      res=arg0*arg1
      ref=Data(numpy.array([[[-6.1723643105610284, 0.41591173345132604], [-13.791114036383906, -14.232107835840534]], 
[[-11.431640480886619, 7.2635682365256429], [7.1304746532651722, -1.161086279591413]], [[-0.76572235443729075, 
-2.4031388105952747], [-1.9734440097528312, 14.686804389151009]], [[-11.134792044784058, -2.2407419744786314], 
[15.977299369620258, -1.2381961086525135]], [[17.785862694907838, -7.918673884976978], [17.327705186446611, 
3.9287876288117292]], [[3.505433011180954, 3.9464572932387099], [7.3336181858825995, 
0.0091388968035773701]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[15.331778611690245, -0.16615299678859122], [19.24075972620826, 13.288518779952373]], 
[[-5.7855449965581718, 2.230190197952437], [-7.0732580113795089, 1.518809484344726]], [[-1.9362662798767951, 
-1.722019172150681], [-20.120103574296987, -10.123483717544369]], [[22.051673801637229, 5.1261842466199834], 
[-3.0948837942187577, 1.0819246704175765]], [[8.0132231521142288, 1.2788725709550108], [-20.214857724324403, 
6.4120902617669646]], [[-0.20885731406290772, -2.4006730143662116], [10.849071642211808, 0.01695383264521589]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_constData_rank4_taggedData_rank0(self):
      arg0=Data(numpy.array([[[[4.3121327761894328, -2.3995680587581338, 2.2598165464673636, -3.3605388984577811], 
[0.79342499158799917, 1.6451809094554193, 1.9400185905503395, -0.64367830781804791], [2.5769001360101846, -3.4240467674217245, 
-2.4283515393792978, 3.4088505847714305]], [[0.68819160265759294, -2.081697989129816, 0.83383113222913785, 2.0492540010414277], 
[3.1688364279762364, -1.9312385716042515, 1.8721554164808305, -1.0080738737863451], [2.1873406677751648, 1.9064540551914302, 
-4.8032428521024606, 2.2548329003263561]]], [[[-3.9281164207390393, 1.3721763758607892, -4.6709338940903216, 
-2.6289225775698344], [1.0920853308126919, 1.397034861906814, -4.9590862430104945, -0.78590998051603744], [2.1384048432502549, 
0.79725194443177827, 2.4101118416924745, -0.87872058370490791]], [[3.2730883131405815, -3.742715747593194, 1.4235795566608092, 
-1.8634836474674019], [-2.4244393169419465, 2.7611576092904588, -3.4508791846469986, 1.1295882018755492], [4.9863930310071876, 
1.008534833270609, -0.75824531021874009, 3.2075272242261796]]], [[[4.9749683722994238, 4.0476025726844362, 
-0.92821018235814545, -3.0462607889054638], [-3.4608434110250643, -4.7945781614312999, 2.553570356070086, -1.9966560324921123], 
[4.1953272182413919, 4.2342904870254436, 0.14879483032395413, -1.0179538230417817]], [[-4.5205092750067699, 
0.70612135957389022, -0.77413796816020319, 3.7340207169157225], [-3.2926017752435186, 2.4097088913448106, -3.7401139032056188, 
0.79655207535074624], [-0.48881103638483303, 0.38771925455395717, 4.6995459786521891, 
4.1264781632233145]]]]),self.functionspace)
      arg1=Data(-0.484821428997,self.functionspace)
      arg1.setTaggedValue(1,3.66050577912)
      res=arg0*arg1
      ref=Data(numpy.array([[[[-2.0906143745780295, 1.16336201522327, -1.0956074873299324, 1.629261270951138], 
[-0.38466943822382299, -0.7976189594811679, -0.9405625853518419, 0.31206903701087624], [-1.2493364063236596, 1.660051246734807, 
1.1773168634295372, -1.6526838117469884]], [[-0.33365003622436029, 1.0092517938306143, -0.40425920106972357, 
-0.99352225316323228], [-1.5363198052699729, 0.93630584401977668, -0.90766106432317362, 0.48873581602388688], 
[-1.0604696282545494, -0.92428977935550682, 2.3287150633771305, -1.0931913088862324]]], [[[1.9044350163702548, 
-0.66526051138109221, 2.2645688452845483, 1.2745580007805348], [-0.52946637067154123, -0.67731243810863417, 2.4042712788569403, 
0.38102599981698437], [-1.0367444918792239, -0.38652482697024904, -1.1684738671325339, 0.42602256908110903]], 
[[-1.5868633532110075, 1.8145487970786345, -0.6901818749515618, 0.90345680487814906], [1.1754201341569055, -1.3386683778228243, 
1.6730601775974148, -0.5476485662117353], [-2.4175101948348217, -0.4889592990597576, 0.36761357483071094, 
-1.5550779323969117]]], [[[-2.4119712754743179, -1.9623644633018045, 0.45001618702067192, 1.4768925087754301], 
[1.6778910480688807, 2.3245142356641191, -1.2380256290749097, 0.96802163088880089], [-2.0339845370588394, -2.0528747647091272, 
-0.072138922265062438, 0.493525827140328]], [[2.1916397665040943, -0.3423427665940928, 0.37531867596445551, 
-1.8103332598804078], [1.5963238977924372, -1.1682785081691645, 1.8132873671646217, -0.38618551544227209], 
[0.23698606516972037, -0.18797460304259714, -2.2784405970084229, -2.0006050398198654]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[15.784586947560543, -8.7836327464683155, 8.2720715280876345, -12.301272058751632], 
[2.9043367670035978, 6.0221942267542534, 7.1014492623036158, -2.35618816566011], [9.4327578400722398, -12.533742980113542, 
-8.8889948436251842, 12.478117265701625]], [[2.519129338667796, -7.6200675195855867, 3.0522436783322933, 7.5013061136904442], 
[11.599544057682964, -7.0693099522107055, 6.853035721432966, -3.6900602407716114], [8.0067731552882684, 6.9785860866489573, 
-17.582298218622689, 8.2538288625874028]]], [[[-14.378892859158993, 5.0228595538060139, -17.097980513190329, 
-9.6231862880451065], [3.99758466472858, 5.1138541856375834, -18.15276385167871, -2.8768280255445546], [7.8276432868089891, 
2.9183453500046586, 8.8222283248332225, -3.2165617748807347]], [[11.981158685810874, -13.700232623656474, 5.2110211941894748, 
-6.8212926608441444], [-8.8746741307840686, 10.10723338586015, -12.631963198434333, 4.1348641409876423], [18.252720506949725, 
3.6917475856276987, -2.7755613400439358, 11.741171940954512]]], [[[18.210900477725517, 14.816272608879551, -3.3977187367570831, 
-11.150855222485461], [-12.668437306675671, -17.550581068346645, 9.3473590457759848, -7.3087709458458692], [15.357019527658773, 
15.499644798216076, 0.54466433630354305, -3.7262258521185188]], [[-16.547350325713538, 2.5847613174780624, -2.8337365062841888, 
13.668404413611992], [-12.052587826609253, 8.8207533227569019, -13.690708557239393, 2.9157834751889156], [-1.7892956235827711, 
1.4192485719696317, 17.202715214081625, 15.104997163878368]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_constData_rank4_taggedData_rank4(self):
      arg0=Data(numpy.array([[[[0.080557554900875239, -3.8080050734797277, 0.66279930901405937, 1.0179665434851612], 
[1.53010251198645, 2.8129083998453321, -2.3595600061431177, -4.1449627798563906], [2.3304599504903436, 0.077960390323860373, 
0.40804137425646392, -0.7475780552821476]], [[1.7315463001835738, -0.11653412716051115, 1.6325710312650088, 
3.7102148123253968], [-3.9604343601128256, -0.38577888594517162, 0.50471693755956082, 2.0428392228761911], [3.009033669411842, 
0.18294451175722415, -3.798017029649936, -3.308451305455776]]], [[[-0.26353006076849983, -1.9787212381552886, 
-3.5762242062899121, 1.5372630020806337], [-4.5924355743150915, 3.2812877380953633, 4.3101220037328325, 2.8081112276035949], 
[-3.5219900997555884, -3.6829952305249458, 1.0324329986397736, -2.4057687059636579]], [[0.50917554614526139, 
4.5525709875566616, -4.7353622735395939, 3.644298218317445], [-4.0577053605775646, -2.7093212922110208, -0.116891913023764, 
3.4331793109911271], [-2.7479662882015399, 2.2496200323148159, 3.4639537672425362, -1.1979526158736431]]], 
[[[-4.4567217868819711, 0.62726826345951459, 2.9530537607631597, 0.37044851505540244], [3.0626790025681867, 
-1.5371986999644847, 4.0366009093013098, -4.4438232737877552], [-4.61246098907373, -4.7235218071981491, -1.526569583716626, 
-2.0032148284458362]], [[0.32186440862628896, 4.831408226880697, -3.7922397088995585, -4.4373675702022446], 
[4.8755380414778937, -1.7265385812197351, -3.8791107918509016, 3.2021769841742387], [2.1125898384269508, 0.55893719783609797, 
-0.89467234740472001, 2.5967114208220385]]]]),self.functionspace)
      arg1=Data(numpy.array([[[[0.46929563492140058, -1.1897805989315557, 2.6096148404041699, 3.0111410260981195], 
[4.8219795698001668, 2.2359347915864527, 0.38927812640834336, 2.1118737535481316], [-0.023426366290417278, 0.12742608590226112, 
-4.4259356221286286, 2.7760050097499462]], [[4.8594150261833029, 3.5194717657830807, -3.4665152964355741, 
-0.57031577271860634], [3.6281189738895847, -1.7619814881086104, -4.2654088284114833, 2.9175219528578644], 
[-3.8231653130594587, -4.4692196694850992, -0.87986434001049751, 2.5771628158593032]]], [[[0.31245471702611383, 
2.8555707860109392, 4.2679090497713332, 4.940055817103163], [2.1820353897608058, -2.4523170199510669, 4.6918457287566682, 
1.5657491757035427], [2.0299089147476588, 3.4207665626635535, -2.2873956220546052, -2.1785833639424954]], [[2.3191221192994229, 
-2.2972731217408402, 1.4046986546251174, -4.9388514376387018], [-4.4168782282250865, 3.06363793793731, 3.2359275181247007, 
-2.4553815499379938], [-3.1384229018010421, -1.6737514055472813, 4.7157605153524482, -0.44825671200603878]]], 
[[[1.598200248336882, -3.4291310857013793, 0.6397623024756296, -0.43083051741421485], [4.7864957532665322, -4.7773817778721135, 
0.91469020468522366, 0.96802666370184554], [0.40998545346154636, -1.6465581444067467, 3.9944029113409343, 3.533891514050481]], 
[[-4.6619894421836232, 2.0429059400770955, -2.8073299767504833, -0.0058905399003048586], [4.1631159883247371, 
-0.73287615620791247, 4.2426263225529599, 0.60065699758699687], [-4.015612231490481, -0.15097609199683593, 2.7929607408377741, 
-4.4444603854954075]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[-2.4937747434820978, -1.4095893564715034, -2.411346202097735, -2.0863290239584584], 
[-2.9167197721464233, 3.5957096154674097, -2.5512626706215338, 0.58526931509350266], [2.0114581688802655, 4.3085452859475186, 
-3.8935368219535951, 0.53738536198823716]], [[4.635045671233593, 2.9884896323681831, 3.2883635167445817, 2.9731432283481158], 
[4.540153668953975, 4.7290369811196555, -1.7884925242896701, 2.2010622307873113], [3.7253432818147392, 1.765558399336169, 
-4.3227799799077449, 3.6145021192357323]]], [[[-2.9781764326177642, -2.7411141328239341, -0.11776731708789878, 
-1.8025636397486213], [4.6858212278097291, -1.0993372345281207, -4.4980033421930301, -0.10172425646091998], 
[-0.90589829606443217, 4.1669332791263862, 4.294072332212723, 1.212882904124033]], [[2.0921531783362743, 1.8064632960910494, 
2.991503294965149, -2.7256817007624279], [4.9505321881462176, 4.6192528129090658, -4.1044956467488873, -0.80123736487541031], 
[3.9938709517437943, 0.30703635553005704, 1.3602123112080236, 2.0766055633617073]]], [[[-1.0089877053771201, 
2.4369987401607602, -4.6215863345288088, -2.0462617703690045], [0.041208059903791394, 2.4828622659367277, -1.191302909148245, 
4.9132222549726539], [3.7368156163699524, -3.1101446825861858, -1.9042055842714811, 3.7295354446457516]], 
[[-4.9506736584491708, -0.52267085101021671, -4.8220622885560527, -0.28077216977476649], [1.8261679195482632, 
-4.9537754272049304, -1.8636839014116822, -0.39562348968437533], [-1.5137538237309602, -3.5747863720006077, 3.6135625036210204, 
1.4869606525011765]]]]))
      res=arg0*arg1
      ref=Data(numpy.array([[[[0.037805308874921832, 4.5306905570591134, 1.7296509130127187, 3.0652408222834646], 
[7.3781230524985766, 6.2894797567599552, -0.91852509833945195, -8.7536381042126141], [-0.054594208425334502, 
0.009934187394382038, -1.8059648536240032, -2.0752804266423639]], [[8.4143021096441633, -0.41013857029159423, 
-5.6593324523977531, -2.1159940276433775], [-14.368927046769599, 0.67973525553855541, -2.1528240813153579, 5.9600282789003876], 
[-11.504033150723377, -0.81761921036973417, 3.3417397471415713, -8.5264176825017959]]], [[[-0.082341210565296197, 
-5.6503785613356357, -15.262999654036019, 7.5941650358459061], [-10.020856948352021, -8.046757767487998, 20.222427513634024, 
4.3967978399041918], [-7.1493191011468653, -12.598666935029081, -2.3615827211533262, 5.2411676803058898]], 
[[1.1808402716718398, -10.458498964531072, -6.6517570148036054, -17.998647494721272], [17.922390463687268, -8.3003794968790192, 
-0.37825375799983701, -8.4297651378364478], [8.6242803322689152, -3.7653046910342436, 16.335176402568717, 
0.53699030073055243]]], [[[-7.1227338665631583, -2.1509851013029442, 1.8892524733201561, -0.1596005254166466], 
[14.659500039411204, 7.3437850581790309, 3.6922393119613748, -4.3017394178053738], [-1.8910419101790858, 7.7775533019249874, 
-6.0977339895622089, -7.0791438830648303]], [[-1.5005284748304346, 9.8701125656319242, 10.646068213817257, 
0.026138490724595141], [20.297430372162093, 1.2653389589489821, -16.457617553605893, 1.9234100130562826], [-8.4833415953097617, 
-0.084386153800956404, -2.498784742214557, -11.540981042407045]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-0.20089239580847515, 5.3677234209665095, -1.5982385965440551, -2.1238131450917619], 
[-4.4628802501217884, 10.114401780752907, 6.0198573627644532, -2.4259195272546106], [4.6876227046621004, 0.33589587222049716, 
-1.58872411554809, -0.40173750385225926]], [[8.0257961832064169, -0.34826103083626309, 5.3684870177059327, 11.031000044982129], 
[-17.980980590717632, -1.8243626181698582, -0.90268246970765076, 4.4964162570436867], [11.209683365097758, 0.32299921934542164, 
16.417991979119424, -11.958404254958127]]], [[[0.78483901626707342, 5.423900750826335, 0.42116233007956322, 
-2.7710143922813595], [-21.51933210147422, -3.607241787688789, -19.38694317805, -0.28565302668753695], [3.1905648301243872, 
-15.346795392938153, 4.4333419743224676, -2.9179157347399181]], [[1.0652732371989169, 8.2240523918700905, -14.165851844147355, 
-9.93319696578898], [-20.087800997552687, -12.515040000120182, 0.47978234814618892, -2.7507915442833073], [-10.975022734819346, 
0.6907151360493502, 4.7117125596587099, -2.4876750667669176]]], [[[4.4967774892502588, 1.528651967793665, -13.647792905871926, 
-0.75803463424783657], [0.12620705980391392, -3.8166526473888123, -4.8088144063211011, -21.833491405939437], 
[-17.235916253867909, 14.690836231737213, 2.9069023260921893, -7.4710607059287044]], [[-1.5934456493784888, 
-2.5252362495214959, 18.286416089449343, 1.2458893207738677], [8.9035511618840992, 8.5528843977675884, 7.2294363345648476, 
-1.266856433066001], [-3.197940945893968, -1.9980810776286906, -3.2329544476082952, 3.8612077086627954]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_float_rank0(self):
      arg0=Data(-2.24445414769,self.functionspace)
      arg0.setTaggedValue(1,-1.24645571799)
      arg1=0.962547171791
      res=arg0*arg1
      ref=Data(-2.16039299207,self.functionspace)
      ref.setTaggedValue(1,-1.19977242611)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_array_rank0(self):
      arg0=Data(1.16419456536,self.functionspace)
      arg0.setTaggedValue(1,-2.13443961827)
      arg1=numpy.array(3.62750269791)
      res=arg0*arg1
      ref=Data(4.22311892675,self.functionspace)
      ref.setTaggedValue(1,-7.74268547378)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_array_rank1(self):
      arg0=Data(4.73054387879,self.functionspace)
      arg0.setTaggedValue(1,-4.6146470815)
      arg1=numpy.array([-3.6311513670946836, -4.4569765252643654])
      res=arg0*arg1
      ref=Data(numpy.array([-17.177320872583099, -21.083923019516519]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([16.756482058630613, 20.567373714603605]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_array_rank2(self):
      arg0=Data(2.72809360801,self.functionspace)
      arg0.setTaggedValue(1,3.76168254187)
      arg1=numpy.array([[4.8508040702521704, -4.4385769893314002, -2.5707005505568281, 2.8311380975909985, 
-0.27753204925319874], [0.23788613511660728, -3.1245896182486965, 1.7581790156520816, -3.9221979564345499, 
-0.30043886080858506], [-1.0862660826944381, 4.3173195552235182, 3.810820813319534, 1.8360784845789135, -3.7651094858165535], 
[1.8995884992355503, -2.4165962702469992, -3.1485167900308273, -2.2173849748254479, -3.3189578000234521]])
      res=arg0*arg1
      ref=Data(numpy.array([[13.233447577744187, -12.108853513237282, -7.0131117400714569, 7.7236097474201255, 
-0.75713340958444375], [0.6489756446448558, -8.5241729651860165, 4.7964769343306353, -10.700123174283091, 
-0.81962533576848995], [-2.9634355567923585, 11.778051882324366, 10.396275902073052, 5.0089939775769832, -10.271571121698704], 
[5.1822552426061179, -6.5927008379918552, -8.5894485295825085, -6.0492337763097366, -9.0544275594854664]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[18.247184985119645, -16.696517571532244, -9.6701593814158802, 10.649842755342846, 
-1.0439874644863139], [0.89485212142205628, -11.75371421748733, 6.6137113086679093, -14.754063578494305, -1.1301556176042116], 
[-4.0861881591016873, 16.240385598576168, 14.335098123674731, 6.906744380951241, -14.163146621040879], [7.1456488943192822, 
-9.0904680005463163, -11.843720641856594, -8.3410983484149348, -12.484865613565249]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_array_rank3(self):
      arg0=Data(0.0393027465249,self.functionspace)
      arg0.setTaggedValue(1,2.27267653139)
      arg1=numpy.array([[[-3.8851278543680587, 0.50444246124378456], [-0.60167445028765254, -0.26043602337940719]], 
[[-3.0554823104759965, 2.1615086092429596], [-3.5662979584356727, -4.1247189566438802]], [[0.81083293059417283, 
3.9291611229326708], [4.1488399622940229, -2.8119035930446348]], [[-3.7351483040360369, -3.1696393829171168], 
[3.4812154261041002, 4.0594858671690339]], [[4.5084772328456548, 1.5560064436661616], [-2.7032929236967473, 
-4.6779668168072019]], [[3.6215585387710973, 0.85866272102225771], [-0.2601558845275953, 0.43914074689217308]]])
      res=arg0*arg1
      ref=Data(numpy.array([[[-0.15269619527691089, 0.019825974190642262], [-0.023647458410141615, -0.010235851012824015]], 
[[-0.12008884675983944, 0.084953224980384198], [-0.14016530469253202, -0.16211278363926993]], [[0.031867961145154236, 
0.15442682366996704], [0.16306080541026224, -0.11051553416978352]], [[-0.14680158702629856, -0.12457553324201316], 
[0.13682132749061079, 0.15954894405860634]], [[0.17719553789564646, 0.061155326846463957], [-0.10624683656250784, 
-0.18385694405269154]], [[0.14233719727427202, 0.033747803274686551], [-0.010224840786539487, 
0.017259437463841898]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-8.8296388960700654, 1.1464345431051242], [-1.3674114027054471, 
-0.59188683826279487]], [[-6.9441229390946688, 4.9124098886229071], [-8.105041674079164, -9.3741519713420747]], 
[[1.842760972239176, 8.9297122721372322], [9.4289712147966682, -6.3905473044424506]], [[-8.4887838918421235, 
-7.2035650385237382], [7.9116765996180076, 9.2258982598225572]], [[10.246310399392351, 3.5362993272109775], 
[-6.1437103851569983, -10.631505399176735]], [[8.2306310981184492, 1.9514626144463645], [-0.59125017326875162, 
0.99802486943871349]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_array_rank4(self):
      arg0=Data(-3.59212542533,self.functionspace)
      arg0.setTaggedValue(1,3.87865975656)
      arg1=numpy.array([[[[1.8154175752790831, -4.2762832815467213, 0.63191616735658229, -1.5252295941989455], 
[-0.52163737212494876, -1.3720022813426045, -4.1900698510318968, -4.927012531177386], [4.3469231149264314, -2.1929044078242677, 
2.525025381050364, 1.5454393820083787]], [[1.6347731010825459, 1.1906407585649603, 4.1080777328056648, -4.9407022587180176], 
[1.458592042344991, -3.3264666951325559, 1.413856523205177, -3.0469693740481962], [-4.0802596941903504, -4.6506825132965748, 
-4.0526147304893794, 4.7713361187546095]]], [[[-4.1735001963740279, -0.6828028046264123, -2.2803545648216894, 
-4.4723549727341441], [-3.3238495713017535, 0.56316163940948982, -4.3945893734606916, 3.5863419045992178], 
[-3.0339125942048719, 2.5741188327377014, -1.5380203735642262, -1.4865585910097492]], [[3.6566459895033763, 
-3.7585953268286287, 2.4970783293474117, 4.6878611006245272], [2.2503564522177477, 4.7157161081821926, -2.4913478538244171, 
2.4716379898324305], [0.62801505063525465, 1.9206972069364063, -2.9830811239765911, 4.3546404948072119]]], 
[[[3.7224948601277337, 0.22617130455488521, -3.7881065747899898, 3.9252123802328693], [4.4242527234031339, 2.7167170676808379, 
-2.9214634317069175, 1.7443240678704539], [-3.6307288354609635, -4.1504402849727482, -0.64936077916460633, 
-0.84036555523836487]], [[0.31660684701211661, -2.2604943317029678, -3.4763597806190116, -4.6604036546203567], 
[2.7142596483863031, -0.38109011149821903, 0.047770912452338443, 3.141090804435402], [-0.70722741899047392, 1.7598844279955586, 
-0.94052599437443973, -2.5248867099616943]]]])
      res=arg0*arg1
      ref=Data(numpy.array([[[[-6.5212076297500943, 15.360945901555608, -2.2699221314383746, 5.4788160047870855], 
[1.8737868672121138, 4.9284042784208992, 15.051256445798424, 17.698446984159528], [-15.614693043079905, 7.8771876786627653, 
-9.070207870873416, -5.5514120974178649]], [[-5.8723100210434271, -4.2769309412748413, -14.756730473241351, 
17.747622202524067], [-5.2394455604907799, 11.949085592097573, -5.0787499647733378, 10.945096158718952], [14.656804589448482, 
16.705834901148101, 14.55750041245591, -17.139237784971588]]], [[[14.991736168012963, 2.4527133149848526, 8.1913196110622639, 
16.065260008657308], [11.939684555043712, -2.0229472434930935, 15.785916222291153, -12.88258993943561], [10.898194567870817, 
-9.246557706896688, 5.5247620885548905, 5.3399049110081735]], [[-13.135131030324363, 13.5013458370259, -8.9698185558882422, 
-16.839385049966673], [-8.0835626280657458, -16.939443730837311, 8.9492339690628651, -8.8784336654874636], 
[-2.2559088308765154, -6.8993852713956931, 10.715601551256928, -15.642414839566584]]], [[[-13.371668432723354, 
-0.81243569357155343, 13.60735394116111, -14.099855190852763], [-15.892470695819847, -9.7587884522430439, 10.494263072204902, 
-6.2658308342117035], [13.042033362336429, 14.908902073962579, 2.3325853650489816, 3.0186984775429044]], [[-1.1372915049856431, 
8.1199791627235314, 12.487520355554565, 16.740754460060479], [-9.7499610939144503, 1.3689234788544209, -0.17159910921123633, 
-11.283192141881218], [2.5404495932458673, -6.3217255994443757, 3.3784873375757707, 9.0697097469300481]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[7.0413870905787768, -16.586247871766908, 2.4509878078428469, -5.9158466465271209], 
[-2.023253882776471, -5.3215300345460719, -16.251855308354454, -19.110205224723007], [16.860235750706583, -8.5055300766014366, 
9.7937143297615865, 5.9942335371920983]], [[6.3407286382685166, 4.6180903947607774, 15.933835779035615, -19.163303020013068], 
[5.6573822558757989, -12.902232501933243, 5.4838683980995784, -11.81815749057823], [-15.825939072152085, -18.038415104840407, 
-15.718713663973688, 18.506389388813826]]], [[[-16.18758725565295, -2.6483597599677804, -8.8447194812518077, 
-17.346743249775365], [-12.892081569052786, 2.1843123872134802, -17.045116949428994, 13.910200018618049], [-11.767514684049722, 
9.98413112513167, -5.9654577277062169, -5.7658549827115504]], [[14.182885643457277, -14.578312435348248, 9.6853172250069655, 
18.182618195314927], [8.7283670091222749, 18.290658292147395, -9.6630906602099991, 9.5866428039370959], [2.4358567034102072, 
7.449730961073036, -11.570356706108733, 16.890168841476218]]], [[[14.438291007962611, 0.87724153706471986, -14.692776525181715, 
15.224563295143158], [17.160170991095374, 10.537221160361478, -11.331362642810522, 6.7656395644405372], [-14.082361821068519, 
-16.098145705311069, -2.5186495216313647, -3.2594920598985713]], [[1.2280102361558611, -8.7676883942984087, 
-13.483616780395511, -18.076120104480751], [10.527689667038782, -1.4781188790894393, 0.18528711566282724, 12.183222494850538], 
[-2.7430945287710564, 6.8259929070552934, -3.6479803243746041, -9.7931764717905647]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_constData_rank0(self):
      arg0=Data(-3.43898287669,self.functionspace)
      arg0.setTaggedValue(1,0.722221413882)
      arg1=Data(0.598267999618,self.functionspace)
      res=arg0*arg1
      ref=Data(-2.05743340636,self.functionspace)
      ref.setTaggedValue(1,0.432081960565)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_constData_rank1(self):
      arg0=Data(2.54071180446,self.functionspace)
      arg0.setTaggedValue(1,1.77366747247)
      arg1=Data(numpy.array([0.96503571115658815, -4.2795936021896841]),self.functionspace)
      res=arg0*arg1
      ref=Data(numpy.array([2.4518776230597954, -10.873213983369505]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([1.7116524506474844, -7.5905759675816533]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_constData_rank2(self):
      arg0=Data(-4.29567815772,self.functionspace)
      arg0.setTaggedValue(1,-4.50683433375)
      arg1=Data(numpy.array([[0.86357290994364888, -1.6358950849440013, -2.2980505809074803, 3.4588705396944679, 
3.8654721551442019], [2.3658542885020406, 0.40765607638525569, -3.9986616455290802, -0.45553462080968821, 
-0.55357772382555837], [-1.7327492088524608, 0.75701029254549645, 3.6063818383867652, 0.20560313166152611, 
0.063917176339579385], [-2.6114212754456858, -2.5024343954751815, -2.1587918361576062, 4.7341325768233897, 
-3.0193998652236154]]),self.functionspace)
      res=arg0*arg1
      ref=Data(numpy.array([[-3.7096312868400583, 7.0272787847086784, 9.8716856857305082, -14.858194627732395, 
-16.604824306111801], [-10.162948591456614, -1.7511593031882913, 17.17696349079543, 1.9568301206955545, 2.3779917368355141], 
[7.443332929266953, -3.2518725788537828, -15.491855691541197, -0.88320488183639601, -0.27456761830480414], [11.217825333526527, 
10.749652773759632, 9.2734749376375447, -20.336309905991339, 12.970370050451297]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-3.8919800402311449, 7.3727081352398454, 10.356933258729857, -15.588556504294269, 
-17.421042624961682], [-10.662513336072623, -1.8372384014152188, 18.021305593123024, 2.0530190692772652, 2.494883092136658], 
[7.8092136262358469, -3.4117199774467988, -16.25336548985689, -0.92661925289885694, -0.2880641248436222], [11.769243064065984, 
11.278057251486535, 9.7293171666160827, -21.335951237755914, 13.6079349799124]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_constData_rank3(self):
      arg0=Data(-3.59206616756,self.functionspace)
      arg0.setTaggedValue(1,-0.0119975658212)
      arg1=Data(numpy.array([[[0.12579371100998493, 4.2244912164096426], [-2.2880694159514627, 0.15522821784365171]], 
[[0.2272855754165759, 3.4328540263145744], [4.3524811547163704, -1.3061387222720855]], [[-3.4268654281407409, 
-2.3221118156450471], [1.2302689975662462, -1.8492085426333125]], [[3.4138346645898849, -1.87114430860573], 
[-4.7545417945591719, 4.4848076805094532]], [[-1.6479203131741729, -3.4662588226341438], [1.4081151914819587, 
3.8191464350469495]], [[0.91171689149033064, -2.7371482480155453], [1.415285018243857, 
3.3557809756702426]]]),self.functionspace)
      res=arg0*arg1
      ref=Data(numpy.array([[[-0.45185933341035378, -15.174651973604927], [8.2188967380601419, -0.55759002956628045]], 
[[-0.81642482582750686, -12.331038806084893], [-15.634400300784174, 4.6917367144091093]], [[12.309527365193574, 
8.3411792902619055], [-4.4192076431514344, 6.6424794427496909]], [[-12.262720000305116, 6.7212741655586496], 
[17.078628722469645, -16.109725937155808]], [[5.9194388037821541, 12.451031044778535], [-5.0580429393447686, 
-13.718626698276386]], [[-3.2749474003122501, 9.8320176172833467], [-5.0837974314834247, 
-12.054187308435015]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-0.0015092183277361623, -0.050683611429984718], [0.027451263421367902, 
-0.0018623607608878412]], [[-0.0027268736512712343, -0.04118589213530393], [-0.052219179139271883, 0.015670485292086311]], 
[[0.041114043534536605, 0.027859689352403513], [-0.014760233276091163, 0.022186001207381092]], [[-0.040957706091134624, 
0.02244917700347376], [0.057042928129902422, -0.053806775342366019]], [[0.019771032425410884, 0.041586668377891968], 
[-0.016893954693646036, -0.045820460735303124]], [[-0.010938383415961312, 0.032839116267967414], [-0.01697997516214856, 
-0.04026120313715735]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_constData_rank4(self):
      arg0=Data(-3.02435008278,self.functionspace)
      arg0.setTaggedValue(1,0.0983034343665)
      arg1=Data(numpy.array([[[[-1.8186748977480915, 1.2922082205688703, -4.2813412436649498, 4.6009209343532866], 
[-2.8913456770667634, -1.9046372889030891, 4.0948281884285791, 0.7633525812302242], [4.4562951952477299, 0.22424375665614971, 
-4.0220562690377024, -0.22014293834666265]], [[0.14355494610290176, -0.66493327919459055, -2.0512094653017163, 
0.9567284495392876], [3.9194732425022067, -0.33412865591083296, -4.5305792297203151, 3.7725706847958005], [2.9211680651596676, 
-4.0730538554822617, -3.9172251429753011, 0.16047009520591793]]], [[[0.1393602798812168, -0.1899159770662715, 
3.4062697273257925, 0.39764325468636752], [-2.133874976270528, 4.0612521341249881, 1.1042056330189141, 4.7775552064895308], 
[3.0855987949820456, 2.7854739781893034, 0.066545702763578518, -2.395952092682978]], [[-0.81613367275528326, 
4.6084451873410046, 4.68970107983953, -0.74320428362115365], [3.8835371188624972, 1.0580760161604728, 0.88414350493161997, 
4.4639606290261682], [-0.096682301394681147, 1.5840389675317326, 4.0985533195863439, -4.1576577737121028]]], 
[[[-2.1340708645131889, 1.6268466187570194, 4.9517882128521329, -3.6014632515771594], [3.5403265521045704, 0.71346428105732329, 
-0.079128681111479082, 1.8845304952447082], [-1.9393707428780305, 4.0706520916770224, 2.5721055800003958, 3.5684468977861243]], 
[[4.24557597470519, -1.2582918884958838, -2.5897456332331337, 0.055754666672839015], [3.7572925903225176, -1.7794347625291085, 
1.269950287036183, 2.2609410519448767], [-3.1056432992516756, 0.65059527218607016, -1.5361529969678003, 
-4.2751161041265862]]]]),self.functionspace)
      res=arg0*arg1
      ref=Data(numpy.array([[[[5.5003095775588244, -3.9080900388496396, 12.948274744698056, -13.914795608686919], 
[8.7444415377895766, 5.7602899423646194, -12.384193970653929, -2.308645442235834], [-13.477396742650555, -0.67819162400647637, 
12.164106210219892, 0.66578931381270345]], [[-0.43416041313014264, 2.010991017976973, 6.2035755161894137, -2.8934817655644798], 
[-11.85385922542519, 1.01052202816392, 13.702057668457133, -11.409574462864864], [-8.8346348796871226, 12.3183407650052, 
11.84706018543489, -0.48531774572012726]]], [[[-0.42147427399534493, 0.57437240096209019, -10.301752131817151, 
-1.2026124102286029], [6.4535849611311935, -12.282648228041355, -3.3395043976296126, -14.448999484244389], 
[-9.3319309710374121, -8.4242484565252109, -0.20125750166184572, 7.2461979098485756]], [[2.4682739407589946, 
-13.937551583833201, -14.183297849037679, 2.2477099366939157], [-11.745175806920553, -3.1999922870650623, -2.67395948233152, 
-13.500579697932938], [0.29240112622660275, -4.7906883825852393, -12.39546007137929, 12.57421263210734]]], 
[[[6.4541773957541011, -4.9201537061121581, -14.975941091460562, 10.892085683045373], [-10.707186900934403, 
-2.1577657574780447, 0.23931283326996872, -5.6994799592994054], [5.8653360667690544, -12.311076990442, -7.7789477237994271, 
-10.792232670724282]], [[-12.840108050558868, 3.8055151771370253, 7.8322974202541449, -0.16862163076750919], 
[-11.363368156579833, 5.3816336713608983, -3.84077425572749, -6.8378772576157525], [9.3925525691846001, -1.9676278652938191, 
4.6458644435460927, 12.929447743419873]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-0.17878198844484142, 0.12702850599858689, -0.42087054794735002, 
0.45228632909580802], [-0.28422920999649276, -0.187232386721737, 0.40253567406341983, 0.075040180367489231], 
[0.43806912224393352, 0.022043931414552707, -0.39538194446185215, -0.021640806891016971]], [[0.014111944222217848, 
-0.065365224969429286, -0.20164093504429942, 0.094049692345880662], [0.38529768064569969, -0.0328459943963086, 
-0.44537149795119063, 0.3708566547059321], [0.28716085316703688, -0.40039518235375648, -0.38507668474140705, 
0.015774761471866326]]], [[[0.013699594126604925, -0.018669392786690289, 0.33484801257488078, 0.039089697588356072], 
[-0.20976723867619795, 0.39923503261289961, 0.10854720597263133, 0.46965008467363367], [0.30332495862397219, 
0.27382165839461897, 0.0065416711239942834, -0.23553031928841958]], [[-0.08022874293401687, 0.45302598900554336, 
0.46101372230066623, -0.073059533515878586], [0.38176503627409586, 0.10401250620943421, 0.086914343007642336, 
0.43882266071026327], [-0.0095042022695574421, 0.15571647067878705, 0.4029018672496939, -0.40871203807661521]]], 
[[[-0.20978649516320355, 0.1599246098113975, 0.48677778757908358, -0.35403620637489741], [0.34802625885090727, 
0.070135989125784545, -0.0077786211101526382, 0.18525581985101891], [-0.19064680453488567, 0.4001590807231642, 
0.25284681206736331, 0.35079058540697811]], [[0.41735469917756285, -0.12369441407469653, -0.25458088988254995, 
0.0054808752159013797], [0.369354765548632, -0.17492454838780824, 0.12484047469042171, 0.22225827030646425], 
[-0.30529540223385143, 0.063955749638520312, -0.1510091153143778, -0.42025859535131799]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_taggedData_rank0(self):
      arg0=Data(0.594413183352,self.functionspace)
      arg0.setTaggedValue(1,4.34488861419)
      arg1=Data(-4.13566143567,self.functionspace)
      arg1.setTaggedValue(1,-2.97392630114)
      res=arg0*arg1
      ref=Data(-2.45829167925,self.functionspace)
      ref.setTaggedValue(1,-12.9213785253)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_taggedData_rank1(self):
      arg0=Data(1.86985047593,self.functionspace)
      arg0.setTaggedValue(1,-4.43665560596)
      arg1=Data(numpy.array([2.0974204701185295, -4.2066944343028512]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([2.4348371383302458, -0.80460054396706226]))
      res=arg0*arg1
      ref=Data(numpy.array([3.9218626642862979, -7.8658895900930066]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-10.802533839373282, 3.5697355139501941]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_taggedData_rank2(self):
      arg0=Data(0.654058548902,self.functionspace)
      arg0.setTaggedValue(1,0.1725176172)
      arg1=Data(numpy.array([[0.8989324988462144, -3.3278840675671484, -2.4140998582875772, -0.95896368060472614, 
0.18211566459683048], [4.3037596802718472, -0.88736460044670729, 2.3682161590270798, 2.1970096163954747, -4.8514034562002468], 
[-0.98633171015110754, -1.4814425809340994, -0.51275967160949065, -1.3854811808572576, -0.69869900021535614], 
[-1.1256572499516535, -2.868454246407607, -3.6897036122280147, -1.9028111479878476, -0.94932567632544362]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[0.74788680809310115, 2.1282151256990716, 1.775511434964784, -3.1970823068074141, 
0.45462100854116905], [4.4983288376995816, -0.14856222667584795, 1.898446692676556, -2.0005540220267006, 3.3381306620499078], 
[-1.9212747911637318, 3.013913690485138, 2.0135772843934081, 0.13281897249513719, -2.1152931733924216], [2.74514833456535, 
1.8699118618738453, 3.6953901619290246, 2.3463011918098431, -1.0346270658051724]]))
      res=arg0*arg1
      ref=Data(numpy.array([[0.58795448575615294, -2.1766310241468663, -1.5789626502159602, -0.62721839338599394, 
0.11911430731851599], [2.8149108113012966, -0.58038840291512628, 1.548952024459386, 1.4369729216232396, -3.1731019047002067], 
[-0.64511868707740572, -0.96895018476730699, -0.3353748467483405, -0.90618581068244897, -0.45699005420009453], 
[-0.7362457474643308, -1.8761370219969773, -2.4132821904921142, -1.2445498982873728, -0.62091457429277574]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[0.12902365006777231, 0.36715460237527625, 0.30630700207203954, -0.55155302156370678, 
0.0784301331227273], [0.77604097246340176, -0.025629601352090609, 0.32751549980238132, -0.3451308129605562, 
0.57588634772016567], [-0.33145374895860302, 0.51995320832990877, 0.34737755515223512, 0.022913612653855466, 
-0.36492533795375687], [0.47358644954063189, 0.32259273878508343, 0.63751990536148773, 0.40477829084529726, 
-0.17849139608366357]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_taggedData_rank3(self):
      arg0=Data(-1.54125663924,self.functionspace)
      arg0.setTaggedValue(1,1.08570842055)
      arg1=Data(numpy.array([[[-2.2770786316341871, -2.1460169655833172], [4.8123782369809174, -2.2852073426872566]], 
[[-1.7994705604766703, -2.0158566453432005], [-4.8171620683622365, 4.7577923462909482]], [[4.3906932460407404, 
1.4886995147677045], [1.3722539055863816, 1.1764964634857966]], [[4.1077975065284651, -0.087591280770782376], 
[-2.8425290770991243, -3.3652982671733014]], [[-0.74730716158883403, 0.46607631672562189], [2.6752511106890662, 
4.8256111214667445]], [[-0.16000978564141732, 2.5358637912087554], [2.1952209336157367, 
0.17205045521583173]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[-2.7325661859534565, 3.4691259661138254], [-3.1465219830597526, 
-0.19620628443754118]], [[0.4064669836819732, -3.434705563588202], [1.5759971465889286, -2.4670170155868187]], 
[[3.0860505079499294, 3.2426839426387737], [-1.789143534604273, 0.68158308502557574]], [[-1.3913333520292257, 
2.8487002965109944], [-4.6617529714600092, -3.9780897472663455]], [[1.3297271827720429, -4.3030558655490792], 
[4.8015031019433643, 4.5790569364688611]], [[2.1248456212909703, -3.9920311788315264], [-4.2933405923153733, 
-2.8802355533519997]]]))
      res=arg0*arg1
      ref=Data(numpy.array([[[3.5095625590839155, 3.3075628961328003], [-7.4171099082940071, 3.5220909889629444]], 
[[2.7734459484564837, 3.1069524383967617], [7.4244830201714835, -7.3329790418591152]], [[-6.767185116338454, 
-2.2944680109731381], [-2.1149954427117614, -1.8132829853930625]], [[-6.3311701796016813, 0.1350006430277414], 
[4.3810668123195029, 5.1867882973128667]], [[1.1517921243524216, -0.7183432175471568], [-4.1232485359909798, 
-7.4375051793641207]], [[0.24661614446363866, -3.9084169044157053], [-3.3833988385398532, 
-0.26517390638613264]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-2.966770117793823, 3.7664592733507636], [-3.4162054124467005, 
-0.21302281517823304]], [[0.44130462685817901, -3.7290887524900502], [1.711073372810888, -2.678461147457285]], 
[[3.3505510227170197, 3.52060926169802], [-1.9424882010884936, 0.74000049471520712]], [[-1.5105823360871113, 
3.0928578995389699], [-5.0613044556278082, -4.3190455363018971]], [[1.4436959993668959, -4.6718639873141896], 
[5.2130323490662391, 4.9715206740920044]], [[2.3069627833997046, -4.3341818659467046], [-4.6613160333564325, 
-3.1270959934353866]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_taggedData_rank4(self):
      arg0=Data(-4.74467900163,self.functionspace)
      arg0.setTaggedValue(1,-2.44505771366)
      arg1=Data(numpy.array([[[[0.57462551893286751, 3.2283279796524091, 1.67588749300874, -4.5342417200560874], 
[0.80984208476713082, -3.4668120846913641, 4.6214701028878871, -0.20725197887660674], [2.124820301332444, -1.4135887630200363, 
-0.25533129849841263, -2.1142574718795237]], [[-2.4976601583407119, -3.9919359456446912, 3.9570976867723964, 
3.6791858352447537], [3.8676141422016119, 1.2414864411901068, 1.95462144151867, -0.15271679325112508], [3.9732173021559394, 
0.84136830548135499, -0.65139380235915834, 4.6379037969393515]]], [[[2.616969981095747, 3.4377149732422705, 
-2.9106449073247607, 0.72156202111654721], [1.7014641223422187, 3.5159672015216099, 4.3574686381919818, -2.0914090270603767], 
[4.6445228689637403, -4.1196691559269976, 4.5345986538506793, -3.074987810357527]], [[4.0018688502739046, 4.9301895185184925, 
-0.84309097038138425, -1.2088704416240805], [-0.75129072617984072, 3.5824548432045287, -4.2745378467592845, 
-3.0743085908558978], [-0.42373047745432846, 0.90072919268893159, 4.3148752470634708, 4.4927376734211784]]], 
[[[-2.5747188107033239, 2.8671121375423025, 1.155946350336361, 2.4938260152308818], [4.710938612563714, -0.79337062868579533, 
-2.4030421103748956, 4.7824950534375237], [-3.0678239944772869, 1.8788111562302685, 3.4275484327606485, -2.2902037608094372]], 
[[0.043051577558484766, -1.6696594766262485, -4.2463825369620389, -4.3849432675853492], [-2.7940357979785535, 
2.7530622022254239, 0.6570614748679402, -4.0229739052949824], [-4.9516112387129132, -3.2516295651747109, -3.0457038901088507, 
-2.6626333045286907]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[-2.6882092787739795, 3.6329986565329691, 1.0478349039456214, 2.2617437593970591], 
[3.730198631533197, -1.6242246318044176, 0.50706479867507426, -3.934785010903834], [2.355968794971651, 3.6502549564072577, 
0.57297647219744086, 3.7315697185556402]], [[0.60046085671603944, -1.5056550836002938, -2.7429338126725678, 
2.9186213701638843], [0.41021572855453581, 0.52862624631844124, -2.8513507813438013, 0.098239565640505511], 
[1.3487264380856976, 0.072841584459576225, 1.4568465057334548, 1.3726680324077636]]], [[[2.8706650903203652, 
0.59686052914704568, -1.4053822125188828, -2.6246185555431989], [-1.3665002953631733, 1.6507151884485776, -1.276703739492171, 
-3.1239365160214683], [-0.65050162738626582, -1.081107329715941, -4.5828318815154798, 0.94173229224798938]], 
[[4.7762275962092708, -0.51244108178484993, -1.3818852495333944, 2.988460367243313], [-0.3409534577725335, 2.4798056473422285, 
4.4971017496106516, -2.1990464382938599], [-4.7777277081516285, 2.7926958052888793, -1.416499850245442, -2.0954204496076825]]], 
[[[0.34593024880876211, -0.68675131339532758, 2.9662640572488037, 2.6783766407383673], [-3.564742905325665, 
-3.3386860856421965, -0.68755006002669106, -0.78019958039247506], [-4.6343899878869985, -4.2168301853658727, 
-2.2456505981955024, -0.41515210751541876]], [[-0.55788332628338466, 3.9630128065823662, -1.0118691818735162, 
-3.0981745142102959], [2.1472063344776027, 4.012163339668648, 1.9479027288120419, -0.68858281819862288], [1.9522838311551602, 
-0.23915064553317755, 4.3595002908910043, -4.1264020430601196]]]]))
      res=arg0*arg1
      ref=Data(numpy.array([[[[-2.7264136334810845, -15.317379975428949, -7.951548197171646, 21.513521477461385], 
[-3.8424407342302564, 16.448910500829623, -21.927392153829505, 0.98334411222194373], [-10.081590265967572, 6.7070249208402251, 
1.2114650504441471, 10.031473030864509]], [[11.85059570648515, 18.940454657149349, -18.775158301824646, -17.456555775577538], 
[-18.350587606908292, -5.8904546483221196, -9.274051309707918, 0.72459216213476796], [-18.851640702449284, -3.992022531653765, 
3.0906544958449289, -22.005364756914688]]], [[[-12.416682517199073, -16.310854047129041, 13.810075772982891, 
-3.4235801699648394], [-8.0729010933026579, -16.682135751476721, -20.674789947887476, 9.9230644945112179], 
[-22.036770128959077, 19.546507737786502, -21.51521501374156, 14.589830094069249]], [[-18.987583101168763, -23.392166682567289, 
4.0001960236317773, 5.735702200064047], [3.5646333326242772, -16.997598268837518, 20.281309963188264, 14.586607415562371], 
[2.0104650987278863, -4.2736708867056352, -20.47269797939185, -21.316598098910092]]], [[[12.216214276243884, 
-13.603526754313302, -5.4845943754508948, -11.832403928182698], [-22.351891512995461, 3.7642889624348856, 11.401663441126592, 
-22.69140385544075], [14.555840087290736, -8.914355840992517, -16.262617075986675, 10.866281693364863]], 
[[-0.20426591602875549, 7.9219982586198361, 20.147722056008906, 20.805148245047732], [13.256802980469253, -13.062396421078134, 
-3.1175457825854576, 19.087719812555502], [23.493805868552535, 15.427938518961282, 14.450887292579969, 
12.633340329035965]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[6.5728268330077837, -8.882891388884623, -2.5620168145379658, -5.5300940252437858], 
[-9.1205509375268186, 3.9713229647154504, -1.2398026973276579, 9.6207764425174567], [-5.760479675295648, -8.9250840380015415, 
-1.4009605430939827, -9.1239033244271468]], [[-1.4681614494664723, 3.6814135762733757, 6.7066314767431594, 
-7.1361976943819814], [-1.00300113136831, -1.2925216812058213, 6.9717172222847594, -0.2402014077562577], [-3.2977139810631666, 
-0.17810187795834925, -3.5620737864671215, -3.3562525609377336]]], [[[-7.0189418224319855, -1.4593584407721891, 
3.4362406193645985, 6.4173438446549307], [3.3411720879010107, -4.0360939045774904, 3.1216143263082121, 7.638205075492988], 
[1.5905140217913694, 2.6433698158199781, 11.205288442321875, -2.3025898053668405]], [[-11.678152126323369, 1.252948019816053, 
3.3787891887692671, -7.3069580729055525], [0.83365088192693371, -6.0632679264201208, -10.995673322014595, 5.3767954566543787], 
[11.68181998659939, -6.8283024206369323, 3.4634238852456369, 5.1234239336812468]]], [[[-0.84581942323935522, 
1.6791465961857013, -7.252686813938614, -6.5487854655331503], [8.7160021378933159, 8.1632801672000408, 1.6810995777979791, 
1.9076330022355517], [11.331350988007433, 10.310393171937397, 5.490745317310691, 1.0150708628241825]], [[1.3640569302533725, 
-9.6897950320809656, 2.4740785483580918, 7.575215494245171], [-5.2500434109413288, -9.8099709221342462, -4.7627345925478251, 
1.68362473113261], [-4.7734466406262159, 0.58473713058847199, -10.659229813960788, 10.089291145060466]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_expandedData_rank0(self):
      arg0=Data(-2.22153518466,self.functionspace)
      arg0.setTaggedValue(1,4.69811369693)
      arg1=Data(-0.562826705043,self.functionspace)
      arg1.setTaggedValue(1,-4.43591643677)
      arg1.expand()
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*(1.25033932812)+(1.-msk_ref)*(-20.84043977)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_expandedData_rank1(self):
      arg0=Data(-1.5457449423,self.functionspace)
      arg0.setTaggedValue(1,2.82703183318)
      arg1=Data(numpy.array([2.2716081265967025, -2.9898915773500745]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([-0.012206473173464794, 3.9964849502775941]))
      arg1.expand()
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-3.5113267725853539, 4.6216097837286236])+(1.-msk_ref)*numpy.array([-0.034508088232212457, 
11.298190175249657])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_expandedData_rank2(self):
      arg0=Data(4.54003329753,self.functionspace)
      arg0.setTaggedValue(1,2.98678553946)
      arg1=Data(numpy.array([[0.7806767811932076, -0.5806864615498144, -0.06668079884937228, 0.9984699402250472, 
2.325215152817858], [2.3410093404432883, 2.0500262341602156, -1.8185004975365828, 0.96411959842396566, 1.5240499389985569], 
[-0.32078568648105232, -4.4164673737677003, -1.2510543799215657, -4.1032611257955534, -3.9555099635330415], 
[-4.3478334514743402, -0.29069180904764202, -2.5538661678923171, -4.9707109114744297, 3.7567090380849475]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[-2.9523242815073703, 3.9983698954863325, -1.5482464874395454, -1.3224686417806639, 
-3.4162019006071875], [1.7905804576917648, -4.9051519230409752, 2.1127184574115638, -3.0653776908518471, 0.96181666995017423], 
[-2.5373501916078967, -2.8751261520435287, -3.9489642086747931, 4.2368003889137267, -0.025684158297478277], 
[-3.3813535442343934, 1.9665471383296582, 2.8491679513752164, -2.3458635583090102, 3.5459706882628943]]))
      arg1.expand()
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[3.5442985812248211, -2.6363358708603744, -0.30273304708197479, 4.5330867752033734, 
10.556554217711751], [10.628260355438623, 9.3071873638950908, -8.2560528103888995, 4.3771350796449653, 6.9192374701502892], 
[-1.4563776979946337, -20.050908934355235, -5.6798285418632393, -18.628942139567602, -17.958146943147209], 
[-19.739308641803369, -1.3197504923951984, -11.594637439663572, -22.567193050483983, 
17.055584122033306]])+(1.-msk_ref)*numpy.array([[-8.8179594717917791, 11.942273385235778, -4.6242802201983677, 
-3.9499302156548355, -10.203462436596507], [5.3480798182667177, -14.650636832574804, 6.3102369375391749, -9.155625760008089, 
2.8727401214151458], [-7.578520860831012, -8.5873852150361056, -11.794709194300168, 12.654414135170137, -0.076713072596013385], 
[-10.099377869708427, 5.8736545554220942, 8.5098536366496855, -7.0065913534947368, 10.59105397503934]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_expandedData_rank3(self):
      arg0=Data(-4.41284591178,self.functionspace)
      arg0.setTaggedValue(1,0.0736469151232)
      arg1=Data(numpy.array([[[-2.9265126812506912, 1.415139545433628], [3.4730061001948851, -2.710581251982791]], 
[[-1.590831811533624, -0.55871061700777958], [-2.2898865302605085, 2.8636774864644376]], [[-2.7476177401678648, 
-4.9860835009420166], [0.98076414280220447, -2.8734975793062132]], [[4.3325905935230438, -4.2574975131879009], 
[4.1006148120269739, 1.5269360791132867]], [[-2.5858279812083387, 4.8750832169823948], [-2.7934231724923722, 
-2.2101722799968995]], [[-3.7634678514803035, -1.6756403963325384], [-1.9347878877304225, 
-3.808061649560913]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[-4.7258601702171514, -4.7936282417750853], [0.90282871055929803, 
4.2131039130666998]], [[-3.217176071073411, -3.6261606403500677], [-1.3107407162171034, 2.4212454742728182]], 
[[3.7844567788747216, 0.39960537946041796], [4.269030376754209, -4.886993952159715]], [[2.1194399496357255, 
2.8374375020432474], [-1.8415129567457269, -3.160498890440917]], [[-3.690965416459937, 4.1410882662465731], 
[-0.76973072875469839, -3.1793861057965422]], [[-4.5376562287182427, 2.0508613156218463], [2.807963454808692, 
0.53344719462163237]]]))
      arg1.expand()
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[12.914249521221418, -6.2447927576611137], [-15.325840770822481, 11.961377396352344]], 
[[7.020095655851363, 2.4655038621293301], [10.104916413493898, -12.63696748879317]], [[12.124813711826432, 22.00281819291202], 
[-4.327961037982436, 12.680302045343273]], [[-19.119054688032772, 18.787680495473076], [-18.095381309026504, 
-6.7381336342602642]], [[11.41086043543446, -21.512991043634688], [12.326946026596826, 9.7531497101077402]], 
[[16.607603722510003, 7.3943428725648674], [8.5379208205273525, 
16.80438928206064]]])+(1.-msk_ref)*numpy.array([[[-0.34804502283993238, -0.35303593225402019], [0.066490549417317843, 
0.31028210629070091]], [[-0.2369350930426235, -0.26705554490282596], [-0.096532010275718547, 0.17831725993611955]], 
[[0.27871356718107604, 0.029429703463881862], [0.31440091781503371, -0.35991202880213108]], [[0.15609021407946905, 
0.2089685188802666], [-0.13562174842366262, -0.23276099353116186]], [[-0.27182821674856528, 0.30497837606179917], 
[-0.056688293648289818, -0.23415197867737056]], [[-0.33418438313451698, 0.15103960924098625], [0.20679784622524713, 
0.039286740264990259]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank0_expandedData_rank4(self):
      arg0=Data(-2.79628244153,self.functionspace)
      arg0.setTaggedValue(1,-0.548556750075)
      arg1=Data(numpy.array([[[[-2.6809019766816999, -0.7244253880463063, 0.93729944966109624, 1.5565250856764319], 
[4.185510640105754, -4.8635085561907987, 1.9415110464407705, 4.2114740531067252], [2.4668477289433435, -4.6813669805705382, 
4.567327498485696, 4.6561230083968894]], [[2.4539479900359007, -3.0968146366065872, 0.58991141066483088, -1.5507096658258224], 
[-3.5305650850407355, 0.21298034086276729, 2.2371711073176748, -3.371622636269096], [-3.0126624143261749, -1.7367006455589062, 
0.31266481769587795, 4.7457353918135396]]], [[[0.74122215047587758, 0.64199484645201643, -0.60059203636507963, 
3.2738050009967345], [-0.97157059985295913, 4.5548394372453149, -1.3102073380243873, -4.9906655221473084], [2.6398326032387871, 
-3.7088749937100349, 4.7457361222110102, 1.076800881023642]], [[-3.2364684687441225, 3.4999109394926258, 3.3980005282726573, 
-2.3029509076538557], [-1.6484621998164863, 3.0434015505538774, -3.3060211933232764, -2.8734937870095667], [4.5642679318723953, 
4.3515697684652679, 2.4887519594030936, -4.7399358947089398]]], [[[-2.6367585800089763, -3.8120927455754039, 3.281096531909478, 
-0.75572814648750786], [-2.5821469746186523, -1.0166223592469379, -1.3825886591032344, -4.6525308744409557], 
[3.4378445293294462, 4.8980879259267187, -3.3434703318321612, -0.62160742741957264]], [[-4.0687428816696167, 
4.8876739753523548, -1.3194379757124475, 4.1633095653093175], [-2.5359168513483512, 0.022787464782540567, -2.1482416631875245, 
-2.9055505732185596], [4.0453721735412707, -4.9729319110352135, -2.4366346683445137, 
-3.9573237575540476]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[2.916583713835605, -3.8625829355903663, 0.027038927869477369, -1.7426984438897919], 
[4.2250304662761469, 2.9361135457363119, -2.9295852137394829, 0.92606122117822043], [4.1331359524915463, -0.48997581025813552, 
-3.0931698790312989, -2.8546285893930703]], [[1.3868011276230519, 3.983340932997141, 1.0403756476034669, -3.5726214057133876], 
[1.4348559142320392, -3.4077223481986518, -0.60697090065497949, -1.4760801179502039], [-2.8837770702185961, 3.4532032682401343, 
2.0502890785183556, -2.2842186450813227]]], [[[1.7432334919452144, 4.6903020438607506, 2.3792084667587883, 4.3494327627815803], 
[-0.42558467044109793, -3.4981055127107421, -4.4161140236008869, -2.8975833849140642], [-0.84418034480826343, 
-3.7924343983855993, 2.5521572008999609, -3.3306181701459181]], [[4.5549821783944182, -2.6705606959859587, 4.975450671737125, 
2.4538872085158205], [4.9659679736221882, 2.2156401035031621, -0.97616024835165316, -1.8402729036950625], [1.6093488091276207, 
-1.6243734283097422, 0.95208250883124013, 3.4489019152227698]]], [[[-4.7854735586906463, 1.8220383646197202, 
-2.1193203874750974, -1.1948487225055491], [-1.8696542408824399, -0.84689669779397825, -1.1391555054103373, 3.643465732682353], 
[0.74094867726507552, 2.4538882973775342, 1.1577215960335447, 1.2566525728924551]], [[-4.0872245606489246, -3.3007699001460598, 
-0.089480160766855832, -2.3614088509724884], [-4.6293694942466992, -2.6901844897243734, 2.2829836924097124, 
0.41331312281774579], [-0.48638090009451851, -3.0155411873592417, 2.5449975277081984, 1.4350840292847309]]]]))
      arg1.expand()
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[7.4965591248677068, 2.0256979927950374, -2.6209539935464119, -4.3524837668835596], 
[-11.7038699117797, 13.599743579924668, -5.4290132492058154, -11.7764709476766], [-6.8980029903812614, 13.090424290144473, 
-12.771537688749044, -13.019835014000735]], [[-6.8619316769740122, 8.6595683930271967, -1.6495589197023723, 4.336222210465154], 
[9.8724571559909222, -0.59555318754639319, -6.2557622860986521, 9.4280091772764365], [8.4242550114484498, 4.8563055213764041, 
-0.87429913980828156, -13.27041654829269]]], [[[-2.0726664846514584, -1.7951989166888209, 1.6794249658125702, 
-9.1544834412919958], [2.7167858090790782, -12.736617542373772, 3.6637097740860476, 13.955310371147538], [-7.3817175570245048, 
10.371062022754341, -13.270418590690312, -3.0110393966343008]], [[9.050079951726266, -9.7867395070345289, -9.5017692135306646, 
6.4397011867862997], [4.6095659048786626, -8.5102103183498823, 9.2445690142277748, 8.0351002224706871], [-12.76298227634957, 
-12.168218136667779, -6.9592534054111663, 13.254199516369372]]], [[[7.3731217198421186, 10.659688009950042, 
-9.1748726211552007, 2.1132293465957361], [7.2204122465851945, 2.8427632528326567, 3.8661083913138321, 13.009790392892121], 
[-9.6131842940862082, -13.696437264356518, 9.3492873826907275, 1.7381899348202108]], [[11.377354279127493, -13.667316917218427, 
3.6895212441773282, -11.641789436143251], [7.0911397646145184, -0.06372018765848303, 6.0070904429421716, 8.1247400508788896], 
[-11.312003178341994, 13.905722185769804, 6.8135187395237642, 
11.065794938712077]]]])+(1.-msk_ref)*numpy.array([[[[-1.5999116833840921, 2.1188459420436092, -0.014832386397599885, 
0.9559689947413974], [-2.3176689815494043, -1.6106249045010601, 1.6070437439174672, -0.50799713386025125], 
[-2.2672596257179776, 0.26877953809069516, 1.6967792162720949, 1.565925781669387]], [[-0.76073911956960749, 
-2.1850885566466665, -0.57070508410680199, 1.9597855875674435], [-0.7870998971373937, 1.8693290964866867, 0.33295798465354914, 
0.80971371235347056], [1.5819153775806685, -1.8942779621750749, -1.124699913626829, 1.2530235564071246]]], 
[[[-0.95626249896381399, -2.5728968460516035, -1.3051308642767436, -2.3859107010223237], [0.23345734369901933, 
1.9189093914729565, 2.4224891567482834, 1.5894889247005306], [0.46308082642543352, 2.0803654884520286, -1.4000030598068554, 
1.8270330791568548]], [[-2.498666220430771, 1.4649540962687824, -2.7293170506478872, -1.3460963921546909], [-2.724115252588013, 
-1.2154043345141077, 0.53547929338844169, 1.0094941233025256], [-0.88281915247253784, 0.89106100874220073, 
-0.52227128684796531, -1.8919184259429431]]], [[[2.6251038229264307, -0.99949144380823562, 1.1625675041215806, 
0.65544233204922042], [1.0256114541428989, 0.46457090019133446, 0.62489144187823509, -1.9986477213308083], 
[-0.40645239837309266, -1.3460969894571337, -0.63507599621210453, -0.68934525135959912]], [[2.2420746218173573, 
1.8106596091703635, 0.049084946186478233, 1.2953667648884226], [2.5394718846615203, 1.4757188607860745, -1.2523461147830892, 
-0.2267257034163595], [0.26680752585452888, 1.6541954734558768, -1.3960755727491811, -0.78722503118934151]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank1_float_rank0(self):
      arg0=Data(numpy.array([2.1952806579129742, 2.6884774478756199]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-3.6051247624491434, -0.31421820317847526]))
      arg1=0.626614133252
      res=arg0*arg1
      ref=Data(numpy.array([1.375593886703014, 1.684637965768125]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-2.2590221282873846, -0.19689356703668046]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank1_array_rank0(self):
      arg0=Data(numpy.array([3.2122627302865183, -4.847095924140068]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([2.9370723087704711, -4.2178567696345954]))
      arg1=numpy.array(4.52616312843)
      res=arg0*arg1
      ref=Data(numpy.array([14.539225128654049, -21.938746851808116]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([13.293668389490893, -19.090707791720718]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank1_array_rank1(self):
      arg0=Data(numpy.array([-0.20883330151686419, 4.2213892778139428]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([4.0742747673854751, 2.2348116931110855]))
      arg1=numpy.array([-0.9174792888043859, 2.8142246343646784])
      res=arg0*arg1
      ref=Data(numpy.array([0.19160022895436443, 11.879937696866916]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-3.7380627159744804, 6.2892621199194529]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank1_constData_rank0(self):
      arg0=Data(numpy.array([-3.2350089253355674, 2.9543163332728497]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-4.2840504995547892, 3.5015438188050751]))
      arg1=Data(-3.00759489945,self.functionspace)
      res=arg0*arg1
      ref=Data(numpy.array([9.7295963435274366, -8.8853867353250831]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([12.884688431464369, -10.531225329652845]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank1_constData_rank1(self):
      arg0=Data(numpy.array([-0.58315848196382092, -2.4134417406043864]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-3.4226636871386407, 3.8532628186902347]))
      arg1=Data(numpy.array([2.824639323240099, -3.0252609130101682]),self.functionspace)
      res=arg0*arg1
      ref=Data(numpy.array([-1.6472123798360105, 7.3012909636776753]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-9.6677904409177522, -11.657125392938953]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank1_taggedData_rank0(self):
      arg0=Data(numpy.array([-0.5004196078421046, 4.9468639816670184]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-1.0996920633843779, 3.8951695653030605]))
      arg1=Data(1.70727137898,self.functionspace)
      arg1.setTaggedValue(1,2.97487288276)
      res=arg0*arg1
      ref=Data(numpy.array([-0.85435207394787749, 8.4456392915938654]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-3.271444098744869, 11.587634313558997]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank1_taggedData_rank1(self):
      arg0=Data(numpy.array([-3.3661646388796749, 4.8926845850811471]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([0.36118877989666753, 3.7712786481015783]))
      arg1=Data(numpy.array([-0.70712349183095746, -0.37464270283337964]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([3.9060632340308139, 2.3846072004866841]))
      res=arg0*arg1
      ref=Data(numpy.array([2.3802940935224894, -1.8330085770660136]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([1.410826213698821, 8.9930182193047106]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank1_expandedData_rank0(self):
      arg0=Data(numpy.array([-2.150487563359369, 1.7174846136358379]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-1.0060565918834552, 3.0878917411591758]))
      arg1=Data(-4.75469453034,self.functionspace)
      arg1.setTaggedValue(1,-4.06790999956)
      arg1.expand()
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([10.224911455060154, -8.1661146983903734])+(1.-msk_ref)*numpy.array([4.0925476702431878, 
-12.561265691411638])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank1_expandedData_rank1(self):
      arg0=Data(numpy.array([-2.8073118301266939, 3.6266676408707408]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-1.0653786792957454, -0.6345243407497394]))
      arg1=Data(numpy.array([4.3448785422004406, 3.5991719188225133]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([2.5735141554828171, 4.5086814811965965]))
      arg1.expand()
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-12.197428931982921, 13.053000331924261])+(1.-msk_ref)*numpy.array([-2.7417671121171892, 
-2.8608681445068291])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank2_float_rank0(self):
      arg0=Data(numpy.array([[-4.3448615713416059, 3.3620388985425222, 2.6688790375841451, -3.6552017545464031, 
1.2616710217268032], [0.84834384600194124, 3.0199836720360462, -3.6730134462209652, 1.1913199361227811, -0.46486234623915657], 
[1.9947587697214768, -0.3462306580415202, -3.5987855083235631, -0.095746585808083928, -2.0443254339037455], 
[0.42343449532836352, 4.4539207072035918, 3.3364644915649819, -4.9532435109307169, 3.1850208678869194]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[4.078962917769358, 3.6045934913068258, -1.3152447454233807, 4.4740273634264849, 
-3.1270169543065474], [-1.5114883455518613, -2.0396717759319705, -0.81607702547454064, -4.1221256705285452, 
4.3360374000620308], [1.7348416865924454, 1.4352128392841141, 1.0487233819999, 4.0784654827843045, -2.373069786356937], 
[-1.2245535989378409, 3.7324232931013075, 3.3211880782305165, 0.86634811060468575, -1.2072355705248592]]))
      arg1=0.796007563642
      res=arg0*arg1
      ref=Data(numpy.array([[-3.4585426737641569, 2.6762083924975171, 2.1244479003618078, -2.9095682432554137, 
1.0042996761221092], [0.67528811798644972, 2.4039298450151811, -2.9237464845496195, 0.94829967987090169, -0.37003394365860359], 
[1.5878430683389428, -0.27560222256569916, -2.8646604845497601, -0.076215006496105547, -1.6272985079325177], 
[0.33705706098819094, 3.5453545707945273, 2.6558509711077436, -3.9428192992601074, 2.535300701194696]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[3.2468853343584985, 2.8692836829339394, -1.0469447653970365, 3.5613596212274938, 
-2.489129147263899], [-1.2031561554155878, -1.6235941609883833, -0.64960348479196905, -3.2812432120224089, 3.4515185666827448], 
[1.3809471042485408, 1.1424402755058598, 0.83479174423984281, 3.246489372347976, -1.8889814989897569], [-0.97475392683920781, 
2.9710371720211683, 2.6436908305481919, 0.68961964878804127, -0.96096864523511216]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank2_array_rank0(self):
      arg0=Data(numpy.array([[3.1397930164632957, -0.74954277925408519, -0.32571383358208283, -3.8320545292303199, 
2.9670771807380083], [4.5628121077446195, 1.2490897077519598, -1.8362782671706679, 0.5204678116185697, -3.7963331885953444], 
[2.7854970070648974, -4.3183003344928768, 0.21468681811062496, 3.8199132307304993, -3.9336360289485519], [-3.6545036951111065, 
-3.5205962261399968, 2.3897187701383888, 1.7502996338293064, 4.3279482257991013]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-2.5471898953292693, -4.9128733692998328, 4.6852225120369688, -1.1377777271632428, 
-1.6315161473916118], [-4.4741295721420098, 2.1262109896762702, 0.88235699514083077, 0.78973340071480536, -2.8042651335933479], 
[4.1625690439075349, 1.5106989326593148, 4.9154856836077752, 4.3679790513267118, -1.0895713812478047], [2.7141091343733139, 
-0.69759011584656783, -1.6848024437156282, 1.0281102104596158, -3.0637939833745809]]))
      arg1=numpy.array(-1.90702806016)
      res=arg0*arg1
      ref=Data(numpy.array([[-5.9876733854743582, 1.4293991123241399, 0.62114542022170283, 7.3078355152864543, 
-5.6582994403131064], [-8.7014107226841784, -2.3820491223338531, 3.5018341817473475, -0.99254672116410281, 7.2397139163491993], 
[-5.3120209539506575, 8.235119910054836, -0.40941378628236424, -7.2846817183605781, 7.5015542856417543], [6.9692410925171799, 
6.7138757917249325, -4.5572607505331133, -3.3378705153915891, -8.2535187094971327]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[4.8575626049363105, 9.3689873712432448, -8.9348507985246108, 2.1697740519197359, 
3.1113470736718591], [8.5322906388443016, -4.054744019122678, -1.6826795488076536, -1.5060437552048027, 5.3478122978769527], 
[-7.9381359690644295, -2.8809452550275911, -9.3739691279304349, -8.3298586170494566, 2.0778431975814549], [-5.1758822775730309, 
1.3303239254062138, 3.212965535983495, -1.9606350202783971, 5.8427410968295277]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank2_array_rank2(self):
      arg0=Data(numpy.array([[-1.5567048977592721, 3.405009177310232, -2.6255202248801881, -2.7415225788207289, 
-4.9626201006286834], [4.4949981787136082, -1.808671563429157, 1.4089858207305657, 0.87325106524519747, 0.092772157158559132], 
[-2.7917426953644076, 3.7964403092700731, 4.1675448083075111, 4.1027906609665195, -4.5272271261338375], [1.8045675702002297, 
-4.1211603186859405, 2.9453023490808423, -4.4927583568818044, 2.7215071600984766]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-0.27335454464858078, -2.0759419237521346, -3.7211813282235759, 3.4365173658696975, 
2.5826327099704134], [-2.1545139356548182, 2.0932323069762306, 1.4021298838581222, 2.1735629708102833, -1.1330635840788936], 
[-1.9156996022986483, 0.12626545060279426, -1.7875176847174226, 1.565202675898794, -1.8349024659561621], [-4.3364746046079645, 
1.2485627003123509, -2.3695449662869015, -1.2732107419273309, 2.7771896161923451]]))
      arg1=numpy.array([[4.4909694804526925, -4.5508173739757565, -1.9895148084903114, 4.7287607725768304, 
-4.6983463261777452], [3.4869944490676232, -2.9096638901072023, -4.0765038203579005, -1.099473062727073, -0.26810160862572197], 
[3.2915946999607311, 4.5905663188733108, -2.7920359744625092, 1.6429913736498092, -2.5086203364741646], [0.60170604566733132, 
-4.4860092937673031, -3.084397720711519, -3.2712142994395621, -2.5034225779677568]])
      res=arg0*arg1
      ref=Data(numpy.array([[-6.9911141859081205, -15.495574922650301, 5.2235113673899463, -12.964004427861134, 
23.316107918004608], [15.674033697743427, 5.2626263371735567, -5.7437360810382625, -0.96011602323481637, 
-0.024872364569887992], [-9.1892854597155704, 17.427811015348173, -11.635935029979033, 6.7408496638589908, 11.357094036456832], 
[1.0858192168046845, 18.48756349073015, -9.0844838523112319, 14.69677538095835, -6.8130824706914366]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-1.2276269173598191, 9.4472325739758691, 7.4033453575784502, 16.250468514003686, 
-12.134102904755967], [-7.5127781340671893, -6.0906024572145325, -5.715787828185614, -2.3897739365469377, 0.30377616956677733], 
[-6.3057066576431113, 0.57962992477454911, 4.9908136807189774, 2.5716144945153165, 4.6030736415442215], [-2.6092829864754625, 
-5.6010638774524066, 7.3086190931387716, 4.1649451851927388, -6.9524791884735251]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank2_constData_rank0(self):
      arg0=Data(numpy.array([[-0.71632597842697443, 0.99936748095127559, -0.23365138989519085, 2.6932576448783649, 
-0.053054450017278931], [3.7857185772859623, 1.1380288181827414, 0.060635823406853362, -4.0519997612453205, 
-4.6730356598285736], [-2.9581813803718293, 4.6361543270464374, -4.3235673307397011, -3.9528228296500725, -1.3118375987593556], 
[-2.7229607012152082, -4.6270280909793353, -4.5198926488096172, 2.6294018640163639, 3.6927190942927002]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-2.1015028100386566, 4.9202957589934684, 1.3720001145391549, -4.9051651000162622, 
-4.6089303356323299], [4.9318255493307603, 2.5027207643951925, 2.9993322107681122, -1.8199182630341171, 0.83091689947804959], 
[-4.2392314732588563, -1.6435856318125621, 4.8103176280939604, -3.8825754413146574, -4.6741266382128401], [-4.8611905992454743, 
2.7804021268222865, 3.9842815315020985, -3.7132775935027529, 3.6546911601480296]]))
      arg1=Data(0.627190968639,self.functionspace)
      res=arg0*arg1
      ref=Data(numpy.array([[-0.44927318427102064, 0.62679425840432523, -0.14654404155225487, 1.6891868710861315, 
-0.033275271896955998], [2.3743685014833114, 0.71376139681533191, 0.038030240816778471, -2.5413776551811682, 
-2.9308857619733009], [-1.8553446453657867, 2.9077541231409691, -2.7117023821433359, -2.4791747793872831, 
-0.82277269426317279], [-1.7078163597615803, -2.9020302303020133, -2.8348358485520011, 1.6491371020340819, 
2.3160400656618245]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-1.3180435830260984, 3.08596506307435, 0.86050608081087498, -3.0764752504142874, 
-2.8906794815957304], [3.093196443444203, 1.5696838604544034, 1.8811540745423379, -1.1414362982364972, 0.52114357504229991], 
[-2.6588076939989094, -1.0308420644579552, 3.0169877726263614, -2.435116251852822, -2.9315700137628933], [-3.0488948406804326, 
1.743843103128099, 2.4989053930739864, -2.3289341706951454, 2.2921892888102819]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank2_constData_rank2(self):
      arg0=Data(numpy.array([[0.32780667421761134, -4.002023898476331, -3.6993632285700873, -0.6514005312305029, 
4.7510196033223178], [4.1434540241262994, -2.7741034563651512, 2.5543272023397385, 1.1594691692541961, 0.24933127135005329], 
[0.77757139265418651, -1.4039909762938541, 4.2210850630401158, 0.47583243250924223, -4.8990608473250905], [-3.0543501436313991, 
4.2912419622927125, -2.9272230845932832, -0.64480562714739431, 4.6861029219159445]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[3.7398512717589636, 3.9042403169138034, -2.228875443710038, 2.9084558495842998, 
1.5263280385354552], [-2.2199292278153102, 4.4422995944863271, -4.4074188006647113, -1.2511140667742406, -3.2066651260120294], 
[-4.9598634494694434, -4.1250293254391037, -3.9281193480701115, 0.32060888825749867, -4.1619712045593324], 
[-0.59685022111605512, -2.8397446292002524, 4.3275879526940475, 4.3870500382327133, 1.7951297829131363]]))
      arg1=Data(numpy.array([[0.57837851256753581, 4.9137512650801369, -2.7108975531477473, 4.5563264160184005, 
-3.6196644327168439], [2.3429959515816545, 1.2935409194384881, 0.19628667826565493, -0.8544984798666615, 1.862543949817014], 
[2.9255183716743449, 3.0852274983288481, 1.4745926395276996, -0.2293003990200031, -3.6713224178132964], [-1.3391136571099747, 
-4.0546088163151284, -4.036945717745831, 3.0334445343426655, 0.39608460371391629]]),self.functionspace)
      res=arg0*arg1
      ref=Data(numpy.array([[0.18959633664369283, -19.664949994019015, 10.028594724535401, -2.9679934478539596, 
-17.197096677286282], [9.708096004092635, -3.5884163355640655, 0.50138040175087073, -0.99076464257997143, 0.46439045095322595], 
[2.2747993944982285, -4.3316315674673644, 6.2243809647792707, -0.10910856664102794, 17.986031915016007], [4.0901219909326194, 
-17.399307493253463, 11.817040696235598, -1.9559821053836579, 1.8560932187897021]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[2.1630496157837564, 19.184465796412077, 6.0422529866246411, 13.251874217284184, 
-5.5247953137452512], [-5.2012851935690607, 5.7462963018730662, -0.86511759610807293, 1.0690750681983854, -5.9725547295429182], 
[-14.510171642418946, -12.726653906257622, -5.7923758778505325, -0.073515746006804036, 15.279938185592085], 
[0.79925028234561757, 11.514053609638879, -17.470237653796683, 13.307872960364806, 0.71102326868019816]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank2_taggedData_rank0(self):
      arg0=Data(numpy.array([[3.9910761026211521, 0.55922044859161435, -0.59472021792302066, -4.9132932757204886, 
-3.8182352572042175], [-3.2688424065712587, -2.733331807126226, -1.9803371238953984, -1.5114120424111577, 2.5213104178757479], 
[0.68640803876360756, 2.7980914507435912, 1.3511628390375927, -3.4491202657444475, 2.9648468263951049], [-0.77982344620884803, 
-1.3742393141095901, -1.9758765626036467, 1.8948147320959681, 2.2998946440928547]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[4.1242504438293821, 2.3579412246962095, 1.4638271036501624, 3.6554091432396003, 
4.999545560367979], [0.082026790081535239, -0.1944497199451547, 3.7964844115799661, -3.7069059174718988, 2.4020889346865291], 
[1.7747899904164379, 3.0908435746698686, 3.4300157830986837, 3.1933121518214467, -2.523928670628719], [1.5673235120667419, 
-0.37564206027940372, -1.1530248095019613, 0.40310033210305996, -3.3313235526389393]]))
      arg1=Data(-4.58203840894,self.functionspace)
      arg1.setTaggedValue(1,1.40828509823)
      res=arg0*arg1
      ref=Data(numpy.array([[-18.287263995217327, -2.5623695745120849, 2.72503088109714, 22.512898503743628, 
17.49530060288307], [14.977961459685178, 12.524231324632931, 9.0739807643407921, 6.9253480300641366, -11.552741175570175], 
[-3.1451479978208257, -12.820962499037039, -6.1910800252042382, 15.804001534698415, -13.585042035169687], [3.5731809827218055, 
6.2968173203271034, 9.0535423011765506, -8.6821138802912881, -10.538205595751529]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[5.8081204414277838, 3.3206534892501014, 2.0614858964608169, 5.1478582243707844, 
7.0407855106056374], [0.11551710612775286, -0.27384064295443716, 5.3465324225038131, -5.220380364129225, 3.3828260513506021], 
[2.4994102959974311, 4.352788947178313, 4.8304401140435571, 4.4970939174180691, -3.554411135850692], [2.2072383461545728, 
-0.52901111576121129, -1.6237876571151226, 0.5676801907937109, -4.6914533165756733]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank2_taggedData_rank2(self):
      arg0=Data(numpy.array([[4.9352649309220684, 4.0324329739825338, -0.74352733584725694, -3.0738636432755531, 
-4.7237293148785788], [1.5767979880149081, 3.6208855856046736, 3.2582301044719522, 3.750034557846087, -0.047576703248881635], 
[1.9189908229654637, -2.3173614301519829, 1.1684650245069426, 3.8745298276639311, 3.1953902831017373], [3.781769517598331, 
-1.5139911213539872, 2.8605970896857045, -2.8450927031930062, 0.96156782163228893]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-3.5901705755125048, 1.7075753637927349, -4.7557092634374252, 4.1212533328655248, 
0.96306044880134856], [2.9214830427408023, -4.4962064128086245, -4.8877952027629048, 0.15147244378581526, -2.4721025160476104], 
[0.22779155828082764, -0.6585633650288667, 2.0364855891545774, 3.8887946709992463, 3.1382904507912386], [1.7610699992680781, 
-1.9437316906071569, 3.2812152994738994, 3.1269726369367543, -1.988043315742333]]))
      arg1=Data(numpy.array([[-2.3118184991921584, -3.7443866530986036, 4.7135127230925598, 3.522335534747862, 
-2.4267571839641331], [4.8784457048853476, -3.6086472321899565, 0.23978200462955002, -0.49485220134710683, 
0.48315245587255884], [-4.0440193944888279, 4.3622266326497474, -4.4866906242342219, -1.3325877486969882, -1.9491563723991612], 
[-4.4413283206355274, 0.31569871137154415, 4.9581048251497783, 4.2296799366357156, 4.5006365681660476]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[-2.7977270233336613, -2.2812632045854131, 3.2930298786878787, -2.3227267353894487, 
-0.62962436259228927], [-2.0773584338375972, -4.5241495757504815, -0.24616937247498338, -0.090839002061281704, 
4.3671976731125319], [0.50075824287307746, -2.8542440895558729, 2.7858917466287281, -0.7256004750614311, 3.190397907348121], 
[-2.8182541988544174, -0.71715056258925003, -4.8031877943706789, 1.1198257406141892, -3.3790905295930251]]))
      res=arg0*arg1
      ref=Data(numpy.array([[-11.409436765719947, -15.098988207294909, -3.5046255574831604, -10.827179139679007, 
11.463344049983563], [7.6923233721031865, -13.066498746568815, 0.78126494599463292, -1.8557128560778606, 
-0.022986801017017111], [-7.7604361059184122, -10.108855748084288, -5.2425410702009092, -5.1631509803060069, 
-6.2283153326101113], [-16.796080060625624, -0.47796504603941287, 14.183140233180104, -12.033831524564132, 
4.327667300810047]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[10.044317237488698, -3.8954288464769169, -15.660692698852165, -9.572545299559625, 
-0.60636632121439316], [-6.0689674381511312, 20.341510334994734, 1.2032254778503784, -0.013759605633287049, 
-10.79616035577876], [0.11406850046602747, 1.8797005922316696, 5.6734283949540805, -2.8217112606934149, 10.012395286854959], 
[-4.9631429199138068, 1.3939482754414767, -15.760293277135366, 3.5016644490380049, 6.7177783406456335]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank2_expandedData_rank0(self):
      arg0=Data(numpy.array([[-2.9126596308563601, -0.89707763384955452, 4.5082120613612915, -1.2393230671071818, 
3.3178366845151981], [2.0948307200398322, 3.0499025616606605, -4.911547629254609, -2.4941582590855482, -0.84881267028263263], 
[0.87816755289775195, 0.31326461409322803, -1.8415111252484717, -2.941030524170686, -0.42295551080006621], [3.4738338907430215, 
-1.3487085872429825, 1.7707642172148326, -2.6242494435571997, -0.84142074452068627]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-2.0523190998243521, 2.5959302263090613, 4.0385872793555055, 1.9355345346640016, 
-0.43403903120164777], [-1.3301263557820087, -4.1587566338593991, 0.67818714863078178, -4.4435593506505562, 
-2.6223743900694316], [3.5441807743349614, -0.12414630837105722, 4.0617480276736124, -2.8382540869522197, 0.41721350619951725], 
[1.6168867022223496, 1.5691003048938175, 1.8899496523294124, 3.0364424970314587, 1.9205323783062065]]))
      arg1=Data(-3.56167986141,self.functionspace)
      arg1.setTaggedValue(1,2.0634111748)
      arg1.expand()
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[10.373961150369167, 3.1951033426051971, -16.05680810992575, 4.4140720098991553, 
-11.817072102692151], [-7.4611163886333287, -10.862776533136023, 17.493360279482602, 8.8833932425597197, 3.0231989938571018], 
[-3.1277516881014891, -1.1157482673088908, 6.5588730893638605, 10.475009189737074, 1.5064321250898738], [-12.372684210550343, 
4.8036682140969269, -6.3068952517632724, 9.3467363944396489, 
2.9968713207337236]])+(1.-msk_ref)*numpy.array([[-4.2347781648314697, 5.356471437965217, 8.3332661226241793, 
3.9938035880355329, -0.89560098728051263], [-2.7445975864155763, -8.5812249115759229, 1.3993789410899831, -9.1688900200159775, 
-5.4110366209765859], [7.3131022152713552, -0.25616488000291093, 8.3810562695204727, -5.8564851999368024, 0.86088301096925268], 
[3.336302089749875, 3.2376991034987856, 3.8997432324244334, 6.2654293800099969, 3.9628479709607731]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank2_expandedData_rank2(self):
      arg0=Data(numpy.array([[-0.432510889502562, -3.9286413420219746, -0.90609391045033494, -3.8533401497430599, 
-4.1322819374856454], [-1.2664142848659719, 3.5013781829093347, -0.71262537233811951, -3.8954830922783956, 
-4.2073801398300805], [0.29743667331951507, 3.7485254218334987, -3.5478313636348915, 4.7358837727689593, -1.0538183150667892], 
[-4.9927776404109681, -1.4633278758802271, 2.7456576050076462, 2.3996666293021507, 2.612379538874964]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[1.281009168630419, -4.1690586786500567, -1.1773646874224584, -4.2175773434378225, 
3.2083933146677861], [-3.4537011461050691, -2.1500943260917218, -0.49782721310641875, 0.20482116571381148, 1.1558444078674102], 
[0.15316421556098803, 4.8215479725374326, 3.2925650010077838, 1.6194799493840399, 3.5172875939087298], [-3.9734020590508203, 
1.7436764975179555, 1.0598608291142186, 2.8183940405264396, -1.7104929511639821]]))
      arg1=Data(numpy.array([[1.7129559008620818, 0.28976378581350204, 0.59500680959717034, -4.0286492587036573, 
-0.5889650477195465], [-2.7508250808729287, -1.6265841746490639, 4.0024996124766297, 0.44911338850647198, -2.2097367719897121], 
[-3.5479883117402733, 4.7369657146058053, 1.5312386622796144, -1.1662807353178928, 3.1770792959428391], [-3.4924054482773617, 
-1.2823090957230168, -4.0084129201150294, -3.7150861395951038, 3.4120335167613653]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[4.4449026981058744, -4.2412745942537535, -3.4138473267625482, -3.0723923701101254, 
-3.0085665553994092], [-2.5016187939487047, 3.4306610796341168, 0.96371580781047683, -3.4872131040059529, 2.0749789448472171], 
[4.3582389799730095, 4.0653701037552885, 2.6301834186200672, 1.4538136498920124, 1.5028869762693606], [1.7736088551717533, 
0.79519134865350871, 0.70249024856680364, -1.0321880343718961, -4.2984858373108237]]))
      arg1.expand()
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-0.74087208036052143, -1.1383779883677247, -0.53913204685247795, 15.523755937795418, 
2.4337696285018531], [3.4836841775850691, -5.6952863417818191, -2.8522827766243375, -1.74951361144282, 9.2972026087217454], 
[-1.0553018404205494, 17.756636403553546, -5.4325765512459512, -5.5233700088850579, -3.3480643504840639], [17.436803833408653, 
1.8764386452662569, -11.005729418124737, -8.9149682341693222, 
8.913526545142977]])+(1.-msk_ref)*numpy.array([[5.6939611099437126, 17.682122655711609, 4.0193432907817828, 12.958052450327697, 
-9.6526648230765542], [8.6398436957786213, -7.3762449220650153, -0.47976395482889073, -0.71425505305497816, 
2.3983528098442752], [0.66752625459488657, 19.601376981375605, 8.6600498703794386, 2.3544220561409426, 5.2860857166792261], 
[-7.0472610770902122, 1.3865564656767295, 0.744541897290666, -2.9091126047764519, 7.3525297253983712]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank3_float_rank0(self):
      arg0=Data(numpy.array([[[0.76248462580352427, -2.61244699151736], [3.1990910210972849, -0.52383512550541411]], 
[[-0.57552094680784549, 2.7901484334242159], [-0.72561892468519673, -2.4613170539297027]], [[4.70888592070086, 
2.9610491502632206], [2.7203574270236874, 1.4443899846060528]], [[-2.4090995613493007, -3.6247629976674722], 
[3.2658057824100091, -2.4081366545829974]], [[-4.9699813734453446, -0.40134235631874304], [-2.906839048169533, 
-1.1909825011075181]], [[-1.4184972601482748, 1.0770036032835675], [1.2515069277880153, 
2.1511546129101191]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[2.1018263866335927, 4.6512402604178842], [-4.1127272467701932, 
-2.8168171006668929]], [[3.8144795645901048, 4.2833666756170246], [-2.2570115069634653, -2.3148187574455283]], 
[[2.4209691488200944, 1.9112963310494315], [1.1693314508116091, 1.5899192992251034]], [[-4.7513304426531278, 
4.6470162553553784], [-1.766702176145416, 3.5197710015707173]], [[-4.2734476808005075, 3.2102240028594178], [4.200902025341593, 
1.8251030313281493]], [[0.81219630382268981, -1.3152532093229494], [-4.4169534160365442, 3.2436769808232384]]]))
      arg1=1.45546582142
      res=arg0*arg1
      ref=Data(numpy.array([[[1.1097703122186526, -3.8023273064366885], [4.6561676408329919, -0.76242412123472558]], 
[[-0.83765106759266694, 4.0609656815499626], [-1.0561135442580774, -3.5823628476838403]], [[6.853622514566978, 
4.3097058337660741], [3.9593872570911768, 2.1022602554019199]], [[-3.5063620719525797, -5.2757186538690952], 
[4.7532686957081536, -3.504960594065007]], [[-7.2336380221659224, -0.58414008231188985], [-4.2308048829927811, 
-1.7334343242766184]], [[-2.0645742799300626, 1.5675419341302268], [1.821525558671393, 
3.1309320156902549]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[3.0591364683132785, 6.7697212262716606], [-5.9859339405151601, -4.0997810152246208]], 
[[5.5518446327829745, 6.2342937969891148], [-3.2850031069470509, -3.3691395842542167]], [[3.523637850830728, 
2.781826484456428], [1.7019219605729807, 2.3140731988452758]], [[-6.9153990655752038, 6.7635733312736601], [-2.571374634015879, 
5.1229063920271383]], [[-6.2198570390507877, 4.6723713152783182], [6.1142693170375031, 2.6563750826763068]], 
[[1.1821239605012059, -1.914306092688391], [-6.4287247318652279, 4.7210609813295248]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank3_array_rank0(self):
      arg0=Data(numpy.array([[[-2.4147572535821893, -1.6310617928522708], [2.6008714761909415, 0.76990055811865687]], 
[[-1.8474728471966873, -3.4675471780653524], [-0.51380775891821351, -4.4855556325990307]], [[-3.1412224239525797, 
-1.8880786853479501], [0.1897244689468085, -3.1254627138310518]], [[1.0886042921189691, -0.99013442888203329], 
[-4.8722294841911715, 3.2671035013462699]], [[-2.4271709967694663, -3.4638776330234999], [-2.8309970988240307, 
-1.1943493028960726]], [[4.8521301745144179, -4.4657417642532042], [-4.0210767736695496, 
0.81568911261875154]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[2.8363704081552079, -2.1098517028503458], [1.3108209394269199, 
-3.4663732593811556]], [[-1.0350093454648865, -0.49524497044055149], [-4.1112062140825589, 1.6718569360900561]], 
[[2.2788590013759258, -1.4287222821291135], [-0.047623733651183997, -1.1789327790981541]], [[-1.7872968012793389, 
-4.4100746624425637], [1.558207815266246, 1.585818156786889]], [[-3.0960323277986577, -3.7698696297909331], 
[0.10672132054054284, -2.9736269627325052]], [[1.8682560347025774, -3.7538727917186518], [1.5922694367614501, 
-3.8258948174236451]]]))
      arg1=numpy.array(1.48876598594)
      res=arg0*arg1
      ref=Data(numpy.array([[[-3.5950084634407076, -2.4282693181685935], [3.8720889875607187, 1.1462017634850807]], 
[[-2.7504547348584798, -5.1623662933540464], [-0.76493951479069877, -6.6779426538655171]], [[-4.6765450990599522, 
-2.8109073255287598], [0.28245533606898243, -4.653082578682711]], [[1.6206770422575614, -1.4740784592300169], 
[-7.2536095317692126, 4.8639525653574536]], [[-3.6134896220561492, -5.1569031995118531], [-4.2146921870306651, 
-1.778106617485619]], [[7.2236863631815407, -6.6484444406223107], [-5.9864423275019947, 
1.2143702059702888]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[4.2226917871948686, -3.141075450586122], [1.951505628279784, -5.1606186031467525]], 
[[-1.5408867086605689, -0.73730386670091319], [-6.1206239727208995, 2.4890037398126537]], [[3.3926877680070087, 
-2.127033136991741], [-0.070900594783460391, -1.7551550212338074]], [[-2.6608666845282274, -6.5655691529106397], 
[2.3198067943979139, 2.3609121317140986]], [[-4.6092676210045296, -5.6124536762697863], [0.15888307199560986, 
-4.4270346769971871]], [[2.781396037496711, -5.5886381278651465], [2.3705165779060162, -5.6958620699734057]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank3_array_rank3(self):
      arg0=Data(numpy.array([[[-0.77674766797076344, 3.1395526638955182], [-1.6757100339581177, -1.0656381309297744]], 
[[-1.4916542432649882, 4.2927047911078855], [3.312121839142101, -2.9714931160816374]], [[4.9530751159392103, 
-2.2232396914812269], [-0.8276727248281972, 0.79212464367262925]], [[-2.9127020275229332, -4.6749976742089778], 
[-4.2607472336933352, -0.61178104287135682]], [[1.4727593909790393, -2.6469434922952639], [0.10985078327163045, 
-1.5206767145623044]], [[2.507776623674304, -2.4202599469282804], [0.7334600289726021, 
-3.2794448937992602]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[2.5537553262014381, 2.1078458674954428], [-4.6600640953318155, 3.0295016455169641]], 
[[-2.0197907315562302, 2.7327259641309398], [4.1865255659767051, 0.42758680032089735]], [[-1.9657534911546479, 
4.5122304062345453], [3.3464726419206627, 3.6550310328470772]], [[2.8060190769965088, -0.64974926276382661], 
[2.9436535814627476, 0.44386112417297596]], [[-2.6841326947886257, 0.67710956628459584], [0.85021610792530922, 
-1.9002376291768694]], [[-3.2217311956988315, 2.5331026007496424], [1.7236253350062096, -3.6099119439395233]]]))
      arg1=numpy.array([[[3.01273954622304, -3.8270724884792062], [2.0286959373210811, 1.6531056739665262]], 
[[3.361691987063093, 3.0469797425074585], [3.9058107923021286, 2.3792262084728675]], [[0.92943152452475175, 
2.0123285653045695], [-1.2460123633166384, 4.0458164797685168]], [[-2.530876767999878, 1.7112786787394345], 
[-2.6435798699628488, -4.6142133794340925]], [[1.9993030619282424, -2.5058867238079676], [2.7336404679238573, 
3.8372159158916688]], [[-0.68575745148238632, -2.6017372533562777], [-0.9759887868084407, 3.5775279891465654]]])
      res=arg0*arg1
      ref=Data(numpy.array([[[-2.3401384167320423, -12.015295626126141], [-3.3995061380190044, -1.7616124406350941]], 
[[-5.0144821170525722, 13.079784539070438], [12.936521224740792, -7.0698543000781404]], [[4.6035441560929922, 
-4.4738887386865906], [1.0312904479159037, 3.2047909374014876]], [[7.371689893563933, -8.0002238430302697], 
[11.263625617991595, 2.8228882733011567]], [[2.9444923598679669, 6.6329405560125991], [0.30029254658446208, 
-5.8351648920443262]], [[-1.7197265063379941, 6.2968804667293945], [-0.71584876384945373, 
-11.732305896430638]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[7.6937996626247918, -8.0668789294463963], [-9.4538530978554931, 5.0080863594950209]], 
[[-6.7899143178168817, 8.3265606545311375], [16.351776737840591, 1.0173257217205336]], [[-1.8270332641237175, 
9.0800901397016176], [-4.1697462853340399, 14.787584786758048]], [[-7.1016884925349251, -1.1119020598944029], 
[-7.7817833520989641, -2.0480699377696028]], [[-5.3663947153126035, -1.6967598727159399], [2.3241851591053431, 
-7.2916220746537341]], [[2.2093261741237318, -6.590467402944018], [-1.6822389996250027, -12.914561017798132]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank3_constData_rank0(self):
      arg0=Data(numpy.array([[[4.4465442088675307, 0.83670680044595258], [-3.1546983801572726, 1.2222109106063384]], 
[[-2.537479116268071, -1.7483202686716268], [4.6989286951363063, -2.1680630466727955]], [[1.5363254551831673, 
4.5928363610908054], [-1.8369963184672242, 2.7668201884761192]], [[-2.6962627532840298, 2.4684359184474136], 
[3.4029816020744423, 2.0752828776693502]], [[-2.7412790052912763, 3.7189521352540975], [-2.2484075655002633, 
-4.5193105671126048]], [[2.6532796296651684, -0.64078888455210148], [2.02673142279962, 
3.6591904881027428]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[0.71277279202402966, 4.7965406023755506], [3.7140982616334011, 4.2202881047815097]], 
[[-1.8291884612449891, -1.0366598015352455], [1.0381172691156824, -2.7156687244396238]], [[0.60372925118800236, 
-1.3553318406897041], [-1.9263612421969931, -1.3362861489839615]], [[-1.3628651579207327, 4.6461148719368595], 
[1.053828268456483, 1.5423344464108695]], [[4.0502306549851497, 1.9087325138141775], [-0.50201782834221387, 
-4.5914953991256082]], [[-1.5524968279444931, 3.5681662017365241], [-1.7694767133097624, -0.8026314538912569]]]))
      arg1=Data(-2.46407902591,self.functionspace)
      res=arg0*arg1
      ref=Data(numpy.array([[[-10.956636322845494, -2.0617116778139009], [7.7734261116131309, -3.0116242700616365]], 
[[6.2525490690770509, 4.3079993046045111], [-11.578531641925082, 5.3422786801537692]], [[-3.785627331086209, 
-11.317111746793882], [4.5265040990062628, -6.8176635948842748]], [[6.6438044987055473, -6.0824211734455158], 
[-8.3852155912242203, -5.1136610116921313]], [[6.754728101101616, -9.1637919548373432], [5.5402539238432453, 
11.135938379988927]], [[-6.5378906853282777, 1.578954450460152], [-4.9940263900702853, 
-9.0165345335379428]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-1.75632848706467, -11.819055095232232], [-9.1518316266541735, -10.399123402283355]], 
[[4.507264921787665, 2.5544116739654918], [-2.5580029892613876, 6.6916223452074322]], [[-1.4876365851798155, 
3.3396447617894931], [4.7467063332207013, 3.2927146723234526]], [[3.3582074507739859, -11.448394207901284], 
[-2.5967161332131172, -3.8004339603372581]], [[-9.9800884070406504, -4.7032677533591674], [1.2370116014501951, 
11.313807510540899]], [[3.8254748715275402, -8.7922434986546527], [4.3601304561001362, 1.9777473310679108]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank3_constData_rank3(self):
      arg0=Data(numpy.array([[[2.7893585951155924, 2.1085470214448945], [-4.5539175359424524, 0.27995692540295902]], 
[[-2.4762236339419994, -2.0889041240773998], [4.0732602276456262, -3.9857501504059591]], [[-2.7745902026986133, 
4.7298916744709079], [2.3729995993936814, -3.9563848110991238]], [[3.4940971271455226, 3.118354656459525], [4.3766274542975143, 
-4.9988541985563053]], [[-1.6923044753740291, -4.9364483339685865], [-4.4506930394866631, -3.3788124008052991]], 
[[0.14284408507544022, 2.6348542568976976], [2.3997481779060177, 0.13214347331767318]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[4.9933684130131741, 0.27895653045722746], [2.3250577983599445, 
-3.4282849894793088]], [[4.7800311528376245, -0.96051829977099512], [2.5732693917958525, 1.7536097106735618]], 
[[0.58060127657340921, 0.30728498130554449], [3.0417063236357365, -2.6841094110229866]], [[-0.091516061367169499, 
-2.5354470249141614], [2.1791800317555694, -1.0999495297257624]], [[3.3738596806047791, -0.30158980435745519], 
[0.41337942738981681, -0.65913517861715398]], [[-0.33628408392834608, 2.5053402472513042], [2.765514614857346, 
-1.8882474073863365]]]))
      arg1=Data(numpy.array([[[-3.1179387884347385, -1.8764013875142593], [1.7894064035762289, 0.91263684101099418]], 
[[-2.723701564199775, -1.0794226480476787], [4.4368914931300303, 1.7613443025382116]], [[-3.7503601958977404, 
-3.1194632319077922], [1.8167344059672725, -3.5529260486435552]], [[-3.0237166573445728, -3.5332517982374654], 
[-1.9086380179390927, -1.8137643114022008]], [[2.5843090862144011, -3.6480633117922578], [-3.4360123203609616, 
-2.5089051749185876]], [[-2.8589557877969805, -3.1094911030689087], [3.1747242604608576, 
-3.3087629902904814]]]),self.functionspace)
      res=arg0*arg1
      ref=Data(numpy.array([[[-8.697049358564735, -3.9564805566782586], [-8.1488092001735062, 0.25549900401890707]], 
[[6.7444941850762747, 2.2548104211293438], [18.072613653345769, -7.020278318758356]], [[10.405712656128722, 
-14.754723169418778], [4.3111100175650554, 14.056742653811789]], [[-10.565159685729734, -11.017932197477791], 
[-8.3533975496282249, 9.0667433432444771]], [[-4.3734378323503984, 18.008476057708815], [15.292636117820949, 
8.4771199174595111]], [[-0.4083849237789941, -8.1930558697066314], [7.6185387593949727, 
-0.43723143392195474]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-15.56901705987859, -0.52343442080610536], [4.160473313070133, -3.1287791828838056]], 
[[-13.019378327907491, 1.0368052066370617], [11.417317073990905, 3.0887104727705599]], [[-2.1774639173483292, 
-0.95856420090011929], [5.525972530997266, 9.5364422438328802]], [[0.27671863917047856, 8.958372760113793], 
[-4.1592658565423992, 1.9950492013602221]], [[8.7190962281993478, 1.1002187004870372], [-1.4203768054951702, 
1.6537076606034651]], [[0.9614213280909506, -7.7903332089883905], [8.7797463404466818, 6.2477631380718632]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank3_taggedData_rank0(self):
      arg0=Data(numpy.array([[[1.4580356589830137, 1.0653556525662458], [3.6213390863458415, -4.3956921229372856]], 
[[-3.1463084426069043, -0.90157764707758581], [-1.8155307802163834, -2.4976208523762122]], [[-2.8765685759336801, 
-2.4378549199760413], [4.5410727236526025, -1.0752876556352717]], [[-0.25048955355113378, -0.22826901551050849], 
[2.4842104514328476, -4.9582603799340017]], [[-4.9352561001269715, -0.45440156882663452], [-4.9236438167444909, 
4.0181599751025505]], [[3.8230385014745387, -3.3948827512615676], [3.6720469519384462, 
1.4242943023792174]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-4.50076498192547, 3.9207998918971487], [2.9897332443816271, -0.83343313548420728]], 
[[-3.3385409476842165, -1.4676148119692556], [-3.2814464049636349, -4.7552555534032672]], [[3.4196841897587777, 
-1.0077116971221258], [0.25200421027839148, 3.2752528259089111]], [[-4.5833894341492698, 3.9709854906417661], 
[-1.1772531995423954, -2.526276324439948]], [[-2.2059091798262189, 0.30008240059538505], [-4.2803536506486486, 
-2.4914837179437486]], [[0.70830102181528609, 0.41006619625322838], [3.8289901270431628, -2.0353786982881528]]]))
      arg1=Data(-1.52462233179,self.functionspace)
      arg1.setTaggedValue(1,3.72872666917)
      res=arg0*arg1
      ref=Data(numpy.array([[[-2.222953726227221, -1.6242650191979695], [-5.5211744420158615, 6.7017703742902226]], 
[[4.7969321142883414, 1.374565414574431], [2.7679987715645038, 3.8079285278695587]], [[4.3856806897851062, 3.7168080526521883], 
[-6.9234208847493983, 1.6394075728763831]], [[0.38190196722340453, 0.3480240387023455], [-3.7874827311130881, 
7.5594745020618825]], [[7.5244016633414086, 0.69279077943211698], [7.5066973167734403, -6.1261764307338895]], 
[[-5.8286898746294415, 5.1759140563717461], [-5.5984847862955975, -2.1715109004442859]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-16.782122419761169, 14.619591121386375], [11.147898082022772, -3.1076443592479444]], 
[[-12.44850666773824, -5.472334489455168], [-12.235616723632077, -17.731048200682139]], [[12.751067638484379, 
-3.757481479891422], [0.93965481960756025, 12.212522560233131]], [[-17.090206418293416, 14.806719501833573], 
[-4.3896554014966256, -9.4197939046259549]], [[-8.2252323885796681, 1.1189252500478499], [-15.960268810642548, 
-9.290061784893723]], [[2.6410609098413254, 1.5290247620935311], [14.27725760268531, -7.5893708341626862]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank3_taggedData_rank3(self):
      arg0=Data(numpy.array([[[2.5410477509978957, 3.8053067841073851], [3.1275815927937813, 1.6745905259842653]], 
[[-0.91566860951537787, -3.0077415059303112], [-1.0387053813225466, -2.2824943234788009]], [[4.6687267852111169, 
2.2087159892907424], [0.44627231529565314, -2.8201174509778015]], [[-4.4491647484157664, 3.6297477362098309], 
[3.6507122932272402, -3.8383162534573989]], [[2.7668960483670055, -0.55587702947652229], [2.6324351886163644, 
-0.97154360019134955]], [[-1.1661738736710592, 1.0813455812691863], [4.9551719297726535, 
0.36108617756682637]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[4.2168675208670976, 4.3644019554936708], [2.7741917781550383, 1.1056952153555244]], 
[[1.4678191035699921, -2.6513183894630252], [-0.9767727141013669, 4.6031926696630485]], [[0.58188328489146368, 
0.74161570629487716], [3.8873402035401803, 0.75270788516990983]], [[-0.79917887238526042, -3.2053846926922813], 
[2.500012433799105, -1.3887180350444206]], [[-1.0184308783661553, -2.9421930689871703], [4.5878095389546569, 
-3.2926948703522427]], [[-2.6280189289494684, -3.9477802404630733], [-0.16877833229834494, -2.9859670305114925]]]))
      arg1=Data(numpy.array([[[-1.2886118557711801, 4.3294142581282884], [-3.4504690023586528, -4.8443103246817723]], 
[[-2.2125791540446125, -3.8649796207824014], [1.5874441390926801, -0.82503058982222655]], [[2.8929815907605603, 
3.9405160462378959], [-1.9902829546711995, -1.2997934809096225]], [[-1.4622048432508539, 0.94152376138871485], 
[1.6594498255096308, -3.9210339864488564]], [[-0.35062747764988167, -3.6330382123190974], [-3.5312304666026817, 
2.300825768574601]], [[-4.5192333155257387, 1.024166950225335], [-0.27206546472983728, 
1.8047837780263229]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[-2.6783833060778317, -0.32925624679365484], [2.0256747186322261, 
2.4715070735394935]], [[4.6608626517072533, -2.3408239052116619], [-0.18444235050544133, -3.7783636926410091]], 
[[-1.952570740880831, 3.5980235670013112], [-4.4579397914251278, 0.74750866406088257]], [[-0.087958351089008957, 
3.5888756297281983], [-0.58533989387224317, -4.2946707334687515]], [[-0.35680444547721013, -2.5809150333435249], 
[-0.84199234392692368, -0.30348524453432546]], [[-1.2412981919500679, -0.38636461292878099], [1.0811616730899711, 
4.6899421088979079]]]))
      res=arg0*arg1
      ref=Data(numpy.array([[[-3.2744242580165821, 16.474749447666817], [-10.791623338282445, -8.1122361746398557]], 
[[2.0259892774267412, 11.624859625002022], [-1.648886769824504, 1.883127637965599]], [[13.506540641906494, 8.7034807973823796], 
[-0.88820818227458964, 3.6655702781804083]], [[6.5055902435545008, 3.4174937414884528], [6.0581738779818082, 
15.050168480545503]], [[-0.97014978235834815, 2.0195224894386348], [-9.2957353393990836, -2.2353525506139968]], 
[[5.2702118215899549, 1.1074784061081047], [-1.3481311538898415, 0.65168247574214055]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-11.294387571832246, -1.4370066073647338], [5.619610149646042, 2.732733545929952]], 
[[6.841303239291797, 6.2062694663823326], [0.18015825529843554, -17.392536053286101]], [[-1.136168276686697, 
2.6683507889072908], [-17.329528576168425, 0.56265566567145153]], [[0.070294455840181028, -11.503727007507138], 
[-1.4633570126792566, 5.9640867021455053]], [[0.36338066481230408, 7.5935503227481105], [-3.8629005071947309, 
0.9992843079057695]], [[3.2621551449155288, 1.5252825845344054], [-0.18247666412901373, -14.004012512176693]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank3_expandedData_rank0(self):
      arg0=Data(numpy.array([[[3.8697408970862952, -4.8053338721003103], [2.1772928592715051, 3.8272657629145854]], 
[[-2.2845843638041896, 2.5730304474204946], [-1.9753106137548859, -4.4031945875414724]], [[3.1321909001312953, 
3.5057024031705435], [-1.1672699647844542, -3.6963244429218847]], [[-3.0917517196112532, 0.31952659186935595], 
[1.9763504099886937, 4.9616396157409213]], [[4.2608275735591068, 0.12972857661281001], [0.70614702462835233, 
2.5627308331629788]], [[-0.65591541831614464, -0.34996100229214377], [-3.1412315098917079, 
3.0961481827578847]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[3.8578402583297642, 0.93065938504718737], [-1.977941549837424, 2.0625071848470347]], 
[[-1.113289505445322, -1.5093307580487325], [-0.94637963084638876, 0.6968134728502271]], [[1.6280936181227323, 
-1.1893212585697821], [-4.9110032789510152, -0.92530922042235364]], [[-3.8512089591668506, 3.9957285681921508], 
[4.0114299538800715, 3.7231629288251149]], [[-2.7679085313282159, 2.2175721828874035], [4.6371746892951613, 
3.6324400491735513]], [[-0.38155118373803809, 4.1773249318472967], [-2.0088437526151193, 4.6631958621472407]]]))
      arg1=Data(-3.18241584996,self.functionspace)
      arg1.setTaggedValue(1,1.17514354106)
      arg1.expand()
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-12.315124766139203, 15.292570678938262], [-6.9290513053578753, -12.17995122592183]], 
[[7.2704974899491157, -8.1884528783095281], [6.286259805814578, 14.012796245865253]], [[-9.9679339656891166, 
-11.156602893104891], [3.7147384371163241, 11.763241493761923]], [[9.8392396766426025, -1.0168664904498406], 
[-6.2895688698297798, -15.790000554940466]], [[-13.559725204055805, -0.41285027840580418], [-2.2472534835817983, 
-8.1556752226478988]], [[2.0873956234847046, 1.1137214405636133], [9.9967049454839874, 
-9.8532310506442222]]])+(1.-msk_ref)*numpy.array([[[4.5335160620225654, 1.0936583652663043], [-2.3243652368882701, 
2.4237419966655636]], [[-1.3082749716554238, -1.7736802916461574], [-1.1121319105811323, 0.81885585194445343]], 
[[1.9132436995800879, -1.3976231952552023], [-5.7711337833902601, -1.0873711538638162]], [[-4.5257233336424223, 
4.6955546187452111], [4.7140060007220841, 4.3752508681277895]], [[-3.2526898328388834, 2.6059656275573895], 
[5.4493458848982526, 4.268638462078771]], [[-0.44837740915405727, 4.9089564125747787], [-2.360679760887046, 
5.4799244981062136]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank3_expandedData_rank3(self):
      arg0=Data(numpy.array([[[4.3762097631213877, 2.7100801508243864], [3.1468351023414129, 1.5484712033675994]], 
[[3.2135735909561998, 2.4827859713995171], [2.676779431271493, -3.8859555659991374]], [[-0.38708627526584127, 
1.0891525939854239], [-2.9927490386991753, 0.44675788460816523]], [[-3.7591188926083383, -1.7724167835522033], 
[0.8170588874364979, -1.8122161363158718]], [[-3.088521550507072, 2.3046448724026813], [-2.5726102343251647, 
-4.822916131150274]], [[3.0127870162417345, -3.6427897326588141], [-1.4584044659162245, 
3.1581587978832619]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-1.2430281999017909, 3.5192172841388185], [1.3819843311457438, 
-2.4146876440467144]], [[-3.3733992028446957, -1.6211500000564616], [3.1707619299824845, 0.08677850366133022]], 
[[2.6837934014329798, 3.788955899243847], [0.22068229173587994, 3.6230551488710621]], [[-1.8268234558994436, 
-2.9291431101714114], [-4.5913390620033265, -1.6907999892980929]], [[-3.138538364156449, 2.9231170845909755], 
[-2.4635957752223723, 1.8766900726830222]], [[-0.28030211385491999, 1.7052331508825747], [4.826559004542764, 
-0.68017814338500937]]]))
      arg1=Data(numpy.array([[[-0.34568104393225241, -3.3213768552226974], [-1.3121481239664678, -1.0158757168101031]], 
[[4.8973834621601409, 1.1918648435092019], [-0.56052748845134648, -2.7193937573383731]], [[2.1348618510135351, 
-2.368537102863264], [-0.32200343518165564, 1.9593594805260404]], [[1.0415423572769704, -1.9343624418333638], 
[2.0819527622370355, 2.5281538562657238]], [[3.231649346397802, -0.16995119428506822], [3.0526903719501668, 
-3.1733828712486281]], [[-1.7940555639510078, -0.35633367087776424], [-2.5340879519010429, 
3.0944206779626064]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[4.1033773699865996, -1.9928239161420249], [4.7026027898576714, 2.5514269773740246]], 
[[-3.2505300392423653, -4.1012463245233839], [1.2311225025544994, 0.96002001392641034]], [[-0.25580650663746596, 
3.8255024039590353], [-0.21668638765335757, -2.3206600820232435]], [[-4.1864102757820953, 2.5067457914789202], 
[-2.5405156592675295, 3.3052614593102643]], [[1.3485681596421113, -2.9475674377526637], [2.5854994769278541, 
-1.6070320634660726]], [[1.0446740057540973, 1.71227009750781], [1.2134761492715009, -2.4229043304269346]]]))
      arg1.expand()
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-1.5127727593823164, -9.0011974887465538], [-4.1291137759691132, -1.5730542936808629]], 
[[15.73810215878347, 2.9591453132689272], [-1.5004084517488336, 10.567443307472358]], [[-0.82637572211596866, 
-2.5796983295342448], [0.96367547109773211, 0.87535929670676726]], [[-3.9152815526916833, 3.4284964573784769], 
[1.701078007608736, -4.5815612134139414]], [[-9.9810186500317055, -0.39167714846779433], [-7.8533824931048928, 
15.304959440060982]], [[-5.405107309487839, 1.2980486376741447], [3.6957251860769795, 
9.7726718884594934]]])+(1.-msk_ref)*numpy.array([[[-5.1006137857321878, -7.0131803699322219], [6.4989233711855627, 
-6.1608991969525135]], [[10.965335443202932, 6.6487354792326467], [3.9035963622445706, 0.083309100293463292]], 
[[-0.68653181455725287, 14.494659901052104], [-0.047818848615312229, -8.4078794589538539]], [[7.6478324878171904, 
-7.3426171640616609], [11.664368784026141, -5.5885360400291937]], [[-4.2325329057166252, -8.616084735278859], 
[-6.3696255881991144, -3.0159011199900911]], [[-0.2928243321021603, 2.919819733535256], [5.8569142350642425, 
1.6480065690692918]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank4_float_rank0(self):
      arg0=Data(numpy.array([[[[-3.2341974107164209, 0.93780197807871257, 1.7077381538183625, 1.4493464904395097], 
[-3.972617771386032, 1.6295339439893572, -3.4966430212295885, -3.1279077034203349], [4.0053089439897942, 4.7693648508684774, 
1.4846677283679952, 1.2690848865590754]], [[1.6912330616515394, -4.7388715592725443, -4.2251859067161686, -1.9867810765662339], 
[-1.9030317769395522, -3.4752436720452371, -4.0216899042024954, 3.3980707899209079], [-1.7144530379269152, 
-0.89200685301942695, 1.0294275117662286, 0.6091674901332631]]], [[[-3.1539068119314297, 0.19058493785494957, 
2.4208184992420847, -0.93807701958738932], [1.9509952691555057, 2.3694109365381681, -1.4820427931011757, 2.7477014046017683], 
[3.5376979857809072, -4.3051143988116083, -1.8789943844945212, 0.4419652270909582]], [[4.3805145593848938, 1.9101809137669559, 
-4.0027648118620558, 4.1661386493215389], [2.5027620441388789, -0.013720494217102086, 1.4418222639591773, -2.7486304922902995], 
[-0.90516065775734234, 0.99159917680981646, 3.8225318629420606, -3.0078591315229386]]], [[[3.6079097445309909, 
0.64773618916777309, 4.4102474623419603, -0.65436362533121617], [1.6205003523752541, 1.2442664462267068, 3.4427049991229293, 
-1.3275327079138597], [-2.4825104391274841, 1.9621775273939281, 2.2066997006557063, 4.5421269296449136]], 
[[-4.5841071145211618, 4.0814910577635164, -2.0627381182117732, 1.1417978645408366], [4.433048026889999, 2.7525715060076914, 
3.7567382573655266, -4.4645240744983585], [1.0404098746374171, -3.074392919400263, 4.0526146639635776, 
4.1815195731703767]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[2.2234410583838855, 3.0929347508489862, -4.7055927648185385, 2.6762864668267312], 
[0.70010582268701071, 1.1765612860241026, -3.6414125658819962, 0.83756864884061422], [-0.90810948833872995, 3.4482059418890163, 
-3.8890311238884712, 0.68854381475754955]], [[-1.2894242887335308, -4.9594780988993534, 3.3019933482835668, 
-4.1415526349345892], [2.3202750764744007, 0.038817654923657408, -0.64112892483139561, 3.3591147300972395], 
[-4.9986644696024136, -1.9922466341289793, 1.050012029575579, 0.31136600387161906]]], [[[2.4831565573680239, 
-1.8804232073409946, -0.22721242531595287, -3.8542841180245722], [2.6209481842175872, 4.8863888715691992, -0.45908976757306963, 
3.3796928872070833], [2.7173739648152226, -3.1848916435627306, 2.2785278807704259, 3.9600013137183012]], [[3.2254925535023595, 
0.19258555531159161, -1.2127033019679265, -4.486044660361264], [-0.80149303878397493, 2.558522998386076, -2.0358655873820855, 
1.352790869147551], [-1.779075675323071, -0.6010355125997151, 3.8093443006725316, 4.5617327434756891]]], 
[[[-0.67858685034294552, 0.56366724068360163, -2.4537445934197755, 1.0247962497724741], [-2.0086262616112895, 
2.3032169021098401, 3.6404681910409025, 3.273259900645165], [4.2056373382871346, 1.1053078735248665, -0.14843844444321519, 
4.6555506050099691]], [[1.7890639445841208, -1.9311880581164989, 1.9186344262777011, -2.2864485710808569], 
[-1.1999156526652111, -2.8277130302517319, 1.5265666099152249, 0.7686070589460039], [-1.1568444347852722, 4.7735477909274557, 
-0.40303754999242081, 2.0959547538460521]]]]))
      arg1=1.88728331722
      res=arg0*arg1
      ref=Data(numpy.array([[[[-6.1038468178548051, 1.7698980280878089, 3.2229857278886498, 2.7353274522839297], 
[-7.4974552456452388, 3.0753922273416676, -6.5991560402550258, -5.9032480264822587], [7.5591527503208154, 9.0011427167995617, 
2.8019886353700674, 2.3951227345443091]], [[3.1918359427929568, -8.9435932362833039, -7.9741228739162295, -3.7496187807801888], 
[-3.5915601247655418, -6.5587694055399446, -7.5900682632503598, 6.413122312564588], [-3.2356586166438155, -1.6834696525532233, 
1.9428213692480218, 1.1496716415238448]]], [[[-5.9523157102379489, 0.35968777372785721, 4.5687703676473106, 
-1.7704171093386789], [3.6820808234605233, 4.4717497321770523, -2.7970346388322054, 5.1856910216184184], [6.676638389941961, 
-8.1249705836188397, -3.5461947550144637, 0.83411359988197042]], [[8.267272048784827, 3.6050525714324535, -7.5543512521993206, 
7.8626839701075015], [4.7234210528852429, -0.025894459840007877, 2.7211271051725823, -5.1874444733132217], 
[-1.7082946087931157, 1.8714285837664162, 7.2142006144884929, -5.6766823594837126]]], [[[6.8091478709039635, 
1.2224617037787167, 8.3233864605083436, -1.2349695534859511], [3.0583432805937543, 2.3482833061455057, 6.4973597109690582, 
-2.505430332715294], [-4.685200536600223, 3.7031849128827909, 4.1646675311711503, 8.5722803790336215]], [[-8.6515088816045527, 
7.7029299827168378, -3.8929712383035189, 2.1548960613901378], [8.366417585603152, 5.1948822827550076, 7.0900294403038711, 
-8.4258218051465636], [1.9635481994785184, -5.8022504673763207, 7.6484320464366169, 7.8917121310909089]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[4.1962632163192248, 5.8372441565402786, -8.8807867226929247, 5.0509108009549868], 
[1.321298039448719, 2.2205044868051389, -6.8723771867196586, 1.5807293379869054], [-1.7138598875546891, 6.5077415484804995, 
-7.3397035602803919, 1.299477254769833]], [[-2.4335089489504722, -9.3599402781915408, 6.2317969598008522, -7.8162831953179772], 
[4.3790164432012411, 0.073259912551184442, -1.209991924024181, 6.3396011907545908], [-9.4338960618819883, -3.7599338363876869, 
1.9816701863027135, 0.58763586465767226]]], [[[4.6864199447765484, -3.5488913485358817, -0.42881421976484729, 
-7.2741261157899642], [4.9464717833829113, 9.2220001987825331, -0.86643245944898972, 6.3784380033672177], [5.1284545504551495, 
-6.0107928660627037, 4.3002276572082359, 7.473644415566465]], [[6.0874182860558879, 0.36346350567792524, -2.2887147105467687, 
-8.4664372478225154], [-1.5126444409683244, 4.82865777158848, -3.8422551591770562, 2.5530996390353984], [-3.357619842116609, 
-1.1343242959887376, 7.1893119482223549, 8.6092821043970478]]], [[[-1.2806856419399559, 1.063799779807959, -4.6309112358902196, 
1.9340808657495145], [-3.790846834077398, 4.3468228353007046, 6.8705948838368567, 6.1775688034265617], [7.9372291868444975, 
2.0860291101000366, -0.28014539983239128, 8.7863429893283449]], [[3.3764705360609315, -3.6446990045058669, 3.6210067445659293, 
-4.3151762438920116], [-2.2645807933512403, -5.3366956278915829, 2.8810636955245066, 1.4505792798495503], [-2.1832932023939029, 
9.0090371097898192, -0.76064604431561023, 3.9556604405904086]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank4_array_rank0(self):
      arg0=Data(numpy.array([[[[-4.8561292005119938, -4.3595787902732983, -1.4103838568401663, 1.7452764230517017], 
[4.8377543811877644, 0.12603345651094422, 1.6059672603734203, 0.92851290069023928], [3.1649206464417663, 0.31104741441816408, 
1.9140963775420605, -2.2072300390565989]], [[3.0282646749825286, 1.7972243912144537, 4.4975276229504644, 2.4822580461388082], 
[4.8558451547277155, -3.6203449629122666, 0.72446977284522962, 0.34900512809611861], [2.0551421906558804, 4.6156308491837486, 
2.4780956708067237, 4.1052108204526139]]], [[[-3.6786932095584879, -2.5846510967257452, -4.6487659609257106, 
3.2188666617073167], [-1.636269537760481, -1.2038398872809575, -1.7858690009743858, 3.4461977643991641], [-1.4008596408761154, 
0.85283758139632493, 4.9415256225965454, -3.6869543487648326]], [[-4.1536676619449162, 3.5171271570894174, 2.7601980244345725, 
0.77532838729432729], [3.4312516679637088, -0.17405370445762713, -4.8793998193008559, 3.8815991899182425], [4.3006111593673015, 
-0.29423695896213253, -1.7826382493752178, -4.2807684991359736]]], [[[-2.661367218603802, -3.8965731798823047, 
-0.28603172439392477, -2.1283044002218499], [-1.9401929130867734, 2.0324175875989994, -2.3953807191234997, 
-2.5802828313279393], [-2.8594311785817816, 1.8423332205591585, -0.69835011511629475, -2.4012552542534471]], 
[[2.8756595022003939, 3.4674119887485837, -2.4521920648562356, -4.8146000628624286], [2.9702344450612586, 4.0900319108686851, 
-2.9721169262088032, 2.7756539246606415], [2.2580026398258326, 3.2091765648128163, -2.1975917291248734, 
-2.033380002084344]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[1.6826342023528653, -1.8498388729921311, 2.1562740796862068, -1.4250475090270576], 
[-1.5283203774640319, 3.6976122540499503, 0.2380304137041378, 0.1422683041491517], [2.3745836515102745, 1.4257671325074615, 
-4.6928680610864912, -2.4038945238545759]], [[-0.34908673666052081, 1.7712049525987084, 0.81255670033107208, 
4.7102053835265405], [-4.8033633829497155, -0.033035101412815848, 4.4758194100620194, 1.1465738079740619], 
[-4.5541711562415879, 3.9573551446937074, -2.6701483575526286, -1.6862523313311941]]], [[[1.1249162067710383, 
-1.948031901727183, 3.8534723772534836, 0.48740203182118691], [-4.2058375352196267, -1.2577066457082786, 3.0165916593512581, 
3.21966638761063], [-0.81952966506145586, -3.5838646003579431, 3.6779433801419881, -1.2748827156791731]], 
[[-3.6063366832070711, 2.5953957283447711, -0.2718101036865308, 0.92358748367678967], [1.5469509503535761, 4.4035384193822669, 
-0.055211249417722819, 3.204452026293465], [-1.9289377267588357, -3.6474249697866989, -3.2998753018043834, 
4.2920380548276817]]], [[[2.0035569946542031, -0.30331723784595965, -4.5928712531265736, 0.25085556448591539], 
[3.2405404942637297, -4.8691364758908708, 1.4244263240469781, -0.6964695433114807], [-4.19002169670126, 4.2439355037115227, 
-1.2136140676288187, -0.47029208179368354]], [[1.4583481973446926, -4.9654514250131365, -3.9010103888193925, 
-3.6095365930564292], [-1.2066644044942665, 4.3108063932952021, -3.5512457929841421, 2.8171138092717918], [-2.1606682853142178, 
-0.23547955095025053, 1.5016019773584075, 2.3403869790096445]]]]))
      arg1=numpy.array(-0.883141413611)
      res=arg0*arg1
      ref=Data(numpy.array([[[[4.2886488068184763, 3.8501245755910856, 1.2455683930641501, -1.5413258873960665], 
[-4.2724212429056276, -0.11130536494537288, -1.4182961965393852, -0.82000819567175398], [-2.7950724936656512, 
-0.27469885326934618, -1.6904177806504495, 1.949296256857407]], [[-2.674385945852737, -1.5872032894335455, -3.9719529026876041, 
-2.1921848798146431], [-4.2883979542230186, 3.197276568306294, -0.63980925930907451, -0.30822088218434168], 
[-1.8149811794277204, -4.0762547528553021, -2.1885089137798857, -3.6254816871462516]]], [[[3.2488063213311689, 
2.2826124232539469, 4.1055177422792619, -2.8427144538459572], [1.4450573926266308, 1.063160859814775, 1.5771748740448259, 
-3.0434799652350137], [1.2371571635141205, -0.75317618721505242, -4.364065923735561, 3.2561020754878989]], 
[[3.6682759306408945, -3.106120649362063, -2.4376451851458127, -0.68472460796795431], [-3.0302804485010371, 
0.15371403459896366, 4.3092000539912778, -3.4280009956562361], [-3.7980478186754643, 0.25985284387445945, 1.5743216635105102, 
3.7805239436689635]]], [[[2.3503636075760981, 3.4412251463204968, 0.25260646141888149, 1.8795937566067249], 
[1.7134647119417605, -1.7949121413603146, 2.1154599144235866, 2.2787546271755001], [2.5252820931764703, -1.6270407647473715, 
0.61674190785930394, 2.1206479596825565]], [[-2.5396139978375509, -3.0622151253156238, 2.1656323666031456, 4.2519727054885879], 
[-2.6231370465678872, -3.6120765634792251, 2.6247995436296261, -2.451294930720096], [-1.994135643273462, -2.8341567279765192, 
1.9407842661994807, 1.7957620894493818]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-1.4860039480563554, 1.6336693172471008, -1.9042949388671273, 1.2585184715851834], 
[1.3497230186042897, -3.2655145130275312, -0.21021451604111571, -0.12564303123834084], [-2.0970931627326763, 
-1.2591540008829349, 4.1444661333584731, 2.1229788079689982]], [[0.30829295408727064, -1.5642244456330681, 
-0.71760247296958302, -4.159777440806411], [4.2420491281061787, 0.029174666160501416, -3.9527814808703314, 
-1.0125868135837159], [4.0219771527502566, -3.4949042166461015, 2.3581185950404806, 1.4891992675969039]]], 
[[[-0.99346008904185146, 1.7203876474509334, -3.403161042559105, -0.4304449193795028], [3.714349306272636, 1.110732824998929, 
-2.6640770223270316, -2.8434207249107106], [0.72376058689863476, 3.1650592493510219, -3.2481441159203142, 1.1259017237133087]], 
[[3.1849052763651873, -2.2921014524107042, 0.24004675920351218, -0.81565835592787184], [-1.3661764490823471, 
-3.8889471445842014, 0.048759340858004728, -2.829984292349879], [1.7035247907776487, 3.2211920438579793, 2.9142565387759962, 
-3.7904765550133082]]], [[[-1.7694241565093918, 0.26787201420390588, 4.0561548110201509, -0.22154093783231074], 
[-2.8618555129681988, 4.3001360703838074, -1.257969877403762, 0.61508109701720315], [3.7003816842860804, -3.7479952000222814, 
1.0717928432640755, 0.41533441392539755]], [[-1.2879276885402433, 4.3851957907035297, 3.4451438292936847, 3.1877312492729777], 
[1.0656553079393059, -3.8070516519786461, 3.136252229696614, -2.4879098718237418], [1.9081756438371471, 0.2079617435027197, 
-1.3261268929655807, -2.0668926650396728]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank4_array_rank4(self):
      arg0=Data(numpy.array([[[[2.6461119532446489, 0.22559070380341417, -4.9484043536929381, -2.6781286175066974], 
[-4.820136743831732, -3.1337856385672169, 2.2076629203901135, 1.8501525278458777], [-3.410993334444842, 4.7130428090814984, 
-1.3285730962446807, 4.8001978721162679]], [[1.1106792380837742, -0.08683101879754318, 4.2993041731027795, 
-0.97098278301736674], [1.6538600595738533, -4.5705410509163693, -0.97702206527607238, -0.96793004347303757], 
[4.0882382696555535, -1.8436534712139876, -2.1095080713283529, 0.23534776182672612]]], [[[-3.7515424457610869, 
-3.1403656523084669, -4.7238827602131881, -3.4686001677521903], [3.6494851384004789, -4.1307608554866064, -1.9438895348482967, 
1.7779968426216497], [-2.3630545555517477, -2.9051650829861817, 0.14027827962982542, -1.2106611688383762]], 
[[3.5131233259312467, -1.5285645423250713, -4.9408046013514468, 3.4824085483126748], [2.727508616235168, 3.223607301831672, 
0.82918924260005777, -1.9526383943073577], [2.3342295203995214, -2.3173218287905284, 2.9955913172872792, 4.2894871902126912]]], 
[[[3.5156109675119058, -2.6915300848544845, -0.28602229565636872, 0.75065192256549818], [-0.86097195193057363, 
2.5028094191776065, 1.1600986993560056, -4.0589017458804353], [2.9062860872154079, -3.6621292703013939, -1.8250955980482422, 
2.3547360009491856]], [[-3.5948879421872415, -0.39679318966534005, -3.0912589755059638, -0.38734776886844902], 
[-3.6549421301171137, 1.504105423365977, 3.4802638873847922, 2.5502228513808891], [-3.5273129477640062, -1.8849288769474715, 
-2.5281221484772844, 2.7578892353455995]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[1.5887942270052378, -1.1172922748223888, -4.7517589101808824, -1.2937074459601918], 
[4.7269364212327822, 0.237483579483591, 3.2461991260272356, -1.2089316931811944], [-1.4337679003099479, -1.1753180125527631, 
-2.4416883298927363, -2.1103928108653056]], [[-1.4677251204301189, -3.5123594187894316, -4.2491465526857395, 
3.1502870832100065], [-2.3888776282646806, -0.76892178060355576, 1.9072179363376742, 4.4323580216035481], [0.67908810608225423, 
4.8131383111738835, 1.3891511264033216, 2.7961468421656743]]], [[[3.9145681995739015, -3.8217169470157475, 2.8979805244847956, 
3.9379496313909073], [3.0856529058529247, 3.8630686161869967, 4.7374715719151048, -3.7452261694538191], [-1.0416633328109959, 
-2.7055727166596801, 0.4003025868412653, 0.1025154170222109]], [[-1.0449858139905741, -4.1829474171215075, 4.9652810391868059, 
1.1035251913821629], [4.7053032033729707, 2.3342786358693415, -3.1983751827088822, 0.60580442426515013], [-0.83651002108329031, 
-0.2816219242751874, -2.3122625482090009, 0.13359483810338357]]], [[[0.46371029108040673, -2.1841384117787577, 
-4.7678226403738, 3.4872257113507708], [-2.8803545909883876, -0.72529341999610963, -2.8627402045563368, 3.5527656730006729], 
[1.2644419432402598, -2.5462611727666618, 0.37951379212905678, -0.96954920968481684]], [[0.065811399428589823, 
4.7794620308007225, -2.6155003868713123, 4.1486007342642921], [-0.72421890173771875, -3.2517351185873911, -0.38907785980493159, 
-1.6416439190974863], [-1.8517089252305086, -0.30829536213708852, -3.6479248597036951, 2.6791158617615114]]]]))
      arg1=numpy.array([[[[3.0947426059007004, -0.62963106638353228, 1.8070998712512401, 0.49770783715437883], 
[-0.69857114043314628, -0.5828954601993992, 4.6873608598855245, -4.158044633466675], [3.4369080081116401, 2.1665243124351097, 
-4.949432747713062, -3.9857930582170518]], [[4.1738198755527236, -3.6010400071781392, 2.7019468950864853, -3.8348989053095806], 
[-0.32995867161382275, -3.3093398026519152, 1.4660415030436136, -1.8482535523774377], [2.2116177703061588, 1.064358033320449, 
3.2561056943092428, -3.285337216625166]]], [[[0.60263745933412771, 1.1558966604096668, -0.69242560876881676, 
4.5381031353742181], [-4.4505611451097007, 1.2854105381787706, 1.0389134789170997, -4.6559230928866624], [-4.3779676417155731, 
-3.8119080597161634, -2.6322251001424846, -0.28589651872469446]], [[-2.2832726444889326, -0.0047630636667204129, 
0.47027402864493606, -4.4000828427169836], [-3.2048421279117068, 2.1070253970837722, -0.84990970023966206, 
-3.4603987514268653], [0.24061750039886576, 0.36872834202498872, 2.5089703673542747, -3.4385546772309752]]], 
[[[-2.7990768313873824, -4.4051488829144114, -4.9968463127276586, -0.85375282972454691], [2.232580746535997, 
-2.2133309253780196, 4.3024963355729522, 0.55974059661808351], [-2.732236456653625, -2.7223687656548345, 0.073092799774507888, 
3.6269057298694065]], [[0.75324638884770945, 0.22371504906054884, -1.7345791360365945, -0.33277127028957842], 
[-4.0457960383873015, 1.6450687999955012, 1.7779264557138656, 3.4173667712967255], [-0.015096555922122334, -4.7310669153990537, 
4.5182248772685334, 0.52008446832135657]]]])
      res=arg0*arg1
      ref=Data(numpy.array([[[[8.1890354016893365, -0.14203891540195523, -8.9422608704575843, -1.3329256018405051], 
[3.3672084221822454, 1.8266694219589059, 10.348112764857191, -7.6930167895043544], [-11.723270306768903, 10.210921831422532, 
6.5756831902839599, -19.132595356749285]], [[4.6357750792778125, 0.31268197255399005, 11.616491561547424, 3.7236208116677498], 
[-0.54570546829214639, 15.125473419452055, -1.4323548970841087, 1.7889801413018893], [9.0416204064159231, -1.9623073827457389, 
-6.868781243243558, -0.77319676077877886]]], [[[-2.2608200080976011, -3.6299381699685815, 3.2709373959931352, 
-15.740865296635754], [-16.242256756620471, -5.309723534338838, -2.0195330392797866, -8.2782165586417111], [10.345376379814127, 
11.074222194641003, -0.36924400864643264, 0.34612381352606131]], [[-8.0214183868147924, 0.0072806502337856641, 
-2.3235320846249823, -15.322886104761558], [-8.7412345175526305, 6.7922224551840262, -0.70473598062016751, 6.7569074616493401], 
[0.56165647255577611, -0.85446223586824632, 7.5158498477775408, -14.749636240828202]]], [[[-9.8404652073339545, 
11.856590746627264, 1.4292094534084263, -0.64087120302846556], [-1.9221894031877147, -5.5395454877931956, 4.9913204028821623, 
-2.2719320848532956], [-7.940660800955154, 9.9696663412588453, -0.13340134711747589, 8.5404054941723739]], 
[[-2.7078363607647131, -0.088768607892873205, 5.3620333229985029, 0.12889820909018779], [14.787150390562664, 
2.4743569038833928, 6.1876532382470035, 8.7150468317106373], [0.053250277170745493, 8.9177246476064767, -11.42262438402364, 
1.4343353566539088]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[4.9169091863221785, 0.70348192645850327, -8.5869029148048046, -0.64388833483936248], 
[-3.3021013665355596, -0.13842810035288838, 15.216106726734662, 5.0267919390598461], [-4.9277283783486716, -2.5463550490384748, 
12.084972179679923, 8.411589015658107]], [[-6.1260202794992455, 12.648146786649699, -11.480968334796676, -12.081032486812965], 
[0.78823088887019355, 2.5446234536773304, 2.7960606500202227, -8.1921214588373896], [1.5018833230150674, 5.1229024269803416, 
4.5232228929379543, -9.186285283715824]]], [[[2.3590654341813866, -4.4175098560865296, -2.0066359288665594, 
17.870821569160821], [-13.732886930083868, 4.9656291089544462, 4.9218230720491825, 17.437485010443492], [4.5603683646081397, 
10.31339444478319, -1.0536865167355451, -0.029308800842260379]], [[2.3859875229636782, 0.019923644862293449, 
2.3350427176526938, -4.8556022611066307], [-15.079753930767602, 4.9183843696467653, 2.7183300927900804, -2.0963248733359965], 
[-0.20127895033166382, -0.10384198521587677, -5.8013982149994687, -0.45937315541430451]]], [[[-1.2979607322390656, 
9.621454884777652, 23.82407698029127, -2.9772288189539164], [-6.4306242030372411, 1.6053143564505779, -12.316929239801002, 
1.9886271774496436], [-3.4547543746429916, 6.9318618859396084, 0.027739725619753356, -3.5164635839962171]], 
[[0.049572198964599495, 1.069237582703614, 4.5367924013626197, -1.3805351362654064], [2.9300419635756647, -5.3493279894377883, 
-0.69175182027971838, -5.6100993794250797], [0.027954427341235415, 1.4585659879777495, -16.482144851519561, 
1.3933665485355486]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank4_constData_rank0(self):
      arg0=Data(numpy.array([[[[4.5177371944796931, -2.2410763163473746, -0.30992088050738431, -0.18030927766947613], 
[-0.91174097745805049, -3.0360052312589438, -1.1783195024883075, 3.1039955075108523], [-4.9438765581376574, 
-1.9927596862215102, -3.1651398911569606, -0.8032332826344879]], [[3.9910692893496567, -3.4540695057299997, 4.8208961780539585, 
-3.699441439199922], [2.2569486738504798, -3.5758741715133358, -2.2843335380417118, 0.81165793193975233], [0.37694003781946872, 
2.1721761058446463, 1.3338782970011875, 2.8160246780504927]]], [[[1.7151110553063633, -3.6417034384551608, 0.69413884554393679, 
-1.5261099919457477], [-2.4011254764335233, 2.9111705034920643, -1.5207886001836468, -4.105960037819135], [-2.2902293827952622, 
1.2409478712720299, 1.8466597172068617, 3.3173751187740201]], [[-1.2249349174886914, -0.81740933683739225, -4.8170220142698987, 
0.82433272737434304], [-3.2809425667933811, 0.39461341002575168, 2.9749940807771598, -3.8956058367160606], 
[-3.9257638440225162, 4.4322308952610427, -4.6824429508825283, -1.9576169999392379]]], [[[1.3761079674639518, 
3.2889589864869482, -4.3856805554638632, -4.5515791386954199], [3.438131921926848, -2.4699179327777046, 0.52304752684814204, 
-4.9909718094514837], [3.3745670524132265, 2.7170492612934272, -4.1906578294566508, 4.3211577779096757]], [[3.8890215302696092, 
4.3072287350467793, 0.37169360573640287, -0.16965184871640204], [4.4264860608830947, -0.3480129511035388, -1.6831883790336164, 
-1.6713067014802241], [-0.58317487278661773, 1.3864624149581504, -2.7714498603992741, 
-4.2933511225254062]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[-0.53121885854002482, 1.7672141733097071, 1.1403941988171749, -1.0680570015355348], 
[-0.67692111787828857, 4.007801749719345, -1.162230762807277, -1.9242354021636929], [-0.29242564954652117, -2.0800857535546067, 
3.3542291637687143, 0.15909407382412777]], [[-2.395023911649937, -2.6127036276992923, -0.78488087858220545, 
-3.4084700738148666], [-1.2866769439768735, 2.1545434523170792, 1.1995502170778991, 2.5819982521340412], [-0.90101860820007929, 
2.2371068580585014, -3.0548065931171364, -4.9407454393353287]]], [[[-1.5370470912829184, -2.4492178457248039, 
3.0198409161679791, -0.53649449613906963], [-1.8040976121493713, 1.5255924726761174, -4.3539474053830922, -2.6293886510865416], 
[-4.4138175689887174, -1.1593502599720762, 4.4742905841974885, 2.5505817057945244]], [[-3.0377520270800886, 
-0.8846257630634744, 3.4383542961257358, 1.9197683383320951], [-3.5404070188517345, -2.8363307265768265, -2.2860361697392784, 
0.63725577645751574], [-0.87953092283467171, 1.0989630635404533, 3.4580803972434584, 4.3900423045587491]]], 
[[[3.270036345473553, -0.72390936239894721, -1.2333819287150782, -4.7172069087515904], [-1.4955659862350634, 
-3.156856029860089, 4.4001086279519335, 1.4088950999011303], [3.3321656191525637, -2.3011845731308345, 3.6113029528197913, 
1.7820393938011216]], [[1.6579413391233819, 1.1540984962221419, -3.0986112754687376, 3.3763350503036875], 
[0.092147646213832424, -1.2260439352277652, -3.2648344871602006, 4.2786218860320506], [-4.7408151467414026, 0.9877952851737879, 
-1.8102669618266907, -1.8837367697934493]]]]))
      arg1=Data(-4.00260684958,self.functionspace)
      res=arg0*arg1
      ref=Data(numpy.array([[[[-18.082725839241309, 8.9701474142507376, 1.24049143914772, 0.72170714984324835], 
[3.6493406814192952, 12.151935334007543, 4.7163497116571946, -12.424073679438488], [19.788394175095714, 7.9762335696435303, 
12.668810608233946, 3.2150270388860176]], [[-15.97468127471218, 13.825282262571433, -19.296152063408353, 14.807409644173623], 
[-9.0336782211117015, 14.31281845214701, 9.1432890660984327, -3.2487475979006057], [-1.5087427772583644, -8.6943669597547917, 
-5.3389904080873576, -11.27143966496029]]], [[[-6.8649152577651593, 14.5763071269114, -2.7783648977359521, 6.1084183069794467], 
[9.6107612786815988, -11.652270997581976, 6.0871188678631452, 16.434543771489857], [9.166887814693073, -4.9670264495291461, 
-7.3914528329416012, -13.27814837304185]], [[4.9029328910338963, 3.2717682105386259, 19.280645308909868, -3.2994798209241645], 
[13.132323190936347, -1.5794823379064664, -11.907731685188203, 15.592578605316085], [15.713289251930686, -17.740477740306229, 
18.741978227985083, 7.8355712128173529]]], [[[-5.5080191763372595, -13.164409767310952, 17.554155031383612, 18.21818183696239], 
[-13.761490380475131, 9.8861104356444738, -2.093553613619938, 19.976897950587279], [-13.507065198367046, -10.875279983908106, 
16.773555732442752, -17.295895719991087]], [[-15.566224215233763, -17.240143237619918, -1.4877433722668119, 
0.67904965171672749], [-17.717483426875333, 1.3929590218306955, 6.7371413350588343, 6.6895836510990874], [2.3342197403205405, 
-5.5494639588011889, 11.093024194510601, 17.184596610686008]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[2.1262602418200842, -7.0734635547699858, -4.5645496314105953, 4.2750122700914499], 
[2.7094491030471697, -16.041654735198275, 4.6519528120087408, 7.7019578009109244], [1.1704649078687286, 8.3257654848981471, 
-13.42566062597246, -0.63679102961655265]], [[9.5863391136856411, 10.457625436160122, 3.141569580720033, 13.642765664050817], 
[5.1500619491626418, -8.6237903799690248, -4.8013279152950403, -10.334723889603621], [3.6064232527835793, -8.9542592333145592, 
12.227189793762639, 19.775861537530655]]], [[[6.1521952157009778, 9.8032561254195656, -12.087235935705626, 2.1473765450099398], 
[7.2210934597058092, -6.1063468808060328, 17.427139707511465, 10.524409025055382], [17.666776434445008, 4.6404232916303219, 
-17.908826139334586, -10.208975806034823]], [[12.158927070926081, 3.5408091385556477, -13.76238045696677, -7.6840779006210456], 
[14.170857383968469, 11.352716793879765, 9.1501040313934308, -2.5506843357853275], [3.52041649615831, -4.3987170855659805, 
-13.841336284416137, -17.571613398186965]]], [[[-13.088669874778532, 2.8975245724154495, 4.9367429560271381, 
18.881124683870414], [5.9861626605081524, 12.63565356826609, -17.611904933150644, -5.6392531772085031], [-13.337348931165771, 
9.2107371345687223, -14.454625934876614, -7.132803083855503]], [[-6.6360873601824286, -4.6194025460724424, 12.402522715386974, 
-13.514141798833453], [-0.36883079990845719, 4.9073718530326218, 13.067848881062947, -17.125641267808572], [18.975619178955029, 
-3.9537561744226162, 7.2457869409817217, 7.5398576975870339]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank4_constData_rank4(self):
      arg0=Data(numpy.array([[[[0.10390028413985597, 0.12646900573271225, 2.3317298404884488, -2.9700552455645002], 
[1.9247790024878935, 3.5212318785099903, -0.051863750009535359, -4.3343721269893916], [-2.3761503897546623, 
-4.8805112670174466, 0.49715153419979963, 1.4670274744368008]], [[-2.6787215192171354, -1.7942179876865163, 
-1.6953883016769922, 4.6004466570067031], [3.89803933984944, -1.4115955437145344, 0.57568012184002892, -2.4847787966656307], 
[-1.1274589584269412, -1.5196792659973521, 0.44677354154515037, -4.4587282735575631]]], [[[-2.5042933827146872, 
1.8734619145704343, -0.86059459581243392, -2.8486840563052285], [1.3580663110529212, 3.1884337945964916, 1.6420938290808573, 
4.8206562541472344], [-0.11520684330124187, -0.14272228431640688, -2.3406017190814845, -0.39474394224016507]], 
[[-4.8679551542501809, 1.325066656063111, -2.2870516016609308, 3.8451033037182398], [2.4451113550946335, 0.69015275675918275, 
-1.9596451707269855, 0.39367272194549585], [-3.1828265509711615, -2.8874285970583191, 1.0005134562371261, 
-1.7397121115071235]]], [[[3.5015000330399406, -3.4569691004662131, 0.78525161551300471, -4.9857052439965956], 
[0.32906606888398304, 0.1763930633917985, -0.80728188785103328, 1.9239262160156931], [1.8363113074086055, 4.127471761204216, 
-4.9781773179145627, 3.2770832675209363]], [[3.0298743509057662, -2.684963479773935, -0.87118923521932601, 
-4.2676679637886705], [4.2639455439960621, 1.9162663173974881, 0.66714088595590493, 2.4034088984660338], [-3.7292477276986702, 
-1.1121076533767238, 1.3620901986978238, 1.6183611828656295]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[-4.1022298904919605, -3.7197607954469447, 3.4501328145226999, -4.1790953867996272], 
[2.383258190833434, 0.81169963768119402, -2.1373793911633152, -4.9971512184927835], [1.4657017483432124, -1.6010973740861378, 
1.2729091354866355, 0.88387675518013431]], [[-1.4058704076545405, -3.9194202227881059, -0.032632801007005163, 
4.1069648269079604], [-3.6233292964134369, 2.6163589375005465, -1.9865939941084343, -4.1896569521856497], [1.955858559188842, 
-0.62753002286117354, -1.8046280163720176, 4.8933823013509716]]], [[[0.55773315101132681, -3.2845130819000703, 
-2.4127490655753214, -3.4978730393725654], [-0.42508165140964849, -3.0360002056635471, 0.94148560575901108, 
1.4760071401180239], [-2.48585237056664, 2.2404840331725122, 0.42943460232787078, 3.5871393174919675]], [[3.6090869989352719, 
-2.8393660861893588, 2.8119636172619984, -3.5325949147544877], [-2.5714178251831732, -1.9757438713079054, -1.1613974940517169, 
0.050920064406247967], [-4.1971372291970663, -0.35031350396061445, 0.374637403240353, -1.8639867122682183]]], 
[[[2.7435914357919469, -1.3891109801191193, -0.99126392566577604, 0.55862809394931645], [4.2742470113356195, 1.322025925227976, 
0.58749708227104591, 0.45698133192350099], [4.928538795662611, -2.0451573972848069, -3.1149604532156805, 0.16626377965871342]], 
[[-4.9222731464757521, 3.4324849422810537, -3.2572352607169131, -4.8041488490220807], [-4.7076578749925124, 4.9487639153364391, 
-3.7425551616857842, -1.8568002491694138], [1.6843169717389426, 4.4219449385125404, 2.1420759104100195, 
-0.62044146424333224]]]]))
      arg1=Data(numpy.array([[[[-1.3551300141073197, 0.41681632436347904, -1.4416631016761716, -4.455983202188083], 
[-3.8244604545723271, 3.2947979761386961, -3.7683339297787546, 0.16233736911354413], [-2.1100577599787673, 1.3756640984953261, 
3.4556313455168617, 0.75223855162508002]], [[-1.0790477102595797, -3.903161269373844, 2.1849494872260173, -3.2888142951716937], 
[3.0896395646281789, 3.1828969962168898, -4.7201275164142276, -2.0027697310600456], [0.046950052656372421, -3.3366991936179047, 
1.3634111073701325, -0.53811036930728751]]], [[[-4.8054810274612159, -1.543930029142647, 4.7750378401754556, 
-3.1846917695389845], [-4.6579739945250154, -3.6160884743539565, 1.8400657162165146, -3.3262642597957806], [1.5583619057910783, 
-0.79705367248142878, 1.80313003752019, 3.0449916026565109]], [[-3.8225582443754824, -0.20070045038093642, 0.56061151104402906, 
4.77774267013422], [2.682363784754398, 4.6322512102150561, -0.40570326003613388, 2.4475902943715289], [-2.0282639300341989, 
2.7418375033014915, -3.3723234076907058, -1.502631901902082]]], [[[4.0678308221294852, -0.78727877213804653, 
-4.5251950234709062, -3.1498054150962385], [-0.65346012883658489, 0.90507894873473571, 0.59733733638456155, 
1.6267960506256385], [-2.4770384905231757, -3.1625444646424206, 3.8096203186936464, -1.0973937579718509]], 
[[4.6190866433497462, -3.4021534821109265, -4.1568643872319546, -2.9138530848544217], [-3.0502324876317477, 
-0.2195252557679499, 4.7963882308453414, -2.7938807481017855], [4.5130729764595863, -1.1514760287792623, 2.1447315015216439, 
0.005251219702463672]]]]),self.functionspace)
      res=arg0*arg1
      ref=Data(numpy.array([[[[-0.14079839351219756, 0.052714346115412876, -3.3615688741094618, 13.234516283806014], 
[-7.3612411788061189, 11.601747666829775, 0.19543992888649531, -0.70363056785453426], [5.0138145687783977, -6.7139441323378373, 
1.7179724250526256, 1.1035546225645381]], [[2.8904683217343128, 7.0031221583518866, -3.7043378003981324, -15.130014729738475], 
[12.043536568875938, -4.4929632159621393, -2.7172835837498157, 4.9764397623417294], [-0.052934257466043695, 5.0707125814112146, 
0.60913600902174936, 2.3992879179249047]]], [[[12.034334337832099, -2.8924941083603697, -4.1093717600548736, 
9.0721806681321908], [-6.3258375597250271, -11.529658695881023, 3.0215605577023865, -16.034776606930951], 
[-0.17953395588709739, 0.11375732085933073, -4.2204092655472181, -1.2019919893208295]], [[18.608042108129151, 
-0.26594147465662776, -1.2821474542428013, 18.370914125248692], [6.558678148597596, 3.1969609427309815, 0.79503443427800413, 
0.96354953339261717], [6.455612288889963, -7.9168600155197097, -3.3740549481779909, 2.614146918876036]]], 
[[[14.243509758087281, 2.7215983887342077, -3.5534167026919383, 15.70400137561419], [-0.21503155576867608, 0.15964964837874859, 
-0.48221961260043655, 3.1298355699094587], [-4.548613789034051, -13.053312971364296, -18.964965460387159, 
-3.5962507221314728]], [[13.995252145296806, 9.1346578520535626, 3.6214155064230589, 12.435357461420006], [-13.006025223789415, 
-0.42066885344619104, 3.1998666937146365, -6.7148378512407705], [-16.830367142400185, 1.2805653042852543, 2.921317757061098, 
0.0084983701291664066]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[5.5590548493738394, -1.5504570222695666, -4.9739291745795349, 18.621978843920846], 
[-9.1146767038780574, 2.6743863234645109, 8.0543592805305781, -0.81122438187265977], [-3.0927153479060419, -2.2025721757254408, 
4.3987047085823878, 0.66488617013177964]], [[1.5170012443013339, 15.298129211987138, -0.071301021827004596, 
-13.507044632502241], [-11.194781549875337, 8.3276010031957028, 9.3769769755344647, 8.3909181273627045], [0.091827662342332833, 
2.0938789212519029, -2.4604498821929384, -2.6331797573417157]]], [[[-2.6801760755710924, 5.0710583782573808, 
-11.520968086970132, 11.139647479382122], [1.9800192778158905, 10.978445351836195, 1.7323953854684939, -4.9095897973779659], 
[-3.8738576377114988, -1.7857860267761541, 0.7743264306079215, 10.922809099322048]], [[-13.795945262448392, 
0.56986205229456111, 1.5764191724740828, -16.877829460521674], [-6.8974780497432597, -9.1521419389410248, 0.47118274953457795, 
0.12463145542950567], [8.5129020513840903, -0.96050270307216823, -1.2633984843439043, 2.8008858985758018]]], 
[[[11.16046580584497, 1.0936175867916587, 4.4856625833690043, -1.7595697953464473], [-2.793050002706762, 1.1965378346054028, 
0.3509339422574882, 0.74341542598279542], [-12.208180298893025, 6.4679012061055658, -11.866816634497626, 
-0.18245683397427931]], [[-22.736406145805276, -11.677840598674809, 13.539885256110328, 13.99858394382281], 
[14.359450990957598, -1.0863786642494329, -17.95074753079918, 5.1876784692250233], [7.6014454089472663, -5.0917635972789794, 
4.5941776837070236, -0.0032580744412599961]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank4_taggedData_rank0(self):
      arg0=Data(numpy.array([[[[-3.6853536010312693, -2.3043836690594679, -3.1006174475441073, 2.3437722318459233], 
[-4.839623403218857, 3.3070650661975947, 3.3004488645890095, 4.1033479301880824], [-0.27354607956975663, 4.9650437898498456, 
1.3126328960356801, 0.49381572631001092]], [[-4.4720827107305485, 2.1673543435336482, -2.4927169203349187, 
-0.35834092552549279], [-4.0833764908301875, 0.55870124717747593, 3.7593746529652492, 4.7076776912446707], [4.7186987243166829, 
-1.1136008027587643, 2.3837688715431327, 1.9379108447728663]]], [[[-2.4472903587000863, 4.8292799659593602, 3.1855112424406347, 
3.9982086946803559], [-1.5986993609428235, -0.53089241767491657, 4.8247351468277504, -3.2664042427873339], [2.9591345322877878, 
0.28976272252442037, -3.4564049340261094, 0.057829480015172408]], [[3.3927167139023329, 0.15573794671308505, 
2.1605514248164157, 4.0729621537910461], [0.51375655229256356, -3.6480488644297635, -0.15145801860341734, -4.4786288483979941], 
[-0.4557991077643484, 3.7990330664261887, -2.3082848242410501, 1.9010472661724007]]], [[[-3.6792324135066732, 
3.5426859187646063, 0.56055073866233318, -4.341663564534942], [-0.33731566409411773, -2.7906273041665672, -0.51786141371352912, 
-2.2397425512067959], [0.78545825329611407, 0.003860283737826542, 3.1210730627540535, -2.4111256811280866]], 
[[0.15917627004090917, -0.4094101001762942, 4.3958229264446107, -3.6780395794242002], [3.9005874233789903, -3.1816699147914229, 
1.7207051941169436, -1.7049758818030547], [-3.21770597801188, 4.7207551478472922, 2.7885576920595012, 
-0.0031663477611365565]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[1.9812055379765914, -2.8858868804605087, 3.8328594647769325, 2.5968975574073738], 
[-4.9603063186649123, -0.13195011646667432, 3.0816951138207038, -1.4437121918947105], [2.6867098769778863, 4.2229337164969252, 
3.9093973450312589, -3.5223156773421427]], [[-2.1057852818273926, 0.8069303623320554, 4.5466620045316883, 4.2405689916538183], 
[0.39944219075230514, -2.3552454513574883, -0.044173904865877134, -3.7479069271193008], [-4.4204519113208285, 
4.1333858238493644, 0.58890833097824569, -4.2075682467865221]]], [[[-1.209020423113516, 0.99652155769890616, 
-4.5678388249329522, -1.4740798848661054], [3.938090038646191, 2.0545874239970638, 2.4618143555559335, -2.8548176402264325], 
[-3.1637347083158374, -0.98200758348063921, -2.4489939164588925, -3.4853422101499265]], [[4.7555750476739256, 
-1.2285587531755828, -3.2184746576200696, -4.5969546718690282], [2.7011029387853212, -1.1715408543242423, -4.8992902220209444, 
-2.8760132823468032], [-1.4487158678368606, -4.3747137997475791, -3.9532393286181433, 4.7307794982529536]]], 
[[[1.0641075638255035, 4.4122450105895545, -1.6450011661023178, -4.3708835966994863], [-2.8373180386214636, 
-2.0586887385947339, -2.9568899160140258, 4.2552994810803622], [2.6819735587888776, -3.9075458132898122, -1.0624751262898267, 
-0.28376527428938392]], [[1.5999328143968494, 1.283246251925755, -3.4318573085072135, -0.90997649713485895], 
[4.803357375328515, -4.7836372766747175, 1.9157089375671301, -3.3175214440430114], [0.96676766718280938, 0.27431848681883686, 
-4.8688225840741168, 1.1534809358463063]]]]))
      arg1=Data(4.69286431794,self.functionspace)
      arg1.setTaggedValue(1,-0.144374058591)
      res=arg0*arg1
      ref=Data(numpy.array([[[[-17.294864413253695, -10.814159895361806, -14.550776983147102, 10.999005076197115], 
[-22.71169598120996, 15.519607646248749, 15.488558709799555, 19.25645508565297], [-1.2837146361239777, 23.300276838372167, 
6.1600080803538066, 2.317410201635512]], [[-20.98687738004238, 10.171099863090959, -11.697982290153096, -1.6816453430544651], 
[-19.162731830512495, 2.6219091472650793, 17.642235166650696, 22.092492657581747], [22.144212870432177, -5.2259774716906158, 
11.186703879469459, 9.0943526547742728]]], [[[-11.484801599970506, 22.663155633570067, 14.949172044031126, 18.763050918923771], 
[-7.5024791860744067, -2.4914060835689744, 22.641827414035866, -15.328791918928871], [13.886816858543268, 1.3598171412026148, 
-16.220439383226346, 0.27138590328795015]], [[15.921559207534672, 0.7308570530783326, 10.139174688585044, 19.113858759826559], 
[2.4109897923591888, -17.119798345966515, -0.71077193116914517, -21.017597515922226], [-2.1390033689740182, 17.828346720087463, 
-10.832467487312181, 8.9213568821287463]]], [[[-17.266138510736127, 16.625344337821954, 2.6305885598606906, 
-20.374838022485442], [-1.5829766439079056, -13.096035300379024, -2.4302533500517067, -10.510807899919557], [3.686049010121053, 
0.018115787810351756, 14.646772409867271, -11.315085675023237]], [[0.74699263793700277, -1.9213060505196127, 
20.629000559473464, -17.260540702233271], [18.304927538162122, -14.931145214572643, 8.0750360071571912, -8.001220478653682], 
[-15.100257569818783, 22.153863387041536, 13.086322891569807, -0.014859240426411799]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-0.28603468442038837, 0.41664720156622836, -0.5533654769382752, 
-0.37492464010761922], [0.71613955507959037, 0.019050173845831748, -0.44491683092194789, 0.20843458858096017], 
[-0.38789120919547432, -0.60968207981088718, -0.56441556134653437, 0.50853100997613421]], [[0.30402076765833952, 
-0.11649981141008008, -0.65642004663514009, -0.61222815605965464], [-0.057669090251338748, 0.34003634479016592, 
0.0063775659292936602, 0.54110053428904925], [0.63819858324315626, -0.59675368711109933, -0.085023085881304666, 
0.60746370458664123]]], [[[0.17455118540414913, -0.14387186175828684, 0.65947743014452054, 0.21281889566528192], 
[-0.56855804197562643, -0.29662912513221662, -0.35542213000887707, 0.41216160925630002], [0.45676122014435949, 
0.1417764203941124, 0.35357119118352021, 0.50319300045741766]], [[-0.68658167056615438, 0.17737201341329772, 
0.46466424879246998, 0.66368100313599232], [-0.38996919394416291, 0.16914010794380596, 0.70733041356772797, 
0.41522171013365755], [0.20915698958460188, 0.63159518644304424, 0.57074520645364712, -0.68300183646125823]]], 
[[[-0.15362952776673111, -0.63701371967612985, 0.2374954947369054, 0.63104220448376391], [0.40963512074886738, 
0.29722124856624021, 0.42689819798136147, -0.61435485660319467], [-0.38720740771574935, 0.56414824819441189, 
0.15339384613430937, 0.040968344336309789]], [[-0.23098879388718618, -0.18526746956204321, 0.49547116813392567, 
0.13137700011366271], [-0.69348019913856629, 0.69063312846010516, -0.27657867439537004, 0.47896403533873316], 
[-0.13957617182560958, -0.039604473288541532, 0.70293167702166726, -0.16653272421532611]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank4_taggedData_rank4(self):
      arg0=Data(numpy.array([[[[-1.3532883833167708, -0.86914255675510166, 3.2812005170107668, -2.4254100040245508], 
[1.0718751931878572, -0.41578362451623629, -3.862213555754932, -3.9930189204001989], [-4.7152892619512912, 3.3779166105093417, 
-1.0344310528206933, -1.2103354491532992]], [[1.0351292574290207, -4.506692668861132, -3.409400143885831, 1.313196181127104], 
[-3.5468061926677565, 1.3853384951420775, -0.69672269217629434, -4.9994576294080497], [-4.7942344611987426, 
-3.2733793480036102, 1.8741546503467701, -1.0299243977249906]]], [[[3.7347053603078297, -4.8293907831328386, 
-4.1883854607206503, 2.575419140175538], [0.97856794803764835, -3.1602267239490134, 2.7307395654890243, 0.73531000496875887], 
[0.88235128630099524, 3.7961315455018934, 4.4525982851379329, 3.5472345173950615]], [[-2.4381751265411458, -1.576676482280972, 
3.7575819661811991, 1.1610148298722924], [4.9794248794760669, -1.681142970119105, 1.681322338237945, -1.4299463616495145], 
[4.8870647335375654, 3.1463465240231212, 2.5220247241367311, -3.3418191799995824]]], [[[-0.82120587395565003, 
-2.0207299168197554, 0.1628873085127891, 1.6033505537422883], [3.7693550920380954, 0.57282097377781049, -3.2714424016177102, 
3.2469388374060397], [-3.9961007411141058, -4.7460546115849152, 2.2646072665984276, 4.9707369943911193]], 
[[-2.6891597834956551, 0.19702474540645554, -2.722659084034369, -3.5315295817554926], [-4.0155970073115785, 
-4.6190821703368554, 4.5632739542389338, -1.9818054349040484], [3.2046427296749833, -0.065937911917783865, -4.443899025501592, 
3.1613250438570049]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[-0.3639682004592153, 3.1067676913355395, -4.4361282666281463, 0.21858042794671029], 
[-1.3042462944217368, 0.078196553344779929, -3.7361198141846872, -1.9812371453675803], [3.1505866455886231, 
-4.7119825320538133, -0.80627211906748286, -2.0210407646942019]], [[3.4657015425999589, -4.2754173257453045, 
-0.017767757118610561, -2.2548665541057735], [-3.0928854938082182, 4.0893764899848009, 1.0738528488015051, 
-0.24469493230951489], [-0.26422542720117548, -3.8668777591475409, 3.3530488435952641, -0.93780420938814935]]], 
[[[4.3350161876545616, 4.0925556508337397, -4.4830309625775255, 2.7613323055559214], [-3.8925103131433101, 3.0119873782008337, 
1.6071354400323976, 1.0307349591055619], [2.141544221037476, 2.2756717030147291, 3.9435543723119029, 0.043314503204946675]], 
[[-0.027142010289551877, 2.3862273147475079, 3.0913137938867425, 3.493217319413052], [1.5529622358287423, -3.5117922193209061, 
-2.3696213312111358, -4.6653656536525512], [0.65584705078964323, -2.3701842815076688, -1.4603526815741286, 
4.8503311497567552]]], [[[-1.5965176195255126, 3.562069694403263, 1.7660449437432613, 3.8831423784808123], 
[-0.92820469100342251, 1.7650058945896188, -1.542239523480895, -4.4465476751882829], [0.57362353277394273, -1.8075398487321492, 
0.98683103823109697, -4.9809873860131804]], [[3.6904196018452922, 3.3995698359526472, 2.1221400586440904, -3.6927178186697187], 
[-0.78155054794039192, 2.0612311645734724, 0.438384322119588, -4.3317494375427801], [-4.3414329593629191, 4.7193189752592293, 
-0.6041773666034489, -3.9525134655897389]]]]))
      arg1=Data(numpy.array([[[[0.17361170468618869, 3.7181882426283313, 3.721151186714275, 4.2294408823886833], 
[0.98325151852268622, -1.9221434482898903, -3.151965683776222, 3.4239072041508294], [2.9877537129846754, 3.1041364843966122, 
4.2435682888207147, 4.0080403419474173]], [[-1.0887631682949817, 0.12444941407842691, -0.77703164515124001, 
2.7420517592483176], [-1.8327369087131906, -4.4220882938756247, -0.66912001794140163, -0.51938895410348795], 
[-3.6221403069574185, -1.4417680447117065, -3.224451927550108, -4.1870446314851737]]], [[[-0.047703848894011358, 
2.8798078234621096, 0.53392801405645685, 4.4439237032623939], [-1.8206629291848753, 4.9984481949485104, -0.099733523715559436, 
-1.5568880269781094], [-2.4228123918565068, -0.51415636268171738, -4.7966640101476852, 0.23819887889085312]], 
[[2.7804216110403521, -2.1241218684525132, 0.3522687248050449, -2.6744563249858477], [-0.21916560615891534, 2.3467670261694078, 
-4.9494066033264241, 3.1270098095582863], [-2.6490613205813194, -2.2718605579630422, -4.0243564500342535, 
-2.177128723782503]]], [[[1.3113395293370314, 3.9380794280623501, 3.1423701341462174, -1.7589162798020008], 
[3.9958761366752409, 2.1706307402668026, -1.388492375572361, 1.0892496485812151], [-3.0074315675500705, -3.1441779947901072, 
0.22496659394695406, -2.162496913136712]], [[2.0402055778911343, -2.7807437093397933, 2.1623702441393799, 0.58586348625903373], 
[-4.5029154412593355, -2.59191035799337, 4.8997443075063121, -2.2452696666134306], [-3.995560920629976, 2.4780588942964776, 
1.1739429456848534, -3.219490419401112]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[-3.0416099889879247, 2.5768080142200409, -0.006941836946602109, 
3.7226676145652267], [-3.0309068128007519, 2.1655449390987682, 2.9405918020645494, 2.4707474992815346], [3.4234672550999719, 
1.5578847985536424, -4.2980321616443673, -1.5429500819106465]], [[0.27189302867058274, 3.2728969311121698, -4.6453457389835489, 
2.1731561048971235], [-1.9540838017554973, -3.1021084519421569, -3.0636334800343015, -4.1604600663474738], 
[0.20804999840622784, -4.6185369410264627, -4.7906356005732684, -0.22034620329094601]]], [[[3.1426525315782534, 
-1.2129314362286117, -2.0072575705897822, -0.9942767712969971], [-3.9284905647224164, -0.67630606537903226, 2.5559113502400974, 
-3.5596976735889454], [3.605101361300548, -1.9248106664350031, 2.2873826181945969, -1.476288108605849]], [[1.9758409585878454, 
-0.37128059028854921, -0.70181805182146917, 2.7445063845885587], [-3.2333688843193209, 2.0855781334561012, 4.1363428588569615, 
1.9273289450711921], [-1.373932771958124, 2.7040407687642514, 1.1678373725636995, -0.50122149444354758]]], 
[[[-3.0325515873861617, 2.898093807978384, 1.0824495879840423, 1.1636657138837094], [-4.4083178004461541, -4.6228041665866568, 
3.9431484918408994, -2.7317220890863778], [-2.4776817725398703, -0.80581003932262885, -4.0817151567241572, 
-3.8388617165159422]], [[-3.1955817960738173, 1.273034042249515, -3.5853253604684667, -0.59646188150604473], 
[-0.410262145680516, -2.5168468692194681, -1.3464155324549463, -0.87646416351853595], [3.9325186707214748, -3.2848178431879624, 
1.1863050818384941, -0.98444346424489293]]]]))
      res=arg0*arg1
      ref=Data(numpy.array([[[[-0.23494670315964095, -3.231635635694746, 12.209843197722108, -10.258128227575936], 
[1.0539229113687583, 0.79919576977010742, 12.173564591154888, -13.671726247868808], [-14.088123000191739, 10.485514191931388, 
-4.3896788127213195, -4.8510733074954704]], [[-1.1270106099132522, -0.56085526207130987, 2.6492118027824816, 
3.6008518986977478], [6.5003626173547051, -6.126089142423055, 0.4661911002891837, 2.5966630692229504], [17.365389882912247, 
4.7194537421708453, -6.0431215748376417, 4.3123394203300229]]], [[[-0.17815982017177895, -13.907717359821753, 
-2.2362963311455148, 11.444966162861727], [-1.7816423866806577, -15.796229563950991, -0.27234627921571608, 
-1.1447953428530748], [-2.1377716304205796, -1.9518051876965798, -21.357617945966425, 0.84494728520644002]], 
[[-6.7791548133360466, 3.3490529954877939, 1.3236786075770843, -3.1050834551543205], [-1.0913186720331562, -3.9452508885520174, 
-8.3215478831951089, -4.471456300020213], [-12.946134156791416, -7.1480605696122463, -10.149526465725513, 
7.2755705264643815]]], [[[-1.0768797242418076, -7.9577949150980229, 0.51185221350204935, -2.8201593912068637], 
[15.061876062930331, 1.2433828143516794, 4.542372831770324, 3.536726987609228], [12.017999515936793, 14.922440471817399, 
0.50946098339417001, -10.749203406385254]], [[-5.4864387901283509, -0.54787532137327555, -5.887396988251699, 
-2.0689942325941804], [18.081893770098084, 11.972246921718591, 22.358875580874034, 4.4496876281196975], [-12.804345255270336, 
-0.16339802909920201, -5.2168839123233886, -10.177855691310427]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[1.1070493141907085, 8.0055438853533119, 0.030794879101145239, 0.81370228029502634], 
[3.9530489793329773, 0.16933815035075503, -10.986403297122418, -4.8951367224006352], [10.785930215527911, -7.3407259577369368, 
3.465383498789198, 3.1183650134296745]], [[0.9423000888858134, -13.993000244655608, 0.082537374822232182, -4.9001770177833022], 
[6.043757444135192, -12.685689372755402, -3.2898915402185036, 1.018043494311335], [-0.054972099708089431, 17.859317777056546, 
-16.063235160588501, 0.20664159696894605]]], [[[13.623449596565317, -4.9639894034112881, 8.9985978388221373, 
-2.7455285692462343], [15.291690038268193, -2.0370253327223131, 4.1076957125519185, -3.6691048360148653], [7.7204839865475261, 
-4.380237167267059, 9.0204177251315496, -0.063944686011632709]], [[-0.053628295628509341, -0.88595988598211439, 
-2.1695398243944282, 9.587157235884451], [-5.0212997718516181, -7.3241170618569544, -9.8015662715503087, -8.9916942636255435], 
[-0.90108975647197509, -6.4090749266809413, -1.7054544386658832, -2.4310902274271711]]], [[[4.8415220413820697, 
10.323212124937552, 1.9116546217161945, 4.5186796479669598], [4.0918212618080094, -8.1592766035588991, -6.0812794510711186, 
12.146732504487513], [-1.4212565714539249, 1.4565337565840717, -4.0279632058737045, 19.121321786614814]], 
[[-11.793037699530801, 4.327768130172319, -7.6085625707226967, 2.2025654179946379], [0.32064060475580819, -5.187803203294342, 
-0.59024746048654575, 3.7966231473478214], [-17.072766170380266, -15.502103177627047, -0.71673868033347032, 
3.8910260485397501]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank4_expandedData_rank0(self):
      arg0=Data(numpy.array([[[[-4.219787807434507, 1.5796496812971137, -1.7744109604039302, -4.2008893090615596], 
[2.8752093545708179, -1.0095586121336089, 3.771790436102302, -3.8721949429711078], [4.4733773137550816, 4.1541057915802853, 
-0.10058389331172979, 0.47659781326370165]], [[3.7059037859503547, -4.5868486303599445, 3.5371896610419249, 
-0.57976334508050709], [-0.65945228435021708, 0.36942654726328872, 0.98907938321894662, 4.9988213699853841], 
[0.60159248424116463, 2.8662094019597628, -2.1208711695657687, -1.618663569351483]]], [[[-3.7154727686203626, 
3.1919537523432613, 4.7257091736043559, -0.83222213923911159], [-2.0647818468730583, 3.4541499207879554, 3.3533889441660634, 
1.7850365811951443], [1.5523183163777396, -1.9561720331748034, -4.3855857548606361, 2.3550105107187056]], [[3.9013257398261167, 
-3.9383655000401618, 0.025731152155249681, -1.7415610678131568], [-0.27743255102651876, 2.7351823089627834, 
-3.6020506556431062, -2.2550872223543683], [-0.021705716201745773, -2.0213798554217099, 0.25438063169193015, 
-4.4722880786941861]]], [[[-2.9825705407619898, -3.8339015400602037, 3.6932899083694473, -3.6255589482244952], 
[-1.2164701276291678, 4.4246508749014435, -4.9938101420542482, -1.2978973042503705], [-4.3985371353145295, 0.46234959255329056, 
4.107074059471417, -1.4193215194522768]], [[0.31199713941376661, -4.4324808375787867, -4.0751941316416538, 
-3.5281587032772457], [2.6698831844651458, -1.8060718647690788, -3.7342749134169315, 0.79369516880371194], [1.3305617547536279, 
-1.3757441783790405, -0.20260136784400551, 3.5000973473473689]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[-2.5041103122322728, 4.2752335695684192, 4.9655672044695649, -1.3576787307638103], 
[3.5213714911712817, 0.98927721064827701, 4.5717752100063951, -4.894727899560789], [-4.0187288515692003, -1.0636466842872161, 
-4.4769297344832442, -3.0288375796990854]], [[2.9588312431302919, -0.39339057549385892, -4.3709439232853811, 
-0.6857964941070076], [-0.67745281775481025, -1.2671412867118548, -1.1036243359258502, -4.2903959394195148], 
[-0.098431373327820815, -4.4170655530127165, 2.3496671706657679, -4.1361192080217188]]], [[[-1.7023975983252306, 
2.8717010449851301, -1.0473737833456722, 4.0132252265937929], [-2.8573855499158443, -3.8128342714691077, -2.3702141920570998, 
-1.8232668841397839], [2.8213427401622013, -1.7610558539831711, -4.7158717933692209, 1.7701316720619333]], 
[[-4.1644145919808997, -4.0112750193492976, 4.8068093588426137, 3.3439679884419409], [2.5699708818283797, -2.0878984330137507, 
1.3003601650287528, -2.7107070474101858], [2.3376036425530335, 0.072655631320497349, 1.8230728843886865, 4.0351791993831796]]], 
[[[-0.69856999838536993, -4.5944466713717125, -2.1974174417292858, 0.3138573585645501], [-4.3212470737617608, 
-2.0763103884085399, 4.4625204633066424, -4.7824999240155943], [1.3312784017002421, 2.2228773838747786, -0.94865273080767398, 
2.5654964449496598]], [[-0.3944517100311673, -1.6172194429567508, 1.498853714509262, -1.0831482576208353], 
[-2.9297762932729121, 0.17156975072456415, 4.9004221503595957, 4.1459712952877794], [1.8389357610379431, -0.492208305981233, 
0.63935979578977964, -0.55597290481337414]]]]))
      arg1=Data(2.02968704328,self.functionspace)
      arg1.setTaggedValue(1,-3.43982262728)
      arg1.expand()
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-8.56484863811996, 3.2061944910423548, -3.601498935777141, -8.5264906008350341], 
[5.8357751736756827, -2.0490880344743538, 7.6555541781056906, -7.8593439047837288], [9.0795559734093541, 8.4315347015644591, 
-0.20415382501698051, 0.96734440643456943]], [[7.5218248979674858, -9.3098672345056084, 7.1793880246233526, 
-1.1767381496757221], [-1.3384817572037868, 0.74982027642214455, 2.0075216088899994, 10.146042966305899], [1.2210444705959571, 
5.8175080864709345, -4.3047047333232973, -3.2853804741340924]]], [[[-7.5412469381101239, 6.4786671738643777, 
9.5917106799509284, -1.689150493140291], [-4.1908609617878287, 7.0108433397529426, 6.806330091035746, 3.6230656206238225], 
[3.1507203737904783, -3.9704170301519603, -8.9013665838123774, 4.7799343203823765]], [[7.9184703057206196, -7.9936494271130822, 
0.052226186138049822, -3.5348239344126702], [-0.56310125420127655, 5.5515640934969674, -7.3110355449793047, 
-4.5771213166678413], [-0.044055810939689292, -4.1027685020866906, 0.51631307220523981, -9.0773451671191729]]], 
[[[-6.0536847822385473, -7.7816202810525548, 7.4962226740760594, -7.3587500218412698], [-2.4690536565800998, 
8.9806565518031896, -10.135871741903173, -2.6343253419386263], [-8.9276538329121706, 0.93842497746892439, 8.3360750042803033, 
-2.8807784982737799]], [[0.63325655140700965, -8.9965489255987201, -8.2713687278236883, -7.1610580066600189], 
[5.4190273065669059, -3.6657606631454542, -7.5794094077895018, 1.6109528004309184], [2.7006239539007879, -2.7923301337170536, 
-0.41121737126278562, 7.1041022361124178]]]])+(1.-msk_ref)*numpy.array([[[[8.6136953132280301, -14.706045169519202, 
-17.080670427226341, 4.6701740186615464], [-12.11289333439851, -3.4029381338428641, -15.726095814229224, 16.836995783300171], 
[13.82371443654077, 3.6587559320451768, 15.399844201429321, 10.418664041012491]], [[-10.17785466043, 1.3531938029434625, 
15.035271809900019, 2.3590182981402981], [2.3303175314292877, 4.3587412699953063, 3.796271962737368, 14.758201032416226], 
[0.33858646520752966, 15.193922035443254, -8.0824383002389713, 14.227516440890902]]], [[[5.8559457793505212, 
-9.8781422333306654, 3.6027800391749274, -13.804782942818287], [9.8288994694705849, 13.115473601077642, 8.1531164093441326, 
6.2717146836388977], [-9.7049185969291649, 6.0577197744396267, 16.221762502194771, -6.088938978828053]], [[14.32484754288134, 
13.798074575810782, -16.534571597580133, -11.502656751550949], [-8.8402439907704338, 7.1820002733483852, -4.4730083192827168, 
9.3243514376157073], [-8.0409419032719303, -0.24992248461574224, -6.2710473589053866, -13.880300715177963]]], 
[[[2.4029568871866984, 15.804081620027203, 7.558726237645633, -1.0796136437294579], [14.864323462404016, 7.1421394553094224, 
-15.350278864393395, 16.4509514536057], [-4.579361569380981, -7.646303922727002, 3.2631971288655759, -8.8248527215506645]], 
[[1.3568439175354867, 5.5629480331638401, -5.1557909221553908, 3.7258378852657694], [10.077910786476027, -0.59016951069957468, 
-16.856582996043326, -14.26140587359466], [-6.32561284093729, 1.6931092682506359, -2.1992842925324059, 1.9124481781330267]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_taggedData_rank4_expandedData_rank4(self):
      arg0=Data(numpy.array([[[[-4.2394854110487303, 1.4146864059729189, 2.6339572727432206, -1.9099050735732281], 
[-3.7267735570270277, -2.6937015349589433, -2.1242184643289272, -1.6619537233941859], [2.5812342814590306, -3.6361172012107748, 
-3.9702608399881223, -2.8501771743320106]], [[-2.2794585618161478, -4.7922663940853374, 4.577444720247108, 
-1.0064711307914487], [-2.4819548030669516, 1.5644493036592912, 4.9832258136037115, -4.028809177111027], [2.4649674216494235, 
-1.5871505000792006, -2.6698101449565659, -3.9627802054123729]]], [[[3.3665933304136644, 3.0110535022832892, 
3.9021632939504762, -3.4933144632862878], [-2.7254540423406137, -4.7397334432458607, 4.2808274791795906, -3.5138505089043379], 
[-0.22833830687890444, -3.1736127048623408, -4.8811238683923275, -0.14067811106407291]], [[-0.1737715656165868, 
-1.4369085474480778, -1.6091832873688716, 4.1522604863368802], [3.3704701836422082, 3.593267828048857, -4.3551593227583831, 
4.8231059928543516], [1.7866455069102223, -0.72443356744384424, 3.8433024010291561, 2.0202923842337857]]], 
[[[-3.2672367899992869, -2.1653132468587364, 2.8923684681644293, 4.1694578198639789], [4.5654751634869335, 0.58188185781572699, 
2.1766927230242326, -1.8083159898852061], [-0.74625321126536193, 4.9614122672885141, 2.2333602939839778, 
-0.28440741321638097]], [[4.3071547407602111, 1.678860106484751, 1.6981586430685036, -1.929143739510554], [3.0097412240058361, 
0.91482986195855531, 1.4049470245084592, 4.1236759526135192], [0.84332517950769414, -0.59028341536362561, -0.61360183887460007, 
-4.7412772223799635]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[2.3924820183504734, -1.7711910590418514, -0.10584956777879562, 
-3.2361969625748035], [4.0445345542779307, -3.2546124979256041, -3.0185886115606806, 0.26858683928314875], 
[0.33662527965318922, 4.4923945866400832, 0.14154363036042916, 2.9397054406772867]], [[-1.0780623874281945, 
-3.5117616732311663, 0.77355505090137555, 2.9395229091423829], [-3.127675963853469, 1.3334512834354451, 4.7125522862875648, 
2.1904817752448054], [-0.33640128241009748, 0.011885043625820657, -1.4655070888112443, -1.854914407272469]]], 
[[[-0.65747943533845721, -1.473505921804541, -2.5892839184825442, 1.0527728108429271], [-2.6000274010310842, 
3.5700410692848639, 1.4849718178524576, -1.6443043504846235], [4.8593803886502691, -3.6448662474437379, 2.94294954621237, 
-2.453361363934603]], [[3.8161736639588568, 3.9653639374103626, -1.1491407536370515, -4.4102526954228782], 
[0.67204940063191287, 1.7631920792795599, 2.9290670362585614, 2.1383785725901872], [-0.021058422970627433, -1.3154526687604564, 
2.6442197841892341, 2.8890951961321498]]], [[[-3.1060387003099441, 3.2017791759102714, 4.4161403626231017, 
-4.9786479768044369], [3.7974780735206011, -1.0567047990468517, -0.99938043262372922, -1.3679330546498725], 
[-1.734360386599537, 0.10178547721658138, -4.6423158212394009, -4.3171267157925381]], [[1.0381739953991413, -3.035377931244867, 
-1.8701732836810283, 2.7263167680515039], [-3.4748171926567961, -0.49805298091144223, -0.42339941212675569, 
4.8182237036577611], [1.0208561871184596, -0.54877187031640329, -0.31092353528725702, -3.4936261759643883]]]]))
      arg1=Data(numpy.array([[[[4.0512893002520549, -0.36063442320618044, -2.7147506017148579, -0.43512381874642969], 
[2.5947300183717541, 4.954831448399629, 4.3586409482416748, 4.9869341533921254], [-0.21381584088776151, 2.1045302789994311, 
0.61838596738128082, 3.4604616411556979]], [[-0.21429219356302909, 2.9799157531796316, -4.647510555578604, 
-0.10828874066454741], [-4.0832424404990295, -1.1519071861447525, -3.7878420079642385, 2.0493199951536454], 
[-2.6137169520131209, -4.5270477141436789, 3.6306974526171292, -2.0574052220587125]]], [[[-1.7759675552198284, 
-4.1240173429310314, -4.950207407606726, -4.1465456522941837], [-0.6102729449932589, -4.1667452308588349, 3.1247577740575885, 
4.5519701768248364], [0.86486899819522733, 1.3946391511015745, -2.0023303415569691, 3.2204493004422794]], [[2.8617389996771152, 
3.0809122511886464, 3.3742657689833422, -1.9139996963109871], [-2.2416867605376876, -4.3192330519657407, 0.33565929769889369, 
2.5048671063277226], [-2.8817451711409037, 4.5579806848888129, -0.70937100201677161, 1.4096195824246376]]], 
[[[0.13529718870683993, 0.84979715549012713, 1.0344349954728944, -3.1614554350075075], [-2.5788449190429965, 
-2.9421670970720815, 1.9278775903131304, 2.0810013182523468], [2.893043418882602, -1.726615700798062, 2.193493761946673, 
-0.9653312924060593]], [[-0.64639620826285071, 3.2260546910856718, -4.1710602679281186, -4.4385521879585363], 
[4.0839306655936305, 2.4623572609301316, 1.1548126176099869, 2.8606578337879416], [2.3065764567839766, -3.9815898786205639, 
1.0218088114890023, -2.0555266494461302]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[-4.5229733152567189, 0.17018496484498602, 3.8220149916066788, 4.0803015367435815], 
[-2.6065320703964301, 0.49598892177018516, 4.2579140430982481, -0.9893732307274643], [4.3150720827787943, -3.6543668271423591, 
-1.0072948541243876, 1.1031734799326944]], [[0.37641962181737121, 0.1412445396703399, -3.1847463824420377, 
-3.7390870938195953], [-2.2524747478408247, -0.78551792367013995, 4.8899458606077548, 1.8324940714526514], [3.0382746479145144, 
0.9766053898523408, -4.6065190329090102, 2.1439276945665942]]], [[[1.5480328969624546, 0.92756057524764124, 3.0392485660817972, 
-0.7731502623624511], [2.3732488385370498, 2.7253120356440617, -2.9780020940216048, 4.870020149206999], [-4.5963422086205421, 
1.9390615325682212, 1.3467338995432607, 2.8387787116392609]], [[0.18494202665104886, -3.8818697667182711, 4.0607887425002058, 
-4.0822879442560289], [2.868768972607505, -4.9844191744945192, -1.9074966426847926, -2.8972500413637228], [1.9608833531223882, 
-4.3321364220346155, -2.2273706191195197, -0.6814990272056356]]], [[[-4.6794835771501555, 0.88526237919283357, 
4.0259691601531635, 4.1508554972608263], [4.7558119583318739, -3.1955366004548083, 4.0857809211084746, 2.0165832985625078], 
[0.53993917461036567, -3.0257062484534449, 2.5766427682780062, -3.6681108125293624]], [[-4.9898032979548397, 
-2.8453427014203858, -0.54434901106418376, 2.4540928261003376], [2.7394397356634084, 1.4697964097252161, -4.8203862302173794, 
4.0458762828142447], [1.5283750153098143, -0.82582519593759862, 3.7525569131034153, -1.2872056644821841]]]]))
      arg1.expand()
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-17.175381884356405, -0.510184616035668, -7.1505370910708841, 0.83104518905636382], 
[-9.6699712200921066, -13.346837078016925, -9.2587055816351089, -8.2880537845516749], [-0.55190877841847952, 
-7.6523187479387422, -2.4551535902920714, -9.8629287822734586]], [[0.48847017534760984, -14.280550121168245, 
-21.273722654925983, 0.10898949126862896], [10.134423187283387, -1.8021003952442916, -18.87567207193991, -8.2563192033121311], 
[-6.442727136125173, 7.1851060433855416, -9.6932728922651723, 8.1530446884863128]]], [[[-5.9789605264341352, 
-12.417636863909506, -19.316517643404708, 14.485187899836147], [1.6632708648629886, 19.749261720186812, 13.376548944965775, 
-15.99494272235332], [-0.19748272271995246, -4.426044528634387, 9.7736224225798836, -0.45304672436383486]], 
[[-0.4972888663599373, -4.426989147670465, -5.4298120825888683, -7.9474253098529006], [-7.5555383874577666, 
-15.520161167473773, -1.4618497196438685, 12.081239551832978], [-5.148657062079125, -3.3019542078941391, -2.7263272752715166, 
2.8478437070393046]]], [[[-0.44204795252646345, -1.8400770379256457, 2.9919671632716138, -13.181555085643529], 
[-11.773652428375271, -1.7119936564486071, 4.1963971217160836, -3.7631079587679115], [-2.1589429416712633, -8.5664523188324591, 
4.8988618730332432, 0.27454737577003319]], [[-2.7841284928287622, 5.4160945222017212, -7.0831220447417627, 8.5626051658910818], 
[12.291574480218742, 2.2526379531093585, 1.6224505509759761, 11.796425917846816], [1.9451940044655682, 2.3502664721293898, 
-0.62698376570792136, 9.7458216830139417]]]])+(1.-msk_ref)*numpy.array([[[[-10.821132326230726, -0.30143008811679101, 
-0.40455863490564409, -13.204659439598881], [-10.542209025551957, -1.6142517436258894, -12.852890839500665, 
-0.26573262891244709], [1.4525623465890813, -16.416857751851431, -0.14257617049614474, 3.2430050809690374]], 
[[-0.40580383617125332, -0.49601716096747867, -2.4635766499779219, -10.991132171561315], [7.0450111280086514, 
-1.0474498834794941, 23.044125545229488, 4.0140448667611848], [-1.0220794878725301, 0.01160699766360666, 6.7508862974720723, 
-3.9768023688020251]]], [[[-1.0177997949802307, -1.3667660004598259, -7.8694774364267293, -0.81395157491126413], 
[-6.1705120096615245, 9.7294758938656347, -4.422249183127688, -8.0077953182888439], [-22.335375188096126, -7.0676199317744359, 
3.9633699185296547, -6.9645500118958124]], [[0.70577089146490968, -15.393026382668209, -4.6664178359175414, 
18.003921409647472], [1.9279544685923022, -8.7884884082778996, -5.5871855378619015, -6.1954174078882183], 
[-0.04129311104611344, 5.6987204177998096, -5.8896574577976573, -1.9689155656685351]]], [[[14.534657088093198, 
2.834414650916397, 17.779244906828215, -20.665648323445186], [18.060091633552361, 3.3767388612304576, -4.0832495045431658, 
-2.7585509515585271], [-0.93644911561746869, -0.30797295441602601, -11.961589488859076, 15.835699185257985]], 
[[-5.1802840260935881, 8.6366904427200915, 1.0180269774904249, 6.6906344221522538], [-9.5190522917304001, -0.73203648319657932, 
2.0409486960979466, 19.493937007922344], [1.5602510906162943, 0.45318963732908618, -1.16675826178875, 4.4970154032845926]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_expandedData_rank0_taggedData_rank0(self):
      arg0=Data(-2.54431206556,self.functionspace)
      arg0.setTaggedValue(1,-3.79955668696)
      arg0.expand()
      arg1=Data(-2.58821102962,self.functionspace)
      arg1.setTaggedValue(1,-0.733629696423)
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*(6.58521655088)+(1.-msk_ref)*(2.78746761879)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_expandedData_rank0_taggedData_rank1(self):
      arg0=Data(3.22855076369,self.functionspace)
      arg0.setTaggedValue(1,-2.15227940214)
      arg0.expand()
      arg1=Data(numpy.array([-3.1609845879711775, 0.039514337730838456]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([3.9944952159708684, -2.5212639479439822]))
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-10.205399205519777, 0.127574045257767])+(1.-msk_ref)*numpy.array([-8.5972697752800649, 
5.4264644625175018])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_expandedData_rank0_taggedData_rank2(self):
      arg0=Data(1.69529493556,self.functionspace)
      arg0.setTaggedValue(1,4.19653106003)
      arg0.expand()
      arg1=Data(numpy.array([[-2.2257987111652633, -4.280537205809213, 4.6322346945409638, 1.5074631886752794, 
-4.9100797308893531], [-0.52015417144620013, -1.288735641855153, 4.9454698768775742, -2.9825531028096828, -3.433428787179321], 
[-4.5263639291271582, 1.6571499872310271, 1.2291625556187284, 3.7349821867623305, 2.6238268621102794], [-0.4470624147841038, 
-0.081930218673285538, 2.5730671661748916, -1.9045103078467518, -3.9473308599285986]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[1.3623423990229586, 3.8388124064188229, -2.3194658071474072, 3.9004425375488996, 
4.9300059065560191], [0.82313827131608708, -4.3949019743858688, -0.92848180246848777, 0.78806224072270403, 
-4.9435549474481029], [-4.199054678791434, 4.3298205134767347, 0.093224119518392712, -2.3101879221820454, 4.7940584387014304], 
[-0.072351787242702414, -4.9619844496927232, -4.1818012068710333, 1.0638110327773829, -3.0879465009415985]]))
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-3.7733852826070637, -7.2567730464703155, 7.8530040179652563, 2.5555947092993301, 
-8.3240333009562431], [-0.88181473256142584, -2.1847870069084325, 8.3840300362186859, -5.0563071702221274, 
-5.8206744344996286], [-7.6735218455357215, 2.8093579808105829, 2.0837930555163404, 6.3318963856126054, 4.4481603911131407], 
[-0.7579026476612325, -0.13889588478587259, 4.3621077356634803, -3.2287066796080981, 
-6.691890015803561]])+(1.-msk_ref)*numpy.array([[5.7171121918978116, 16.109695497171245, -9.7337103023753624, 
16.368328256692433, 20.688922913001587], [3.4543253222786787, -18.443342641304508, -3.8964027227331348, 3.307127670430928, 
-20.745781883938854], [-17.62146338231927, 18.170226269167092, 0.39121791310303328, -9.6947753699468215, 20.118415141617156], 
[-0.30362652241279886, -20.823121862529327, -17.549058651511928, 4.464316041054583, -12.95866340291732]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_expandedData_rank0_taggedData_rank3(self):
      arg0=Data(-1.79538932421,self.functionspace)
      arg0.setTaggedValue(1,1.67233948388)
      arg0.expand()
      arg1=Data(numpy.array([[[2.006076901865419, -0.21180380381218367], [-4.7516938316925907, 4.4895326313297694]], 
[[-1.4536137685907145, 0.37356845302733444], [3.4608233559137282, -3.9965816103050509]], [[0.72700080266957912, 
2.3240241936289818], [4.2646674443814039, 1.6300285776269661]], [[1.4450634931594823, -1.4217502578877426], 
[-4.6200423766436778, -3.5260862034215332]], [[-1.7957701759162017, -4.2794877311083113], [1.8749216910730482, 
-3.6011197035525608]], [[-2.0663557095947613, -3.035040215113435], [1.7109419450569572, 
3.8030711274074775]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[-0.38773511596923793, 0.69166649005324743], [-2.4838005031008725, 
0.2114193801043518]], [[-2.0219425518790732, -1.0837798424159129], [-2.3985472013086016, 1.933325258994703]], 
[[-3.5733445026210751, 0.78035338401677734], [4.197561801162033, -3.8411731530245721]], [[-2.9459009939039094, 
-3.9045136836735117], [3.3618947957571468, 1.9786572454639622]], [[-4.325266590787753, -4.4546197095344162], 
[4.1002239839438026, 2.0282127912929546]], [[3.6435123278846255, 2.1550798550760328], [3.6603646425060745, 
2.430236386148561]]]))
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-3.6016890531438066, 0.38027028819044617], [8.5311403773125551, -8.0604589569603267]], 
[[2.6098026416454498, -0.67070081242512625], [-6.2135253061675044, 7.175419956456496]], [[-1.3052494798015701, 
-4.1725282264360617], [-7.6567384009278259, -2.9265359064208343]], [[-2.594451568417202, 2.5525952346976362], 
[8.2947747604016566, 6.3306975258502494]], [[3.2241066025660339, 7.6833465854989758], [-3.3662143878733017, 
6.4654118709432451]], [[3.7099129810168852, 5.4490788007481008], [-3.0718069024901329, 
-6.8279933013404008]]])+(1.-msk_ref)*numpy.array([[[-0.64842474372262082, 1.1567011809935837], [-4.1537576514196308, 
0.35356497700619943]], [[-3.3813743636469291, -1.8124478223066991], [-4.0111851887011749, 3.23317616580173]], 
[[-5.9758451012431282, 1.3050157754715819], [7.0197483361148443, -6.4237455282275162]], [[-4.9265465477104406, 
-6.5296723985617264], [5.6222294075994705, 3.3089866366570417]], [[-7.233314098086681, -7.4496364259299019], 
[6.8569664611059844, 3.391860332592151]], [[6.093189525929442, 3.60402513256067], [6.1213723170656795, 4.0641802637210489]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_expandedData_rank0_taggedData_rank4(self):
      arg0=Data(-3.15397247664,self.functionspace)
      arg0.setTaggedValue(1,3.49662325766)
      arg0.expand()
      arg1=Data(numpy.array([[[[3.4812249215396491, 2.9178310230201774, 0.0022048924324336028, -1.9175704500433586], 
[-1.0012714533135236, 3.2233211055221496, -2.8814905448902692, 0.16733940052608176], [-1.5169811959524471, 2.6944106601477138, 
2.6501612838465363, -2.8482883183224761]], [[-0.35065201828540538, 3.4216611888074411, -4.1671316880540754, 
2.1007050688880629], [4.5637534106035496, -0.3341293870761417, 0.24400566710331173, -0.86330674582364519], [3.5806375506866921, 
-4.4233663735766493, -2.0215864104984282, 4.6922747017737123]]], [[[-1.3824925497200633, -4.7525633463330639, 
4.2699493240029227, 0.94836142718456706], [-0.35386031512282656, 3.0255813601837485, -1.5818219570567695, -2.4612702362214076], 
[3.9930377569198576, 1.4034505424158432, -3.0925604826337283, -3.9332998843171185]], [[2.8746524747222226, 0.68128928538586031, 
-2.7118081103006455, -1.8965057915567982], [-0.80565267278230568, 1.052035416755035, 3.4919565150116245, 1.9160526947568348], 
[-3.4223662452644632, -3.9223936694503694, 0.74735008065621944, 4.2594567869818381]]], [[[-2.9139071364900113, 
4.2483995068106992, 1.3152982254632128, -0.51807232918913293], [-3.8911314307131173, 0.54787947725167108, -3.24134612379373, 
3.6338556624701788], [-4.7572631306876465, 1.5546972520595412, 2.1148618102259551, -1.5916000155023022]], 
[[0.84673640817317164, -0.0093692225283072972, 3.55050527148342, -0.86789022707078622], [0.5664074506031902, 
-1.5037271669245511, 0.68698074352069405, 2.3855508738877962], [-4.4221284869652209, 4.8905945172968757, -3.3480102460091876, 
-0.97135336491982294]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[3.2490441346387691, 3.4976673071078661, 0.94898237214549219, -3.446010746914161], 
[-3.597787522500786, 3.9541480139835965, 3.1410594152591624, -3.4554060648485354], [-0.50548745605709211, 2.4059006787835324, 
-1.8132319580611878, -2.1441562762643631]], [[-3.860203887104193, 3.0555115296459689, 1.7470014267813738, 0.1744170609704776], 
[-1.6392271041717867, 4.9774933065311995, 0.93275043099859545, 3.0176838849246117], [1.8096071150529376, -0.052996165393926375, 
3.0888443048297507, 0.70508279050446276]]], [[[3.6144248084987858, -2.9288851473482937, 4.9112257641652395, 
1.0911855838563085], [-4.9624043941844542, -1.1701931916302133, 3.2312159367546371, 3.4654715891420089], [-0.83201209919020247, 
0.47660680687762103, 2.8904160662877887, 0.089187816351649296]], [[-1.76217311449716, -0.6711114190792431, -1.1866720427841404, 
-4.4791904415669324], [2.5515367007341494, 3.3749563907509863, 2.3612141901710544, 0.36844284036236807], [2.5339402749164242, 
-3.8964601891973469, 0.15190452124008047, 3.5051215703147527]]], [[[-2.8379026535899845, 2.3836421539106132, 
-3.5936308236197725, 3.5501740565469166], [-0.75560644750861528, -2.8891751372178174, -3.3460588337750696, 2.6265018600598449], 
[-4.2212713656260838, 0.025188779056204424, -4.0842941393654861, -4.040894900196391]], [[-3.7636587026068624, 
1.8922933126298647, -1.1875519047740637, -1.204800193819958], [2.3968594480791525, 4.3792914005887287, -3.7838499193929378, 
-1.9178522390117503], [1.9225340862060971, 0.10950146671084759, -0.79342252598082652, -3.0175597743779359]]]]))
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-10.979687587540324, -9.2027587381012168, -0.006954170045854388, 6.0479644214610051], 
[3.1579826053993578, -10.166266050199887, 9.0881418702914338, -0.52778386351722906], [4.7845169396192535, -8.4980970628798378, 
-8.3585357479172959, 8.9834229615333427]], [[1.1059468145515452, -10.791825213896811, 13.143018650670136, -6.6255659688177397], 
[-14.39395264722998, 1.0538348904758021, -0.76958715818880041, 2.7228457152281558], [-11.293232283700831, 13.951175796369652, 
6.3760278978678988, -14.799305262243315]]], [[[4.3603434509813157, 14.989453987837633, -13.467302644566317, 
-2.9911058392501579], [1.1160656944736731, -9.5426003358641402, 4.9890229155068821, 7.7627785826233469], [-12.593931183522201, 
-4.4264443831094944, 9.7538506445810889, 12.405519577519946]], [[-9.0665747851880596, -2.1487676547388959, 8.5529681418259553, 
5.9815270683645059], [2.541006355689396, -3.3180907488992046, -11.013534737981457, -6.0431774630610295], [10.794048942556737, 
12.371121676005863, -2.3571215848067677, -13.434209471591657]]], [[[9.1903829079836008, -13.399335114265353, 
-4.1484144016885729, 1.6339858671729439], [12.272521435470322, -1.727996791769417, 10.223116461719442, -11.461080743524867], 
[15.004276978338146, -4.9034723425085582, -6.6702159413564086, 5.0198626427191]], [[-2.6705833263498784, 0.029550269981826326, 
-11.198195904435185, 2.7373018889288487], [-1.7864335097680863, 4.7427140968606407, -2.1667183570481283, -7.5239617978741657], 
[13.947271536068001, -15.424800501976323, 10.559532167432298, 
3.0636217780518487]]]])+(1.-msk_ref)*numpy.array([[[[11.360683286341761, 12.230024853590422, 3.318233833553295, 
-12.049401323806398], [-12.580107527295237, 13.826165909925184, 10.98310140508714, -12.082253211008842], [-1.7674991953046206, 
8.4125282690545049, -6.3401890360891491, -7.4973067036436545]], [[-13.497678690958098, 10.683972678608409, 6.1086058200489735, 
0.60987075192207596], [-5.7317596170337382, 17.40441886046402, 3.2614768506220875, 10.551703656293212], [6.3275143257211353, 
-0.18530762448319954, 10.800524835558372, 2.4654088838537249]]], [[[12.638281848460183, -10.241207925233009, 
17.172706230599232, 3.8154648909352855], [-17.351658618619595, -4.0917247298096013, 11.298344794977941, 12.117448557353944], 
[-2.9092328566829893, 1.6665144456873626, 10.10669604169604, 0.31185619295508671]], [[-6.161655496173946, -2.3466237964336956, 
-4.1493450640139402, -15.662041473471346], [8.9217625705601158, 11.800951009488184, 8.2562764536689546, 1.2883058047293705], 
[8.8602344987941688, -13.624453320093767, 0.53115288191177434, 12.256089603688341]]], [[[-9.9230764215177985, 
8.3346985933026509, -12.565573117312795, 12.413621174863133], [-2.6420710779964818, -10.102356980248871, -11.699907139676638, 
9.1838874901725305], [-14.760195633942397, 0.088075670679983759, -14.281237878829835, -14.129487089786426]], 
[[-13.160096553429655, 6.6166368072560893, -4.1524216099114373, -4.2127323785441533], [8.3809144914956999, 15.312732163369029, 
-13.230697631644301, -6.7060067436838109], [6.7223773994723741, 0.3828853752490331, -2.7742996574959116, 
-10.551269688469183]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_expandedData_rank1_taggedData_rank0(self):
      arg0=Data(numpy.array([3.8273818212730006, -4.5520083685936363]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([1.72269021376417, 0.70691097169829931]))
      arg0.expand()
      arg1=Data(0.183762749507,self.functionspace)
      arg1.setTaggedValue(1,-0.0270620652542)
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([0.70333020688977776, -0.83648957359109533])+(1.-msk_ref)*numpy.array([-0.046619554977702406, 
-0.019130470845027645])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_expandedData_rank1_taggedData_rank1(self):
      arg0=Data(numpy.array([4.0505624475932525, 0.2000246605205156]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([0.052522036452478993, 2.2365254316340053]))
      arg0.expand()
      arg1=Data(numpy.array([0.89989683782981356, -4.1812985044019335]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([0.53506112756503743, 0.30884630653134426]))
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([3.6450883380213579, -0.83636281387793632])+(1.-msk_ref)*numpy.array([0.02810250004627541, 
0.69074261902358303])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_expandedData_rank2_taggedData_rank0(self):
      arg0=Data(numpy.array([[-3.6645609541962374, -0.94947120386556882, 2.3472072910041986, -4.0543733606410495, 
-4.7717043295237005], [-0.1979820241597432, -1.3431554631498588, -1.8652776092700094, 0.67233515121340925, 2.8383905051754219], 
[-4.121998345942707, 4.6266515007468065, -0.786182000587897, 1.5665442054657088, 3.7707972359365947], [0.93339621993556587, 
-3.6204830468167715, -4.9337289254327672, 1.7162993806811366, 2.2188183776520276]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-2.3547433134403661, 1.3976950523092366, 0.13258472582283432, -3.9335955779851894, 
-3.2866216379575111], [4.160944724982178, -2.5217866229304766, 2.7869566450073782, 1.0088243769870022, 1.0295492619628979], 
[-1.3507227975925664, 1.672158146626181, -2.4152665376147731, -4.7550238486618754, -2.6683711845694424], [-0.66174718644758812, 
-4.0356900661020143, 3.0647342700709537, 3.5371584854380256, -3.1457594816411838]]))
      arg0.expand()
      arg1=Data(0.751618640206,self.functionspace)
      arg1.setTaggedValue(1,-2.6765230481)
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-2.7543523213457584, -0.71364025516439489, 1.7642047523466848, -3.0473425922133197, 
-3.5865019196227035], [-0.14880697978421981, -1.0095406827982432, -1.4019774202866204, 0.50533963211786126, 
2.1333872118741768], [-3.098170791709717, 3.4774775096993498, -0.59090904623647533, 1.1774438255350586, 2.83420149096801], 
[0.70155799760158943, -2.7212225445380689, -3.7082826260798374, 1.2900026066943215, 
1.6677052518753728]])+(1.-msk_ref)*numpy.array([[6.3025247507844924, -3.7409630217221883, -0.35486607449094731, 
10.528359226384925, 8.7967185643802299], [-11.136864458288432, 6.7496200186658157, -7.4593536944200522, -2.7001416964916873, 
-2.7556123287989109], [3.6152406993517565, -4.4755698195145657, 6.4645165552326667, 12.726930925212693, 7.1419569763882667], 
[1.7711815965428568, 10.801617476913664, -8.2028319101494276, -9.4672862110603528, 8.4196977563943953]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_expandedData_rank2_taggedData_rank2(self):
      arg0=Data(numpy.array([[-1.7054936511978589, -4.8465104031194173, 1.0464662990684293, 4.8431626906547827, 
-0.21288025865812976], [-2.7471393889787676, -3.9683545446167079, -1.7238558705884399, 2.507775775292834, -3.1510675627245224], 
[1.8947853101892465, -1.0433740177237216, -0.91736414420281065, 2.2472348260223249, -0.4904392219748992], [1.6043695836622742, 
-2.4102971267223805, 0.76240673944957571, -4.3822369784791881, 4.5846201490007843]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[2.2648286658072072, 1.7736424171585332, -4.5464419524438595, -3.3902708387253289, 
-2.763788913243034], [1.1953623199014114, -1.7749143093752107, -1.7049023861920096, -3.9810696615138683, -3.6099151954180853], 
[-1.7290986720006285, -3.6621286777419018, 0.97849385055978733, -4.8616831341790947, -3.3609922362702713], 
[-2.6874716401932988, -0.48814498094636427, 2.2163565874370672, -2.3455993348952942, -2.4922140191001385]]))
      arg0.expand()
      arg1=Data(numpy.array([[3.5691299286851024, 4.9512794573102905, 1.8438692370037204, 1.1360135413814803, 
-2.6203959933604235], [1.9834881274719054, -1.4099192763848736, 4.2929027097467287, -3.2164450171588053, -0.63196137753241999], 
[4.5922165417466658, -2.9041458994985292, -3.0811838793254354, 4.210894493452253, 0.5304496717155196], [-0.34903156971157756, 
4.4748437574863953, 3.5377759199181344, -0.11858203827521585, -1.9190934036562926]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[-1.5937072758425908, -0.33837739684422186, 3.064357378499448, -2.3889480357871151, 
-0.46048301032346561], [4.66972555684303, 1.0088008101323727, 0.04516901885279978, 3.4230810523599828, 3.781546081097737], 
[0.20243258925208973, 2.2115251412678507, -1.6029450150263926, -0.01871320336909843, -4.001857264241786], [-2.8019971415916212, 
3.4074385941335592, -0.73623535581384925, 2.4304097679967498, 0.22963562168701301]]))
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-6.0871284336727092, -23.996427398605785, 1.9295470164134116, 5.5018983996973985, 
0.55783057685329385], [-5.4489183625498105, 5.5950595679846131, -7.4003455380619201, -8.0661228965921961, 1.9913529976371145], 
[8.7012644445096452, 3.030110375215652, 2.8265676125888741, 9.4628687543915397, -0.26015332429300014], [-0.55997563418315377, 
-10.78570305120104, 2.6972242040080081, 0.51965459311308537, 
-8.7983142862171348]])+(1.-msk_ref)*numpy.array([[-3.6094739232338138, -0.60016050405059784, -13.931922942890777, 
8.0991808609592102, 1.2726778386687718], [5.5820139749307947, -1.7905349932132533, -0.077008768024090221, -13.627524126453293, 
-13.651060660328431], [-0.35002592124543708, -8.098889641384206, -1.5684718399887911, 0.090977665206009251, 
13.450211195778431], [7.5302878539301688, -1.6633240476092326, -1.6317600807620978, -5.7007675353362028, -0.57230111565314967]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_expandedData_rank3_taggedData_rank0(self):
      arg0=Data(numpy.array([[[3.7443711174968008, -4.6319206543741185], [0.003209457295509921, -1.2266210875995052]], 
[[-0.9856001464550932, 1.5866448313638992], [2.9076526660133055, 4.2009935556589646]], [[-3.8984765467086344, 
-0.72907122581068595], [-4.0551468474518799, -1.3673035501519095]], [[-1.033398996946715, -2.5895775417481559], 
[4.5862875363514473, -4.2536226457012987]], [[-3.6717813944954569, -1.1910054496262958], [1.5000455665513046, 
2.9336310049448144]], [[-2.407603499615194, 3.0430598937691595], [2.7325999672429653, 1.806437421501343]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-0.8587624389803219, -1.2899872191655479], [2.9569671883288171, 
1.8778449324709188]], [[3.7856624464111768, 3.9367936159245911], [-2.3094222189349409, 4.6663421852019997]], 
[[-0.032665255404467963, -0.043214161832270115], [-1.3000664769518835, -4.1222916886261807]], [[2.5058475043821886, 
0.3901053088682751], [-0.98552091597489344, -0.74494670023705911]], [[4.1726538654963328, 0.93041024211013124], 
[0.47426324295652744, 3.9407235132118092]], [[-3.3219207668679172, -2.9223937690758008], [-3.6581597158183965, 
3.4173960537624755]]]))
      arg0.expand()
      arg1=Data(-4.69364339659,self.functionspace)
      arg1.setTaggedValue(1,-3.30034890301)
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[-17.574742770035272, 21.740583792949348], [-0.01506404804171982, 5.7573219679340779]], 
[[4.6260556190907947, -7.4471450354707915], [-13.647484735421605, -19.717965661651657]], [[18.298058700234641, 
3.4220003446728469], [19.033413222760537, 6.41763527930972]], [[4.8504063780655677, 12.154553528793743], [-21.526398209876252, 
19.964987842597594]], [[17.234032496009444, 5.5901548639456502], [-7.0406789680332817, -13.769417794401956]], 
[[11.300432267584892, -14.283037975828936], [-12.825849791782279, 
-8.478773074789645]]])+(1.-msk_ref)*numpy.array([[[2.8342156734327655, 4.2574079036667341], [-9.7590234162302334, 
-6.1975434628986221]], [[-12.494006902169881, -12.992792491683721], [7.6218990868431185, -15.40055731198912]], 
[[0.10780673984059622, 0.14262181159752199], [4.2906729710449962, 13.605000852434422]], [[-8.2701710621918814, 
-1.2874836281808204], [3.2525628739287034, 2.4585840249264477]], [[-13.771213607620899, -3.07067842189513], 
[-1.565234173628363, -13.005762523884524]], [[10.96349755881042, 9.6449190699253222], [12.073203405127536, 
-11.278599317177205]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_expandedData_rank3_taggedData_rank3(self):
      arg0=Data(numpy.array([[[-3.304122256951838, 2.6798852943533813], [0.31332631416387002, -3.109146156722721]], 
[[-1.4038751016523889, 0.49696658739359822], [-1.3799527883723961, 2.4412868717030065]], [[-1.2642050194054799, 
-0.23057449884432923], [2.1418773395433641, -2.1930221142543758]], [[1.3421655017217873, -4.104778106032386], 
[-3.5368134327885778, -0.65517723819063267]], [[3.2084028309131227, -1.4486054840913134], [0.61604684195723181, 
2.5672568580560728]], [[-4.9087505032005927, -2.4480237279613801], [3.1489150029110338, 
-4.598213413999729]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[2.9629749299965553, -0.16899083295023054], [1.0596950278282229, 
-0.47099246533104733]], [[0.98163881995146696, 3.6759647214984064], [1.844693417458255, -1.2706806482358877]], 
[[-1.2871341130725744, -0.020429968385329289], [1.0318928008467054, -3.8130148624348692]], [[-4.7672702014694854, 
-4.1395269501114704], [-3.5871259434338065, -1.4942346387976091]], [[-0.15879784084443482, -2.3967188551730878], 
[-1.6187590548304409, -3.645688289061475]], [[1.7105653298916144, 3.8421632179132121], [3.3480762653970402, 
4.5610395282786236]]]))
      arg0.expand()
      arg1=Data(numpy.array([[[-2.0444026065036791, 1.6184790271764324], [0.60952262921762212, -2.2029251876892966]], 
[[4.875159971482276, -4.915409184414341], [1.0711414034526223, 0.26509812555141288]], [[4.7804472710508144, 
0.24766874715916742], [-2.3990963276483281, 2.3313278932397736]], [[-1.4868184802561011, -0.2627726214655679], 
[-0.020654077201388787, 0.00036099260437705283]], [[-3.1226693543942652, 0.19874398149199113], [-2.3480608573548256, 
-3.7552582490114728]], [[2.0666935571397049, -3.7309591313719812], [1.4854020755350881, 
-0.86230906049862366]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[-1.8640386794705419, 4.3022630879288055], [4.2424324980753152, 1.5386252617530438]], 
[[-1.5598338183333693, -3.9476821047830821], [4.8256799248908351, 4.6203582319908705]], [[-4.834277209512539, 
4.8405770573361462], [-0.29044054079314563, -1.1036788159542055]], [[0.84096341939734476, 1.9936067523607068], 
[3.1345295703523952, -4.2976034775820935]], [[-2.4573752401881399, 1.6374297569864202], [2.9827541853076642, 
-0.69812389823252907]], [[-4.5207179800543411, 2.4433538210396009], [1.7905735491856181, 3.2609806873186713]]]))
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[6.7549561543191565, 4.3373381441494878], [0.19097947881222874, 6.8492163808518551]], 
[[-6.8441157005363378, -2.4427941280215451], [-1.4781245664355678, 0.64718057362173964]], [[-6.0434654350656682, 
-0.057106097255627916], [-5.1385700595716557, -5.1126536254528876]], [[-1.9955564715221552, 1.0786233034565988], 
[0.07304961768772418, -0.00023651413754300116]], [[-10.018781196644214, -0.28790162151944082], [-1.4465154758968304, 
-9.640712493546344]], [[-10.144883038570949, 9.1334764816527905], [4.6774048810076279, 
3.965081088998275]]])+(1.-msk_ref)*numpy.array([[[-5.5230998758151006, -0.72704302280011979], [4.4956846241072785, 
-0.72468090525369411]], [[-1.5311934287491595, -14.511540148873186], [8.9018999922065696, -5.8709997933081794]], 
[[6.2223631084128819, -0.098892836248127752], [-0.29970350311847083, 4.208343728587904]], [[-4.0090998498188473, 
-8.2525888793213511], [-11.2439523422715, 6.4216279800202285]], [[0.39022588228645105, -3.9244587725908406], 
[-4.828360345800176, 2.5451421201002762]], [[-7.7329834428986066, 9.3877641795460551], [5.9949768014761071, 
14.873461815813654]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_expandedData_rank4_taggedData_rank0(self):
      arg0=Data(numpy.array([[[[-1.7190448457863692, -3.1729952230272973, -1.0425315051697837, 3.9543807611717838], 
[0.16754228263986004, 4.6482841273611371, -2.8613522778678591, 1.040956599660281], [4.817132222569068, -2.5260830411328508, 
-2.8007790273994679, -2.6375034989982691]], [[0.050900119635550745, -4.3261872294587009, 0.21049915584286083, 
2.0261928833607232], [4.6256830566236147, -0.54437918741556324, 4.173364609522114, 1.8407574291200604], [-3.8153487785618267, 
0.46680613801020954, 4.0888635786646752, 2.009029414674492]]], [[[-0.84418938956408507, -4.2992911285438851, 
3.9199081200434307, 4.3858040789664017], [2.047324914685607, -0.69199866849278724, -2.7806211867302477, -2.3939525741722747], 
[0.31796825654209293, -4.0255537261167715, 0.90387805280546996, -1.9199510920289198]], [[-2.4537517324312272, 
4.7407663295878777, -2.1267037090581544, -4.4456110769259745], [2.9111660922049083, 0.0034106609879680505, -3.8250424037139008, 
2.925537571669742], [2.5396668371714313, -0.10652376409898334, 3.3710608130822148, -4.9771878795538811]]], 
[[[0.095698963044959839, -2.9129707907640268, 1.275239366291804, -3.9849707401962564], [-3.150701748264356, 
0.62453607405104083, -2.0222836102265349, 0.3423927791230339], [-2.4347101312150787, -4.1063431924580884, -1.2753944364859562, 
-1.7328387807260959]], [[-4.2609926063268242, -3.6471393424637011, 0.11706582726151282, 4.2130803364279323], 
[2.4143425512799501, 3.493537268796544, -4.5687243034731875, 3.0405306352096257], [-3.7807392817769427, -3.1626461996690782, 
1.8983261318723024, 1.0529036345045117]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[-1.2915906426322965, 1.6827749165843588, -3.4690858366103363, 0.35551024660497443], 
[3.0612478006657255, 2.9912857768509298, -2.0916595185819498, -0.26798299939989434], [3.6493910926336923, 0.079590513116919226, 
2.7488227766714495, 2.0022612393632642]], [[2.2816057181957685, 4.96068135932315, -2.6793606017679528, -0.94597322991091826], 
[-2.4280419083304472, 4.8106105450717092, -0.20886799407173839, 2.8799577881481895], [-0.71581066130397986, 
-3.2543666317018829, -3.039782590738306, -4.3089455661315759]]], [[[4.6697815043142104, 0.016299766983602915, 
-1.3693093315807792, 0.64238240271877611], [-0.51799538273935397, 4.6397982104486388, -0.2910156357961311, 
-4.9338439987880411], [3.2709559837085784, 2.4656830608175468, -0.46296666457012137, 2.3671973203619023]], 
[[4.7592424260119746, -1.6312239473212697, 3.6115235998794919, -2.8972205907270911], [-2.5640964977402145, 1.4972074427813702, 
-4.7142668280783697, 3.114307974708316], [3.833394664034147, 3.0161629679139921, -1.7819159507065718, -2.1906822323795971]]], 
[[[-0.28853093500351257, -2.5940984356796646, -4.061971229822932, -1.7559170709524197], [0.98053911945804373, 
3.1210824842196665, -0.04719949025923853, 1.1830268742470729], [3.654353863026941, 0.96514501984880852, -1.2684205506260469, 
-0.42012007172000665]], [[-2.302778771991064, 0.4192765667143572, -0.29698974639200415, 3.0320569644906801], 
[4.4991560216996618, 1.0092180100670376, -1.8138975634237395, -0.54030423499564861], [-3.5023763812016528, -4.389212309957812, 
-2.4186165591124329, -2.8947226596135991]]]]))
      arg0.expand()
      arg1=Data(0.447062126416,self.functionspace)
      arg1.setTaggedValue(1,-0.201753069462)
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-0.76851984416111474, -1.4185259915132782, -0.46607635155651012, 1.7678538717465881], 
[0.074901809141507417, 2.0780717861621767, -1.2792022337678646, 0.46537227095052808], [2.1535573746470664, -1.1293160558713602, 
-1.2521222276095578, -1.1791279226908793]], [[0.022755515719080216, -1.9340744620740298, 0.094106200219808339, 
0.90583409896349887], [2.0679677034189896, -0.24337131710242452, 1.8657532566407686, 0.82293293047781646], 
[-1.7056979379611974, 0.20869134468272094, 1.8279760461013279, 0.89816096215596397]]], [[[-0.37740510359604812, 
-1.9220502340067622, 1.7524424595005832, 1.9607268975851442], [0.91528142982308347, -0.30936639621318285, -1.2431104204960284, 
-1.0702455283476726], [0.14215156490238448, -1.7996726087982009, 0.40408964430764921, -0.85833741781649531]], 
[[-1.0969794671967856, 2.1194170761452655, -0.95076868242758505, -1.9874643412674871], [1.3014721035302601, 
0.0015247773537638931, -1.7100315906343597, 1.3078970476995475], [1.1353888566131645, -0.047622740491890407, 
1.5070736153729998, -2.2251121970035506]]], [[[0.042783381914652308, -1.3022789159056387, 0.57011122278335791, 
-1.781529492816279], [-1.408559423280564, 0.27920642528853923, -0.90408641100338916, 0.153070843904107], [-1.0884666884667356, 
-1.8357905194127355, -0.5701805487940993, -0.77468659004690799]], [[-1.9049284152258261, -1.6304978697759922, 
0.052335697666138908, 1.8835086539634271], [1.0793611148709963, 1.5618282001004999, -2.0425036021175758, 1.3593060912087376], 
[-1.6902253427343716, -1.4138993351244276, 0.84866971714522421, 
0.47071333775235175]]]])+(1.-msk_ref)*numpy.array([[[[0.26058237663984468, -0.33950500463505273, 0.69989871576431084, 
-0.071725283477851232], [-0.61761614016901156, -0.6035010871185823, 0.42199872814393574, 0.054066392692641185], 
[-0.7362758546072079, -0.016057630321417549, -0.55458343260133502, -0.40396235090691862]], [[-0.4603209569487216, 
-1.0008326908678382, 0.54056922560302778, 0.19085300276368955], [0.48986490778875735, -0.97055544345590394, 
0.04213975891640577, -0.58104032368074066], [0.14441699807191355, 0.65657845710152674, 0.61328546817950214, 
0.86934299411299421]]], [[[-0.94214275221364785, -0.0032885280204620702, 0.27626236068978643, -0.12960262151707755], 
[0.10450715843496125, -0.93609353064367873, 0.05871329778339094, 0.99541817100361363], [-0.65992540978926806, 
-0.497459125841128, 0.093404945635742975, -0.47758932540593474]], [[-0.96019176776309789, 0.32910443835246805, 
-0.72863597171120675, 0.58452314708855579], [0.51731433881661026, -0.30206619720293565, 0.95111780282909097, 
-0.62832119314830781], [-0.77339913992927434, -0.60852013677515515, 0.35950701257887541, 0.44197686459909752]]], 
[[[0.058212001771784753, 0.52336732188571156, 0.8195151636843121, 0.35426165878589405], [-0.19782677707851681, 
-0.62968797123632425, 0.0095226420368570933, -0.23867930313573207], [-0.73727710876708252, -0.19472097023074528, 
0.25590773945786, 0.084760514012231086]], [[0.46459268554181277, -0.084590334288234495, 0.059918592933415553, 
-0.6117267993705251], [-0.90771853736767716, -0.20361283128765473, 0.36595940111091835, 0.10900803785384955], 
[0.70661518531968037, 0.88553705605568112, 0.48796331465326892, 0.58401918181910339]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_mult_overloaded_expandedData_rank4_taggedData_rank4(self):
      arg0=Data(numpy.array([[[[2.8680555154398419, 2.0400288398940516, 1.640185146938463, 1.5096740672960092], 
[2.2121135769841906, -1.5490892976229276, -2.5141554458850344, 3.8342399822052595], [-1.7407227589515806, 3.7447943647694473, 
-4.6665256421514325, 3.6932445944539722]], [[4.2907606231222921, 4.6715137097410278, 1.6891935845953761, -2.7927302856532865], 
[4.2670298597282184, -4.7010810380008881, 0.23565827351810587, -0.60145774219904524], [-4.7587995348486389, 
0.38451877123728639, -1.6591877066111085, 1.9323607961209177]]], [[[-4.8778582759614952, 0.41800871640264425, 
3.7282312153199975, 0.27240901461459721], [1.1449458463083664, 3.0818113002992149, -4.0793821931070919, 2.8158986117968867], 
[2.0714321972511174, -0.66597843385970457, -2.3350700921440204, 1.5508413116997968]], [[4.2012049909550804, 
-1.8867472589604803, -2.574570877097202, 1.4189962443023898], [-3.9121606243320528, 3.3296364791359405, -0.37850715573887417, 
4.6167598071568996], [2.9805359805676668, -1.7700046075497724, 1.0449805829704717, 1.5016027333205439]]], 
[[[1.3283341123968935, -0.28358268147310461, -3.3016493353540834, 1.125565758971443], [3.0200919603642262, 1.8433825437830365, 
0.29184322944725061, 0.89831772010928113], [0.14158404561088922, 1.3779453632317367, -1.3457960983498793, -4.4244467396645]], 
[[2.4120271066038077, 4.5763093241546411, -0.30670517295721123, 2.2737782994944986], [4.2482972535010521, -0.20960732717534469, 
-4.7431933640871833, -0.6808757881046823], [4.1080423310509655, -4.3682781696425383, -2.92296578559881, 
-4.2136083609475943]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[-4.1536996832173898, -2.2419682922125417, -0.043802532118516702, 
1.9775528363596013], [3.6989422251705619, -2.9492747375611006, -2.9418363570439245, 4.4703574613295238], [0.10494338048399054, 
-0.26669086231523131, 1.3210228848573289, 4.4657993006878929]], [[-4.3061257540762092, 0.18278999873401602, 
-4.9691495596286792, -3.4583888786093442], [-2.8136212582618656, 3.0401263694267922, 1.7746819397445002, -1.5937260075868087], 
[3.4295817006814691, 3.8305935939943616, -1.9117683444889422, -2.5112093900686396]]], [[[1.3393314723774319, 
-1.5632181000052836, 2.8516291011454085, 0.96028495522943036], [2.0775605994885762, 0.84224540785127733, 2.261376358592929, 
0.76665012300458191], [-4.6361766014611625, 4.8123989186884319, -3.0701443549428675, 1.5847948433189707]], 
[[-1.2347588245046115, -3.7598435351862047, 3.2538874880772752, 3.7555596975238537], [2.3473083143498208, -1.1384760828771032, 
0.87529112975751033, -0.13511125065736618], [-4.0836169276956502, 1.3392940981900123, -0.16687823875832031, 
-1.9104919759042751]]], [[[2.2504305283326893, 4.8146047674799686, -3.0481352092799452, 2.0752105907170204], 
[0.87767128631066527, -1.4117559991644582, 3.3022714985388859, -4.3278709958864123], [2.4479238113976622, -0.11873834446334364, 
-0.0020982165709302336, 4.3563815466432825]], [[-4.0076601394711595, 4.9882672665244616, -0.23512091819119441, 
-4.3274033246189667], [0.106050344357282, -0.40157778220597873, 3.6834220825172572, -2.1037971802148681], [1.9595885444100247, 
-0.54715498169332655, 4.3618541160691038, -2.8344936470424988]]]]))
      arg0.expand()
      arg1=Data(numpy.array([[[[-0.6877644775283418, -2.2748901437702251, 0.75136227068943739, 0.54390983361969525], 
[4.6798581940426445, 0.85193543064995847, 3.6176634924942448, -1.1954932760040649], [-1.7294515666796482, 1.4939459445086944, 
0.70557056518230432, -4.2301702307575964]], [[3.4667419026322932, 3.4626939743352434, -2.247024764719725, -4.3904717796285588], 
[2.850218632416782, -4.373428719833595, 2.7870084082734259, -2.8679149026298925], [2.755852667768961, 4.0114964526093608, 
1.9660653291580896, 2.0231157322642073]]], [[[1.1331018911654001, -2.5946422168894712, 3.3281440837407761, 
-1.4659291839542887], [4.9682756913562258, 4.3030710802501133, 0.46749727788872786, 4.9685136830149741], [2.5076209132852227, 
-0.87601084069697599, -3.1820171989848731, -2.2101995587677403]], [[0.16267043236319534, 0.52441289089565135, 
-4.9502368461030208, 3.9107772486011374], [-2.6810096214600856, 3.9841141053036626, -0.95937935710436495, -0.9711584276472891], 
[-1.0351273257663052, -1.7682434946573933, 0.34370322844275325, -1.3712053876711181]]], [[[-4.7510047640509923, 
-3.4200169091179022, -0.43218888971286251, 1.5737747366695398], [4.2905465979876105, 3.3956488255156323, -3.8793324037004959, 
-3.0878520770099427], [-2.6335287222865036, -4.7540981754543541, 2.8604792505866783, -4.061558082709106]], 
[[-4.3170334129271595, -3.4692017862487146, 3.000717869318942, 4.4333041875599815], [2.4486899405704481, -1.6286489287097083, 
-3.001328134699579, -4.9948069259508143], [-4.5294647348097126, -3.5621594110932109, 0.054499652669305121, 
0.31347153200218081]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[4.8770345803409167, -1.359590348870011, -4.7907381162281801, -1.6195886745722055], 
[1.279755407943779, -1.486414757307406, -4.8634720090161423, 2.3021398812687641], [0.34716950716454242, 0.046377840375470214, 
-3.6630268256689611, 0.25052380370799465]], [[3.4650026724915062, 3.6480724730400951, -2.1254343134595413, 
-3.9410878856250218], [0.75275151132314022, -2.12641026545346, -0.092378743730891166, -0.64749248802068671], 
[-1.8281014076270443, -2.1919977696314588, -2.2960468988950087, 1.6558006705308781]]], [[[3.1323795658233813, 
-3.0120365159856788, 2.3469113475407823, -3.5149507352609177], [1.0077269591359723, 2.9409868253816596, -4.4516362767771938, 
-3.9551085662768628], [-3.9477221532183027, -2.4835877486136382, -4.8953069200918033, -3.2885535304954683]], 
[[-3.293689490126277, -2.0264322135735888, -3.3380054806525883, 1.9356715857363902], [0.69306129508112235, 3.5058624107236227, 
0.902969603036885, -2.6357617531577091], [2.4118437662875367, 4.0702227531597686, 1.6787466288535953, -3.8535138606901542]]], 
[[[2.8362822126004703, 2.5861086828489448, 4.1490653991232023, 2.5721003949748047], [0.76735984275115499, 4.6651083907971618, 
-1.7730500382727543, 0.47192829833828664], [-4.2384958985464039, 4.7908935635162884, -2.1698622777980034, 
-0.76705531632890178]], [[1.1064747676018545, -2.5384823704232904, -0.029896718222782503, -1.3545366161932151], 
[3.4778870993564954, -3.8252341615326002, 0.41480611671119938, -0.17554053014023463], [2.8455983091241999, 
-0.78538750591266915, 2.4919675608182121, 0.60720672856616975]]]]))
      res=arg0*arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-1.972546703098762, -4.6408415008819848, 1.2323732363547721, 0.82112657076294093], 
[10.352377849402449, -1.3197240578856304, -9.095368371033878, -4.5838081173123326], [3.0104957026237305, 5.5945203542663284, 
-3.2925631347705018, -15.623053338365605]], [[14.874959646342699, 16.176022373744736, -3.7956598169914937, 12.261403507274759], 
[12.161968011276135, 20.559842825858212, 0.6567815897741599, 1.7249296221547699], [-13.114550393490312, 1.5424956867800848, 
-3.262071424533425, 3.9093895270428169]]], [[[-5.5271104373287683, -1.0845830626060791, 12.408090662084932, 
-0.39933232449576839], [5.6884066161331379, 13.261253081105549, -1.9071000707453143, 13.990830782695703], [5.1943666982792625, 
0.5834043277314952, 7.4302331940374655, -3.4276687828376744]], [[0.68341183232507707, -0.98943458446091159, 12.744735618710342, 
5.5493782280682478], [10.488540274531529, 13.265651662059126, 0.36313195173216284, -4.4836051951436966], [-3.0852342389152612, 
3.1297991328134973, 0.35916320002694152, -2.059005758070807]]], [[[-6.3109216962490873, 0.9698575657710139, 1.4269361604678918, 
1.7713869559295334], [12.957845286150464, 6.2594797697728861, -1.1321568967953179, -2.7738722378542802], [-0.37286565073379913, 
-6.5508875372157869, -3.8496218148503383, 17.970147417000302]], [[-10.412801612094658, -15.876140481783928, 
-0.92033569310526042, 10.080350856731974], [10.40276274920109, 0.34137674885383046, 14.235879691955207, 3.4008431021374861], 
[-18.607232867600835, 15.560503192265193, -0.15930062007939771, 
-1.3208462681634405]]]])+(1.-msk_ref)*numpy.array([[[[-20.257736991402322, 3.0481584525647523, 0.20984646020748707, 
-3.2028221771361522], [4.7337413163336217, 4.3838454932647473, 14.307538777589144, 10.291388195254084], [0.036433141682808055, 
-0.012368546242052303, -4.8389422645549951, 1.1187890274048335]], [[-14.920737245958568, 0.66683116272859766, 
10.561600982747164, 13.62981451326759], [-2.1179576544475349, -6.464555920224889, -0.16394288811549801, 1.0319256178756586], 
[-6.2696231345877464, -8.3966526144001943, 4.3895097787694803, -4.1580621919190905]]], [[[4.19529453593921, 4.7084699996656667, 
6.6925206964556807, -3.3753543094436838], [2.0936138253433305, 2.4770326482288092, -10.066825033358594, -3.0321844688326323], 
[18.302337075820574, -11.952014995896109, 15.029298906432604, -5.2116826771076132]], [[4.0669121631115148, 7.6190680576977288, 
-10.861494268628828, 7.2695301950336759], [1.626828540297973, -3.9913405044667081, 0.79036128397884575, 0.35612106690399015], 
[-9.8490460309690171, 5.4512253116255813, -0.28014628074455561, 7.3621073098844443]]], [[[6.3828560782030852, 
12.451091193665871, -12.646912328672581, 5.3376499800391457], [0.67348970025055599, -6.5859947574603446, -5.8550926068713975, 
-2.0424447945163005], [-10.375515034563072, -0.56886277023201293, 0.0045528409879121929, -3.3415856253098535]], 
[[-4.434374821448567, -12.662628515031923, 0.0070293438394440364, 5.8616262562326442], [0.36883112452250499, 
1.5361290510068082, 1.5279060102572626, 0.36930167232244865], [5.5762018485523184, 0.42972868641981388, 10.869598962265604, 
-1.7211236145622673]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_float_rank0_taggedData_rank0(self):
      arg0=0.530720959001
      arg1=Data(-2.72292512329,self.functionspace)
      arg1.setTaggedValue(1,1.75160853271)
      res=arg0/arg1
      ref=Data(-0.194908392619,self.functionspace)
      ref.setTaggedValue(1,0.302990622099)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_float_rank0_taggedData_rank1(self):
      arg0=-1.55181779951
      arg1=Data(numpy.array([-4.0753145551015475, 1.6095009643123257]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([-1.2973999945988721, 1.9949506918417423]))
      res=arg0/arg1
      ref=Data(numpy.array([0.38078479060373915, -0.9641608386185353]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([1.1960982009935197, -0.77787275938939227]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_float_rank0_taggedData_rank2(self):
      arg0=-3.98091301865
      arg1=Data(numpy.array([[0.44966731933462789, -0.81680618711702913, 4.0646487172360395, 2.8134699767808371, 
-0.39919154984348371], [-1.1585803868590006, -3.7920466820746999, -0.0040164555894577347, -2.1234840931313945, 
-4.9842779777036235], [2.3729035242579606, 2.4074341644549175, 0.30195529961868228, 2.7291749648090917, -1.5550476687079762], 
[3.3234587020672777, -3.7862918929952629, -1.4172997917377703, 4.2031497491210388, -2.0504656511172445]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[-1.5745511585718477, -4.2717852405415, 4.913864011647874, -2.5014818454433363, 
-2.1507065783852153], [-0.28496355064187018, 4.5941786949255832, -3.1192237707103407, -3.5993239337610516, 
-3.8302938748712401], [2.5030751218880525, 3.5473076425187813, -4.8440762855556443, -2.1837352778033239, 4.195268327590739], 
[2.8739387053288388, -2.2881264230635701, -0.54140737035705744, 1.1767893424149865, 1.226580964756824]]))
      res=arg0/arg1
      ref=Data(numpy.array([[-8.8530183259470814, 4.8737547308497406, -0.97939903189370314, -1.4149477518874776, 
9.9724380944682025], [3.4360265923726856, 1.0498059102138815, 991.15076215405782, 1.8747081890208599, 0.7986940207702985], 
[-1.6776548131655902, -1.6535916443431811, -13.183782578667005, -1.4586507167844507, 2.5599942038796359], [-1.197822321719457, 
1.0514015113345463, 2.8088009621224233, -0.94712614497769121, 1.9414677912209186]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[2.5282843285065026, 0.93190851002245867, -0.81013902892154976, 1.5914219109367249, 
1.8509791426954634], [13.969902500449955, -0.86651244607572731, 1.276251180191021, 1.1060168775887789, 1.0393231299472505], 
[-1.5904089269387105, -1.1222350638362719, 0.82181055457765673, 1.8229833346162101, -0.94890545914976565], 
[-1.3851767302022051, 1.7398134030194534, 7.3528977191861138, -3.3828595103346188, -3.2455362776954524]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_float_rank0_taggedData_rank3(self):
      arg0=3.83661766078
      arg1=Data(numpy.array([[[0.99803638763779734, -3.1417627649199664], [-1.0524959532968037, -2.3983565939824656]], 
[[-4.0713931887572148, -2.490178211518864], [-0.24398143906304437, -0.54270325028569921]], [[4.9981751140140176, 
-3.6838989503046173], [-0.036672206855446809, 2.2695133465231727]], [[1.2407870628674713, 2.91397971267995], 
[0.18342130401242152, 2.2465388378215012]], [[1.4931945480717879, 2.4257146301282431], [-0.080461879769858413, 
-4.1674943020115283]], [[-3.8183096032317687, 4.4255998690403882], [4.6338139363791306, 
-2.6025911584729311]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[4.5865666548884967, -2.630330766944402], [-4.8559664548198818, -3.656842762709418]], 
[[4.8253074812978713, 0.893423466559776], [2.8737737451964875, -1.3961757949838383]], [[4.6808521133877612, 
-2.9013361383556635], [2.4024701914638875, 3.5000753496252344]], [[-3.7429634962469658, 0.42882599343018235], 
[0.36749943896296422, 1.7516847075867981]], [[-0.34484116655048247, -4.3804283927641769], [3.4879699636605626, 
-2.319257842923351]], [[-4.5067227802990537, 3.7519172069177529], [2.9911497237315832, -4.5312902993671802]]]))
      res=arg0/arg1
      ref=Data(numpy.array([[[3.8441661128766134, -1.2211672070258122], [-3.6452564484996959, -1.5996860810444846]], 
[[-0.94233533409877535, -1.5407000362576038], [-15.725039066531751, -7.0694576801507454]], [[0.76760368999833495, 
-1.0414557273504375], [-104.61921956041671, 1.6905023566627591]], [[3.0920838680478715, 1.3166246985455228], 
[20.916968622767985, 1.7077904891666276]], [[2.569402403544375, 1.5816442763393703], [-47.68242640799243, 
-0.92060537645442841]], [[-1.0047948069815356, 0.8669147176215255], [0.82796109499660819, 
-1.4741530371701339]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[0.83649011329331258, -1.4586065406640563], [-0.79008322987217106, 
-1.0491612327166049]], [[0.79510325003020677, 4.2942879881455553], [1.3350451360994979, -2.7479474107480999]], 
[[0.81964086192807761, -1.3223623454224842], [1.5969470399286234, 1.0961528760190289]], [[-1.0250213940429687, 
8.9467936168837969], [10.439791885401094, 2.1902444225025577]], [[-11.125753050755188, -0.87585444088357567], 
[1.0999571959468786, -1.6542436937236238]], [[-0.85130988698630827, 1.0225752459838628], [1.2826565084106418, 
-0.84669429837916443]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_float_rank0_taggedData_rank4(self):
      arg0=-1.20467024608
      arg1=Data(numpy.array([[[[-1.2181731751178226, 3.6492979695913839, -2.1710664723041506, -1.1649719746118494], 
[0.56103710184591549, 1.9062433266827892, 1.5973342421602945, -4.3364036964420176], [1.9912096725077069, 2.0287016115745162, 
0.86239674465844818, 2.6236829160063202]], [[-2.4917496797756735, 1.8374186351918285, 0.77615467473568778, 
-4.5720898592529231], [1.5051976661221609, -3.5176206544634847, -0.39848562191284298, 2.10229027041599], [3.4285102555646922, 
-0.33870066986103264, -1.3675053513437483, -0.77018927694325168]]], [[[-4.6586434464869333, -2.4028035019862548, 
-2.0673634943331685, 0.44047401891906812], [2.1403252158407273, -2.4536016369740485, 1.4966484381309861, 3.1609877640937221], 
[0.55037318997358309, -3.2343668944249861, 3.0046276941113099, -3.4454349909795123]], [[-1.652781759778168, 1.7839114376269363, 
-3.9491973821240158, 4.8546759094468133], [-4.0126866980083928, -1.9009361670550384, 0.72519552439328283, -4.9667947391451372], 
[4.5138078681293727, 0.21422136096062339, -4.2208642613153398, -2.7529651562587754]]], [[[0.98202605996668701, 
-4.6404271194933298, 4.045509455184316, 0.88570777694947544], [-0.11073949336977496, 4.1401483777031132, 3.4634100875895832, 
-0.93493502677335272], [4.2308907811038861, 0.031500298818153638, 1.4868222260755024, -3.5674597542115647]], 
[[3.6453420951771971, -4.6861793612833633, 4.9963869188833048, 4.5784049008321066], [3.605763931528573, -4.9199331585407418, 
3.2155995666002397, 4.9077635900480647], [-0.78082311759376832, 2.8898200228418585, 4.7053097356086884, 
-0.21445265420813175]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[-4.9385503022391086, 0.32713299150944586, 1.3262211351551221, -0.6662407209656509], 
[-4.148846361377033, 4.3188191045578321, 3.5948304937505853, -1.8057428662174568], [0.43293685492360812, -3.7434975310003935, 
1.8244767358349376, -2.0297101572418197]], [[-2.6073404331261987, -4.4332096572466764, 0.44693896208392303, 
-3.9313597779800604], [-4.2793135890210445, 3.8313069862422591, 2.2588282098794457, -1.6224630822127226], 
[-0.60100390740555198, 2.8166102931952999, -4.0628073385628527, -1.9662851558398406]]], [[[3.8045806656868457, 
0.71980655532686288, -2.0044054569814627, 3.4872921248630284], [4.2348112396683817, 4.5460019207439046, -0.74599653651381903, 
2.1076379152503826], [-2.3497915596425525, 2.9300588946383543, -0.30107605232075052, 4.9639892058955954]], 
[[4.5304229865204722, 1.1595101589107806, 1.069910835267919, -3.5828187734558679], [-0.88512547434241995, -2.6502158738832682, 
-4.9009793014608407, -2.0901477125278434], [3.1009082781056971, 2.2426029807421699, 0.39684269187096088, 
-4.6821302744076077]]], [[[-2.4204741988578737, 4.9484608350697066, 3.9297077431320098, -4.6471734288695181], 
[-3.4314083260843686, -0.48402484123672274, -1.7049570470108733, -4.9531288268282339], [3.2187095348114365, 
-1.0977948903230828, -2.036383893171978, 1.3937446538051832]], [[-2.222073073734542, 0.093544412493242746, 2.5132000962898884, 
2.8667027592838998], [3.5402001261687914, -4.5095813949818586, 1.1701032152564617, -3.8504426971959758], [1.0408755936050662, 
-4.0701816320647977, 1.0938885246665766, -3.2849950776654691]]]]))
      res=arg0/arg1
      ref=Data(numpy.array([[[[0.9889154273677504, -0.33011013518703142, 0.55487487898104559, 1.0340765892509547], 
[-2.1472202856388356, -0.63196037421723961, -0.75417543447283142, 0.27780398929831945], [-0.60499417148894374, 
-0.59381342194754916, -1.3968863560085447, -0.459152376504886]], [[0.48346359020623003, -0.65563188649918214, 
-1.5521007413758221, 0.26348350167299939], [-0.80034022985377173, 0.34246735632251113, 3.0231209856376129, 
-0.57302755144331108], [-0.35136842426657872, 3.5567400754590826, 0.88092543469451801, 1.564122329592408]]], 
[[[0.25858820489642936, 0.50136028396984678, 0.58270848323561963, -2.7349405284694326], [-0.56284448604525383, 
0.49098037265953809, -0.80491197223575273, -0.38110563405643511], [-2.1888243614071992, 0.37245936698030058, 
-0.40093827546107369, 0.34964242518971228]], [[0.72887435921440635, -0.67529711434671569, 0.30504179191764214, 
-0.24814637857398031], [0.30021537606648485, 0.63372472309044758, -1.6611661345916733, 0.2425448018991245], 
[-0.26688558336418838, -5.6234833010000571, 0.28540843095109675, 0.43759008113153669]]], [[[-1.226719223846704, 
0.25960331130275449, -0.29777961451450508, -1.3601215631510601], [10.878415725246326, -0.29097272275731878, 
-0.34782778117909247, 1.288506913937248], [-0.28473205960784914, -38.243137090030366, -0.81023152933308162, 
0.33768292540859013]], [[-0.33046836610296598, 0.25706874475023478, -0.24110827796915607, -0.26312007613407612], 
[-0.33409570591851845, 0.24485500254984718, -0.37463316595518575, -0.24546215887871914], [1.5428209269622493, 
-0.41686687633055236, -0.25602358054410473, 5.6174182153530632]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[0.24393195823749753, -3.6825091853958929, -0.90834794752284376, 1.8081606364941476], 
[0.29036270354434912, -0.27893510168282615, -0.33511183578024717, 0.66713277322979525], [-2.7825541586015716, 
0.3218034033957653, -0.66028260181036302, 0.59351836112235934]], [[0.46203028602412788, 0.2717377113239785, 
-2.6953797907047687, 0.30642584604620765], [0.28151015835115673, -0.31442801383585034, -0.53331645178269871, 
0.74249470406231755], [2.0044299733090929, -0.42770213862739759, 0.29651178254140453, 0.61266304254076098]]], 
[[[-0.31663679967266262, -1.6736027716954209, 0.60101125841761871, -0.34544575072754691], [-0.28446846338631754, 
-0.26499554269489611, 1.6148469692757823, -0.57157362626799157], [0.51267110954421169, -0.4111419904507615, 4.0012157619104789, 
-0.24268188267791091]], [[-0.265906792735219, -1.0389475562777415, -1.125953870518478, 0.33623532817362856], 
[1.361016354177975, 0.45455551676038003, 0.24580194528071025, 0.5763565124412342], [-0.38848948051294435, -0.53717499549603553, 
-3.0356367164026974, 0.257291056736346]]], [[[0.49770009804194876, -0.24344342336552038, -0.30655466635781897, 
0.2592264447450634], [0.35107166842316267, 2.4888603713014827, 0.7065692641299065, 0.24321399426450796], [-0.37427118944740223, 
1.0973545757031486, 0.59157325400129424, -0.86434071175849636]], [[0.54213799731389301, -12.878056678869958, 
-0.47933717966108846, -0.42022851590671956], [-0.34028309223955272, 0.26713571406430225, -1.0295418646598054, 
0.31286538738957292], [-1.1573623721036661, 0.295974566979814, -1.1012733189122368, 0.36671904145916956]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_constData_rank0_taggedData_rank0(self):
      arg0=Data(2.20674093822,self.functionspace)
      arg1=Data(-0.707495774895,self.functionspace)
      arg1.setTaggedValue(1,-2.88870574019)
      res=arg0/arg1
      ref=Data(-3.11908709072,self.functionspace)
      ref.setTaggedValue(1,-0.763920293962)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_constData_rank0_taggedData_rank1(self):
      arg0=Data(-3.85742192674,self.functionspace)
      arg1=Data(numpy.array([1.1476886192811531, 1.2600836428974427]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([-3.8657758687700152, -0.70778037640435887]))
      res=arg0/arg1
      ref=Data(numpy.array([-3.3610352685719769, -3.06124275835599]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([0.99783899990300218, 5.4500266683557568]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_constData_rank0_taggedData_rank2(self):
      arg0=Data(-3.32334925637,self.functionspace)
      arg1=Data(numpy.array([[-2.1894767590113307, -4.9459887058223266, 0.21738557706519224, 0.25916702845134232, 
-3.2167462638555779], [0.87751372732748223, -0.58986023525252929, -3.7500060502682619, -3.9331935649214689, 
0.13386935591894122], [-3.3696689989587716, -3.0236469753840756, -4.1345844831901619, -3.0866737505456676, 
-0.86639436477752074], [0.91195952992653417, 0.72955614534918833, 4.9893385457301243, -4.9951855729182846, 
-0.85147238709252893]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[-0.076936971515947583, 0.96591761133066179, -4.6167646063351349, 2.0271833763580913, 
2.5095884650854652], [4.8917158391157045, -0.25021690479511971, 2.132018625605653, 4.1601611747154017, 3.204379729440415], 
[-0.72312034831626448, 3.5918537997251025, 3.519934821057852, -2.1094561286976186, 2.8903365982059981], [-4.7972633333815509, 
-4.5191085930110164, 3.2550932356179985, -1.5137486048197646, -0.2316874649356766]]))
      res=arg0/arg1
      ref=Data(numpy.array([[1.5178737306474492, 0.67192819353878208, -15.287809344268355, -12.823194664171417, 
1.0331400066298866], [-3.787233353588511, 5.6341300154665142, 0.88622503852458434, 0.84494932718440197, -24.825317441421952], 
[0.9862539191218278, 1.0991194684506016, 0.80379280430186917, 1.0766765537753729, 3.8358389568009357], [-3.6441850184230629, 
-4.5553029435119843, -0.66609014920635856, 0.66531046902124391, 3.9030616925986918]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[43.195737899269233, -3.4406135858607252, 0.7198437736691421, -1.6393925162986156, 
-1.3242606517372706], [-0.67938313787400828, 13.281873417336087, -1.5587805924642588, -0.79885108215639422, -1.0371271624998], 
[4.595845303073828, -0.92524624933808897, -0.94415079406715907, 1.5754531280146866, -1.1498139207831999], [0.69275939747585491, 
0.73539929124653214, -1.0209689909958777, 2.1954433158748388, 14.344104707128096]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_constData_rank0_taggedData_rank3(self):
      arg0=Data(-0.36054099192,self.functionspace)
      arg1=Data(numpy.array([[[-3.4777829118500825, 2.5861179243702326], [-0.31307176586733831, 2.9290849166548947]], 
[[2.3748161016655267, -4.5603485313701793], [3.1274404956404496, -2.9256573446892284]], [[-4.8051276071531142, 
-1.362383820269768], [-3.7761610666308321, 3.9014351538845524]], [[3.4904078719832139, -0.37896776253300857], 
[0.87231031240545853, -0.20747709716432006]], [[3.2213434923912203, 3.052045925261325], [-2.1594867981437114, 
-4.9541438692063364]], [[-4.3723471506500724, 0.13506123740451326], [1.6256383365753173, 
0.87551365598019615]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[2.1300119212290483, -4.9481617183479001], [-0.66984879260119978, 
-3.9605702045285254]], [[-1.5893085322329004, 2.620104187747696], [4.6267318374860036, -3.1524897793121531]], 
[[0.8804621030700952, -1.3592447340588243], [1.8097485258645669, -1.5679733865711976]], [[-1.7798184574398936, 
4.9462192372553542], [1.9662582740241668, -0.10421490819175183]], [[4.9092743420191063, 1.5159259140936934], 
[0.78477367127559017, 2.8264233550244757]], [[-4.8715818788534264, 0.98830914169182371], [3.0294781181419062, 
1.6374283490796513]]]))
      res=arg0/arg1
      ref=Data(numpy.array([[[0.10366978073626021, -0.13941397974247791], [1.151624104208065, -0.12308997594086808]], 
[[-0.15181848887876112, 0.079059964263627075], [-0.11528308609624804, 0.12323418276384251]], [[0.07503255301338807, 
0.26463980748715826], [0.095478181560060577, -0.092412401513537856]], [[-0.1032948025397831, 0.95137641658479333], 
[-0.41331735598263514, 1.7377387521200245]], [[-0.11192255429183651, -0.11813091963514279], [0.16695679372975589, 
0.072775640239444633]], [[0.082459370104271346, -2.6694631179779389], [-0.22178425779460351, 
-0.41180510373211804]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-0.16926712396603544, 0.072863623390261506], [0.53824235544224053, 
0.091032597151684672]], [[0.22685399631830341, -0.13760559355074359], [-0.077925629706630098, 0.11436706132588244]], 
[[-0.40949064208741676, 0.26525097569677791], [-0.19922159723687036, 0.22994075984174198]], [[0.20257177939283533, 
-0.072892238420041], [-0.18336400496457836, 3.4595913211997233]], [[-0.073440791204902559, -0.23783549615969357], 
[-0.45942034642138097, -0.1275608593025826]], [[0.074009018196912121, -0.36480588584116841], [-0.1190109246080127, 
-0.22018733956967321]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_constData_rank0_taggedData_rank4(self):
      arg0=Data(0.135869730246,self.functionspace)
      arg1=Data(numpy.array([[[[-2.0118141541466628, -1.4485699498312474, -4.356974536106236, -4.7847651197014365], 
[2.3506548838105692, 3.0216815570643298, 2.7951380752011135, -1.057300270840539], [-4.3410868494704991, 0.16768650552685216, 
2.2480335593136829, -4.3792660210958489]], [[-4.9305540684590614, -2.9602955008781384, -4.0273626067438526, 
-1.4797548019016737], [4.3308582325662499, -3.4271795134720295, 0.32855580481089319, 0.37615668601418939], [3.6176108347500531, 
4.1698238147380646, 0.96377054300975118, 4.9261629115498238]]], [[[-1.2781454968554637, 1.3968319656083903, 
-2.7477657102941566, 3.4642661657685707], [1.8680307006895234, -1.3674314148597801, -2.7640608668981437, 2.7193130543511259], 
[3.853725428116304, 3.8430630709740914, -4.2163460366112702, 3.5757860396038446]], [[-3.1834535912919684, 2.3549041314866077, 
-4.4559155722565613, 1.071754890339057], [-4.3932567550526338, -2.8465586048205891, -4.0923043129321526, 3.1526709972206337], 
[-3.1187854967479431, -3.0009675789119483, -0.1986567863252553, 1.8427407678950143]]], [[[-3.4859998323962182, 
-1.1653957041309901, -2.8192990087460092, -2.7864784822994415], [2.1558757316363453, 4.3765316546055324, 1.9820169980899855, 
1.0030089252137095], [-0.040605968139832527, -0.010031182935654748, -3.4416497495608347, 1.6219192195928898]], 
[[-2.2121224422209176, -1.2307420109277456, 1.8692260645322616, 2.2677320707085045], [-2.0758042127710343, 
-0.68542432885667637, 2.6831785432997002, -1.1319899673565748], [1.2850495340014021, -0.49126725450923381, -2.9377294292623377, 
4.4685947020146841]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[0.020539442728244595, 2.3361660977592056, 2.4631811124116876, 0.71783793677018082], 
[1.5301372766865304, 0.60482947813645715, -4.7186789711301067, -2.3308716345871403], [2.3518800389813652, 4.8033145433793223, 
2.8325970377015679, -4.1907034864924784]], [[0.70037695614196238, 3.5700465742164269, -2.2869246847346902, 4.636999560364492], 
[3.9990570879474987, -4.5953281305785634, -0.32834480236619701, -1.8109628339339459], [4.2348586650716875, -4.5962447679296385, 
-0.03838232625863025, 0.77467396901565699]]], [[[3.3869494172138399, 0.24851162824529016, -3.8280922056564668, 
0.29721104044761404], [2.0403740401664479, 3.8282110028211473, 2.3332955300893721, 1.9453471481140898], [-3.6327357067538357, 
0.39074252141170618, -4.1481501134298693, -3.1623475064843332]], [[1.4724796392860355, -2.9662747191833203, 
-2.0797484607657637, 1.8275664710887005], [-2.8927734364098647, -3.0993623517107771, -1.3220568256144194, 1.4930862990443998], 
[-3.1372480192288075, -0.11237338532426389, 1.0530442951046837, -0.17463262338962249]]], [[[4.5890428381345743, 
-1.3392215693772691, 3.9704494710711167, -2.6544632033270155], [-4.9180738375268129, -1.3418556383851818, -3.8770454208169767, 
1.4885355575169807], [-1.5485935986068577, 3.569321917567521, -1.7667207942154119, -4.5373079100481162]], 
[[-4.4949677820536866, -3.2680656021039969, 4.9586758956692449, -0.52504395141281002], [0.16264759970116671, 
-4.0921050841912052, -1.2774387526331266, 0.27980341051749669], [-2.972529251272781, 1.6080683030556884, -4.7553206687763847, 
-0.36967858035345547]]]]))
      res=arg0/arg1
      ref=Data(numpy.array([[[[-0.067535925207587208, -0.093795767516675746, -0.031184421464955158, -0.028396321835436816], 
[0.057800798910029871, 0.04496494011037238, 0.048609308946656722, -0.12850628529395891], [-0.031298551482006623, 
0.81026037139438811, 0.060439369191398959, -0.031025685489646248]], [[-0.027556685995023984, -0.045897353897849089, 
-0.033736651876962689, -0.091819083858626041], [0.03137247237148761, -0.039644766115086438, 0.41353623419990054, 
0.36120514481800031], [0.037557862482298157, 0.032584045821261939, 0.14097725981716339, 0.027581249886692898]]], 
[[[-0.10630224069191307, 0.097269917635967235, -0.049447349072373817, 0.039220349633807869], [0.072734206239684615, 
-0.099361276016864633, -0.049155838741890188, 0.049964725476756539], [0.035256723080146185, 0.035354540827656981, 
-0.032224520726295641, 0.037997164467107526]], [[-0.04267997831589973, 0.057696501708645896, -0.030491989366218466, 
0.12677313765559867], [-0.030926881314130374, -0.047731225352578975, -0.033201277289338027, 0.043096704466084747], 
[-0.04356494872369069, -0.045275307604381455, -0.68394205282047882, 0.073732416742057549]]], [[[-0.03897582810628529, 
-0.116586778005441, -0.048192735082203141, -0.04876037303323897], [0.063022987945082987, 0.031045069696465068, 
0.068551243696168204, 0.13546213481307237], [-3.3460532150871831, -13.544736559741143, -0.039478081772659102, 
0.083770960109911238]], [[-0.061420528833659137, -0.11039659736941489, 0.072687692957038433, 0.05991436642846646], 
[-0.065454019897492652, -0.19822717771435419, 0.050637603146201908, -0.12002732724151045], [0.10573112292639927, 
-0.27656988940112748, -0.046249912906421463, 0.030405471810803723]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[6.6150641009930879, 0.058159276592677771, 0.055160267980857082, 
0.18927633005486261], [0.088795778206408021, 0.22464138266647185, -0.028794018638965396, -0.058291382601204679], 
[0.057770688978193624, 0.028286661016878691, 0.047966487445126348, -0.03242169976567208]], [[0.19399514654858852, 
0.038058251460160786, -0.059411545624108213, 0.029301216978190586], [0.033975441524829286, -0.029566926753695825, 
-0.4138019827537312, -0.075026238915607765], [0.032083651661540008, -0.029561030168377293, -3.5399034787648933, 
0.17538956474638981]]], [[[0.040115665606185229, 0.546733894125493, -0.035492805017927849, 0.45714900106465772], 
[0.066590599356444707, 0.035491703604082173, 0.058230827811516069, 0.069843436621444557], [-0.037401490560794393, 
0.34772189562357636, -0.03275429445191206, -0.042964832285957204]], [[0.092272739548299496, -0.045804837079763877, 
-0.06532988619017277, 0.074344617498413243], [-0.046968673224073242, -0.043837962402497842, -0.10277147518441165, 
0.090999247888734383], [-0.043308571529328301, -1.2090917244679384, 0.12902565530969184, -0.7780317767023156]]], 
[[[0.029607422514548763, -0.10145425772166516, 0.034220239102894429, -0.05118538847165776], [-0.027626614551671744, 
-0.101255102530644, -0.0350446578511798, 0.091277450216008277], [-0.087737499604961022, 0.038065978184060524, 
-0.07690503824423095, -0.02994500989124485]], [[-0.030227075439445618, -0.041574970269428108, 0.027400405492256266, 
-0.25877782208596145], [0.83536265211198024, -0.033202893730884885, -0.10636105250913379, 0.4855899718831988], 
[-0.045708458609057416, 0.084492511908748874, -0.028572148906411323, -0.36753476524419448]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_constData_rank1_taggedData_rank0(self):
      arg0=Data(numpy.array([3.2585370968848757, 1.1454175877624291]),self.functionspace)
      arg1=Data(-2.93544378089,self.functionspace)
      arg1.setTaggedValue(1,-1.7765826732)
      res=arg0/arg1
      ref=Data(numpy.array([-1.1100662591795942, -0.39020252924586424]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-1.8341601244001815, -0.64473081103446983]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_constData_rank1_taggedData_rank1(self):
      arg0=Data(numpy.array([-3.2873749726724677, 2.537628784189514]),self.functionspace)
      arg1=Data(numpy.array([-0.80369604430644515, 4.5440558592404088]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([0.35406786474087504, 3.4767588100197635]))
      res=arg0/arg1
      ref=Data(numpy.array([4.0903212053374354, 0.55845017376474504]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-9.284590046256632, 0.72988346987897301]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_constData_rank2_taggedData_rank0(self):
      arg0=Data(numpy.array([[-1.4112039068670001, 2.3844727243919053, -0.75018126153440612, 0.29224859319870333, 
4.0528743390776452], [1.9704199277864749, -2.1729409187986413, -2.4825493518310005, -2.1875975998764421, 4.9720042358891909], 
[3.3006411409063965, 0.66079211276274386, -1.3681574974938391, 4.9776486045598318, -3.9336042743125299], [-3.6909919190458771, 
-2.1480074682985437, 3.2063682437999201, -2.1716564783041159, -3.0121932209668212]]),self.functionspace)
      arg1=Data(-1.57513181223,self.functionspace)
      arg1.setTaggedValue(1,1.87210037907)
      res=arg0/arg1
      ref=Data(numpy.array([[0.89592750010320077, -1.5138242437065803, 0.47626570405613905, -0.18553913452130785, 
-2.5730382102637277], [-1.2509555787543909, 1.3795295745554479, 1.5760899072386068, 1.3888346250686632, -3.1565639124768596], 
[-2.0954697983193307, -0.41951543841015804, 0.86859873368578333, -3.1601473387189079, 2.4973175221036521], [2.3432908219999318, 
1.3637001371036392, -2.0356189995643836, 1.3787141250263675, 1.9123435877384896]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-0.75380782069450514, 1.2736885003881666, -0.40071636645235031, 0.15610733081743924, 
2.1648808922810976], [1.0525183103519651, -1.1606967997516264, -1.3260770520575456, -1.1685258036029549, 2.655842759010095], 
[1.7630684646026589, 0.35296831310483778, -0.73081417684161565, 2.6588577515466865, -2.1011716670180491], [-1.9715779988690334, 
-1.1473783629953114, 1.7127117112145833, -1.1600107037981795, -1.6089912991020063]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_constData_rank2_taggedData_rank2(self):
      arg0=Data(numpy.array([[2.1242999657742629, -3.4221008601311564, 4.2534489054981375, -4.8094965494123985, 
4.2667327602227072], [-3.6816173720608258, 1.4409034883997451, -4.034615678096003, -1.8654408170921997, 0.87668821722978407], 
[-1.9951165434446114, 0.45212816257873989, -2.205575441391133, -1.7963673125665891, 4.1658244100775637], [2.265279299567001, 
-0.58964116078633833, -0.52906345752831019, -2.2048578238610403, -3.2055551728240972]]),self.functionspace)
      arg1=Data(numpy.array([[3.5943115462955646, -3.0844586504099247, -2.7379900762426268, 2.1889271004313908, 
-1.9778180484342145], [1.5687583805902436, 0.64969773638259731, -2.7566385783967382, -3.6243552192765769, 2.3794575949312815], 
[3.1534586273684582, -2.3236537673598701, -4.8303168433264752, 4.4349372319698883, 1.5406507964844085], [2.2497316341606242, 
0.5718283152109036, -1.83523453963251, 0.93037440006281891, -3.6951477240543626]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[4.8794157182702627, 1.4041991126063849, 1.3961903501679584, -0.19042047134780127, 
-0.67996644605524459], [4.1306622917886742, -4.7891221822455314, 1.4035302073653213, -2.7472352870139414, -3.9112979346701215], 
[1.1424091371706826, -0.12991144661524245, -2.8477964939229228, 1.8369104041912729, -4.673017980849564], [4.0404887066736102, 
0.60585388990847733, -2.2948948876050435, -2.6772976779015356, -4.6260664401208729]]))
      res=arg0/arg1
      ref=Data(numpy.array([[0.59101720549618131, 1.1094656301119028, -1.5534931782277279, -2.1971935696097642, 
-2.157292863011623], [-2.3468351899262023, 2.2178059237553178, 1.4635998022064018, 0.51469591257794611, 0.36844036182754614], 
[-0.63267566795684393, -0.19457639039418806, 0.45661092489995503, -0.40504909508464171, 2.7039381147132793], 
[1.0069108978023407, -1.0311506882426151, 0.2882811139955172, -2.3698608041151696, 0.86750393007479598]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[0.43535949556831788, -2.437048157493328, 3.0464677720960163, 25.257245270798098, 
-6.2749166300421422], [-0.8912898494218463, -0.30087006210481188, -2.8746197673006999, 0.67902477298178832, 
-0.22414253065682757], [-1.7464115775419691, -3.4802796393900821, 0.77448492056849483, -0.9779286504490492, 
-0.89146338129865454], [0.56064487838450727, -0.97323986955899855, 0.23053929850375054, 0.82353854114168079, 
0.69293323265377493]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_constData_rank3_taggedData_rank0(self):
      arg0=Data(numpy.array([[[2.6375759461098571, -0.43198402551411963], [1.6874696619176541, 1.831463809668338]], 
[[-3.8383287600871805, 3.0959933190860376], [-1.5389902059323646, 1.0811639522118535]], [[1.6142394852896498, 
3.8739496592777307], [0.043286786771422392, 2.3845984586399274]], [[1.5164970238400599, -3.7468631863780386], 
[3.2752310454695071, -1.6820948111677749]], [[-4.7093914200301317, -1.8351240837587754], [0.23258098683259831, 
-3.3092167865797997]], [[-1.5246914567979806, -1.3122311385794418], [-4.5490618864752239, 
-2.2060097425654037]]]),self.functionspace)
      arg1=Data(2.83227781938,self.functionspace)
      arg1.setTaggedValue(1,0.866518073529)
      res=arg0/arg1
      ref=Data(numpy.array([[[0.93125608231636536, -0.15252176977761089], [0.5957994835003334, 0.64663988720835253]], 
[[-1.3552091301988771, 1.0931107456685982], [-0.54337543986691195, 0.38172948459113409]], [[0.56994390671798034, 
1.367785897543796], [0.015283383033680311, 0.84193663570746313]], [[0.53543371115005634, -1.322915132384398], 
[1.1563946951303552, -0.59390177039002467]], [[-1.6627575825370751, -0.64793223009413459], [0.082117998891539187, 
-1.1683941327835796]], [[-0.53832694178648688, -0.46331300185285212], [-1.6061495999240374, 
-0.7788818340731205]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[3.043878744928076, -0.49852858089271096], [1.9474142703636017, 2.1135898553278136]], 
[[-4.4296003480420287, 3.572912572358137], [-1.7760624422584472, 1.2477107924698314]], [[1.8629034230251316, 
4.4707084336997163], [0.049954857369736774, 2.7519315886042008]], [[1.7501043199994299, -4.3240450497703202], 
[3.7797607984471511, -1.9412114560033753]], [[-5.4348450008117082, -2.1178139727493139], [0.26840869675744916, 
-3.818981839702408]], [[-1.7595610563425637, -1.5143724968548706], [-5.249817661564169, -2.5458323489804116]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_constData_rank3_taggedData_rank3(self):
      arg0=Data(numpy.array([[[4.8303225645325281, -1.0125453237903259], [2.569604615749455, 1.2552508462123315]], 
[[-3.126977584206112, 3.1569136639623281], [3.7002735557649693, 2.5687804807560424]], [[-3.0538389311101088, 
-0.36985166324444041], [-0.69529422769575078, -4.8557413152636464]], [[-2.4905676261177154, 3.7498719272240759], 
[-1.9291435617097052, -2.6737150849446745]], [[-1.8559499267186572, 4.7293161660832688], [1.0977607101120492, 
1.2895476314272951]], [[-1.7741830671411298, 4.9174177866142958], [-0.56915213868415027, 
1.7847200642595595]]]),self.functionspace)
      arg1=Data(numpy.array([[[2.7162713855158316, 0.48303593143262091], [-0.18054295857952596, 2.4043604973410515]], 
[[0.19783477216364709, -1.0306617538413732], [-0.7179577077467405, -1.1511629800898646]], [[-3.0798640564733648, 
4.1804252248204214], [-4.9327278660714358, 3.2549958666072847]], [[-2.0909917665980826, -2.9585134915299847], 
[-3.7066650346990504, 4.2676629763540515]], [[4.1253146300741932, -4.5927979362442741], [4.3699763164694332, 
-0.81512767038709111]], [[-0.34278103039103591, -3.6926309440512481], [-2.819051354175758, 
4.6322903358636172]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[4.0791814075741115, -2.7571044312349056], [-2.2565683255916067, 
2.1599933357453178]], [[1.9490405642078104, -2.1937628909281379], [-2.0780393295047404, 3.3735947926417786]], 
[[-3.277246602870342, 0.12914894658870946], [-2.8392206047615187, -2.2118315970562996]], [[-1.113162735231592, 
-4.0540600088616854], [2.8236181373569611, -1.4112029583924612]], [[2.6684523673283422, 4.8710676069119501], 
[3.495269856384505, -2.1577555328919082]], [[-2.2665352681117277, 0.96684744328519123], [-0.37893362511194795, 
0.44803354310583465]]]))
      res=arg0/arg1
      ref=Data(numpy.array([[[1.7782915912929771, -2.0962111882386263], [-14.232649314969489, 0.5220726457619379]], 
[[-15.806005941258421, -3.06299680976442], [-5.1538879182424493, -2.2314655050456129]], [[0.99154991100709289, 
-0.088472259005739809], [0.14095531855267393, -1.4917811002705927]], [[1.1910939420721482, -1.267485153594768], 
[0.52045262888620725, -0.62650567764113418]], [[-0.44989293984717915, -1.0297244145582054], [0.25120518524890906, 
-1.5820192078805393]], [[5.1758496236422031, -1.3316840651341435], [0.20189491682763633, 
0.38527810971650306]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[1.1841401697810543, 0.36724953625960677], [-1.1387222742638556, 
0.58113644400629605]], [[-1.6043676266312474, -1.4390405075302828], [-1.7806561710489168, 0.76143717270339217]], 
[[0.93183068019215765, -2.8637605881701695], [0.24488911729145199, 2.1953485616744488]], [[2.2373796276961753, 
-0.92496705007506275], [-0.68321687560608813, 1.8946354024019156]], [[-0.69551547910028333, 0.97089930744801434], 
[0.31407037373863006, -0.59763379667899308]], [[0.78277320106261516, 5.0860327766971238], [1.5019837274034635, 
3.9834518904268119]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_constData_rank4_taggedData_rank0(self):
      arg0=Data(numpy.array([[[[-0.40439655050506307, 4.7434545426165862, 3.135682738883439, 3.6890247371085412], 
[-3.0240233683889506, -3.0091160627712443, 4.9563636007625362, -2.7993775220515458], [3.1593616202308965, 2.2839736444338268, 
-1.680261946012791, -2.7937825726014989]], [[0.46596655666301601, 3.6943544529664702, -1.5589931865433759, 
-1.2021917139461835], [-1.7532963918640587, 2.687443190168004, 1.2626313379950984, 0.57686811363170865], [3.6083299837397291, 
-3.301213684076548, 3.806992606627297, -0.70222177045157963]]], [[[-4.7482159117577414, 2.5371566506143637, 
-3.1243746857120214, 2.0799416723605884], [-3.4564422813449669, -4.9450390976084515, -1.1433380071130661, -3.7353188366478474], 
[0.70693669677722148, -4.4585762059345875, 4.2928520010064801, -4.7999322967126181]], [[-0.26969445824687988, 
1.4888875603746863, 1.5696795377620223, 0.68305017181904315], [-3.4740113184712964, 3.0298970865586483, -3.2140618612730174, 
-4.2715960958365384], [2.905858897840174, -1.1307926793268299, -1.515030551515939, -1.7465901236069117]]], 
[[[-1.8544338104517877, 3.1855981173537415, 0.57801513741138155, -1.8057838711819985], [1.7459494646057667, 1.7369656430881362, 
1.8768624862324437, -2.0087825793770966], [-2.624487765952952, -4.3579545617989499, 4.1792741353895337, 0.39684950891829107]], 
[[-2.6538601617546975, 3.4521058612465634, 0.46125256449499119, 2.3167452388635059], [-4.6112734888389975, -3.702753425479882, 
3.5555330825741684, 0.35105302555406759], [1.9210357584595217, -2.9392465676608639, 1.865934640724296, 
0.73700163702246435]]]]),self.functionspace)
      arg1=Data(0.829003758751,self.functionspace)
      arg1.setTaggedValue(1,1.06971166958)
      res=arg0/arg1
      ref=Data(numpy.array([[[[-0.48781027376104608, 5.7218733842238949, 3.7824710754138002, 4.4499493496487137], 
[-3.6477800449861792, -3.6297978519498373, 5.9786985866413476, -3.3767971405467923], [3.8110341320917875, 2.7550823748688975, 
-2.0268447860177918, -3.3700481368287885]], [[0.56208014951015761, 4.4563784107979192, -1.8805622653544578, 
-1.4501643704945666], [-2.1149438387426422, 3.2417744332285046, 1.5230707034405169, 0.69585705437707202], [4.3526099196195558, 
-3.9821456166276832, 4.592250115204406, -0.84706705251844816]]], [[[-5.7276168673998109, 3.0604887177329076, 
-3.7688305423618633, 2.5089653097536093], [-4.1693927739896317, -5.9650382105157291, -1.37917107738596, -4.5057924010832169], 
[0.85275451325173579, -5.3782340054213869, 5.178326341338086, -5.7900006435998366]], [[-0.32532356506240862, 
1.7959961515960026, 1.8934528597647315, 0.82394098290758133], [-4.1905857263024267, 3.6548653182526722, -3.8770172358651176, 
-5.1526860412241549], [3.5052421260666509, -1.3640380606127389, -1.827531582968055, -2.106854287656343]]], 
[[[-2.236942584249122, 3.8426823566576043, 0.69724067148081303, -2.1782577607410714], [2.1060814817499973, 2.095244592987068, 
2.2639975590232519, -2.4231284335846315], [-3.1658333731904493, -5.2568574216923976, 5.0413210932700654, 0.47870652542805148]], 
[[-3.2012643293130285, 4.1641618928836897, 0.55639381562051471, 2.7946136726269075], [-5.5624277214240045, -4.4665098154203422, 
4.2889227522113744, 0.42346373203801402], [2.317282326143792, -3.5455165753297142, 2.2508156579850498, 
0.88902086298524519]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-0.37804257166346222, 4.4343299951987474, 2.9313345157067121, 3.4486159607565199], 
[-2.8269518360836048, -2.8130160195064051, 4.6333640566204277, -2.6169458571581141], [2.9534702762306999, 2.1351301564638931, 
-1.5707615367776886, -2.6117155230324118]], [[0.43560014339897168, 3.4535983462062738, -1.4573956991240327, 
-1.1238464982085212], [-1.6390364261038859, 2.5123061350095548, 1.1803473533154409, 0.53927439518367282], [3.3731799758422207, 
-3.086078032021407, 3.558896023014301, -0.65645892292610175]]], [[[-4.4387810723222128, 2.3718135669391711, 
-2.9207633931388002, 1.9443946733649367], [-3.2311905905577594, -4.6227775560930757, -1.0688282082272358, -3.4918931361449497], 
[0.66086658384982444, -4.1680167962459684, 4.0130926146730594, -4.4871271700845732]], [[-0.25211883343638514, 
1.3918587622441594, 1.4673856352185677, 0.63853671156971914], [-3.2476146771840999, 2.8324427719467464, -3.0046057761956426, 
-3.9932219282306467], [2.7164879850202865, -1.0571004425656678, -1.4162980498435984, -1.6327671963218056]]], 
[[[-1.7335828552624859, 2.9779969761527787, 0.54034666896762351, -1.6881033670476324], [1.6321682882053794, 1.623769930243006, 
1.7545498844335694, -1.8778729226845192], [-2.4534534310468277, -4.0739525292126961, 3.9069164656721544, 0.37098736061789062]], 
[[-2.4809116673521099, 3.2271367691199502, 0.43119335575507162, 2.1657660701981594], [-4.3107630027680326, -3.461449968986773, 
3.3238237776561528, 0.32817537242825034], [1.7958444439708809, -2.7476998253416252, 1.7443341919073063, 
0.68897223240944938]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_constData_rank4_taggedData_rank4(self):
      arg0=Data(numpy.array([[[[2.0267423103229278, 4.4304144537213581, 2.3998280562999295, 0.73346121699437994], 
[-0.70471017413104953, 0.12036320698675773, -1.9875348687034, 1.7040368796017802], [-2.9924975322791738, 3.8272926953468183, 
4.5594274045174554, -0.16228766761595814]], [[2.1449467587140028, -1.138919086121045, -3.5854052066399369, 
-3.5438499769716714], [1.7706143766847457, -3.3001727622469601, 4.6622898862050697, 2.1136376510182036], [-0.10334082163529423, 
-2.4222888015696475, 2.0207072143394091, 4.2395543949793613]]], [[[0.81742005488931291, 4.023960713960161, 3.6165574700924363, 
-3.98217737122601], [4.7758814615918705, -4.0098356488952538, -2.3378042266399977, 4.5768812718249325], [-4.6356398313845091, 
-2.469718272610578, -0.88945710474326667, 4.1639966092317433]], [[-2.4091448984896768, 0.87460010281437039, 3.8200461458693944, 
0.96138924349685517], [4.5419678853711218, 1.3431536047458454, -0.5432998335173167, -1.5681019632291857], 
[-0.71961925597821619, -0.023225164995805514, -3.2215782779344018, 0.7147037911800993]]], [[[-3.2331757340286984, 
-3.8028177233147877, -3.0284332892284773, 1.9064210246288908], [-1.9767690620578748, -3.2315964412321154, 4.1049555220198339, 
-1.9432452143380763], [-1.2618564757456676, 4.2475267848701819, -4.3922832376031993, 4.9266431588365869]], 
[[-0.73818099973821916, -0.2429119201422747, -1.6837321904074165, -2.2725318026746888], [-0.078372641583149161, 
0.21708511865109692, -4.8602869378366602, 0.10115190778778782], [-2.4173702167796951, 3.6570734534176221, 4.9018739714191923, 
-3.0200750675728982]]]]),self.functionspace)
      arg1=Data(numpy.array([[[[-3.0749199480722957, 4.527135569632474, 3.8314162039939816, -0.17890255087897344], 
[3.2744214839737396, -4.1033528924311957, -2.3215361326676143, 2.6137076375879973], [-0.49410291123851291, -1.7907712904243955, 
-1.2137242352469935, -2.1619296163976607]], [[-3.1907513685622515, 1.708388050884051, 4.2066499009231801, 2.6406571363429556], 
[1.5124465159515852, -0.85708823513832133, 2.2589981571609554, -4.0864183610547142], [0.017339812113645436, 3.4317973973471965, 
-2.5492970433716824, -2.3343116509947048]]], [[[1.4621064465511546, 4.3954244313602562, 2.2436704937089864, 
-2.593153967022086], [-0.43817452374418142, -1.4572602329033826, 1.4650427063747902, -1.6351042957221118], 
[-0.98293393491229253, -0.016659450881860494, -3.5572714927863922, 4.3513430853277075]], [[-4.4471446796274332, 
-4.6056359498574739, 0.70449701331028436, 1.8998795430745439], [1.9254438963206244, 0.39398369895024388, -4.6753723861998964, 
-1.944419492280276], [4.0698412790670542, -1.1423603011108452, -4.4919602257110594, 0.7227419735777163]]], 
[[[2.323855700529923, -0.75697665479222032, -1.3518806584814111, 4.0554573487258452], [-2.0576602387607945, 1.4415740555727732, 
-4.8307337346390886, -4.4699681608555775], [-3.1584800206067474, 2.2059791039773256, -4.7926475503324699, 4.947202826973145]], 
[[-0.72950717024511924, 0.36647077147856066, 2.1111574790992034, 1.0656325051029505], [-1.9285251192882846, 3.8562039891700302, 
-1.2230308520631796, -1.1689889042311554], [1.9053815031943824, 4.656492252685668, 3.6513764548491707, 
1.8199585584886613]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[-0.36456385228451182, 2.2220461965410649, -1.9938606399882297, 4.0566344137755568], 
[2.5297709783923326, 0.73437391225396098, -4.8661744266664355, 1.4313162781076647], [-1.5867385405986867, -4.7509072633968721, 
0.6862239678750548, -3.3828501795365149]], [[2.7038486779949036, -3.8417740864616636, -2.0001342191239049, 
-4.8125464015906152], [3.0740096934550287, 2.0861463332381156, -2.2973261516936407, 3.7860789586752617], [0.046222477934768413, 
-3.9412823790604556, -0.71558050872530998, -0.63438638763907029]]], [[[2.3169286406542327, -4.4338772677528677, 
-1.6916025033697224, -4.8289544524638552], [3.5897702062943253, -0.69684785172973474, 4.999688069539534, -4.9405518118605398], 
[3.0674225999757248, -0.34068115988563097, 4.445246225618849, 2.7354626544339853]], [[1.1404855054694529, 4.6077912581580058, 
-0.1561917937774302, 1.9031770744487231], [3.6884162791384458, -4.5702543326058205, -1.3577584451280034, -0.658097687525105], 
[4.2446893257066911, 1.5532247403082442, -2.1916973257355208, -0.7737461629127651]]], [[[-3.922054846645552, 
0.093300629927113299, -3.6473786127903542, -1.4747299137752634], [-4.7722884547734976, -3.3666393719363876, 2.9647284395784048, 
1.2114491935013492], [0.29917041263470701, -1.0464700598139776, 0.82958819060768629, 3.8284997851980638]], 
[[4.8272996441080291, 2.0515738836123996, -0.21313910907914746, 4.9907295061662555], [4.2134997819973101, 4.8047816888385597, 
-1.0342983460422284, -0.21998108051719445], [3.4369485288642814, 1.2991584707787407, 4.2376545125842977, 
2.8609853695778709]]]]))
      res=arg0/arg1
      ref=Data(numpy.array([[[[-0.65912034932600994, 0.97863525082838021, 0.62635535492027139, -4.0997806537178016], 
[-0.21521669631724821, -0.029332891940338023, 0.85612919856628622, 0.65196154883425039], [6.0564256235167946, 
-2.1372314353106403, -3.7565595809245829, 0.075066119814932636]], [[-0.67223876477737377, -0.66666299002248397, 
-0.85231842228018395, -1.342033362907366], [1.1706955307247537, 3.8504469282726315, 2.0638750285943139, -0.51723476753189523], 
[-5.9597428713758056, -0.70583677330197114, -0.79265271169295981, -1.8161903930748868]]], [[[0.55907013939885108, 
0.91548854423481962, 1.6118933150981301, 1.5356501857847817], [-10.899495983431853, 2.7516263453550982, -1.5957242860345231, 
-2.7991372072101632], [4.7161255367565964, 148.24727958468969, 0.25003913998325711, 0.95694513799022707]], 
[[0.54172847344636132, -0.18989779312484215, 5.4223737981794917, 0.50602641993873709], [2.3589198802678562, 3.4091603493358544, 
0.11620461187668225, 0.8064627871993959], [-0.17681752349398189, 0.020330857937921231, 0.71718762323289242, 
0.98887821284569044]]], [[[-1.3912979765875384, 5.0236922093173524, 2.2401631906106005, 0.47008780038775538], 
[0.96068778743003969, -2.2417137910741061, -0.84975818323104524, 0.43473356954876563], [0.3995138381477758, 1.9254610241828658, 
0.91646280922503953, 0.99584418329799163]], [[1.0118899852487886, -0.66284118420201366, -0.79753983635831738, 
-2.1325661443249051], [0.040638641830121613, 0.056295029843019297, 3.9739692008894525, -0.086529399399488297], 
[-1.2687066672616276, 0.78537088756206486, 1.3424729090612697, -1.6594196903476985]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-5.5593616800527546, 1.9938444396961397, -1.203608721778116, 0.18080535295556471], 
[-0.27856678732985241, 0.1638990778108329, 0.4084388873961835, 1.1905383217290575], [1.8859424257446253, -0.80559196026283308, 
6.6442264012375905, 0.047973649142863672]], [[0.79329393548186045, 0.29645654858638709, 1.7925823039067896, 
0.73637731073104629], [0.57599505312381316, -1.5819469179443577, -2.0294418721381482, 0.55826560251077262], 
[-2.2357265610280397, 0.61459407588732218, -2.8238712341941365, -6.6829214459617727]]], [[[0.35280329335412658, 
-0.90754896244558059, -2.1379475750882055, 0.82464587529795441], [1.3304142569398483, 5.7542484187070828, -0.46759001644182713, 
-0.92639070413904756], [-1.5112491612408394, 7.2493538340649053, -0.20009175186228073, 1.5222275480464735]], 
[[-2.112385371787791, 0.1898089678576276, -24.457406202229002, 0.50514965549137492], [1.2314141196752477, -0.293890341104938, 
0.40014469102867323, 2.3827799321500671], [-0.16953402257735506, -0.01495286830880403, 1.4699010853851633, 
-0.92369284067219026]]], [[[0.82435760346236953, -40.758757216168412, 0.83030406511915, -1.2927255403319997], 
[0.41421826882249857, 0.95988791320212008, 1.3845974785480095, -1.6040666210042858], [-4.2178518411391819, -4.0589090390462106, 
-5.2945344296497074, 1.2868338605853447]], [[-0.15291799850030183, -0.11840271612083342, 7.8996867242331223, 
-0.45535062556824218], [-0.018600366829970134, 0.045181057685801336, 4.6991150633032381, -0.45982094255547334], 
[-0.7033478088129822, 2.8149556314138504, 1.1567422395720093, -1.0556066101164652]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_float_rank0(self):
      arg0=Data(3.65356534422,self.functionspace)
      arg0.setTaggedValue(1,-1.17926016579)
      arg1=-2.37300818504
      res=arg0/arg1
      ref=Data(-1.53963453108,self.functionspace)
      ref.setTaggedValue(1,0.496947365468)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_array_rank0(self):
      arg0=Data(-0.177107121474,self.functionspace)
      arg0.setTaggedValue(1,-0.694156234322)
      arg1=numpy.array(1.03752931743)
      res=arg0/arg1
      ref=Data(-0.170700835629,self.functionspace)
      ref.setTaggedValue(1,-0.669047344167)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_array_rank1(self):
      arg0=Data(-0.667094646269,self.functionspace)
      arg0.setTaggedValue(1,-3.86103689664)
      arg1=numpy.array([-3.2794782614723719, 2.4566354281925591])
      res=arg0/arg1
      ref=Data(numpy.array([0.20341487062327701, -0.27154808508157807]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([1.1773326696498316, -1.5716767951517205]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_array_rank2(self):
      arg0=Data(-1.12136649302,self.functionspace)
      arg0.setTaggedValue(1,-0.135474988185)
      arg1=numpy.array([[-4.7016203258815779, -1.195553024451661, 0.70607934955873386, 0.76361944055447672, 
-2.9546114444532368], [-0.84237928527766659, -2.6504357791235478, -2.9392721252310561, -3.9923151524787492, 
1.0749527219716075], [0.95063739419692794, -3.6584397860427131, 4.2619516746355277, 4.7461606918243255, -0.86318012019117152], 
[-0.68072422070398009, 0.072401114773859909, -2.3193253343869316, 0.76198100785014233, 0.91251085425159228]])
      res=arg0/arg1
      ref=Data(numpy.array([[0.2385063904142028, 0.93794793713844393, -1.5881593105999545, -1.4684886652568985, 
0.37953095156699246], [1.3311895397029334, 0.42308759255992201, 0.3815116277931947, 0.28088125566134947, -1.043177499906532], 
[-1.1795943436154879, 0.30651495134679546, -0.26311102955430854, -0.2362681261415599, 1.2991106569689186], [1.6473139326001751, 
-15.488248993493775, 0.48348822668315927, -1.471646250328329, -1.228880169259758]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[0.028814531756039312, 0.11331575046375719, -0.19186935330939797, -0.17741165427452185, 
0.04585204881653223], [0.16082421606592465, 0.051114231573554221, 0.04609133908426561, 0.033933941337482058, 
-0.12602878751399904], [-0.14250963512686152, 0.037030809882891681, -0.031787077500483422, -0.028544121655704174, 
0.15694868894217642], [0.19901596573844743, -1.8711726830187876, 0.058411377729707246, -0.17779312973585071, 
-0.14846397448725826]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_array_rank3(self):
      arg0=Data(1.04505458244,self.functionspace)
      arg0.setTaggedValue(1,-4.42265972115)
      arg1=numpy.array([[[-0.85371618468244836, 4.7933895743288719], [4.7447822909239825, 0.99290307762258756]], 
[[-1.5109097371537974, -4.971113528906753], [-0.55762642667318563, 1.1502033348125016]], [[-2.915209220379694, 
4.3298574014955165], [2.4121988281640956, 3.8675256922831416]], [[2.425278072924498, 3.5545003821874452], [2.2306237850195725, 
2.5967654878909752]], [[-1.8835381269518461, -3.3280636126263619], [1.5102969231404115, 3.5994910063932277]], 
[[3.8930526803950087, 3.8178257644340459], [-0.25009295764235873, -2.2152654993081686]]])
      res=arg0/arg1
      ref=Data(numpy.array([[[-1.2241241307007049, 0.21801995565650301], [0.22025343174091433, 1.0525242654517788]], 
[[-0.69167241215094977, -0.21022545076924704], [-1.874112367081217, 0.90858246608186222]], [[-0.35848356101981954, 
0.24136004619426188], [0.43323733111789414, 0.27021270589739527]], [[0.43090093218851216, 0.29400885358644868], 
[0.46850329018183351, 0.40244472876458726]], [[-0.55483590562127338, -0.31401280266239062], [0.6919530632867259, 
0.29033398905105007]], [[0.26844090440961821, 0.27373029753610123], [-4.1786645745298729, 
-0.47175139177037556]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[5.1804801179861473, -0.9226581008220337], [-0.93211014752147037, 
-4.4542713390918811]], [[2.9271501879931465, 0.88967184020901746], [7.9312233237153436, -3.845111196683642]], 
[[1.5170985637093932, -1.0214331122366394], [-1.8334557124863804, -1.1435372569017261]], [[-1.8235680974171313, 
-1.2442422972616765], [-1.9827008708739322, -1.7031417514495626]], [[2.3480595682486451, 1.3288987939927761], 
[-2.9283379005727084, -1.2286903101841669]], [[-1.1360390121157231, -1.158423666776744], [17.684063409234277, 
1.9964468017633181]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_array_rank4(self):
      arg0=Data(2.79370294518,self.functionspace)
      arg0.setTaggedValue(1,-2.86744498095)
      arg1=numpy.array([[[[1.4248287908084727, -1.7304678349826075, -1.5878385754886071, -0.21777917617957332], 
[0.53171468876790673, 4.3731568345348251, 1.7050672045022974, 4.6050075276918818], [4.6527971178732344, 1.8938925169077283, 
2.583143433781574, 3.1480201107678738]], [[3.7875392155597289, 2.2412750037755425, -2.5736967334388119, 2.8802643576253697], 
[-0.61376571637346622, -2.8428520213819422, -3.1372808922717743, -0.38231467528594898], [3.680723722632548, 4.7481540330616312, 
-1.0051596282873811, 1.8839188110630971]]], [[[1.2870581087220643, -1.32073746798542, -1.9812776812063246, 1.2948176354033203], 
[4.3700562979327735, 1.0740891030122421, -0.83870482096762267, -4.5607652083519579], [-2.4091902868028257, -0.1426399567648744, 
3.6538589418800846, 1.813285329001407]], [[-4.5038182270932703, 1.673874344250895, -0.15539206591807631, 4.7273666398045773], 
[1.8809828251669458, -1.2176266440921211, -3.9709101887242868, -3.5862383890117364], [0.20581793341956001, 4.1878806179562069, 
-2.6295301450609152, 1.8092259097201078]]], [[[-1.7469294859436548, 3.3695279137357126, -2.5809961613918042, 
1.6559816856217102], [-2.9355906765013873, -0.13185985973782621, 1.3934501237527011, -3.3011587407423693], 
[0.79080667429923501, 2.9204713694404578, -1.9600441816227301, -3.7026076834852804]], [[2.874970873111188, -2.3154801899357014, 
4.2187833414159801, 3.8758031353410143], [0.80152141615899541, -2.6708142888982209, -2.322302379449328, 3.5335964742879185], 
[-3.6888480534253389, 1.6825242681388195, -3.121182557042339, 4.9088970957681823]]]])
      res=arg0/arg1
      ref=Data(numpy.array([[[[1.9607288701676631, -1.6144206143030291, -1.7594376332144346, -12.828145437012129], 
[5.2541391167090827, 0.63882980896600328, 1.6384708695395529, 0.60666631452489972], [0.60043515210507159, 1.475111665653392, 
1.0815128996125596, 0.88744761687777352]], [[0.73760370155570676, 1.2464793211355674, -1.0854825702216608, 
0.96994671263005838], [-4.5517416021398178, -0.98271134908605051, -0.89048543662957513, -7.3073390214349683], 
[0.75900913942710324, 0.58837664610953277, -2.7793624679736122, 1.4829210944646627]]], [[[2.1706113548813706, 
-2.1152598551214075, -1.4100511865067165, 2.1576034097759633], [0.63928305603426594, 2.6009973821998753, -3.3309727991799658, 
-0.6125513631064039], [-1.1596024442268964, -19.585696802960708, 0.76458970902329382, 1.5406857930752531]], 
[[-0.62029655823549712, 1.6690039815590301, -17.978414333310379, 0.59096388286476165], [1.4852357543117387, 
-2.2943838809204746, -0.70354221385242965, -0.77900648036789266], [13.573661433521872, 0.66709230755189308, 
-1.0624342719294195, 1.5441426801235936]]], [[[-1.5992076198056466, 0.82910811742970381, -1.0824126695631147, 
1.6870373443383861], [-0.95166637758700279, -21.186909729305842, 2.0048819097023234, -0.84627949292617244], 
[3.5327255522468426, 0.95659316315075138, -1.4253265162988999, -0.75452307778784966]], [[0.97173260825457031, 
-1.2065328640370845, 0.66220583497577379, 0.72080620393492945], [3.4855000613359475, -1.0460116814549199, -1.2029884522818712, 
0.7906117649574671], [-0.75733749526227201, 1.660423565999795, -0.89507835383765322, 0.5691101057287643]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-2.0124838853957407, 1.6570345446373296, 1.8058794043768491, 13.166754651443592], 
[-5.3928263437566777, -0.65569223548209699, -1.6817196257005873, -0.62267975974127643], [-0.61628412077865158, 
-1.5140484242642236, -1.1100603022853344, -0.91087251035715755]], [[-0.75707334439471796, -1.2793811451604968, 
1.1141347555423324, -0.99554923608262536], [4.6718884819646034, 1.0086508053824248, 0.9139905158041397, 7.5002221110274396], 
[-0.77904379601169316, -0.60390732082063669, 2.8527259753115857, -1.5220639892288397]]], [[[-2.2279063870683133, 
2.1710938399618454, 1.4472706214527549, -2.2145550867916435], [-0.65615744637120044, -2.6696527996683979, 3.4188965047819191, 
0.62872014891249084], [1.1902110832246724, 20.102677019711976, -0.78477166922993291, -1.5813534335101465]], 
[[0.63666978469523572, -1.7130586837647073, 18.452969036795519, -0.60656284977051977], [-1.5244397463838892, 
2.3549459884626263, 0.72211277633331694, 0.79956898284727118], [-13.931949142180247, -0.68470074544515958, 1.0904780788826149, 
-1.584901567871948]]], [[[1.6414199909168152, -0.85099309290804626, 1.110983822387275, -1.7315680516559679], 
[0.97678637689616443, 21.746155248846939, -2.0578023799141323, 0.8686177206689295], [-3.6259746840034026, -0.9818432089266923, 
1.4629491558583025, 0.77443932116805103]], [[-0.99738227185825601, 1.2383802692043659, -0.6796852904959868, 
-0.73983246331670482], [-3.5775026382840207, 1.0736220009264832, 1.2347422998506716, -0.81148059825585794], 
[0.77732802745489571, -1.7042517812369331, 0.91870466675527218, -0.5841322246135271]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_constData_rank0(self):
      arg0=Data(-0.0283128535384,self.functionspace)
      arg0.setTaggedValue(1,1.79608880446)
      arg1=Data(-4.66599643441,self.functionspace)
      res=arg0/arg1
      ref=Data(0.00606791152467,self.functionspace)
      ref.setTaggedValue(1,-0.384931456702)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_constData_rank1(self):
      arg0=Data(-0.878851394404,self.functionspace)
      arg0.setTaggedValue(1,4.7006799177)
      arg1=Data(numpy.array([1.0889262256835419, 0.17033168040482405]),self.functionspace)
      res=arg0/arg1
      ref=Data(numpy.array([-0.80708074952693132, -5.1596472970586333]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([4.3168029264304835, 27.597214484854483]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_constData_rank2(self):
      arg0=Data(-1.79071968044,self.functionspace)
      arg0.setTaggedValue(1,-4.05190302404)
      arg1=Data(numpy.array([[3.3227948715468596, 4.4019901286560756, 3.5327950123940628, 1.0360594336973552, 
-4.5360262382692866], [-0.67888861194611128, -3.1593593522434316, -0.13551814757515857, -4.9347811884290627, 
-3.5929785159799921], [4.5309740146872759, -2.336853069803011, 3.5886944968120922, 4.0147878253869642, 4.1742705165228315], 
[4.3444033431698639, 2.9195692550647863, 1.0568468873081969, -2.4811997399936656, 1.7952193648542227]]),self.functionspace)
      res=arg0/arg1
      ref=Data(numpy.array([[-0.53891971959345386, -0.40679775013200803, -0.50688468313565871, -1.728394744739798, 
0.39477718742734746], [2.6377223729048844, 0.56679835396661249, 13.213873658119953, 0.36287722029893232, 0.49839420761250436], 
[-0.39521738033277909, 0.76629536686769606, -0.49898916779662672, -0.4460309631102366, -0.42898984944853791], 
[-0.41219001528850074, -0.61335064319303612, -1.6943984052425862, 0.72171524588551328, 
-0.99749351834003408]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-1.2194261700390827, -0.92047072019966925, -1.1469397487883246, -3.9108789440543812, 
0.89327151369871471], [5.9684356943632517, 1.2825078037288395, 29.899338919082414, 0.82109071695755875, 1.1277281525661247], 
[-0.89426754841266765, 1.7339143296576429, -1.1290743827972198, -1.0092446226956842, -0.97068529890370614], 
[-0.93267192384569186, -1.3878427500929345, -3.8339546368501343, 1.6330418541984197, -2.2570517583320071]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_constData_rank3(self):
      arg0=Data(4.52906509113,self.functionspace)
      arg0.setTaggedValue(1,-4.6262702253)
      arg1=Data(numpy.array([[[-4.29305547636723, 0.24597715884219884], [-2.1490153711561897, 3.51230655418175]], 
[[2.6472988906595161, -4.9815800353560373], [0.28601959081328143, -2.007021075964289]], [[-3.5903182816760193, 
3.1653115189614223], [-4.1478168439266607, -4.2020309451968281]], [[0.24634018030861071, 3.0513399543590047], 
[1.3704546924491146, -3.2920982593393147]], [[3.3681734611895902, 1.7271529165301036], [3.2683825469940047, 
-3.5607612048751571]], [[1.6754734057637668, -1.967821549034011], [3.4461406769222833, 
-2.4790813441888373]]]),self.functionspace)
      res=arg0/arg1
      ref=Data(numpy.array([[[-1.0549747414302821, 18.412543312738627], [-2.107507071338302, 1.2894845655582292]], 
[[1.7108249873508081, -0.90916236595256861], [15.834807253056409, -2.2566106282418334]], [[-1.2614661809348371, 
1.4308433985077138], [-1.0919154006903529, -1.0778276386334962]], [[18.385409499385933, 1.4842872832495637], 
[3.304790093448887, -1.3757381263690789]], [[1.3446650367961674, 2.6222722075040048], [1.3857206205227857, 
-1.2719373275931789]], [[2.7031554637310369, -2.3015629101885073], [1.3142426603348187, 
-1.8269126592973086]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[1.0776171542088682, -18.807722827108233], [2.1527394765979158, -1.3171601493029179]], 
[[-1.7475435968437694, 0.92867527821883289], [-16.174662064752624, 2.3050431710493737]], [[1.2885404196376797, 
-1.4615528985347981], [1.1153506529772534, 1.1009605320950226]], [[-18.780006653839173, -1.5161438235339111], 
[-3.3757192053070564, 1.4052649285845098]], [[-1.3735249323144181, -2.6785527679841756], [-1.415461672183546, 
1.2992363034537868]], [[-2.7611719824312937, 2.3509602420883402], [-1.3424496150967729, 1.8661228023630585]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_constData_rank4(self):
      arg0=Data(-1.87400473233,self.functionspace)
      arg0.setTaggedValue(1,0.0362796037947)
      arg1=Data(numpy.array([[[[0.058347597377736982, 1.8625416969204966, 1.7934734722818755, -2.8351925203595063], 
[3.7760306971696025, -1.7564200670817955, 1.0856871257068548, 0.11871549003082116], [1.1036491406041629, -3.77448405271008, 
2.5647614059537158, -3.2943957938616042]], [[-0.048275771939394474, 0.37830551598762252, 2.5615192384070005, 
0.72340458478667014], [-4.125241159258958, 2.6684660155882058, 1.0466547599654721, 0.10552320824038919], [-4.30863132838223, 
-3.6083832495958665, -2.412632296893209, -4.548670155534329]]], [[[-3.9261352738412292, 1.1068734025516633, 3.8061208327786602, 
1.4249499053819417], [-0.80053884869661651, 2.8600876648003082, 0.66840261404344314, -1.0356828709045973], [3.3694562891636632, 
-4.1939741897498273, -0.91815132723240733, 1.3279872691013317]], [[-3.0704812663247583, -1.1798506923743446, 
-1.3672698458334342, -4.1232225798817712], [-0.028968607237399802, 3.8138090299463947, 1.3795904838575224, 1.9475879248430283], 
[0.28188355764269257, 2.0712127537582656, 3.7175372210568352, 2.8979979571539687]]], [[[-3.7108215503854289, 
-3.0870336230592033, 4.2993691563358389, 1.2096120473062193], [4.1636582734336027, 4.3237750957454182, -2.3970015820029911, 
3.3478797896379984], [-4.9528365930148919, -0.43664652527808556, -0.75980631710951396, 2.2076815680212958]], 
[[-0.99806651102131205, 4.3667553186072201, -3.0086784842363201, -2.5060720681661985], [4.7629622091106008, 
-0.55449294733600141, 0.68510782006316084, -3.9654897352036], [-4.5885399126788995, -2.7777416633007324, 3.7004375397447156, 
3.3904007245100249]]]]),self.functionspace)
      res=arg0/arg1
      ref=Data(numpy.array([[[[-32.117941724354175, -1.0061545121017657, -1.0449023982216474, 0.66097971085808682], 
[-0.49628959153826102, 1.0669456398592636, -1.7261001700781289, -15.785679963479948], [-1.6980076941013735, 
0.49649295272255856, -0.73067410012643319, 0.56884626183230336]], [[38.818741928909333, -4.953680697575531, 
-0.7315989293524392, -2.5905347736866715], [0.45427761917096643, -0.70227790850135785, -1.7904707493004266, 
-17.759171310117146], [0.43494200118483406, 0.51934747578271312, 0.77674693103769998, 0.4119895855834152]]], 
[[[0.47731537545846181, -1.6930614901524548, -0.49236606368225022, -1.3151372727253392], [2.3409291571363031, 
-0.655226325891336, -2.8037064681683534, 1.809438762560033], [-0.55617422263678806, 0.44683268125835135, 2.0410630325864343, 
-1.4111616699476368]], [[0.6103293164127801, 1.5883405794024406, 1.3706180517657194, 0.454500016923164], [64.690881303910629, 
-0.49137351073936109, -1.3583775433810368, -0.96221829496364231], [-6.6481519816408419, -0.90478620746893823, 
-0.50409844499189382, -0.64665495284704666]]], [[[0.50501073869736235, 0.60705679340062613, -0.43587900089309101, 
-1.549260968843363], [-0.45008610439800101, -0.43341864246784068, 0.78181205486242289, -0.55975866819784192], 
[0.37836999003302318, 4.2918118520254938, 2.4664242585707918, -0.84885644717950559]], [[1.8776351191430976, 
-0.42915267643893368, 0.62286639870391725, 0.74778565075565739], [-0.39345362193922895, 3.3796728007771435, 
-2.7353427846750757, 0.47257838437905325], [0.40840981401426846, 0.67465047491399777, -0.50642787838097658, 
-0.55273841784736677]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[0.62178402239677533, 0.019478545825149091, 0.020228681580975662, 
-0.012796169407965474], [0.0096078678125977434, -0.020655425472901591, 0.033416260482131442, 0.30560126387296094], 
[0.032872407053981444, -0.0096118047627378588, 0.014145410840360856, -0.011012521283057748]], [[-0.7515074816465358, 
0.095900277055182684, 0.014163314977590796, 0.050151194169464092], [-0.0087945413114306186, 0.013595677660043118, 
0.034662436156038368, 0.34380686864703153], [-0.0084202153838812688, -0.010054254574754526, -0.015037353119012274, 
-0.0079758704311799246]]], [[[-0.00924053840845423, 0.032776651522280563, 0.0095319106745833139, 0.025460266117209578], 
[-0.045318979651999214, 0.012684787337541239, 0.054278069882531657, -0.035029645477315963], [0.010767198230585103, 
-0.0086504117939936436, -0.039513751947704318, 0.027319240657531135]], [[-0.011815608254188132, -0.030749317713843406, 
-0.026534340609700356, -0.0087988467980685912], [-1.2523765294410913, 0.0095126954469523534, 0.026297371734019317, 
0.018627967103277715], [0.12870422133916665, 0.017516116453457822, 0.0097590425158952786, 0.012518850713872098]]], 
[[[-0.0097767039729918081, -0.011752254178159649, 0.0084383551343230855, 0.029992759972514129], [0.0087133961079852267, 
0.0083907240759159424, -0.015135410867939748, 0.010836590939437436], [-0.0073250152944441711, -0.083086894534684722, 
-0.047748489289656318, 0.016433349954193613]], [[-0.036349885898478117, 0.0083081375409621641, -0.012058318622212481, 
-0.014476680162380245], [0.0076170253304385172, -0.065428431450784169, 0.052954590113089332, -0.0091488331119974863], 
[-0.0079065682079979861, -0.013060827172677586, 0.009804138944396204, 0.010700683117615812]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_taggedData_rank0(self):
      arg0=Data(-0.453669765546,self.functionspace)
      arg0.setTaggedValue(1,0.011241474504)
      arg1=Data(-0.588500262809,self.functionspace)
      arg1.setTaggedValue(1,-2.03150897246)
      res=arg0/arg1
      ref=Data(0.770891355903,self.functionspace)
      ref.setTaggedValue(1,-0.00553355887489)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_taggedData_rank1(self):
      arg0=Data(-4.21556327047,self.functionspace)
      arg0.setTaggedValue(1,4.7278077455)
      arg1=Data(numpy.array([1.3595023971429061, -4.4488245092837806]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([-2.989062845700512, 3.8385217993932503]))
      res=arg0/arg1
      ref=Data(numpy.array([-3.1008134147646746, 0.94756789387139084]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-1.5817023560744135, 1.2316740642833679]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_taggedData_rank2(self):
      arg0=Data(-0.966091079476,self.functionspace)
      arg0.setTaggedValue(1,-4.93447026408)
      arg1=Data(numpy.array([[-1.6438963019922581, 4.9735662405722749, -3.4220694157282736, 4.613346795430628, 
0.31826771793314279], [-2.8442408494331883, 3.703145829016032, -2.7304274489860725, -2.665330148633287, 3.3337899074801882], 
[1.6383386529679491, 0.88312808709937496, 0.71961606206577144, -4.8979257227363888, -3.439782929743159], [0.085268288014404447, 
2.1849421213156086, 4.9132009902484022, -1.0220567518567858, -4.3980456582799548]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[-2.1102216161630838, -2.8754796356858692, 1.0958404074990646, 2.7929272330041401, 
0.59825843078902796], [4.3816838410124177, 2.8159133132667389, -3.1884389513683029, 1.755729350297992, 4.4439353669117967], 
[1.8292411860347197, 1.5454540994262169, -1.1884358494391467, 3.8954003857137209, 4.5154354665709899], [2.6643375285810942, 
-0.9198120970567123, 0.56163720459659228, 2.1611035627761357, 4.1699640542628043]]))
      res=arg0/arg1
      ref=Data(numpy.array([[0.58768371113522133, -0.19424514176473803, 0.28231194698622919, -0.20941219516234047, 
-3.0354667628566072], [0.33966570716709987, -0.26088388739823892, 0.35382411637966382, 0.36246582059324373, 
-0.28978763098076776], [-0.58967727931349512, -1.093942196595052, -1.3425090550410448, 0.19724494289320049, 
0.28085815274058951], [-11.330016140503185, -0.44215865951385885, -0.19663170332208066, 0.94524210883707249, 
0.21966372214837537]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[2.3383658978206934, 1.7160511946741146, -4.5029095754383706, -1.7667736580348312, 
-8.2480580467071327], [-1.1261584457311464, -1.7523516227690079, 1.5476132174217168, -2.8104959703739749, -1.1103829954009687], 
[-2.6975503841439123, -3.192893445306368, 4.1520712004846763, -1.2667427672330847, -1.0928005284564608], [-1.8520439738382921, 
5.3646503235492693, -8.7858678586368057, -2.2833104109740323, -1.183336402872704]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_taggedData_rank3(self):
      arg0=Data(-1.81664246796,self.functionspace)
      arg0.setTaggedValue(1,4.46387457355)
      arg1=Data(numpy.array([[[1.4850376184631315, -1.3933942291535595], [-2.0083169776060785, 0.98100783331441122]], 
[[-4.4032839330649285, -3.5634930840889103], [2.2732272840852499, 1.6835078278446218]], [[-1.2429237532913051, 
1.4955486286156363], [4.2157916269941929, -2.76280105088229]], [[3.8009575255761554, 2.888422220105995], [3.4482664468826201, 
0.89811738641277117]], [[-0.43029554687801141, -3.9738451716931733], [0.36127797698629571, 2.6502839052976777]], 
[[1.2205998958897144, 4.3255182934682495], [3.3092526196601373, 2.3106639707779166]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[3.6431867103538238, -2.3447916583182327], [1.0122395694910651, 4.9223038188279116]], 
[[-0.62554367985776338, 1.9161664116007717], [0.81108174545006317, 1.5775982015840553]], [[0.64593983524115384, 
0.15898102039526663], [1.5037109500046384, -4.7876085795451715]], [[-3.9803137633694474, 0.23223516944779554], 
[-0.39621951450216653, -4.2304355031718242]], [[1.1852613265336416, -0.42000938189589032], [-3.2873826804966857, 
-3.6672001473908464]], [[3.4239409211551166, 2.4165247208931344], [2.2879787259509357, -2.4164695851244824]]]))
      res=arg0/arg1
      ref=Data(numpy.array([[[-1.2232972723202762, 1.3037534029852396], [0.90455963287448415, -1.8518123976862448]], 
[[0.4125653706583633, 0.5097926178306067], [-0.7991468695968813, -1.0790816876003344]], [[1.4615880203016602, 
-1.2146996982910105], [-0.43091372361166519, 0.65753647638826906]], [[-0.47794337498774819, -0.6289393757302848], 
[-0.52682775416072336, -2.022722748097459]], [[4.2218481718890883, 0.45714978552748042], [-5.0283786548878355, 
-0.68545202433884311]], [[-1.4883193699068511, -0.41998261126352637], [-0.54895853437309317, 
-0.78619933098595485]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[1.2252664846589463, -1.9037403846587668], [4.4098993045646022, 0.90686693423453668]], 
[[-7.135991805666424, 2.3295860664952817], [5.5036062623681046, 2.8295383254552871]], [[6.9106661797454967, 
28.078034487721304], [2.968572233604903, -0.93238085348562338]], [[-1.1214881134829493, 19.221354733503706], 
[-11.26616537088057, -1.0551808602694857]], [[3.7661522177613387, -10.628035386737865], [-1.3578810279784586, 
-1.2172432357495935]], [[1.3037241810952354, 1.847229012373437], [1.9510122725009749, -1.8472711599726042]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_taggedData_rank4(self):
      arg0=Data(-4.33459200977,self.functionspace)
      arg0.setTaggedValue(1,4.96142104529)
      arg1=Data(numpy.array([[[[-2.5560622075966832, 0.21123248607315492, -2.8558357377619545, 2.6728741063594743], 
[-1.4130500254892961, -0.51734307388043455, 4.4618570982579016, -3.9222758679812788], [1.4871882525810518, 
-0.21059693570670746, 3.9415040459913477, -4.159679074077939]], [[2.2319614247688175, -0.87556252785269528, 
0.28045835245833572, -2.3407235358027698], [-1.253587074114618, -4.8227016394684803, 4.2556425164228084, 2.0646454127542757], 
[4.0984029147716399, 1.5667800037135944, -1.2676554805251969, 4.1855175758015868]]], [[[1.5379230034448863, -3.177082682780509, 
0.91412809104564907, 2.2907979947424462], [1.647498035765242, -0.94889258263806298, 3.2399002953813145, 2.7380089511422465], 
[2.3615886927451726, -4.3396607248204733, 4.6957926389748064, -0.27105662440875555]], [[4.2139321486118586, -3.387080457729498, 
0.17859242801337682, -0.96930346441610915], [-0.49096192080272161, -3.4895088559320939, 0.74554073476852345, 
-4.8638424465808425], [-4.7678993684924018, -3.9431336725572885, -2.0242236648446488, 1.3933820507885297]]], 
[[[2.8325719326427565, 0.32418415704306724, 3.8267512851785881, -4.4640542958307652], [4.4364015446792706, 4.2276973150545203, 
3.3791890929061736, -2.3884012760197981], [-4.7491093887390265, -3.1323487130297343, 0.56655435324242465, 
-2.2453913298191166]], [[-0.51407286716072775, -3.1993706638928012, -4.2917732732211, 1.5017220912066467], [-3.622510023882155, 
0.83477979765192245, 3.6295131008120798, -4.3922952577479357], [4.5397371755719753, -0.9752586798552132, -2.1838605695407853, 
2.4725808570494054]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[2.4282905664511114, 1.9431491180501297, -3.1746436884664178, -0.65762774630028797], 
[4.812600111110978, -1.5260077684590003, 3.3167087834720004, 3.8033036220531358], [-4.5797919222237304, 2.7027967837481484, 
-2.4155868025454685, -0.68624512601000376]], [[4.734589744190842, 1.8007573220468487, 0.14863374647300898, 1.0064009264892135], 
[-1.9212161124061424, 0.37223127267947742, -4.2615002122289871, 2.5541471478074556], [3.0348236956004833, 4.175461027670865, 
-3.673667802411865, 1.4904880820072268]]], [[[-1.9876615154973463, -0.86128681568929011, 0.48043512360380269, 
3.9156066572136847], [3.022730516281392, 4.1999878128093719, -2.7600327036443852, 3.6732147186618427], [-3.4472025910571293, 
-4.703661587379953, -3.3156001581157044, -0.38300653380579863]], [[1.3581160499399383, -4.1721407248007658, 
-4.8363925850034502, -0.93945114774215455], [-2.8287495114445882, -4.0237412510872854, 3.8868602247425326, 2.3362985572430066], 
[-2.185778561021865, 2.5925884494093223, 3.0317331003427164, -0.14622785786970294]]], [[[3.232202668141591, 1.0171116756135987, 
-0.075629080005226612, 1.9926159022248422], [1.9387335848887854, 0.96264876721385928, 1.5561037577523198, 
-0.19116181552739953], [2.8667716742977412, -3.494625065354775, -2.3419505667791087, 1.8383806894854127]], 
[[-1.547464180775008, 4.0477413875198085, -0.20463792402589664, 0.68985914454873143], [2.2072971665380283, 2.9453420023492924, 
-4.0311444937145193, -3.4110707691073596], [-3.173364921520534, -1.2199118557933564, 1.5909898667373223, 
-3.412580452142179]]]]))
      res=arg0/arg1
      ref=Data(numpy.array([[[[1.6958084967121141, -20.520480018712675, 1.5178015851724329, -1.6216970337114038], 
[3.0675432090709185, 8.3785639136032302, -0.97147710343739779, 1.1051216578496583], [-2.9146222761270391, 20.582407788705176, 
-1.0997304478668786, 1.0420496227171112]], [[-1.9420550739205307, 4.9506367299634269, -15.455385699062452, 1.8518171597230495], 
[3.457751040412258, 0.89878917125897573, -1.0185517211654171, -2.0994365342302297], [-1.057629544948901, -2.766560716560905, 
3.4193770124129723, -1.0356167263106146]]], [[[-2.8184714059532663, 1.364330879161648, -4.7417774951089662, 
-1.8921755736277899], [-2.6310149788760238, 4.5680534225658782, -1.3378782106185234, -1.5831182757670925], [-1.83545594670363, 
0.99883200199861155, -0.92307994475529365, 15.991463109311725]], [[-1.02863355576218, 1.2797428534286539, -24.270861077282134, 
4.4718627023357014], [8.8287743429880088, 1.2421782516466353, -5.8140243820654405, 0.89118676383407258], [0.90911986071085349, 
1.0992759489576251, 2.1413602088778276, -3.1108424335695921]]], [[[-1.5302672316332158, -13.370770642537403, 
-1.1327080561926017, 0.97099894457276237], [-0.97705132551984719, -1.0252843774628837, -1.2827314159088206, 
1.8148508181132157], [0.91271681803018867, 1.3838152794854652, -7.6507964063113238, 1.9304394526705344]], [[8.4318630425051087, 
1.3548264534291594, 1.0099769335004833, -2.8864142274715401], [1.1965714328436565, -5.1924974968962658, -1.1942626708792818, 
0.98686262088620536], [-0.95481122411476393, 4.4445561975523171, 1.9848300162673123, 
-1.7530638067544368]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[2.0431743687680202, 2.5532888851436528, -1.5628276846687046, -7.5444217084912788], 
[1.0309231872059188, -3.2512423251319693, 1.4958868472318418, 1.3045030158848496], [-1.08332892182688, 1.835661887392716, 
-2.0539195859432171, -7.2298087917082894]], [[1.0479093888507571, 2.7551858235148754, 33.380178882828965, 4.9298653396532464], 
[-2.5824377659837419, 13.328866781073204, -1.164242824875751, 1.9424961672835088], [1.6348300734855044, 1.1882331106468604, 
-1.3505361159865292, 3.328722386436386]]], [[[-2.4961096276257364, -5.7604748556651826, 10.326932402605916, 
1.2670887245923208], [1.6413706146050036, 1.1812941528455039, -1.7975950207919491, 1.3507027019377569], [-1.439260070807908, 
-1.0547997455016132, -1.4963870215622512, -12.953880958620276]], [[3.6531642826204016, -1.18917873881903, -1.025851594570367, 
-5.2811911052726916], [-1.7539273184921862, -1.2330368022430431, 1.2764598566501668, 2.1236245812474013], [-2.2698644472817016, 
1.9136940328591159, 1.6364966443560727, -33.92938334441709]]], [[[1.5349968905714506, 4.877951127933895, -65.60202828001097, 
2.4899033676055913], [2.5591040893732173, 5.1539265558440936, 3.1883613291060389, -25.954038109577169], [1.7306648763750825, 
-1.4197291418987759, -2.1184994746142505, 2.6987995868705825]], [[-3.2061621244178244, 1.2257257987359027, -24.244875767339327, 
7.1919334323524575], [2.2477358828289016, 1.6844974340286156, -1.23077231615738, -1.4545054562419526], [-1.5634574554119662, 
-4.0670324021627628, 3.1184491799866598, -1.4538620011667873]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_expandedData_rank0(self):
      arg0=Data(-4.34905492087,self.functionspace)
      arg0.setTaggedValue(1,1.15303882944)
      arg1=Data(3.0112285778,self.functionspace)
      arg1.setTaggedValue(1,1.60456097144)
      arg1.expand()
      res=arg0/arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*(-1.44427923969)+(1.-msk_ref)*(0.718600819765)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_expandedData_rank1(self):
      arg0=Data(4.00995768724,self.functionspace)
      arg0.setTaggedValue(1,-2.00220236418)
      arg1=Data(numpy.array([2.0994462036726649, 2.673579231938076]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([3.114021857047252, 0.10008508054673104]))
      arg1.expand()
      res=arg0/arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([1.9100073534757624, 1.4998462133978903])+(1.-msk_ref)*numpy.array([-0.64296349097475847, 
-20.005003275627548])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_expandedData_rank2(self):
      arg0=Data(-4.17082551299,self.functionspace)
      arg0.setTaggedValue(1,-1.74232260959)
      arg1=Data(numpy.array([[4.0087954440243898, -2.7750306475964361, 4.0606996479551647, -2.1548122550698356, 
-3.446092235357614], [3.1107974127556037, -1.7059535742566112, 0.49777370979760249, -4.6293523622698887, 3.0208945209323232], 
[-3.6038287403873204, -0.46401708293522148, -3.3073887136789715, 1.0377385090007838, 0.18590623208800228], 
[-1.3240557135703392, -4.2378047306192741, -3.6624302691775146, 0.10933844803161996, -3.9071019631855517]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[-3.3859783889657393, -4.4839394837855027, 0.40761343030684483, 0.62017427853840168, 
0.79315590574968819], [4.611823226693474, -1.9803892482674201, 4.0135141972339774, 0.47314003176127439, 1.1011054979752899], 
[-2.3804860772558243, 2.5479357901319508, 3.8728716729138828, -0.26970301851693268, -3.4891404874928966], [1.4584278871775824, 
-2.7580017330900031, 4.838708039328802, -1.4264068079588057, -3.0704374164044546]]))
      arg1.expand()
      res=arg0/arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-1.0404186422639154, 1.5029835856400873, -1.0271199238007953, 1.9355865009457414, 
1.2103058270443545], [-1.3407576770777332, 2.4448646058865409, -8.3789590146926525, 0.9009522686107575, -1.3806591008342803], 
[1.1573317750214087, 8.9885171610543662, 1.2610629938161126, -4.0191488287368502, -22.435103256846631], [3.1500377742707832, 
0.98419483154811127, 1.1388136309615753, -38.146009826108468, 
1.0674985071505667]])+(1.-msk_ref)*numpy.array([[0.51456991434589971, 0.38856960846318933, -4.2744484848685573, 
-2.8094080484817816, -2.1966962572639872], [-0.37779475143420799, 0.8797879563886094, -0.43411397692026032, 
-3.6824671188809219, -1.5823393968978872], [0.7319188405401984, -0.68381731452382388, -0.44987873514442428, 6.4601524267989623, 
0.49935582010316376], [-1.1946580457666589, 0.63173368917180084, -0.36008012788241156, 1.2214766501853977, 
0.56745094372497051]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_expandedData_rank3(self):
      arg0=Data(0.532523847342,self.functionspace)
      arg0.setTaggedValue(1,4.66312843622)
      arg1=Data(numpy.array([[[4.3058616519490709, -2.513724733530025], [0.47677819556482604, -2.3538795590231896]], 
[[4.2414306346467541, 0.7495356419509358], [0.21876776368661677, 1.6942419352442748]], [[0.34188533835082957, 
1.8739372160026218], [-3.4264188783980662, 2.6968599559437578]], [[-2.8486975740462981, -1.2073590382391339], 
[0.74015335841206031, -3.6939094924523208]], [[2.8768705604203904, 1.3121327841819399], [-1.3068827757046808, 
1.8769048375264816]], [[-4.1700688019836445, -0.30075017722268527], [-2.477106430988516, 
-2.7504480564723655]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[-1.8923219781201093, -2.7349215148924233], [-3.2080724587704323, 
2.7255473360138529]], [[1.9532585980913897, -2.4769636671330897], [-2.0641982451685017, -0.52231436217788474]], 
[[4.8766931059149758, 4.9785123468885306], [-4.3322694338406276, 1.3911220481054443]], [[-3.4277872458857592, 
-0.34209859507274487], [3.9534173442797389, 0.076064301005633439]], [[-4.6658285648326512, 0.66662009356085594], 
[-0.43037456264572871, 4.4454766831101242]], [[0.02690897096143452, -1.2437812763101008], [4.8013379238845229, 
-0.70182714290652903]]]))
      arg1.expand()
      res=arg0/arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[0.12367416568086602, -0.21184652409980201], [1.1169215628897846, -0.22623241078784126]], 
[[0.12555288373503906, 0.71047168078085277], [2.434197060700741, 0.31431393372119421]], [[1.5576094895171591, 
0.28417379344116289], [-0.15541703050358063, 0.19746069727068263]], [[-0.18693590088106068, -0.44106502744924431], 
[0.71947771538120697, -0.1441626678807725]], [[0.18510525105593223, 0.40584600412529381], [-0.40747636837963225, 
0.28372447909710463]], [[-0.12770145353206705, -1.7706518156022191], [-0.21497818611270872, 
-0.19361349002352529]]])+(1.-msk_ref)*numpy.array([[[-2.4642362611315156, -1.7050319034120851], [-1.4535608207574411, 
1.7108961472082065]], [[2.3873584587193055, -1.8825986420773517], [-2.2590506736134919, -8.9278196693193141]], 
[[0.95620707207590117, 0.93665097348489101], [-1.0763708276762816, 3.352062777360449]], [[-1.3603902756265474, 
-13.630948806522021], [1.1795183837514258, 61.305084968497027]], [[-0.99942129708037053, 6.9951813353102796], 
[-10.835046587217185, 1.0489602732450494]], [[173.29270758450068, -3.7491547147692197], [0.97121438027152807, 
-6.6442691528115176]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank0_expandedData_rank4(self):
      arg0=Data(2.84998385413,self.functionspace)
      arg0.setTaggedValue(1,2.38733853285)
      arg1=Data(numpy.array([[[[-0.45767471930061454, -3.9272674409317219, 3.1347077551511013, 3.4434165582722596], 
[3.8366679836940509, 2.0244239729990268, 2.1264023907726672, -3.6142433976306299], [-1.7270712058341275, 0.29499008578792996, 
-4.8017571425766974, 3.2939256106497972]], [[-0.34618201821149963, -2.4172694552892859, -3.8971442881709359, 
1.8658079940269303], [-1.0723662209946019, -3.6580915735177544, -1.632814753749666, -0.90754508331792572], [1.8084875698726597, 
-3.5821375798551989, -3.0735656954115429, -4.6306368534833684]]], [[[2.6106457117901307, 4.8445064796969337, 1.960913330311981, 
-3.263287320551381], [-4.9748402967369723, 4.0240054393186444, 3.1368794853996196, 3.3037202682139881], [-4.2907290089086905, 
-2.9123732359332157, -1.8498883241099859, 0.70581339775108187]], [[0.47222113136728794, 3.3175404153925712, 
-4.1590485580973757, -3.7590442260778509], [3.936768352922476, 3.1093324299232741, -2.0058900491385021, 2.1007633817438069], 
[3.5490048646907564, -4.0159649758207818, 3.6258432291040634, 4.1273276907005325]]], [[[-1.052267174503827, -4.364689840543754, 
-3.9360336931486173, -1.4835175450225977], [-1.4611255072993359, 1.1133357251379286, -0.2513726868743893, 
-0.018276028050577153], [-1.3787857770503287, -2.3085969384722862, -2.5296618435851248, 3.9382584085266537]], 
[[-3.4493005662193643, 1.4206714036461374, 2.4068575425257519, 2.1101204030556158], [-3.0147594614038553, -3.0716631930591065, 
-0.23661279388452439, 2.4538655210309201], [-3.6104680324761871, -2.6301357082606023, 0.94962766549029176, 
0.64114360257541936]]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[[4.4029532775525855, -1.2794583911017385, 2.2116669645505009, 4.0372280430621625], 
[1.2597434228646085, -1.9498847622761186, 2.1355755818358393, -1.2434962073760056], [-2.7182716530855009, 
-0.020458879868014535, -4.0102943031373623, -0.66194171493406984]], [[2.7611009636686479, -0.52995287741487296, 
3.3840860450347741, -0.49817405196504438], [-2.199767859266343, -2.3823180148864056, -2.388450843121487, 3.7616876244212065], 
[-4.8455888355476233, -2.4034466953760125, 2.9715782875682537, 1.0470845329951644]]], [[[-2.0927578239431224, 
2.8732508131325751, 4.4545282333887783, 0.34668571156381223], [4.164036149729494, 3.751233043208952, 4.5605571272969527, 
2.1461349398201239], [2.2920546635129604, 4.3306935057898741, -0.080249260842084169, -0.78641690174511858]], 
[[1.607953891314664, -3.3051180264265376, 3.9490904120897508, -0.85002362574627366], [2.7586761102882402, 1.1942678969622014, 
0.72440912431206872, 3.7439455761677447], [-4.970263955895561, 1.266860145804749, 3.3056040701731764, -1.5083371070444542]]], 
[[[1.8563925528372778, 0.319524985186181, -0.62735601486433534, 3.792017753253651], [0.95176703360505499, -0.24796663592225787, 
2.4647140520697182, 1.964227599160421], [3.6552171220798986, 2.5348443529495057, -2.813465204571858, 4.5565891008354509]], 
[[3.1125587828185388, 4.1989891896862233, 2.3324754666992504, 4.5738156221432131], [0.71412413993541257, 0.92660128246471452, 
-3.9490083746591278, 0.086510484903197238], [-0.74779213574335923, -0.50155660488376519, 0.81877138380351244, 
2.0393373031117203]]]]))
      arg1.expand()
      res=arg0/arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[-6.2270947770121685, -0.72569131005023291, 0.90917051181059461, 0.82766165693219285], 
[0.74282785642121762, 1.4077998937669847, 1.3402843537491382, -0.78854231455350121], [-1.6501831797669881, 9.6612869090666198, 
-0.59352936216970387, 0.86522410977130315]], [[-8.2326166704192349, -1.179009583681806, -0.73130057380168556, 
1.5274797102655309], [-2.6576591078037262, -0.77909035267444615, -1.7454422478621912, -3.1403220694095015], 
[1.5758935265051568, -0.79560982530508284, -0.9272565276161312, -0.61546261222870113]]], [[[1.0916777566777229, 
0.58829188609231842, 1.4533961343788382, -0.87334750948188644], [-0.5728794663009964, 0.70824552727491696, 0.90854107318831101, 
0.86265894892732131], [-0.6642190285636882, -0.97857782064603505, -1.5406248133916649, 4.0378715722997178]], 
[[6.0352738681460734, 0.85906530057754327, -0.68524899729257749, -0.75816715173394267], [0.72393994226550562, 
0.91659027085685185, -1.4208076137330607, 1.3566420087547628], [0.80303746058001002, -0.70966352328431048, 0.78601960262677728, 
0.69051552668056715]]], [[[-2.7084222744772144, -0.65296366024769248, -0.72407506548744294, -1.9210988529858974], 
[-1.9505400733131548, 2.5598602378220541, -11.337683061610832, -155.941096513986], [-2.0670244076816702, -1.2345090676648578, 
-1.1266264150501122, 0.72366603673261187]], [[-0.82624978583734043, 2.0060823683878728, 1.1841099042100345, 
1.3506261775396193], [-0.94534369677381869, -0.92783084439965358, -12.044927103638624, 1.1614262597935805], 
[-0.78936687113463988, -1.0835881377437204, 3.0011592518799706, 
4.4451568146031937]]]])+(1.-msk_ref)*numpy.array([[[[0.54221300621641033, -1.865897749747417, 1.0794294851428443, 
0.5913311082228172], [1.895099025342373, -1.2243485251227986, 1.1178899745612927, -1.9198599229264124], [-0.878256052938022, 
-116.68960120268146, -0.5953025769167376, -3.6065690966310622]], [[0.8646328273632381, -4.5048128514702999, 
0.70546035209564317, -4.7921776002490351], [-1.0852683944788606, -1.0021074088070556, -0.99953429635258939, 
0.63464560888931154], [-0.49268285318359656, -0.99329789066892193, 0.80339075798195669, 2.2799864362653226]]], 
[[[-1.1407619675524712, 0.83088414068849681, 0.53593521193960836, 6.8861751529461639], [0.5733232006180522, 
0.63641434838981936, 0.52347519529201958, 1.1123897610335147], [1.0415713773567623, 0.55126009948763577, -29.749040773721628, 
-3.0357162054306048]], [[1.4847058399792141, -0.72231566732681929, 0.60452871009070419, -2.8085555042734645], 
[0.86539283243466492, 1.9989974937153852, 3.2955666248948861, 0.63765310800693686], [-0.48032429545726701, 1.884453103018465, 
0.72220946071351932, -1.5827619182094577]]], [[[1.2860095399560929, 7.4715238041905501, -3.8053967385144816, 
0.62956945040771106], [2.5083223609978846, -9.6276602857194842, 0.96860669530708499, 1.2154083029240683], [0.65313179850004, 
0.94180872686495098, -0.8485402730315551, 0.5239310545720407]], [[0.76700191046363453, 0.56855076900795321, 1.0235213904438498, 
0.52195775476701822], [3.3430301530880921, 2.5764463939678341, -0.60454126868197777, 27.595944416720677], [-3.192516233777984, 
-4.7598586273336894, 2.9157571699221654, 1.1706442721414778]]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank1_float_rank0(self):
      arg0=Data(numpy.array([-4.7578217123530333, 4.4315786179062311]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-1.3831856498875386, -1.2228219493438997]))
      arg1=-1.04566150784
      res=arg0/arg1
      ref=Data(numpy.array([4.5500591507840911, -4.2380623028539377]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([1.3227852794827566, 1.1694242737061613]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank1_array_rank0(self):
      arg0=Data(numpy.array([0.89679554939939443, -0.92263199926399064]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-3.2732533809677413, -1.2063353198834714]))
      arg1=numpy.array(-4.70762130446)
      res=arg0/arg1
      ref=Data(numpy.array([-0.1904986598115003, 0.19598687736207673]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([0.69530940771887595, 0.25625156355312528]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank1_array_rank1(self):
      arg0=Data(numpy.array([4.1010553208827556, 1.0401909712110395]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([2.379786423594668, 0.18274133683874005]))
      arg1=numpy.array([-0.11664989875909892, 4.6921845196824794])
      res=arg0/arg1
      ref=Data(numpy.array([-35.156955681136971, 0.2216858622775196]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-20.401101491817968, 0.038945897390051103]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank1_constData_rank0(self):
      arg0=Data(numpy.array([4.7051476178243341, 2.0491810770016325]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([4.2671687268351928, 3.071700801556128]))
      arg1=Data(-4.0639770884,self.functionspace)
      res=arg0/arg1
      ref=Data(numpy.array([-1.1577692283894254, -0.50423046991401921]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-1.0499982244042565, -0.75583615132255189]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank1_constData_rank1(self):
      arg0=Data(numpy.array([-4.5903931628652792, -3.003311261411131]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([1.7691300155565806, -3.2978689534347239]))
      arg1=Data(numpy.array([-0.53634382045320006, -0.61911680385402157]),self.functionspace)
      res=arg0/arg1
      ref=Data(numpy.array([8.5586763337489131, 4.8509606631824944]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-3.2984998579114797, 5.326731455042709]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank1_taggedData_rank0(self):
      arg0=Data(numpy.array([-4.8605831153265076, 4.5841737890307535]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-3.5994750716987776, 4.3425793558512673]))
      arg1=Data(-4.15085940313,self.functionspace)
      arg1.setTaggedValue(1,4.98475451014)
      res=arg0/arg1
      ref=Data(numpy.array([1.1709823540795581, -1.1043914871165508]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-0.72209675810016816, 0.87117216043754642]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank1_taggedData_rank1(self):
      arg0=Data(numpy.array([3.3810872778838696, 1.6475730627265417]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([3.3142778823486516, 0.17151178503778564]))
      arg1=Data(numpy.array([3.7552739180059209, -4.1172718698479516]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([-2.3734150374947682, -3.2018256944650414]))
      res=arg0/arg1
      ref=Data(numpy.array([0.90035703165942493, -0.40016134829284072]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-1.3964173269277844, -0.053566871342895415]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank1_expandedData_rank0(self):
      arg0=Data(numpy.array([-4.2857362454502823, 4.2148426355495729]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([0.023646371870507998, -3.6177048959897773]))
      arg1=Data(0.613760918735,self.functionspace)
      arg1.setTaggedValue(1,3.01035980779)
      arg1.expand()
      res=arg0/arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-6.9827454219169542, 6.8672385401057205])+(1.-msk_ref)*numpy.array([0.007854998531853381, 
-1.2017516599288769])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank1_expandedData_rank1(self):
      arg0=Data(numpy.array([4.2249033586340605, -3.2399083084192846]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([-3.8341853977490823, 0.9059571177822443]))
      arg1=Data(numpy.array([-1.4019643743011292, 0.028380576969282423]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([-1.4351282824614353, -1.8543086352944451]))
      arg1.expand()
      res=arg0/arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([-3.0135597138409094, -114.15935313527922])+(1.-msk_ref)*numpy.array([2.6716673656329495, 
-0.48856867758607381])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank2_float_rank0(self):
      arg0=Data(numpy.array([[-0.96850210242003154, 3.781502646832152, -3.8474647040746679, 3.9024026227889266, 
0.87096348976100124], [4.9644659602751595, -1.0611480121333292, -0.32565561597713177, 1.0911911503774334, -3.9960652574041089], 
[4.9548040887202909, 3.6283218283466638, 0.7082980773072034, -3.6743829629729188, 1.0651486717127661], [2.8225234212805379, 
-2.0578292748745652, -1.4527402651044508, 2.1565364193238858, 3.1134283188501417]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-2.2802095260764488, 2.3138487364639175, 1.2657856865812462, -3.261317945964719, 
-2.7782112252104394], [-1.2678958290996745, -4.6285007637749951, -3.4693072567737659, -4.602246020118419, 0.83422529431232384], 
[-1.951583116012392, 3.4603739741508583, 1.5464922685103275, 0.30933401000278415, 0.054488824811835812], [-0.17346852088860576, 
-4.1460553496565486, -0.30820225234651666, 2.8683805176537858, 1.722354401627193]]))
      arg1=-1.69413983905
      res=arg0/arg1
      ref=Data(numpy.array([[0.5716777801314834, -2.2321077396740416, 2.2710431662085657, -2.3034713739916297, 
-0.51410365879226505], [-2.9303755486093577, 0.62636388547995681, 0.19222475528340885, -0.64409745006041252, 
2.3587576215942723], [-2.9246724352463604, -2.1416896909659457, -0.41808713837026867, 2.1688781990008561, 
-0.62872535499222681], [-1.6660510285056498, 1.2146749798584018, 0.85750906248663394, -1.2729388505107266, 
-1.8377634756510077]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[1.3459393808695204, -1.365795599117918, -0.74715537490195727, 1.9250582925874689, 
1.6398948665119832], [0.74840092882247211, 2.7320653567607964, 2.0478281525570923, 2.7165679680261632, -0.49241820249056262], 
[1.151961054825039, -2.042555103416166, -0.91284806180943223, -0.18259060018113199, -0.03216312110481518], [0.1023932717301233, 
2.4472922801833805, 0.18192255753779119, -1.6931190988716596, -1.0166542111386108]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank2_array_rank0(self):
      arg0=Data(numpy.array([[-0.86877202576759593, 4.6823850407762482, 4.7832512368068549, -1.0771977118132048, 
-1.0808582530891275], [-3.1170942988902772, 0.13425662102394131, -2.8111787049557213, -2.0630331356687726, 
-2.5369244726618678], [-1.9885758414216106, 1.9077986902968433, 2.8433828110992838, 1.2159842141051502, -3.4010419657412969], 
[0.54337993094706682, -0.17058354824602073, 0.80717350447632796, -4.8313886478040446, 0.23232013809738472]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-3.9794749013168076, 4.1645831365517552, 0.53106033956518139, 0.27710892337327664, 
-0.3967233056376287], [4.6133980599895335, -4.0057616541961369, -2.8561369204110654, -3.7411130207334531, -1.8897238945063108], 
[0.65935489144387827, -0.14470695221244423, 2.6240280157987907, 3.2626845236366382, 1.4048525894803641], [-0.74345394006123655, 
3.9363504382427177, 0.26476519664200637, -1.9513354349777678, 4.6815015188103928]]))
      arg1=numpy.array(4.43852348684)
      res=arg0/arg1
      ref=Data(numpy.array([[-0.19573446627974897, 1.0549420442754822, 1.0776672132037468, -0.24269280426385098, 
-0.24351752475632388], [-0.70228180793214201, 0.030248036632424261, -0.63335897923893236, -0.46480167149809437, 
-0.57156946002004372], [-0.4480264320591566, 0.42982732792820189, 0.64061456913025883, 0.27396142381792266, 
-0.76625525939469175], [0.12242357904777047, -0.038432498724323041, 0.18185631029525431, -1.0885125790421541, 
0.052341761575888504]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-0.89657628558504021, 0.93828119844257163, 0.11964797328193404, 0.062432681542549766, 
-0.089381819610397623], [1.0393992672706536, -0.90249869490815027, -0.64348807185015755, -0.84287331853082603, 
-0.42575507375536581], [0.14855275485151681, -0.03260249779940412, 0.59119390120979887, 0.7350833071644628, 
0.31651349680683821], [-0.1675002829803251, 0.88686033765733174, 0.059651638078916672, -0.43963616296308833, 
1.0547429866455127]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank2_array_rank2(self):
      arg0=Data(numpy.array([[-4.680459229495586, 3.5086992616684824, 4.6054145981410599, -4.9227853438784042, 
0.9463344268417595], [-2.7570556308569492, 2.2361380984984596, 1.1723470805649594, 2.7082441248431257, 0.57328838737897403], 
[0.21491402272158044, 0.037011524317512645, -4.5982653755979355, 2.185432758297515, 2.1727815800981967], [4.6367277133885469, 
0.81357627120924736, 2.3393905269164117, -1.9195861881296317, -1.2993918833900828]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[2.2483877032216961, 4.5151550356187045, -4.565516548199553, -4.3254139967345226, 
-1.917195561676456], [-2.9924210601110302, 1.2187078210552027, -3.5971200466067152, -2.2860320264712133, -0.64613124280667833], 
[-2.9714970771789693, -4.3279367179402488, -2.9460945717188904, 0.81628151856682152, -3.0793646816279563], [1.469245350777836, 
1.7181297074566437, 0.11319749001826018, 3.8930383232993826, -0.61431201799334012]]))
      arg1=numpy.array([[-4.6696661363926042, -3.9108922104562382, -0.37285733404263244, -3.0392948051772803, 
-3.2356120160727206], [1.4335647808583669, 4.6112495784872038, 3.7005360034262438, 3.7016208542585183, -3.1963114986615251], 
[-2.0804478907833888, -3.1947497976993553, 0.9816102698815623, -3.3924746575248657, -1.768109850697245], [-2.8522107944728337, 
-4.7808064650252167, -1.4065903050885185, -3.1636750612490494, 3.3926042149914242]])
      res=arg0/arg1
      ref=Data(numpy.array([[1.0023113200789382, -0.89716081979645335, -12.35168032825788, 1.6197130122068764, 
-0.29247462988173378], [-1.923216632879418, 0.48493104969435669, 0.31680466815604802, 0.73163736413669556, 
-0.17935936081919487], [-0.1033018051899656, -0.011585108900911698, -4.6844104189667313, -0.64420017212213965, 
-1.228872504296818], [-1.6256609512781612, -0.17017552941352043, -1.6631641199668237, 0.60675832725114331, 
-0.38300721246771413]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-0.48148789175720674, -1.1545076654239912, 12.244674118915233, 1.4231636856570824, 
0.59252949740354988], [-2.0873985606142447, 0.26429014528747757, -0.97205378984996282, -0.61757595293457856, 
0.20214902179504399], [1.4282968058671528, 1.3547028693943228, -3.0012874377061642, -0.24061536222716454, 1.7416138937372159], 
[-0.51512509300680653, -0.35938072792235093, -0.080476518008658196, -1.230543038690697, -0.18107388279445763]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank2_constData_rank0(self):
      arg0=Data(numpy.array([[4.7381624111313041, 0.13568298849501659, 2.2397249921395712, -1.8792998063470878, 
-0.43823350482581347], [-4.353430451352077, 1.7258530152098341, -2.3554071557072165, -0.5100589575859038, -2.4694484646673809], 
[-2.887004642158717, 4.1989813619698637, -1.8779944209560053, 3.396118464014199, 3.5417248680053888], [-1.7259852752446916, 
3.8767394617580884, 3.3796412275282908, 0.97763229909163663, 0.53392773067385946]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-0.47143531055055288, -0.81936402795983554, 1.3964568028269673, 4.2069824505429114, 
-4.5678782034867087], [3.3208206022065649, 3.6987565284183059, -2.1905297090835063, 4.3442031944294133, -2.3278688764524782], 
[3.1005484659046338, -1.100965344121497, 2.4052976262093644, -3.1804480145014202, -3.4886744535858227], [-1.2459873003814081, 
-3.6650774206041192, 2.9700472066872052, -0.93195629669241331, 4.933632227260194]]))
      arg1=Data(1.48163591676,self.functionspace)
      res=arg0/arg1
      ref=Data(numpy.array([[3.1979262634823797, 0.091576470953512609, 1.5116567888247752, -1.2683951469362491, 
-0.29577678285742587], [-2.9382592593103394, 1.1648293590113572, -1.5897341101551574, -0.34425391002984873, 
-1.6667039700714921], [-1.9485250117778332, 2.8340169905890384, -1.2675141036405821, 2.2921410216867888, 2.39041509991609], 
[-1.164918625229435, 2.6165263799968921, 2.2810200463516876, 0.65983301837628106, 0.36036365252321545]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-0.31818566573420182, -0.55301307068109617, 0.94251009106138439, 2.8394171624413342, 
-3.0829964040491915], [2.2413202627163917, 2.4964004223805456, -1.478453434006282, 2.9320315100918739, -1.5711477091755395], 
[2.0926520684522094, -0.74307414639875313, 1.6234066675882866, -2.1465786422433011, -2.3546098026636373], 
[-0.84095376352957052, -2.4736693941750505, 2.0045729001888968, -0.62900493039428118, 3.3298546366525597]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank2_constData_rank2(self):
      arg0=Data(numpy.array([[4.0196862927330308, 1.4209060338696924, -1.5305585309848913, -1.7585074454525538, 
-3.4282684625181759], [2.7380810498806945, 0.60648868744311102, -0.51957688708537297, -3.4114805210616828, 1.7958523837800398], 
[2.0731973753800057, -1.8654000051692323, -3.3445384034857986, -4.8188145073710009, 2.9328119444793295], [-0.39034114064433112, 
0.78577501092795732, -4.2350204151090765, -0.54792199732024116, 1.0129500725329006]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[1.6013253736167998, 1.8143178441846679, -0.46185749664512699, -0.80220040035261952, 
2.3326568036808712], [0.20813716161286333, -3.4650664162598166, 3.3953284219720832, -4.5848652921452393, -4.9757462977595379], 
[-3.0285603274404718, -0.22786768299635529, -3.1354740154472163, 2.0912987935881961, 2.0598586587375411], [0.42280850685455462, 
1.6609112120697587, 0.81840709417158841, 0.48006393827907345, -1.4103724446340147]]))
      arg1=Data(numpy.array([[3.9613372629979988, -1.0130494995838593, 3.806524444790842, 2.6940884510355287, 
0.11281037621404444], [4.4375555287127124, 0.34424559039139435, -2.4196055837978623, -3.0577975572331226, -2.2880130808743449], 
[2.6485890816482538, -1.5790284323110959, -3.9124982540491526, -4.2849333360619957, -0.63654083845953924], 
[-0.37913667938615614, 0.084526838971296314, 4.7637305208526115, 0.37537921948770858, -1.3508330614532382]]),self.functionspace)
      res=arg0/arg1
      ref=Data(numpy.array([[1.0147296293804766, -1.4026027696113295, -0.40208819178330307, -0.6527281777911319, 
-30.389655433941989], [0.6170246281233539, 1.7617907225871974, 0.21473619112327988, 1.1156659187564377, -0.78489603000598662], 
[0.78275538842357006, 1.1813593517369396, 0.85483447820697256, 1.1245949771997295, -4.6074214995802647], [1.0295525647276218, 
9.2961599001092576, -0.88901343108532793, -1.4596492530087493, -0.74987065495951066]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[0.40423858593774292, -1.7909468835727711, -0.12133312247007119, -0.29776320077548946, 
20.677679500464823], [0.046903562167534545, -10.065681341974971, -1.4032569790332134, 1.4994011887084828, 2.1747018578486879], 
[-1.1434617579695514, 0.14430879035081329, 0.80139946700352582, -0.48805865332555515, -3.236019646001822], 
[-1.1151875559471209, 19.649512891802001, 0.17179962019033562, 1.2788772349578414, 1.0440760482399827]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank2_taggedData_rank0(self):
      arg0=Data(numpy.array([[3.0872704665448207, 0.25094350734692217, 3.2558142937884647, -3.8129216643769972, 
-3.4777575291065412], [-3.2536230990178927, 1.8675633618786271, -3.9047844920612071, -0.068669303729897102, 
0.91167583791798545], [-4.9061726237392564, 3.5832206948059415, 0.42412435403912507, 2.7976596863397782, 1.3060804305081568], 
[4.3484113378533511, -2.7883532167938152, 3.102221189100911, 2.4592776783855177, -2.9337653740576775]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[1.9314475306988435, 4.7205913111124769, -1.4317861015641311, -2.6201872377971966, 
-0.16074478139048143], [3.3667408815099797, -4.2669437203974949, -4.2650160670382711, -2.3113276748995402, 
-1.6056856631732752], [-3.9884394656548383, -2.4020796896935481, 3.6441411399237769, -1.7360849791093069, -1.8301188462570939], 
[-3.6608237610639227, -0.72926946864759934, 2.7947911367053528, 2.7704563369696427, -4.8203658507379714]]))
      arg1=Data(1.7024078282,self.functionspace)
      arg1.setTaggedValue(1,-3.53787262292)
      res=arg0/arg1
      ref=Data(numpy.array([[1.8134729031478061, 0.14740504783302211, 1.9124761058186908, -2.2397228215354783, 
-2.0428462977561472], [-1.9111889907489188, 1.0970129078029522, -2.2936833509471737, -0.040336576578457371, 
0.53552140845280727], [-2.8819020580578441, 2.1047957107889794, 0.24913205109490003, 1.6433545710960216, 0.76719597318240895], 
[2.5542712303283288, -1.6378879200434293, 1.8222550071233916, 1.4445878582383136, -1.7233035031106971]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-0.54593472873593385, -1.3343022245978009, 0.40470255833585622, 0.7406109594841529, 
0.045435434941573177], [-0.951628631198845, 1.2060761296911049, 1.2055312674067102, 0.65331003154901945, 0.45385626739883816], 
[1.1273553038089117, 0.67896160933787075, -1.0300374061830759, 0.49071438238326687, 0.51729359457379587], [1.0347528447865024, 
0.20613220044215833, -0.78996375352674886, -0.7830853827289922, 1.3625040708087039]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank2_taggedData_rank2(self):
      arg0=Data(numpy.array([[2.4064861557228721, -0.40277278166582242, 2.6159521004565232, 2.9471342618430789, 
1.6280431255815575], [2.954704259644295, -2.5362618356540878, 3.5857339613590451, 2.0923414973267498, 3.1885141632534548], 
[1.5356281187811422, -4.1291945486851054, 3.4857098292377913, 1.1164616625203774, 2.5847916522030765], [2.4964947423872141, 
-3.2897710443558359, -3.6539907055062928, 4.1467813982665653, -0.74216384017212622]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-0.72050458576253718, -1.6386842961823911, -4.8461160649959325, -4.7795278727167902, 
-2.7350903135228313], [-1.7436704562597463, 1.9375119504166225, 1.9755999341734167, -2.3059172583383392, 1.6515476291587596], 
[2.7987441852884354, -4.8935794930071284, 2.5505003522648657, -3.7575355131236288, 2.5396394514280471], [-0.12534326160963705, 
-2.0015811379246582, 2.8487301763888917, -4.9334606356505217, 3.3902777014695786]]))
      arg1=Data(numpy.array([[-2.8581403876527647, 4.9856764402670724, -1.0276430219302601, -1.8049385499841994, 
-0.0093728544684665849], [4.1223651673324806, 4.7574151662523185, -4.9530642582338791, -3.1222523011144543, 
-1.422887536110804], [1.1073765696299045, 0.79132294240336432, 4.4758137740169719, 4.7707916064039129, 0.26741900233408522], 
[4.7998393287425909, 2.3539145307646621, 0.89293002812367561, 0.11014489755241286, -4.218320098100623]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[-1.4880398811210824, -2.1364113262306281, 1.8481115944192137, 4.0077079547607521, 
-3.7882186980854868], [-2.7597638561380053, -3.5389979775976519, -3.6269142295296009, 1.8051363025348097, 3.4540213084361451], 
[-4.4206870146155577, 3.0043476844034682, -3.0044629241762042, 3.6226446648629036, 2.8433074935084175], [-2.3457656964366782, 
3.2944611893650499, -1.9975724820718002, -0.26380161861718321, -4.950877410740242]]))
      res=arg0/arg1
      ref=Data(numpy.array([[-0.84197619057445539, -0.080785984909250694, -2.5455844535808581, -1.6328169520612645, 
-173.69768527387669], [0.7167497637178607, -0.53311761681964853, -0.72394254837259375, -0.67013850757029181, 
-2.2408757419919918], [1.3867262148181114, -5.2180902731622227, 0.77878794901455917, 0.23402021187044353, 9.6656992571302371], 
[0.52012048141645162, -1.3975745513951026, -4.0921355430105386, 37.648420311919615, 0.17593824624790785]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[0.48419709370941882, 0.76702659083613811, -2.6221988323810446, -1.1925838725447033, 
0.72199905325030678], [0.63181871607660911, -0.5474747266546468, -0.54470544632362194, -1.2774200236848168, 
0.47815212521271916], [-0.63310163692550547, -1.628832614284714, -0.84890391947978161, -1.0372354621387714, 
0.89319901460757312], [0.053433836891740298, -0.6075594832885034, -1.4260960250284915, 18.701403962231684, 
-0.68478320511730739]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank2_expandedData_rank0(self):
      arg0=Data(numpy.array([[3.8247338339088941, 3.5195866844021655, -2.2356823955320229, 2.5821104539400785, 
-0.2798309883044281], [3.3095359660221462, -3.8503723262915903, 4.9239382170314467, 2.958881891559737, -3.3909813984873169], 
[1.4561827514917089, -0.31884689788780118, -1.7841064652739522, 1.0343446965407024, -2.5682127979261429], [3.7099598055226064, 
-1.3279777306190321, 2.2359625028251937, 1.4235694283169495, -2.5991349801713168]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[1.9976083233190423, 1.77411176859043, -0.66958530962942397, -0.2346316355441207, 
1.1822866847811406], [-1.3145107956408033, -0.17705332759028991, -1.5071254289121807, 3.079250751713996, 2.0687721544582089], 
[-3.9787206963755639, 3.8578058296903084, -2.4099777241875788, -4.1692658188020442, 0.16614901863204068], [1.1585839421606927, 
3.1860861105440446, 3.4471996975659351, -4.1085206500929718, -3.5737448569811416]]))
      arg1=Data(1.34382909793,self.functionspace)
      arg1.setTaggedValue(1,-3.28334285652)
      arg1.expand()
      res=arg0/arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[2.8461460164870056, 2.6190731320130194, -1.6636657138754412, 1.9214574665187185, 
-0.20823405947657933], [2.4627655191597255, -2.865224701732187, 3.6641104323616585, 2.2018290094481072, -2.5233725060085073], 
[1.0836070998434706, -0.2372674459715674, -1.3276289879598262, 0.7696995831799115, -1.9111156335911852], [2.7607378134921459, 
-0.9882043279654904, 1.663874153545041, 1.0593381483636808, 
-1.9341261356653232]])+(1.-msk_ref)*numpy.array([[-0.60840686172970493, -0.5403370424951166, 0.20393402056669696, 
0.071461204570235068, -0.36008627074469185], [0.40035745673948497, 0.053924714940630232, 0.45902164189723793, 
-0.93784014837123619, -0.6300810621555949], [1.211789590743646, -1.1749628346084831, 0.73400123882908141, 1.2698234698580362, 
-0.050603615245973045], [-0.35286718225584679, -0.97037874196277663, -1.0499054921171924, 1.2513224569076484, 
1.0884470532471389]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank2_expandedData_rank2(self):
      arg0=Data(numpy.array([[-0.72379850533849677, 2.1985965363820723, -2.0490539052619896, -1.132863323393356, 
3.4030895915967978], [-1.8352607794497744, 3.339365948647032, -4.9660039617174494, -2.3657772620579696, -3.6840685023954558], 
[-4.7155850171876477, -2.6517791836980309, -2.7733482225934147, 0.052710587056693292, -2.6072597230988315], 
[1.1445838265746762, -0.54682033015869624, -0.77098224078111066, -4.297879142495173, 0.83839611390418334]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[-0.91879631114516513, 1.5547258432163744, 2.0020062919618535, 4.3329468648295322, 
-2.8366746618357599], [-0.075337422541112531, -1.1003772743824292, 1.7461448735470118, 3.5971232193420075, 3.7917368536389962], 
[-3.4286841437609095, 1.2461499012569561, -4.6067893474342583, -3.6168455895106257, -1.4791331362657667], [0.75512843498482063, 
-0.58725328527409104, 1.8301496780830631, 0.23458122719692831, 2.2864940443739501]]))
      arg1=Data(numpy.array([[4.4903474190252659, -3.8252180999631169, -2.570982001117649, -0.91837537411493031, 
-3.8008627922283322], [-4.7566309778707518, 0.93828810241630389, -3.8789305270519603, -0.62436129358632098, 
4.5244112697189216], [-3.6645536114516872, -0.69212607710501928, 2.5804643456851437, 4.573815727030988, 2.119832741116352], 
[-1.0393958361106059, 2.8677653047517371, 1.2242261114471775, -3.9095841196945749, 3.9297385449386049]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[-0.83774252654751447, -0.067136625908340797, 0.7559624238873468, 0.27739693099038565, 
2.6998377184885154], [2.945906977930699, -0.940242499536728, -2.9973034261897427, 3.2604966617886788, 4.7667061792559036], 
[0.4589603467524439, 4.2173064828876967, 4.0376520010217547, 0.37309580567656653, 0.078292229086288856], [1.9828663888477305, 
-2.9050782438248168, 0.3850989042726809, -3.4080442542518643, -1.2926167712217307]]))
      arg1.expand()
      res=arg0/arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[-0.16118986746366587, -0.57476370730423743, 0.79699270721118687, 1.2335515033655329, 
-0.89534660355410201], [0.38583207063737929, 3.5589984995519073, 1.2802508132290988, 3.7891158314266793, -0.8142647258997584], 
[1.2868102140603155, 3.8313528003304302, -1.0747477395805902, 0.011524422976897987, -1.2299365287309363], [-1.1012010889495971, 
-0.19067820133420388, -0.62977111300927902, 1.0993187538399691, 
0.21334653802452441]])+(1.-msk_ref)*numpy.array([[1.0967526203208136, -23.157640441135442, 2.6482881009707326, 
15.620024523557936, -1.0506833956760377], [-0.025573591802288336, 1.1703122066111689, -0.58257194059487027, 1.1032439509901717, 
0.79546267612217225], [-7.470545479630049, 0.29548478544620399, -1.1409575035858661, -9.6941470112532908, -18.892464214239673], 
[0.3808266856667209, 0.20214714922821328, 4.7524146596562904, -0.068831625911038447, -1.7688878059448707]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank3_float_rank0(self):
      arg0=Data(numpy.array([[[2.5532378612591069, -0.30175198476828236], [3.1052177451838183, -3.8159778568198401]], 
[[2.3859544492752427, -0.86551304919249805], [-3.3577660783187504, 0.750826040637806]], [[-0.89021077588322139, 
-1.9297780910610474], [-4.5632905486930007, -0.08424212803408615]], [[-2.124632207704372, -2.3108633048343297], 
[-1.6592361507868736, 3.8069797244456023]], [[-1.0380743531161309, -1.622627866829347], [-4.102445360357061, 
-3.4644096735936225]], [[1.2182277899141223, -0.3686880395016745], [-2.3786114516997325, 
-0.54497661789960539]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-4.311377598697125, 0.39516878910976949], [-2.2842079644753124, 
4.6699639910049076]], [[-4.088649031689938, -1.5639647788399702], [-4.6365648337690359, -4.5493013582657529]], 
[[3.447724442580542, 2.1341662814580689], [1.5351070387608008, -0.042172004862186085]], [[-0.56832205644354161, 
-1.1567919454623468], [4.1377467317326566, 3.6529317186117858]], [[3.404127724063752, -0.54721690399906642], 
[-0.074718820610154779, 3.5198805824026262]], [[-2.2600444887043247, -3.782656619427438], [3.563554564166866, 
-4.0676617506032153]]]))
      arg1=1.84941062748
      res=arg0/arg1
      ref=Data(numpy.array([[[1.3805683947739438, -0.16316116079602616], [1.6790309837321264, -2.0633480743093418]], 
[[1.2901161125721661, -0.46799398485746013], [-1.815587100249602, 0.40598125125977802]], [[-0.48134836182693019, 
-1.0434557163163221], [-2.4674296129188087, -0.045550796984894323]], [[-1.148815831451349, -1.2495133695549503], 
[-0.89717022608817887, 2.0584826689523421]], [[-0.56130009079169774, -0.87737565834126807], [-2.218244720451918, 
-1.8732506573256935]], [[0.65871136015559517, -0.19935434241765893], [-1.2861456597876959, 
-0.29467583337181236]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-2.3312170561979597, 0.21367282270246479], [-1.2351004858162395, 
2.5251093086698875]], [[-2.2107848689391605, -0.84565577573775774], [-2.5070499568203926, -2.4598654785835889]], 
[[1.8642287393345505, 1.1539710271726387], [0.83005202627813801, -0.022802942859493653]], [[-0.30729901083010125, 
-0.62549221263968646], [2.2373326238364037, 1.9751869402781475]], [[1.8406554355647031, -0.29588718474298542], 
[-0.040401422755925266, 1.9032444877842989]], [[-1.2220349851578478, -2.0453308547166382], [1.9268595687810648, 
-2.1994367774040153]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank3_array_rank0(self):
      arg0=Data(numpy.array([[[-3.6536378486115284, 3.3242827856699755], [-3.6856663252397359, 0.31811672647400435]], 
[[-1.7135577199646521, 2.7699818797069931], [0.0034531890434887913, -3.8417893604767004]], [[2.4236958082344087, 
4.7340397156639362], [0.86099161749359432, 1.9072096804891281]], [[-3.5411952799652857, 1.6212989856936648], 
[-4.1086611522453707, 1.7245165367487916]], [[1.7552582940737258, -1.5545033525579943], [-0.84939615557367709, 
1.9686126962740875]], [[-3.3869411086458543, 4.1411434866435837], [-1.0633827781924876, 
4.7828489020138303]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-1.8902282079452917, 4.7680188747156951], [-2.5816121333893491, 
3.3233188050723292]], [[3.2143470992634988, 3.5715412154591295], [-0.26348341062075242, -0.42857596953714072]], 
[[-1.8909276243688558, 0.417283150709018], [-2.7873584879630622, -0.2065878422652192]], [[-2.2209229242376329, 
-0.3244552610034841], [1.9625268342609514, 4.8990543386093073]], [[0.17603649424332168, -4.002103439248053], 
[-4.2192898047752134, -0.16291931448901487]], [[-2.8550343817953836, 1.1162966601597404], [3.5906990394751421, 
-0.14321610771094306]]]))
      arg1=numpy.array(0.168140709001)
      res=arg0/arg1
      ref=Data(numpy.array([[[-21.72964459546521, 19.770838397375059], [-21.920130747323309, 1.8919673193061199]], 
[[-10.19121264654016, 16.474189363016798], [0.020537495434716283, -22.848656838149129]], [[14.414687690096839, 
28.155226320881045], [5.120661275971953, 11.342938255856108]], [[-21.060903697947797, 9.6425130792587783], 
[-24.435850048853354, 10.256389110046706]], [[10.439222627923888, -9.2452527516872376], [-5.0516984293844605, 
11.708126532686544]], [[-20.14349248779925, 24.629035474270506], [-6.3243624016656073, 
28.445514060477375]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-11.24194265137236, 28.35731396077346], [-15.35387919281866, 19.765105219470815]], 
[[19.117006930504559, 21.241383105190838], [-1.5670411537273092, -2.5489125868723099]], [[-11.246102360390609, 
2.4817496797140817], [-16.577534997511609, -1.2286604683256168]], [[-13.208716303381024, -1.9296651175797013], 
[11.671931478857456, 29.136634237656452]], [[1.0469593906776258, -23.802108739977534], [-25.093802862228724, 
-0.96894627991892324]], [[-16.980030587274463, 6.6390624066898463], [21.355322341737946, -0.85176343410371291]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank3_array_rank3(self):
      arg0=Data(numpy.array([[[-2.1441425798937166, 4.0784007312797108], [0.33256583727128941, -1.254823433287835]], 
[[1.2219642026211801, -1.5429443361926687], [-2.8787665435464325, 2.389528765815788]], [[-0.5878305704692135, 
4.2375674369847456], [-0.0036826456830718612, -4.3701543776847984]], [[0.9150478377139688, 3.7038018949999127], 
[-4.4760431758714692, 4.1251973141960132]], [[3.4172067236820425, 3.3502562706843726], [0.55329357864442308, 
4.4935280618624809]], [[-1.9920859306257608, -3.7394130471113662], [2.0901189485555749, 
-0.07336904421024748]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-4.4909616298009123, -3.7595204685788977], [-3.2802855538462361, 
3.4717112214745978]], [[-0.2294650633573454, -3.4333177479852441], [1.1682057930790277, -3.3327131693442613]], 
[[-3.3168686117127311, -4.5755331760127396], [-1.4375744354183362, -4.1932692342653173]], [[3.9056870958317145, 
1.0113330612044731], [3.4345902167882674, 3.1756522449199771]], [[-2.4932068121441153, 3.9139214299710599], 
[0.27264117187332904, -1.5402598751422536]], [[4.1702802298637192, -3.2109505159949228], [-4.4230809873541634, 
-0.6157800144982879]]]))
      arg1=numpy.array([[[-3.3783542916377671, -1.6466380848798066], [0.55261959271472705, 1.0852988729279058]], 
[[2.3627234033823576, -0.77139983056033579], [4.1726031853017691, -2.4664339071671879]], [[3.6424248081846393, 
1.3591855563166169], [-1.3551971848985489, 2.2157114629223624]], [[-4.2807467426620063, 3.8907724093294309], 
[-1.2343405946579109, -0.29843511241130471]], [[-3.7883809083234832, -1.7126967010228187], [0.80402711335573684, 
2.824333012502116]], [[-0.34747741563332735, 2.6895934485282211], [0.016940788367399762, 1.7422335044570065]]])
      res=arg0/arg1
      ref=Data(numpy.array([[[0.63467072864470753, -2.4768045684898672], [0.60179885341663297, -1.1562008075274122]], 
[[0.51718461876319366, 2.0001875487474403], [-0.68992099552793584, -0.96881929772051789]], [[-0.16138440775725565, 
3.1177254770632814], [0.0027174242421021165, -1.972348137749345]], [[-0.2137589286921798, 0.95194514233698335], 
[3.6262626338656343, -13.822761272509537]], [[-0.90202300306552308, -1.9561293419223655], [0.68815288620698756, 
1.5910050415342494]], [[5.7329939760110706, -1.3903265005191099], [123.37790327265547, 
-0.042112061341119743]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[1.3293341201416067, 2.2831492257470272], [-5.9358835573164033, 3.1988526921700915]], 
[[-0.097118885362905624, 4.4507629013754419], [0.27997049831963383, 1.351227437986382]], [[-0.91062102483478213, 
-3.3663786042668096], [1.0607861729922012, -1.8925159274731105]], [[-0.91238452789265945, 0.25993117941811839], 
[-2.7825303904390672, -10.64101411948899]], [[0.65811935823725376, -2.2852390780187029], [0.3390944998551319, 
-0.54535349348826112]], [[-12.001586411775241, -1.1938423324729597], [-261.09062290547115, -0.35344287256730555]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank3_constData_rank0(self):
      arg0=Data(numpy.array([[[2.7656170567218492, -0.58204174852103385], [-3.1102954656909745, -1.5839816458631448]], 
[[1.4684679070607842, 1.9077953082218011], [4.3121062310874851, 0.22354741075810569]], [[-1.8363892420075487, 
4.3765203852071526], [-1.4197616931049151, -3.7492133477886669]], [[0.12473787059878561, 0.46487131968311424], 
[-4.7333063782646043, -4.0576942373423872]], [[2.0864833177022586, 4.924546519610292], [-3.4476573197345708, 
-0.98300564687094472]], [[-2.6480282805230604, -2.487453010423236], [1.3351550194088961, 
4.486143181561447]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[3.4491370804309867, -1.6347938201148815], [-0.37312224570803565, 
3.1427888072688539]], [[-4.3347470638668391, 1.9040863912021084], [-1.0348732571241559, 2.952260668907833]], 
[[1.1491533077467517, 4.3161681090597472], [-4.6297877554297076, -1.7908274163069668]], [[4.0963055739014305, 
2.4819696723352855], [-4.5046774633502338, -3.0319031222275452]], [[1.3008358424120372, -4.3929368763841055], 
[0.46120789878588386, 1.602378727584596]], [[3.2036615578301593, 3.1889393682470697], [-2.2513123711192904, 
2.1332047026027512]]]))
      arg1=Data(-4.22802627658,self.functionspace)
      res=arg0/arg1
      ref=Data(numpy.array([[[-0.65411538997266128, 0.13766275572710163], [0.73563768581980882, 0.37463855289547227]], 
[[-0.34731759241749904, -0.45122598191692664], [-1.0198863367926556, -0.052872758146329149]], [[0.43433723488861853, 
-1.0351213778983424], [0.33579774585797612, 0.88675261280981532]], [[-0.02950262425984531, -0.10994995992758973], 
[1.1195073229511212, 0.95971358073525981]], [[-0.4934887300152811, -1.1647388633521041], [0.81542949220286476, 
0.2324975254565714]], [[0.62630364791938886, 0.58832487021188784], [-0.31578683103357885, 
-1.0610490304679203]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-0.81577948073169948, 0.3866564948210367], [0.088249746169877491, 
-0.74332291279151497]], [[1.0252412781525875, -0.45034876006988317], [0.24476509591621565, -0.69825977318515597]], 
[[-0.2717942681934869, -1.020847039897733], [1.0950234110586543, 0.42356108953849969]], [[-0.96884581739445264, 
-0.58702796765517484], [1.0654327027954644, 0.7170965656054894]], [[-0.30766976298531834, 1.0390041567892578], 
[-0.10908349868596497, -0.3789897750776387]], [[-0.75772035182789188, -0.75423830403064229], [0.5324735997002058, 
-0.50453913080376678]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank3_constData_rank3(self):
      arg0=Data(numpy.array([[[-4.8674334986106382, 2.8887318600312906], [2.0538694057121685, 0.61053129878567791]], 
[[-3.6203383484459648, -0.6071910938051408], [-3.7526332453492497, -3.9582011840371409]], [[-1.3241064668814229, 
2.9777492321256025], [0.38500561436277714, -3.0112735420924741]], [[0.6661399625171498, -4.2807600963611314], 
[2.278916904152358, -4.6575388908559967]], [[-0.021824772114461766, -3.6009820623354614], [-0.6763812621895493, 
-0.893176181106492]], [[-0.40190673597975035, -4.2164577208213441], [2.1280689666689314, 
0.088712446116368859]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-2.5167853671021034, -1.0284204112352411], [0.43150120974364548, 
-4.2603930002781016]], [[-1.7113384479765714, 0.46569309785701929], [1.8237757267904939, 1.8846290833594868]], 
[[0.09726288074230105, 0.78458232469691414], [4.135584347217474, 2.6553708520258805]], [[3.6199013501973294, 
3.318219113973182], [-4.9183716669915185, 1.2748356481278442]], [[-1.3335303831170755, -3.8176652808277822], 
[-0.5120987526311227, 2.940057261448433]], [[3.5090862536180385, 3.6898639610378616], [-4.3319804376002766, 
4.541019818237892]]]))
      arg1=Data(numpy.array([[[3.2963290076967251, 0.85357942680494769], [-4.0802845171646949, 4.9793501152270743]], 
[[0.5509817116483795, 3.3989499804234757], [4.1376229717551265, -2.6054583986891711]], [[3.8513847330702937, 
-4.5928937140620079], [-2.4776867431094174, -3.9668791347407795]], [[-3.6190008061586343, 1.1995958536501234], 
[-1.7327481103364151, -2.5493213908821764]], [[4.3539812929184301, 1.2662753732437961], [-0.86562308420087675, 
-1.1426120549797982]], [[-0.74179292781107975, -4.338340439862348], [3.8865545818726268, 
-3.9345830333203624]]]),self.functionspace)
      res=arg0/arg1
      ref=Data(numpy.array([[[-1.4766224752582284, 3.3842566600324093], [-0.50336426224006547, 0.12261264716426468]], 
[[-6.5707051103655498, -0.17864078533144251], [-0.90695388897588003, 1.5191956954785948]], [[-0.34380010272976691, 
-0.64833837173472209], [-0.15538914087242822, 0.75910393027118273]], [[-0.184067370580174, -3.5685019111525427], 
[-1.3152038028827535, 1.8269720355832755]], [[-0.0050126012598994971, -2.8437590578034277], [0.78138080480370842, 
0.78169679482532994]], [[0.54180448601163822, 0.97190568127823751], [0.54754639921809134, 
-0.022546848132343304]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-0.76351157946478176, -1.2048327067637332], [-0.10575272580341695, 
-0.85561225896721549]], [[-3.1059804922684946, 0.13701087116292265], [0.44077861594452422, -0.72333877382485179]], 
[[0.025254002776493287, -0.17082527346425802], [-1.6691312405487744, -0.669385368656915]], [[-1.0002488377557592, 
2.7661141907722704], [2.8384804679063311, -0.50006862715991074]], [[-0.30627839060448131, -3.0148776178503209], 
[0.59159553618406613, -2.5731019103421016]], [[-4.7305469249657426, -0.85052429890793402], [-1.1146068700038774, 
-1.1541298734279761]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank3_taggedData_rank0(self):
      arg0=Data(numpy.array([[[4.0117227786695846, -0.53492418922952112], [-1.4882942167138591, 1.900837298708562]], 
[[0.3979828547855826, -2.0806414273277065], [-3.1038194294358092, 1.3619630468314083]], [[-1.8360143953269672, 
-0.54583843212253136], [-2.8745251386926807, 2.8454895264534175]], [[-4.0367023374846722, -4.8815643727381284], 
[-2.4178783308021412, -0.18865332193405226]], [[4.4239527120031354, -0.23469975720542635], [-2.6557303119811104, 
-4.228655562140105]], [[1.0241549991061296, 1.6012695623869719], [4.294822539139151, 
-0.66009157022351594]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-3.7467677360500771, -3.1566842580210439], [3.5515499219663269, 
1.5656649082458323]], [[-1.0059725635217331, 4.0121910445334912], [-1.9861236068404295, 1.1688601739729174]], 
[[-4.7791339554087582, -1.2361230737018425], [-0.094248485141122273, -3.1051132394500334]], [[4.7778069411338233, 
1.0007220688184661], [2.106976210113233, -0.61430719630395725]], [[1.5404800798012701, 0.79080850633239574], 
[-3.4835194084275747, -0.74931004023844316]], [[-2.445319759379637, -1.8443175619123844], [4.6036602132061084, 
-1.3015696598232296]]]))
      arg1=Data(3.76509523495,self.functionspace)
      arg1.setTaggedValue(1,-3.1292964952)
      res=arg0/arg1
      ref=Data(numpy.array([[[1.0655036667958775, -0.14207454416151977], [-0.39528727000064834, 0.50485769418693838]], 
[[0.10570326378248868, -0.55261322688909353], [-0.82436677846241746, 0.36173402313721381]], [[-0.48764089106866565, 
-0.14497334013132998], [-0.76346678087006492, 0.75575499393575984]], [[-1.0721381759533737, -1.2965314469155615], 
[-0.64218251595897835, -0.050105856601740925]], [[1.174990919470795, -0.062335676140966127], [-0.70535541500583165, 
-1.1231204785718722]], [[0.27201303956421441, 0.42529324292387061], [1.140694264325, 
-0.17531869156907484]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[1.197319506732037, 1.0087520510964567], [-1.1349355765473297, -0.50032488472979231]], 
[[0.32146923919324205, -1.2821383498460153], [0.63468693678834809, -0.37352170871828805]], [[1.5272231195544448, 
0.39501628420262402], [0.030118106509151924, 0.99227198324410393]], [[-1.5267990580195372, -0.31979138773003868], 
[-0.67330667239288822, 0.19630840262225535]], [[-0.49227680475935803, -0.25271127473719335], [1.1131957019003849, 
0.23944999823059879]], [[0.78142795453585034, 0.58937130589635656], [-1.4711486176745949, 0.41593043734272883]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank3_taggedData_rank3(self):
      arg0=Data(numpy.array([[[1.5937778250119417, 1.1222313900225354], [0.77948460194958891, -2.5380780385458204]], 
[[-3.138691428415501, 0.3279494678157846], [-4.5778698242660028, 1.384000964765443]], [[-1.1160444348521437, 
-0.54829334971058863], [1.8664472023968779, -4.4659166827566636]], [[-1.8710693431629744, -0.66054166701996841], 
[0.71327913550891964, 3.1722427340027295]], [[1.2498289090681949, 4.1746474144082182], [-3.9323326976200446, 
0.65790680147240543]], [[-3.5388360463036372, -0.50190928882352814], [-2.1998792527280617, 
3.3685005402883981]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[3.5751931384164575, -0.15270724878766995], [-1.2964474481215293, 
2.9411685095922246]], [[3.9827285699197095, -0.36835243661909978], [4.3222517341685638, -3.0461074462971762]], 
[[3.2875535691212505, -4.1602493486471221], [1.2903858495079987, 3.4347804637468968]], [[0.7343249455630918, 
-4.3980873412001174], [-0.23010238111155878, -3.0859699278609929]], [[-2.5545618965079155, -1.2222884334765927], 
[-0.025342010922082991, 3.2000852974204719]], [[2.9496213267253761, 3.1998425197446405], [1.7305719630653886, 
4.0924554658293069]]]))
      arg1=Data(numpy.array([[[2.3019482566686067, 2.4151921713670834], [4.9863199346297211, 2.7496577250514012]], 
[[-2.8187488643605296, 3.9429412106483461], [0.70822665206212054, -1.0585529095703681]], [[-4.7684941529121039, 
-0.75282231717744175], [-2.9978257342497985, 3.059495541521267]], [[-2.5232680258562654, 0.62187038751541657], 
[-2.098159851848024, 4.7599109785216616]], [[-3.7209922362758316, 4.802534289533714], [-3.1955257408812923, 
-4.1253666216266218]], [[-1.874515928762893, 3.2816047369005155], [3.9607499751068662, 
-2.3419882732384103]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[-4.8414333724499148, -1.7201838311026485], [3.5809677743076236, 
-0.48054219312836821]], [[4.6515895936151708, 0.88541446835050497], [-0.24399267212025499, 4.2071608935220546]], 
[[-3.6504739740524594, -3.9583906331081966], [4.8778971249238907, -2.5776368469216324]], [[-0.24137564699645253, 
3.957479943815537], [-2.553837484212643, -0.41418964057339736]], [[-1.994511551383118, -1.3061462907505286], 
[3.3493000239108213, 2.1591392153846112]], [[-0.12730059409353345, 1.865300910946428], [-1.9370843676228167, 
3.8186125759004366]]]))
      res=arg0/arg1
      ref=Data(numpy.array([[[0.69236040401640764, 0.46465511246971003], [0.15632462661212546, -0.92305235499752047]], 
[[1.1135051682326991, 0.083173816269469347], [-6.4638485588430878, -1.3074461864425497]], [[0.23404546573063931, 
0.72831707721724559], [-0.62260030030196323, -1.4596905346481024]], [[0.74152619697546052, -1.0621854333007505], 
[-0.33995462017856998, 0.66645001310254925]], [[-0.33588592227730379, 0.8692592624494393], [1.2305745647148343, 
-0.15947838381767737]], [[1.887866617724145, -0.15294629581062308], [-0.55541987415368377, 
-1.4383080303090359]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-0.7384575730735089, 0.088773796164438812], [-0.36203828959957512, 
-6.1205208442675589]], [[0.85620807463032678, -0.41602260837834171], [-17.714678463942906, -0.72402922621461852]], 
[[-0.90058266200201831, 1.0509951478387627], [0.26453732345331749, -1.3325307899167085]], [[-3.0422495173006583, 
-1.1113353456340644], [0.090100635821194458, 7.4506207436497602]], [[1.2807957390552207, 0.93579749996782513], 
[-0.0075663603562431255, 1.4821116093945037]], [[-23.170522869344641, 1.7154564719110572], [-0.89339008253375185, 
1.0717126664425489]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank3_expandedData_rank0(self):
      arg0=Data(numpy.array([[[-2.9234329263958045, -4.6133510296387232], [0.36977338192269471, -1.4132543604160377]], 
[[-0.095529011036092015, 0.28743106785685058], [-0.13391103476522392, 1.4970278654800335]], [[-0.19839489809219035, 
3.5234266890100017], [-0.76688567031431809, -3.0817924695570098]], [[-4.0464820015838852, 2.344248494534618], 
[-2.1923214832479223, 2.9269692343885261]], [[-3.3030189300411275, -3.6495395496230554], [0.18122263589447485, 
3.8123939654433006]], [[-0.27049898348041168, -0.12490504905707223], [4.5882713231869623, 
-0.44323594640142439]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-4.2731527360257902, 2.6207669149340695], [-1.4607543320385377, 
0.34556696867206771]], [[1.3183700646854533, 0.16651816063926628], [0.12571553103927879, 2.6041271722556427]], 
[[-4.6460883139768274, 0.82703695488618401], [-0.29685825079511918, -2.7314911113193761]], [[3.2141601516351734, 
4.2938631512172911], [-3.4196645360181845, 3.3405093976069828]], [[-0.74495637357537703, 3.7512125741603857], 
[3.9467791556907699, 2.0230395050836645]], [[-1.284872990686996, -0.61787673514865826], [-3.9235720833257046, 
-0.11825446977713661]]]))
      arg1=Data(-0.380983118767,self.functionspace)
      arg1.setTaggedValue(1,4.80801095448)
      arg1.expand()
      res=arg0/arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[7.6733922906004084, 12.109069411182521], [-0.9705768148452083, 3.7094933890765112]], 
[[0.25074342229454127, -0.75444567934417084], [0.35148810582106443, -3.9293810978419583]], [[0.52074459029642672, 
-9.2482488473842182], [2.0129124691828468, 8.0890525531172965]], [[10.621158267273067, -6.1531558199252849], 
[5.754379591260939, -7.6826743501419603]], [[8.6697251592948916, 9.5792683975973407], [-0.47567103886640549, 
-10.006726748894609]], [[0.71000254382878092, 0.32784930067584511], [-12.043240493268975, 
1.1634004882837481]]])+(1.-msk_ref)*numpy.array([[[-0.88875686359261863, 0.54508339097899472], [-0.30381676453468709, 
0.071873165835826092]], [[0.2742027996953792, 0.034633481956604921], [0.026147097464918601, 0.54162255388108638]], 
[[-0.96632232288161335, 0.17201228589443024], [-0.061742423968125806, -0.56811249749175208]], [[0.66850100427451975, 
0.8930643444589399], [-0.71124308334390562, 0.694779905709631]], [[-0.15494065646432989, 0.78020050488077297], 
[0.82087565794963469, 0.42076432941508357]], [[-0.26723587006157284, -0.12850984346707292], [-0.81604890680768405, 
-0.024595299573280157]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank3_expandedData_rank3(self):
      arg0=Data(numpy.array([[[1.3030807390070231, 0.82127637791553276], [-2.9606834680969496, -1.118500727450924]], 
[[-0.10527441065803256, -1.7036285349095071], [2.0749292280559715, 0.18766364610176289]], [[0.17322444543358095, 
1.8375346797078631], [3.3181757408573951, 1.5715641685845041]], [[-1.8544947705522832, -4.8166379022667529], 
[4.8520794350991032, 2.6712900737127176]], [[-3.1314844443990397, 1.3948832470485897], [4.0479224098608295, 
3.3473999426191678]], [[-0.56471985665859403, 2.7421007640238759], [0.4901941429997887, 
4.167578888219337]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[-3.303869536271332, 1.11279445169325], [4.8332355282011328, -3.9306895647498044]], 
[[4.3973887894618553, -3.634065929413195], [-3.189822296333904, -2.7055559770184923]], [[-0.86544452397463001, 
-1.1173825047968986], [1.4607489243185938, 0.70581535455476274]], [[-0.11179792520149778, 2.0989695219655893], 
[1.511321381783846, -0.88964822861353632]], [[0.84022664796619928, -2.3804943246397805], [0.48611183702885974, 
0.44058210065668568]], [[4.4082571824426182, 1.1114191929844477], [0.65626061651835599, 0.19178014938961141]]]))
      arg1=Data(numpy.array([[[1.4677610289674732, -3.7236404556747491], [3.7207377949461975, 3.5930209564696032]], 
[[-3.8006610018199396, -0.39710647500866525], [-3.8904627344396681, 4.8903230445371815]], [[-2.9314504272302, 
2.3587324666543701], [4.665664136916531, 4.9945594696438782]], [[1.9628235610719553, -4.8889899786606064], [1.8838860934203812, 
-1.029348815023484]], [[3.3814184641408254, 0.71686668985086133], [-0.65039794223511294, -4.9535588999565654]], 
[[-0.84501415113220713, 1.9805961596815989], [2.5931526352221104, 1.1220257622302112]]]),self.functionspace)
      arg1.setTaggedValue(1,numpy.array([[[-1.6872082410458713, 4.0157845925193829], [0.78345958243454916, 
-0.96540699024498888]], [[-3.9886327567173763, -0.37651403960664798], [0.015760472815211202, 0.31573495968308496]], 
[[-2.4577065831388856, -1.8460551455583296], [1.91188909328483, -4.6208887383513675]], [[-2.6671460557039541, 
1.4465886022360586], [3.9230452652233119, -1.3572843287538863]], [[-0.0041169436943278015, -0.57878923774283564], 
[-0.29559919131281198, 2.0240994978893267]], [[-4.6636866277286479, -2.7711289542982307], [-3.5219939460384952, 
0.9525977694068386]]]))
      arg1.expand()
      res=arg0/arg1
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[0.88780170156425409, -0.22055737864377453], [-0.79572483503631608, -0.31129813630420067]], 
[[0.027698974101510791, 4.2901051534662891], [-0.53333738675556741, 0.038374488636572945]], [[-0.059091719179182302, 
0.77903480182058338], [0.7111904422358033, 0.31465521196338059]], [[-0.94480971562186133, 0.98520101765197832], 
[2.575569431742911, -2.5951261950515518]], [[-0.92608604276806339, 1.945805638338119], [-6.2237626336116891, 
-0.67575656416410412]], [[0.66829633077972028, 1.3844825208914353], [0.18903404926559683, 
3.7143344016768265]]])+(1.-msk_ref)*numpy.array([[[1.9581871732817759, 0.277105115091623], [6.1690936412854525, 
4.0715362582493038]], [[-1.1024802376343323, 9.6518736278991852], [-202.3938198894167, -8.5690731863654257]], 
[[0.35213500664075142, 0.60528121680728675], [0.76403434145276228, -0.15274450317247462]], [[0.041916686550557261, 
1.4509788883453911], [0.38524189235879663, 0.65546194689385118]], [[-204.08990512156817, 4.1128862967860993], 
[-1.6444965051154066, 0.21766820312742141]], [[-0.94523014394506366, -0.40107090334448436], [-0.18633212508968439, 
0.20132332401851899]]])
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank4_float_rank0(self):
      arg0=Data(numpy.array([[[[3.6203898043611602, -4.8522252206209142, 3.1930866223489787, -4.7335254845755834], 
[-4.9589079272086423, -3.3771502779694762, -4.3302456038164392, 3.2988256323598524], [1.5372701442055314, 3.3506351444045244, 
0.37323338247660054, 0.66273168450391751]], [[-0.37569636227086889, 3.5117066629685514, -0.68247207856867576, 
-3.5518497694242668], [0.52969358964135704, 3.2380028341101603, -2.8115421943851162, -1.2112866867917305], [1.312586199221939, 
2.2049983340740873, -0.063973208576920904, -1.3744609948537612]]], [[[-2.6119033395905733, 1.6478643456924482, 
-1.8326459567700928, -2.0904354431940151], [3.0025998076579015, -3.216243008732762, 4.8184792438440169, 1.6769454462177773], 
[-3.6266313077416945, 0.58490737983812835, -0.24713838094624929, 0.67551945767703536]], [[0.39214409502181269, 
4.4550016931441547, -0.92391535607890773, 4.8711114102911335], [0.06138164770969734, -3.7850186033068711, -0.44883011158736608, 
-1.1388227684437768], [3.9946701951683821, -1.5235711003213859, -4.909818628684647, 3.1171649422216579]]], 
[[[-0.42423119998224035, -2.5228654622761071, -0.2122461957948385, -2.900151833219641], [2.5687623559133783, 
1.1172843662843448, -3.2010427689428225, -2.2640960195326909], [-4.8469757068278572, -0.78288514960780198, -3.8480800644004587, 
-0.61918384740730747]], [[2.4123778086960312, 0.16077761049424133, -1.2547160847252501, 1.9801405242982115], 
[-0.54998003204373092, -2.8676285276543778, 2.3933635846937227, -3.3144110754777891], [-1.2675207995210314, 
0.61155064775410306, -3.8693222930075066, 3.6992300759582619]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[-3.634851405743913, 0.27020005877386755, 4.6453187805316745, -0.52328532154797802], 
[-0.82978855445949051, -4.746822215577704, -4.332549741487421, -1.6242034193431243], [-4.9322371420319167, 0.22972216757547237, 
3.6264993122046523, -2.4148707558881455]], [[-0.53059750609464462, 1.5789454802460314, -2.204494424669281, 
-4.8604313537221477], [0.42659220872660875, -4.0354210574814431, -4.6115751168595267, 3.2002303390390416], 
[0.64763447796177509, -2.1720613963955469, 0.8863986077623478, 3.5941628697016341]]], [[[-3.4699331906186428, 
-0.88802807462416666, 1.082548213294996, -3.0845995178982943], [0.33065149231971525, -4.6219993942457975, 0.13862939178681533, 
-4.6872263486545931], [3.3681435450104207, -0.98115160228651987, 2.6737643765785233, -3.3741281655630795]], 
[[0.39786453691122148, 2.6812507071066625, 1.7081409703380608, 1.6248594881653684], [-0.78496210682853729, 2.7617802436342682, 
3.1095291962382685, 3.2655545837171935], [-0.16081689153361367, 4.130199757349116, -0.32388642843524451, 
0.84634232389791197]]], [[[3.0873340023218176, -0.41109976788443348, -3.1184580296746156, -0.5696825246610695], 
[2.4620105272124873, 0.43074446661690491, -0.799082081550468, 0.73248964174856379], [-4.0633985174048748, -2.4843305264582325, 
1.3472174598355791, 4.4028741514964072]], [[2.4236778091329283, -1.8484683056142193, -3.7205804053990388, 
-0.28143868847938069], [-2.842491844767181, 2.2381877451472612, 0.67607094394759848, 0.23955332426623244], 
[-3.6987505214923488, 3.1925484048981083, -4.8258105785692997, -3.2680928819884336]]]]))
      arg1=0.413558452763
      res=arg0/arg1
      ref=Data(numpy.array([[[[8.754239649003555, -11.732864334411099, 7.7210043731748819, -11.445843877563455], 
[-11.990827158952337, -8.1660772628489333, -10.470697853913085, 7.9766853036560441], [3.717177424216108, 8.1019626657761776, 
0.90249245295974789, 1.6025103103942857]], [[-0.90844803137390251, 8.4914396973488131, -1.6502433308001243, 
-8.5885072489548495], [1.2808191589412636, 7.82961347416426, -6.7984154974924706, -2.9289370793854173], [3.1738831365953373, 
5.331769473796844, -0.15468964096723203, -3.3234987355956416]]], [[[-6.315681186391835, 3.9845983915496226, -4.431407324707612, 
-5.054752065218719], [7.260400041626867, -7.7769973923697675, 11.65126528462403, 4.0549175939042481], [-8.7693318405397935, 
1.4143281945512094, -0.59758996411491794, 1.6334316301924243]], [[0.94821927203176692, 10.772362802348114, -2.2340623191364943, 
11.778531856242719], [0.14842314864938125, -9.1523183192512434, -1.085288206753785, -2.7537165806535824], [9.6592638077563429, 
-3.6840526173294119, -11.872127376138105, 7.537422875517108]]], [[[-1.0258071069461017, -6.1003842272327775, 
-0.51321933907202899, -7.0126769597898884], [6.2113646541363927, 2.7016359085853008, -7.7402426369334449, -5.4746699152307574], 
[-11.720170811263451, -1.8930459391573868, -9.3048033202764291, -1.4972099911633951]], [[5.8332208967729109, 
0.38876635072976545, -3.033951008234733, 4.7880547745241735], [-1.3298725449059901, -6.9340343752943978, 5.7872437830777148, 
-8.0143714953268894], [-3.0649132935180412, 1.4787526253371113, -9.356167833479125, 8.944878411360623]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-8.7892083487994928, 0.65335397443443821, 11.232556726848653, -1.265323724014084], 
[-2.0064601482934585, -11.477995876666061, -10.476269346057874, -3.9273853756114248], [-11.926336190387875, 
0.55547690064249866, 8.7690126703326321, -5.8392489374899048]], [[-1.2830048631561037, 3.8179499649827977, -5.3305510017732667, 
-11.752707075011374], [1.0315161155000139, -9.7578009360408018, -11.150963270236463, 7.7382781506598546], [1.5660046932529459, 
-5.2521267111874419, 2.1433454009695927, 8.6908219277980461]]], [[[-8.3904298592696094, -2.1472855135484341, 
2.6176425752191252, -7.4586784462695181], [0.79952783000896122, -11.176169567717794, 0.3352111191550361, -11.333890813585125], 
[8.1442986414741938, -2.3724617299698876, 6.465263516470225, -8.1587696806046246]], [[0.9620515171501679, 6.4833657471902519, 
4.1303495525834659, 3.9289717748685562], [-1.8980681003702879, 6.6780892161207595, 7.5189593525680092, 7.8962346480828147], 
[-0.3888613337705179, 9.9869794215351284, -0.78316964934727251, 2.0464877896771916]]], [[[7.4652905331589334, 
-0.99405480685390113, -7.5405496099468303, -1.377513918176662], [5.9532346897079131, 1.0415564323223436, -1.9322107339631549, 
1.7711876927051486], [-9.8254514936258115, -6.0072052931295277, 3.2576228362248361, 10.646316432604149]], [[5.8605447257537788, 
-4.4696663633958664, -8.9965043164729916, -0.68052940666274586], [-6.8732529241615801, 5.4120227266354917, 1.6347651448791107, 
0.57924900982094796], [-8.9437188305015969, 7.7197029429966948, -11.668992729623149, -7.9023723494265541]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_quotient_overloaded_taggedData_rank4_array_rank0(self):
      arg0=Data(numpy.array([[[[3.4291166724435556, -3.5926339750524203, -1.5475843284301338, -3.4566378870411008], 
[-3.672887604919862, -4.5295982023752899, -1.4658640846319413, -0.014575827085298698], [-1.253532674795943, 
-4.6553481394901208, 4.862329645566291, -1.51717090636871]], [[1.8161815466297355, 3.7585630608880471, -2.6866097249378864, 
-2.7480595936533616], [1.1878511834883465, 0.3647196286663732, -1.5374358841644673, 0.58709308345952582], [3.5533218142514649, 
-0.37232562804411451, -1.2137088225392301, 3.9446296095433855]]], [[[0.25170530254330536, 1.0783691566479501, 
1.4521010658044844, -2.3963713247532512], [-4.3383471977641888, 2.1563624449196128, 3.8141212549286365, 4.0912931529208052], 
[-2.4807386402123233, 2.0367813392198011, -0.29099812506794187, -3.3842548469707578]], [[-0.82534111740968719, 
-3.2362584223700241, -0.81520740895996369, 0.24629244526181981], [-2.3470833053686824, 2.2250912336018969, 1.2535083827066824, 
1.4506279015892778], [-4.4413536877400723, 0.22597360655997178, -4.2731012937159853, 0.88576214135889764]]], 
[[[-2.7775903348569733, -0.32907536494470868, 4.8380401319641546, 1.2853515653123964], [1.3956938433885995, 1.7898635170409953, 
2.8197354403935302, -1.9117009156228026], [-1.8413635689185437, 1.8044097183152994, 0.33537690066736126, -3.6486560523145926]], 
[[2.0535577780102106, 1.5376737584515601, -0.25710013106498586, -1.1731957173889573], [2.4279006360588786, -1.3926894400285725, 
3.7160645033901378, -0.59603409648490135], [2.1961906463550989, -4.8502792078765768, -2.6741887490519489, 
4.6451433282020052]]]]),self.functionspace)
      arg0.setTaggedValue(1,numpy.array([[[[-1.9771675854126611, 4.9618182253042313, 1.712135945833321, -0.67123899563295009], 
[3.941760104308786, -1.5661992738598962, 0.30424350159760216, 2.8287611250635925], [2.7512229432822313, -3.5283965645877879, 
-4.7500059147253513, -3.9493198458266487]], [[-1.0742850319177935, -0.76421683993359135, -1.5611177509428842, 
-3.5448170561914849], [-1.6657876306848518, 1.9787072708209852, -1.4607491047318213, -4.4590699358789525], 
[-0.49773075429816771, 1.7665162863795993, 3.8854046738265371, 4.2832536612472634]]], [[[3.9890217647607162, 
-2.3994769041291053, -2.1163364325133003, -1.307887439158101], [3.9605554981132371, 0.48753951223392278, 3.7033077812374344, 
-0.66348907194746687], [-4.666759865063308, 2.3997229252818952, 0.31299119875697468, 3.5203143497411702]], 
[[-2.6814907550189151, 0.77666800881142528, -1.9893706891053728, -0.42858869738287453], [4.99