<!--
  You are amazing! Thanks for contributing to our project!
  Please fill the template to help maintainers processing your PR.

  Don't forget to create the PR against the correct branch:
  - new product id -> new_product_ids
  - anything else -> dev
-->
## Context
<!--
  Summarize the motivation and context of the change.
  Which issue are you dealing with?
-->


## Proposed change
<!--
  Describe the change. How are you fixing the issue?
-->


## Type of change
<!--
  What type of change does your PR introduce?
  Please, check only 1 box!
-->

- [ ] Dependency upgrade
- [ ] Bugfix (non-breaking change which fixes an issue)
- [ ] New device
- [ ] New product id (the device is already supported with a different id)
- [ ] New feature (which adds functionality to an existing device)
- [ ] Breaking change (fix/feature causing existing functionality to break)
- [ ] Code quality improvements to existing code or addition of tests
- [ ] Documentation

## Additional information
<!--
  Link docs and related issues, when applicable.
-->

- This PR fixes issue: fixes #
- This PR is related to: 
- Link to documentation pull request: 

## Checklist
<!--
  Please do your best to check these boxes.
-->

- [ ] The code change is tested and works locally.
- [ ] The code has been formatted using Black.
- [ ] The code follows the [Zen of Python](https://www.python.org/dev/peps/pep-0020/).
- [ ] I am creating the Pull Request against the correct branch.
- [ ] Documentation added/updated.
