# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, AsyncIterable, AsyncIterator, Callable, Dict, IO, Optional, Type, TypeVar, Union, cast, overload

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ...operations._long_term_retention_backups_operations import (
    build_change_access_tier_by_resource_group_request,
    build_change_access_tier_request,
    build_copy_by_resource_group_request,
    build_copy_request,
    build_delete_by_resource_group_request,
    build_delete_request,
    build_get_by_resource_group_request,
    build_get_request,
    build_list_by_database_request,
    build_list_by_location_request,
    build_list_by_resource_group_database_request,
    build_list_by_resource_group_location_request,
    build_list_by_resource_group_server_request,
    build_list_by_server_request,
    build_update_by_resource_group_request,
    build_update_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class LongTermRetentionBackupsOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.sql.aio.SqlManagementClient`'s
        :attr:`long_term_retention_backups` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_by_location(
        self,
        location_name: str,
        only_latest_per_database: Optional[bool] = None,
        database_state: Optional[Union[str, _models.DatabaseState]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.LongTermRetentionBackup"]:
        """Lists the long term retention backups for a given location.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param only_latest_per_database: Whether or not to only get the latest backup for each
         database. Default value is None.
        :type only_latest_per_database: bool
        :param database_state: Whether to query against just live databases, just deleted databases, or
         all databases. Known values are: "All", "Live", and "Deleted". Default value is None.
        :type database_state: str or ~azure.mgmt.sql.models.DatabaseState
        :return: An iterator like instance of either LongTermRetentionBackup or the result of
         cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.sql.models.LongTermRetentionBackup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        cls: ClsType[_models.LongTermRetentionBackupListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_by_location_request(
                    location_name=location_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_by_server(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        only_latest_per_database: Optional[bool] = None,
        database_state: Optional[Union[str, _models.DatabaseState]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.LongTermRetentionBackup"]:
        """Lists the long term retention backups for a given server.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param only_latest_per_database: Whether or not to only get the latest backup for each
         database. Default value is None.
        :type only_latest_per_database: bool
        :param database_state: Whether to query against just live databases, just deleted databases, or
         all databases. Known values are: "All", "Live", and "Deleted". Default value is None.
        :type database_state: str or ~azure.mgmt.sql.models.DatabaseState
        :return: An iterator like instance of either LongTermRetentionBackup or the result of
         cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.sql.models.LongTermRetentionBackup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        cls: ClsType[_models.LongTermRetentionBackupListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_by_server_request(
                    location_name=location_name,
                    long_term_retention_server_name=long_term_retention_server_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_by_database(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        only_latest_per_database: Optional[bool] = None,
        database_state: Optional[Union[str, _models.DatabaseState]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.LongTermRetentionBackup"]:
        """Lists all long term retention backups for a database.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param only_latest_per_database: Whether or not to only get the latest backup for each
         database. Default value is None.
        :type only_latest_per_database: bool
        :param database_state: Whether to query against just live databases, just deleted databases, or
         all databases. Known values are: "All", "Live", and "Deleted". Default value is None.
        :type database_state: str or ~azure.mgmt.sql.models.DatabaseState
        :return: An iterator like instance of either LongTermRetentionBackup or the result of
         cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.sql.models.LongTermRetentionBackup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        cls: ClsType[_models.LongTermRetentionBackupListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_by_database_request(
                    location_name=location_name,
                    long_term_retention_server_name=long_term_retention_server_name,
                    long_term_retention_database_name=long_term_retention_database_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        **kwargs: Any
    ) -> _models.LongTermRetentionBackup:
        """Gets a long term retention backup.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :return: LongTermRetentionBackup or the result of cls(response)
        :rtype: ~azure.mgmt.sql.models.LongTermRetentionBackup
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        cls: ClsType[_models.LongTermRetentionBackup] = kwargs.pop("cls", None)

        _request = build_get_request(
            location_name=location_name,
            long_term_retention_server_name=long_term_retention_server_name,
            long_term_retention_database_name=long_term_retention_database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("LongTermRetentionBackup", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _delete_initial(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_delete_request(
            location_name=location_name,
            long_term_retention_server_name=long_term_retention_server_name,
            long_term_retention_database_name=long_term_retention_database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a long term retention backup.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(
                location_name=location_name,
                long_term_retention_server_name=long_term_retention_server_name,
                long_term_retention_database_name=long_term_retention_database_name,
                backup_name=backup_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _change_access_tier_initial(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: Union[_models.ChangeLongTermRetentionBackupAccessTierParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ChangeLongTermRetentionBackupAccessTierParameters")

        _request = build_change_access_tier_request(
            location_name=location_name,
            long_term_retention_server_name=long_term_retention_server_name,
            long_term_retention_database_name=long_term_retention_database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_change_access_tier(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: _models.ChangeLongTermRetentionBackupAccessTierParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LongTermRetentionBackup]:
        """Change a long term retention backup access tier.

        :param location_name: Required.
        :type location_name: str
        :param long_term_retention_server_name: Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: Required.
        :type long_term_retention_database_name: str
        :param backup_name: Required.
        :type backup_name: str
        :param parameters: Required.
        :type parameters: ~azure.mgmt.sql.models.ChangeLongTermRetentionBackupAccessTierParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either LongTermRetentionBackup or the
         result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.sql.models.LongTermRetentionBackup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_change_access_tier(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LongTermRetentionBackup]:
        """Change a long term retention backup access tier.

        :param location_name: Required.
        :type location_name: str
        :param long_term_retention_server_name: Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: Required.
        :type long_term_retention_database_name: str
        :param backup_name: Required.
        :type backup_name: str
        :param parameters: Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either LongTermRetentionBackup or the
         result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.sql.models.LongTermRetentionBackup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_change_access_tier(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: Union[_models.ChangeLongTermRetentionBackupAccessTierParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LongTermRetentionBackup]:
        """Change a long term retention backup access tier.

        :param location_name: Required.
        :type location_name: str
        :param long_term_retention_server_name: Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: Required.
        :type long_term_retention_database_name: str
        :param backup_name: Required.
        :type backup_name: str
        :param parameters: Is either a ChangeLongTermRetentionBackupAccessTierParameters type or a
         IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.sql.models.ChangeLongTermRetentionBackupAccessTierParameters or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either LongTermRetentionBackup or the
         result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.sql.models.LongTermRetentionBackup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LongTermRetentionBackup] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._change_access_tier_initial(
                location_name=location_name,
                long_term_retention_server_name=long_term_retention_server_name,
                long_term_retention_database_name=long_term_retention_database_name,
                backup_name=backup_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackup", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.LongTermRetentionBackup].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.LongTermRetentionBackup](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _copy_initial(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: Union[_models.CopyLongTermRetentionBackupParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "CopyLongTermRetentionBackupParameters")

        _request = build_copy_request(
            location_name=location_name,
            long_term_retention_server_name=long_term_retention_server_name,
            long_term_retention_database_name=long_term_retention_database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_copy(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: _models.CopyLongTermRetentionBackupParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Copy an existing long term retention backup.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The parameters needed for long term retention copy request. Required.
        :type parameters: ~azure.mgmt.sql.models.CopyLongTermRetentionBackupParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either
         LongTermRetentionBackupOperationResult or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_copy(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Copy an existing long term retention backup.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The parameters needed for long term retention copy request. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either
         LongTermRetentionBackupOperationResult or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_copy(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: Union[_models.CopyLongTermRetentionBackupParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Copy an existing long term retention backup.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The parameters needed for long term retention copy request. Is either a
         CopyLongTermRetentionBackupParameters type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.sql.models.CopyLongTermRetentionBackupParameters or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either
         LongTermRetentionBackupOperationResult or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LongTermRetentionBackupOperationResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._copy_initial(
                location_name=location_name,
                long_term_retention_server_name=long_term_retention_server_name,
                long_term_retention_database_name=long_term_retention_database_name,
                backup_name=backup_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackupOperationResult", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.LongTermRetentionBackupOperationResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.LongTermRetentionBackupOperationResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _update_initial(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: Union[_models.UpdateLongTermRetentionBackupParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "UpdateLongTermRetentionBackupParameters")

        _request = build_update_request(
            location_name=location_name,
            long_term_retention_server_name=long_term_retention_server_name,
            long_term_retention_database_name=long_term_retention_database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: _models.UpdateLongTermRetentionBackupParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Updates an existing long term retention backup.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The requested backup resource state. Required.
        :type parameters: ~azure.mgmt.sql.models.UpdateLongTermRetentionBackupParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either
         LongTermRetentionBackupOperationResult or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Updates an existing long term retention backup.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The requested backup resource state. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either
         LongTermRetentionBackupOperationResult or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update(
        self,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: Union[_models.UpdateLongTermRetentionBackupParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Updates an existing long term retention backup.

        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The requested backup resource state. Is either a
         UpdateLongTermRetentionBackupParameters type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.sql.models.UpdateLongTermRetentionBackupParameters or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either
         LongTermRetentionBackupOperationResult or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LongTermRetentionBackupOperationResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_initial(
                location_name=location_name,
                long_term_retention_server_name=long_term_retention_server_name,
                long_term_retention_database_name=long_term_retention_database_name,
                backup_name=backup_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackupOperationResult", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.LongTermRetentionBackupOperationResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.LongTermRetentionBackupOperationResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list_by_resource_group_location(
        self,
        resource_group_name: str,
        location_name: str,
        only_latest_per_database: Optional[bool] = None,
        database_state: Optional[Union[str, _models.DatabaseState]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.LongTermRetentionBackup"]:
        """Lists the long term retention backups for a given location based on resource group.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param only_latest_per_database: Whether or not to only get the latest backup for each
         database. Default value is None.
        :type only_latest_per_database: bool
        :param database_state: Whether to query against just live databases, just deleted databases, or
         all databases. Known values are: "All", "Live", and "Deleted". Default value is None.
        :type database_state: str or ~azure.mgmt.sql.models.DatabaseState
        :return: An iterator like instance of either LongTermRetentionBackup or the result of
         cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.sql.models.LongTermRetentionBackup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        cls: ClsType[_models.LongTermRetentionBackupListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_by_resource_group_location_request(
                    resource_group_name=resource_group_name,
                    location_name=location_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_by_resource_group_server(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        only_latest_per_database: Optional[bool] = None,
        database_state: Optional[Union[str, _models.DatabaseState]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.LongTermRetentionBackup"]:
        """Lists the long term retention backups for a given server based on resource groups.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param only_latest_per_database: Whether or not to only get the latest backup for each
         database. Default value is None.
        :type only_latest_per_database: bool
        :param database_state: Whether to query against just live databases, just deleted databases, or
         all databases. Known values are: "All", "Live", and "Deleted". Default value is None.
        :type database_state: str or ~azure.mgmt.sql.models.DatabaseState
        :return: An iterator like instance of either LongTermRetentionBackup or the result of
         cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.sql.models.LongTermRetentionBackup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        cls: ClsType[_models.LongTermRetentionBackupListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_by_resource_group_server_request(
                    resource_group_name=resource_group_name,
                    location_name=location_name,
                    long_term_retention_server_name=long_term_retention_server_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_by_resource_group_database(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        only_latest_per_database: Optional[bool] = None,
        database_state: Optional[Union[str, _models.DatabaseState]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.LongTermRetentionBackup"]:
        """Lists all long term retention backups for a database based on a particular resource group.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param only_latest_per_database: Whether or not to only get the latest backup for each
         database. Default value is None.
        :type only_latest_per_database: bool
        :param database_state: Whether to query against just live databases, just deleted databases, or
         all databases. Known values are: "All", "Live", and "Deleted". Default value is None.
        :type database_state: str or ~azure.mgmt.sql.models.DatabaseState
        :return: An iterator like instance of either LongTermRetentionBackup or the result of
         cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.sql.models.LongTermRetentionBackup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        cls: ClsType[_models.LongTermRetentionBackupListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_by_resource_group_database_request(
                    resource_group_name=resource_group_name,
                    location_name=location_name,
                    long_term_retention_server_name=long_term_retention_server_name,
                    long_term_retention_database_name=long_term_retention_database_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_by_resource_group(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        **kwargs: Any
    ) -> _models.LongTermRetentionBackup:
        """Gets a long term retention backup.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :return: LongTermRetentionBackup or the result of cls(response)
        :rtype: ~azure.mgmt.sql.models.LongTermRetentionBackup
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        cls: ClsType[_models.LongTermRetentionBackup] = kwargs.pop("cls", None)

        _request = build_get_by_resource_group_request(
            resource_group_name=resource_group_name,
            location_name=location_name,
            long_term_retention_server_name=long_term_retention_server_name,
            long_term_retention_database_name=long_term_retention_database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("LongTermRetentionBackup", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _delete_by_resource_group_initial(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_delete_by_resource_group_request(
            resource_group_name=resource_group_name,
            location_name=location_name,
            long_term_retention_server_name=long_term_retention_server_name,
            long_term_retention_database_name=long_term_retention_database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete_by_resource_group(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a long term retention backup.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_by_resource_group_initial(
                resource_group_name=resource_group_name,
                location_name=location_name,
                long_term_retention_server_name=long_term_retention_server_name,
                long_term_retention_database_name=long_term_retention_database_name,
                backup_name=backup_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _change_access_tier_by_resource_group_initial(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: Union[_models.ChangeLongTermRetentionBackupAccessTierParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ChangeLongTermRetentionBackupAccessTierParameters")

        _request = build_change_access_tier_by_resource_group_request(
            resource_group_name=resource_group_name,
            location_name=location_name,
            long_term_retention_server_name=long_term_retention_server_name,
            long_term_retention_database_name=long_term_retention_database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_change_access_tier_by_resource_group(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: _models.ChangeLongTermRetentionBackupAccessTierParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LongTermRetentionBackup]:
        """Change a long term retention backup access tier.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: Required.
        :type location_name: str
        :param long_term_retention_server_name: Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: Required.
        :type long_term_retention_database_name: str
        :param backup_name: Required.
        :type backup_name: str
        :param parameters: Required.
        :type parameters: ~azure.mgmt.sql.models.ChangeLongTermRetentionBackupAccessTierParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either LongTermRetentionBackup or the
         result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.sql.models.LongTermRetentionBackup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_change_access_tier_by_resource_group(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LongTermRetentionBackup]:
        """Change a long term retention backup access tier.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: Required.
        :type location_name: str
        :param long_term_retention_server_name: Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: Required.
        :type long_term_retention_database_name: str
        :param backup_name: Required.
        :type backup_name: str
        :param parameters: Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either LongTermRetentionBackup or the
         result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.sql.models.LongTermRetentionBackup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_change_access_tier_by_resource_group(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: Union[_models.ChangeLongTermRetentionBackupAccessTierParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LongTermRetentionBackup]:
        """Change a long term retention backup access tier.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: Required.
        :type location_name: str
        :param long_term_retention_server_name: Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: Required.
        :type long_term_retention_database_name: str
        :param backup_name: Required.
        :type backup_name: str
        :param parameters: Is either a ChangeLongTermRetentionBackupAccessTierParameters type or a
         IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.sql.models.ChangeLongTermRetentionBackupAccessTierParameters or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either LongTermRetentionBackup or the
         result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.sql.models.LongTermRetentionBackup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LongTermRetentionBackup] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._change_access_tier_by_resource_group_initial(
                resource_group_name=resource_group_name,
                location_name=location_name,
                long_term_retention_server_name=long_term_retention_server_name,
                long_term_retention_database_name=long_term_retention_database_name,
                backup_name=backup_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackup", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.LongTermRetentionBackup].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.LongTermRetentionBackup](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _copy_by_resource_group_initial(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: Union[_models.CopyLongTermRetentionBackupParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "CopyLongTermRetentionBackupParameters")

        _request = build_copy_by_resource_group_request(
            resource_group_name=resource_group_name,
            location_name=location_name,
            long_term_retention_server_name=long_term_retention_server_name,
            long_term_retention_database_name=long_term_retention_database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_copy_by_resource_group(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: _models.CopyLongTermRetentionBackupParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Copy an existing long term retention backup to a different server.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The parameters needed for long term retention copy request. Required.
        :type parameters: ~azure.mgmt.sql.models.CopyLongTermRetentionBackupParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either
         LongTermRetentionBackupOperationResult or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_copy_by_resource_group(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Copy an existing long term retention backup to a different server.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The parameters needed for long term retention copy request. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either
         LongTermRetentionBackupOperationResult or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_copy_by_resource_group(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: Union[_models.CopyLongTermRetentionBackupParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Copy an existing long term retention backup to a different server.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The parameters needed for long term retention copy request. Is either a
         CopyLongTermRetentionBackupParameters type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.sql.models.CopyLongTermRetentionBackupParameters or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either
         LongTermRetentionBackupOperationResult or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LongTermRetentionBackupOperationResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._copy_by_resource_group_initial(
                resource_group_name=resource_group_name,
                location_name=location_name,
                long_term_retention_server_name=long_term_retention_server_name,
                long_term_retention_database_name=long_term_retention_database_name,
                backup_name=backup_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackupOperationResult", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.LongTermRetentionBackupOperationResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.LongTermRetentionBackupOperationResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _update_by_resource_group_initial(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: Union[_models.UpdateLongTermRetentionBackupParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "UpdateLongTermRetentionBackupParameters")

        _request = build_update_by_resource_group_request(
            resource_group_name=resource_group_name,
            location_name=location_name,
            long_term_retention_server_name=long_term_retention_server_name,
            long_term_retention_database_name=long_term_retention_database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update_by_resource_group(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: _models.UpdateLongTermRetentionBackupParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Updates an existing long term retention backup.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The requested backup resource state. Required.
        :type parameters: ~azure.mgmt.sql.models.UpdateLongTermRetentionBackupParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either
         LongTermRetentionBackupOperationResult or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update_by_resource_group(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Updates an existing long term retention backup.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The requested backup resource state. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either
         LongTermRetentionBackupOperationResult or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update_by_resource_group(
        self,
        resource_group_name: str,
        location_name: str,
        long_term_retention_server_name: str,
        long_term_retention_database_name: str,
        backup_name: str,
        parameters: Union[_models.UpdateLongTermRetentionBackupParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LongTermRetentionBackupOperationResult]:
        """Updates an existing long term retention backup.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal. Required.
        :type resource_group_name: str
        :param location_name: The location of the database. Required.
        :type location_name: str
        :param long_term_retention_server_name: The name of the server. Required.
        :type long_term_retention_server_name: str
        :param long_term_retention_database_name: The name of the database. Required.
        :type long_term_retention_database_name: str
        :param backup_name: The backup name. Required.
        :type backup_name: str
        :param parameters: The requested backup resource state. Is either a
         UpdateLongTermRetentionBackupParameters type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.sql.models.UpdateLongTermRetentionBackupParameters or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either
         LongTermRetentionBackupOperationResult or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.sql.models.LongTermRetentionBackupOperationResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LongTermRetentionBackupOperationResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_by_resource_group_initial(
                resource_group_name=resource_group_name,
                location_name=location_name,
                long_term_retention_server_name=long_term_retention_server_name,
                long_term_retention_database_name=long_term_retention_database_name,
                backup_name=backup_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("LongTermRetentionBackupOperationResult", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.LongTermRetentionBackupOperationResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.LongTermRetentionBackupOperationResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )
