# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class AccessCondition(msrest.serialization.Model):
    """Parameter group.

    :param if_none_match: Defines the If-None-Match condition. The operation will be performed only
     if the ETag on the server does not match this value.
    :type if_none_match: str
    """

    _attribute_map = {
        'if_none_match': {'key': 'If-None-Match', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccessCondition, self).__init__(**kwargs)
        self.if_none_match = kwargs.get('if_none_match', None)


class Compatibility(msrest.serialization.Model):
    """Update compatibility information.

    All required parameters must be populated in order to send to Azure.

    :param device_manufacturer: Required. The manufacturer of device the update is compatible with.
    :type device_manufacturer: str
    :param device_model: Required. The model of device the update is compatible with.
    :type device_model: str
    """

    _validation = {
        'device_manufacturer': {'required': True},
        'device_model': {'required': True},
    }

    _attribute_map = {
        'device_manufacturer': {'key': 'deviceManufacturer', 'type': 'str'},
        'device_model': {'key': 'deviceModel', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Compatibility, self).__init__(**kwargs)
        self.device_manufacturer = kwargs['device_manufacturer']
        self.device_model = kwargs['device_model']


class Deployment(msrest.serialization.Model):
    """Deployment metadata.

    All required parameters must be populated in order to send to Azure.

    :param deployment_id: Required. Gets or sets the deployment identifier.
    :type deployment_id: str
    :param deployment_type: Required. Gets or sets the deployment type. Possible values include:
     "Complete", "Download", "Install".
    :type deployment_type: str or ~azure.iot.deviceupdate.models.DeploymentType
    :param device_class_id: Gets or sets the device class identifier.
    :type device_class_id: str
    :param start_date_time: Required. Gets or sets the Deployment start datetime.
    :type start_date_time: ~datetime.datetime
    :param device_group_type: Required. Gets or sets the device group type. Possible values
     include: "All", "Devices", "DeviceGroupDefinitions".
    :type device_group_type: str or ~azure.iot.deviceupdate.models.DeviceGroupType
    :param device_group_definition: Required. Gets or sets the device group definition.
    :type device_group_definition: list[str]
    :param update_id: Required. Update identity.
    :type update_id: ~azure.iot.deviceupdate.models.UpdateId
    :param is_canceled: Boolean flag indicating whether the deployment was canceled.
    :type is_canceled: bool
    :param is_retried: Boolean flag indicating whether the deployment has been retried.
    :type is_retried: bool
    :param is_completed: Boolean flag indicating whether the deployment was completed.
    :type is_completed: bool
    """

    _validation = {
        'deployment_id': {'required': True},
        'deployment_type': {'required': True},
        'start_date_time': {'required': True},
        'device_group_type': {'required': True},
        'device_group_definition': {'required': True},
        'update_id': {'required': True},
    }

    _attribute_map = {
        'deployment_id': {'key': 'deploymentId', 'type': 'str'},
        'deployment_type': {'key': 'deploymentType', 'type': 'str'},
        'device_class_id': {'key': 'deviceClassId', 'type': 'str'},
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
        'device_group_type': {'key': 'deviceGroupType', 'type': 'str'},
        'device_group_definition': {'key': 'deviceGroupDefinition', 'type': '[str]'},
        'update_id': {'key': 'updateId', 'type': 'UpdateId'},
        'is_canceled': {'key': 'isCanceled', 'type': 'bool'},
        'is_retried': {'key': 'isRetried', 'type': 'bool'},
        'is_completed': {'key': 'isCompleted', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Deployment, self).__init__(**kwargs)
        self.deployment_id = kwargs['deployment_id']
        self.deployment_type = kwargs['deployment_type']
        self.device_class_id = kwargs.get('device_class_id', None)
        self.start_date_time = kwargs['start_date_time']
        self.device_group_type = kwargs['device_group_type']
        self.device_group_definition = kwargs['device_group_definition']
        self.update_id = kwargs['update_id']
        self.is_canceled = kwargs.get('is_canceled', None)
        self.is_retried = kwargs.get('is_retried', None)
        self.is_completed = kwargs.get('is_completed', None)


class DeploymentDeviceState(msrest.serialization.Model):
    """Deployment device status.

    All required parameters must be populated in order to send to Azure.

    :param device_id: Required. Device identity.
    :type device_id: str
    :param retry_count: Required. The number of times this deployment has been retried on this
     device.
    :type retry_count: int
    :param moved_on_to_new_deployment: Required. Boolean flag indicating whether this device is in
     a newer deployment and can no longer retry this deployment.
    :type moved_on_to_new_deployment: bool
    :param device_state: Required. Deployment device state. Possible values include: "Succeeded",
     "InProgress", "Failed", "Canceled", "Incompatible".
    :type device_state: str or ~azure.iot.deviceupdate.models.DeviceDeploymentState
    """

    _validation = {
        'device_id': {'required': True},
        'retry_count': {'required': True},
        'moved_on_to_new_deployment': {'required': True},
        'device_state': {'required': True},
    }

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'retry_count': {'key': 'retryCount', 'type': 'int'},
        'moved_on_to_new_deployment': {'key': 'movedOnToNewDeployment', 'type': 'bool'},
        'device_state': {'key': 'deviceState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeploymentDeviceState, self).__init__(**kwargs)
        self.device_id = kwargs['device_id']
        self.retry_count = kwargs['retry_count']
        self.moved_on_to_new_deployment = kwargs['moved_on_to_new_deployment']
        self.device_state = kwargs['device_state']


class DeploymentDeviceStatesFilter(msrest.serialization.Model):
    """Deployment device state filter.

    :param device_id: Device Identifier.
    :type device_id: str
    :param device_state: The deployment device state. Possible values include: "NotStarted",
     "Incompatible", "AlreadyInDeployment", "Canceled", "InProgress", "Failed", "Succeeded".
    :type device_state: str or ~azure.iot.deviceupdate.models.DeviceState
    """

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'device_state': {'key': 'deviceState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeploymentDeviceStatesFilter, self).__init__(**kwargs)
        self.device_id = kwargs.get('device_id', None)
        self.device_state = kwargs.get('device_state', None)


class DeploymentFilter(msrest.serialization.Model):
    """Deployment filter.

    :param provider: Update provider.
    :type provider: str
    :param name: Update name.
    :type name: str
    :param version: Update version.
    :type version: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeploymentFilter, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.name = kwargs.get('name', None)
        self.version = kwargs.get('version', None)


class DeploymentStatus(msrest.serialization.Model):
    """Deployment status metadata.

    All required parameters must be populated in order to send to Azure.

    :param deployment_state: Required. Gets or sets the state of the deployment. Possible values
     include: "Active", "Superseded", "Canceled".
    :type deployment_state: str or ~azure.iot.deviceupdate.models.DeploymentState
    :param total_devices: Gets or sets the total number of devices in the deployment.
    :type total_devices: int
    :param devices_incompatible_count: Gets or sets the number of incompatible devices in the
     deployment.
    :type devices_incompatible_count: int
    :param devices_in_progress_count: Gets or sets the number of devices that are currently in
     deployment.
    :type devices_in_progress_count: int
    :param devices_completed_failed_count: Gets or sets the number of devices that have completed
     deployment with a failure.
    :type devices_completed_failed_count: int
    :param devices_completed_succeeded_count: Gets or sets the number of devices which have
     successfully completed deployment.
    :type devices_completed_succeeded_count: int
    :param devices_canceled_count: Gets or sets the number of devices which have had their
     deployment canceled.
    :type devices_canceled_count: int
    """

    _validation = {
        'deployment_state': {'required': True},
    }

    _attribute_map = {
        'deployment_state': {'key': 'deploymentState', 'type': 'str'},
        'total_devices': {'key': 'totalDevices', 'type': 'int'},
        'devices_incompatible_count': {'key': 'devicesIncompatibleCount', 'type': 'int'},
        'devices_in_progress_count': {'key': 'devicesInProgressCount', 'type': 'int'},
        'devices_completed_failed_count': {'key': 'devicesCompletedFailedCount', 'type': 'int'},
        'devices_completed_succeeded_count': {'key': 'devicesCompletedSucceededCount', 'type': 'int'},
        'devices_canceled_count': {'key': 'devicesCanceledCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeploymentStatus, self).__init__(**kwargs)
        self.deployment_state = kwargs['deployment_state']
        self.total_devices = kwargs.get('total_devices', None)
        self.devices_incompatible_count = kwargs.get('devices_incompatible_count', None)
        self.devices_in_progress_count = kwargs.get('devices_in_progress_count', None)
        self.devices_completed_failed_count = kwargs.get('devices_completed_failed_count', None)
        self.devices_completed_succeeded_count = kwargs.get('devices_completed_succeeded_count', None)
        self.devices_canceled_count = kwargs.get('devices_canceled_count', None)


class Device(msrest.serialization.Model):
    """Device metadata.

    All required parameters must be populated in order to send to Azure.

    :param device_id: Required. Device identity.
    :type device_id: str
    :param device_class_id: Required. Device class identity.
    :type device_class_id: str
    :param manufacturer: Required. Device manufacturer.
    :type manufacturer: str
    :param model: Required. Device model.
    :type model: str
    :param group_id: Device group identity.
    :type group_id: str
    :param last_attempted_update_id: Update identity.
    :type last_attempted_update_id: ~azure.iot.deviceupdate.models.UpdateId
    :param deployment_status: State of the device in its last deployment. Possible values include:
     "Succeeded", "InProgress", "Failed", "Canceled", "Incompatible".
    :type deployment_status: str or ~azure.iot.deviceupdate.models.DeviceDeploymentState
    :param installed_update_id: Update identity.
    :type installed_update_id: ~azure.iot.deviceupdate.models.UpdateId
    :param on_latest_update: Required. Boolean flag indicating whether the latest update is
     installed on the device.
    :type on_latest_update: bool
    :param last_deployment_id: The deployment identifier for the last deployment to the device.
    :type last_deployment_id: str
    """

    _validation = {
        'device_id': {'required': True},
        'device_class_id': {'required': True},
        'manufacturer': {'required': True},
        'model': {'required': True},
        'on_latest_update': {'required': True},
    }

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'device_class_id': {'key': 'deviceClassId', 'type': 'str'},
        'manufacturer': {'key': 'manufacturer', 'type': 'str'},
        'model': {'key': 'model', 'type': 'str'},
        'group_id': {'key': 'groupId', 'type': 'str'},
        'last_attempted_update_id': {'key': 'lastAttemptedUpdateId', 'type': 'UpdateId'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
        'installed_update_id': {'key': 'installedUpdateId', 'type': 'UpdateId'},
        'on_latest_update': {'key': 'onLatestUpdate', 'type': 'bool'},
        'last_deployment_id': {'key': 'lastDeploymentId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Device, self).__init__(**kwargs)
        self.device_id = kwargs['device_id']
        self.device_class_id = kwargs['device_class_id']
        self.manufacturer = kwargs['manufacturer']
        self.model = kwargs['model']
        self.group_id = kwargs.get('group_id', None)
        self.last_attempted_update_id = kwargs.get('last_attempted_update_id', None)
        self.deployment_status = kwargs.get('deployment_status', None)
        self.installed_update_id = kwargs.get('installed_update_id', None)
        self.on_latest_update = kwargs['on_latest_update']
        self.last_deployment_id = kwargs.get('last_deployment_id', None)


class DeviceClass(msrest.serialization.Model):
    """Device class metadata.

    All required parameters must be populated in order to send to Azure.

    :param device_class_id: Required. The device class identifier.
    :type device_class_id: str
    :param manufacturer: Required. Device manufacturer.
    :type manufacturer: str
    :param model: Required. Device model.
    :type model: str
    :param best_compatible_update_id: Required. Update identity.
    :type best_compatible_update_id: ~azure.iot.deviceupdate.models.UpdateId
    """

    _validation = {
        'device_class_id': {'required': True},
        'manufacturer': {'required': True},
        'model': {'required': True},
        'best_compatible_update_id': {'required': True},
    }

    _attribute_map = {
        'device_class_id': {'key': 'deviceClassId', 'type': 'str'},
        'manufacturer': {'key': 'manufacturer', 'type': 'str'},
        'model': {'key': 'model', 'type': 'str'},
        'best_compatible_update_id': {'key': 'bestCompatibleUpdateId', 'type': 'UpdateId'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeviceClass, self).__init__(**kwargs)
        self.device_class_id = kwargs['device_class_id']
        self.manufacturer = kwargs['manufacturer']
        self.model = kwargs['model']
        self.best_compatible_update_id = kwargs['best_compatible_update_id']


class DeviceFilter(msrest.serialization.Model):
    """Operation status filter.

    :param group_id: Device group identifier.
    :type group_id: str
    """

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeviceFilter, self).__init__(**kwargs)
        self.group_id = kwargs.get('group_id', None)


class DeviceTag(msrest.serialization.Model):
    """Device tag properties.

    All required parameters must be populated in order to send to Azure.

    :param tag_name: Required. Tag name.
    :type tag_name: str
    :param device_count: Required. Number of devices with this tag.
    :type device_count: int
    """

    _validation = {
        'tag_name': {'required': True},
        'device_count': {'required': True},
    }

    _attribute_map = {
        'tag_name': {'key': 'tagName', 'type': 'str'},
        'device_count': {'key': 'deviceCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeviceTag, self).__init__(**kwargs)
        self.tag_name = kwargs['tag_name']
        self.device_count = kwargs['device_count']


class Error(msrest.serialization.Model):
    """Error details.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Server defined error code.
    :type code: str
    :param message: Required. A human-readable representation of the error.
    :type message: str
    :param target: The target of the error.
    :type target: str
    :param details: An array of errors that led to the reported error.
    :type details: list[~azure.iot.deviceupdate.models.Error]
    :param innererror: An object containing more specific information than the current object about
     the error.
    :type innererror: ~azure.iot.deviceupdate.models.InnerError
    :param occurred_date_time: Date and time in UTC when the error occurred.
    :type occurred_date_time: ~datetime.datetime
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[Error]'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
        'occurred_date_time': {'key': 'occurredDateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Error, self).__init__(**kwargs)
        self.code = kwargs['code']
        self.message = kwargs['message']
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)
        self.innererror = kwargs.get('innererror', None)
        self.occurred_date_time = kwargs.get('occurred_date_time', None)


class File(msrest.serialization.Model):
    """Update file metadata.

    All required parameters must be populated in order to send to Azure.

    :param file_id: Required. File identity, generated by server at import time.
    :type file_id: str
    :param file_name: Required. File name.
    :type file_name: str
    :param size_in_bytes: Required. File size in number of bytes.
    :type size_in_bytes: long
    :param hashes: Required. Mapping of hashing algorithm to base64 encoded hash values.
    :type hashes: dict[str, str]
    :param mime_type: File MIME type.
    :type mime_type: str
    :param etag: File ETag.
    :type etag: str
    """

    _validation = {
        'file_id': {'required': True},
        'file_name': {'required': True},
        'size_in_bytes': {'required': True},
        'hashes': {'required': True},
    }

    _attribute_map = {
        'file_id': {'key': 'fileId', 'type': 'str'},
        'file_name': {'key': 'fileName', 'type': 'str'},
        'size_in_bytes': {'key': 'sizeInBytes', 'type': 'long'},
        'hashes': {'key': 'hashes', 'type': '{str}'},
        'mime_type': {'key': 'mimeType', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(File, self).__init__(**kwargs)
        self.file_id = kwargs['file_id']
        self.file_name = kwargs['file_name']
        self.size_in_bytes = kwargs['size_in_bytes']
        self.hashes = kwargs['hashes']
        self.mime_type = kwargs.get('mime_type', None)
        self.etag = kwargs.get('etag', None)


class FileImportMetadata(msrest.serialization.Model):
    """Metadata describing an update file.

    All required parameters must be populated in order to send to Azure.

    :param filename: Required. Update file name as specified inside import manifest.
    :type filename: str
    :param url: Required. Azure Blob location from which the update file can be downloaded by
     Device Update for IoT Hub. This is typically a read-only SAS-protected blob URL with an
     expiration set to at least 4 hours.
    :type url: str
    """

    _validation = {
        'filename': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'filename': {'key': 'filename', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileImportMetadata, self).__init__(**kwargs)
        self.filename = kwargs['filename']
        self.url = kwargs['url']


class Group(msrest.serialization.Model):
    """Group details.

    All required parameters must be populated in order to send to Azure.

    :param group_id: Required. Group identity.
    :type group_id: str
    :param group_type: Required. Group type. Possible values include: "IoTHubTag".
    :type group_type: str or ~azure.iot.deviceupdate.models.GroupType
    :param tags: Required. A set of tags. IoT Hub tags.
    :type tags: list[str]
    :param created_date_time: Required. Date and time when the update was created.
    :type created_date_time: str
    :param device_count: The number of devices in the group.
    :type device_count: int
    """

    _validation = {
        'group_id': {'required': True},
        'group_type': {'required': True},
        'tags': {'required': True},
        'created_date_time': {'required': True},
    }

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'group_type': {'key': 'groupType', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '[str]'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'str'},
        'device_count': {'key': 'deviceCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Group, self).__init__(**kwargs)
        self.group_id = kwargs['group_id']
        self.group_type = kwargs['group_type']
        self.tags = kwargs['tags']
        self.created_date_time = kwargs['created_date_time']
        self.device_count = kwargs.get('device_count', None)


class GroupBestUpdatesFilter(msrest.serialization.Model):
    """Group best updates filter.

    :param provider: Update provider.
    :type provider: str
    :param name: Update name.
    :type name: str
    :param version: Update version.
    :type version: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GroupBestUpdatesFilter, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.name = kwargs.get('name', None)
        self.version = kwargs.get('version', None)


class ImportManifestMetadata(msrest.serialization.Model):
    """Metadata describing the import manifest, a document which describes the files and other metadata about an update version.

    All required parameters must be populated in order to send to Azure.

    :param url: Required. Azure Blob location from which the import manifest can be downloaded by
     Device Update for IoT Hub. This is typically a read-only SAS-protected blob URL with an
     expiration set to at least 4 hours.
    :type url: str
    :param size_in_bytes: Required. File size in number of bytes.
    :type size_in_bytes: long
    :param hashes: Required. A JSON object containing the hash(es) of the file. At least SHA256
     hash is required. This object can be thought of as a set of key-value pairs where the key is
     the hash algorithm, and the value is the hash of the file calculated using that algorithm.
    :type hashes: dict[str, str]
    """

    _validation = {
        'url': {'required': True},
        'size_in_bytes': {'required': True},
        'hashes': {'required': True},
    }

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'size_in_bytes': {'key': 'sizeInBytes', 'type': 'long'},
        'hashes': {'key': 'hashes', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportManifestMetadata, self).__init__(**kwargs)
        self.url = kwargs['url']
        self.size_in_bytes = kwargs['size_in_bytes']
        self.hashes = kwargs['hashes']


class ImportUpdateInput(msrest.serialization.Model):
    """Import update input metadata.

    All required parameters must be populated in order to send to Azure.

    :param import_manifest: Required. Import manifest metadata like source URL, file size/hashes,
     etc.
    :type import_manifest: ~azure.iot.deviceupdate.models.ImportManifestMetadata
    :param files: Required. One or more update file properties like filename and source URL.
    :type files: list[~azure.iot.deviceupdate.models.FileImportMetadata]
    """

    _validation = {
        'import_manifest': {'required': True},
        'files': {'required': True, 'min_items': 1},
    }

    _attribute_map = {
        'import_manifest': {'key': 'importManifest', 'type': 'ImportManifestMetadata'},
        'files': {'key': 'files', 'type': '[FileImportMetadata]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportUpdateInput, self).__init__(**kwargs)
        self.import_manifest = kwargs['import_manifest']
        self.files = kwargs['files']


class InnerError(msrest.serialization.Model):
    """An object containing more specific information than the current object about the error.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. A more specific error code than what was provided by the containing
     error.
    :type code: str
    :param message: A human-readable representation of the error.
    :type message: str
    :param error_detail: The internal error or exception message.
    :type error_detail: str
    :param inner_error: An object containing more specific information than the current object
     about the error.
    :type inner_error: ~azure.iot.deviceupdate.models.InnerError
    """

    _validation = {
        'code': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'error_detail': {'key': 'errorDetail', 'type': 'str'},
        'inner_error': {'key': 'innerError', 'type': 'InnerError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InnerError, self).__init__(**kwargs)
        self.code = kwargs['code']
        self.message = kwargs.get('message', None)
        self.error_detail = kwargs.get('error_detail', None)
        self.inner_error = kwargs.get('inner_error', None)


class Operation(msrest.serialization.Model):
    """Operation metadata.

    All required parameters must be populated in order to send to Azure.

    :param operation_id: Required. Operation Id.
    :type operation_id: str
    :param status: Required. Operation status. Possible values include: "Undefined", "NotStarted",
     "Running", "Succeeded", "Failed".
    :type status: str or ~azure.iot.deviceupdate.models.OperationStatus
    :param update_id: The identity of update being imported or deleted. For import, this property
     will only be populated after import manifest is processed successfully.
    :type update_id: ~azure.iot.deviceupdate.models.UpdateId
    :param resource_location: Location of the imported update when operation is successful.
    :type resource_location: str
    :param error: Operation error encountered, if any.
    :type error: ~azure.iot.deviceupdate.models.Error
    :param trace_id: Operation correlation identity that can used by Microsoft Support for
     troubleshooting.
    :type trace_id: str
    :param last_action_date_time: Required. Date and time in UTC when the operation status was last
     updated.
    :type last_action_date_time: ~datetime.datetime
    :param created_date_time: Required. Date and time in UTC when the operation was created.
    :type created_date_time: ~datetime.datetime
    :param etag: Operation ETag.
    :type etag: str
    """

    _validation = {
        'operation_id': {'required': True},
        'status': {'required': True},
        'last_action_date_time': {'required': True},
        'created_date_time': {'required': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'update_id': {'key': 'updateId', 'type': 'UpdateId'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
        'trace_id': {'key': 'traceId', 'type': 'str'},
        'last_action_date_time': {'key': 'lastActionDateTime', 'type': 'iso-8601'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.operation_id = kwargs['operation_id']
        self.status = kwargs['status']
        self.update_id = kwargs.get('update_id', None)
        self.resource_location = kwargs.get('resource_location', None)
        self.error = kwargs.get('error', None)
        self.trace_id = kwargs.get('trace_id', None)
        self.last_action_date_time = kwargs['last_action_date_time']
        self.created_date_time = kwargs['created_date_time']
        self.etag = kwargs.get('etag', None)


class OperationFilter(msrest.serialization.Model):
    """Operation status filter.

    :param status: Operation status filter. Possible values include: "Running", "NotStarted".
    :type status: str or ~azure.iot.deviceupdate.models.OperationFilterStatus
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationFilter, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)


class PageableListOfDeploymentDeviceStates(msrest.serialization.Model):
    """The list of deployment device states.

    :param value: The collection of pageable items.
    :type value: list[~azure.iot.deviceupdate.models.DeploymentDeviceState]
    :param next_link: The link to the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeploymentDeviceState]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PageableListOfDeploymentDeviceStates, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PageableListOfDeployments(msrest.serialization.Model):
    """The list of deployments.

    :param value: The collection of pageable items.
    :type value: list[~azure.iot.deviceupdate.models.Deployment]
    :param next_link: The link to the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Deployment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PageableListOfDeployments, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PageableListOfDeviceClasses(msrest.serialization.Model):
    """The list of device classes.

    :param value: The collection of pageable items.
    :type value: list[~azure.iot.deviceupdate.models.DeviceClass]
    :param next_link: The link to the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeviceClass]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PageableListOfDeviceClasses, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PageableListOfDevices(msrest.serialization.Model):
    """The list of devices.

    :param value: The collection of pageable items.
    :type value: list[~azure.iot.deviceupdate.models.Device]
    :param next_link: The link to the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Device]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PageableListOfDevices, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PageableListOfDeviceTags(msrest.serialization.Model):
    """The list of device tags.

    :param value: The collection of pageable items.
    :type value: list[~azure.iot.deviceupdate.models.DeviceTag]
    :param next_link: The link to the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeviceTag]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PageableListOfDeviceTags, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PageableListOfGroups(msrest.serialization.Model):
    """The list of groups.

    :param value: The collection of pageable items.
    :type value: list[~azure.iot.deviceupdate.models.Group]
    :param next_link: The link to the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Group]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PageableListOfGroups, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PageableListOfOperations(msrest.serialization.Model):
    """The list of operations with server paging support.

    :param value: The collection of pageable items.
    :type value: list[~azure.iot.deviceupdate.models.Operation]
    :param next_link: The link to the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PageableListOfOperations, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PageableListOfStrings(msrest.serialization.Model):
    """The list of strings with server paging support.

    :param value: The collection of pageable items.
    :type value: list[str]
    :param next_link: The link to the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[str]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PageableListOfStrings, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PageableListOfUpdatableDevices(msrest.serialization.Model):
    """The list of updatable devices.

    :param value: The collection of pageable items.
    :type value: list[~azure.iot.deviceupdate.models.UpdatableDevices]
    :param next_link: The link to the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UpdatableDevices]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PageableListOfUpdatableDevices, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PageableListOfUpdateIds(msrest.serialization.Model):
    """The list of update identities.

    :param value: The collection of pageable items.
    :type value: list[~azure.iot.deviceupdate.models.UpdateId]
    :param next_link: The link to the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UpdateId]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PageableListOfUpdateIds, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class UpdatableDevices(msrest.serialization.Model):
    """Update identifier and the number of devices for which the update is applicable.

    All required parameters must be populated in order to send to Azure.

    :param update_id: Required. Update identity.
    :type update_id: ~azure.iot.deviceupdate.models.UpdateId
    :param device_count: Required. Total number of devices for which the update is applicable.
    :type device_count: int
    """

    _validation = {
        'update_id': {'required': True},
        'device_count': {'required': True},
    }

    _attribute_map = {
        'update_id': {'key': 'updateId', 'type': 'UpdateId'},
        'device_count': {'key': 'deviceCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdatableDevices, self).__init__(**kwargs)
        self.update_id = kwargs['update_id']
        self.device_count = kwargs['device_count']


class Update(msrest.serialization.Model):
    """Update metadata.

    All required parameters must be populated in order to send to Azure.

    :param update_id: Required. Update identity.
    :type update_id: ~azure.iot.deviceupdate.models.UpdateId
    :param update_type: Required. Update type.
    :type update_type: str
    :param installed_criteria: Required. String interpreted by Device Update client to determine if
     the update is installed on the device.
    :type installed_criteria: str
    :param compatibility: Required. List of update compatibility information.
    :type compatibility: list[~azure.iot.deviceupdate.models.Compatibility]
    :param manifest_version: Required. Schema version of manifest used to import the update.
    :type manifest_version: str
    :param imported_date_time: Required. Date and time in UTC when the update was imported.
    :type imported_date_time: ~datetime.datetime
    :param created_date_time: Required. Date and time in UTC when the update was created.
    :type created_date_time: ~datetime.datetime
    :param etag: Update ETag.
    :type etag: str
    """

    _validation = {
        'update_id': {'required': True},
        'update_type': {'required': True},
        'installed_criteria': {'required': True},
        'compatibility': {'required': True, 'min_items': 1},
        'manifest_version': {'required': True},
        'imported_date_time': {'required': True},
        'created_date_time': {'required': True},
    }

    _attribute_map = {
        'update_id': {'key': 'updateId', 'type': 'UpdateId'},
        'update_type': {'key': 'updateType', 'type': 'str'},
        'installed_criteria': {'key': 'installedCriteria', 'type': 'str'},
        'compatibility': {'key': 'compatibility', 'type': '[Compatibility]'},
        'manifest_version': {'key': 'manifestVersion', 'type': 'str'},
        'imported_date_time': {'key': 'importedDateTime', 'type': 'iso-8601'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Update, self).__init__(**kwargs)
        self.update_id = kwargs['update_id']
        self.update_type = kwargs['update_type']
        self.installed_criteria = kwargs['installed_criteria']
        self.compatibility = kwargs['compatibility']
        self.manifest_version = kwargs['manifest_version']
        self.imported_date_time = kwargs['imported_date_time']
        self.created_date_time = kwargs['created_date_time']
        self.etag = kwargs.get('etag', None)


class UpdateCompliance(msrest.serialization.Model):
    """Update compliance information.

    All required parameters must be populated in order to send to Azure.

    :param total_device_count: Required. Total number of devices.
    :type total_device_count: int
    :param on_latest_update_device_count: Required. Number of devices on the latest update.
    :type on_latest_update_device_count: int
    :param new_updates_available_device_count: Required. Number of devices with a newer update
     available.
    :type new_updates_available_device_count: int
    :param updates_in_progress_device_count: Required. Number of devices with update in-progress.
    :type updates_in_progress_device_count: int
    """

    _validation = {
        'total_device_count': {'required': True},
        'on_latest_update_device_count': {'required': True},
        'new_updates_available_device_count': {'required': True},
        'updates_in_progress_device_count': {'required': True},
    }

    _attribute_map = {
        'total_device_count': {'key': 'totalDeviceCount', 'type': 'int'},
        'on_latest_update_device_count': {'key': 'onLatestUpdateDeviceCount', 'type': 'int'},
        'new_updates_available_device_count': {'key': 'newUpdatesAvailableDeviceCount', 'type': 'int'},
        'updates_in_progress_device_count': {'key': 'updatesInProgressDeviceCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateCompliance, self).__init__(**kwargs)
        self.total_device_count = kwargs['total_device_count']
        self.on_latest_update_device_count = kwargs['on_latest_update_device_count']
        self.new_updates_available_device_count = kwargs['new_updates_available_device_count']
        self.updates_in_progress_device_count = kwargs['updates_in_progress_device_count']


class UpdateId(msrest.serialization.Model):
    """Update identifier.

    All required parameters must be populated in order to send to Azure.

    :param provider: Required. Update provider.
    :type provider: str
    :param name: Required. Update name.
    :type name: str
    :param version: Required. Update version.
    :type version: str
    """

    _validation = {
        'provider': {'required': True},
        'name': {'required': True},
        'version': {'required': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateId, self).__init__(**kwargs)
        self.provider = kwargs['provider']
        self.name = kwargs['name']
        self.version = kwargs['version']
