from setuptools import setup

with open("README.md") as f:
    readme = f.read()

with open("aiosqlite/__init__.py") as f:
    for line in f:
        if line.startswith("__version__"):
            version = line.split('"')[1]

setup(
    name="aiosqlite",
    description="asyncio bridge to the standard sqlite3 module",
    long_description=readme,
    long_description_content_type="text/markdown",
    version=version,
    author="John Reese",
    author_email="john@noswap.com",
    url="https://github.com/jreese/aiosqlite",
    classifiers=[
        "Development Status :: 4 - Beta",
        "Framework :: AsyncIO",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.5",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Topic :: Software Development :: Libraries",
    ],
    license="MIT",
    packages=["aiosqlite", "aiosqlite.tests"],
    python_requires=">=3.5",
    setup_requires=["setuptools>=38.6.0"],
    tests_require=["aiounittest"],
    install_requires=[],
    test_suite="aiosqlite.tests",
)
