# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

#### Public Classes

* [`systemd`](#systemd): This module allows triggering systemd commands once for all modules
* [`systemd::systemctl::daemon_reload`](#systemdsystemctldaemon_reload): Reload the systemctl daemon
* [`systemd::tmpfiles`](#systemdtmpfiles): Update the systemd temp files

#### Private Classes

* `systemd::journald`: This class manages and configures journald.  https://www.freedesktop.org/software/systemd/man/journald.conf.html
* `systemd::logind`: This class manages systemd's login manager configuration.  https://www.freedesktop.org/software/systemd/man/logind.conf.html
* `systemd::networkd`: This class provides an abstract way to trigger systemd-networkd
* `systemd::resolved`: This class provides an abstract way to trigger resolved. Each parameters correspond to resolved.conf(5): https://www.freedesktop.org/software
* `systemd::system`: This class provides a solution to enable accounting
* `systemd::timesyncd`: This class provides an abstract way to trigger systemd-timesyncd

### Defined types

* [`systemd::dropin_file`](#systemddropin_file): Creates a drop-in file for a systemd unit
* [`systemd::network`](#systemdnetwork): -- Define: systemd::network Creates network config for systemd-networkd
* [`systemd::service_limits`](#systemdservice_limits): Adds a set of custom limits to the service   * Mutually exclusive with ``$limits``
* [`systemd::timer`](#systemdtimer): Create a timer and optionally a service unit to execute with the timer unit
* [`systemd::tmpfile`](#systemdtmpfile): Creates a systemd tmpfile   * Mutually exclusive with ``$limits``
* [`systemd::unit_file`](#systemdunit_file): Creates a systemd unit file

### Resource types

* [`loginctl_user`](#loginctl_user): An arbitrary name used as the identity of the resource.

### Data types

* [`Systemd::Dropin`](#systemddropin)
* [`Systemd::JournaldSettings`](#systemdjournaldsettings): Matches Systemd journald config Struct
* [`Systemd::JournaldSettings::Ensure`](#systemdjournaldsettingsensure)
* [`Systemd::LogindSettings`](#systemdlogindsettings): Matches Systemd Login Manager Struct
* [`Systemd::LogindSettings::Ensure`](#systemdlogindsettingsensure)
* [`Systemd::ServiceLimits`](#systemdservicelimits): Matches Systemd Service Limit Struct
* [`Systemd::Unit`](#systemdunit)

## Classes

### `systemd`

This module allows triggering systemd commands once for all modules

#### Parameters

The following parameters are available in the `systemd` class.

##### `service_limits`

Data type: `Hash[String,Hash[String, Any]]`

May be passed a resource hash suitable for passing directly into the
``create_resources()`` function as called on ``systemd::service_limits``

##### `manage_resolved`

Data type: `Boolean`

Manage the systemd resolver

##### `resolved_ensure`

Data type: `Enum['stopped','running']`

The state that the ``resolved`` service should be in

##### `dns`

Data type: `Optional[Variant[Array[String],String]]`

A space-separated list of IPv4 and IPv6 addresses to use as system DNS servers.
DNS requests are sent to one of the listed DNS servers in parallel to suitable
per-link DNS servers acquired from systemd-networkd.service(8) or set at runtime
by external applications. requires puppetlabs-inifile

##### `fallback_dns`

Data type: `Optional[Variant[Array[String],String]]`

A space-separated list of IPv4 and IPv6 addresses to use as the fallback DNS
servers. Any per-link DNS servers obtained from systemd-networkd take
precedence over this setting. requires puppetlabs-inifile

##### `domains`

Data type: `Optional[Variant[Array[String],String]]`

A space-separated list of domains host names or IP addresses to be used
systemd-resolved take precedence over this setting.

##### `llmnr`

Data type: `Optional[Variant[Boolean,Enum['resolve']]]`

Takes a boolean argument or "resolve".

##### `multicast_dns`

Data type: `Optional[Variant[Boolean,Enum['resolve']]]`

Takes a boolean argument or "resolve".

##### `dnssec`

Data type: `Optional[Variant[Boolean,Enum['allow-downgrade']]]`

Takes a boolean argument or "allow-downgrade".

##### `dnsovertls`

Data type: `Optional[Variant[Boolean,Enum['opportunistic', 'no']]]`

Takes a boolean argument or "opportunistic"

##### `cache`

Data type: `Boolean`

Takes a boolean argument.

##### `dns_stub_listener`

Data type: `Optional[Variant[Boolean,Enum['udp','tcp']]]`

Takes a boolean argument or one of "udp" and "tcp".

##### `use_stub_resolver`

Data type: `Boolean`

Takes a boolean argument. When "false" (default) it uses /var/run/systemd/resolve/resolv.conf
as /etc/resolv.conf. When "true", it uses /var/run/systemd/resolve/stub-resolv.conf

##### `manage_networkd`

Data type: `Boolean`

Manage the systemd network daemon

##### `networkd_ensure`

Data type: `Enum['stopped','running']`

The state that the ``networkd`` service should be in

##### `manage_timesyncd`

Data type: `Boolean`

Manage the systemd tiemsyncd daemon

##### `timesyncd_ensure`

Data type: `Enum['stopped','running']`

The state that the ``timesyncd`` service should be in

##### `ntp_server`

Data type: `Optional[Variant[Array,String]]`

comma separated list of ntp servers, will be combined with interface specific
addresses from systemd-networkd. requires puppetlabs-inifile

##### `fallback_ntp_server`

Data type: `Optional[Variant[Array,String]]`

A space-separated list of NTP server host names or IP addresses to be used
as the fallback NTP servers. Any per-interface NTP servers obtained from
systemd-networkd take precedence over this setting. requires puppetlabs-inifile

##### `manage_journald`

Data type: `Boolean`

Manage the systemd journald

##### `journald_settings`

Data type: `Systemd::JournaldSettings`

Config Hash that is used to configure settings in journald.conf

##### `manage_logind`

Data type: `Boolean`

Manage the systemd logind

##### `logind_settings`

Data type: `Systemd::LogindSettings`

Config Hash that is used to configure settings in logind.conf

##### `loginctl_users`

Data type: `Hash`

Config Hash that is used to generate instances of our type
`loginctl_user`.

Default value: `{}`

##### `dropin_files`

Data type: `Hash`

Configure dropin files via hiera with factory pattern

Default value: `{}`

##### `manage_accounting`

Data type: `Boolean`



##### `accounting`

Data type: `Hash[String,String]`



##### `purge_dropin_dirs`

Data type: `Boolean`



### `systemd::systemctl::daemon_reload`

Reload the systemctl daemon

### `systemd::tmpfiles`

Update the systemd temp files

* **See also**
  * systemd-tmpfiles(8)

#### Parameters

The following parameters are available in the `systemd::tmpfiles` class.

##### `operations`

Data type: `Array[Enum['create','clean','remove']]`

The operations to perform on the systemd tempfiles

* All operations may be combined but you'll probably only ever want to
  use ``create``

Default value: `['create']`

## Defined types

### `systemd::dropin_file`

Creates a drop-in file for a systemd unit

* **See also**
  * systemd.unit(5)

#### Parameters

The following parameters are available in the `systemd::dropin_file` defined type.

##### `unit`

Data type: `Systemd::Unit`



##### `filename`

Data type: `Systemd::Dropin`



Default value: `$name`

##### `ensure`

Data type: `Enum['present', 'absent', 'file']`



Default value: `'present'`

##### `path`

Data type: `Stdlib::Absolutepath`



Default value: `'/etc/systemd/system'`

##### `selinux_ignore_defaults`

Data type: `Optional[Boolean]`



Default value: ``false``

##### `content`

Data type: `Optional[Variant[String,Sensitive[String]]]`



Default value: ``undef``

##### `source`

Data type: `Optional[String]`



Default value: ``undef``

##### `target`

Data type: `Optional[Stdlib::Absolutepath]`



Default value: ``undef``

##### `owner`

Data type: `String`



Default value: `'root'`

##### `group`

Data type: `String`



Default value: `'root'`

##### `mode`

Data type: `String`



Default value: `'0444'`

##### `show_diff`

Data type: `Boolean`



Default value: ``true``

##### `daemon_reload`

Data type: `Enum['lazy', 'eager']`



Default value: `'lazy'`

### `systemd::network`

-- Define: systemd::network
Creates network config for systemd-networkd

#### Parameters

The following parameters are available in the `systemd::network` defined type.

##### `ensure`

Data type: `Enum['file', 'absent']`



Default value: `file`

##### `path`

Data type: `Stdlib::Absolutepath`



Default value: `'/etc/systemd/network'`

##### `content`

Data type: `Optional[String]`



Default value: ``undef``

##### `source`

Data type: `Optional[String]`



Default value: ``undef``

##### `target`

Data type: `Optional[Stdlib::Absolutepath]`



Default value: ``undef``

##### `owner`

Data type: `String`



Default value: `'root'`

##### `group`

Data type: `String`



Default value: `'root'`

##### `mode`

Data type: `String`



Default value: `'0444'`

##### `show_diff`

Data type: `Boolean`



Default value: ``true``

##### `restart_service`

Data type: `Boolean`



Default value: ``true``

### `systemd::service_limits`

Adds a set of custom limits to the service

 * Mutually exclusive with ``$limits``

* **See also**
  * systemd.exec(5)

#### Parameters

The following parameters are available in the `systemd::service_limits` defined type.

##### `$ensure`

Whether to drop a file or remove it

##### `path`

Data type: `Stdlib::Absolutepath`

The path to the main systemd settings directory

Default value: `'/etc/systemd/system'`

##### `selinux_ignore_defaults`

Data type: `Optional[Boolean]`

If Puppet should ignore the default SELinux labels.

Default value: ``false``

##### `limits`

Data type: `Optional[Systemd::ServiceLimits]`

A Hash of service limits matching the settings in ``systemd.exec(5)``

* Mutually exclusive with ``$source``

Default value: ``undef``

##### `source`

Data type: `Optional[String]`

A ``File`` resource compatible ``source``

Default value: ``undef``

##### `restart_service`

Data type: `Boolean`

Restart the managed service after setting the limits

Default value: ``true``

##### `ensure`

Data type: `Enum['present', 'absent', 'file']`



Default value: `'present'`

### `systemd::timer`

Create a timer and optionally a service unit to execute with the timer unit

* **See also**
  * https://www.freedesktop.org/software/systemd/man/systemd.timer.html
    * systemd.timer(5)

#### Parameters

The following parameters are available in the `systemd::timer` defined type.

##### `name`

Data type: `Pattern['^.+\.timer$]`

The target of the timer unit to create

##### `path`

Data type: `Stdlib::Absolutepath`

The main systemd configuration path

Default value: `'/etc/systemd/system'`

##### `timer_content`

Data type: `Optional[String[1]]`

The full content of the timer unit file

* Mutually exclusive with ``$timer_source``

Default value: ``undef``

##### `timer_source`

Data type: `Optional[String[1]]`

The ``File`` resource compatible ``source``

* Mutually exclusive with ``$timer_content``

Default value: ``undef``

##### `service_content`

Data type: `Optional[String[1]]`

The full content of the service unit file

* Mutually exclusive with ``$service_source``

Default value: ``undef``

##### `service_source`

Data type: `Optional[String[1]]`

The ``File`` resource compatible ``source``

* Mutually exclusive with ``$service_content``

Default value: ``undef``

##### `owner`

Data type: `String[1]`

The owner to set on the dropin file

Default value: `'root'`

##### `group`

Data type: `String[1]`

The group to set on the dropin file

Default value: `'root'`

##### `mode`

Data type: `Stdlib::Filemode`

The mode to set on the dropin file

Default value: `'0444'`

##### `show_diff`

Data type: `Boolean`

Whether to show the diff when updating dropin file

Default value: ``true``

##### `service_unit`

Data type: `Optional[Systemd::Unit]`

If set then the service_unit will have this name.
If not set the service unit has the same name
as the timer unit with s/.timer/.service/

Default value: ``undef``

##### `active`

Data type: `Optional[Boolean]`

If set to true or false the timer service will be maintained.
If true the timer service will be running and enabled, if false it will
explictly stopped and disabled.

Default value: ``undef``

##### `enable`

Data type: `Optional[Variant[Boolean, Enum['mask']]]`

If set, will manage the state of the unit.

Default value: ``undef``

##### `ensure`

Data type: `Enum['present', 'absent', 'file']`



Default value: `'present'`

### `systemd::tmpfile`

Creates a systemd tmpfile

 * Mutually exclusive with ``$limits``

* **See also**
  * systemd-tmpfiles(8)

#### Parameters

The following parameters are available in the `systemd::tmpfile` defined type.

##### `$ensure`

Whether to drop a file or remove it

##### `path`

Data type: `Stdlib::Absolutepath`

The path to the main systemd tmpfiles directory

Default value: `'/etc/tmpfiles.d'`

##### `content`

Data type: `Optional[String]`

The literal content to write to the file

* Mutually exclusive with ``$source``

Default value: ``undef``

##### `source`

Data type: `Optional[String]`

A ``File`` resource compatible ``source``

Default value: ``undef``

##### `ensure`

Data type: `Enum['present', 'absent', 'file']`



Default value: `'file'`

##### `filename`

Data type: `Systemd::Dropin`



Default value: `$name`

### `systemd::unit_file`

Creates a systemd unit file

* **See also**
  * systemd.unit(5)

#### Parameters

The following parameters are available in the `systemd::unit_file` defined type.

##### `name`

Data type: `Pattern['^[^/]+\.(service|socket|device|mount|automount|swap|target|path|timer|slice|scope)$']`

The target unit file to create

##### `ensure`

Data type: `Enum['present', 'absent', 'file']`

The state of the unit file to ensure

Default value: `'present'`

##### `path`

Data type: `Stdlib::Absolutepath`

The main systemd configuration path

Default value: `'/etc/systemd/system'`

##### `content`

Data type: `Optional[String]`

The full content of the unit file

* Mutually exclusive with ``$source``

Default value: ``undef``

##### `source`

Data type: `Optional[String]`

The ``File`` resource compatible ``source``

* Mutually exclusive with ``$content``

Default value: ``undef``

##### `target`

Data type: `Optional[Stdlib::Absolutepath]`

If set, will force the file to be a symlink to the given target

* Mutually exclusive with both ``$source`` and ``$content``

Default value: ``undef``

##### `owner`

Data type: `String`

The owner to set on the unit file

Default value: `'root'`

##### `group`

Data type: `String`

The group to set on the unit file

Default value: `'root'`

##### `mode`

Data type: `String`

The mode to set on the unit file

Default value: `'0444'`

##### `show_diff`

Data type: `Boolean`

Whether to show the diff when updating unit file

Default value: ``true``

##### `enable`

Data type: `Optional[Variant[Boolean, Enum['mask']]]`

If set, will manage the unit enablement status.

Default value: ``undef``

##### `active`

Data type: `Optional[Boolean]`

If set, will manage the state of the unit.

Default value: ``undef``

## Resource types

### `loginctl_user`

An arbitrary name used as the identity of the resource.

#### Properties

The following properties are available in the `loginctl_user` type.

##### `linger`

Valid values: `enabled`, `disabled`

Whether linger is enabled for the user.

Default value: `disabled`

#### Parameters

The following parameters are available in the `loginctl_user` type.

##### `name`

namevar

An arbitrary name used as the identity of the resource.

##### `provider`

The specific backend to use for this `loginctl_user` resource. You will seldom need to specify this --- Puppet will
usually discover the appropriate provider for your platform.

## Data types

### `Systemd::Dropin`

The Systemd::Dropin data type.

Alias of `Pattern['^[^/]+\.conf$']`

### `Systemd::JournaldSettings`

Matches Systemd journald config Struct

Alias of `Struct[{
    Optional['Storage']              => Variant[Enum['volatile','persistent','auto','none'],Systemd::JournaldSettings::Ensure],
    Optional['Compress']             => Variant[Enum['yes','no'], Pattern[/^[0-9]+(K|M|G)?$/],Systemd::JournaldSettings::Ensure],
    Optional['Seal']                 => Variant[Enum['yes','no'],Systemd::JournaldSettings::Ensure],
    Optional['SplitMode']            => Variant[Enum['uid','none'],Systemd::JournaldSettings::Ensure],
    Optional['RateLimitInterval']    => Variant[Pattern[/^[0-9]+(s|min|h|ms|us)?$/],Systemd::JournaldSettings::Ensure],
    Optional['RateLimitIntervalSec'] => Variant[Pattern[/^[0-9]+(s|min|h|ms|us)?$/],Systemd::JournaldSettings::Ensure],
    Optional['RateLimitBurst']       => Variant[Integer[0], Pattern[/^[0-9]+$/],Systemd::JournaldSettings::Ensure],
    Optional['SystemMaxUse']         => Variant[Pattern[/^[0-9]+(K|M|G|T|P|E)?$/],Systemd::JournaldSettings::Ensure],
    Optional['SystemKeepFree']       => Variant[Pattern[/^[0-9]+(K|M|G|T|P|E)?$/],Systemd::JournaldSettings::Ensure],
    Optional['SystemMaxFileSize']    => Variant[Pattern[/^[0-9]+(K|M|G|T|P|E)?$/],Systemd::JournaldSettings::Ensure],
    Optional['SystemMaxFiles']       => Variant[Integer[0], Pattern[/^[0-9]+$/],Systemd::JournaldSettings::Ensure],
    Optional['RuntimeMaxUse']        => Variant[Pattern[/^[0-9]+(K|M|G|T|P|E)?$/],Systemd::JournaldSettings::Ensure],
    Optional['RuntimeKeepFree']      => Variant[Pattern[/^[0-9]+(K|M|G|T|P|E)?$/],Systemd::JournaldSettings::Ensure],
    Optional['RuntimeMaxFileSize']   => Variant[Pattern[/^[0-9]+(K|M|G|T|P|E)?$/],Systemd::JournaldSettings::Ensure],
    Optional['RuntimeMaxFiles']      => Variant[Integer[0], Pattern[/^[0-9]+$/],Systemd::JournaldSettings::Ensure],
    Optional['MaxFileSec']           => Variant[Pattern[/^[0-9]+(year|month|week|day|h|m)?$/],Systemd::JournaldSettings::Ensure],
    Optional['MaxRetentionSec']      => Variant[Pattern[/^[0-9]+(year|month|week|day|h|m)?$/],Systemd::JournaldSettings::Ensure],
    Optional['SyncIntervalSec']      => Variant[Pattern[/^[0-9]+(year|month|week|day|h|m)?$/],Systemd::JournaldSettings::Ensure],
    Optional['ForwardToSyslog']      => Variant[Enum['yes','no'],Systemd::JournaldSettings::Ensure],
    Optional['ForwardToKMsg']        => Variant[Enum['yes','no'],Systemd::JournaldSettings::Ensure],
    Optional['ForwardToConsole']     => Variant[Enum['yes','no'],Systemd::JournaldSettings::Ensure],
    Optional['ForwardToWall']        => Variant[Enum['yes','no'],Systemd::JournaldSettings::Ensure],
    Optional['MaxLevelStore']        => Variant[Enum['emerg','alert','crit','err','warning','notice','info','debug'],Integer[0,7],Systemd::JournaldSettings::Ensure],
    Optional['MaxLevelSyslog']       => Variant[Enum['emerg','alert','crit','err','warning','notice','info','debug'],Integer[0,7],Systemd::JournaldSettings::Ensure],
    Optional['MaxLevelKMsg']         => Variant[Enum['emerg','alert','crit','err','warning','notice','info','debug'],Integer[0,7],Systemd::JournaldSettings::Ensure],
    Optional['MaxLevelConsole']      => Variant[Enum['emerg','alert','crit','err','warning','notice','info','debug'],Integer[0,7],Systemd::JournaldSettings::Ensure],
    Optional['MaxLevelWall']         => Variant[Enum['emerg','alert','crit','err','warning','notice','info','debug'],Integer[0,7],Systemd::JournaldSettings::Ensure],
    Optional['ReadKMsg']             => Variant[Enum['yes','no'],Systemd::JournaldSettings::Ensure],
    Optional['TTYPath']              => Variant[Stdlib::Absolutepath,Systemd::JournaldSettings::Ensure],
    Optional['LineMax']              => Variant[Pattern[/^[0-9]+(K|M|G|T)?$/],Systemd::JournaldSettings::Ensure],
  }]`

### `Systemd::JournaldSettings::Ensure`

The Systemd::JournaldSettings::Ensure data type.

Alias of `Struct[{ 'ensure' => Enum['present','absent'] }]`

### `Systemd::LogindSettings`

Matches Systemd Login Manager Struct

Alias of `Struct[{
    Optional['HandleHibernateKey']           => Variant[Enum['ignore','poweroff','reboot','halt','kexec','suspend','hibernate','hybrid-sleep','suspend-then-hibernate','lock'],Systemd::LogindSettings::Ensure],
    Optional['HandleLidSwitch']              => Variant[Enum['ignore','poweroff','reboot','halt','kexec','suspend','hibernate','hybrid-sleep','suspend-then-hibernate','lock'],Systemd::LogindSettings::Ensure],
    Optional['HandleLidSwitchDocked']        => Variant[Enum['ignore','poweroff','reboot','halt','kexec','suspend','hibernate','hybrid-sleep','suspend-then-hibernate','lock'],Systemd::LogindSettings::Ensure],
    Optional['HandleLidSwitchExternalPower'] => Variant[Enum['ignore','poweroff','reboot','halt','kexec','suspend','hibernate','hybrid-sleep','suspend-then-hibernate','lock'],Systemd::LogindSettings::Ensure],
    Optional['HandlePowerKey']               => Variant[Enum['ignore','poweroff','reboot','halt','kexec','suspend','hibernate','hybrid-sleep','suspend-then-hibernate','lock'],Systemd::LogindSettings::Ensure],
    Optional['HandleSuspendKey']             => Variant[Enum['ignore','poweroff','reboot','halt','kexec','suspend','hibernate','hybrid-sleep','suspend-then-hibernate','lock'],Systemd::LogindSettings::Ensure],
    Optional['HibernateKeyIgnoreInhibited']  => Variant[Enum['yes','no'],Systemd::LogindSettings::Ensure],
    Optional['HoldoffTimeoutSec']            => Variant[Integer,Systemd::LogindSettings::Ensure],
    Optional['IdleAction']                   => Variant[Enum['ignore','poweroff','reboot','halt','kexec','suspend','hibernate','hybrid-sleep','suspend-then-hibernate','lock'],Systemd::LogindSettings::Ensure],
    Optional['IdleActionSec']                => Variant[Integer,Systemd::LogindSettings::Ensure],
    Optional['InhibitDelayMaxSec']           => Variant[Integer,Systemd::LogindSettings::Ensure],
    Optional['InhibitorsMax']                => Variant[Integer,Systemd::LogindSettings::Ensure],
    Optional['KillExcludeUsers']             => Variant[Array[String],Systemd::LogindSettings::Ensure],
    Optional['KillOnlyUsers']                => Variant[Array[String],Systemd::LogindSettings::Ensure],
    Optional['KillUserProcesses']            => Variant[Enum['yes','no'],Systemd::LogindSettings::Ensure],
    Optional['LidSwitchIgnoreInhibited']     => Variant[Enum['yes','no'],Systemd::LogindSettings::Ensure],
    Optional['NAutoVTs']                     => Variant[Integer,Systemd::LogindSettings::Ensure],
    Optional['PowerKeyIgnoreInhibited']      => Variant[Enum['yes','no'],Systemd::LogindSettings::Ensure],
    Optional['RemoveIPC']                    => Variant[Enum['yes','no'],Systemd::LogindSettings::Ensure],
    Optional['ReserveVT']                    => Variant[Integer,Systemd::LogindSettings::Ensure],
    Optional['RuntimeDirectorySize']         => Variant[Integer,Pattern['^(\d+(K|M|G|T|P|E|%)?)$'],Systemd::LogindSettings::Ensure],
    Optional['SessionsMax']                  => Variant[Integer,Pattern['^(infinity|(\d+(K|M|G|T|P|E|%)?))$'],Systemd::LogindSettings::Ensure],
    Optional['SuspendKeyIgnoreInhibited']    => Variant[Enum['yes','no'],Systemd::LogindSettings::Ensure],
    Optional['UserTasksMax']                 => Variant[Integer,Pattern['^(infinity|(\d+(K|M|G|T|P|E|%)?))$'],Systemd::LogindSettings::Ensure]
  }]`

### `Systemd::LogindSettings::Ensure`

The Systemd::LogindSettings::Ensure data type.

Alias of `Struct[{ 'ensure' => Enum['present','absent'] }]`

### `Systemd::ServiceLimits`

Matches Systemd Service Limit Struct

Alias of `Struct[{
    Optional['LimitCPU']            => Pattern['^\d+(s|m|h|d|w|M|y)?(:\d+(s|m|h|d|w|M|y)?)?$'],
    Optional['LimitFSIZE']          => Pattern['^(infinity|((\d+(K|M|G|T|P|E)(:\d+(K|M|G|T|P|E))?)))$'],
    Optional['LimitDATA']           => Pattern['^(infinity|((\d+(K|M|G|T|P|E)(:\d+(K|M|G|T|P|E))?)))$'],
    Optional['LimitSTACK']          => Pattern['^(infinity|((\d+(K|M|G|T|P|E)(:\d+(K|M|G|T|P|E))?)))$'],
    Optional['LimitCORE']           => Pattern['^(infinity|((\d+(K|M|G|T|P|E)(:\d+(K|M|G|T|P|E))?)))$'],
    Optional['LimitRSS']            => Pattern['^(infinity|((\d+(K|M|G|T|P|E)(:\d+(K|M|G|T|P|E))?)))$'],
    Optional['LimitNOFILE']         => Variant[Integer[-1],Pattern['^(infinity|\d+(:(infinity|\d+))?)$']],
    Optional['LimitAS']             => Pattern['^(infinity|((\d+(K|M|G|T|P|E)(:\d+(K|M|G|T|P|E))?)))$'],
    Optional['LimitNPROC']          => Integer[1],
    Optional['LimitMEMLOCK']        => Pattern['^(infinity|((\d+(K|M|G|T|P|E)(:\d+(K|M|G|T|P|E))?)))$'],
    Optional['LimitLOCKS']          => Integer[1],
    Optional['LimitSIGPENDING']     => Integer[1],
    Optional['LimitMSGQUEUE']       => Pattern['^(infinity|((\d+(K|M|G|T|P|E)(:\d+(K|M|G|T|P|E))?)))$'],
    Optional['LimitNICE']           => Variant[Integer[0,40], Pattern['^(-\+([0-1]?[0-9]|20))|([0-3]?[0-9]|40)$']],
    Optional['LimitRTPRIO']         => Integer[0],
    Optional['LimitRTTIME']         => Pattern['^\d+(ms|s|m|h|d|w|M|y)?(:\d+(ms|s|m|h|d|w|M|y)?)?$'],
    Optional['CPUAccounting']       => Boolean,
    Optional['CPUShares']           => Integer[2,262144],
    Optional['StartupCPUShares']    => Integer[2,262144],
    Optional['CPUQuota']            => Pattern['^([1-9][0-9]*)%$'],
    Optional['MemoryAccounting']    => Boolean,
    Optional['MemoryLow']           => Pattern['^(\d+(K|M|G|T)?)$'],
    Optional['MemoryHigh']          => Pattern['^(\d+(K|M|G|T)?)$'],
    Optional['MemoryMax']           => Pattern['^(\d+(K|M|G|T)?)$'],
    Optional['MemoryLimit']         => Pattern['^(\d+(K|M|G|T)?)$'],
    Optional['TasksAccounting']     => Boolean,
    Optional['TasksMax']            => Variant[Integer[1],Pattern['^(infinity|([1-9][0-9]?$|^100)%)$']],
    Optional['IOAccounting']        => Boolean,
    Optional['IOWeight']            => Integer[1,10000],
    Optional['StartupIOWeight']     => Integer[1,10000],
    Optional['IODeviceWeight']      => Array[Hash[Stdlib::Absolutepath, Integer[1,10000], 1, 1]],
    Optional['IOReadBandwidthMax']  => Array[Hash[Stdlib::Absolutepath, Pattern['^(\d+(K|M|G|T)?)$'], 1, 1]],
    Optional['IOWriteBandwidthMax'] => Array[Hash[Stdlib::Absolutepath, Pattern['^(\d+(K|M|G|T)?)$'], 1, 1]],
    Optional['IOReadIOPSMax']       => Array[Hash[Stdlib::Absolutepath, Pattern['^(\d+(K|M|G|T)?)$'], 1, 1]],
    Optional['IOWriteIOPSMax']      => Array[Hash[Stdlib::Absolutepath, Pattern['^(\d+(K|M|G|T)?)$'], 1, 1]],
    Optional['DeviceAllow']         => String[1],
    Optional['DevicePolicy']        => Enum['auto','closed','strict'],
    Optional['Slice']               => String[1],
    Optional['Delegate']            => Boolean,
    Optional['OOMScoreAdjust']      => Integer[-1000,1000]
  }]`

### `Systemd::Unit`

The Systemd::Unit data type.

Alias of `Pattern['^[^/]+\.(service|socket|device|mount|automount|swap|target|path|timer|slice|scope)$']`

