/*
 * Plasma applet to display indicators from libindicate
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: GPL v3
 */
// Self
#include "filtermodeltest.h"

// Qt
#include <QtTest>

// KDE
#include <qtest_kde.h>
#include <KDebug>

// libindicate-qt
#include <qindicatelistener.h>
#include <qindicateindicator.h>
#include <qindicateserver.h>

const QString SERVER_TYPE = "message";
const QString APP_NAME = "An application using libindicate";

QTEST_KDEMAIN(FilterModelTest, GUI)

void FilterModelTest::init()
{
    mServer = QIndicate::Server::defaultInstance();
    const QString desktopFile = KDESRCDIR "test.desktop";

    mServer->setType(SERVER_TYPE);
    mServer->setDesktopFile(desktopFile);
}

void FilterModelTest::cleanup()
{
    delete mServer;
    mServer = 0;
}

void FilterModelTest::testFilter()
{
    // Show server
    mServer->show();

    // Show an indicator
    QIndicate::Indicator indicator;
    indicator.setIndicatorProperty("name", "John Doe");
    indicator.show();
    QTest::qWait(500);

    QModelIndex serverIndex;
    QIndicate::Listener listener;

    // FIXME: ListenerModel can't list servers or indicators which have already
    // been received by Listener, so this does not work for now
    #if 0
    // Create a ListenerModel with a wrong server type
    ListenerModel listenerModel1(&listener, QRegExp("^foo"));

    // We should not find any index
    QTest::qWait(500);
    serverIndex = listenerModel1.index(0, 0);
    QVERIFY(!serverIndex.isValid());
    #endif

    // Create a ListenerModel with the correct server type
    ListenerModel listenerModel2(&listener, QRegExp('^' + SERVER_TYPE));

    // We should see the server and its indicator now
    QTest::qWait(500);
    serverIndex = listenerModel2.index(0, 0);
    QVERIFY(serverIndex.isValid());

    QVERIFY(listenerModel2.hasChildren(serverIndex));
    QModelIndex indicatorIndex = listenerModel2.index(0, 0, serverIndex);

    QCOMPARE(indicatorIndex.data().toString(), QString("John Doe"));

    indicator.setIndicatorProperty("name", "Bruce Wayne");
    QTest::qWait(500);

    QCOMPARE(indicatorIndex.data().toString(), QString("Bruce Wayne"));
}

#include "filtermodeltest.moc"
