<?php

namespace AsyncAws\Core\Sts\ValueObject;

use AsyncAws\Core\Exception\InvalidArgument;

/**
 * The identifiers for the temporary security credentials that the operation returns.
 */
final class AssumedRoleUser
{
    /**
     * A unique identifier that contains the role ID and the role session name of the role that is being assumed. The role
     * ID is generated by Amazon Web Services when the role is created.
     *
     * @var string
     */
    private $assumedRoleId;

    /**
     * The ARN of the temporary security credentials that are returned from the AssumeRole action. For more information
     * about ARNs and how to use them in policies, see IAM Identifiers [^1] in the *IAM User Guide*.
     *
     * [^1]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html
     *
     * @var string
     */
    private $arn;

    /**
     * @param array{
     *   AssumedRoleId: string,
     *   Arn: string,
     * } $input
     */
    public function __construct(array $input)
    {
        $this->assumedRoleId = $input['AssumedRoleId'] ?? $this->throwException(new InvalidArgument('Missing required field "AssumedRoleId".'));
        $this->arn = $input['Arn'] ?? $this->throwException(new InvalidArgument('Missing required field "Arn".'));
    }

    /**
     * @param array{
     *   AssumedRoleId: string,
     *   Arn: string,
     * }|AssumedRoleUser $input
     */
    public static function create($input): self
    {
        return $input instanceof self ? $input : new self($input);
    }

    public function getArn(): string
    {
        return $this->arn;
    }

    public function getAssumedRoleId(): string
    {
        return $this->assumedRoleId;
    }

    /**
     * @return never
     */
    private function throwException(\Throwable $exception)
    {
        throw $exception;
    }
}
