#!/bin/sh 

# called with '--upstream-version' <version>
VERSION=$2
TAR=../osgi-compendium_$VERSION.orig.tar.gz
DIR=osgi-compendium-$VERSION
TAG=42

wget -O osgi.compendium.jar --no-check-certificate https://github.com/bndtools/bnd/raw/master/cnf/repo/osgi.cmpn/osgi.cmpn-4.3.0.jar
# http://www.osgi.org/download/r4v$TAG/osgi.cmpn.jar

mkdir -p $DIR/src/
(cd $DIR && jar xvf ../osgi.compendium.jar)

rm -r $DIR/org $DIR/info
mv $DIR/OSGI-OPT/src/* $DIR/src/
mv $DIR/xmlns $DIR/src/
mv $DIR/OSGI-OPT/*.bnd $DIR/src/
mv $DIR/META-INF $DIR/src/
rm -r $DIR/OSGI-OPT

GZIP=--best tar -c -z -f $TAR --exclude '*.jar' --exclude '*.class' $DIR
rm -rf $DIR osgi.compendium.jar
