###############################################################################
# OpenVAS Vulnerability Test
# $Id: quicksilver_forums_32452.nasl 8287 2010-07-05 10:40:56Z mime $
#
# Quicksilver Forums Local File Include and Arbitrary File Upload Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100504);
 script_tag(name:"cvss_base", value:"7.5");
 script_cve_id("CVE-2008-7064");
 script_bugtraq_id(32452);
 script_version ("1.0-$Revision: 8287 $");
 script_tag(name:"risk_factor", value:"High");

 script_name("Quicksilver Forums Local File Include and Arbitrary File Upload Vulnerabilities");

desc = "Overview:
Quicksilver Forums is prone to a local file-include vulnerability and
an arbitrary-file-upload vulnerability because the application fails
to sufficiently sanitize user-supplied input.

An attacker can exploit these issues to upload arbitrary files onto
the webserver, execute arbitrary local files within the context of the
webserver, and obtain sensitive information. By exploiting the arbitrary-file-
upload and local file-include vulnerabilities at the same time, the
attacker may be able to execute remote code.

Quicksilver Forums 1.4.2 is vulnerable; other versions may also be
affected. Note that these issues affect only versions running on
Windows platforms.

Solution:
Updates are available. Please see the references for more information.

References:
http://www.securityfocus.com/bid/32452
http://pdnsadmin.iguanadons.net/index.php?a=newspost&t=85
http://www.quicksilverforums.com/

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Quicksilver Forums version is <= 1.4.2");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("os_fingerprint.nasl","quicksilver_forums_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

os = get_kb_item("Host/OS/ICMP");
if ("windows" >!< tolower(os))exit(0);

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/quicksilver")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less_equal(version: vers, test_version: "1.4.2")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
