###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for emacs22 vulnerability USN-541-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840051);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.3");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "541-1");
  script_cve_id("CVE-2007-5795");
  script_name( "Ubuntu Update for emacs22 vulnerability USN-541-1");
  desc = "

  Vulnerability Insight:

  Drake Wilson discovered that Emacs did not correctly handle the safe
  mode of &quot;enable-local-variables&quot;. If a user were tricked into opening
  a specially crafted file while &quot;enable-local-variables&quot; was set to the
  non-default &quot;:safe&quot;, a remote attacker could execute arbitrary commands
  with the user's privileges.

  Affected Software/OS:
  emacs22 vulnerability on Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-November/000621.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of emacs22 vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"emacs22-bin-common", ver:"22.1-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"emacs22-nox", ver:"22.1-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"emacs22", ver:"22.1-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"emacs22-gtk", ver:"22.1-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"emacs22-common", ver:"22.1-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"emacs22-el", ver:"22.1-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"emacs", ver:"22.1-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}