###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_symantec_altiris_ns_unauth_access_vuln.nasl 7083 2010-02-11 13:09:24Z feb $
#
# Symantec Altiris NS Key Unauthorized Access Vulnerability
#
# Authors:
# Rachana Shetty <srachana@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800985);
  script_version("$Revision: 7664 $: 1.0");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-3035");
  script_bugtraq_id(37953);
  script_name("Symantec Altiris NS Key Unauthorized Access Vulnerability");
  desc = "
  Overview: This host is installed with Symantec Altiris Notification Server
  and is prone to unauthorized access vulnerability.

  Vulnerability Insight:
  The flaw is caused due to the application using a static encryption key to
  encrypt and store certain credentials.

  Impact:
  Successful exploitation let attackers to access certain encrypted credentials
  and encryption keys and also execute code, obtain sensitive information, or
  perform actions with elevated privileges.

  Impact Level: Application

  Affected Software/OS:
  Symantec Altiris Notification Server versions 6.0.x before 6.0 SP3 R12

  Fix: Update to Symantec Altiris Notification Server 6.0 SP3 R12
  For Updates Refer, https://kb.altiris.com/article.asp?article=46763&p=1

  References:
  http://secunia.com/advisories/38356
  http://xforce.iss.net/xforce/xfdb/55952
  http://www.symantec.com/business/security_response/securityupdates/detail.jsp?fid=security_advisory&pvid=security_advisory&year=2010&suid=20100128_00

  CVSS Score:
    CVSS Base Score      : 4.3 (AV:L/AC:L/Au:SI/C:P/I:P/A:P)
    CVSS Temporal Score  : 3.3
  Risk factor :Medium";

  script_description(desc);
  script_summary("Check for the version of Symantec Altiris Notification Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("General");
  script_dependencies("gb_symantec_altiris_ns_detect.nasl");
  script_require_keys("Symantec/AltirisNS/Ver", "Symantec/AltirisNS/SP");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");
include("http_keepalive.inc");

httpPort = get_http_port(default:80);
if(!httpPort){
  exit(0);
}

## Send Request and Receive Response
sndReq = http_get(item:"/Altiris/NS/logview.asp", port:httpPort);
rcvRes = http_keepalive_send_recv(port:httpPort, data:sndReq, bodyonly:0);
if((isnull(rcvRes)) && ("Altiris NS " >!< rcvRes)){
  exit(0);
}

altirisVer = get_kb_item("Symantec/AltirisNS/Ver");
if(!altirisVer){
  exit(0);
}

spVer= get_kb_item("Symantec/AltirisNS/SP");
if((spVer == NULL) && (altirisVer =~ "^6\.0"))
{
  # Grep for Altiris version prior to 6.0(6.0.6074)
  if(version_is_less_equal(version:altirisVer, test_version:"6.0.6074"))
  {
    security_warning(0);
    exit(0);
  }
}

else if(spVer =~ "^6\.0")
{
  # Grep for Altiris 6.0 SP prior to 6.0 SP3 R12(6.0.1210.0)
  if(version_is_less(version:spVer, test_version:"6.0.1210.0")){
    security_warning(0);
  }
}
