###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_opera_js_uri_xss_vuln_sep09_lin.nasl 4414 2009-09-03 21:06:26Z sep $
#
# Opera 'javascript: URI' XSS Vulnerability - Sep0 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800882);
  script_version("$Revision: 7922 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-3013");
  script_name("Opera 'javascript: URI' XSS Vulnerability - Sep09 (Linux)");
  desc = "
  Overview: This host is installed with Opera Web Browser and is prone to
  Cross-Site Scripting vulnerability.

  Vulnerability Insight:
  Error occurs when application fails to sanitise the 'javascript:' and 'data:'
  URIs in Location headers in HTTP responses, which can be exploited via vectors
  related to injecting a Location header.

  Impact:
  Successful exploitation will let the attackers to conduct Cross-Site Scripting
  attacks in the victim's system.

  Impact Level: Application

  Affected Software/OS:
  Opera version 9.52 and prior and 10.00 Beta 3 Build 1699 on Linux.

  Fix: Upgrade to Opera version 9.64 or later and 10.10 or later.
  For updates refer, http://www.opera.com/

  References:
  http://websecurity.com.ua/3386/

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Opera Web Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_opera_detection_linux_900037.nasl");
  script_require_keys("Opera/Build/Linux/Ver");
  exit(0);
}


include("version_func.inc");

operaVer = get_kb_item("Opera/Build/Linux/Ver");
if(isnull(operaVer))
{
  exit(0);
}

# Check for Opera Version <= 9.52 (9.52.2091)
#                    and 10.00 Beta 3 Build 1699 (10.00.1699)
if(version_is_less_equal(version:operaVer, test_version:"9.52.2091")||
   version_is_equal(version:operaVer, test_version:"10.00.1699")){
  security_warning(0);
}
