#
#ADV FreeBSD-SA-06:14.fpu.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#
                                                                                
if(description)
{
 script_id(56578);
 script_bugtraq_id(17600);
 script_cve_id("CVE-2006-1056");
 script_version ("$");
 script_tag(name:"cvss_base", value:"2.1");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Security Advisory (FreeBSD-SA-06:14.fpu.asc)";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-06:14.fpu.asc

The floating-point unit (FPU) of i386 and amd64 processors is derived from
the original 8087 floating-point co-processor.  As a result, the FPU
contains the same debugging registers FOP, FIP, and FDP which store the
opcode, instruction address, and data address of the instruction most
recently executed by the FPU.

On processors implementing the SSE instruction set, a new pair of
instructions fxsave/fxrstor replaces the earlier fsave/frstor pair used
for saving and restoring the FPU state.  These new instructions also
save and restore the contents of the additional registers used by SSE
instructions.

On 7th generation and 8th generation processors manufactured by AMD,
including the AMD Athlon, Duron, Athlon MP, Athlon XP, Athlon64, Athlon64
FX, Opteron, Turion, and Sempron, the fxsave and fxrstor instructions do
not save and restore the FOP, FIP, and FDP registers unless the exception
summary bit (ES) in the x87 status word is set to 1, indicating that an
unmasked x87 exception has occurred.

This behaviour is consistent with documentation provided by AMD, but is
different from processors from other vendors, which save and restore the
FOP, FIP, and FDP registers regardless of the value of the ES bit.  As a
result of this discrepancy remaining unnoticed until now, the FreeBSD
kernel does not restore the contents of the FOP, FIP, and FDP registers
between context switches.

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-06:14.fpu.asc
Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Security Advisory (FreeBSD-SA-06:14.fpu.asc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"6.0", patchlevel:"7")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"5.4", patchlevel:"14")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"5.3", patchlevel:"29")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"4.11", patchlevel:"17")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"4.10", patchlevel:"23")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
