#
#VID a8d8713e-dc83-11da-a22b-000c6ec775d9
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56714);
 script_cve_id("CVE-2006-1518");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.5");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: mysql-server";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: mysql-server

CVE-2006-1518
Buffer overflow in the open_table function in sql_base.cc in MySQL
5.0.x up to 5.0.20 might allow remote attackers to execute arbitrary
code via crafted COM_TABLE_DUMP packets with invalid length values.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.wisec.it/vulns.php?page=8
http://dev.mysql.com/doc/refman/5.0/en/news-5-0-21.html
http://marc.theaimsgroup.com/?l=bugtraq&m=114659633220473
http://www.vuxml.org/freebsd/a8d8713e-dc83-11da-a22b-000c6ec775d9.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: mysql-server";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"mysql-server");
if(!isnull(bver) && revcomp(a:bver, b:"5.0")>0 && revcomp(a:bver, b:"5.0.21")<0) {
    security_note(0, data:"Package mysql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
