# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-6547 (rb_libtorrent)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64303);
 script_cve_id("CVE-2009-1760");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 10 FEDORA-2009-6547 (rb_libtorrent)";
 script_name(name);

 desc = "The remote host is missing an update to rb_libtorrent
announced via advisory FEDORA-2009-6547.

Its main goals are to be very efficient (in terms of CPU and memory usage) as
well as being very easy to use both as a user and developer.

Update Information:

This release adds an upstream patch to fix a directory traversal vulnerability
which would allow a remote attacker to create or overwrite arbitrary files via a
.. (dot dot) and partial relative pathname in a specially-crafted torrent.

ChangeLog:

* Sun Jun 14 2009 Peter Gordon  - 0.13.1-5
- Apply upstream patch to fix CVE-2009-1760 (arbitrary file overwrite
vulnerability):
+ 0.13-CVE-2009-1760.diff
- Fixes security bug #505523.

References:

[ 1 ] Bug #505523 - CVE-2009-1760 rb_libtorrent: arbitrary file overwrite vulnerability
https://bugzilla.redhat.com/show_bug.cgi?id=505523

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update rb_libtorrent' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-6547

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-6547 (rb_libtorrent)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"rb_libtorrent", rpm:"rb_libtorrent~0.13.1~5.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"rb_libtorrent-devel", rpm:"rb_libtorrent-devel~0.13.1~5.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"rb_libtorrent-python", rpm:"rb_libtorrent-python~0.13.1~5.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"rb_libtorrent-debuginfo", rpm:"rb_libtorrent-debuginfo~0.13.1~5.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
