# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-6366 (firefox)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64230);
 script_cve_id("CVE-2009-1392", "CVE-2009-1832", "CVE-2009-1833", "CVE-2009-1834", "CVE-2009-1835", "CVE-2009-1836", "CVE-2009-1837", "CVE-2009-1838", "CVE-2009-1839", "CVE-2009-1840", "CVE-2009-1841");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Fedora Core 10 FEDORA-2009-6366 (firefox)";
 script_name(name);

 desc = "The remote host is missing an update to firefox
announced via advisory FEDORA-2009-6366.

Update Information:

Update to new upstream Firefox version 3.0.11, fixing multiple security issues
detailed in the upstream advisories:
http://www.mozilla.org/security/known-vulnerabilities/firefox30.html#firefox3.0.11

Update also includes all packages depending on gecko-libs rebuild
against new version of Firefox / XULRunner.

ChangeLog:

* Thu Jun 11 2009 Christopher Aillon  - 3.0.11-1
- Update to 3.0.11
* Mon Apr 27 2009 Jan Horak  - 3.0.10-1
- Update to 3.0.10
* Tue Apr 21 2009 Christopher Aillon  - 3.0.9-1
- Update to 3.0.9
* Fri Mar 27 2009 Christopher Aillon  - 3.0.8-1
- Update to 3.0.8
* Wed Mar  4 2009 Jan Horak  - 3.0.7-1
- Update to 3.0.7
* Thu Feb 26 2009 Jan Horak  - 3.0.6-2
- Fixed spelling mistake in firefox.sh.in
* Wed Feb  4 2009 Christopher Aillon  - 3.0.6-1
- Update to 3.0.6
* Wed Jan  7 2009 Jan Horak  - 3.0.5-2
- Fixed wrong LANG and LC_MESSAGES variables interpretation (#441973)
in startup script.
* Tue Dec 16 2008 Christopher Aillon  3.0.5-1
- Update to 3.0.5
* Thu Nov 13 2008 Jan Horak  3.0.4-2
- Removed firefox-2.0-getstartpage.patch patch
- Start page is set by different way

References:

[ 1 ] Bug #503568 - CVE-2009-1392 Firefox browser engine crashes
https://bugzilla.redhat.com/show_bug.cgi?id=503568
[ 2 ] Bug #503569 - CVE-2009-1832 Firefox double frame construction flaw
https://bugzilla.redhat.com/show_bug.cgi?id=503569
[ 3 ] Bug #503570 - CVE-2009-1833 Firefox JavaScript engine crashes
https://bugzilla.redhat.com/show_bug.cgi?id=503570
[ 4 ] Bug #503573 - CVE-2009-1834 Firefox URL spoofing with invalid unicode characters
https://bugzilla.redhat.com/show_bug.cgi?id=503573
[ 5 ] Bug #503576 - CVE-2009-1835 Firefox Arbitrary domain cookie access by local file: resources
https://bugzilla.redhat.com/show_bug.cgi?id=503576
[ 6 ] Bug #503578 - CVE-2009-1836 Firefox SSL tampering via non-200 responses to proxy CONNECT requests
https://bugzilla.redhat.com/show_bug.cgi?id=503578
[ 7 ] Bug #503579 - CVE-2009-1837 Firefox Race condition while accessing the private data of a NPObject JS wrapper class object
https://bugzilla.redhat.com/show_bug.cgi?id=503579
[ 8 ] Bug #503580 - CVE-2009-1838 Firefox arbitrary code execution flaw
https://bugzilla.redhat.com/show_bug.cgi?id=503580
[ 9 ] Bug #503581 - CVE-2009-1839 Firefox information disclosure flaw
https://bugzilla.redhat.com/show_bug.cgi?id=503581
[ 10 ] Bug #503582 - CVE-2009-1840 Firefox XUL scripts skip some security checks
https://bugzilla.redhat.com/show_bug.cgi?id=503582
[ 11 ] Bug #503583 - CVE-2009-1841 Firefox JavaScript arbitrary code execution
https://bugzilla.redhat.com/show_bug.cgi?id=503583

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update firefox' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-6366

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-6366 (firefox)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"firefox", rpm:"firefox~3.0.11~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-debuginfo", rpm:"firefox-debuginfo~3.0.11~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
