# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 617-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53301);
 script_bugtraq_id(12075);
 script_cve_id("CVE-2004-1308");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 617-1 (tiff)";
 script_name(name);

 desc = "The remote host is missing an update to tiff
announced via advisory DSA 617-1.

infamous41md discovered a problem in libtiff, the Tag Image File
Format library for processing TIFF graphics files.  Upon reading a
TIFF file it is possible to allocate a zero sized buffer and write to
it which would lead to the execution of arbitrary code.

For the stable distribution (woody) this problem has been fixed in
version 3.5.5-6woody2.

For the unstable distribution (sid) this problem has been fixed in
version 3.6.1-4.

We recommend that you upgrade your libtiff packages immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20617-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 617-1 (tiff)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libtiff-tools", ver:"3.5.5-6.woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff3g", ver:"3.5.5-6.woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff3g-dev", ver:"3.5.5-6.woody3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
