# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1301-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58352);
 script_cve_id("CVE-2007-2356");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1301-1 (gimp)";
 script_name(name);

 desc = "The remote host is missing an update to gimp
announced via advisory DSA 1301-1.

A buffer overflow has been identified in Gimp's SUNRAS plugin in
versions prior to 2.2.15.  This bug could allow an attacker to execute
arbitrary code on the victim's computer by inducing the victim to open a
specially crafted RAS file.

For the stable distribution (etch), this problem has been fixed in
version 2.2.13-1etch1.

For the old stable distribution (sarge), this problem has been fixed in
version 2.2.6-1sarge2.

For the unstable and testing distributions (sid and lenny,
respectively), this problem has been fixed in version 2.2.14-2.

We recommend that you upgrade your gimp package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201301-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1301-1 (gimp)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libgimp2.0-doc", ver:"2.2.6-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp1.2", ver:"2.2.6-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp-data", ver:"2.2.6-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp-helpbrowser", ver:"2.2.6-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp-svg", ver:"2.2.6-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgimp2.0", ver:"2.2.6-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp", ver:"2.2.6-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp-python", ver:"2.2.6-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgimp2.0-dev", ver:"2.2.6-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgimp2.0-doc", ver:"2.2.13-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp-data", ver:"2.2.13-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp", ver:"2.2.13-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp-python", ver:"2.2.13-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp-svg", ver:"2.2.13-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgimp2.0", ver:"2.2.13-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgimp2.0-dev", ver:"2.2.13-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp-helpbrowser", ver:"2.2.13-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gimp-dbg", ver:"2.2.13-1etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
