##############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# Apache Web Server Configuration File Environment Variable Local
# Buffer Overflow Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(100172);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.6");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2004-0747");
  script_bugtraq_id(11182);
  script_name("Apache Web Server Configuration File Environment Variable Local Buffer Overflow Vulnerability");
  desc = "

  Overview:
   According to its version number, the remote version of Apache Web
   Server is prone to a local buffer-overflow vulnerability that
   affects a configuration file environment variable. This occurs
   because the application fails to validate user-supplied string
   lengths before copying them into finite process buffers.

   An attacker may leverage this issue to execute arbitrary code on
   the affected computer with the privileges of the Apache webserver
   process. 

  Solution:
   The vendor has released an upgrade. Please see
   http://www.apache.org/dist/httpd/Announcement2.html for more
   information.

  See also:
   http://www.securityfocus.com/bid/11182

  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for Apache Web Server version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Web application abuses");
  script_dependencies("http_version.nasl", "secpod_apache_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

httpdPort = get_http_port(default:80);
if(!httpdPort){
  exit(0);
}

version = get_kb_item("www/" + httpdPort + "/Apache");
if(version != NULL){
  if(version_is_less(version:version, test_version:"2.0.51")){
    security_warning(httpdPort);
  }
}
