##############################################################################
# OpenVAS Vulnerability Test
# $Id: apache_CVE_2009_1195.nasl 7189 2010-03-31 13:58:50Z chandra $
#
# Apache 'Options' and 'AllowOverride' Directives Security Bypass
# Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(100211);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.9");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-1195");
  script_bugtraq_id(35115);
  script_name("Apache 'Options' and 'AllowOverride' Directives Security Bypass Vulnerability");
  desc = "
  Overview:
   Apache HTTP server is prone to a security-bypass vulnerability
   related to the handling of specific configuration directives.

   A local attacker may exploit this issue to execute arbitrary code
   within the context of the webserver process. This may result in
   elevated privileges or aid in further attacks.

   Versions prior to Apache 2.2.9 are vulnerable. 

  Solution:
   Updates are available. Please see http://httpd.apache.org/
   for more Information.

  See also:
   http://www.securityfocus.com/bid/35115

  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for Apache Web Server version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Web Servers");
  script_dependencies("http_version.nasl", "secpod_apache_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

httpdPort = get_http_port(default:80);
if(!httpdPort){
  exit(0);
}

version = get_kb_item("www/" + httpdPort + "/Apache");
if(version != NULL){
  if(version_is_less(version:version, test_version:"2.2.9")){
    security_warning(httpdPort);
  }
}
