###############################################################################
# OpenVAS Vulnerability Test
# $Id: JBoss_enterprise_aplication_server_detect.nasl 7190 2010-03-31 14:02:04Z chandra $
#
# JBoss Enterprise Application Server Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "Overview:
This host is running JBoss Enterprise Application Server.

See also:
http://www.jboss.com/products/platforms/application/

Risk factor : None";

if (description)
{
 script_id(100387);
 script_version ("1.0-$Revision: 7190 $");
 script_tag(name:"risk_factor", value:"None");

 script_name("JBoss Enterprise Application Server Detection");
 script_description(desc);
 script_summary("Checks for the presence of JBoss Enterprise Application Server");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes");
 script_require_ports("Services/www", 8080);
 exit(0);
}


include("http_func.inc");
include("global_settings.inc");

port = get_http_port(default:8080);
if(!get_port_state(port))exit(0);

banner = get_http_banner(port: port);
if(!banner)exit(0);

if(egrep(pattern:"X-Powered-By.*JBoss-", string:banner))
 {
   version = eregmatch(pattern:"JBoss-([0-9.]+[GA_CP0-9]*)", string: banner);

   if(!isnull(version[1])) {

     set_kb_item(name: string("www/", port, "/jboss_enterprise_application_server"), value: version[1]);
     set_kb_item(name: string("cpe:/a:jboss:enterprise_application_platform:",version[1]), value: TRUE);

     info = string("None\n\nJBoss Enterprise Application Server Version '");
     info += string(vers);
     info += string("' was detected on the remote host.\n");

     desc = ereg_replace(
        string:desc,
        pattern:"None$",
        replace:info
    );

     if(report_verbosity > 0) {
        security_note(port:port);
        exit(0); 
     }
   }
 }

exit(0);

