/*
 * Copyright 2013 Peter Lawrey
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.chronicle.sandbox;

import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.ExcerptTailer;
import org.jetbrains.annotations.NotNull;

import java.io.IOException;

/**
 * A Journal is a simplified Chronicle.  It is bounded in size and number, does not support random access and is designed for fast writes.
 */
public interface Journal {
    @NotNull
    String name();

    @NotNull
    ExcerptTailer createTailer() throws IOException;

    @NotNull
    ExcerptAppender createAppender() throws IOException;

    // the last written entry.
    long size();
}
