/***************************************************************************
 *   Copyright (C) 2008-2011 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KOSD.                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#include "osd.h"

#include <QApplication>
#include <QDesktopWidget>


Osd::Osd()
    : Plasma::Dialog(0, Qt::X11BypassWindowManagerHint),
      m_timer(this),
      m_hPos(0.5),
      m_vPos(0.7),
      m_timeout(2000),
      m_lockPrimaryScreen(true)
{
    m_timer.setSingleShot(true);
    connect(&m_timer, SIGNAL(timeout()), this, SLOT(hide()));
}


Osd::~Osd()
{
}


void Osd::setOpacity(unsigned char percent)
{
    if (percent > 100)
        percent = 100;

    setWindowOpacity(static_cast<qreal>(percent)/100);
}


void Osd::setPosition(unsigned char xPercent, unsigned char yPercent)
{
    if (xPercent > 100)
        xPercent = 100;
    if (yPercent > 100)
        yPercent = 100;

    m_hPos = static_cast<qreal>(xPercent)/100;
    m_vPos = static_cast<qreal>(yPercent)/100;
}


void Osd::setPrimaryScreenLock(bool lock)
{
    m_lockPrimaryScreen = lock;
}


void Osd::setTimeout(unsigned int milliseconds)
{
    if (milliseconds < 1)
        milliseconds = 1;

    m_timeout = milliseconds;
}


QSize Osd::pixmapSize() const
{
    return requestedPixmapSize();
}


void Osd::show(const QPixmap &pixmap, const QString &text, unsigned char percent)
{
    setContents(pixmap, text, percent);
    show();
}


void Osd::mousePressEvent(QMouseEvent*)
{
    m_timer.stop();
    hide();
}


void Osd::updatePosition()
{
    QRect desktopRect;
    if (m_lockPrimaryScreen)
        desktopRect = QApplication::desktop()->screenGeometry(QApplication::desktop()->primaryScreen());
    else
        desktopRect = QApplication::desktop()->screenGeometry(QCursor::pos());

    int xPos = desktopRect.x() + (desktopRect.width() - size().width()) * m_hPos;
    int yPos = desktopRect.y() + (desktopRect.height() - size().height()) * m_vPos;
    move(xPos, yPos);
}


void Osd::show()
{
    updatePosition();
    Plasma::Dialog::show();

    m_timer.start(m_timeout);
}
