function(bindgen_enable_fortran_openacc_on_target target)
    # TODO check if find_package(OpenACC) solves this problem
    if(CMAKE_Fortran_COMPILER_ID STREQUAL "Cray")
        target_compile_options(${target} PRIVATE $<$<COMPILE_LANGUAGE:Fortran>:-h acc>)
    elseif(CMAKE_Fortran_COMPILER_ID STREQUAL "GNU")
        target_compile_options(${target} PRIVATE $<$<COMPILE_LANGUAGE:Fortran>:-fopenacc>)
        set_target_properties(${target} PROPERTIES APPEND_STRING PROPERTY LINK_FLAGS -fopenacc)
    else()
        message(FATAL_ERROR "OpenACC is not configured for this compiler.")
    endif()
endfunction()

function(bindgen_enable_fortran_preprocessing_on_target target)
    if (CMAKE_Fortran_COMPILER_ID STREQUAL "Cray")
        target_compile_options(${target} PRIVATE $<$<COMPILE_LANGUAGE:Fortran>:-eF>)
    else()
        target_compile_options(${target} PRIVATE $<$<COMPILE_LANGUAGE:Fortran>:-cpp>)
    endif()
endfunction()
