// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file primitivesTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "primitivesTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "primitives.hpp"


using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ShortStruct_type_identifier(
        TypeIdentifierPair& type_ids_ShortStruct)
{

    ReturnCode_t return_code_ShortStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ShortStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ShortStruct", type_ids_ShortStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ShortStruct)
    {
        StructTypeFlag struct_flags_ShortStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ShortStruct = "ShortStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ShortStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ShortStruct;
        CompleteTypeDetail detail_ShortStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ShortStruct, ann_custom_ShortStruct, type_name_ShortStruct.to_string());
        CompleteStructHeader header_ShortStruct;
        header_ShortStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ShortStruct);
        CompleteStructMemberSeq member_seq_ShortStruct;
        {
            TypeIdentifierPair type_ids_var_short;
            ReturnCode_t return_code_var_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_var_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_short Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_short = 0x00000000;
            bool common_var_short_ec {false};
            CommonStructMember common_var_short {TypeObjectUtils::build_common_struct_member(member_id_var_short, member_flags_var_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_short, common_var_short_ec))};
            if (!common_var_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_short = "var_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_short;
            ann_custom_ShortStruct.reset();
            CompleteMemberDetail detail_var_short = TypeObjectUtils::build_complete_member_detail(name_var_short, member_ann_builtin_var_short, ann_custom_ShortStruct);
            CompleteStructMember member_var_short = TypeObjectUtils::build_complete_struct_member(common_var_short, detail_var_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_ShortStruct, member_var_short);
        }
        CompleteStructType struct_type_ShortStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_ShortStruct, header_ShortStruct, member_seq_ShortStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ShortStruct, type_name_ShortStruct.to_string(), type_ids_ShortStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ShortStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UShortStruct_type_identifier(
        TypeIdentifierPair& type_ids_UShortStruct)
{

    ReturnCode_t return_code_UShortStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UShortStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "UShortStruct", type_ids_UShortStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UShortStruct)
    {
        StructTypeFlag struct_flags_UShortStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UShortStruct = "UShortStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UShortStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UShortStruct;
        CompleteTypeDetail detail_UShortStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UShortStruct, ann_custom_UShortStruct, type_name_UShortStruct.to_string());
        CompleteStructHeader header_UShortStruct;
        header_UShortStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_UShortStruct);
        CompleteStructMemberSeq member_seq_UShortStruct;
        {
            TypeIdentifierPair type_ids_var_ushort;
            ReturnCode_t return_code_var_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_var_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_ushort)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ushort Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_ushort = 0x00000000;
            bool common_var_ushort_ec {false};
            CommonStructMember common_var_ushort {TypeObjectUtils::build_common_struct_member(member_id_var_ushort, member_flags_var_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_ushort, common_var_ushort_ec))};
            if (!common_var_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ushort = "var_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_ushort;
            ann_custom_UShortStruct.reset();
            CompleteMemberDetail detail_var_ushort = TypeObjectUtils::build_complete_member_detail(name_var_ushort, member_ann_builtin_var_ushort, ann_custom_UShortStruct);
            CompleteStructMember member_var_ushort = TypeObjectUtils::build_complete_struct_member(common_var_ushort, detail_var_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_UShortStruct, member_var_ushort);
        }
        CompleteStructType struct_type_UShortStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_UShortStruct, header_UShortStruct, member_seq_UShortStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_UShortStruct, type_name_UShortStruct.to_string(), type_ids_UShortStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "UShortStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_LongStruct_type_identifier(
        TypeIdentifierPair& type_ids_LongStruct)
{

    ReturnCode_t return_code_LongStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_LongStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "LongStruct", type_ids_LongStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_LongStruct)
    {
        StructTypeFlag struct_flags_LongStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_LongStruct = "LongStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_LongStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_LongStruct;
        CompleteTypeDetail detail_LongStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_LongStruct, ann_custom_LongStruct, type_name_LongStruct.to_string());
        CompleteStructHeader header_LongStruct;
        header_LongStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_LongStruct);
        CompleteStructMemberSeq member_seq_LongStruct;
        {
            TypeIdentifierPair type_ids_var_long;
            ReturnCode_t return_code_var_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_var_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_long Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_long = 0x00000000;
            bool common_var_long_ec {false};
            CommonStructMember common_var_long {TypeObjectUtils::build_common_struct_member(member_id_var_long, member_flags_var_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_long, common_var_long_ec))};
            if (!common_var_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_long = "var_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_long;
            ann_custom_LongStruct.reset();
            CompleteMemberDetail detail_var_long = TypeObjectUtils::build_complete_member_detail(name_var_long, member_ann_builtin_var_long, ann_custom_LongStruct);
            CompleteStructMember member_var_long = TypeObjectUtils::build_complete_struct_member(common_var_long, detail_var_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_LongStruct, member_var_long);
        }
        CompleteStructType struct_type_LongStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_LongStruct, header_LongStruct, member_seq_LongStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_LongStruct, type_name_LongStruct.to_string(), type_ids_LongStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "LongStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ULongStruct_type_identifier(
        TypeIdentifierPair& type_ids_ULongStruct)
{

    ReturnCode_t return_code_ULongStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ULongStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ULongStruct", type_ids_ULongStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ULongStruct)
    {
        StructTypeFlag struct_flags_ULongStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ULongStruct = "ULongStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ULongStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ULongStruct;
        CompleteTypeDetail detail_ULongStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ULongStruct, ann_custom_ULongStruct, type_name_ULongStruct.to_string());
        CompleteStructHeader header_ULongStruct;
        header_ULongStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ULongStruct);
        CompleteStructMemberSeq member_seq_ULongStruct;
        {
            TypeIdentifierPair type_ids_var_ulong;
            ReturnCode_t return_code_var_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_var_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_ulong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ulong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_ulong = 0x00000000;
            bool common_var_ulong_ec {false};
            CommonStructMember common_var_ulong {TypeObjectUtils::build_common_struct_member(member_id_var_ulong, member_flags_var_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_ulong, common_var_ulong_ec))};
            if (!common_var_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ulong = "var_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_ulong;
            ann_custom_ULongStruct.reset();
            CompleteMemberDetail detail_var_ulong = TypeObjectUtils::build_complete_member_detail(name_var_ulong, member_ann_builtin_var_ulong, ann_custom_ULongStruct);
            CompleteStructMember member_var_ulong = TypeObjectUtils::build_complete_struct_member(common_var_ulong, detail_var_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_ULongStruct, member_var_ulong);
        }
        CompleteStructType struct_type_ULongStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_ULongStruct, header_ULongStruct, member_seq_ULongStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ULongStruct, type_name_ULongStruct.to_string(), type_ids_ULongStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ULongStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_LongLongStruct_type_identifier(
        TypeIdentifierPair& type_ids_LongLongStruct)
{

    ReturnCode_t return_code_LongLongStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_LongLongStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "LongLongStruct", type_ids_LongLongStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_LongLongStruct)
    {
        StructTypeFlag struct_flags_LongLongStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_LongLongStruct = "LongLongStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_LongLongStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_LongLongStruct;
        CompleteTypeDetail detail_LongLongStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_LongLongStruct, ann_custom_LongLongStruct, type_name_LongLongStruct.to_string());
        CompleteStructHeader header_LongLongStruct;
        header_LongLongStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_LongLongStruct);
        CompleteStructMemberSeq member_seq_LongLongStruct;
        {
            TypeIdentifierPair type_ids_var_longlong;
            ReturnCode_t return_code_var_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_var_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_longlong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_longlong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_longlong = 0x00000000;
            bool common_var_longlong_ec {false};
            CommonStructMember common_var_longlong {TypeObjectUtils::build_common_struct_member(member_id_var_longlong, member_flags_var_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_longlong, common_var_longlong_ec))};
            if (!common_var_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_longlong = "var_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_longlong;
            ann_custom_LongLongStruct.reset();
            CompleteMemberDetail detail_var_longlong = TypeObjectUtils::build_complete_member_detail(name_var_longlong, member_ann_builtin_var_longlong, ann_custom_LongLongStruct);
            CompleteStructMember member_var_longlong = TypeObjectUtils::build_complete_struct_member(common_var_longlong, detail_var_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_LongLongStruct, member_var_longlong);
        }
        CompleteStructType struct_type_LongLongStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_LongLongStruct, header_LongLongStruct, member_seq_LongLongStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_LongLongStruct, type_name_LongLongStruct.to_string(), type_ids_LongLongStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "LongLongStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ULongLongStruct_type_identifier(
        TypeIdentifierPair& type_ids_ULongLongStruct)
{

    ReturnCode_t return_code_ULongLongStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ULongLongStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ULongLongStruct", type_ids_ULongLongStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ULongLongStruct)
    {
        StructTypeFlag struct_flags_ULongLongStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ULongLongStruct = "ULongLongStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ULongLongStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ULongLongStruct;
        CompleteTypeDetail detail_ULongLongStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ULongLongStruct, ann_custom_ULongLongStruct, type_name_ULongLongStruct.to_string());
        CompleteStructHeader header_ULongLongStruct;
        header_ULongLongStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ULongLongStruct);
        CompleteStructMemberSeq member_seq_ULongLongStruct;
        {
            TypeIdentifierPair type_ids_var_ulonglong;
            ReturnCode_t return_code_var_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_var_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_ulonglong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ulonglong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_ulonglong = 0x00000000;
            bool common_var_ulonglong_ec {false};
            CommonStructMember common_var_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_var_ulonglong, member_flags_var_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_ulonglong, common_var_ulonglong_ec))};
            if (!common_var_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ulonglong = "var_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_ulonglong;
            ann_custom_ULongLongStruct.reset();
            CompleteMemberDetail detail_var_ulonglong = TypeObjectUtils::build_complete_member_detail(name_var_ulonglong, member_ann_builtin_var_ulonglong, ann_custom_ULongLongStruct);
            CompleteStructMember member_var_ulonglong = TypeObjectUtils::build_complete_struct_member(common_var_ulonglong, detail_var_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_ULongLongStruct, member_var_ulonglong);
        }
        CompleteStructType struct_type_ULongLongStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_ULongLongStruct, header_ULongLongStruct, member_seq_ULongLongStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ULongLongStruct, type_name_ULongLongStruct.to_string(), type_ids_ULongLongStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ULongLongStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FloatStruct_type_identifier(
        TypeIdentifierPair& type_ids_FloatStruct)
{

    ReturnCode_t return_code_FloatStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FloatStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FloatStruct", type_ids_FloatStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FloatStruct)
    {
        StructTypeFlag struct_flags_FloatStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_FloatStruct = "FloatStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FloatStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FloatStruct;
        CompleteTypeDetail detail_FloatStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FloatStruct, ann_custom_FloatStruct, type_name_FloatStruct.to_string());
        CompleteStructHeader header_FloatStruct;
        header_FloatStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FloatStruct);
        CompleteStructMemberSeq member_seq_FloatStruct;
        {
            TypeIdentifierPair type_ids_var_float;
            ReturnCode_t return_code_var_float {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_var_float);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_float)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_float Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_float = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_float = 0x00000000;
            bool common_var_float_ec {false};
            CommonStructMember common_var_float {TypeObjectUtils::build_common_struct_member(member_id_var_float, member_flags_var_float, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_float, common_var_float_ec))};
            if (!common_var_float_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_float member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_float = "var_float";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_float;
            ann_custom_FloatStruct.reset();
            CompleteMemberDetail detail_var_float = TypeObjectUtils::build_complete_member_detail(name_var_float, member_ann_builtin_var_float, ann_custom_FloatStruct);
            CompleteStructMember member_var_float = TypeObjectUtils::build_complete_struct_member(common_var_float, detail_var_float);
            TypeObjectUtils::add_complete_struct_member(member_seq_FloatStruct, member_var_float);
        }
        CompleteStructType struct_type_FloatStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_FloatStruct, header_FloatStruct, member_seq_FloatStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FloatStruct, type_name_FloatStruct.to_string(), type_ids_FloatStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FloatStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_DoubleStruct_type_identifier(
        TypeIdentifierPair& type_ids_DoubleStruct)
{

    ReturnCode_t return_code_DoubleStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_DoubleStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "DoubleStruct", type_ids_DoubleStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_DoubleStruct)
    {
        StructTypeFlag struct_flags_DoubleStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_DoubleStruct = "DoubleStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_DoubleStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_DoubleStruct;
        CompleteTypeDetail detail_DoubleStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_DoubleStruct, ann_custom_DoubleStruct, type_name_DoubleStruct.to_string());
        CompleteStructHeader header_DoubleStruct;
        header_DoubleStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_DoubleStruct);
        CompleteStructMemberSeq member_seq_DoubleStruct;
        {
            TypeIdentifierPair type_ids_var_double;
            ReturnCode_t return_code_var_double {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_double", type_ids_var_double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_double)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_double Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_double = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_double = 0x00000000;
            bool common_var_double_ec {false};
            CommonStructMember common_var_double {TypeObjectUtils::build_common_struct_member(member_id_var_double, member_flags_var_double, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_double, common_var_double_ec))};
            if (!common_var_double_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_double member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_double = "var_double";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_double;
            ann_custom_DoubleStruct.reset();
            CompleteMemberDetail detail_var_double = TypeObjectUtils::build_complete_member_detail(name_var_double, member_ann_builtin_var_double, ann_custom_DoubleStruct);
            CompleteStructMember member_var_double = TypeObjectUtils::build_complete_struct_member(common_var_double, detail_var_double);
            TypeObjectUtils::add_complete_struct_member(member_seq_DoubleStruct, member_var_double);
        }
        CompleteStructType struct_type_DoubleStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_DoubleStruct, header_DoubleStruct, member_seq_DoubleStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_DoubleStruct, type_name_DoubleStruct.to_string(), type_ids_DoubleStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "DoubleStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_LongDoubleStruct_type_identifier(
        TypeIdentifierPair& type_ids_LongDoubleStruct)
{

    ReturnCode_t return_code_LongDoubleStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_LongDoubleStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "LongDoubleStruct", type_ids_LongDoubleStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_LongDoubleStruct)
    {
        StructTypeFlag struct_flags_LongDoubleStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_LongDoubleStruct = "LongDoubleStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_LongDoubleStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_LongDoubleStruct;
        CompleteTypeDetail detail_LongDoubleStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_LongDoubleStruct, ann_custom_LongDoubleStruct, type_name_LongDoubleStruct.to_string());
        CompleteStructHeader header_LongDoubleStruct;
        header_LongDoubleStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_LongDoubleStruct);
        CompleteStructMemberSeq member_seq_LongDoubleStruct;
        {
            TypeIdentifierPair type_ids_var_longdouble;
            ReturnCode_t return_code_var_longdouble {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_longdouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_longdouble", type_ids_var_longdouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_longdouble)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_longdouble Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_longdouble = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_longdouble = 0x00000000;
            bool common_var_longdouble_ec {false};
            CommonStructMember common_var_longdouble {TypeObjectUtils::build_common_struct_member(member_id_var_longdouble, member_flags_var_longdouble, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_longdouble, common_var_longdouble_ec))};
            if (!common_var_longdouble_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_longdouble member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_longdouble = "var_longdouble";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_longdouble;
            ann_custom_LongDoubleStruct.reset();
            CompleteMemberDetail detail_var_longdouble = TypeObjectUtils::build_complete_member_detail(name_var_longdouble, member_ann_builtin_var_longdouble, ann_custom_LongDoubleStruct);
            CompleteStructMember member_var_longdouble = TypeObjectUtils::build_complete_struct_member(common_var_longdouble, detail_var_longdouble);
            TypeObjectUtils::add_complete_struct_member(member_seq_LongDoubleStruct, member_var_longdouble);
        }
        CompleteStructType struct_type_LongDoubleStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_LongDoubleStruct, header_LongDoubleStruct, member_seq_LongDoubleStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_LongDoubleStruct, type_name_LongDoubleStruct.to_string(), type_ids_LongDoubleStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "LongDoubleStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_BooleanStruct_type_identifier(
        TypeIdentifierPair& type_ids_BooleanStruct)
{

    ReturnCode_t return_code_BooleanStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_BooleanStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "BooleanStruct", type_ids_BooleanStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_BooleanStruct)
    {
        StructTypeFlag struct_flags_BooleanStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_BooleanStruct = "BooleanStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_BooleanStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_BooleanStruct;
        CompleteTypeDetail detail_BooleanStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_BooleanStruct, ann_custom_BooleanStruct, type_name_BooleanStruct.to_string());
        CompleteStructHeader header_BooleanStruct;
        header_BooleanStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_BooleanStruct);
        CompleteStructMemberSeq member_seq_BooleanStruct;
        {
            TypeIdentifierPair type_ids_var_boolean;
            ReturnCode_t return_code_var_boolean {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_var_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_boolean)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_boolean Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_boolean = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_boolean = 0x00000000;
            bool common_var_boolean_ec {false};
            CommonStructMember common_var_boolean {TypeObjectUtils::build_common_struct_member(member_id_var_boolean, member_flags_var_boolean, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_boolean, common_var_boolean_ec))};
            if (!common_var_boolean_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_boolean member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_boolean = "var_boolean";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_boolean;
            ann_custom_BooleanStruct.reset();
            CompleteMemberDetail detail_var_boolean = TypeObjectUtils::build_complete_member_detail(name_var_boolean, member_ann_builtin_var_boolean, ann_custom_BooleanStruct);
            CompleteStructMember member_var_boolean = TypeObjectUtils::build_complete_struct_member(common_var_boolean, detail_var_boolean);
            TypeObjectUtils::add_complete_struct_member(member_seq_BooleanStruct, member_var_boolean);
        }
        CompleteStructType struct_type_BooleanStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_BooleanStruct, header_BooleanStruct, member_seq_BooleanStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_BooleanStruct, type_name_BooleanStruct.to_string(), type_ids_BooleanStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "BooleanStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_OctetStruct_type_identifier(
        TypeIdentifierPair& type_ids_OctetStruct)
{

    ReturnCode_t return_code_OctetStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_OctetStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "OctetStruct", type_ids_OctetStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_OctetStruct)
    {
        StructTypeFlag struct_flags_OctetStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_OctetStruct = "OctetStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_OctetStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_OctetStruct;
        CompleteTypeDetail detail_OctetStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_OctetStruct, ann_custom_OctetStruct, type_name_OctetStruct.to_string());
        CompleteStructHeader header_OctetStruct;
        header_OctetStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_OctetStruct);
        CompleteStructMemberSeq member_seq_OctetStruct;
        {
            TypeIdentifierPair type_ids_var_octet;
            ReturnCode_t return_code_var_octet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_var_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_octet)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_octet Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_octet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_octet = 0x00000000;
            bool common_var_octet_ec {false};
            CommonStructMember common_var_octet {TypeObjectUtils::build_common_struct_member(member_id_var_octet, member_flags_var_octet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_octet, common_var_octet_ec))};
            if (!common_var_octet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_octet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_octet = "var_octet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_octet;
            ann_custom_OctetStruct.reset();
            CompleteMemberDetail detail_var_octet = TypeObjectUtils::build_complete_member_detail(name_var_octet, member_ann_builtin_var_octet, ann_custom_OctetStruct);
            CompleteStructMember member_var_octet = TypeObjectUtils::build_complete_struct_member(common_var_octet, detail_var_octet);
            TypeObjectUtils::add_complete_struct_member(member_seq_OctetStruct, member_var_octet);
        }
        CompleteStructType struct_type_OctetStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_OctetStruct, header_OctetStruct, member_seq_OctetStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_OctetStruct, type_name_OctetStruct.to_string(), type_ids_OctetStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "OctetStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_CharStruct_type_identifier(
        TypeIdentifierPair& type_ids_CharStruct)
{

    ReturnCode_t return_code_CharStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_CharStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "CharStruct", type_ids_CharStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_CharStruct)
    {
        StructTypeFlag struct_flags_CharStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_CharStruct = "CharStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_CharStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_CharStruct;
        CompleteTypeDetail detail_CharStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_CharStruct, ann_custom_CharStruct, type_name_CharStruct.to_string());
        CompleteStructHeader header_CharStruct;
        header_CharStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_CharStruct);
        CompleteStructMemberSeq member_seq_CharStruct;
        {
            TypeIdentifierPair type_ids_var_char8;
            ReturnCode_t return_code_var_char8 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_char8 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_var_char8);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_char8)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_char8 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_char8 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_char8 = 0x00000000;
            bool common_var_char8_ec {false};
            CommonStructMember common_var_char8 {TypeObjectUtils::build_common_struct_member(member_id_var_char8, member_flags_var_char8, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_char8, common_var_char8_ec))};
            if (!common_var_char8_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_char8 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_char8 = "var_char8";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_char8;
            ann_custom_CharStruct.reset();
            CompleteMemberDetail detail_var_char8 = TypeObjectUtils::build_complete_member_detail(name_var_char8, member_ann_builtin_var_char8, ann_custom_CharStruct);
            CompleteStructMember member_var_char8 = TypeObjectUtils::build_complete_struct_member(common_var_char8, detail_var_char8);
            TypeObjectUtils::add_complete_struct_member(member_seq_CharStruct, member_var_char8);
        }
        CompleteStructType struct_type_CharStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_CharStruct, header_CharStruct, member_seq_CharStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_CharStruct, type_name_CharStruct.to_string(), type_ids_CharStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "CharStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_WCharStruct_type_identifier(
        TypeIdentifierPair& type_ids_WCharStruct)
{

    ReturnCode_t return_code_WCharStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_WCharStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "WCharStruct", type_ids_WCharStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_WCharStruct)
    {
        StructTypeFlag struct_flags_WCharStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_WCharStruct = "WCharStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_WCharStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_WCharStruct;
        CompleteTypeDetail detail_WCharStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_WCharStruct, ann_custom_WCharStruct, type_name_WCharStruct.to_string());
        CompleteStructHeader header_WCharStruct;
        header_WCharStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_WCharStruct);
        CompleteStructMemberSeq member_seq_WCharStruct;
        {
            TypeIdentifierPair type_ids_var_char16;
            ReturnCode_t return_code_var_char16 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_char16 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_wchar_t", type_ids_var_char16);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_char16)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_char16 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_char16 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_char16 = 0x00000000;
            bool common_var_char16_ec {false};
            CommonStructMember common_var_char16 {TypeObjectUtils::build_common_struct_member(member_id_var_char16, member_flags_var_char16, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_char16, common_var_char16_ec))};
            if (!common_var_char16_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_char16 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_char16 = "var_char16";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_char16;
            ann_custom_WCharStruct.reset();
            CompleteMemberDetail detail_var_char16 = TypeObjectUtils::build_complete_member_detail(name_var_char16, member_ann_builtin_var_char16, ann_custom_WCharStruct);
            CompleteStructMember member_var_char16 = TypeObjectUtils::build_complete_struct_member(common_var_char16, detail_var_char16);
            TypeObjectUtils::add_complete_struct_member(member_seq_WCharStruct, member_var_char16);
        }
        CompleteStructType struct_type_WCharStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_WCharStruct, header_WCharStruct, member_seq_WCharStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_WCharStruct, type_name_WCharStruct.to_string(), type_ids_WCharStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "WCharStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Int8Struct_type_identifier(
        TypeIdentifierPair& type_ids_Int8Struct)
{

    ReturnCode_t return_code_Int8Struct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Int8Struct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Int8Struct", type_ids_Int8Struct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Int8Struct)
    {
        StructTypeFlag struct_flags_Int8Struct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Int8Struct = "Int8Struct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Int8Struct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Int8Struct;
        CompleteTypeDetail detail_Int8Struct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Int8Struct, ann_custom_Int8Struct, type_name_Int8Struct.to_string());
        CompleteStructHeader header_Int8Struct;
        header_Int8Struct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Int8Struct);
        CompleteStructMemberSeq member_seq_Int8Struct;
        {
            TypeIdentifierPair type_ids_var_int8;
            ReturnCode_t return_code_var_int8 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_int8 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int8_t", type_ids_var_int8);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_int8)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_int8 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_int8 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_int8 = 0x00000000;
            bool common_var_int8_ec {false};
            CommonStructMember common_var_int8 {TypeObjectUtils::build_common_struct_member(member_id_var_int8, member_flags_var_int8, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_int8, common_var_int8_ec))};
            if (!common_var_int8_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_int8 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_int8 = "var_int8";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_int8;
            ann_custom_Int8Struct.reset();
            CompleteMemberDetail detail_var_int8 = TypeObjectUtils::build_complete_member_detail(name_var_int8, member_ann_builtin_var_int8, ann_custom_Int8Struct);
            CompleteStructMember member_var_int8 = TypeObjectUtils::build_complete_struct_member(common_var_int8, detail_var_int8);
            TypeObjectUtils::add_complete_struct_member(member_seq_Int8Struct, member_var_int8);
        }
        CompleteStructType struct_type_Int8Struct = TypeObjectUtils::build_complete_struct_type(struct_flags_Int8Struct, header_Int8Struct, member_seq_Int8Struct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Int8Struct, type_name_Int8Struct.to_string(), type_ids_Int8Struct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Int8Struct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Uint8Struct_type_identifier(
        TypeIdentifierPair& type_ids_Uint8Struct)
{

    ReturnCode_t return_code_Uint8Struct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Uint8Struct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Uint8Struct", type_ids_Uint8Struct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Uint8Struct)
    {
        StructTypeFlag struct_flags_Uint8Struct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Uint8Struct = "Uint8Struct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Uint8Struct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Uint8Struct;
        CompleteTypeDetail detail_Uint8Struct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Uint8Struct, ann_custom_Uint8Struct, type_name_Uint8Struct.to_string());
        CompleteStructHeader header_Uint8Struct;
        header_Uint8Struct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Uint8Struct);
        CompleteStructMemberSeq member_seq_Uint8Struct;
        {
            TypeIdentifierPair type_ids_var_uint8;
            ReturnCode_t return_code_var_uint8 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_uint8 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint8_t", type_ids_var_uint8);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_uint8)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_uint8 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_uint8 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_uint8 = 0x00000000;
            bool common_var_uint8_ec {false};
            CommonStructMember common_var_uint8 {TypeObjectUtils::build_common_struct_member(member_id_var_uint8, member_flags_var_uint8, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_uint8, common_var_uint8_ec))};
            if (!common_var_uint8_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_uint8 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_uint8 = "var_uint8";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_uint8;
            ann_custom_Uint8Struct.reset();
            CompleteMemberDetail detail_var_uint8 = TypeObjectUtils::build_complete_member_detail(name_var_uint8, member_ann_builtin_var_uint8, ann_custom_Uint8Struct);
            CompleteStructMember member_var_uint8 = TypeObjectUtils::build_complete_struct_member(common_var_uint8, detail_var_uint8);
            TypeObjectUtils::add_complete_struct_member(member_seq_Uint8Struct, member_var_uint8);
        }
        CompleteStructType struct_type_Uint8Struct = TypeObjectUtils::build_complete_struct_type(struct_flags_Uint8Struct, header_Uint8Struct, member_seq_Uint8Struct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Uint8Struct, type_name_Uint8Struct.to_string(), type_ids_Uint8Struct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Uint8Struct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Int16Struct_type_identifier(
        TypeIdentifierPair& type_ids_Int16Struct)
{

    ReturnCode_t return_code_Int16Struct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Int16Struct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Int16Struct", type_ids_Int16Struct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Int16Struct)
    {
        StructTypeFlag struct_flags_Int16Struct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Int16Struct = "Int16Struct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Int16Struct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Int16Struct;
        CompleteTypeDetail detail_Int16Struct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Int16Struct, ann_custom_Int16Struct, type_name_Int16Struct.to_string());
        CompleteStructHeader header_Int16Struct;
        header_Int16Struct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Int16Struct);
        CompleteStructMemberSeq member_seq_Int16Struct;
        {
            TypeIdentifierPair type_ids_var_int16;
            ReturnCode_t return_code_var_int16 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_int16 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_var_int16);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_int16)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_int16 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_int16 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_int16 = 0x00000000;
            bool common_var_int16_ec {false};
            CommonStructMember common_var_int16 {TypeObjectUtils::build_common_struct_member(member_id_var_int16, member_flags_var_int16, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_int16, common_var_int16_ec))};
            if (!common_var_int16_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_int16 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_int16 = "var_int16";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_int16;
            ann_custom_Int16Struct.reset();
            CompleteMemberDetail detail_var_int16 = TypeObjectUtils::build_complete_member_detail(name_var_int16, member_ann_builtin_var_int16, ann_custom_Int16Struct);
            CompleteStructMember member_var_int16 = TypeObjectUtils::build_complete_struct_member(common_var_int16, detail_var_int16);
            TypeObjectUtils::add_complete_struct_member(member_seq_Int16Struct, member_var_int16);
        }
        CompleteStructType struct_type_Int16Struct = TypeObjectUtils::build_complete_struct_type(struct_flags_Int16Struct, header_Int16Struct, member_seq_Int16Struct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Int16Struct, type_name_Int16Struct.to_string(), type_ids_Int16Struct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Int16Struct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Uint16Struct_type_identifier(
        TypeIdentifierPair& type_ids_Uint16Struct)
{

    ReturnCode_t return_code_Uint16Struct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Uint16Struct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Uint16Struct", type_ids_Uint16Struct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Uint16Struct)
    {
        StructTypeFlag struct_flags_Uint16Struct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Uint16Struct = "Uint16Struct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Uint16Struct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Uint16Struct;
        CompleteTypeDetail detail_Uint16Struct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Uint16Struct, ann_custom_Uint16Struct, type_name_Uint16Struct.to_string());
        CompleteStructHeader header_Uint16Struct;
        header_Uint16Struct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Uint16Struct);
        CompleteStructMemberSeq member_seq_Uint16Struct;
        {
            TypeIdentifierPair type_ids_var_uint16;
            ReturnCode_t return_code_var_uint16 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_uint16 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_var_uint16);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_uint16)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_uint16 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_uint16 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_uint16 = 0x00000000;
            bool common_var_uint16_ec {false};
            CommonStructMember common_var_uint16 {TypeObjectUtils::build_common_struct_member(member_id_var_uint16, member_flags_var_uint16, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_uint16, common_var_uint16_ec))};
            if (!common_var_uint16_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_uint16 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_uint16 = "var_uint16";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_uint16;
            ann_custom_Uint16Struct.reset();
            CompleteMemberDetail detail_var_uint16 = TypeObjectUtils::build_complete_member_detail(name_var_uint16, member_ann_builtin_var_uint16, ann_custom_Uint16Struct);
            CompleteStructMember member_var_uint16 = TypeObjectUtils::build_complete_struct_member(common_var_uint16, detail_var_uint16);
            TypeObjectUtils::add_complete_struct_member(member_seq_Uint16Struct, member_var_uint16);
        }
        CompleteStructType struct_type_Uint16Struct = TypeObjectUtils::build_complete_struct_type(struct_flags_Uint16Struct, header_Uint16Struct, member_seq_Uint16Struct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Uint16Struct, type_name_Uint16Struct.to_string(), type_ids_Uint16Struct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Uint16Struct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Int32Struct_type_identifier(
        TypeIdentifierPair& type_ids_Int32Struct)
{

    ReturnCode_t return_code_Int32Struct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Int32Struct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Int32Struct", type_ids_Int32Struct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Int32Struct)
    {
        StructTypeFlag struct_flags_Int32Struct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Int32Struct = "Int32Struct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Int32Struct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Int32Struct;
        CompleteTypeDetail detail_Int32Struct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Int32Struct, ann_custom_Int32Struct, type_name_Int32Struct.to_string());
        CompleteStructHeader header_Int32Struct;
        header_Int32Struct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Int32Struct);
        CompleteStructMemberSeq member_seq_Int32Struct;
        {
            TypeIdentifierPair type_ids_var_int32;
            ReturnCode_t return_code_var_int32 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_int32 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_var_int32);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_int32)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_int32 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_int32 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_int32 = 0x00000000;
            bool common_var_int32_ec {false};
            CommonStructMember common_var_int32 {TypeObjectUtils::build_common_struct_member(member_id_var_int32, member_flags_var_int32, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_int32, common_var_int32_ec))};
            if (!common_var_int32_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_int32 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_int32 = "var_int32";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_int32;
            ann_custom_Int32Struct.reset();
            CompleteMemberDetail detail_var_int32 = TypeObjectUtils::build_complete_member_detail(name_var_int32, member_ann_builtin_var_int32, ann_custom_Int32Struct);
            CompleteStructMember member_var_int32 = TypeObjectUtils::build_complete_struct_member(common_var_int32, detail_var_int32);
            TypeObjectUtils::add_complete_struct_member(member_seq_Int32Struct, member_var_int32);
        }
        CompleteStructType struct_type_Int32Struct = TypeObjectUtils::build_complete_struct_type(struct_flags_Int32Struct, header_Int32Struct, member_seq_Int32Struct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Int32Struct, type_name_Int32Struct.to_string(), type_ids_Int32Struct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Int32Struct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Uint32Struct_type_identifier(
        TypeIdentifierPair& type_ids_Uint32Struct)
{

    ReturnCode_t return_code_Uint32Struct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Uint32Struct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Uint32Struct", type_ids_Uint32Struct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Uint32Struct)
    {
        StructTypeFlag struct_flags_Uint32Struct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Uint32Struct = "Uint32Struct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Uint32Struct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Uint32Struct;
        CompleteTypeDetail detail_Uint32Struct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Uint32Struct, ann_custom_Uint32Struct, type_name_Uint32Struct.to_string());
        CompleteStructHeader header_Uint32Struct;
        header_Uint32Struct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Uint32Struct);
        CompleteStructMemberSeq member_seq_Uint32Struct;
        {
            TypeIdentifierPair type_ids_var_uint32;
            ReturnCode_t return_code_var_uint32 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_uint32 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_var_uint32);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_uint32)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_uint32 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_uint32 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_uint32 = 0x00000000;
            bool common_var_uint32_ec {false};
            CommonStructMember common_var_uint32 {TypeObjectUtils::build_common_struct_member(member_id_var_uint32, member_flags_var_uint32, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_uint32, common_var_uint32_ec))};
            if (!common_var_uint32_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_uint32 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_uint32 = "var_uint32";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_uint32;
            ann_custom_Uint32Struct.reset();
            CompleteMemberDetail detail_var_uint32 = TypeObjectUtils::build_complete_member_detail(name_var_uint32, member_ann_builtin_var_uint32, ann_custom_Uint32Struct);
            CompleteStructMember member_var_uint32 = TypeObjectUtils::build_complete_struct_member(common_var_uint32, detail_var_uint32);
            TypeObjectUtils::add_complete_struct_member(member_seq_Uint32Struct, member_var_uint32);
        }
        CompleteStructType struct_type_Uint32Struct = TypeObjectUtils::build_complete_struct_type(struct_flags_Uint32Struct, header_Uint32Struct, member_seq_Uint32Struct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Uint32Struct, type_name_Uint32Struct.to_string(), type_ids_Uint32Struct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Uint32Struct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Int64Struct_type_identifier(
        TypeIdentifierPair& type_ids_Int64Struct)
{

    ReturnCode_t return_code_Int64Struct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Int64Struct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Int64Struct", type_ids_Int64Struct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Int64Struct)
    {
        StructTypeFlag struct_flags_Int64Struct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Int64Struct = "Int64Struct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Int64Struct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Int64Struct;
        CompleteTypeDetail detail_Int64Struct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Int64Struct, ann_custom_Int64Struct, type_name_Int64Struct.to_string());
        CompleteStructHeader header_Int64Struct;
        header_Int64Struct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Int64Struct);
        CompleteStructMemberSeq member_seq_Int64Struct;
        {
            TypeIdentifierPair type_ids_var_int64;
            ReturnCode_t return_code_var_int64 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_int64 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_var_int64);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_int64)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_int64 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_int64 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_int64 = 0x00000000;
            bool common_var_int64_ec {false};
            CommonStructMember common_var_int64 {TypeObjectUtils::build_common_struct_member(member_id_var_int64, member_flags_var_int64, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_int64, common_var_int64_ec))};
            if (!common_var_int64_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_int64 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_int64 = "var_int64";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_int64;
            ann_custom_Int64Struct.reset();
            CompleteMemberDetail detail_var_int64 = TypeObjectUtils::build_complete_member_detail(name_var_int64, member_ann_builtin_var_int64, ann_custom_Int64Struct);
            CompleteStructMember member_var_int64 = TypeObjectUtils::build_complete_struct_member(common_var_int64, detail_var_int64);
            TypeObjectUtils::add_complete_struct_member(member_seq_Int64Struct, member_var_int64);
        }
        CompleteStructType struct_type_Int64Struct = TypeObjectUtils::build_complete_struct_type(struct_flags_Int64Struct, header_Int64Struct, member_seq_Int64Struct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Int64Struct, type_name_Int64Struct.to_string(), type_ids_Int64Struct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Int64Struct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Uint64Struct_type_identifier(
        TypeIdentifierPair& type_ids_Uint64Struct)
{

    ReturnCode_t return_code_Uint64Struct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Uint64Struct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Uint64Struct", type_ids_Uint64Struct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Uint64Struct)
    {
        StructTypeFlag struct_flags_Uint64Struct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Uint64Struct = "Uint64Struct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Uint64Struct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Uint64Struct;
        CompleteTypeDetail detail_Uint64Struct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Uint64Struct, ann_custom_Uint64Struct, type_name_Uint64Struct.to_string());
        CompleteStructHeader header_Uint64Struct;
        header_Uint64Struct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Uint64Struct);
        CompleteStructMemberSeq member_seq_Uint64Struct;
        {
            TypeIdentifierPair type_ids_var_uint64;
            ReturnCode_t return_code_var_uint64 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_uint64 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_var_uint64);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_uint64)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_uint64 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_uint64 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_uint64 = 0x00000000;
            bool common_var_uint64_ec {false};
            CommonStructMember common_var_uint64 {TypeObjectUtils::build_common_struct_member(member_id_var_uint64, member_flags_var_uint64, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_uint64, common_var_uint64_ec))};
            if (!common_var_uint64_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_uint64 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_uint64 = "var_uint64";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_uint64;
            ann_custom_Uint64Struct.reset();
            CompleteMemberDetail detail_var_uint64 = TypeObjectUtils::build_complete_member_detail(name_var_uint64, member_ann_builtin_var_uint64, ann_custom_Uint64Struct);
            CompleteStructMember member_var_uint64 = TypeObjectUtils::build_complete_struct_member(common_var_uint64, detail_var_uint64);
            TypeObjectUtils::add_complete_struct_member(member_seq_Uint64Struct, member_var_uint64);
        }
        CompleteStructType struct_type_Uint64Struct = TypeObjectUtils::build_complete_struct_type(struct_flags_Uint64Struct, header_Uint64Struct, member_seq_Uint64Struct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Uint64Struct, type_name_Uint64Struct.to_string(), type_ids_Uint64Struct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Uint64Struct already registered in TypeObjectRegistry for a different type.");
        }
    }
}

