# System information #
What is your operating system and version? _(e.g. "Linux, Fedora 29" or "macOS 10.13")_

What is your version of GJS? _(e.g. "1.54.1-fc29.1" or "commit 4ab70ef")_

If the bug is related to GNOME Shell, what is your version of GNOME Shell? _(e.g. "3.30.1-2ubuntu1" or "commit b405ed64")_

# Bug information #
## Steps to reproduce ##
- Step by step, how can you make the problem appear?
- List those steps here.
- If the problem doesn't happen every time, note that as well.

Even better, if the problem can be observed by executing a standalone JS
file, paste that here instead of the steps.
Use code blocks (```js) to format it.

## Current behaviour ##
What happened that made it evident there was a problem?
Copy and paste the exact text of any error messages.
Use code blocks (```) to format them.

If the problem was with GNOME Shell, you may be able to find error
messages in the system journal (`sudo journalctl -xb`).

If GJS or GNOME Shell crashed, please include a stack trace.
For information on how to get a stack trace,
[read this wiki page](https://wiki.gnome.org/GettingInTouch/Bugzilla/GettingTraces/Details).

## Expected behaviour ##
What did you expect to see instead?

/label ~"1. Bug"
