NDA Policy
==========

We, the individuals who are the maintainers of the fwupd and LVFS projects, often get asked by
companies to sign non-disclosure agreements "NDAs" or other types of confidentiality agreements and
we have always said “no”.

Rather than rewriting a version of this document for each individual request, we have summarized the
key points here.

We Are Individuals
------------------

The fwupd and LVFS projects do not sit under a legal entity and it would be us, as individuals,
personally signing these contracts.

That means not only putting our names and reputations on the line, but also our personal property,
homes etc.

NDAs Require Time
-----------------

We have limited time to spend on these projects and time spent dealing with NDAs and lawyers is time
that we either cannot spend on the project itself, or with our families and friends.

Cost of Lawyers
---------------

Before we sign an NDA in a personal capacity, we need to spend time to read it, and have our lawyer
check it.

The protection language of a “generic NDA” is almost always broad, vague and ambiguous and we would
probably need to negotiate to make it more specific, with both legal teams involved.

That means money and time – which is a really bitter pill to swallow if the company isn’t actually
contributing financially to fwupd/LVFS.

Limitless Risk
--------------

The remediation language is almost always open-ended and requires that we agree to eventualities
that are nearly impossible to define fully.

We often see language like “irreparable harm” and “cannot adequately be compensated with damages”.
This means the **personal** potential negative outcomes are near limitless.

Worldwide Risk
--------------

Companies typically propose that NDAs are subject to governing laws and jurisdictions which are most
favorable to them, or relate to where in the world they have a presence.

The complexity and cost of reviewing an NDA under a governing law unfamiliar to us is significant.

We do not want to be in a position where we could be sued, and forced to pay to defend ourselves,
in countries around the world, by working (usually for free) on better supporting firmware updates
for a company's hardware.

Really "Confidential Information"?
----------------------------------

Agreements of this nature are really about protecting confidential, proprietary information.

We know it feels as though the protocol used by your device is unique and contains valuable
intellectual property, but unfortunately they rarely do.

In reality, most firmware update protocols are very similar, and specific device implementation is
broadly the same as direct competitors.

Firmware updating is a very low level operation, with only a few different ways to achieve the same
result – so many companies we’ve already worked with (over 100 other vendors!) will have ideas
similar to whatever you’re trying to keep secret about.

Corporate Policy Dictates
----------------------------

We do understand that some companies have a corporate policy of requiring NDAs.

Our policy is that we do not sign NDAs, for the reasons in this document.
If that means that there is an irreconciable clash of policies, then that is unfortunate but
acceptable to us.

Trust Is More Important
-----------------------

Working together in an open source project is a very human business that involves networks,
relationships and, above all else, trust.

If someone actually lets you down in a confidential situation, they lose all of those – that would
hurt the fwupd/LVFS brand and standing much more than any legal recourse you might have with an NDA.

The LVFS works with all levels of the ecosystem from ISV, to IHV, to ODM to OEM and we **rely** on
these trust networks as without those the whole ecosystem collapses.

Hardly Actually Used
--------------------

NDAs very rarely ever seem to actually get used; in 21 years of being a software engineer I’ve never
actually seen an NDA that I’ve been involved with, actually be used in a court of law.
Almost always, NDAs will be used against former employees trying to compete with their former
business, rather than between partners working together.
You would be asking us to spend time and money on something that is likely never going to used.

Organization structures also change; if your organization ever changes hands, so does the agreement.
The new parent company may not love fwupd/LVFS or Open Source as much as the old one did, and may be
subject to different governing laws or jurisdictions.

Signing an NDA also opens us up personally to the possibility of abusive or frivolous litigation.
Even if we have done nothing wrong we must pay legal fees to prove it – and remember that most
companies are not paying us anything for our services anyway, so we have no legal defense fund.

Conclusion
----------

Signing a “generic NDA” means the risk-reward ratio is strongly stacked against us.
Our best-case scenario is (usually) adding one new fwupd plugin and adding support for a handful of
new devices to the LVFS.
The beneficiary here is the company providing the firmware, in terms of getting better support for
the hardware, not us personally -- as we do not receive anything for the provision of updates.

The worst-case scenario of potential frivolous litigation is complete and total devastation of both
projects, and often, the destruction of both professional and personal reputation.

Important Note
--------------

Both maintainers of fwupd are employed by huge companies that may or may not allow them to
contribute to all or some of the project during work time.
There maybe an existing NDA between your company and theirs, or that a new NDA can be signed between
them and you.

If this is arranged outside of the fwupd/LVFS ecosystem, all correspondence must be made using the
corporate-approved communication methods rather than leaking out onto GitHub or personal email
addresses.
