"""
Data downloaded from NIST Standard Reference Database at https://physics.nist.gov/PhysRefData/FFast/html/form.html
"""
nan = float("nan")

# flake8: noqa
# fmt: off
XRAY_SCATTERING_FACTORS = {
    'H':                                                                                                          [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.013328, 0.013532, 0.0135864, 0.013668, 0.013872, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368,
         0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404,
         0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482,
         0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625,
         0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098,
         1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848,
         2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467,
         5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212,
         11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338,
         24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159,
         51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239,
         106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156,
         222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [0.454682, 0.39717, 0.299485, 0.0685829, -0.117232, -0.516414, -0.998811, -0.492163, -0.0462805, 0.0468513,
         0.491043, 0.684358, 0.803468, 0.88464, 0.942415, 0.984335, 1.01491, 1.0371, 1.05295, 1.06395, 1.07121, 1.07558,
         1.07772, 1.07815, 1.07727, 1.07541, 1.07283, 1.06974, 1.0663, 1.06265, 1.05889, 1.0551, 1.05134, 1.04767,
         1.04411, 1.0407, 1.03745, 1.03437, 1.03147, 1.02876, 1.02622, 1.02387, 1.02169, 1.01968, 1.01782, 1.01612,
         1.01456, 1.01313, 1.01183, 1.01065, 1.00957, 1.00859, 1.00771, 1.00691, 1.00618, 1.00553, 1.00494, 1.00441,
         1.00394, 1.00351, 1.00313, 1.00279, 1.00248, 1.0022, 1.00196, 1.00174, 1.00154, 1.00137, 1.00121, 1.00108,
         1.00095, 1.00084, 1.00075, 1.00066, 1.00058, 1.00052, 1.00046, 1.0004, 1.00036, 1.00031, 1.00028, 1.00024,
         1.00022, 1.00019, 1.00017, 1.00015, 1.00013, 1.00011, 1.0001, 1.00009, 1.00008, 1.00007, 1.00006, 1.00005,
         1.00005, 1.00004, 1.00004, 1.00003, 1.00003, 1.00002, 1.00002, 1.00002, 1.00002, 1.00001, 1.00001, 1.00001,
         1.00001, 1.00001, 1.00001, 1.00001, 1.00001, 1.00001, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
         1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
         1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.95197, 0.9303, 0.92117, 0.8297, 0.7464, 0.67066, 0.60188, 0.53953,
         0.48306, 0.43201, 0.38592, 0.34435, 0.30692, 0.27325, 0.24301, 0.21589, 0.19159, 0.16984, 0.15041, 0.13306,
         0.1176, 0.10383, 0.091576, 0.080693, 0.071034, 0.062473, 0.054891, 0.048185, 0.04226, 0.03703, 0.032418,
         0.028356, 0.024781, 0.021639, 0.018879, 0.016458, 0.014336, 0.012477, 0.010851, 0.0094291, 0.0081876,
         0.0071041, 0.0061595, 0.0053367, 0.0046205, 0.0039976, 0.0034563, 0.0029863, 0.0025785, 0.0022249, 0.0019186,
         0.0016535, 0.0014241, 0.0012258, 0.0010545, 0.00090664, 0.00077906, 0.00066907, 0.0005743, 0.0004927,
         0.00042248, 0.00036208, 0.00031017, 0.00026558, 0.0002273, 0.00019444, 0.00016627, 0.00014211, 0.00012142,
         0.0001037, 8.8528e-05, 7.555e-05, 6.4451e-05, 5.4965e-05, 4.6859e-05, 3.9935e-05, 3.4025e-05, 2.898e-05,
         2.4677e-05, 2.1007e-05, 1.7878e-05, 1.5211e-05, 1.294e-05, 1.1005e-05, 9.3572e-06, 7.9549e-06, 6.7615e-06,
         5.7461e-06, 4.8825e-06, 4.1481e-06, 3.5237e-06, 2.993e-06, 2.5419e-06, 2.1586e-06, 1.833e-06, 1.5564e-06,
         1.3214e-06, 1.1219e-06, 9.5248e-07, 8.0863e-07, 6.8651e-07, 5.8283e-07, 4.9482e-07, 4.2012e-07, 3.5671e-07,
         3.0289e-07, 2.5721e-07, 2.1844e-07, 1.8553e-07, 1.576e-07, 1.3389e-07, 1.1376e-07, 9.6669e-08, 8.2161e-08,
         6.9843e-08, 5.9383e-08, 5.0499e-08, 4.2954e-08, 3.6544e-08, 3.1098e-08, 2.6471e-08, 2.2537e-08, 1.9194e-08,
         1.6351e-08, 1.3934e-08, 1.1877e-08, 1.0128e-08, 8.639e-09, 7.3715e-09, 6.2923e-09, 5.3732e-09, 4.5901e-09,
         3.9227e-09, 3.3537e-09, 2.8685e-09, 2.4545e-09, 2.1013e-09, 1.7997e-09, 1.5422e-09, 1.3221e-09, 1.1341e-09,
         9.7323e-10, 8.3566e-10, 7.1792e-10, 6.1711e-10, 5.3076e-10, 4.5676e-10, 3.9331e-10, 3.3887e-10, 2.9216e-10,
         2.5204e-10, 2.1757e-10, 1.8793e-10, 1.6245e-10, 1.4051e-10, 1.2162e-10, 1.0534e-10, 9.1313e-11]],
    'D':                                                                                                          [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.013328, 0.013532, 0.0135864, 0.013668, 0.013872, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368,
         0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404,
         0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482,
         0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625,
         0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098,
         1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848,
         2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467,
         5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212,
         11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338,
         24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159,
         51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239,
         106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156,
         222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [0.454682, 0.39717, 0.299485, 0.0685829, -0.117232, -0.516414, -0.998811, -0.492163, -0.0462805, 0.0468513,
         0.491043, 0.684358, 0.803468, 0.88464, 0.942415, 0.984335, 1.01491, 1.0371, 1.05295, 1.06395, 1.07121, 1.07558,
         1.07772, 1.07815, 1.07727, 1.07541, 1.07283, 1.06974, 1.0663, 1.06265, 1.05889, 1.0551, 1.05134, 1.04767,
         1.04411, 1.0407, 1.03745, 1.03437, 1.03147, 1.02876, 1.02622, 1.02387, 1.02169, 1.01968, 1.01782, 1.01612,
         1.01456, 1.01313, 1.01183, 1.01065, 1.00957, 1.00859, 1.00771, 1.00691, 1.00618, 1.00553, 1.00494, 1.00441,
         1.00394, 1.00351, 1.00313, 1.00279, 1.00248, 1.0022, 1.00196, 1.00174, 1.00154, 1.00137, 1.00121, 1.00108,
         1.00095, 1.00084, 1.00075, 1.00066, 1.00058, 1.00052, 1.00046, 1.0004, 1.00036, 1.00031, 1.00028, 1.00024,
         1.00022, 1.00019, 1.00017, 1.00015, 1.00013, 1.00011, 1.0001, 1.00009, 1.00008, 1.00007, 1.00006, 1.00005,
         1.00005, 1.00004, 1.00004, 1.00003, 1.00003, 1.00002, 1.00002, 1.00002, 1.00002, 1.00001, 1.00001, 1.00001,
         1.00001, 1.00001, 1.00001, 1.00001, 1.00001, 1.00001, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
         1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
         1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.95197, 0.9303, 0.92117, 0.8297, 0.7464, 0.67066, 0.60188, 0.53953,
         0.48306, 0.43201, 0.38592, 0.34435, 0.30692, 0.27325, 0.24301, 0.21589, 0.19159, 0.16984, 0.15041, 0.13306,
         0.1176, 0.10383, 0.091576, 0.080693, 0.071034, 0.062473, 0.054891, 0.048185, 0.04226, 0.03703, 0.032418,
         0.028356, 0.024781, 0.021639, 0.018879, 0.016458, 0.014336, 0.012477, 0.010851, 0.0094291, 0.0081876,
         0.0071041, 0.0061595, 0.0053367, 0.0046205, 0.0039976, 0.0034563, 0.0029863, 0.0025785, 0.0022249, 0.0019186,
         0.0016535, 0.0014241, 0.0012258, 0.0010545, 0.00090664, 0.00077906, 0.00066907, 0.0005743, 0.0004927,
         0.00042248, 0.00036208, 0.00031017, 0.00026558, 0.0002273, 0.00019444, 0.00016627, 0.00014211, 0.00012142,
         0.0001037, 8.8528e-05, 7.555e-05, 6.4451e-05, 5.4965e-05, 4.6859e-05, 3.9935e-05, 3.4025e-05, 2.898e-05,
         2.4677e-05, 2.1007e-05, 1.7878e-05, 1.5211e-05, 1.294e-05, 1.1005e-05, 9.3572e-06, 7.9549e-06, 6.7615e-06,
         5.7461e-06, 4.8825e-06, 4.1481e-06, 3.5237e-06, 2.993e-06, 2.5419e-06, 2.1586e-06, 1.833e-06, 1.5564e-06,
         1.3214e-06, 1.1219e-06, 9.5248e-07, 8.0863e-07, 6.8651e-07, 5.8283e-07, 4.9482e-07, 4.2012e-07, 3.5671e-07,
         3.0289e-07, 2.5721e-07, 2.1844e-07, 1.8553e-07, 1.576e-07, 1.3389e-07, 1.1376e-07, 9.6669e-08, 8.2161e-08,
         6.9843e-08, 5.9383e-08, 5.0499e-08, 4.2954e-08, 3.6544e-08, 3.1098e-08, 2.6471e-08, 2.2537e-08, 1.9194e-08,
         1.6351e-08, 1.3934e-08, 1.1877e-08, 1.0128e-08, 8.639e-09, 7.3715e-09, 6.2923e-09, 5.3732e-09, 4.5901e-09,
         3.9227e-09, 3.3537e-09, 2.8685e-09, 2.4545e-09, 2.1013e-09, 1.7997e-09, 1.5422e-09, 1.3221e-09, 1.1341e-09,
         9.7323e-10, 8.3566e-10, 7.1792e-10, 6.1711e-10, 5.3076e-10, 4.5676e-10, 3.9331e-10, 3.3887e-10, 2.9216e-10,
         2.5204e-10, 2.1757e-10, 1.8793e-10, 1.6245e-10, 1.4051e-10, 1.2162e-10, 1.0534e-10, 9.1313e-11]],
    'T':                                                                                                          [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.013328, 0.013532, 0.0135864, 0.013668, 0.013872, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368,
         0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404,
         0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482,
         0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625,
         0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098,
         1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848,
         2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467,
         5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212,
         11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338,
         24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159,
         51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239,
         106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156,
         222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [0.454682, 0.39717, 0.299485, 0.0685829, -0.117232, -0.516414, -0.998811, -0.492163, -0.0462805, 0.0468513,
         0.491043, 0.684358, 0.803468, 0.88464, 0.942415, 0.984335, 1.01491, 1.0371, 1.05295, 1.06395, 1.07121, 1.07558,
         1.07772, 1.07815, 1.07727, 1.07541, 1.07283, 1.06974, 1.0663, 1.06265, 1.05889, 1.0551, 1.05134, 1.04767,
         1.04411, 1.0407, 1.03745, 1.03437, 1.03147, 1.02876, 1.02622, 1.02387, 1.02169, 1.01968, 1.01782, 1.01612,
         1.01456, 1.01313, 1.01183, 1.01065, 1.00957, 1.00859, 1.00771, 1.00691, 1.00618, 1.00553, 1.00494, 1.00441,
         1.00394, 1.00351, 1.00313, 1.00279, 1.00248, 1.0022, 1.00196, 1.00174, 1.00154, 1.00137, 1.00121, 1.00108,
         1.00095, 1.00084, 1.00075, 1.00066, 1.00058, 1.00052, 1.00046, 1.0004, 1.00036, 1.00031, 1.00028, 1.00024,
         1.00022, 1.00019, 1.00017, 1.00015, 1.00013, 1.00011, 1.0001, 1.00009, 1.00008, 1.00007, 1.00006, 1.00005,
         1.00005, 1.00004, 1.00004, 1.00003, 1.00003, 1.00002, 1.00002, 1.00002, 1.00002, 1.00001, 1.00001, 1.00001,
         1.00001, 1.00001, 1.00001, 1.00001, 1.00001, 1.00001, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
         1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
         1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.95197, 0.9303, 0.92117, 0.8297, 0.7464, 0.67066, 0.60188, 0.53953,
         0.48306, 0.43201, 0.38592, 0.34435, 0.30692, 0.27325, 0.24301, 0.21589, 0.19159, 0.16984, 0.15041, 0.13306,
         0.1176, 0.10383, 0.091576, 0.080693, 0.071034, 0.062473, 0.054891, 0.048185, 0.04226, 0.03703, 0.032418,
         0.028356, 0.024781, 0.021639, 0.018879, 0.016458, 0.014336, 0.012477, 0.010851, 0.0094291, 0.0081876,
         0.0071041, 0.0061595, 0.0053367, 0.0046205, 0.0039976, 0.0034563, 0.0029863, 0.0025785, 0.0022249, 0.0019186,
         0.0016535, 0.0014241, 0.0012258, 0.0010545, 0.00090664, 0.00077906, 0.00066907, 0.0005743, 0.0004927,
         0.00042248, 0.00036208, 0.00031017, 0.00026558, 0.0002273, 0.00019444, 0.00016627, 0.00014211, 0.00012142,
         0.0001037, 8.8528e-05, 7.555e-05, 6.4451e-05, 5.4965e-05, 4.6859e-05, 3.9935e-05, 3.4025e-05, 2.898e-05,
         2.4677e-05, 2.1007e-05, 1.7878e-05, 1.5211e-05, 1.294e-05, 1.1005e-05, 9.3572e-06, 7.9549e-06, 6.7615e-06,
         5.7461e-06, 4.8825e-06, 4.1481e-06, 3.5237e-06, 2.993e-06, 2.5419e-06, 2.1586e-06, 1.833e-06, 1.5564e-06,
         1.3214e-06, 1.1219e-06, 9.5248e-07, 8.0863e-07, 6.8651e-07, 5.8283e-07, 4.9482e-07, 4.2012e-07, 3.5671e-07,
         3.0289e-07, 2.5721e-07, 2.1844e-07, 1.8553e-07, 1.576e-07, 1.3389e-07, 1.1376e-07, 9.6669e-08, 8.2161e-08,
         6.9843e-08, 5.9383e-08, 5.0499e-08, 4.2954e-08, 3.6544e-08, 3.1098e-08, 2.6471e-08, 2.2537e-08, 1.9194e-08,
         1.6351e-08, 1.3934e-08, 1.1877e-08, 1.0128e-08, 8.639e-09, 7.3715e-09, 6.2923e-09, 5.3732e-09, 4.5901e-09,
         3.9227e-09, 3.3537e-09, 2.8685e-09, 2.4545e-09, 2.1013e-09, 1.7997e-09, 1.5422e-09, 1.3221e-09, 1.1341e-09,
         9.7323e-10, 8.3566e-10, 7.1792e-10, 6.1711e-10, 5.3076e-10, 4.5676e-10, 3.9331e-10, 3.3887e-10, 2.9216e-10,
         2.5204e-10, 2.1757e-10, 1.8793e-10, 1.6245e-10, 1.4051e-10, 1.2162e-10, 1.0534e-10, 9.1313e-11]],
    'He':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.024108, 0.024477, 0.0245754, 0.024723, 0.025092, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368,
         0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404,
         0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482,
         0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625,
         0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098,
         1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848,
         2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467,
         5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212,
         11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338,
         24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159,
         51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239,
         106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156,
         222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [0.809152, 0.794174, 0.776288, 0.754752, 0.728554, 0.69627, 0.655815, 0.603976, 0.535466, 0.440723, 0.299815,
         0.0595946, -0.537052, -0.818127, -1.66675, -2.67916, -1.63405, -0.718902, -0.346603, 0.444157, 0.835659,
         1.09847, 1.29391, 1.44669, 1.56954, 1.66999, 1.75296, 1.82186, 1.87923, 1.92697, 1.9666, 1.99934, 2.02621,
         2.04803, 2.06555, 2.07934, 2.08994, 2.09782, 2.10336, 2.10693, 2.10882, 2.1093, 2.10861, 2.10695, 2.10451,
         2.10143, 2.09787, 2.09393, 2.08972, 2.08533, 2.08083, 2.07628, 2.07175, 2.06727, 2.06289, 2.05862, 2.0545,
         2.05053, 2.04675, 2.04315, 2.03973, 2.03651, 2.03349, 2.03065, 2.028, 2.02553, 2.02324, 2.02112, 2.01917,
         2.01736, 2.0157, 2.01418, 2.01279, 2.01152, 2.01036, 2.00929, 2.00833, 2.00745, 2.00665, 2.00594, 2.00529,
         2.00471, 2.00419, 2.00373, 2.00331, 2.00294, 2.0026, 2.00231, 2.00204, 2.00181, 2.0016, 2.00141, 2.00125,
         2.0011, 2.00097, 2.00086, 2.00076, 2.00067, 2.00059, 2.00052, 2.00046, 2.0004, 2.00035, 2.00031, 2.00027,
         2.00024, 2.00021, 2.00019, 2.00016, 2.00014, 2.00013, 2.00011, 2.0001, 2.00009, 2.00007, 2.00007, 2.00006,
         2.00005, 2.00004, 2.00004, 2.00003, 2.00003, 2.00003, 2.00002, 2.00002, 2.00002, 2.00002, 2.00001, 2.00001,
         2.00001, 2.00001, 2.00001, 2.00001, 2.00001, 2.00001, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0,
         2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.9911, 1.9648, 1.9399, 1.8248,
         1.7138, 1.6069, 1.5043, 1.406, 1.312, 1.2223, 1.1369, 1.0558, 0.97893, 0.90618, 0.83748, 0.77275, 0.71188,
         0.65476, 0.60124, 0.55122, 0.50455, 0.46109, 0.42069, 0.38322, 0.34853, 0.31646, 0.28689, 0.25966, 0.23464,
         0.21169, 0.19068, 0.17148, 0.15396, 0.13801, 0.12352, 0.11037, 0.098459, 0.087695, 0.077982, 0.069233,
         0.061368, 0.054308, 0.047984, 0.042328, 0.037279, 0.032779, 0.028776, 0.025222, 0.022071, 0.019283, 0.016819,
         0.014647, 0.012735, 0.011055, 0.0095814, 0.0082906, 0.0071622, 0.0061775, 0.0053, 0.0045425, 0.0038898,
         0.003328, 0.0028448, 0.0024298, 0.0020737, 0.0017684, 0.0015069, 0.0012832, 0.0010919, 0.00092851, 0.00078905,
         0.00067012, 0.00056878, 0.00048249, 0.00040907, 0.00034664, 0.0002936, 0.00024855, 0.00021033, 0.00017791,
         0.00015043, 0.00012714, 0.00010743, 9.074e-05, 7.6624e-05, 6.4687e-05, 5.4596e-05, 4.607e-05, 3.8868e-05,
         3.2787e-05, 2.7654e-05, 2.3322e-05, 1.9667e-05, 1.6584e-05, 1.3984e-05, 1.1791e-05, 9.9427e-06, 8.3843e-06,
         7.0708e-06, 5.9636e-06, 5.0304e-06, 4.2439e-06, 3.581e-06, 3.0223e-06, 2.5513e-06, 2.1543e-06, 1.8195e-06,
         1.5373e-06, 1.2992e-06, 1.0984e-06, 9.2904e-07, 7.8609e-07, 6.6542e-07, 5.6354e-07, 4.7748e-07, 4.0478e-07,
         3.4333e-07, 2.9137e-07, 2.4742e-07, 2.1023e-07, 1.7875e-07, 1.5208e-07, 1.2948e-07, 1.1032e-07, 9.4059e-08,
         8.026e-08, 6.854e-08, 5.8579e-08, 5.0108e-08, 4.29e-08, 3.6762e-08, 3.1531e-08, 2.707e-08, 2.3263e-08,
         2.0011e-08, 1.7232e-08, 1.4854e-08, 1.2818e-08, 1.1073e-08, 9.5771e-09, 8.2925e-09, 7.1887e-09, 6.2394e-09,
         5.4221e-09, 4.7179e-09, 4.1103e-09, 3.5857e-09, 3.1323e-09, 2.7399e-09]],
    'Li':                                                                                                         [
        [0.0052332, 0.0053133, 0.00533466, 0.0053667, 0.0054468, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.053655, 0.05447625, 0.05469525, 0.05502375, 0.055845, 0.05667876, 0.06058959,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581,
         0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655,
         0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189,
         0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768,
         0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329,
         1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406,
         3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365,
         7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688,
         15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405,
         32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287,
         66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669,
         139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869,
         290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [0.908733, 0.859283, 0.803599, 0.856971, 0.901968, 1.0766, 1.08752, 1.09737, 1.10595, 1.11307, 1.11854, 1.12215,
         1.12376, 1.12305, 1.1198, 1.1137, 1.10441, 1.0914, 1.07404, 1.05151, 1.02273, 0.986239, 0.939944, 0.880803,
         0.804138, 0.702294, 0.561559, 0.35373, 0.00488984, -0.835477, -1.19807, -2.31019, -3.60723, -2.31071, -1.18751,
         -0.72105, 0.250867, 0.817156, 1.26129, 1.63438, 1.95333, 2.22569, 2.4562, 2.64887, 2.80757, 2.93608, 3.03823,
         3.11772, 3.17802, 3.22227, 3.25329, 3.27358, 3.28517, 3.2899, 3.28929, 3.28462, 3.27691, 3.26695, 3.25537,
         3.24269, 3.22935, 3.21568, 3.20197, 3.18842, 3.17518, 3.16239, 3.15011, 3.13842, 3.12734, 3.1169, 3.10711,
         3.09796, 3.08945, 3.08155, 3.07424, 3.06751, 3.06132, 3.05566, 3.05049, 3.04576, 3.04136, 3.03729, 3.03355,
         3.03015, 3.02705, 3.02425, 3.02172, 3.01943, 3.01738, 3.01553, 3.01387, 3.01238, 3.01105, 3.00986, 3.00881,
         3.00786, 3.00699, 3.00621, 3.00552, 3.0049, 3.00435, 3.00385, 3.00341, 3.00302, 3.00268, 3.00237, 3.0021,
         3.00186, 3.00164, 3.00145, 3.00128, 3.00113, 3.001, 3.00088, 3.00078, 3.00069, 3.00061, 3.00053, 3.00047,
         3.00042, 3.00037, 3.00032, 3.00028, 3.00025, 3.00022, 3.00019, 3.00017, 3.00015, 3.00013, 3.00012, 3.0001,
         3.00009, 3.00008, 3.00007, 3.00006, 3.00005, 3.00005, 3.00004, 3.00004, 3.00003, 3.00003, 3.00002, 3.00002,
         3.00002, 3.00002, 3.00001, 3.00001, 3.00001, 3.00001, 3.00001, 3.00001, 3.00001, 3.00001, 3.00001, 3.0, 3.0,
         3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0],
        [0.0, 0.0, 0.0, 0.10769, 0.10987, 0.17745, 0.17721, 0.17581, 0.17335, 0.16997, 0.16578, 0.16092, 0.15551,
         0.14967, 0.1435, 0.13711, 0.13057, 0.12391, 0.11721, 0.11056, 0.10401, 0.097625, 0.091431, 0.085462, 0.079741,
         0.07428, 0.069091, 0.064175, 0.059534, 0.055164, 0.054412, 0.053466, 0.053218, 2.5879, 2.5985, 2.6092, 2.6581,
         2.6783, 2.6515, 2.5848, 2.4858, 2.3627, 2.2228, 2.0728, 1.9181, 1.7633, 1.612, 1.4666, 1.329, 1.2001, 1.0806,
         0.97059, 0.86995, 0.77835, 0.69532, 0.62031, 0.55269, 0.4918, 0.43709, 0.38805, 0.34415, 0.30493, 0.26993,
         0.23873, 0.21095, 0.18625, 0.1643, 0.14482, 0.12754, 0.11224, 0.098699, 0.086728, 0.076155, 0.066826, 0.058603,
         0.051362, 0.04499, 0.03939, 0.034471, 0.029934, 0.025916, 0.022438, 0.019426, 0.016819, 0.014561, 0.012607,
         0.010915, 0.0094497, 0.0081814, 0.0070833, 0.0061326, 0.0053094, 0.0045965, 0.0039792, 0.0034448, 0.0029684,
         0.0025468, 0.0021851, 0.0018748, 0.0016085, 0.0013801, 0.0011841, 0.0010159, 0.00087162, 0.00074783,
         0.00064162, 0.0005505, 0.00047232, 0.00040524, 0.00034768, 0.00029831, 0.00025574, 0.00021863, 0.00018691,
         0.00015979, 0.00013661, 0.00011679, 9.9841e-05, 8.5355e-05, 7.2971e-05, 6.2383e-05, 5.3332e-05, 4.5594e-05,
         3.8979e-05, 3.3323e-05, 2.8488e-05, 2.4355e-05, 2.0857e-05, 1.7837e-05, 1.5245e-05, 1.303e-05, 1.1137e-05,
         9.5189e-06, 8.1358e-06, 6.9538e-06, 5.9434e-06, 5.0799e-06, 4.3418e-06, 3.711e-06, 3.1718e-06, 2.711e-06,
         2.3171e-06, 1.9805e-06, 1.6927e-06, 1.4468e-06, 1.2366e-06, 1.0569e-06, 9.0339e-07, 7.7214e-07, 6.5996e-07,
         5.6408e-07, 4.8213e-07, 4.1209e-07, 3.5222e-07, 3.0105e-07, 2.5732e-07, 2.1993e-07, 1.8798e-07, 1.6067e-07,
         1.3733e-07, 1.1738e-07, 1.0033e-07, 8.5755e-08, 7.3297e-08, 6.2649e-08, 5.3548e-08, 4.577e-08, 3.9121e-08,
         3.3438e-08, 2.8581e-08]],
    'Be':                                                                                                         [
        [0.0082516, 0.0083779, 0.00841158, 0.0084621, 0.0085884, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368,
         0.09041995, 0.09665893, 0.1033284, 0.10878, 0.1104581, 0.110889, 0.111555, 0.11322, 0.1180797, 0.1262272,
         0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997,
         0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098,
         0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948,
         0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643,
         2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024,
         4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789,
         9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961,
         18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551,
         39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578,
         81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356,
         170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294,
         354.4049, 378.8588, 405.0001, 432.9451],
        [1.55864, 1.50947, 1.45794, 1.50266, 1.53756, 1.5848, 1.60258, 1.62546, 1.65269, 1.68318, 1.71575, 1.74924,
         1.78263, 1.81506, 1.84585, 1.87451, 1.90068, 1.92412, 1.94468, 1.9623, 1.97692, 1.9885, 1.997, 2.00234,
         2.00432, 2.00267, 1.99706, 1.98704, 1.97202, 1.9512, 1.92346, 1.88729, 1.84054, 1.78009, 1.70124, 1.59647,
         1.4529, 1.24579, 0.918719, 0.291953, -1.10059, -2.81138, -4.79732, -2.70425, -0.867705, 0.743908, 1.85031,
         2.50334, 2.95829, 3.29619, 3.55465, 3.75464, 3.9099, 4.03003, 4.12212, 4.19162, 4.24285, 4.27928, 4.30376,
         4.31861, 4.32576, 4.32684, 4.32314, 4.31578, 4.30567, 4.29356, 4.28005, 4.26557, 4.2505, 4.23517, 4.21985,
         4.20476, 4.19008, 4.17592, 4.1624, 4.14957, 4.13749, 4.12618, 4.11586, 4.10588, 4.09645, 4.08767, 4.07955,
         4.07207, 4.06521, 4.05894, 4.05324, 4.04805, 4.04336, 4.03909, 4.03518, 4.03162, 4.02839, 4.02551, 4.02306,
         4.02063, 4.01844, 4.01646, 4.01468, 4.01308, 4.01165, 4.01037, 4.00923, 4.0082, 4.00729, 4.00647, 4.00574,
         4.0051, 4.00452, 4.00401, 4.00356, 4.00316, 4.0028, 4.00248, 4.00219, 4.00194, 4.00171, 4.00151, 4.00134,
         4.00118, 4.00104, 4.00092, 4.00081, 4.00072, 4.00063, 4.00056, 4.00049, 4.00043, 4.00038, 4.00034, 4.0003,
         4.00026, 4.00023, 4.0002, 4.00018, 4.00016, 4.00014, 4.00012, 4.00011, 4.00009, 4.00008, 4.00007, 4.00006,
         4.00006, 4.00005, 4.00004, 4.00004, 4.00003, 4.00003, 4.00003, 4.00002, 4.00002, 4.00002, 4.00002, 4.00001,
         4.00001, 4.00001, 4.00001, 4.00001, 4.00001, 4.00001, 4.00001, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0],
        [0.0, 0.0, 0.0, 0.097318, 0.10286, 0.21247, 0.24694, 0.2787, 0.3066, 0.32988, 0.3482, 0.36151, 0.37006, 0.37426,
         0.37463, 0.37173, 0.36615, 0.35841, 0.349, 0.33833, 0.32677, 0.31461, 0.30208, 0.28933, 0.27642, 0.26351,
         0.2507, 0.23807, 0.22569, 0.2136, 0.20184, 0.19044, 0.17941, 0.16876, 0.15851, 0.14865, 0.13921, 0.13017,
         0.12155, 0.11333, 0.10728, 0.10553, 0.10509, 4.0732, 4.007, 3.8249, 3.5508, 3.285, 3.0279, 2.7813, 2.5461,
         2.3237, 2.1149, 1.9199, 1.7389, 1.5715, 1.4173, 1.2758, 1.1464, 1.0285, 0.92117, 0.82386, 0.73579, 0.65626,
         0.58459, 0.52011, 0.46212, 0.41004, 0.36339, 0.32168, 0.28447, 0.25134, 0.22187, 0.19572, 0.17254, 0.15201,
         0.13385, 0.11782, 0.10297, 0.089977, 0.078625, 0.068705, 0.060037, 0.052463, 0.045844, 0.04006, 0.035006,
         0.030589, 0.02673, 0.023204, 0.020139, 0.01748, 0.015171, 0.013168, 0.011388, 0.0098151, 0.0084596, 0.0072914,
         0.0062835, 0.0054148, 0.0046662, 0.0040211, 0.0034651, 0.0029861, 0.0025732, 0.0022175, 0.0019109, 0.0016467,
         0.0014191, 0.0012229, 0.0010525, 0.00090177, 0.00077264, 0.000662, 0.00056721, 0.00048599, 0.0004164,
         0.00035677, 0.00030569, 0.00026192, 0.00022441, 0.00019228, 0.00016475, 0.00014116, 0.00012094, 0.00010363,
         8.8788e-05, 7.594e-05, 6.4915e-05, 5.549e-05, 4.7433e-05, 4.0546e-05, 3.466e-05, 2.9628e-05, 2.5326e-05,
         2.1649e-05, 1.8512e-05, 1.5845e-05, 1.3563e-05, 1.161e-05, 9.9374e-06, 8.5061e-06, 7.281e-06, 6.2323e-06,
         5.3347e-06, 4.5664e-06, 3.9087e-06, 3.3457e-06, 2.8639e-06, 2.4514e-06, 2.0984e-06, 1.7962e-06, 1.5375e-06,
         1.3161e-06, 1.1265e-06, 9.6428e-07, 8.2541e-07, 7.0654e-07, 6.0479e-07, 5.177e-07, 4.4314e-07, 3.7933e-07,
         3.247e-07, 2.7794e-07, 2.3792e-07, 2.0366e-07, 1.7433e-07, 1.4923e-07, 1.2774e-07]],
    'B':                                                                                                          [
        [0.004606, 0.0046765, 0.0046953, 0.0047235, 0.004794, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0132006,
         0.01340265, 0.01345653, 0.01353735, 0.0137394, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581,
         0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.18424, 0.18706, 0.187812,
         0.1883732, 0.18894, 0.19176, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128,
         0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525,
         0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345,
         1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781,
         2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664,
         5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004,
         11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988,
         22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101,
         47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374,
         99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018,
         207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001,
         432.9451],
        [0.803768, 0.303582, -0.292582, 0.323173, 0.861328, 2.36087, 2.37363, 2.37133, 2.33137, 2.31282, 2.25109,
         2.18102, 2.24636, 2.30171, 2.32499, 2.36971, 2.40102, 2.43266, 2.46722, 2.50542, 2.54708, 2.59154, 2.63793,
         2.68534, 2.73282, 2.77952, 2.8247, 2.86772, 2.90809, 2.94544, 2.97932, 3.00989, 3.03686, 3.06015, 3.07973,
         3.09557, 3.10748, 3.11523, 3.11858, 3.11726, 3.11091, 3.09899, 3.0808, 3.05508, 3.02038, 2.97471, 2.91504,
         2.83673, 2.73225, 2.58847, 2.37982, 2.04643, 1.38697, 0.147973, -1.46533, -3.39747, -2.53721, -1.39355,
         0.364335, 2.05708, 3.05311, 3.66377, 4.09461, 4.41524, 4.65896, 4.84566, 4.98856, 5.09713, 5.17848, 5.23814,
         5.28048, 5.309, 5.32654, 5.33541, 5.33746, 5.33457, 5.32733, 5.31709, 5.30466, 5.29073, 5.27579, 5.26025,
         5.24449, 5.22885, 5.21494, 5.19961, 5.18432, 5.16952, 5.15544, 5.14217, 5.12975, 5.11821, 5.10752, 5.09766,
         5.0886, 5.08029, 5.0727, 5.06577, 5.05947, 5.05375, 5.04875, 5.04408, 5.03978, 5.03582, 5.03219, 5.02888,
         5.02588, 5.02316, 5.02071, 5.0185, 5.01652, 5.01474, 5.01314, 5.01172, 5.01044, 5.0093, 5.00828, 5.00737,
         5.00654, 5.00581, 5.00516, 5.00457, 5.00405, 5.00359, 5.00318, 5.00282, 5.00249, 5.0022, 5.00195, 5.00172,
         5.00152, 5.00135, 5.00119, 5.00105, 5.00093, 5.00082, 5.00072, 5.00064, 5.00056, 5.00049, 5.00044, 5.00038,
         5.00034, 5.0003, 5.00026, 5.00023, 5.0002, 5.00018, 5.00016, 5.00014, 5.00012, 5.00011, 5.00009, 5.00008,
         5.00007, 5.00006, 5.00006, 5.00005, 5.00004, 5.00004, 5.00003, 5.00003, 5.00003, 5.00002, 5.00002, 5.00002,
         5.00002, 5.00001, 5.00001, 5.00001, 5.00001, 5.00001, 5.00001, 5.00001, 5.00001],
        [0.0, 0.0, 0.0, 1.1721, 1.1548, 0.63908, 0.60622, 0.57327, 0.54038, 0.53508, 0.52763, 0.52567, 0.65844, 0.65819,
         0.65834, 0.66435, 0.67606, 0.68985, 0.7042, 0.71767, 0.72892, 0.737, 0.74132, 0.74153, 0.73754, 0.72948,
         0.71764, 0.70241, 0.68424, 0.66364, 0.64107, 0.61699, 0.59184, 0.56597, 0.53974, 0.51332, 0.4868, 0.46045,
         0.43449, 0.4091, 0.3844, 0.36052, 0.33727, 0.31461, 0.29304, 0.27258, 0.25321, 0.23492, 0.2177, 0.20152,
         0.18634, 0.17213, 0.15886, 0.15049, 0.14773, 0.14701, 3.9624, 3.9498, 3.8885, 3.6926, 3.4372, 3.1815, 2.9293,
         2.684, 2.4491, 2.227, 2.0189, 1.8254, 1.6466, 1.4821, 1.3316, 1.1942, 1.0694, 0.95617, 0.85376, 0.76132,
         0.67805, 0.60317, 0.53594, 0.47567, 0.42165, 0.37337, 0.33033, 0.29207, 0.256, 0.22436, 0.19662, 0.17231,
         0.15101, 0.13235, 0.11599, 0.10165, 0.089083, 0.078072, 0.068421, 0.059964, 0.052552, 0.046056, 0.040363,
         0.035374, 0.030872, 0.026837, 0.02332, 0.020164, 0.017435, 0.015075, 0.013035, 0.011271, 0.0097453, 0.0084264,
         0.007286, 0.0062986, 0.0054448, 0.0047067, 0.0040687, 0.0035172, 0.003036, 0.002607, 0.0022386, 0.0019223,
         0.0016507, 0.0014174, 0.0012171, 0.0010451, 0.00089746, 0.00077065, 0.00066175, 0.00056825, 0.00048795,
         0.000419, 0.0003598, 0.00030896, 0.0002653, 0.0002273, 0.0001946, 0.0001666, 0.00014263, 0.00012211,
         0.00010455, 8.9505e-05, 7.6628e-05, 6.5604e-05, 5.6166e-05, 4.8086e-05, 4.1169e-05, 3.5246e-05, 3.0176e-05,
         2.5835e-05, 2.2118e-05, 1.8973e-05, 1.6348e-05, 1.4085e-05, 1.2136e-05, 1.0456e-05, 9.0092e-06, 7.7624e-06,
         6.6881e-06, 5.7625e-06, 4.965e-06, 4.2779e-06, 3.6858e-06, 3.1757e-06, 2.7362e-06, 2.3575e-06, 2.0313e-06,
         1.7502e-06, 1.5079e-06, 1.2993e-06, 1.1194e-06, 9.6452e-07, 8.3104e-07, 7.1603e-07, 6.1693e-07, 5.3155e-07,
         4.5799e-07]],
    'C':                                                                                                          [
        [0.006272, 0.006368, 0.0063936, 0.006432, 0.006528, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.0191198, 0.01941245, 0.01948844, 0.01949049, 0.01960755,
         0.0199002, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581,
         0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655,
         0.2301188, 0.245997, 0.2629708, 0.278124, 0.2811158, 0.282381, 0.2835162, 0.285219, 0.289476, 0.3005128,
         0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525,
         0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345,
         1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781,
         2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664,
         5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004,
         11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988,
         22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101,
         47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374,
         99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018,
         207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001,
         432.9451],
        [-0.320134, -1.17579, -2.18154, -1.16186, -0.276671, 2.10173, 2.22488, 2.33994, 2.44742, 2.5471, 2.63805,
         2.71844, 2.78446, 2.82559, 2.80931, 2.75154, 2.67983, 2.67501, 2.75433, 2.82926, 2.91938, 3.00738, 3.08738,
         3.16576, 3.24448, 3.32364, 3.4028, 3.48136, 3.55864, 3.63385, 3.70629, 3.77526, 3.84022, 3.90069, 3.95635,
         4.00697, 4.05263, 4.0929, 4.12801, 4.15805, 4.18316, 4.2034, 4.21865, 4.22883, 4.23389, 4.23373, 4.22817,
         4.21665, 4.19786, 4.17119, 4.13557, 4.08928, 4.02965, 3.9525, 3.85109, 3.71374, 3.51819, 3.21423, 2.64704,
         1.26093, 0.407656, -0.335665, -2.24717, -0.265349, 1.47293, 2.89123, 4.00159, 4.65259, 5.10424, 5.43616,
         5.68561, 5.8745, 6.01732, 6.12442, 6.20354, 6.26062, 6.30033, 6.32635, 6.34162, 6.34849, 6.34886, 6.34469,
         6.33647, 6.32562, 6.31267, 6.29863, 6.28281, 6.26551, 6.24774, 6.23009, 6.21289, 6.19636, 6.18064, 6.16581,
         6.15192, 6.13897, 6.12696, 6.11588, 6.10571, 6.09643, 6.0879, 6.07984, 6.07234, 6.06543, 6.05909, 6.05329,
         6.04802, 6.04323, 6.0389, 6.03498, 6.0314, 6.02815, 6.0252, 6.02255, 6.02016, 6.01801, 6.0161, 6.01439,
         6.01284, 6.01144, 6.01018, 6.00906, 6.00805, 6.00715, 6.00635, 6.00563, 6.00499, 6.00443, 6.00392, 6.00348,
         6.00308, 6.00272, 6.00241, 6.00213, 6.00189, 6.00167, 6.00148, 6.0013, 6.00115, 6.00102, 6.0009, 6.00079,
         6.0007, 6.00062, 6.00054, 6.00048, 6.00042, 6.00037, 6.00033, 6.00029, 6.00025, 6.00022, 6.0002, 6.00017,
         6.00015, 6.00013, 6.00012, 6.0001, 6.00009, 6.00008, 6.00007, 6.00006, 6.00005, 6.00005, 6.00004, 6.00004,
         6.00003, 6.00003, 6.00003, 6.00002, 6.00002, 6.00002, 6.00001, 6.00001, 6.00001],
        [0.0, 0.0, 0.0, 1.9697, 1.9598, 1.7392, 1.7134, 1.6847, 1.6524, 1.6161, 1.5757, 1.5311, 1.4826, 1.4304, 1.3911,
         1.3783, 1.3749, 1.3748, 1.5242, 1.5191, 1.5052, 1.4898, 1.4761, 1.4626, 1.4477, 1.4301, 1.4091, 1.3844, 1.3557,
         1.323, 1.2864, 1.2462, 1.2028, 1.1569, 1.1089, 1.0595, 1.0091, 0.95827, 0.90756, 0.85736, 0.808, 0.75955,
         0.71222, 0.6663, 0.62204, 0.57959, 0.53908, 0.49886, 0.46044, 0.42445, 0.39083, 0.3595, 0.33037, 0.30333,
         0.27829, 0.25513, 0.23374, 0.21403, 0.19587, 0.18175, 0.17916, 0.17809, 0.17713, 3.9387, 3.8777, 3.7279,
         3.4725, 3.2143, 2.9562, 2.7033, 2.4612, 2.2326, 2.019, 1.8212, 1.6391, 1.4724, 1.3204, 1.1823, 1.0571, 0.94391,
         0.84179, 0.74981, 0.66709, 0.59282, 0.52585, 0.46573, 0.40956, 0.36016, 0.31672, 0.27853, 0.24494, 0.2154,
         0.18942, 0.16658, 0.1465, 0.12883, 0.1133, 0.099638, 0.087625, 0.077061, 0.06742, 0.058701, 0.051109, 0.044499,
         0.038744, 0.033733, 0.02937, 0.025572, 0.022265, 0.019289, 0.016703, 0.014463, 0.012524, 0.010844, 0.0093904,
         0.0081313, 0.0070314, 0.0060514, 0.0052079, 0.004482, 0.0038573, 0.0033197, 0.002857, 0.0024588, 0.0021161,
         0.0018212, 0.0015673, 0.0013489, 0.0011609, 0.00099909, 0.00085985, 0.00074001, 0.00063687, 0.00054642,
         0.00046835, 0.00040143, 0.00034407, 0.00029491, 0.00025277, 0.00021666, 0.0001857, 0.00015917, 0.00013643,
         0.00011694, 0.00010023, 8.5909e-05, 7.3635e-05, 6.3115e-05, 5.4098e-05, 4.6381e-05, 3.9791e-05, 3.4136e-05,
         2.9285e-05, 2.5124e-05, 2.1554e-05, 1.8491e-05, 1.5863e-05, 1.3609e-05, 1.1675e-05, 1.0016e-05, 8.5931e-06,
         7.372e-06, 6.3245e-06, 5.4258e-06, 4.6549e-06, 3.9934e-06, 3.426e-06, 2.9392e-06, 2.5216e-06, 2.1633e-06,
         1.8559e-06, 1.5922e-06, 1.366e-06, 1.1719e-06, 1.0054e-06]],
    'N':                                                                                                          [
        [0.009016, 0.009154, 0.0091908, 0.009246, 0.009384, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.0257838, 0.02617845, 0.02628369, 0.02644155, 0.0268362, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581,
         0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655,
         0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.393568,
         0.399592, 0.4011984, 0.403608, 0.409632, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525,
         0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345,
         1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781,
         2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664,
         5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004,
         11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988,
         22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101,
         47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374,
         99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018,
         207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001,
         432.9451],
        [-0.991623, -1.99965, -3.16894, -2.00383, -1.0002, 0.547159, 0.87087, 1.13142, 1.35881, 1.56675, 1.76235,
         1.94939, 2.12978, 2.30416, 2.47213, 2.63228, 2.78168, 2.91376, 3.00357, 3.00473, 2.9644, 2.89288, 2.97828,
         3.06936, 3.11898, 3.29678, 3.45322, 3.60471, 3.75399, 3.9019, 4.04756, 4.18906, 4.32493, 4.45392, 4.57503,
         4.68748, 4.79073, 4.8845, 4.9687, 5.04344, 5.1095, 5.16622, 5.21458, 5.2551, 5.28833, 5.31484, 5.33491,
         5.34874, 5.35661, 5.3587, 5.35518, 5.34609, 5.3313, 5.30915, 5.27886, 5.23972, 5.1903, 5.12826, 5.04985,
         4.94898, 4.81524, 4.62915, 4.3485, 3.85352, 2.43899, 2.29017, 0.666889, -1.27959, 0.743479, 2.51867, 3.58763,
         4.91711, 5.62761, 6.10433, 6.44813, 6.7035, 6.89525, 7.03922, 7.14645, 7.22503, 7.28114, 7.31959, 7.34418,
         7.35796, 7.3634, 7.36196, 7.3554, 7.34489, 7.33166, 7.31668, 7.30081, 7.28407, 7.26624, 7.24821, 7.23046,
         7.21328, 7.19688, 7.18139, 7.16696, 7.15398, 7.14238, 7.13003, 7.11843, 7.10763, 7.09763, 7.08842, 7.07996,
         7.07222, 7.06516, 7.05874, 7.0529, 7.04762, 7.04284, 7.03853, 7.03465, 7.03113, 7.02795, 7.02503, 7.02238,
         7.02, 7.01785, 7.01591, 7.01418, 7.01263, 7.01123, 7.00999, 7.00888, 7.00789, 7.00701, 7.00622, 7.00552,
         7.00489, 7.00435, 7.00387, 7.00343, 7.00304, 7.00269, 7.00238, 7.0021, 7.00186, 7.00164, 7.00145, 7.00128,
         7.00113, 7.001, 7.00088, 7.00078, 7.00068, 7.0006, 7.00053, 7.00047, 7.00041, 7.00036, 7.00032, 7.00028,
         7.00025, 7.00022, 7.00019, 7.00017, 7.00015, 7.00013, 7.00012, 7.0001, 7.00009, 7.00008, 7.00007, 7.00006,
         7.00005, 7.00005, 7.00004, 7.00004, 7.00003, 7.00003, 7.00002, 7.00002],
        [0.0, 0.0, 0.0, 2.2815, 2.2891, 2.3575, 2.3922, 2.4252, 2.4553, 2.4814, 2.5024, 2.5171, 2.5248, 2.5246, 2.5157,
         2.4977, 2.4704, 2.4334, 2.387, 2.3769, 2.3646, 2.3613, 2.5098, 2.5052, 2.501, 2.481, 2.4598, 2.434, 2.4027,
         2.3648, 2.3181, 2.2628, 2.1993, 2.1284, 2.051, 1.9684, 1.8816, 1.7919, 1.7005, 1.6083, 1.5166, 1.426, 1.3374,
         1.2514, 1.1683, 1.0886, 1.012, 0.93899, 0.86967, 0.80415, 0.74248, 0.68462, 0.62932, 0.57532, 0.52549, 0.47959,
         0.43741, 0.39869, 0.36322, 0.33075, 0.30107, 0.27396, 0.24923, 0.22669, 0.20615, 0.20531, 0.20092, 0.19977,
         4.0314, 3.9626, 3.8543, 3.5663, 3.286, 3.0109, 2.7458, 2.4943, 2.2583, 2.0388, 1.836, 1.6498, 1.4796, 1.3248,
         1.1842, 1.0571, 0.94164, 0.83758, 0.74413, 0.66043, 0.58564, 0.51897, 0.45964, 0.40501, 0.35664, 0.31405,
         0.27654, 0.24352, 0.21445, 0.18884, 0.1663, 0.14645, 0.12829, 0.11184, 0.097505, 0.085005, 0.074107, 0.064606,
         0.056324, 0.049103, 0.042809, 0.037321, 0.032537, 0.028366, 0.02473, 0.02156, 0.018724, 0.016235, 0.01406,
         0.012128, 0.010461, 0.0090226, 0.0077825, 0.0067122, 0.0057889, 0.0049927, 0.004306, 0.0037138, 0.003203,
         0.0027624, 0.0023825, 0.0020548, 0.0017722, 0.0015285, 0.0013183, 0.0011327, 0.00097197, 0.00083408,
         0.00071576, 0.00061422, 0.00052709, 0.00045232, 0.00038815, 0.00033309, 0.00028584, 0.00024529, 0.0002105,
         0.00018064, 0.00015501, 0.00013303, 0.00011416, 9.7951e-05, 8.4023e-05, 7.2075e-05, 6.1826e-05, 5.3035e-05,
         4.5494e-05, 3.9025e-05, 3.3476e-05, 2.8716e-05, 2.4633e-05, 2.1131e-05, 1.8126e-05, 1.5549e-05, 1.3338e-05,
         1.1442e-05, 9.815e-06, 8.4195e-06, 7.2224e-06, 6.1956e-06, 5.3147e-06, 4.5591e-06, 3.9109e-06, 3.3549e-06,
         2.8779e-06, 2.4688e-06, 2.1178e-06]],
    'O':                                                                                                          [
        [0.006958, 0.0070645, 0.0070929, 0.0071355, 0.007242, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.023226, 0.0235815,
         0.0236763, 0.0238073, 0.0238185, 0.024174, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581,
         0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655,
         0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189,
         0.4484657, 0.4794098, 0.5124891, 0.52136, 0.52934, 0.531468, 0.53466, 0.54264, 0.5478508, 0.5856525, 0.6260625,
         0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098,
         1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848,
         2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467,
         5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212,
         11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338,
         24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159,
         51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239,
         106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156,
         222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [-2.2073, -3.19554, -4.32288, -3.22458, -2.2889, 0.21149, 0.432528, 0.641679, 0.84133, 1.03339, 1.21943, 1.4007,
         1.57805, 1.75182, 1.9214, 2.0843, 2.23222, 2.29401, 2.27485, 2.21999, 2.29056, 2.29549, 2.38419, 2.56373,
         2.77017, 2.97896, 3.19372, 3.41313, 3.63537, 3.85841, 4.08006, 4.29812, 4.51045, 4.71509, 4.91032, 5.09473,
         5.26727, 5.42719, 5.5741, 5.70887, 5.82981, 5.9383, 6.03498, 6.12073, 6.19637, 6.26258, 6.32029, 6.37066,
         6.41516, 6.44826, 6.46854, 6.4786, 6.48016, 6.47437, 6.46203, 6.44358, 6.41919, 6.38871, 6.35166, 6.30713,
         6.25366, 6.18896, 6.10952, 6.00975, 5.88028, 5.70405, 5.44549, 5.01012, 3.97074, 3.28506, 1.63837, -0.336417,
         1.71635, 3.5178, 4.05204, 5.74654, 6.55266, 7.0748, 7.44087, 7.70602, 7.9015, 8.0483, 8.16115, 8.24254,
         8.30267, 8.33861, 8.35935, 8.36902, 8.3705, 8.36596, 8.35705, 8.34592, 8.33198, 8.31689, 8.30145, 8.28581,
         8.26885, 8.25152, 8.23442, 8.21791, 8.20256, 8.18728, 8.17222, 8.15779, 8.14414, 8.13136, 8.11947, 8.10847,
         8.09834, 8.08903, 8.08051, 8.07273, 8.06564, 8.0592, 8.05336, 8.04808, 8.04333, 8.03905, 8.03513, 8.03154,
         8.02827, 8.0253, 8.02262, 8.02021, 8.01804, 8.01609, 8.01434, 8.01277, 8.01137, 8.01012, 8.009, 8.00801,
         8.00713, 8.00633, 8.00562, 8.00498, 8.00442, 8.00392, 8.00347, 8.00307, 8.00272, 8.0024, 8.00213, 8.00188,
         8.00166, 8.00147, 8.0013, 8.00114, 8.00101, 8.00089, 8.00079, 8.00069, 8.00061, 8.00054, 8.00048, 8.00042,
         8.00037, 8.00033, 8.00029, 8.00025, 8.00022, 8.0002, 8.00017, 8.00015, 8.00013, 8.00012, 8.0001, 8.00009,
         8.00008, 8.00007, 8.00006, 8.00005, 8.00005, 8.00004, 8.00004],
        [0.0, 0.0, 0.0, 2.1888, 2.2193, 2.8635, 2.9247, 2.9771, 3.0227, 3.0629, 3.0988, 3.1309, 3.1595, 3.1845, 3.2056,
         3.2222, 3.2335, 3.2375, 3.2384, 3.2385, 3.3643, 3.3645, 3.3716, 3.3962, 3.4281, 3.455, 3.4718, 3.4762, 3.4671,
         3.4438, 3.4059, 3.3536, 3.2873, 3.208, 3.117, 3.0157, 2.9059, 2.7892, 2.6674, 2.5423, 2.4154, 2.2881, 2.1619,
         2.0376, 1.9159, 1.7974, 1.6829, 1.5728, 1.4636, 1.343, 1.2306, 1.1262, 1.0297, 0.94068, 0.85876, 0.78355,
         0.71464, 0.65159, 0.59399, 0.54143, 0.49351, 0.44986, 0.41012, 0.37397, 0.3411, 0.31121, 0.28376, 0.25661,
         0.23191, 0.22593, 0.22075, 0.21941, 4.1067, 4.036, 3.9911, 3.6911, 3.3971, 3.1024, 2.8186, 2.5523, 2.3068,
         2.0831, 1.8753, 1.6834, 1.5016, 1.3385, 1.1926, 1.0621, 0.94552, 0.84147, 0.74865, 0.6659, 0.59217, 0.52651,
         0.46808, 0.41395, 0.36513, 0.32207, 0.28409, 0.25059, 0.21994, 0.19213, 0.16784, 0.14662, 0.12808, 0.11189,
         0.097749, 0.085394, 0.074601, 0.065172, 0.056936, 0.04974, 0.043455, 0.037964, 0.033166, 0.028976, 0.025277,
         0.021935, 0.018995, 0.016411, 0.014177, 0.012248, 0.010581, 0.0091406, 0.0078965, 0.0068218, 0.0058934,
         0.0050913, 0.0043984, 0.0037998, 0.0032827, 0.002836, 0.00245, 0.0021079, 0.001811, 0.001556, 0.0013368,
         0.0011486, 0.00098682, 0.00084786, 0.00072846, 0.00062588, 0.00053774, 0.00046201, 0.00039695, 0.00034106,
         0.00029303, 0.00025177, 0.00021632, 0.0001858, 0.00015948, 0.00013689, 0.0001175, 0.00010086, 8.6571e-05,
         7.4309e-05, 6.3783e-05, 5.4749e-05, 4.6994e-05, 4.0338e-05, 3.4625e-05, 2.9721e-05, 2.5511e-05, 2.1898e-05,
         1.8797e-05, 1.6135e-05, 1.3849e-05, 1.1888e-05, 1.0204e-05, 8.7592e-06, 7.5187e-06, 6.4539e-06, 5.5399e-06,
         4.7554e-06, 4.0819e-06]],
    'F':                                                                                                          [
        [0.008428, 0.008557, 0.0085914, 0.008643, 0.008772, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03038, 0.030845, 0.030969, 0.03109002, 0.031155, 0.03162, 0.03323523, 0.03552846,
         0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028,
         0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797,
         0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188,
         0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657,
         0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.671692, 0.681973, 0.6847146, 0.688827,
         0.699108, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098,
         1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848,
         2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467,
         5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212,
         11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338,
         24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159,
         51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239,
         106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156,
         222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [-2.53843, -3.50839, -4.60765, -3.54459, -2.64402, -1.03438, -0.785561, -0.555727, -0.335163, -0.118924,
         0.0958117, 0.310798, 0.527186, 0.745735, 0.966891, 1.19079, 1.41722, 1.64545, 1.87395, 2.1, 2.31315, 2.42332,
         2.42239, 2.37534, 2.42622, 2.45285, 2.55277, 2.77327, 3.04456, 3.31742, 3.59298, 3.87021, 4.14747, 4.42281,
         4.6941, 4.95919, 5.21598, 5.46254, 5.69718, 5.91853, 6.12552, 6.31749, 6.49407, 6.6551, 6.80118, 6.93272,
         7.05053, 7.1557, 7.24938, 7.33266, 7.40712, 7.47445, 7.52489, 7.55803, 7.57744, 7.58557, 7.5842, 7.57462,
         7.55776, 7.5342, 7.50422, 7.46776, 7.42436, 7.37312, 7.31248, 7.24, 7.15184, 7.04174, 6.8991, 6.704, 6.41337,
         5.90422, 4.46336, 4.27069, 2.57294, 0.52979, 2.66519, 4.54067, 5.64407, 7.044, 7.76036, 8.22518, 8.55284,
         8.79468, 8.97744, 9.11455, 9.21735, 9.28588, 9.33097, 9.35888, 9.37393, 9.37936, 9.37762, 9.37061, 9.36013,
         9.34689, 9.33207, 9.31652, 9.30109, 9.28588, 9.26977, 9.25188, 9.23378, 9.21598, 9.19881, 9.18245, 9.167,
         9.15253, 9.13905, 9.12654, 9.115, 9.10438, 9.09464, 9.08575, 9.07766, 9.07041, 9.06412, 9.05787, 9.05214,
         9.04693, 9.04219, 9.0379, 9.03403, 9.0305, 9.02731, 9.02442, 9.02183, 9.01949, 9.01739, 9.01551, 9.01382,
         9.01231, 9.01096, 9.00976, 9.00868, 9.00772, 9.00685, 9.00608, 9.00539, 9.00478, 9.00424, 9.00375, 9.00332,
         9.00294, 9.0026, 9.0023, 9.00204, 9.0018, 9.00159, 9.0014, 9.00124, 9.0011, 9.00097, 9.00085, 9.00075, 9.00066,
         9.00059, 9.00052, 9.00046, 9.0004, 9.00035, 9.00031, 9.00027, 9.00024, 9.00021, 9.00019, 9.00017, 9.00015,
         9.00013, 9.00011, 9.0001, 9.00009, 9.00008, 9.00007, 9.00006],
        [0.0, 0.0, 0.0, 2.13, 2.1646, 2.6472, 2.7969, 2.938, 3.071, 3.1962, 3.3139, 3.4245, 3.528, 3.6244, 3.7134,
         3.7948, 3.8678, 3.932, 3.9866, 4.0307, 4.0636, 4.0786, 4.0826, 4.0835, 4.2017, 4.2031, 4.2127, 4.2434, 4.2797,
         4.3029, 4.3112, 4.3036, 4.2796, 4.2389, 4.1815, 4.1078, 4.0186, 3.915, 3.7985, 3.6708, 3.5338, 3.3894, 3.2395,
         3.086, 2.9308, 2.7755, 2.6214, 2.4699, 2.3217, 2.1774, 2.038, 1.8939, 1.7353, 1.587, 1.449, 1.3211, 1.2031,
         1.0944, 0.99472, 0.90347, 0.82014, 0.74419, 0.67509, 0.61229, 0.55531, 0.50364, 0.45684, 0.41448, 0.37614,
         0.34148, 0.30993, 0.27941, 0.25176, 0.25034, 0.24446, 0.24292, 4.2681, 4.1803, 4.0471, 3.6853, 3.3518, 3.0432,
         2.7592, 2.4992, 2.2538, 2.0306, 1.8172, 1.6221, 1.4469, 1.2898, 1.1491, 1.0233, 0.91083, 0.8105, 0.72104,
         0.64132, 0.57033, 0.50714, 0.45093, 0.39862, 0.35055, 0.30702, 0.26891, 0.23553, 0.20629, 0.18068, 0.15825,
         0.13861, 0.12141, 0.10634, 0.093147, 0.08159, 0.071467, 0.062601, 0.054836, 0.048034, 0.041998, 0.036478,
         0.031684, 0.02752, 0.023903, 0.020762, 0.01798, 0.015549, 0.013445, 0.011626, 0.010053, 0.0086933, 0.0075172,
         0.0065003, 0.005621, 0.0048606, 0.0042031, 0.0036202, 0.0031141, 0.0026787, 0.0023042, 0.0019821, 0.001705,
         0.0014667, 0.0012616, 0.0010853, 0.00093356, 0.00080306, 0.00069081, 0.00059424, 0.00051118, 0.00043973,
         0.00037826, 0.00032542, 0.00028001, 0.00024094, 0.00020732, 0.00017839, 0.0001535, 0.00013208, 0.00011365,
         9.7791e-05, 8.4146e-05, 7.2405e-05, 6.2302e-05, 5.3609e-05, 4.6129e-05, 3.9693e-05, 3.4155e-05, 2.9389e-05,
         2.5289e-05, 2.176e-05, 1.8724e-05, 1.6112e-05, 1.3864e-05, 1.193e-05, 1.0265e-05, 8.8331e-06, 7.6007e-06]],
    'Ne':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.017934,
         0.0182085, 0.01823053, 0.0182817, 0.0183915, 0.018666, 0.01948844, 0.02083314, 0.02227063, 0.0238073,
         0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198,
         0.0441, 0.044775, 0.044955, 0.045225, 0.0459, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581,
         0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655,
         0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189,
         0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768,
         0.849562, 0.8625655, 0.8660331, 0.8712345, 0.8739896, 0.884238, 0.9342948, 0.9987612, 1.067676, 1.141345,
         1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781,
         2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664,
         5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004,
         11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988,
         22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101,
         47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374,
         99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018,
         207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001,
         432.9451],
        [0.514761, 0.433365, 0.333357, 0.208132, 0.0470096, -0.169204, -0.481386, -1.01047, -1.97188, -2.99087,
         -3.18853, -4.13413, -3.04138, -2.12394, -1.40016, -0.964316, -0.695045, -0.470803, -0.254421, -0.0293826,
         0.212777, 0.476291, 0.762562, 1.07065, 1.39717, 1.7349, 2.06269, 2.12873, 2.15951, 2.1216, 2.21023, 2.33986,
         2.41484, 2.83688, 3.2525, 3.67274, 4.09378, 4.51362, 4.92887, 5.33657, 5.73279, 6.11057, 6.46494, 6.79261,
         7.09156, 7.36082, 7.60028, 7.81058, 7.99292, 8.14807, 8.27968, 8.38901, 8.47827, 8.54971, 8.60523, 8.64653,
         8.67533, 8.69321, 8.70161, 8.70179, 8.69485, 8.68175, 8.66338, 8.63782, 8.60277, 8.55918, 8.50711, 8.44583,
         8.37371, 8.2879, 8.18372, 8.05325, 7.88235, 7.64279, 7.26655, 6.51081, 5.3179, 3.62497, 1.59294, 3.70829,
         4.35896, 5.56519, 7.48184, 8.47076, 9.07296, 9.474, 9.75622, 9.95856, 10.105, 10.2131, 10.2871, 10.3356,
         10.3659, 10.3828, 10.3896, 10.389, 10.383, 10.3731, 10.3599, 10.3456, 10.3349, 10.3186, 10.3011, 10.2822,
         10.2628, 10.2434, 10.2247, 10.2067, 10.1896, 10.1736, 10.1586, 10.1447, 10.1319, 10.12, 10.1091, 10.0992,
         10.0903, 10.0818, 10.074, 10.0668, 10.0602, 10.0542, 10.0487, 10.0438, 10.0393, 10.0353, 10.0316, 10.0283,
         10.0253, 10.0226, 10.0202, 10.018, 10.0161, 10.0144, 10.0128, 10.0114, 10.0101, 10.009, 10.008, 10.0071,
         10.0063, 10.0056, 10.005, 10.0044, 10.0039, 10.0034, 10.0031, 10.0027, 10.0024, 10.0021, 10.0019, 10.0016,
         10.0015, 10.0013, 10.0011, 10.001, 10.0009, 10.0008, 10.0007, 10.0006, 10.0005, 10.0005, 10.0004, 10.0004,
         10.0003, 10.0003, 10.0003, 10.0002, 10.0002, 10.0002, 10.0002, 10.0001, 10.0001, 10.0001, 10.0001],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.2083, 2.2523, 2.3856, 2.6068, 2.8426, 3.0893,
         3.3431, 3.5995, 3.8537, 4.1006, 4.3349, 4.5515, 4.7454, 4.9122, 5.0483, 5.076, 5.1005, 5.1067, 5.2321, 5.2606,
         5.2805, 5.3892, 5.4705, 5.5205, 5.5384, 5.5237, 5.4767, 5.3983, 5.286, 5.1415, 4.9692, 4.7741, 4.5611, 4.335,
         4.1003, 3.8613, 3.6215, 3.3842, 3.152, 2.927, 2.7109, 2.5047, 2.3089, 2.1241, 1.9506, 1.7886, 1.6378, 1.498,
         1.3688, 1.2497, 1.1402, 1.0288, 0.92751, 0.83571, 0.75265, 0.67764, 0.60999, 0.54905, 0.49421, 0.4449, 0.40059,
         0.36079, 0.32506, 0.29299, 0.27594, 0.26917, 0.26742, 4.2677, 4.251, 4.1899, 3.913, 3.5924, 3.2552, 2.9372,
         2.6424, 2.3724, 2.1276, 1.9048, 1.6988, 1.5147, 1.3502, 1.2033, 1.0721, 0.9549, 0.85029, 0.75695, 0.6737,
         0.5995, 0.53135, 0.46926, 0.41343, 0.36257, 0.31798, 0.27888, 0.24459, 0.21452, 0.18815, 0.16502, 0.14474,
         0.12696, 0.11136, 0.097675, 0.085676, 0.075151, 0.065788, 0.057186, 0.049709, 0.04321, 0.037561, 0.03265,
         0.028382, 0.024672, 0.021447, 0.01863, 0.016125, 0.013956, 0.012079, 0.010454, 0.0090465, 0.0078288, 0.006775,
         0.0058415, 0.0050307, 0.0043323, 0.003731, 0.0032131, 0.0027671, 0.002383, 0.0020523, 0.0017674, 0.0015221,
         0.0013109, 0.0011289, 0.00097225, 0.00083732, 0.00072111, 0.00062104, 0.00053516, 0.00046175, 0.0003984,
         0.00034375, 0.0002966, 0.00025591, 0.00022081, 0.00019052, 0.00016439, 0.00014184, 0.00012238, 0.0001056,
         9.1113e-05, 7.8615e-05, 6.7832e-05, 5.8528e-05, 5.05e-05, 4.3573e-05, 3.7597e-05, 3.244e-05, 2.799e-05,
         2.4151e-05, 2.0839e-05, 1.798e-05, 1.5514e-05, 1.3386e-05]],
    'Na':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.030478, 0.0309445,
         0.03109002, 0.0312555, 0.031722, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.062034, 0.0629835, 0.0632367, 0.0636165, 0.064566,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581,
         0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655,
         0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189,
         0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768,
         0.8739896, 0.9342948, 0.9987612, 1.050658, 1.067676, 1.071028, 1.077461, 1.093542, 1.141345, 1.220098,
         1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848,
         2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467,
         5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212,
         11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338,
         24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159,
         51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239,
         106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156,
         222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [1.48693, 1.46241, 1.43394, 1.4008, 1.36209, 1.3167, 1.26325, 1.19992, 1.12436, 1.03337, 0.922475, 0.785105,
         0.610932, 0.382047, 0.061915, -0.452629, -1.22048, -1.96928, -3.28343, -2.07435, -1.5487, -1.24532, -1.15725,
         -1.06542, -0.90935, -0.670261, -0.344944, 0.0601422, 0.530816, 1.04425, 1.55378, 1.69884, 1.71644, 1.61823,
         1.79758, 2.03826, 2.07828, 2.80061, 3.48119, 4.14972, 4.79962, 5.42266, 6.01127, 6.56006, 7.06488, 7.52371,
         7.93649, 8.30337, 8.62338, 8.89786, 9.12956, 9.322, 9.47902, 9.60562, 9.7036, 9.77764, 9.83116, 9.86727,
         9.88851, 9.89698, 9.89457, 9.88287, 9.86321, 9.8366, 9.80379, 9.76525, 9.72113, 9.6713, 9.61523, 9.55196,
         9.47867, 9.39178, 9.2874, 9.15862, 8.99314, 8.76706, 8.42597, 7.7997, 6.52412, 4.91181, 3.52095, 4.89062,
         6.12496, 7.70749, 9.32686, 10.2655, 10.6769, 10.85, 10.968, 11.054, 11.1263, 11.1914, 11.2505, 11.3511,
         11.3777, 11.3894, 11.3918, 11.388, 11.3852, 11.3721, 11.3556, 11.3373, 11.3182, 11.2991, 11.2804, 11.2619,
         11.243, 11.2245, 11.2068, 11.1899, 11.174, 11.1591, 11.1453, 11.1325, 11.1217, 11.1112, 11.1009, 11.0913,
         11.0825, 11.0744, 11.0671, 11.0604, 11.0543, 11.0487, 11.0438, 11.0393, 11.0352, 11.0315, 11.0283, 11.0253,
         11.0226, 11.0202, 11.0181, 11.0161, 11.0143, 11.0128, 11.0114, 11.0101, 11.009, 11.008, 11.0071, 11.0063,
         11.0056, 11.0049, 11.0044, 11.0039, 11.0034, 11.003, 11.0027, 11.0024, 11.0021, 11.0019, 11.0016, 11.0015,
         11.0013, 11.0011, 11.001, 11.0009, 11.0008, 11.0007, 11.0006, 11.0005, 11.0005, 11.0004, 11.0004, 11.0003,
         11.0003, 11.0002, 11.0002, 11.0002, 11.0002, 11.0001, 11.0001],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4752, 1.558,
         1.8498, 2.3528, 2.9049, 3.4793, 4.0538, 4.6061, 5.1157, 5.5651, 5.9411, 6.2352, 6.3186, 6.3666, 6.3785, 6.6559,
         6.709, 6.7198, 6.9123, 7.033, 7.0772, 7.0494, 6.956, 6.8045, 6.6036, 6.3621, 6.0888, 5.7918, 5.4758, 5.1475,
         4.8145, 4.483, 4.1579, 3.8431, 3.5414, 3.2547, 2.9844, 2.7312, 2.495, 2.2755, 2.0722, 1.8846, 1.7121, 1.5539,
         1.409, 1.2767, 1.1561, 1.0463, 0.94647, 0.85583, 0.77342, 0.69457, 0.62355, 0.55968, 0.50234, 0.45092, 0.40486,
         0.36364, 0.32676, 0.29882, 0.29049, 0.2889, 3.3468, 3.6044, 4.222, 4.0897, 3.5285, 2.9168, 2.5451, 2.2568,
         2.0296, 1.8413, 1.6757, 1.5228, 1.3668, 1.2171, 1.0838, 0.96513, 0.85948, 0.76236, 0.6737, 0.59538, 0.52617,
         0.46503, 0.411, 0.36326, 0.31883, 0.27975, 0.24548, 0.2154, 0.18902, 0.16587, 0.14555, 0.12773, 0.11209,
         0.098173, 0.085365, 0.074228, 0.064546, 0.056127, 0.048806, 0.042441, 0.036907, 0.032094, 0.027909, 0.02427,
         0.021106, 0.018354, 0.015961, 0.013875, 0.012014, 0.010402, 0.00898, 0.0077433, 0.0066761, 0.005756, 0.0049627,
         0.0042788, 0.0036891, 0.0031807, 0.0027424, 0.0023645, 0.0020387, 0.0017577, 0.0015155, 0.0013067, 0.0011267,
         0.00097142, 0.00083757, 0.00072216, 0.00062266, 0.00053687, 0.0004629, 0.00039913, 0.00034414, 0.00029672,
         0.00025584, 0.0002206, 0.0001902, 0.000164, 0.00014141, 0.00012193, 0.00010513, 9.0646e-05, 7.8159e-05,
         6.7391e-05, 5.8108e-05, 5.0103e-05, 4.3201e-05, 3.725e-05, 3.2118e-05, 2.7694e-05, 2.3879e-05, 2.059e-05]],
    'Mg':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.050372, 0.051143, 0.0513486,
         0.051657, 0.052428, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411,
         0.08458368, 0.087612, 0.088953, 0.0893106, 0.089847, 0.09041995, 0.091188, 0.09665893, 0.1033284, 0.1104581,
         0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655,
         0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189,
         0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768,
         0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.2789, 1.298475, 1.304285, 1.311525, 1.3311,
         1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235,
         2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855,
         6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334,
         12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923,
         26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542,
         54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353,
         113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548,
         237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [2.46798, 2.45703, 2.44446, 2.42999, 2.41334, 2.39414, 2.37197, 2.34635, 2.31667, 2.28222, 2.24214, 2.19535,
         2.14053, 2.07604, 1.99976, 1.90893, 1.79989, 1.6676, 1.50483, 1.30071, 1.0375, 0.68272, 0.163175, -0.79466,
         -1.23235, -2.14633, -3.06571, -2.31811, -1.77102, -1.65181, -1.58097, -1.5153, -1.24345, -0.75002, -0.0657205,
         0.745736, 1.5776, 1.91414, 1.87327, 1.62388, 2.01523, 2.26495, 2.49637, 3.62633, 4.71331, 5.69293, 6.56897,
         7.34102, 8.01184, 8.58744, 9.07657, 9.48729, 9.82965, 10.1128, 10.3452, 10.5347, 10.6868, 10.8064, 10.8979,
         10.9658, 11.0131, 11.0431, 11.0586, 11.0617, 11.0544, 11.0378, 11.0132, 10.9815, 10.9433, 10.8992, 10.8494,
         10.7938, 10.7317, 10.6624, 10.5839, 10.4938, 10.3877, 10.2587, 10.0942, 9.86553, 9.51607, 8.85649, 7.57149,
         5.98525, 3.41984, 5.92695, 7.57432, 9.30219, 10.4949, 11.169, 11.5495, 11.7834, 11.9494, 12.0708, 12.1624,
         12.2323, 12.2852, 12.3707, 12.3918, 12.4049, 12.4053, 12.3973, 12.3843, 12.3682, 12.3501, 12.331, 12.3116,
         12.2924, 12.274, 12.2558, 12.2374, 12.2194, 12.2022, 12.186, 12.171, 12.157, 12.1436, 12.1308, 12.1189,
         12.1078, 12.0976, 12.0882, 12.0796, 12.0718, 12.0646, 12.0581, 12.0522, 12.0469, 12.0421, 12.0378, 12.0339,
         12.0304, 12.0272, 12.0244, 12.0218, 12.0195, 12.0174, 12.0155, 12.0138, 12.0123, 12.0109, 12.0097, 12.0086,
         12.0077, 12.0068, 12.006, 12.0053, 12.0047, 12.0042, 12.0037, 12.0033, 12.0029, 12.0026, 12.0023, 12.002,
         12.0018, 12.0016, 12.0014, 12.0012, 12.0011, 12.001, 12.0008, 12.0007, 12.0007, 12.0006, 12.0005, 12.0005,
         12.0004, 12.0004, 12.0003, 12.0003, 12.0002, 12.0002, 12.0002],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
         0.0, 0.0, 0.0, 0.0, 0.0, 1.7107, 1.8464, 1.9565, 2.7595, 3.7482, 4.7712, 5.7446, 6.5956, 7.2727, 7.7495,
         7.9183, 7.9741, 7.9871, 8.608, 8.6311, 8.6592, 8.7766, 8.7615, 8.6076, 8.3455, 8.0043, 7.6096, 7.1826, 6.7401,
         6.2947, 5.8557, 5.4298, 5.0212, 4.632, 4.2624, 3.9136, 3.5864, 3.2807, 2.9961, 2.7321, 2.4878, 2.2623, 2.0544,
         1.8629, 1.6872, 1.5262, 1.3791, 1.245, 1.123, 1.0123, 0.91188, 0.82108, 0.73909, 0.66515, 0.59857, 0.5387,
         0.48399, 0.42897, 0.38061, 0.33816, 0.31133, 0.30318, 0.30083, 3.9592, 3.9913, 3.9993, 3.6712, 3.2546, 2.8511,
         2.5397, 2.2732, 2.0422, 1.8378, 1.6539, 1.4866, 1.3291, 1.185, 1.0522, 0.93089, 0.82358, 0.72867, 0.64473,
         0.57048, 0.50479, 0.44669, 0.39528, 0.34977, 0.30719, 0.26981, 0.23698, 0.20815, 0.18283, 0.1606, 0.14079,
         0.12254, 0.10666, 0.092844, 0.080816, 0.070348, 0.061236, 0.053306, 0.046403, 0.040394, 0.035164, 0.030611,
         0.026648, 0.023199, 0.020196, 0.017582, 0.015306, 0.013269, 0.011454, 0.0098871, 0.0085347, 0.0073674,
         0.0063597, 0.0054892, 0.0047372, 0.0040882, 0.0035282, 0.0030449, 0.0026278, 0.0022678, 0.0019572, 0.0016891,
         0.0014577, 0.001258, 0.0010857, 0.00093701, 0.00080867, 0.00069791, 0.00060232, 0.00051983, 0.00044863,
         0.00038719, 0.00033416, 0.00028839, 0.0002489, 0.00021481, 0.00018539, 0.00016, 0.00013809, 0.00011918,
         0.00010286, 8.8772e-05, 7.6615e-05, 6.6123e-05, 5.7068e-05, 4.9253e-05, 4.2508e-05, 3.6687e-05, 3.1663e-05]],
    'Al':                                                                                                         [
        [0.008208152, 0.008333787, 0.00836729, 0.008417543, 0.008543178, 0.01069, 0.01142761, 0.01221612, 0.01305903,
         0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073,
         0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198,
         0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.071638, 0.0727345,
         0.0730269, 0.0734655, 0.07401695, 0.074562, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284,
         0.1104581, 0.115346, 0.1171115, 0.1175823, 0.1180797, 0.1182885, 0.120054, 0.1262272, 0.1349368, 0.1442475,
         0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158,
         0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508,
         0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676,
         1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.528408, 1.551802, 1.55804, 1.567398, 1.590792, 1.593329,
         1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406,
         3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365,
         7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688,
         15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405,
         32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287,
         66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669,
         139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869,
         290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [3.11903, 3.07927, 3.02769, 3.08902, 3.1416, 3.16731, 3.1565, 3.14495, 3.1324, 3.11858, 3.10318, 3.08594,
         3.06659, 3.04487, 3.02055, 2.99341, 2.96319, 2.92964, 2.89315, 2.85179, 2.80561, 2.75366, 2.69458, 2.62647,
         2.54633, 2.45013, 2.33262, 2.18672, 2.00256, 1.76493, 1.44912, 1.01038, 0.349959, -0.855994, -2.2552, -4.06506,
         -6.02938, -4.25024, -3.26725, -2.79918, -1.53427, -0.805339, -0.0106801, 0.882403, 1.83035, 2.73433, 3.13128,
         2.99611, 2.62299, 3.00312, 3.14862, 3.75272, 4.87197, 6.04241, 7.06078, 7.95326, 8.72829, 9.39304, 9.95657,
         10.429, 10.8209, 11.1424, 11.4037, 11.6133, 11.7794, 11.909, 12.0075, 12.0791, 12.1278, 12.1573, 12.1706,
         12.1704, 12.159, 12.1381, 12.1089, 12.0725, 12.0297, 11.9809, 11.9265, 11.8662, 11.7996, 11.7255, 11.642,
         11.5461, 11.4444, 11.3023, 11.1171, 10.8582, 10.446, 9.55217, 8.67724, 7.08006, 5.18127, 7.0582, 8.76616,
         8.86568, 10.9116, 11.8026, 12.3246, 12.6397, 12.8559, 13.0119, 13.1269, 13.2127, 13.2769, 13.3285, 13.4011,
         13.4116, 13.4114, 13.4039, 13.3916, 13.3759, 13.3581, 13.3392, 13.3198, 13.3004, 13.2816, 13.2637, 13.2456,
         13.2277, 13.2105, 13.1945, 13.1795, 13.1646, 13.1503, 13.1369, 13.1243, 13.1128, 13.1021, 13.0923, 13.0833,
         13.0752, 13.0677, 13.061, 13.0548, 13.0493, 13.0443, 13.0397, 13.0358, 13.0321, 13.0288, 13.0258, 13.0231,
         13.0206, 13.0184, 13.0164, 13.0146, 13.013, 13.0116, 13.0103, 13.0091, 13.0081, 13.0072, 13.0064, 13.0057,
         13.005, 13.0045, 13.004, 13.0035, 13.0031, 13.0027, 13.0024, 13.0022, 13.0019, 13.0017, 13.0015, 13.0013,
         13.0012, 13.001, 13.0009, 13.0008, 13.0007, 13.0006, 13.0005, 13.0005, 13.0004, 13.0004, 13.0003, 13.0003,
         13.0003],
        [0.0, 0.0, 0.0, 0.10319, 0.090457, 0.018351, 0.01505, 0.013667, 0.01348, 0.0142, 0.015741, 0.018134, 0.021472,
         0.025892, 0.031548, 0.038589, 0.04713, 0.057225, 0.068841, 0.08183, 0.095929, 0.11075, 0.12583, 0.14038,
         0.15354, 0.1649, 0.17418, 0.18132, 0.18615, 0.1883, 0.18825, 0.1863, 0.18275, 0.17794, 0.17511, 0.17377,
         0.17342, 3.9275, 4.0145, 4.1018, 4.8866, 5.8791, 6.7792, 7.5222, 8.0732, 8.4204, 8.5391, 8.5619, 8.5664,
         9.4208, 9.4235, 9.4411, 9.441, 9.3134, 9.0606, 8.7125, 8.2962, 7.8365, 7.3536, 6.8631, 6.3766, 5.9026, 5.447,
         5.0136, 4.6044, 4.2203, 3.8603, 3.5244, 3.2123, 2.9236, 2.6572, 2.4121, 2.1872, 1.9809, 1.7921, 1.6196, 1.4625,
         1.3197, 1.1901, 1.0727, 0.96659, 0.87081, 0.7845, 0.70682, 0.62898, 0.56009, 0.49919, 0.44531, 0.39707,
         0.35292, 0.33771, 0.32887, 0.32657, 4.0561, 4.034, 4.0316, 3.8047, 3.4335, 3.0522, 2.7132, 2.4305, 2.1807,
         1.9587, 1.7592, 1.5787, 1.4117, 1.2507, 1.1075, 0.98077, 0.86856, 0.76922, 0.68127, 0.60341, 0.53446, 0.47341,
         0.41935, 0.37148, 0.32822, 0.28857, 0.25373, 0.22309, 0.1958, 0.1707, 0.14882, 0.12975, 0.11313, 0.098639,
         0.086005, 0.07499, 0.065387, 0.057015, 0.049716, 0.043351, 0.037802, 0.032964, 0.028745, 0.025066, 0.021859,
         0.018978, 0.016453, 0.014264, 0.012344, 0.01066, 0.0092057, 0.0079499, 0.0068656, 0.0059291, 0.0051204,
         0.0044218, 0.003818, 0.0032967, 0.0028466, 0.0024579, 0.0021224, 0.0018326, 0.0015824, 0.0013664, 0.0011798,
         0.0010188, 0.00087971, 0.00075962, 0.00065593, 0.00056639, 0.00048908, 0.00042232, 0.00036468, 0.0003149,
         0.00027192, 0.00023481, 0.00020276, 0.00017508, 0.00015119, 0.00013055, 0.00011274, 9.735e-05, 8.4064e-05,
         7.2591e-05, 6.2685e-05, 5.413e-05, 4.6743e-05]],
    'Si':                                                                                                         [
        [0.004981393, 0.005057639, 0.005077971, 0.005108469, 0.005184715, 0.01069, 0.01113003, 0.01130038, 0.01134581,
         0.01141396, 0.01142761, 0.01158431, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382,
         0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002,
         0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876,
         0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.097216,
         0.098704, 0.0991008, 0.099696, 0.101184, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475,
         0.145726, 0.1479565, 0.1485513, 0.1494435, 0.151674, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709,
         0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405,
         0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052,
         0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486,
         1.593329, 1.703269, 1.802122, 1.820795, 1.829705, 1.837061, 1.848094, 1.875678, 1.94643, 2.080733, 2.224304,
         2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924,
         4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919,
         10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215,
         21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992,
         44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069,
         93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539,
         194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588,
         405.0001, 432.9451],
        [0.550431, -0.320849, -1.28029, -0.407656, 0.319503, 4.49043, 4.41607, 4.38482, 4.37198, 4.36769, 4.36646,
         4.34801, 4.26861, 4.17557, 4.09293, 4.02013, 3.95663, 3.89925, 3.84744, 3.79998, 3.75582, 3.71414, 3.67429,
         3.63561, 3.59745, 3.55913, 3.51987, 3.47876, 3.43487, 3.38651, 3.33221, 3.26991, 3.19712, 3.11054, 3.00579,
         2.87721, 2.71713, 2.51474, 2.2539, 1.9088, 1.43406, 0.737405, -0.423197, -3.28171, -3.84572, -6.95115,
         -10.4791, -7.07666, -4.18129, -2.6747, -0.473104, 1.02847, 2.34527, 3.5162, 4.39577, 4.44809, 4.27331, 3.83506,
         4.43854, 5.11882, 5.58201, 6.95675, 8.06341, 9.0093, 9.82004, 10.5105, 11.0929, 11.5791, 11.9807, 12.3087,
         12.5735, 12.7839, 12.9483, 13.0739, 13.167, 13.2331, 13.2758, 13.2987, 13.3048, 13.2972, 13.2781, 13.2495,
         13.213, 13.1695, 13.1201, 13.0654, 13.0058, 12.9418, 12.8743, 12.7932, 12.6978, 12.5861, 12.4527, 12.2868,
         12.0669, 11.7442, 11.1665, 9.77316, 8.96867, 8.18207, 6.28036, 8.18045, 9.90765, 11.353, 12.5086, 13.132,
         13.5165, 13.772, 13.9567, 14.0941, 14.1991, 14.2699, 14.3185, 14.3972, 14.4122, 14.4148, 14.4092, 14.398,
         14.383, 14.3657, 14.347, 14.3275, 14.308, 14.289, 14.2709, 14.2537, 14.2373, 14.2193, 14.2018, 14.185, 14.1691,
         14.1542, 14.1404, 14.1275, 14.1156, 14.1047, 14.0947, 14.0856, 14.0772, 14.0696, 14.0628, 14.0566, 14.0511,
         14.0462, 14.0415, 14.0372, 14.0333, 14.0298, 14.0267, 14.0239, 14.0213, 14.0191, 14.017, 14.0151, 14.0135,
         14.012, 14.0107, 14.0095, 14.0084, 14.0075, 14.0066, 14.0059, 14.0052, 14.0046, 14.0041, 14.0036, 14.0032,
         14.0029, 14.0025, 14.0022, 14.002, 14.0017, 14.0015, 14.0014, 14.0012, 14.0011, 14.0009, 14.0008, 14.0007,
         14.0006, 14.0006, 14.0005, 14.0004, 14.0004, 14.0003],
        [0.0, 0.0, 0.0, 1.8433, 1.9476, 0.49472, 0.40981, 0.38216, 0.37522, 0.37687, 0.37492, 0.3536, 0.28398, 0.22096,
         0.17788, 0.149, 0.13038, 0.11936, 0.11415, 0.11354, 0.11673, 0.12324, 0.13259, 0.14434, 0.15811, 0.17351,
         0.19016, 0.20768, 0.22566, 0.24374, 0.26154, 0.27876, 0.29508, 0.31003, 0.32339, 0.33506, 0.34502, 0.35326,
         0.35981, 0.36472, 0.36805, 0.36987, 0.37026, 0.36804, 0.36732, 0.36535, 0.36481, 7.2061, 7.3507, 7.5606,
         8.2681, 8.8713, 9.2705, 9.468, 9.48, 9.467, 9.4409, 9.4327, 10.408, 10.379, 10.338, 10.098, 9.7527, 9.3252,
         8.8416, 8.3235, 7.7878, 7.2498, 6.7202, 6.2068, 5.715, 5.2483, 4.8086, 4.3969, 4.0133, 3.6568, 3.3258, 3.02,
         2.7385, 2.4802, 2.2438, 2.028, 1.8311, 1.6519, 1.4894, 1.3422, 1.2092, 1.0893, 0.98137, 0.87137, 0.7742,
         0.68851, 0.61287, 0.54605, 0.48696, 0.43467, 0.38835, 0.3533, 0.34728, 0.34446, 0.34216, 4.0819, 4.0304,
         3.8896, 3.5283, 3.1614, 2.8224, 2.5325, 2.2762, 2.0459, 1.8323, 1.6363, 1.4614, 1.2999, 1.1509, 1.019, 0.90223,
         0.7989, 0.70743, 0.62644, 0.55475, 0.49128, 0.43509, 0.38534, 0.34129, 0.30059, 0.26409, 0.2306, 0.20136,
         0.17583, 0.15354, 0.13408, 0.11709, 0.10225, 0.089301, 0.07799, 0.068113, 0.059487, 0.051955, 0.045377,
         0.039633, 0.034616, 0.030235, 0.026276, 0.022797, 0.019779, 0.017161, 0.01489, 0.012919, 0.01116, 0.00964,
         0.0083272, 0.0071932, 0.0062137, 0.0053676, 0.0046367, 0.0040054, 0.0034605, 0.0029899, 0.0025832, 0.0022319,
         0.0019284, 0.0016662, 0.0014396, 0.0012438, 0.0010747, 0.00092859, 0.00080234, 0.00069326, 0.00059902,
         0.00051758, 0.00044723, 0.00038643, 0.00033391, 0.00028852, 0.00024931, 0.00021542, 0.00018614, 0.00016085,
         0.00013899, 0.0001201, 0.00010378, 8.9678e-05, 7.7492e-05, 6.6963e-05]],
    'P':                                                                                                          [
        [0.006209957, 0.006257232, 0.006305007, 0.006330354, 0.006353005, 0.006368374, 0.006378545, 0.006416855,
         0.006463425, 0.006512629, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01417226, 0.01438918,
         0.01444703, 0.0145338, 0.01475072, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314,
         0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993,
         0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942,
         0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272,
         0.129556, 0.131539, 0.1320678, 0.132861, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.185514,
         0.1883732, 0.1891107, 0.1902465, 0.193086, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158,
         0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508,
         0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676,
         1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.10259,
         2.134772, 2.143354, 2.156227, 2.18841, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406,
         3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365,
         7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688,
         15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405,
         32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287,
         66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669,
         139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869,
         290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [-1.26929, -1.66855, -2.31139, -3.07745, -3.18301, -3.42247, -3.94072, -2.90422, -2.33032, -2.02658, 6.73661,
         6.70372, 6.52061, 6.2759, 6.02132, 5.96539, 5.91002, 5.89549, 5.87424, 5.82233, 5.7824, 5.56893, 5.382,
         5.21926, 5.07806, 4.95436, 4.84692, 4.75458, 4.67639, 4.61122, 4.55762, 4.51357, 4.47659, 4.44405, 4.41334,
         4.38215, 4.34843, 4.30977, 4.26427, 4.20979, 4.14493, 4.067, 3.97288, 3.85846, 3.71823, 3.54439, 3.32567,
         3.04495, 2.67477, 2.16732, 1.42815, 0.226515, -2.33819, -4.8695, -9.24896, -14.359, -9.2459, -4.70611,
         0.239838, 2.55586, 4.24825, 5.53947, 6.11355, 5.89518, 5.40553, 6.07332, 6.81272, 7.90149, 9.14404, 10.1493,
         10.9897, 11.6948, 12.2841, 12.7723, 13.1729, 13.4977, 13.7575, 13.9617, 14.1172, 14.2345, 14.3183, 14.3744,
         14.4075, 14.423, 14.4202, 14.4036, 14.3758, 14.339, 14.2948, 14.2446, 14.1907, 14.1474, 14.0846, 14.0043,
         13.914, 13.8136, 13.7007, 13.5703, 13.4131, 13.2121, 12.9304, 12.4678, 11.3134, 10.8633, 9.28431, 7.39192,
         9.29308, 11.0202, 11.8112, 13.2998, 14.0078, 14.4377, 14.725, 14.9354, 15.0821, 15.1854, 15.2583, 15.3093,
         15.3912, 15.4105, 15.4155, 15.4114, 15.4013, 15.3871, 15.3703, 15.3519, 15.3326, 15.3133, 15.2943, 15.2766,
         15.259, 15.2404, 15.222, 15.2041, 15.187, 15.171, 15.1559, 15.1419, 15.129, 15.117, 15.1061, 15.096, 15.0869,
         15.0785, 15.071, 15.0642, 15.0579, 15.0521, 15.0469, 15.0421, 15.0377, 15.0338, 15.0303, 15.0271, 15.0242,
         15.0216, 15.0193, 15.0172, 15.0154, 15.0137, 15.0122, 15.0108, 15.0096, 15.0085, 15.0076, 15.0067, 15.006,
         15.0053, 15.0047, 15.0042, 15.0037, 15.0033, 15.0029, 15.0026, 15.0023, 15.002, 15.0018, 15.0016, 15.0014,
         15.0012, 15.0011, 15.001, 15.0008, 15.0007, 15.0007, 15.0006, 15.0005, 15.0005],
        [0.0, 0.0, 0.0, 0.0, 0.94416, 0.95617, 0.96419, 2.9193, 3.0314, 3.1536, 3.073, 2.2393, 1.6032, 1.1415, 0.81618,
         0.75768, 0.70351, 0.68995, 0.67052, 0.62463, 0.59118, 0.43681, 0.33202, 0.26246, 0.21892, 0.19555, 0.18825,
         0.19364, 0.20852, 0.22988, 0.25483, 0.28079, 0.30586, 0.32885, 0.34935, 0.36723, 0.38272, 0.39627, 0.40847,
         0.42008, 0.43148, 0.44289, 0.45446, 0.46625, 0.4782, 0.49011, 0.50174, 0.51277, 0.52288, 0.53177, 0.53914,
         0.54479, 0.53712, 0.53236, 0.52939, 0.52859, 10.516, 10.551, 10.704, 10.79, 10.709, 10.481, 10.223, 10.134,
         10.111, 11.179, 11.093, 10.828, 10.352, 9.8221, 9.2561, 8.6714, 8.0814, 7.4974, 6.9286, 6.3813, 5.8599, 5.3671,
         4.9045, 4.4727, 4.0715, 3.7002, 3.3577, 3.0418, 2.7517, 2.4862, 2.2441, 2.0239, 1.8239, 1.6428, 1.4792, 1.3319,
         1.1806, 1.0473, 0.93, 0.82665, 0.73553, 0.65511, 0.58408, 0.52128, 0.4657, 0.41646, 0.37279, 0.36641, 0.35735,
         0.355, 4.0785, 4.0118, 3.9399, 3.5859, 3.2218, 2.887, 2.5936, 2.3262, 2.0806, 1.8611, 1.664, 1.4879, 1.3284,
         1.1761, 1.0413, 0.92199, 0.8164, 0.72293, 0.6402, 0.56693, 0.50207, 0.44464, 0.3938, 0.34826, 0.30528, 0.26689,
         0.23334, 0.20401, 0.17838, 0.15596, 0.13637, 0.11924, 0.10427, 0.091177, 0.079731, 0.069723, 0.060972,
         0.053321, 0.04663, 0.04078, 0.035454, 0.030764, 0.026694, 0.023164, 0.0201, 0.017442, 0.015135, 0.013134,
         0.011368, 0.0098273, 0.0084957, 0.0073447, 0.0063496, 0.0054893, 0.0047457, 0.0041028, 0.0035473, 0.0030675,
         0.0026527, 0.002294, 0.0019838, 0.0017155, 0.0014836, 0.001283, 0.0011096, 0.00095957, 0.00082986, 0.00071769,
         0.00062069, 0.0005368, 0.00046426, 0.00040152, 0.00034726, 0.00030034, 0.00025976, 0.00022466, 0.00019431,
         0.00016806, 0.00014536, 0.00012572, 0.00010874, 9.4055e-05]],
    'S':                                                                                                          [
        [0.00758018, 0.007657359, 0.007696204, 0.007727143, 0.007774563, 0.007805818, 0.0078527, 0.007889576,
         0.007969904, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382,
         0.01733447, 0.01759979, 0.01767054, 0.01777667, 0.01804199, 0.01823053, 0.01948844, 0.02083314, 0.02227063,
         0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054,
         0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695,
         0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368,
         0.1442475, 0.1542005, 0.161504, 0.163976, 0.1646352, 0.1648404, 0.165624, 0.168096, 0.1762144, 0.1883732,
         0.2013709, 0.2152655, 0.224616, 0.228054, 0.2289708, 0.2301188, 0.230346, 0.233784, 0.245997, 0.2629708,
         0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891,
         0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612,
         1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733,
         2.224304, 2.377781, 2.42256, 2.45964, 2.469528, 2.48436, 2.52144, 2.541848, 2.717235, 2.904724, 3.10515,
         3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004,
         6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697,
         14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676,
         30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927,
         62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587,
         130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699,
         271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [-3.48343, -4.26512, -4.91639, -6.07961, -5.80548, -6.49112, -5.51019, -5.10778, -4.6885, 4.85407, 7.02455,
         8.2926, 8.79689, 8.78922, 8.50205, 8.09906, 7.6761, 7.57568, 7.48403, 7.46005, 7.42486, 7.33908, 7.28016,
         6.92902, 6.62473, 6.36305, 6.13733, 5.94417, 5.77933, 5.64047, 5.52557, 5.43223, 5.35763, 5.29818, 5.24989,
         5.20867, 5.17122, 5.13443, 5.09561, 5.05383, 5.00445, 4.94551, 4.87744, 4.7972, 4.70176, 4.58711, 4.44776,
         4.27591, 4.06018, 3.78344, 3.41854, 2.91916, 2.19699, 1.05025, -1.18249, -5.49062, -10.8763, -17.2556,
         -22.8517, -10.7387, -5.05078, 0.268651, 3.57484, 5.64507, 7.05788, 7.51754, 7.2736, 6.72984, 7.35124, 7.4535,
         8.24499, 9.56827, 10.7717, 11.7286, 12.515, 13.1657, 13.7032, 14.1439, 14.5017, 14.7886, 15.0149, 15.1896,
         15.3221, 15.4165, 15.4802, 15.5185, 15.5359, 15.5359, 15.5214, 15.4951, 15.46, 15.4191, 15.377, 15.3185,
         15.2465, 15.1657, 15.0779, 14.9834, 14.8807, 14.7671, 14.6378, 14.4842, 14.2907, 14.0245, 13.5997, 12.6322,
         11.9404, 10.3757, 8.49659, 10.3922, 12.1135, 12.5569, 14.2376, 14.9741, 15.4198, 15.7231, 15.9311, 16.0769,
         16.1802, 16.2533, 16.3047, 16.385, 16.4057, 16.4117, 16.4086, 16.3993, 16.3859, 16.3698, 16.3522, 16.3342,
         16.318, 16.2986, 16.2792, 16.2603, 16.2413, 16.2226, 16.2045, 16.1874, 16.1713, 16.1562, 16.1422, 16.1293,
         16.1174, 16.1064, 16.0964, 16.0873, 16.079, 16.0715, 16.0645, 16.0581, 16.0523, 16.047, 16.0421, 16.0378,
         16.0338, 16.0303, 16.0271, 16.0242, 16.0216, 16.0193, 16.0172, 16.0153, 16.0137, 16.0122, 16.0108, 16.0096,
         16.0086, 16.0076, 16.0067, 16.006, 16.0053, 16.0047, 16.0042, 16.0037, 16.0033, 16.0029, 16.0026, 16.0023,
         16.002, 16.0018, 16.0016, 16.0014, 16.0012, 16.0011, 16.001, 16.0009, 16.0008, 16.0007, 16.0006],
        [0.0, 0.0, 0.0, 0.0, 1.7889, 1.836, 3.6918, 3.8061, 4.0655, 10.046, 8.6428, 6.8704, 5.1618, 3.7368, 2.6492,
         1.8642, 1.3165, 1.211, 1.1213, 1.0989, 1.0667, 0.99108, 0.94176, 0.68765, 0.51689, 0.40433, 0.33392, 0.29544,
         0.28174, 0.28698, 0.3057, 0.33304, 0.36459, 0.39668, 0.42687, 0.45409, 0.47795, 0.49862, 0.5168, 0.53333,
         0.54903, 0.56524, 0.58227, 0.60028, 0.61932, 0.63925, 0.65975, 0.68034, 0.70045, 0.7195, 0.73688, 0.75205,
         0.76456, 0.77408, 0.76165, 0.74766, 0.74264, 0.74128, 13.291, 13.261, 13.165, 12.863, 12.429, 11.923, 11.353,
         10.965, 10.822, 10.784, 11.942, 11.933, 11.797, 11.322, 10.685, 10.032, 9.3747, 8.7232, 8.0847, 7.466, 6.8727,
         6.3084, 5.7755, 5.2754, 4.8084, 4.3745, 3.9729, 3.6027, 3.2623, 2.9496, 2.6633, 2.4023, 2.1653, 1.9505, 1.7565,
         1.5563, 1.3799, 1.2248, 1.0883, 0.96802, 0.86197, 0.76836, 0.68566, 0.61253, 0.54778, 0.49041, 0.43951,
         0.39431, 0.38259, 0.37333, 0.37093, 4.07, 3.9926, 3.9512, 3.5845, 3.2216, 2.8955, 2.5973, 2.3237, 2.0792,
         1.8606, 1.665, 1.4893, 1.3318, 1.1801, 1.0457, 0.9267, 0.82127, 0.72786, 0.64511, 0.5718, 0.50681, 0.44855,
         0.39488, 0.34764, 0.30521, 0.26702, 0.23361, 0.20439, 0.17883, 0.15647, 0.13691, 0.1198, 0.10483, 0.091735,
         0.080275, 0.070249, 0.061476, 0.0538, 0.046793, 0.040617, 0.035256, 0.030603, 0.026565, 0.02306, 0.020017,
         0.017377, 0.015084, 0.013095, 0.011346, 0.0098178, 0.0084952, 0.0073509, 0.0063607, 0.005504, 0.0047619,
         0.0041184, 0.0035618, 0.0030804, 0.0026642, 0.0023041, 0.0019928, 0.0017235, 0.0014906, 0.0012892, 0.001115,
         0.00096437, 0.00083407, 0.00072139, 0.00062393, 0.00053963, 0.00046673, 0.00040368, 0.00034915, 0.00030198,
         0.00026119, 0.00022591, 0.00019539, 0.000169, 0.00014617, 0.00012643]],
    'Cl':                                                                                                         [
        [0.006664, 0.006766, 0.0067932, 0.006834, 0.006936, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01715, 0.0174125, 0.0174825, 0.0175875, 0.01785, 0.01823053, 0.01948844,
         0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846,
         0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028,
         0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797,
         0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.196, 0.197568, 0.199, 0.1998,
         0.200592, 0.201, 0.2013709, 0.2013984, 0.202608, 0.204, 0.205632, 0.2152655, 0.2301188, 0.245997, 0.2629708,
         0.264796, 0.268849, 0.2699298, 0.271551, 0.275604, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099,
         0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399,
         0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281,
         1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.765952,
         2.808288, 2.819578, 2.836512, 2.878848, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821,
         4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794,
         9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398,
         20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543,
         41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564,
         87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159,
         181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049,
         378.8588, 405.0001, 432.9451],
        [-6.48754, -8.71036, -10.9679, -9.15794, -7.81269, 8.13522, 9.37473, 9.87659, 9.88286, 9.60491, 9.19403, 8.7443,
         8.3067, 8.27119, 8.17619, 8.15072, 8.11518, 8.02747, 7.90572, 7.54978, 7.24039, 6.97002, 6.73643, 6.53547,
         6.36342, 6.2171, 6.09417, 5.99205, 5.90798, 5.83917, 5.78294, 5.7368, 5.69856, 5.66627, 5.64012, 5.61503,
         5.59156, 5.5685, 5.54462, 5.51848, 5.48825, 5.45162, 5.40568, 5.34667, 5.26968, 5.1682, 5.03347, 4.85335,
         4.60508, 4.24737, 3.72741, 2.94256, 1.65231, -0.963484, -5.11596, -7.04464, -10.3536, -15.8375, -13.2492,
         -12.3713, -12.8311, -12.963, -8.42225, -5.64408, -3.66881, 1.76525, 5.36699, 7.46894, 8.63568, 8.66322, 8.401,
         7.81491, 8.59454, 9.44336, 10.0833, 11.5368, 12.6019, 13.452, 14.1442, 14.7107, 15.1732, 15.5481, 15.8486,
         16.0858, 16.2691, 16.4066, 16.5034, 16.5699, 16.6094, 16.6268, 16.6272, 16.6118, 16.5843, 16.5482, 16.528,
         16.4667, 16.3923, 16.3103, 16.223, 16.1307, 16.033, 15.9283, 15.8134, 15.6835, 15.5299, 15.3369, 15.072,
         14.649, 13.6771, 13.0165, 11.4668, 9.60284, 11.4882, 13.2, 13.6816, 15.3069, 16.0128, 16.443, 16.743, 16.9472,
         17.0895, 17.1898, 17.2603, 17.3095, 17.3868, 17.4057, 17.411, 17.4076, 17.3984, 17.3854, 17.3702, 17.3541,
         17.3362, 17.3166, 17.2966, 17.2769, 17.2579, 17.2389, 17.2202, 17.2023, 17.1853, 17.1694, 17.1545, 17.1407,
         17.1279, 17.1161, 17.1054, 17.0955, 17.0867, 17.0785, 17.0709, 17.0639, 17.0575, 17.0517, 17.0464, 17.0416,
         17.0373, 17.0334, 17.0299, 17.0267, 17.0239, 17.0214, 17.0191, 17.017, 17.0151, 17.0135, 17.012, 17.0107,
         17.0095, 17.0084, 17.0075, 17.0067, 17.0059, 17.0052, 17.0047, 17.0041, 17.0037, 17.0032, 17.0029, 17.0025,
         17.0022, 17.002, 17.0018, 17.0016, 17.0014, 17.0012, 17.0011, 17.001, 17.0008, 17.0007],
        [0.0, 0.0, 0.0, 4.2153, 4.6476, 10.632, 8.5751, 6.6572, 5.0456, 3.7778, 2.822, 2.1201, 1.6121, 1.5764, 1.4849,
         1.4619, 1.4302, 1.3517, 1.2497, 0.99072, 0.80826, 0.68213, 0.59833, 0.54685, 0.52018, 0.51307, 0.52094,
         0.53952, 0.56545, 0.59621, 0.63002, 0.66568, 0.70249, 0.74008, 0.77828, 0.81703, 0.85625, 0.8958, 0.93544,
         0.9747, 1.013, 1.0498, 1.0844, 1.1163, 1.1447, 1.169, 1.1889, 1.204, 1.1885, 1.1615, 1.1286, 1.0906, 1.0484,
         1.0027, 0.97436, 0.96858, 0.96331, 0.96038, 10.701, 10.68, 10.66, 10.659, 15.407, 15.302, 15.182, 14.507,
         13.57, 12.673, 11.807, 11.719, 11.526, 11.476, 12.699, 12.518, 12.278, 11.49, 10.723, 9.9762, 9.2522, 8.5551,
         7.8877, 7.2524, 6.651, 6.0847, 5.5541, 5.0594, 4.5999, 4.175, 3.7833, 3.4235, 3.0938, 2.7921, 2.5173, 2.2683,
         2.021, 1.7948, 1.594, 1.4171, 1.2611, 1.1235, 1.0019, 0.89432, 0.79917, 0.71488, 0.64014, 0.57382, 0.51489,
         0.4625, 0.41585, 0.40432, 0.39473, 0.39224, 4.0625, 3.9785, 3.9285, 3.541, 3.1795, 2.8622, 2.5699, 2.2984,
         2.0558, 1.839, 1.6453, 1.4714, 1.3153, 1.1664, 1.0345, 0.91748, 0.81377, 0.72183, 0.64026, 0.56708, 0.49958,
         0.44014, 0.38779, 0.34169, 0.30019, 0.2628, 0.23008, 0.20144, 0.17637, 0.15443, 0.13522, 0.1184, 0.10368,
         0.09079, 0.079504, 0.069623, 0.060598, 0.052638, 0.045724, 0.039719, 0.034503, 0.029972, 0.026037, 0.022619,
         0.01965, 0.01707, 0.01483, 0.012883, 0.011169, 0.0096669, 0.0083672, 0.0072424, 0.0062681, 0.0054237,
         0.0046931, 0.0040609, 0.0035139, 0.0030406, 0.0026311, 0.0022767, 0.0019701, 0.0017048, 0.0014752, 0.0012765,
         0.0011046, 0.00095585, 0.00082714, 0.00071576, 0.00061938, 0.00053598, 0.00046381, 0.00040136, 0.00034732,
         0.00030056, 0.00026009, 0.00022508, 0.00019477, 0.00016855]],
    'Ar':                                                                                                         [
        [0.01069, 0.01142761, 0.012152, 0.01221612, 0.012338, 0.0123876, 0.012462, 0.012648, 0.01305903, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.024794,
         0.0251735, 0.0252747, 0.02545001, 0.025806, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846,
         0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028,
         0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797,
         0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188,
         0.240296, 0.242354, 0.243974, 0.2449548, 0.245997, 0.2460635, 0.246426, 0.2470527, 0.2485365, 0.250104,
         0.252246, 0.2629708, 0.2811158, 0.3005128, 0.3136, 0.3184, 0.31968, 0.3212482, 0.3216, 0.3264, 0.3434143,
         0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609,
         0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285,
         1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235,
         2.904724, 3.10515, 3.138842, 3.186885, 3.199697, 3.218914, 3.266958, 3.319406, 3.548445, 3.793288, 4.055024,
         4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789,
         9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961,
         18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551,
         39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578,
         81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356,
         170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294,
         354.4049, 378.8588, 405.0001, 432.9451],
        [-2.55688, -4.00996, -7.07227, -7.6477, -9.53105, -11.9746, -10.093, -8.7553, -8.32095, -7.63879, -4.68957,
         -0.184234, 4.52316, 8.33043, 10.7845, 11.9786, 12.2589, 11.9916, 11.6829, 11.5494, 11.5101, 11.4521, 11.3281,
         10.8349, 10.2231, 9.66544, 9.17783, 8.76122, 8.40482, 8.11116, 7.86667, 7.66343, 7.49416, 7.35244, 7.23317,
         7.13172, 7.04399, 6.96644, 6.89605, 6.83218, 6.76853, 6.70486, 6.63892, 6.56824, 6.48974, 6.39944, 6.29218,
         6.16102, 5.99631, 5.78428, 5.50443, 5.12448, 4.58949, 3.79424, 2.49575, -0.113261, -4.75294, -7.01147,
         -10.3826, -16.3309, -13.1494, -12.9562, -12.301, -12.9419, -8.06178, -5.23505, -2.88933, 2.70864, 6.72406,
         8.87011, 9.5278, 9.275, 8.6594, 9.36235, 9.49472, 10.4119, 11.9186, 13.228, 14.2235, 15.0147, 15.6524, 16.1677,
         16.582, 16.9113, 17.1691, 17.3665, 17.5131, 17.6172, 17.689, 17.7293, 17.7465, 17.7457, 17.7336, 17.7035,
         17.6519, 17.5882, 17.5176, 17.439, 17.3539, 17.2641, 17.1699, 17.0705, 16.9641, 16.8476, 16.7157, 16.5595,
         16.3623, 16.0891, 15.644, 14.5379, 14.0901, 12.5541, 10.706, 12.5778, 14.2753, 15.0333, 16.4395, 17.1011,
         17.5109, 17.7899, 17.9817, 18.1162, 18.2108, 18.2767, 18.322, 18.3939, 18.4089, 18.412, 18.4075, 18.3978,
         18.3906, 18.3744, 18.3552, 18.3348, 18.3139, 18.2932, 18.2732, 18.2541, 18.235, 18.2165, 18.1987, 18.1819,
         18.1662, 18.1516, 18.138, 18.1255, 18.114, 18.1044, 18.0947, 18.0856, 18.0773, 18.0696, 18.0627, 18.0563,
         18.0506, 18.0454, 18.0407, 18.0365, 18.0326, 18.0292, 18.0261, 18.0234, 18.0209, 18.0186, 18.0166, 18.0148,
         18.0132, 18.0117, 18.0104, 18.0093, 18.0083, 18.0073, 18.0065, 18.0058, 18.0051, 18.0045, 18.004, 18.0036,
         18.0032, 18.0028, 18.0025, 18.0022, 18.0019, 18.0017, 18.0015, 18.0013, 18.0012, 18.001, 18.0009],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.5247, 5.0555, 6.4235, 10.449, 14.367, 16.5, 16.433, 14.663, 12.053, 9.3462,
         6.9752, 5.0945, 4.1883, 3.8917, 3.817, 3.6993, 3.4612, 2.6975, 1.9988, 1.52, 1.1966, 0.98222, 0.84376, 0.75813,
         0.70911, 0.68529, 0.67864, 0.68408, 0.69799, 0.71754, 0.741, 0.76735, 0.79601, 0.82669, 0.8592, 0.89335,
         0.92887, 0.96534, 1.002, 1.0382, 1.0731, 1.1058, 1.1354, 1.161, 1.1819, 1.1973, 1.2069, 1.2104, 1.2079, 1.1996,
         1.1754, 1.1692, 1.1643, 1.1613, 11.814, 11.809, 11.787, 11.748, 16.906, 16.766, 16.579, 15.693, 14.375, 13.194,
         12.497, 12.259, 12.196, 13.497, 13.48, 13.257, 12.521, 11.611, 10.75, 9.9311, 9.1532, 8.4154, 7.7167, 7.0589,
         6.4422, 5.8666, 5.3316, 4.8365, 4.3801, 3.9608, 3.5767, 3.226, 2.9066, 2.5899, 2.3089, 2.0599, 1.8372, 1.6349,
         1.4562, 1.2982, 1.1585, 1.0348, 0.92523, 0.82805, 0.7418, 0.66517, 0.59704, 0.53641, 0.4824, 0.42981, 0.42124,
         0.40949, 0.40644, 4.0445, 3.9547, 3.8605, 3.4785, 3.1275, 2.8093, 2.5178, 2.2529, 2.0148, 1.8015, 1.6105,
         1.4394, 1.2843, 1.1397, 1.0114, 0.89769, 0.79678, 0.70619, 0.62255, 0.54885, 0.4839, 0.42666, 0.37619, 0.33171,
         0.29142, 0.25528, 0.22364, 0.19592, 0.17165, 0.15039, 0.13176, 0.11545, 0.10116, 0.088636, 0.077197, 0.067103,
         0.05833, 0.050704, 0.044077, 0.038316, 0.033309, 0.028957, 0.025173, 0.021885, 0.019026, 0.016541, 0.01438,
         0.012502, 0.010833, 0.0093726, 0.0081074, 0.0070102, 0.0060615, 0.0052412, 0.004532, 0.0039187, 0.0033885,
         0.00293, 0.0025336, 0.0021909, 0.0018945, 0.0016382, 0.0014166, 0.001225, 0.0010593, 0.000916, 0.00079211,
         0.00068497, 0.00059233, 0.00051222, 0.00044295, 0.00038305, 0.00033125, 0.00028645, 0.00024772, 0.00021422]],
    'K':                                                                                                          [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.017444, 0.017711,
         0.0177822, 0.017889, 0.018156, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.0337305, 0.0338661, 0.0340695, 0.034578, 0.03552846,
         0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028,
         0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797,
         0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188,
         0.245997, 0.2629708, 0.2811158, 0.287728, 0.290374, 0.292132, 0.2933064, 0.2948185, 0.295068, 0.2960037,
         0.2977815, 0.299472, 0.3005128, 0.302226, 0.3212482, 0.3434143, 0.3671099, 0.369558, 0.3752145, 0.3767229,
         0.3789855, 0.384642, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625,
         0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098,
         1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848,
         2.717235, 2.904724, 3.10515, 3.319406, 3.535252, 3.548445, 3.589363, 3.603793, 3.625437, 3.679548, 3.793288,
         4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609,
         8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362,
         17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889,
         36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536,
         76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864,
         159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304,
         331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [1.03631, 0.667451, 0.182018, -0.481008, -1.43652, -2.93411, -5.66247, -12.849, -20.1638, -36.4057, -57.575,
         -32.766, -10.9873, -7.96761, 10.5085, 13.6677, 13.72, 13.0032, 12.158, 11.3733, 10.6944, 10.1175, 9.61001,
         9.48312, 9.42106, 9.41824, 9.35849, 9.2233, 8.91334, 8.65576, 8.44571, 8.27664, 8.14269, 8.03876, 7.96076,
         7.90418, 7.86604, 7.84348, 7.83414, 7.83561, 7.84534, 7.86087, 7.87971, 7.89855, 7.91598, 7.92812, 7.93138,
         7.92155, 7.89362, 7.84127, 7.7565, 7.62874, 7.44332, 7.17851, 6.7998, 6.24684, 5.39894, 3.95518, 0.705984,
         -2.13949, -4.36755, -7.17401, -12.4621, -9.07883, -8.77353, -9.3545, -5.13667, -2.87198, -1.90035, -0.640194,
         5.59255, 8.5957, 10.1429, 10.183, 9.89081, 9.19868, 10.136, 11.1597, 11.9388, 13.6474, 14.8494, 15.7726,
         16.4983, 17.0723, 17.5257, 17.8814, 18.1571, 18.3667, 18.5218, 18.6322, 18.7063, 18.7539, 18.7769, 18.777,
         18.7592, 18.7275, 18.6758, 18.6114, 18.5398, 18.4623, 18.3778, 18.2883, 18.194, 18.094, 17.9866, 17.8682,
         17.7332, 17.5716, 17.3645, 17.0762, 16.566, 15.1657, 14.9494, 13.642, 11.8067, 13.6705, 15.3599, 16.5531,
         17.6584, 18.2298, 18.5966, 18.8512, 19.0266, 19.1497, 19.2357, 19.2949, 19.3348, 19.4018, 19.4134, 19.4155,
         19.4122, 19.4018, 19.3862, 19.3677, 19.3476, 19.3268, 19.3059, 19.2855, 19.2659, 19.247, 19.2283, 19.2102,
         19.1929, 19.1767, 19.1616, 19.1476, 19.135, 19.1233, 19.1119, 19.1014, 19.0917, 19.0827, 19.0746, 19.0671,
         19.0603, 19.0542, 19.0486, 19.0436, 19.0391, 19.035, 19.0313, 19.028, 19.0251, 19.0224, 19.02, 19.0178,
         19.0159, 19.0142, 19.0126, 19.0112, 19.01, 19.0089, 19.0079, 19.007, 19.0062, 19.0055, 19.0049, 19.0044,
         19.0039, 19.0034, 19.003, 19.0027, 19.0024, 19.0021, 19.0019, 19.0017, 19.0015, 19.0013, 19.0011],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 42.47, 38.222, 37.125, 23.098, 14.677, 9.7862, 6.8296,
         4.9747, 3.7714, 2.9673, 2.4161, 2.0302, 1.9611, 1.9433, 1.989, 1.9326, 1.8414, 1.6722, 1.5627, 1.4956, 1.4595,
         1.446, 1.4489, 1.4635, 1.4861, 1.5142, 1.5456, 1.5786, 1.6112, 1.642, 1.67, 1.6941, 1.7137, 1.7279, 1.7363,
         1.7384, 1.734, 1.7229, 1.705, 1.6805, 1.65, 1.6139, 1.5729, 1.5275, 1.4787, 1.427, 1.3732, 1.3181, 1.2987,
         1.291, 1.2859, 1.2826, 10.759, 10.75, 10.716, 15.353, 15.268, 15.216, 15.131, 14.247, 13.306, 12.353, 12.259,
         12.044, 11.988, 13.446, 13.233, 12.947, 12.012, 11.11, 10.243, 9.4182, 8.6374, 7.9026, 7.2147, 6.5728, 5.9766,
         5.4252, 4.917, 4.4499, 4.0218, 3.6304, 3.267, 2.9368, 2.6275, 2.3429, 2.0908, 1.8674, 1.6641, 1.4833, 1.3233,
         1.1817, 1.0563, 0.94505, 0.84636, 0.7587, 0.68077, 0.61143, 0.54407, 0.47995, 0.42673, 0.42379, 0.41486,
         0.41178, 4.0255, 3.9276, 3.7342, 3.3541, 3.0167, 2.7144, 2.4328, 2.177, 1.9467, 1.7396, 1.5542, 1.3883, 1.2373,
         1.0989, 0.97605, 0.86567, 0.76367, 0.67372, 0.59441, 0.52447, 0.46278, 0.40837, 0.36038, 0.31804, 0.2792,
         0.24474, 0.21455, 0.18808, 0.16489, 0.14456, 0.12674, 0.11112, 0.09682, 0.084188, 0.073206, 0.063658, 0.055356,
         0.048138, 0.041862, 0.036404, 0.031659, 0.027533, 0.023945, 0.020825, 0.018111, 0.015752, 0.0137, 0.011915,
         0.010336, 0.0089613, 0.0077691, 0.0067356, 0.0058397, 0.0050629, 0.0043895, 0.0038057, 0.0032996, 0.0028608,
         0.0024804, 0.0021505, 0.0018646, 0.0016166, 0.0014017, 0.0012153, 0.0010537, 0.00091366, 0.00079219,
         0.00068688, 0.00059557, 0.0005164, 0.00044775, 0.00038823, 0.00033663, 0.00029188]],
    'Ca':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.024892, 0.025273, 0.0253746, 0.02545001, 0.025527, 0.025908,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.042826, 0.04340198,
         0.0434815, 0.0436563, 0.0439185, 0.044574, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581,
         0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655,
         0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.339472, 0.343, 0.3434143, 0.344668,
         0.3460536, 0.34825, 0.34965, 0.35175, 0.353328, 0.357, 0.3671099, 0.3924405, 0.4195189, 0.429044, 0.435611,
         0.4373622, 0.439989, 0.446556, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609,
         0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285,
         1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235,
         2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 3.957338, 4.017909, 4.034062, 4.055024, 4.05829, 4.118862,
         4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789,
         9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961,
         18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551,
         39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578,
         81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356,
         170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294,
         354.4049, 378.8588, 405.0001, 432.9451],
        [6.74674, 6.71135, 6.66883, 6.61724, 6.55391, 6.475, 6.37476, 6.24417, 6.06801, 5.81829, 5.43633, 4.77106,
         3.24162, -0.374657, -6.20519, -14.1462, -9.70039, -4.18744, 4.30351, 10.2441, 10.6666, 9.98904, 9.39459,
         8.94477, 8.59656, 8.3021, 8.04432, 7.92888, 7.90165, 7.77713, 7.86952, 7.92308, 7.90007, 7.81742, 7.74364,
         7.68645, 7.64749, 7.6278, 7.62852, 7.65082, 7.70078, 7.76858, 7.85896, 7.97064, 8.10171, 8.24823, 8.40291,
         8.55822, 8.70566, 8.84003, 8.95323, 9.0384, 9.08864, 9.09648, 9.05296, 8.9465, 8.76054, 8.46935, 8.02921,
         7.35724, 6.26827, 4.2, -0.601802, -3.23076, -3.6994, -5.61786, -10.9196, -6.84427, -7.4721, -3.36124, -1.51093,
         1.07948, 4.79675, 8.98735, 11.0578, 11.3462, 11.0638, 10.3698, 11.3158, 12.3521, 12.5462, 14.5209, 15.8108,
         16.7789, 17.528, 18.1133, 18.5712, 18.929, 19.2085, 19.418, 19.5708, 19.6784, 19.7509, 19.8007, 19.8129,
         19.802, 19.7743, 19.7367, 19.6846, 19.6197, 19.548, 19.4721, 19.3889, 19.3001, 19.2061, 19.1059, 18.9976,
         18.8776, 18.7401, 18.5764, 18.3498, 18.008, 17.3592, 16.2338, 14.7223, 12.8987, 14.547, 14.7569, 16.44, 18.059,
         18.8984, 19.3754, 19.6982, 19.9227, 20.0785, 20.1876, 20.2632, 20.3145, 20.3488, 20.409, 20.4237, 20.421,
         20.4108, 20.396, 20.378, 20.3582, 20.3376, 20.3166, 20.2959, 20.2759, 20.2569, 20.2384, 20.2201, 20.2026,
         20.186, 20.1706, 20.1564, 20.143, 20.1302, 20.1182, 20.1071, 20.0969, 20.0875, 20.0789, 20.0711, 20.0639,
         20.0575, 20.0516, 20.0463, 20.0415, 20.0372, 20.0333, 20.0298, 20.0267, 20.0239, 20.0213, 20.019, 20.017,
         20.0151, 20.0135, 20.012, 20.0107, 20.0095, 20.0084, 20.0075, 20.0067, 20.0059, 20.0053, 20.0047, 20.0041,
         20.0037, 20.0033, 20.0029, 20.0026, 20.0023, 20.002, 20.0018, 20.0016, 20.0014],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.608, 16.03, 13.471, 7.5878,
         3.5839, 1.9921, 1.288, 0.9443, 0.76777, 0.67898, 0.64639, 0.6422, 0.64174, 0.64081, 0.8598, 0.86461, 0.88583,
         0.94439, 1.0243, 1.1216, 1.2338, 1.3587, 1.494, 1.6367, 1.7833, 1.9298, 2.0717, 2.2042, 2.3229, 2.4206, 2.4932,
         2.5393, 2.5589, 2.553, 2.5241, 2.4748, 2.4086, 2.3287, 2.2384, 2.1408, 2.0387, 1.9345, 1.8301, 1.7271, 1.6267,
         1.5296, 1.4524, 1.4382, 1.4366, 1.4316, 1.4262, 11.0, 10.949, 15.626, 15.545, 15.358, 14.866, 13.749, 12.683,
         12.334, 12.102, 12.041, 13.502, 13.275, 13.21, 12.219, 11.265, 10.357, 9.5, 8.6947, 7.9426, 7.244, 6.5931,
         5.9873, 5.4288, 4.9166, 4.4486, 4.0045, 3.6007, 3.2354, 2.9062, 2.6095, 2.3292, 2.0811, 1.8618, 1.6627, 1.4833,
         1.3245, 1.1839, 1.0591, 0.94843, 0.85013, 0.76275, 0.67803, 0.59753, 0.52709, 0.4654, 0.43026, 0.41835,
         0.41526, 4.0127, 4.0068, 3.8997, 3.564, 3.1991, 2.882, 2.5972, 2.3263, 2.0813, 1.8605, 1.6616, 1.4837, 1.3249,
         1.1797, 1.0471, 0.92433, 0.81604, 0.72049, 0.63616, 0.56174, 0.49605, 0.43807, 0.38688, 0.34169, 0.30162,
         0.26458, 0.23209, 0.20359, 0.1786, 0.15668, 0.13745, 0.11986, 0.10431, 0.090778, 0.079005, 0.06876, 0.059846,
         0.052088, 0.045337, 0.039461, 0.034348, 0.029897, 0.026024, 0.022653, 0.019719, 0.017165, 0.014942, 0.012994,
         0.011274, 0.0097822, 0.0084877, 0.0073645, 0.00639, 0.0055445, 0.0048109, 0.0041744, 0.0036222, 0.003143,
         0.0027273, 0.0023665, 0.0020535, 0.0017819, 0.0015463, 0.0013418, 0.0011643, 0.0010104, 0.00087675, 0.00076082,
         0.00066022, 0.00057292, 0.00049717, 0.00043144, 0.0003744]],
    'Sc':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.031654,
         0.0321385, 0.0322677, 0.0324615, 0.032946, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198,
         0.04639671, 0.04959809, 0.052724, 0.05302035, 0.053531, 0.0537462, 0.054069, 0.054876, 0.05667876, 0.06058959,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581,
         0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655,
         0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.394156,
         0.398566, 0.400189, 0.4017978, 0.404211, 0.4046665, 0.4062933, 0.4087335, 0.410244, 0.414834, 0.4195189,
         0.4484657, 0.4794098, 0.490392, 0.497898, 0.4998996, 0.502902, 0.510408, 0.5124891, 0.5478508, 0.5856525,
         0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345,
         1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781,
         2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.402944, 4.470336,
         4.488307, 4.515264, 4.582656, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525,
         7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095,
         16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502,
         34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318,
         71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553,
         148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126,
         310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [8.43172, 8.4201, 8.40652, 8.39057, 8.37174, 8.34938, 8.32265, 8.2904, 8.25104, 8.20232, 8.14085, 8.06127,
         7.95448, 7.80327, 7.56991, 7.14726, 5.98986, 5.06744, 2.64257, -0.572539, 3.30677, 6.66886, 7.54411, 9.63779,
         9.68356, 9.47617, 9.26018, 9.06182, 8.86608, 8.62098, 8.58033, 8.46296, 8.30602, 8.44091, 8.54012, 8.57621,
         8.56318, 8.53831, 8.52042, 8.51531, 8.52654, 8.55692, 8.60871, 8.68337, 8.77778, 8.89838, 9.0395, 9.19793,
         9.36968, 9.54736, 9.72191, 9.88537, 10.0286, 10.1445, 10.2257, 10.2646, 10.2526, 10.1788, 10.0285, 9.77881,
         9.39216, 8.79907, 7.85136, 6.14027, 1.46616, 0.748834, -2.14125, -4.20296, -9.45344, -5.39644, -5.0526,
         -5.85041, -1.85144, -0.308777, 2.49519, 4.28326, 9.51097, 11.8389, 12.1697, 11.892, 11.1773, 12.1617, 13.2441,
         13.4384, 15.5039, 16.8387, 17.8352, 18.6004, 19.1936, 19.6541, 20.0108, 20.2868, 20.4928, 20.6451, 20.7586,
         20.8218, 20.8494, 20.8499, 20.8295, 20.7942, 20.7506, 20.6959, 20.6294, 20.5567, 20.48, 20.3965, 20.3074,
         20.2132, 20.1132, 20.0074, 19.8896, 19.7362, 19.5416, 19.2752, 18.852, 17.87, 17.2904, 15.7929, 13.9862,
         15.8273, 17.4949, 18.0517, 19.4991, 20.1389, 20.5351, 20.813, 21.0038, 21.1368, 21.2296, 21.2935, 21.3369,
         21.4081, 21.4223, 21.423, 21.4153, 21.4022, 21.3854, 21.3664, 21.3461, 21.3254, 21.3047, 21.2844, 21.2651,
         21.2467, 21.2285, 21.2108, 21.194, 21.1783, 21.1637, 21.1496, 21.1362, 21.1237, 21.1122, 21.1015, 21.0917,
         21.0827, 21.0746, 21.0671, 21.0604, 21.0543, 21.0487, 21.0437, 21.0392, 21.0351, 21.0315, 21.0282, 21.0252,
         21.0225, 21.0201, 21.0179, 21.016, 21.0143, 21.0127, 21.0113, 21.0101, 21.009, 21.008, 21.0071, 21.0063,
         21.0056, 21.005, 21.0044, 21.0039, 21.0035, 21.0031, 21.0027, 21.0024, 21.0021, 21.0019, 21.0017],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.4655,
         5.649, 5.2166, 2.8403, 1.6748, 1.1417, 0.87736, 0.74331, 0.68109, 0.66398, 0.66389, 0.66425, 0.66459, 0.95669,
         0.96596, 0.99135, 1.0641, 1.158, 1.2694, 1.3961, 1.5357, 1.6854, 1.8415, 1.9997, 2.155, 2.3021, 2.4359, 2.5515,
         2.644, 2.7074, 2.7405, 2.7441, 2.7203, 2.6722, 2.6035, 2.5182, 2.42, 2.3126, 2.1994, 2.0831, 1.9662, 1.8506,
         1.7377, 1.6287, 1.5241, 1.5175, 1.5006, 1.4944, 1.4884, 11.021, 11.006, 10.953, 15.603, 15.533, 15.325, 15.117,
         13.937, 12.824, 12.458, 12.216, 12.152, 13.665, 13.427, 13.362, 12.329, 11.35, 10.419, 9.5373, 8.7119, 7.9434,
         7.2315, 6.5712, 5.9594, 5.3984, 4.8649, 4.378, 3.936, 3.5362, 3.1759, 2.852, 2.5615, 2.2906, 2.0483, 1.8338,
         1.6391, 1.4635, 1.308, 1.1701, 1.0477, 0.93904, 0.83405, 0.73458, 0.6476, 0.57147, 0.50478, 0.44631, 0.43371,
         0.4218, 0.41871, 3.9769, 3.8694, 3.7907, 3.3816, 3.0409, 2.742, 2.4648, 2.2063, 1.9727, 1.7627, 1.5741, 1.4055,
         1.2534, 1.1075, 0.97833, 0.86426, 0.76355, 0.67462, 0.59608, 0.52672, 0.46545, 0.41134, 0.36353, 0.32129,
         0.28301, 0.2484, 0.21804, 0.19139, 0.168, 0.14661, 0.12771, 0.11124, 0.096904, 0.084416, 0.073539, 0.064065,
         0.055812, 0.048624, 0.042363, 0.036908, 0.032157, 0.028018, 0.024411, 0.02127, 0.018533, 0.016131, 0.014007,
         0.012162, 0.010561, 0.0091701, 0.0079628, 0.0069145, 0.0060043, 0.005214, 0.0045277, 0.0039318, 0.0034143,
         0.002965, 0.0025748, 0.002236, 0.0019418, 0.0016863, 0.0014645, 0.0012718, 0.0011045, 0.00095918, 0.000833,
         0.00072343, 0.00062827, 0.00054563, 0.00047387]],
    'Ti':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.033908, 0.034427, 0.0345654, 0.034773, 0.035292, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.059094, 0.0599985, 0.0602397, 0.06058959, 0.0606015, 0.061506,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581,
         0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655,
         0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189,
         0.44639, 0.4484657, 0.45227, 0.4532225, 0.4550445, 0.4577775, 0.4591925, 0.4610385, 0.4638075, 0.46461,
         0.47073, 0.4794098, 0.5124891, 0.5478508, 0.552426, 0.5608815, 0.5631363, 0.5665185, 0.574974, 0.5856525,
         0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345,
         1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781,
         2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.867072,
         4.941568, 4.953664, 4.961434, 4.991232, 5.065728, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525,
         7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095,
         16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502,
         34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318,
         71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553,
         148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126,
         310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [9.42905, 9.42053, 9.41062, 9.39906, 9.38551, 9.36957, 9.3507, 9.32824, 9.30127, 9.26856, 9.22834, 9.17803,
         9.11359, 9.02823, 8.90939, 8.73001, 8.41542, 7.60473, 6.89881, 5.21284, 3.01476, 5.60428, 7.86368, 8.34078,
         9.99065, 10.1319, 10.0332, 9.89691, 9.75735, 9.61388, 9.44458, 9.26972, 9.10085, 8.92474, 9.07958, 9.0835,
         9.20754, 9.2831, 9.29671, 9.30317, 9.31776, 9.3468, 9.39422, 9.46274, 9.55397, 9.66065, 9.79749, 9.95464,
         10.129, 10.3167, 10.5109, 10.7029, 10.8847, 11.0503, 11.1902, 11.2992, 11.371, 11.3988, 11.3743, 11.2871,
         11.1216, 10.854, 10.444, 9.81571, 8.80332, 6.92604, 1.92843, 0.987301, -1.76894, -2.96272, -8.18637, -3.90944,
         -3.08146, -4.1943, -0.365275, 0.404249, 3.83984, 6.44177, 11.0633, 13.0866, 13.1659, 12.8802, 12.1445, 13.1577,
         14.27, 15.0556, 16.9001, 18.1505, 19.0837, 19.8089, 20.3785, 20.8094, 21.1416, 21.4337, 21.6411, 21.7616,
         21.8304, 21.8617, 21.8659, 21.8498, 21.8189, 21.7801, 21.7335, 21.6786, 21.6125, 21.5408, 21.4645, 21.3815,
         21.2933, 21.2005, 21.1027, 20.9847, 20.8432, 20.6701, 20.4452, 20.1195, 19.5302, 18.3295, 16.8446, 16.1067,
         15.0532, 16.8795, 18.5331, 19.9941, 20.8781, 21.3665, 21.6932, 21.9215, 22.0793, 22.1897, 22.2671, 22.3223,
         22.3587, 22.4196, 22.425, 22.4203, 22.4091, 22.3936, 22.3754, 22.3555, 22.3348, 22.3139, 22.2934, 22.2735,
         22.2547, 22.2365, 22.2186, 22.2014, 22.1864, 22.1708, 22.1559, 22.142, 22.1289, 22.1169, 22.1058, 22.0957,
         22.0863, 22.0779, 22.0701, 22.0631, 22.0568, 22.051, 22.0458, 22.0411, 22.0369, 22.0331, 22.0297, 22.0266,
         22.0237, 22.0212, 22.0189, 22.0169, 22.015, 22.0134, 22.0119, 22.0106, 22.0094, 22.0084, 22.0075, 22.0066,
         22.0059, 22.0052, 22.0046, 22.0041, 22.0037, 22.0032, 22.0029, 22.0025, 22.0023, 22.002],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
         4.4077, 3.936, 3.7403, 2.2468, 1.4413, 1.0503, 0.85004, 0.74921, 0.70691, 0.70362, 0.7168, 0.72413, 0.72628,
         1.0619, 1.0621, 1.0777, 1.1418, 1.2446, 1.3647, 1.4997, 1.6471, 1.8036, 1.9656, 2.1285, 2.2874, 2.4371, 2.5726,
         2.6893, 2.7827, 2.8469, 2.8809, 2.8854, 2.8628, 2.8158, 2.748, 2.6634, 2.5655, 2.4579, 2.3437, 2.2258, 2.1067,
         1.9881, 1.8718, 1.7587, 1.6498, 1.5526, 1.5455, 1.5327, 1.5295, 1.5234, 11.107, 11.064, 11.008, 15.678, 15.643,
         15.387, 15.035, 13.816, 12.665, 12.526, 12.274, 12.208, 13.763, 13.515, 13.211, 12.153, 11.157, 10.224, 9.3601,
         8.5328, 7.7655, 7.064, 6.4217, 5.7774, 5.1954, 4.6702, 4.1983, 3.7746, 3.3947, 3.0542, 2.7492, 2.4762, 2.2158,
         1.9839, 1.7785, 1.5901, 1.4215, 1.272, 1.1394, 1.0116, 0.89095, 0.78546, 0.69316, 0.61232, 0.54145, 0.47926,
         0.43839, 0.42651, 0.42463, 0.42343, 3.9516, 3.8444, 3.55, 3.1852, 2.8699, 2.5886, 2.3196, 2.076, 1.8566,
         1.6599, 1.4823, 1.319, 1.1692, 1.033, 0.9125, 0.80612, 0.71218, 0.62924, 0.55599, 0.49128, 0.43414, 0.38365,
         0.33906, 0.29966, 0.2632, 0.23115, 0.20302, 0.17732, 0.1546, 0.13479, 0.11752, 0.10247, 0.089345, 0.077906,
         0.067933, 0.059238, 0.051657, 0.045047, 0.039284, 0.034259, 0.029877, 0.026057, 0.022725, 0.019787, 0.017165,
         0.014891, 0.012918, 0.011207, 0.0097228, 0.0084351, 0.007318, 0.0063489, 0.0055082, 0.0047789, 0.0041462,
         0.0035972, 0.003121, 0.0027079, 0.0023494, 0.0020384, 0.0017686, 0.0015346, 0.0013315, 0.0011553, 0.0010024,
         0.00086974, 0.00075465, 0.0006548, 0.00056816]],
    'V':                                                                                                          [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.037044, 0.037611, 0.0377622, 0.03797993, 0.037989, 0.038556, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06517, 0.0661675, 0.0664335, 0.0668325, 0.06783,
         0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797,
         0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188,
         0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657,
         0.4794098, 0.502642, 0.51009, 0.5103355, 0.5124891, 0.5154645, 0.5178975, 0.5199795, 0.5231025, 0.523158,
         0.53091, 0.5478508, 0.5856525, 0.615636, 0.625059, 0.6260625, 0.6275718, 0.631341, 0.640764, 0.6692609,
         0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285,
         1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235,
         2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.355798,
         5.437774, 5.459635, 5.492425, 5.574402, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789,
         9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961,
         18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551,
         39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578,
         81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356,
         170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294,
         354.4049, 378.8588, 405.0001, 432.9451],
        [6.03298, 6.07191, 6.11684, 6.16824, 6.22652, 6.29198, 6.36478, 6.44492, 6.53219, 6.62612, 6.72589, 6.83025,
         6.93728, 7.04404, 7.14583, 7.23437, 7.29311, 7.28097, 7.04435, 6.31229, 5.04483, 3.35785, 5.28829, 5.34875,
         7.12733, 8.81634, 9.44378, 9.66967, 9.79279, 9.8731, 9.92252, 9.93366, 9.84482, 9.81827, 9.66616, 9.48206,
         9.66842, 9.83442, 9.92865, 10.0868, 10.1956, 10.2928, 10.3896, 10.4924, 10.6054, 10.7319, 10.8633, 11.0204,
         11.1921, 11.3764, 11.5703, 11.7692, 11.9653, 12.1513, 12.3224, 12.469, 12.5871, 12.6713, 12.716, 12.715,
         12.6602, 12.5404, 12.3391, 12.0299, 11.567, 10.8618, 9.71151, 7.46757, 3.15839, -1.39635, -1.70484, -7.62793,
         -2.50381, -1.34166, -2.63868, 1.09287, 1.144, 5.2073, 9.04877, 12.8372, 14.0588, 13.7816, 13.6222, 13.035,
         14.0717, 15.2143, 16.855, 18.4554, 19.596, 20.4566, 21.1301, 21.6581, 22.0899, 22.4125, 22.6235, 22.7603,
         22.8438, 22.8869, 22.8996, 22.8934, 22.8669, 22.8285, 22.7819, 22.7317, 22.672, 22.6035, 22.5308, 22.4528,
         22.3715, 22.2923, 22.1901, 22.0721, 21.9364, 21.7762, 21.5764, 21.3044, 20.8694, 19.8136, 19.367, 17.8916,
         16.1109, 17.9281, 19.5732, 20.2817, 21.5912, 22.1944, 22.5734, 22.8396, 23.0228, 23.1513, 23.2454, 23.309,
         23.3493, 23.4148, 23.4254, 23.424, 23.4149, 23.4008, 23.3833, 23.3639, 23.3434, 23.3225, 23.3018, 23.2816,
         23.2624, 23.2443, 23.2271, 23.2099, 23.1928, 23.1764, 23.161, 23.1466, 23.1332, 23.1208, 23.1094, 23.0989,
         23.0894, 23.0806, 23.0727, 23.0654, 23.0589, 23.053, 23.0476, 23.0431, 23.0386, 23.0346, 23.031, 23.0277,
         23.0247, 23.0221, 23.0197, 23.0176, 23.0157, 23.014, 23.0124, 23.0111, 23.0099, 23.0088, 23.0078, 23.0069,
         23.0062, 23.0055, 23.0049, 23.0043, 23.0038, 23.0034, 23.003, 23.0027, 23.0024],
        [1.3926, 1.4821, 1.5754, 1.672, 1.7714, 1.8729, 1.9757, 2.0791, 2.1821, 2.2838, 2.3833, 2.4796, 2.572, 2.6595,
         2.7415, 2.8172, 2.8862, 2.948, 3.0024, 3.0326, 3.0429, 3.0455, 6.4585, 6.4533, 6.145, 5.2816, 4.4661, 3.9727,
         3.6535, 3.4244, 3.2483, 3.1077, 2.9948, 2.9856, 2.9639, 2.9583, 3.3136, 3.3006, 3.2845, 3.2481, 3.2329, 3.2361,
         3.256, 3.2903, 3.3358, 3.3885, 3.4437, 3.4966, 3.5423, 3.5763, 3.5945, 3.591, 3.5633, 3.5119, 3.4384, 3.3451,
         3.2352, 3.112, 2.9789, 2.839, 2.695, 2.5496, 2.405, 2.263, 2.1248, 1.9915, 1.8639, 1.7424, 1.6601, 1.6351,
         1.6343, 1.6273, 11.276, 11.206, 11.147, 15.841, 15.839, 15.532, 14.897, 13.629, 12.738, 12.476, 12.448, 12.407,
         13.99, 13.733, 13.0, 11.939, 10.937, 10.006, 9.1452, 8.3284, 7.5803, 6.8343, 6.1482, 5.53, 4.9725, 4.471,
         4.0207, 3.6167, 3.2545, 2.93, 2.6393, 2.3764, 2.1275, 1.9068, 1.7099, 1.5291, 1.3687, 1.215, 1.0704, 0.94397,
         0.83331, 0.73636, 0.65136, 0.57675, 0.51121, 0.45356, 0.44449, 0.43262, 0.42954, 3.9371, 3.8274, 3.7167,
         3.3154, 2.9844, 2.6931, 2.4213, 2.1691, 1.9414, 1.7355, 1.5457, 1.3765, 1.2246, 1.0823, 0.95604, 0.84453,
         0.74607, 0.65914, 0.58237, 0.51457, 0.45469, 0.4018, 0.35508, 0.3138, 0.27646, 0.24293, 0.21236, 0.18533,
         0.16172, 0.14113, 0.12316, 0.10749, 0.093808, 0.081873, 0.071458, 0.06237, 0.054438, 0.047517, 0.041476,
         0.036204, 0.031603, 0.027587, 0.024042, 0.020874, 0.018123, 0.015735, 0.013662, 0.011862, 0.0103, 0.0089431,
         0.0077653, 0.0067426, 0.0058547, 0.0050838, 0.0044144, 0.0038332, 0.0033286, 0.0028904, 0.0025099, 0.0021795,
         0.0018926, 0.0016435, 0.0014272, 0.0012394, 0.0010763, 0.00093467, 0.00081168, 0.00070488]],
    'Cr':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04165, 0.0422875, 0.0424575, 0.0427125, 0.04335, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.072618, 0.0737295, 0.07401695,
         0.0740259, 0.0744705, 0.075582, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581,
         0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655,
         0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189,
         0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.56301, 0.572026, 0.5739255, 0.5773725, 0.5807815, 0.5831163,
         0.5856525, 0.58599, 0.5866185, 0.595374, 0.6260625, 0.6692609, 0.680708, 0.691127, 0.6939054, 0.698073,
         0.708492, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098,
         1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848,
         2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467,
         5.660855, 5.869416, 5.959254, 5.983211, 6.019146, 6.051453, 6.108984, 6.469004, 6.915365, 7.392525, 7.902609,
         8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362,
         17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889,
         36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536,
         76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864,
         159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304,
         331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [4.91074, 4.96917, 5.03413, 5.10636, 5.18659, 5.27545, 5.37345, 5.481, 5.59831, 5.72538, 5.86196, 6.00743,
         6.16072, 6.32013, 6.48301, 6.64508, 6.79915, 6.93175, 7.01362, 6.96365, 6.40477, 5.50583, 3.43782, 0.622173,
         4.05524, 7.09375, 7.2268, 10.0687, 10.5444, 10.676, 10.7528, 10.815, 10.8599, 10.8662, 10.7857, 10.6519,
         10.4986, 10.4869, 10.6552, 10.8074, 10.9676, 11.1006, 11.2096, 11.3121, 11.416, 11.5266, 11.6482, 11.784,
         11.9285, 12.0966, 12.2801, 12.4764, 12.6825, 12.892, 13.0964, 13.2879, 13.4608, 13.6061, 13.7191, 13.7945,
         13.8264, 13.8083, 13.7312, 13.5829, 13.3444, 12.9845, 12.4471, 11.619, 10.2203, 7.17813, 4.03264, -1.46698,
         -6.34058, -1.66698, -0.233901, -1.67326, 1.18309, 1.54437, 2.12272, 6.31539, 11.672, 14.5819, 14.8744, 14.621,
         13.8694, 14.9312, 16.1104, 16.5908, 18.7137, 20.0955, 21.1147, 21.9, 22.5466, 23.0148, 23.347, 23.587, 23.7474,
         23.8492, 23.9066, 23.9301, 23.928, 23.9099, 23.8752, 23.8307, 23.7813, 23.7276, 23.6639, 23.5939, 23.5212,
         23.4551, 23.3672, 23.2625, 23.1453, 23.0137, 22.8622, 22.679, 22.44, 22.0858, 21.3981, 20.4015, 18.9371,
         17.1703, 18.9719, 19.8252, 20.6031, 22.2661, 23.0221, 23.4637, 23.7651, 23.9746, 24.1269, 24.227, 24.2944,
         24.3392, 24.3684, 24.4243, 24.4264, 24.4195, 24.4067, 24.3901, 24.3712, 24.3509, 24.3301, 24.3093, 24.2889,
         24.2694, 24.2512, 24.2333, 24.2153, 24.1978, 24.181, 24.1653, 24.1506, 24.1369, 24.1242, 24.1125, 24.1018,
         24.092, 24.0831, 24.075, 24.0676, 24.0609, 24.0549, 24.0495, 24.0444, 24.0399, 24.0357, 24.032, 24.0286,
         24.0256, 24.0229, 24.0204, 24.0182, 24.0162, 24.0145, 24.0129, 24.0115, 24.0102, 24.0091, 24.0081, 24.0072,
         24.0064, 24.0057, 24.005, 24.0045, 24.004, 24.0035, 24.0031, 24.0028],
        [2.0464, 2.1522, 2.2639, 2.381, 2.5029, 2.629, 2.7586, 2.8907, 3.0245, 3.1589, 3.2927, 3.4249, 3.5542, 3.6795,
         3.7997, 3.9138, 4.0208, 4.1198, 4.2103, 4.2917, 4.3636, 4.3886, 4.4027, 4.4064, 10.114, 9.4318, 9.3778, 7.0694,
         5.8022, 5.1298, 4.7082, 4.4061, 4.1693, 3.9739, 3.8536, 3.8182, 3.8093, 3.809, 4.1232, 4.0982, 4.0301, 3.9538,
         3.8999, 3.8667, 3.8526, 3.8554, 3.8716, 3.897, 3.9264, 3.9543, 3.9752, 3.9841, 3.9761, 3.9445, 3.888, 3.8071,
         3.7041, 3.5818, 3.444, 3.2943, 3.1366, 2.974, 2.8096, 2.6461, 2.4855, 2.3296, 2.1795, 2.036, 1.8997, 1.7709,
         1.7204, 1.6915, 1.6856, 11.688, 11.587, 11.518, 16.406, 16.392, 16.365, 16.009, 14.855, 13.462, 13.133, 12.846,
         12.771, 14.371, 14.093, 13.914, 12.748, 11.672, 10.67, 9.7452, 8.8912, 8.0226, 7.2353, 6.5161, 5.8615, 5.2721,
         4.7405, 4.263, 3.8344, 3.4502, 3.1057, 2.7971, 2.5207, 2.2658, 2.0299, 1.8208, 1.6307, 1.4474, 1.2756, 1.1254,
         0.9938, 0.87851, 0.77738, 0.6886, 0.61057, 0.54194, 0.48151, 0.4518, 0.43991, 0.43683, 3.9165, 3.8773, 3.8091,
         3.4413, 3.0935, 2.7898, 2.5128, 2.2524, 2.0153, 1.7961, 1.6008, 1.4269, 1.2717, 1.1261, 0.99494, 0.87882,
         0.77631, 0.6858, 0.60588, 0.53531, 0.47298, 0.41793, 0.36931, 0.32636, 0.28815, 0.25208, 0.22018, 0.19232,
         0.16799, 0.14673, 0.12816, 0.11195, 0.097787, 0.085421, 0.074621, 0.065188, 0.056949, 0.049753, 0.043467,
         0.037976, 0.033179, 0.028939, 0.025144, 0.021847, 0.018983, 0.016494, 0.014332, 0.012453, 0.010821, 0.009403,
         0.0081708, 0.0071002, 0.0061699, 0.0053615, 0.0046591, 0.0040488, 0.0035185, 0.0030576, 0.0026571, 0.0023091,
         0.0020067, 0.0017439, 0.0015156, 0.0013171, 0.0011447, 0.0009948, 0.00086456]],
    'Mn':                                                                                                         [
        [0.007000906, 0.007108063, 0.007116359, 0.007136638, 0.007179501, 0.007225283, 0.007254329, 0.007286658,
         0.007297899, 0.007406823, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306,
         0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327,
         0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.047628, 0.048357,
         0.0485514, 0.048843, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695,
         0.07912411, 0.082222, 0.0834805, 0.0838161, 0.0843195, 0.08458368, 0.085578, 0.09041995, 0.09665893, 0.1033284,
         0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709,
         0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405,
         0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.627494, 0.6370985, 0.638372,
         0.6396597, 0.6435015, 0.648143, 0.6507486, 0.653106, 0.654657, 0.664428, 0.6692609, 0.7154399, 0.75362,
         0.7648052, 0.765155, 0.768231, 0.772845, 0.78438, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676,
         1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304,
         2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924,
         4.953664, 5.295467, 5.660855, 6.051453, 6.40822, 6.469004, 6.506305, 6.532461, 6.571695, 6.66978, 6.915365,
         7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688,
         15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405,
         32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287,
         66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669,
         139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869,
         290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [4.87567, 4.76264, 4.74787, 4.69094, 4.68054, 4.60492, 4.43167, 4.5645, 4.60423, 4.74833, 4.87379, 4.86446,
         4.85674, 4.85198, 4.85154, 4.85683, 4.86935, 4.89071, 4.92262, 4.96681, 5.02507, 5.0993, 5.19091, 5.30149,
         5.43236, 5.58491, 5.75947, 5.9515, 6.15427, 6.3576, 6.54294, 6.66665, 6.55405, 6.20116, 5.35353, 4.21071,
         5.54427, 6.78893, 8.26842, 8.82114, 9.17629, 9.46762, 9.72427, 9.94746, 10.1123, 10.1176, 9.99109, 9.79639,
         10.0228, 10.0962, 10.2519, 10.6219, 10.9524, 11.2573, 11.5559, 11.8579, 12.1705, 12.5017, 12.8362, 13.14,
         13.4258, 13.6967, 13.9546, 14.1998, 14.4295, 14.6387, 14.8229, 14.9795, 15.1015, 15.1866, 15.2308, 15.2292,
         15.1754, 15.06, 14.8692, 14.5809, 14.1575, 13.5289, 12.5443, 10.7856, 5.92995, 5.54629, 0.707354, -0.976022,
         -4.53373, 0.0775254, 1.67813, 0.172464, 2.39202, 3.80093, 7.80621, 8.95254, 14.2272, 15.7962, 15.5761, 15.5425,
         14.7738, 15.8637, 17.0753, 18.7594, 20.4727, 21.6815, 22.5986, 23.3123, 23.8555, 24.2393, 24.5176, 24.7113,
         24.8369, 24.9125, 24.9499, 24.9583, 24.9447, 24.9156, 24.8752, 24.8294, 24.7785, 24.7246, 24.6691, 24.612,
         24.5255, 24.4274, 24.3202, 24.2039, 24.0759, 23.9312, 23.7601, 23.5437, 23.2388, 22.7115, 21.4354, 20.7891,
         19.9795, 18.2218, 20.0165, 21.641, 22.9017, 23.8502, 24.3589, 24.6957, 24.9352, 25.0944, 25.2022, 25.2757,
         25.3252, 25.3579, 25.4183, 25.424, 25.4196, 25.4086, 25.3932, 25.3751, 25.3554, 25.3349, 25.3143, 25.2941,
         25.2746, 25.2565, 25.2383, 25.22, 25.2021, 25.1851, 25.1691, 25.1541, 25.1401, 25.1272, 25.1153, 25.1044,
         25.0944, 25.0853, 25.077, 25.0695, 25.0626, 25.0565, 25.0508, 25.0456, 25.0409, 25.0367, 25.0329, 25.0294,
         25.0263, 25.0235, 25.021, 25.0187, 25.0167, 25.0149, 25.0133, 25.0118, 25.0105, 25.0094, 25.0083, 25.0074,
         25.0066, 25.0059, 25.0052, 25.0046, 25.0041, 25.0036, 25.0032],
        [0.0, 0.0, 0.0, 0.0, 0.086582, 0.087712, 0.088433, 0.43229, 0.43365, 0.44694, 0.89599, 1.0032, 1.1196, 1.246,
         1.3827, 1.5303, 1.6889, 1.8586, 2.0393, 2.2306, 2.4316, 2.6413, 2.8582, 3.0804, 3.3057, 3.5314, 3.7511, 3.9586,
         4.1504, 4.3234, 4.4745, 4.6014, 4.7022, 4.7343, 4.751, 4.7551, 7.0772, 6.9247, 6.3735, 6.0061, 5.7945, 5.6564,
         5.5542, 5.4705, 5.3977, 5.3596, 5.3453, 5.3415, 5.7433, 5.7418, 5.7364, 5.7149, 5.697, 5.6848, 5.6777, 5.6747,
         5.674, 5.6709, 5.5608, 5.4373, 5.3132, 5.1855, 5.0514, 4.9083, 4.7517, 4.5816, 4.3992, 4.2068, 4.0069, 3.8023,
         3.5956, 3.3896, 3.1862, 2.9874, 2.7947, 2.6096, 2.4328, 2.2649, 2.1063, 1.9569, 1.8169, 1.8123, 1.7817, 1.7778,
         1.7738, 11.535, 11.416, 11.351, 16.147, 16.092, 15.75, 15.586, 14.152, 13.13, 12.855, 12.846, 12.772, 14.414,
         14.137, 13.388, 12.261, 11.217, 10.249, 9.3203, 8.4254, 7.5974, 6.8499, 6.1613, 5.5413, 4.9834, 4.4808, 4.0297,
         3.6251, 3.2624, 2.9374, 2.6463, 2.3855, 2.1404, 1.92, 1.7102, 1.508, 1.331, 1.176, 1.04, 0.9207, 0.81589,
         0.72375, 0.64266, 0.57123, 0.50825, 0.46011, 0.45266, 0.44818, 0.44509, 3.9072, 3.797, 3.547, 3.1829, 2.8708,
         2.5884, 2.3192, 2.0682, 1.8446, 1.6453, 1.4677, 1.3092, 1.1631, 1.0284, 0.9087, 0.80299, 0.70962, 0.62716,
         0.55431, 0.48995, 0.43309, 0.38284, 0.33845, 0.29781, 0.26044, 0.22761, 0.19892, 0.17386, 0.15195, 0.13281,
         0.11608, 0.10146, 0.088683, 0.077519, 0.067762, 0.059235, 0.051782, 0.045268, 0.039574, 0.03454, 0.030033,
         0.026114, 0.022708, 0.019746, 0.01717, 0.014931, 0.012984, 0.011291, 0.009819, 0.0085389, 0.0074258, 0.0064579,
         0.0056162, 0.0048843, 0.0042478, 0.0036942, 0.0032129, 0.0027943, 0.0024302, 0.0021136, 0.0018383, 0.0015988,
         0.0013905, 0.0012094, 0.0010519]],
    'Fe':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05292, 0.05302035, 0.05373, 0.053946,
         0.05427, 0.05508, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368,
         0.09041995, 0.091042, 0.0924355, 0.0928071, 0.0933645, 0.094758, 0.09665893, 0.1033284, 0.1104581, 0.1180797,
         0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188,
         0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657,
         0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.693938, 0.7045595, 0.706678, 0.7073919,
         0.7116405, 0.7154399, 0.7174945, 0.7203789, 0.722262, 0.7247055, 0.735522, 0.7648052, 0.8175768, 0.829178,
         0.8418695, 0.8452539, 0.8503305, 0.863022, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098,
         1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848,
         2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467,
         5.660855, 6.051453, 6.469004, 6.915365, 6.96976, 7.07644, 7.104888, 7.14756, 7.25424, 7.392525, 7.902609,
         8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362,
         17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889,
         36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536,
         76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864,
         159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304,
         331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [4.40382, 4.40661, 4.41481, 4.42757, 4.44647, 4.4736, 4.51048, 4.55792, 4.61691, 4.6885, 4.7737, 4.87349,
         4.98874, 5.12026, 5.26878, 5.43505, 5.61986, 5.8282, 6.05409, 6.29071, 6.53388, 6.77456, 6.99243, 7.12657,
         6.78937, 6.74584, 6.05634, 5.04941, 6.23005, 7.32766, 8.17043, 9.1286, 9.72729, 10.2742, 10.7404, 11.1204,
         11.4192, 11.5747, 11.5657, 11.443, 11.2427, 11.4812, 11.726, 11.8998, 12.2954, 12.6117, 12.8952, 13.1595,
         13.4126, 13.6595, 13.9037, 14.1496, 14.3931, 14.6359, 14.8762, 15.1118, 15.3398, 15.5539, 15.7483, 15.9181,
         16.0582, 16.1644, 16.2326, 16.2582, 16.2355, 16.1566, 16.0101, 15.7788, 15.434, 14.9253, 14.1528, 12.8786,
         10.271, 6.60633, 1.76776, -1.24454, -3.49355, 1.19707, 2.82538, 2.96615, 1.39388, 2.65657, 4.99594, 8.97159,
         13.3092, 16.4542, 16.7052, 16.4524, 15.6692, 16.7842, 18.0245, 18.6609, 20.8209, 22.2293, 23.2714, 24.0488,
         24.6633, 25.1128, 25.4331, 25.6643, 25.817, 25.9124, 25.9647, 25.984, 25.9787, 25.9575, 25.9217, 25.8778,
         25.8293, 25.7812, 25.7281, 25.6539, 25.5677, 25.4704, 25.3646, 25.2504, 25.1258, 24.9864, 24.8241, 24.6232,
         24.3495, 23.9082, 22.789, 22.4649, 21.0168, 19.2682, 21.0548, 22.6714, 23.4808, 24.683, 25.2655, 25.6451,
         25.8973, 26.066, 26.1815, 26.2607, 26.3142, 26.3498, 26.4121, 26.4211, 26.4188, 26.4094, 26.3951, 26.3778,
         26.3587, 26.3387, 26.3183, 26.2983, 26.2809, 26.2618, 26.243, 26.2243, 26.2062, 26.1889, 26.1725, 26.1573,
         26.1431, 26.13, 26.1179, 26.1068, 26.0966, 26.0873, 26.0789, 26.0712, 26.0643, 26.0579, 26.0521, 26.0468,
         26.042, 26.0376, 26.0337, 26.0302, 26.027, 26.0241, 26.0215, 26.0192, 26.0171, 26.0153, 26.0136, 26.0121,
         26.0108, 26.0096, 26.0086, 26.0076, 26.0068, 26.006, 26.0053, 26.0047, 26.0042, 26.0037],
        [1.424, 1.5363, 1.6592, 1.7931, 1.9386, 2.096, 2.2636, 2.441, 2.6278, 2.8235, 3.0272, 3.2383, 3.4557, 3.6787,
         3.9061, 4.137, 4.3705, 4.599, 4.8169, 5.0275, 5.2288, 5.4191, 5.5969, 5.7609, 5.906, 5.9101, 5.9379, 5.9462,
         8.0096, 7.9125, 7.7445, 7.4424, 7.3003, 7.1586, 6.8831, 6.6327, 6.3988, 6.1785, 6.1566, 6.1086, 6.0961, 6.5009,
         6.4618, 6.4106, 6.2493, 6.1022, 5.9677, 5.8454, 5.7339, 5.6308, 5.533, 5.4371, 5.3394, 5.2365, 5.1252, 5.0034,
         4.8675, 4.7151, 4.5474, 4.3664, 4.175, 3.976, 3.7724, 3.567, 3.3624, 3.1607, 2.9637, 2.773, 2.5897, 2.4147,
         2.2486, 2.0915, 1.9436, 1.8672, 1.8359, 1.8298, 1.8277, 11.657, 11.565, 11.515, 11.447, 16.292, 16.209, 15.852,
         14.949, 13.531, 13.253, 12.96, 12.883, 14.559, 14.272, 14.032, 12.835, 11.74, 10.687, 9.7229, 8.8309, 7.9627,
         7.1798, 6.4637, 5.8123, 5.2261, 4.6982, 4.2238, 3.7984, 3.4173, 3.076, 2.7704, 2.4969, 2.2482, 2.0033, 1.7751,
         1.5695, 1.387, 1.2269, 1.0864, 0.96283, 0.85419, 0.75854, 0.67426, 0.59992, 0.5343, 0.47631, 0.46996, 0.4579,
         0.45477, 3.8992, 3.7877, 3.6502, 3.265, 2.9475, 2.6546, 2.3704, 2.1145, 1.8865, 1.6832, 1.502, 1.3404, 1.194,
         1.0562, 0.93409, 0.82587, 0.73023, 0.64572, 0.57102, 0.505, 0.44663, 0.39503, 0.34777, 0.30571, 0.26786,
         0.2342, 0.20478, 0.17906, 0.15658, 0.13691, 0.11972, 0.10469, 0.09155, 0.080062, 0.070017, 0.061234, 0.053554,
         0.046838, 0.040894, 0.035564, 0.03093, 0.0269, 0.023395, 0.020347, 0.017697, 0.015392, 0.013387, 0.011644,
         0.010128, 0.0088094, 0.0076625, 0.006665, 0.0057975, 0.0050429, 0.0043866, 0.0038158, 0.0033192, 0.0028873,
         0.0025117, 0.0021849, 0.0019006, 0.0016534, 0.0014383, 0.0012512]],
    'Co':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.05831,
         0.0592025, 0.0594405, 0.0597975, 0.06058959, 0.06069, 0.06477028, 0.06923942, 0.07401695, 0.07912411,
         0.08458368, 0.09041995, 0.09665893, 0.098686, 0.1001965, 0.1005993, 0.1012035, 0.102714, 0.1033284, 0.1104581,
         0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655,
         0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189,
         0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.763028, 0.7648052,
         0.774707, 0.777728, 0.7778214, 0.782493, 0.789632, 0.7928064, 0.794172, 0.797568, 0.809472, 0.8175768,
         0.8739896, 0.907088, 0.920972, 0.9246744, 0.930228, 0.9342948, 0.944112, 0.9987612, 1.067676, 1.141345,
         1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781,
         2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664,
         5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.554722, 7.670355, 7.701191, 7.747444, 7.863078,
         7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095,
         16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502,
         34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318,
         71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553,
         148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126,
         310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [4.07651, 4.07931, 4.08644, 4.09903, 4.11806, 4.14462, 4.17992, 4.22518, 4.28168, 4.35067, 4.43344, 4.53124,
         4.64533, 4.77694, 4.92734, 5.09779, 5.28966, 5.50445, 5.74388, 6.01002, 6.30538, 6.67459, 7.06312, 7.46141,
         7.85964, 8.12459, 7.95238, 7.32491, 6.41648, 7.50344, 8.46511, 8.53783, 9.99361, 10.7, 11.1971, 11.6018,
         11.9426, 12.2207, 12.3949, 12.3849, 12.2528, 12.0449, 12.2888, 12.5366, 12.5962, 13.0306, 13.3567, 13.6488,
         13.9231, 14.1876, 14.4472, 14.7051, 14.9632, 15.2277, 15.486, 15.7421, 15.9934, 16.2372, 16.4686, 16.681,
         16.8691, 17.0277, 17.1536, 17.2425, 17.29, 17.2911, 17.2394, 17.1251, 16.9341, 16.6433, 16.2138, 15.5717,
         14.5571, 12.7139, 7.65825, 7.22164, 2.81236, -2.10962, -2.47515, 2.28899, 4.2024, 2.56916, 2.39355, 6.16476,
         10.1298, 11.6331, 16.5757, 17.6437, 17.4222, 16.6663, 17.7529, 18.2397, 18.9734, 21.1535, 22.7846, 23.9382,
         24.8005, 25.4732, 25.9977, 26.3628, 26.6227, 26.7981, 26.9098, 26.9744, 27.0031, 27.0049, 26.9898, 26.9602,
         26.9203, 26.8771, 26.8376, 26.7746, 26.6954, 26.6078, 26.5107, 26.4054, 26.2922, 26.1697, 26.0338, 25.8774,
         25.6869, 25.4337, 25.044, 24.1983, 23.4922, 22.0515, 20.3118, 22.0899, 23.698, 23.9681, 25.5247, 26.1889,
         26.5956, 26.8641, 27.0436, 27.1663, 27.2503, 27.3072, 27.3449, 27.3695, 27.4194, 27.4188, 27.4105, 27.3973,
         27.3808, 27.3623, 27.343, 27.3241, 27.3053, 27.2853, 27.2654, 27.2463, 27.2274, 27.2091, 27.1916, 27.1751,
         27.1597, 27.1453, 27.132, 27.1198, 27.1086, 27.0983, 27.0889, 27.0803, 27.0725, 27.0655, 27.059, 27.053,
         27.0476, 27.0427, 27.0383, 27.0343, 27.0307, 27.0275, 27.0246, 27.0219, 27.0196, 27.0175, 27.0156, 27.0139,
         27.0124, 27.011, 27.0098, 27.0087, 27.0078, 27.0069, 27.0061, 27.0055, 27.0049, 27.0043],
        [1.5562, 1.6781, 1.8115, 1.9562, 2.1124, 2.2802, 2.4597, 2.6509, 2.8536, 3.0675, 3.2922, 3.5274, 3.7723, 4.0266,
         4.2894, 4.5603, 4.8385, 5.1236, 5.4151, 5.7127, 6.0162, 6.3044, 6.5733, 6.8347, 7.0873, 7.1365, 7.0944, 7.0696,
         7.0627, 8.9241, 8.8069, 8.7924, 8.2619, 7.8176, 7.4801, 7.1971, 6.9439, 6.7099, 6.4907, 6.4253, 6.3784, 6.3661,
         6.7844, 6.7462, 6.7311, 6.5708, 6.4252, 6.2918, 6.1699, 6.0579, 5.9535, 5.8536, 5.7547, 5.6531, 5.5455, 5.4288,
         5.3009, 5.1597, 5.0016, 4.8271, 4.6386, 4.4388, 4.2307, 4.0175, 3.8022, 3.5873, 3.3752, 3.1678, 2.9667, 2.7733,
         2.5884, 2.4125, 2.2461, 2.0893, 1.9469, 1.9419, 1.9146, 1.9064, 1.9061, 11.809, 11.644, 11.572, 16.482, 16.372,
         15.995, 15.747, 14.185, 13.401, 13.097, 13.018, 14.641, 14.556, 14.357, 13.34, 12.182, 11.109, 10.116, 9.2078,
         8.3151, 7.4892, 6.7415, 6.0602, 5.448, 4.8978, 4.4033, 3.9603, 3.5635, 3.2082, 2.8901, 2.6054, 2.3362, 2.0714,
         1.837, 1.6283, 1.4403, 1.2751, 1.13, 1.0023, 0.88996, 0.79093, 0.7036, 0.62651, 0.55839, 0.49816, 0.4801,
         0.46787, 0.4647, 3.8913, 3.7792, 3.742, 3.3364, 3.0147, 2.7028, 2.4149, 2.1541, 1.9216, 1.7145, 1.5298, 1.3652,
         1.2182, 1.0783, 0.95438, 0.84426, 0.7469, 0.66081, 0.58469, 0.51737, 0.45783, 0.40326, 0.35466, 0.31194,
         0.27377, 0.23948, 0.2095, 0.18327, 0.16034, 0.14027, 0.12271, 0.10735, 0.09392, 0.082171, 0.071894, 0.062904,
         0.05504, 0.048079, 0.041842, 0.036414, 0.031691, 0.027581, 0.024005, 0.020892, 0.018184, 0.015826, 0.013775,
         0.01199, 0.010436, 0.0090837, 0.0079067, 0.0068823, 0.0059908, 0.0052147, 0.0045393, 0.0039514, 0.0034396,
         0.0029942, 0.0026065, 0.002269, 0.0019752, 0.0017195, 0.0014969]],
    'Ni':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.06477028, 0.066738, 0.0677595, 0.0680319, 0.0684405, 0.06923942, 0.069462, 0.07401695, 0.07912411,
         0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.109564, 0.1104581, 0.111241, 0.1116882, 0.112359, 0.114036,
         0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655,
         0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189,
         0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768,
         0.837606, 0.8504265, 0.854462, 0.8589735, 0.8675405, 0.8710281, 0.871794, 0.8739896, 0.8762595, 0.889338,
         0.9342948, 0.987938, 0.9987612, 1.00306, 1.007092, 1.013141, 1.028262, 1.067676, 1.141345, 1.220098, 1.304285,
         1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235,
         2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855,
         6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.166144, 8.291136, 8.324467, 8.374464, 8.44789, 8.499456,
         9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961,
         18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551,
         39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578,
         81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356,
         170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294,
         354.4049, 378.8588, 405.0001, 432.9451],
        [3.57659, 3.57599, 3.57095, 3.56836, 3.56968, 3.57685, 3.59151, 3.61476, 3.64791, 3.69236, 3.74958, 3.82103,
         3.90818, 4.01245, 4.13521, 4.27778, 4.44144, 4.62739, 4.83686, 5.07105, 5.33124, 5.61884, 5.93534, 6.28228,
         6.72188, 7.16643, 7.58919, 7.89984, 7.81083, 7.29248, 6.49266, 7.47679, 8.30426, 8.44458, 9.92898, 10.7677,
         11.3913, 11.9094, 12.3487, 12.7032, 12.8584, 12.8304, 12.7438, 12.5364, 12.794, 13.0669, 13.3934, 13.8459,
         14.2329, 14.5869, 14.9196, 15.2378, 15.5459, 15.8466, 16.1413, 16.4384, 16.72, 16.9927, 17.2537, 17.5008,
         17.7292, 17.933, 18.1062, 18.2471, 18.3508, 18.4135, 18.431, 18.3977, 18.3055, 18.1427, 17.8905, 17.5178,
         16.9681, 16.1269, 14.7079, 11.5821, 8.76961, 3.93819, -5.44705, 3.45285, 5.48784, 3.82284, 0.68749, 5.8096,
         7.36968, 11.2789, 16.2345, 18.4258, 18.4133, 18.2231, 17.4472, 18.5689, 19.8654, 21.5374, 23.3736, 24.6251,
         25.5591, 26.2818, 26.8506, 27.2544, 27.5358, 27.73, 27.8603, 27.9855, 28.0289, 28.0405, 28.0299, 28.0016,
         27.9659, 27.9386, 27.8847, 27.8165, 27.734, 27.6425, 27.5458, 27.4435, 27.3322, 27.2114, 27.0779, 26.9254,
         26.7418, 26.5023, 26.1454, 25.4382, 24.5187, 23.0862, 21.3577, 23.1229, 24.2866, 24.7181, 26.3786, 27.1216,
         27.5654, 27.8453, 28.0311, 28.1583, 28.2454, 28.3043, 28.3432, 28.3682, 28.4192, 28.4194, 28.412, 28.3996,
         28.3839, 28.3663, 28.3479, 28.329, 28.3086, 28.288, 28.2678, 28.2484, 28.2295, 28.211, 28.1934, 28.1768,
         28.1613, 28.1468, 28.1334, 28.1211, 28.1097, 28.0994, 28.0899, 28.0813, 28.0734, 28.0662, 28.0596, 28.0536,
         28.0481, 28.0432, 28.0387, 28.0347, 28.0311, 28.0278, 28.0248, 28.0222, 28.0198, 28.0177, 28.0158, 28.0141,
         28.0125, 28.0112, 28.0099, 28.0088, 28.0079, 28.007, 28.0062, 28.0055, 28.0049],
        [1.4343, 1.5448, 1.667, 1.8017, 1.95, 2.1125, 2.2884, 2.4778, 2.6808, 2.8974, 3.1272, 3.3699, 3.625, 3.892,
         4.1699, 4.4581, 4.7557, 5.0616, 5.3751, 5.6954, 6.0216, 6.3532, 6.6897, 7.0309, 7.3516, 7.6429, 7.9225, 8.1889,
         8.3039, 8.3483, 8.3411, 10.005, 9.9197, 9.8964, 9.4522, 9.042, 8.7086, 8.4128, 8.1362, 7.8715, 7.6469, 7.6164,
         7.5899, 7.5749, 7.9994, 7.9514, 7.8409, 7.639, 7.4472, 7.2647, 7.0911, 6.925, 6.7644, 6.6064, 6.448, 6.2862,
         6.1183, 5.942, 5.756, 5.5592, 5.3486, 5.1254, 4.8924, 4.6526, 4.4092, 4.165, 3.923, 3.6854, 3.4539, 3.2304,
         3.0161, 2.8117, 2.618, 2.4352, 2.2632, 2.1021, 2.0462, 2.0119, 2.0013, 11.918, 11.735, 11.662, 11.646, 16.508,
         16.442, 16.066, 14.877, 13.649, 13.424, 13.334, 13.251, 14.933, 14.615, 13.841, 12.599, 11.485, 10.475, 9.5264,
         8.6323, 7.7753, 7.0012, 6.3039, 5.6777, 5.1095, 4.592, 4.1285, 3.7138, 3.343, 3.0114, 2.6981, 2.4055, 2.1392,
         1.897, 1.6844, 1.4976, 1.3269, 1.1761, 1.0433, 0.92645, 0.82342, 0.73254, 0.65229, 0.58138, 0.51866, 0.49051,
         0.47804, 0.4748, 3.8783, 3.8127, 3.7677, 3.4017, 3.0709, 2.7492, 2.4485, 2.1838, 1.9478, 1.7376, 1.5502,
         1.3831, 1.2341, 1.0942, 0.96902, 0.8582, 0.76013, 0.67282, 0.59559, 0.52725, 0.46461, 0.40881, 0.35972,
         0.31655, 0.27821, 0.24347, 0.21307, 0.18647, 0.1632, 0.14284, 0.12502, 0.10943, 0.095778, 0.083836, 0.073385,
         0.064239, 0.056155, 0.048934, 0.042642, 0.037161, 0.032385, 0.028224, 0.024598, 0.021438, 0.018685, 0.016286,
         0.014196, 0.012374, 0.010786, 0.009402, 0.008196, 0.0071448, 0.0062286, 0.00543, 0.0047339, 0.0041272,
         0.0035983, 0.0031373, 0.0027354, 0.002385, 0.0020796, 0.0018133]],
    'Cu':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.06477028, 0.06923942, 0.072128, 0.073232, 0.0735264, 0.07401695, 0.075072, 0.07912411, 0.08458368,
         0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.117404, 0.1180797, 0.119201, 0.1196802, 0.120399, 0.122196,
         0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188,
         0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657,
         0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896,
         0.912478, 0.9264445, 0.9301689, 0.93198, 0.9342948, 0.9357555, 0.946245, 0.950049, 0.955755, 0.97002,
         0.9987612, 1.067676, 1.074178, 1.090619, 1.095004, 1.10158, 1.118022, 1.141345, 1.220098, 1.304285, 1.394281,
         1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724,
         3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453,
         6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 8.799322, 8.934005, 8.969921, 9.030794, 9.158478, 9.653919,
         10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215,
         21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992,
         44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069,
         93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539,
         194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588,
         405.0001, 432.9451],
        [5.11541, 5.16418, 5.21676, 5.27396, 5.33667, 5.40595, 5.48301, 5.56923, 5.66623, 5.77588, 5.9004, 6.0425,
         6.20556, 6.39395, 6.61376, 6.874, 7.18087, 7.48774, 7.79039, 8.0925, 8.39535, 8.69863, 9.00071, 9.29848,
         9.58673, 9.85667, 10.0916, 10.2528, 10.202, 9.67426, 8.64551, 7.25829, 9.01656, 10.3701, 11.8948, 12.5602,
         12.902, 13.1577, 13.3709, 13.538, 13.57, 13.5466, 13.444, 13.2559, 13.4706, 13.6854, 13.9079, 14.2299, 14.515,
         14.7908, 15.0662, 15.3462, 15.6336, 15.93, 16.2355, 16.5503, 16.8682, 17.1872, 17.5025, 17.8097, 18.1027,
         18.3733, 18.6138, 18.8206, 18.9882, 19.1122, 19.1884, 19.2116, 19.1744, 19.0663, 18.8708, 18.5608, 18.0877,
         17.3572, 16.1368, 13.6848, 9.41949, 4.24002, -1.51687, -1.75592, 2.65894, 3.88406, 6.37, 4.47663, 8.42374,
         12.7452, 16.533, 19.8679, 19.967, 19.7917, 19.1176, 20.0415, 21.1255, 22.025, 24.0494, 25.395, 26.3665,
         27.0949, 27.6981, 28.1525, 28.467, 28.6884, 28.8419, 28.9864, 29.0462, 29.069, 29.0677, 29.0575, 29.0457,
         28.9922, 28.9262, 28.8535, 28.7704, 28.6782, 28.5808, 28.479, 28.3686, 28.2491, 28.1175, 27.9683, 27.7902,
         27.561, 27.227, 26.5993, 25.5649, 24.1493, 22.4326, 24.3489, 25.7726, 27.312, 28.0727, 28.5046, 28.7985,
         29.0017, 29.1413, 29.2373, 29.3017, 29.3434, 29.3688, 29.4189, 29.4195, 29.4125, 29.4006, 29.3855, 29.3684,
         29.3516, 29.3316, 29.3106, 29.2896, 29.2692, 29.2497, 29.2308, 29.2123, 29.1946, 29.1779, 29.1623, 29.1478,
         29.1344, 29.122, 29.1106, 29.1001, 29.0907, 29.0821, 29.0741, 29.0668, 29.0601, 29.0541, 29.0486, 29.0436,
         29.0391, 29.035, 29.0313, 29.028, 29.0251, 29.0224, 29.02, 29.0179, 29.0159, 29.0142, 29.0127, 29.0113,
         29.0101, 29.009, 29.008, 29.0071, 29.0063, 29.0056],
        [2.1733, 2.2889, 2.4126, 2.5449, 2.6864, 2.8374, 2.9985, 3.1701, 3.3525, 3.546, 3.7507, 3.9669, 4.1946, 4.4336,
         4.6837, 4.9447, 5.1429, 5.2695, 5.3892, 5.5005, 5.6019, 5.6922, 5.7698, 5.8335, 5.8821, 5.9145, 5.9298, 5.9273,
         5.9066, 5.8847, 5.8748, 5.8721, 8.6666, 8.4419, 7.734, 7.0931, 6.7123, 6.4597, 6.2728, 6.1234, 6.0085, 5.9985,
         5.9824, 5.9757, 6.3567, 6.3407, 6.3091, 6.2577, 6.2188, 6.1892, 6.1667, 6.1485, 6.131, 6.1101, 6.0812, 6.0398,
         5.9821, 5.9048, 5.8057, 5.6839, 5.536, 5.3635, 5.1699, 4.9596, 4.7369, 4.5063, 4.2718, 4.0367, 3.804, 3.5762,
         3.3552, 3.1426, 2.9393, 2.7122, 2.4939, 2.2948, 2.1756, 2.1352, 2.1247, 13.119, 13.043, 12.996, 12.662, 12.545,
         17.798, 17.165, 15.984, 13.862, 13.705, 13.328, 13.231, 14.651, 14.383, 14.041, 12.862, 11.731, 10.688, 9.7449,
         8.8867, 8.0183, 7.2303, 6.5194, 5.878, 5.2957, 4.7581, 4.2769, 3.847, 3.4633, 3.1014, 2.7637, 2.465, 2.1976,
         1.9496, 1.7317, 1.5402, 1.367, 1.2121, 1.0758, 0.95563, 0.84971, 0.75624, 0.67369, 0.60071, 0.53613, 0.50037,
         0.48721, 0.4834, 3.8582, 3.754, 3.4054, 3.0504, 2.7462, 2.4736, 2.2129, 1.9766, 1.7631, 1.5712, 1.3994, 1.2463,
         1.1059, 0.97986, 0.86826, 0.76945, 0.68155, 0.60363, 0.53216, 0.46847, 0.41242, 0.3631, 0.31969, 0.28131,
         0.24628, 0.21563, 0.1888, 0.16531, 0.14475, 0.12675, 0.11098, 0.097185, 0.085104, 0.074527, 0.06518, 0.056834,
         0.049559, 0.043217, 0.037687, 0.032866, 0.028662, 0.024997, 0.021801, 0.019015, 0.016585, 0.014466, 0.012618,
         0.011006, 0.0096007, 0.0083749, 0.0073058, 0.0063734, 0.0055601, 0.0048507, 0.0042319, 0.0036922, 0.0032214,
         0.0028106, 0.0024524, 0.0021398]],
    'Zn':                                                                                                         [
        [0.007938, 0.0080595, 0.0080919, 0.0081405, 0.008262, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368,
         0.084868, 0.086167, 0.0865134, 0.087033, 0.088332, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797,
         0.1262272, 0.133182, 0.1349368, 0.1352205, 0.1357641, 0.1365795, 0.138618, 0.1442475, 0.1542005, 0.1648404,
         0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482,
         0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625,
         0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9, 0.9045, 0.9090225, 0.91356761, 0.91813545,
         0.92272613, 0.92733976, 0.93197646, 0.93663634, 0.94131952, 0.94602612, 0.95075625, 0.95551003, 0.96028758,
         0.96508902, 0.96991446, 0.97476404, 0.97963786, 0.98453605, 0.98945873, 0.99440602, 0.99937805, 1.0043749,
         1.0093968, 1.0144438, 1.019516, 1.019629, 1.0197711, 1.0246136, 1.0297367, 1.0348853, 1.0400598, 1.0427279,
         1.042872, 1.0452601, 1.0504864, 1.0557388, 1.0610175, 1.0663226, 1.0716542, 1.0770125, 1.0823975, 1.0878095,
         1.0932486, 1.0987148, 1.1042084, 1.1097294, 1.1152781, 1.1208545, 1.1264587, 1.132091, 1.1377515, 1.1434402,
         1.1491574, 1.1549032, 1.1606777, 1.1664811, 1.1723135, 1.1781751, 1.184066, 1.1899863, 1.1924542, 1.1947459,
         1.1959362, 1.2019159, 1.2079255, 1.2139651, 1.220035, 1.2261351, 1.2322658, 1.2384271, 1.2446193, 1.2508424,
         1.2570966, 1.2633821, 1.269699, 1.2760475, 1.2824277, 1.2888399, 1.295284, 1.3017605, 1.3082693, 1.3148106,
         1.3213847, 1.3279916, 1.3346316, 1.3413047, 1.3480112, 1.3547513, 1.361525, 1.3683327, 1.3751743, 1.3820502,
         1.3889605, 1.3959053, 1.4028848, 1.4098992, 1.4169487, 1.4240335, 1.4311536, 1.4383094, 1.4455009, 1.4527284,
         1.4599921, 1.467292, 1.4746285, 1.4820016, 1.4894117, 1.4968587, 1.504343, 1.5118647, 1.519424, 1.5270212,
         1.5346563, 1.5423295, 1.5500412, 1.5577914, 1.5655804, 1.5734083, 1.5812753, 1.5891817, 1.5971276, 1.6051132,
         1.6131388, 1.6212045, 1.6293105, 1.6374571, 1.6456443, 1.6538726, 1.6621419, 1.6704526, 1.6788049, 1.6871989,
         1.6956349, 1.7041131, 1.7126337, 1.7211968, 1.7298028, 1.7384518, 1.7471441, 1.7558798, 1.7646592, 1.7734825,
         1.7823499, 1.7912617, 1.800218, 1.8092191, 1.8182652, 1.8273565, 1.8364933, 1.8456757, 1.8549041, 1.8641786,
         1.8734995, 1.882867, 1.8922814, 1.9017428, 1.9112515, 1.9208077, 1.9304118, 1.9400638, 1.9497642, 1.959513,
         1.9693105, 1.9791571, 1.9890529, 1.9989981, 2.0089931, 2.0190381, 2.0291333, 2.039279, 2.0494754, 2.0597227,
         2.0700213, 2.0803714, 2.0907733, 2.1012272, 2.1117333, 2.122292, 2.1329034, 2.143568, 2.1542858, 2.1650572,
         2.1758825, 2.1867619, 2.1976957, 2.2086842, 2.2197276, 2.2308263, 2.2419804, 2.2531903, 2.2644562, 2.2757785,
         2.2871574, 2.2985932, 2.3100862, 2.3216366, 2.3332448, 2.344911, 2.3566356, 2.3684187, 2.3802608, 2.3921621,
         2.404123, 2.4161436, 2.4282243, 2.4403654, 2.4525672, 2.4648301, 2.4771542, 2.48954, 2.5019877, 2.5144976,
         2.5270701, 2.5397055, 2.552404, 2.565166, 2.5779919, 2.5908818, 2.6038362, 2.6168554, 2.6299397, 2.6430894,
         2.6563048, 2.6695863, 2.6829343, 2.6963489, 2.7098307, 2.7233798, 2.7369967, 2.7506817, 2.7644351, 2.7782573,
         2.7921486, 2.8061093, 2.8201399, 2.8342406, 2.8484118, 2.8626539, 2.8769671, 2.891352, 2.9058087, 2.9203378,
         2.9349394, 2.9496141, 2.9643622, 2.979184, 2.9940799, 3.0090503, 3.0240956, 3.0392161, 3.0544122, 3.0696842,
         3.0850326, 3.1004578, 3.1159601, 3.1315399, 3.1471976, 3.1629336, 3.1787482, 3.194642, 3.2106152, 3.2266683,
         3.2428016, 3.2590156, 3.2753107, 3.2916873, 3.3081457, 3.3246864, 3.3413099, 3.3580164, 3.3748065, 3.3916805,
         3.4086389, 3.4256821, 3.4428105, 3.4600246, 3.4773247, 3.4947113, 3.5121849, 3.5297458, 3.5473945, 3.5651315,
         3.5829572, 3.6008719, 3.6188763, 3.6369707, 3.6551555, 3.6734313, 3.6917985, 3.7102575, 3.7288088, 3.7474528,
         3.7661901, 3.785021, 3.8039461, 3.8229659, 3.8420807, 3.8612911, 3.8805975, 3.9000005, 3.9195005, 3.939098,
         3.9587935, 3.9785875, 3.9984804, 4.0184728, 4.0385652, 4.058758, 4.0790518, 4.0994471, 4.1199443, 4.140544,
         4.1612467, 4.182053, 4.2029632, 4.2239781, 4.245098, 4.2663234, 4.2876551, 4.3090933, 4.3306388, 4.352292,
         4.3740535, 4.3959237, 4.4179033, 4.4399929, 4.4621928, 4.4845038, 4.5069263, 4.5294609, 4.5521082, 4.5748688,
         4.5977431, 4.6207318, 4.6438355, 4.6670547, 4.69039, 4.7138419, 4.7374111, 4.7610982, 4.7849037, 4.8088282,
         4.8328723, 4.8570367, 4.8813219, 4.9057285, 4.9302571, 4.9549084, 4.9796829, 5.0045814, 5.0296043, 5.0547523,
         5.080026, 5.1054262, 5.1309533, 5.1566081, 5.1823911, 5.2083031, 5.2343446, 5.2605163, 5.2868189, 5.313253,
         5.3398192, 5.3665183, 5.3933509, 5.4203177, 5.4474193, 5.4746564, 5.5020297, 5.5295398, 5.5571875, 5.5849734,
         5.6128983, 5.6409628, 5.6691676, 5.6975135, 5.726001, 5.754631, 5.7834042, 5.8123212, 5.8413828, 5.8705897,
         5.8999427, 5.9294424, 5.9590896, 5.988885, 6.0188295, 6.0489236, 6.0791682, 6.1095641, 6.1401119, 6.1708125,
         6.2016665, 6.2326749, 6.2638382, 6.2951574, 6.3266332, 6.3582664, 6.3900577, 6.422008, 6.454118, 6.4863886,
         6.5188206, 6.5514147, 6.5841717, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.465428, 9.610307, 9.653919,
         9.706893, 9.851772, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961,
         18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551,
         39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578,
         81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356,
         170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294,
         354.4049, 378.8588, 405.0001, 432.9451],
        [1.89392, 1.58428, 1.24074, 1.56676, 1.83711, 2.18614, 2.18313, 2.17165, 2.15396, 2.13164, 2.10599, 2.07822,
         2.04961, 2.02156, 1.99571, 1.97391, 1.95833, 1.95148, 1.9198, 1.93967, 1.97834, 2.0404, 2.13183, 2.25682,
         2.41567, 2.609, 2.83737, 3.10102, 3.39971, 3.73279, 4.09943, 4.50246, 4.96402, 5.42968, 5.88267, 6.28468,
         6.3847, 6.35349, 5.9048, 5.22864, 6.04111, 6.84154, 7.44473, 8.49813, 9.27197, 9.9677, 10.6284, 11.2517,
         11.6453, 11.6353, 11.6068, 11.414, 11.7133, 12.0794, 12.7012, 13.6448, 14.4977, 15.2357, 15.8898, 16.4779,
         17.0117, 17.4994, 17.9464, 18.359, 18.7336, 19.0739, 19.38, 19.6517, 19.8882, 20.086, 20.2402, 20.3509,
         20.4139, 20.4261, 20.3829, 20.2777, 20.0994, 19.8305, 19.4417, 18.8803, 18.0422, 16.6852, 17.3931, 17.263,
         17.1262, 16.9821, 16.8299, 16.669, 16.4984, 16.3171, 16.1239, 15.9173, 15.6957, 15.4569, 15.1986, 14.9176,
         14.6101, 14.2713, 13.8946, 13.4716, 12.9904, 12.4339, 11.7757, 10.9729, 9.94316, 8.51478, 6.15159, -5.07956,
         -8.22555, -8.40332, 5.3677, 7.32086, 7.99378, 7.35582, 1.91437, 1.85341, 7.97659, 10.5445, 11.9953, 13.075,
         13.9517, 14.6953, 15.3428, 15.9165, 16.4313, 16.8974, 17.3222, 17.7116, 18.0696, 18.3997, 18.7044, 18.9856,
         19.2447, 19.4825, 19.6995, 19.8953, 20.0688, 20.2177, 20.3376, 20.4199, 20.4469, 20.3734, 20.0079, 19.4199,
         19.467, 19.9205, 20.8465, 21.3413, 21.7172, 22.0337, 22.313, 22.5663, 22.7996, 23.017, 23.2211, 23.4138,
         23.5968, 23.7712, 23.9379, 24.0975, 24.2507, 24.3978, 24.5392, 24.6754, 24.8065, 24.9329, 25.0546, 25.1727,
         25.2874, 25.3986, 25.5066, 25.6115, 25.7138, 25.8134, 25.9104, 26.005, 26.0973, 26.1872, 26.275, 26.3606,
         26.4442, 26.5257, 26.6054, 26.6833, 26.7594, 26.8337, 26.9065, 26.9776, 27.0472, 27.1153, 27.182, 27.2473,
         27.3113, 27.3741, 27.4356, 27.496, 27.5554, 27.6139, 27.6711, 27.727, 27.7815, 27.8347, 27.8868, 27.9377,
         27.9874, 28.0361, 28.0838, 28.1304, 28.1761, 28.2207, 28.2644, 28.3071, 28.3489, 28.3898, 28.4298, 28.469,
         28.5073, 28.5449, 28.5816, 28.6175, 28.6527, 28.6872, 28.7209, 28.7539, 28.7862, 28.8179, 28.8489, 28.8793,
         28.909, 28.9381, 28.9666, 28.9946, 29.022, 29.0488, 29.075, 29.1008, 29.126, 29.1507, 29.175, 29.1987, 29.222,
         29.2448, 29.2672, 29.2892, 29.3107, 29.3318, 29.3526, 29.373, 29.393, 29.4126, 29.432, 29.451, 29.4697,
         29.6021, 29.6199, 29.6373, 29.6541, 29.7278, 29.7436, 29.7589, 29.7737, 29.7879, 29.8017, 29.8149, 29.8278,
         29.8401, 29.8521, 29.8637, 29.8748, 29.8856, 29.896, 29.9061, 29.9158, 29.9252, 29.9343, 29.943, 29.9515,
         29.9596, 29.9675, 29.9751, 29.9824, 29.9895, 29.9964, 30.003, 30.0496, 30.0559, 30.0619, 30.0676, 30.073,
         30.0782, 30.0831, 30.0877, 30.0921, 30.0962, 30.1001, 30.1038, 30.1073, 30.1105, 30.1136, 30.1165, 30.1191,
         30.1216, 30.1239, 30.126, 30.128, 30.1297, 30.1313, 30.1328, 30.1341, 30.1353, 30.1363, 30.1372, 30.1379,
         30.1386, 30.1391, 30.1395, 30.1397, 30.1399, 30.14, 30.14, 30.1399, 30.1397, 30.1394, 30.1391, 30.1387,
         30.1382, 30.1377, 30.1372, 30.1366, 30.136, 30.1369, 30.1381, 30.1387, 30.1388, 30.1383, 30.1375, 30.1364,
         30.1349, 30.1331, 30.1312, 30.1289, 30.1265, 30.1239, 30.1211, 30.1181, 30.1149, 30.1116, 30.1082, 30.1046,
         30.1009, 30.097, 30.093, 30.089, 30.0848, 30.0805, 30.0761, 30.0716, 30.067, 30.0624, 30.0576, 30.0528,
         30.0479, 30.0429, 30.0379, 30.0327, 30.0276, 30.0223, 30.017, 30.0116, 30.0062, 30.0007, 29.9952, 29.9896,
         29.984, 29.9783, 29.9726, 29.9668, 29.961, 29.9551, 29.9492, 29.9433, 29.9374, 29.9314, 29.9253, 29.9193,
         29.9132, 29.9071, 29.9009, 29.8948, 29.8886, 29.8824, 29.8762, 29.8699, 29.8636, 29.8574, 29.8511, 29.8447,
         29.8384, 29.8321, 29.8257, 29.8194, 29.813, 29.8066, 29.8003, 29.7939, 29.7875, 29.7811, 29.7748, 29.7684,
         29.762, 29.7555, 29.749, 29.7424, 29.7358, 29.7291, 29.7224, 29.7156, 29.7087, 29.7018, 29.6949, 29.6879,
         29.6809, 29.6738, 29.6667, 29.6595, 29.6523, 29.6451, 29.6379, 29.6306, 29.6233, 29.616, 29.6086, 29.6012,
         29.5938, 29.5864, 29.5789, 29.5714, 29.5639, 29.5564, 29.5489, 29.5414, 29.5337, 29.526, 29.5183, 29.5105,
         29.5026, 29.4947, 29.4867, 29.4787, 29.4706, 29.4625, 29.4543, 29.4461, 29.4378, 29.4294, 29.421, 29.4126,
         29.4041, 29.3955, 29.387, 29.3783, 29.3696, 29.3608, 29.352, 29.3432, 29.3342, 29.3253, 29.3162, 29.3071,
         29.298, 29.2887, 29.2795, 29.2701, 29.2607, 29.2512, 29.2416, 29.232, 29.2223, 29.2125, 29.2027, 29.1928,
         29.1827, 29.1726, 29.1624, 29.1522, 29.1418, 29.1313, 29.1207, 29.0257, 28.8496, 28.6263, 28.308, 27.7362,
         26.6177, 25.2001, 22.708, 25.2381, 26.8206, 28.2422, 29.0456, 29.4892, 29.7882, 29.9968, 30.1393, 30.237,
         30.3025, 30.3446, 30.37, 30.4195, 30.4206, 30.4141, 30.4028, 30.3892, 30.3746, 30.3546, 30.3335, 30.312,
         30.2907, 30.2701, 30.2505, 30.2315, 30.213, 30.1953, 30.1786, 30.163, 30.1484, 30.135, 30.1225, 30.1111,
         30.1011, 30.0916, 30.0827, 30.0746, 30.0672, 30.0605, 30.0544, 30.0488, 30.0438, 30.0393, 30.0352, 30.0315,
         30.0282, 30.0252, 30.0225, 30.0201, 30.018, 30.016, 30.0143, 30.0128, 30.0114, 30.0101, 30.009, 30.008,
         30.0071, 30.0064],
        [0.0, 0.0, 0.0, 0.66117, 0.67285, 0.91642, 0.99609, 1.0846, 1.1832, 1.293, 1.4153, 1.5516, 1.7033, 1.8717,
         2.0584, 2.2648, 2.4922, 2.7417, 3.0145, 3.3112, 3.6322, 3.9774, 4.3457, 4.7295, 5.1247, 5.5282, 5.9369, 6.3475,
         6.7568, 7.1617, 7.5593, 7.9471, 8.3109, 8.6353, 8.9287, 9.1879, 9.4104, 9.4205, 9.4654, 9.4769, 10.902, 10.895,
         10.884, 10.847, 10.845, 10.871, 10.904, 10.936, 10.958, 10.963, 10.964, 10.965, 11.429, 11.441, 11.472, 11.437,
         11.07, 10.696, 10.32, 9.9442, 9.5693, 9.1959, 8.8239, 8.4529, 8.0824, 7.7122, 7.3424, 6.9736, 6.6052, 6.2364,
         5.8703, 5.5099, 5.1581, 4.8174, 4.4899, 4.177, 3.8799, 3.5993, 3.3356, 3.0889, 2.859, 2.6453, 2.5564, 2.5415,
         2.5268, 2.5121, 2.4976, 2.4831, 2.4687, 2.4544, 2.4401, 2.426, 2.4119, 2.3979, 2.384, 2.3702, 2.3565, 2.3428,
         2.3292, 2.3157, 2.3023, 2.289, 2.2757, 2.2625, 2.2458, 2.2287, 2.2118, 2.195, 2.1946, 12.572, 12.469, 12.362,
         12.256, 12.151, 12.098, 17.202, 17.134, 16.987, 16.842, 16.697, 16.554, 16.412, 16.272, 16.132, 15.994, 15.857,
         15.722, 15.587, 15.454, 15.321, 15.19, 15.06, 14.932, 14.804, 14.677, 14.552, 14.427, 14.304, 14.182, 14.061,
         13.941, 13.822, 13.703, 13.655, 15.44, 15.416, 15.294, 15.174, 15.055, 14.937, 14.82, 14.704, 14.589, 14.474,
         14.361, 14.249, 14.139, 14.029, 13.921, 13.813, 13.706, 13.601, 13.496, 13.392, 13.289, 13.187, 13.086, 12.989,
         12.892, 12.796, 12.701, 12.607, 12.515, 12.423, 12.333, 12.243, 12.154, 12.065, 11.978, 11.891, 11.805, 11.719,
         11.634, 11.55, 11.467, 11.385, 11.303, 11.222, 11.141, 11.061, 10.982, 10.903, 10.825, 10.748, 10.671, 10.595,
         10.52, 10.445, 10.369, 10.294, 10.219, 10.144, 10.07, 9.9972, 9.9245, 9.8523, 9.7807, 9.7092, 9.6375, 9.5663,
         9.4957, 9.4256, 9.3561, 9.287, 9.2185, 9.1505, 9.083, 9.016, 8.9495, 8.8835, 8.818, 8.753, 8.6884, 8.6244,
         8.5608, 8.4977, 8.435, 8.3728, 8.3111, 8.2499, 8.1891, 8.1287, 8.0688, 8.0093, 7.9503, 7.8917, 7.8335, 7.7758,
         7.7185, 7.6616, 7.6052, 7.5491, 7.4935, 7.4383, 7.3835, 7.3291, 7.2751, 7.2216, 7.1684, 7.1156, 7.0632, 7.0112,
         6.9596, 6.906, 6.8528, 6.8, 6.7476, 6.695, 6.6423, 6.59, 6.538, 6.4865, 6.4354, 6.3847, 6.3345, 6.2846, 6.2351,
         6.186, 6.1373, 6.089, 6.0411, 5.9935, 5.9464, 5.8996, 5.8532, 5.8072, 5.7616, 5.7163, 5.6714, 5.6269, 5.5827,
         5.5389, 5.4955, 5.4524, 5.4093, 5.3661, 5.3232, 5.2806, 5.2385, 5.1966, 5.1551, 5.114, 5.0732, 5.0327, 4.9925,
         4.9527, 4.9133, 4.8741, 4.8351, 4.7965, 4.7582, 4.7202, 4.6825, 4.6451, 4.608, 4.5713, 4.5348, 4.4987, 4.4629,
         4.4273, 4.3921, 4.3571, 4.3225, 4.2881, 4.2541, 4.2203, 4.1868, 4.1536, 4.1206, 4.088, 4.0556, 4.0235, 3.9916,
         3.9601, 3.9288, 3.8977, 3.8669, 3.8364, 3.8062, 3.7762, 3.7445, 3.7119, 3.6796, 3.6475, 3.6158, 3.5844, 3.5532,
         3.5224, 3.4918, 3.4615, 3.4315, 3.4018, 3.3723, 3.3432, 3.3142, 3.2856, 3.2572, 3.2291, 3.2012, 3.1736, 3.1462,
         3.1191, 3.0923, 3.0657, 3.0393, 3.0132, 2.9873, 2.9617, 2.9362, 2.9111, 2.8861, 2.8614, 2.8369, 2.8126, 2.7886,
         2.7647, 2.7411, 2.7177, 2.6946, 2.6716, 2.6488, 2.6263, 2.6039, 2.5817, 2.5598, 2.538, 2.5164, 2.4951, 2.4739,
         2.4529, 2.4321, 2.4115, 2.3911, 2.3709, 2.3508, 2.331, 2.3113, 2.2918, 2.2724, 2.2533, 2.2343, 2.2155, 2.1969,
         2.1784, 2.1601, 2.1419, 2.124, 2.1062, 2.0885, 2.071, 2.0537, 2.0365, 2.0195, 2.0026, 1.9859, 1.9693, 1.9529,
         1.9366, 1.9198, 1.9032, 1.8867, 1.8703, 1.854, 1.8376, 1.8214, 1.8054, 1.7895, 1.7737, 1.7581, 1.7427, 1.7274,
         1.7123, 1.6973, 1.6824, 1.6677, 1.6531, 1.6387, 1.6244, 1.6102, 1.5962, 1.5823, 1.5686, 1.555, 1.5415, 1.5281,
         1.5149, 1.5018, 1.4888, 1.4759, 1.463, 1.4498, 1.4367, 1.4238, 1.4109, 1.3982, 1.3857, 1.3732, 1.3609, 1.3487,
         1.3366, 1.3246, 1.3127, 1.301, 1.2893, 1.2778, 1.2664, 1.255, 1.2438, 1.2327, 1.2217, 1.2109, 1.2001, 1.1894,
         1.1788, 1.1683, 1.1579, 1.1477, 1.1375, 1.1274, 1.1174, 1.1075, 1.0977, 1.088, 1.0784, 1.0688, 1.0594, 1.05,
         1.0408, 1.0316, 1.0225, 1.0135, 1.0046, 0.99576, 0.987, 0.97833, 0.96975, 0.96124, 0.95281, 0.87397, 0.7778,
         0.69289, 0.61784, 0.54929, 0.50093, 0.48628, 0.48201, 3.8531, 3.7401, 3.4219, 3.061, 2.7556, 2.4851, 2.2238,
         1.9866, 1.7721, 1.579, 1.4062, 1.2523, 1.1123, 0.98624, 0.8744, 0.77527, 0.6872, 0.6061, 0.53381, 0.47016,
         0.41413, 0.36481, 0.32137, 0.28309, 0.24795, 0.21718, 0.19024, 0.16665, 0.14599, 0.12789, 0.11203, 0.098139,
         0.085974, 0.075223, 0.065631, 0.057264, 0.049966, 0.043599, 0.038045, 0.033199, 0.028972, 0.025283, 0.022065,
         0.019257, 0.016807, 0.014669, 0.012803, 0.011175, 0.0097545, 0.0085146, 0.0074325, 0.0064882, 0.0056639,
         0.0049445, 0.0043166, 0.0037685, 0.0032901, 0.0028725, 0.002508]],
    'Ga':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.017313,
         0.0173826, 0.017487, 0.017748, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368,
         0.09041995, 0.09665893, 0.100842, 0.1023855, 0.1027971, 0.1033284, 0.1034145, 0.104664, 0.104958, 0.106266,
         0.1066932, 0.107334, 0.108936, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.154938,
         0.1573095, 0.1579419, 0.1588905, 0.161262, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188,
         0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657,
         0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896,
         0.9, 0.9045, 0.9090225, 0.91356761, 0.91813545, 0.92272613, 0.92733976, 0.93197646, 0.93663634, 0.94131952,
         0.94602612, 0.95075625, 0.95551003, 0.96028758, 0.96508902, 0.96991446, 0.97476404, 0.97963786, 0.98453605,
         0.98945873, 0.99440602, 0.99937805, 1.0043749, 1.0093968, 1.0144438, 1.019516, 1.0246136, 1.0297367, 1.0348853,
         1.0400598, 1.0452601, 1.0504864, 1.0557388, 1.0610175, 1.0663226, 1.0716542, 1.0770125, 1.0823975, 1.0878095,
         1.0932486, 1.0987148, 1.1042084, 1.1097294, 1.1152781, 1.115315, 1.115485, 1.1208545, 1.1264587, 1.132091,
         1.1377515, 1.142213, 1.1423871, 1.1434402, 1.1491574, 1.1549032, 1.1606777, 1.1664811, 1.1723135, 1.1781751,
         1.184066, 1.1899863, 1.1959362, 1.2019159, 1.2079255, 1.2139651, 1.220035, 1.2261351, 1.2322658, 1.2384271,
         1.2446193, 1.2508424, 1.2570966, 1.2633821, 1.269699, 1.2760475, 1.2824277, 1.2888399, 1.295284, 1.2964841,
         1.298916, 1.3017605, 1.3082693, 1.3148106, 1.3213847, 1.3279916, 1.3346316, 1.3413047, 1.3480112, 1.3547513,
         1.361525, 1.3683327, 1.3751743, 1.3820502, 1.3889605, 1.3959053, 1.4028848, 1.4098992, 1.4169487, 1.4240335,
         1.4311536, 1.4383094, 1.4455009, 1.4527284, 1.4599921, 1.467292, 1.4746285, 1.4820016, 1.4894117, 1.4968587,
         1.504343, 1.5118647, 1.519424, 1.5270212, 1.5346563, 1.5423295, 1.5500412, 1.5577914, 1.5655804, 1.5734083,
         1.5812753, 1.5891817, 1.5971276, 1.6051132, 1.6131388, 1.6212045, 1.6293105, 1.6374571, 1.6456443, 1.6538726,
         1.6621419, 1.6704526, 1.6788049, 1.6871989, 1.6956349, 1.7041131, 1.7126337, 1.7211968, 1.7298028, 1.7384518,
         1.7471441, 1.7558798, 1.7646592, 1.7734825, 1.7823499, 1.7912617, 1.800218, 1.8092191, 1.8182652, 1.8273565,
         1.8364933, 1.8456757, 1.8549041, 1.8641786, 1.8734995, 1.882867, 1.8922814, 1.9017428, 1.9112515, 1.9208077,
         1.9304118, 1.9400638, 1.9497642, 1.959513, 1.9693105, 1.9791571, 1.9890529, 1.9989981, 2.0089931, 2.0190381,
         2.0291333, 2.039279, 2.0494754, 2.0597227, 2.0700213, 2.0803714, 2.0907733, 2.1012272, 2.1117333, 2.122292,
         2.1329034, 2.143568, 2.1542858, 2.1650572, 2.1758825, 2.1867619, 2.1976957, 2.2086842, 2.2197276, 2.2308263,
         2.2419804, 2.2531903, 2.2644562, 2.2757785, 2.2871574, 2.2985932, 2.3100862, 2.3216366, 2.3332448, 2.344911,
         2.3566356, 2.3684187, 2.3802608, 2.3921621, 2.404123, 2.4161436, 2.4282243, 2.4403654, 2.4525672, 2.4648301,
         2.4771542, 2.48954, 2.5019877, 2.5144976, 2.5270701, 2.5397055, 2.552404, 2.565166, 2.5779919, 2.5908818,
         2.6038362, 2.6168554, 2.6299397, 2.6430894, 2.6563048, 2.6695863, 2.6829343, 2.6963489, 2.7098307, 2.7233798,
         2.7369967, 2.7506817, 2.7644351, 2.7782573, 2.7921486, 2.8061093, 2.8201399, 2.8342406, 2.8484118, 2.8626539,
         2.8769671, 2.891352, 2.9058087, 2.9203378, 2.9349394, 2.9496141, 2.9643622, 2.979184, 2.9940799, 3.0090503,
         3.0240956, 3.0392161, 3.0544122, 3.0696842, 3.0850326, 3.1004578, 3.1159601, 3.1315399, 3.1471976, 3.1629336,
         3.1787482, 3.194642, 3.2106152, 3.2266683, 3.2428016, 3.2590156, 3.2753107, 3.2916873, 3.3081457, 3.3246864,
         3.3413099, 3.3580164, 3.3748065, 3.3916805, 3.4086389, 3.4256821, 3.4428105, 3.4600246, 3.4773247, 3.4947113,
         3.5121849, 3.5297458, 3.5473945, 3.5651315, 3.5829572, 3.6008719, 3.6188763, 3.6369707, 3.6551555, 3.6734313,
         3.6917985, 3.7102575, 3.7288088, 3.7474528, 3.7661901, 3.785021, 3.8039461, 3.8229659, 3.8420807, 3.8612911,
         3.8805975, 3.9000005, 3.9195005, 3.939098, 3.9587935, 3.9785875, 3.9984804, 4.0184728, 4.0385652, 4.058758,
         4.0790518, 4.0994471, 4.1199443, 4.140544, 4.1612467, 4.182053, 4.2029632, 4.2239781, 4.245098, 4.2663234,
         4.2876551, 4.3090933, 4.3306388, 4.352292, 4.3740535, 4.3959237, 4.4179033, 4.4399929, 4.4621928, 4.4845038,
         4.5069263, 4.5294609, 4.5521082, 4.5748688, 4.5977431, 4.6207318, 4.6438355, 4.6670547, 4.69039, 4.7138419,
         4.7374111, 4.7610982, 4.7849037, 4.8088282, 4.8328723, 4.8570367, 4.8813219, 4.9057285, 4.9302571, 4.9549084,
         4.9796829, 5.0045814, 5.0296043, 5.0547523, 5.080026, 5.1054262, 5.1309533, 5.1566081, 5.1823911, 5.2083031,
         5.2343446, 5.2605163, 5.2868189, 5.313253, 5.3398192, 5.3665183, 5.3933509, 5.4203177, 5.4474193, 5.4746564,
         5.5020297, 5.5295398, 5.5571875, 5.5849734, 5.6128983, 5.6409628, 5.6691676, 5.6975135, 5.726001, 5.754631,
         5.7834042, 5.8123212, 5.8413828, 5.8705897, 5.8999427, 5.9294424, 5.9590896, 5.988885, 6.0188295, 6.0489236,
         6.0791682, 6.1095641, 6.1401119, 6.1708125, 6.2016665, 6.2326749, 6.2638382, 6.2951574, 6.3266332, 6.3582664,
         6.3900577, 6.422008, 6.454118, 6.4863886, 6.5188206, 6.5514147, 6.5841717, 6.915365, 7.392525, 7.902609,
         8.44789, 9.030794, 9.653919, 10.15976, 10.32004, 10.35673, 10.41894, 10.57444, 11.03212, 11.79334, 12.60708,
         13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645,
         28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721,
         58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931,
         121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835,
         253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [3.15198, 3.09183, 3.01884, 2.9286, 2.81368, 2.6595, 2.4281, 1.90191, 1.4508, 0.945019, 1.43339, 1.83886,
         2.06446, 2.22367, 2.21897, 2.15214, 2.0508, 1.92725, 1.78929, 1.64356, 1.49683, 1.35666, 1.23162, 1.13137,
         1.06643, 1.0479, 1.08696, 1.19432, 1.38877, 1.66014, 2.02335, 2.48203, 3.03821, 3.69108, 4.42213, 5.2061,
         6.01082, 6.77799, 7.14467, 7.11392, 6.91461, 7.18608, 7.22281, 7.53327, 7.58273, 7.72946, 7.68165, 7.90187,
         8.24646, 8.50418, 9.56869, 10.5176, 11.3901, 12.1765, 12.7848, 12.8065, 12.7561, 12.5398, 12.8669, 13.258,
         13.6262, 14.5147, 15.2959, 16.0188, 16.6967, 17.336, 17.9414, 18.5163, 19.0643, 19.5895, 20.0952, 20.5727,
         20.9634, 21.2796, 21.5316, 21.7256, 21.8639, 21.9465, 21.9737, 21.9438, 21.853, 21.6937, 21.4528, 21.1076,
         20.6181, 19.9078, 20.4665, 20.4043, 20.3401, 20.2736, 20.205, 20.1339, 20.0604, 19.9842, 19.9053, 19.8233,
         19.7383, 19.6499, 19.558, 19.4622, 19.3625, 19.2584, 19.1497, 19.036, 18.9169, 18.792, 18.6608, 18.5227,
         18.3744, 18.2171, 18.0503, 17.873, 17.6841, 17.4821, 17.2655, 17.0322, 16.78, 16.5058, 16.2061, 15.876,
         15.5096, 15.0984, 14.6313, 14.0917, 13.4544, 12.678, 11.6858, 10.3097, 8.02547, -4.2778, -5.41991, -5.58976,
         7.38309, 9.26436, 9.98691, 9.7512, 4.23877, 4.18116, 8.34121, 11.824, 13.3476, 14.4324, 15.2974, 16.0239,
         16.6524, 17.2067, 17.7023, 18.1496, 18.5562, 18.9278, 19.2684, 19.5812, 19.8687, 20.1326, 20.3739, 20.5931,
         20.79, 20.9633, 21.1106, 21.2267, 21.3018, 21.3144, 21.2054, 20.6512, 20.2896, 20.3323, 21.1138, 21.8519,
         22.3083, 22.6677, 22.9755, 23.2501, 23.5011, 23.7338, 23.9522, 24.1587, 24.3549, 24.5413, 24.7192, 24.8895,
         25.0529, 25.2099, 25.3612, 25.5071, 25.6479, 25.7841, 25.9158, 26.0433, 26.1669, 26.2868, 26.4031, 26.5161,
         26.626, 26.7327, 26.8366, 26.9376, 27.0359, 27.1317, 27.2249, 27.3158, 27.4043, 27.4906, 27.5748, 27.6569,
         27.737, 27.8151, 27.8914, 27.9659, 28.0387, 28.1097, 28.1791, 28.247, 28.3133, 28.3781, 28.4415, 28.5036,
         28.5643, 28.6238, 28.6822, 28.7392, 28.7948, 28.8491, 28.9022, 28.954, 29.0047, 29.0542, 29.1026, 29.1499,
         29.1962, 29.2415, 29.2858, 29.3291, 29.3715, 29.413, 29.4536, 29.4933, 29.5322, 29.5702, 29.6075, 29.6439,
         29.6796, 29.7146, 29.7488, 29.7823, 29.8151, 29.8473, 29.8787, 29.9096, 29.9397, 29.9692, 29.9981, 30.0264,
         30.0541, 30.0812, 30.1077, 30.1337, 30.1591, 30.1839, 30.2083, 30.2321, 30.2554, 30.2782, 30.3006, 30.3225,
         30.3439, 30.3649, 30.3855, 30.4057, 30.4255, 30.4448, 30.4639, 30.4825, 30.5008, 30.5188, 30.6455, 30.6628,
         30.6796, 30.6959, 30.7117, 30.7822, 30.7971, 30.8114, 30.8253, 30.8387, 30.8516, 30.8641, 30.8762, 30.8879,
         30.8991, 30.91, 30.9206, 30.9307, 30.9406, 30.9501, 30.9593, 30.9682, 30.9768, 30.985, 30.9931, 31.0008,
         31.0083, 31.0155, 31.0225, 31.0293, 31.0358, 31.0839, 31.0901, 31.0961, 31.1018, 31.1072, 31.1124, 31.1173,
         31.122, 31.1265, 31.1308, 31.135, 31.1389, 31.1426, 31.1462, 31.1496, 31.1529, 31.1561, 31.1591, 31.1621,
         31.1649, 31.1677, 31.1705, 31.1732, 31.1759, 31.1787, 31.1817, 31.1848, 31.1882, 31.1921, 31.1967, 31.2005,
         31.2033, 31.2054, 31.2068, 31.2078, 31.2083, 31.2084, 31.2082, 31.2077, 31.2068, 31.2057, 31.2044, 31.2028,
         31.201, 31.199, 31.1968, 31.1944, 31.1919, 31.1891, 31.1862, 31.1832, 31.18, 31.1767, 31.1733, 31.1697, 31.166,
         31.1622, 31.1582, 31.1542, 31.15, 31.1458, 31.1414, 31.137, 31.1325, 31.1279, 31.1232, 31.1184, 31.1135,
         31.1086, 31.1036, 31.0985, 31.0933, 31.0881, 31.0828, 31.0775, 31.0721, 31.0666, 31.0611, 31.0556, 31.0499,
         31.0443, 31.0386, 31.0328, 31.027, 31.0211, 31.0153, 31.0093, 31.0034, 30.9974, 30.9913, 30.9853, 30.9791,
         30.973, 30.9668, 30.9606, 30.9544, 30.9482, 30.9419, 30.9356, 30.9293, 30.9229, 30.9166, 30.9102, 30.9038,
         30.8974, 30.8909, 30.8845, 30.878, 30.8715, 30.865, 30.8585, 30.852, 30.8455, 30.839, 30.8324, 30.8259,
         30.8193, 30.8128, 30.8062, 30.7997, 30.7931, 30.7866, 30.78, 30.7735, 30.7669, 30.7604, 30.7538, 30.7472,
         30.7405, 30.7338, 30.7271, 30.7203, 30.7134, 30.7065, 30.6995, 30.6925, 30.6855, 30.6784, 30.6713, 30.6641,
         30.6569, 30.6496, 30.6423, 30.635, 30.6277, 30.6203, 30.613, 30.6055, 30.5981, 30.5906, 30.5832, 30.5756,
         30.5681, 30.5606, 30.553, 30.5454, 30.5378, 30.5301, 30.5224, 30.5146, 30.5067, 30.4988, 30.4908, 30.4828,
         30.4747, 30.4665, 30.4583, 30.4501, 30.4418, 30.4334, 30.425, 30.4165, 30.408, 30.3995, 30.3908, 30.3822,
         30.3734, 30.3647, 30.3558, 30.3469, 30.338, 30.3289, 30.3199, 30.3107, 30.3015, 30.2923, 30.2829, 30.2036,
         30.0569, 29.8851, 29.6694, 29.3678, 28.8162, 27.648, 26.1338, 24.5278, 26.2749, 27.8546, 29.1935, 30.0256,
         30.4757, 30.7777, 30.9902, 31.135, 31.2343, 31.3007, 31.3433, 31.3689, 31.4186, 31.4203, 31.4148, 31.4053,
         31.3918, 31.3739, 31.3537, 31.3325, 31.3111, 31.2898, 31.2693, 31.2498, 31.231, 31.2126, 31.195, 31.1784,
         31.1628, 31.1484, 31.135, 31.1228, 31.1117, 31.1012, 31.0915, 31.0826, 31.0745, 31.0671, 31.0604, 31.0543,
         31.0488, 31.0438, 31.0392, 31.0352, 31.0315, 31.0282, 31.0252, 31.0225, 31.0201, 31.018, 31.0161, 31.0143,
         31.0128, 31.0114, 31.0101, 31.009, 31.008, 31.0072],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.97516, 0.97958, 0.98763, 1.0092, 1.0578, 1.1418, 1.2615,
         1.4188, 1.6168, 1.8592, 2.15, 2.4925, 2.8896, 3.3429, 3.8522, 4.4153, 5.0277, 5.6822, 6.3693, 7.0772, 7.7923,
         8.4996, 9.1832, 9.8181, 10.377, 10.846, 11.218, 11.487, 11.604, 11.635, 11.643, 12.131, 12.133, 12.159, 12.165,
         12.188, 12.195, 12.437, 12.461, 12.48, 12.517, 12.48, 12.38, 12.225, 12.025, 12.009, 11.957, 11.943, 12.434,
         12.388, 12.317, 12.084, 11.827, 11.548, 11.251, 10.939, 10.614, 10.279, 9.9349, 9.5828, 9.2241, 8.7314, 8.2053,
         7.6944, 7.2003, 6.7227, 6.2622, 5.8209, 5.4005, 5.0023, 4.627, 4.2747, 3.9455, 3.6389, 3.3545, 3.0916, 2.9826,
         2.9644, 2.9464, 2.9284, 2.9106, 2.8929, 2.8753, 2.8578, 2.8404, 2.8232, 2.806, 2.789, 2.772, 2.7552, 2.7384,
         2.7218, 2.7053, 2.6889, 2.6725, 2.6563, 2.6402, 2.6242, 2.6042, 2.5837, 2.5634, 2.5434, 2.5234, 2.5037, 2.4842,
         2.4648, 2.4456, 2.4266, 2.4077, 2.389, 2.3705, 2.3521, 2.3339, 2.3159, 2.2981, 2.2803, 2.2628, 2.2454, 2.2282,
         2.2111, 2.211, 12.157, 12.061, 11.962, 11.864, 11.766, 11.69, 16.591, 16.566, 16.43, 16.296, 16.163, 16.031,
         15.9, 15.77, 15.641, 15.513, 15.386, 15.261, 15.136, 15.012, 14.89, 14.768, 14.648, 14.528, 14.409, 14.292,
         14.175, 14.06, 13.945, 13.831, 13.718, 13.607, 13.496, 13.475, 15.253, 15.205, 15.095, 14.986, 14.878, 14.771,
         14.665, 14.559, 14.455, 14.351, 14.248, 14.144, 14.041, 13.938, 13.836, 13.735, 13.635, 13.535, 13.436, 13.337,
         13.24, 13.143, 13.046, 12.951, 12.856, 12.762, 12.669, 12.576, 12.484, 12.393, 12.302, 12.212, 12.123, 12.034,
         11.946, 11.858, 11.772, 11.685, 11.6, 11.515, 11.431, 11.347, 11.264, 11.182, 11.1, 11.019, 10.938, 10.858,
         10.779, 10.7, 10.622, 10.545, 10.468, 10.391, 10.315, 10.238, 10.163, 10.088, 10.013, 9.9394, 9.8661, 9.7933,
         9.721, 9.6493, 9.5782, 9.5075, 9.4374, 9.3679, 9.2988, 9.2303, 9.1622, 9.0947, 9.0277, 8.9612, 8.8952, 8.8297,
         8.7646, 8.7001, 8.636, 8.5724, 8.5093, 8.4462, 8.3834, 8.321, 8.2591, 8.1977, 8.1368, 8.0763, 8.0162, 7.9563,
         7.8969, 7.8379, 7.7793, 7.7212, 7.6636, 7.6064, 7.5496, 7.4932, 7.4373, 7.3818, 7.3268, 7.2721, 7.2179, 7.1641,
         7.1107, 7.0577, 7.0051, 6.9529, 6.9011, 6.8497, 6.7967, 6.7441, 6.692, 6.6403, 6.5887, 6.5368, 6.4853, 6.4343,
         6.3836, 6.3333, 6.2835, 6.234, 6.1849, 6.1363, 6.088, 6.0401, 5.9926, 5.9455, 5.8987, 5.8523, 5.8064, 5.7607,
         5.7155, 5.6706, 5.6261, 5.582, 5.5382, 5.4947, 5.4517, 5.409, 5.3661, 5.3233, 5.2809, 5.2388, 5.197, 5.1556,
         5.1146, 5.0739, 5.0335, 4.9935, 4.9538, 4.9145, 4.8754, 4.8367, 4.7983, 4.7603, 4.7225, 4.6851, 4.648, 4.6112,
         4.5747, 4.5385, 4.5026, 4.4671, 4.4318, 4.3968, 4.3621, 4.3277, 4.2934, 4.2573, 4.22, 4.1831, 4.1466, 4.1104,
         4.0745, 4.0389, 4.0037, 3.9688, 3.9343, 3.9, 3.8661, 3.8325, 3.7992, 3.7662, 3.7335, 3.7011, 3.669, 3.6372,
         3.6057, 3.5745, 3.5436, 3.5129, 3.4826, 3.4525, 3.4227, 3.3932, 3.3639, 3.3349, 3.3062, 3.2778, 3.2496, 3.2216,
         3.194, 3.1665, 3.1394, 3.1124, 3.0858, 3.0593, 3.0331, 3.0072, 2.9815, 2.956, 2.9307, 2.9057, 2.8809, 2.8564,
         2.832, 2.8079, 2.784, 2.7603, 2.7369, 2.7136, 2.6906, 2.6678, 2.6451, 2.6227, 2.6005, 2.5785, 2.5567, 2.5351,
         2.5136, 2.4924, 2.4714, 2.4505, 2.4299, 2.4094, 2.3891, 2.369, 2.3491, 2.3294, 2.3098, 2.2904, 2.2712, 2.2522,
         2.2333, 2.2146, 2.1961, 2.1777, 2.1596, 2.1415, 2.1236, 2.1059, 2.0884, 2.071, 2.0538, 2.0367, 2.0197, 2.003,
         1.9863, 1.9699, 1.9535, 1.9373, 1.9213, 1.9054, 1.8896, 1.8734, 1.8572, 1.8413, 1.8255, 1.8097, 1.7939, 1.7782,
         1.7626, 1.7472, 1.732, 1.7168, 1.7019, 1.6871, 1.6724, 1.6579, 1.6435, 1.6292, 1.6151, 1.6011, 1.5872, 1.5735,
         1.5599, 1.5464, 1.5331, 1.5199, 1.5068, 1.4938, 1.481, 1.4683, 1.4557, 1.4429, 1.4299, 1.4171, 1.4044, 1.3919,
         1.3794, 1.3671, 1.3549, 1.3428, 1.3308, 1.3189, 1.3072, 1.2956, 1.284, 1.2726, 1.2613, 1.2501, 1.239, 1.228,
         1.2171, 1.2063, 1.1956, 1.1851, 1.1746, 1.1642, 1.1539, 1.1437, 1.1336, 1.1236, 1.1137, 1.1039, 1.0942, 1.0033,
         0.89248, 0.79466, 0.70823, 0.62937, 0.55215, 0.49982, 0.48485, 0.48152, 3.8431, 3.7266, 3.4259, 3.0603, 2.755,
         2.4874, 2.2265, 1.9894, 1.7746, 1.5811, 1.408, 1.2538, 1.1143, 0.98861, 0.87706, 0.77807, 0.68692, 0.60523,
         0.5333, 0.46995, 0.41415, 0.365, 0.3217, 0.28355, 0.24851, 0.21775, 0.19081, 0.16721, 0.14653, 0.12842,
         0.11255, 0.098642, 0.086354, 0.075397, 0.065833, 0.057485, 0.050197, 0.043834, 0.03828, 0.03343, 0.029196,
         0.025499, 0.022271, 0.019452, 0.01699, 0.014841, 0.012964, 0.011324, 0.0098927, 0.0086422, 0.0075501,
         0.0065961, 0.0057629, 0.005035, 0.0043993, 0.0038439, 0.0033587, 0.0029349]],
    'Ge':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.028126, 0.0285565, 0.0286713,
         0.0288435, 0.02908327, 0.029274, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198,
         0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411,
         0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.118384, 0.120196, 0.1206792, 0.121404,
         0.123216, 0.125342, 0.1262272, 0.1272605, 0.1277721, 0.1285395, 0.130458, 0.1349368, 0.1442475, 0.1542005,
         0.1648404, 0.1762144, 0.1764, 0.1791, 0.17982, 0.1809, 0.1836, 0.1883732, 0.2013709, 0.2152655, 0.2301188,
         0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657,
         0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896,
         0.9, 0.9045, 0.9090225, 0.91356761, 0.91813545, 0.92272613, 0.92733976, 0.93197646, 0.93663634, 0.94131952,
         0.94602612, 0.95075625, 0.95551003, 0.96028758, 0.96508902, 0.96991446, 0.97476404, 0.97963786, 0.98453605,
         0.98945873, 0.99440602, 0.99937805, 1.0043749, 1.0093968, 1.0144438, 1.019516, 1.0246136, 1.0297367, 1.0348853,
         1.0400598, 1.0452601, 1.0504864, 1.0557388, 1.0610175, 1.0663226, 1.0716542, 1.0770125, 1.0823975, 1.0878095,
         1.0932486, 1.0987148, 1.1042084, 1.1097294, 1.1152781, 1.1208545, 1.1264587, 1.132091, 1.1377515, 1.1434402,
         1.1491574, 1.1549032, 1.1606777, 1.1664811, 1.1723135, 1.1781751, 1.184066, 1.1899863, 1.1959362, 1.2019159,
         1.2079255, 1.2139651, 1.2165985, 1.2168014, 1.220035, 1.2261351, 1.2322658, 1.2384271, 1.2446193, 1.2476951,
         1.2479049, 1.2508424, 1.2570966, 1.2633821, 1.269699, 1.2760475, 1.2824277, 1.2888399, 1.295284, 1.3017605,
         1.3082693, 1.3148106, 1.3213847, 1.3279916, 1.3346316, 1.3413047, 1.3480112, 1.3547513, 1.361525, 1.3683327,
         1.3751743, 1.3820502, 1.3889605, 1.3959053, 1.4028848, 1.4098992, 1.4130073, 1.4155926, 1.4169487, 1.4240335,
         1.4311536, 1.4383094, 1.4455009, 1.4527284, 1.4599921, 1.467292, 1.4746285, 1.4820016, 1.4894117, 1.4968587,
         1.504343, 1.5118647, 1.519424, 1.5270212, 1.5346563, 1.5423295, 1.5500412, 1.5577914, 1.5655804, 1.5734083,
         1.5812753, 1.5891817, 1.5971276, 1.6051132, 1.6131388, 1.6212045, 1.6293105, 1.6374571, 1.6456443, 1.6538726,
         1.6621419, 1.6704526, 1.6788049, 1.6871989, 1.6956349, 1.7041131, 1.7126337, 1.7211968, 1.7298028, 1.7384518,
         1.7471441, 1.7558798, 1.7646592, 1.7734825, 1.7823499, 1.7912617, 1.800218, 1.8092191, 1.8182652, 1.8273565,
         1.8364933, 1.8456757, 1.8549041, 1.8641786, 1.8734995, 1.882867, 1.8922814, 1.9017428, 1.9112515, 1.9208077,
         1.9304118, 1.9400638, 1.9497642, 1.959513, 1.9693105, 1.9791571, 1.9890529, 1.9989981, 2.0089931, 2.0190381,
         2.0291333, 2.039279, 2.0494754, 2.0597227, 2.0700213, 2.0803714, 2.0907733, 2.1012272, 2.1117333, 2.122292,
         2.1329034, 2.143568, 2.1542858, 2.1650572, 2.1758825, 2.1867619, 2.1976957, 2.2086842, 2.2197276, 2.2308263,
         2.2419804, 2.2531903, 2.2644562, 2.2757785, 2.2871574, 2.2985932, 2.3100862, 2.3216366, 2.3332448, 2.344911,
         2.3566356, 2.3684187, 2.3802608, 2.3921621, 2.404123, 2.4161436, 2.4282243, 2.4403654, 2.4525672, 2.4648301,
         2.4771542, 2.48954, 2.5019877, 2.5144976, 2.5270701, 2.5397055, 2.552404, 2.565166, 2.5779919, 2.5908818,
         2.6038362, 2.6168554, 2.6299397, 2.6430894, 2.6563048, 2.6695863, 2.6829343, 2.6963489, 2.7098307, 2.7233798,
         2.7369967, 2.7506817, 2.7644351, 2.7782573, 2.7921486, 2.8061093, 2.8201399, 2.8342406, 2.8484118, 2.8626539,
         2.8769671, 2.891352, 2.9058087, 2.9203378, 2.9349394, 2.9496141, 2.9643622, 2.979184, 2.9940799, 3.0090503,
         3.0240956, 3.0392161, 3.0544122, 3.0696842, 3.0850326, 3.1004578, 3.1159601, 3.1315399, 3.1471976, 3.1629336,
         3.1787482, 3.194642, 3.2106152, 3.2266683, 3.2428016, 3.2590156, 3.2753107, 3.2916873, 3.3081457, 3.3246864,
         3.3413099, 3.3580164, 3.3748065, 3.3916805, 3.4086389, 3.4256821, 3.4428105, 3.4600246, 3.4773247, 3.4947113,
         3.5121849, 3.5297458, 3.5473945, 3.5651315, 3.5829572, 3.6008719, 3.6188763, 3.6369707, 3.6551555, 3.6734313,
         3.6917985, 3.7102575, 3.7288088, 3.7474528, 3.7661901, 3.785021, 3.8039461, 3.8229659, 3.8420807, 3.8612911,
         3.8805975, 3.9000005, 3.9195005, 3.939098, 3.9587935, 3.9785875, 3.9984804, 4.0184728, 4.0385652, 4.058758,
         4.0790518, 4.0994471, 4.1199443, 4.140544, 4.1612467, 4.182053, 4.2029632, 4.2239781, 4.245098, 4.2663234,
         4.2876551, 4.3090933, 4.3306388, 4.352292, 4.3740535, 4.3959237, 4.4179033, 4.4399929, 4.4621928, 4.4845038,
         4.5069263, 4.5294609, 4.5521082, 4.5748688, 4.5977431, 4.6207318, 4.6438355, 4.6670547, 4.69039, 4.7138419,
         4.7374111, 4.7610982, 4.7849037, 4.8088282, 4.8328723, 4.8570367, 4.8813219, 4.9057285, 4.9302571, 4.9549084,
         4.9796829, 5.0045814, 5.0296043, 5.0547523, 5.080026, 5.1054262, 5.1309533, 5.1566081, 5.1823911, 5.2083031,
         5.2343446, 5.2605163, 5.2868189, 5.313253, 5.3398192, 5.3665183, 5.3933509, 5.4203177, 5.4474193, 5.4746564,
         5.5020297, 5.5295398, 5.5571875, 5.5849734, 5.6128983, 5.6409628, 5.6691676, 5.6975135, 5.726001, 5.754631,
         5.7834042, 5.8123212, 5.8413828, 5.8705897, 5.8999427, 5.9294424, 5.9590896, 5.988885, 6.0188295, 6.0489236,
         6.0791682, 6.1095641, 6.1401119, 6.1708125, 6.2016665, 6.2326749, 6.2638382, 6.2951574, 6.3266332, 6.3582664,
         6.3900577, 6.422008, 6.454118, 6.4863886, 6.5188206, 6.5514147, 6.5841717, 6.915365, 7.392525, 7.902609,
         8.44789, 9.030794, 9.653919, 10.32004, 10.88104, 11.03212, 11.04758, 11.092, 11.15862, 11.32516, 11.79334,
         12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923,
         26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542,
         54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353,
         113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548,
         237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [4.82331, 4.79856, 4.7699, 4.73664, 4.69793, 4.65272, 4.59971, 4.53719, 4.46296, 4.37397, 4.26589, 4.132,
         3.96079, 3.72818, 3.35842, 2.99548, 2.56016, 2.10442, 2.50915, 2.7398, 2.82322, 2.99292, 2.92695, 2.7896,
         2.61993, 2.43542, 2.24947, 2.07531, 1.92706, 1.81991, 1.76967, 1.79203, 1.90158, 2.11068, 2.42839, 2.85949,
         3.40364, 4.06865, 4.81459, 5.63462, 6.4934, 7.27992, 7.30144, 7.33901, 7.19222, 7.46831, 7.83726, 8.13535,
         8.23834, 8.32672, 8.30406, 8.4956, 8.82407, 9.44533, 10.5868, 11.6674, 12.6665, 13.4585, 13.4654, 13.4468,
         13.2225, 13.5903, 14.0475, 14.5635, 15.6526, 16.612, 17.4848, 18.2815, 19.0067, 19.664, 20.2567, 20.788,
         21.2611, 21.6795, 22.0431, 22.3602, 22.631, 22.8586, 23.0456, 23.1952, 23.2789, 23.291, 23.2338, 23.1045,
         22.8946, 22.5869, 22.1496, 22.6092, 22.5715, 22.5327, 22.4929, 22.452, 22.41, 22.3668, 22.3224, 22.2768,
         22.2298, 22.1816, 22.1319, 22.0807, 22.0281, 21.9739, 21.918, 21.8603, 21.8009, 21.7396, 21.6763, 21.6109,
         21.5433, 21.4902, 21.4294, 21.3624, 21.2906, 21.2148, 21.1349, 21.051, 20.9631, 20.8711, 20.7747, 20.6737,
         20.568, 20.4571, 20.3407, 20.2185, 20.0899, 19.9546, 19.8118, 19.661, 19.5012, 19.3318, 19.1515, 18.9592,
         18.7534, 18.5323, 18.2939, 18.0355, 17.754, 17.4452, 17.1038, 16.723, 16.2931, 15.8006, 15.2254, 14.5354,
         13.6744, 12.5293, 10.8065, 7.08105, -3.13227, -3.29888, 7.38606, 10.3333, 11.4726, 11.8269, 11.0504, 6.23429,
         6.17858, 11.6286, 13.9279, 15.2259, 16.191, 16.9747, 17.6396, 18.2185, 18.7314, 19.1913, 19.6071, 19.9856,
         20.3315, 20.6485, 20.9392, 21.2057, 21.4492, 21.6704, 21.8693, 22.0449, 22.1951, 22.3155, 22.3976, 22.4237,
         22.3485, 21.9837, 21.3436, 21.3844, 21.8469, 22.8052, 23.3095, 23.6912, 24.0122, 24.2954, 24.5523, 24.7893,
         25.0104, 25.2184, 25.4154, 25.6025, 25.781, 25.9517, 26.1154, 26.2728, 26.4243, 26.5705, 26.7116, 26.848,
         26.9801, 27.1082, 27.2324, 27.3529, 27.4698, 27.5833, 27.6935, 27.8007, 27.9049, 28.0062, 28.1047, 28.2005,
         28.2938, 28.3847, 28.4732, 28.5594, 28.6435, 28.7255, 28.8055, 28.8835, 28.9596, 29.034, 29.1066, 29.1775,
         29.2467, 29.3144, 29.3806, 29.4453, 29.5085, 29.5705, 29.6311, 29.6905, 29.7488, 29.8058, 29.8613, 29.9155,
         29.9685, 30.0202, 30.0707, 30.12, 30.1682, 30.2153, 30.2614, 30.3064, 30.3504, 30.3935, 30.4356, 30.4768,
         30.5171, 30.5564, 30.595, 30.6327, 30.6695, 30.7056, 30.7409, 30.7755, 30.8093, 30.8423, 30.8747, 30.9064,
         30.9374, 30.9677, 30.9974, 31.0265, 31.0549, 31.0828, 31.11, 31.1367, 31.1629, 31.1885, 31.2135, 31.2381,
         31.2621, 31.2857, 31.3088, 31.3314, 31.3535, 31.3752, 31.3964, 31.4172, 31.4375, 31.4574, 31.477, 31.4961,
         31.5149, 31.5332, 31.5513, 31.569, 31.5864, 31.7109, 31.7274, 31.7435, 31.7591, 31.7742, 31.8434, 31.8576,
         31.8714, 31.8847, 31.8976, 31.91, 31.9221, 31.9338, 31.9451, 31.9561, 31.9667, 31.977, 31.987, 31.9966, 32.006,
         32.0152, 32.024, 32.0326, 32.041, 32.0491, 32.057, 32.0647, 32.0722, 32.0795, 32.0866, 32.1349, 32.1419,
         32.1487, 32.1554, 32.162, 32.1684, 32.1748, 32.1811, 32.1874, 32.1937, 32.2002, 32.2068, 32.2124, 32.2167,
         32.2206, 32.2241, 32.2271, 32.2298, 32.2321, 32.2341, 32.2358, 32.2372, 32.2382, 32.239, 32.2396, 32.2398,
         32.2399, 32.2397, 32.2393, 32.2386, 32.2378, 32.2368, 32.2355, 32.2341, 32.2325, 32.2308, 32.2288, 32.2268,
         32.2245, 32.2221, 32.2196, 32.2169, 32.214, 32.2111, 32.2079, 32.2047, 32.2014, 32.1979, 32.1943, 32.1906,
         32.1868, 32.1829, 32.1789, 32.1748, 32.1705, 32.1662, 32.1619, 32.1574, 32.1528, 32.1482, 32.1435, 32.1387,
         32.1338, 32.1288, 32.1238, 32.1187, 32.1136, 32.1084, 32.1031, 32.0978, 32.0924, 32.087, 32.0815, 32.0759,
         32.0703, 32.0647, 32.059, 32.0532, 32.0475, 32.0416, 32.0358, 32.0299, 32.0239, 32.018, 32.0119, 32.0059,
         31.9998, 31.9937, 31.9875, 31.9814, 31.9752, 31.9689, 31.9627, 31.9564, 31.9501, 31.9438, 31.9374, 31.9311,
         31.9247, 31.9183, 31.9118, 31.9054, 31.8989, 31.8925, 31.886, 31.8795, 31.873, 31.8664, 31.8599, 31.8533,
         31.8468, 31.8402, 31.8337, 31.8271, 31.8205, 31.8139, 31.8073, 31.8007, 31.7941, 31.7875, 31.7809, 31.7743,
         31.7677, 31.7612, 31.7546, 31.748, 31.7414, 31.7348, 31.7281, 31.7214, 31.7146, 31.7078, 31.701, 31.6941,
         31.6871, 31.6801, 31.6731, 31.666, 31.6588, 31.6517, 31.6445, 31.6372, 31.63, 31.6227, 31.6153, 31.608,
         31.6006, 31.5932, 31.5857, 31.5783, 31.5708, 31.5633, 31.5557, 31.5482, 31.5406, 31.533, 31.5254, 31.5177,
         31.51, 31.5022, 31.4943, 31.4863, 31.4784, 31.4703, 31.4622, 31.454, 31.4458, 31.4375, 31.4292, 31.4208,
         31.3523, 31.2238, 31.0798, 30.9116, 30.7014, 30.3972, 29.8588, 28.674, 27.5223, 27.2677, 25.5686, 27.3085,
         28.8815, 30.1773, 31.021, 31.4728, 31.775, 31.9885, 32.1337, 32.2331, 32.2995, 32.342, 32.3676, 32.4172,
         32.4194, 32.4148, 32.406, 32.391, 32.3726, 32.3523, 32.331, 32.3095, 32.2884, 32.2679, 32.2485, 32.2299,
         32.2116, 32.1942, 32.1777, 32.1623, 32.1479, 32.1347, 32.1226, 32.1112, 32.1007, 32.0911, 32.0822, 32.0741,
         32.0668, 32.0601, 32.054, 32.0485, 32.0436, 32.0391, 32.035, 32.0314, 32.0281, 32.0251, 32.0225, 32.0201,
         32.0179, 32.016, 32.0143, 32.0128, 32.0114, 32.0101, 32.009, 32.008],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.8603, 0.87594,
         0.88848, 1.0128, 1.1767, 1.3852, 1.6451, 1.9627, 2.3438, 2.7932, 3.3138, 3.9058, 4.5662, 5.2882, 6.0612,
         6.8707, 7.6989, 8.5256, 9.3292, 10.088, 10.78, 11.388, 11.896, 12.289, 12.301, 12.37, 12.387, 12.806, 12.88,
         12.956, 12.985, 13.017, 13.032, 13.234, 13.292, 13.403, 13.533, 13.55, 13.463, 13.283, 13.28, 13.227, 13.213,
         13.744, 13.693, 13.597, 13.306, 12.957, 12.561, 12.127, 11.665, 11.182, 10.687, 10.186, 9.6827, 9.1826, 8.6892,
         8.2053, 7.7335, 7.2755, 6.832, 6.3846, 5.9027, 5.4478, 5.0209, 4.6224, 4.2519, 3.9088, 3.5923, 3.4614, 3.4396,
         3.418, 3.3965, 3.3751, 3.3539, 3.3328, 3.3119, 3.291, 3.2704, 3.2498, 3.2294, 3.2092, 3.189, 3.169, 3.1491,
         3.1294, 3.1098, 3.0903, 3.071, 3.0517, 3.0326, 3.0089, 2.9847, 2.9607, 2.9369, 2.9133, 2.89, 2.8669, 2.844,
         2.8213, 2.7988, 2.7765, 2.7544, 2.7326, 2.7109, 2.6894, 2.6681, 2.647, 2.6261, 2.6054, 2.5849, 2.5646, 2.5444,
         2.5245, 2.5047, 2.4851, 2.4656, 2.4464, 2.4273, 2.4084, 2.3896, 2.3711, 2.3526, 2.3344, 2.3163, 2.2984, 2.2806,
         2.263, 2.2456, 2.2283, 2.2208, 11.907, 11.856, 11.76, 11.665, 11.571, 11.478, 11.432, 16.209, 16.147, 16.017,
         15.889, 15.761, 15.634, 15.509, 15.384, 15.261, 15.138, 15.016, 14.896, 14.776, 14.658, 14.54, 14.424, 14.308,
         14.193, 14.079, 13.966, 13.854, 13.743, 13.633, 13.524, 13.416, 13.308, 13.261, 15.085, 15.064, 14.954, 14.845,
         14.737, 14.629, 14.523, 14.417, 14.313, 14.209, 14.106, 14.003, 13.901, 13.8, 13.7, 13.6, 13.501, 13.403,
         13.306, 13.21, 13.114, 13.019, 12.924, 12.831, 12.737, 12.644, 12.552, 12.46, 12.369, 12.278, 12.188, 12.099,
         12.01, 11.922, 11.835, 11.748, 11.662, 11.576, 11.491, 11.407, 11.324, 11.241, 11.158, 11.077, 10.995, 10.915,
         10.835, 10.756, 10.677, 10.599, 10.521, 10.444, 10.368, 10.292, 10.216, 10.14, 10.065, 9.99, 9.9158, 9.8422,
         9.7691, 9.6966, 9.6245, 9.553, 9.4821, 9.4117, 9.3417, 9.2723, 9.2034, 9.1351, 9.0672, 8.9998, 8.9329, 8.8666,
         8.8007, 8.7353, 8.6704, 8.6059, 8.542, 8.4785, 8.4155, 8.3529, 8.2909, 8.2293, 8.1681, 8.1074, 8.0472, 7.9874,
         7.9281, 7.8692, 7.8107, 7.7527, 7.6951, 7.638, 7.5813, 7.525, 7.4687, 7.4127, 7.3571, 7.3019, 7.2471, 7.1928,
         7.1389, 7.0854, 7.0323, 6.9796, 6.9273, 6.8754, 6.8236, 6.7722, 6.7203, 6.6681, 6.6163, 6.565, 6.514, 6.463,
         6.4121, 6.3615, 6.3114, 6.2616, 6.2123, 6.1634, 6.1148, 6.0666, 6.0189, 5.9715, 5.9245, 5.8779, 5.8317, 5.7858,
         5.7403, 5.6952, 5.6505, 5.6061, 5.5621, 5.5185, 5.4752, 5.4323, 5.3897, 5.3475, 5.3054, 5.2633, 5.2215, 5.1801,
         5.139, 5.0983, 5.0579, 5.0179, 4.9781, 4.9388, 4.8997, 4.861, 4.8201, 4.7779, 4.7361, 4.6947, 4.6537, 4.6131,
         4.5729, 4.533, 4.4935, 4.4543, 4.4155, 4.3771, 4.3391, 4.3013, 4.264, 4.227, 4.1903, 4.154, 4.118, 4.0823,
         4.047, 4.0119, 3.9773, 3.9429, 3.9088, 3.8749, 3.8413, 3.8081, 3.7752, 3.7425, 3.7102, 3.6782, 3.6464, 3.615,
         3.5838, 3.553, 3.5224, 3.4921, 3.462, 3.4323, 3.4028, 3.3736, 3.3447, 3.316, 3.2876, 3.2594, 3.2315, 3.2039,
         3.1765, 3.1493, 3.1224, 3.0958, 3.0694, 3.0432, 3.0173, 2.9916, 2.9662, 2.9409, 2.9159, 2.8912, 2.8666, 2.8423,
         2.8182, 2.7943, 2.7707, 2.7472, 2.724, 2.701, 2.6781, 2.6555, 2.6331, 2.6109, 2.5889, 2.5671, 2.5455, 2.5241,
         2.5029, 2.4818, 2.461, 2.4404, 2.4199, 2.3996, 2.3795, 2.3596, 2.3399, 2.3203, 2.3009, 2.2817, 2.2627, 2.2438,
         2.2251, 2.2066, 2.1882, 2.17, 2.152, 2.1341, 2.1164, 2.0988, 2.0814, 2.0641, 2.0471, 2.0301, 2.0133, 1.9967,
         1.9802, 1.9638, 1.9476, 1.9316, 1.9157, 1.8999, 1.8843, 1.8688, 1.8534, 1.8379, 1.8221, 1.8066, 1.7911, 1.7759,
         1.7606, 1.7453, 1.7301, 1.7151, 1.7002, 1.6855, 1.6709, 1.6564, 1.6421, 1.6279, 1.6139, 1.6, 1.5862, 1.5725,
         1.559, 1.5456, 1.5323, 1.5192, 1.5062, 1.4933, 1.4805, 1.4679, 1.4553, 1.4429, 1.4306, 1.4182, 1.4056, 1.3931,
         1.3807, 1.3684, 1.3562, 1.3442, 1.3322, 1.3204, 1.3087, 1.2971, 1.2856, 1.2742, 1.263, 1.2518, 1.1474, 1.0201,
         0.90777, 0.80862, 0.71829, 0.63015, 0.55335, 0.49947, 0.48636, 0.48505, 0.48132, 3.8275, 3.7099, 3.4186,
         3.0517, 2.7472, 2.4811, 2.2215, 1.985, 1.7706, 1.5776, 1.405, 1.2513, 1.1127, 0.98771, 0.87684, 0.77457,
         0.6832, 0.60227, 0.53094, 0.46809, 0.41271, 0.3639, 0.32088, 0.28296, 0.24813, 0.2175, 0.19066, 0.16714,
         0.14652, 0.12846, 0.11262, 0.098633, 0.08617, 0.075285, 0.065777, 0.057472, 0.050218, 0.043881, 0.038345,
         0.033509, 0.029283, 0.025591, 0.022366, 0.019548, 0.017085, 0.014933, 0.013053, 0.011409, 0.0099731, 0.008718,
         0.0076211, 0.0066625, 0.0058245, 0.0050922, 0.004452, 0.0038924, 0.0034033]],
    'As':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.040376, 0.04060054, 0.040994, 0.0411588, 0.041406, 0.042024, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368,
         0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.13769, 0.1397975, 0.1403595,
         0.1412025, 0.14331, 0.143472, 0.1442475, 0.145668, 0.1462536, 0.147132, 0.149328, 0.1542005, 0.1648404,
         0.1762144, 0.1883732, 0.19943, 0.2013709, 0.2024825, 0.2032965, 0.2045175, 0.20757, 0.2152655, 0.2301188,
         0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657,
         0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896,
         0.9, 0.9045, 0.9090225, 0.91356761, 0.91813545, 0.92272613, 0.92733976, 0.93197646, 0.93663634, 0.94131952,
         0.94602612, 0.95075625, 0.95551003, 0.96028758, 0.96508902, 0.96991446, 0.97476404, 0.97963786, 0.98453605,
         0.98945873, 0.99440602, 0.99937805, 1.0043749, 1.0093968, 1.0144438, 1.019516, 1.0246136, 1.0297367, 1.0348853,
         1.0400598, 1.0452601, 1.0504864, 1.0557388, 1.0610175, 1.0663226, 1.0716542, 1.0770125, 1.0823975, 1.0878095,
         1.0932486, 1.0987148, 1.1042084, 1.1097294, 1.1152781, 1.1208545, 1.1264587, 1.132091, 1.1377515, 1.1434402,
         1.1491574, 1.1549032, 1.1606777, 1.1664811, 1.1723135, 1.1781751, 1.184066, 1.1899863, 1.1959362, 1.2019159,
         1.2079255, 1.2139651, 1.220035, 1.2261351, 1.2322658, 1.2384271, 1.2446193, 1.2508424, 1.2570966, 1.2633821,
         1.269699, 1.2760475, 1.2824277, 1.2888399, 1.295284, 1.3017605, 1.3082693, 1.3148106, 1.3213847, 1.3229793,
         1.3232206, 1.3279916, 1.3346316, 1.3413047, 1.3480112, 1.3547513, 1.3584739, 1.3587261, 1.361525, 1.3683327,
         1.3751743, 1.3820502, 1.3889605, 1.3959053, 1.4028848, 1.4098992, 1.4169487, 1.4240335, 1.4311536, 1.4383094,
         1.4455009, 1.4527284, 1.4599921, 1.467292, 1.4746285, 1.4820016, 1.4894117, 1.4968587, 1.504343, 1.5118647,
         1.519424, 1.5251383, 1.5270212, 1.5278616, 1.5346563, 1.5423295, 1.5500412, 1.5577914, 1.5655804, 1.5734083,
         1.5812753, 1.5891817, 1.5971276, 1.6051132, 1.6131388, 1.6212045, 1.6293105, 1.6374571, 1.6456443, 1.6538726,
         1.6621419, 1.6704526, 1.6788049, 1.6871989, 1.6956349, 1.7041131, 1.7126337, 1.7211968, 1.7298028, 1.7384518,
         1.7471441, 1.7558798, 1.7646592, 1.7734825, 1.7823499, 1.7912617, 1.800218, 1.8092191, 1.8182652, 1.8273565,
         1.8364933, 1.8456757, 1.8549041, 1.8641786, 1.8734995, 1.882867, 1.8922814, 1.9017428, 1.9112515, 1.9208077,
         1.9304118, 1.9400638, 1.9497642, 1.959513, 1.9693105, 1.9791571, 1.9890529, 1.9989981, 2.0089931, 2.0190381,
         2.0291333, 2.039279, 2.0494754, 2.0597227, 2.0700213, 2.0803714, 2.0907733, 2.1012272, 2.1117333, 2.122292,
         2.1329034, 2.143568, 2.1542858, 2.1650572, 2.1758825, 2.1867619, 2.1976957, 2.2086842, 2.2197276, 2.2308263,
         2.2419804, 2.2531903, 2.2644562, 2.2757785, 2.2871574, 2.2985932, 2.3100862, 2.3216366, 2.3332448, 2.344911,
         2.3566356, 2.3684187, 2.3802608, 2.3921621, 2.404123, 2.4161436, 2.4282243, 2.4403654, 2.4525672, 2.4648301,
         2.4771542, 2.48954, 2.5019877, 2.5144976, 2.5270701, 2.5397055, 2.552404, 2.565166, 2.5779919, 2.5908818,
         2.6038362, 2.6168554, 2.6299397, 2.6430894, 2.6563048, 2.6695863, 2.6829343, 2.6963489, 2.7098307, 2.7233798,
         2.7369967, 2.7506817, 2.7644351, 2.7782573, 2.7921486, 2.8061093, 2.8201399, 2.8342406, 2.8484118, 2.8626539,
         2.8769671, 2.891352, 2.9058087, 2.9203378, 2.9349394, 2.9496141, 2.9643622, 2.979184, 2.9940799, 3.0090503,
         3.0240956, 3.0392161, 3.0544122, 3.0696842, 3.0850326, 3.1004578, 3.1159601, 3.1315399, 3.1471976, 3.1629336,
         3.1787482, 3.194642, 3.2106152, 3.2266683, 3.2428016, 3.2590156, 3.2753107, 3.2916873, 3.3081457, 3.3246864,
         3.3413099, 3.3580164, 3.3748065, 3.3916805, 3.4086389, 3.4256821, 3.4428105, 3.4600246, 3.4773247, 3.4947113,
         3.5121849, 3.5297458, 3.5473945, 3.5651315, 3.5829572, 3.6008719, 3.6188763, 3.6369707, 3.6551555, 3.6734313,
         3.6917985, 3.7102575, 3.7288088, 3.7474528, 3.7661901, 3.785021, 3.8039461, 3.8229659, 3.8420807, 3.8612911,
         3.8805975, 3.9000005, 3.9195005, 3.939098, 3.9587935, 3.9785875, 3.9984804, 4.0184728, 4.0385652, 4.058758,
         4.0790518, 4.0994471, 4.1199443, 4.140544, 4.1612467, 4.182053, 4.2029632, 4.2239781, 4.245098, 4.2663234,
         4.2876551, 4.3090933, 4.3306388, 4.352292, 4.3740535, 4.3959237, 4.4179033, 4.4399929, 4.4621928, 4.4845038,
         4.5069263, 4.5294609, 4.5521082, 4.5748688, 4.5977431, 4.6207318, 4.6438355, 4.6670547, 4.69039, 4.7138419,
         4.7374111, 4.7610982, 4.7849037, 4.8088282, 4.8328723, 4.8570367, 4.8813219, 4.9057285, 4.9302571, 4.9549084,
         4.9796829, 5.0045814, 5.0296043, 5.0547523, 5.080026, 5.1054262, 5.1309533, 5.1566081, 5.1823911, 5.2083031,
         5.2343446, 5.2605163, 5.2868189, 5.313253, 5.3398192, 5.3665183, 5.3933509, 5.4203177, 5.4474193, 5.4746564,
         5.5020297, 5.5295398, 5.5571875, 5.5849734, 5.6128983, 5.6409628, 5.6691676, 5.6975135, 5.726001, 5.754631,
         5.7834042, 5.8123212, 5.8413828, 5.8705897, 5.8999427, 5.9294424, 5.9590896, 5.988885, 6.0188295, 6.0489236,
         6.0791682, 6.1095641, 6.1401119, 6.1708125, 6.2016665, 6.2326749, 6.2638382, 6.2951574, 6.3266332, 6.3582664,
         6.3900577, 6.422008, 6.454118, 6.4863886, 6.5188206, 6.5514147, 6.5841717, 6.915365, 7.392525, 7.902609,
         8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.62937, 11.79334, 11.80737, 11.85483, 11.92603, 12.10403,
         12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923,
         26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542,
         54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353,
         113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548,
         237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [5.97388, 5.95892, 5.94172, 5.92193, 5.89914, 5.87286, 5.84252, 5.80742, 5.76673, 5.71947, 5.66438, 5.59995,
         5.52424, 5.43479, 5.32828, 5.20019, 5.04396, 4.84923, 4.59747, 4.24541, 3.66212, 3.56057, 3.26814, 2.89512,
         3.18075, 3.36584, 3.36274, 3.13444, 2.84875, 2.55769, 2.28864, 2.06592, 1.9131, 1.85256, 1.9041, 2.08345,
         2.40093, 2.86035, 3.45832, 4.18397, 5.01853, 5.93419, 6.88034, 7.77925, 7.98349, 7.99944, 7.81981, 8.12885,
         8.52176, 8.54386, 8.64108, 8.77001, 8.74386, 8.95813, 9.32082, 9.96447, 11.2098, 12.4105, 13.5313, 14.2923,
         14.335, 14.2878, 14.0489, 14.454, 14.965, 15.7674, 16.9797, 18.0578, 19.0331, 19.913, 20.7016, 21.4026,
         22.0202, 22.559, 23.024, 23.4203, 23.7497, 24.0227, 24.2405, 24.4063, 24.5228, 24.5907, 24.6075, 24.5717,
         24.4792, 24.318, 24.0651, 24.4656, 24.4435, 24.4209, 24.3978, 24.3741, 24.3499, 24.325, 24.2997, 24.2737,
         24.2472, 24.2202, 24.1925, 24.1643, 24.1355, 24.1062, 24.0763, 24.0458, 24.0149, 23.9834, 23.9515, 23.9192,
         23.8865, 23.8509, 23.8095, 23.7656, 23.7197, 23.6722, 23.6231, 23.5725, 23.5201, 23.4662, 23.4105, 23.3531,
         23.2939, 23.2327, 23.1696, 23.1045, 23.0371, 22.9676, 22.8956, 22.8212, 22.7442, 22.6644, 22.5817, 22.4959,
         22.4069, 22.3144, 22.2182, 22.118, 22.0137, 21.9049, 21.7912, 21.6724, 21.5479, 21.4173, 21.2802, 21.1358,
         20.9834, 20.8225, 20.6519, 20.4706, 20.2775, 20.0709, 19.8492, 19.6102, 19.3513, 19.0692, 18.7596, 18.4174,
         18.0351, 17.6029, 17.1067, 16.5252, 15.8238, 14.9407, 13.7469, 11.8809, 7.00551, -1.02828, -1.19194, 9.86152,
         12.1906, 13.1749, 13.477, 12.7785, 8.07519, 8.02227, 12.9746, 15.3326, 16.6108, 17.552, 18.3128, 18.9565,
         19.5156, 20.01, 20.4522, 20.851, 21.2128, 21.5421, 21.8422, 22.1155, 22.3634, 22.5867, 22.785, 22.9569, 23.099,
         23.2045, 23.2595, 23.2307, 23.0055, 22.1676, 21.6078, 22.2101, 23.467, 24.0566, 24.4774, 24.8232, 25.1247,
         25.3961, 25.6449, 25.876, 26.0924, 26.2963, 26.4898, 26.6742, 26.8504, 27.0193, 27.1815, 27.3375, 27.4878,
         27.6329, 27.7732, 27.9088, 28.0403, 28.1678, 28.2917, 28.4121, 28.5289, 28.6423, 28.7524, 28.8595, 28.9637,
         29.065, 29.1635, 29.2593, 29.3525, 29.4432, 29.5316, 29.6177, 29.7016, 29.7834, 29.8632, 29.9411, 30.0171,
         30.0913, 30.1637, 30.2345, 30.3037, 30.3712, 30.4373, 30.502, 30.5652, 30.6271, 30.6878, 30.7473, 30.8056,
         30.8624, 30.9178, 30.9719, 31.0246, 31.0762, 31.1265, 31.1757, 31.2237, 31.2706, 31.3165, 31.3613, 31.4051,
         31.4479, 31.4898, 31.5308, 31.5708, 31.6099, 31.6482, 31.6856, 31.7222, 31.758, 31.793, 31.8272, 31.8607,
         31.8935, 31.9255, 31.9569, 31.9875, 32.0175, 32.0468, 32.0755, 32.1036, 32.1311, 32.158, 32.1843, 32.21,
         32.2352, 32.2598, 32.284, 32.3076, 32.3307, 32.3533, 32.3754, 32.3971, 32.4184, 32.4392, 32.4595, 32.4795,
         32.499, 32.5182, 32.537, 32.5554, 32.5735, 32.5912, 32.6086, 32.6257, 32.6425, 32.7635, 32.7794, 32.7949,
         32.8099, 32.8246, 32.8894, 32.9031, 32.9164, 32.9293, 32.9418, 32.9538, 32.9656, 32.9769, 32.988, 32.9987,
         33.0091, 33.0192, 33.029, 33.0386, 33.0479, 33.057, 33.0659, 33.0747, 33.0835, 33.094, 33.1145, 33.1264,
         33.1367, 33.1882, 33.1966, 33.2041, 33.2109, 33.2171, 33.2227, 33.2278, 33.2325, 33.2366, 33.2404, 33.2438,
         33.2468, 33.2495, 33.2518, 33.2539, 33.2556, 33.257, 33.2582, 33.2591, 33.2598, 33.2602, 33.2604, 33.2603,
         33.26, 33.2596, 33.2589, 33.258, 33.257, 33.2557, 33.2543, 33.2527, 33.251, 33.249, 33.247, 33.2447, 33.2424,
         33.2399, 33.2372, 33.2344, 33.2315, 33.2285, 33.2254, 33.2221, 33.2187, 33.2152, 33.2116, 33.2079, 33.2041,
         33.2002, 33.1962, 33.1921, 33.1879, 33.1836, 33.1792, 33.1748, 33.1702, 33.1656, 33.1609, 33.1561, 33.1513,
         33.1464, 33.1414, 33.1363, 33.1312, 33.126, 33.1208, 33.1155, 33.1101, 33.1047, 33.0992, 33.0937, 33.0881,
         33.0825, 33.0768, 33.0711, 33.0654, 33.0596, 33.0538, 33.0479, 33.042, 33.036, 33.03, 33.024, 33.0179, 33.0119,
         33.0057, 32.9996, 32.9934, 32.9872, 32.981, 32.9747, 32.9685, 32.9622, 32.9558, 32.9495, 32.9431, 32.9367,
         32.9303, 32.9239, 32.9174, 32.911, 32.9045, 32.898, 32.8915, 32.885, 32.8785, 32.8719, 32.8654, 32.8588,
         32.8522, 32.8457, 32.8391, 32.8325, 32.8259, 32.8193, 32.8127, 32.806, 32.7994, 32.7928, 32.7862, 32.7796,
         32.7729, 32.7663, 32.7597, 32.7531, 32.7465, 32.7399, 32.7333, 32.7267, 32.72, 32.7133, 32.7066, 32.6998,
         32.693, 32.6861, 32.6792, 32.6722, 32.6652, 32.6582, 32.6511, 32.6439, 32.6368, 32.6296, 32.6223, 32.6151,
         32.6078, 32.6004, 32.5931, 32.5857, 32.5783, 32.5708, 32.5634, 32.5559, 32.5484, 32.5408, 32.4812, 32.3657,
         32.2394, 32.0983, 31.9351, 31.721, 31.4141, 30.8756, 29.6992, 28.5199, 28.3012, 26.6121, 28.3415, 29.9049,
         31.1969, 32.0334, 32.4817, 32.7814, 32.993, 33.1366, 33.2347, 33.3002, 33.3421, 33.3674, 33.4162, 33.4187,
         33.4175, 33.4061, 33.3899, 33.371, 33.3504, 33.329, 33.3075, 33.2864, 33.2661, 33.2468, 33.2282, 33.2101,
         33.1928, 33.1765, 33.1613, 33.1471, 33.134, 33.1218, 33.1105, 33.1, 33.0904, 33.0816, 33.0736, 33.0663,
         33.0597, 33.0537, 33.0482, 33.0433, 33.0388, 33.0348, 33.0312, 33.0279, 33.025, 33.0223, 33.02, 33.0178,
         33.0159, 33.0142, 33.0127, 33.0113, 33.0101, 33.009],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
         0.0, 0.0, 0.67799, 0.72651, 0.84453, 1.1515, 1.5444, 2.0278, 2.6072, 3.2835, 4.0522, 4.9031, 5.8203, 6.7827,
         7.7653, 8.7406, 9.6801, 10.556, 11.345, 12.024, 12.577, 12.994, 13.092, 13.158, 13.174, 13.658, 13.733, 13.739,
         13.765, 13.809, 13.827, 14.057, 14.127, 14.262, 14.463, 14.537, 14.477, 14.33, 14.297, 14.278, 14.263, 14.839,
         14.787, 14.637, 14.296, 13.877, 13.395, 12.864, 12.298, 11.708, 11.107, 10.502, 9.901, 9.3104, 8.7349, 8.1779,
         7.6422, 7.1294, 6.6402, 6.1736, 5.7303, 5.3113, 4.9173, 4.5204, 4.1474, 3.9929, 3.9672, 3.9416, 3.9163, 3.891,
         3.866, 3.8411, 3.8164, 3.7919, 3.7675, 3.7432, 3.7192, 3.6953, 3.6715, 3.648, 3.6245, 3.6013, 3.5782, 3.5552,
         3.5325, 3.5098, 3.4874, 3.4595, 3.4312, 3.403, 3.3752, 3.3476, 3.3203, 3.2932, 3.2664, 3.2399, 3.2135, 3.1875,
         3.1616, 3.136, 3.1107, 3.0856, 3.0607, 3.036, 3.0116, 2.9874, 2.9634, 2.9397, 2.9161, 2.8928, 2.8697, 2.8468,
         2.8241, 2.8016, 2.7794, 2.7573, 2.7354, 2.7137, 2.6923, 2.671, 2.6499, 2.629, 2.6083, 2.5878, 2.5674, 2.5473,
         2.5273, 2.5075, 2.4879, 2.4685, 2.4492, 2.4301, 2.4112, 2.3925, 2.3739, 2.3555, 2.3372, 2.3191, 2.3012, 2.2834,
         2.2658, 2.2483, 2.231, 2.2269, 11.702, 11.634, 11.541, 11.449, 11.357, 11.267, 11.217, 15.893, 15.841, 15.714,
         15.589, 15.465, 15.342, 15.22, 15.099, 14.979, 14.86, 14.742, 14.625, 14.508, 14.393, 14.279, 14.165, 14.053,
         13.941, 13.83, 13.72, 13.612, 13.503, 13.396, 13.29, 13.211, 15.08, 15.068, 14.969, 14.858, 14.748, 14.639,
         14.531, 14.424, 14.318, 14.212, 14.108, 14.004, 13.902, 13.801, 13.701, 13.601, 13.502, 13.404, 13.307, 13.211,
         13.115, 13.021, 12.927, 12.833, 12.741, 12.649, 12.557, 12.465, 12.374, 12.284, 12.194, 12.104, 12.015, 11.927,
         11.839, 11.752, 11.666, 11.58, 11.495, 11.411, 11.327, 11.244, 11.162, 11.08, 10.998, 10.918, 10.838, 10.758,
         10.679, 10.601, 10.523, 10.446, 10.37, 10.294, 10.218, 10.141, 10.066, 9.9906, 9.9161, 9.8421, 9.7686, 9.6957,
         9.6233, 9.5514, 9.4801, 9.4093, 9.339, 9.2692, 9.1999, 9.1311, 9.0628, 8.9951, 8.9278, 8.861, 8.7947, 8.7289,
         8.6636, 8.5988, 8.5344, 8.4705, 8.4071, 8.3442, 8.2817, 8.2197, 8.1582, 8.0971, 8.0365, 7.9763, 7.9166, 7.8574,
         7.7985, 7.7402, 7.6822, 7.6247, 7.5677, 7.511, 7.4548, 7.3991, 7.3437, 7.2888, 7.2343, 7.1802, 7.1265, 7.0732,
         7.0204, 6.9679, 6.9159, 6.8642, 6.813, 6.7621, 6.7117, 6.6614, 6.6101, 6.559, 6.5082, 6.4579, 6.408, 6.3581,
         6.3083, 6.2589, 6.2096, 6.1607, 6.1122, 6.0642, 6.0165, 5.9692, 5.9223, 5.8757, 5.8296, 5.7838, 5.7385, 5.6935,
         5.6489, 5.6046, 5.5607, 5.5172, 5.4741, 5.4288, 5.3822, 5.336, 5.2902, 5.2439, 5.1979, 5.1524, 5.1074, 5.0627,
         5.0184, 4.9746, 4.9312, 4.8882, 4.8455, 4.8033, 4.7615, 4.72, 4.6789, 4.6383, 4.598, 4.558, 4.5184, 4.4792,
         4.4404, 4.4019, 4.3638, 4.326, 4.2886, 4.2515, 4.2148, 4.1784, 4.1423, 4.1066, 4.0712, 4.0361, 4.0013, 3.9669,
         3.9328, 3.8989, 3.8654, 3.8323, 3.7994, 3.7668, 3.7345, 3.7025, 3.6708, 3.6394, 3.6083, 3.5774, 3.5468, 3.5164,
         3.4862, 3.4564, 3.4268, 3.3975, 3.3685, 3.3397, 3.3112, 3.283, 3.255, 3.2273, 3.1998, 3.1726, 3.1456, 3.1188,
         3.0923, 3.0661, 3.0401, 3.0143, 2.9888, 2.9634, 2.9384, 2.9135, 2.8889, 2.8645, 2.8403, 2.8163, 2.7925, 2.769,
         2.7457, 2.7226, 2.6996, 2.6769, 2.6544, 2.6322, 2.6101, 2.5882, 2.5665, 2.545, 2.5237, 2.5025, 2.4816, 2.4609,
         2.4403, 2.4199, 2.3998, 2.3797, 2.3599, 2.3403, 2.3208, 2.3015, 2.2824, 2.2634, 2.2446, 2.226, 2.2075, 2.1893,
         2.1711, 2.1532, 2.1354, 2.1177, 2.1002, 2.0829, 2.0657, 2.0487, 2.0318, 2.0151, 1.9985, 1.9821, 1.9658, 1.9496,
         1.9336, 1.9178, 1.9021, 1.8865, 1.8711, 1.8558, 1.8406, 1.8255, 1.8106, 1.7954, 1.7802, 1.7651, 1.7501, 1.7353,
         1.7204, 1.7056, 1.6908, 1.6763, 1.6618, 1.6475, 1.6333, 1.6193, 1.6054, 1.5916, 1.578, 1.5645, 1.5511, 1.5378,
         1.5247, 1.5117, 1.4988, 1.486, 1.4734, 1.4608, 1.4484, 1.4361, 1.4239, 1.3052, 1.1599, 1.0317, 0.9186, 0.81573,
         0.71576, 0.62865, 0.55267, 0.49952, 0.48634, 0.48523, 0.48153, 3.8077, 3.691, 3.4005, 3.0358, 2.7327, 2.4677,
         2.2092, 1.9737, 1.7605, 1.5688, 1.3973, 1.2448, 1.1074, 0.98363, 0.86938, 0.76708, 0.67685, 0.59696, 0.52646,
         0.46432, 0.40953, 0.36124, 0.31866, 0.28111, 0.24662, 0.21628, 0.18968, 0.16636, 0.14591, 0.12798, 0.11213,
         0.097993, 0.085642, 0.074852, 0.065423, 0.057184, 0.049985, 0.043694, 0.038196, 0.033391, 0.029191, 0.025521,
         0.022313, 0.019508, 0.017057, 0.014915, 0.013041, 0.011404, 0.0099724, 0.0087208, 0.0076265, 0.0066698,
         0.0058332, 0.0051018, 0.0044622, 0.0039029]],
    'Se':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.055566, 0.0564165,
         0.05667876, 0.0569835, 0.057834, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368,
         0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.158662,
         0.1610905, 0.1617381, 0.1627095, 0.1648404, 0.165138, 0.167359, 0.1680318, 0.169041, 0.171564, 0.1762144,
         0.1883732, 0.2013709, 0.2152655, 0.22687, 0.2301188, 0.2303425, 0.2312685, 0.2326575, 0.23613, 0.245997,
         0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098,
         0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9, 0.9045,
         0.9090225, 0.91356761, 0.91813545, 0.92272613, 0.92733976, 0.93197646, 0.93663634, 0.94131952, 0.94602612,
         0.95075625, 0.95551003, 0.96028758, 0.96508902, 0.96991446, 0.97476404, 0.97963786, 0.98453605, 0.98945873,
         0.99440602, 0.99937805, 1.0043749, 1.0093968, 1.0144438, 1.019516, 1.0246136, 1.0297367, 1.0348853, 1.0400598,
         1.0452601, 1.0504864, 1.0557388, 1.0610175, 1.0663226, 1.0716542, 1.0770125, 1.0823975, 1.0878095, 1.0932486,
         1.0987148, 1.1042084, 1.1097294, 1.1152781, 1.1208545, 1.1264587, 1.132091, 1.1377515, 1.1434402, 1.1491574,
         1.1549032, 1.1606777, 1.1664811, 1.1723135, 1.1781751, 1.184066, 1.1899863, 1.1959362, 1.2019159, 1.2079255,
         1.2139651, 1.220035, 1.2261351, 1.2322658, 1.2384271, 1.2446193, 1.2508424, 1.2570966, 1.2633821, 1.269699,
         1.2760475, 1.2824277, 1.2888399, 1.295284, 1.3017605, 1.3082693, 1.3148106, 1.3213847, 1.3279916, 1.3346316,
         1.3413047, 1.3480112, 1.3547513, 1.361525, 1.3683327, 1.3751743, 1.3820502, 1.3889605, 1.3959053, 1.4028848,
         1.4098992, 1.4169487, 1.4240335, 1.4311536, 1.4356568, 1.4359431, 1.4383094, 1.4455009, 1.4527284, 1.4599921,
         1.467292, 1.4746285, 1.4760494, 1.4763506, 1.4820016, 1.4894117, 1.4968587, 1.504343, 1.5118647, 1.519424,
         1.5270212, 1.5346563, 1.5423295, 1.5500412, 1.5577914, 1.5655804, 1.5734083, 1.5812753, 1.5891817, 1.5971276,
         1.6051132, 1.6131388, 1.6212045, 1.6293105, 1.6374571, 1.6456443, 1.6524595, 1.6538726, 1.6553406, 1.6621419,
         1.6704526, 1.6788049, 1.6871989, 1.6956349, 1.7041131, 1.7126337, 1.7211968, 1.7298028, 1.7384518, 1.7471441,
         1.7558798, 1.7646592, 1.7734825, 1.7823499, 1.7912617, 1.800218, 1.8092191, 1.8182652, 1.8273565, 1.8364933,
         1.8456757, 1.8549041, 1.8641786, 1.8734995, 1.882867, 1.8922814, 1.9017428, 1.9112515, 1.9208077, 1.9304118,
         1.9400638, 1.9497642, 1.959513, 1.9693105, 1.9791571, 1.9890529, 1.9989981, 2.0089931, 2.0190381, 2.0291333,
         2.039279, 2.0494754, 2.0597227, 2.0700213, 2.0803714, 2.0907733, 2.1012272, 2.1117333, 2.122292, 2.1329034,
         2.143568, 2.1542858, 2.1650572, 2.1758825, 2.1867619, 2.1976957, 2.2086842, 2.2197276, 2.2308263, 2.2419804,
         2.2531903, 2.2644562, 2.2757785, 2.2871574, 2.2985932, 2.3100862, 2.3216366, 2.3332448, 2.344911, 2.3566356,
         2.3684187, 2.3802608, 2.3921621, 2.404123, 2.4161436, 2.4282243, 2.4403654, 2.4525672, 2.4648301, 2.4771542,
         2.48954, 2.5019877, 2.5144976, 2.5270701, 2.5397055, 2.552404, 2.565166, 2.5779919, 2.5908818, 2.6038362,
         2.6168554, 2.6299397, 2.6430894, 2.6563048, 2.6695863, 2.6829343, 2.6963489, 2.7098307, 2.7233798, 2.7369967,
         2.7506817, 2.7644351, 2.7782573, 2.7921486, 2.8061093, 2.8201399, 2.8342406, 2.8484118, 2.8626539, 2.8769671,
         2.891352, 2.9058087, 2.9203378, 2.9349394, 2.9496141, 2.9643622, 2.979184, 2.9940799, 3.0090503, 3.0240956,
         3.0392161, 3.0544122, 3.0696842, 3.0850326, 3.1004578, 3.1159601, 3.1315399, 3.1471976, 3.1629336, 3.1787482,
         3.194642, 3.2106152, 3.2266683, 3.2428016, 3.2590156, 3.2753107, 3.2916873, 3.3081457, 3.3246864, 3.3413099,
         3.3580164, 3.3748065, 3.3916805, 3.4086389, 3.4256821, 3.4428105, 3.4600246, 3.4773247, 3.4947113, 3.5121849,
         3.5297458, 3.5473945, 3.5651315, 3.5829572, 3.6008719, 3.6188763, 3.6369707, 3.6551555, 3.6734313, 3.6917985,
         3.7102575, 3.7288088, 3.7474528, 3.7661901, 3.785021, 3.8039461, 3.8229659, 3.8420807, 3.8612911, 3.8805975,
         3.9000005, 3.9195005, 3.939098, 3.9587935, 3.9785875, 3.9984804, 4.0184728, 4.0385652, 4.058758, 4.0790518,
         4.0994471, 4.1199443, 4.140544, 4.1612467, 4.182053, 4.2029632, 4.2239781, 4.245098, 4.2663234, 4.2876551,
         4.3090933, 4.3306388, 4.352292, 4.3740535, 4.3959237, 4.4179033, 4.4399929, 4.4621928, 4.4845038, 4.5069263,
         4.5294609, 4.5521082, 4.5748688, 4.5977431, 4.6207318, 4.6438355, 4.6670547, 4.69039, 4.7138419, 4.7374111,
         4.7610982, 4.7849037, 4.8088282, 4.8328723, 4.8570367, 4.8813219, 4.9057285, 4.9302571, 4.9549084, 4.9796829,
         5.0045814, 5.0296043, 5.0547523, 5.080026, 5.1054262, 5.1309533, 5.1566081, 5.1823911, 5.2083031, 5.2343446,
         5.2605163, 5.2868189, 5.313253, 5.3398192, 5.3665183, 5.3933509, 5.4203177, 5.4474193, 5.4746564, 5.5020297,
         5.5295398, 5.5571875, 5.5849734, 5.6128983, 5.6409628, 5.6691676, 5.6975135, 5.726001, 5.754631, 5.7834042,
         5.8123212, 5.8413828, 5.8705897, 5.8999427, 5.9294424, 5.9590896, 5.988885, 6.0188295, 6.0489236, 6.0791682,
         6.1095641, 6.1401119, 6.1708125, 6.2016665, 6.2326749, 6.2638382, 6.2951574, 6.3266332, 6.3582664, 6.3900577,
         6.422008, 6.454118, 6.4863886, 6.5188206, 6.5514147, 6.5841717, 6.915365, 7.392525, 7.902609, 8.44789,
         9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.40464, 12.60708, 12.64514, 12.72109, 12.91096, 13.47697,
         14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676,
         30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927,
         62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587,
         130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699,
         271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [7.1217, 7.11201, 7.10091, 7.08817, 7.07355, 7.05677, 7.0375, 7.01534, 6.98983, 6.96044, 6.92655, 6.88738,
         6.84205, 6.78948, 6.72835, 6.65705, 6.57359, 6.47542, 6.3593, 6.2209, 6.0543, 5.85093, 5.59743, 5.26996,
         4.81237, 4.28445, 3.91211, 3.42611, 3.79296, 3.87146, 3.62586, 3.11653, 2.60474, 2.15098, 1.81009, 1.6304,
         1.64914, 1.88864, 2.35448, 3.03577, 3.90686, 4.92969, 6.05516, 7.21906, 8.30675, 8.64723, 8.63184, 8.38352,
         8.77941, 9.21656, 9.2596, 9.49061, 9.44902, 9.71715, 10.1672, 10.8049, 12.2345, 13.5635, 14.7764, 15.5251,
         15.5403, 15.5218, 15.2643, 15.7024, 16.2554, 17.2195, 18.5115, 19.6545, 20.6785, 21.5921, 22.4007, 23.1097,
         23.7249, 24.2525, 24.6988, 25.0701, 25.377, 25.6153, 25.7945, 25.9182, 25.9889, 26.0077, 25.9709, 25.8757,
         25.7157, 26.049, 26.0344, 26.0195, 26.0042, 25.9885, 25.9723, 25.9558, 25.9388, 25.9214, 25.9036, 25.8853,
         25.8666, 25.8475, 25.8279, 25.8078, 25.7872, 25.7662, 25.7447, 25.7227, 25.7002, 25.6772, 25.6537, 25.6296,
         25.6045, 25.5785, 25.5515, 25.5236, 25.4946, 25.4647, 25.4338, 25.4018, 25.3689, 25.3349, 25.2998, 25.2637,
         25.2264, 25.1879, 25.1482, 25.1072, 25.0649, 25.0213, 24.9764, 24.93, 24.8821, 24.8328, 24.782, 24.7295,
         24.6754, 24.6197, 24.5621, 24.5027, 24.4414, 24.3781, 24.3127, 24.2451, 24.1752, 24.1029, 24.0281, 23.9506,
         23.8704, 23.7872, 23.7008, 23.6111, 23.5179, 23.4209, 23.3199, 23.2146, 23.1047, 22.9898, 22.8696, 22.7437,
         22.6114, 22.4723, 22.3258, 22.1711, 22.0073, 21.8335, 21.6486, 21.4512, 21.2397, 21.0122, 20.7662, 20.4989,
         20.2066, 19.8845, 19.5263, 19.1236, 18.6644, 18.1311, 17.4959, 16.7115, 15.6854, 14.1918, 11.3302, 0.959582,
         0.798914, 9.23944, 13.0471, 14.3962, 14.9963, 14.9826, 13.1496, 9.84436, 9.79284, 15.5867, 17.2959, 18.3878,
         19.226, 19.9166, 20.507, 21.0233, 21.4817, 21.8929, 22.2641, 22.6008, 22.9069, 23.185, 23.4368, 23.6634,
         23.8645, 24.0389, 24.1834, 24.2915, 24.3501, 24.3277, 24.1226, 23.2318, 20.853, 23.2748, 24.5031, 25.119,
         25.5503, 25.902, 26.2073, 26.4811, 26.7317, 26.9639, 27.1809, 27.3848, 27.5781, 27.7624, 27.9384, 28.107,
         28.2688, 28.4245, 28.5744, 28.7191, 28.859, 28.9943, 29.1253, 29.2525, 29.376, 29.4961, 29.6128, 29.726,
         29.8359, 29.9427, 30.0466, 30.1477, 30.246, 30.3416, 30.4345, 30.5249, 30.613, 30.6988, 30.7824, 30.8638,
         30.9433, 31.0208, 31.0964, 31.1702, 31.2423, 31.3127, 31.3815, 31.4487, 31.5144, 31.5787, 31.6416, 31.7031,
         31.7634, 31.8225, 31.8805, 31.937, 31.992, 32.0458, 32.0982, 32.1494, 32.1994, 32.2482, 32.2959, 32.3425,
         32.388, 32.4325, 32.476, 32.5185, 32.5601, 32.6007, 32.6404, 32.6792, 32.7172, 32.7543, 32.7906, 32.8261,
         32.8608, 32.8947, 32.9279, 32.9604, 32.9922, 33.0232, 33.0536, 33.0834, 33.1125, 33.1409, 33.1688, 33.196,
         33.2227, 33.2488, 33.2743, 33.2993, 33.3238, 33.3478, 33.3712, 33.3942, 33.4167, 33.4388, 33.4604, 33.4816,
         33.5024, 33.5228, 33.5427, 33.5624, 33.5816, 33.6006, 33.6192, 33.6375, 33.6555, 33.6732, 33.6907, 33.708,
         33.8286, 33.8455, 33.8621, 33.8785, 33.8948, 33.911, 33.9811, 33.9974, 34.014, 34.0286, 34.0413, 34.0534,
         34.0649, 34.0758, 34.0862, 34.0961, 34.1055, 34.1144, 34.1229, 34.131, 34.1387, 34.146, 34.1529, 34.1594,
         34.1657, 34.1715, 34.1771, 34.1824, 34.2289, 34.2338, 34.2383, 34.2424, 34.2462, 34.2496, 34.2527, 34.2555,
         34.258, 34.2602, 34.2621, 34.2637, 34.2651, 34.2662, 34.2671, 34.2678, 34.2682, 34.2684, 34.2684, 34.2682,
         34.2678, 34.2671, 34.2663, 34.2654, 34.2642, 34.2629, 34.2614, 34.2597, 34.2579, 34.2559, 34.2538, 34.2516,
         34.2492, 34.2466, 34.244, 34.2412, 34.2382, 34.2352, 34.232, 34.2288, 34.2254, 34.2219, 34.2183, 34.2146,
         34.2108, 34.2069, 34.2029, 34.1989, 34.1947, 34.1905, 34.1861, 34.1817, 34.1772, 34.1727, 34.168, 34.1633,
         34.1586, 34.1537, 34.1488, 34.1438, 34.1388, 34.1337, 34.1285, 34.1233, 34.118, 34.1127, 34.1073, 34.1018,
         34.0963, 34.0908, 34.0852, 34.0795, 34.0738, 34.0681, 34.0623, 34.0565, 34.0507, 34.0448, 34.0389, 34.0329,
         34.0269, 34.0209, 34.0148, 34.0087, 34.0026, 33.9964, 33.9903, 33.9841, 33.9778, 33.9716, 33.9653, 33.959,
         33.9527, 33.9463, 33.94, 33.9336, 33.9272, 33.9207, 33.9143, 33.9078, 33.9014, 33.8949, 33.8884, 33.8819,
         33.8753, 33.8688, 33.8623, 33.8557, 33.8491, 33.8425, 33.8359, 33.8293, 33.8227, 33.8161, 33.8095, 33.8029,
         33.7963, 33.7896, 33.783, 33.7764, 33.7697, 33.7631, 33.7565, 33.7498, 33.7432, 33.7366, 33.7299, 33.7233,
         33.7167, 33.71, 33.7033, 33.6966, 33.6898, 33.683, 33.6761, 33.6692, 33.6622, 33.6552, 33.6482, 33.5926,
         33.4882, 33.3744, 33.2495, 33.1131, 32.9468, 32.7281, 32.4168, 31.8669, 30.7234, 29.1062, 27.6562, 29.3734,
         30.9258, 32.2506, 33.0616, 33.5009, 33.7958, 34.0028, 34.1433, 34.2391, 34.3029, 34.3439, 34.3689, 34.4192,
         34.4238, 34.4171, 34.4042, 34.3873, 34.368, 34.3473, 34.326, 34.3046, 34.2837, 34.2635, 34.2444, 34.2261,
         34.2081, 34.191, 34.1749, 34.1598, 34.1459, 34.1328, 34.1207, 34.1094, 34.099, 34.0895, 34.0808, 34.0729,
         34.0657, 34.0591, 34.0531, 34.0477, 34.0429, 34.0385, 34.0345, 34.0309, 34.0277, 34.0248, 34.0221, 34.0198,
         34.0177, 34.0158, 34.0141, 34.0126, 34.0112, 34.01],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
         0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.54255, 0.60226, 0.83607, 1.3253, 1.9914, 2.8356, 3.8477, 5.0006, 6.2528,
         7.5533, 8.8472, 10.081, 11.208, 12.19, 13.0, 13.623, 14.052, 14.177, 14.229, 14.242, 14.871, 14.928, 14.935,
         14.986, 15.0, 15.287, 15.345, 15.433, 15.564, 15.559, 15.427, 15.243, 15.181, 15.177, 15.158, 15.777, 15.71,
         15.497, 15.073, 14.566, 13.993, 13.372, 12.719, 12.047, 11.368, 10.691, 10.025, 9.376, 8.7484, 8.1457, 7.5704,
         7.0238, 6.5064, 6.017, 5.556, 5.1241, 4.7216, 4.5539, 4.5259, 4.4981, 4.4705, 4.443, 4.4157, 4.3885, 4.3615,
         4.3347, 4.308, 4.2815, 4.2551, 4.2289, 4.2029, 4.177, 4.1513, 4.1257, 4.1003, 4.075, 4.0499, 4.025, 4.0002,
         3.9699, 3.9392, 3.9086, 3.8784, 3.8484, 3.8186, 3.7891, 3.7599, 3.7309, 3.7021, 3.6736, 3.6453, 3.6166, 3.5868,
         3.5572, 3.5278, 3.4988, 3.47, 3.4415, 3.4133, 3.3853, 3.3576, 3.3302, 3.303, 3.276, 3.2494, 3.2229, 3.1967,
         3.1708, 3.1451, 3.1196, 3.0944, 3.0694, 3.0447, 3.0201, 2.9958, 2.9717, 2.9479, 2.9242, 2.9008, 2.8776, 2.8546,
         2.8318, 2.8093, 2.7869, 2.7647, 2.7428, 2.721, 2.6995, 2.6781, 2.6569, 2.6359, 2.6152, 2.5946, 2.5741, 2.5539,
         2.5339, 2.514, 2.4943, 2.4748, 2.4555, 2.4363, 2.4173, 2.3985, 2.3799, 2.3614, 2.3431, 2.3249, 2.3069, 2.2891,
         2.2714, 2.2539, 2.243, 11.542, 11.512, 11.42, 11.329, 11.238, 11.149, 11.06, 11.043, 15.634, 15.539, 15.416,
         15.293, 15.172, 15.052, 14.932, 14.814, 14.696, 14.58, 14.464, 14.35, 14.236, 14.123, 14.011, 13.9, 13.79,
         13.681, 13.573, 13.465, 13.359, 13.253, 13.148, 13.062, 13.044, 14.94, 14.848, 14.737, 14.627, 14.518, 14.41,
         14.302, 14.196, 14.09, 13.985, 13.882, 13.78, 13.679, 13.579, 13.481, 13.383, 13.285, 13.189, 13.093, 12.999,
         12.905, 12.812, 12.719, 12.628, 12.537, 12.446, 12.355, 12.264, 12.175, 12.086, 11.997, 11.909, 11.821, 11.733,
         11.647, 11.561, 11.476, 11.391, 11.307, 11.224, 11.141, 11.059, 10.978, 10.897, 10.817, 10.737, 10.658, 10.58,
         10.502, 10.425, 10.348, 10.272, 10.196, 10.121, 10.045, 9.9697, 9.895, 9.8209, 9.7473, 9.6742, 9.6016, 9.5296,
         9.4581, 9.3871, 9.3166, 9.2467, 9.1772, 9.1083, 9.0399, 8.9719, 8.9045, 8.8376, 8.7711, 8.7052, 8.6397, 8.5747,
         8.5102, 8.4462, 8.3826, 8.3195, 8.2569, 8.1948, 8.1331, 8.0719, 8.0112, 7.9509, 7.8911, 7.8317, 7.7728, 7.7143,
         7.6562, 7.5986, 7.5415, 7.4848, 7.4285, 7.3726, 7.3172, 7.2622, 7.2076, 7.1535, 7.0998, 7.0464, 6.9935, 6.9411,
         6.889, 6.8373, 6.786, 6.7352, 6.6847, 6.6346, 6.5849, 6.5352, 6.4853, 6.4357, 6.3865, 6.3377, 6.2893, 6.2408,
         6.1927, 6.1449, 6.0945, 6.0426, 5.9911, 5.9398, 5.8889, 5.8385, 5.7885, 5.739, 5.69, 5.6414, 5.5932, 5.5454,
         5.498, 5.451, 5.4045, 5.3584, 5.3127, 5.2674, 5.2226, 5.1781, 5.133, 5.0882, 5.0438, 4.9999, 4.9564, 4.9133,
         4.8705, 4.8282, 4.7862, 4.7447, 4.7035, 4.6627, 4.6223, 4.5823, 4.5426, 4.5033, 4.4643, 4.4257, 4.3875, 4.3496,
         4.3121, 4.2749, 4.238, 4.2015, 4.1653, 4.1295, 4.094, 4.0588, 4.0239, 3.9894, 3.9551, 3.9212, 3.8876, 3.8543,
         3.8213, 3.7886, 3.7562, 3.7241, 3.6923, 3.6607, 3.6295, 3.5986, 3.5679, 3.5375, 3.5074, 3.4775, 3.448, 3.4187,
         3.3896, 3.3609, 3.3324, 3.3041, 3.2761, 3.2484, 3.2209, 3.1935, 3.1664, 3.1395, 3.1129, 3.0865, 3.0604, 3.0345,
         3.0088, 2.9834, 2.9582, 2.9332, 2.9085, 2.8839, 2.8596, 2.8355, 2.8117, 2.788, 2.7645, 2.7413, 2.7183, 2.6955,
         2.6729, 2.6504, 2.6282, 2.6062, 2.5844, 2.5628, 2.5414, 2.5201, 2.4991, 2.4782, 2.4576, 2.4371, 2.4168, 2.3967,
         2.3767, 2.3569, 2.3374, 2.3179, 2.2987, 2.2796, 2.2607, 2.242, 2.2234, 2.205, 2.1868, 2.1687, 2.1508, 2.1331,
         2.1155, 2.098, 2.0807, 2.0636, 2.0466, 2.0298, 2.0131, 1.9966, 1.9802, 1.9639, 1.9478, 1.9319, 1.9161, 1.9004,
         1.8848, 1.8694, 1.8542, 1.839, 1.824, 1.8092, 1.7944, 1.7798, 1.7651, 1.7502, 1.7354, 1.7207, 1.7061, 1.6917,
         1.6772, 1.6628, 1.6485, 1.6343, 1.6203, 1.6064, 1.4764, 1.3147, 1.1689, 1.0402, 0.92336, 0.8104, 0.71195,
         0.62607, 0.55107, 0.50063, 0.48552, 0.48276, 3.7868, 3.6719, 3.3722, 3.0123, 2.7116, 2.4478, 2.1904, 1.9566,
         1.7451, 1.5552, 1.3856, 1.2347, 1.0988, 0.97157, 0.85771, 0.75718, 0.66844, 0.5899, 0.52047, 0.45925, 0.40525,
         0.35762, 0.31561, 0.27856, 0.24442, 0.21442, 0.18812, 0.16505, 0.14481, 0.12692, 0.11097, 0.097022, 0.084831,
         0.074175, 0.06486, 0.056717, 0.049598, 0.043374, 0.037932, 0.033174, 0.029014, 0.025376, 0.022195, 0.019413,
         0.016981, 0.014853, 0.012993, 0.011366, 0.0099429, 0.0086982, 0.0076096, 0.0066574, 0.0058245, 0.0050959,
         0.0044586]],
    'Br':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.06477028, 0.06762, 0.068698, 0.068931, 0.06923942, 0.069345, 0.0697495, 0.0700299, 0.07038, 0.0704505,
         0.071502, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797,
         0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.17787, 0.1805925, 0.1813185, 0.1824075,
         0.18513, 0.185514, 0.1883732, 0.1891107, 0.1902465, 0.193086, 0.2013709, 0.2152655, 0.2301188, 0.245997,
         0.25137, 0.2552175, 0.2562435, 0.2577825, 0.26163, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143,
         0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609,
         0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9, 0.9045, 0.9090225, 0.91356761, 0.91813545, 0.92272613,
         0.92733976, 0.93197646, 0.93663634, 0.94131952, 0.94602612, 0.95075625, 0.95551003, 0.96028758, 0.96508902,
         0.96991446, 0.97476404, 0.97963786, 0.98453605, 0.98945873, 0.99440602, 0.99937805, 1.0043749, 1.0093968,
         1.0144438, 1.019516, 1.0246136, 1.0297367, 1.0348853, 1.0400598, 1.0452601, 1.0504864, 1.0557388, 1.0610175,
         1.0663226, 1.0716542, 1.0770125, 1.0823975, 1.0878095, 1.0932486, 1.0987148, 1.1042084, 1.1097294, 1.1152781,
         1.1208545, 1.1264587, 1.132091, 1.1377515, 1.1434402, 1.1491574, 1.1549032, 1.1606777, 1.1664811, 1.1723135,
         1.1781751, 1.184066, 1.1899863, 1.1959362, 1.2019159, 1.2079255, 1.2139651, 1.220035, 1.2261351, 1.2322658,
         1.2384271, 1.2446193, 1.2508424, 1.2570966, 1.2633821, 1.269699, 1.2760475, 1.2824277, 1.2888399, 1.295284,
         1.3017605, 1.3082693, 1.3148106, 1.3213847, 1.3279916, 1.3346316, 1.3413047, 1.3480112, 1.3547513, 1.361525,
         1.3683327, 1.3751743, 1.3820502, 1.3889605, 1.3959053, 1.4028848, 1.4098992, 1.4169487, 1.4240335, 1.4311536,
         1.4383094, 1.4455009, 1.4527284, 1.4599921, 1.467292, 1.4746285, 1.4820016, 1.4894117, 1.4968587, 1.504343,
         1.5118647, 1.519424, 1.5270212, 1.5346563, 1.5423295, 1.5497311, 1.5500412, 1.550069, 1.5577914, 1.5655804,
         1.5734083, 1.5812753, 1.5891817, 1.5958196, 1.5961803, 1.5971276, 1.6051132, 1.6131388, 1.6212045, 1.6293105,
         1.6374571, 1.6456443, 1.6538726, 1.6621419, 1.6704526, 1.6788049, 1.6871989, 1.6956349, 1.7041131, 1.7126337,
         1.7211968, 1.7298028, 1.7384518, 1.7471441, 1.7558798, 1.7646592, 1.7734825, 1.7804852, 1.7823499, 1.7835146,
         1.7912617, 1.800218, 1.8092191, 1.8182652, 1.8273565, 1.8364933, 1.8456757, 1.8549041, 1.8641786, 1.8734995,
         1.882867, 1.8922814, 1.9017428, 1.9112515, 1.9208077, 1.9304118, 1.9400638, 1.9497642, 1.959513, 1.9693105,
         1.9791571, 1.9890529, 1.9989981, 2.0089931, 2.0190381, 2.0291333, 2.039279, 2.0494754, 2.0597227, 2.0700213,
         2.0803714, 2.0907733, 2.1012272, 2.1117333, 2.122292, 2.1329034, 2.143568, 2.1542858, 2.1650572, 2.1758825,
         2.1867619, 2.1976957, 2.2086842, 2.2197276, 2.2308263, 2.2419804, 2.2531903, 2.2644562, 2.2757785, 2.2871574,
         2.2985932, 2.3100862, 2.3216366, 2.3332448, 2.344911, 2.3566356, 2.3684187, 2.3802608, 2.3921621, 2.404123,
         2.4161436, 2.4282243, 2.4403654, 2.4525672, 2.4648301, 2.4771542, 2.48954, 2.5019877, 2.5144976, 2.5270701,
         2.5397055, 2.552404, 2.565166, 2.5779919, 2.5908818, 2.6038362, 2.6168554, 2.6299397, 2.6430894, 2.6563048,
         2.6695863, 2.6829343, 2.6963489, 2.7098307, 2.7233798, 2.7369967, 2.7506817, 2.7644351, 2.7782573, 2.7921486,
         2.8061093, 2.8201399, 2.8342406, 2.8484118, 2.8626539, 2.8769671, 2.891352, 2.9058087, 2.9203378, 2.9349394,
         2.9496141, 2.9643622, 2.979184, 2.9940799, 3.0090503, 3.0240956, 3.0392161, 3.0544122, 3.0696842, 3.0850326,
         3.1004578, 3.1159601, 3.1315399, 3.1471976, 3.1629336, 3.1787482, 3.194642, 3.2106152, 3.2266683, 3.2428016,
         3.2590156, 3.2753107, 3.2916873, 3.3081457, 3.3246864, 3.3413099, 3.3580164, 3.3748065, 3.3916805, 3.4086389,
         3.4256821, 3.4428105, 3.4600246, 3.4773247, 3.4947113, 3.5121849, 3.5297458, 3.5473945, 3.5651315, 3.5829572,
         3.6008719, 3.6188763, 3.6369707, 3.6551555, 3.6734313, 3.6917985, 3.7102575, 3.7288088, 3.7474528, 3.7661901,
         3.785021, 3.8039461, 3.8229659, 3.8420807, 3.8612911, 3.8805975, 3.9000005, 3.9195005, 3.939098, 3.9587935,
         3.9785875, 3.9984804, 4.0184728, 4.0385652, 4.058758, 4.0790518, 4.0994471, 4.1199443, 4.140544, 4.1612467,
         4.182053, 4.2029632, 4.2239781, 4.245098, 4.2663234, 4.2876551, 4.3090933, 4.3306388, 4.352292, 4.3740535,
         4.3959237, 4.4179033, 4.4399929, 4.4621928, 4.4845038, 4.5069263, 4.5294609, 4.5521082, 4.5748688, 4.5977431,
         4.6207318, 4.6438355, 4.6670547, 4.69039, 4.7138419, 4.7374111, 4.7610982, 4.7849037, 4.8088282, 4.8328723,
         4.8570367, 4.8813219, 4.9057285, 4.9302571, 4.9549084, 4.9796829, 5.0045814, 5.0296043, 5.0547523, 5.080026,
         5.1054262, 5.1309533, 5.1566081, 5.1823911, 5.2083031, 5.2343446, 5.2605163, 5.2868189, 5.313253, 5.3398192,
         5.3665183, 5.3933509, 5.4203177, 5.4474193, 5.4746564, 5.5020297, 5.5295398, 5.5571875, 5.5849734, 5.6128983,
         5.6409628, 5.6691676, 5.6975135, 5.726001, 5.754631, 5.7834042, 5.8123212, 5.8413828, 5.8705897, 5.8999427,
         5.9294424, 5.9590896, 5.988885, 6.0188295, 6.0489236, 6.0791682, 6.1095641, 6.1401119, 6.1708125, 6.2016665,
         6.2326749, 6.2638382, 6.2951574, 6.3266332, 6.3582664, 6.3900577, 6.422008, 6.454118, 6.4863886, 6.5188206,
         6.5514147, 6.5841717, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334,
         12.60708, 13.20423, 13.40633, 13.46023, 13.47697, 13.54107, 13.74317, 14.40688, 15.40095, 16.46362, 17.59961,
         18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551,
         39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578,
         81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356,
         170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294,
         354.4049, 378.8588, 405.0001, 432.9451],
        [7.92654, 7.91924, 7.91088, 7.90131, 7.89034, 7.87777, 7.86335, 7.8468, 7.82781, 7.80599, 7.7809, 7.75202,
         7.71875, 7.68036, 7.63602, 7.58469, 7.52515, 7.45592, 7.37517, 7.28066, 7.16951, 7.03807, 6.88151, 6.69323,
         6.46382, 6.17882, 5.81322, 5.31115, 4.81939, 4.4921, 4.31259, 4.34562, 4.35127, 4.30405, 4.18899, 4.2295,
         4.23437, 4.18378, 3.89155, 3.19834, 2.50987, 1.91726, 1.50831, 1.35641, 1.50912, 1.98211, 2.75914, 3.79675,
         5.03081, 6.38104, 7.74433, 8.90219, 8.99692, 8.93602, 8.59461, 9.1103, 9.71976, 9.77847, 10.0811, 10.0116,
         10.3475, 10.8833, 12.0378, 13.6565, 15.1121, 16.3544, 16.6405, 16.6393, 16.3641, 16.8336, 17.4254, 17.5748,
         19.1091, 20.3881, 21.5199, 22.522, 23.4034, 24.1723, 24.8364, 25.4036, 25.8819, 26.2785, 26.6073, 26.8654,
         27.0567, 27.1895, 27.2671, 27.2913, 27.2621, 27.1732, 27.4506, 27.4412, 27.4315, 27.4215, 27.4111, 27.4004,
         27.3893, 27.3778, 27.3661, 27.3539, 27.3414, 27.3285, 27.3153, 27.3017, 27.2877, 27.2733, 27.2586, 27.2434,
         27.2279, 27.2119, 27.1956, 27.1788, 27.1723, 27.1649, 27.1553, 27.1437, 27.1305, 27.1157, 27.0996, 27.0821,
         27.0634, 27.0435, 27.0225, 27.0005, 26.9775, 26.9534, 26.9284, 26.9024, 26.8754, 26.8475, 26.8187, 26.7889,
         26.7582, 26.7266, 26.694, 26.6604, 26.6258, 26.5903, 26.5538, 26.5162, 26.4775, 26.4378, 26.397, 26.3551,
         26.312, 26.2677, 26.2222, 26.1754, 26.1273, 26.0778, 26.0269, 25.9746, 25.9207, 25.8653, 25.8082, 25.7494,
         25.6889, 25.6264, 25.562, 25.4956, 25.427, 25.3562, 25.283, 25.2072, 25.1289, 25.0477, 24.9634, 24.8761,
         24.7853, 24.6908, 24.5925, 24.4901, 24.3832, 24.2716, 24.1549, 24.0326, 23.9044, 23.7696, 23.6277, 23.4781,
         23.3198, 23.1521, 22.9739, 22.7839, 22.5806, 22.3623, 22.1268, 21.8715, 21.5929, 21.2869, 20.9478, 20.5681,
         20.1376, 19.641, 19.0553, 18.3419, 17.4295, 16.1588, 14.0202, 2.83862, 2.15632, 2.68037, 13.7486, 15.5172,
         16.3532, 16.6565, 16.2799, 11.5761, 11.5274, 14.2378, 17.776, 19.1375, 20.0886, 20.8413, 21.4709, 22.0139,
         22.4914, 22.9166, 23.2986, 23.6436, 23.9561, 24.2392, 24.495, 24.7245, 24.9278, 25.1036, 25.2488, 25.3568,
         25.4137, 25.387, 25.1675, 24.2756, 23.3907, 24.3169, 25.6026, 26.2089, 26.6377, 26.9884, 27.2932, 27.5667,
         27.8169, 28.0486, 28.2649, 28.4681, 28.6607, 28.8442, 29.0195, 29.1874, 29.3485, 29.5034, 29.6527, 29.7967,
         29.9357, 30.0703, 30.2006, 30.327, 30.4497, 30.5691, 30.6852, 30.7978, 30.907, 31.0132, 31.1164, 31.2169,
         31.3147, 31.4098, 31.5023, 31.5922, 31.6798, 31.765, 31.8481, 31.9291, 32.0081, 32.0851, 32.1603, 32.2336,
         32.3052, 32.3752, 32.4435, 32.5103, 32.5755, 32.6394, 32.7018, 32.7629, 32.8227, 32.8814, 32.9389, 32.9949,
         33.0495, 33.1028, 33.1548, 33.2056, 33.2552, 33.3037, 33.351, 33.3972, 33.4424, 33.4866, 33.5297, 33.5719,
         33.6131, 33.6534, 33.6928, 33.7314, 33.769, 33.8059, 33.8419, 33.8771, 33.9116, 33.9453, 33.9783, 34.0105,
         34.0421, 34.073, 34.1032, 34.1328, 34.1617, 34.19, 34.2177, 34.2449, 34.2715, 34.2975, 34.323, 34.348, 34.3725,
         34.3964, 34.42, 34.4431, 34.4657, 34.4879, 34.5098, 34.5312, 34.5523, 34.5731, 34.5937, 34.6139, 34.6341,
         34.6541, 34.6779, 34.7003, 34.7205, 34.7395, 34.7576, 34.7751, 34.8925, 34.9089, 34.9247, 34.9397, 34.9542,
         34.9681, 35.0325, 35.0453, 35.0576, 35.0692, 35.0803, 35.0908, 35.1008, 35.1104, 35.1195, 35.1282, 35.1365,
         35.1443, 35.1518, 35.159, 35.1658, 35.1722, 35.1783, 35.1841, 35.1896, 35.1948, 35.1998, 35.2045, 35.2495,
         35.2539, 35.2579, 35.2616, 35.2649, 35.2678, 35.2705, 35.2728, 35.2749, 35.2767, 35.2782, 35.2794, 35.2804,
         35.2812, 35.2817, 35.282, 35.2821, 35.2819, 35.2816, 35.281, 35.2803, 35.2794, 35.2783, 35.277, 35.2755,
         35.2739, 35.2722, 35.2702, 35.2681, 35.2659, 35.2635, 35.261, 35.2584, 35.2556, 35.2527, 35.2497, 35.2466,
         35.2433, 35.2399, 35.2364, 35.2329, 35.2292, 35.2254, 35.2215, 35.2175, 35.2134, 35.2093, 35.205, 35.2007,
         35.1963, 35.1918, 35.1872, 35.1826, 35.1779, 35.1731, 35.1682, 35.1633, 35.1583, 35.1533, 35.1482, 35.143,
         35.1378, 35.1325, 35.1272, 35.1218, 35.1164, 35.1109, 35.1053, 35.0997, 35.0941, 35.0884, 35.0826, 35.0769,
         35.0711, 35.0652, 35.0593, 35.0534, 35.0474, 35.0414, 35.0353, 35.0293, 35.0232, 35.017, 35.0109, 35.0047,
         34.9984, 34.9922, 34.9859, 34.9796, 34.9733, 34.9669, 34.9606, 34.9542, 34.9478, 34.9413, 34.9349, 34.9284,
         34.9219, 34.9154, 34.9089, 34.9024, 34.8958, 34.8892, 34.8827, 34.8761, 34.8695, 34.8629, 34.8562, 34.8496,
         34.843, 34.8363, 34.8297, 34.823, 34.8163, 34.8096, 34.8029, 34.7963, 34.7896, 34.7829, 34.7762, 34.7695,
         34.7628, 34.7561, 34.7494, 34.6965, 34.5988, 34.4956, 34.3844, 34.2667, 34.1242, 33.9494, 33.7255, 33.4058,
         32.8304, 31.7466, 30.3664, 28.7, 27.1626, 30.4042, 31.945, 33.3364, 34.1052, 34.5298, 34.8171, 35.0169,
         35.1527, 35.2451, 35.3066, 35.3461, 35.3706, 35.4243, 35.4242, 35.4156, 35.4016, 35.3841, 35.3646, 35.3438,
         35.3225, 35.3012, 35.2804, 35.2604, 35.2416, 35.2234, 35.2057, 35.1888, 35.1728, 35.158, 35.1442, 35.1312,
         35.1191, 35.108, 35.0977, 35.0883, 35.0798, 35.0719, 35.0648, 35.0583, 35.0524, 35.0471, 35.0423, 35.038,
         35.034, 35.0305, 35.0273, 35.0245, 35.0219, 35.0196, 35.0175, 35.0156, 35.0139, 35.0124, 35.0111],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
         0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.28116, 0.28479, 0.2991, 0.30939, 0.50909, 0.51341, 0.58193,
         0.77949, 1.3532, 2.1831, 3.2703, 4.5908, 6.0881, 7.6828, 9.2846, 10.806, 12.171, 13.325, 14.233, 14.882,
         15.273, 15.308, 15.355, 15.366, 16.196, 16.253, 16.26, 16.308, 16.318, 16.685, 16.73, 16.812, 16.809, 16.649,
         16.352, 16.231, 16.139, 16.114, 16.768, 16.676, 16.643, 16.171, 15.613, 14.981, 14.297, 13.578, 12.841, 12.099,
         11.362, 10.638, 9.934, 9.2552, 8.6047, 7.9851, 7.3977, 6.8432, 6.3209, 5.8297, 5.3703, 5.1786, 5.1467, 5.1149,
         5.0832, 5.0518, 5.0206, 4.9895, 4.9586, 4.9279, 4.8974, 4.867, 4.8368, 4.8068, 4.777, 4.7474, 4.718, 4.6887,
         4.6596, 4.6307, 4.6019, 4.5734, 4.545, 4.5108, 4.4761, 4.4416, 4.4075, 4.3736, 4.3396, 4.3058, 4.2722, 4.239,
         4.206, 4.1733, 4.1409, 4.1088, 4.0769, 4.0454, 4.0141, 3.983, 3.9523, 3.9217, 3.8915, 3.8615, 3.8318, 3.8023,
         3.7731, 3.7441, 3.7153, 3.6869, 3.6586, 3.6306, 3.6028, 3.5753, 3.548, 3.5209, 3.4941, 3.4675, 3.4411, 3.4149,
         3.389, 3.3633, 3.3377, 3.3124, 3.2874, 3.2625, 3.2378, 3.2134, 3.1891, 3.1651, 3.1412, 3.1176, 3.0941, 3.0709,
         3.0478, 3.024, 3.0004, 2.9769, 2.9532, 2.9295, 2.9061, 2.8828, 2.8598, 2.837, 2.8144, 2.792, 2.7699, 2.7479,
         2.7261, 2.7046, 2.6832, 2.662, 2.6411, 2.6203, 2.5997, 2.5793, 2.5591, 2.539, 2.5192, 2.4995, 2.48, 2.4607,
         2.4415, 2.4226, 2.4038, 2.3852, 2.3667, 2.3484, 2.3303, 2.3123, 2.2952, 11.454, 11.454, 11.363, 11.272, 11.182,
         11.093, 11.004, 10.931, 15.45, 15.435, 15.313, 15.191, 15.071, 14.951, 14.832, 14.715, 14.598, 14.482, 14.367,
         14.254, 14.141, 14.029, 13.917, 13.807, 13.698, 13.589, 13.482, 13.375, 13.269, 13.164, 13.06, 12.979, 14.883,
         14.869, 14.771, 14.66, 14.55, 14.441, 14.332, 14.225, 14.118, 14.012, 13.907, 13.803, 13.702, 13.601, 13.502,
         13.404, 13.306, 13.209, 13.113, 13.018, 12.924, 12.83, 12.738, 12.646, 12.555, 12.465, 12.374, 12.284, 12.194,
         12.105, 12.016, 11.929, 11.841, 11.754, 11.667, 11.581, 11.496, 11.411, 11.327, 11.243, 11.16, 11.078, 10.997,
         10.916, 10.835, 10.756, 10.676, 10.598, 10.52, 10.442, 10.366, 10.289, 10.214, 10.138, 10.063, 9.9879, 9.9131,
         9.8389, 9.7652, 9.6921, 9.6195, 9.5474, 9.4758, 9.4048, 9.3342, 9.2642, 9.1947, 9.1257, 9.0572, 8.9892, 8.9217,
         8.8547, 8.7882, 8.7222, 8.6567, 8.5917, 8.5271, 8.4631, 8.3995, 8.3364, 8.2737, 8.2116, 8.1499, 8.0887, 8.0279,
         7.9676, 7.9078, 7.8484, 7.7895, 7.731, 7.673, 7.6155, 7.5583, 7.5017, 7.4454, 7.3896, 7.3342, 7.2793, 7.2248,
         7.1707, 7.1171, 7.0638, 7.011, 6.9586, 6.9066, 6.8551, 6.8016, 6.7472, 6.6931, 6.6395, 6.5864, 6.5337, 6.4813,
         6.4271, 6.3735, 6.3203, 6.2676, 6.2154, 6.1634, 6.1109, 6.0589, 6.0074, 5.9564, 5.9058, 5.8557, 5.806, 5.7568,
         5.7081, 5.6598, 5.612, 5.5645, 5.5176, 5.4707, 5.4242, 5.3782, 5.3326, 5.2874, 5.2426, 5.1983, 5.1543, 5.1106,
         5.0661, 5.0219, 4.9782, 4.9348, 4.8919, 4.8493, 4.8072, 4.7654, 4.724, 4.683, 4.6424, 4.6022, 4.5623, 4.5228,
         4.4836, 4.4448, 4.4064, 4.3683, 4.3306, 4.2932, 4.2562, 4.2195, 4.1831, 4.1471, 4.1114, 4.076, 4.041, 4.0063,
         3.9719, 3.9378, 3.904, 3.8705, 3.8374, 3.8045, 3.7719, 3.7397, 3.7077, 3.676, 3.6446, 3.6135, 3.5827, 3.5521,
         3.5219, 3.4919, 3.4622, 3.4327, 3.4035, 3.3746, 3.346, 3.3176, 3.2894, 3.2616, 3.2339, 3.2066, 3.1794, 3.1525,
         3.1259, 3.0995, 3.0733, 3.0474, 3.0216, 2.9961, 2.9707, 2.9456, 2.9207, 2.8961, 2.8716, 2.8474, 2.8234, 2.7996,
         2.7761, 2.7527, 2.7296, 2.7066, 2.6839, 2.6614, 2.639, 2.6169, 2.595, 2.5732, 2.5517, 2.5304, 2.5092, 2.4882,
         2.4675, 2.4469, 2.4265, 2.4062, 2.3862, 2.3663, 2.3466, 2.3271, 2.3078, 2.2886, 2.2696, 2.2508, 2.2321, 2.2136,
         2.1953, 2.1771, 2.1591, 2.1413, 2.1236, 2.1061, 2.0887, 2.0715, 2.0544, 2.0375, 2.0207, 2.0041, 1.9876, 1.9713,
         1.9551, 1.939, 1.9231, 1.9074, 1.8918, 1.8763, 1.8609, 1.8457, 1.8306, 1.8157, 1.8009, 1.6587, 1.4787, 1.3179,
         1.1723, 1.0403, 0.91328, 0.80257, 0.70596, 0.62158, 0.54782, 0.50214, 0.48804, 0.48439, 3.8023, 3.7655, 3.6529,
         3.3331, 2.9803, 2.6831, 2.4201, 2.165, 1.9335, 1.7246, 1.5372, 1.37, 1.2213, 1.0819, 0.95548, 0.84388, 0.74531,
         0.65825, 0.58121, 0.51301, 0.45284, 0.39976, 0.35293, 0.31159, 0.27507, 0.24139, 0.21184, 0.18592, 0.16317,
         0.14307, 0.12516, 0.10949, 0.095793, 0.08381, 0.073328, 0.064159, 0.056139, 0.049123, 0.042986, 0.037616,
         0.032918, 0.028808, 0.025212, 0.022066, 0.019312, 0.016903, 0.014795, 0.01295, 0.011335, 0.0099222, 0.0086856,
         0.0076033, 0.006656, 0.0058269, 0.0051012]],
    'Kr':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.087122, 0.0884555, 0.0888111, 0.0893445,
         0.09041995, 0.090678, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005,
         0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.209524, 0.212731, 0.2135862, 0.214869, 0.2152655, 0.218246,
         0.2215865, 0.2224773, 0.2238135, 0.227154, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.2825634, 0.2868883,
         0.2880417, 0.2897716, 0.2940966, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657,
         0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896,
         0.9, 0.9045, 0.9090225, 0.91356761, 0.91813545, 0.92272613, 0.92733976, 0.93197646, 0.93663634, 0.94131952,
         0.94602612, 0.95075625, 0.95551003, 0.96028758, 0.96508902, 0.96991446, 0.97476404, 0.97963786, 0.98453605,
         0.98945873, 0.99440602, 0.99937805, 1.0043749, 1.0093968, 1.0144438, 1.019516, 1.0246136, 1.0297367, 1.0348853,
         1.0400598, 1.0452601, 1.0504864, 1.0557388, 1.0610175, 1.0663226, 1.0716542, 1.0770125, 1.0823975, 1.0878095,
         1.0932486, 1.0987148, 1.1042084, 1.1097294, 1.1152781, 1.1208545, 1.1264587, 1.132091, 1.1377515, 1.1434402,
         1.1491574, 1.1549032, 1.1606777, 1.1664811, 1.1723135, 1.1781751, 1.184066, 1.1899863, 1.1959362, 1.2019159,
         1.2079255, 1.2139651, 1.220035, 1.2261351, 1.2322658, 1.2384271, 1.2446193, 1.2508424, 1.2570966, 1.2633821,
         1.269699, 1.2760475, 1.2824277, 1.2888399, 1.295284, 1.3017605, 1.3082693, 1.3148106, 1.3213847, 1.3279916,
         1.3346316, 1.3413047, 1.3480112, 1.3547513, 1.361525, 1.3683327, 1.3751743, 1.3820502, 1.3889605, 1.3959053,
         1.4028848, 1.4098992, 1.4169487, 1.4240335, 1.4311536, 1.4383094, 1.4455009, 1.4527284, 1.4599921, 1.467292,
         1.4746285, 1.4820016, 1.4894117, 1.4968587, 1.504343, 1.5118647, 1.519424, 1.5270212, 1.5346563, 1.5423295,
         1.5500412, 1.5577914, 1.5655804, 1.5734083, 1.5812753, 1.5891817, 1.5971276, 1.6051132, 1.6131388, 1.6212045,
         1.6293105, 1.6374571, 1.6456443, 1.6538726, 1.6621419, 1.6704526, 1.6747007, 1.6750994, 1.6788049, 1.6871989,
         1.6956349, 1.7041131, 1.7126337, 1.7211968, 1.7269841, 1.7274159, 1.7298028, 1.7384518, 1.7471441, 1.7558798,
         1.7646592, 1.7734825, 1.7823499, 1.7912617, 1.800218, 1.8092191, 1.8182652, 1.8273565, 1.8364933, 1.8456757,
         1.8549041, 1.8641786, 1.8734995, 1.882867, 1.8922814, 1.9017428, 1.9112515, 1.9194747, 1.9208077, 1.9225253,
         1.9304118, 1.9400638, 1.9497642, 1.959513, 1.9693105, 1.9791571, 1.9890529, 1.9989981, 2.0089931, 2.0190381,
         2.0291333, 2.039279, 2.0494754, 2.0597227, 2.0700213, 2.0803714, 2.0907733, 2.1012272, 2.1117333, 2.122292,
         2.1329034, 2.143568, 2.1542858, 2.1650572, 2.1758825, 2.1867619, 2.1976957, 2.2086842, 2.2197276, 2.2308263,
         2.2419804, 2.2531903, 2.2644562, 2.2757785, 2.2871574, 2.2985932, 2.3100862, 2.3216366, 2.3332448, 2.344911,
         2.3566356, 2.3684187, 2.3802608, 2.3921621, 2.404123, 2.4161436, 2.4282243, 2.4403654, 2.4525672, 2.4648301,
         2.4771542, 2.48954, 2.5019877, 2.5144976, 2.5270701, 2.5397055, 2.552404, 2.565166, 2.5779919, 2.5908818,
         2.6038362, 2.6168554, 2.6299397, 2.6430894, 2.6563048, 2.6695863, 2.6829343, 2.6963489, 2.7098307, 2.7233798,
         2.7369967, 2.7506817, 2.7644351, 2.7782573, 2.7921486, 2.8061093, 2.8201399, 2.8342406, 2.8484118, 2.8626539,
         2.8769671, 2.891352, 2.9058087, 2.9203378, 2.9349394, 2.9496141, 2.9643622, 2.979184, 2.9940799, 3.0090503,
         3.0240956, 3.0392161, 3.0544122, 3.0696842, 3.0850326, 3.1004578, 3.1159601, 3.1315399, 3.1471976, 3.1629336,
         3.1787482, 3.194642, 3.2106152, 3.2266683, 3.2428016, 3.2590156, 3.2753107, 3.2916873, 3.3081457, 3.3246864,
         3.3413099, 3.3580164, 3.3748065, 3.3916805, 3.4086389, 3.4256821, 3.4428105, 3.4600246, 3.4773247, 3.4947113,
         3.5121849, 3.5297458, 3.5473945, 3.5651315, 3.5829572, 3.6008719, 3.6188763, 3.6369707, 3.6551555, 3.6734313,
         3.6917985, 3.7102575, 3.7288088, 3.7474528, 3.7661901, 3.785021, 3.8039461, 3.8229659, 3.8420807, 3.8612911,
         3.8805975, 3.9000005, 3.9195005, 3.939098, 3.9587935, 3.9785875, 3.9984804, 4.0184728, 4.0385652, 4.058758,
         4.0790518, 4.0994471, 4.1199443, 4.140544, 4.1612467, 4.182053, 4.2029632, 4.2239781, 4.245098, 4.2663234,
         4.2876551, 4.3090933, 4.3306388, 4.352292, 4.3740535, 4.3959237, 4.4179033, 4.4399929, 4.4621928, 4.4845038,
         4.5069263, 4.5294609, 4.5521082, 4.5748688, 4.5977431, 4.6207318, 4.6438355, 4.6670547, 4.69039, 4.7138419,
         4.7374111, 4.7610982, 4.7849037, 4.8088282, 4.8328723, 4.8570367, 4.8813219, 4.9057285, 4.9302571, 4.9549084,
         4.9796829, 5.0045814, 5.0296043, 5.0547523, 5.080026, 5.1054262, 5.1309533, 5.1566081, 5.1823911, 5.2083031,
         5.2343446, 5.2605163, 5.2868189, 5.313253, 5.3398192, 5.3665183, 5.3933509, 5.4203177, 5.4474193, 5.4746564,
         5.5020297, 5.5295398, 5.5571875, 5.5849734, 5.6128983, 5.6409628, 5.6691676, 5.6975135, 5.726001, 5.754631,
         5.7834042, 5.8123212, 5.8413828, 5.8705897, 5.8999427, 5.9294424, 5.9590896, 5.988885, 6.0188295, 6.0489236,
         6.0791682, 6.1095641, 6.1401119, 6.1708125, 6.2016665, 6.2326749, 6.2638382, 6.2951574, 6.3266332, 6.3582664,
         6.3900577, 6.422008, 6.454118, 6.4863886, 6.5188206, 6.5514147, 6.5841717, 6.915365, 7.392525, 7.902609,
         8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.03909, 14.25397, 14.31127,
         14.40688, 14.61211, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645,
         28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721,
         58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931,
         121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835,
         253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [9.29037, 9.28534, 9.27958, 9.27298, 9.26544, 9.25679, 9.2469, 9.23556, 9.22256, 9.20767, 9.19057, 9.17096,
         9.14843, 9.12254, 9.09275, 9.05845, 9.0189, 8.97325, 8.92046, 8.85929, 8.78826, 8.70556, 8.60896, 8.49567,
         8.36216, 8.20386, 8.01472, 7.78638, 7.5068, 7.15722, 6.70431, 6.06764, 5.64666, 5.27889, 5.01683, 5.11898,
         5.09657, 5.07502, 4.30507, 3.35762, 2.47607, 1.80997, 1.49791, 1.63144, 2.23705, 3.27653, 4.66077, 6.26791,
         7.95392, 9.52269, 10.1694, 10.0543, 9.60025, 10.2597, 10.403, 11.0418, 11.4044, 11.3064, 11.7277, 12.3826,
         12.8377, 14.8064, 16.4724, 17.7817, 17.8453, 17.8572, 17.5673, 18.072, 18.7115, 19.3348, 20.866, 22.1571,
         23.2881, 24.2803, 25.1426, 25.885, 26.5175, 27.05, 27.4917, 27.851, 28.1356, 28.3463, 28.5005, 28.5971,
         28.6402, 28.6334, 28.882, 28.8793, 28.8765, 28.8735, 28.8703, 28.8669, 28.8633, 28.8596, 28.8558, 28.8519,
         28.8479, 28.8438, 28.8397, 28.8357, 28.8318, 28.828, 28.8245, 28.8214, 28.8188, 28.8169, 28.8161, 28.8167,
         28.8063, 28.7937, 28.7805, 28.7668, 28.7525, 28.7376, 28.7222, 28.7063, 28.6898, 28.6727, 28.6551, 28.637,
         28.6183, 28.5991, 28.5793, 28.5589, 28.5381, 28.5166, 28.4946, 28.472, 28.4488, 28.4251, 28.4007, 28.3758,
         28.3503, 28.3242, 28.2974, 28.2701, 28.242, 28.2134, 28.184, 28.1539, 28.1231, 28.0915, 28.0592, 28.0261,
         27.9923, 27.9576, 27.9222, 27.8858, 27.8487, 27.8106, 27.7716, 27.7317, 27.6908, 27.6489, 27.606, 27.562,
         27.517, 27.4707, 27.4234, 27.3748, 27.3249, 27.2737, 27.2211, 27.1672, 27.1117, 27.0547, 26.9961, 26.9358,
         26.8737, 26.8098, 26.7439, 26.676, 26.606, 26.5337, 26.4591, 26.3819, 26.3021, 26.2195, 26.1339, 26.0451,
         25.953, 25.8573, 25.7577, 25.654, 25.5459, 25.433, 25.315, 25.1914, 25.0618, 24.9256, 24.7821, 24.6308,
         24.4707, 24.3009, 24.1203, 23.9276, 23.7211, 23.4991, 23.2591, 22.9983, 22.7131, 22.3986, 22.0489, 21.6552,
         21.2058, 20.6827, 20.0577, 19.2819, 18.2574, 16.7363, 13.6146, 4.64497, 4.49118, 13.0021, 16.134, 17.3862,
         18.006, 18.1618, 17.5651, 13.239, 13.193, 16.8801, 19.4458, 20.6785, 21.5639, 22.272, 22.8675, 23.3827,
         23.8363, 24.2405, 24.6033, 24.9304, 25.2257, 25.4918, 25.7302, 25.9413, 26.1241, 26.2757, 26.39, 26.4538,
         26.4363, 26.2375, 25.2812, 24.0373, 25.3179, 26.6053, 27.2335, 27.6713, 28.0275, 28.3362, 28.6126, 28.8651,
         29.0986, 29.3165, 29.5207, 29.7142, 29.8985, 30.0744, 30.2428, 30.4043, 30.5596, 30.7091, 30.8532, 30.9923,
         31.1269, 31.2571, 31.3834, 31.5059, 31.6249, 31.7407, 31.8532, 31.9623, 32.0683, 32.1713, 32.2715, 32.369,
         32.464, 32.5564, 32.6462, 32.7336, 32.8188, 32.9017, 32.9825, 33.0613, 33.1382, 33.2132, 33.2864, 33.3578,
         33.4275, 33.4957, 33.5622, 33.6273, 33.6909, 33.7531, 33.814, 33.8736, 33.932, 33.9892, 34.0449, 34.0993,
         34.1524, 34.2042, 34.2548, 34.3042, 34.3525, 34.3997, 34.4457, 34.4908, 34.5348, 34.5779, 34.62, 34.6611,
         34.7014, 34.7408, 34.7793, 34.817, 34.8539, 34.89, 34.9253, 34.96, 34.9939, 35.0271, 35.0597, 35.0917, 35.123,
         35.1538, 35.1841, 35.2139, 35.2433, 35.2723, 35.3012, 35.3301, 35.3594, 35.3902, 35.4225, 35.4522, 35.48,
         35.5064, 35.5316, 35.5558, 35.579, 35.6013, 35.6229, 35.6438, 35.664, 35.6836, 35.7026, 35.7211, 35.739,
         35.7565, 35.7734, 35.7899, 35.806, 35.8217, 35.837, 35.8519, 35.9671, 35.9811, 35.9946, 36.0076, 36.02,
         36.0319, 36.094, 36.105, 36.1154, 36.1254, 36.1348, 36.1437, 36.1523, 36.1603, 36.168, 36.1753, 36.1822,
         36.1888, 36.195, 36.201, 36.2066, 36.2119, 36.2169, 36.2216, 36.2261, 36.2304, 36.2344, 36.2807, 36.2845,
         36.288, 36.2911, 36.2939, 36.2964, 36.2986, 36.3005, 36.3022, 36.3036, 36.3047, 36.3056, 36.3063, 36.3067,
         36.3069, 36.3068, 36.3066, 36.3062, 36.3055, 36.3047, 36.3037, 36.3024, 36.301, 36.2995, 36.2977, 36.2958,
         36.2938, 36.2916, 36.2892, 36.2867, 36.2841, 36.2813, 36.2784, 36.2753, 36.2722, 36.2689, 36.2655, 36.2619,
         36.2583, 36.2546, 36.2507, 36.2468, 36.2428, 36.2386, 36.2344, 36.2301, 36.2257, 36.2212, 36.2166, 36.212,
         36.2072, 36.2024, 36.1976, 36.1926, 36.1876, 36.1825, 36.1774, 36.1722, 36.1669, 36.1616, 36.1562, 36.1508,
         36.1453, 36.1398, 36.1342, 36.1285, 36.1228, 36.1171, 36.1113, 36.1055, 36.0997, 36.0938, 36.0878, 36.0819,
         36.0758, 36.0698, 36.0637, 36.0575, 36.0514, 36.0452, 36.0389, 36.0327, 36.0264, 36.0201, 36.0137, 36.0073,
         36.0009, 35.9945, 35.988, 35.9816, 35.9751, 35.9685, 35.962, 35.9554, 35.9488, 35.9422, 35.9356, 35.929,
         35.9223, 35.9157, 35.909, 35.9023, 35.8956, 35.8889, 35.8821, 35.8754, 35.8686, 35.8618, 35.8551, 35.7984,
         35.7052, 35.6076, 35.5052, 35.4026, 35.2769, 35.1272, 34.9475, 34.7178, 34.3871, 33.7744, 32.7699, 31.3987,
         29.7438, 31.5725, 32.9645, 34.4353, 35.1565, 35.5643, 35.8418, 36.0333, 36.1637, 36.2526, 36.3124, 36.3531,
         36.3793, 36.4257, 36.4237, 36.4141, 36.3994, 36.3815, 36.3617, 36.3407, 36.3194, 36.2981, 36.2774, 36.2575,
         36.2388, 36.2206, 36.203, 36.1863, 36.1708, 36.1562, 36.1424, 36.1295, 36.1175, 36.1065, 36.0964, 36.0871,
         36.0786, 36.0709, 36.0639, 36.0575, 36.0517, 36.0465, 36.0417, 36.0374, 36.0336, 36.0301, 36.0269, 36.0241,
         36.0216, 36.0193, 36.0173, 36.0154, 36.0138, 36.0123],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
         0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.41142, 0.46449, 0.47811, 0.91368, 1.726,
         2.9189, 4.4806, 6.3314, 8.3376, 10.342, 12.194, 13.777, 15.016, 15.88, 16.377, 16.509, 16.53, 16.533, 17.597,
         17.602, 17.627, 17.641, 17.643, 18.1, 18.11, 18.11, 17.991, 17.686, 17.23, 17.189, 17.066, 17.033, 17.719,
         17.597, 17.41, 16.78, 16.086, 15.344, 14.562, 13.759, 12.949, 12.145, 11.356, 10.589, 9.8506, 9.1436, 8.471,
         7.8343, 7.2342, 6.6708, 6.1435, 5.9226, 5.8857, 5.849, 5.8125, 5.7762, 5.7401, 5.7041, 5.6684, 5.6328, 5.5975,
         5.5624, 5.5274, 5.4927, 5.4582, 5.4238, 5.3897, 5.3558, 5.322, 5.2885, 5.2552, 5.2221, 5.1892, 5.1494, 5.109,
         5.0689, 5.0291, 4.9897, 4.9507, 4.9119, 4.8736, 4.8355, 4.7978, 4.7604, 4.7233, 4.6866, 4.6502, 4.6141, 4.5783,
         4.5428, 4.5076, 4.4728, 4.4382, 4.404, 4.37, 4.3363, 4.3029, 4.2699, 4.2371, 4.2045, 4.1723, 4.1402, 4.1081,
         4.0762, 4.0446, 4.0132, 3.9822, 3.9514, 3.9208, 3.8906, 3.8606, 3.8308, 3.8014, 3.7721, 3.7431, 3.7144, 3.6859,
         3.6577, 3.6297, 3.602, 3.5744, 3.5472, 3.5201, 3.4933, 3.4667, 3.4403, 3.4142, 3.3883, 3.3626, 3.3371, 3.3119,
         3.2868, 3.262, 3.2374, 3.213, 3.1888, 3.1648, 3.141, 3.1174, 3.094, 3.0708, 3.0478, 3.025, 3.0024, 2.98,
         2.9577, 2.9357, 2.9138, 2.8921, 2.8706, 2.8493, 2.8282, 2.8072, 2.7864, 2.7658, 2.7453, 2.7251, 2.705, 2.685,
         2.6652, 2.6456, 2.6262, 2.6069, 2.5878, 2.5688, 2.55, 2.5313, 2.5128, 2.4945, 2.4763, 2.4582, 2.4403, 2.4226,
         2.4049, 2.3875, 2.37, 2.3607, 11.391, 11.35, 11.259, 11.169, 11.079, 10.99, 10.902, 10.843, 15.298, 15.264,
         15.143, 15.022, 14.902, 14.783, 14.665, 14.548, 14.432, 14.317, 14.203, 14.09, 13.978, 13.867, 13.756, 13.647,
         13.538, 13.43, 13.324, 13.218, 13.112, 13.008, 12.919, 12.905, 14.817, 14.725, 14.613, 14.502, 14.392, 14.283,
         14.175, 14.068, 13.961, 13.855, 13.751, 13.65, 13.549, 13.449, 13.351, 13.253, 13.156, 13.06, 12.965, 12.87,
         12.777, 12.684, 12.592, 12.501, 12.411, 12.322, 12.231, 12.142, 12.053, 11.964, 11.877, 11.79, 11.703, 11.617,
         11.531, 11.446, 11.361, 11.277, 11.194, 11.112, 11.03, 10.948, 10.868, 10.788, 10.708, 10.629, 10.551, 10.473,
         10.396, 10.319, 10.243, 10.168, 10.093, 10.018, 9.9428, 9.8684, 9.7945, 9.7211, 9.6483, 9.576, 9.5043, 9.4331,
         9.3624, 9.2922, 9.2225, 9.1534, 9.0847, 9.0166, 8.949, 8.8819, 8.8152, 8.7491, 8.6835, 8.6184, 8.5538, 8.4897,
         8.426, 8.3629, 8.3002, 8.238, 8.1763, 8.1151, 8.0544, 7.9941, 7.9343, 7.8749, 7.8161, 7.7577, 7.6997, 7.6422,
         7.5826, 7.5217, 7.4613, 7.4014, 7.342, 7.2831, 7.2247, 7.1667, 7.1092, 7.0522, 6.9957, 6.9396, 6.884, 6.8289,
         6.7742, 6.72, 6.6662, 6.6129, 6.56, 6.5076, 6.4556, 6.4041, 6.3518, 6.2987, 6.2461, 6.194, 6.1424, 6.0912,
         6.0401, 5.9885, 5.9375, 5.8869, 5.8368, 5.7872, 5.738, 5.6893, 5.6411, 5.5932, 5.5459, 5.4989, 5.4524, 5.4063,
         5.3607, 5.3155, 5.2706, 5.2262, 5.1823, 5.1387, 5.0955, 5.0527, 5.0089, 4.9656, 4.9226, 4.88, 4.8379, 4.7961,
         4.7547, 4.7137, 4.673, 4.6324, 4.5922, 4.5524, 4.5129, 4.4738, 4.4351, 4.3967, 4.3586, 4.3208, 4.2833, 4.2462,
         4.2094, 4.173, 4.1368, 4.1011, 4.0656, 4.0305, 3.9957, 3.9612, 3.927, 3.8931, 3.8596, 3.8264, 3.7934, 3.7608,
         3.7285, 3.6964, 3.6647, 3.6332, 3.6021, 3.5712, 3.5406, 3.5103, 3.4802, 3.4505, 3.421, 3.3917, 3.3628, 3.3341,
         3.3057, 3.2775, 3.2496, 3.2219, 3.1945, 3.1673, 3.1404, 3.1137, 3.0873, 3.0611, 3.0352, 3.0094, 2.984, 2.9587,
         2.9337, 2.9089, 2.8843, 2.86, 2.8358, 2.8119, 2.7882, 2.7646, 2.7412, 2.7181, 2.6951, 2.6723, 2.6498, 2.6275,
         2.6053, 2.5834, 2.5616, 2.5401, 2.5187, 2.4976, 2.4766, 2.4558, 2.4352, 2.4148, 2.3946, 2.3745, 2.3547, 2.335,
         2.3155, 2.2961, 2.277, 2.258, 2.2391, 2.2205, 2.202, 2.1837, 2.1655, 2.1475, 2.1297, 2.112, 2.0945, 2.0771,
         2.0599, 2.0428, 2.0259, 2.0092, 1.852, 1.6573, 1.478, 1.3181, 1.1691, 1.0267, 0.90242, 0.79399, 0.69926,
         0.61644, 0.54394, 0.50406, 0.49003, 0.4864, 3.7394, 3.6342, 3.2888, 2.944, 2.6507, 2.3881, 2.1362, 1.908,
         1.7024, 1.5182, 1.3541, 1.204, 1.065, 0.94055, 0.83069, 0.73368, 0.64798, 0.5722, 0.50509, 0.44588, 0.39364,
         0.34754, 0.30686, 0.27079, 0.23777, 0.20879, 0.18335, 0.16085, 0.14079, 0.12323, 0.10787, 0.094427, 0.082662,
         0.072366, 0.063355, 0.055468, 0.048565, 0.042522, 0.037233, 0.032603, 0.028549, 0.025, 0.021893, 0.019173,
         0.016792, 0.014706, 0.01288, 0.011281, 0.0098811, 0.0086549, 0.0075812, 0.0066408, 0.0058172]],
    'Rb':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.108094,
         0.109564, 0.1097485, 0.1101897, 0.1104581, 0.1108515, 0.111241, 0.1116882, 0.112359, 0.112506, 0.114036,
         0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655,
         0.2301188, 0.23373, 0.2373075, 0.2382615, 0.2396925, 0.242452, 0.24327, 0.245997, 0.246163, 0.2471526,
         0.248637, 0.252348, 0.2629708, 0.2811158, 0.3005128, 0.315658, 0.3204895, 0.3212482, 0.3217779, 0.3237105,
         0.328542, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525,
         0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345,
         1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.768312, 1.795378, 1.802596, 1.813422, 1.820795,
         1.826622, 1.840488, 1.85458, 1.862036, 1.873219, 1.901178, 1.94643, 2.023798, 2.054774, 2.063035, 2.075425,
         2.080733, 2.106402, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288,
         4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609,
         8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 14.89571, 15.1237,
         15.1845, 15.2757, 15.40095, 15.50369, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923,
         26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542,
         54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353,
         113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548,
         237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [10.6052, 10.6015, 10.5972, 10.5923, 10.5867, 10.5803, 10.573, 10.5646, 10.555, 10.544, 10.5314, 10.517,
         10.5004, 10.4814, 10.4596, 10.4345, 10.4057, 10.3726, 10.3345, 10.2905, 10.2397, 10.1809, 10.1128, 10.0337,
         9.94164, 9.83403, 9.70781, 9.55905, 9.38267, 9.17195, 8.91774, 8.60695, 8.21972, 7.72246, 7.04466, 6.36832,
         6.05004, 5.9943, 5.78032, 5.75275, 5.77037, 5.72118, 5.58945, 5.59619, 5.59062, 5.45079, 4.91265, 3.69986,
         2.56355, 1.74687, 1.46669, 1.84424, 2.87535, 4.44382, 6.35797, 8.37821, 10.133, 10.3741, 10.2407, 9.69342,
         10.4916, 11.2475, 11.3947, 11.7264, 11.7335, 11.6209, 12.1407, 12.9482, 14.581, 16.7594, 18.5648, 19.5375,
         19.5433, 19.4315, 19.2133, 19.7819, 20.4946, 21.7872, 23.2924, 24.5443, 25.6094, 26.5213, 27.3013, 27.9617,
         28.5146, 28.9716, 29.343, 29.6376, 29.8635, 30.0328, 30.1412, 30.1985, 30.2095, 30.1813, 30.0924, 29.8858,
         29.5799, 29.1656, 28.6048, 27.8159, 26.6003, 24.2705, 20.9998, 16.7689, 12.0146, 16.5024, 18.1208, 18.868,
         19.7523, 19.5105, 17.6613, 20.5312, 23.6161, 25.8435, 27.5287, 27.3506, 26.531, 27.7221, 28.072, 29.0967,
         31.4076, 33.1215, 34.3107, 35.1644, 35.7995, 36.2964, 36.615, 36.8409, 37.1467, 37.2307, 37.3083, 37.3012,
         37.2647, 37.2079, 37.1377, 37.0586, 36.9737, 36.8848, 36.7938, 36.7023, 36.6083, 36.5147, 36.4009, 36.2685,
         36.1154, 35.9319, 35.6954, 35.3489, 34.6753, 33.7901, 32.428, 30.7845, 32.4638, 33.5245, 33.982, 35.5543,
         36.2184, 36.605, 36.8702, 37.052, 37.1762, 37.2613, 37.3198, 37.3592, 37.3806, 37.4248, 37.4215, 37.411,
         37.3958, 37.3776, 37.3576, 37.3367, 37.3153, 37.2942, 37.2736, 37.2538, 37.2352, 37.2171, 37.1997, 37.1841,
         37.1686, 37.1539, 37.1401, 37.1273, 37.1155, 37.1046, 37.0947, 37.0855, 37.0772, 37.0696, 37.0627, 37.0565,
         37.0508, 37.0456, 37.041, 37.0368, 37.033, 37.0296, 37.0265, 37.0237, 37.0212, 37.019, 37.017, 37.0152,
         37.0135],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
         0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.25914, 0.2697, 0.28054,
         0.29347, 0.49693, 0.50427, 0.58678, 0.86744, 1.7961, 3.2757, 5.2741, 7.6481, 10.163, 12.561, 14.622, 16.204,
         17.252, 17.78, 17.834, 17.863, 17.867, 19.152, 19.176, 19.181, 19.19, 19.19, 19.191, 19.742, 19.744, 19.673,
         19.343, 18.795, 18.287, 18.117, 18.09, 18.071, 18.835, 18.663, 18.124, 17.264, 16.369, 15.46, 14.553, 13.654,
         12.771, 11.912, 11.084, 10.291, 9.5364, 8.8212, 8.1467, 7.5128, 6.9191, 6.3649, 5.8487, 5.2591, 4.7337, 4.267,
         3.8509, 3.4763, 3.1425, 2.8447, 2.5786, 2.4416, 2.3885, 2.3747, 11.451, 11.348, 11.268, 11.081, 10.895, 10.798,
         15.142, 14.663, 14.007, 13.09, 12.769, 12.687, 14.48, 14.424, 14.161, 13.092, 11.929, 10.816, 9.7911, 8.8531,
         7.9746, 7.1601, 6.4342, 5.7579, 5.1392, 4.5792, 4.0776, 3.6308, 3.2358, 2.8864, 2.577, 2.3017, 2.0576, 1.8411,
         1.648, 1.4703, 1.3082, 1.1491, 1.0103, 0.88918, 0.78333, 0.69075, 0.6097, 0.53867, 0.5065, 0.49254, 0.48892,
         3.7245, 3.6643, 3.6159, 3.2333, 2.8978, 2.6097, 2.3484, 2.1007, 1.8765, 1.6749, 1.4947, 1.3296, 1.1815, 1.0446,
         0.92254, 0.81482, 0.7197, 0.63565, 0.56136, 0.49552, 0.43743, 0.38618, 0.34095, 0.30104, 0.26552, 0.23329,
         0.20497, 0.17991, 0.15755, 0.13798, 0.12084, 0.10583, 0.092695, 0.081191, 0.071118, 0.062296, 0.054571,
         0.047806, 0.041881, 0.036691, 0.032146, 0.028164, 0.024677, 0.021622, 0.018946, 0.016601, 0.014547, 0.012748,
         0.011171, 0.0097899, 0.0085796, 0.0075192, 0.00659]],
    'Sr':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.019502, 0.0198005, 0.0198801, 0.0199995, 0.020298, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.036946, 0.0375115, 0.0376623, 0.0378885,
         0.03797993, 0.038454, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581,
         0.1180797, 0.1262272, 0.130438, 0.1323, 0.1324345, 0.1329669, 0.1337655, 0.134325, 0.1349368, 0.135675,
         0.135762, 0.1377, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188,
         0.245997, 0.2629708, 0.263718, 0.2677545, 0.2688309, 0.2704455, 0.274204, 0.274482, 0.278401, 0.2795202,
         0.2811158, 0.281199, 0.285396, 0.3005128, 0.3212482, 0.3434143, 0.35035, 0.3557125, 0.3571425, 0.3592875,
         0.36465, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625,
         0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098,
         1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.900808, 1.929902, 1.93766, 1.94643, 1.949298,
         1.966664, 1.978392, 1.996766, 2.004793, 2.016834, 2.046936, 2.080733, 2.171974, 2.205219, 2.214084, 2.224304,
         2.227382, 2.260626, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024,
         4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789,
         9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 15.78251, 16.02408,
         16.0885, 16.18512, 16.42669, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645,
         28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721,
         58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931,
         121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835,
         253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [6.01475, 5.84877, 5.64098, 5.3755, 5.02694, 4.55166, 3.86641, 2.785, 0.754046, -5.82671, -6.00105, -13.6341,
         -23.0666, -12.8619, -3.82214, 2.01263, 8.40831, 11.4841, 12.9978, 13.603, 13.6861, 13.4888, 13.1574, 12.773,
         12.5346, 12.4291, 12.3844, 12.3712, 12.3628, 12.3062, 12.032, 11.712, 11.4213, 11.1581, 10.9182, 10.6961,
         10.4934, 10.2891, 10.0843, 9.87222, 9.6453, 9.39477, 9.11006, 8.77712, 8.37592, 7.87523, 7.21893, 6.26992,
         5.54051, 5.01232, 4.95426, 4.56862, 4.63112, 4.56576, 4.25375, 4.4424, 4.4465, 4.35558, 3.59201, 2.40039,
         1.56073, 1.31547, 1.79924, 2.99766, 4.76573, 6.87259, 9.02751, 10.6739, 10.6994, 10.4677, 9.77365, 10.7411,
         11.7583, 11.8076, 12.2586, 12.0944, 12.6846, 12.7109, 13.6391, 15.8617, 18.1526, 19.9592, 20.3353, 20.3684,
         20.0386, 20.6284, 21.3786, 21.6251, 23.4986, 24.9534, 26.1751, 27.206, 28.0783, 28.8164, 29.4368, 29.9511,
         30.3708, 30.7066, 30.9681, 31.169, 31.3124, 31.413, 31.5546, 31.5036, 31.3758, 31.1577, 30.8513, 30.4446,
         29.9032, 29.1497, 28.0062, 25.8874, 22.4478, 18.3841, 13.839, 17.1473, 18.0907, 20.616, 21.2315, 21.0047,
         19.2132, 21.9144, 24.8433, 26.4766, 28.5735, 28.4259, 27.6147, 28.5604, 28.8147, 30.2095, 32.4386, 34.1917,
         35.3853, 36.2474, 36.8987, 37.34, 37.6486, 37.8686, 38.172, 38.2552, 38.3309, 38.3224, 38.2855, 38.2285,
         38.1577, 38.078, 37.9926, 37.9036, 37.8125, 37.7216, 37.6321, 37.529, 37.4095, 37.2732, 37.116, 36.9268,
         36.6805, 36.3115, 35.5442, 34.8227, 33.4696, 31.8377, 33.5041, 35.0109, 35.131, 36.6899, 37.2957, 37.6587,
         37.9092, 38.0799, 38.197, 38.2782, 38.3342, 38.3668, 38.3854, 38.4267, 38.4218, 38.4101, 38.3941, 38.3754,
         38.3551, 38.334, 38.3126, 38.2914, 38.2709, 38.2512, 38.2327, 38.2149, 38.1983, 38.1818, 38.1662, 38.1515,
         38.1379, 38.1252, 38.1136, 38.1029, 38.0931, 38.0841, 38.0759, 38.0684, 38.0617, 38.0555, 38.0499, 38.0449,
         38.0403, 38.0362, 38.0324, 38.0291, 38.0261, 38.0233, 38.0209, 38.0187, 38.0167, 38.0149],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.72, 17.971, 16.728, 13.904, 11.221, 8.7811,
         6.7384, 5.1194, 3.8813, 2.9556, 2.2723, 1.9596, 1.8527, 1.8257, 1.8292, 1.8141, 1.7391, 1.4601, 1.207, 1.0266,
         0.89863, 0.80874, 0.74641, 0.70405, 0.67615, 0.65872, 0.6489, 0.64464, 0.64464, 0.64796, 0.65373, 0.66129,
         0.67015, 0.67994, 0.69034, 0.69558, 0.69786, 0.69802, 0.69867, 1.2472, 1.2706, 1.2972, 1.7037, 1.7101, 1.8615,
         2.5308, 4.0874, 6.2297, 8.7792, 11.466, 13.995, 16.122, 17.7, 18.678, 19.087, 19.093, 19.11, 19.11, 20.693,
         20.703, 20.703, 20.694, 20.688, 21.367, 21.367, 21.343, 21.135, 20.62, 19.892, 19.644, 19.448, 19.395, 20.165,
         19.968, 19.876, 18.928, 17.932, 16.918, 15.907, 14.913, 13.946, 13.007, 12.102, 11.236, 10.413, 9.6331, 8.8989,
         8.2102, 7.5663, 6.9663, 6.3301, 5.7183, 5.1566, 4.6569, 4.2117, 3.8117, 3.4528, 3.132, 2.8448, 2.6757, 2.6188,
         2.604, 11.304, 11.275, 11.103, 10.989, 10.815, 10.74, 14.918, 14.547, 14.159, 13.212, 12.897, 12.815, 14.635,
         14.605, 14.284, 13.26, 12.045, 10.915, 9.8856, 8.9071, 7.9961, 7.1843, 6.4604, 5.7885, 5.1674, 4.6063, 4.1044,
         3.658, 3.2608, 2.9094, 2.5983, 2.3221, 2.0766, 1.8587, 1.6649, 1.4831, 1.3088, 1.1512, 1.0135, 0.89312, 0.7878,
         0.69556, 0.61469, 0.54374, 0.51994, 0.50573, 0.50204, 3.7145, 3.6075, 3.5915, 3.1809, 2.854, 2.5703, 2.31,
         2.0662, 1.8459, 1.6484, 1.4669, 1.3039, 1.1592, 1.0241, 0.90457, 0.79901, 0.70582, 0.62346, 0.55068, 0.48613,
         0.42918, 0.37893, 0.33458, 0.29544, 0.26046, 0.22893, 0.20103, 0.17615, 0.15436, 0.13527, 0.11855, 0.10389,
         0.091057, 0.079809, 0.069953, 0.061317, 0.053749, 0.047116, 0.041304, 0.03621, 0.031745, 0.027832, 0.024401,
         0.021395, 0.018759, 0.016449, 0.014423, 0.012647, 0.011091, 0.0097258, 0.0085292, 0.00748]],
    'Y':                                                                                                          [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.025088, 0.02545001, 0.025472, 0.0255744, 0.025728, 0.026112,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.044492,
         0.045173, 0.0453546, 0.045627, 0.046308, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581,
         0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.154252, 0.156408, 0.156613, 0.1572426, 0.158187,
         0.158802, 0.1594404, 0.160398, 0.160548, 0.162792, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655,
         0.2301188, 0.245997, 0.2629708, 0.2811158, 0.294294, 0.2987985, 0.2999997, 0.3005128, 0.3018015, 0.306152,
         0.306306, 0.310838, 0.3120876, 0.313962, 0.318648, 0.3212482, 0.3434143, 0.3671099, 0.385728, 0.391632,
         0.3924405, 0.3932064, 0.395568, 0.401472, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525,
         0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345,
         1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.0384, 2.0696, 2.07792,
         2.080733, 2.0904, 2.11239, 2.1216, 2.144722, 2.153344, 2.166277, 2.19861, 2.224304, 2.32505, 2.360637,
         2.370127, 2.377781, 2.384362, 2.41995, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288,
         4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609,
         8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362,
         16.69763, 16.95321, 17.02136, 17.12359, 17.37917, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923,
         26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542,
         54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353,
         113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548,
         237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [9.25807, 9.21353, 9.16034, 9.0963, 9.01842, 8.9225, 8.80245, 8.64897, 8.44706, 8.17048, 7.76777, 7.11823,
         5.82478, 2.66593, -0.88356, -1.3618, -6.35333, -0.923289, 3.88163, 8.00855, 10.6268, 11.8406, 12.4062, 12.6179,
         12.6306, 12.5313, 12.3632, 12.2795, 12.202, 12.1481, 12.1734, 12.1689, 12.1661, 12.0224, 11.8616, 11.7016,
         11.5446, 11.3895, 11.2337, 11.0734, 10.9135, 10.7301, 10.526, 10.293, 10.021, 9.69578, 9.29754, 8.79516,
         8.13454, 7.20073, 5.5529, 5.53953, 4.79154, 4.67786, 4.0541, 4.23245, 4.17477, 3.84776, 4.09204, 4.11345,
         4.13332, 4.00162, 2.92375, 2.16988, 2.08958, 2.79942, 4.24554, 6.23497, 8.4883, 10.6387, 11.5884, 11.2613,
         10.4367, 10.2828, 11.5479, 12.7165, 12.7431, 13.2377, 13.0303, 13.7281, 14.7549, 15.1933, 18.0485, 20.2626,
         21.4535, 21.4973, 21.406, 21.1563, 21.7734, 22.5608, 23.9959, 25.666, 27.0341, 28.1698, 29.1188, 29.9121,
         30.5739, 31.1231, 31.5714, 31.9301, 32.2102, 32.4224, 32.5811, 32.6957, 32.7199, 32.6594, 32.533, 32.3292,
         32.0337, 31.6382, 31.1118, 30.3822, 29.2819, 27.2756, 23.7509, 19.7463, 15.2496, 12.2125, 19.4878, 22.2543,
         22.6814, 22.4813, 20.6853, 23.3438, 26.2, 27.3921, 29.6519, 29.506, 28.6977, 29.2895, 29.8931, 31.2811,
         33.4545, 35.2232, 36.4368, 37.3289, 37.9344, 38.357, 38.6559, 38.8701, 39.1683, 39.251, 39.3244, 39.3154,
         39.2785, 39.2227, 39.153, 39.0743, 38.9901, 38.9024, 38.8129, 38.7295, 38.6362, 38.5263, 38.403, 38.2634,
         38.1022, 37.9068, 37.6486, 37.2495, 36.3315, 35.8476, 34.5036, 32.883, 34.5372, 36.0327, 36.5825, 37.8229,
         38.3725, 38.7118, 38.9467, 39.1063, 39.2168, 39.2939, 39.3414, 39.3703, 39.4221, 39.4258, 39.4194, 39.4068,
         39.3903, 39.3712, 39.3507, 39.3296, 39.3082, 39.2872, 39.2669, 39.2475, 39.2293, 39.2118, 39.1946, 39.1782,
         39.1628, 39.1484, 39.135, 39.1226, 39.1111, 39.1007, 39.091, 39.0823, 39.0742, 39.0669, 39.0603, 39.0543,
         39.0488, 39.0439, 39.0394, 39.0354, 39.0317, 39.0285, 39.0255, 39.0228, 39.0204, 39.0183, 39.0164],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.9117, 9.4699, 8.348,
         6.7893, 5.444, 4.324, 3.4253, 2.7216, 2.179, 1.7643, 1.6368, 1.5648, 1.5466, 1.604, 1.5441, 1.5367, 1.314,
         1.151, 1.0318, 0.94549, 0.88383, 0.84065, 0.81131, 0.79235, 0.78119, 0.7759, 0.77504, 0.77753, 0.78263,
         0.78967, 0.79802, 0.80718, 0.81672, 0.82624, 0.82629, 0.82823, 0.82842, 0.82898, 1.7739, 1.8063, 1.8409,
         2.5368, 2.5506, 2.7681, 2.9871, 4.6314, 6.9768, 9.7069, 12.508, 15.059, 17.117, 18.549, 19.336, 19.531, 19.54,
         19.538, 21.378, 21.381, 21.378, 21.378, 21.353, 21.343, 22.129, 22.086, 22.055, 21.616, 20.907, 20.256, 20.041,
         20.011, 19.983, 20.78, 20.562, 19.893, 18.833, 17.749, 16.659, 15.589, 14.551, 13.552, 12.594, 11.678, 10.807,
         9.9856, 9.2134, 8.4907, 7.8172, 7.093, 6.4399, 5.8454, 5.2774, 4.7662, 4.3109, 3.9039, 3.537, 3.2091, 2.9155,
         2.7303, 2.6724, 2.6573, 11.347, 11.25, 11.032, 10.943, 10.724, 10.644, 14.777, 14.387, 14.1, 13.101, 12.787,
         12.706, 14.549, 14.489, 14.173, 13.193, 11.997, 10.88, 9.8107, 8.8048, 7.9085, 7.1093, 6.3963, 5.7359, 5.121,
         4.5662, 4.0696, 3.6301, 3.2375, 2.8894, 2.5811, 2.3079, 2.0645, 1.8485, 1.6525, 1.46, 1.2899, 1.1357, 1.0008,
         0.88275, 0.77932, 0.68866, 0.6091, 0.53924, 0.52558, 0.51129, 0.50758, 3.6974, 3.5922, 3.505, 3.1169, 2.7995,
         2.5209, 2.2626, 2.0235, 1.8082, 1.6098, 1.4316, 1.2733, 1.1318, 0.99964, 0.88302, 0.78007, 0.68916, 0.60881,
         0.5378, 0.47479, 0.4192, 0.37014, 0.32684, 0.28863, 0.25432, 0.22342, 0.19588, 0.17174, 0.15058, 0.13204,
         0.11579, 0.10154, 0.089045, 0.078093, 0.06849, 0.060071, 0.052689, 0.046215, 0.040538, 0.03556, 0.031194,
         0.027365, 0.024007, 0.021062, 0.018478, 0.016212, 0.014224, 0.01248, 0.010951, 0.009609, 0.0084317]],
    'Zr':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.028126, 0.0285565, 0.0286713,
         0.0288435, 0.02908327, 0.029274, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198,
         0.04639671, 0.04959809, 0.050274, 0.0510435, 0.0512487, 0.0515565, 0.052326, 0.05302035, 0.05667876,
         0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284,
         0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1764, 0.178752,
         0.1791, 0.17982, 0.1809, 0.181488, 0.1822176, 0.183312, 0.1836, 0.186048, 0.1883732, 0.2013709, 0.2152655,
         0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.32389, 0.3288475, 0.3301695, 0.3321525,
         0.337316, 0.342479, 0.3434143, 0.3438558, 0.345921, 0.351084, 0.3671099, 0.3924405, 0.4195189, 0.421694,
         0.4281485, 0.4298697, 0.4324515, 0.438906, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625,
         0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098,
         1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.177854, 2.211189, 2.220078,
         2.224304, 2.233412, 2.260566, 2.266746, 2.295166, 2.304393, 2.318233, 2.352834, 2.377781, 2.480968, 2.518942,
         2.529068, 2.541848, 2.544258, 2.582232, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024,
         4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789,
         9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961,
         17.63765, 17.90761, 17.9796, 18.08759, 18.35755, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645,
         28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721,
         58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931,
         121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835,
         253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [8.63969, 9.20229, 9.79034, 10.321, 10.7704, 11.1106, 11.3288, 11.4247, 11.4062, 11.2852, 11.0699, 10.7559,
         10.3102, 9.62155, 8.21966, 6.29704, 3.21432, -0.5923, 3.5496, 6.11659, 7.19898, 10.9926, 12.3938, 12.9928,
         13.2238, 13.2621, 13.1953, 13.0678, 12.8901, 12.841, 12.7552, 12.6876, 12.7297, 12.7431, 12.7301, 12.615,
         12.484, 12.3506, 12.2161, 12.079, 11.9368, 11.7864, 11.6299, 11.4486, 11.2422, 11.0023, 10.7172, 10.3714,
         9.94174, 9.39145, 8.65667, 7.59071, 5.62572, 5.57321, 4.67369, 4.45684, 3.60635, 3.89674, 3.8567, 3.43839,
         3.83947, 3.89979, 4.02739, 3.95244, 3.06524, 2.61432, 2.94879, 4.10791, 5.95134, 8.21365, 10.548, 12.3356,
         12.4034, 11.9981, 11.064, 12.2979, 13.6414, 14.1694, 14.0923, 13.9242, 14.6887, 15.7956, 18.0251, 20.5907,
         22.4759, 22.5688, 22.6184, 22.2665, 22.9066, 23.7239, 24.5159, 26.3946, 27.8803, 29.1158, 30.1279, 30.9657,
         31.6585, 32.2301, 32.6986, 33.0705, 33.3583, 33.574, 33.7337, 33.8779, 33.885, 33.8089, 33.6698, 33.4666,
         33.175, 32.7836, 32.263, 31.543, 30.4556, 28.4688, 25.0258, 21.0778, 16.6305, 16.201, 20.8476, 23.823, 24.0772,
         23.9079, 22.1098, 24.7235, 27.5108, 28.5758, 30.7315, 30.5892, 29.784, 30.8105, 30.9762, 32.3607, 34.5926,
         36.3503, 37.5776, 38.4098, 38.9875, 39.3928, 39.6799, 39.8855, 40.1747, 40.2531, 40.322, 40.311, 40.2733,
         40.2179, 40.1495, 40.0724, 39.9904, 39.9071, 39.8312, 39.7383, 39.6345, 39.5203, 39.3936, 39.2506, 39.0847,
         38.8813, 38.6073, 38.1655, 36.9666, 36.873, 35.5375, 33.9278, 35.5694, 37.0539, 37.9492, 38.9585, 39.4548,
         39.7696, 39.9873, 40.1362, 40.2404, 40.3063, 40.3483, 40.3736, 40.4228, 40.4242, 40.4164, 40.4028, 40.3857,
         40.3663, 40.3456, 40.3244, 40.3032, 40.2823, 40.2622, 40.2432, 40.2252, 40.2075, 40.1904, 40.1742, 40.159,
         40.1449, 40.1318, 40.1196, 40.1085, 40.0982, 40.0888, 40.0803, 40.0724, 40.0653, 40.0588, 40.053, 40.0477,
         40.0428, 40.0385, 40.0346, 40.031, 40.0278, 40.0249, 40.0223, 40.02, 40.0179],
        [3.7546, 3.8719, 3.8448, 3.6795, 3.399, 3.0377, 2.6337, 2.2215, 1.8295, 1.4775, 1.175, 0.92388, 0.72105,
         0.56055, 0.43549, 0.38425, 0.363, 0.3576, 7.9002, 7.6864, 7.5218, 6.1658, 4.9447, 3.9611, 3.1838, 2.5776,
         2.1087, 1.7474, 1.4693, 1.4213, 1.3703, 1.3573, 1.4517, 1.4103, 1.3757, 1.2296, 1.1224, 1.0443, 0.98836,
         0.94929, 0.92428, 0.90958, 0.90237, 0.90088, 0.90376, 0.90996, 0.91865, 0.92912, 0.94071, 0.95287, 0.9651,
         0.97697, 0.98807, 0.98824, 0.99032, 0.99062, 0.99124, 2.3162, 2.3505, 2.3941, 3.3624, 3.3916, 3.6524, 3.9221,
         5.8955, 8.5578, 11.475, 14.289, 16.688, 18.468, 19.558, 19.988, 20.0, 20.0, 19.996, 22.058, 22.04, 21.998,
         21.989, 21.984, 22.86, 22.798, 22.504, 21.81, 20.892, 20.814, 20.58, 20.518, 21.338, 21.102, 20.752, 19.628,
         18.475, 17.321, 16.183, 15.083, 14.029, 13.025, 12.066, 11.155, 10.297, 9.4945, 8.7469, 7.9335, 7.2, 6.5408,
         5.949, 5.3904, 4.874, 4.4137, 4.0029, 3.6307, 3.2965, 2.9969, 2.81, 2.7507, 2.7353, 11.335, 11.245, 10.983,
         10.925, 10.663, 10.581, 14.67, 14.271, 14.007, 13.041, 12.728, 12.648, 14.446, 14.426, 14.114, 13.113, 11.927,
         10.765, 9.6735, 8.6866, 7.8053, 7.0192, 6.3175, 5.6673, 5.0616, 4.5149, 4.0262, 3.5936, 3.2086, 2.8651, 2.5609,
         2.2911, 2.051, 1.8332, 1.6261, 1.4376, 1.2709, 1.1197, 0.98744, 0.87156, 0.76995, 0.68082, 0.60256, 0.53379,
         0.53171, 0.51731, 0.51357, 3.6815, 3.5783, 3.4138, 3.0491, 2.7406, 2.4665, 2.2109, 1.9773, 1.761, 1.5667,
         1.3939, 1.2404, 1.1015, 0.97302, 0.85957, 0.75942, 0.67097, 0.59279, 0.52368, 0.4624, 0.40832, 0.36059,
         0.31845, 0.28126, 0.24752, 0.21714, 0.19051, 0.16714, 0.14666, 0.12868, 0.11292, 0.099091, 0.08696, 0.076317,
         0.066979, 0.058786, 0.051598, 0.04529, 0.039755, 0.034897, 0.030634, 0.026893, 0.023609, 0.020727, 0.018198,
         0.015978, 0.014029, 0.012318, 0.010816, 0.0094972]],
    'Nb':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.0337305, 0.0338661, 0.0340695, 0.034578, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.056938, 0.0578095, 0.0580419, 0.0583905, 0.059262, 0.06058959,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581,
         0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.200508, 0.2013709,
         0.203252, 0.203577, 0.2043954, 0.205623, 0.206363, 0.2071926, 0.208437, 0.208692, 0.211548, 0.2152655,
         0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.35574, 0.361185, 0.362637,
         0.364815, 0.3671099, 0.37026, 0.370832, 0.376508, 0.3780216, 0.380292, 0.385968, 0.3924405, 0.4195189,
         0.4484657, 0.459032, 0.466058, 0.4679316, 0.470742, 0.477768, 0.4794098, 0.5124891, 0.5478508, 0.5856525,
         0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345,
         1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.32309,
         2.358648, 2.36813, 2.377781, 2.382353, 2.415406, 2.41791, 2.452376, 2.462235, 2.477023, 2.513994, 2.541848,
         2.643746, 2.684212, 2.695002, 2.711189, 2.717235, 2.751654, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288,
         4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609,
         8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362,
         17.59961, 18.60589, 18.81398, 18.89067, 18.96661, 19.08053, 19.36531, 20.11215, 21.49988, 22.98338, 24.56923,
         26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542,
         54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353,
         113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548,
         237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [10.0659, 10.5322, 10.9518, 11.312, 11.6045, 11.8247, 11.9742, 12.0579, 12.082, 12.0526, 11.9742, 11.8479,
         11.6699, 11.4272, 11.0887, 10.5769, 9.6496, 6.6165, 3.18596, -1.19368, 3.70199, 8.02069, 10.7915, 13.2373,
         13.9977, 14.2144, 14.2065, 14.0978, 13.9394, 13.7336, 13.7147, 13.6248, 13.5549, 13.5974, 13.6097, 13.5818,
         13.4584, 13.3287, 13.2008, 13.0742, 12.9466, 12.8148, 12.6746, 12.5133, 12.3409, 12.1424, 11.9086, 11.6273,
         11.2817, 10.8466, 10.2823, 9.51839, 8.38955, 6.42876, 6.18902, 5.47097, 5.28557, 4.4195, 4.71064, 4.65902,
         4.22092, 4.61993, 4.66799, 4.79309, 4.64634, 3.68255, 3.3117, 3.8466, 5.28323, 7.40735, 9.86435, 12.1514,
         12.8368, 12.3859, 11.357, 12.7166, 13.5048, 14.1594, 14.2535, 14.8151, 14.542, 15.3787, 16.5851, 17.5798,
         20.6793, 22.9922, 23.5572, 23.6325, 23.2794, 23.9415, 24.7959, 24.9438, 27.1205, 28.759, 30.0837, 31.1435,
         32.0317, 32.7581, 33.3512, 33.8339, 34.2181, 34.5185, 34.8154, 35.1027, 35.1326, 35.0842, 34.9759, 34.814,
         34.5998, 34.3066, 33.9135, 33.3913, 32.67, 31.5783, 29.5666, 26.27, 22.3765, 17.9815, 20.8709, 22.1655,
         25.3224, 25.4136, 25.2771, 23.4796, 26.045, 28.7649, 29.8378, 31.7857, 31.6513, 30.8499, 32.0413, 32.3528,
         33.4274, 35.7728, 37.5651, 38.7342, 39.5227, 40.0708, 40.4564, 40.7284, 40.9221, 41.1966, 41.2671, 41.3296,
         41.3149, 41.275, 41.2187, 41.1509, 41.0753, 40.9963, 40.9235, 40.8335, 40.7336, 40.626, 40.509, 40.3794,
         40.2325, 40.061, 39.8477, 39.5528, 39.0503, 37.8959, 37.1442, 36.5692, 34.9713, 36.5985, 38.0702, 39.2483,
         40.0917, 40.54, 40.8303, 41.0302, 41.1681, 41.2581, 41.3169, 41.354, 41.3762, 41.4228, 41.4217, 41.4125,
         41.3981, 41.3804, 41.3607, 41.3401, 41.3189, 41.2979, 41.2773, 41.2575, 41.2389, 41.2208, 41.2031, 41.1862,
         41.1703, 41.1553, 41.1415, 41.1286, 41.1167, 41.1058, 41.0958, 41.0866, 41.0783, 41.0706, 41.0637, 41.0574,
         41.0517, 41.0465, 41.0418, 41.0375, 41.0337, 41.0303, 41.0271, 41.0243, 41.0218, 41.0195],
        [4.4264, 4.2928, 4.0896, 3.8319, 3.5347, 3.2159, 2.892, 2.5762, 2.2779, 2.003, 1.7549, 1.5345, 1.3411, 1.1731,
         1.0283, 0.9041, 0.79807, 0.70772, 0.68959, 0.68479, 9.404, 8.8157, 7.8365, 5.8871, 4.5061, 3.5327, 2.8358,
         2.3295, 1.9564, 1.678, 1.6617, 1.6096, 1.5964, 1.6935, 1.6519, 1.5957, 1.4641, 1.3708, 1.3053, 1.2606, 1.2317,
         1.2146, 1.2064, 1.2049, 1.2085, 1.2156, 1.2254, 1.2367, 1.2489, 1.2611, 1.2727, 1.283, 1.2916, 1.2978, 1.2981,
         1.2988, 1.299, 1.2992, 2.6448, 2.6845, 2.7303, 3.7235, 3.7474, 4.03, 4.4399, 6.6351, 9.5437, 12.665, 15.581,
         17.948, 19.577, 20.429, 20.588, 20.601, 20.599, 22.873, 22.871, 22.859, 22.856, 22.811, 22.794, 23.757, 23.685,
         23.579, 22.919, 21.97, 21.592, 21.335, 21.266, 22.096, 21.838, 21.777, 20.561, 19.311, 18.064, 16.848, 15.67,
         14.545, 13.48, 12.471, 11.516, 10.619, 9.7821, 8.8727, 8.0514, 7.3122, 6.6472, 6.0491, 5.4997, 4.9797, 4.5124,
         4.0948, 3.7178, 3.3776, 3.0723, 2.8904, 2.8297, 2.8139, 11.274, 11.232, 10.933, 10.911, 10.612, 10.53, 14.574,
         14.182, 13.909, 13.024, 12.715, 12.636, 14.411, 14.364, 14.102, 13.054, 11.824, 10.626, 9.5442, 8.5721, 7.7022,
         6.9255, 6.2323, 5.5898, 4.9939, 4.4558, 3.9755, 3.5503, 3.1728, 2.8352, 2.5355, 2.2696, 2.0284, 1.7989, 1.5966,
         1.4125, 1.2492, 1.1014, 0.97189, 0.85843, 0.75891, 0.67149, 0.59468, 0.5378, 0.52714, 0.52329, 0.51953, 3.6636,
         3.5646, 3.3283, 2.9812, 2.6792, 2.408, 2.1563, 1.9214, 1.71, 1.522, 1.3548, 1.2062, 1.07, 0.94541, 0.83542,
         0.73828, 0.65247, 0.57661, 0.50951, 0.45, 0.39747, 0.3511, 0.31015, 0.27365, 0.24026, 0.2109, 0.18514, 0.16253,
         0.14269, 0.12528, 0.10999, 0.096581, 0.084806, 0.07447, 0.065397, 0.057431, 0.050438, 0.044297, 0.038906,
         0.034172, 0.030015, 0.026365, 0.023159, 0.020344, 0.017872, 0.0157, 0.013793, 0.012118, 0.010647]],
    'Mo':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.034104, 0.034626, 0.0347652, 0.034974, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.061491, 0.0617382, 0.062109, 0.063036, 0.06477028,
         0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797,
         0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.22246,
         0.225694, 0.225865, 0.226773, 0.228135, 0.2291485, 0.2301188, 0.2314515, 0.23154, 0.234906, 0.245997,
         0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.384454, 0.3903385, 0.3919077, 0.3924405,
         0.3942615, 0.400146, 0.401506, 0.4076515, 0.4092903, 0.4117485, 0.417894, 0.4195189, 0.4484657, 0.4794098,
         0.494508, 0.502077, 0.5040954, 0.507123, 0.5124891, 0.514692, 0.5478508, 0.5856525, 0.6260625, 0.6692609,
         0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285,
         1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.469796, 2.507599,
         2.51768, 2.532801, 2.541848, 2.572598, 2.611974, 2.622475, 2.638225, 2.677602, 2.717235, 2.80819, 2.851172,
         2.862634, 2.879827, 2.904724, 2.92281, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924,
         4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919,
         10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 19.59951,
         19.8995, 19.9795, 20.11215, 20.39949, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502,
         34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318,
         71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553,
         148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126,
         310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [5.43077, 5.6574, 5.89493, 6.1416, 6.39538, 6.65388, 6.91442, 7.17398, 7.42913, 7.6759, 7.90949, 8.12377,
         8.31018, 8.45545, 8.53633, 8.50468, 8.23348, 7.17095, 5.77629, 2.90324, -0.778485, 3.36242, 7.19047, 11.2789,
         12.6164, 13.2362, 13.5538, 13.721, 13.8042, 13.8311, 13.787, 13.7286, 13.6601, 13.7257, 13.781, 13.8132,
         13.8363, 13.8351, 13.8196, 13.7912, 13.7496, 13.6931, 13.6193, 13.5141, 13.3944, 13.2439, 13.0549, 12.8173,
         12.5165, 12.1311, 11.6281, 10.9533, 9.99069, 8.43463, 7.04766, 5.8333, 5.7249, 4.69403, 5.09083, 5.02968,
         4.41639, 5.00987, 5.03178, 5.28899, 4.84517, 4.24159, 4.54616, 5.81417, 7.86636, 10.3493, 12.7662, 13.7735,
         13.2606, 12.1417, 11.384, 13.606, 15.1521, 15.3665, 15.9187, 15.6122, 16.5015, 17.7696, 18.0296, 21.4691,
         23.9738, 24.794, 24.8741, 24.5128, 25.1922, 25.8644, 26.069, 28.2255, 29.9319, 31.2977, 32.4106, 33.3261,
         34.0693, 34.6737, 35.1699, 35.5813, 35.9549, 36.1742, 36.2585, 36.2574, 36.1943, 36.0724, 35.9002, 35.6798,
         35.3859, 34.9914, 34.465, 33.734, 32.6163, 30.5017, 27.5231, 23.709, 19.403, 23.5006, 24.869, 26.7832, 26.6161,
         24.8332, 27.332, 29.9784, 31.2991, 32.83, 32.718, 31.9251, 33.1218, 34.0687, 34.5276, 37.1639, 38.8104,
         39.9027, 40.642, 41.1562, 41.5188, 41.7742, 41.9551, 42.2145, 42.276, 42.3318, 42.3136, 42.2721, 42.2157,
         42.1495, 42.0778, 42.0075, 41.9204, 41.8235, 41.7208, 41.611, 41.4919, 41.3594, 41.2086, 41.0305, 40.8051,
         40.4829, 39.8893, 38.9193, 37.6005, 36.0126, 37.7527, 39.0911, 40.5117, 41.2203, 41.6227, 41.8901, 42.0745,
         42.1944, 42.2738, 42.3257, 42.3582, 42.3775, 42.421, 42.4178, 42.4073, 42.3921, 42.3741, 42.3543, 42.3337,
         42.3128, 42.292, 42.2718, 42.2527, 42.2342, 42.216, 42.1984, 42.1817, 42.166, 42.1514, 42.1378, 42.1253,
         42.1137, 42.103, 42.0933, 42.0843, 42.0762, 42.0688, 42.062, 42.0559, 42.0503, 42.0453, 42.0407, 42.0366,
         42.0328, 42.0295, 42.0264, 42.0237, 42.0212],
        [4.2268, 4.3599, 4.4827, 4.5937, 4.6917, 4.7757, 4.845, 4.899, 4.9378, 4.9614, 4.9703, 4.9652, 4.947, 4.9167,
         4.8757, 4.8251, 4.7664, 4.701, 4.6591, 4.6174, 4.6063, 11.959, 11.443, 9.5682, 8.1374, 7.0647, 6.2404, 5.5908,
         5.0665, 4.6336, 4.269, 4.1958, 4.1764, 4.2808, 4.2156, 4.1021, 3.8525, 3.6366, 3.4473, 3.2799, 3.1308, 2.9973,
         2.877, 2.7682, 2.6694, 2.5793, 2.4969, 2.4212, 2.351, 2.2854, 2.2236, 2.1649, 2.1085, 2.0539, 2.0275, 2.016,
         2.0154, 2.0122, 3.6403, 3.6929, 3.7449, 4.9447, 4.953, 5.2834, 6.6278, 9.4064, 12.567, 15.621, 18.172, 19.977,
         20.964, 21.198, 21.204, 21.2, 23.659, 23.656, 23.628, 23.618, 23.555, 23.534, 24.569, 24.476, 24.448, 23.758,
         22.755, 22.216, 21.94, 21.866, 22.711, 22.514, 22.433, 21.221, 19.898, 18.585, 17.309, 16.076, 14.895, 13.782,
         12.732, 11.746, 10.827, 9.8128, 8.9, 8.0802, 7.344, 6.6828, 6.0889, 5.5491, 5.0351, 4.5682, 4.1501, 3.7728,
         3.4311, 3.124, 2.9632, 2.9015, 2.8855, 11.137, 11.065, 10.825, 10.53, 10.453, 14.436, 14.071, 13.727, 13.02,
         12.718, 12.64, 14.41, 14.233, 14.106, 12.897, 11.637, 10.453, 9.3804, 8.4242, 7.5706, 6.8064, 6.1245, 5.4907,
         4.908, 4.3807, 3.9113, 3.4954, 3.1265, 2.7961, 2.5023, 2.2363, 1.9837, 1.7606, 1.5633, 1.384, 1.2244, 1.0802,
         0.95392, 0.84315, 0.74588, 0.66041, 0.58527, 0.54374, 0.52913, 0.52534, 3.6454, 3.5517, 3.2372, 2.904, 2.6105,
         2.3438, 2.0896, 1.8604, 1.6566, 1.4753, 1.314, 1.1704, 1.037, 0.91661, 0.8103, 0.71637, 0.63337, 0.55996,
         0.49496, 0.43732, 0.38642, 0.34147, 0.30134, 0.26504, 0.23277, 0.20445, 0.17958, 0.15774, 0.13856, 0.12172,
         0.10694, 0.09395, 0.082544, 0.072525, 0.063725, 0.055995, 0.049205, 0.043239, 0.037999, 0.033394, 0.029348,
         0.025794, 0.022671, 0.019926, 0.017514, 0.015395, 0.013533, 0.011896]],
    'Tc':                                                                                                         [
        [0.006594833, 0.006695774, 0.006722692, 0.006763068, 0.00686401, 0.006871351, 0.006976524, 0.007004571,
         0.00704664, 0.007151814, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306,
         0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327,
         0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.038122, 0.0387055, 0.0388611, 0.0390945, 0.039678,
         0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.067032,
         0.068058, 0.0683316, 0.068742, 0.06923942, 0.069768, 0.07401695, 0.07912411, 0.08458368, 0.09041995,
         0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144,
         0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.247842, 0.251272, 0.2516355, 0.2526471, 0.2541645,
         0.255118, 0.2561436, 0.257682, 0.257958, 0.261528, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143,
         0.3671099, 0.3924405, 0.4165, 0.4195189, 0.422875, 0.424575, 0.427125, 0.4335, 0.436002, 0.4426755, 0.4444551,
         0.4471245, 0.4484657, 0.453798, 0.4794098, 0.5124891, 0.536648, 0.544862, 0.5470524, 0.5478508, 0.550338,
         0.558552, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612,
         1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733,
         2.224304, 2.377781, 2.541848, 2.623362, 2.663515, 2.674223, 2.690284, 2.717235, 2.730438, 2.737336, 2.779234,
         2.790407, 2.807166, 2.849064, 2.904724, 2.98165, 3.027288, 3.039458, 3.057713, 3.10515, 3.319406, 3.548445,
         3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525,
         7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095,
         16.46362, 17.59961, 18.81398, 20.11215, 20.62312, 20.93878, 21.02296, 21.14922, 21.46488, 21.49988, 22.98338,
         24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159,
         51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239,
         106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156,
         222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [4.82558, 4.59453, 4.41601, 4.50917, 4.44636, 4.43283, 3.99241, 3.43742, 4.02391, 4.52865, 3.69822, 3.35022,
         3.04621, 2.83967, 2.79407, 2.97422, 3.43337, 4.19913, 5.26243, 6.57362, 8.0514, 9.59139, 11.0679, 12.3918,
         13.4889, 14.3111, 14.8282, 15.0121, 14.7684, 13.3431, 13.1246, 11.1702, 8.71925, 11.433, 13.8226, 15.1868,
         16.5957, 16.9305, 16.919, 16.7624, 16.5406, 16.2876, 16.0082, 15.8314, 15.6989, 15.594, 15.6614, 15.6855,
         15.6858, 15.5655, 15.3932, 15.2214, 15.0539, 14.8894, 14.7251, 14.5568, 14.3659, 14.1734, 13.9586, 13.7169,
         13.4373, 13.104, 12.6951, 12.1779, 11.4995, 10.5653, 9.14953, 6.38418, 5.80494, 4.08107, 3.76123, 2.03092,
         2.86996, 2.87946, 2.07427, 3.14086, 3.26901, 4.0085, 4.13181, 4.40739, 5.07732, 6.59798, 8.79609, 11.3486,
         13.824, 15.1673, 15.0733, 14.572, 13.3707, 14.9086, 16.5109, 16.8695, 17.3684, 17.0243, 17.94, 18.2734,
         19.2209, 22.1872, 24.8222, 26.0979, 26.1559, 25.7769, 25.5775, 26.4692, 27.3518, 29.0479, 30.8296, 32.2455,
         33.4075, 34.3822, 35.1671, 35.7977, 36.3196, 36.7772, 37.1357, 37.3028, 37.3608, 37.347, 37.2693, 37.1397,
         36.9636, 36.744, 36.456, 36.0649, 35.5373, 34.7971, 33.6483, 31.3904, 28.7881, 25.0323, 20.7808, 24.844,
         27.5114, 28.0698, 28.2666, 28.0038, 26.2259, 28.6758, 31.257, 32.8473, 33.965, 33.8793, 33.0922, 34.2883,
         35.7277, 38.4624, 39.9967, 41.0105, 41.7156, 42.2095, 42.5576, 42.803, 42.9757, 43.223, 43.2768, 43.3256,
         43.3043, 43.2619, 43.2061, 43.1423, 43.0782, 43.0003, 42.9078, 42.808, 42.7034, 42.5915, 42.4704, 42.3348,
         42.1793, 41.9933, 41.7525, 41.3935, 40.6536, 39.9411, 38.6303, 37.0523, 38.6579, 40.11, 40.1953, 41.7384,
         42.3426, 42.7056, 42.952, 43.1118, 43.218, 43.2885, 43.3341, 43.3624, 43.3789, 43.4189, 43.4135, 43.4018,
         43.3859, 43.3675, 43.3477, 43.3271, 43.3064, 43.286, 43.2669, 43.2479, 43.2291, 43.2109, 43.1935, 43.1771,
         43.1617, 43.1474, 43.1342, 43.1219, 43.1106, 43.1002, 43.0907, 43.082, 43.0741, 43.0669, 43.0603, 43.0543,
         43.0489, 43.044, 43.0396, 43.0356, 43.0319, 43.0287, 43.0257, 43.023],
        [0.0, 0.0, 0.0, 0.28287, 0.2741, 0.27348, 0.26479, 0.26254, 1.3562, 1.316, 1.9224, 2.4517, 3.1433, 4.0047,
         5.0239, 6.1624, 7.3533, 8.5056, 9.5168, 10.29, 10.753, 10.869, 10.643, 10.118, 9.3601, 8.4491, 7.4627, 6.4738,
         5.5364, 4.6841, 4.6393, 4.4606, 4.4142, 9.2224, 8.7692, 8.1102, 6.4701, 5.2237, 4.2849, 3.5682, 3.0159, 2.5871,
         2.2526, 2.11, 2.0523, 2.0376, 2.1929, 2.1696, 2.1457, 1.9838, 1.8436, 1.7381, 1.6596, 1.6023, 1.5616, 1.5338,
         1.516, 1.5058, 1.5076, 1.5202, 1.5352, 1.5516, 1.568, 1.5835, 1.5974, 1.609, 1.6179, 1.6235, 1.6239, 1.6245,
         1.6246, 1.6247, 4.4826, 4.5451, 4.6135, 6.6747, 6.7057, 7.1221, 7.2981, 9.9312, 13.083, 16.043, 18.465, 20.151,
         21.056, 21.258, 21.248, 21.23, 21.217, 23.814, 23.757, 23.727, 23.633, 23.604, 24.693, 24.67, 24.574, 23.978,
         22.983, 22.175, 21.894, 21.819, 22.778, 22.693, 22.41, 21.484, 20.157, 18.842, 17.572, 16.319, 15.113, 13.979,
         12.921, 11.935, 10.834, 9.8127, 8.9011, 8.0867, 7.3578, 6.7054, 6.121, 5.5959, 5.0865, 4.619, 4.2, 3.8225,
         3.4791, 3.1701, 3.0348, 2.972, 2.9556, 11.112, 10.908, 10.811, 10.76, 10.462, 10.384, 14.318, 13.966, 13.532,
         13.001, 12.694, 12.611, 14.368, 14.032, 12.651, 11.386, 10.235, 9.1995, 8.2654, 7.4299, 6.6808, 6.0099, 5.3838,
         4.813, 4.2974, 3.8397, 3.434, 3.074, 2.7519, 2.4588, 2.1809, 1.9363, 1.7198, 1.5276, 1.3533, 1.1976, 1.0573,
         0.93432, 0.8264, 0.73162, 0.64823, 0.57486, 0.5496, 0.53488, 0.53106, 3.6354, 3.539, 3.5286, 3.1461, 2.8263,
         2.5402, 2.2694, 2.021, 1.7999, 1.6032, 1.4282, 1.2725, 1.1338, 1.0031, 0.88705, 0.78449, 0.69384, 0.61369,
         0.54278, 0.47993, 0.42419, 0.37495, 0.331, 0.29131, 0.25624, 0.22515, 0.19785, 0.17387, 0.1528, 0.13429,
         0.11803, 0.10374, 0.091183, 0.080151, 0.070456, 0.061936, 0.054449, 0.047869, 0.042085, 0.037001, 0.032533,
         0.028605, 0.025152, 0.022117, 0.019448, 0.017102, 0.01504, 0.013226]],
    'Ru':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.042238, 0.0428845, 0.0430569, 0.0433155, 0.04340198, 0.043962,
         0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.073402, 0.07401695,
         0.0745255, 0.0748251, 0.0752745, 0.076398, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284,
         0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709,
         0.2152655, 0.2301188, 0.245997, 0.2629708, 0.273812, 0.277928, 0.278003, 0.2791206, 0.280797, 0.2811158,
         0.282182, 0.2833164, 0.285018, 0.289272, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189,
         0.4484657, 0.451388, 0.458297, 0.4601394, 0.462903, 0.469812, 0.473144, 0.4794098, 0.480386, 0.4823172,
         0.485214, 0.492456, 0.5124891, 0.5478508, 0.5733, 0.582075, 0.584415, 0.5856525, 0.587925, 0.5967, 0.6260625,
         0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098,
         1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848,
         2.717235, 2.781142, 2.82371, 2.835062, 2.852089, 2.894658, 2.904724, 2.907562, 2.952066, 2.963933, 2.981735,
         3.026238, 3.10515, 3.15952, 3.20788, 3.220776, 3.24012, 3.28848, 3.319406, 3.548445, 3.793288, 4.055024,
         4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789,
         9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961,
         18.81398, 20.11215, 21.49988, 21.67486, 22.00661, 22.09508, 22.22779, 22.55954, 22.98338, 24.56923, 26.2645,
         28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721,
         58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931,
         121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835,
         253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [1.00155, 1.21062, 1.45119, 1.72392, 2.02883, 2.36557, 2.73311, 3.12973, 3.55307, 4.00016, 4.46753, 4.95122,
         5.44688, 5.94974, 6.45448, 6.95483, 7.44255, 7.9047, 8.3158, 8.60832, 8.4035, 7.19875, 4.95206, 1.97649,
         5.41269, 6.14069, 8.52148, 11.7689, 13.2029, 13.9004, 14.3271, 14.6223, 14.8381, 14.9907, 15.0472, 15.0352,
         15.0028, 14.9268, 15.0174, 15.111, 15.2164, 15.3454, 15.4374, 15.5029, 15.5443, 15.5624, 15.5564, 15.5248,
         15.453, 15.3607, 15.2304, 15.0544, 14.8216, 14.5159, 14.1129, 13.5743, 12.8364, 11.7634, 9.99936, 7.92428,
         6.16444, 6.10788, 4.61041, 5.30456, 5.34954, 5.2651, 4.50713, 5.36581, 5.99852, 6.05492, 5.99312, 6.94055,
         8.82922, 11.3403, 13.9957, 15.9267, 15.9534, 15.3295, 14.0529, 15.6982, 17.4209, 17.8891, 18.4095, 18.4097,
         18.0427, 19.0159, 20.3756, 22.7608, 25.6936, 27.0826, 27.1746, 26.8006, 26.9064, 27.5104, 28.4278, 30.2296,
         32.085, 33.5416, 34.717, 35.6847, 36.4799, 37.1117, 37.6704, 38.0802, 38.383, 38.5496, 38.6027, 38.5796,
         38.4965, 38.3601, 38.1767, 37.9482, 37.6565, 37.2619, 36.7266, 35.9697, 34.7747, 32.2942, 30.2369, 26.5904,
         22.4727, 26.378, 29.5073, 29.7685, 29.8248, 29.449, 27.6815, 29.9606, 32.7712, 34.9892, 35.6507, 35.5236,
         34.7222, 35.884, 37.1842, 37.6671, 39.5868, 40.8496, 42.0086, 42.7363, 43.2299, 43.573, 43.8127, 43.9808,
         44.2178, 44.3028, 44.3118, 44.29, 44.2488, 44.1964, 44.1479, 44.0745, 43.9861, 43.8895, 43.7875, 43.6812,
         43.5675, 43.444, 43.3048, 43.1438, 42.9479, 42.6871, 42.2765, 41.2619, 40.9604, 39.6567, 38.0877, 39.6841,
         41.1276, 41.8441, 42.9361, 43.4577, 43.7905, 44.0056, 44.1468, 44.2409, 44.3031, 44.343, 44.3672, 44.415,
         44.4167, 44.4093, 44.3964, 44.3798, 44.3612, 44.3413, 44.3209, 44.3008, 44.2821, 44.262, 44.2424, 44.2236,
         44.2056, 44.1885, 44.1724, 44.1573, 44.1433, 44.1304, 44.1184, 44.1074, 44.0973, 44.0881, 44.0796, 44.0719,
         44.0649, 44.0585, 44.0527, 44.0475, 44.0427, 44.0384, 44.0345, 44.031, 44.0278, 44.025],
        [5.1187, 5.4437, 5.773, 6.1017, 6.4268, 6.7445, 7.0507, 7.3418, 7.6143, 7.8653, 8.0923, 8.2934, 8.4674, 8.6137,
         8.7324, 8.8241, 8.89, 8.9319, 8.9519, 8.9057, 8.608, 8.4221, 8.349, 8.3296, 14.303, 14.235, 13.811, 12.25,
         10.748, 9.6507, 8.8029, 8.1135, 7.5299, 7.0211, 6.6222, 6.5681, 6.5243, 6.4988, 6.6227, 6.5353, 6.3367, 5.9877,
         5.6701, 5.3793, 5.1122, 4.8664, 4.6398, 4.4308, 4.2376, 4.0589, 3.8933, 3.7394, 3.5959, 3.4611, 3.3336, 3.2125,
         3.0966, 2.9852, 2.8775, 2.8139, 2.7907, 2.7902, 2.784, 5.2239, 5.2405, 5.2969, 5.3584, 7.1567, 7.5805, 8.891,
         11.975, 15.257, 18.158, 20.327, 21.614, 22.049, 22.05, 22.028, 22.017, 24.785, 24.722, 24.682, 24.59, 24.574,
         24.541, 25.694, 25.556, 25.078, 24.006, 23.139, 22.832, 22.75, 23.702, 23.622, 23.314, 22.293, 20.854, 19.435,
         18.073, 16.761, 15.496, 14.312, 13.21, 12.096, 11.038, 9.9896, 9.055, 8.2212, 7.4755, 6.8087, 6.2118, 5.6769,
         5.1681, 4.692, 4.2654, 3.8813, 3.532, 3.2179, 3.1159, 3.0513, 3.0344, 10.932, 10.698, 10.643, 10.628, 10.395,
         10.334, 14.292, 14.151, 13.295, 12.738, 12.272, 12.154, 13.854, 13.431, 13.184, 11.858, 11.047, 10.035, 9.0167,
         8.0998, 7.2799, 6.5464, 5.8883, 5.2718, 4.7148, 4.2116, 3.7656, 3.37, 3.0188, 2.6988, 2.3932, 2.1242, 1.8872,
         1.6774, 1.4903, 1.321, 1.1691, 1.0329, 0.91336, 0.8084, 0.71616, 0.63499, 0.56348, 0.5554, 0.54057, 0.53673,
         3.6233, 3.5276, 3.4109, 3.0547, 2.7483, 2.4608, 2.194, 1.954, 1.7404, 1.5504, 1.3813, 1.2307, 1.0952, 0.96878,
         0.85705, 0.75827, 0.67093, 0.59365, 0.52527, 0.46455, 0.41073, 0.36268, 0.3193, 0.28113, 0.24728, 0.21738,
         0.1911, 0.16801, 0.14771, 0.12987, 0.11419, 0.10041, 0.088295, 0.077645, 0.068282, 0.06005, 0.052813, 0.046449,
         0.040854, 0.035934, 0.031607, 0.027802, 0.024456, 0.021513, 0.018925, 0.016649, 0.014647]],
    'Rh':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.046942, 0.0476605, 0.0478521, 0.0481395,
         0.048858, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411,
         0.07938, 0.080595, 0.080919, 0.081405, 0.08262, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581,
         0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655,
         0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.30086, 0.305466, 0.306693, 0.308535, 0.3101415,
         0.3113883, 0.3132585, 0.317934, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098,
         0.486276, 0.493719, 0.4957038, 0.498681, 0.506124, 0.51058, 0.5124891, 0.518395, 0.520479, 0.523605, 0.53142,
         0.5478508, 0.5856525, 0.614558, 0.6239645, 0.6260625, 0.6264729, 0.6302355, 0.639642, 0.6692609, 0.7154399,
         0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281,
         1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724,
         2.943724, 2.988781, 3.000796, 3.018819, 3.063876, 3.083178, 3.10515, 3.13037, 3.142954, 3.161831, 3.209022,
         3.319406, 3.343662, 3.394841, 3.408488, 3.42896, 3.480138, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924,
         4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919,
         10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215,
         21.49988, 22.7555, 22.98338, 23.1038, 23.19668, 23.336, 23.6843, 24.56923, 26.2645, 28.07676, 30.01405,
         32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287,
         66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669,
         139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869,
         290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [1.89417, 2.09662, 2.32705, 2.58575, 2.87263, 3.18714, 3.52819, 3.89415, 4.28288, 4.69173, 5.11762, 5.5571,
         6.00634, 6.46121, 6.91721, 7.36933, 7.81174, 8.23697, 8.63416, 8.98459, 9.24829, 9.31015, 8.53632, 8.00116,
         5.95081, 3.21176, 6.39978, 9.28778, 10.5693, 12.9851, 13.8997, 14.401, 14.736, 14.9838, 15.1694, 15.2714,
         15.2708, 15.2279, 15.148, 15.2468, 15.3518, 15.4415, 15.6159, 15.7489, 15.8551, 15.9375, 15.9967, 16.0318,
         16.0413, 16.017, 15.9658, 15.8769, 15.7426, 15.5526, 15.2919, 14.9381, 14.4564, 13.7917, 12.8315, 11.3237,
         8.15945, 8.05768, 5.95237, 4.17242, 5.06359, 5.04698, 4.14952, 5.23483, 6.10712, 6.30213, 6.53387, 7.463,
         9.35507, 11.9079, 14.6475, 16.7922, 16.9162, 16.2427, 14.8958, 16.622, 18.4232, 19.015, 19.2134, 19.5194,
         19.125, 20.1348, 21.5333, 23.4547, 26.5544, 28.0923, 28.1885, 27.947, 27.8066, 28.5331, 29.4719, 31.2211,
         33.1285, 34.6156, 35.8079, 36.7848, 37.5849, 38.2442, 38.7727, 39.1539, 39.4325, 39.6085, 39.6637, 39.6411,
         39.5546, 39.4114, 39.2194, 38.9783, 38.6746, 38.2656, 37.7071, 36.909, 35.6223, 32.7378, 31.4079, 27.8447,
         23.8203, 27.6279, 30.7009, 31.1221, 31.2624, 30.7066, 28.999, 31.2954, 33.7259, 35.9162, 36.1407, 36.0599,
         35.2798, 36.4699, 37.865, 38.9158, 41.1094, 42.4388, 43.3289, 43.95, 44.3826, 44.6862, 44.8983, 45.13, 45.261,
         45.3329, 45.3324, 45.3055, 45.2629, 45.2202, 45.1573, 45.0732, 44.9788, 44.8783, 44.7736, 44.6648, 44.5483,
         44.4213, 44.2772, 44.1089, 43.9001, 43.6125, 43.1259, 41.9842, 41.3616, 40.6879, 39.1279, 40.7147, 42.1495,
         43.2772, 44.1227, 44.5784, 44.8642, 45.0536, 45.1785, 45.2617, 45.3162, 45.3506, 45.3709, 45.4151, 45.4136,
         45.4044, 45.3903, 45.3732, 45.3543, 45.3345, 45.3146, 45.2951, 45.2749, 45.2549, 45.2356, 45.2171, 45.1994,
         45.1827, 45.167, 45.1524, 45.1388, 45.1262, 45.1146, 45.1039, 45.0942, 45.0852, 45.0771, 45.0696, 45.0628,
         45.0566, 45.051, 45.046, 45.0414, 45.0372, 45.0334, 45.03, 45.027],
        [4.8055, 5.1028, 5.4019, 5.6998, 5.9931, 6.2786, 6.5531, 6.8134, 7.0566, 7.2804, 7.4824, 7.6611, 7.8152, 7.9443,
         8.0481, 8.127, 8.1819, 8.214, 8.2249, 8.2164, 8.1907, 8.1499, 8.0962, 8.0857, 8.0228, 8.006, 13.516, 13.044,
         12.595, 10.918, 9.7195, 8.8533, 8.1819, 7.6317, 7.1613, 6.7471, 6.7282, 6.6405, 6.6177, 6.7567, 6.6791, 6.56,
         6.2449, 5.9577, 5.6935, 5.4491, 5.2222, 5.0111, 4.8142, 4.6301, 4.4576, 4.2954, 4.1424, 3.9976, 3.8596, 3.7268,
         3.5984, 3.4736, 3.3517, 3.2323, 3.1149, 3.1128, 3.0864, 3.0794, 6.0229, 6.1078, 6.1755, 8.3433, 8.8068, 9.158,
         12.03, 15.371, 18.361, 20.619, 21.977, 22.452, 22.452, 22.416, 22.401, 25.308, 25.227, 25.166, 25.137, 25.037,
         24.998, 26.203, 26.042, 25.646, 24.527, 23.568, 23.249, 23.177, 23.163, 24.053, 23.731, 22.73, 21.237, 19.768,
         18.361, 17.016, 15.729, 14.525, 13.315, 12.186, 11.14, 10.098, 9.1498, 8.3038, 7.5479, 6.8721, 6.2674, 5.7258,
         5.2173, 4.7367, 4.3058, 3.918, 3.5657, 3.2488, 3.1893, 3.1231, 3.1056, 10.824, 10.604, 10.512, 10.409, 10.293,
         10.236, 13.993, 13.691, 13.008, 12.857, 12.545, 12.463, 14.209, 13.89, 13.477, 12.138, 10.918, 9.8125, 8.8157,
         7.9204, 7.1193, 6.402, 5.7551, 5.1523, 4.6094, 4.1209, 3.6875, 3.3029, 2.954, 2.6207, 2.3256, 2.0656, 1.8364,
         1.6333, 1.4515, 1.2873, 1.1391, 1.0071, 0.89111, 0.78923, 0.69962, 0.62075, 0.56105, 0.55121, 0.54612, 0.54225,
         3.6109, 3.5161, 3.2962, 2.9629, 2.6567, 2.3762, 2.1169, 1.8854, 1.6795, 1.4962, 1.3331, 1.1878, 1.0551, 0.9337,
         0.82632, 0.73135, 0.64735, 0.57299, 0.50717, 0.44872, 0.39644, 0.34922, 0.30765, 0.27104, 0.23849, 0.20982,
         0.18461, 0.16243, 0.14293, 0.12577, 0.11068, 0.097405, 0.085725, 0.07545, 0.066408, 0.058453, 0.051453,
         0.045293, 0.039872, 0.035101, 0.030902, 0.027206, 0.023953, 0.02109, 0.01857, 0.016351]],
    'Pd':                                                                                                         [
        [0.004918045, 0.004993321, 0.005013395, 0.005043505, 0.005118781, 0.005337699, 0.005419399, 0.005441185,
         0.005473865, 0.005555565, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306,
         0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327,
         0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.050078,
         0.0508445, 0.0510489, 0.0513555, 0.052122, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942,
         0.07401695, 0.07912411, 0.08458368, 0.084672, 0.085968, 0.0863136, 0.086832, 0.088128, 0.09041995, 0.09665893,
         0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732,
         0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.328006, 0.3332,
         0.3343653, 0.3363735, 0.3383, 0.33966, 0.3417, 0.3434143, 0.3468, 0.3671099, 0.3924405, 0.4195189, 0.4484657,
         0.4794098, 0.5124891, 0.52087, 0.5288425, 0.5309685, 0.5341575, 0.54213, 0.5478508, 0.547918, 0.5563045,
         0.5585409, 0.5618955, 0.570282, 0.5856525, 0.6260625, 0.656502, 0.6665505, 0.6692609, 0.6732495, 0.683298,
         0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285,
         1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235,
         2.904724, 3.10515, 3.109834, 3.157434, 3.170127, 3.189167, 3.236766, 3.263694, 3.313649, 3.319406, 3.32697,
         3.346952, 3.396906, 3.532214, 3.548445, 3.586279, 3.600696, 3.622322, 3.676386, 3.793288, 4.055024, 4.334821,
         4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794,
         9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398,
         20.11215, 21.49988, 22.98338, 23.86329, 24.22855, 24.32595, 24.47205, 24.56923, 24.83731, 26.2645, 28.07676,
         30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927,
         62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587,
         130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699,
         271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [6.71496, 6.11262, 5.44009, 6.10578, 6.63715, 6.79644, 6.49543, 6.06873, 6.55164, 6.98189, 6.01744, 6.42158,
         7.09077, 8.02678, 9.19859, 10.5437, 12.1215, 13.6564, 14.9854, 16.1464, 17.0936, 17.8069, 18.2908, 18.5688,
         18.6751, 18.6465, 18.5158, 18.3091, 18.0435, 17.7246, 17.3419, 16.8525, 16.1137, 14.2976, 13.623, 10.9636,
         7.5959, 11.4201, 14.7671, 16.2824, 18.3065, 18.6618, 18.6221, 18.4661, 18.275, 18.0705, 17.8268, 17.8216,
         17.7138, 17.6255, 17.6845, 17.7103, 17.6846, 17.5705, 17.4529, 17.342, 17.2375, 17.1364, 17.0353, 16.9303,
         16.8155, 16.6888, 16.5424, 16.3683, 16.1564, 15.8928, 15.5574, 15.1204, 14.5368, 13.7202, 12.4975, 10.3106,
         9.03284, 7.08114, 5.69216, 6.38916, 6.32003, 5.52007, 6.37537, 6.72139, 6.99095, 6.90251, 7.18951, 8.67316,
         11.0867, 13.9123, 16.2885, 16.4916, 15.8269, 14.4342, 16.2489, 18.169, 18.9247, 18.9321, 19.4716, 19.0688,
         20.1262, 21.6034, 23.4214, 26.8121, 28.4827, 28.6202, 28.2322, 28.9922, 29.9729, 31.8543, 33.881, 35.4626,
         36.7357, 37.7973, 38.7285, 39.4074, 39.8884, 40.2408, 40.4949, 40.6675, 40.7247, 40.6964, 40.617, 40.4717,
         40.2765, 40.0306, 39.7193, 39.2989, 38.719, 37.8775, 36.4793, 32.9123, 32.7326, 29.3641, 25.6358, 29.0306,
         31.7693, 32.234, 31.7769, 31.4036, 30.1956, 32.3154, 34.5954, 36.9631, 37.0718, 36.9573, 36.2, 37.409, 38.8586,
         40.5122, 42.5804, 43.7716, 44.5459, 45.0808, 45.4549, 45.7234, 45.9179, 46.1414, 46.2653, 46.3334, 46.3307,
         46.3063, 46.2851, 46.2264, 46.1473, 46.0568, 45.959, 45.8564, 45.7502, 45.6397, 45.5209, 45.3904, 45.241,
         45.0641, 44.8392, 44.5155, 43.9078, 43.0041, 41.7152, 40.1649, 41.7399, 42.3366, 43.1644, 44.6043, 45.2922,
         45.6821, 45.933, 46.0979, 46.2076, 46.2804, 46.3277, 46.3569, 46.3737, 46.4139, 46.4097, 46.3988, 46.3839,
         46.3663, 46.3473, 46.3277, 46.3082, 46.288, 46.2677, 46.2479, 46.2288, 46.2106, 46.1933, 46.177, 46.1617,
         46.1475, 46.1343, 46.1221, 46.1109, 46.1005, 46.0911, 46.0824, 46.0745, 46.0673, 46.0607, 46.0548, 46.0494,
         46.0445, 46.04, 46.036, 46.0323, 46.0291],
        [0.0, 0.0, 0.0, 1.2926, 1.2527, 1.1464, 1.1101, 1.1007, 1.9521, 1.8837, 5.9028, 6.958, 7.9974, 8.9357, 9.6879,
         10.183, 10.377, 10.26, 9.8569, 9.2189, 8.4134, 7.512, 6.5829, 5.6822, 4.8484, 4.1035, 3.4558, 2.9046, 2.4427,
         2.0602, 1.7461, 1.4895, 1.2807, 1.1109, 1.0892, 1.0562, 1.0478, 7.7492, 7.1742, 6.5676, 4.6854, 3.4892, 2.7454,
         2.2608, 1.9334, 1.7064, 1.5464, 1.5443, 1.5151, 1.5077, 1.6484, 1.6287, 1.5993, 1.5516, 1.538, 1.5483, 1.5724,
         1.6069, 1.6492, 1.6973, 1.7494, 1.8042, 1.8604, 1.9166, 1.9719, 2.0248, 2.0736, 2.1173, 2.1553, 2.1866, 2.2108,
         2.2275, 2.2311, 2.2334, 2.2338, 4.6967, 4.7964, 4.8687, 6.7251, 6.8812, 7.203, 9.5564, 13.17, 16.686, 19.54,
         21.425, 22.29, 22.359, 22.378, 22.376, 25.425, 25.386, 25.337, 25.336, 25.236, 25.204, 26.465, 26.325, 26.01,
         24.928, 23.978, 23.654, 23.566, 24.461, 24.134, 23.094, 21.563, 20.056, 18.617, 17.25, 15.952, 14.612, 13.372,
         12.224, 11.173, 10.16, 9.2068, 8.3565, 7.5968, 6.9175, 6.3097, 5.7651, 5.2551, 4.7721, 4.3369, 3.9451, 3.5896,
         3.227, 3.2184, 3.133, 3.1109, 10.218, 10.188, 10.172, 10.145, 10.142, 10.138, 13.662, 13.509, 12.986, 12.905,
         12.71, 12.634, 14.377, 14.066, 13.384, 11.932, 10.633, 9.5222, 8.5451, 7.6856, 6.923, 6.2398, 5.6154, 5.0297,
         4.5015, 4.0278, 3.6074, 3.2259, 2.8623, 2.5411, 2.2566, 2.0056, 1.7844, 1.5881, 1.4114, 1.2523, 1.108, 0.98014,
         0.86786, 0.76913, 0.68225, 0.60572, 0.56667, 0.55164, 0.54775, 3.5968, 3.572, 3.5051, 3.1939, 2.8664, 2.5645,
         2.2894, 2.039, 1.8163, 1.6181, 1.4416, 1.2846, 1.1447, 1.0151, 0.89866, 0.79565, 0.70451, 0.62385, 0.55241,
         0.48916, 0.43235, 0.38101, 0.33579, 0.29595, 0.2608, 0.22958, 0.20211, 0.17794, 0.15666, 0.13794, 0.12146,
         0.10695, 0.094185, 0.082944, 0.073048, 0.064336, 0.056665, 0.049911, 0.043964, 0.038726, 0.034114, 0.030053,
         0.026475, 0.023325, 0.02055, 0.018106]],
    'Ag':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.054782, 0.0556205,
         0.0558441, 0.0561795, 0.05667876, 0.057018, 0.06058959, 0.061348, 0.062287, 0.0625374, 0.062913, 0.063852,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.093296, 0.094724, 0.0951048,
         0.095676, 0.09665893, 0.097104, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005,
         0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128,
         0.3212482, 0.3434143, 0.359366, 0.3648665, 0.365344, 0.3663333, 0.3671099, 0.3685335, 0.370936, 0.3724272,
         0.374034, 0.374664, 0.380256, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.559972,
         0.568543, 0.5708286, 0.574257, 0.582828, 0.5856525, 0.590352, 0.599388, 0.6017976, 0.605412, 0.614448,
         0.6260625, 0.6692609, 0.70315, 0.7139125, 0.7154399, 0.7167825, 0.7210875, 0.73185, 0.7648052, 0.8175768,
         0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329,
         1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.284078,
         3.319406, 3.334344, 3.347749, 3.367855, 3.418122, 3.453226, 3.506081, 3.520176, 3.541318, 3.548445, 3.594174,
         3.729684, 3.786771, 3.793288, 3.801994, 3.824829, 3.881916, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467,
         5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212,
         11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338,
         24.56923, 25.00372, 25.38643, 25.48849, 25.64157, 26.02428, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889,
         36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536,
         76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864,
         159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304,
         331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [2.8409, 3.04646, 3.28198, 3.54889, 3.84865, 4.17867, 4.53536, 4.91531, 5.31506, 5.73104, 6.1596, 6.59705,
         7.03979, 7.48426, 7.92702, 8.36475, 8.79411, 9.21172, 9.61381, 9.99579, 10.3512, 10.6696, 10.9302, 11.0819,
         10.925, 10.3446, 9.15723, 7.57811, 9.41576, 10.6211, 11.065, 12.6538, 12.6611, 12.23, 11.4631, 12.4638,
         13.4374, 13.8959, 14.9135, 15.3648, 15.6512, 15.8628, 16.0128, 16.039, 15.9917, 15.9036, 16.0128, 16.103,
         16.1295, 16.3562, 16.5356, 16.6898, 16.8238, 16.9382, 17.0318, 17.1026, 17.1474, 17.164, 17.1454, 17.0808,
         16.9624, 16.776, 16.5012, 16.1067, 15.5436, 14.727, 13.4807, 11.3239, 8.17693, 5.38571, 4.87928, 2.9088,
         2.81916, 4.33783, 4.39445, 3.12064, 4.35482, 4.77825, 6.26493, 7.23412, 8.52533, 10.6783, 13.4741, 16.4378,
         18.8361, 19.1053, 18.3518, 16.8858, 18.7523, 20.6937, 21.0721, 21.5803, 22.0441, 21.6033, 22.6665, 24.1171,
         25.3913, 28.7197, 30.3701, 30.4724, 30.3653, 30.0829, 30.826, 31.7868, 33.5328, 35.4838, 36.9977, 38.2082,
         39.2179, 40.0468, 40.6725, 41.1291, 41.4587, 41.6876, 41.8417, 41.8978, 41.8626, 41.7704, 41.6141, 41.4062,
         41.1462, 40.818, 40.3771, 39.7652, 38.8627, 37.3492, 33.9635, 32.0969, 30.5512, 26.7378, 30.2844, 33.1732,
         33.7562, 33.2333, 31.5999, 33.7502, 34.2479, 36.024, 38.1788, 38.1381, 37.9709, 37.3722, 38.566, 39.9808,
         42.0364, 43.8319, 44.9334, 45.6723, 46.1852, 46.5439, 46.7976, 46.9766, 47.1807, 47.2894, 47.3505, 47.3467,
         47.3333, 47.2863, 47.2146, 47.1294, 47.0354, 46.9353, 46.8312, 46.7237, 46.6114, 46.49, 46.3552, 46.1995,
         46.0118, 45.766, 45.3918, 44.566, 44.0222, 42.7404, 41.1991, 42.7653, 44.1811, 44.5838, 45.861, 46.4369,
         46.7849, 46.9986, 47.1402, 47.2353, 47.2982, 47.3384, 47.3627, 47.4096, 47.412, 47.4053, 47.393, 47.3772,
         47.3593, 47.3402, 47.321, 47.301, 47.2805, 47.2603, 47.2407, 47.222, 47.2041, 47.1872, 47.1713, 47.1564,
         47.1426, 47.1298, 47.118, 47.1071, 47.0971, 47.088, 47.0796, 47.072, 47.065, 47.0587, 47.0529, 47.0477,
         47.0429, 47.0386, 47.0348, 47.0313],
        [4.5969, 4.905, 5.2143, 5.5216, 5.8214, 6.1064, 6.3737, 6.6206, 6.8451, 7.0457, 7.2214, 7.3718, 7.4968, 7.597,
         7.6732, 7.7266, 7.7586, 7.7709, 7.7652, 7.7435, 7.7077, 7.6596, 7.6011, 7.534, 7.4599, 7.4215, 7.4033, 7.3984,
         10.577, 10.414, 10.308, 9.3944, 9.239, 9.053, 9.0013, 10.557, 10.25, 9.9783, 8.947, 8.2211, 7.687, 7.2641,
         6.9106, 6.7617, 6.6926, 6.6746, 6.8386, 6.7975, 6.7793, 6.548, 6.3253, 6.1216, 5.9328, 5.7564, 5.5901, 5.4324,
         5.2817, 5.137, 4.997, 4.8607, 4.7272, 4.5956, 4.4645, 4.3331, 4.2008, 4.0673, 3.9327, 3.797, 3.7041, 3.673,
         3.6703, 3.6648, 7.801, 7.8731, 7.9977, 8.0768, 11.122, 11.18, 11.714, 12.994, 16.302, 19.39, 21.687, 23.018,
         23.418, 23.372, 23.295, 23.269, 26.407, 26.281, 26.233, 26.149, 25.967, 25.915, 27.194, 26.984, 26.689, 25.43,
         24.352, 24.005, 23.955, 23.912, 24.813, 24.467, 23.424, 21.84, 20.291, 18.813, 17.415, 15.985, 14.642, 13.398,
         12.245, 11.189, 10.211, 9.2467, 8.3868, 7.6195, 6.9336, 6.3204, 5.7714, 5.2608, 4.7785, 4.3434, 3.9522, 3.551,
         3.2163, 3.1564, 3.1317, 3.1097, 10.402, 10.281, 10.2, 10.08, 10.043, 13.624, 13.594, 13.398, 12.784, 12.494,
         12.461, 12.416, 14.155, 13.844, 12.923, 11.573, 10.367, 9.3056, 8.3559, 7.5133, 6.7612, 6.0868, 5.4706, 4.901,
         4.3883, 3.93, 3.5141, 3.1173, 2.7679, 2.4591, 2.1854, 1.9437, 1.7304, 1.5411, 1.3695, 1.2159, 1.0755, 0.95208,
         0.84356, 0.74808, 0.66401, 0.5899, 0.57193, 0.55683, 0.55291, 3.5841, 3.4923, 3.4365, 3.0917, 2.7803, 2.477,
         2.2014, 1.9609, 1.7469, 1.5564, 1.3868, 1.2359, 1.1011, 0.97517, 0.86367, 0.765, 0.67765, 0.60032, 0.5318,
         0.47041, 0.41471, 0.36563, 0.32238, 0.28427, 0.25054, 0.2207, 0.19442, 0.17128, 0.1509, 0.13295, 0.11714,
         0.10322, 0.090955, 0.080152, 0.070635, 0.06225, 0.054863, 0.048355, 0.04262, 0.037567, 0.033114, 0.02919,
         0.025732, 0.022684, 0.019998]],
    'Cd':                                                                                                         [
        [0.009114, 0.0092535, 0.0092907, 0.0093465, 0.009486, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.065562, 0.0665655, 0.0668331, 0.0672345,
         0.068238, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.105448,
         0.107062, 0.1074924, 0.108138, 0.109752, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005,
         0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128,
         0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.395626, 0.4016815, 0.40229, 0.4032963, 0.4057185, 0.4084475,
         0.4100895, 0.411774, 0.4125525, 0.41871, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525,
         0.60417, 0.6134175, 0.6158835, 0.6195825, 0.6260625, 0.62883, 0.637686, 0.6474465, 0.6500493, 0.6539535,
         0.663714, 0.6692609, 0.7154399, 0.754796, 0.7648052, 0.766349, 0.7694298, 0.774051, 0.785604, 0.8175768,
         0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329,
         1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406,
         3.46675, 3.519812, 3.533962, 3.548445, 3.555187, 3.60825, 3.65246, 3.708365, 3.723273, 3.745635, 3.793288,
         3.80154, 3.93764, 3.99791, 4.013982, 4.03809, 4.055024, 4.09836, 4.334821, 4.633924, 4.953664, 5.295467,
         5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212,
         11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338,
         24.56923, 26.17698, 26.2645, 26.57764, 26.68449, 26.84476, 27.24542, 28.07676, 30.01405, 32.08502, 34.29889,
         36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536,
         76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864,
         159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304,
         331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [-0.255482, -1.31522, -2.57675, -1.23253, -0.0888866, 0.805089, 0.447887, -0.0465177, -0.638675, -1.31418,
         -2.0534, -2.81785, -3.54108, -4.12454, -4.44143, -4.35157, -3.72673, -2.48166, -0.601492, 1.84418, 4.65148,
         7.72864, 10.7988, 13.6598, 16.1566, 18.1877, 19.7108, 20.7453, 21.3457, 21.578, 21.4957, 21.0974, 20.0512,
         19.594, 18.1776, 16.4471, 18.353, 19.987, 20.6144, 21.4606, 21.3777, 21.0768, 20.7147, 20.3349, 19.9289,
         19.7777, 19.5992, 19.4588, 19.5484, 19.5803, 19.5713, 19.373, 19.1492, 18.933, 18.7262, 18.5253, 18.3249,
         18.1169, 17.9042, 17.6951, 17.4569, 17.1855, 16.8631, 16.4655, 15.9582, 15.2867, 14.359, 12.9964, 10.7613,
         5.74265, 4.46424, -0.152779, -1.19614, -4.5567, -1.56461, -1.12406, -3.26016, -0.911513, 0.0686458, 3.39588,
         3.65174, 8.37082, 11.9797, 15.4735, 18.6093, 21.0086, 21.3556, 20.4904, 18.9637, 20.8403, 22.3481, 22.7411,
         23.638, 24.011, 23.5362, 24.5866, 25.9872, 26.5609, 30.0001, 31.7476, 31.8609, 31.8163, 31.4077, 32.1559,
         33.107, 34.6667, 36.5926, 38.1048, 39.3637, 40.4395, 41.2418, 41.8352, 42.2838, 42.593, 42.8011, 42.9337,
         42.9952, 42.962, 42.8569, 42.6965, 42.4829, 42.2148, 41.8768, 41.4267, 40.8113, 39.9196, 38.0892, 35.1406,
         31.687, 27.7885, 30.356, 31.4895, 34.5292, 35.2329, 34.6373, 32.9486, 35.1307, 37.1821, 37.3998, 39.3697,
         39.2963, 38.5238, 39.7007, 40.229, 41.0801, 43.4595, 45.0537, 46.0867, 46.7933, 47.2835, 47.625, 47.8624,
         48.0258, 48.2126, 48.3099, 48.3643, 48.3786, 48.3459, 48.2818, 48.2016, 48.1115, 48.0147, 47.9129, 47.8076,
         47.6992, 47.585, 47.4612, 47.3218, 47.1592, 46.959, 46.687, 46.2404, 45.0549, 44.8946, 43.7823, 42.2514,
         43.8062, 45.2128, 46.1921, 47.0987, 47.5564, 47.8434, 48.0376, 48.1669, 48.2538, 48.3108, 48.3465, 48.367,
         48.4096, 48.4082, 48.3995, 48.3861, 48.3697, 48.3515, 48.333, 48.3135, 48.293, 48.2726, 48.2525, 48.2333,
         48.2149, 48.1974, 48.1809, 48.1654, 48.151, 48.1376, 48.1252, 48.1138, 48.1033, 48.0936, 48.0848, 48.0767,
         48.0694, 48.0627, 48.0566, 48.051, 48.046, 48.0414, 48.0373, 48.0335],
        [0.0, 0.0, 0.0, 2.4746, 2.3409, 1.5527, 1.4576, 1.5479, 1.8001, 2.2301, 2.8761, 3.7878, 5.0153, 6.5929, 8.5207,
         10.746, 13.156, 15.578, 17.804, 19.625, 20.871, 21.439, 21.312, 20.551, 19.278, 17.636, 15.795, 13.904, 12.077,
         10.39, 8.882, 7.5685, 6.4461, 6.2613, 6.0383, 5.9809, 9.3131, 8.8611, 8.4419, 6.8057, 5.6179, 4.7652, 4.1313,
         3.65, 3.2803, 3.1855, 3.1194, 3.1025, 3.3138, 3.2602, 3.2381, 3.0421, 2.8981, 2.7933, 2.7191, 2.6687, 2.6363,
         2.6226, 2.6536, 2.691, 2.7323, 2.775, 2.8169, 2.8562, 2.8906, 2.9178, 2.9368, 2.9468, 2.9475, 2.9384, 2.9367,
         2.933, 2.9326, 2.932, 10.686, 10.825, 10.908, 16.362, 16.428, 16.954, 17.024, 19.663, 22.013, 23.387, 23.936,
         23.768, 23.501, 23.338, 23.292, 26.48, 26.351, 26.294, 26.105, 25.888, 25.828, 27.128, 26.905, 26.776, 25.514,
         24.279, 23.969, 23.922, 23.827, 24.751, 24.4, 23.457, 21.905, 20.411, 18.998, 17.471, 16.005, 14.641, 13.382,
         12.216, 11.152, 10.182, 9.2462, 8.3851, 7.6167, 6.9297, 6.3148, 5.7641, 5.257, 4.7781, 4.3441, 3.9055, 3.4718,
         3.2183, 3.1345, 3.1128, 10.619, 10.592, 10.378, 10.205, 9.9942, 9.9338, 13.575, 13.324, 13.281, 12.588, 12.284,
         12.204, 13.936, 13.848, 13.626, 12.493, 11.248, 10.11, 9.0844, 8.1591, 7.3317, 6.5913, 5.9281, 5.3234, 4.7715,
         4.2744, 3.8216, 3.3892, 3.0085, 2.6731, 2.3769, 2.1138, 1.8813, 1.6761, 1.4934, 1.3271, 1.1782, 1.0427,
         0.92363, 0.81889, 0.72667, 0.64542, 0.57713, 0.57375, 0.56193, 0.55799, 3.5688, 3.478, 3.3013, 2.9524, 2.6447,
         2.3707, 2.1173, 1.8884, 1.6831, 1.4993, 1.3351, 1.1886, 1.0564, 0.93595, 0.82931, 0.73488, 0.65126, 0.57719,
         0.51076, 0.45045, 0.39729, 0.35043, 0.30911, 0.27268, 0.2404, 0.2119, 0.18679, 0.16466, 0.14517, 0.12798,
         0.11284, 0.099495, 0.087731, 0.077361, 0.06822, 0.060162, 0.053057, 0.046794, 0.041271, 0.036402, 0.032108,
         0.028321, 0.024982, 0.022038]],
    'In':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.015876, 0.01595306, 0.016119, 0.0161838,
         0.016281, 0.016524, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.075852, 0.077013,
         0.0773226, 0.077787, 0.078948, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797,
         0.119462, 0.1212905, 0.1217781, 0.1225095, 0.124338, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404,
         0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482,
         0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.434238, 0.4408845, 0.441784, 0.4426569, 0.4453155, 0.4484657,
         0.448546, 0.4503492, 0.451962, 0.453054, 0.459816, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625,
         0.651014, 0.6609785, 0.6636357, 0.6676215, 0.6692609, 0.677586, 0.688156, 0.698689, 0.7014978, 0.705711,
         0.7154399, 0.716244, 0.7648052, 0.809088, 0.8175768, 0.821472, 0.8247744, 0.829728, 0.842112, 0.8739896,
         0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795,
         1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.655498,
         3.711449, 3.72637, 3.74875, 3.793288, 3.804702, 3.85924, 3.91831, 3.934062, 3.95769, 4.01676, 4.055024,
         4.15275, 4.216313, 4.233263, 4.258688, 4.32225, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453,
         6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708,
         13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645,
         27.3811, 27.8002, 27.91196, 28.07676, 28.0796, 28.4987, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543,
         41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564,
         87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159,
         181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049,
         378.8588, 405.0001, 432.9451],
        [2.10675, 1.92675, 1.7038, 1.41977, 1.03965, 0.473339, -0.644411, -0.837616, -1.58291, -2.59561, -1.65847,
         -0.906518, -0.503092, -0.4089, -0.632308, -0.968126, -1.34282, -1.70181, -1.98858, -2.14107, -2.09479,
         -1.79013, -1.18182, -0.247938, 1.00374, 2.53426, 4.27733, 6.14773, 8.01761, 9.86577, 11.5783, 13.0912, 14.3529,
         15.3047, 15.764, 15.5786, 14.8156, 13.7034, 15.0356, 16.2971, 16.4066, 18.0342, 18.6695, 18.9771, 19.1093,
         19.1198, 19.003, 18.9541, 18.8183, 18.6749, 18.8039, 18.9026, 18.931, 18.9234, 18.8536, 18.758, 18.6457,
         18.5194, 18.3786, 18.2195, 18.0359, 17.8183, 17.5604, 17.2294, 16.8057, 16.2501, 15.5051, 14.4769, 12.9744,
         10.5627, 5.77615, -0.231978, -7.80538, -10.3777, -15.4694, -9.57113, -8.22734, -8.26674, -11.8403, -8.09054,
         -5.57207, 0.983374, 8.30071, 14.6157, 19.1024, 22.4492, 24.6655, 24.9558, 23.9656, 22.3863, 24.2457, 24.7328,
         26.0673, 26.9478, 27.1941, 26.6741, 27.7002, 28.9399, 29.0168, 32.2695, 33.9638, 34.0589, 33.9818, 33.5525,
         34.2947, 35.2159, 36.6029, 38.453, 40.0262, 41.3313, 42.213, 42.8776, 43.3582, 43.7113, 43.9566, 44.1135,
         44.2037, 44.2438, 44.1999, 44.0835, 43.911, 43.6841, 43.4025, 43.0533, 42.6007, 41.9395, 40.8316, 38.6509,
         36.3248, 32.8236, 28.8247, 32.7064, 35.574, 35.917, 36.7476, 36.0579, 34.3002, 36.5333, 38.8109, 39.5586,
         40.6024, 40.4916, 39.7108, 40.8706, 42.2127, 42.3881, 44.8579, 46.2849, 47.2544, 47.927, 48.3927, 48.7137,
         48.9322, 49.0788, 49.2898, 49.3396, 49.4159, 49.3952, 49.3405, 49.2665, 49.1806, 49.087, 48.9881, 48.885,
         48.7786, 48.6691, 48.5527, 48.4256, 48.2806, 48.109, 47.8919, 47.583, 47.0178, 46.0767, 44.811, 43.2899,
         44.812, 44.8324, 46.2279, 47.5892, 48.2836, 48.6701, 48.9207, 49.0881, 49.2, 49.2746, 49.323, 49.3526, 49.3689,
         49.4076, 49.4035, 49.3931, 49.3788, 49.3619, 49.3449, 49.326, 49.3055, 49.2849, 49.2645, 49.2447, 49.2257,
         49.2077, 49.1906, 49.1745, 49.1595, 49.1456, 49.1326, 49.1206, 49.1096, 49.0995, 49.0902, 49.0817, 49.0739,
         49.0668, 49.0603, 49.0545, 49.0491, 49.0443, 49.0399, 49.0359],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.931, 1.9665, 2.0444, 2.2269, 2.5294, 2.9881, 3.6169,
         4.4309, 5.4388, 6.6361, 7.9989, 9.4806, 11.013, 12.51, 13.88, 15.036, 15.908, 16.45, 16.647, 16.513, 16.084,
         15.414, 14.565, 13.597, 12.568, 12.186, 11.95, 11.888, 14.087, 13.725, 13.672, 12.163, 10.863, 9.7759, 8.8509,
         8.0593, 7.3815, 7.2738, 7.1376, 7.1024, 7.3213, 7.2014, 7.084, 6.6167, 6.2239, 5.8934, 5.6158, 5.3826, 5.186,
         5.0191, 4.8758, 4.7503, 4.6379, 4.5342, 4.4356, 4.3391, 4.2591, 4.1793, 4.0943, 4.0036, 3.9067, 3.8542, 3.8306,
         3.8274, 3.8243, 17.656, 17.68, 17.681, 17.695, 27.173, 27.187, 27.272, 27.512, 27.734, 27.329, 26.443, 25.263,
         24.496, 24.189, 24.108, 27.294, 27.245, 26.995, 26.681, 26.373, 26.292, 27.594, 27.322, 27.3, 25.935, 24.513,
         24.251, 24.132, 24.032, 24.967, 24.598, 23.685, 22.11, 20.631, 18.95, 17.387, 15.906, 14.538, 13.29, 12.14,
         11.086, 10.13, 9.2342, 8.371, 7.6005, 6.912, 6.2955, 5.7429, 5.2385, 4.7633, 4.279, 3.8064, 3.3869, 3.2169,
         3.1337, 3.1121, 10.81, 10.551, 10.487, 10.186, 9.8767, 9.8038, 13.528, 13.157, 12.926, 12.377, 12.056, 11.973,
         13.698, 13.387, 13.327, 12.054, 10.916, 9.8417, 8.8515, 7.9492, 7.1376, 6.4106, 5.7615, 5.1709, 4.6378, 4.1462,
         3.6763, 3.2627, 2.8984, 2.5771, 2.2933, 2.0411, 1.8179, 1.6207, 1.4441, 1.2838, 1.1395, 1.0092, 0.8945,
         0.79358, 0.70468, 0.62629, 0.57897, 0.56192, 0.55751, 3.5483, 3.5477, 3.4601, 3.172, 2.8394, 2.5429, 2.2763,
         2.0305, 1.8103, 1.6133, 1.4372, 1.2802, 1.1402, 1.0121, 0.89714, 0.79529, 0.70507, 0.62514, 0.55344, 0.48826,
         0.4308, 0.38012, 0.33543, 0.29601, 0.26122, 0.2304, 0.20323, 0.17927, 0.15814, 0.13952, 0.12309, 0.1086,
         0.09582, 0.084549, 0.074607, 0.065837, 0.0581, 0.051275, 0.045253, 0.039939, 0.035251, 0.031115, 0.027464,
         0.024243]],
    'Sn':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.023422, 0.0237805, 0.0238073, 0.0238761, 0.0240195, 0.024378, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368,
         0.086828, 0.088157, 0.0885114, 0.089043, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272,
         0.13377, 0.1349368, 0.1358175, 0.1363635, 0.1371825, 0.13923, 0.1442475, 0.1542005, 0.1648404, 0.1762144,
         0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143,
         0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.475104, 0.4794098, 0.482376, 0.483434, 0.4843152, 0.487224,
         0.4908335, 0.4928067, 0.494496, 0.4957665, 0.503166, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609,
         0.700112, 0.710828, 0.7136856, 0.7154399, 0.717972, 0.728688, 0.741272, 0.752618, 0.7556436, 0.760182,
         0.7648052, 0.771528, 0.8175768, 0.866124, 0.8739896, 0.879381, 0.8829162, 0.888219, 0.901476, 0.9342948,
         0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643,
         2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 3.850224,
         3.909156, 3.924871, 3.948444, 4.007376, 4.055024, 4.072978, 4.135319, 4.151944, 4.17688, 4.239222, 4.334821,
         4.375406, 4.442377, 4.460236, 4.487024, 4.553994, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004,
         6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697,
         14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676,
         28.6161, 29.0541, 29.1709, 29.3461, 29.7841, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992,
         44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069,
         93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539,
         194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588,
         405.0001, 432.9451],
        [8.40533, 8.3166, 8.21206, 8.08822, 7.94054, 7.76297, 7.54725, 7.2816, 6.94848, 6.51984, 5.94558, 5.11472,
         4.07447, 3.4488, 3.3658, 2.99671, 3.16193, 3.07327, 2.19506, 0.654972, -0.153839, 0.364264, 2.36543, 5.47285,
         9.01769, 12.3644, 15.1082, 17.1028, 18.388, 19.0958, 19.38, 19.3766, 19.1892, 18.8876, 18.5413, 18.0845,
         17.4338, 16.9441, 16.1855, 15.3182, 16.2085, 16.9648, 17.5538, 17.5484, 17.4115, 17.2315, 17.0235, 16.7668,
         16.6942, 16.6008, 16.4394, 16.5757, 16.6725, 16.6976, 16.6565, 16.602, 16.5491, 16.4986, 16.4471, 16.3884,
         16.3138, 16.2115, 16.0658, 15.8589, 15.555, 15.1156, 14.4774, 13.5372, 12.1052, 9.77113, 5.34162, -5.3938,
         -10.0246, -15.9897, -20.0565, -27.1125, -17.9385, -15.5411, -20.5115, -15.1896, -11.0983, -1.09926, 5.02345,
         16.0755, 21.7958, 25.4521, 27.698, 27.9859, 26.9092, 25.2636, 25.7353, 27.1651, 28.9963, 29.9222, 30.097,
         29.5426, 30.5673, 31.2055, 31.8439, 34.4946, 36.071, 36.1442, 36.0506, 35.6078, 36.3432, 37.2414, 38.5344,
         40.38, 41.7705, 42.795, 43.5956, 44.2078, 44.6469, 44.9678, 45.1804, 45.3112, 45.3763, 45.3928, 45.3446,
         45.2231, 45.0418, 44.8028, 44.5039, 44.135, 43.6444, 42.8802, 41.6355, 38.9148, 37.5113, 34.0273, 30.0304,
         33.9408, 37.1907, 37.9931, 38.1101, 37.3576, 35.5879, 37.8115, 40.0581, 41.4391, 41.7235, 41.6034, 40.8219,
         41.974, 43.3023, 44.1919, 46.2573, 47.5557, 48.4498, 49.0715, 49.5, 49.7938, 49.9926, 50.2028, 50.3272,
         50.4269, 50.4277, 50.3869, 50.3224, 50.2428, 50.1534, 50.0578, 49.9577, 49.8538, 49.7468, 49.6362, 49.5174,
         49.3865, 49.235, 49.0522, 48.8135, 48.4518, 47.6648, 47.0981, 45.8386, 44.325, 45.8608, 47.2498, 47.5904,
         48.8917, 49.4402, 49.7671, 49.9853, 50.1305, 50.2279, 50.2924, 50.3335, 50.3579, 50.4028, 50.4047, 50.3982,
         50.3866, 50.3718, 50.3569, 50.338, 50.3177, 50.2969, 50.2763, 50.2561, 50.2366, 50.2181, 50.2004, 50.1838,
         50.1682, 50.1536, 50.1401, 50.1276, 50.1161, 50.1054, 50.0957, 50.0867, 50.0785, 50.0711, 50.0642, 50.058,
         50.0524, 50.0473, 50.0426, 50.0384],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.71303, 0.8622, 1.4971,
         3.4165, 6.399, 9.9099, 13.138, 15.366, 16.277, 15.966, 14.784, 13.132, 11.341, 9.6305, 8.1137, 6.8318, 5.7821,
         4.9401, 4.2744, 3.7535, 3.3495, 3.2177, 3.1474, 3.1295, 4.7868, 4.6507, 4.138, 3.7616, 3.5187, 3.3688, 3.2869,
         3.258, 3.2565, 3.2558, 3.2556, 3.5528, 3.5593, 3.5821, 3.6492, 3.7388, 3.8437, 3.9584, 4.0778, 4.1973, 4.3123,
         4.4188, 4.5133, 4.5924, 4.6539, 4.6958, 4.717, 4.7169, 4.6945, 4.6509, 4.5879, 4.4758, 4.4569, 4.4439, 4.4393,
         4.4354, 24.794, 24.594, 24.486, 38.081, 37.968, 37.32, 36.532, 33.809, 31.371, 29.15, 27.071, 25.73, 25.288,
         25.173, 28.519, 28.418, 27.994, 27.51, 27.086, 26.974, 28.271, 28.106, 27.869, 26.343, 24.806, 24.568, 24.407,
         24.302, 25.241, 24.857, 23.947, 22.333, 20.514, 18.831, 17.281, 15.808, 14.442, 13.197, 12.054, 11.01, 10.055,
         9.1859, 8.3312, 7.5618, 6.8741, 6.2588, 5.7068, 5.2058, 4.6802, 4.1619, 3.7073, 3.3031, 3.2198, 3.1372, 3.1158,
         10.82, 10.465, 10.191, 10.09, 9.7618, 9.6868, 13.408, 13.018, 12.464, 12.248, 11.923, 11.84, 13.561, 13.25,
         12.901, 11.694, 10.597, 9.5551, 8.5908, 7.7135, 6.9246, 6.219, 5.5891, 5.0166, 4.4908, 3.9815, 3.5329, 3.1377,
         2.7892, 2.4818, 2.2102, 1.9686, 1.7545, 1.5653, 1.3947, 1.2404, 1.1005, 0.97529, 0.86507, 0.76798, 0.6824,
         0.60051, 0.57853, 0.56159, 0.55721, 3.5328, 3.4443, 3.3992, 3.0381, 2.7208, 2.4382, 2.1809, 1.9457, 1.7347,
         1.5459, 1.3771, 1.2266, 1.0924, 0.96868, 0.85903, 0.76186, 0.67575, 0.59847, 0.5282, 0.46621, 0.41152, 0.36327,
         0.32071, 0.28314, 0.24995, 0.22061, 0.19472, 0.17188, 0.15173, 0.13395, 0.11825, 0.1044, 0.092181, 0.081392,
         0.07187, 0.063464, 0.056043, 0.049492, 0.043709, 0.038603, 0.034094, 0.030114, 0.026598]],
    'Sb':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.030772, 0.03109002,
         0.031243, 0.0313686, 0.031557, 0.032028, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198,
         0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411,
         0.08458368, 0.09041995, 0.096432, 0.09665893, 0.097908, 0.0983016, 0.098892, 0.100368, 0.1033284, 0.1104581,
         0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.14896, 0.15124, 0.151848, 0.15276, 0.1542005, 0.15504, 0.1648404,
         0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482,
         0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.51695, 0.5248625, 0.526162,
         0.5269725, 0.5301375, 0.5342155, 0.5363631, 0.53805, 0.5395845, 0.5478508, 0.5856525, 0.6260625, 0.6692609,
         0.7154399, 0.750288, 0.761772, 0.7648052, 0.7648344, 0.769428, 0.780912, 0.795662, 0.8078405, 0.8110881,
         0.8159595, 0.8175768, 0.828138, 0.8739896, 0.924826, 0.9342948, 0.9389815, 0.9427563, 0.9484185, 0.962574,
         0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643,
         2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.049556,
         4.055024, 4.111539, 4.128068, 4.152861, 4.214844, 4.292792, 4.334821, 4.358498, 4.37602, 4.402302, 4.468008,
         4.604334, 4.633924, 4.674808, 4.693602, 4.721791, 4.792266, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004,
         6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697,
         14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676,
         29.88138, 30.01405, 30.33874, 30.46071, 30.64366, 31.10102, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992,
         44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069,
         93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539,
         194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588,
         405.0001, 432.9451],
        [5.60066, 5.50128, 5.38564, 5.25072, 5.09278, 4.90714, 4.68795, 4.42767, 4.1165, 3.74142, 3.28467, 2.72124,
         2.01461, 1.10848, -0.0905118, -1.75747, -3.84438, -4.36403, -4.65656, -4.98693, -5.20918, -5.96971, -8.47735,
         -14.9079, -20.7779, -19.9494, -9.21232, 7.33816, 22.5266, 32.0942, 35.9127, 35.8926, 34.0081, 31.549, 29.1518,
         27.0458, 25.2544, 23.6943, 22.0731, 21.9889, 21.2835, 20.5485, 21.1727, 21.5874, 21.6265, 21.2341, 20.7308,
         20.237, 19.7643, 19.2875, 19.0102, 18.7825, 18.5939, 18.7254, 18.7836, 18.7879, 18.6293, 18.3933, 18.1581,
         17.9281, 17.7023, 17.4794, 17.2549, 17.0152, 16.7428, 16.4168, 16.0178, 15.5023, 14.8094, 13.8406, 12.4195,
         10.181, 6.15466, -4.39626, -7.65911, -19.9185, -25.5442, -33.0107, -21.8369, -18.66, -24.3979, -18.8391,
         -13.2225, -1.09635, 16.3151, 23.2994, 27.2541, 29.5461, 29.8255, 28.7013, 27.0528, 27.0121, 28.9494, 30.8036,
         31.795, 31.9318, 31.3556, 32.3883, 32.6333, 33.6578, 36.0758, 37.5487, 37.6111, 37.5172, 37.073, 37.8019,
         38.6901, 40.0143, 41.8815, 43.143, 44.09, 44.8358, 45.4081, 45.8155, 46.1106, 46.3046, 46.4133, 46.4607,
         46.4584, 46.4054, 46.2816, 46.0945, 45.8465, 45.5381, 45.1717, 44.619, 43.7679, 42.3394, 38.6985, 38.5259,
         35.2495, 31.2844, 35.1768, 38.4252, 39.4207, 39.2292, 38.6196, 36.8523, 39.0524, 41.2611, 42.8218, 42.9076,
         42.7008, 41.9213, 43.069, 44.3895, 45.8807, 47.6632, 48.8405, 49.6541, 50.2187, 50.607, 50.8727, 51.0531,
         51.2517, 51.3849, 51.4451, 51.4241, 51.3726, 51.3015, 51.2178, 51.1259, 51.0287, 50.9275, 50.8228, 50.715,
         50.6025, 50.4806, 50.3444, 50.1845, 49.9872, 49.7185, 49.2783, 48.1193, 47.9024, 46.8668, 45.3623, 46.8879,
         48.2676, 49.2519, 50.1312, 50.5777, 50.8571, 51.0451, 51.17, 51.2536, 51.3083, 51.3425, 51.3619, 51.4029,
         51.4014, 51.3932, 51.3809, 51.3667, 51.3491, 51.3295, 51.3089, 51.2882, 51.2677, 51.2478, 51.2287, 51.2105,
         51.1933, 51.1771, 51.162, 51.1479, 51.1348, 51.1228, 51.1116, 51.1014, 51.092, 51.0834, 51.0755, 51.0683,
         51.0617, 51.0558, 51.0503, 51.0454, 51.0409],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.25761,
         0.37031, 0.91655, 4.479, 14.207, 29.219, 42.628, 47.65, 43.565, 34.42, 24.603, 16.521, 10.746, 6.9378, 4.5311,
         3.0369, 2.1106, 1.5317, 1.1759, 1.1656, 1.1122, 1.0964, 2.4069, 2.32, 2.1662, 1.884, 1.7036, 1.6018, 1.5574,
         1.5578, 1.5713, 1.5803, 1.5829, 1.9125, 1.923, 1.9293, 2.0151, 2.1333, 2.271, 2.4256, 2.5975, 2.784, 2.9781,
         3.173, 3.3666, 3.5553, 3.7348, 3.9011, 4.0507, 4.1813, 4.2907, 4.3779, 4.444, 4.4816, 4.4842, 4.4879, 4.4884,
         4.4887, 28.634, 28.262, 28.069, 43.941, 43.714, 42.526, 37.707, 33.734, 30.618, 28.003, 26.331, 25.821, 25.689,
         25.688, 28.986, 28.502, 27.902, 27.424, 27.299, 28.607, 28.546, 28.156, 26.568, 24.989, 24.714, 24.58, 24.472,
         25.405, 25.015, 24.069, 22.119, 20.307, 18.64, 17.107, 15.648, 14.293, 13.058, 11.926, 10.897, 9.9536, 9.0959,
         8.2687, 7.5066, 6.8253, 6.2155, 5.6689, 5.118, 4.5597, 4.0612, 3.623, 3.2402, 3.2328, 3.1579, 3.1365, 10.786,
         10.425, 9.996, 9.7756, 9.6715, 9.5967, 13.294, 12.901, 12.162, 12.022, 11.837, 11.754, 13.468, 13.158, 12.511,
         11.356, 10.281, 9.262, 8.3229, 7.4727, 6.7098, 6.0285, 5.4184, 4.8549, 4.3109, 3.8246, 3.3957, 3.0177, 2.6842,
         2.3898, 2.1296, 1.8978, 1.6923, 1.5106, 1.3455, 1.1969, 1.0614, 0.9412, 0.8354, 0.74215, 0.65316, 0.57836,
         0.5734, 0.56152, 0.55716, 3.5145, 3.4275, 3.252, 2.911, 2.6076, 2.3365, 2.0865, 1.8611, 1.6592, 1.4786, 1.3173,
         1.1735, 1.0438, 0.92605, 0.82164, 0.72906, 0.64593, 0.57023, 0.50344, 0.4445, 0.39249, 0.34659, 0.30608,
         0.27032, 0.23871, 0.21081, 0.18617, 0.16443, 0.14523, 0.12828, 0.11331, 0.1001, 0.088426, 0.078119, 0.069017,
         0.060977, 0.053876, 0.047604, 0.042063, 0.037169, 0.032845, 0.029025]],
    'Te':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.039004, 0.039601, 0.0397602, 0.039999, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368,
         0.09041995, 0.09665893, 0.1033284, 0.107996, 0.109649, 0.1100898, 0.1104581, 0.110751, 0.112404, 0.1180797,
         0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.164934, 0.1674585, 0.1681317, 0.1691415, 0.171666,
         0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482,
         0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.560658, 0.5692395,
         0.57085, 0.5715279, 0.5749605, 0.5795875, 0.5819175, 0.583542, 0.5856525, 0.59415, 0.6260625, 0.6692609,
         0.7154399, 0.7648052, 0.802326, 0.8146065, 0.8175768, 0.8178813, 0.8227935, 0.835074, 0.852306, 0.8653515,
         0.8688303, 0.8739896, 0.8740485, 0.887094, 0.9342948, 0.98588, 0.9987612, 1.00097, 1.004994, 1.01103, 1.02612,
         1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733,
         2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.254572,
         4.319693, 4.334821, 4.337059, 4.363107, 4.428228, 4.51976, 4.58894, 4.607388, 4.633924, 4.63506, 4.70424,
         4.840416, 4.914504, 4.934261, 4.953664, 4.963896, 5.037984, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365,
         7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688,
         15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405,
         31.17752, 31.65473, 31.78199, 31.97287, 32.08502, 32.45008, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101,
         47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374,
         99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018,
         207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001,
         432.9451],
        [5.02171, 4.95273, 4.87306, 4.78087, 4.67402, 4.54987, 4.40528, 4.23635, 4.0383, 3.8051, 3.52916, 3.20063,
         2.80664, 2.32987, 1.74643, 1.02221, 0.106352, -1.08165, -2.68102, -4.97638, -6.23915, -7.16454, -7.53159,
         -7.79861, -8.69306, -14.6624, -22.7141, -27.1819, -21.1494, -4.60076, 14.9668, 30.0555, 38.0387, 40.2145,
         39.0346, 36.4569, 33.5946, 30.9241, 28.5341, 26.9218, 26.0467, 25.3687, 25.602, 25.8166, 25.9837, 25.4097,
         24.4131, 23.5329, 22.7549, 22.0521, 21.3284, 21.3207, 21.0437, 20.8308, 20.9635, 21.0059, 20.9123, 20.578,
         20.247, 19.9365, 19.6437, 19.3624, 19.0847, 18.8008, 18.4978, 18.1581, 17.7479, 17.2479, 16.5932, 15.6938,
         14.3924, 12.3763, 8.87098, 0.787758, -6.28018, -18.7866, -25.7911, -32.2115, -20.6063, -17.1582, -23.0368,
         -18.4736, -11.0295, 0.571545, 16.0555, 24.1327, 28.3771, 30.7857, 31.1006, 29.9606, 28.5887, 28.2393, 30.2193,
         32.121, 33.2176, 33.3477, 32.7617, 33.7989, 33.8085, 35.0964, 37.4949, 39.0244, 39.1176, 39.0626, 38.6076,
         39.362, 40.28, 41.6539, 43.2237, 44.3693, 45.2519, 45.9578, 46.4985, 46.8807, 47.1403, 47.3202, 47.4163,
         47.4762, 47.4681, 47.4141, 47.2925, 47.0977, 46.8476, 46.6153, 46.1977, 45.566, 44.6074, 42.9161, 39.8866,
         36.4828, 33.5784, 32.5661, 36.4143, 39.6387, 40.6986, 39.8588, 38.101, 40.1981, 40.2695, 42.4355, 43.901,
         43.7836, 43.007, 43.762, 44.1527, 45.4697, 47.4921, 49.0633, 50.1223, 50.8541, 51.3603, 51.7086, 51.947,
         52.111, 52.3131, 52.4118, 52.4525, 52.4176, 52.3573, 52.2804, 52.1929, 52.0983, 51.9993, 51.8967, 51.7907,
         51.6814, 51.5662, 51.4406, 51.298, 51.128, 50.9118, 50.606, 50.0202, 49.1381, 47.8928, 46.3982, 47.9119,
         48.433, 49.2809, 50.6702, 51.3278, 51.698, 51.938, 52.0975, 52.2041, 52.2749, 52.3206, 52.3484, 52.3636,
         52.4005, 52.3964, 52.3867, 52.3744, 52.3584, 52.3395, 52.3193, 52.2986, 52.278, 52.2578, 52.2384, 52.2197,
         52.202, 52.1854, 52.1697, 52.1552, 52.1416, 52.1291, 52.1175, 52.1068, 52.097, 52.088, 52.0797, 52.0722,
         52.0653, 52.059, 52.0533, 52.0481, 52.0434],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
         0.0, 0.26938, 0.39162, 2.0857, 9.0143, 23.696, 41.736, 53.777, 54.618, 46.556, 35.09, 24.414, 16.236, 10.612,
         6.966, 4.6687, 3.2331, 2.5916, 2.4126, 2.3683, 3.471, 3.4406, 3.2799, 2.8411, 2.4261, 2.1678, 2.0161, 1.939,
         1.917, 1.917, 1.9185, 1.9192, 2.2751, 2.2855, 2.3086, 2.3917, 2.5018, 2.6328, 2.7816, 2.9453, 3.1207, 3.3043,
         3.4917, 3.6779, 3.8574, 4.0242, 4.1725, 4.2972, 4.3941, 4.4592, 4.491, 4.4905, 4.483, 4.4762, 4.4748, 4.4742,
         29.296, 28.851, 28.631, 44.853, 44.528, 43.258, 38.96, 34.422, 31.032, 28.276, 26.502, 25.969, 25.843, 25.831,
         29.191, 28.686, 28.006, 27.511, 27.381, 28.707, 28.705, 28.239, 26.663, 25.112, 24.759, 24.694, 24.564, 25.499,
         25.017, 23.768, 21.817, 20.028, 18.393, 16.88, 15.44, 14.101, 12.882, 11.773, 10.766, 9.8467, 8.9995, 8.1995,
         7.447, 6.7743, 6.1722, 5.5748, 4.9906, 4.4525, 3.9705, 3.5466, 3.2731, 3.1916, 3.1732, 3.1704, 10.73, 10.375,
         9.9045, 9.5928, 9.5193, 13.189, 13.182, 12.795, 12.099, 11.775, 11.693, 13.446, 13.402, 13.093, 12.143, 11.024,
         9.9599, 8.9652, 8.0533, 7.2315, 6.4957, 5.8397, 5.2387, 4.6582, 4.1358, 3.6712, 3.261, 2.8992, 2.5799, 2.2978,
         2.0485, 1.8263, 1.6292, 1.4547, 1.2957, 1.1532, 1.0224, 0.90723, 0.80574, 0.70918, 0.6227, 0.57843, 0.56169,
         0.55735, 3.4947, 3.4746, 3.4107, 3.1135, 2.7886, 2.4971, 2.2343, 1.9932, 1.7775, 1.5846, 1.4123, 1.2587,
         1.1216, 0.99655, 0.88454, 0.78519, 0.69597, 0.61479, 0.54312, 0.47984, 0.42397, 0.37464, 0.33107, 0.29258,
         0.25859, 0.22858, 0.20207, 0.17864, 0.15794, 0.13964, 0.12347, 0.10918, 0.09655, 0.085384, 0.075514, 0.066788,
         0.059073, 0.052252, 0.046221, 0.040888, 0.036171, 0.032001]],
    'I':                                                                                                          [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.048608, 0.049352, 0.04959809, 0.049848, 0.050592,
         0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995,
         0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.120246, 0.1220865, 0.1225773, 0.1233135, 0.125154, 0.1262272,
         0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.182672, 0.185468, 0.1862136, 0.187332, 0.1883732,
         0.190128, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143,
         0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.607012, 0.616303,
         0.618674, 0.6187806, 0.622497, 0.6260625, 0.6281435, 0.6306687, 0.631788, 0.6344565, 0.643926, 0.6692609,
         0.7154399, 0.7648052, 0.8175768, 0.857108, 0.870227, 0.8739896, 0.878973, 0.892092, 0.91189, 0.9258475,
         0.9295695, 0.9342948, 0.9351525, 0.94911, 0.9987612, 1.050658, 1.067676, 1.071028, 1.077461, 1.093542,
         1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304,
         2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.465958,
         4.534314, 4.552543, 4.579885, 4.633924, 4.648242, 4.755058, 4.827839, 4.847248, 4.87636, 4.953664, 5.084338,
         5.162159, 5.182912, 5.21404, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789,
         9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961,
         18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 32.50601, 33.00355,
         33.13623, 33.33525, 33.83279, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721,
         58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931,
         121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835,
         253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [11.8518, 11.8252, 11.7946, 11.7594, 11.7188, 11.6719, 11.6177, 11.5549, 11.4821, 11.3973, 11.2983, 11.1823,
         11.046, 10.8849, 10.6935, 10.4643, 10.1874, 9.84922, 9.43029, 8.90135, 8.2157, 7.29092, 5.95148, 4.48414,
         3.67328, 2.55839, 3.20612, 2.78632, 0.605141, -2.9799, -4.41342, -1.57643, 5.22924, 13.5284, 20.7455, 25.6007,
         28.0894, 28.8251, 28.4904, 27.5842, 26.3152, 25.839, 25.155, 24.5579, 25.0124, 25.2665, 25.2677, 24.7795,
         24.1393, 23.5207, 22.9449, 22.3849, 22.0302, 21.7663, 21.5453, 21.7026, 21.7597, 21.7817, 21.6355, 21.3975,
         21.1701, 20.959, 20.7604, 20.5671, 20.3694, 20.1545, 19.905, 19.5966, 19.1892, 18.6426, 17.8709, 16.7376,
         14.9816, 11.9899, 5.63492, -3.38493, -15.3534, -26.9803, -28.2232, -16.9818, -13.2224, -13.4083, -19.2036,
         -19.5875, -8.36804, 3.18632, 15.334, 24.5449, 29.1643, 31.7254, 32.0836, 30.943, 28.7963, 31.2151, 33.1591,
         34.3584, 34.4902, 33.9013, 34.8163, 34.9563, 36.2578, 38.6538, 40.1104, 40.0667, 39.6513, 40.4143, 41.3447,
         42.8266, 44.3871, 45.5247, 46.3982, 47.0925, 47.621, 47.993, 48.2438, 48.4003, 48.489, 48.5412, 48.5293,
         48.478, 48.3604, 48.2078, 48.065, 47.6838, 47.1716, 46.4591, 45.3714, 43.2826, 41.0615, 37.7027, 33.8351,
         37.6379, 40.4735, 40.836, 41.9574, 41.0845, 39.3389, 41.4727, 43.6693, 44.9619, 44.8502, 44.0786, 45.2183,
         46.5711, 49.0314, 50.4303, 51.3802, 52.0355, 52.4876, 52.7994, 53.015, 53.1826, 53.3587, 53.4298, 53.4524,
         53.4062, 53.3387, 53.2571, 53.1664, 53.0697, 52.9691, 52.8653, 52.7582, 52.6473, 52.5289, 52.3987, 52.2486,
         52.0687, 51.833, 51.4549, 50.5798, 50.158, 48.9195, 47.4332, 48.9383, 50.2993, 50.8358, 51.9788, 52.492,
         52.8009, 53.0062, 53.1422, 53.2332, 53.2932, 53.3312, 53.3535, 53.3967, 53.3976, 53.3913, 53.3819, 53.3679,
         53.35, 53.3303, 53.3097, 53.2891, 53.2686, 53.2488, 53.2296, 53.2114, 53.1942, 53.1781, 53.163, 53.1489,
         53.1359, 53.1238, 53.1126, 53.1024, 53.0929, 53.0843, 53.0764, 53.0692, 53.0626, 53.0566, 53.0511, 53.0461],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
         0.0, 0.0, 0.0, 0.0, 0.62754, 0.81817, 1.8942, 5.861, 12.865, 20.756, 26.34, 27.841, 25.717, 21.603, 17.05,
         12.982, 9.7369, 7.3115, 5.5642, 5.1835, 4.8922, 4.8191, 5.7654, 5.5146, 5.3788, 4.5057, 3.9032, 3.5, 3.2395,
         3.0832, 3.0324, 3.017, 3.0134, 3.3918, 3.3898, 3.3874, 3.3965, 3.4508, 3.5381, 3.6501, 3.78, 3.9218, 4.0698,
         4.2182, 4.3612, 4.493, 4.608, 4.7012, 4.7685, 4.8069, 4.8143, 4.7894, 4.7339, 4.6924, 4.6724, 4.6672, 4.667,
         28.524, 28.226, 28.054, 27.848, 43.524, 43.172, 41.956, 38.956, 34.443, 30.997, 28.202, 26.462, 25.931, 25.783,
         29.204, 28.702, 27.977, 27.486, 27.358, 28.719, 28.69, 28.218, 26.646, 25.11, 24.603, 24.5, 25.442, 24.955,
         23.6, 21.641, 19.848, 18.211, 16.699, 15.264, 13.933, 12.723, 11.623, 10.626, 9.7173, 8.8857, 8.1102, 7.3706,
         6.7093, 6.0553, 5.424, 4.8629, 4.3446, 3.8793, 3.4694, 3.3023, 3.2206, 3.1994, 10.667, 10.391, 10.32, 9.8092,
         9.5109, 9.4389, 13.062, 12.66, 12.036, 11.713, 11.631, 13.332, 13.013, 11.779, 10.679, 9.6346, 8.6656, 7.7844,
         6.9929, 6.2859, 5.6458, 5.0279, 4.4712, 3.9684, 3.5241, 3.1314, 2.785, 2.4792, 2.209, 1.9699, 1.7569, 1.5678,
         1.3991, 1.2463, 1.1086, 0.98355, 0.87336, 0.76881, 0.67523, 0.59354, 0.57883, 0.56217, 0.55785, 3.4787, 3.3951,
         3.3198, 2.9745, 2.6643, 2.3861, 2.1326, 1.9025, 1.6966, 1.5126, 1.3483, 1.2017, 1.0706, 0.95063, 0.84419,
         0.74857, 0.66149, 0.5846, 0.51669, 0.4567, 0.40372, 0.3569, 0.31554, 0.279, 0.24674, 0.21827, 0.19309, 0.17083,
         0.15114, 0.13373, 0.11833, 0.10472, 0.09267, 0.082014, 0.072587, 0.064247, 0.056869, 0.05034, 0.044562,
         0.03945, 0.034926]],
    'Xe':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.06272, 0.06368, 0.063936, 0.06432, 0.06477028, 0.06528, 0.06923942, 0.07401695, 0.07912411, 0.08458368,
         0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.143766, 0.1442475, 0.1459665,
         0.1465533, 0.1474335, 0.149634, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.203938, 0.2070595,
         0.2078919, 0.2091405, 0.212262, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482,
         0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625,
         0.658854, 0.6692609, 0.671692, 0.6756615, 0.681973, 0.6847146, 0.685746, 0.688827, 0.699108, 0.7154399,
         0.7648052, 0.8175768, 0.8739896, 0.91826, 0.932315, 0.9342948, 0.936063, 0.941685, 0.95574, 0.97902, 0.994005,
         0.9987612, 1.003995, 1.01898, 1.067676, 1.121708, 1.138877, 1.141345, 1.143455, 1.150323, 1.167492, 1.220098,
         1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848,
         2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.686556, 4.758289,
         4.777418, 4.806111, 4.877844, 4.953664, 5.001626, 5.078182, 5.098596, 5.129219, 5.205774, 5.295467, 5.343744,
         5.425536, 5.447347, 5.480064, 5.561856, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789,
         9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961,
         18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 33.87017, 34.29889,
         34.38859, 34.52684, 34.73421, 35.25263, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721,
         58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931,
         121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835,
         253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [17.4817, 17.4729, 17.4627, 17.451, 17.4376, 17.4222, 17.4044, 17.3839, 17.3603, 17.333, 17.3014, 17.2647,
         17.2221, 17.1724, 17.1143, 17.046, 16.9653, 16.8696, 16.7551, 16.6169, 16.4483, 16.2392, 15.9749, 15.631,
         15.1635, 14.4787, 13.2889, 11.9994, 10.5181, 9.04168, 10.1989, 10.7681, 11.0295, 11.3451, 11.9353, 13.4352,
         15.4567, 17.5482, 19.3672, 20.7487, 21.6728, 22.1972, 22.3982, 22.3204, 21.8272, 21.7629, 21.3416, 20.7968,
         21.3224, 21.7567, 22.0064, 22.129, 22.0852, 21.9645, 21.7702, 21.6898, 21.4862, 21.2694, 21.4691, 21.6278,
         21.6791, 21.7426, 21.7454, 21.7359, 21.7211, 21.6987, 21.6617, 21.5992, 21.4951, 21.3273, 21.0644, 20.6582,
         20.0448, 19.1067, 17.6322, 15.1523, 10.2292, -0.298003, -12.4339, -24.5681, -13.2073, -9.82041, -15.3958,
         -17.9455, -5.13804, 5.78404, 13.7642, 24.5976, 29.707, 32.5139, 32.9938, 31.8535, 31.2765, 30.0986, 32.1316,
         34.0977, 35.3823, 35.4177, 33.9244, 35.919, 37.3675, 39.7178, 41.1467, 41.1545, 41.0201, 40.7001, 41.4707,
         42.4232, 43.9835, 45.5566, 46.6886, 47.5513, 48.2356, 48.765, 49.1379, 49.3845, 49.5404, 49.6205, 49.663,
         49.6398, 49.583, 49.4927, 49.346, 49.0369, 48.6191, 48.0668, 47.2888, 46.0511, 43.2904, 42.2221, 38.9074,
         35.0859, 38.8484, 42.0237, 43.039, 43.2058, 42.3055, 40.5721, 42.6732, 44.7523, 45.7697, 46.0586, 45.9458,
         45.1763, 46.3112, 47.6166, 48.4989, 50.5102, 51.7598, 52.6129, 53.2022, 53.6109, 53.8997, 54.1224, 54.3248,
         54.4259, 54.4732, 54.4466, 54.3916, 54.3183, 54.2329, 54.1397, 54.0413, 53.9394, 53.8345, 53.7261, 53.6131,
         53.4914, 53.3563, 53.1993, 53.0051, 52.7236, 52.2415, 51.1766, 50.322, 49.9447, 48.4666, 49.9634, 51.3169,
         52.4379, 53.2174, 53.6296, 53.8905, 54.065, 54.1809, 54.2583, 54.3087, 54.3398, 54.3573, 54.3963, 54.3945,
         54.3894, 54.3768, 54.36, 54.3409, 54.3206, 54.3, 54.2794, 54.2592, 54.2397, 54.221, 54.2032, 54.1866, 54.1709,
         54.1564, 54.1428, 54.1302, 54.1186, 54.1079, 54.0981, 54.089, 54.0807, 54.0732, 54.0662, 54.0599, 54.0542,
         54.0489],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
         0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.7373, 2.8683, 3.023, 4.4855, 6.6806, 8.5363, 9.6404, 9.9217, 9.5457,
         8.7673, 7.8187, 6.8627, 5.9916, 5.2451, 4.6587, 4.631, 4.5353, 4.5038, 5.5082, 5.4034, 5.2082, 4.8526, 4.5958,
         4.4226, 4.3179, 4.3047, 4.2913, 4.2883, 4.6957, 4.6923, 4.6913, 4.7129, 4.7685, 4.8475, 4.9411, 5.0418, 5.1427,
         5.2375, 5.3204, 5.3862, 5.4308, 5.4507, 5.4436, 5.4084, 5.3453, 5.2553, 5.1399, 5.0359, 5.0016, 4.9935, 27.559,
         27.119, 26.932, 41.885, 41.543, 40.435, 38.768, 34.4, 30.971, 28.17, 26.334, 25.798, 25.725, 25.659, 29.1,
         28.595, 27.794, 27.3, 27.146, 28.757, 28.243, 26.672, 25.123, 24.669, 24.6, 24.542, 25.494, 25.011, 23.587,
         21.576, 19.756, 18.107, 16.595, 15.167, 13.829, 12.613, 11.509, 10.509, 9.5998, 8.7741, 8.0226, 7.2962, 6.5778,
         5.8878, 5.2812, 4.742, 4.243, 3.7928, 3.3957, 3.3332, 3.2512, 3.2299, 10.612, 10.271, 9.9278, 9.7191, 9.433,
         9.3624, 12.947, 12.575, 12.166, 11.958, 11.638, 11.557, 13.252, 12.949, 12.605, 11.42, 10.336, 9.3148, 8.3751,
         7.5253, 6.7644, 6.0747, 5.4221, 4.8271, 4.2915, 3.8087, 3.3831, 3.007, 2.6749, 2.3817, 2.1226, 1.8933, 1.689,
         1.5075, 1.3446, 1.1978, 1.065, 0.94548, 0.83239, 0.73122, 0.64288, 0.57946, 0.56569, 0.56288, 0.55858, 3.4633,
         3.38, 3.1686, 2.8388, 2.5432, 2.2781, 2.0335, 1.8141, 1.6179, 1.4425, 1.2859, 1.1462, 1.02, 0.90616, 0.80382,
         0.71056, 0.62818, 0.5554, 0.49109, 0.43427, 0.38405, 0.33966, 0.30042, 0.26574, 0.2352, 0.2082, 0.1843,
         0.16316, 0.14446, 0.1279, 0.11325, 0.10029, 0.088808, 0.078648, 0.069654, 0.061692, 0.054642, 0.0484, 0.042873,
         0.037979]],
    'Cs':                                                                                                         [
        [0.01069, 0.011172, 0.011343, 0.0113886, 0.01142761, 0.011457, 0.011628, 0.01221612, 0.012838, 0.0130345,
         0.01305903, 0.0130869, 0.0131655, 0.013362, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.022246, 0.02227063, 0.0225865, 0.0226773, 0.0228135, 0.023154, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07497, 0.0761175,
         0.0764235, 0.0768825, 0.077224, 0.07803, 0.078406, 0.0787212, 0.07912411, 0.079194, 0.080376, 0.08458368,
         0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.158368,
         0.160792, 0.1614384, 0.162408, 0.1648404, 0.168854, 0.1714385, 0.1721277, 0.1731615, 0.175746, 0.1762144,
         0.1883732, 0.2013709, 0.2152655, 0.226184, 0.229646, 0.2301188, 0.2305692, 0.231954, 0.235416, 0.245997,
         0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098,
         0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.71099, 0.7154399, 0.7218725, 0.72471, 0.7247745,
         0.7291275, 0.7358025, 0.7387605, 0.74001, 0.7431975, 0.75429, 0.7648052, 0.8175768, 0.8739896, 0.9342948,
         0.977648, 0.992612, 0.9966024, 0.9987612, 1.002588, 1.017552, 1.0437, 1.059675, 1.063935, 1.067676, 1.070325,
         1.0863, 1.141345, 1.192758, 1.211015, 1.215883, 1.220098, 1.223186, 1.241442, 1.304285, 1.394281, 1.490486,
         1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515,
         3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.911662, 4.953664, 4.98684, 5.006888, 5.036959,
         5.112138, 5.252212, 5.295467, 5.332603, 5.35404, 5.386197, 5.466588, 5.600014, 5.660855, 5.685729, 5.708586,
         5.742872, 5.828586, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004,
         11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988,
         22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 35.26491, 35.80468, 35.94862, 36.16452,
         36.66551, 36.70429, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318,
         71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553,
         148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126,
         310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [-12.1026, -17.4936, -24.4803, -32.8699, -27.9838, -24.0414, -16.3832, -9.79847, -9.31038, -12.3379, -13.59,
         -16.8117, -11.5245, -6.49255, -1.15375, 2.52001, 4.35711, 5.23957, 5.54833, 5.49875, 5.22332, 4.81062, 4.80269,
         4.69752, 4.66282, 4.6235, 4.5155, 4.29825, 3.73335, 3.11987, 2.46113, 1.75118, 0.976396, 0.12113, -0.856516,
         -1.99122, -3.34832, -5.01452, -7.12612, -9.90451, -13.7385, -19.3856, -28.5658, -46.3389, -99.959, -129.058,
         -221.925, -340.742, -196.862, -147.117, -117.448, -139.264, -236.373, -95.6342, -77.0908, 58.4873, 122.57,
         93.1188, 68.8276, 54.3537, 45.4066, 39.5075, 35.3773, 32.3276, 29.9529, 27.943, 27.1051, 26.4045, 25.8952,
         26.1848, 26.2309, 25.9271, 25.6084, 25.3979, 25.486, 25.4439, 25.4243, 24.7988, 24.1919, 23.6419, 23.185,
         22.9041, 22.8143, 22.641, 22.8565, 23.0017, 23.0229, 22.9649, 22.938, 22.9549, 23.0087, 23.0822, 23.1512,
         23.1889, 23.1648, 23.0427, 22.7759, 22.3011, 21.5152, 20.2337, 18.0683, 13.8951, 2.98332, 0.0604433, -7.72576,
         -18.5884, -19.1802, -9.26291, -6.15356, -11.3635, -12.2738, -1.76746, 8.45083, 13.4408, 25.2035, 30.5574,
         33.4544, 33.871, 32.6294, 30.6735, 30.9608, 32.9983, 35.2241, 36.729, 36.8058, 36.1034, 36.7852, 37.2994,
         38.7407, 41.0242, 42.1692, 42.1411, 41.6738, 42.1059, 42.4448, 43.3922, 45.0837, 46.6262, 47.7757, 48.6563,
         49.3538, 49.8622, 50.2114, 50.4447, 50.647, 50.7185, 50.7506, 50.7159, 50.6493, 50.5732, 50.3418, 50.0012,
         49.5485, 48.946, 48.076, 46.6164, 43.379, 42.088, 40.1016, 36.3183, 40.0489, 43.2059, 44.433, 44.2277, 43.5105,
         41.7843, 43.8628, 45.9086, 47.1111, 47.1838, 47.0101, 46.2463, 47.3775, 48.6805, 50.3007, 51.989, 53.0921,
         53.8505, 54.3753, 54.7429, 55.0192, 55.1931, 55.3657, 55.4449, 55.4785, 55.4399, 55.3771, 55.2986, 55.2096,
         55.1139, 55.0136, 54.9102, 54.8037, 54.6938, 54.5784, 54.4532, 54.3136, 54.146, 53.9188, 53.5825, 52.9105,
         52.195, 50.9706, 49.5025, 50.9879, 52.2763, 52.3309, 53.829, 54.4128, 54.7513, 54.9722, 55.1185, 55.2163,
         55.281, 55.3226, 55.3477, 55.3613, 55.3958, 55.3951, 55.3844, 55.3689, 55.3507, 55.331, 55.3105, 55.2899,
         55.2695, 55.2497, 55.2306, 55.2123, 55.1951, 55.179, 55.1639, 55.1498, 55.1368, 55.1247, 55.1136, 55.1033,
         55.0939, 55.0852, 55.0773, 55.07, 55.0634, 55.0574, 55.0519],
        [0.0, 0.0, 0.0, 0.0, 16.606, 16.512, 15.981, 14.334, 12.83, 12.378, 12.323, 12.259, 21.314, 20.509, 18.246,
         15.149, 12.455, 10.168, 8.264, 6.7034, 5.4384, 4.436, 4.4209, 4.2335, 4.1817, 4.1161, 3.935, 3.6186, 2.9719,
         2.4576, 2.049, 1.7242, 1.4659, 1.2603, 1.0965, 0.96587, 0.8617, 0.77862, 0.71281, 0.66082, 0.61996, 0.58791,
         0.5627, 0.5428, 0.52698, 0.52433, 0.52132, 0.52055, 231.6, 214.73, 179.89, 165.74, 154.78, 364.6, 358.9,
         275.58, 111.18, 37.396, 16.039, 8.5172, 5.3851, 3.9085, 3.1538, 2.7563, 2.557, 2.4801, 2.4742, 2.476, 2.4771,
         3.3029, 3.3175, 3.3477, 3.3705, 3.377, 3.7029, 3.731, 3.7364, 3.8938, 4.0923, 4.324, 4.512, 4.5717, 4.5798,
         4.5876, 5.0882, 5.1508, 5.339, 5.6267, 5.9045, 6.162, 6.3883, 6.5697, 6.7002, 6.778, 6.8036, 6.7792, 6.7095,
         6.5999, 6.4564, 6.2849, 6.0915, 5.8812, 5.6798, 5.6585, 5.6279, 5.6145, 5.6142, 26.798, 26.411, 26.242, 40.226,
         39.937, 38.958, 38.065, 34.073, 30.811, 28.078, 26.398, 25.859, 25.718, 29.754, 29.597, 29.002, 28.014, 27.441,
         27.292, 28.939, 28.836, 28.234, 26.429, 25.038, 24.588, 24.471, 25.527, 25.452, 24.988, 23.435, 21.528, 19.742,
         18.09, 16.56, 15.099, 13.769, 12.563, 11.459, 10.455, 9.5448, 8.7209, 7.9771, 7.1995, 6.4441, 5.778, 5.191,
         4.6666, 4.1851, 3.7579, 3.4164, 3.3694, 3.3331, 3.3114, 10.623, 10.283, 9.692, 9.5385, 9.4138, 9.3437, 12.901,
         12.529, 11.957, 11.722, 11.632, 11.551, 13.236, 12.933, 12.217, 11.075, 10.007, 9.011, 8.1009, 7.2827, 6.5399,
         5.8397, 5.2103, 4.6386, 4.1219, 3.6594, 3.2515, 2.8911, 2.5727, 2.2914, 2.0427, 1.8226, 1.6265, 1.4529, 1.2958,
         1.1546, 1.026, 0.90351, 0.79396, 0.69828, 0.61464, 0.58299, 0.56641, 0.56212, 3.4469, 3.3719, 3.3662, 3.027,
         2.7121, 2.4284, 2.1715, 1.9375, 1.7284, 1.5415, 1.3747, 1.2258, 1.093, 0.97171, 0.86233, 0.76264, 0.67454,
         0.59667, 0.52783, 0.46698, 0.41317, 0.36559, 0.32351, 0.2863, 0.25345, 0.22452, 0.1989, 0.17622, 0.15613,
         0.13835, 0.12259, 0.10864, 0.096275, 0.085325, 0.075625, 0.067031, 0.059416, 0.052669, 0.04669, 0.041392]],
    'Ba':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.014308, 0.014527, 0.0145854, 0.014673, 0.014892,
         0.01492335, 0.01595306, 0.016268, 0.016517, 0.0165834, 0.016683, 0.016932, 0.01705382, 0.01823053, 0.01948844,
         0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846,
         0.03797993, 0.038318, 0.0389045, 0.0390609, 0.0392955, 0.039882, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368,
         0.088102, 0.0894505, 0.0898101, 0.09041995, 0.09065, 0.091698, 0.0920375, 0.0924075, 0.0929625, 0.09435,
         0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144,
         0.1788015, 0.1795203, 0.1805985, 0.183294, 0.187964, 0.1883732, 0.190841, 0.1916082, 0.192759, 0.195636,
         0.2013709, 0.2152655, 0.2301188, 0.245997, 0.24794, 0.251735, 0.252747, 0.254265, 0.25806, 0.2629708,
         0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891,
         0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.765086, 0.7767965, 0.780178, 0.7846035,
         0.7921195, 0.7953039, 0.796314, 0.8000805, 0.812022, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.040956,
         1.056889, 1.061138, 1.067676, 1.083444, 1.113966, 1.131017, 1.135563, 1.141345, 1.142384, 1.159434, 1.220098,
         1.266944, 1.286336, 1.291507, 1.299264, 1.304285, 1.318656, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795,
         1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288,
         4.055024, 4.334821, 4.633924, 4.953664, 5.14206, 5.220765, 5.241753, 5.273235, 5.295467, 5.35194, 5.511128,
         5.595482, 5.617976, 5.651718, 5.660855, 5.736072, 5.869024, 5.958856, 5.982811, 6.018744, 6.051453, 6.108576,
         6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708,
         13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645,
         28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 36.69179, 37.2534, 37.40316, 37.6278, 38.18941, 39.19543,
         41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564,
         87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159,
         181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049,
         378.8588, 405.0001, 432.9451],
        [14.3338, 13.9405, 13.3645, 12.4158, 10.3261, 8.3293, 4.62144, 0.16426, 4.86407, 8.93756, 9.23744, 12.7559,
         12.5921, 11.169, 9.00419, 11.5742, 14.0476, 14.6943, 17.7878, 19.2404, 20.0237, 20.4129, 20.5556, 20.5428,
         20.4336, 20.2658, 20.0629, 19.8383, 19.5981, 19.3408, 19.3043, 19.2365, 19.2113, 19.1959, 19.1437, 19.0744,
         18.7969, 18.4984, 18.1587, 17.771, 17.3012, 16.7134, 15.9402, 14.8562, 13.1961, 10.2689, 3.36627, -10.8739,
         -33.558, -63.6243, -22.5694, -14.8234, -2.34496, -4.39435, -19.7423, 8.16737, 32.6022, 42.9232, 40.1512,
         34.0274, 30.3135, 28.0185, 26.4755, 25.342, 24.43, 23.6073, 22.6102, 22.1082, 21.6302, 22.0139, 22.2568,
         22.2328, 22.2205, 22.0787, 21.9129, 22.0571, 22.1562, 22.1642, 22.0525, 21.907, 21.6928, 21.6416, 21.425,
         21.1727, 21.4262, 21.6501, 21.7706, 22.0321, 22.281, 22.5628, 22.8757, 23.2063, 23.5321, 23.8184, 24.0286,
         24.1237, 24.0578, 23.7758, 23.1801, 22.1087, 20.2275, 16.5998, 5.88726, 5.75176, -4.33866, -17.7417, -5.78321,
         -2.80807, -7.78728, -12.8192, 1.2116, 10.7864, 13.3265, 25.8483, 31.3908, 34.3674, 34.7296, 33.4815, 31.5154,
         33.8505, 36.0736, 37.6618, 37.6671, 36.9535, 37.967, 38.1225, 39.5218, 41.7996, 42.7472, 42.7243, 42.2596,
         43.0282, 43.3576, 43.9869, 45.9814, 47.5979, 48.7836, 49.6753, 50.3359, 50.8105, 51.1484, 51.485, 51.6848,
         51.7595, 51.7921, 51.7628, 51.7419, 51.5927, 51.3222, 50.9469, 50.4516, 49.7836, 48.8026, 46.9999, 44.543,
         41.3094, 37.5721, 41.2613, 42.6868, 44.3928, 45.6654, 44.7233, 43.0095, 45.0562, 45.4367, 47.0616, 48.191,
         48.0966, 47.3384, 48.4624, 49.0789, 49.7589, 51.9659, 53.4251, 54.3968, 55.066, 55.5333, 55.888, 56.112,
         56.2453, 56.3911, 56.4523, 56.4722, 56.4235, 56.3541, 56.2713, 56.1795, 56.0818, 55.9801, 55.8754, 55.7679,
         55.6571, 55.5396, 55.4124, 55.2621, 55.07, 54.8096, 54.3908, 53.2415, 53.212, 51.9948, 50.5352, 52.012,
         53.3471, 54.193, 55.1167, 55.5719, 55.8522, 56.0387, 56.1622, 56.2448, 56.2991, 56.3333, 56.3534, 56.3946,
         56.3972, 56.3892, 56.3757, 56.3589, 56.34, 56.32, 56.2996, 56.2792, 56.2592, 56.2398, 56.2212, 56.2034,
         56.1868, 56.1713, 56.1568, 56.1433, 56.1308, 56.1192, 56.1085, 56.0987, 56.0897, 56.0814, 56.0738, 56.0669,
         56.0606, 56.0548],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.774, 8.4767, 8.4354, 7.2225, 6.899, 6.65, 6.5846, 10.979, 10.596,
         10.413, 8.818, 7.391, 6.1288, 5.0483, 4.145, 3.4028, 2.8003, 2.315, 1.926, 1.6149, 1.3662, 1.1671, 1.1438,
         1.1055, 1.0957, 1.0993, 1.0663, 1.0288, 0.90911, 0.81645, 0.74504, 0.69046, 0.64907, 0.61794, 0.59492, 0.578,
         0.56569, 0.55668, 0.54997, 0.54668, 0.54558, 0.5453, 58.904, 56.3, 45.897, 42.984, 40.033, 73.068, 56.274,
         36.802, 12.04, 5.2283, 3.0158, 2.1488, 1.7723, 1.6134, 1.572, 1.6076, 1.7039, 1.7322, 1.7405, 2.6163, 2.6598,
         2.7399, 2.7472, 2.7919, 2.8061, 3.1367, 3.1955, 3.3173, 3.6322, 3.9889, 4.3789, 4.4266, 4.5193, 4.5439, 5.0752,
         5.1705, 5.2924, 5.7251, 6.1432, 6.528, 6.8637, 7.1372, 7.3318, 7.4408, 7.4684, 7.4226, 7.3142, 7.1546, 6.9554,
         6.727, 6.4787, 6.2181, 5.9507, 5.9492, 5.8879, 5.8703, 25.816, 25.455, 25.304, 38.538, 38.257, 37.389, 36.997,
         33.381, 30.314, 27.662, 26.088, 25.535, 25.392, 29.274, 28.639, 27.474, 26.916, 26.773, 28.357, 28.322, 27.758,
         26.003, 24.88, 24.455, 24.345, 25.333, 25.227, 24.929, 23.285, 21.37, 19.565, 17.896, 16.327, 14.895, 13.6,
         12.407, 11.31, 10.315, 9.4155, 8.6035, 7.8048, 6.9934, 6.2655, 5.6213, 5.0525, 4.5498, 4.1024, 3.6853, 3.4671,
         3.3825, 3.3605, 10.586, 10.489, 10.25, 9.6197, 9.3495, 9.2804, 12.8, 12.76, 12.435, 11.901, 11.578, 11.497,
         13.172, 13.061, 12.872, 11.807, 10.692, 9.6457, 8.6788, 7.8032, 7.0067, 6.2554, 5.5897, 4.9844, 4.4369, 3.94,
         3.4989, 3.1098, 2.7659, 2.462, 2.1935, 1.956, 1.7459, 1.5597, 1.3938, 1.2429, 1.1072, 0.9756, 0.85752, 0.75436,
         0.66418, 0.58526, 0.58447, 0.56795, 0.56367, 3.4315, 3.3512, 3.215, 2.8831, 2.5829, 2.3128, 2.0659, 1.8434,
         1.6446, 1.4669, 1.3083, 1.1668, 1.0396, 0.92298, 0.81666, 0.72265, 0.63952, 0.566, 0.50098, 0.44346, 0.39257,
         0.34755, 0.30771, 0.27246, 0.24145, 0.21406, 0.18978, 0.16827, 0.14921, 0.13231, 0.11733, 0.10406, 0.092287,
         0.081854, 0.072604, 0.064402, 0.057129, 0.050681, 0.044962]],
    'La':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.014112, 0.014328, 0.0143856, 0.014472, 0.014688,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.031654, 0.0321385, 0.0322677, 0.0324615, 0.032946, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.096922, 0.0984055,
         0.0988011, 0.0993945, 0.100878, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005,
         0.1648404, 0.1762144, 0.187572, 0.1883732, 0.190443, 0.1912086, 0.192357, 0.195228, 0.2013709, 0.201684,
         0.204771, 0.2055942, 0.206829, 0.209916, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.264992, 0.269048,
         0.2701296, 0.271752, 0.275808, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189,
         0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.815066,
         0.8175768, 0.8275415, 0.83153, 0.8358585, 0.8442575, 0.8476515, 0.848334, 0.8527425, 0.86547, 0.8739896,
         0.9342948, 0.9987612, 1.067676, 1.100932, 1.117783, 1.122277, 1.129017, 1.141345, 1.145868, 1.180312, 1.198378,
         1.203196, 1.210422, 1.220098, 1.228488, 1.304285, 1.334074, 1.354493, 1.359939, 1.368106, 1.388526, 1.394281,
         1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724,
         3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.373046, 5.455286,
         5.477217, 5.510113, 5.592354, 5.660855, 5.772788, 5.861147, 5.88471, 5.920053, 6.008412, 6.051453, 6.140974,
         6.234969, 6.260034, 6.297632, 6.391626, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919,
         10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215,
         21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 38.14611, 38.72998,
         38.88567, 39.11922, 39.19543, 39.70309, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287,
         66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669,
         139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869,
         290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [18.7089, 18.3468, 17.7981, 16.8371, 14.3197, 13.281, 9.70715, 5.39845, 9.90333, 13.8687, 15.6489, 19.055,
         20.8265, 21.9681, 22.719, 23.199, 23.486, 23.6361, 23.6908, 23.6802, 23.6248, 23.5359, 23.5047, 23.4686,
         23.4467, 23.4528, 23.4432, 23.433, 23.3376, 23.232, 23.1224, 23.02, 22.9042, 22.7831, 22.6534, 22.5101,
         22.3459, 22.1501, 21.9053, 21.5806, 21.1153, 20.3664, 18.877, 13.3358, 12.6877, 4.27129, -7.36267, 7.5766,
         20.1159, 26.1204, 28.34, 27.0378, 25.9494, 25.1633, 24.5597, 24.0505, 23.5728, 23.057, 22.3145, 22.2201,
         21.8103, 21.301, 21.7474, 22.0741, 22.1454, 22.141, 22.0171, 21.8525, 22.021, 22.1656, 22.244, 22.2964,
         22.2928, 22.2043, 22.167, 21.9707, 21.7154, 21.9911, 22.2524, 22.414, 22.7965, 23.1627, 23.5533, 23.9653,
         24.3836, 24.7866, 25.14, 25.4068, 25.549, 25.5227, 25.2763, 24.7077, 23.6639, 21.8056, 18.171, 7.99874, 6.8089,
         -1.69126, -21.9139, -3.05614, -0.129034, -4.97044, -11.2965, 3.63331, 12.7805, 16.1223, 27.56, 32.828, 35.5387,
         35.6384, 34.38, 32.3952, 34.7078, 36.5972, 37.0034, 38.6875, 38.6787, 37.9519, 39.1322, 40.0238, 40.5402,
         43.0692, 43.5846, 43.5695, 43.108, 43.8732, 44.8271, 45.0197, 47.286, 48.8265, 49.9607, 50.8126, 51.444,
         51.8973, 52.2206, 52.5442, 52.7346, 52.8027, 52.8464, 52.8835, 52.7902, 52.5879, 52.2804, 51.8694, 51.3283,
         50.585, 49.4384, 46.9684, 45.729, 42.5859, 38.9711, 42.5027, 45.5088, 46.39, 46.8156, 45.894, 44.2328, 46.1993,
         48.132, 48.6016, 49.1977, 49.1273, 48.379, 49.5027, 50.8069, 51.4451, 53.5912, 54.8511, 55.6931, 56.281,
         56.7219, 56.997, 57.1703, 57.3491, 57.4399, 57.4834, 57.4549, 57.398, 57.3236, 57.2376, 57.1439, 57.0451,
         56.9428, 56.8376, 56.7295, 56.6175, 56.498, 56.3624, 56.1951, 55.9805, 55.6735, 55.1093, 54.2292, 53.0188,
         51.5674, 53.0359, 53.3483, 54.3636, 55.6912, 56.3415, 56.7055, 56.9403, 57.0962, 57.2003, 57.2696, 57.3146,
         57.3424, 57.3584, 57.3969, 57.3925, 57.3815, 57.3663, 57.3485, 57.3291, 57.309, 57.2887, 57.2686, 57.249,
         57.23, 57.2119, 57.1948, 57.1787, 57.1638, 57.1498, 57.1369, 57.1249, 57.1138, 57.1036, 57.0942, 57.0856,
         57.0777, 57.0705, 57.0639, 57.0578],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.4982, 8.3345, 8.1623, 7.4767, 6.7507, 5.9723, 5.2034, 4.4843, 3.8371,
         3.2705, 2.7843, 2.3731, 2.0287, 1.7424, 1.674, 1.6189, 1.6048, 1.6149, 1.5665, 1.5389, 1.3514, 1.1995, 1.0768,
         0.97787, 0.8984, 0.83474, 0.78385, 0.74326, 0.71114, 0.6862, 0.66685, 0.65186, 0.6402, 0.63111, 0.62394,
         0.6182, 0.61799, 0.61685, 0.61656, 24.131, 19.837, 14.48, 6.2404, 3.3591, 2.2914, 1.8404, 1.6467, 1.5839,
         1.6033, 1.6852, 1.8119, 1.8222, 1.8498, 1.8602, 2.8253, 2.8775, 2.9952, 3.0014, 3.0637, 3.0806, 3.4333, 3.5027,
         3.6262, 3.9852, 4.3834, 4.8098, 4.86, 4.9598, 4.9863, 5.541, 5.6421, 5.7724, 6.2234, 6.6495, 7.031, 7.3528,
         7.6033, 7.7705, 7.8465, 7.8382, 7.7563, 7.6133, 7.4219, 7.194, 6.9402, 6.6701, 6.3909, 6.1211, 6.108, 6.0566,
         6.0363, 25.206, 24.855, 24.715, 24.688, 37.187, 36.387, 35.868, 32.536, 29.646, 26.971, 25.83, 25.284, 25.142,
         29.075, 28.607, 28.438, 27.215, 26.665, 26.523, 28.098, 27.793, 27.535, 25.51, 24.842, 24.412, 24.301, 25.282,
         24.877, 24.766, 22.845, 20.959, 19.183, 17.542, 16.009, 14.606, 13.34, 12.171, 11.099, 10.131, 9.2543, 8.3917,
         7.559, 6.7776, 6.0781, 5.4587, 4.9111, 4.4267, 3.9916, 3.5875, 3.5036, 3.4185, 3.3963, 10.377, 10.105, 9.8871,
         9.5487, 9.3016, 9.2377, 12.65, 12.328, 12.176, 11.871, 11.566, 11.488, 13.155, 12.861, 12.629, 11.409, 10.292,
         9.2671, 8.3384, 7.4904, 6.6873, 5.9756, 5.3423, 4.7625, 4.2378, 3.7621, 3.3427, 2.9725, 2.6451, 2.3557, 2.0999,
         1.8735, 1.6731, 1.4955, 1.3359, 1.1917, 1.0525, 0.92569, 0.81452, 0.7173, 0.63221, 0.58681, 0.57031, 0.56603,
         3.4178, 3.4071, 3.3377, 3.06, 2.7431, 2.4574, 2.1998, 1.9636, 1.7523, 1.5634, 1.3947, 1.244, 1.1096, 0.98626,
         0.873, 0.77283, 0.68421, 0.6058, 0.53642, 0.47503, 0.4207, 0.37261, 0.33004, 0.29236, 0.25904, 0.22981,
         0.20389, 0.1809, 0.16052, 0.14244, 0.12641, 0.11218, 0.099565, 0.088371, 0.07844, 0.069628, 0.061809, 0.054871,
         0.048714]],
    'Ce':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.019404, 0.01948844, 0.019701, 0.0197802, 0.019899, 0.020196, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.037044, 0.037611, 0.0377622, 0.03797993,
         0.037989, 0.038556, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.084182, 0.08458368, 0.0854705, 0.0858141, 0.0863295,
         0.087618, 0.09041995, 0.09665893, 0.1033284, 0.1078, 0.10945, 0.10989, 0.1104581, 0.11055, 0.1122, 0.1180797,
         0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.203056, 0.206164,
         0.2069928, 0.208236, 0.211344, 0.2152655, 0.218834, 0.2221835, 0.2230767, 0.2244165, 0.227766, 0.2301188,
         0.245997, 0.2629708, 0.2811158, 0.283808, 0.288152, 0.2893104, 0.291048, 0.295392, 0.3005128, 0.3212482,
         0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625,
         0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.865634, 0.8739896, 0.8788835, 0.883274, 0.8877165, 0.8967935,
         0.9003987, 0.900966, 0.9058065, 0.919326, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.161692, 1.179473,
         1.184215, 1.191327, 1.209108, 1.220098, 1.247344, 1.266436, 1.271527, 1.279164, 1.298256, 1.304285, 1.394281,
         1.405908, 1.427427, 1.433165, 1.441773, 1.463292, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733,
         2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821,
         4.633924, 4.953664, 5.295467, 5.608932, 5.660855, 5.694783, 5.717677, 5.752017, 5.837868, 6.040916, 6.051453,
         6.133379, 6.158036, 6.195021, 6.287484, 6.417824, 6.469004, 6.516056, 6.542251, 6.581544, 6.679776, 6.915365,
         7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688,
         15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405,
         32.08502, 34.29889, 36.66551, 39.19543, 39.63414, 40.24079, 40.40256, 40.64522, 41.25186, 41.89992, 44.79101,
         47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374,
         99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018,
         207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001,
         432.9451],
        [18.5477, 18.4321, 18.2878, 18.1041, 17.864, 17.538, 17.0701, 16.3339, 14.9461, 10.8521, 10.0681, 6.1472,
         0.379223, 6.55466, 12.0134, 15.9795, 19.6057, 21.4408, 22.4561, 22.9871, 23.2158, 23.2563, 23.1818, 23.0382,
         22.9227, 22.8708, 22.8481, 22.8421, 22.8418, 22.8084, 22.664, 22.4654, 22.2623, 22.0558, 21.844, 21.6221,
         21.3955, 21.1284, 20.8174, 20.4375, 19.9452, 19.3008, 19.2365, 19.072, 18.9691, 18.934, 18.7633, 18.2758,
         16.6918, 13.137, 5.12263, -8.64721, -27.986, -5.31339, -2.53344, 18.4513, 30.5692, 29.1226, 26.9869, 25.7041,
         24.9525, 24.4842, 24.1452, 23.8195, 23.2986, 23.1721, 22.7074, 22.2092, 22.6691, 23.0311, 23.1562, 23.1771,
         23.0847, 22.9305, 23.1075, 23.2773, 23.3369, 23.526, 23.6066, 23.5791, 23.541, 23.3542, 23.1025, 23.3794,
         23.6458, 23.8, 24.2058, 24.5712, 24.963, 25.3727, 25.7854, 26.18, 26.5263, 26.783, 26.9084, 26.8554, 26.5618,
         25.9329, 24.7956, 22.7724, 18.7435, 8.85327, 4.11953, -1.15258, -34.5756, -2.48566, 0.634175, -4.41287,
         -8.3683, 4.57327, 14.1198, 19.4031, 29.9944, 34.8425, 36.9803, 36.8591, 35.5587, 33.531, 35.8829, 38.21,
         38.9332, 39.9517, 39.912, 39.1626, 40.3586, 41.7722, 42.0651, 44.5314, 44.6848, 44.6619, 44.1922, 44.9648,
         45.923, 46.7032, 48.7721, 50.2271, 51.2984, 52.1013, 52.6929, 53.1185, 53.5173, 53.7256, 53.8825, 53.9726,
         54.1316, 54.0412, 53.8652, 53.6071, 53.2539, 52.7952, 52.1906, 51.3382, 49.9245, 46.8297, 45.4426, 43.6597,
         39.988, 43.6201, 46.7211, 48.1015, 48.0772, 47.1455, 45.489, 47.4235, 49.308, 50.2841, 50.3955, 50.2108,
         49.4645, 50.5806, 51.8733, 53.3992, 55.1261, 56.221, 56.9654, 57.5029, 57.8541, 58.0788, 58.2206, 58.3774,
         58.449, 58.4781, 58.4372, 58.3727, 58.2934, 58.2044, 58.1087, 58.0087, 57.9055, 57.7995, 57.6904, 57.5765,
         57.4526, 57.3038, 57.1194, 56.8744, 56.4958, 55.6078, 55.2451, 54.0411, 52.598, 54.0571, 55.3764, 55.9523,
         57.0307, 57.5239, 57.821, 58.0169, 58.1468, 58.2336, 58.2911, 58.3279, 58.3503, 58.3941, 58.3944, 58.3864,
         58.3732, 58.3567, 58.3381, 58.3185, 58.2983, 58.2782, 58.2583, 58.2391, 58.2206, 58.2029, 58.1864, 58.171,
         58.1566, 58.1432, 58.1308, 58.1193, 58.1087, 58.0989, 58.0899, 58.0817, 58.0742, 58.0673, 58.0609],
        [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.424, 11.037, 10.269, 8.7851, 7.3863,
         6.1056, 4.9917, 4.0571, 3.2921, 2.6767, 2.1871, 1.9341, 1.8511, 1.8299, 1.8223, 1.8211, 1.7485, 1.5247, 1.2941,
         1.1157, 0.97795, 0.8719, 0.79042, 0.72792, 0.68006, 0.64347, 0.61552, 0.59418, 0.57914, 0.57815, 0.57606,
         0.57528, 0.67415, 0.68664, 0.72185, 0.84947, 1.0495, 1.2092, 1.2718, 1.2887, 40.959, 40.45, 32.422, 15.58,
         7.1616, 4.7904, 4.0662, 3.8505, 3.8044, 3.8146, 3.845, 3.8897, 3.8965, 3.9099, 3.9136, 4.8664, 4.893, 4.9281,
         4.9616, 4.9944, 5.0034, 5.3388, 5.3784, 5.407, 5.6147, 5.8612, 6.1427, 6.1853, 6.2541, 6.2724, 6.812, 6.8843,
         6.969, 7.3018, 7.624, 7.9138, 8.1521, 8.3262, 8.4268, 8.441, 8.3709, 8.2281, 8.0259, 7.7785, 7.499, 7.199,
         6.8875, 6.5726, 6.3043, 6.2595, 6.2335, 6.2104, 26.121, 25.699, 25.534, 25.509, 38.494, 37.541, 36.529, 32.667,
         29.443, 26.661, 25.984, 25.419, 25.272, 29.279, 28.619, 28.225, 27.301, 26.742, 26.598, 28.207, 27.629, 27.453,
         25.227, 24.983, 24.549, 24.437, 25.432, 25.02, 24.525, 22.579, 20.699, 18.933, 17.3, 15.796, 14.404, 13.148,
         11.988, 10.931, 9.9786, 9.0399, 8.1349, 7.3286, 6.5717, 5.8978, 5.3002, 4.7711, 4.3029, 3.8778, 3.5375, 3.485,
         3.4514, 3.4291, 10.533, 10.205, 9.5007, 9.4699, 9.2384, 9.1714, 12.55, 12.227, 11.799, 11.639, 11.497, 11.42,
         13.081, 12.792, 12.149, 10.991, 9.9078, 8.9174, 8.0097, 7.15, 6.3882, 5.7128, 5.1034, 4.5487, 4.045, 3.5928,
         3.1939, 2.8418, 2.5302, 2.2547, 2.0111, 1.7954, 1.6044, 1.435, 1.2815, 1.1348, 0.99927, 0.87956, 0.77465,
         0.68282, 0.60237, 0.58995, 0.57343, 0.56915, 3.4044, 3.3261, 3.2457, 2.9144, 2.6115, 2.3382, 2.0897, 1.8652,
         1.6646, 1.4854, 1.3254, 1.1825, 1.0531, 0.93251, 0.82579, 0.73135, 0.64777, 0.57379, 0.50831, 0.45033, 0.399,
         0.35354, 0.31329, 0.27764, 0.24629, 0.21867, 0.19415, 0.1724, 0.15309, 0.13595, 0.12074, 0.10723, 0.095245,
         0.084601, 0.075151, 0.066759, 0.059308, 0.05269]],
    'Pr':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.021854, 0.0221885, 0.02227063, 0.0222777, 0.0224115, 0.022746, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.036652, 0.037213, 0.0373626, 0.037587,
         0.03797993, 0.038148, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581,
         0.110936, 0.112634, 0.1130868, 0.113766, 0.115464, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005,
         0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.213248, 0.2152655, 0.216512, 0.2173824, 0.218688, 0.221952,
         0.2301188, 0.231574, 0.2351185, 0.2360637, 0.2374815, 0.241026, 0.245997, 0.2629708, 0.2811158, 0.29841,
         0.3005128, 0.3029775, 0.3041955, 0.3060225, 0.31059, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189,
         0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768,
         0.8739896, 0.91238, 0.926345, 0.930069, 0.932078, 0.9342948, 0.935655, 0.9463445, 0.9501489, 0.9558555,
         0.970122, 0.9987612, 1.067676, 1.141345, 1.217356, 1.220098, 1.235989, 1.240958, 1.248411, 1.267044, 1.304285,
         1.310652, 1.330713, 1.336063, 1.344087, 1.364148, 1.394281, 1.48078, 1.490486, 1.503445, 1.509489, 1.518555,
         1.54122, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724,
         3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 5.845014,
         5.934479, 5.958336, 5.994122, 6.051453, 6.083586, 6.311592, 6.408198, 6.43396, 6.469004, 6.472602, 6.569208,
         6.698104, 6.800626, 6.827965, 6.868974, 6.915365, 6.971496, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919,
         10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215,
         21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.15079,
         41.78065, 41.89992, 41.94861, 42.20055, 42.83041, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287,
         66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669,
         139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869,
         290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [17.2746, 17.1786, 17.0636, 16.9241, 16.7523, 16.536, 16.2553, 15.8752, 15.3259, 14.4414, 12.6571, 8.78438,
         3.65754, -1.5689, -2.66574, 4.16438, 10.2066, 15.7662, 19.0008, 20.6242, 21.4648, 21.8593, 21.993, 21.977,
         21.9361, 21.9051, 21.8881, 21.8891, 21.8795, 21.8737, 21.7708, 21.6522, 21.5466, 21.4645, 21.3979, 21.3576,
         21.3462, 21.3678, 21.4186, 21.4093, 21.3305, 21.1444, 20.7735, 20.0352, 18.3476, 11.6068, 10.3019, -0.981412,
         -16.7885, 3.85738, 21.0277, 28.6936, 31.4534, 29.6178, 28.2581, 27.3603, 26.7195, 26.206, 25.736, 25.2247,
         24.5328, 24.2898, 24.0212, 23.4988, 23.9617, 24.3073, 24.4087, 24.3919, 24.264, 24.0994, 24.2665, 24.4103,
         24.4805, 24.5523, 24.5591, 24.4528, 24.3988, 24.2591, 24.0036, 24.2818, 24.5476, 24.8143, 25.1989, 25.5909,
         26.0096, 26.4465, 26.8823, 27.2919, 27.6374, 27.8793, 27.9771, 27.883, 27.5307, 26.8172, 25.5391, 23.2365,
         18.3938, 9.90448, -0.185307, -11.0922, -10.3377, -3.36199, -1.35468, 2.11908, -3.13253, 6.00182, 15.6757,
         23.9928, 32.6129, 36.7032, 37.8194, 37.747, 36.4995, 34.4409, 36.8305, 39.1981, 40.9346, 41.0718, 41.016,
         40.2641, 41.4509, 42.8521, 44.0113, 45.8154, 45.8831, 45.7859, 45.3126, 46.0868, 47.0452, 48.361, 50.251,
         51.6042, 52.6024, 53.3495, 53.8968, 54.2865, 54.668, 54.9099, 55.0655, 55.2498, 55.1905, 55.0442, 54.8333,
         54.5398, 54.1509, 53.6469, 52.9708, 51.9742, 50.1049, 47.948, 44.8046, 41.158, 44.7709, 47.1935, 47.8639,
         49.291, 48.3098, 46.6523, 48.4282, 48.5756, 50.4377, 51.3533, 51.2799, 50.5336, 51.6492, 52.3747, 52.9391,
         55.1795, 56.613, 57.5552, 58.2224, 58.6655, 58.9521, 59.1366, 59.2527, 59.3873, 59.4424, 59.4585, 59.408,
         59.3379, 59.2553, 59.1643, 59.0678, 58.9673, 58.864, 58.7578, 58.6484, 58.5341, 58.399, 58.2361, 58.0303,
         57.7427, 57.2414, 56.2616, 55.0638, 54.3184, 53.628, 55.08, 56.3927, 57.5729, 58.2861, 58.6719, 58.9167,
         59.0794, 59.1879, 59.2606, 59.3083, 59.3386, 59.3582, 59.3943, 59.3901, 59.3794, 59.3645, 59.347, 59.3279,
         59.3081, 59.2879, 59.268, 59.2485, 59.2296, 59.2114, 59.1943, 59.1783, 59.1635, 59.1496, 59.1368, 59.1249,
         59.1139, 59.1037, 59.0944, 59.0858, 59.0779, 59.0707, 59.0641],
        [0.23728, 0.26237, 0.29076, 0.32288, 0.35918, 0.40006, 0.44589, 0.4971, 0.55414, 0.61742, 0.68733, 0.74176,
         0.75981, 0.76426, 0.76464, 13.314, 12.834, 11.483, 9.7813, 8.2672, 6.98, 5.9361, 5.1215, 4.5077, 4.2806,
         4.1821, 4.1573, 4.1426, 4.0837, 4.0597, 3.7806, 3.5873, 3.48, 3.4368, 3.4456, 3.4962, 3.5799, 3.6904, 3.6967,
         3.6665, 3.6299, 3.5846, 3.5296, 3.4646, 3.3896, 3.3048, 3.299, 3.2783, 3.2727, 35.265, 28.922, 21.62, 9.9813,
         6.1318, 4.7184, 4.0747, 3.7343, 3.5421, 3.4409, 3.4093, 3.4319, 3.4399, 3.4454, 3.4495, 4.4336, 4.4636, 4.5497,
         4.5665, 4.6095, 4.6214, 4.9652, 5.0167, 5.0924, 5.3744, 5.7025, 6.0245, 6.0636, 6.1093, 6.1318, 6.6829, 6.77,
         6.9693, 7.3577, 7.7181, 8.03, 8.2777, 8.4482, 8.5326, 8.5245, 8.434, 8.2746, 8.0606, 7.8062, 7.5237, 7.2236,
         6.9148, 6.6041, 6.405, 6.3351, 6.3167, 26.811, 26.698, 26.628, 26.093, 25.906, 39.126, 38.024, 35.955, 31.912,
         28.707, 26.058, 25.972, 25.485, 25.336, 29.405, 28.731, 27.473, 27.287, 26.726, 26.582, 28.188, 27.617, 26.813,
         24.922, 24.735, 24.492, 24.381, 25.383, 24.974, 24.063, 22.11, 20.25, 18.518, 16.915, 15.428, 14.073, 12.844,
         11.717, 10.692, 9.6854, 8.7117, 7.8467, 7.0689, 6.3421, 5.6964, 5.1242, 4.6174, 4.1684, 3.7541, 3.5682, 3.4816,
         3.4592, 10.518, 10.305, 10.188, 9.4366, 9.1775, 9.1113, 12.493, 12.481, 12.156, 11.748, 11.445, 11.368, 13.028,
         12.896, 12.739, 11.668, 10.546, 9.5034, 8.5385, 7.6226, 6.8109, 6.0909, 5.4519, 4.8664, 4.3371, 3.8547, 3.4263,
         3.0482, 2.7141, 2.4183, 2.1566, 1.9251, 1.72, 1.5382, 1.3762, 1.2199, 1.0772, 0.94878, 0.83572, 0.7367,
         0.64993, 0.59345, 0.5769, 0.57385, 0.57261, 3.3934, 3.3149, 3.0868, 2.7683, 2.4801, 2.2208, 1.9833, 1.7708,
         1.5808, 1.411, 1.2594, 1.1226, 0.99577, 0.88198, 0.78127, 0.69213, 0.6132, 0.54333, 0.48145, 0.42666, 0.37813,
         0.33515, 0.29707, 0.26334, 0.23394, 0.20785, 0.18468, 0.1641, 0.14582, 0.12959, 0.11517, 0.10236, 0.090977,
         0.080867, 0.071883, 0.0639, 0.056807]],
    'Nd':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.020678, 0.02083314, 0.0209945, 0.0210789, 0.0212055, 0.021522, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03675, 0.0373125, 0.0374625, 0.0376875,
         0.03797993, 0.03825, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025,
         0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958,
         0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956,
         0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622,
         0.11614001, 0.11672071, 0.11730431, 0.11748954, 0.11751046, 0.11751048, 0.11789083, 0.11848029, 0.11907269,
         0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979, 0.12453939,
         0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902, 0.13025706,
         0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944, 0.13623724,
         0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305, 0.14249197,
         0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239, 0.14903386,
         0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058, 0.15587609,
         0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134, 0.16303245,
         0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902, 0.17051736,
         0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862, 0.17834591,
         0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388,
         0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776,
         0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481,
         0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308,
         0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146,
         0.22433757, 0.22447692, 0.22472308, 0.22545925, 0.22658655, 0.22771948, 0.22885808, 0.23000237, 0.23115238,
         0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422, 0.23936509, 0.24056191, 0.24176472,
         0.24297355, 0.24315743, 0.24344258, 0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893, 0.25035448,
         0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567, 0.2618484,
         0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747, 0.27387001,
         0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845, 0.28644354,
         0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381, 0.29959433,
         0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873, 0.31178993, 0.31334888,
         0.31491562, 0.3155152, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438,
         0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602,
         0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502,
         0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665, 0.37311293,
         0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718, 0.38636941, 0.38830126, 0.39024276,
         0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737, 0.40410785, 0.40612839, 0.40815904,
         0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785,
         0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698,
         0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592,
         0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597,
         0.49087815, 0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035,
         0.51341465, 0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424,
         0.53698581, 0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492,
         0.56163914, 0.56444734, 0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181,
         0.58742432, 0.59036144, 0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663,
         0.61439331, 0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345,
         0.64260046, 0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883,
         0.67210262, 0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194,
         0.70295924, 0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464,
         0.73523251, 0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165,
         0.76898746, 0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067,
         0.80429212, 0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248,
         0.84121764, 0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112,
         0.87983843, 0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405,
         0.92023232, 0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226,
         0.96248072, 0.96729312, 0.97212959, 0.97699023, 0.97760223, 0.97779777, 0.98187519, 0.98678456, 0.99171848,
         0.99667708, 0.99936105, 0.99963891, 1.0016605, 1.0066688, 1.0117021, 1.0167606, 1.0218444, 1.0269536,
         1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017, 1.0794722,
         1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143, 1.1290314, 1.1346765,
         1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1867702, 1.192704,
         1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555, 1.2474618, 1.2536991,
         1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2965165, 1.2982423, 1.2982835, 1.3047335,
         1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577,
         1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4018615, 1.4037384, 1.4060887, 1.4131192, 1.4201848, 1.4272857,
         1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132, 1.5002773,
         1.5077787, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5732678,
         1.5770017, 1.5773321, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967,
         1.6494027, 1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278,
         1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.813351,
         1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672, 1.896603, 1.906086,
         1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955, 2.0035635,
         2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.106026,
         2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561, 2.2027149, 2.2137285,
         2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3038428, 2.315362, 2.3269388,
         2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388,
         2.4581685, 2.4704593, 2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244,
         2.5838796, 2.596799, 2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507,
         2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135,
         2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988,
         3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918,
         3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049,
         3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267,
         3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769,
         3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969,
         3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821,
         4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.083742, 6.176861, 6.201692, 6.23894, 6.332058, 6.469004,
         6.58707, 6.687892, 6.714778, 6.755107, 6.85593, 6.915365, 6.98348, 7.09037, 7.118874, 7.16163, 7.26852,
         7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688,
         15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405,
         32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 42.69752, 43.35106, 43.52533, 43.78675, 44.44028, 44.79101,
         47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374,
         99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018,
         207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001,
         432.9451],
        [14.844, 14.7192, 14.5682, 14.383, 14.1508, 13.8515, 13.4503, 12.8793, 11.9837, 10.2794, 5.53421, 3.72966,
         -0.0960247, -7.02935, 0.443496, 7.05288, 12.1512, 16.2683, 18.2917, 19.3604, 19.8867, 20.0933, 20.1157,
         20.0381, 19.9757, 19.9387, 19.9204, 19.9195, 19.9111, 19.9006, 19.7994, 19.6963, 19.6222, 19.5881, 19.6043,
         19.6841, 19.7918, 19.9005, 19.9804, 20.0357, 20.0504, 19.9983, 19.8321, 19.4554, 20.9142, 20.8515, 20.7848,
         20.7137, 20.6377, 20.5565, 20.4695, 20.3763, 20.2762, 20.1685, 20.0523, 19.9269, 19.7909, 19.6433, 19.4824,
         19.3065, 19.1135, 18.9007, 18.6649, 18.4023, 18.1078, 17.7752, 17.3961, 16.9596, 16.451, 15.8479, 15.1193,
         14.2163, 13.0569, 11.4906, 9.19412, 5.25443, -5.79019, -31.9507, -31.8147, -31.7939, 2.87043, 12.4334, 17.4057,
         20.6974, 23.0793, 24.8815, 26.2796, 27.3799, 28.252, 28.9449, 29.494, 29.926, 30.2618, 30.5176, 30.7063,
         30.8384, 30.9224, 30.965, 30.9715, 30.9458, 30.893, 30.8211, 30.7355, 30.6403, 30.5385, 30.4323, 30.3234,
         30.2132, 30.1027, 29.9926, 29.8837, 29.7763, 29.6708, 29.5675, 29.4665, 29.3681, 29.2722, 29.179, 29.0884,
         29.0004, 28.9151, 28.8323, 28.752, 28.6742, 28.5987, 28.5256, 28.4547, 28.386, 28.3194, 28.2548, 28.1921,
         28.1313, 28.0722, 28.0149, 27.9592, 27.905, 27.8523, 27.8011, 27.7512, 27.7026, 27.6552, 27.609, 27.5639,
         27.5199, 27.4769, 27.4349, 27.3938, 27.3535, 27.3141, 27.2754, 27.2375, 27.2003, 27.1637, 27.1277, 27.0924,
         27.0575, 27.0232, 26.9893, 26.9559, 26.9229, 26.8903, 26.858, 26.826, 26.7944, 26.7629, 26.7318, 26.7008,
         26.67, 26.6394, 26.6088, 26.5784, 26.5481, 26.5178, 26.4875, 26.4572, 26.4268, 26.3964, 26.3659, 26.3352,
         26.3044, 26.2733, 26.2421, 26.2105, 26.1786, 26.1463, 26.1137, 26.0805, 26.0468, 26.0125, 25.9776, 25.9418,
         25.9052, 25.8677, 25.829, 25.7891, 25.7478, 25.7048, 25.6598, 25.6127, 25.5629, 25.5098, 25.4528, 25.3908,
         25.3224, 25.2454, 25.1562, 25.0481, 24.9074, 24.6945, 24.1391, 23.894, 23.8879, 24.4907, 24.7326, 24.8514,
         24.9255, 24.9759, 25.0114, 25.0365, 25.0536, 25.064, 25.0685, 25.0671, 25.0592, 25.0433, 25.0153, 24.963,
         24.8079, 24.7223, 24.7234, 24.9173, 25.0122, 25.0643, 25.1008, 25.1292, 25.1523, 25.1719, 25.1888, 25.2036,
         25.2168, 25.2287, 25.2394, 25.2493, 25.2583, 25.2666, 25.2744, 25.2816, 25.2883, 25.2947, 25.3006, 25.3063,
         25.3116, 25.3167, 25.3215, 25.326, 25.3304, 25.3345, 25.3384, 25.342, 25.3454, 25.3486, 25.3516, 25.3542,
         25.3565, 25.3585, 25.3601, 25.3612, 25.3618, 25.3618, 25.361, 25.3593, 25.3565, 25.3522, 25.3463, 25.3381,
         25.3268, 25.3114, 25.29, 25.259, 25.2109, 25.1239, 24.8279, 24.8503, 25.0924, 25.2399, 25.3283, 25.3949,
         25.4502, 25.4986, 25.5425, 25.5832, 25.6215, 25.658, 25.6932, 25.7274, 25.7607, 25.7934, 25.8256, 25.8574,
         25.889, 25.9203, 25.9515, 25.9826, 26.0136, 26.0446, 26.0752, 26.1063, 26.1375, 26.1687, 26.2, 26.2314,
         26.2629, 26.2945, 26.3263, 26.3582, 26.3902, 26.4224, 26.4547, 26.4872, 26.5198, 26.5526, 26.5855, 26.6186,
         26.6518, 26.6852, 26.7187, 26.7523, 26.7861, 26.82, 26.854, 26.8882, 26.9224, 26.9568, 26.9912, 27.0258,
         27.0604, 27.0951, 27.1299, 27.1647, 27.1997, 27.2346, 27.2696, 27.3046, 27.3397, 27.3747, 27.4098, 27.4449,
         27.48, 27.515, 27.55, 27.585, 27.6199, 27.6548, 27.6896, 27.7244, 27.759, 27.7936, 27.8281, 27.8624, 27.8967,
         27.9308, 27.9647, 27.9985, 28.0322, 28.0657, 28.099, 28.132, 28.1649, 28.1975, 28.2298, 28.2619, 28.2936,
         28.325, 28.3561, 28.3869, 28.4172, 28.4472, 28.4768, 28.506, 28.5348, 28.563, 28.5909, 28.6182, 28.6451,
         28.6715, 28.6973, 28.7226, 28.7473, 28.7715, 28.795, 28.818, 28.8404, 28.8621, 28.8832, 28.9036, 28.9233,
         28.9424, 28.9607, 28.9783, 28.9952, 29.0113, 29.0267, 29.0412, 29.0549, 29.0679, 29.08, 29.0912, 29.1015,
         29.111, 29.1195, 29.1272, 29.1338, 29.1395, 29.1443, 29.148, 29.1507, 29.1523, 29.1529, 29.1524, 29.1508,
         29.1481, 29.1442, 29.1391, 29.1328, 29.1253, 29.1166, 29.1066, 29.0952, 29.0825, 29.0685, 29.0531, 29.0362,
         29.0179, 28.998, 28.9767, 28.9537, 28.9292, 28.903, 28.8752, 28.8456, 28.8143, 28.7811, 28.7461, 28.7091,
         28.6702, 28.6293, 28.5863, 28.5411, 28.4937, 28.444, 28.392, 28.3396, 28.2827, 28.2232, 28.161, 28.0961,
         28.0283, 27.9575, 27.8837, 27.8066, 27.7263, 27.6425, 27.5551, 27.464, 27.3691, 27.27, 27.1668, 27.0591,
         26.9467, 26.8295, 26.7072, 26.5796, 26.4463, 26.3071, 26.1616, 26.0095, 25.8504, 25.6839, 25.5094, 25.3266,
         25.1348, 24.9334, 24.7218, 24.4991, 24.2646, 24.0172, 23.756, 23.4797, 23.1869, 22.8761, 22.5455, 22.193,
         21.8163, 21.4123, 20.9779, 20.5089, 20.0005, 19.4466, 18.8399, 18.1709, 17.4272, 16.5924, 15.6442, 14.5504,
         13.2624, 11.7018, 9.72743, 7.03962, 2.76831, -10.4456, -22.7447, -22.762, -0.169924, 3.55695, 4.46341, 2.4008,
         -8.95807, -8.87175, 3.16228, 9.52744, 12.9304, 15.4145, 17.413, 19.1007, 20.5681, 21.8694, 23.0399, 24.104,
         25.0795, 25.9799, 26.8155, 27.5945, 28.3237, 29.0083, 29.6529, 30.2614, 30.8368, 31.3819, 31.8992, 32.3905,
         32.8578, 33.3025, 33.726, 34.1294, 34.5139, 34.8802, 35.2293, 35.5617, 35.878, 36.1787, 36.4642, 36.7347,
         36.9904, 37.2315, 37.4577, 37.669, 37.865, 38.0451, 38.2085, 38.354, 38.4802, 38.5848, 38.6646, 38.7151,
         38.7296, 38.697, 38.5988, 38.3993, 38.0146, 37.1555, 34.7103, 34.6325, 34.7017, 37.9088, 38.9968, 39.7146,
         40.2643, 40.7135, 41.0926, 41.4174, 41.696, 41.9314, 42.1234, 42.2814, 42.3984, 42.4558, 42.4046, 42.0209,
         41.3093, 41.3414, 42.1539, 43.041, 43.5497, 43.9423, 44.2742, 44.5668, 44.8307, 45.0718, 45.2936, 45.4979,
         45.6869, 45.8662, 46.0356, 46.1952, 46.3447, 46.4839, 46.6118, 46.7269, 46.8266, 46.9058, 46.9546, 46.9488,
         46.7997, 46.4683, 46.4656, 46.5384, 47.264, 47.6379, 47.9239, 48.1694, 48.3912, 48.5972, 48.7917, 48.9777,
         49.1569, 49.33, 49.4977, 49.6612, 49.8214, 49.9783, 50.1293, 50.275, 50.4161, 50.5529, 50.6858, 50.8151,
         50.9411, 51.064, 51.1841, 51.3014, 51.4163, 51.5288, 51.6391, 51.7475, 51.8542, 51.9587, 52.0603, 52.1594,
         52.2561, 52.3506, 52.4428, 52.5329, 52.6211, 52.7073, 52.7916, 52.874, 52.9548, 53.0338, 53.1111, 53.1868,
         53.2609, 53.3335, 53.4046, 53.4743, 53.5425, 53.6094, 53.675, 53.7394, 53.8025, 53.8641, 53.9243, 53.9832,
         54.0407, 54.0969, 54.152, 54.2057, 54.2583, 54.3098, 54.3601, 54.4093, 54.4575, 54.5045, 54.5506, 54.5957,
         54.6397, 54.6827, 54.7246, 54.7654, 54.8053, 54.8442, 54.8821, 54.9191, 54.9552, 54.9904, 55.0247, 55.0582,
         55.0909, 55.1227, 55.1538, 55.1841, 55.2137, 55.2426, 55.2707, 55.2982, 55.3251, 55.3513, 55.3768, 55.4018,
         55.4262, 55.4501, 55.4734, 55.4962, 55.5185, 55.5404, 55.5618, 55.6852, 55.7063, 55.7268, 55.7467, 55.7661,
         55.7849, 55.8032, 55.8211, 55.8385, 55.8555, 55.8721, 55.8884, 55.9043, 55.92, 55.9354, 55.9506, 56.0125,
         56.0276, 56.0425, 56.0573, 56.072, 56.0868, 56.1016, 56.1167, 56.1323, 56.1642, 56.1826, 56.2027, 56.2254,
         56.2662, 56.2762, 56.2847, 56.292, 56.2981, 56.3033, 56.3075, 56.3109, 56.3136, 56.3154, 56.3367, 56.3375,
         56.3375, 56.3368, 56.3355, 56.3336, 56.331, 56.3279, 56.3242, 56.32, 56.3152, 56.31, 56.3042, 56.2979, 56.2912,
         56.284, 56.2763, 56.2682, 56.2597, 56.2507, 56.2413, 56.2315, 56.2213, 56.2107, 56.1997, 56.1883, 56.1766,
         56.1645, 56.152, 56.1391, 56.1259, 56.1124, 56.0985, 56.0842, 56.0696, 56.0547, 56.0394, 56.0239, 56.008,
         55.9917, 55.9752, 55.9584, 55.9412, 55.9237, 55.9059, 55.8876, 55.8688, 55.8496, 55.8798, 55.5364, 55.0956,
         54.5257, 53.7453, 52.5236, 49.6236, 49.0992, 45.9862, 42.3756, 45.9501, 49.0157, 50.323, 50.4754, 49.4518,
         47.7614, 49.7211, 51.6041, 52.118, 52.4797, 52.4047, 51.6595, 52.7687, 54.0478, 54.8829, 56.8673, 58.0697,
         58.8974, 59.4525, 59.8121, 60.0465, 60.196, 60.3595, 60.4387, 60.474, 60.4403, 60.3808, 60.3052, 60.2192,
         60.1261, 60.0284, 59.9273, 59.8234, 59.7171, 59.6126, 59.4862, 59.339, 59.1595, 58.9249, 58.572, 57.813,
         57.2777, 56.0865, 54.659, 56.1019, 57.4061, 57.7322, 58.9643, 59.4877, 59.7971, 59.9994, 60.1336, 60.2238,
         60.284, 60.3235, 60.349, 60.3916, 60.392, 60.3843, 60.3715, 60.3552, 60.3369, 60.3175, 60.2975, 60.2775,
         60.2577, 60.2386, 60.2201, 60.2023, 60.1858, 60.1704, 60.1561, 60.1428, 60.1305, 60.1191, 60.1086, 60.0989,
         60.09, 60.0818, 60.0743, 60.0674],
        [0.27095, 0.30133, 0.33573, 0.37466, 0.41861, 0.46815, 0.5239, 0.58645, 0.65646, 0.73456, 0.81122, 0.8214,
         0.83203, 0.83761, 14.593, 14.087, 12.999, 11.145, 9.4814, 8.0415, 6.8589, 5.9286, 5.2254, 4.7161, 4.5213,
         4.446, 4.4273, 4.4216, 4.389, 4.3607, 4.1768, 4.0705, 4.0486, 4.0943, 4.1942, 4.3227, 4.3219, 4.3249, 4.326,
         4.3208, 4.3063, 4.2801, 4.2412, 4.1888, 4.1569, 4.1519, 4.1468, 4.1416, 4.1364, 4.1311, 4.1258, 4.1203, 4.1148,
         4.1092, 4.1035, 4.0978, 4.0919, 4.086, 4.0801, 4.074, 4.0679, 4.0617, 4.0554, 4.0491, 4.0427, 4.0362, 4.0296,
         4.023, 4.0163, 4.0096, 4.0027, 3.9958, 3.9888, 3.9818, 3.9747, 3.9675, 3.9602, 3.9579, 32.823, 32.823, 31.525,
         29.635, 27.872, 26.23, 24.699, 23.273, 21.943, 20.703, 19.548, 18.47, 17.466, 16.53, 15.657, 14.843, 14.084,
         13.376, 12.716, 12.101, 11.527, 10.992, 10.503, 10.056, 9.6484, 9.2749, 8.9324, 8.618, 8.3287, 8.0624, 7.8166,
         7.5896, 7.3796, 7.1851, 7.0046, 6.8369, 6.6809, 6.5356, 6.4, 6.2735, 6.1551, 6.0443, 5.9404, 5.8429, 5.7512,
         5.665, 5.5839, 5.5073, 5.4351, 5.3668, 5.3022, 5.2411, 5.1831, 5.1282, 5.0759, 5.0263, 4.9791, 4.9342, 4.8914,
         4.8505, 4.8115, 4.7743, 4.7387, 4.7047, 4.6721, 4.6409, 4.611, 4.5824, 4.5549, 4.5285, 4.5032, 4.4789, 4.4555,
         4.433, 4.4114, 4.3906, 4.3706, 4.3514, 4.3329, 4.3151, 4.298, 4.2815, 4.2656, 4.2503, 4.2356, 4.2215, 4.2079,
         4.1948, 4.1823, 4.1702, 4.1587, 4.1476, 4.1369, 4.1268, 4.117, 4.1077, 4.0988, 4.0903, 4.0823, 4.0746, 4.0673,
         4.0605, 4.054, 4.0479, 4.0421, 4.0368, 4.0318, 4.0271, 4.0229, 4.0189, 4.0154, 4.0122, 4.0093, 4.0068, 4.0047,
         4.0029, 4.0014, 4.0003, 3.9995, 3.9991, 3.999, 3.9992, 3.9998, 4.0008, 4.002, 4.0036, 4.0056, 4.0079, 4.0105,
         4.0134, 4.0167, 4.0204, 4.0208, 5.025, 5.0302, 5.0384, 5.047, 5.056, 5.0653, 5.0749, 5.085, 5.0953, 5.106,
         5.1171, 5.1285, 5.1402, 5.1523, 5.1648, 5.1776, 5.1907, 5.1927, 5.5238, 5.533, 5.5484, 5.5641, 5.5801, 5.5964,
         5.6131, 5.6301, 5.6474, 5.665, 5.6829, 5.7011, 5.7196, 5.7384, 5.7575, 5.7769, 5.7966, 5.8165, 5.8368, 5.8573,
         5.8781, 5.8992, 5.9205, 5.9421, 5.9639, 5.986, 6.0084, 6.031, 6.0538, 6.0768, 6.1001, 6.1236, 6.1473, 6.1712,
         6.1953, 6.2196, 6.2441, 6.2688, 6.2937, 6.3187, 6.3439, 6.3692, 6.3947, 6.4204, 6.4461, 6.472, 6.498, 6.5242,
         6.5504, 6.5767, 6.6031, 6.6296, 6.6562, 7.1864, 7.2036, 7.2314, 7.2592, 7.2871, 7.315, 7.3429, 7.3709, 7.3988,
         7.4268, 7.4547, 7.4826, 7.5105, 7.5384, 7.5662, 7.5939, 7.6216, 7.6492, 7.6767, 7.7041, 7.7314, 7.7586, 7.7857,
         7.8126, 7.8393, 7.8659, 7.8923, 7.9185, 7.9445, 7.9704, 7.996, 8.0214, 8.0465, 8.0715, 8.0962, 8.1206, 8.1448,
         8.1687, 8.1924, 8.2157, 8.2388, 8.2616, 8.2841, 8.3062, 8.3281, 8.3496, 8.3708, 8.3916, 8.412, 8.4321, 8.4518,
         8.4712, 8.4902, 8.5088, 8.5271, 8.5449, 8.5624, 8.5795, 8.5962, 8.6125, 8.6284, 8.6439, 8.659, 8.6736, 8.6879,
         8.7017, 8.7151, 8.7281, 8.7406, 8.7527, 8.7644, 8.7756, 8.7864, 8.7967, 8.8066, 8.8161, 8.8251, 8.8337, 8.8418,
         8.8494, 8.8566, 8.8634, 8.8696, 8.8752, 8.8803, 8.8849, 8.8889, 8.8925, 8.8954, 8.8979, 8.8998, 8.9012, 8.9021,
         8.9025, 8.9024, 8.9018, 8.9007, 8.899, 8.8969, 8.8943, 8.8913, 8.8877, 8.8837, 8.8792, 8.8742, 8.8688, 8.863,
         8.8566, 8.8499, 8.8427, 8.8351, 8.8271, 8.8186, 8.8097, 8.8005, 8.7908, 8.7807, 8.7703, 8.7595, 8.7483, 8.7367,
         8.7247, 8.7124, 8.6998, 8.6868, 8.6735, 8.6598, 8.6458, 8.6315, 8.6169, 8.602, 8.5867, 8.5712, 8.5554, 8.5393,
         8.5229, 8.5063, 8.4894, 8.4722, 8.4548, 8.4371, 8.4192, 8.401, 8.3826, 8.364, 8.3452, 8.3262, 8.3069, 8.2875,
         8.2678, 8.248, 8.228, 8.2078, 8.1874, 8.1668, 8.1461, 8.1253, 8.1042, 8.083, 8.0617, 8.0403, 8.0187, 7.9969,
         7.975, 7.953, 7.9308, 7.9086, 7.8862, 7.8638, 7.8412, 7.8185, 7.7958, 7.7729, 7.75, 7.727, 7.7039, 7.6807,
         7.6575, 7.6342, 7.6109, 7.5874, 7.564, 7.5405, 7.5169, 7.4933, 7.4696, 7.4459, 7.4222, 7.3984, 7.3746, 7.3508,
         7.3269, 7.3031, 7.2792, 7.2553, 7.2314, 7.2074, 7.1835, 7.1595, 7.1356, 7.1116, 7.0877, 7.0637, 7.0398, 7.0158,
         6.9919, 6.968, 6.9441, 6.9202, 6.8963, 6.8724, 6.8486, 6.8248, 6.801, 6.7772, 6.7534, 6.7297, 6.706, 6.6823,
         6.6586, 6.635, 6.6115, 6.5879, 6.5644, 6.541, 6.5176, 6.4942, 6.4709, 6.468, 25.854, 25.714, 25.547, 25.381,
         25.217, 25.128, 37.894, 38.008, 37.726, 37.445, 37.166, 36.89, 36.616, 36.343, 36.073, 35.805, 35.539, 35.275,
         35.013, 34.753, 34.495, 34.239, 33.985, 33.732, 33.482, 33.234, 32.987, 32.742, 32.5, 32.259, 32.02, 31.782,
         31.547, 31.313, 31.081, 30.851, 30.622, 30.396, 30.171, 29.948, 29.726, 29.506, 29.288, 29.071, 28.856, 28.643,
         28.431, 28.221, 28.013, 27.806, 27.601, 27.397, 27.195, 26.994, 26.794, 26.596, 26.4, 26.205, 26.012, 25.871,
         30.254, 30.252, 30.007, 29.763, 29.521, 29.282, 29.044, 28.808, 28.575, 28.343, 28.113, 27.897, 27.695, 27.496,
         27.3, 27.107, 26.916, 26.841, 28.63, 28.56, 28.354, 28.151, 27.951, 27.753, 27.557, 27.364, 27.174, 26.985,
         26.799, 26.623, 26.451, 26.282, 26.115, 25.95, 25.787, 25.627, 25.469, 25.312, 25.158, 25.006, 24.855, 24.707,
         24.63, 25.733, 25.726, 25.583, 25.435, 25.289, 25.144, 25.001, 24.859, 24.719, 24.58, 24.442, 24.301, 24.158,
         24.016, 23.876, 23.731, 23.579, 23.428, 23.278, 23.129, 22.982, 22.835, 22.689, 22.544, 22.4, 22.257, 22.115,
         21.974, 21.834, 21.695, 21.557, 21.416, 21.275, 21.135, 20.996, 20.857, 20.72, 20.583, 20.447, 20.312, 20.178,
         20.045, 19.912, 19.78, 19.649, 19.519, 19.389, 19.26, 19.132, 19.005, 18.879, 18.753, 18.628, 18.504, 18.38,
         18.257, 18.134, 18.012, 17.891, 17.77, 17.651, 17.532, 17.414, 17.296, 17.18, 17.064, 16.949, 16.835, 16.721,
         16.607, 16.492, 16.379, 16.266, 16.154, 16.042, 15.932, 15.822, 15.713, 15.605, 15.498, 15.391, 15.286, 15.181,
         15.077, 14.973, 14.871, 14.769, 14.668, 14.568, 14.469, 14.37, 14.272, 14.175, 14.079, 13.983, 13.888, 13.794,
         13.701, 13.608, 13.517, 13.425, 13.335, 13.243, 13.152, 13.061, 12.972, 12.883, 12.794, 12.707, 12.62, 12.534,
         12.448, 12.363, 12.279, 12.196, 12.113, 12.03, 11.948, 11.866, 11.785, 11.704, 11.624, 11.545, 11.466, 11.388,
         11.31, 11.233, 11.157, 11.081, 11.006, 10.93, 10.844, 10.758, 10.674, 10.589, 10.506, 10.423, 10.341, 10.26,
         10.179, 10.099, 10.019, 9.94, 9.8615, 9.7836, 9.7064, 9.6299, 9.554, 9.4788, 9.4042, 9.3302, 9.2569, 9.1842,
         9.1121, 9.0407, 8.9699, 8.8996, 8.83, 8.761, 8.6925, 8.6247, 8.5574, 8.4907, 8.4246, 8.3591, 8.2941, 8.2297,
         8.1658, 8.1025, 8.0397, 7.9775, 7.9158, 7.8546, 7.794, 7.7339, 7.6743, 7.6152, 7.5566, 7.4985, 7.4409, 7.3839,
         7.3273, 7.2712, 7.2155, 7.1584, 7.1016, 7.0453, 6.9895, 6.8021, 6.1071, 5.4906, 4.9438, 4.4599, 4.0284, 3.6265,
         3.5963, 3.5094, 3.4869, 10.477, 10.157, 9.7134, 9.3795, 9.1261, 9.0613, 12.49, 12.143, 11.947, 11.729, 11.409,
         11.33, 12.981, 12.689, 12.368, 11.191, 10.105, 9.0889, 8.1175, 7.2528, 6.4859, 5.8052, 5.1951, 4.6369, 4.1298,
         3.6706, 3.2654, 2.9074, 2.5908, 2.3103, 2.0622, 1.8424, 1.6476, 1.4747, 1.309, 1.1578, 1.0217, 0.90046, 0.7938,
         0.70034, 0.61837, 0.59708, 0.58049, 0.57619, 3.3802, 3.3033, 3.2633, 2.9336, 2.6295, 2.3545, 2.1055, 1.8805,
         1.6795, 1.4999, 1.3393, 1.1944, 1.0619, 0.9408, 0.83358, 0.73864, 0.65458, 0.58013, 0.51419, 0.45578, 0.40404,
         0.3582, 0.31759, 0.28159, 0.24998, 0.22225, 0.19761, 0.17571, 0.15625, 0.13895, 0.12357, 0.1099, 0.097751,
         0.086948, 0.077342, 0.068801, 0.061207]],
    'Pm':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.020678, 0.02083314, 0.0209945, 0.0210789, 0.0212055, 0.021522, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03675, 0.0373125, 0.0374625, 0.0376875,
         0.03797993, 0.03825, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025,
         0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958,
         0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956,
         0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622,
         0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12038579,
         0.1204142, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979, 0.12453939, 0.12516208,
         0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902, 0.13025706, 0.13090835,
         0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944, 0.13623724, 0.13691842,
         0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305, 0.14249197, 0.14320443,
         0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239, 0.14903386, 0.14977903,
         0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058, 0.15587609, 0.15665547,
         0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134, 0.16303245, 0.16384761,
         0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995,
         0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862, 0.17834591, 0.17923764,
         0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655,
         0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325,
         0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508,
         0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902,
         0.21556265, 0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757,
         0.22545925, 0.22658655, 0.22771948, 0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703,
         0.23581022, 0.23585864, 0.23614137, 0.23698927, 0.23817422, 0.23936509, 0.24056191, 0.24176472, 0.24297355,
         0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286,
         0.25423287, 0.25456716, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567, 0.2618484, 0.26315764,
         0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747, 0.27387001, 0.27523936,
         0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845, 0.28644354, 0.28787576,
         0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381, 0.29959433, 0.3010923,
         0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873, 0.31178993, 0.31334888, 0.31491562,
         0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438, 0.32773491, 0.32937358,
         0.33005637, 0.33074361, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602,
         0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502,
         0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665, 0.37311293,
         0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718, 0.38636941, 0.38830126, 0.39024276,
         0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737, 0.40410785, 0.40612839, 0.40815904,
         0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785,
         0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698,
         0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592,
         0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597,
         0.49087815, 0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035,
         0.51341465, 0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424,
         0.53698581, 0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492,
         0.56163914, 0.56444734, 0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181,
         0.58742432, 0.59036144, 0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663,
         0.61439331, 0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345,
         0.64260046, 0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883,
         0.67210262, 0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194,
         0.70295924, 0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464,
         0.73523251, 0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165,
         0.76898746, 0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067,
         0.80429212, 0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248,
         0.84121764, 0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112,
         0.87983843, 0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405,
         0.92023232, 0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226,
         0.96248072, 0.96729312, 0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605,
         1.0066688, 1.0117021, 1.0167606, 1.0218444, 1.0267933, 1.0269536, 1.0270069, 1.0320884, 1.0372489, 1.0424351,
         1.0476473, 1.0513391, 1.0516608, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0848695,
         1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143, 1.1290314, 1.1346765, 1.1403499,
         1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1867702, 1.192704, 1.1986676,
         1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555, 1.2474618, 1.2536991, 1.2599676,
         1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335, 1.3112571, 1.3178134, 1.3244025,
         1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3559325, 1.3578453, 1.3578674, 1.3646345, 1.3714577, 1.378315,
         1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942, 1.4488022,
         1.4560462, 1.4633265, 1.4703391, 1.4706431, 1.4724609, 1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787,
         1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5770017, 1.5848867,
         1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6442772, 1.6487228, 1.6494027,
         1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278, 1.7337534,
         1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.813351, 1.8224178,
         1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672, 1.896603, 1.906086, 1.9156165,
         1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955, 2.0035635, 2.0135813,
         2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.106026, 2.1165562,
         2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561, 2.2027149, 2.2137285, 2.2247971,
         2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735,
         2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685,
         2.4704593, 2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796,
         2.596799, 2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195,
         2.7295996, 2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171,
         2.8691917, 2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179,
         3.0159225, 3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853,
         3.1701572, 3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009,
         3.3322794, 3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663,
         3.5026927, 3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033,
         3.6818208, 3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554,
         3.8701096, 3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924,
         4.953664, 5.295467, 5.660855, 6.051453, 6.330114, 6.427004, 6.452841, 6.469004, 6.491597, 6.588486, 6.872544,
         6.915365, 6.977736, 7.005787, 7.047864, 7.153056, 7.279342, 7.392525, 7.420472, 7.465039, 7.576458, 7.902609,
         8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362,
         17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889,
         36.66551, 39.19543, 41.89992, 44.28032, 44.79101, 44.95808, 45.13881, 45.40992, 46.08768, 47.88159, 51.18542,
         54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353,
         113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548,
         237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [12.5974, 12.4613, 12.3126, 12.1106, 11.8573, 11.5312, 11.0943, 10.4739, 9.50254, 7.65798, 2.52909, 0.578709,
         -3.55699, -11.0546, -2.96724, 4.18486, 9.69595, 14.1247, 16.2788, 17.3987, 17.9337, 18.125, 18.1188, 18.0053,
         17.923, 17.8768, 17.8559, 17.8515, 17.8383, 17.8235, 17.6842, 17.5358, 17.412, 17.3214, 17.2687, 17.2569,
         17.2887, 17.3807, 17.51, 17.699, 17.9251, 18.0861, 18.1521, 18.0626, 21.0426, 21.013, 20.9808, 20.9459,
         20.9081, 20.8671, 20.8226, 20.7745, 20.7223, 20.6659, 20.6047, 20.5384, 20.4664, 20.3882, 20.3033, 20.2107,
         20.1098, 19.9996, 19.8788, 19.7461, 19.6, 19.4386, 19.2594, 19.0597, 18.8364, 18.584, 18.2973, 17.9689,
         17.5888, 17.1433, 16.613, 15.969, 15.1662, 14.1287, 12.7149, 10.6144, 6.90986, -5.15134, -22.5841, -22.4362,
         6.71061, 14.2183, 18.3192, 21.0848, 23.1102, 24.658, 25.87, 26.8329, 27.6041, 28.2237, 28.7212, 29.1188,
         29.4339, 29.68, 29.868, 30.0066, 30.1029, 30.1627, 30.1903, 30.1888, 30.1633, 30.1206, 30.0653, 30.0009,
         29.9301, 29.8548, 29.7764, 29.6963, 29.6153, 29.5341, 29.4533, 29.3734, 29.2947, 29.2175, 29.1419, 29.0681,
         28.9962, 28.9262, 28.8582, 28.7923, 28.7283, 28.6663, 28.6063, 28.5482, 28.492, 28.4376, 28.3849, 28.334,
         28.2847, 28.237, 28.1909, 28.1462, 28.1029, 28.061, 28.0204, 27.981, 27.9428, 27.9057, 27.8697, 27.8348,
         27.8008, 27.7677, 27.7356, 27.7042, 27.6737, 27.6439, 27.6148, 27.5864, 27.5587, 27.5315, 27.5049, 27.4788,
         27.4533, 27.4281, 27.4035, 27.3792, 27.3553, 27.3317, 27.3085, 27.2856, 27.2629, 27.2405, 27.2183, 27.1963,
         27.1744, 27.1527, 27.1311, 27.1097, 27.0883, 27.0669, 27.0457, 27.0244, 27.0031, 26.9818, 26.9604, 26.939,
         26.9174, 26.8958, 26.874, 26.852, 26.8299, 26.8075, 26.7849, 26.762, 26.7388, 26.7153, 26.6914, 26.6671,
         26.6423, 26.6171, 26.5913, 26.5649, 26.5378, 26.5101, 26.4815, 26.4521, 26.4217, 26.3901, 26.3574, 26.3233,
         26.2876, 26.2501, 26.2106, 26.1686, 26.1238, 26.0756, 26.0231, 25.9655, 25.901, 25.8274, 25.7407, 25.6341,
         25.4922, 25.2703, 24.6034, 24.506, 24.5005, 25.1225, 25.3599, 25.4826, 25.5617, 25.6173, 25.6579, 25.6877,
         25.7091, 25.7233, 25.7307, 25.7309, 25.7223, 25.7007, 25.6532, 25.4844, 25.4345, 25.4375, 25.6329, 25.7306,
         25.7882, 25.8307, 25.8649, 25.894, 25.9195, 25.9422, 25.9628, 25.9817, 25.9992, 26.0156, 26.031, 26.0455,
         26.0593, 26.0725, 26.0851, 26.0972, 26.1089, 26.1202, 26.1311, 26.1417, 26.152, 26.162, 26.1718, 26.1813,
         26.1906, 26.1996, 26.2084, 26.2169, 26.2252, 26.2333, 26.241, 26.2484, 26.2555, 26.2622, 26.2685, 26.2742,
         26.2793, 26.2837, 26.2873, 26.2898, 26.291, 26.2907, 26.2883, 26.2832, 26.2745, 26.2606, 26.239, 26.2044,
         26.1438, 26.004, 25.8298, 25.8376, 25.939, 26.1743, 26.2855, 26.3646, 26.429, 26.4848, 26.5351, 26.5817,
         26.6255, 26.6673, 26.7075, 26.7466, 26.7847, 26.822, 26.8588, 26.8951, 26.9311, 26.9667, 27.0045, 27.0398,
         27.075, 27.1102, 27.1453, 27.1804, 27.2155, 27.2506, 27.2858, 27.321, 27.3563, 27.3916, 27.4271, 27.4626,
         27.4982, 27.534, 27.5698, 27.6057, 27.6417, 27.6778, 27.7141, 27.7504, 27.7868, 27.8233, 27.8599, 27.8966,
         27.9334, 27.9702, 28.0071, 28.0441, 28.0811, 28.1182, 28.1554, 28.1926, 28.2298, 28.2671, 28.3044, 28.3417,
         28.379, 28.4163, 28.4536, 28.4909, 28.5282, 28.5654, 28.6027, 28.6398, 28.6769, 28.714, 28.7509, 28.7878,
         28.8246, 28.8613, 28.8979, 28.9344, 28.9708, 29.007, 29.0431, 29.079, 29.1148, 29.1504, 29.1858, 29.2211,
         29.256, 29.2908, 29.3253, 29.3595, 29.3934, 29.427, 29.4602, 29.4931, 29.5257, 29.5579, 29.5897, 29.6211,
         29.6521, 29.6827, 29.7128, 29.7424, 29.7716, 29.8003, 29.8285, 29.8561, 29.8833, 29.9099, 29.9359, 29.9613,
         29.9862, 30.0105, 30.0341, 30.0571, 30.0795, 30.1012, 30.1222, 30.1426, 30.1622, 30.1812, 30.1994, 30.2168,
         30.2335, 30.2495, 30.2646, 30.2789, 30.2924, 30.3051, 30.317, 30.3279, 30.338, 30.3472, 30.3555, 30.3628,
         30.3692, 30.3746, 30.379, 30.3825, 30.3849, 30.3862, 30.3865, 30.3857, 30.3839, 30.3808, 30.3767, 30.3714,
         30.3648, 30.3571, 30.3481, 30.3379, 30.3264, 30.3135, 30.2993, 30.2838, 30.2668, 30.2484, 30.2285, 30.2071,
         30.1841, 30.1621, 30.136, 30.1082, 30.0788, 30.0476, 30.0146, 29.9798, 29.9431, 29.9045, 29.8639, 29.8213,
         29.7766, 29.7297, 29.6806, 29.6292, 29.5776, 29.5214, 29.4627, 29.4014, 29.3375, 29.2707, 29.201, 29.1284,
         29.0527, 28.9737, 28.8915, 28.8057, 28.7164, 28.6233, 28.5262, 28.4251, 28.3197, 28.2099, 28.0953, 27.9759,
         27.8513, 27.7212, 27.5855, 27.4438, 27.2957, 27.141, 26.9791, 26.8097, 26.6323, 26.4464, 26.2514, 26.0467,
         25.8315, 25.6051, 25.3667, 25.1153, 24.8497, 24.5687, 24.2709, 23.9548, 23.6184, 23.2597, 22.8761, 22.4647,
         22.022, 21.5438, 21.0251, 20.4596, 19.8395, 19.1548, 18.3927, 17.5357, 16.5599, 15.4309, 14.1039, 12.4974,
         10.435, 7.56515, 2.77945, -22.1483, -26.8792, -22.4988, 1.58433, 4.98823, 5.96659, 4.51624, -7.48748, -7.60111,
         1.77888, 9.77361, 13.4392, 16.0406, 18.1099, 19.847, 21.352, 22.6832, 23.8785, 24.9635, 25.957, 26.873,
         27.7223, 28.5133, 29.253, 29.9468, 30.5995, 31.215, 31.7965, 32.3468, 32.8684, 33.3633, 33.8334, 34.2802,
         34.7051, 35.1092, 35.4938, 35.8596, 36.2074, 36.5379, 36.8517, 37.1491, 37.4307, 37.6965, 37.9467, 38.1812,
         38.4001, 38.6028, 38.7889, 38.9576, 39.1078, 39.2379, 39.3457, 39.428, 39.4803, 39.4957, 39.4633, 39.3642,
         39.1625, 38.7743, 37.9059, 35.539, 35.4989, 35.5324, 38.6761, 39.7544, 40.4681, 41.0163, 41.4657, 41.8464,
         42.1743, 42.4576, 42.7, 42.9021, 43.0731, 43.2089, 43.2972, 43.3111, 43.1658, 42.1883, 41.9985, 42.2231,
         43.4706, 44.1218, 44.568, 44.9287, 45.2394, 45.5159, 45.7663, 45.9953, 46.2055, 46.398, 46.5781, 46.748,
         46.9076, 47.0567, 47.1947, 47.3209, 47.4334, 47.5295, 47.6037, 47.6449, 47.625, 47.4301, 47.1621, 47.2348,
         47.3473, 47.9992, 48.3513, 48.6254, 48.8617, 49.0749, 49.2722, 49.4578, 49.6341, 49.8028, 49.9652, 50.123,
         50.2769, 50.4276, 50.5752, 50.718, 50.8566, 50.9915, 51.123, 51.2513, 51.3767, 51.4995, 51.6197, 51.7377,
         51.8534, 51.9672, 52.0791, 52.1892, 52.2979, 52.4052, 52.5112, 52.615, 52.7166, 52.8161, 52.9137, 53.0095,
         53.1035, 53.196, 53.2868, 53.3762, 53.4641, 53.5507, 53.636, 53.7201, 54.0324, 54.1145, 54.1948, 54.2733,
         54.3502, 54.5801, 54.654, 54.7261, 54.7965, 54.8651, 54.9318, 54.9968, 55.06, 55.1217, 55.1819, 55.2405,
         55.2978, 55.3536, 55.4081, 55.4613, 55.5133, 55.564, 55.6134, 55.6614, 55.7083, 55.754, 55.7984, 55.8418,
         55.884, 55.9252, 55.9653, 56.0044, 56.0425, 56.0797, 56.1159, 56.1512, 56.1857, 56.2192, 56.252, 56.2839,
         56.3151, 56.3455, 56.3751, 56.4041, 56.4324, 56.46, 56.487, 56.5133, 56.5391, 56.5643, 56.589, 56.6132,
         56.6369, 56.6601, 56.683, 56.7054, 56.8219, 56.8437, 56.865, 56.8858, 56.9061, 56.9259, 56.9453, 56.9644,
         56.9831, 57.0015, 57.0196, 57.0375, 57.0553, 57.073, 57.0906, 57.1082, 57.126, 57.1955, 57.2142, 57.2332,
         57.2688, 57.3099, 57.3283, 57.3431, 57.3556, 57.3663, 57.3755, 57.3833, 57.39, 57.3956, 57.4003, 57.404,
         57.4069, 57.409, 57.4104, 57.4111, 57.4112, 57.4106, 57.4093, 57.4285, 57.4263, 57.4234, 57.42, 57.416,
         57.4114, 57.4063, 57.4007, 57.3946, 57.388, 57.3809, 57.3734, 57.3654, 57.3569, 57.3481, 57.3388, 57.3291,
         57.3189, 57.3084, 57.2975, 57.2862, 57.2745, 57.2625, 57.25, 57.2373, 57.2241, 57.2106, 57.1967, 57.1825,
         57.1679, 57.153, 57.1378, 57.1222, 57.1063, 57.0901, 57.0735, 57.0566, 57.0393, 57.0217, 57.2709, 56.9459,
         56.5589, 56.0639, 55.4141, 54.4933, 52.9075, 50.2829, 47.193, 43.6091, 44.4402, 47.1568, 50.2049, 51.7067,
         51.5211, 50.6636, 48.9754, 50.9205, 52.7796, 53.6031, 53.512, 52.7858, 53.8921, 55.1658, 56.8936, 58.4739,
         59.5133, 60.208, 60.6562, 60.9484, 61.1371, 61.2555, 61.3937, 61.452, 61.4702, 61.4233, 61.3558, 61.2751,
         61.1858, 61.0911, 60.9926, 60.8916, 60.7901, 60.6889, 60.5693, 60.4331, 60.2729, 60.0727, 59.7978, 59.335,
         58.2962, 57.5906, 57.111, 55.6908, 57.1266, 58.4243, 59.4838, 60.2477, 60.6492, 60.9005, 61.0674, 61.1788,
         61.2539, 61.3038, 61.3369, 61.3547, 61.3914, 61.3874, 61.377, 61.3625, 61.3452, 61.3264, 61.3067, 61.2867,
         61.2669, 61.2475, 61.2287, 61.2105, 61.1934, 61.1775, 61.1627, 61.1489, 61.1362, 61.1244, 61.1135, 61.1035,
         61.0942, 61.0857, 61.0779, 61.0707],
        [0.24241, 0.27242, 0.30634, 0.34476, 0.38832, 0.43773, 0.49378, 0.55717, 0.62855, 0.70875, 0.78801, 0.79858,
         0.80963, 0.81543, 15.691, 15.134, 13.936, 11.898, 10.082, 8.5183, 7.2406, 6.2405, 5.4887, 4.9481, 4.743,
         4.6642, 4.6447, 4.6381, 4.6041, 4.5747, 4.3856, 4.282, 4.27, 4.3313, 4.4514, 4.6186, 4.8239, 5.0598, 5.3207,
         5.6013, 5.6952, 5.715, 5.7131, 5.688, 5.6661, 5.6624, 5.6585, 5.6545, 5.6503, 5.6461, 5.6417, 5.6371, 5.6324,
         5.6276, 5.6227, 5.6176, 5.6124, 5.6071, 5.6016, 5.596, 5.5903, 5.5844, 5.5784, 5.5723, 5.5661, 5.5597, 5.5532,
         5.5465, 5.5398, 5.5329, 5.5259, 5.5187, 5.5114, 5.5041, 5.4965, 5.4889, 5.4811, 5.4732, 5.4652, 5.4571, 5.4488,
         5.4405, 5.4388, 30.45, 29.192, 27.62, 26.151, 24.777, 23.493, 22.293, 21.172, 20.123, 19.143, 18.226, 17.369,
         16.568, 15.818, 15.118, 14.462, 13.849, 13.276, 12.739, 12.237, 11.769, 11.339, 10.946, 10.586, 10.255, 9.9501,
         9.6696, 9.4107, 9.1715, 8.95, 8.7448, 8.5542, 8.377, 8.2121, 8.0583, 7.9147, 7.7804, 7.6547, 7.5368, 7.4261,
         7.3221, 7.2242, 7.1319, 7.0448, 6.9625, 6.8846, 6.8109, 6.7409, 6.6745, 6.6114, 6.5514, 6.4942, 6.4397, 6.3876,
         6.3379, 6.2903, 6.2447, 6.2011, 6.1592, 6.119, 6.0804, 6.0432, 6.0075, 5.9731, 5.9399, 5.9079, 5.877, 5.8472,
         5.8183, 5.7905, 5.7635, 5.7374, 5.7121, 5.6877, 5.6639, 5.6409, 5.6186, 5.5969, 5.5759, 5.5555, 5.5357, 5.5165,
         5.4978, 5.4796, 5.462, 5.4449, 5.4282, 5.4121, 5.3963, 5.3811, 5.3663, 5.3519, 5.3379, 5.3244, 5.3112, 5.2985,
         5.2861, 5.2741, 5.2626, 5.2513, 5.2405, 5.23, 5.2199, 5.2101, 5.2007, 5.1917, 5.183, 5.1746, 5.1666, 5.159,
         5.1517, 5.1447, 5.138, 5.1318, 5.1258, 5.1202, 5.1149, 5.1099, 5.1053, 5.101, 5.0971, 5.0935, 5.0902, 5.0873,
         5.0847, 5.0824, 5.0804, 5.0788, 5.0776, 5.0766, 5.076, 5.0758, 5.0759, 5.0763, 5.077, 5.0781, 5.0781, 6.1083,
         6.1123, 6.1181, 6.1242, 6.1307, 6.1375, 6.1447, 6.1523, 6.1602, 6.1684, 6.177, 6.186, 6.1952, 6.2049, 6.2149,
         6.2252, 6.226, 6.559, 6.567, 6.5796, 6.5925, 6.6057, 6.6193, 6.6332, 6.6474, 6.6619, 6.6767, 6.6919, 6.7073,
         6.723, 6.739, 6.7552, 6.7718, 6.7886, 6.8057, 6.8231, 6.8408, 6.8587, 6.8769, 6.8953, 6.9139, 6.9328, 6.952,
         6.9714, 6.9909, 7.0108, 7.0308, 7.051, 7.0715, 7.0921, 7.1129, 7.1339, 7.1551, 7.1764, 7.1979, 7.2195, 7.2413,
         7.2633, 7.2853, 7.3075, 7.3298, 7.3523, 7.3748, 7.3974, 7.4201, 7.4429, 7.4657, 7.4886, 7.5116, 7.5346, 7.5441,
         8.0762, 8.0802, 8.1044, 8.1286, 8.1528, 8.177, 8.2013, 8.2254, 8.2496, 8.2738, 8.2979, 8.3219, 8.3459, 8.3698,
         8.3937, 8.4174, 8.4411, 8.4647, 8.4881, 8.5115, 8.5347, 8.5578, 8.5807, 8.6034, 8.6259, 8.6483, 8.6704, 8.6924,
         8.7141, 8.7356, 8.7568, 8.7779, 8.7986, 8.8192, 8.8394, 8.8594, 8.8791, 8.8986, 8.9176, 8.9363, 8.9548, 8.9729,
         8.9907, 9.0082, 9.0254, 9.0422, 9.0587, 9.0748, 9.0906, 9.1061, 9.1211, 9.1358, 9.1501, 9.1641, 9.1777, 9.1909,
         9.2037, 9.2161, 9.2281, 9.2397, 9.2509, 9.2617, 9.2721, 9.2821, 9.2916, 9.3008, 9.3095, 9.3178, 9.3257, 9.3331,
         9.3401, 9.3467, 9.3529, 9.3586, 9.3639, 9.3688, 9.3732, 9.3772, 9.3806, 9.3835, 9.3859, 9.3878, 9.3892, 9.39,
         9.3903, 9.3901, 9.3895, 9.3883, 9.3866, 9.3844, 9.3818, 9.3786, 9.375, 9.3709, 9.3663, 9.3612, 9.3557, 9.3498,
         9.3433, 9.3365, 9.3291, 9.3214, 9.3132, 9.3046, 9.2955, 9.2861, 9.2762, 9.266, 9.2553, 9.2442, 9.2328, 9.221,
         9.2088, 9.1962, 9.1833, 9.17, 9.1563, 9.1423, 9.128, 9.1134, 9.0984, 9.0831, 9.0674, 9.0515, 9.0353, 9.0187,
         9.0019, 8.9848, 8.9674, 8.9498, 8.9318, 8.9137, 8.8952, 8.8765, 8.8576, 8.8384, 8.819, 8.7994, 8.7796, 8.7595,
         8.7392, 8.7188, 8.6981, 8.6772, 8.6562, 8.6349, 8.6135, 8.5919, 8.5702, 8.5483, 8.5262, 8.504, 8.4816, 8.4591,
         8.4364, 8.4136, 8.3907, 8.3676, 8.3444, 8.3211, 8.2977, 8.2742, 8.2506, 8.2268, 8.203, 8.1791, 8.1552, 8.1311,
         8.107, 8.0827, 8.0585, 8.0341, 8.0097, 7.9853, 7.9607, 7.9362, 7.9115, 7.8869, 7.8622, 7.8374, 7.8126, 7.7878,
         7.763, 7.7381, 7.7132, 7.6883, 7.6634, 7.6384, 7.6135, 7.5885, 7.5635, 7.5386, 7.5136, 7.4886, 7.4636, 7.4386,
         7.4137, 7.3887, 7.3637, 7.3388, 7.3139, 7.289, 7.2641, 7.2392, 7.2144, 7.1895, 7.1647, 7.14, 7.1152, 7.0905,
         7.0658, 7.0412, 7.0165, 6.992, 6.9674, 6.9429, 6.9184, 6.894, 6.8696, 6.8453, 6.821, 6.7968, 6.7726, 6.7441,
         6.7071, 6.6703, 6.6338, 6.5967, 6.5608, 26.53, 26.528, 26.326, 26.123, 25.922, 25.723, 25.583, 38.691, 38.62,
         38.318, 38.017, 37.719, 37.424, 37.131, 36.84, 36.551, 36.265, 35.982, 35.7, 35.421, 35.144, 34.869, 34.596,
         34.326, 34.058, 33.792, 33.528, 33.266, 33.007, 32.749, 32.493, 32.24, 31.989, 31.739, 31.492, 31.246, 31.003,
         30.761, 30.522, 30.284, 30.048, 29.815, 29.583, 29.353, 29.124, 28.898, 28.673, 28.451, 28.23, 28.01, 27.793,
         27.577, 27.363, 27.151, 26.94, 26.731, 26.524, 26.321, 26.119, 25.976, 30.344, 30.343, 30.096, 29.851, 29.608,
         29.367, 29.129, 28.892, 28.658, 28.425, 28.195, 27.977, 27.771, 27.568, 27.369, 27.171, 26.977, 26.792, 26.784,
         28.592, 28.433, 28.225, 28.019, 27.815, 27.614, 27.416, 27.219, 27.025, 26.834, 26.646, 26.469, 26.294, 26.121,
         25.951, 25.783, 25.617, 25.453, 25.291, 25.131, 24.974, 24.818, 24.663, 24.606, 25.699, 25.686, 25.531, 25.378,
         25.226, 25.076, 24.927, 24.78, 24.634, 24.49, 24.347, 24.205, 24.066, 23.928, 23.791, 23.651, 23.508, 23.367,
         23.227, 23.087, 22.949, 22.811, 22.675, 22.539, 22.404, 22.27, 22.137, 22.005, 21.874, 21.744, 21.614, 21.484,
         21.352, 21.22, 21.09, 20.96, 20.83, 20.702, 20.574, 20.447, 20.321, 20.195, 20.07, 19.946, 19.822, 19.699,
         19.571, 19.443, 19.316, 19.189, 19.062, 18.933, 18.805, 18.678, 18.551, 18.424, 18.298, 18.173, 18.049, 17.926,
         17.803, 17.682, 17.561, 17.441, 17.322, 17.201, 17.081, 16.961, 16.843, 16.725, 16.608, 16.492, 16.377, 16.262,
         16.149, 16.036, 15.925, 15.814, 15.704, 15.594, 15.486, 15.378, 15.272, 15.166, 15.061, 14.957, 14.853, 14.751,
         14.649, 14.548, 14.448, 14.348, 14.25, 14.152, 14.055, 13.959, 13.864, 13.769, 13.675, 13.582, 13.49, 13.398,
         13.305, 13.213, 13.121, 13.031, 12.941, 12.852, 12.763, 12.676, 12.589, 12.502, 12.417, 12.332, 12.247, 12.164,
         12.081, 11.999, 11.916, 11.835, 11.753, 11.672, 11.578, 11.485, 11.393, 11.302, 11.211, 11.121, 11.033, 10.945,
         10.857, 10.771, 10.685, 10.6, 10.516, 10.433, 10.35, 10.268, 10.187, 10.106, 10.026, 9.9467, 9.8677, 9.7894,
         9.7119, 9.635, 9.5588, 9.4833, 9.4084, 9.3343, 9.2607, 9.1879, 9.1157, 9.0441, 8.9731, 8.9028, 8.8331, 8.764,
         8.6955, 8.6277, 8.5604, 8.4937, 8.4276, 8.3621, 8.2972, 8.2328, 8.169, 8.1057, 8.0431, 7.9809, 7.9193, 7.8582,
         7.7977, 7.7377, 7.6782, 7.6193, 7.5608, 7.5029, 7.4454, 7.2561, 6.5544, 5.9072, 5.312, 4.785, 4.3185, 3.8956,
         3.6294, 3.5428, 3.52, 10.534, 10.459, 10.145, 9.3341, 9.2306, 9.0844, 9.0205, 12.435, 12.089, 11.696, 11.369,
         11.295, 12.942, 12.65, 11.871, 10.736, 9.6674, 8.6411, 7.7194, 6.9021, 6.1767, 5.5326, 4.9456, 4.4134, 3.929,
         3.4954, 3.1123, 2.7736, 2.474, 2.2088, 1.9735, 1.7648, 1.5796, 1.4043, 1.2431, 1.1, 0.96981, 0.85514, 0.7544,
         0.66606, 0.60115, 0.58853, 0.58449, 0.58017, 3.37, 3.2928, 3.1007, 2.7819, 2.4927, 2.2324, 1.995, 1.7825,
         1.5924, 1.4225, 1.2691, 1.1288, 1.0024, 0.88835, 0.78738, 0.69796, 0.61874, 0.54857, 0.48639, 0.43129, 0.38247,
         0.3392, 0.30084, 0.26684, 0.23733, 0.21117, 0.1879, 0.16721, 0.1488, 0.13243, 0.11786, 0.10491, 0.09338,
         0.083124, 0.073998, 0.065877]],
    'Sm':                                                                                                         [
        [0.00539, 0.0054725, 0.0054945, 0.0055275, 0.00561, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.020874, 0.0211935, 0.0212787,
         0.0214065, 0.021726, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.036652, 0.037213, 0.0373626, 0.037587, 0.03797993, 0.038148, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368,
         0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294,
         0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712,
         0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956,
         0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029,
         0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979,
         0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12897987,
         0.12902012, 0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395,
         0.13488502, 0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579,
         0.14107766, 0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052,
         0.14755462, 0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113,
         0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121,
         0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497,
         0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726,
         0.17657574, 0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362,
         0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031,
         0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434,
         0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348,
         0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228, 0.21990634,
         0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948, 0.22885808, 0.23000237,
         0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422, 0.23936509, 0.24056191,
         0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.2472382, 0.2475618, 0.24786959, 0.24910893,
         0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567,
         0.2618484, 0.26315764, 0.26447343, 0.26540451, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171,
         0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044,
         0.28501845, 0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071,
         0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873,
         0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197,
         0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913,
         0.34107602, 0.3427814, 0.34449531, 0.34532318, 0.34607681, 0.34621779, 0.34794888, 0.34968862, 0.35143706,
         0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174,
         0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718,
         0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737,
         0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789,
         0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756, 0.43986595,
         0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045,
         0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815, 0.48118209,
         0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344,
         0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901,
         0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538,
         0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56726958, 0.57010592, 0.57295645, 0.57582123,
         0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325, 0.59627982, 0.59926122, 0.60225752,
         0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751,
         0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693,
         0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406,
         0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985,
         0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805,
         0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536,
         0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015,
         0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944,
         0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545,
         0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934,
         0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959, 0.97699023, 0.98187519, 0.98678456,
         0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489,
         1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0800822, 1.0803177,
         1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.105813, 1.1061869, 1.1067302, 1.1122639, 1.1178252, 1.1234143,
         1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659,
         1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555,
         1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335,
         1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577,
         1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4187409, 1.4201848, 1.4208592, 1.4272857,
         1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132, 1.5002773,
         1.5077787, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.5395028, 1.5418971, 1.545852, 1.5535812, 1.5613491,
         1.5691559, 1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967,
         1.6494027, 1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7203536,
         1.7251278, 1.7252464, 1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526,
         1.8043294, 1.813351, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672,
         1.896603, 1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772,
         1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227,
         2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561,
         2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3038428,
         2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616,
         2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057,
         2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832,
         2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518,
         2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506,
         2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387,
         3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587,
         3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058,
         3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957,
         3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654,
         3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739,
         4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.581876, 6.682619, 6.709484,
         6.749781, 6.850524, 6.915365, 7.165564, 7.275241, 7.304488, 7.348359, 7.392525, 7.458036, 7.582064, 7.698116,
         7.729063, 7.775484, 7.891536, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708,
         13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645,
         28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 45.89752, 46.60003, 46.78737,
         47.06837, 47.77089, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564,
         87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159,
         181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049,
         378.8588, 405.0001, 432.9451],
        [12.6627, 12.6395, 12.62, 12.6329, 12.6384, 11.9895, 11.8453, 11.6714, 11.4588, 11.1936, 10.8539, 10.4023,
         9.8018, 8.82703, 7.04772, 1.54367, 1.13415, -5.42605, -13.5144, -4.77791, 2.94811, 7.74165, 13.1791, 15.6856,
         16.9697, 17.5776, 17.7918, 17.7805, 17.6467, 17.5585, 17.5059, 17.483, 17.4764, 17.4536, 17.4423, 17.2685,
         17.089, 16.9349, 16.8151, 16.735, 16.6946, 16.6887, 16.7318, 16.7934, 16.8862, 17.0075, 17.1534, 17.3175,
         17.4882, 20.5652, 20.5766, 20.5878, 20.5987, 20.6092, 20.6194, 20.6291, 20.6388, 20.6473, 20.654, 20.6588,
         20.6616, 20.6622, 20.6607, 20.6569, 20.6506, 20.6417, 20.6301, 20.6155, 20.5979, 20.5769, 20.5524, 20.524,
         20.4915, 20.455, 20.4131, 20.3659, 20.3129, 20.2535, 20.1871, 20.1128, 20.0299, 19.9372, 19.8336, 19.7175,
         19.5872, 19.4406, 19.275, 19.0872, 18.8731, 18.6273, 18.3429, 18.0107, 17.6178, 17.1458, 16.5674, 15.8392,
         14.8876, 13.5719, 11.5723, 7.86869, -11.309, -15.2959, -15.1333, 10.0196, 15.8212, 19.185, 21.5087, 23.2368,
         24.5738, 25.6325, 26.483, 27.172, 27.7327, 28.1894, 28.5606, 28.8605, 29.1007, 29.2902, 29.4363, 29.545,
         29.6211, 29.6681, 29.6888, 29.6881, 29.6719, 29.6442, 29.608, 29.5655, 29.5185, 29.4682, 29.4158, 29.3622,
         29.3078, 29.2534, 29.1992, 29.1457, 29.093, 29.0414, 28.991, 28.9419, 28.8941, 28.8478, 28.803, 28.7596,
         28.7177, 28.6773, 28.6382, 28.6006, 28.5644, 28.5295, 28.4959, 28.4635, 28.4324, 28.4024, 28.3735, 28.3457,
         28.3189, 28.293, 28.2681, 28.2441, 28.2209, 28.1985, 28.1769, 28.1559, 28.1357, 28.116, 28.097, 28.0785,
         28.0606, 28.0431, 28.0261, 28.0095, 27.9933, 27.9774, 27.9619, 27.9467, 27.9318, 27.9171, 27.9026, 27.8883,
         27.8742, 27.8603, 27.8464, 27.8327, 27.819, 27.8054, 27.7918, 27.7782, 27.7645, 27.7509, 27.7372, 27.7234,
         27.7095, 27.6954, 27.6812, 27.6669, 27.6523, 27.6375, 27.6225, 27.6071, 27.5915, 27.5756, 27.5593, 27.5425,
         27.5254, 27.5078, 27.4897, 27.471, 27.4518, 27.4319, 27.4112, 27.3899, 27.3676, 27.3445, 27.3203, 27.295,
         27.2684, 27.2404, 27.2109, 27.1796, 27.1462, 27.1104, 27.0719, 27.0301, 26.9843, 26.9336, 26.8767, 26.8116,
         26.7352, 26.642, 26.5215, 26.3473, 26.0106, 25.4816, 25.4768, 25.8299, 26.2469, 26.4145, 26.5167, 26.5877,
         26.6399, 26.6792, 26.7086, 26.7296, 26.7429, 26.7477, 26.7422, 26.7202, 26.6594, 26.4878, 26.4932, 26.7272,
         26.8103, 26.8667, 26.9111, 26.9484, 26.9811, 27.0104, 27.0371, 27.0617, 27.0847, 27.1063, 27.1266, 27.146,
         27.1645, 27.1822, 27.1992, 27.2157, 27.2316, 27.247, 27.2619, 27.2764, 27.2906, 27.3044, 27.3179, 27.3311,
         27.344, 27.3566, 27.369, 27.381, 27.3928, 27.4042, 27.4154, 27.4262, 27.4367, 27.4468, 27.4565, 27.4657,
         27.4743, 27.4823, 27.4896, 27.4959, 27.5013, 27.5053, 27.5077, 27.508, 27.5057, 27.4998, 27.4889, 27.4705,
         27.4395, 27.3841, 27.2578, 27.0743, 27.0834, 27.1381, 27.4045, 27.5221, 27.6054, 27.6729, 27.7316, 27.7845,
         27.8336, 27.8798, 27.9239, 27.9664, 28.0077, 28.0479, 28.0874, 28.1263, 28.1646, 28.2026, 28.2403, 28.2777,
         28.3149, 28.352, 28.389, 28.426, 28.4366, 28.4735, 28.5103, 28.5472, 28.5841, 28.6211, 28.6581, 28.6952,
         28.7324, 28.7696, 28.8069, 28.8443, 28.8817, 28.9193, 28.9569, 28.9946, 29.0324, 29.0702, 29.1082, 29.1462,
         29.1842, 29.2224, 29.2606, 29.2988, 29.3372, 29.3755, 29.4139, 29.4524, 29.4908, 29.5293, 29.5678, 29.6063,
         29.6449, 29.6834, 29.7219, 29.7604, 29.7988, 29.8372, 29.8756, 29.9139, 29.9522, 29.9904, 30.0285, 30.0665,
         30.1044, 30.1423, 30.18, 30.2176, 30.255, 30.2923, 30.3295, 30.3665, 30.4033, 30.44, 30.4765, 30.5128, 30.5488,
         30.5847, 30.6204, 30.6558, 30.6909, 30.7258, 30.7604, 30.7946, 30.8286, 30.8622, 30.8954, 30.9283, 30.9607,
         30.9928, 31.0244, 31.0556, 31.0863, 31.1166, 31.1464, 31.1757, 31.2044, 31.2327, 31.2604, 31.2875, 31.3141,
         31.3401, 31.3655, 31.3903, 31.4144, 31.4379, 31.4608, 31.483, 31.5045, 31.5253, 31.5454, 31.5647, 31.5834,
         31.6013, 31.6184, 31.6347, 31.6502, 31.665, 31.6789, 31.6919, 31.7041, 31.7155, 31.7259, 31.7354, 31.744,
         31.7517, 31.7585, 31.7642, 31.769, 31.7727, 31.7755, 31.7772, 31.7778, 31.7774, 31.7758, 31.7731, 31.7693,
         31.7643, 31.7582, 31.7508, 31.7422, 31.7323, 31.7211, 31.7086, 31.6948, 31.6796, 31.663, 31.645, 31.6255,
         31.6046, 31.5867, 31.5627, 31.5371, 31.5098, 31.4809, 31.4502, 31.4178, 31.3836, 31.3475, 31.3095, 31.2695,
         31.2276, 31.1836, 31.1374, 31.0891, 31.0402, 30.9873, 30.932, 30.8742, 30.8138, 30.7508, 30.6851, 30.6166,
         30.5451, 30.4705, 30.3928, 30.3119, 30.2275, 30.1396, 30.048, 29.9525, 29.8531, 29.7494, 29.6414, 29.5288,
         29.4113, 29.2888, 29.1611, 29.0277, 28.8884, 28.743, 28.5909, 28.432, 28.2656, 28.0915, 27.909, 27.7176,
         27.5167, 27.3056, 27.0836, 26.8498, 26.6032, 26.3429, 26.0676, 25.7759, 25.4663, 25.137, 24.786, 24.4108,
         24.0086, 23.8623, 23.41, 22.8983, 22.3385, 21.7245, 21.0471, 20.2942, 19.4493, 18.4895, 17.3824, 16.0787,
         14.4986, 12.4979, 9.76901, 5.41125, -8.4845, -20.0658, -20.4132, 2.37973, 6.31812, 7.54898, 6.54865, -5.44034,
         -5.54165, 0.293779, 10.7026, 14.5771, 17.2549, 19.3618, 21.1195, 22.6362, 23.974, 25.1724, 26.2585, 27.2515,
         28.1659, 29.0127, 29.8008, 30.537, 31.2271, 31.8758, 32.487, 33.064, 33.6098, 34.1267, 34.6168, 35.082,
         35.5238, 35.9436, 36.3426, 36.7218, 37.0821, 37.4242, 37.7489, 38.0566, 38.3478, 38.6227, 38.8814, 39.1242,
         39.3508, 39.5609, 39.7542, 39.9298, 40.0866, 40.2233, 40.3376, 40.4264, 40.4855, 40.5082, 40.4839, 40.3947,
         40.2067, 39.8419, 39.0431, 36.6193, 35.1582, 36.613, 39.571, 40.7074, 41.4447, 42.0074, 42.4677, 42.8577,
         43.1941, 43.4859, 43.7373, 43.9488, 44.129, 44.2753, 44.3773, 44.4127, 44.3185, 43.7226, 43.3145, 43.3563,
         44.3465, 45.1079, 45.59, 45.9703, 46.2944, 46.581, 46.8395, 47.0753, 47.2916, 47.4894, 47.6728, 47.8461,
         48.009, 48.1611, 48.3022, 48.4312, 48.5467, 48.6459, 48.7236, 48.7694, 48.7575, 48.5899, 48.3059, 48.363,
         48.3838, 49.0945, 49.4588, 49.7386, 49.9783, 50.1939, 50.3931, 50.58, 50.7574, 50.9269, 51.0899, 51.248,
         51.4021, 51.5528, 51.7004, 51.8434, 51.982, 52.1169, 52.2482, 52.3764, 52.5017, 52.6242, 52.7442, 52.8619,
         52.9773, 53.0907, 53.2022, 53.3119, 53.42, 53.5268, 53.6323, 53.7358, 53.837, 53.936, 54.0331, 54.1284,
         54.2218, 54.3136, 54.4038, 54.4924, 54.5796, 54.6653, 54.7497, 54.8329, 54.9148, 54.9955, 55.2956, 55.3737,
         55.4502, 55.525, 55.7481, 55.8202, 55.8904, 55.9589, 56.0256, 56.0905, 56.1536, 56.2152, 56.2753, 56.3339,
         56.391, 56.4468, 56.5012, 56.5543, 56.6062, 56.6569, 56.7064, 56.7547, 56.802, 56.8482, 56.8933, 56.9372,
         56.9801, 57.0218, 57.0626, 57.1023, 57.1411, 57.1789, 57.2158, 57.2518, 57.2869, 57.3213, 57.3548, 57.3875,
         57.4195, 57.4507, 57.4813, 57.5112, 57.5404, 57.5691, 57.5971, 57.6247, 57.6516, 57.6781, 57.7042, 57.7298,
         57.7551, 57.78, 57.8046, 57.8289, 57.9556, 57.9802, 58.0046, 58.0289, 58.0531, 58.0774, 58.1021, 58.1275,
         58.154, 58.183, 58.2179, 58.2834, 58.301, 58.3166, 58.3307, 58.3436, 58.3556, 58.4146, 58.4249, 58.4343,
         58.4427, 58.4503, 58.457, 58.4629, 58.4681, 58.4725, 58.4763, 58.4793, 58.4817, 58.4834, 58.4846, 58.4851,
         58.485, 58.4844, 58.4832, 58.4816, 58.4793, 58.4766, 58.4735, 58.4903, 58.4863, 58.4818, 58.4768, 58.4713,
         58.4653, 58.4588, 58.4519, 58.4445, 58.4367, 58.4285, 58.4198, 58.4107, 58.4012, 58.3914, 58.3811, 58.3704,
         58.3594, 58.348, 58.3362, 58.3241, 58.3116, 58.2987, 58.2855, 58.272, 58.2581, 58.2439, 58.2293, 58.2144,
         58.1992, 58.4761, 58.18, 57.8318, 57.4103, 56.8644, 56.1302, 55.0264, 52.7472, 51.376, 48.2974, 44.7163,
         48.2774, 51.3435, 52.1218, 52.8838, 51.8181, 50.1326, 52.0594, 53.0809, 53.8886, 54.6545, 54.5824, 53.8405,
         54.9428, 56.2108, 56.292, 58.6461, 60.0049, 60.8642, 61.4251, 61.7932, 62.0339, 62.1879, 62.3534, 62.3992,
         62.4411, 62.4459, 62.3903, 62.3177, 62.2344, 62.144, 62.0492, 61.9516, 61.8538, 61.7569, 61.6432, 61.5154,
         61.3696, 61.1938, 60.9665, 60.6307, 59.9454, 59.3118, 58.1331, 56.721, 58.1477, 59.4373, 59.5434, 60.9184,
         61.4636, 61.7813, 61.9873, 62.1242, 62.2165, 62.2786, 62.3211, 62.3457, 62.3573, 62.3883, 62.381, 62.3684,
         62.3525, 62.3345, 62.3153, 62.2955, 62.2757, 62.2562, 62.2371, 62.2187, 62.201, 62.1845, 62.1693, 62.1551,
         62.1419, 62.1297, 62.1185, 62.1081, 62.0985, 62.0896, 62.0815, 62.0741],
        [0.0, 0.0, 0.0, 0.033428, 0.035067, 0.19065, 0.21975, 0.2527, 0.29009, 0.33254, 0.3808, 0.43567, 0.49806,
         0.56895, 0.64942, 0.7406, 0.74345, 0.76591, 0.77195, 16.823, 16.205, 15.23, 12.929, 10.907, 9.1675, 7.7466,
         6.6351, 5.7999, 5.1995, 4.988, 4.8988, 4.8768, 4.867, 4.8155, 4.7949, 4.5712, 4.4534, 4.4363, 4.4994, 4.6244,
         4.7895, 4.9941, 5.2307, 5.4931, 5.7767, 6.0781, 6.3945, 6.7245, 7.067, 7.246, 7.2725, 7.2991, 7.3257, 7.3525,
         7.3792, 7.4061, 7.4181, 7.4167, 7.415, 7.4132, 7.4111, 7.4088, 7.4063, 7.4036, 7.4007, 7.3976, 7.3943, 7.3907,
         7.387, 7.383, 7.3789, 7.3745, 7.3699, 7.3651, 7.3602, 7.355, 7.3496, 7.344, 7.3381, 7.3321, 7.3259, 7.3195,
         7.3129, 7.3061, 7.299, 7.2918, 7.2844, 7.2768, 7.2689, 7.2609, 7.2527, 7.2443, 7.2357, 7.2269, 7.2179, 7.2087,
         7.1994, 7.1898, 7.1801, 7.1701, 7.16, 7.1598, 29.133, 27.85, 26.53, 25.292, 24.132, 23.044, 22.024, 21.068,
         20.171, 19.331, 18.542, 17.803, 17.109, 16.459, 15.848, 15.276, 14.738, 14.234, 13.76, 13.315, 12.9, 12.519,
         12.169, 11.846, 11.549, 11.275, 11.022, 10.787, 10.569, 10.367, 10.178, 10.003, 9.839, 9.6858, 9.5424, 9.4079,
         9.2816, 9.1628, 9.051, 8.9455, 8.8458, 8.7516, 8.6623, 8.5777, 8.4973, 8.4208, 8.348, 8.2786, 8.2124, 8.1491,
         8.0885, 8.0305, 7.9749, 7.9215, 7.8702, 7.8208, 7.7732, 7.7274, 7.6831, 7.6404, 7.5991, 7.5591, 7.5204, 7.4829,
         7.4465, 7.4112, 7.3769, 7.3436, 7.3112, 7.2796, 7.2489, 7.219, 7.1898, 7.1614, 7.1336, 7.1065, 7.0801, 7.0543,
         7.029, 7.0043, 6.9802, 6.9566, 6.9335, 6.911, 6.8889, 6.8673, 6.8461, 6.8254, 6.8051, 6.7853, 6.7659, 6.7469,
         6.7283, 6.71, 6.6922, 6.6748, 6.6577, 6.6411, 6.6248, 6.6088, 6.5932, 6.578, 6.5632, 6.5487, 6.5345, 6.5207,
         6.5072, 6.4941, 6.4814, 6.4689, 6.4569, 6.4451, 6.4337, 6.4227, 6.412, 6.4016, 6.3916, 6.3819, 6.3726, 6.3636,
         6.3549, 6.3466, 6.3386, 6.331, 6.3237, 6.3167, 6.3101, 6.3039, 6.2979, 6.2924, 6.2871, 6.2847, 7.338, 7.3379,
         7.3374, 7.3374, 7.3377, 7.3383, 7.3393, 7.3407, 7.3424, 7.3445, 7.347, 7.3498, 7.353, 7.3565, 7.3604, 7.3634,
         7.6966, 7.7027, 7.7093, 7.7162, 7.7235, 7.7311, 7.739, 7.7473, 7.7559, 7.7649, 7.7741, 7.7837, 7.7935, 7.8037,
         7.8141, 7.8249, 7.836, 7.8473, 7.859, 7.8709, 7.8831, 7.8956, 7.9084, 7.9214, 7.9347, 7.9482, 7.962, 7.9761,
         7.9903, 8.0049, 8.0196, 8.0345, 8.0497, 8.0651, 8.0807, 8.0965, 8.1124, 8.1286, 8.1449, 8.1614, 8.1781, 8.1949,
         8.2118, 8.2289, 8.2462, 8.2635, 8.281, 8.2986, 8.3163, 8.334, 8.3519, 8.3698, 8.3878, 8.3965, 8.9281, 8.9296,
         8.9488, 8.9681, 8.9874, 9.0067, 9.0261, 9.0454, 9.0648, 9.0841, 9.1035, 9.1228, 9.142, 9.1612, 9.1804, 9.1995,
         9.2185, 9.2375, 9.2563, 9.2751, 9.2938, 9.3123, 9.3307, 9.3489, 9.367, 9.3849, 9.4026, 9.4201, 9.4375, 9.4546,
         9.4715, 9.4881, 9.5045, 9.5207, 9.5366, 9.5522, 9.5676, 9.5828, 9.5976, 9.6122, 9.6265, 9.6405, 9.6542, 9.6676,
         9.6807, 9.6935, 9.706, 9.7181, 9.7299, 9.7413, 9.7524, 9.7632, 9.7736, 9.7836, 9.7933, 9.8026, 9.8116, 9.8201,
         9.8283, 9.8361, 9.8435, 9.8505, 9.8572, 9.8634, 9.8692, 9.8747, 9.8797, 9.8843, 9.8885, 9.8923, 9.8957, 9.8987,
         9.9012, 9.9034, 9.9051, 9.9064, 9.9073, 9.9078, 9.9078, 9.9075, 9.9067, 9.9055, 9.9038, 9.9016, 9.8989, 9.8957,
         9.892, 9.8878, 9.8831, 9.878, 9.8723, 9.8662, 9.8595, 9.8524, 9.8449, 9.8368, 9.8284, 9.8194, 9.81, 9.8002,
         9.79, 9.7793, 9.7681, 9.7566, 9.7447, 9.7323, 9.7195, 9.7064, 9.6928, 9.6789, 9.6646, 9.6499, 9.6349, 9.6195,
         9.6037, 9.5876, 9.5712, 9.5544, 9.5373, 9.5199, 9.5021, 9.4841, 9.4657, 9.4471, 9.4281, 9.4089, 9.3894, 9.3696,
         9.3496, 9.3293, 9.3088, 9.288, 9.2669, 9.2457, 9.2242, 9.2025, 9.1805, 9.1584, 9.1361, 9.1135, 9.0908, 9.0679,
         9.0448, 9.0215, 8.998, 8.9743, 8.9505, 8.9265, 8.9024, 8.8781, 8.8537, 8.8292, 8.8045, 8.7797, 8.7548, 8.7298,
         8.7046, 8.6794, 8.654, 8.6286, 8.6031, 8.5775, 8.5518, 8.526, 8.5001, 8.4742, 8.4482, 8.4222, 8.3961, 8.3699,
         8.3437, 8.3174, 8.2911, 8.2648, 8.2384, 8.212, 8.1855, 8.1591, 8.1326, 8.106, 8.0795, 8.053, 8.0264, 7.9998,
         7.9733, 7.9467, 7.9201, 7.8936, 7.867, 7.8404, 7.8139, 7.7873, 7.7608, 7.7343, 7.7078, 7.6814, 7.6549, 7.6285,
         7.6021, 7.5757, 7.5494, 7.5231, 7.4969, 7.4706, 7.4445, 7.4183, 7.3922, 7.3661, 7.3401, 7.3142, 7.2882, 7.2624,
         7.2365, 7.2108, 7.1801, 7.1397, 7.0995, 7.0596, 7.0199, 6.9806, 6.9414, 6.9025, 6.8639, 6.8256, 6.7874, 6.7496,
         6.7118, 6.6735, 6.6354, 6.5977, 6.5934, 26.48, 26.307, 26.104, 25.903, 25.703, 25.538, 38.594, 38.564, 38.261,
         37.961, 37.663, 37.368, 37.075, 36.784, 36.495, 36.209, 35.926, 35.644, 35.365, 35.088, 34.814, 34.541, 34.271,
         34.003, 33.737, 33.473, 33.211, 32.952, 32.695, 32.439, 32.186, 31.935, 31.685, 31.438, 31.193, 30.95, 30.708,
         30.469, 30.232, 29.996, 29.762, 29.531, 29.301, 29.073, 28.847, 28.622, 28.4, 28.179, 27.96, 27.743, 27.527,
         27.313, 27.101, 26.891, 26.682, 26.475, 26.271, 26.11, 30.507, 30.484, 30.261, 30.016, 29.774, 29.534, 29.296,
         29.061, 28.827, 28.595, 28.365, 28.145, 27.938, 27.734, 27.532, 27.333, 27.137, 26.943, 26.909, 28.725, 28.615,
         28.403, 28.193, 27.986, 27.781, 27.579, 27.379, 27.181, 26.985, 26.792, 26.611, 26.433, 26.257, 26.084, 25.913,
         25.744, 25.577, 25.412, 25.249, 25.089, 24.93, 24.773, 24.704, 25.796, 25.794, 25.638, 25.482, 25.327, 25.174,
         25.022, 24.872, 24.724, 24.576, 24.43, 24.286, 24.144, 24.004, 23.864, 23.723, 23.578, 23.435, 23.292, 23.151,
         23.01, 22.871, 22.733, 22.596, 22.459, 22.324, 22.189, 22.056, 21.923, 21.791, 21.66, 21.529, 21.396, 21.263,
         21.131, 20.999, 20.869, 20.739, 20.61, 20.482, 20.354, 20.227, 20.101, 19.976, 19.851, 19.727, 19.604, 19.476,
         19.348, 19.221, 19.095, 18.969, 18.841, 18.713, 18.586, 18.459, 18.333, 18.208, 18.084, 17.96, 17.838, 17.716,
         17.595, 17.475, 17.355, 17.237, 17.119, 17.002, 16.886, 16.771, 16.654, 16.538, 16.423, 16.308, 16.194, 16.082,
         15.97, 15.858, 15.748, 15.639, 15.53, 15.422, 15.315, 15.209, 15.104, 15.0, 14.896, 14.794, 14.692, 14.591,
         14.49, 14.391, 14.292, 14.194, 14.097, 14.001, 13.905, 13.811, 13.717, 13.624, 13.531, 13.44, 13.347, 13.255,
         13.164, 13.073, 12.983, 12.894, 12.806, 12.718, 12.632, 12.545, 12.459, 12.36, 12.262, 12.165, 12.069, 11.973,
         11.877, 11.782, 11.687, 11.594, 11.501, 11.409, 11.318, 11.227, 11.138, 11.049, 10.961, 10.874, 10.788, 10.702,
         10.617, 10.533, 10.45, 10.367, 10.286, 10.205, 10.124, 10.045, 9.9655, 9.8865, 9.8083, 9.7308, 9.654, 9.5778,
         9.5024, 9.4276, 9.3534, 9.2799, 9.2071, 9.1349, 9.0634, 8.9925, 8.9222, 8.8525, 8.7834, 8.715, 8.6472, 8.5799,
         8.5132, 8.4472, 8.3817, 8.3167, 8.2524, 8.1886, 8.1254, 8.0627, 8.0005, 7.939, 7.736, 6.9839, 6.3137, 5.6849,
         5.1162, 4.6131, 4.1674, 3.756, 3.6557, 3.5699, 3.5469, 10.486, 10.155, 9.9509, 9.2642, 9.0154, 8.9518, 12.348,
         12.208, 12.005, 11.638, 11.318, 11.241, 12.884, 12.596, 12.569, 11.38, 10.264, 9.183, 8.2105, 7.3402, 6.5679,
         5.882, 5.2711, 4.7077, 4.2005, 3.7379, 3.3284, 2.9663, 2.646, 2.3624, 2.1111, 1.8879, 1.6898, 1.5024, 1.3321,
         1.1796, 1.0428, 0.91997, 0.81156, 0.71648, 0.63304, 0.60513, 0.58841, 0.58407, 3.3575, 3.2817, 3.27, 2.9424,
         2.6381, 2.3625, 2.1137, 1.8891, 1.6883, 1.5088, 1.3466, 1.1983, 1.0664, 0.9456, 0.83837, 0.74336, 0.65918,
         0.58459, 0.51848, 0.45988, 0.40794, 0.36189, 0.32107, 0.28487, 0.25307, 0.22533, 0.20065, 0.17868, 0.15913,
         0.14172, 0.12623, 0.11243, 0.10015, 0.089218, 0.079481, 0.07081]],
    'Eu':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.02083314, 0.02156, 0.02189, 0.021978, 0.02211, 0.02227063, 0.02244, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.031164, 0.031641, 0.0317682, 0.031959, 0.032436, 0.03323523, 0.03552846,
         0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028,
         0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751,
         0.10201505, 0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778,
         0.10669862, 0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201,
         0.11159722, 0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001,
         0.11672071, 0.11730431, 0.11789083, 0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206,
         0.12207942, 0.12268982, 0.12330327, 0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892,
         0.12768416, 0.12832258, 0.12896419, 0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181,
         0.13317243, 0.13322758, 0.13354621, 0.13421395, 0.13488502, 0.13555944, 0.13623724, 0.13691842, 0.13760302,
         0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305, 0.14249197, 0.14320443, 0.14392045,
         0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239, 0.14903386, 0.14977903, 0.15052792,
         0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875,
         0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685,
         0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268,
         0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862, 0.17834591, 0.17923764, 0.18013383,
         0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388,
         0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361,
         0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046,
         0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265,
         0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925,
         0.22658655, 0.22771948, 0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022,
         0.23698927, 0.23817422, 0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364,
         0.24786959, 0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25641678, 0.25667624,
         0.2567832, 0.25795962, 0.25924942, 0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477,
         0.2684604, 0.2698027, 0.27115171, 0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863,
         0.28078557, 0.2821895, 0.28360044, 0.28366578, 0.28413421, 0.28501845, 0.28644354, 0.28787576, 0.28931514,
         0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381, 0.29959433, 0.3010923, 0.30259776,
         0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873, 0.31178993, 0.31334888, 0.31491562, 0.3164902,
         0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438, 0.32773491, 0.32937358, 0.33102045,
         0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34449531, 0.34621779,
         0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.35978936, 0.36031129,
         0.36061062, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665, 0.37311293, 0.3749785,
         0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718, 0.38636941, 0.38830126, 0.39024276, 0.39219398,
         0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737, 0.40410785, 0.40612839, 0.40815904, 0.41019983,
         0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234,
         0.4311775, 0.43333339, 0.43550006, 0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947,
         0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309,
         0.47167755, 0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815,
         0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465,
         0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581,
         0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914,
         0.56444734, 0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432,
         0.59036144, 0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331,
         0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046,
         0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262,
         0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924,
         0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251,
         0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746,
         0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212,
         0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764,
         0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843,
         0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232,
         0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072,
         0.96729312, 0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688,
         1.0117021, 1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499,
         1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639,
         1.1178252, 1.1234143, 1.1290314, 1.1307711, 1.1310289, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408,
         1.1603841, 1.1608158, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1867702, 1.192704, 1.1986676, 1.2046609,
         1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555, 1.2474618, 1.2536991, 1.2599676, 1.2662674,
         1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245,
         1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577, 1.378315, 1.3852066, 1.3921326, 1.3990933,
         1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4706431,
         1.4779963, 1.4794437, 1.4817563, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176, 1.5228942, 1.5305086,
         1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779,
         1.6125491, 1.6152508, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6494027, 1.6576497, 1.665938, 1.6742677,
         1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278, 1.7337534, 1.7424222, 1.7511343, 1.7598899,
         1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.7973, 1.8027, 1.8043294, 1.813351, 1.8224178, 1.8315299,
         1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672, 1.896603, 1.906086, 1.9156165, 1.9251945,
         1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955, 2.0035635, 2.0135813, 2.0236492,
         2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.106026, 2.1165562, 2.1271389,
         2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211,
         2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664,
         2.3620177, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593,
         2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799,
         2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996,
         2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917,
         2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225,
         3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572,
         3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794,
         3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927,
         3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208,
         3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096,
         3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664,
         5.295467, 5.660855, 6.051453, 6.469004, 6.837362, 6.915365, 6.942016, 6.969923, 7.011785, 7.116438, 7.392525,
         7.464758, 7.579014, 7.609483, 7.655185, 7.769442, 7.89096, 7.902609, 8.01174, 8.043948, 8.09226, 8.21304,
         8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362,
         17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889,
         36.66551, 39.19543, 41.89992, 44.79101, 47.54862, 47.88159, 48.27641, 48.47048, 48.7616, 49.48938, 51.18542,
         54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353,
         113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548,
         237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [13.9833, 13.8468, 13.6829, 13.4837, 13.2373, 12.9256, 12.5184, 11.9616, 11.1444, 9.78838, 6.82187, 2.42628,
         -4.57615, -13.2262, -3.85948, 1.4657, 4.4272, 13.2311, 16.956, 18.8177, 19.7321, 20.1046, 20.1107, 20.1363,
         20.1315, 20.1522, 20.1771, 20.1866, 20.1102, 19.9568, 19.7831, 19.6243, 19.5039, 19.4397, 19.4498, 19.5454,
         19.6637, 19.7952, 19.9539, 20.1062, 20.2598, 20.4046, 20.526, 20.6028, 23.5129, 23.5122, 23.5108, 23.5088,
         23.506, 23.5024, 23.4981, 23.4929, 23.4868, 23.4797, 23.4717, 23.4626, 23.4524, 23.441, 23.4284, 23.4145,
         23.3992, 23.3824, 23.364, 23.3439, 23.3221, 23.2983, 23.2726, 23.2446, 23.2143, 23.1814, 23.1458, 23.1073,
         23.0656, 23.0205, 22.9716, 22.9187, 22.8613, 22.7989, 22.7312, 22.6575, 22.5772, 22.4895, 22.3935, 22.2882,
         22.1724, 22.0445, 21.9029, 21.7452, 21.5689, 21.3706, 21.1459, 20.8893, 20.5935, 20.2483, 19.8395, 19.3466,
         18.7376, 17.9602, 16.9196, 15.4187, 12.9303, 6.86825, -7.84966, -7.66782, 8.89574, 16.4402, 20.1017, 22.5011,
         24.2431, 25.5737, 26.6201, 27.4577, 28.1354, 28.6869, 29.1369, 29.5036, 29.8012, 30.0407, 30.2312, 30.3796,
         30.4919, 30.5726, 30.6253, 30.6528, 30.658, 30.6466, 30.6229, 30.5901, 30.5503, 30.5054, 30.4567, 30.4054,
         30.3522, 30.298, 30.2431, 30.1882, 30.1335, 30.0792, 30.0257, 29.9731, 29.9215, 29.8709, 29.8216, 29.7734,
         29.7265, 29.6809, 29.6365, 29.5934, 29.5516, 29.5109, 29.4715, 29.4332, 29.396, 29.36, 29.325, 29.2911,
         29.2582, 29.2262, 29.1951, 29.1649, 29.1355, 29.1069, 29.0792, 29.0521, 29.0257, 29.0, 28.9749, 28.9504,
         28.9265, 28.9031, 28.8802, 28.8578, 28.8358, 28.8142, 28.793, 28.7722, 28.7517, 28.7315, 28.7116, 28.6919,
         28.6725, 28.6533, 28.6343, 28.6155, 28.5968, 28.5782, 28.5598, 28.5414, 28.5231, 28.5048, 28.4866, 28.4684,
         28.4501, 28.4318, 28.4135, 28.3951, 28.3766, 28.358, 28.3392, 28.3203, 28.3011, 28.2818, 28.2622, 28.2424,
         28.2222, 28.2018, 28.181, 28.1597, 28.1381, 28.116, 28.0934, 28.0702, 28.0464, 28.0219, 27.9966, 27.9706,
         27.9436, 27.9155, 27.8864, 27.856, 27.8241, 27.7905, 27.7551, 27.7175, 27.6774, 27.6342, 27.5873, 27.5359,
         27.4788, 27.4142, 27.3394, 27.2499, 27.137, 26.9814, 26.7189, 26.0606, 25.7561, 26.0554, 26.7284, 26.9422,
         27.0641, 27.1475, 27.2093, 27.2573, 27.2956, 27.3266, 27.3518, 27.3722, 27.3884, 27.4006, 27.4091, 27.4137,
         27.4139, 27.4088, 27.3963, 27.3718, 27.3221, 27.1502, 27.1247, 27.1284, 27.3011, 27.3998, 27.4586, 27.5026,
         27.5387, 27.5699, 27.5977, 27.6229, 27.6463, 27.6681, 27.6886, 27.7082, 27.7269, 27.7448, 27.7622, 27.7789,
         27.7952, 27.8111, 27.8265, 27.8416, 27.8564, 27.8709, 27.8851, 27.899, 27.9127, 27.926, 27.9391, 27.9519,
         27.9643, 27.9764, 27.9881, 27.9994, 28.0101, 28.0203, 28.0298, 28.0384, 28.0461, 28.0526, 28.0576, 28.0607,
         28.0613, 28.0586, 28.0513, 28.0373, 28.0123, 27.9669, 27.8699, 27.6514, 27.4403, 27.6621, 27.9389, 28.0747,
         28.1662, 28.2393, 28.3024, 28.3592, 28.4118, 28.4614, 28.5087, 28.5544, 28.5987, 28.642, 28.6845, 28.7263,
         28.7677, 28.8086, 28.8493, 28.8897, 28.9299, 28.97, 28.9879, 29.0279, 29.0678, 29.1076, 29.1475, 29.1874,
         29.2274, 29.2674, 29.3075, 29.3476, 29.3878, 29.4281, 29.4684, 29.5088, 29.5493, 29.5899, 29.6306, 29.6714,
         29.7122, 29.7531, 29.7941, 29.8352, 29.8763, 29.9175, 29.9588, 30.0001, 30.0414, 30.0828, 30.1243, 30.1658,
         30.2073, 30.2488, 30.2903, 30.3318, 30.3733, 30.4149, 30.4564, 30.4978, 30.5393, 30.5806, 30.622, 30.6633,
         30.7045, 30.7456, 30.7866, 30.8276, 30.8684, 30.9092, 30.9498, 30.9902, 31.0306, 31.0708, 31.1108, 31.1507,
         31.1904, 31.2299, 31.2692, 31.3083, 31.3472, 31.3859, 31.4243, 31.4625, 31.5004, 31.538, 31.5753, 31.6122,
         31.6489, 31.6851, 31.721, 31.7565, 31.7915, 31.8262, 31.8604, 31.8941, 31.9274, 31.9602, 31.9926, 32.0244,
         32.0557, 32.0864, 32.1166, 32.1462, 32.1753, 32.2038, 32.2316, 32.2588, 32.2855, 32.3114, 32.3367, 32.3613,
         32.3853, 32.4085, 32.4311, 32.4529, 32.474, 32.4943, 32.5138, 32.5326, 32.5506, 32.5678, 32.5841, 32.5997,
         32.6143, 32.6281, 32.6411, 32.6531, 32.6643, 32.6745, 32.6837, 32.692, 32.6994, 32.7057, 32.7111, 32.7154,
         32.7187, 32.7209, 32.7221, 32.7221, 32.7211, 32.7189, 32.7155, 32.711, 32.7052, 32.6983, 32.6901, 32.6806,
         32.6698, 32.6577, 32.6442, 32.6294, 32.6132, 32.5955, 32.5805, 32.5599, 32.5378, 32.5141, 32.4887, 32.4618,
         32.4331, 32.4028, 32.3706, 32.3367, 32.3009, 32.2632, 32.2235, 32.1818, 32.138, 32.0922, 32.0441, 31.9938,
         31.9411, 31.8861, 31.8295, 31.7695, 31.7068, 31.6414, 31.5732, 31.5021, 31.428, 31.3507, 31.2703, 31.1864,
         31.0991, 31.0082, 30.9135, 30.815, 30.7123, 30.6054, 30.4941, 30.3783, 30.2576, 30.132, 30.0011, 29.8649,
         29.7231, 29.5754, 29.4218, 29.262, 29.0959, 28.9235, 28.745, 28.5607, 28.3715, 28.179, 27.9686, 27.7137,
         27.4438, 27.1576, 26.8535, 26.5299, 26.1848, 25.8156, 25.4197, 24.994, 24.5345, 24.0367, 23.4948, 22.9019,
         22.249, 21.5245, 20.7134, 19.7944, 18.7378, 17.4994, 16.0081, 14.1386, 11.6332, 7.79666, -1.32844, -18.3139,
         -18.6591, 2.34454, 7.40466, 9.28125, 9.48813, 6.90042, -3.30656, -3.40633, 7.75267, 13.768, 17.0308, 19.4196,
         21.3458, 22.9755, 24.395, 25.6554, 26.7903, 27.823, 28.7702, 29.6448, 30.4566, 31.2134, 31.9215, 32.5862,
         33.2116, 33.8014, 34.3586, 34.8859, 35.3854, 35.8591, 36.3087, 36.7356, 37.1411, 37.5262, 37.8918, 38.2389,
         38.5679, 38.8795, 39.174, 39.4517, 39.7127, 39.9571, 40.1847, 40.3952, 40.5878, 40.7619, 40.9159, 41.0482,
         41.156, 41.2357, 41.2815, 41.2848, 41.2313, 41.0948, 40.8209, 40.26, 38.5729, 37.4597, 37.4574, 39.6033,
         41.1518, 42.0233, 42.6591, 43.1692, 43.5979, 43.9672, 44.2891, 44.5699, 44.812, 45.021, 45.2033, 45.3541,
         45.4652, 45.5195, 45.4731, 45.1426, 44.4561, 44.5036, 45.0086, 46.0143, 46.5443, 46.9454, 47.2812, 47.5756,
         47.8398, 48.0804, 48.3007, 48.5027, 48.6883, 48.8632, 49.0275, 49.1808, 49.3227, 49.4521, 49.5674, 49.6653,
         49.74, 49.7791, 49.7502, 49.5046, 49.3344, 49.4181, 49.6237, 50.1984, 50.5401, 50.8117, 51.0477, 51.2615,
         51.4599, 51.6467, 51.8243, 51.9943, 52.158, 52.3172, 52.4725, 52.6247, 52.7725, 52.9156, 53.0545, 53.1896,
         53.3213, 53.4498, 53.5754, 53.6983, 53.8186, 53.9365, 54.0521, 54.1657, 54.2773, 54.387, 54.4951, 54.6017,
         54.707, 54.8106, 54.9118, 55.011, 55.1081, 55.2033, 55.2968, 55.3885, 55.4787, 55.5672, 55.6543, 55.74,
         55.8243, 55.9072, 55.989, 56.0695, 56.369, 56.447, 56.5233, 56.5981, 56.6713, 56.8928, 56.9633, 57.0319,
         57.0988, 57.1639, 57.2274, 57.2893, 57.3497, 57.4087, 57.4662, 57.5225, 57.5774, 57.6311, 57.6835, 57.7348,
         57.7851, 57.8341, 57.882, 57.9287, 57.9743, 58.0188, 58.0623, 58.1048, 58.1463, 58.1869, 58.2266, 58.2654,
         58.3033, 58.3405, 58.3768, 58.4125, 58.4474, 58.4816, 58.5153, 58.5483, 58.5807, 58.6127, 58.6441, 58.6752,
         58.7058, 58.7361, 58.7662, 58.796, 58.8257, 58.8553, 58.885, 58.9148, 58.945, 58.9756, 59.1179, 59.1515,
         59.188, 59.2104, 59.2313, 59.2511, 59.2696, 59.287, 59.3033, 59.3186, 59.3329, 59.3464, 59.3589, 59.3707,
         59.3816, 59.3918, 59.4012, 59.4577, 59.4661, 59.4737, 59.4804, 59.4863, 59.4915, 59.4959, 59.4997, 59.5027,
         59.5051, 59.5069, 59.5081, 59.5087, 59.5087, 59.5082, 59.5071, 59.5055, 59.5034, 59.5008, 59.4978, 59.4942,
         59.4903, 59.5065, 59.5018, 59.4966, 59.4909, 59.4847, 59.4781, 59.471, 59.4634, 59.4555, 59.4471, 59.4383,
         59.4291, 59.4195, 59.4095, 59.3991, 59.3884, 59.3773, 59.3658, 59.3539, 59.3417, 59.3292, 59.6358, 59.3705,
         59.0558, 58.6852, 58.2226, 57.6151, 56.7667, 55.3693, 52.4608, 50.6522, 49.4006, 45.8346, 49.3893, 52.4556,
         54.1115, 54.0325, 52.9494, 51.2685, 53.1756, 54.9778, 55.6937, 55.7303, 55.6299, 54.8926, 55.9907, 57.2565,
         58.5224, 60.3515, 61.4328, 62.1312, 62.597, 62.9021, 63.1004, 63.2258, 63.3696, 63.4331, 63.4567, 63.4161,
         63.3537, 63.2776, 63.1925, 63.1018, 63.0078, 62.9135, 62.8223, 62.7126, 62.5915, 62.4558, 62.2983, 62.1028,
         61.837, 61.399, 60.328, 59.9783, 59.1554, 57.7507, 59.1703, 60.4533, 61.4212, 62.222, 62.6336, 62.8888,
         63.0578, 63.1711, 63.2479, 63.3021, 63.3337, 63.3506, 63.3867, 63.3832, 63.3731, 63.3589, 63.342, 63.3234,
         63.304, 63.2843, 63.2647, 63.2454, 63.2268, 63.2088, 63.1916, 63.1759, 63.1612, 63.1477, 63.1351, 63.1234,
         63.1127, 63.1028, 63.0936, 63.0852, 63.0775],
        [0.25065, 0.28095, 0.31548, 0.35479, 0.3995, 0.45032, 0.50798, 0.5733, 0.64715, 0.73045, 0.82418, 0.87675,
         0.90104, 0.90756, 18.081, 17.741, 17.394, 14.94, 12.596, 10.552, 8.8615, 7.5261, 7.4848, 7.23, 7.1655, 7.0947,
         6.8729, 6.5399, 5.81, 5.3111, 5.0003, 4.8414, 4.8054, 4.8696, 5.0163, 5.1276, 5.1817, 5.2494, 5.3225, 5.3942,
         5.459, 5.5126, 5.5518, 5.5743, 5.5787, 5.579, 5.5791, 5.5791, 5.579, 5.5788, 5.5785, 5.578, 5.5775, 5.5769,
         5.5761, 5.5752, 5.5742, 5.5731, 5.5719, 5.5706, 5.5691, 5.5676, 5.5659, 5.5641, 5.5622, 5.5602, 5.5581, 5.5558,
         5.5535, 5.551, 5.5484, 5.5457, 5.5429, 5.54, 5.5369, 5.5337, 5.5305, 5.5271, 5.5236, 5.5199, 5.5162, 5.5123,
         5.5084, 5.5043, 5.5001, 5.4958, 5.4914, 5.4868, 5.4822, 5.4774, 5.4725, 5.4675, 5.4624, 5.4572, 5.4519, 5.4465,
         5.4409, 5.4353, 5.4295, 5.4236, 5.4176, 5.4115, 5.4088, 25.088, 24.497, 23.32, 22.214, 21.176, 20.201, 19.285,
         18.425, 17.617, 16.858, 16.146, 15.476, 14.847, 14.256, 13.7, 13.178, 12.688, 12.227, 11.793, 11.386, 11.003,
         10.65, 10.325, 10.027, 9.7515, 9.4978, 9.2634, 9.0465, 8.8455, 8.659, 8.4858, 8.3245, 8.1743, 8.0342, 7.9033,
         7.7808, 7.6661, 7.5585, 7.4575, 7.3626, 7.2732, 7.189, 7.1095, 7.0345, 6.9636, 6.8964, 6.8328, 6.7724, 6.7151,
         6.6606, 6.6087, 6.5594, 6.5123, 6.4674, 6.4245, 6.3835, 6.3443, 6.3068, 6.2709, 6.2364, 6.2033, 6.1716, 6.1411,
         6.1118, 6.0836, 6.0564, 6.0303, 6.0051, 5.9808, 5.9574, 5.9349, 5.9131, 5.8921, 5.8718, 5.8522, 5.8332, 5.8149,
         5.7972, 5.7801, 5.7636, 5.7477, 5.7322, 5.7173, 5.7029, 5.689, 5.6756, 5.6626, 5.6501, 5.638, 5.6264, 5.6152,
         5.6044, 5.594, 5.584, 5.5744, 5.5651, 5.5563, 5.5478, 5.5397, 5.532, 5.5246, 5.5176, 5.511, 5.5047, 5.4987,
         5.4931, 5.4879, 5.483, 5.4784, 5.4741, 5.4703, 5.4667, 5.4635, 5.4606, 5.458, 5.4558, 5.4539, 5.4523, 5.4511,
         5.4502, 5.4497, 5.4494, 5.4495, 5.4499, 5.4507, 5.4518, 5.4532, 5.4549, 5.457, 5.4594, 5.4621, 5.4652, 5.4679,
         6.5471, 6.5477, 6.5549, 6.5631, 6.5716, 6.5805, 6.5897, 6.5992, 6.6091, 6.6193, 6.6299, 6.6408, 6.652, 6.6636,
         6.6755, 6.6877, 6.7003, 6.7132, 6.7264, 6.7399, 6.7538, 6.768, 6.7686, 7.1061, 7.1162, 7.1326, 7.1492, 7.1662,
         7.1834, 7.2009, 7.2187, 7.2368, 7.2551, 7.2737, 7.2925, 7.3116, 7.3309, 7.3505, 7.3703, 7.3903, 7.4106, 7.4311,
         7.4518, 7.4728, 7.4939, 7.5152, 7.5367, 7.5584, 7.5803, 7.6024, 7.6246, 7.647, 7.6695, 7.6922, 7.715, 7.7379,
         7.7609, 7.7841, 7.8074, 7.8307, 7.8542, 7.8777, 7.9014, 7.925, 7.9488, 7.9726, 7.9964, 8.0202, 8.0441, 8.068,
         8.0919, 8.1089, 8.6402, 8.6444, 8.6652, 8.6902, 8.7151, 8.7401, 8.765, 8.7898, 8.8146, 8.8393, 8.8639, 8.8884,
         8.9128, 8.9371, 8.9614, 8.9854, 9.0094, 9.0332, 9.0569, 9.0804, 9.1037, 9.1269, 9.1498, 9.1725, 9.195, 9.2173,
         9.2394, 9.2612, 9.2827, 9.3039, 9.3248, 9.3455, 9.3659, 9.3859, 9.4057, 9.4251, 9.4443, 9.4631, 9.4816, 9.4998,
         9.5176, 9.5351, 9.5522, 9.569, 9.5854, 9.6015, 9.6172, 9.6325, 9.6474, 9.6619, 9.676, 9.6898, 9.7031, 9.716,
         9.7285, 9.7406, 9.7523, 9.7636, 9.7744, 9.7849, 9.7949, 9.8044, 9.8135, 9.8222, 9.8305, 9.8383, 9.8457, 9.8526,
         9.8591, 9.8651, 9.8707, 9.8758, 9.8805, 9.8847, 9.8885, 9.8919, 9.8948, 9.8972, 9.8992, 9.9007, 9.9018, 9.9023,
         9.9023, 9.9018, 9.9007, 9.8991, 9.897, 9.8944, 9.8912, 9.8876, 9.8834, 9.8787, 9.8736, 9.8679, 9.8618, 9.8552,
         9.8481, 9.8405, 9.8325, 9.8241, 9.8151, 9.8058, 9.796, 9.7857, 9.775, 9.7639, 9.7523, 9.7404, 9.728, 9.7153,
         9.7021, 9.6886, 9.6747, 9.6605, 9.6459, 9.6309, 9.6156, 9.5999, 9.5839, 9.5676, 9.551, 9.534, 9.5168, 9.4992,
         9.4813, 9.4632, 9.4448, 9.4261, 9.4071, 9.3879, 9.3684, 9.3486, 9.3286, 9.3084, 9.2879, 9.2673, 9.2464, 9.2252,
         9.2039, 9.1824, 9.1607, 9.1388, 9.1167, 9.0944, 9.0719, 9.0493, 9.0265, 9.0036, 8.9805, 8.9572, 8.9338, 8.9103,
         8.8867, 8.8629, 8.839, 8.815, 8.7908, 8.7666, 8.7422, 8.7178, 8.6932, 8.6686, 8.6439, 8.6191, 8.5942, 8.5692,
         8.5442, 8.5191, 8.494, 8.4687, 8.4435, 8.4182, 8.3928, 8.3674, 8.3419, 8.3164, 8.2909, 8.2653, 8.2398, 8.2141,
         8.1885, 8.1629, 8.1372, 8.1115, 8.0858, 8.0601, 8.0344, 8.0087, 7.983, 7.9573, 7.9316, 7.9059, 7.8802, 7.8545,
         7.8289, 7.8032, 7.7776, 7.752, 7.7264, 7.7009, 7.6753, 7.6498, 7.6243, 7.5989, 7.5735, 7.5481, 7.518, 7.4786,
         7.4394, 7.4004, 7.3617, 7.323, 7.2827, 7.2427, 7.2029, 7.1633, 7.1241, 7.085, 7.0462, 7.0077, 6.9694, 6.9313,
         6.8935, 6.8559, 6.8185, 6.7814, 6.7445, 6.7078, 6.6714, 6.6352, 6.5992, 6.5881, 26.407, 26.277, 26.075, 25.875,
         25.677, 25.48, 25.383, 38.394, 38.263, 37.964, 37.667, 37.373, 37.08, 36.791, 36.503, 36.218, 35.935, 35.655,
         35.376, 35.1, 34.827, 34.555, 34.286, 34.018, 33.753, 33.49, 33.229, 32.97, 32.714, 32.459, 32.207, 31.956,
         31.707, 31.461, 31.216, 30.973, 30.732, 30.492, 30.255, 30.02, 29.786, 29.554, 29.324, 29.097, 28.87, 28.646,
         28.424, 28.203, 27.984, 27.767, 27.551, 27.338, 27.125, 26.915, 26.706, 26.499, 26.295, 26.255, 30.678, 30.555,
         30.306, 30.059, 29.814, 29.571, 29.331, 29.093, 28.856, 28.622, 28.39, 28.179, 27.971, 27.766, 27.564, 27.364,
         27.167, 26.972, 26.881, 28.687, 28.646, 28.434, 28.225, 28.018, 27.814, 27.612, 27.412, 27.215, 27.019, 26.826,
         26.642, 26.464, 26.288, 26.114, 25.942, 25.773, 25.605, 25.44, 25.277, 25.116, 24.956, 24.799, 24.765, 25.851,
         25.822, 25.664, 25.507, 25.351, 25.197, 25.045, 24.894, 24.744, 24.596, 24.449, 24.305, 24.162, 24.02, 23.88,
         23.733, 23.587, 23.442, 23.299, 23.156, 23.015, 22.875, 22.735, 22.597, 22.459, 22.323, 22.187, 22.052, 21.918,
         21.785, 21.653, 21.521, 21.388, 21.254, 21.122, 20.99, 20.858, 20.728, 20.598, 20.469, 20.341, 20.213, 20.086,
         19.96, 19.835, 19.711, 19.587, 19.46, 19.332, 19.205, 19.079, 18.953, 18.827, 18.7, 18.573, 18.446, 18.32,
         18.196, 18.072, 17.948, 17.826, 17.705, 17.584, 17.464, 17.345, 17.227, 17.11, 16.992, 16.874, 16.756, 16.639,
         16.524, 16.409, 16.295, 16.182, 16.069, 15.958, 15.847, 15.737, 15.629, 15.521, 15.413, 15.307, 15.202, 15.097,
         14.993, 14.89, 14.788, 14.687, 14.587, 14.487, 14.388, 14.29, 14.193, 14.097, 14.001, 13.906, 13.812, 13.719,
         13.626, 13.535, 13.443, 13.351, 13.258, 13.153, 13.048, 12.944, 12.841, 12.739, 12.638, 12.538, 12.439, 12.341,
         12.243, 12.147, 12.051, 11.957, 11.863, 11.769, 11.675, 11.582, 11.489, 11.398, 11.307, 11.217, 11.128, 11.04,
         10.952, 10.866, 10.78, 10.695, 10.61, 10.527, 10.444, 10.362, 10.28, 10.2, 10.12, 10.04, 9.9618, 9.8836,
         9.8057, 9.7285, 9.652, 9.5761, 9.501, 9.4264, 9.3526, 9.2794, 9.2068, 9.1349, 9.0636, 8.9929, 8.9229, 8.8535,
         8.7847, 8.7165, 8.6488, 8.5818, 8.5154, 8.4495, 8.2325, 7.4286, 6.7125, 6.0676, 5.4616, 4.9205, 4.4412, 4.0134,
         3.6797, 3.6152, 3.5936, 3.5713, 10.485, 10.149, 9.3669, 9.2026, 8.958, 8.8957, 12.274, 11.938, 11.599, 11.568,
         11.284, 11.207, 12.844, 12.562, 12.052, 10.886, 9.7453, 8.722, 7.7991, 6.9771, 6.2471, 5.5984, 5.0106, 4.4768,
         3.9915, 3.5544, 3.168, 2.8261, 2.5233, 2.255, 2.0169, 1.8054, 1.6051, 1.4248, 1.2627, 1.1186, 0.9879, 0.87194,
         0.76975, 0.68007, 0.60908, 0.60131, 0.5923, 0.58795, 3.347, 3.271, 3.1039, 2.7859, 2.4966, 2.236, 1.9997,
         1.7878, 1.5984, 1.4271, 1.2703, 1.1309, 1.0053, 0.89153, 0.79073, 0.70139, 0.6222, 0.55201, 0.48977, 0.43458,
         0.38565, 0.34225, 0.30375, 0.26961, 0.24007, 0.21392, 0.19064, 0.1699, 0.15143, 0.13497, 0.12031, 0.10724,
         0.095604, 0.085233, 0.07599]],
    'Gd':                                                                                                         [
        [0.00835371, 0.008481573, 0.00851567, 0.008566815, 0.008694678, 0.009093814, 0.009233005, 0.009270123,
         0.009325799, 0.00946499, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306,
         0.01705382, 0.01823053, 0.01948844, 0.019894, 0.0201985, 0.0202797, 0.0204015, 0.020706, 0.02083314,
         0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.035378, 0.03552846,
         0.0359195, 0.0360639, 0.0362805, 0.036822, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809,
         0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995,
         0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294, 0.1040707,
         0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712, 0.10884865,
         0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956, 0.11384596,
         0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029, 0.11907269,
         0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979, 0.12453939,
         0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902, 0.13025706,
         0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944, 0.13623724,
         0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14046403, 0.14053596, 0.14107766,
         0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462,
         0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894,
         0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427,
         0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489,
         0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574,
         0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244,
         0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131,
         0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946,
         0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475,
         0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588,
         0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948, 0.22885808, 0.23000237, 0.23115238,
         0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422, 0.23936509, 0.24056191, 0.24176472,
         0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893, 0.25035448, 0.25160625, 0.25286428,
         0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567, 0.2618484, 0.26315764, 0.26447343,
         0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27068519, 0.27111483, 0.27115171, 0.27250747, 0.27387001,
         0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845, 0.28644354,
         0.28787576, 0.28823661, 0.28876341, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071,
         0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873,
         0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197,
         0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913,
         0.34107602, 0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022,
         0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665,
         0.37311293, 0.3749785, 0.37534905, 0.37625097, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718,
         0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737,
         0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789,
         0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756, 0.43986595,
         0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045,
         0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815, 0.48118209,
         0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344,
         0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901,
         0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538,
         0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56726958, 0.57010592, 0.57295645, 0.57582123,
         0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325, 0.59627982, 0.59926122, 0.60225752,
         0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751,
         0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693,
         0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406,
         0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985,
         0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805,
         0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536,
         0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015,
         0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944,
         0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545,
         0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934,
         0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959, 0.97699023, 0.98187519, 0.98678456,
         0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489,
         1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939,
         1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143, 1.1290314, 1.1346765, 1.1403499, 1.1460517,
         1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1850578, 1.1853422, 1.1867702, 1.192704,
         1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.216959, 1.217441, 1.2228213, 1.2289354, 1.2350801, 1.2412555,
         1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335,
         1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577,
         1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942,
         1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176,
         1.5228942, 1.5305086, 1.5381612, 1.5427108, 1.5452893, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5770017,
         1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6494027, 1.6576497,
         1.665938, 1.6742677, 1.682639, 1.6868076, 1.6897925, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278,
         1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.813351,
         1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8778472, 1.8837529, 1.8871672,
         1.896603, 1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772,
         1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227,
         2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561,
         2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3038428,
         2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616,
         2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057,
         2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832,
         2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518,
         2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506,
         2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387,
         3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587,
         3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058,
         3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957,
         3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654,
         3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739,
         4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.097944, 7.206586,
         7.235557, 7.279014, 7.392525, 7.771694, 7.890649, 7.902609, 7.92237, 7.969952, 8.088906, 8.208088, 8.333722,
         8.367224, 8.417478, 8.44789, 8.543112, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697,
         14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676,
         30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 49.23432, 49.98791, 50.18886,
         50.4903, 51.18542, 51.24388, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069,
         93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539,
         194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588,
         405.0001, 432.9451],
        [13.2097, 13.1819, 13.1665, 13.1686, 13.1559, 13.0748, 13.0083, 12.9446, 12.9986, 13.0338, 12.9235, 12.7999,
         12.6419, 12.4423, 12.1876, 11.8541, 11.3991, 10.7332, 9.62346, 7.04472, 4.95758, 0.508358, -4.87034, 0.785012,
         5.76199, 6.77123, 11.7709, 14.0334, 15.3779, 16.1513, 16.4765, 16.6427, 16.645, 16.5486, 16.5385, 16.5057,
         16.4811, 16.4852, 16.4682, 16.4096, 16.2666, 16.1333, 16.0235, 15.9462, 15.9079, 15.9114, 15.9574, 16.0625,
         16.1889, 16.3506, 16.5431, 16.7603, 16.9955, 17.2392, 20.0918, 20.1097, 20.1276, 20.1454, 20.1631, 20.1807,
         20.1981, 20.2154, 20.2325, 20.2494, 20.2662, 20.2827, 20.2991, 20.3151, 20.331, 20.3465, 20.3624, 20.3773,
         20.3919, 20.4062, 20.42, 20.4334, 20.4464, 20.4589, 20.4708, 20.4822, 20.493, 20.5032, 20.5126, 20.5214,
         20.5293, 20.5363, 20.5425, 20.5476, 20.5516, 20.5545, 20.5561, 20.5563, 20.5551, 20.5521, 20.5474, 20.5408,
         20.532, 20.5209, 20.5071, 20.4905, 20.4707, 20.4473, 20.42, 20.3882, 20.3513, 20.3087, 20.2596, 20.2028,
         20.1373, 20.0615, 19.9734, 19.8708, 19.7505, 19.6081, 19.4381, 19.2323, 18.9787, 18.6585, 18.2403, 17.6653,
         16.8045, 15.2719, 9.93257, 6.19564, 6.28437, 15.2536, 18.0396, 19.6242, 20.734, 21.5809, 22.258, 22.8151,
         23.2827, 23.6805, 24.0225, 24.3187, 24.5768, 24.8027, 25.001, 25.1754, 25.329, 25.4641, 25.5827, 25.6862,
         25.7757, 25.8529, 25.9207, 25.9812, 26.0358, 26.0858, 26.1321, 26.1755, 26.2165, 26.2555, 26.2929, 26.3291,
         26.3644, 26.3991, 26.4335, 26.4677, 26.502, 26.5364, 26.5712, 26.6064, 26.6421, 26.6785, 26.7156, 26.7535,
         26.7928, 26.832, 26.8704, 26.908, 26.9451, 26.9814, 27.0172, 27.0524, 27.087, 27.1211, 27.1546, 27.1877,
         27.2202, 27.2522, 27.2838, 27.3149, 27.3455, 27.3757, 27.4054, 27.4346, 27.4634, 27.4917, 27.5195, 27.5469,
         27.5739, 27.6004, 27.6264, 27.652, 27.6771, 27.7018, 27.7259, 27.7497, 27.7729, 27.7956, 27.8179, 27.8397,
         27.861, 27.8817, 27.902, 27.9218, 27.941, 27.9597, 27.9779, 27.9956, 28.0127, 28.0293, 28.0452, 28.0606,
         28.0755, 28.0897, 28.1033, 28.1163, 28.1286, 28.1403, 28.1513, 28.1617, 28.1713, 28.1802, 28.1883, 28.1956,
         28.2021, 28.2078, 28.2126, 28.2164, 28.2193, 28.2211, 28.2218, 28.2214, 28.2197, 28.2166, 28.2122, 28.2061,
         28.1983, 28.1886, 28.1768, 28.1626, 28.1457, 28.1256, 28.1019, 28.0738, 28.0404, 28.0004, 27.9517, 27.8913,
         27.814, 27.7097, 27.555, 27.2664, 26.6714, 26.6713, 26.7292, 27.4074, 27.6326, 27.7715, 27.8715, 27.9486,
         28.0099, 28.0589, 28.0969, 28.1236, 28.136, 28.1244, 28.0362, 27.9515, 27.9661, 28.1056, 28.2566, 28.3485,
         28.4209, 28.483, 28.5386, 28.5897, 28.6373, 28.6822, 28.7248, 28.7656, 28.8048, 28.8426, 28.8792, 28.9148,
         28.9493, 28.9831, 29.016, 29.0483, 29.0799, 29.1109, 29.1413, 29.1712, 29.2006, 29.2296, 29.258, 29.2861,
         29.3137, 29.3409, 29.3676, 29.394, 29.4199, 29.4453, 29.4703, 29.4948, 29.5187, 29.5421, 29.5648, 29.5869,
         29.6081, 29.6284, 29.6477, 29.6656, 29.6821, 29.6967, 29.7089, 29.7182, 29.7233, 29.7226, 29.7132, 29.6888,
         29.6331, 29.4654, 29.3702, 29.386, 29.5405, 29.7481, 29.8664, 29.957, 30.0339, 30.1027, 30.1662, 30.2258,
         30.2827, 30.3374, 30.3904, 30.4421, 30.4928, 30.5425, 30.5915, 30.6399, 30.6877, 30.7352, 30.7822, 30.8289,
         30.8754, 30.9217, 30.9677, 31.0021, 31.0478, 31.0934, 31.1389, 31.1842, 31.2295, 31.2747, 31.3198, 31.3649,
         31.4099, 31.4548, 31.4997, 31.5445, 31.5892, 31.6339, 31.6786, 31.7232, 31.7678, 31.8123, 31.8567, 31.9011,
         31.9454, 31.9897, 32.0339, 32.078, 32.122, 32.166, 32.2098, 32.2536, 32.2973, 32.3408, 32.3843, 32.4276,
         32.4708, 32.5139, 32.5568, 32.5996, 32.6423, 32.6848, 32.7271, 32.7693, 32.8112, 32.853, 32.8946, 32.936,
         32.9772, 33.0182, 33.059, 33.0995, 33.1398, 33.1798, 33.2196, 33.2592, 33.2984, 33.3374, 33.3761, 33.4146,
         33.4527, 33.4905, 33.528, 33.5652, 33.602, 33.6385, 33.6746, 33.7102, 33.7455, 33.7803, 33.8147, 33.8487,
         33.8822, 33.9152, 33.9477, 33.9797, 34.0112, 34.0421, 34.0726, 34.1024, 34.1317, 34.1604, 34.1886, 34.2161,
         34.243, 34.2693, 34.295, 34.32, 34.3443, 34.368, 34.391, 34.4133, 34.4349, 34.4558, 34.476, 34.4954, 34.5141,
         34.532, 34.5491, 34.5655, 34.581, 34.5957, 34.6097, 34.6227, 34.6349, 34.6463, 34.6568, 34.6664, 34.6751,
         34.6828, 34.6897, 34.6956, 34.7005, 34.7045, 34.7074, 34.7094, 34.7103, 34.7102, 34.7091, 34.7069, 34.7035,
         34.6991, 34.6935, 34.6868, 34.6789, 34.6699, 34.6596, 34.648, 34.6353, 34.6212, 34.6058, 34.5891, 34.571,
         34.5516, 34.5307, 34.5113, 34.4875, 34.4622, 34.4354, 34.407, 34.377, 34.3453, 34.312, 34.2769, 34.24, 34.2013,
         34.1607, 34.119, 34.0745, 34.0281, 33.9795, 33.9288, 33.876, 33.8208, 33.7633, 33.7035, 33.6411, 33.5762,
         33.5087, 33.4385, 33.3655, 33.2895, 33.2106, 33.1286, 33.0435, 32.955, 32.8631, 32.7677, 32.6686, 32.5658,
         32.4592, 32.3485, 32.2338, 32.1148, 31.9916, 31.864, 31.7259, 31.5686, 31.4033, 31.2296, 31.0473, 30.8556,
         30.6542, 30.4423, 30.2191, 29.9839, 29.7357, 29.4734, 29.1958, 28.9016, 28.5893, 28.2568, 27.9023, 27.5231,
         27.1163, 26.6784, 26.2054, 25.6921, 25.1323, 24.5182, 23.8396, 23.0837, 22.2325, 21.2613, 20.1339, 18.7939,
         17.1463, 15.0091, 11.9519, 6.37618, -14.7683, -15.1056, -0.517733, 8.46718, 11.1758, 12.0958, 11.351, 2.2836,
         -0.280404, -0.374992, 13.4452, 17.5253, 20.1965, 22.2583, 23.9629, 25.4265, 26.7135, 27.8643, 28.9059, 29.8574,
         30.7332, 31.5438, 32.298, 33.0023, 33.6624, 34.2827, 34.8671, 35.4186, 35.9401, 36.4337, 36.9016, 37.3453,
         37.7665, 38.1662, 38.5457, 38.9058, 39.2473, 39.5709, 39.8771, 40.1663, 40.4386, 40.6942, 40.9331, 41.1549,
         41.3593, 41.5454, 41.7121, 41.858, 41.9806, 42.0769, 42.1419, 42.1684, 42.1448, 42.0507, 41.8463, 41.4359,
         40.4625, 38.4229, 38.4315, 38.975, 41.5876, 42.6547, 43.383, 43.9517, 44.4237, 44.8279, 45.1798, 45.488,
         45.7569, 45.9888, 46.1953, 46.3751, 46.5238, 46.6335, 46.6876, 46.6433, 46.3288, 45.6433, 45.6961, 46.0974,
         47.1547, 47.6933, 48.0981, 48.4359, 48.7315, 48.9965, 49.2374, 49.458, 49.6599, 49.845, 50.0193, 50.183,
         50.3355, 50.4763, 50.6043, 50.7176, 50.8127, 50.8829, 50.9135, 50.864, 50.4941, 50.4867, 50.5743, 50.9179,
         51.4087, 51.7311, 51.9939, 52.2248, 52.4354, 52.6314, 52.8165, 52.9929, 53.1619, 53.3252, 53.4841, 53.6394,
         53.7909, 53.9373, 54.0792, 54.217, 54.3512, 54.4819, 54.6095, 54.7342, 54.8562, 54.9756, 55.0926, 55.2073,
         55.3199, 55.4305, 55.5393, 55.6464, 55.7519, 55.856, 55.9585, 56.0586, 56.1566, 56.2525, 56.3466, 56.4389,
         56.5294, 56.6183, 56.7056, 56.7914, 56.8757, 56.9586, 57.0402, 57.1205, 57.1996, 57.4955, 57.5721, 57.6471,
         57.7206, 57.7926, 57.8632, 58.0807, 58.1483, 58.2142, 58.2783, 58.3409, 58.402, 58.4617, 58.5199, 58.5768,
         58.6324, 58.6868, 58.74, 58.792, 58.8429, 58.8927, 58.9415, 58.9893, 59.036, 59.0817, 59.1263, 59.17, 59.2127,
         59.2546, 59.2955, 59.3356, 59.375, 59.4135, 59.4514, 59.4885, 59.525, 59.561, 59.5963, 59.6312, 59.6655,
         59.6995, 59.7331, 59.7664, 59.7994, 59.8323, 59.8651, 59.898, 59.9312, 59.9661, 59.9971, 60.0255, 60.0522,
         60.0773, 60.2037, 60.2269, 60.2486, 60.269, 60.2883, 60.3063, 60.3233, 60.3392, 60.3542, 60.3682, 60.3813,
         60.3936, 60.4051, 60.4158, 60.4257, 60.435, 60.4435, 60.4514, 60.5064, 60.5134, 60.5195, 60.5249, 60.5295,
         60.5334, 60.5367, 60.5393, 60.5412, 60.5426, 60.5434, 60.5436, 60.5432, 60.5423, 60.5409, 60.5389, 60.5365,
         60.5336, 60.5303, 60.5265, 60.5222, 60.5175, 60.5343, 60.529, 60.5231, 60.5168, 60.51, 60.5027, 60.495,
         60.4869, 60.4784, 60.4695, 60.4602, 60.4504, 60.7797, 60.5462, 60.2633, 59.9288, 59.5306, 59.0193, 58.3326,
         57.3192, 55.3684, 53.5634, 50.5305, 46.9937, 50.5208, 53.6385, 55.2011, 54.1336, 53.7852, 52.5006, 54.3302,
         56.0583, 56.717, 56.6681, 55.9394, 57.0383, 57.4719, 58.3113, 60.4779, 61.8945, 62.775, 63.3568, 63.7404,
         63.9922, 64.1543, 64.2554, 64.3753, 64.4222, 64.4323, 64.3823, 64.3148, 64.2361, 64.1503, 64.0603, 63.9699,
         63.8844, 63.778, 63.6621, 63.5343, 63.39, 63.2174, 62.9955, 62.6711, 62.0283, 61.3442, 60.1781, 58.7811,
         60.1934, 61.4133, 61.4695, 62.8932, 63.4489, 63.7699, 63.9778, 64.1165, 64.2109, 64.2766, 64.3175, 64.3408,
         64.3522, 64.3832, 64.3762, 64.364, 64.3484, 64.3308, 64.3119, 64.2924, 64.2729, 64.2535, 64.2347, 64.2164,
         64.1988, 64.1825, 64.1674, 64.1534, 64.1404, 64.1284, 64.1173, 64.1071, 64.0977, 64.089, 64.081],
        [0.0, 0.0, 0.0, 0.019667, 0.019324, 0.018323, 0.017996, 0.01791, 0.13389, 0.13155, 0.11642, 0.1149, 0.11823,
         0.12603, 0.13838, 0.15568, 0.17868, 0.20836, 0.24598, 0.2931, 0.30984, 0.32291, 0.32647, 10.947, 10.71, 10.614,
         9.6389, 8.6774, 7.6765, 6.7379, 5.9222, 5.2582, 4.7528, 4.4181, 4.4, 4.3559, 4.3406, 4.3514, 4.3032, 4.2232,
         4.1376, 4.1554, 4.2536, 4.419, 4.6376, 4.8971, 5.1869, 5.4977, 5.8218, 6.1529, 6.4858, 6.8167, 7.1432, 7.4631,
         7.6231, 7.6464, 7.6697, 7.6929, 7.7161, 7.7392, 7.7623, 7.7853, 7.8083, 7.8312, 7.8541, 7.877, 7.8998, 7.9225,
         7.9452, 7.9679, 7.9905, 8.0131, 8.0356, 8.0581, 8.0805, 8.1029, 8.1253, 8.1476, 8.1699, 8.1921, 8.2143, 8.2364,
         8.2585, 8.2806, 8.3026, 8.3246, 8.3465, 8.3684, 8.3902, 8.412, 8.4338, 8.4556, 8.4773, 8.4989, 8.5205, 8.5421,
         8.5637, 8.5852, 8.6067, 8.6282, 8.6496, 8.671, 8.6923, 8.7137, 8.7349, 8.7562, 8.7775, 8.7987, 8.8199, 8.841,
         8.8621, 8.8832, 8.9043, 8.9254, 8.9464, 8.9674, 8.9884, 9.0094, 9.0304, 9.0513, 9.0722, 9.0931, 9.114, 9.1166,
         18.785, 18.453, 18.041, 17.649, 17.277, 16.922, 16.585, 16.265, 15.96, 15.67, 15.395, 15.134, 14.886, 14.65,
         14.426, 14.214, 14.012, 13.821, 13.639, 13.467, 13.305, 13.155, 13.018, 12.892, 12.776, 12.669, 12.571, 12.477,
         12.388, 12.306, 12.23, 12.16, 12.096, 12.036, 11.981, 11.931, 11.884, 11.841, 11.802, 11.765, 11.732, 11.702,
         11.674, 11.649, 11.601, 11.542, 11.484, 11.428, 11.374, 11.321, 11.27, 11.22, 11.171, 11.124, 11.077, 11.032,
         10.988, 10.944, 10.902, 10.86, 10.82, 10.78, 10.74, 10.702, 10.664, 10.626, 10.59, 10.554, 10.518, 10.483,
         10.449, 10.414, 10.381, 10.348, 10.315, 10.283, 10.251, 10.22, 10.189, 10.158, 10.128, 10.098, 10.069, 10.04,
         10.011, 9.9825, 9.9544, 9.9266, 9.8992, 9.8721, 9.8453, 9.8188, 9.7927, 9.7668, 9.7413, 9.7161, 9.6911, 9.6665,
         9.6422, 9.6183, 9.5946, 9.5712, 9.5481, 9.5253, 9.5029, 9.4807, 9.4589, 9.4373, 9.4161, 9.3951, 9.3745, 9.3542,
         9.3342, 9.3145, 9.2951, 9.276, 9.2573, 9.2388, 9.2207, 9.2029, 9.1854, 9.1682, 9.1513, 9.1348, 9.1186, 9.1027,
         9.0871, 9.0718, 9.0569, 9.0423, 9.028, 9.014, 9.0051, 10.149, 10.149, 10.139, 10.13, 10.121, 10.113, 10.105,
         10.097, 10.09, 10.083, 10.076, 10.069, 10.063, 10.057, 10.056, 10.4, 10.399, 10.395, 10.392, 10.389, 10.387,
         10.384, 10.382, 10.381, 10.38, 10.379, 10.378, 10.377, 10.377, 10.377, 10.378, 10.378, 10.379, 10.38, 10.382,
         10.383, 10.385, 10.387, 10.39, 10.392, 10.395, 10.398, 10.401, 10.405, 10.409, 10.412, 10.416, 10.421, 10.425,
         10.429, 10.434, 10.439, 10.444, 10.449, 10.454, 10.46, 10.465, 10.471, 10.476, 10.482, 10.488, 10.494, 10.5,
         10.506, 10.512, 10.518, 10.525, 10.531, 10.537, 10.538, 11.074, 11.077, 11.084, 11.092, 11.099, 11.106, 11.113,
         11.121, 11.128, 11.135, 11.142, 11.149, 11.156, 11.163, 11.17, 11.176, 11.183, 11.19, 11.196, 11.202, 11.208,
         11.214, 11.22, 11.226, 11.231, 11.237, 11.242, 11.247, 11.251, 11.256, 11.26, 11.264, 11.268, 11.271, 11.275,
         11.278, 11.28, 11.283, 11.285, 11.287, 11.289, 11.291, 11.292, 11.293, 11.293, 11.294, 11.294, 11.293, 11.293,
         11.292, 11.29, 11.289, 11.287, 11.285, 11.282, 11.279, 11.276, 11.273, 11.269, 11.265, 11.26, 11.255, 11.25,
         11.244, 11.238, 11.232, 11.226, 11.219, 11.211, 11.204, 11.196, 11.187, 11.178, 11.169, 11.16, 11.15, 11.14,
         11.129, 11.119, 11.107, 11.096, 11.084, 11.072, 11.059, 11.046, 11.032, 11.018, 11.004, 10.989, 10.974, 10.958,
         10.942, 10.926, 10.909, 10.892, 10.874, 10.856, 10.838, 10.819, 10.8, 10.781, 10.761, 10.741, 10.721, 10.7,
         10.679, 10.658, 10.636, 10.614, 10.592, 10.57, 10.547, 10.524, 10.5, 10.477, 10.453, 10.429, 10.405, 10.38,
         10.355, 10.33, 10.305, 10.279, 10.253, 10.227, 10.201, 10.175, 10.148, 10.122, 10.095, 10.068, 10.041, 10.013,
         9.9857, 9.958, 9.9302, 9.9022, 9.8741, 9.8459, 9.8176, 9.7891, 9.7605, 9.7319, 9.7031, 9.6742, 9.6452, 9.6162,
         9.587, 9.5578, 9.5285, 9.4991, 9.4697, 9.4402, 9.4107, 9.3811, 9.3514, 9.3217, 9.292, 9.2622, 9.2324, 9.2025,
         9.1727, 9.1428, 9.1129, 9.0829, 9.053, 9.023, 8.9931, 8.9631, 8.9332, 8.9032, 8.8732, 8.8433, 8.8134, 8.7835,
         8.7536, 8.7237, 8.6938, 8.664, 8.6342, 8.6044, 8.5747, 8.545, 8.5153, 8.4857, 8.4561, 8.4266, 8.3971, 8.3676,
         8.3382, 8.3089, 8.2796, 8.2503, 8.2211, 8.192, 8.163, 8.1339, 8.0996, 8.0546, 8.01, 7.9656, 7.9215, 7.8777,
         7.8341, 7.7909, 7.7479, 7.7053, 7.6629, 7.6208, 7.5789, 7.5374, 7.4961, 7.4551, 7.414, 7.3716, 7.3296, 7.2878,
         7.2464, 7.2052, 7.1643, 7.1237, 7.0834, 7.0433, 7.0035, 6.964, 6.9248, 6.8853, 6.8457, 6.8064, 6.7674, 6.7286,
         6.7012, 25.9, 25.854, 25.662, 25.472, 25.283, 25.096, 24.91, 24.904, 37.507, 37.258, 36.978, 36.7, 36.424,
         36.151, 35.879, 35.61, 35.343, 35.077, 34.814, 34.553, 34.294, 34.037, 33.782, 33.529, 33.278, 33.029, 32.781,
         32.536, 32.293, 32.051, 31.811, 31.574, 31.338, 31.103, 30.871, 30.64, 30.412, 30.185, 29.959, 29.736, 29.514,
         29.294, 29.076, 28.859, 28.644, 28.431, 28.219, 28.009, 27.8, 27.593, 27.388, 27.184, 26.982, 26.781, 26.582,
         26.384, 26.267, 30.743, 30.725, 30.476, 30.229, 29.984, 29.741, 29.499, 29.258, 29.019, 28.782, 28.547, 28.326,
         28.116, 27.91, 27.705, 27.504, 27.305, 27.108, 26.914, 26.819, 28.633, 28.601, 28.389, 28.179, 27.972, 27.768,
         27.566, 27.366, 27.168, 26.972, 26.779, 26.594, 26.416, 26.24, 26.066, 25.894, 25.725, 25.557, 25.392, 25.229,
         25.067, 24.908, 24.75, 24.749, 25.825, 25.767, 25.609, 25.452, 25.297, 25.143, 24.991, 24.84, 24.69, 24.542,
         24.395, 24.251, 24.108, 23.966, 23.821, 23.673, 23.527, 23.382, 23.238, 23.095, 22.953, 22.812, 22.672, 22.533,
         22.395, 22.258, 22.122, 21.987, 21.852, 21.718, 21.586, 21.454, 21.32, 21.186, 21.052, 20.92, 20.788, 20.657,
         20.527, 20.398, 20.269, 20.141, 20.014, 19.888, 19.762, 19.637, 19.513, 19.389, 19.261, 19.134, 19.009, 18.884,
         18.759, 18.633, 18.507, 18.381, 18.256, 18.132, 18.009, 17.887, 17.766, 17.645, 17.525, 17.407, 17.289, 17.172,
         17.055, 16.94, 16.825, 16.709, 16.594, 16.479, 16.365, 16.252, 16.14, 16.028, 15.918, 15.808, 15.7, 15.592,
         15.485, 15.379, 15.273, 15.169, 15.065, 14.963, 14.861, 14.76, 14.66, 14.56, 14.462, 14.364, 14.267, 14.171,
         14.075, 13.966, 13.857, 13.75, 13.644, 13.539, 13.433, 13.327, 13.221, 13.116, 13.012, 12.909, 12.807, 12.706,
         12.606, 12.507, 12.409, 12.311, 12.215, 12.119, 12.024, 11.93, 11.837, 11.745, 11.652, 11.56, 11.468, 11.377,
         11.287, 11.198, 11.109, 11.022, 10.935, 10.849, 10.763, 10.678, 10.595, 10.512, 10.429, 10.347, 10.267, 10.186,
         10.107, 10.028, 9.95, 9.8726, 9.7954, 9.7185, 9.6424, 9.5669, 9.4921, 9.4179, 9.3444, 9.2715, 9.1993, 9.1277,
         9.0567, 8.9864, 8.7546, 7.8959, 7.1311, 6.4492, 5.826, 5.2446, 4.7294, 4.2728, 3.857, 3.7036, 3.6172, 3.5948,
         10.455, 10.112, 9.1507, 8.912, 8.8889, 8.851, 12.125, 11.824, 11.537, 11.249, 11.175, 12.806, 12.738, 12.53,
         11.524, 10.333, 9.2524, 8.2759, 7.4018, 6.6258, 5.9363, 5.3231, 4.7588, 4.2515, 3.7894, 3.3778, 3.0136, 2.691,
         2.4051, 2.1515, 1.9262, 1.7125, 1.52, 1.3491, 1.1961, 1.0592, 0.93498, 0.82563, 0.72944, 0.64496, 0.61279,
         0.59596, 0.5916, 3.3355, 3.2652, 3.2594, 2.9371, 2.6343, 2.3606, 2.1138, 1.8907, 1.6911, 1.5105, 1.345, 1.1979,
         1.0669, 0.94693, 0.84015, 0.74547, 0.66153, 0.58709, 0.52107, 0.46251, 0.41057, 0.36449, 0.3236, 0.28733,
         0.25546, 0.22781, 0.20316, 0.18119, 0.16161, 0.14415, 0.12859, 0.11471, 0.10234, 0.091305, 0.081465]],
    'Tb':                                                                                                         [
        [0.008428, 0.008557, 0.0085914, 0.008643, 0.008772, 0.009212, 0.009353, 0.0093906, 0.009447, 0.009588, 0.01069,
         0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844,
         0.02083314, 0.02227063, 0.0238073, 0.024892, 0.025273, 0.0253746, 0.02545001, 0.025527, 0.025908, 0.02720606,
         0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.03822, 0.038805, 0.038961, 0.039195, 0.03978,
         0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942,
         0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505,
         0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862,
         0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722,
         0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071,
         0.11730431, 0.11789083, 0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942,
         0.12268982, 0.12330327, 0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416,
         0.12832258, 0.12896419, 0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621,
         0.13421395, 0.13488502, 0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774,
         0.14037579, 0.14107766, 0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007,
         0.14682052, 0.14695355, 0.14704645, 0.14755462, 0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056,
         0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594,
         0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018,
         0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793,
         0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345,
         0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459,
         0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888,
         0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096,
         0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046,
         0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655,
         0.22771948, 0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927,
         0.23817422, 0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959,
         0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942,
         0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171,
         0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044,
         0.2847492, 0.28501845, 0.2852508, 0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766,
         0.29514498, 0.29662071, 0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946,
         0.30869526, 0.3098867, 0.31023873, 0.31051331, 0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265,
         0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555,
         0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34449531, 0.34621779, 0.34794888,
         0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341,
         0.36574303, 0.36757174, 0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135,
         0.3825345, 0.38444718, 0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39739863,
         0.39810635, 0.39840134, 0.40009688, 0.40209737, 0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083,
         0.41431208, 0.41638364, 0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775,
         0.43333339, 0.43550006, 0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311,
         0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755,
         0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254,
         0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172,
         0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074,
         0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734,
         0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144,
         0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528,
         0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347,
         0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314,
         0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404,
         0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867,
         0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324,
         0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358,
         0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373,
         0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762,
         0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348,
         0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312,
         0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021,
         1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407,
         1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252,
         1.1234143, 1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909,
         1.1808659, 1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801,
         1.2410448, 1.2412555, 1.2413551, 1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2747297, 1.2752703,
         1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796,
         1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577, 1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887,
         1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963,
         1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812,
         1.5613491, 1.5691559, 1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6098611, 1.6127389, 1.6168229,
         1.624907, 1.6330316, 1.6411967, 1.6494027, 1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075,
         1.708005, 1.716545, 1.7251278, 1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7660507, 1.7686894, 1.7693492,
         1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.813351, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404,
         1.8684361, 1.8777783, 1.8871672, 1.896603, 1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171,
         1.9639882, 1.9642536, 1.9707463, 1.9738081, 1.9836772, 1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675,
         2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746,
         2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007,
         2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177,
         2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116,
         2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829,
         2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476,
         2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376,
         2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021,
         3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008,
         3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408,
         3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061,
         3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299,
         3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602,
         3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467,
         5.660855, 6.051453, 6.469004, 6.915365, 7.36372, 7.392525, 7.47643, 7.506486, 7.55157, 7.66428, 7.902609,
         8.086568, 8.210342, 8.243349, 8.292858, 8.416632, 8.44789, 8.53384, 8.66446, 8.699292, 8.75154, 8.88216,
         9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961,
         18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551,
         39.19543, 41.89992, 44.79101, 47.88159, 50.95579, 51.18542, 51.73572, 51.94371, 52.25568, 53.03561, 54.71721,
         58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931,
         121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835,
         253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [12.981, 12.9472, 12.9206, 12.9376, 12.9409, 12.8773, 12.8122, 12.7429, 12.8081, 12.8578, 12.837, 12.7683,
         12.678, 12.5663, 12.4303, 12.265, 12.0622, 11.8097, 11.4875, 11.061, 10.462, 9.52814, 7.69941, 4.2122,
         -0.441891, -6.107, -3.53795, -0.0875725, 5.18255, 10.2633, 13.005, 14.5382, 15.3677, 15.7615, 15.8784, 15.8782,
         15.8646, 15.8469, 15.861, 15.8659, 15.8529, 15.7544, 15.6225, 15.5046, 15.409, 15.3482, 15.3299, 15.3572,
         15.4298, 15.5456, 15.7156, 15.9045, 16.12, 16.3527, 19.0901, 19.1079, 19.1257, 19.1434, 19.1611, 19.1787,
         19.1962, 19.2136, 19.2309, 19.2481, 19.2651, 19.2821, 19.2988, 19.3154, 19.3318, 19.348, 19.3639, 19.3797,
         19.3951, 19.4103, 19.4252, 19.4397, 19.4539, 19.4677, 19.4811, 19.494, 19.5065, 19.5185, 19.5299, 19.5408,
         19.551, 19.5605, 19.5699, 19.578, 19.5852, 19.5916, 19.597, 19.6013, 19.6046, 19.6066, 19.6074, 19.6068,
         19.6047, 19.601, 19.5955, 19.5881, 19.5786, 19.5668, 19.5526, 19.5357, 19.5159, 19.4927, 19.466, 19.4354,
         19.4003, 19.3604, 19.315, 19.2636, 19.2052, 19.139, 19.064, 18.9787, 18.8818, 18.7711, 18.6444, 18.4986, 18.33,
         18.1334, 17.9023, 17.6275, 17.2961, 16.8889, 16.3762, 15.708, 14.7917, 13.4255, 11.0209, 3.47099, -3.34446,
         -3.13135, 10.5112, 15.5232, 18.2741, 20.1565, 21.5618, 22.6604, 23.5434, 24.2662, 24.8653, 25.3661, 25.7872,
         26.1426, 26.4432, 26.6977, 26.9127, 27.094, 27.246, 27.3723, 27.4756, 27.5581, 27.6224, 27.673, 27.7135,
         27.7462, 27.7731, 27.7956, 27.815, 27.8322, 27.848, 27.8629, 27.8775, 27.8921, 27.9072, 27.9231, 27.9398,
         27.9578, 27.9771, 27.9983, 28.0193, 28.0402, 28.0611, 28.0821, 28.1031, 28.1242, 28.1455, 28.1669, 28.1885,
         28.2102, 28.2321, 28.2542, 28.2763, 28.2986, 28.321, 28.3435, 28.3661, 28.3888, 28.4115, 28.4343, 28.4571,
         28.4799, 28.5027, 28.5254, 28.5481, 28.5708, 28.5934, 28.6158, 28.6382, 28.6604, 28.6825, 28.7045, 28.7262,
         28.7478, 28.7691, 28.7903, 28.8112, 28.8318, 28.8522, 28.8723, 28.8921, 28.9116, 28.9308, 28.9497, 28.9682,
         28.9864, 29.0041, 29.0215, 29.0385, 29.0551, 29.0713, 29.087, 29.1023, 29.1171, 29.1314, 29.1452, 29.1585,
         29.1712, 29.1834, 29.1951, 29.2061, 29.2165, 29.2263, 29.2354, 29.2439, 29.2516, 29.2585, 29.2647, 29.2701,
         29.2746, 29.2781, 29.2807, 29.2823, 29.2828, 29.2821, 29.2802, 29.2768, 29.272, 29.2656, 29.2574, 29.2471,
         29.2346, 29.2196, 29.2016, 29.1802, 29.1547, 29.1243, 29.0876, 29.043, 28.9877, 28.917, 28.8223, 28.6841,
         28.4403, 27.8284, 26.8959, 27.829, 28.4574, 28.7078, 28.8569, 28.964, 29.0477, 29.1163, 29.174, 29.2234,
         29.2659, 29.3022, 29.3327, 29.3572, 29.3748, 29.3832, 29.377, 29.3374, 29.1967, 28.9823, 29.2097, 29.4082,
         29.5122, 29.5859, 29.6467, 29.7001, 29.7486, 29.7936, 29.8359, 29.8761, 29.9146, 29.9516, 29.9874, 30.0221,
         30.0558, 30.0887, 30.1208, 30.1523, 30.1831, 30.2133, 30.2431, 30.2723, 30.301, 30.3293, 30.3572, 30.3846,
         30.4117, 30.4383, 30.4645, 30.4903, 30.5156, 30.5405, 30.5649, 30.5887, 30.612, 30.6346, 30.6565, 30.6775,
         30.6976, 30.7166, 30.7342, 30.7502, 30.7641, 30.7754, 30.7832, 30.7863, 30.7822, 30.7669, 30.7304, 30.6395,
         30.4502, 30.3141, 30.467, 30.7421, 30.8843, 30.9841, 31.0659, 31.1378, 31.2034, 31.2647, 31.3229, 31.3788,
         31.4328, 31.4855, 31.537, 31.5875, 31.6373, 31.6865, 31.7351, 31.7833, 31.8312, 31.8787, 31.926, 31.97,
         32.0169, 32.0636, 32.1102, 32.1567, 32.2031, 32.2494, 32.2956, 32.3417, 32.3878, 32.4338, 32.4798, 32.5257,
         32.5716, 32.6175, 32.6633, 32.7091, 32.7549, 32.8006, 32.8462, 32.8918, 32.9374, 32.9829, 33.0283, 33.0737,
         33.119, 33.1642, 33.2094, 33.2545, 33.2995, 33.3444, 33.3892, 33.4339, 33.4784, 33.5229, 33.5672, 33.6114,
         33.6555, 33.6994, 33.7431, 33.7867, 33.8302, 33.8734, 33.9164, 33.9593, 34.0019, 34.0444, 34.0866, 34.1286,
         34.1703, 34.2119, 34.2531, 34.2941, 34.3349, 34.3753, 34.4155, 34.4554, 34.495, 34.5343, 34.5732, 34.6119,
         34.6501, 34.688, 34.7255, 34.7626, 34.7993, 34.8356, 34.8713, 34.9067, 34.9415, 34.9759, 35.0097, 35.043,
         35.0758, 35.1081, 35.1398, 35.1709, 35.2014, 35.2313, 35.2607, 35.2894, 35.3175, 35.3449, 35.3717, 35.3978,
         35.4232, 35.448, 35.472, 35.4953, 35.518, 35.5398, 35.561, 35.5813, 35.6009, 35.6197, 35.6378, 35.655, 35.6714,
         35.687, 35.7017, 35.7156, 35.7286, 35.7408, 35.752, 35.7624, 35.7718, 35.7803, 35.7879, 35.7945, 35.8001,
         35.8048, 35.8084, 35.811, 35.8126, 35.8132, 35.8126, 35.811, 35.8083, 35.8045, 35.7996, 35.7935, 35.7862,
         35.7777, 35.768, 35.7571, 35.7449, 35.7315, 35.7167, 35.7007, 35.6832, 35.6644, 35.6442, 35.6226, 35.6013,
         35.5767, 35.5506, 35.523, 35.4938, 35.4629, 35.4304, 35.3962, 35.3602, 35.3225, 35.2829, 35.2415, 35.1981,
         35.1528, 35.1055, 35.0561, 35.0046, 34.9509, 34.895, 34.8368, 34.7763, 34.7133, 34.6478, 34.5798, 34.5092,
         34.4358, 34.3597, 34.2807, 34.1987, 34.1138, 34.0258, 33.9309, 33.8244, 33.7127, 33.5959, 33.4736, 33.3455,
         33.2115, 33.0713, 32.9245, 32.7707, 32.6097, 32.441, 32.2642, 32.0788, 31.8842, 31.6798, 31.465, 31.239,
         31.001, 30.7501, 30.4851, 30.205, 29.9083, 29.5935, 29.2589, 28.9023, 28.5214, 28.1132, 27.6743, 27.2007,
         26.6875, 26.1287, 25.5167, 24.8419, 24.0918, 23.2496, 22.2917, 21.1857, 19.8799, 18.29, 16.2608, 13.4483,
         8.76614, -14.6252, -21.4128, -14.9723, 7.7323, 11.2864, 12.6566, 12.4859, 8.84739, 0.375774, 0.286762, 12.1356,
         17.2921, 20.3204, 22.5811, 24.4201, 25.9839, 27.3503, 28.5662, 29.6627, 30.6615, 31.5784, 32.4253, 33.2117,
         33.9449, 34.631, 35.2747, 35.8803, 36.4511, 36.9901, 37.4997, 37.982, 38.4389, 38.8719, 39.2824, 39.6715,
         40.0403, 40.3894, 40.7198, 41.0317, 41.3257, 41.602, 41.8607, 42.1016, 42.3245, 42.5289, 42.7137, 42.8779,
         43.0195, 43.1358, 43.2231, 43.2756, 43.2843, 43.2344, 43.0989, 42.8205, 42.2397, 40.4058, 39.6252, 39.6414,
         41.7185, 43.247, 44.1265, 44.7741, 45.2968, 45.7386, 46.1214, 46.4572, 46.7528, 47.0108, 47.2386, 47.443,
         47.6215, 47.7705, 47.8831, 47.945, 47.9218, 47.6933, 46.9089, 46.6372, 46.965, 48.2501, 48.8419, 49.2675,
         49.6165, 49.9189, 50.1884, 50.4324, 50.655, 50.8584, 51.0436, 51.2174, 51.3805, 51.5326, 51.673, 51.8006,
         51.9135, 52.0083, 52.0783, 52.1094, 52.0624, 51.7185, 51.6931, 51.7851, 52.0833, 52.5884, 52.9146, 53.179,
         53.4106, 53.6213, 53.8172, 54.0019, 54.1777, 54.3459, 54.5082, 54.6662, 54.8205, 54.97, 55.1146, 55.2548,
         55.391, 55.5237, 55.653, 55.7793, 55.9026, 56.0233, 56.1415, 56.2573, 56.3709, 56.4824, 56.5919, 56.6995,
         56.8055, 56.9099, 57.0129, 57.1145, 57.2137, 57.3108, 57.4059, 57.4991, 57.5905, 57.6802, 57.7683, 57.8547,
         57.9397, 58.0231, 58.1052, 58.186, 58.2654, 58.3436, 58.6401, 58.716, 58.7903, 58.863, 58.9343, 59.0042,
         59.2221, 59.2892, 59.3545, 59.4182, 59.4804, 59.5411, 59.6004, 59.6584, 59.715, 59.7704, 59.8246, 59.8777,
         59.9296, 59.9805, 60.0304, 60.0793, 60.1273, 60.1743, 60.2204, 60.2655, 60.3097, 60.3531, 60.3958, 60.4377,
         60.4789, 60.5195, 60.5595, 60.5992, 60.6384, 60.6775, 60.7165, 60.7557, 60.7956, 60.8359, 60.8734, 60.9086,
         60.9417, 60.9732, 61.003, 61.0315, 61.0586, 61.0844, 61.1091, 61.1328, 61.1554, 61.177, 61.1978, 61.3211,
         61.3406, 61.359, 61.3763, 61.3925, 61.4078, 61.422, 61.4354, 61.4479, 61.4596, 61.4705, 61.4807, 61.4901,
         61.4988, 61.5069, 61.5143, 61.5211, 61.5273, 61.5803, 61.5858, 61.5905, 61.5945, 61.5978, 61.6004, 61.6023,
         61.6036, 61.6044, 61.6045, 61.6041, 61.6031, 61.6016, 61.5996, 61.5971, 61.5941, 61.5907, 61.5868, 61.5824,
         61.5776, 61.5724, 61.5668, 61.5835, 61.5773, 61.5705, 61.9269, 61.7228, 61.4665, 61.1604, 60.7991, 60.3598,
         59.7832, 58.9836, 57.7015, 54.6368, 54.1724, 51.6171, 48.0919, 51.6124, 54.6597, 56.2924, 56.3069, 55.1953,
         53.5209, 55.4015, 57.1642, 57.3859, 57.7981, 57.7495, 57.0199, 58.1155, 59.3813, 60.2005, 62.1877, 63.3585,
         64.0963, 64.5643, 64.8759, 65.0801, 65.2095, 65.3548, 65.3846, 65.4482, 65.4127, 65.3547, 65.2827, 65.202,
         65.1162, 65.0301, 64.9464, 64.8428, 64.7303, 64.6085, 64.4733, 64.3176, 64.1253, 63.8653, 63.4418, 62.3594,
         62.1547, 61.1993, 59.8099, 61.214, 62.4827, 63.3932, 64.2121, 64.6272, 64.8831, 65.0525, 65.1669, 65.2468,
         65.2984, 65.3289, 65.3454, 65.3814, 65.3781, 65.3683, 65.3544, 65.3378, 65.3196, 65.3004, 65.281, 65.2617,
         65.2427, 65.2242, 65.2063, 65.1893, 65.1737, 65.1593, 65.1459, 65.1335, 65.1221, 65.1115, 65.1017, 65.0928,
         65.0845],
        [0.0, 0.0, 0.0, 0.044183, 0.043243, 0.040279, 0.039401, 0.039172, 0.16984, 0.16622, 0.14498, 0.14004, 0.14113,
         0.14746, 0.15886, 0.17558, 0.19819, 0.22759, 0.26496, 0.31175, 0.36973, 0.44091, 0.52762, 0.5954, 0.6205,
         0.6273, 11.903, 11.837, 11.522, 10.564, 9.3993, 8.2623, 7.2428, 6.4036, 5.7661, 5.7162, 5.6032, 5.5751, 5.5671,
         5.4739, 5.3603, 5.1021, 4.9983, 5.018, 5.1339, 5.3289, 5.585, 5.8872, 6.2227, 6.5815, 6.9551, 7.3372, 7.7227,
         8.1079, 8.3031, 8.3317, 8.3603, 8.3888, 8.4173, 8.4458, 8.4743, 8.5028, 8.5312, 8.5596, 8.588, 8.6164, 8.6447,
         8.6731, 8.7014, 8.7296, 8.7579, 8.7861, 8.8143, 8.8425, 8.8707, 8.8988, 8.9269, 8.955, 8.983, 9.011, 9.039,
         9.067, 9.095, 9.1229, 9.1508, 9.1787, 9.2065, 9.2343, 9.2621, 9.2899, 9.3177, 9.3454, 9.3731, 9.4008, 9.4284,
         9.456, 9.4836, 9.5112, 9.5388, 9.5663, 9.5939, 9.6214, 9.6488, 9.6763, 9.7037, 9.7312, 9.7586, 9.7859, 9.8133,
         9.8407, 9.868, 9.8953, 9.9226, 9.9499, 9.9772, 10.004, 10.032, 10.059, 10.086, 10.113, 10.141, 10.168, 10.195,
         10.222, 10.249, 10.277, 10.304, 10.331, 10.358, 10.385, 10.412, 10.44, 10.444, 26.773, 26.136, 25.261, 24.438,
         23.664, 22.936, 22.252, 21.608, 21.004, 20.435, 19.901, 19.399, 18.928, 18.485, 18.07, 17.68, 17.314, 16.97,
         16.648, 16.347, 16.054, 15.784, 15.536, 15.31, 15.103, 14.913, 14.738, 14.578, 14.43, 14.295, 14.17, 14.055,
         13.95, 13.852, 13.763, 13.68, 13.604, 13.531, 13.428, 13.33, 13.237, 13.148, 13.062, 12.981, 12.902, 12.826,
         12.754, 12.684, 12.616, 12.551, 12.487, 12.426, 12.367, 12.309, 12.253, 12.198, 12.145, 12.093, 12.043, 11.993,
         11.945, 11.898, 11.851, 11.806, 11.761, 11.718, 11.675, 11.632, 11.591, 11.55, 11.51, 11.47, 11.431, 11.393,
         11.355, 11.317, 11.28, 11.244, 11.208, 11.172, 11.137, 11.102, 11.068, 11.034, 11.0, 10.967, 10.934, 10.902,
         10.87, 10.838, 10.807, 10.776, 10.745, 10.714, 10.684, 10.654, 10.625, 10.596, 10.567, 10.538, 10.51, 10.482,
         10.455, 10.427, 10.4, 10.374, 10.347, 10.321, 10.296, 10.27, 10.245, 10.22, 10.196, 10.172, 10.148, 10.124,
         10.101, 10.078, 10.056, 10.033, 10.011, 9.9898, 9.9686, 9.9476, 9.927, 9.9068, 9.8868, 9.8672, 9.848, 9.829,
         9.8104, 9.7922, 9.7743, 9.76, 10.88, 10.878, 10.867, 10.854, 10.842, 10.83, 10.819, 10.807, 10.797, 10.786,
         10.776, 10.766, 10.757, 10.748, 10.739, 10.731, 10.723, 10.715, 10.71, 11.041, 11.04, 11.036, 11.031, 11.027,
         11.022, 11.018, 11.015, 11.011, 11.008, 11.006, 11.003, 11.001, 10.999, 10.998, 10.997, 10.996, 10.995, 10.995,
         10.994, 10.995, 10.995, 10.996, 10.996, 10.998, 10.999, 11.0, 11.002, 11.004, 11.006, 11.009, 11.011, 11.014,
         11.017, 11.02, 11.023, 11.026, 11.03, 11.034, 11.037, 11.041, 11.045, 11.049, 11.054, 11.058, 11.062, 11.067,
         11.071, 11.076, 11.08, 11.085, 11.088, 11.614, 11.614, 11.619, 11.625, 11.631, 11.637, 11.643, 11.649, 11.654,
         11.66, 11.666, 11.671, 11.677, 11.682, 11.688, 11.693, 11.698, 11.703, 11.708, 11.713, 11.718, 11.723, 11.727,
         11.731, 11.735, 11.739, 11.743, 11.746, 11.75, 11.753, 11.756, 11.758, 11.761, 11.763, 11.764, 11.766, 11.767,
         11.768, 11.769, 11.769, 11.77, 11.769, 11.769, 11.768, 11.767, 11.765, 11.764, 11.762, 11.759, 11.756, 11.753,
         11.75, 11.746, 11.742, 11.738, 11.733, 11.728, 11.722, 11.717, 11.71, 11.704, 11.697, 11.69, 11.682, 11.674,
         11.665, 11.657, 11.648, 11.638, 11.628, 11.618, 11.607, 11.596, 11.585, 11.573, 11.561, 11.549, 11.536, 11.523,
         11.509, 11.495, 11.481, 11.466, 11.451, 11.435, 11.419, 11.402, 11.385, 11.368, 11.35, 11.332, 11.313, 11.294,
         11.274, 11.254, 11.234, 11.214, 11.193, 11.171, 11.15, 11.127, 11.105, 11.082, 11.059, 11.036, 11.012, 10.988,
         10.964, 10.939, 10.915, 10.889, 10.864, 10.838, 10.812, 10.786, 10.76, 10.733, 10.706, 10.679, 10.652, 10.624,
         10.596, 10.568, 10.54, 10.512, 10.483, 10.454, 10.426, 10.396, 10.367, 10.338, 10.308, 10.279, 10.249, 10.219,
         10.189, 10.159, 10.128, 10.098, 10.067, 10.037, 10.006, 9.9755, 9.9447, 9.9138, 9.8828, 9.8518, 9.8207, 9.7895,
         9.7583, 9.7271, 9.6958, 9.6645, 9.6332, 9.6018, 9.5704, 9.539, 9.5075, 9.4761, 9.4446, 9.4132, 9.3817, 9.3502,
         9.3188, 9.2874, 9.2559, 9.2245, 9.1931, 9.1617, 9.1304, 9.0991, 9.0678, 9.0365, 9.0053, 8.9741, 8.943, 8.9119,
         8.8809, 8.8499, 8.819, 8.7881, 8.7572, 8.7265, 8.6958, 8.6651, 8.6345, 8.5979, 8.5491, 8.5006, 8.4525, 8.4047,
         8.3572, 8.31, 8.2632, 8.2166, 8.1704, 8.1245, 8.0789, 8.0337, 7.9887, 7.944, 7.8997, 7.8556, 7.8119, 7.7684,
         7.7253, 7.6824, 7.6398, 7.5976, 7.5556, 7.5139, 7.4725, 7.4312, 7.3885, 7.3461, 7.304, 7.2621, 7.2206, 7.1793,
         7.1384, 7.0977, 7.0573, 7.0172, 6.9774, 6.9379, 6.8986, 6.8596, 6.8209, 6.7824, 6.7455, 26.448, 26.445, 26.244,
         26.042, 25.841, 25.641, 25.444, 25.378, 38.277, 38.103, 37.804, 37.508, 37.214, 36.923, 36.634, 36.347, 36.063,
         35.78, 35.501, 35.223, 34.948, 34.675, 34.404, 34.135, 33.869, 33.604, 33.342, 33.082, 32.824, 32.568, 32.314,
         32.062, 31.813, 31.565, 31.319, 31.075, 30.834, 30.594, 30.356, 30.12, 29.886, 29.654, 29.423, 29.195, 28.968,
         28.744, 28.521, 28.3, 28.08, 27.862, 27.647, 27.432, 27.22, 27.009, 26.8, 26.592, 26.565, 31.048, 30.919,
         30.667, 30.416, 30.168, 29.922, 29.678, 29.436, 29.196, 28.957, 28.722, 28.507, 28.295, 28.086, 27.88, 27.676,
         27.475, 27.276, 27.08, 26.944, 28.792, 28.776, 28.575, 28.361, 28.15, 27.941, 27.734, 27.53, 27.328, 27.128,
         26.93, 26.74, 26.558, 26.379, 26.202, 26.028, 25.855, 25.685, 25.517, 25.351, 25.187, 25.025, 24.865, 24.861,
         25.938, 25.888, 25.726, 25.566, 25.408, 25.251, 25.096, 24.942, 24.79, 24.639, 24.489, 24.342, 24.197, 24.052,
         23.902, 23.753, 23.606, 23.459, 23.314, 23.169, 23.026, 22.884, 22.743, 22.602, 22.463, 22.325, 22.187, 22.051,
         21.915, 21.781, 21.647, 21.514, 21.379, 21.244, 21.11, 20.977, 20.844, 20.712, 20.581, 20.451, 20.321, 20.192,
         20.064, 19.937, 19.811, 19.685, 19.56, 19.436, 19.308, 19.181, 19.054, 18.929, 18.804, 18.678, 18.552, 18.426,
         18.301, 18.177, 18.054, 17.931, 17.81, 17.689, 17.57, 17.451, 17.333, 17.216, 17.099, 16.984, 16.869, 16.753,
         16.638, 16.523, 16.409, 16.296, 16.184, 16.073, 15.962, 15.853, 15.745, 15.637, 15.53, 15.424, 15.319, 15.215,
         15.112, 15.009, 14.891, 14.775, 14.66, 14.546, 14.433, 14.321, 14.21, 14.1, 13.99, 13.882, 13.775, 13.669,
         13.564, 13.46, 13.354, 13.249, 13.144, 13.04, 12.937, 12.835, 12.734, 12.634, 12.534, 12.436, 12.338, 12.242,
         12.146, 12.051, 11.957, 11.864, 11.772, 11.68, 11.589, 11.497, 11.406, 11.316, 11.227, 11.138, 11.05, 10.963,
         10.877, 10.791, 10.706, 10.622, 10.539, 10.456, 10.374, 10.293, 10.213, 10.133, 10.054, 9.9761, 9.8986, 9.8217,
         9.7449, 9.6685, 9.5928, 9.3434, 8.4197, 7.5975, 6.8649, 6.2113, 5.6017, 5.0463, 4.5534, 4.1161, 3.7337, 3.7112,
         3.6468, 3.6242, 10.464, 10.133, 9.4871, 9.1064, 8.8738, 8.8144, 12.167, 11.841, 11.761, 11.547, 11.235, 11.163,
         12.789, 12.511, 12.202, 11.006, 9.862, 8.8004, 7.862, 7.0353, 6.301, 5.6482, 5.0597, 4.5252, 4.0404, 3.6017,
         3.2134, 2.8695, 2.5647, 2.2943, 2.0543, 1.8264, 1.6209, 1.4399, 1.2777, 1.1329, 1.0021, 0.88527, 0.7821,
         0.69148, 0.61688, 0.61183, 0.59999, 0.59561, 3.3244, 3.2494, 3.0964, 2.78, 2.4918, 2.2322, 1.9977, 1.7875,
         1.5972, 1.4228, 1.2675, 1.1294, 1.0049, 0.89182, 0.79157, 0.70266, 0.62379, 0.55382, 0.49174, 0.43666, 0.38778,
         0.34439, 0.30589, 0.27171, 0.24224, 0.21619, 0.19295, 0.17223, 0.15374, 0.13724, 0.12252, 0.10939, 0.097665,
         0.087205]],
    'Dy':                                                                                                         [
        [0.004116, 0.004179, 0.0041958, 0.004221, 0.004284, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.025774, 0.0261685, 0.0262737, 0.0264315, 0.026826, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.061642, 0.0625855, 0.0628371, 0.0632145, 0.064158, 0.06477028, 0.06923942, 0.07401695, 0.07912411,
         0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775,
         0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827,
         0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598,
         0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083,
         0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327,
         0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419,
         0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502,
         0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766,
         0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462,
         0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15414295,
         0.15425706, 0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215,
         0.16061121, 0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922,
         0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314,
         0.17569726, 0.17657574, 0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937,
         0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409,
         0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422,
         0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745,
         0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228,
         0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948, 0.22885808,
         0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422, 0.23936509,
         0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893, 0.25035448,
         0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567, 0.2618484,
         0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747, 0.27387001,
         0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845, 0.28644354,
         0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.29262731, 0.29317269, 0.2936766, 0.29514498, 0.29662071,
         0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873,
         0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197,
         0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33144831, 0.33215172, 0.33267555, 0.33433893, 0.33601062,
         0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706,
         0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174,
         0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718,
         0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737,
         0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41572967, 0.41638364, 0.41687033,
         0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006,
         0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412,
         0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612,
         0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782,
         0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444,
         0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691, 0.54508094,
         0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56726958, 0.57010592,
         0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325, 0.59627982,
         0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526, 0.62365537,
         0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253, 0.65228775,
         0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045, 0.68223466,
         0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641, 0.71355644,
         0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322, 0.74631623,
         0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656, 0.78058004,
         0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515, 0.81641693,
         0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084, 0.8538991,
         0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881, 0.8931021,
         0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765, 0.93410494,
         0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959, 0.97699023,
         0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606, 1.0218444,
         1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017,
         1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143, 1.1290314,
         1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1867702,
         1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555, 1.2474618,
         1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.294729, 1.2950709, 1.2982423,
         1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3321988, 1.3328011, 1.3376796, 1.344368, 1.3510899,
         1.3578453, 1.3646345, 1.3714577, 1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848,
         1.4272857, 1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132,
         1.5002773, 1.5077787, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559,
         1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6494027,
         1.6576497, 1.665938, 1.6740015, 1.6742677, 1.6771986, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545,
         1.7251278, 1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294,
         1.813351, 1.8224178, 1.8315299, 1.8399858, 1.8406875, 1.8436141, 1.8498909, 1.8591404, 1.8684361, 1.8777783,
         1.8871672, 1.896603, 1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081,
         1.9836772, 1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0432385, 2.0439363, 2.0503613, 2.054156,
         2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058,
         2.1700018, 2.1808519, 2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279,
         2.280976, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697,
         2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4952257, 2.5077018,
         2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829, 2.6228319, 2.635946,
         2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486,
         2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451,
         2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879,
         3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477,
         3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514,
         3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962,
         3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247,
         3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452,
         3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453,
         6.469004, 6.915365, 7.392525, 7.634298, 7.75115, 7.78231, 7.829051, 7.902609, 7.945902, 8.408988, 8.44789,
         8.537697, 8.572019, 8.623503, 8.752212, 8.864884, 9.000571, 9.030794, 9.036754, 9.091029, 9.226716, 9.653919,
         10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215,
         21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992,
         44.79101, 47.88159, 51.18542, 52.71273, 53.51956, 53.73471, 54.05744, 54.71721, 54.86427, 58.4927, 62.5287,
         66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669,
         139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869,
         290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [12.0399, 11.9981, 11.9535, 11.9946, 12.0271, 11.5061, 11.3999, 11.2755, 11.3472, 11.1736, 10.9656, 10.7127,
         10.3998, 10.0025, 9.4798, 8.75445, 7.65884, 5.72391, 0.535432, -2.09144, -10.3771, -20.6809, -9.41095, 0.56153,
         4.62242, 12.7652, 15.9925, 17.464, 18.0436, 18.1477, 18.0083, 17.7603, 17.4826, 17.2211, 17.0027, 16.8431,
         16.7508, 16.7367, 16.7217, 16.7082, 16.7212, 16.7362, 16.7444, 16.849, 17.0661, 17.4445, 17.8946, 18.3409,
         18.7849, 21.495, 21.5276, 21.56, 21.5924, 21.6246, 21.6568, 21.6888, 21.7206, 21.7524, 21.7839, 21.8153,
         21.8466, 21.8776, 21.9084, 21.9391, 21.9695, 21.9997, 22.0296, 22.0593, 22.0887, 22.1178, 22.1466, 22.1751,
         22.2033, 22.2311, 22.2585, 22.2856, 22.3122, 22.3384, 22.3642, 22.3894, 22.4141, 22.4384, 22.462, 22.485,
         22.5075, 22.5292, 22.5502, 22.5706, 22.5901, 22.6088, 22.6266, 22.6435, 22.6594, 22.6743, 22.688, 22.7006,
         22.7119, 22.7219, 22.7305, 22.7376, 22.743, 22.7467, 22.7486, 22.7484, 22.7461, 22.7414, 22.7343, 22.7244,
         22.7116, 22.6955, 22.676, 22.6526, 22.6249, 22.5927, 22.5552, 22.5121, 22.4625, 22.4057, 22.3409, 22.2668,
         22.1822, 22.0854, 21.9746, 21.8471, 21.7, 21.5292, 21.3295, 21.0937, 20.8121, 20.4705, 20.0477, 19.5095,
         18.7967, 17.793, 16.2198, 13.0688, 2.08158, 2.30352, 6.37497, 16.5698, 20.0324, 22.1796, 23.7146, 24.886,
         25.8134, 26.5647, 27.1824, 27.6954, 28.1242, 28.4839, 28.7863, 29.0402, 29.253, 29.4304, 29.577, 29.6966,
         29.7922, 29.8659, 29.9196, 29.9573, 29.9828, 29.9991, 30.0081, 30.0115, 30.0105, 30.0061, 29.9991, 29.9902,
         29.9798, 29.9684, 29.9563, 29.9439, 29.9313, 29.9187, 29.9063, 29.8943, 29.8825, 29.8713, 29.8606, 29.852,
         29.8424, 29.8334, 29.825, 29.8172, 29.8101, 29.8035, 29.7975, 29.7921, 29.7873, 29.783, 29.7793, 29.776,
         29.7732, 29.7709, 29.769, 29.7675, 29.7664, 29.7657, 29.7653, 29.7652, 29.7655, 29.766, 29.7667, 29.7677,
         29.7689, 29.7702, 29.7717, 29.7734, 29.7752, 29.7771, 29.7791, 29.7811, 29.7832, 29.7853, 29.7874, 29.7895,
         29.7915, 29.7935, 29.7955, 29.7974, 29.7991, 29.8008, 29.8023, 29.8036, 29.8048, 29.8058, 29.8065, 29.8071,
         29.8074, 29.8074, 29.8071, 29.8065, 29.8056, 29.8043, 29.8027, 29.8006, 29.7981, 29.7951, 29.7916, 29.7875,
         29.7829, 29.7777, 29.7718, 29.7651, 29.7577, 29.7494, 29.7402, 29.73, 29.7187, 29.7062, 29.6923, 29.6769,
         29.6598, 29.6408, 29.6196, 29.5958, 29.569, 29.5386, 29.5039, 29.4638, 29.4169, 29.3608, 29.2919, 29.2039,
         29.0837, 28.8976, 28.4835, 28.1482, 28.1476, 28.5284, 28.9155, 29.1008, 29.2247, 29.3182, 29.3936, 29.4569,
         29.5114, 29.5594, 29.602, 29.6404, 29.675, 29.7065, 29.7352, 29.7611, 29.7845, 29.8052, 29.8233, 29.8384,
         29.8499, 29.857, 29.8579, 29.8488, 29.82, 29.7246, 29.6465, 29.6565, 29.7606, 29.8975, 29.9753, 30.0349,
         30.0855, 30.1306, 30.1722, 30.211, 30.2479, 30.2831, 30.3171, 30.3501, 30.3821, 30.4134, 30.444, 30.474,
         30.5035, 30.5326, 30.5612, 30.5894, 30.6172, 30.6447, 30.6718, 30.6986, 30.725, 30.751, 30.7767, 30.8019,
         30.8267, 30.8509, 30.8747, 30.8977, 30.9201, 30.9415, 30.9619, 30.9811, 30.9987, 31.0144, 31.0275, 31.0374,
         31.0426, 31.0411, 31.0287, 30.9962, 30.9136, 30.7302, 30.4221, 30.7496, 30.999, 31.1479, 31.2515, 31.3364,
         31.4111, 31.4795, 31.5435, 31.6044, 31.663, 31.7198, 31.7752, 31.8296, 31.883, 31.9357, 31.9878, 32.0395,
         32.0907, 32.1417, 32.1923, 32.2428, 32.293, 32.3492, 32.3992, 32.4491, 32.499, 32.5488, 32.5985, 32.6481,
         32.6978, 32.7474, 32.7969, 32.8465, 32.896, 32.9455, 32.9949, 33.0444, 33.0938, 33.1432, 33.1926, 33.2419,
         33.2912, 33.3404, 33.3896, 33.4388, 33.4878, 33.5369, 33.5858, 33.6347, 33.6835, 33.7323, 33.7809, 33.8294,
         33.8779, 33.9262, 33.9744, 34.0224, 34.0703, 34.1181, 34.1657, 34.2132, 34.2605, 34.3076, 34.3545, 34.4013,
         34.4478, 34.4941, 34.5402, 34.5861, 34.6317, 34.6771, 34.7222, 34.7671, 34.8117, 34.856, 34.9, 34.9438,
         34.9872, 35.0303, 35.0732, 35.1156, 35.1578, 35.1995, 35.2409, 35.2819, 35.3225, 35.3626, 35.4023, 35.4416,
         35.4803, 35.5186, 35.5564, 35.5936, 35.6304, 35.6666, 35.7022, 35.7373, 35.7718, 35.8058, 35.8391, 35.8718,
         35.904, 35.9355, 35.9664, 35.9966, 36.0262, 36.0551, 36.0833, 36.1107, 36.1374, 36.1633, 36.1884, 36.2128,
         36.2364, 36.2592, 36.2811, 36.3023, 36.3226, 36.3421, 36.3608, 36.3785, 36.3954, 36.4115, 36.4266, 36.4408,
         36.4541, 36.4665, 36.4779, 36.4883, 36.4978, 36.5063, 36.5138, 36.5203, 36.5258, 36.5302, 36.5336, 36.5359,
         36.5371, 36.5372, 36.5362, 36.5341, 36.5307, 36.5263, 36.5206, 36.5137, 36.5056, 36.4962, 36.4855, 36.4736,
         36.4603, 36.4469, 36.431, 36.4136, 36.3948, 36.3746, 36.3529, 36.3297, 36.305, 36.2786, 36.2507, 36.2212,
         36.19, 36.157, 36.1223, 36.0859, 36.0476, 36.0074, 35.9653, 35.9213, 35.8752, 35.8271, 35.7769, 35.7245, 35.67,
         35.6131, 35.5541, 35.5075, 35.4827, 35.4478, 35.4039, 35.3516, 35.2915, 35.2241, 35.1497, 35.0684, 34.9805,
         34.8859, 34.7847, 34.6769, 34.5624, 34.4411, 34.3129, 34.1775, 34.0347, 33.8842, 33.7257, 33.5589, 33.3833,
         33.1985, 33.0039, 32.799, 32.5831, 32.3554, 32.1151, 31.8612, 31.5927, 31.3083, 31.0067, 30.686, 30.3445,
         29.9798, 29.5894, 29.1703, 28.7188, 28.2306, 27.7003, 27.1213, 26.4852, 25.7812, 24.995, 24.1072, 23.0911,
         21.9047, 20.4841, 18.7174, 16.3805, 12.8991, 5.58834, -12.71, -13.0561, 5.3553, 11.5342, 13.8769, 14.7162,
         14.0991, 8.65102, 2.39694, 2.31057, 14.9106, 19.4254, 22.2413, 24.381, 26.1366, 27.6375, 28.9537, 30.1281,
         31.1894, 32.1577, 33.0477, 33.8708, 34.6356, 35.3491, 36.017, 36.644, 37.234, 37.7901, 38.3152, 38.8115,
         39.2812, 39.7259, 40.147, 40.5459, 40.9237, 41.2811, 41.619, 41.938, 42.2384, 42.5206, 42.7846, 43.0304,
         43.2576, 43.4658, 43.6539, 43.8206, 43.9641, 44.0814, 44.1685, 44.2193, 44.224, 44.1663, 44.0159, 43.7067,
         43.042, 40.6438, 40.3848, 40.671, 43.008, 44.3844, 45.2282, 45.8623, 46.3795, 46.8192, 47.2017, 47.5382,
         47.8347, 48.0934, 48.3245, 48.5326, 48.7158, 48.8707, 48.9917, 49.0667, 49.0685, 48.9126, 48.0751, 47.7976,
         48.1344, 49.1843, 49.8465, 50.2957, 50.657, 50.9672, 51.2425, 51.4913, 51.7182, 51.9258, 52.1149, 52.2909,
         52.4563, 52.6103, 52.7525, 52.8816, 52.9957, 53.0912, 53.1611, 53.1904, 53.1357, 52.7952, 52.7239, 52.8942,
         53.2252, 53.7063, 54.0275, 54.2903, 54.5215, 54.7324, 54.9288, 55.1141, 55.2905, 55.4593, 55.6224, 55.781,
         55.936, 56.0858, 56.2307, 56.3713, 56.5079, 56.6409, 56.7706, 56.8971, 57.0207, 57.1417, 57.26, 57.3759,
         57.4896, 57.6011, 57.7105, 57.8181, 57.9238, 58.0279, 58.1305, 58.2317, 58.3307, 58.4276, 58.5224, 58.6153,
         58.7064, 58.7958, 58.8835, 58.9696, 59.0542, 59.1374, 59.2191, 59.2994, 59.3784, 59.4562, 59.5328, 59.828,
         59.9021, 59.9746, 60.0456, 60.1154, 60.1838, 60.3943, 60.4596, 60.5233, 60.5855, 60.6463, 60.7057, 60.7638,
         60.8207, 60.8763, 60.9309, 60.9843, 61.0368, 61.0882, 61.1387, 61.1884, 61.2372, 61.2854, 61.3328, 61.3795,
         61.4255, 61.4711, 61.5162, 61.5613, 61.6075, 61.6638, 61.7137, 61.7593, 61.8015, 61.841, 61.8782, 61.9134,
         61.9468, 61.9786, 62.0089, 62.0378, 62.0654, 62.0918, 62.1171, 62.1413, 62.1646, 62.1868, 62.2082, 62.2287,
         62.2484, 62.2674, 62.2856, 62.4074, 62.4245, 62.4405, 62.4556, 62.4697, 62.4829, 62.4953, 62.5068, 62.5176,
         62.5276, 62.5369, 62.5456, 62.5535, 62.5608, 62.5675, 62.5737, 62.5792, 62.5843, 62.5888, 62.6415, 62.6452,
         62.6482, 62.6506, 62.6523, 62.6534, 62.6538, 62.6537, 62.6531, 62.6519, 62.6502, 62.648, 62.6452, 62.6421,
         62.6384, 62.6343, 63.0127, 62.8643, 62.6369, 62.3597, 62.0314, 61.6424, 61.1523, 60.4954, 59.5372, 57.7675,
         55.7189, 52.7186, 49.2132, 52.7159, 55.0591, 55.7528, 57.4449, 57.2929, 56.328, 54.6603, 56.5372, 58.2818,
         58.8592, 58.7877, 58.3174, 58.0648, 59.1577, 60.4204, 62.252, 63.8114, 64.748, 65.3232, 65.714, 65.9725,
         66.1399, 66.2445, 66.3671, 66.4171, 66.4299, 66.384, 66.3205, 66.2462, 66.1656, 66.0849, 66.0029, 65.9027,
         65.7934, 65.6765, 65.5487, 65.4053, 65.2349, 65.0163, 64.6984, 64.0762, 63.3752, 62.2214, 60.8393, 62.2361,
         63.3622, 63.4983, 64.8889, 65.4469, 65.7676, 65.9746, 66.1132, 66.2115, 66.2745, 66.3134, 66.3358, 66.3469,
         66.3776, 66.3708, 66.3589, 66.3437, 66.3263, 66.3078, 66.2886, 66.2693, 66.2503, 66.2317, 66.2136, 66.1961,
         66.18, 66.1651, 66.1513, 66.1386, 66.1268, 66.1159, 66.1058, 66.0966, 66.088],
        [0.0, 0.0, 0.0, 0.084705, 0.085785, 0.26494, 0.29523, 0.32993, 0.3697, 0.41529, 0.46755, 0.52742, 0.596,
         0.67432, 0.76357, 0.86507, 0.98022, 1.1105, 1.2576, 1.2875, 1.3243, 1.3342, 21.825, 20.871, 20.011, 16.478,
         13.594, 11.256, 9.4549, 8.132, 7.2103, 6.6139, 6.2771, 6.146, 6.1788, 6.3436, 6.6164, 6.7021, 6.7824, 6.8044,
         6.8637, 6.9503, 7.008, 7.4562, 7.9731, 8.5332, 8.7702, 8.9903, 9.1862, 9.2747, 9.287, 9.2991, 9.311, 9.3228,
         9.3343, 9.3456, 9.3568, 9.3677, 9.3785, 9.389, 9.3994, 9.4095, 9.4195, 9.4292, 9.4388, 9.4481, 9.4572, 9.4661,
         9.4748, 9.4833, 9.4916, 9.4997, 9.5075, 9.5151, 9.5225, 9.5297, 9.5367, 9.5434, 9.5499, 9.5562, 9.5623, 9.5681,
         9.5737, 9.5791, 9.5842, 9.5891, 9.5938, 9.5983, 9.6025, 9.6065, 9.6102, 9.6137, 9.617, 9.62, 9.6228, 9.6254,
         9.6277, 9.6298, 9.6317, 9.6333, 9.6346, 9.6358, 9.6366, 9.6373, 9.6377, 9.6379, 9.6378, 9.6375, 9.6369, 9.6361,
         9.6351, 9.6338, 9.6323, 9.6305, 9.6285, 9.6262, 9.6237, 9.621, 9.618, 9.6148, 9.6114, 9.6077, 9.6038, 9.5996,
         9.5952, 9.5905, 9.5856, 9.5805, 9.5751, 9.5695, 9.5637, 9.5576, 9.5513, 9.5448, 9.538, 9.531, 9.5255, 24.699,
         24.616, 23.763, 22.957, 22.195, 21.476, 20.796, 20.153, 19.546, 18.972, 18.43, 17.917, 17.432, 16.973, 16.54,
         16.13, 15.742, 15.375, 15.028, 14.699, 14.388, 14.097, 13.827, 13.578, 13.348, 13.134, 12.935, 12.75, 12.577,
         12.416, 12.266, 12.125, 11.992, 11.868, 11.751, 11.641, 11.537, 11.439, 11.347, 11.259, 11.176, 11.097, 11.021,
         10.95, 10.882, 10.816, 10.754, 10.694, 10.637, 10.583, 10.53, 10.479, 10.431, 10.384, 10.339, 10.295, 10.253,
         10.212, 10.172, 10.134, 10.097, 10.061, 10.026, 9.9921, 9.959, 9.9268, 9.8954, 9.8648, 9.835, 9.8059, 9.7775,
         9.7497, 9.7226, 9.696, 9.6701, 9.6447, 9.6198, 9.5955, 9.5716, 9.5482, 9.5253, 9.5029, 9.4809, 9.4593, 9.4381,
         9.4173, 9.3969, 9.3769, 9.3573, 9.3381, 9.3192, 9.3007, 9.2825, 9.2647, 9.2472, 9.23, 9.2132, 9.1967, 9.1806,
         9.1648, 9.1492, 9.1341, 9.1192, 9.1046, 9.0904, 9.0765, 9.0628, 9.0495, 9.0365, 9.0238, 9.0115, 8.9994, 8.9877,
         8.9762, 8.9651, 8.9542, 8.9437, 8.9335, 8.9236, 8.914, 8.9047, 8.8958, 8.8871, 8.8788, 8.8707, 8.863, 8.8556,
         8.8485, 8.8417, 8.8352, 8.8334, 9.9758, 9.9751, 9.9735, 9.9722, 9.9711, 9.9705, 9.9701, 9.9701, 9.9704, 9.971,
         9.9719, 9.9732, 9.9748, 9.9767, 9.9789, 9.9814, 9.9843, 9.9874, 9.9909, 9.9947, 9.9988, 10.003, 10.008, 10.013,
         10.018, 10.023, 10.025, 10.36, 10.362, 10.37, 10.378, 10.386, 10.394, 10.403, 10.412, 10.421, 10.43, 10.44,
         10.45, 10.46, 10.47, 10.48, 10.491, 10.501, 10.512, 10.523, 10.535, 10.546, 10.558, 10.569, 10.581, 10.593,
         10.605, 10.618, 10.63, 10.642, 10.655, 10.668, 10.68, 10.693, 10.706, 10.719, 10.732, 10.745, 10.757, 10.77,
         10.783, 10.796, 10.809, 10.822, 10.835, 10.848, 10.861, 10.87, 11.397, 11.4, 11.41, 11.424, 11.438, 11.452,
         11.465, 11.479, 11.492, 11.505, 11.518, 11.531, 11.544, 11.557, 11.569, 11.582, 11.594, 11.606, 11.617, 11.629,
         11.64, 11.651, 11.662, 11.673, 11.683, 11.693, 11.703, 11.713, 11.722, 11.731, 11.739, 11.747, 11.755, 11.763,
         11.77, 11.777, 11.784, 11.79, 11.795, 11.801, 11.806, 11.811, 11.815, 11.819, 11.822, 11.826, 11.828, 11.831,
         11.833, 11.834, 11.835, 11.836, 11.837, 11.837, 11.836, 11.835, 11.834, 11.832, 11.83, 11.828, 11.825, 11.821,
         11.817, 11.813, 11.809, 11.804, 11.798, 11.792, 11.786, 11.779, 11.772, 11.764, 11.756, 11.748, 11.739, 11.73,
         11.72, 11.71, 11.699, 11.689, 11.677, 11.665, 11.653, 11.64, 11.627, 11.613, 11.599, 11.585, 11.569, 11.554,
         11.538, 11.521, 11.504, 11.487, 11.469, 11.451, 11.433, 11.414, 11.394, 11.375, 11.355, 11.334, 11.313, 11.292,
         11.271, 11.249, 11.227, 11.204, 11.181, 11.157, 11.133, 11.109, 11.085, 11.06, 11.035, 11.01, 10.984, 10.959,
         10.933, 10.907, 10.88, 10.853, 10.826, 10.799, 10.772, 10.745, 10.717, 10.689, 10.661, 10.633, 10.604, 10.576,
         10.547, 10.518, 10.489, 10.46, 10.431, 10.402, 10.372, 10.343, 10.313, 10.283, 10.253, 10.223, 10.193, 10.163,
         10.133, 10.103, 10.073, 10.042, 10.012, 9.9813, 9.9508, 9.9203, 9.8897, 9.8591, 9.8285, 9.7979, 9.7672, 9.7366,
         9.7059, 9.6752, 9.6445, 9.6138, 9.5832, 9.5525, 9.5219, 9.4912, 9.4606, 9.43, 9.3995, 9.3689, 9.3384, 9.308,
         9.2776, 9.2472, 9.2168, 9.1789, 9.1261, 9.0736, 9.0214, 8.9696, 8.9182, 8.8671, 8.8164, 8.766, 8.716, 8.6663,
         8.6169, 8.5679, 8.5193, 8.4709, 8.4229, 8.3753, 8.3279, 8.2809, 8.2342, 8.1878, 8.1418, 8.0961, 8.0507, 8.0056,
         7.9608, 7.9163, 7.8721, 7.8283, 7.7847, 7.7415, 7.6985, 7.6548, 7.6105, 7.5666, 7.5229, 7.4795, 7.4365, 7.3938,
         7.3513, 7.3092, 7.2673, 7.2258, 7.1845, 7.1435, 7.1029, 7.0625, 7.0223, 6.9825, 6.943, 6.9037, 6.8647, 6.8469,
         26.489, 26.389, 26.186, 25.985, 25.786, 25.588, 25.392, 25.357, 38.199, 37.98, 37.683, 37.389, 37.097, 36.807,
         36.52, 36.235, 35.952, 35.672, 35.394, 35.118, 34.844, 34.573, 34.303, 34.036, 33.771, 33.509, 33.248, 32.989,
         32.733, 32.479, 32.226, 31.976, 31.728, 31.481, 31.237, 30.995, 30.754, 30.516, 30.279, 30.045, 29.812, 29.581,
         29.352, 29.125, 28.9, 28.676, 28.454, 28.234, 28.016, 27.8, 27.585, 27.372, 27.161, 26.951, 26.75, 26.743,
         31.276, 31.109, 30.853, 30.599, 30.348, 30.098, 29.851, 29.606, 29.362, 29.12, 28.885, 28.668, 28.454, 28.243,
         28.034, 27.829, 27.626, 27.425, 27.227, 27.047, 27.032, 28.861, 28.714, 28.5, 28.289, 28.08, 27.873, 27.669,
         27.467, 27.267, 27.068, 26.875, 26.692, 26.511, 26.332, 26.156, 25.982, 25.811, 25.641, 25.474, 25.308, 25.144,
         24.994, 24.983, 26.064, 26.003, 25.84, 25.678, 25.518, 25.359, 25.202, 25.046, 24.892, 24.739, 24.587, 24.438,
         24.291, 24.143, 23.991, 23.841, 23.691, 23.543, 23.396, 23.25, 23.105, 22.961, 22.818, 22.676, 22.535, 22.395,
         22.255, 22.117, 21.98, 21.843, 21.707, 21.573, 21.438, 21.301, 21.166, 21.031, 20.897, 20.764, 20.632, 20.5,
         20.37, 20.24, 20.111, 19.983, 19.855, 19.728, 19.602, 19.477, 19.351, 19.223, 19.096, 18.97, 18.845, 18.721,
         18.594, 18.469, 18.344, 18.22, 18.096, 17.974, 17.853, 17.732, 17.612, 17.493, 17.376, 17.259, 17.142, 17.027,
         16.913, 16.799, 16.686, 16.572, 16.458, 16.345, 16.234, 16.123, 16.013, 15.903, 15.778, 15.654, 15.531, 15.41,
         15.289, 15.17, 15.051, 14.934, 14.818, 14.703, 14.589, 14.476, 14.364, 14.253, 14.143, 14.035, 13.927, 13.82,
         13.714, 13.609, 13.505, 13.402, 13.296, 13.191, 13.087, 12.984, 12.882, 12.781, 12.681, 12.581, 12.483, 12.385,
         12.289, 12.193, 12.098, 12.004, 11.911, 11.818, 11.727, 11.636, 11.546, 11.455, 11.364, 11.274, 11.186, 11.097,
         11.01, 10.924, 10.838, 10.753, 10.669, 10.585, 10.502, 10.42, 10.339, 10.258, 10.178, 9.9154, 8.9317, 8.055,
         7.2743, 6.578, 5.9509, 5.3613, 4.8341, 4.3657, 3.9446, 3.7521, 3.665, 3.6423, 10.445, 10.238, 10.119, 9.0602,
         8.9898, 8.8326, 8.7742, 12.108, 11.765, 11.478, 11.188, 11.127, 11.115, 12.735, 12.459, 11.649, 10.464, 9.3197,
         8.3321, 7.4556, 6.6764, 5.9834, 5.3666, 4.8016, 4.2936, 3.8318, 3.419, 3.0534, 2.7293, 2.4418, 2.1865, 1.9442,
         1.7255, 1.5327, 1.3618, 1.2085, 1.072, 0.94701, 0.83701, 0.74, 0.65474, 0.62051, 0.60356, 0.59917, 3.3135,
         3.2518, 3.2383, 2.9264, 2.6252, 2.3528, 2.1076, 1.8865, 1.6863, 1.5027, 1.3393, 1.1938, 1.0643, 0.9454,
         0.83942, 0.74538, 0.66194, 0.5879, 0.52218, 0.46385, 0.41207, 0.3661, 0.32528, 0.28903, 0.2572, 0.22971,
         0.20517, 0.18327, 0.16371, 0.14625, 0.13066, 0.11674, 0.10431, 0.093206]],
    'Ho':                                                                                                         [
        [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053,
         0.01948844, 0.019894, 0.0201985, 0.0202797, 0.0204015, 0.020706, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671,
         0.04959809, 0.050176, 0.050944, 0.0511488, 0.051456, 0.052224, 0.05302035, 0.05667876, 0.06058959, 0.06477028,
         0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751,
         0.10201505, 0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778,
         0.10669862, 0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201,
         0.11159722, 0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001,
         0.11672071, 0.11730431, 0.11789083, 0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206,
         0.12207942, 0.12268982, 0.12330327, 0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892,
         0.12768416, 0.12832258, 0.12896419, 0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181,
         0.13354621, 0.13421395, 0.13488502, 0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249,
         0.1396774, 0.14037579, 0.14107766, 0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325,
         0.14609007, 0.14682052, 0.14755462, 0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696,
         0.15279715, 0.15356113, 0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707,
         0.15981215, 0.16061121, 0.16093012, 0.16106987, 0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685,
         0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268,
         0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862, 0.17834591, 0.17923764, 0.18013383,
         0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388,
         0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361,
         0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046,
         0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265,
         0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925,
         0.22658655, 0.22771948, 0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022,
         0.23698927, 0.23817422, 0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364,
         0.24786959, 0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962,
         0.25924942, 0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027,
         0.27115171, 0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895,
         0.28360044, 0.28501845, 0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498,
         0.29662071, 0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.3062977, 0.30690231,
         0.30715946, 0.30869526, 0.31023873, 0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301,
         0.32126133, 0.32286764, 0.32448197, 0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893,
         0.33601062, 0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34311527, 0.34388471, 0.34449531, 0.34621779,
         0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.36031129, 0.36211285,
         0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766,
         0.38063135, 0.3825345, 0.38444718, 0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572,
         0.39810635, 0.40009688, 0.40209737, 0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208,
         0.41638364, 0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339,
         0.43505516, 0.43550006, 0.43634484, 0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947,
         0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309,
         0.47167755, 0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815,
         0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465,
         0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581,
         0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914,
         0.56444734, 0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432,
         0.59036144, 0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331,
         0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046,
         0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262,
         0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924,
         0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251,
         0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746,
         0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212,
         0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764,
         0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843,
         0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232,
         0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072,
         0.96729312, 0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688,
         1.0117021, 1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499,
         1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639,
         1.1178252, 1.1234143, 1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452,
         1.1749909, 1.1808659, 1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354,
         1.2350801, 1.2412555, 1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833,
         1.2982423, 1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3512135,
         1.3515865, 1.3578453, 1.3646345, 1.3714577, 1.378315, 1.3852066, 1.3911646, 1.3918353, 1.3921326, 1.3990933,
         1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4706431,
         1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852,
         1.5535812, 1.5613491, 1.5691559, 1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907,
         1.6330316, 1.6411967, 1.6494027, 1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005,
         1.716545, 1.7251278, 1.7337534, 1.7394239, 1.7424222, 1.742976, 1.7511343, 1.7598899, 1.7686894, 1.7775328,
         1.7864205, 1.7953526, 1.8043294, 1.813351, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361,
         1.8777783, 1.8871672, 1.896603, 1.906086, 1.9156165, 1.9208002, 1.9247997, 1.9251945, 1.9348205, 1.9444946,
         1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0439363,
         2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.106026, 2.1165562, 2.1244052, 2.1271389, 2.1321947,
         2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211,
         2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664,
         2.3620177, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593,
         2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799,
         2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996,
         2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917,
         2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225,
         3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572,
         3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794,
         3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927,
         3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208,
         3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096,
         3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664,
         5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 7.909678, 8.030745, 8.063029, 8.111456,
         8.232522, 8.44789, 8.739444, 8.873211, 8.908882, 8.962389, 9.030794, 9.096156, 9.206316, 9.347229, 9.384806,
         9.441171, 9.582084, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362,
         17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889,
         36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.50534, 54.71721, 55.33961, 55.56208, 55.89579,
         56.73005, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353,
         113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548,
         237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [9.73216, 9.93946, 9.65648, 9.30247, 8.8488, 8.24754, 7.41052, 6.1512, 3.97033, -1.39811, -5.95584, -16.0324,
         -28.5314, -14.9118, -2.86167, -0.410622, 11.2389, 15.5912, 17.6656, 18.601, 18.9102, 18.8728, 18.6521, 18.3458,
         18.0125, 17.6872, 17.3911, 17.1367, 16.9294, 16.8969, 16.8496, 16.8262, 16.8282, 16.8126, 16.7927, 16.739,
         16.7654, 16.9116, 17.1692, 17.5279, 17.9004, 18.2919, 18.7022, 19.1268, 21.6923, 21.7247, 21.757, 21.7893,
         21.8216, 21.8539, 21.8862, 21.9184, 21.9506, 21.9827, 22.0148, 22.0468, 22.0787, 22.1106, 22.1423, 22.174,
         22.2056, 22.237, 22.2684, 22.2995, 22.3306, 22.3615, 22.3922, 22.4228, 22.4531, 22.4833, 22.5132, 22.543,
         22.5724, 22.6017, 22.6306, 22.6592, 22.6876, 22.7156, 22.7433, 22.7706, 22.7975, 22.824, 22.8501, 22.8758,
         22.9009, 22.9256, 22.9497, 22.9733, 22.9962, 23.0186, 23.0402, 23.0612, 23.0814, 23.1008, 23.1194, 23.1371,
         23.1538, 23.1696, 23.1843, 23.1978, 23.2102, 23.2213, 23.2309, 23.2392, 23.2458, 23.2508, 23.2539, 23.2552,
         23.2543, 23.2512, 23.2456, 23.2373, 23.2262, 23.212, 23.1943, 23.1728, 23.1472, 23.117, 23.0817, 23.0408,
         22.9936, 22.9393, 22.8769, 22.8054, 22.7234, 22.6293, 22.5211, 22.3962, 22.2514, 22.0827, 21.8844, 21.6505,
         21.3677, 21.0222, 20.5904, 20.0337, 19.2825, 18.1924, 16.3791, 11.974, 4.52486, 4.76173, 13.2915, 18.8069,
         21.4996, 23.2847, 24.5995, 25.6206, 26.4387, 27.1074, 27.6612, 28.1241, 28.5131, 28.8413, 29.1186, 29.3527,
         29.5498, 29.7151, 29.8524, 29.9651, 30.0557, 30.1258, 30.1778, 30.2159, 30.2432, 30.2623, 30.2749, 30.2824,
         30.2858, 30.2862, 30.2842, 30.2803, 30.2751, 30.2689, 30.262, 30.2548, 30.2473, 30.2399, 30.2325, 30.2254,
         30.2185, 30.2121, 30.206, 30.2005, 30.1954, 30.1908, 30.1868, 30.1832, 30.1802, 30.1778, 30.1758, 30.1743,
         30.1734, 30.1728, 30.1728, 30.1732, 30.174, 30.1752, 30.1767, 30.1786, 30.1809, 30.1834, 30.1863, 30.1894,
         30.1928, 30.1964, 30.2002, 30.2042, 30.2084, 30.2127, 30.2171, 30.2217, 30.2263, 30.231, 30.2358, 30.2406,
         30.2454, 30.2502, 30.255, 30.2598, 30.2645, 30.2692, 30.2737, 30.2782, 30.2825, 30.2868, 30.2908, 30.2947,
         30.2984, 30.3019, 30.3052, 30.3082, 30.311, 30.3135, 30.3157, 30.3176, 30.3191, 30.3203, 30.321, 30.3214,
         30.3213, 30.3207, 30.3196, 30.318, 30.3158, 30.313, 30.3095, 30.3052, 30.3002, 30.2943, 30.2875, 30.2797,
         30.2708, 30.2607, 30.2492, 30.2362, 30.2215, 30.2049, 30.1861, 30.1648, 30.1405, 30.1126, 30.0806, 30.0432,
         29.9991, 29.9462, 29.881, 29.7978, 29.6848, 29.5135, 29.1672, 28.7365, 28.7368, 28.9651, 29.4571, 29.6653,
         29.8008, 29.9022, 29.9837, 30.052, 30.1109, 30.1626, 30.2087, 30.2501, 30.2875, 30.3214, 30.352, 30.3795,
         30.4038, 30.4247, 30.4417, 30.4539, 30.4596, 30.4548, 30.4294, 30.3304, 30.27, 30.2826, 30.3931, 30.5278,
         30.6084, 30.6716, 30.7261, 30.7751, 30.8205, 30.8633, 30.9041, 30.9432, 30.9811, 31.0179, 31.0538, 31.0889,
         31.1234, 31.1573, 31.1907, 31.2236, 31.2561, 31.2882, 31.3199, 31.3513, 31.3824, 31.4132, 31.4437, 31.4738,
         31.5037, 31.5332, 31.5623, 31.5911, 31.6194, 31.6473, 31.6747, 31.7014, 31.7274, 31.7526, 31.7768, 31.7998,
         31.8212, 31.8409, 31.8581, 31.8721, 31.8818, 31.8851, 31.8783, 31.8532, 31.7852, 31.6007, 31.4146, 31.6239,
         31.8338, 31.9973, 32.108, 32.1982, 32.2775, 32.35, 32.418, 32.4828, 32.5452, 32.6058, 32.6649, 32.7229,
         32.7799, 32.8362, 32.8919, 32.9471, 33.0018, 33.0563, 33.1104, 33.1643, 33.2323, 33.2859, 33.3393, 33.3926,
         33.4459, 33.499, 33.552, 33.605, 33.6579, 33.7108, 33.7636, 33.8163, 33.869, 33.9217, 33.9743, 34.0269,
         34.0794, 34.1319, 34.1843, 34.2366, 34.2889, 34.3411, 34.3933, 34.4454, 34.4974, 34.5493, 34.6011, 34.6529,
         34.7045, 34.756, 34.8074, 34.8587, 34.9098, 34.9608, 35.0116, 35.0623, 35.1129, 35.1632, 35.2134, 35.2634,
         35.3132, 35.3627, 35.4121, 35.4613, 35.5102, 35.5588, 35.6073, 35.6554, 35.7034, 35.751, 35.7983, 35.8454,
         35.8922, 35.9386, 35.9848, 36.0306, 36.0761, 36.1213, 36.1661, 36.2106, 36.2546, 36.2983, 36.3416, 36.3845,
         36.4269, 36.4688, 36.5103, 36.5513, 36.5917, 36.6317, 36.6711, 36.71, 36.7484, 36.7862, 36.8234, 36.86, 36.896,
         36.9315, 36.9663, 37.0005, 37.034, 37.0669, 37.0992, 37.1308, 37.1617, 37.192, 37.2215, 37.2502, 37.2782,
         37.3053, 37.3318, 37.3574, 37.3822, 37.4062, 37.4294, 37.4518, 37.4733, 37.494, 37.5138, 37.5327, 37.5508,
         37.568, 37.5843, 37.5997, 37.6141, 37.6276, 37.6402, 37.6518, 37.6625, 37.6721, 37.6808, 37.6885, 37.6951,
         37.7007, 37.7053, 37.7088, 37.7112, 37.7125, 37.7127, 37.7118, 37.7098, 37.7066, 37.7022, 37.6966, 37.6898,
         37.6818, 37.6725, 37.662, 37.6501, 37.6373, 37.6228, 37.607, 37.5897, 37.5711, 37.551, 37.5295, 37.5065,
         37.4819, 37.4559, 37.4282, 37.3989, 37.368, 37.3354, 37.301, 37.265, 37.2271, 37.1944, 37.1717, 37.1444,
         37.1126, 37.0764, 37.0358, 36.9915, 36.9422, 36.8886, 36.8306, 36.7682, 36.7014, 36.6301, 36.5542, 36.4737,
         36.3884, 36.2982, 36.2031, 36.1028, 35.9972, 35.8862, 35.7695, 35.6469, 35.5182, 35.3831, 35.2413, 35.0925,
         34.9364, 34.7725, 34.6005, 34.4198, 34.23, 34.0305, 33.8205, 33.5995, 33.3666, 33.1208, 32.8613, 32.5867,
         32.2959, 31.9872, 31.6591, 31.3092, 30.9354, 30.5348, 30.1041, 29.6396, 29.1364, 28.5886, 27.9891, 27.3285,
         26.5947, 25.7716, 24.8368, 23.7589, 22.4875, 20.9428, 18.9771, 16.2672, 11.8184, -7.94075, -11.1161, -11.4577,
         10.239, 14.073, 15.7145, 16.0735, 14.7112, 3.96765, 3.88801, 6.54188, 17.9314, 21.6526, 24.187, 26.1718,
         27.8253, 29.252, 30.5108, 31.6391, 32.662, 33.5976, 34.4594, 35.2575, 36.0001, 36.6936, 37.3433, 37.9536,
         38.5279, 39.0695, 39.5808, 40.0641, 40.5212, 40.9537, 41.3631, 41.7504, 42.1167, 42.4626, 42.7889, 43.0961,
         43.3842, 43.6536, 43.9041, 44.1353, 44.3466, 44.537, 44.705, 44.8485, 44.9643, 45.0477, 45.0918, 45.0849,
         45.0075, 44.8213, 44.4371, 43.5431, 41.5726, 41.0342, 41.6119, 44.4274, 45.5999, 46.385, 46.9944, 47.4994,
         47.9326, 48.3114, 48.6457, 48.9403, 49.1977, 49.4321, 49.6449, 49.8346, 49.9991, 50.1343, 50.2326, 50.2778,
         50.2299, 49.937, 49.2783, 49.3413, 49.4604, 50.6537, 51.2077, 51.616, 51.9535, 52.2468, 52.5085, 52.7452,
         52.9608, 53.157, 53.3351, 53.5019, 53.6573, 53.8004, 53.93, 54.0439, 54.138, 54.2047, 54.2263, 54.1485,
         53.8523, 53.4378, 53.9589, 54.3759, 54.8132, 55.1226, 55.3804, 55.6091, 55.8188, 56.0145, 56.1996, 56.3761,
         56.5451, 56.7088, 56.8683, 57.0237, 57.1737, 57.3191, 57.4601, 57.5972, 57.7308, 57.861, 57.9882, 58.1124,
         58.234, 58.353, 58.4696, 58.5839, 58.696, 58.8061, 58.9142, 59.0205, 59.1251, 59.2282, 59.3298, 59.4298,
         59.5276, 59.6233, 59.7171, 59.8091, 59.8993, 59.9879, 60.0748, 60.1603, 60.2443, 60.3268, 60.4081, 60.488,
         60.5667, 60.6442, 60.7206, 60.9983, 61.0715, 61.1433, 61.2137, 61.283, 61.4922, 61.5586, 61.6236, 61.6872,
         61.7495, 61.8106, 61.8707, 61.9297, 61.9878, 62.0452, 62.102, 62.1583, 62.2144, 62.2708, 62.3279, 62.3911,
         62.4781, 62.5382, 62.5903, 62.638, 62.6828, 62.7251, 62.7655, 62.804, 62.8409, 62.8762, 62.9101, 62.9427,
         62.974, 63.0041, 63.033, 63.0608, 63.0876, 63.1133, 63.1381, 63.1619, 63.1848, 63.2068, 63.228, 63.2485,
         63.2681, 63.287, 63.3053, 63.3228, 63.3398, 63.459, 63.4754, 63.4908, 63.5051, 63.5186, 63.5312, 63.543,
         63.554, 63.5643, 63.5738, 63.5826, 63.5908, 63.5983, 63.6052, 63.6115, 63.6172, 63.6224, 63.6271, 63.6313,
         63.6349, 63.6885, 63.6917, 63.6941, 63.6959, 63.697, 63.6975, 63.6975, 63.6969, 64.0956, 63.9832, 63.7889,
         63.542, 63.2455, 62.8946, 62.472, 61.9213, 61.1594, 59.9548, 56.9139, 56.8216, 53.8366, 50.3421, 53.8428,
         56.8834, 58.4369, 58.615, 57.5023, 55.8405, 57.7058, 58.8604, 59.4438, 59.999, 59.9731, 59.2505, 60.3395,
         61.5929, 61.9877, 64.0767, 65.2185, 65.9704, 66.4794, 66.8189, 67.0426, 67.1849, 67.3367, 67.3708, 67.4348,
         67.4038, 67.3504, 67.2834, 67.2083, 67.1306, 67.0572, 66.9602, 66.8537, 66.7401, 66.6184, 66.4839, 66.3296,
         66.1395, 65.8829, 65.4662, 64.3897, 64.2184, 63.2423, 61.8682, 63.2566, 64.5109, 65.3995, 66.2164, 66.6288,
         66.8827, 67.0512, 67.1685, 67.2458, 67.2943, 67.3236, 67.3395, 67.3751, 67.3719, 67.3624, 67.3488, 67.3325,
         67.3146, 67.2959, 67.2768, 67.2578, 67.239, 67.2208, 67.2031, 67.1863, 67.1709, 67.1568, 67.1436, 67.1315,
         67.1203, 67.1099, 67.1004, 67.0916],
        [0.29493, 0.32621, 0.36196, 0.40282, 0.44955, 0.50299, 0.56408, 0.63386, 0.71346, 0.80413, 0.83457, 0.85779,
         0.86404, 25.698, 24.583, 24.138, 19.827, 16.295, 13.389, 11.076, 9.2885, 7.9449, 6.9671, 6.2858, 5.844, 5.5958,
         5.5061, 5.548, 5.7012, 5.738, 5.7905, 5.8051, 5.8567, 5.9165, 5.9822, 6.3228, 6.7412, 7.2311, 7.788, 8.0914,
         8.3762, 8.651, 8.9095, 9.1457, 9.2556, 9.2711, 9.2864, 9.3015, 9.3165, 9.3313, 9.3459, 9.3603, 9.3745, 9.3886,
         9.4024, 9.4161, 9.4296, 9.4429, 9.456, 9.4689, 9.4817, 9.4942, 9.5065, 9.5186, 9.5306, 9.5423, 9.5538, 9.5651,
         9.5762, 9.5871, 9.5978, 9.6082, 9.6185, 9.6286, 9.6384, 9.648, 9.6574, 9.6666, 9.6755, 9.6843, 9.6928, 9.7011,
         9.7092, 9.717, 9.7246, 9.732, 9.7392, 9.7462, 9.7529, 9.7594, 9.7656, 9.7717, 9.7774, 9.783, 9.7883, 9.7934,
         9.7983, 9.8029, 9.8073, 9.8115, 9.8154, 9.8191, 9.8226, 9.8258, 9.8287, 9.8315, 9.834, 9.8363, 9.8383, 9.8401,
         9.8416, 9.8429, 9.844, 9.8448, 9.8454, 9.8457, 9.8459, 9.8457, 9.8454, 9.8447, 9.8439, 9.8428, 9.8415, 9.8399,
         9.8381, 9.8361, 9.8338, 9.8313, 9.8285, 9.8255, 9.8223, 9.8188, 9.8151, 9.8111, 9.8069, 9.8025, 9.7979, 9.793,
         9.7878, 9.7825, 9.7803, 24.061, 23.717, 22.947, 22.218, 21.529, 20.877, 20.26, 19.676, 19.124, 18.601, 18.107,
         17.639, 17.195, 16.776, 16.379, 16.003, 15.647, 15.309, 14.99, 14.687, 14.4, 14.134, 13.887, 13.659, 13.447,
         13.251, 13.068, 12.897, 12.738, 12.59, 12.451, 12.321, 12.199, 12.084, 11.976, 11.874, 11.778, 11.687, 11.601,
         11.52, 11.443, 11.369, 11.3, 11.233, 11.17, 11.109, 11.052, 10.996, 10.943, 10.892, 10.844, 10.797, 10.752,
         10.708, 10.666, 10.626, 10.587, 10.549, 10.512, 10.477, 10.443, 10.409, 10.377, 10.345, 10.315, 10.285, 10.256,
         10.228, 10.201, 10.174, 10.148, 10.122, 10.097, 10.073, 10.049, 10.026, 10.003, 9.9804, 9.9586, 9.9372, 9.9163,
         9.8958, 9.8757, 9.8561, 9.8368, 9.8179, 9.7994, 9.7812, 9.7634, 9.746, 9.7289, 9.7122, 9.6958, 9.6798, 9.664,
         9.6486, 9.6335, 9.6188, 9.6043, 9.5902, 9.5764, 9.5629, 9.5496, 9.5367, 9.5242, 9.5119, 9.4999, 9.4882, 9.4768,
         9.4657, 9.455, 9.4445, 9.4343, 9.4244, 9.4148, 9.4056, 9.3966, 9.3879, 9.3795, 9.3714, 9.3637, 9.3562, 9.349,
         9.3421, 9.3356, 9.3293, 9.3233, 9.3176, 9.3123, 9.3072, 9.3051, 10.468, 10.468, 10.468, 10.468, 10.468, 10.469,
         10.47, 10.471, 10.473, 10.475, 10.477, 10.479, 10.482, 10.485, 10.489, 10.492, 10.496, 10.501, 10.505, 10.51,
         10.515, 10.521, 10.527, 10.533, 10.534, 10.869, 10.872, 10.88, 10.888, 10.897, 10.906, 10.915, 10.924, 10.933,
         10.943, 10.953, 10.963, 10.974, 10.984, 10.995, 11.006, 11.017, 11.028, 11.039, 11.051, 11.063, 11.074, 11.086,
         11.098, 11.111, 11.123, 11.135, 11.148, 11.161, 11.173, 11.186, 11.199, 11.212, 11.225, 11.237, 11.25, 11.263,
         11.276, 11.289, 11.302, 11.315, 11.328, 11.341, 11.354, 11.367, 11.38, 11.392, 11.405, 11.415, 11.417, 11.943,
         11.952, 11.965, 11.979, 11.992, 12.005, 12.018, 12.031, 12.043, 12.056, 12.068, 12.08, 12.092, 12.104, 12.116,
         12.127, 12.138, 12.149, 12.16, 12.17, 12.18, 12.19, 12.2, 12.209, 12.218, 12.226, 12.235, 12.243, 12.25,
         12.258, 12.265, 12.271, 12.278, 12.283, 12.289, 12.294, 12.299, 12.303, 12.307, 12.311, 12.314, 12.317, 12.32,
         12.322, 12.323, 12.324, 12.325, 12.326, 12.326, 12.325, 12.324, 12.323, 12.321, 12.319, 12.317, 12.314, 12.31,
         12.306, 12.302, 12.297, 12.292, 12.287, 12.281, 12.274, 12.267, 12.26, 12.252, 12.244, 12.235, 12.226, 12.217,
         12.207, 12.197, 12.186, 12.175, 12.163, 12.151, 12.139, 12.126, 12.113, 12.099, 12.085, 12.07, 12.055, 12.039,
         12.023, 12.006, 11.989, 11.972, 11.954, 11.935, 11.917, 11.897, 11.878, 11.858, 11.837, 11.817, 11.795, 11.774,
         11.752, 11.73, 11.707, 11.684, 11.661, 11.637, 11.613, 11.589, 11.564, 11.539, 11.513, 11.488, 11.461, 11.435,
         11.409, 11.382, 11.355, 11.327, 11.3, 11.272, 11.244, 11.216, 11.188, 11.159, 11.13, 11.101, 11.072, 11.043,
         11.014, 10.984, 10.955, 10.925, 10.895, 10.865, 10.834, 10.804, 10.774, 10.743, 10.713, 10.682, 10.651, 10.62,
         10.589, 10.558, 10.527, 10.496, 10.465, 10.434, 10.403, 10.371, 10.34, 10.309, 10.277, 10.246, 10.214, 10.183,
         10.152, 10.12, 10.089, 10.057, 10.026, 9.9944, 9.963, 9.9316, 9.9002, 9.8689, 9.8375, 9.8063, 9.7664, 9.7094,
         9.6527, 9.5965, 9.5407, 9.4853, 9.4303, 9.3756, 9.3213, 9.2674, 9.2139, 9.1608, 9.108, 9.0556, 9.0036, 8.9519,
         8.9005, 8.8496, 8.799, 8.7487, 8.6988, 8.6492, 8.6, 8.5511, 8.5026, 8.4544, 8.4065, 8.359, 8.3118, 8.2649,
         8.2183, 8.1721, 8.1262, 8.0806, 8.0353, 7.9904, 7.9457, 7.9014, 7.8574, 7.8137, 7.7702, 7.7264, 7.6817, 7.6374,
         7.5934, 7.5497, 7.5063, 7.4632, 7.4204, 7.3779, 7.3357, 7.2939, 7.2523, 7.211, 7.17, 7.1292, 7.0888, 7.0486,
         7.0088, 6.9692, 6.9299, 6.9291, 26.506, 26.318, 26.116, 25.916, 25.718, 25.52, 25.352, 38.17, 38.158, 37.86,
         37.564, 37.271, 36.98, 36.692, 36.406, 36.122, 35.84, 35.561, 35.284, 35.01, 34.737, 34.467, 34.199, 33.933,
         33.669, 33.407, 33.148, 32.89, 32.635, 32.382, 32.13, 31.881, 31.634, 31.389, 31.145, 30.904, 30.665, 30.427,
         30.192, 29.958, 29.726, 29.497, 29.268, 29.042, 28.818, 28.595, 28.374, 28.154, 27.936, 27.719, 27.505, 27.292,
         27.08, 26.943, 31.568, 31.55, 31.301, 31.037, 30.775, 30.515, 30.257, 30.002, 29.749, 29.498, 29.248, 29.013,
         28.792, 28.574, 28.359, 28.148, 27.939, 27.733, 27.53, 27.329, 27.131, 27.025, 28.854, 28.845, 28.626, 28.411,
         28.198, 27.987, 27.779, 27.573, 27.37, 27.169, 26.97, 26.78, 26.597, 26.417, 26.24, 26.065, 25.892, 25.721,
         25.552, 25.386, 25.221, 25.1, 25.058, 26.163, 26.076, 25.912, 25.749, 25.588, 25.429, 25.271, 25.114, 24.959,
         24.805, 24.653, 24.504, 24.356, 24.205, 24.053, 23.901, 23.751, 23.602, 23.454, 23.308, 23.162, 23.017, 22.873,
         22.73, 22.589, 22.448, 22.308, 22.169, 22.03, 21.893, 21.757, 21.621, 21.486, 21.35, 21.214, 21.078, 20.944,
         20.81, 20.677, 20.545, 20.414, 20.283, 20.153, 20.024, 19.896, 19.769, 19.642, 19.516, 19.391, 19.263, 19.136,
         19.01, 18.885, 18.76, 18.636, 18.51, 18.385, 18.261, 18.138, 18.016, 17.895, 17.774, 17.655, 17.537, 17.419,
         17.302, 17.187, 17.072, 16.958, 16.844, 16.713, 16.583, 16.452, 16.322, 16.194, 16.067, 15.941, 15.816, 15.693,
         15.57, 15.449, 15.329, 15.21, 15.092, 14.975, 14.859, 14.744, 14.63, 14.518, 14.406, 14.295, 14.185, 14.077,
         13.969, 13.862, 13.757, 13.652, 13.548, 13.445, 13.342, 13.237, 13.133, 13.03, 12.928, 12.827, 12.727, 12.627,
         12.529, 12.431, 12.335, 12.239, 12.144, 12.05, 11.956, 11.864, 11.772, 11.681, 11.591, 11.502, 11.413, 11.323,
         11.234, 11.146, 11.058, 10.972, 10.886, 10.8, 10.52, 9.4779, 8.5432, 7.711, 6.9692, 6.307, 5.7, 5.1362, 4.6345,
         4.1893, 3.7812, 3.776, 3.6885, 3.6658, 10.452, 10.119, 9.5635, 9.0214, 8.805, 8.7477, 12.075, 11.899, 11.735,
         11.465, 11.132, 11.049, 12.653, 12.348, 12.198, 10.941, 9.8237, 8.8246, 7.9097, 7.0859, 6.3487, 5.69, 5.0967,
         4.557, 4.0737, 3.6352, 3.2468, 2.9024, 2.5968, 2.3254, 2.0677, 1.8352, 1.6301, 1.4491, 1.2871, 1.1426, 1.0121,
         0.89477, 0.79118, 0.70001, 0.62421, 0.61983, 0.60722, 0.60281, 3.3013, 3.2271, 3.079, 2.765, 2.4787, 2.2211,
         1.989, 1.7786, 1.5856, 1.4137, 1.2606, 1.1242, 1.0012, 0.88923, 0.78989, 0.70172, 0.62345, 0.55395, 0.49225,
         0.43746, 0.38879, 0.34557, 0.30718, 0.27307, 0.24378, 0.2179, 0.19478, 0.17413, 0.15567, 0.13919, 0.12445,
         0.11128, 0.099514]],
    'Er':                                                                                                         [
        [0.004214, 0.0042785, 0.0042957, 0.0043215, 0.004386, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.028812, 0.02908327, 0.029253, 0.0293706, 0.029547, 0.029988, 0.03109002, 0.03323523, 0.03552846,
         0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.058604, 0.059501,
         0.0597402, 0.060099, 0.06058959, 0.060996, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368,
         0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294,
         0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712,
         0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956,
         0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029,
         0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979,
         0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902,
         0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944,
         0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305,
         0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239,
         0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058,
         0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134,
         0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16751369, 0.16768632, 0.16798497,
         0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726,
         0.17657574, 0.17660087, 0.17679912, 0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967,
         0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263,
         0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888, 0.19902907,
         0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661,
         0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366,
         0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948,
         0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422,
         0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893,
         0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567,
         0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747,
         0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845,
         0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381,
         0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873, 0.31178993,
         0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32033919, 0.32126133, 0.32286764, 0.32448197,
         0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913,
         0.34107602, 0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022,
         0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36576056, 0.36663944, 0.36757174,
         0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718,
         0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737,
         0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789,
         0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756, 0.43986595,
         0.44206528, 0.4442756, 0.44649698, 0.44843083, 0.44872947, 0.44976915, 0.45097311, 0.45322798, 0.45549412,
         0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612,
         0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782,
         0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444,
         0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691, 0.54508094,
         0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56726958, 0.57010592,
         0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325, 0.59627982,
         0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526, 0.62365537,
         0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253, 0.65228775,
         0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045, 0.68223466,
         0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641, 0.71355644,
         0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322, 0.74631623,
         0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656, 0.78058004,
         0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515, 0.81641693,
         0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084, 0.8538991,
         0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881, 0.8931021,
         0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765, 0.93410494,
         0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959, 0.97699023,
         0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606, 1.0218444,
         1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017,
         1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143, 1.1290314,
         1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1867702,
         1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555, 1.2474618,
         1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335, 1.3112571,
         1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577, 1.378315,
         1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.409097, 1.4095029, 1.4131192, 1.4201848, 1.4272857, 1.4344221,
         1.4415942, 1.4488022, 1.4529192, 1.4536808, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132,
         1.5002773, 1.5077787, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559,
         1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6494027,
         1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278, 1.7337534,
         1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.8098795, 1.813351,
         1.8137205, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672, 1.896603,
         1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955,
         2.0035635, 2.0036337, 2.0079663, 2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489,
         2.0851227, 2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519,
         2.1917561, 2.2022856, 2.2027149, 2.2107145, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279,
         2.280976, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697,
         2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4952257, 2.5077018,
         2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829, 2.6228319, 2.635946,
         2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486,
         2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451,
         2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879,
         3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477,
         3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514,
         3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962,
         3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247,
         3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452,
         3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453,
         6.469004, 6.915365, 7.392525, 7.902609, 8.190742, 8.31611, 8.349542, 8.399689, 8.44789, 8.525058, 9.030794,
         9.079014, 9.217979, 9.255036, 9.310622, 9.449586, 9.556274, 9.653919, 9.702543, 9.741549, 9.800056, 9.946326,
         10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215,
         21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992,
         44.79101, 47.88159, 51.18542, 54.71721, 56.33579, 57.19807, 57.42801, 57.77293, 58.4927, 58.63521, 62.5287,
         66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669,
         139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869,
         290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [11.3349, 11.2763, 11.2116, 11.2735, 11.3244, 10.926, 10.8355, 10.7304, 11.014, 10.8707, 10.7017, 10.5009,
         10.2594, 9.96477, 9.59762, 9.12687, 8.498, 7.60417, 6.19628, 3.47413, -3.98499, -7.97707, -13.2047, -24.7216,
         -12.0411, -0.820267, 8.00407, 14.1917, 16.7708, 17.8228, 18.109, 18.0104, 17.7364, 17.4051, 17.0826, 16.8045,
         16.6851, 16.6278, 16.6014, 16.6008, 16.5898, 16.5783, 16.496, 16.4964, 16.6185, 16.892, 17.3191, 17.7819,
         18.2536, 20.7708, 20.8075, 20.8444, 20.8813, 20.9183, 20.9554, 20.9925, 21.0297, 21.067, 21.1043, 21.1417,
         21.1791, 21.2165, 21.254, 21.2915, 21.3291, 21.3666, 21.4042, 21.4417, 21.4793, 21.5168, 21.5543, 21.5918,
         21.6293, 21.6668, 21.7041, 21.7415, 21.7787, 21.8159, 21.8531, 21.8901, 21.927, 21.9638, 22.0005, 22.037,
         22.0734, 22.1096, 22.1457, 22.1816, 22.2173, 22.2528, 22.288, 22.323, 22.3578, 22.3922, 22.4264, 22.4603,
         22.4938, 22.527, 22.5598, 22.5922, 22.6242, 22.6557, 22.6868, 22.7173, 22.7473, 22.7768, 22.8056, 22.8338,
         22.8614, 22.8882, 22.9142, 22.9394, 22.9638, 22.9872, 23.0097, 23.0311, 23.0514, 23.0705, 23.0883, 23.1047,
         23.1197, 23.1331, 23.1448, 23.1547, 23.1626, 23.1683, 23.1717, 23.1726, 23.1707, 23.1658, 23.1576, 23.1458,
         23.1299, 23.1095, 23.0842, 23.0532, 23.0158, 22.9713, 22.9186, 22.8563, 22.7829, 22.6965, 22.5945, 22.4735,
         22.3291, 22.1551, 21.9426, 21.6779, 21.3391, 20.8872, 20.2424, 19.1976, 16.8073, 12.7085, 12.8511, 16.9178,
         20.202, 21.697, 22.632, 23.2653, 23.6915, 23.9468, 24.03, 23.8895, 23.3199, 20.3429, 19.9814, 20.134, 23.9084,
         25.554, 26.5431, 27.2564, 27.8061, 28.2463, 28.606, 28.9034, 29.1503, 29.3557, 29.5275, 29.672, 29.7938,
         29.8966, 29.9834, 30.0563, 30.1174, 30.168, 30.2094, 30.2423, 30.2681, 30.2886, 30.3049, 30.318, 30.3287,
         30.3374, 30.3447, 30.3508, 30.3562, 30.3609, 30.3653, 30.3695, 30.3736, 30.3778, 30.382, 30.3864, 30.391,
         30.3958, 30.4009, 30.4064, 30.4121, 30.4182, 30.4246, 30.4313, 30.4384, 30.4457, 30.4534, 30.4613, 30.4695,
         30.478, 30.4868, 30.4957, 30.5049, 30.5143, 30.5239, 30.5336, 30.5434, 30.5534, 30.5635, 30.5737, 30.584,
         30.5943, 30.6047, 30.615, 30.6254, 30.6358, 30.6461, 30.6564, 30.6666, 30.6767, 30.6868, 30.6967, 30.7064,
         30.7161, 30.7255, 30.7348, 30.7438, 30.7526, 30.7612, 30.7695, 30.7776, 30.7853, 30.7927, 30.7997, 30.8064,
         30.8127, 30.8186, 30.824, 30.829, 30.8334, 30.8373, 30.8406, 30.8433, 30.8453, 30.8466, 30.8471, 30.8468,
         30.8456, 30.8434, 30.8401, 30.8356, 30.8299, 30.8227, 30.8138, 30.8032, 30.7905, 30.7754, 30.7576, 30.7365,
         30.7116, 30.6819, 30.6463, 30.6031, 30.5497, 30.4818, 30.3915, 30.2622, 30.046, 29.3972, 29.4022, 29.901,
         30.2189, 30.3963, 30.5222, 30.621, 30.7031, 30.7738, 30.8362, 30.8922, 30.9432, 30.9899, 31.0332, 31.0734,
         31.111, 31.146, 31.1788, 31.2093, 31.2376, 31.2635, 31.2869, 31.3075, 31.3245, 31.3368, 31.3425, 31.3371,
         31.3077, 31.17, 31.1662, 31.1807, 31.316, 31.4363, 31.5149, 31.5786, 31.6344, 31.6853, 31.7328, 31.7778,
         31.821, 31.8627, 31.9031, 31.9424, 31.9809, 32.0186, 32.0557, 32.0921, 32.1279, 32.1632, 32.198, 32.2323,
         32.2661, 32.2994, 32.3322, 32.3645, 32.3962, 32.4272, 32.4576, 32.4872, 32.5159, 32.5436, 32.57, 32.5948,
         32.6178, 32.6384, 32.6558, 32.6689, 32.6758, 32.673, 32.6529, 32.5932, 32.4053, 32.3132, 32.4302, 32.6227,
         32.7958, 32.9111, 33.0047, 33.0871, 33.1625, 33.2332, 33.3006, 33.3656, 33.4287, 33.4903, 33.5507, 33.6101,
         33.6688, 33.7269, 33.7844, 33.8415, 33.8983, 33.9547, 34.0109, 34.0669, 34.1227, 34.192, 34.2476, 34.3031,
         34.3584, 34.4137, 34.4689, 34.524, 34.579, 34.634, 34.689, 34.7439, 34.8116, 34.8665, 34.9213, 34.976, 35.0307,
         35.0853, 35.1399, 35.1944, 35.2489, 35.3032, 35.3575, 35.4118, 35.4659, 35.52, 35.5739, 35.6278, 35.6815,
         35.7351, 35.7886, 35.8419, 35.8951, 35.9482, 36.0011, 36.0539, 36.1064, 36.1588, 36.211, 36.263, 36.3148,
         36.3664, 36.4178, 36.4689, 36.5198, 36.5705, 36.6209, 36.671, 36.7208, 36.7704, 36.8197, 36.8687, 36.9173,
         36.9657, 37.0137, 37.0614, 37.1088, 37.1558, 37.2024, 37.2487, 37.2946, 37.3401, 37.3852, 37.4298, 37.4741,
         37.5178, 37.5612, 37.604, 37.6464, 37.6883, 37.7297, 37.7705, 37.8108, 37.8506, 37.8898, 37.9284, 37.9665,
         38.0039, 38.0408, 38.077, 38.1126, 38.1476, 38.1819, 38.2156, 38.2485, 38.2808, 38.3123, 38.343, 38.373,
         38.4022, 38.4306, 38.4582, 38.485, 38.5111, 38.5363, 38.5606, 38.5842, 38.6069, 38.6287, 38.6497, 38.6698,
         38.689, 38.7073, 38.7247, 38.7412, 38.7567, 38.7713, 38.785, 38.7977, 38.8094, 38.8201, 38.8298, 38.8386,
         38.8463, 38.8529, 38.8585, 38.8631, 38.8665, 38.8689, 38.8702, 38.8703, 38.8693, 38.8672, 38.8639, 38.8594,
         38.8537, 38.8467, 38.8386, 38.8291, 38.8184, 38.8064, 38.7929, 38.7782, 38.7622, 38.7448, 38.726, 38.7057,
         38.684, 38.6607, 38.6781, 38.7605, 38.8201, 38.862, 38.8895, 38.9049, 38.9099, 38.906, 38.8941, 38.875,
         38.8493, 38.8175, 38.78, 38.7372, 38.6892, 38.6362, 38.5784, 38.5159, 38.4487, 38.378, 38.3015, 38.2205,
         38.1347, 38.0443, 37.949, 37.8488, 37.7437, 37.6333, 37.5177, 37.3966, 37.2698, 37.1371, 36.9982, 36.8529,
         36.701, 36.5419, 36.3755, 36.2012, 36.0187, 35.8274, 35.6267, 35.4162, 35.195, 34.9624, 34.7177, 34.4597,
         34.1875, 33.8997, 33.595, 33.2718, 32.9281, 32.5616, 32.17, 31.75, 31.2982, 30.8101, 30.2806, 29.7029, 29.0689,
         28.3678, 27.5859, 26.7029, 25.6921, 24.5128, 23.1005, 21.3426, 19.0125, 15.5226, 8.03916, -9.27823, -9.62017,
         8.49489, 14.5127, 16.9061, 17.9144, 17.7593, 15.3518, 6.05814, 5.98292, 14.4499, 20.8507, 24.0594, 26.366,
         28.2119, 29.768, 31.1205, 32.32, 33.399, 34.38, 35.2792, 36.1088, 36.8781, 37.5947, 38.2644, 38.8921, 39.4818,
         40.037, 40.5605, 41.0546, 41.5215, 41.9628, 42.38, 42.7745, 43.1472, 43.499, 43.8306, 44.1425, 44.435, 44.7083,
         44.9622, 45.1965, 45.4105, 45.6033, 45.7732, 45.9182, 46.035, 46.1189, 46.1625, 46.1543, 46.0738, 45.8818,
         45.485, 44.5513, 42.6606, 42.3695, 42.7054, 45.5466, 46.716, 47.5047, 48.1184, 48.6274, 49.0644, 49.4466,
         49.7839, 50.0811, 50.3408, 50.5784, 50.7951, 50.9898, 51.1607, 51.305, 51.417, 51.4853, 51.4844, 51.3397,
         50.5184, 50.5004, 50.5651, 51.4684, 52.1751, 52.6349, 52.9986, 53.3076, 53.5797, 53.8235, 54.0442, 54.2441,
         54.4238, 54.5884, 54.741, 54.8801, 55.0036, 55.1081, 55.1871, 55.2263, 55.186, 54.8733, 54.8392, 54.9879,
         55.2349, 55.7415, 56.0726, 56.3423, 56.5792, 56.7951, 56.9959, 57.1853, 57.3655, 57.5378, 57.704, 57.8655,
         58.0232, 58.177, 58.3257, 58.4699, 58.6099, 58.7462, 58.8791, 59.0087, 59.1353, 59.2591, 59.3802, 59.4988,
         59.6151, 59.7291, 59.8409, 59.9507, 60.0586, 60.1646, 60.2689, 60.3715, 60.4727, 60.5725, 60.6703, 60.766,
         60.8597, 60.9517, 61.0419, 61.1305, 61.2175, 61.303, 61.387, 61.4697, 61.551, 61.631, 61.7099, 61.7876,
         61.8643, 62.151, 62.2255, 62.2989, 62.3712, 62.4424, 62.5128, 62.7315, 62.8009, 62.8699, 62.9388, 63.0083,
         63.0795, 63.155, 63.2207, 63.2811, 63.3383, 63.3929, 63.4452, 63.4955, 63.5439, 63.5904, 63.6352, 63.6785,
         63.7201, 63.7602, 63.7989, 63.8361, 63.872, 63.9066, 63.9399, 63.9721, 64.0031, 64.033, 64.0618, 64.0896,
         64.1163, 64.142, 64.1668, 64.1907, 64.2137, 64.2358, 64.2571, 64.2776, 64.2973, 64.3163, 64.3346, 64.3522,
         64.3692, 64.3855, 64.4013, 64.5202, 64.5356, 64.55, 64.5634, 64.5759, 64.5876, 64.5985, 64.6087, 64.6181,
         64.6267, 64.6348, 64.6421, 64.6489, 64.655, 64.6606, 64.6656, 64.6701, 64.6741, 64.6776, 64.6807, 65.1585,
         65.0633, 64.9252, 64.707, 64.4383, 64.1184, 63.7384, 63.2673, 62.6355, 61.7181, 60.0572, 57.8968, 54.9282,
         51.4509, 54.9359, 56.6313, 57.9659, 59.8477, 59.7452, 58.6124, 56.949, 58.8004, 60.5211, 61.0405, 61.1845,
         61.0288, 60.3128, 61.3998, 62.6541, 64.1771, 65.693, 66.6121, 67.2371, 67.6565, 67.9349, 68.1159, 68.2286,
         68.355, 68.4065, 68.4211, 68.3798, 68.3214, 68.253, 68.1838, 68.1129, 68.017, 67.9127, 67.8019, 67.6845,
         67.557, 67.4143, 67.2454, 67.0286, 66.7132, 66.0951, 65.4055, 64.2643, 62.8976, 64.279, 65.4056, 65.5268,
         66.9049, 67.4553, 67.7716, 67.9759, 68.1195, 68.212, 68.2714, 68.3086, 68.3301, 68.3409, 68.3712, 68.3646,
         68.3529, 68.338, 68.321, 68.3027, 68.2839, 68.265, 68.2463, 68.2279, 68.2101, 68.1928, 68.1769, 68.1622,
         68.1487, 68.1363, 68.1247, 68.1141, 68.1042, 68.0951],
        [0.0, 0.0, 0.0, 0.12433, 0.12488, 0.28242, 0.31136, 0.3445, 0.38246, 0.42594, 0.47574, 0.53277, 0.59806,
         0.67274, 0.75803, 0.85526, 0.96593, 1.0916, 1.2341, 1.3952, 1.55, 1.5769, 1.5937, 1.6055, 24.533, 23.362,
         20.782, 16.869, 13.748, 11.346, 9.5843, 8.3567, 7.5582, 7.0975, 6.9015, 6.9136, 6.9842, 7.0288, 7.0418, 7.0928,
         7.1229, 7.1492, 7.4422, 7.8749, 8.4045, 9.0191, 9.4355, 9.7393, 10.03, 10.169, 10.189, 10.209, 10.229, 10.248,
         10.268, 10.287, 10.306, 10.325, 10.343, 10.362, 10.38, 10.398, 10.416, 10.434, 10.452, 10.469, 10.486, 10.503,
         10.52, 10.537, 10.553, 10.569, 10.585, 10.601, 10.617, 10.632, 10.647, 10.662, 10.677, 10.691, 10.706, 10.72,
         10.734, 10.747, 10.761, 10.774, 10.787, 10.799, 10.812, 10.824, 10.836, 10.848, 10.859, 10.871, 10.882, 10.892,
         10.903, 10.913, 10.923, 10.933, 10.942, 10.952, 10.961, 10.969, 10.978, 10.986, 10.994, 11.002, 11.009, 11.016,
         11.023, 11.03, 11.036, 11.043, 11.048, 11.054, 11.059, 11.064, 11.069, 11.074, 11.078, 11.082, 11.086, 11.089,
         11.092, 11.095, 11.098, 11.1, 11.102, 11.104, 11.105, 11.106, 11.107, 11.108, 11.108, 11.108, 11.108, 11.108,
         11.107, 11.106, 11.105, 11.103, 11.101, 11.099, 11.097, 11.094, 11.091, 11.088, 11.085, 11.081, 11.077, 11.073,
         11.068, 11.066, 19.211, 19.05, 18.615, 18.203, 17.812, 17.442, 17.091, 16.759, 16.444, 16.145, 15.861, 15.593,
         15.585, 20.764, 20.369, 19.863, 19.384, 18.93, 18.499, 18.089, 17.701, 17.333, 16.984, 16.655, 16.346, 16.057,
         15.784, 15.528, 15.287, 15.059, 14.845, 14.642, 14.451, 14.271, 14.103, 13.945, 13.799, 13.661, 13.532, 13.411,
         13.297, 13.19, 13.089, 12.993, 12.903, 12.817, 12.736, 12.659, 12.586, 12.516, 12.449, 12.385, 12.324, 12.266,
         12.21, 12.156, 12.104, 12.055, 12.007, 11.961, 11.916, 11.873, 11.831, 11.791, 11.752, 11.714, 11.677, 11.642,
         11.607, 11.573, 11.54, 11.508, 11.477, 11.446, 11.416, 11.387, 11.359, 11.331, 11.303, 11.277, 11.251, 11.225,
         11.2, 11.175, 11.151, 11.127, 11.104, 11.081, 11.059, 11.037, 11.015, 10.994, 10.973, 10.953, 10.933, 10.913,
         10.893, 10.874, 10.855, 10.837, 10.819, 10.801, 10.784, 10.767, 10.75, 10.733, 10.717, 10.701, 10.686, 10.67,
         10.655, 10.641, 10.626, 10.612, 10.598, 10.585, 10.572, 10.559, 10.546, 10.534, 10.522, 10.51, 10.499, 10.488,
         10.477, 10.467, 10.456, 10.447, 10.437, 10.428, 10.419, 10.41, 10.402, 11.582, 11.58, 11.576, 11.573, 11.57,
         11.567, 11.565, 11.563, 11.561, 11.56, 11.558, 11.558, 11.557, 11.557, 11.557, 11.557, 11.558, 11.559, 11.56,
         11.561, 11.563, 11.565, 11.568, 11.57, 11.573, 11.576, 11.579, 11.583, 11.583, 11.915, 11.918, 11.924, 11.93,
         11.936, 11.942, 11.948, 11.955, 11.962, 11.969, 11.976, 11.984, 11.991, 11.999, 12.007, 12.015, 12.023, 12.032,
         12.04, 12.049, 12.058, 12.067, 12.076, 12.085, 12.094, 12.103, 12.112, 12.122, 12.131, 12.14, 12.15, 12.159,
         12.169, 12.178, 12.188, 12.197, 12.207, 12.216, 12.226, 12.235, 12.244, 12.252, 12.254, 12.777, 12.782, 12.793,
         12.803, 12.813, 12.823, 12.833, 12.842, 12.852, 12.861, 12.871, 12.88, 12.889, 12.897, 12.906, 12.914, 12.923,
         12.931, 12.939, 12.946, 12.953, 12.961, 12.967, 12.974, 12.98, 12.986, 12.992, 12.997, 13.002, 13.007, 13.011,
         13.015, 13.019, 13.022, 13.025, 13.028, 13.03, 13.032, 13.033, 13.035, 13.035, 13.036, 13.036, 13.035, 13.034,
         13.033, 13.031, 13.029, 13.027, 13.024, 13.021, 13.017, 13.013, 13.008, 13.003, 12.998, 12.992, 12.986, 12.979,
         12.972, 12.965, 12.957, 12.948, 12.94, 12.93, 12.921, 12.911, 12.9, 12.889, 12.878, 12.866, 12.854, 12.841,
         12.828, 12.815, 12.801, 12.786, 12.772, 12.757, 12.741, 12.725, 12.709, 12.692, 12.675, 12.657, 12.639, 12.62,
         12.601, 12.582, 12.562, 12.542, 12.521, 12.5, 12.478, 12.457, 12.434, 12.411, 12.388, 12.365, 12.341, 12.317,
         12.292, 12.267, 12.242, 12.216, 12.19, 12.163, 12.136, 12.109, 12.081, 12.053, 12.025, 11.997, 11.968, 11.939,
         11.91, 11.88, 11.85, 11.821, 11.79, 11.76, 11.729, 11.699, 11.668, 11.637, 11.605, 11.574, 11.542, 11.511,
         11.479, 11.447, 11.414, 11.382, 11.35, 11.317, 11.285, 11.252, 11.219, 11.186, 11.154, 11.121, 11.088, 11.054,
         11.021, 10.988, 10.955, 10.922, 10.888, 10.855, 10.822, 10.788, 10.755, 10.722, 10.688, 10.655, 10.621, 10.588,
         10.555, 10.522, 10.488, 10.455, 10.412, 10.35, 10.288, 10.227, 10.166, 10.106, 10.046, 9.9865, 9.9274, 9.8688,
         9.8106, 9.7528, 9.6955, 9.6386, 9.582, 9.5259, 9.4702, 9.4149, 9.36, 9.3055, 9.2514, 9.1977, 9.1444, 9.0914,
         9.0388, 8.9866, 8.9347, 8.8832, 8.8321, 8.7813, 8.7309, 8.6809, 8.6312, 8.5819, 8.5329, 8.4843, 8.436, 8.3881,
         8.3405, 8.2933, 8.2464, 8.1998, 8.1536, 8.1076, 8.0621, 8.0168, 7.9719, 7.9272, 7.8829, 7.839, 7.7938, 7.7486,
         7.7038, 7.6593, 7.6151, 7.5713, 7.5277, 7.4845, 7.4416, 7.399, 7.3567, 7.3147, 7.273, 7.2316, 7.1905, 7.1496,
         7.1091, 7.0689, 7.0289, 7.0119, 26.576, 26.471, 26.268, 26.066, 25.866, 25.668, 25.471, 25.36, 38.139, 38.042,
         37.746, 37.451, 37.158, 36.868, 36.58, 36.295, 36.011, 35.73, 35.452, 35.175, 34.901, 34.629, 34.36, 34.092,
         33.827, 33.564, 33.302, 33.043, 32.787, 32.532, 32.279, 32.028, 31.78, 31.533, 31.288, 31.046, 30.805, 30.566,
         30.329, 30.095, 29.862, 29.63, 29.401, 29.174, 28.948, 28.724, 28.502, 28.282, 28.064, 27.847, 27.632, 27.419,
         27.207, 27.078, 31.752, 31.741, 31.481, 31.213, 30.947, 30.683, 30.421, 30.162, 29.906, 29.651, 29.398, 29.16,
         28.938, 28.718, 28.502, 28.289, 28.079, 27.871, 27.665, 27.463, 27.263, 27.065, 27.064, 28.901, 28.777, 28.558,
         28.342, 28.128, 27.917, 27.709, 27.502, 27.298, 27.097, 26.899, 26.715, 26.533, 26.353, 26.177, 26.002, 25.83,
         25.66, 25.492, 25.332, 25.326, 26.387, 26.341, 26.174, 26.008, 25.844, 25.682, 25.521, 25.362, 25.204, 25.048,
         24.893, 24.741, 24.591, 24.442, 24.29, 24.137, 23.984, 23.833, 23.683, 23.535, 23.387, 23.24, 23.094, 22.95,
         22.806, 22.663, 22.521, 22.38, 22.24, 22.101, 21.962, 21.825, 21.688, 21.552, 21.416, 21.279, 21.143, 21.007,
         20.873, 20.739, 20.606, 20.474, 20.342, 20.212, 20.082, 19.953, 19.825, 19.697, 19.571, 19.445, 19.318, 19.191,
         19.064, 18.939, 18.814, 18.689, 18.565, 18.44, 18.317, 18.194, 18.072, 17.951, 17.83, 17.691, 17.553, 17.416,
         17.281, 17.146, 17.013, 16.881, 16.751, 16.621, 16.492, 16.364, 16.237, 16.111, 15.986, 15.862, 15.739, 15.618,
         15.497, 15.378, 15.259, 15.142, 15.025, 14.909, 14.794, 14.68, 14.567, 14.456, 14.345, 14.235, 14.127, 14.019,
         13.912, 13.806, 13.702, 13.598, 13.495, 13.393, 13.291, 13.187, 13.084, 12.981, 12.88, 12.779, 12.68, 12.581,
         12.483, 12.386, 12.29, 12.195, 12.101, 12.007, 11.914, 11.823, 11.732, 11.641, 11.552, 11.463, 11.166, 10.057,
         9.0625, 8.1745, 7.3833, 6.6775, 6.0465, 5.4548, 4.9195, 4.4427, 4.0175, 3.8007, 3.7129, 3.6901, 10.444, 10.315,
         10.115, 9.0727, 8.9917, 8.7652, 8.7063, 12.022, 11.691, 11.445, 11.224, 11.116, 11.033, 12.628, 12.323, 11.592,
         10.376, 9.3223, 8.3663, 7.4967, 6.7173, 6.0205, 5.3984, 4.8304, 4.3214, 3.8614, 3.449, 3.0834, 2.759, 2.4708,
         2.1971, 1.9502, 1.7322, 1.54, 1.3696, 1.2165, 1.0801, 0.95556, 0.84529, 0.74787, 0.66218, 0.62805, 0.611,
         0.60658, 3.2906, 3.2283, 3.2162, 2.9062, 2.6074, 2.3374, 2.095, 1.8742, 1.6714, 1.4907, 1.3298, 1.1863, 1.0585,
         0.94103, 0.83621, 0.74314, 0.66049, 0.58709, 0.52189, 0.46397, 0.41252, 0.3668, 0.32617, 0.29007, 0.25839,
         0.23113, 0.20676, 0.18498, 0.1655, 0.14808, 0.1325, 0.11857, 0.10611]],
    'Tm':                                                                                                         [
        [0.005194, 0.0052735, 0.0052947, 0.0053265, 0.005406, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.031654, 0.0321385, 0.0322677, 0.0324615, 0.032946, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.052136, 0.052934, 0.05302035,
         0.0531468, 0.053466, 0.054264, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411,
         0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775,
         0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827,
         0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598,
         0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083,
         0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327,
         0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419,
         0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502,
         0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766,
         0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462,
         0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894,
         0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427,
         0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489,
         0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574,
         0.17745862, 0.17834591, 0.17923764, 0.17946997, 0.17949044, 0.17970956, 0.17973003, 0.18013383, 0.1810345,
         0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459,
         0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888,
         0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096,
         0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046,
         0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655,
         0.22771948, 0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927,
         0.23817422, 0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959,
         0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942,
         0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171,
         0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044,
         0.28501845, 0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071,
         0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873,
         0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197,
         0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33621965, 0.33698036,
         0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706,
         0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174,
         0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718,
         0.38540604, 0.38636941, 0.38639394, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635,
         0.40009688, 0.40209737, 0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364,
         0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006,
         0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412,
         0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47099246, 0.47167755, 0.47240756,
         0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254,
         0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172,
         0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074,
         0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734,
         0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144,
         0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528,
         0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347,
         0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314,
         0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404,
         0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867,
         0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324,
         0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358,
         0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373,
         0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762,
         0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348,
         0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312,
         0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021,
         1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407,
         1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252,
         1.1234143, 1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909,
         1.1808659, 1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801,
         1.2412555, 1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423,
         1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345,
         1.3714577, 1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221,
         1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4674798, 1.4679202, 1.4706431, 1.4779963, 1.4853863, 1.4928132,
         1.5002773, 1.5077787, 1.5141684, 1.5150317, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812,
         1.5613491, 1.5691559, 1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316,
         1.6411967, 1.6494027, 1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545,
         1.7251278, 1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294,
         1.813351, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8824082, 1.8865918,
         1.8871672, 1.896603, 1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081,
         1.9836772, 1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489,
         2.0851227, 2.0874384, 2.0921614, 2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058,
         2.1700018, 2.1808519, 2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279,
         2.280976, 2.2923809, 2.3022094, 2.3038428, 2.3113904, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177,
         2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116,
         2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829,
         2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476,
         2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376,
         2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021,
         3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008,
         3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408,
         3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061,
         3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299,
         3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602,
         3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467,
         5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 8.47504, 8.60476, 8.639352, 8.69124,
         8.82096, 9.030794, 9.424561, 9.568814, 9.607282, 9.653919, 9.664983, 9.809237, 9.913386, 10.06512, 10.10558,
         10.16628, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398,
         20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543,
         41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.20181, 58.4927, 59.09265, 59.33021, 59.68655, 60.57739,
         62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587,
         130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699,
         271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [10.5318, 10.4639, 10.3894, 10.4604, 10.5184, 10.2397, 10.162, 10.0721, 9.9679, 9.84691, 9.70585, 10.2087,
         10.0135, 9.78076, 9.49946, 9.15334, 8.71683, 8.14646, 7.361, 6.18552, 4.13989, -1.07371, -4.94686, -14.4758,
         -26.4192, -13.2016, -1.50865, 1.71508, 12.0535, 15.6441, 17.0816, 17.5084, 17.4405, 17.1456, 16.8602, 16.7592,
         16.7457, 16.7187, 16.7026, 16.6351, 16.4141, 16.1064, 15.8667, 15.7111, 15.6505, 15.6952, 15.8582, 16.1588,
         16.6281, 19.091, 19.1424, 19.1938, 19.2449, 19.296, 19.347, 19.3979, 19.4486, 19.4993, 19.55, 19.6005, 19.651,
         19.7015, 19.7519, 19.8022, 19.8525, 19.9028, 19.953, 20.0032, 20.0533, 20.1034, 20.1535, 20.2035, 20.2535,
         20.3035, 20.3534, 20.4033, 20.4531, 20.5029, 20.5526, 20.6023, 20.6519, 20.7014, 20.7509, 20.8003, 20.8496,
         20.8989, 20.948, 20.9971, 21.046, 21.0948, 21.1436, 21.1921, 21.2406, 21.2889, 21.337, 21.385, 21.4328,
         21.4804, 21.5278, 21.575, 21.6219, 21.6686, 21.7151, 21.7612, 21.8071, 21.8527, 21.898, 21.9429, 21.9874,
         22.0316, 22.0753, 22.1187, 22.1615, 22.2039, 22.2458, 22.2871, 22.3279, 22.368, 22.4075, 22.4464, 22.4845,
         22.5218, 22.5583, 22.594, 22.6288, 22.6625, 22.6953, 22.7269, 22.7573, 22.7865, 22.8143, 22.8407, 22.8655,
         22.8887, 22.9101, 22.9295, 22.9469, 22.962, 22.9747, 22.9847, 22.9918, 22.9957, 22.9962, 22.9944, 22.9868,
         22.9746, 22.9572, 22.934, 22.9042, 22.8671, 22.8215, 22.7663, 22.7, 22.6207, 22.5262, 22.4134, 22.2785,
         22.1165, 21.9205, 21.6808, 21.3833, 21.006, 20.513, 19.8386, 18.845, 17.1548, 12.7504, 8.81247, 8.13869,
         8.41529, 9.13343, 15.2124, 19.7264, 22.0462, 23.6141, 24.7851, 25.7057, 26.4522, 27.07, 27.5885, 28.0278,
         28.4029, 28.7246, 29.0014, 29.2401, 29.4459, 29.6232, 29.7754, 29.9052, 30.0149, 30.1058, 30.1799, 30.2412,
         30.2925, 30.3359, 30.3731, 30.4052, 30.4334, 30.4584, 30.4808, 30.5012, 30.52, 30.5376, 30.5542, 30.5702,
         30.5857, 30.6009, 30.6158, 30.6307, 30.6456, 30.6606, 30.6758, 30.6911, 30.7066, 30.7224, 30.7384, 30.7547,
         30.7713, 30.7881, 30.8053, 30.8227, 30.8403, 30.8582, 30.8763, 30.8947, 30.9133, 30.932, 30.951, 30.9701,
         30.9894, 31.0088, 31.0283, 31.0479, 31.0676, 31.0873, 31.1071, 31.1269, 31.1468, 31.1666, 31.1864, 31.2062,
         31.2259, 31.2455, 31.265, 31.2845, 31.3038, 31.3229, 31.342, 31.3608, 31.3795, 31.3979, 31.4162, 31.4342,
         31.4519, 31.4694, 31.4866, 31.5035, 31.52, 31.5363, 31.5521, 31.5676, 31.5827, 31.5973, 31.6115, 31.6252,
         31.6384, 31.6511, 31.6632, 31.6747, 31.6856, 31.6958, 31.7053, 31.7141, 31.722, 31.729, 31.7351, 31.7401,
         31.744, 31.7468, 31.7481, 31.748, 31.7462, 31.7426, 31.7369, 31.7288, 31.7179, 31.7038, 31.6858, 31.6631,
         31.6346, 31.5986, 31.5527, 31.4927, 31.4116, 31.2942, 31.0997, 30.6005, 30.4348, 30.4405, 30.849, 31.2216,
         31.4195, 31.559, 31.6687, 31.7604, 31.8399, 31.9106, 31.9746, 32.0333, 32.0876, 32.1383, 32.1859, 32.2307,
         32.273, 32.3129, 32.3506, 32.3861, 32.4194, 32.4503, 32.4785, 32.5035, 32.5246, 32.5402, 32.5474, 32.5391,
         32.489, 32.3946, 32.4074, 32.4131, 32.6148, 32.7137, 32.7893, 32.8543, 32.9132, 32.9681, 33.0201, 33.07,
         33.1182, 33.1649, 33.2106, 33.2552, 33.299, 33.3421, 33.3845, 33.4262, 33.4674, 33.508, 33.5481, 33.5877,
         33.6267, 33.6652, 33.7031, 33.7404, 33.777, 33.8129, 33.848, 33.8822, 33.9152, 33.9469, 33.977, 34.0052,
         34.0308, 34.0532, 34.0709, 34.0821, 34.0828, 34.0642, 33.9988, 33.8336, 33.2805, 33.8619, 34.0908, 34.2537,
         34.3692, 34.4655, 34.5515, 34.6309, 34.7059, 34.7778, 34.8473, 34.9149, 34.9811, 35.0462, 35.1103, 35.1736,
         35.2363, 35.2985, 35.3602, 35.4215, 35.4825, 35.5433, 35.6038, 35.6641, 35.7242, 35.7842, 35.8441, 35.9038,
         36.0, 36.0596, 36.1191, 36.1785, 36.2378, 36.297, 36.3562, 36.4152, 36.4742, 36.5332, 36.592, 36.6508, 36.7095,
         36.7681, 36.8266, 36.885, 36.9433, 37.0015, 37.0597, 37.1177, 37.1756, 37.2334, 37.291, 37.3485, 37.4059,
         37.4632, 37.5202, 37.5772, 37.6339, 37.6905, 37.7469, 37.8031, 37.8591, 37.9149, 37.9704, 38.0258, 38.0809,
         38.1358, 38.1905, 38.2449, 38.299, 38.3529, 38.4065, 38.4599, 38.5129, 38.5656, 38.6181, 38.6702, 38.722,
         38.7735, 38.8247, 38.8755, 38.926, 38.9761, 39.0259, 39.0753, 39.1244, 39.1731, 39.2214, 39.2693, 39.3168,
         39.3638, 39.4105, 39.4566, 39.5024, 39.5476, 39.5924, 39.6366, 39.6804, 39.7236, 39.7663, 39.8085, 39.8502,
         39.8913, 39.9319, 39.9719, 40.0114, 40.0503, 40.0886, 40.1264, 40.1635, 40.2, 40.2359, 40.2711, 40.3058,
         40.3397, 40.3731, 40.4058, 40.4379, 40.4694, 40.5002, 40.5304, 40.56, 40.589, 40.6174, 40.6451, 40.6722,
         40.6988, 40.7247, 40.7501, 40.7749, 40.7991, 40.8227, 40.8459, 40.8685, 40.8906, 40.9122, 40.9334, 40.9541,
         40.9744, 40.9943, 41.0139, 41.0331, 41.0521, 41.0708, 41.0894, 41.1079, 41.1263, 41.1448, 41.1634, 41.1822,
         41.2014, 41.221, 41.2412, 41.2515, 41.2383, 41.223, 41.2037, 41.1816, 41.1566, 41.1288, 41.0983, 41.0651,
         41.0293, 40.9908, 40.9497, 40.9059, 40.8595, 40.8104, 40.7587, 40.7042, 40.647, 40.5871, 40.5243, 40.4586,
         40.3901, 40.3185, 40.2439, 40.1661, 40.0851, 40.0008, 39.9131, 39.8219, 39.7271, 39.6269, 39.5244, 39.4179,
         39.3073, 39.1922, 39.0726, 38.9483, 38.819, 38.6846, 38.5447, 38.3992, 38.2476, 38.0898, 37.9253, 37.7537,
         37.5747, 37.3878, 37.1925, 36.9883, 36.7744, 36.5503, 36.3152, 36.0682, 35.8083, 35.5346, 35.2458, 34.9405,
         34.6172, 34.2739, 33.9086, 33.5188, 33.1015, 32.6531, 32.1695, 31.6455, 31.0748, 30.4494, 29.759, 28.9902,
         28.1245, 27.1371, 25.9882, 24.6188, 22.9259, 20.7073, 17.4624, 11.102, -7.6274, -7.97086, 8.04023, 15.368,
         18.063, 19.2819, 19.4196, 17.9223, 7.84877, 7.78268, 9.89537, 20.9882, 24.6248, 27.0972, 29.0321, 30.6439,
         32.0345, 33.2616, 34.3615, 35.3588, 36.271, 37.1112, 37.8892, 38.613, 39.2887, 39.9216, 40.5157, 41.0746,
         41.6013, 42.0982, 42.5674, 43.0107, 43.4297, 43.8256, 44.1996, 44.5524, 44.8848, 45.1973, 45.4903, 45.7638,
         46.0179, 46.252, 46.4657, 46.6579, 46.8271, 46.9709, 47.086, 47.1676, 47.2079, 47.1947, 47.1065, 46.9006,
         46.4731, 45.4244, 43.804, 43.85, 44.2318, 46.7542, 47.8491, 48.6072, 49.2042, 49.7033, 50.1343, 50.5134,
         50.8498, 51.1481, 51.4118, 51.6542, 51.8756, 52.0754, 52.2523, 52.4038, 52.5249, 52.606, 52.6266, 52.5309,
         52.0407, 51.6756, 51.7443, 52.353, 53.1829, 53.6739, 54.0531, 54.3726, 54.6529, 54.9043, 55.1323, 55.34,
         55.5284, 55.7004, 55.8613, 56.0099, 56.1451, 56.2648, 56.3654, 56.4399, 56.473, 56.4203, 56.1306, 55.9885,
         56.2497, 56.5389, 57.0159, 57.3383, 57.6033, 57.837, 58.0503, 58.2491, 58.4366, 58.6151, 58.7858, 58.9506,
         59.111, 59.2668, 59.4173, 59.5631, 59.7047, 59.8424, 59.9765, 60.1072, 60.2349, 60.3597, 60.4817, 60.6011,
         60.7181, 60.8327, 60.9452, 61.0555, 61.1638, 61.2702, 61.3748, 61.4777, 61.579, 61.6788, 61.7768, 61.8728,
         61.9669, 62.0592, 62.1499, 62.239, 62.3265, 62.4126, 62.4974, 62.5808, 62.663, 62.7441, 62.8241, 62.9032,
         62.9813, 63.2813, 63.3587, 63.4355, 63.512, 63.5908, 63.6825, 63.9106, 63.9821, 64.05, 64.1148, 64.1769,
         64.2364, 64.2936, 64.3486, 64.4016, 64.4526, 64.5018, 64.5492, 64.5949, 64.639, 64.6816, 64.7227, 64.7624,
         64.8007, 64.8378, 64.8736, 64.9081, 64.9416, 64.9739, 65.0051, 65.0351, 65.0641, 65.092, 65.1188, 65.1447,
         65.1696, 65.1936, 65.2168, 65.239, 65.2605, 65.2811, 65.301, 65.3201, 65.3386, 65.3563, 65.3734, 65.3899,
         65.4057, 65.421, 65.4358, 65.5572, 65.5716, 65.585, 65.5975, 65.6091, 65.6199, 65.6299, 65.6392, 65.6478,
         65.6557, 65.6629, 65.6695, 66.1088, 66.1107, 66.0094, 65.8258, 65.587, 65.2974, 64.9529, 64.539, 64.0048,
         63.2653, 62.104, 59.2839, 58.9756, 56.0429, 52.593, 56.0824, 59.0778, 60.3859, 60.7158, 59.5927, 57.9397,
         59.4809, 59.791, 61.5257, 62.0369, 62.0671, 61.364, 62.4607, 63.7534, 66.1062, 67.2118, 67.9569, 68.4675,
         68.8093, 69.035, 69.1791, 69.3315, 69.3678, 69.403, 69.4058, 69.3572, 69.2964, 69.233, 69.164, 69.0712,
         68.9695, 68.8613, 68.7471, 68.6254, 68.4912, 68.3377, 68.1488, 67.8932, 67.4763, 66.421, 66.1954, 65.2863,
         63.9276, 65.3004, 66.5405, 67.44, 68.2358, 68.6397, 68.8894, 69.0612, 69.1715, 69.2436, 69.2898, 69.318,
         69.3333, 69.3682, 69.3651, 69.3557, 69.3424, 69.3265, 69.309, 69.2906, 69.2719, 69.2532, 69.2348, 69.2169,
         69.1994, 69.1828, 69.1677, 69.1538, 69.141, 69.1291, 69.1182, 69.1081, 69.0987],
        [0.0, 0.0, 0.0, 0.14292, 0.14344, 0.25905, 0.28489, 0.31469, 0.349, 0.38849, 0.4339, 0.48611, 0.54609, 0.61496,
         0.694, 0.7846, 0.88828, 1.0065, 1.1409, 1.2935, 1.4661, 1.6608, 1.7174, 1.7665, 1.7797, 25.575, 24.276, 23.547,
         18.798, 15.152, 12.365, 10.336, 8.9323, 8.0236, 7.6007, 7.5087, 7.4997, 7.487, 7.4917, 7.4271, 7.3118, 7.3198,
         7.5089, 7.8428, 8.2953, 8.8472, 9.4845, 10.197, 10.976, 11.363, 11.39, 11.416, 11.443, 11.469, 11.495, 11.521,
         11.547, 11.573, 11.598, 11.624, 11.649, 11.674, 11.699, 11.723, 11.747, 11.772, 11.796, 11.819, 11.843, 11.866,
         11.89, 11.912, 11.935, 11.958, 11.98, 12.002, 12.024, 12.045, 12.067, 12.088, 12.109, 12.129, 12.149, 12.17,
         12.189, 12.209, 12.228, 12.247, 12.266, 12.285, 12.303, 12.321, 12.338, 12.356, 12.373, 12.39, 12.406, 12.423,
         12.439, 12.454, 12.47, 12.485, 12.5, 12.514, 12.528, 12.542, 12.556, 12.569, 12.582, 12.595, 12.607, 12.619,
         12.631, 12.643, 12.654, 12.665, 12.675, 12.685, 12.695, 12.705, 12.714, 12.723, 12.731, 12.74, 12.748, 12.755,
         12.762, 12.769, 12.776, 12.782, 12.788, 12.794, 12.799, 12.804, 12.809, 12.813, 12.817, 12.821, 12.824, 12.827,
         12.829, 12.832, 12.834, 12.835, 12.836, 12.837, 12.838, 12.838, 12.838, 12.838, 12.837, 12.836, 12.834, 12.832,
         12.83, 12.828, 12.825, 12.822, 12.819, 12.815, 12.811, 12.806, 12.801, 12.796, 12.791, 12.785, 12.779, 12.777,
         12.777, 25.45, 25.435, 25.131, 24.482, 23.866, 23.281, 22.726, 22.199, 21.699, 21.224, 20.772, 20.344, 19.937,
         19.55, 19.183, 18.833, 18.501, 18.186, 17.886, 17.6, 17.329, 17.071, 16.83, 16.607, 16.4, 16.207, 16.027,
         15.858, 15.701, 15.554, 15.415, 15.285, 15.163, 15.048, 14.939, 14.836, 14.738, 14.646, 14.558, 14.475, 14.395,
         14.319, 14.247, 14.177, 14.111, 14.047, 13.986, 13.927, 13.87, 13.816, 13.763, 13.712, 13.663, 13.615, 13.569,
         13.524, 13.481, 13.438, 13.397, 13.357, 13.318, 13.28, 13.242, 13.206, 13.17, 13.135, 13.101, 13.068, 13.035,
         13.003, 12.971, 12.94, 12.909, 12.879, 12.85, 12.821, 12.792, 12.764, 12.737, 12.709, 12.683, 12.656, 12.63,
         12.604, 12.579, 12.554, 12.529, 12.505, 12.481, 12.457, 12.434, 12.411, 12.388, 12.366, 12.344, 12.322, 12.301,
         12.279, 12.258, 12.238, 12.217, 12.197, 12.178, 12.158, 12.139, 12.12, 12.101, 12.083, 12.065, 12.047, 12.029,
         12.012, 11.995, 11.979, 11.962, 11.946, 11.93, 11.915, 11.9, 11.885, 11.87, 11.856, 11.842, 11.828, 11.814,
         11.801, 11.788, 11.775, 11.774, 12.97, 12.967, 12.959, 12.951, 12.944, 12.937, 12.93, 12.924, 12.918, 12.912,
         12.907, 12.902, 12.897, 12.892, 12.888, 12.884, 12.88, 12.877, 12.874, 12.871, 12.868, 12.866, 12.864, 12.862,
         12.86, 12.859, 12.858, 12.857, 12.856, 13.185, 13.185, 13.186, 13.187, 13.189, 13.191, 13.193, 13.195, 13.197,
         13.2, 13.202, 13.205, 13.208, 13.211, 13.215, 13.218, 13.222, 13.225, 13.229, 13.233, 13.237, 13.241, 13.245,
         13.249, 13.254, 13.258, 13.262, 13.267, 13.271, 13.276, 13.28, 13.285, 13.289, 13.294, 13.298, 13.303, 13.307,
         13.312, 13.316, 13.32, 13.324, 13.327, 13.329, 13.846, 13.85, 13.855, 13.86, 13.865, 13.869, 13.874, 13.878,
         13.883, 13.887, 13.891, 13.895, 13.898, 13.902, 13.905, 13.908, 13.911, 13.913, 13.916, 13.918, 13.92, 13.921,
         13.923, 13.924, 13.924, 13.925, 13.925, 13.924, 13.924, 13.923, 13.922, 13.92, 13.918, 13.916, 13.913, 13.91,
         13.907, 13.903, 13.899, 13.895, 13.89, 13.885, 13.879, 13.873, 13.867, 13.86, 13.852, 13.845, 13.837, 13.828,
         13.82, 13.81, 13.8, 13.79, 13.78, 13.769, 13.757, 13.745, 13.733, 13.72, 13.707, 13.694, 13.68, 13.666, 13.651,
         13.636, 13.62, 13.604, 13.588, 13.571, 13.554, 13.536, 13.518, 13.499, 13.481, 13.461, 13.442, 13.422, 13.401,
         13.38, 13.359, 13.338, 13.316, 13.293, 13.271, 13.248, 13.224, 13.2, 13.176, 13.151, 13.126, 13.1, 13.074,
         13.047, 13.021, 12.993, 12.966, 12.938, 12.909, 12.881, 12.852, 12.822, 12.793, 12.763, 12.733, 12.702, 12.671,
         12.64, 12.608, 12.576, 12.544, 12.511, 12.479, 12.446, 12.413, 12.38, 12.346, 12.312, 12.279, 12.245, 12.211,
         12.176, 12.142, 12.107, 12.073, 12.038, 12.003, 11.968, 11.933, 11.897, 11.862, 11.827, 11.791, 11.756, 11.72,
         11.685, 11.649, 11.613, 11.578, 11.542, 11.506, 11.47, 11.434, 11.399, 11.363, 11.327, 11.291, 11.256, 11.22,
         11.184, 11.149, 11.102, 11.034, 10.966, 10.898, 10.831, 10.765, 10.699, 10.634, 10.569, 10.505, 10.441, 10.378,
         10.315, 10.253, 10.191, 10.129, 10.068, 10.008, 9.9479, 9.8884, 9.8293, 9.7706, 9.7124, 9.6547, 9.5973, 9.5404,
         9.484, 9.4279, 9.3723, 9.3171, 9.2623, 9.208, 9.154, 9.1004, 9.0473, 8.9945, 8.9421, 8.8901, 8.8385, 8.7873,
         8.7365, 8.686, 8.6359, 8.5862, 8.5369, 8.4879, 8.4393, 8.391, 8.3431, 8.2955, 8.2483, 8.2015, 8.155, 8.1088,
         8.063, 8.0175, 7.9723, 7.9275, 7.883, 7.8388, 7.7937, 7.7484, 7.7035, 7.6589, 7.6146, 7.5707, 7.5271, 7.4837,
         7.4408, 7.3981, 7.3557, 7.3137, 7.2719, 7.2305, 7.1894, 7.1485, 7.108, 7.0851, 26.608, 26.532, 26.329, 26.127,
         25.926, 25.727, 25.53, 25.364, 38.095, 38.084, 37.787, 37.493, 37.201, 36.912, 36.624, 36.338, 36.055, 35.774,
         35.496, 35.219, 34.945, 34.673, 34.404, 34.136, 33.871, 33.608, 33.347, 33.088, 32.831, 32.577, 32.324, 32.073,
         31.825, 31.578, 31.334, 31.091, 30.851, 30.612, 30.375, 30.14, 29.907, 29.676, 29.447, 29.22, 28.994, 28.771,
         28.549, 28.329, 28.11, 27.894, 27.679, 27.466, 27.255, 27.151, 31.766, 31.75, 31.488, 31.229, 30.971, 30.714,
         30.46, 30.209, 29.959, 29.712, 29.466, 29.235, 29.014, 28.797, 28.583, 28.371, 28.162, 27.956, 27.753, 27.552,
         27.353, 27.157, 27.113, 28.924, 28.854, 28.638, 28.425, 28.214, 28.006, 27.8, 27.596, 27.394, 27.194, 26.996,
         26.811, 26.629, 26.45, 26.273, 26.098, 25.925, 25.754, 25.585, 25.418, 25.276, 25.253, 26.325, 26.267, 26.1,
         25.934, 25.77, 25.608, 25.447, 25.288, 25.129, 24.972, 24.816, 24.663, 24.511, 24.357, 24.202, 24.048, 23.896,
         23.744, 23.594, 23.445, 23.297, 23.15, 23.003, 22.858, 22.714, 22.571, 22.428, 22.287, 22.146, 22.007, 21.868,
         21.73, 21.592, 21.456, 21.318, 21.181, 21.045, 20.91, 20.776, 20.642, 20.509, 20.377, 20.246, 20.116, 19.987,
         19.858, 19.731, 19.604, 19.478, 19.352, 19.225, 19.098, 18.973, 18.847, 18.704, 18.561, 18.416, 18.271, 18.129,
         17.987, 17.847, 17.708, 17.57, 17.434, 17.299, 17.165, 17.032, 16.901, 16.77, 16.641, 16.513, 16.387, 16.261,
         16.137, 16.013, 15.891, 15.77, 15.648, 15.527, 15.407, 15.288, 15.171, 15.054, 14.938, 14.824, 14.71, 14.597,
         14.486, 14.375, 14.266, 14.157, 14.05, 13.943, 13.838, 13.733, 13.63, 13.527, 13.425, 13.324, 13.223, 13.119,
         13.017, 12.916, 12.815, 12.715, 12.617, 12.519, 12.422, 12.326, 12.23, 12.136, 11.825, 10.658, 9.6063, 8.6601,
         7.8175, 7.0662, 6.3955, 5.7885, 5.2191, 4.711, 4.2584, 3.8477, 3.8287, 3.7405, 3.7176, 10.419, 9.9983, 9.5496,
         9.0035, 8.8174, 8.7676, 12.105, 12.082, 11.774, 11.552, 11.228, 11.143, 12.729, 12.408, 10.996, 9.8298, 8.8364,
         7.9243, 7.1023, 6.3661, 5.708, 5.1161, 4.5777, 4.0962, 3.6598, 3.2721, 2.928, 2.6224, 2.3318, 2.0697, 1.8385,
         1.6344, 1.4542, 1.2928, 1.1489, 1.019, 0.90164, 0.79799, 0.70656, 0.63175, 0.62608, 0.61465, 0.61021, 3.2783,
         3.205, 3.0529, 2.7418, 2.4583, 2.2038, 1.9726, 1.7598, 1.5702, 1.4011, 1.2505, 1.1162, 0.99475, 0.88429,
         0.78617, 0.699, 0.62156, 0.55275, 0.49159, 0.43724, 0.38893, 0.34599, 0.30781, 0.27387, 0.24486, 0.21921,
         0.19626, 0.17572, 0.15735, 0.1409, 0.12618, 0.11301]],
    'Yb':                                                                                                         [
        [0.006174, 0.0062685, 0.0062937, 0.0063315, 0.006426, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.022932, 0.023283,
         0.0233766, 0.023517, 0.0238073, 0.023868, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523,
         0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.0538295, 0.0540459,
         0.0543705, 0.055182, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368,
         0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294,
         0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712,
         0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956,
         0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029,
         0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979,
         0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902,
         0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944,
         0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305,
         0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239,
         0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058,
         0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134,
         0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902,
         0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862,
         0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18476613,
         0.18503387, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031,
         0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19791478, 0.19803888, 0.19828522, 0.19902907,
         0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661,
         0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366,
         0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948,
         0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422,
         0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893,
         0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567,
         0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747,
         0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845,
         0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381,
         0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873, 0.31178993,
         0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438,
         0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602,
         0.3427814, 0.34308435, 0.34391562, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425,
         0.35496022, 0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096,
         0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718, 0.38636941,
         0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39615652, 0.39724347, 0.39810635, 0.40009688,
         0.40209737, 0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556,
         0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756,
         0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159,
         0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815,
         0.48118209, 0.483588, 0.48600594, 0.48646432, 0.48793566, 0.48843597, 0.49087815, 0.49333254, 0.4957992,
         0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163,
         0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691,
         0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56726958,
         0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325,
         0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526,
         0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253,
         0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045,
         0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641,
         0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322,
         0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656,
         0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515,
         0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084,
         0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881,
         0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765,
         0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959,
         0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606,
         1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579,
         1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143,
         1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659,
         1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555,
         1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335,
         1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577,
         1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942,
         1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176,
         1.5228942, 1.5275616, 1.5280383, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5758114,
         1.5767887, 1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967,
         1.6494027, 1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278,
         1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.813351,
         1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672, 1.896603, 1.906086,
         1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9475382, 1.9520618, 1.9542171, 1.9639882, 1.9738081, 1.9836772,
         1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227,
         2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.170436, 2.1755642,
         2.1808519, 2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.280976,
         2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3931119,
         2.3976254, 2.4030879, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4952257,
         2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829, 2.6228319,
         2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476, 2.7569638,
         2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553,
         2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571,
         3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938,
         3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856,
         3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072,
         3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311,
         3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075,
         3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855,
         6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 8.764728, 8.898882, 8.934656, 8.988318, 9.030794,
         9.122472, 9.653919, 9.778636, 9.928309, 9.968222, 10.02809, 10.17776, 10.27667, 10.32004, 10.43397, 10.47591,
         10.53883, 10.69613, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398,
         20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543,
         41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 60.10565, 61.02564, 61.27097, 61.63896, 62.5287,
         62.55894, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587,
         130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699,
         271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [8.70177, 8.61958, 8.53448, 8.6115, 8.66995, 8.08034, 7.90296, 7.68974, 7.43114, 7.11351, 6.71672, 6.20942,
         5.53952, 4.61228, 3.33375, 0.989324, -4.40734, -11.2079, -23.2927, -38.3698, -21.8016, -8.64846, -7.13978,
         8.7862, 14.2828, 16.6838, 17.6344, 17.8325, 17.6392, 17.2551, 16.7932, 16.3169, 15.8609, 15.4428, 15.0639,
         14.9722, 14.9329, 14.9244, 14.8735, 14.769, 14.537, 14.3639, 14.2565, 14.2383, 14.2782, 14.4017, 14.6183,
         14.9408, 17.1539, 17.1878, 17.2224, 17.2578, 17.294, 17.331, 17.3688, 17.4075, 17.447, 17.4874, 17.5286,
         17.5708, 17.6138, 17.6578, 17.7027, 17.7485, 17.7954, 17.8432, 17.8921, 17.942, 17.9929, 18.045, 18.0981,
         18.1524, 18.2078, 18.2644, 18.3222, 18.3813, 18.4416, 18.5032, 18.5662, 18.6305, 18.6962, 18.7634, 18.8325,
         18.9028, 18.9727, 19.0423, 19.1115, 19.1804, 19.2489, 19.3172, 19.3852, 19.4528, 19.5202, 19.5873, 19.6541,
         19.7206, 19.7869, 19.8529, 19.9186, 19.984, 20.0492, 20.1141, 20.1787, 20.243, 20.3071, 20.3708, 20.4343,
         20.4974, 20.5602, 20.6227, 20.6849, 20.7467, 20.8082, 20.8693, 20.93, 20.9904, 21.0503, 21.1098, 21.1688,
         21.2274, 21.2855, 21.343, 21.4001, 21.4566, 21.5125, 21.5677, 21.6223, 21.6763, 21.7295, 21.782, 21.8336,
         21.8844, 21.9343, 21.9833, 22.0312, 22.0781, 22.1238, 22.1683, 22.2115, 22.2533, 22.2936, 22.3323, 22.3693,
         22.4044, 22.4376, 22.4685, 22.4987, 22.5247, 22.548, 22.5681, 22.5849, 22.5979, 22.6067, 22.6109, 22.6099,
         22.603, 22.5894, 22.5682, 22.5381, 22.4976, 22.4448, 22.3773, 22.2918, 22.1839, 22.0474, 21.8733, 21.6475,
         21.3465, 20.9273, 20.296, 19.1799, 15.649, 14.5455, 14.7266, 18.9116, 21.1444, 22.3655, 23.1919, 23.7954,
         24.2488, 24.5883, 24.8323, 24.9873, 25.0483, 24.9927, 24.7576, 24.1288, 21.9002, 20.3066, 22.0937, 24.7765,
         26.1333, 26.9668, 27.5734, 28.0466, 28.429, 28.7451, 29.0112, 29.2382, 29.4338, 29.6038, 29.7524, 29.8831,
         29.9985, 30.1008, 30.1918, 30.2727, 30.3448, 30.4088, 30.4655, 30.5158, 30.5614, 30.6032, 30.6421, 30.6786,
         30.7131, 30.7462, 30.7781, 30.809, 30.8391, 30.8687, 30.8978, 30.9266, 30.9551, 30.9835, 31.0118, 31.04,
         31.0681, 31.0963, 31.1245, 31.1527, 31.181, 31.2093, 31.2377, 31.2661, 31.2946, 31.3231, 31.3516, 31.3802,
         31.4087, 31.4373, 31.4658, 31.4943, 31.5228, 31.5512, 31.5795, 31.6077, 31.6358, 31.6638, 31.6917, 31.7194,
         31.7469, 31.7742, 31.8013, 31.8282, 31.8549, 31.8812, 31.9073, 31.9331, 31.9586, 31.9838, 32.0085, 32.0329,
         32.0569, 32.0805, 32.1036, 32.1262, 32.1484, 32.17, 32.191, 32.2115, 32.2313, 32.2504, 32.2689, 32.2865,
         32.3034, 32.3194, 32.3345, 32.3486, 32.3616, 32.3735, 32.384, 32.3932, 32.4009, 32.4068, 32.4109, 32.4128,
         32.4122, 32.4089, 32.4022, 32.3917, 32.3764, 32.3552, 32.3265, 32.288, 32.2355, 32.1621, 32.0535, 31.8715,
         31.4224, 31.2139, 31.2236, 31.5691, 31.9806, 32.1944, 32.3455, 32.4651, 32.5659, 32.6539, 32.7328, 32.8048,
         32.8713, 32.9333, 32.9916, 33.0466, 33.0989, 33.1487, 33.1961, 33.2414, 33.2846, 33.3258, 33.3649, 33.4018,
         33.4363, 33.468, 33.4962, 33.5199, 33.5371, 33.5435, 33.5272, 33.4144, 33.4093, 33.4318, 33.5488, 33.6822,
         33.772, 33.8464, 33.9128, 33.9743, 34.0323, 34.0878, 34.1414, 34.1934, 34.2441, 34.2937, 34.3424, 34.3903,
         34.4375, 34.4839, 34.5298, 34.5751, 34.6198, 34.6639, 34.7076, 34.7507, 34.7933, 34.8352, 34.8766, 34.9174,
         34.9574, 34.9966, 35.0349, 35.0722, 35.1082, 35.1428, 35.1756, 35.2062, 35.2339, 35.2576, 35.2759, 35.286,
         35.282, 35.2493, 35.1189, 35.0492, 35.0796, 35.1748, 35.404, 35.5389, 35.6457, 35.739, 35.8242, 35.9042,
         35.9805, 36.054, 36.1255, 36.1953, 36.2638, 36.3313, 36.3979, 36.4638, 36.529, 36.5938, 36.6581, 36.7221,
         36.7857, 36.8491, 36.9123, 36.9752, 37.038, 37.1006, 37.163, 37.2514, 37.3137, 37.3758, 37.4378, 37.4997,
         37.5615, 37.6232, 37.6848, 37.7463, 37.8077, 37.8691, 37.9303, 37.9915, 38.0525, 38.1187, 38.1795, 38.2402,
         38.3008, 38.3613, 38.4216, 38.4818, 38.5419, 38.6018, 38.6616, 38.7213, 38.7807, 38.8401, 38.8992, 38.9582,
         39.0169, 39.0755, 39.1339, 39.1921, 39.2501, 39.3078, 39.3654, 39.4226, 39.4797, 39.5365, 39.593, 39.6493,
         39.7052, 39.7609, 39.8163, 39.8715, 39.9263, 39.9808, 40.0349, 40.0888, 40.1423, 40.1954, 40.2482, 40.3007,
         40.3528, 40.4045, 40.4558, 40.5068, 40.5573, 40.6075, 40.6572, 40.7065, 40.7554, 40.8038, 40.8518, 40.8993,
         40.9463, 40.9928, 41.0388, 41.0843, 41.1293, 41.1737, 41.2176, 41.261, 41.3039, 41.3461, 41.3878, 41.429,
         41.4695, 41.5095, 41.5488, 41.5875, 41.6255, 41.6628, 41.6995, 41.7355, 41.7708, 41.8053, 41.8392, 41.8724,
         41.9049, 41.9367, 41.9677, 41.9981, 42.0277, 42.0565, 42.0847, 42.1121, 42.1388, 42.1648, 42.19, 42.2144,
         42.2382, 42.2611, 42.2834, 42.3049, 42.3256, 42.3456, 42.3649, 42.3834, 42.4012, 42.4182, 42.4345, 42.4501,
         42.4649, 42.479, 42.4924, 42.5051, 42.5171, 42.5334, 42.5528, 42.5643, 42.5695, 42.5694, 42.5649, 42.5578,
         42.5458, 42.5305, 42.5121, 42.4908, 42.4667, 42.4399, 42.4105, 42.3786, 42.3441, 42.3071, 42.2676, 42.2256,
         42.1812, 42.1343, 42.0849, 42.033, 41.9785, 41.9214, 41.8617, 41.7994, 41.7343, 41.6664, 41.5958, 41.5222,
         41.4456, 41.366, 41.2832, 41.1972, 41.1064, 41.0136, 40.9172, 40.8172, 40.7133, 40.6055, 40.4935, 40.3772,
         40.2564, 40.131, 40.0006, 39.8652, 39.7243, 39.5778, 39.4254, 39.2667, 39.1014, 38.9292, 38.7495, 38.562,
         38.3662, 38.1614, 37.9471, 37.7227, 37.4873, 37.2401, 36.9801, 36.7064, 36.4177, 36.1126, 35.7894, 35.4463,
         35.0812, 34.6916, 34.2747, 33.827, 33.3443, 32.8216, 32.2526, 31.6294, 30.9419, 30.178, 29.3172, 28.3353,
         27.1953, 25.8385, 24.1652, 21.9805, 18.8094, 12.7485, -6.16539, -6.5087, 8.46563, 16.3279, 19.1031, 20.354,
         20.5113, 19.0375, 9.29434, 9.24297, 10.7459, 22.0634, 25.7088, 28.1835, 30.1187, 31.7298, 33.1192, 34.3448,
         35.4429, 36.4381, 37.3481, 38.1859, 38.9614, 39.6825, 40.3554, 40.9853, 41.5763, 42.1319, 42.655, 43.1481,
         43.6134, 44.0524, 44.4668, 44.8578, 45.2264, 45.5733, 45.8993, 46.2047, 46.4896, 46.7541, 46.9979, 47.2202,
         47.4201, 47.5958, 47.745, 47.864, 47.9476, 47.9874, 47.9698, 47.8704, 47.6397, 47.1503, 45.8346, 44.6174,
         44.6759, 45.7658, 47.8151, 48.8564, 49.6011, 50.196, 50.6968, 51.131, 51.5135, 51.853, 52.1534, 52.4207,
         52.6687, 52.897, 53.1051, 53.2923, 53.4572, 53.5967, 53.7051, 53.7715, 53.7716, 53.6356, 52.9164, 52.8293,
         52.9028, 53.6916, 54.4223, 54.8883, 55.2548, 55.5658, 55.8396, 56.0852, 56.3078, 56.5101, 56.6927, 56.8603,
         57.017, 57.1615, 57.2923, 57.4073, 57.5023, 57.569, 57.5888, 57.5021, 57.262, 56.4412, 57.3875, 57.7872,
         58.2101, 58.5158, 58.7724, 59.0011, 59.2111, 59.4075, 59.5935, 59.7708, 59.9408, 60.1056, 60.2653, 60.4194,
         60.5687, 60.7135, 60.8544, 60.9915, 61.1252, 61.2558, 61.3833, 61.5081, 61.6302, 61.7499, 61.8672, 61.9822,
         62.0951, 62.2059, 62.3149, 62.4219, 62.5273, 62.6309, 62.7331, 62.8338, 62.9327, 63.0297, 63.1251, 63.2191,
         63.3116, 63.4028, 63.493, 63.5823, 63.6712, 63.7602, 63.8504, 63.9454, 64.0414, 64.1313, 64.2174, 64.5182,
         64.5976, 64.6741, 64.7478, 64.819, 64.8878, 65.0964, 65.1611, 65.2232, 65.2829, 65.3402, 65.3954, 65.4485,
         65.4997, 65.549, 65.5966, 65.6425, 65.6868, 65.7295, 65.7708, 65.8106, 65.8491, 65.8863, 65.9222, 65.9569,
         65.9904, 66.0228, 66.0541, 66.0843, 66.1134, 66.1415, 66.1686, 66.1948, 66.22, 66.2443, 66.2678, 66.2904,
         66.3122, 66.3332, 66.3535, 66.3731, 66.392, 66.4102, 66.4276, 66.4445, 66.4608, 66.4764, 66.4915, 66.5061,
         66.6298, 66.6439, 66.6571, 66.6694, 66.6808, 67.1293, 67.1246, 67.0963, 66.9694, 66.7626, 66.5036, 66.1931,
         65.8226, 65.3663, 64.7554, 63.8684, 62.2694, 60.1186, 57.1931, 53.7535, 57.217, 58.6884, 60.243, 62.2929,
         62.0963, 60.9185, 59.2549, 61.0691, 62.7204, 63.1439, 63.2436, 63.1156, 62.4005, 63.4667, 64.6852, 65.9637,
         67.5511, 68.5201, 69.1784, 69.6219, 69.9154, 70.1045, 70.22, 70.3448, 70.3981, 70.4166, 70.3806, 70.3291,
         70.2721, 70.2074, 70.1192, 70.0208, 69.9157, 69.8048, 69.6878, 69.5608, 69.4188, 69.2508, 69.0346, 68.7183,
         68.089, 67.437, 66.3087, 64.9576, 66.3231, 67.5338, 67.5565, 68.9414, 69.4756, 69.7851, 69.9894, 70.1221,
         70.2094, 70.2663, 70.3022, 70.323, 70.3335, 70.3634, 70.357, 70.3456, 70.331, 70.3144, 70.2967, 70.2783,
         70.2598, 70.2414, 70.2234, 70.2059, 70.1888, 70.1732, 70.1589, 70.1457, 70.1335, 70.1223, 70.1119, 70.1023],
        [0.0, 0.0, 0.0, 0.15997, 0.16048, 0.24028, 0.26322, 0.28998, 0.32108, 0.3571, 0.39875, 0.44685, 0.50232,
         0.56624, 0.63982, 0.72443, 0.82162, 0.86864, 0.89418, 0.90106, 30.895, 29.627, 29.371, 23.655, 18.939, 15.192,
         12.3, 10.127, 8.5366, 7.4086, 6.6435, 6.1631, 5.9074, 5.8318, 5.9031, 5.937, 5.947, 6.0019, 6.0455, 6.1379,
         6.4395, 6.8326, 7.3074, 7.856, 8.4722, 9.1509, 9.8876, 10.679, 11.101, 11.165, 11.228, 11.292, 11.356, 11.42,
         11.484, 11.549, 11.614, 11.679, 11.745, 11.811, 11.877, 11.943, 12.01, 12.077, 12.144, 12.211, 12.279, 12.347,
         12.415, 12.483, 12.552, 12.621, 12.69, 12.759, 12.829, 12.899, 12.969, 13.039, 13.11, 13.18, 13.251, 13.323,
         13.381, 13.41, 13.438, 13.466, 13.494, 13.521, 13.548, 13.575, 13.601, 13.627, 13.653, 13.679, 13.704, 13.729,
         13.753, 13.777, 13.801, 13.825, 13.848, 13.87, 13.893, 13.915, 13.937, 13.958, 13.979, 14.0, 14.02, 14.04,
         14.06, 14.079, 14.098, 14.116, 14.134, 14.152, 14.17, 14.187, 14.203, 14.219, 14.235, 14.251, 14.266, 14.281,
         14.295, 14.309, 14.323, 14.336, 14.348, 14.361, 14.373, 14.384, 14.396, 14.406, 14.417, 14.427, 14.436, 14.446,
         14.454, 14.463, 14.471, 14.478, 14.486, 14.492, 14.499, 14.505, 14.51, 14.515, 14.52, 14.525, 14.528, 14.532,
         14.535, 14.538, 14.54, 14.542, 14.544, 14.545, 14.545, 14.546, 14.545, 14.545, 14.544, 14.543, 14.541, 14.539,
         14.536, 14.533, 14.53, 14.526, 14.522, 14.517, 14.517, 21.9, 21.659, 21.285, 20.93, 20.593, 20.272, 19.967,
         19.677, 19.401, 19.139, 18.889, 18.652, 18.425, 18.21, 18.03, 18.005, 22.599, 22.28, 21.873, 21.486, 21.117,
         20.766, 20.431, 20.116, 19.819, 19.539, 19.275, 19.025, 18.789, 18.565, 18.354, 18.153, 17.962, 17.781, 17.609,
         17.445, 17.289, 17.144, 17.007, 16.878, 16.756, 16.642, 16.533, 16.43, 16.333, 16.241, 16.152, 16.068, 15.988,
         15.912, 15.838, 15.768, 15.7, 15.635, 15.573, 15.512, 15.454, 15.398, 15.343, 15.29, 15.239, 15.189, 15.141,
         15.094, 15.048, 15.003, 14.959, 14.916, 14.875, 14.834, 14.794, 14.754, 14.716, 14.678, 14.641, 14.604, 14.568,
         14.533, 14.498, 14.464, 14.43, 14.397, 14.364, 14.332, 14.3, 14.269, 14.238, 14.207, 14.177, 14.147, 14.117,
         14.088, 14.059, 14.03, 14.002, 13.974, 13.946, 13.919, 13.892, 13.865, 13.839, 13.813, 13.787, 13.761, 13.736,
         13.711, 13.686, 13.662, 13.638, 13.614, 13.59, 13.567, 13.544, 13.521, 13.499, 13.477, 13.455, 13.433, 13.412,
         13.391, 13.37, 13.349, 13.329, 13.309, 13.289, 13.27, 13.251, 13.247, 14.457, 14.452, 14.438, 14.423, 14.41,
         14.396, 14.383, 14.37, 14.357, 14.345, 14.333, 14.321, 14.31, 14.299, 14.288, 14.277, 14.267, 14.257, 14.247,
         14.238, 14.229, 14.22, 14.211, 14.203, 14.195, 14.187, 14.179, 14.172, 14.164, 14.157, 14.157, 14.481, 14.479,
         14.474, 14.469, 14.465, 14.46, 14.456, 14.453, 14.449, 14.445, 14.442, 14.439, 14.436, 14.433, 14.431, 14.428,
         14.426, 14.424, 14.422, 14.42, 14.418, 14.417, 14.415, 14.414, 14.412, 14.411, 14.41, 14.409, 14.407, 14.406,
         14.405, 14.404, 14.403, 14.402, 14.401, 14.401, 14.4, 14.399, 14.398, 14.396, 14.395, 14.394, 14.394, 14.907,
         14.907, 14.907, 14.907, 14.906, 14.906, 14.905, 14.905, 14.904, 14.903, 14.902, 14.901, 14.899, 14.898, 14.896,
         14.894, 14.892, 14.89, 14.887, 14.885, 14.882, 14.879, 14.875, 14.871, 14.867, 14.863, 14.859, 14.854, 14.849,
         14.843, 14.838, 14.831, 14.825, 14.818, 14.811, 14.804, 14.796, 14.788, 14.78, 14.771, 14.762, 14.752, 14.742,
         14.732, 14.721, 14.71, 14.699, 14.687, 14.675, 14.662, 14.649, 14.636, 14.622, 14.608, 14.594, 14.579, 14.563,
         14.548, 14.532, 14.515, 14.498, 14.481, 14.463, 14.445, 14.426, 14.408, 14.388, 14.369, 14.348, 14.328, 14.307,
         14.286, 14.264, 14.242, 14.22, 14.197, 14.173, 14.15, 14.126, 14.102, 14.077, 14.052, 14.026, 14.0, 13.974,
         13.948, 13.921, 13.893, 13.866, 13.838, 13.809, 13.78, 13.751, 13.721, 13.691, 13.661, 13.63, 13.599, 13.568,
         13.536, 13.504, 13.472, 13.44, 13.407, 13.373, 13.34, 13.306, 13.272, 13.237, 13.202, 13.167, 13.131, 13.096,
         13.06, 13.024, 12.987, 12.951, 12.914, 12.878, 12.841, 12.804, 12.766, 12.729, 12.691, 12.654, 12.616, 12.578,
         12.54, 12.503, 12.465, 12.426, 12.388, 12.35, 12.312, 12.274, 12.235, 12.197, 12.159, 12.12, 12.082, 12.044,
         12.006, 11.967, 11.929, 11.891, 11.84, 11.765, 11.69, 11.616, 11.543, 11.47, 11.397, 11.326, 11.255, 11.184,
         11.114, 11.045, 10.976, 10.907, 10.84, 10.772, 10.706, 10.64, 10.574, 10.509, 10.444, 10.38, 10.317, 10.254,
         10.191, 10.129, 10.068, 10.007, 9.946, 9.8859, 9.8263, 9.7672, 9.7085, 9.6502, 9.5925, 9.5351, 9.4783, 9.4218,
         9.3658, 9.3103, 9.2551, 9.2004, 9.1462, 9.0923, 9.0389, 8.9858, 8.9332, 8.881, 8.8292, 8.7778, 8.7268, 8.6761,
         8.6259, 8.576, 8.5266, 8.4775, 8.4287, 8.3804, 8.3324, 8.2848, 8.2375, 8.1906, 8.1441, 8.0979, 8.0509, 8.0037,
         7.9568, 7.9103, 7.8641, 7.8183, 7.7728, 7.7277, 7.6829, 7.6385, 7.5944, 7.5506, 7.5072, 7.4641, 7.4213, 7.3788,
         7.3366, 7.2948, 7.2533, 7.212, 7.1711, 7.1462, 26.615, 26.549, 26.345, 26.144, 25.943, 25.745, 25.548, 25.382,
         38.098, 38.09, 37.793, 37.499, 37.206, 36.916, 36.629, 36.343, 36.06, 35.779, 35.501, 35.225, 34.951, 34.679,
         34.41, 34.142, 33.877, 33.614, 33.354, 33.095, 32.838, 32.584, 32.331, 32.081, 31.832, 31.586, 31.342, 31.099,
         30.859, 30.62, 30.384, 30.149, 29.916, 29.686, 29.457, 29.23, 29.004, 28.781, 28.559, 28.339, 28.121, 27.905,
         27.69, 27.477, 27.411, 32.118, 32.058, 31.786, 31.517, 31.25, 30.985, 30.722, 30.461, 30.202, 29.946, 29.692,
         29.461, 29.237, 29.016, 28.799, 28.584, 28.373, 28.164, 27.958, 27.755, 27.554, 27.356, 27.161, 27.153, 28.982,
         28.875, 28.658, 28.443, 28.23, 28.02, 27.812, 27.607, 27.404, 27.203, 27.005, 26.821, 26.64, 26.461, 26.284,
         26.11, 25.938, 25.768, 25.6, 25.434, 25.331, 25.27, 26.372, 26.28, 26.114, 25.95, 25.786, 25.625, 25.465,
         25.306, 25.148, 24.992, 24.837, 24.685, 24.53, 24.375, 24.221, 24.068, 23.916, 23.766, 23.616, 23.468, 23.321,
         23.174, 23.029, 22.884, 22.74, 22.597, 22.455, 22.314, 22.174, 22.035, 21.896, 21.758, 21.621, 21.484, 21.347,
         21.21, 21.074, 20.939, 20.805, 20.671, 20.538, 20.406, 20.275, 20.145, 20.016, 19.887, 19.743, 19.6, 19.458,
         19.315, 19.168, 19.023, 18.879, 18.736, 18.593, 18.452, 18.308, 18.165, 18.023, 17.882, 17.743, 17.606, 17.469,
         17.334, 17.2, 17.067, 16.935, 16.805, 16.675, 16.547, 16.42, 16.294, 16.17, 16.046, 15.924, 15.802, 15.68,
         15.56, 15.44, 15.322, 15.205, 15.089, 14.974, 14.86, 14.747, 14.635, 14.524, 14.415, 14.306, 14.197, 14.089,
         13.983, 13.877, 13.772, 13.668, 13.565, 13.463, 13.362, 13.26, 13.156, 13.054, 12.952, 12.851, 12.519, 11.292,
         10.172, 9.1701, 8.2727, 7.4733, 6.7601, 6.1228, 5.5324, 4.9914, 4.5094, 4.0808, 3.8563, 3.7678, 3.7409, 10.431,
         10.321, 10.089, 8.9588, 8.7436, 8.5005, 8.4382, 11.721, 11.387, 11.176, 11.086, 10.854, 10.772, 12.356, 12.066,
         11.498, 10.372, 9.3393, 8.3938, 7.5242, 6.7398, 6.0368, 5.4096, 4.8427, 4.3363, 3.879, 3.4684, 3.104, 2.7802,
         2.4723, 2.1945, 1.9495, 1.7332, 1.5421, 1.3727, 1.2204, 1.0847, 0.96081, 0.85078, 0.75329, 0.66748, 0.6355,
         0.61835, 0.6139, 3.2671, 3.196, 3.1936, 2.8776, 2.5819, 2.3152, 2.0735, 1.8505, 1.6518, 1.4746, 1.3166, 1.1757,
         1.05, 0.93416, 0.83084, 0.73901, 0.6574, 0.58485, 0.52036, 0.46302, 0.41203, 0.36668, 0.32635, 0.29048,
         0.25909, 0.23212, 0.20797, 0.18635, 0.16699, 0.14965, 0.13412, 0.1202]],
    'Lu':                                                                                                         [
        [0.006762, 0.0068655, 0.0068931, 0.0069345, 0.007038, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.02744, 0.02786, 0.027972, 0.02814, 0.02856, 0.02908327, 0.03109002, 0.03323523, 0.03552846,
         0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.055664, 0.056516, 0.05667876,
         0.0567432, 0.057084, 0.057936, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368,
         0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294,
         0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712,
         0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956,
         0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029,
         0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979,
         0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902,
         0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944,
         0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305,
         0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239,
         0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058,
         0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134,
         0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902,
         0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862,
         0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585,
         0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712,
         0.19485647, 0.19509776, 0.19514351, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434,
         0.20202946, 0.20303961, 0.20405481, 0.20462018, 0.20497981, 0.20507508, 0.20610046, 0.20713096, 0.20816661,
         0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366,
         0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948,
         0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422,
         0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893,
         0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567,
         0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747,
         0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845,
         0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381,
         0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873, 0.31178993,
         0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438,
         0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602,
         0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502,
         0.3585187, 0.35885446, 0.35974552, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096,
         0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718, 0.38636941,
         0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737, 0.40410785,
         0.40612839, 0.40815904, 0.40952587, 0.41019983, 0.41067415, 0.41225083, 0.41431208, 0.41638364, 0.41846556,
         0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756,
         0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159,
         0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815,
         0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782, 0.50076959,
         0.50327344, 0.50541541, 0.5057898, 0.50698463, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163,
         0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691,
         0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56726958,
         0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325,
         0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526,
         0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253,
         0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045,
         0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641,
         0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322,
         0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656,
         0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515,
         0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084,
         0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881,
         0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765,
         0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959,
         0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606,
         1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579,
         1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143,
         1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659,
         1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555,
         1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335,
         1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577,
         1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942,
         1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176,
         1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5770017, 1.5848867, 1.5882395,
         1.5887605, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6388836, 1.6399164, 1.6411967,
         1.6494027, 1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278,
         1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.813351,
         1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672, 1.896603, 1.906086,
         1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955, 2.0035635,
         2.0135813, 2.0213134, 2.0236492, 2.0258868, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227,
         2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561,
         2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2608064, 2.2661935, 2.2696279, 2.280976,
         2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3976254,
         2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4861428, 2.4952257, 2.4962571,
         2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829, 2.6228319,
         2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476, 2.7569638,
         2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553,
         2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571,
         3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938,
         3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856,
         3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072,
         3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311,
         3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075,
         3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855,
         6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.059218, 9.197879, 9.234856, 9.29032,
         9.428982, 9.653919, 10.14163, 10.29686, 10.32004, 10.33825, 10.40034, 10.55557, 10.65299, 10.81605, 10.85953,
         10.92475, 11.03212, 11.08781, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398,
         20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543,
         41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.04752, 62.5287, 62.99723, 63.25049, 63.63037,
         64.58008, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587,
         130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699,
         271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [10.9733, 10.7902, 10.576, 10.7961, 10.9845, 11.0473, 10.9705, 10.8782, 10.7684, 10.6376, 10.4815, 10.2939,
         10.0658, 9.78414, 9.4284, 8.84927, 8.21276, 7.26572, 5.62002, 1.17691, -0.278294, -6.41303, -13.9079, -5.90857,
         1.14942, 4.64754, 10.259, 12.8947, 14.313, 15.0174, 15.2796, 15.2719, 15.1082, 14.8634, 14.5849, 14.3716,
         14.2925, 14.2695, 14.2545, 14.2534, 14.2164, 14.074, 13.8832, 13.7405, 13.6575, 13.6432, 13.723, 13.8739,
         14.1238, 16.2066, 16.2342, 16.2624, 16.2914, 16.3211, 16.3515, 16.3826, 16.4144, 16.447, 16.4804, 16.5145,
         16.5493, 16.585, 16.6214, 16.6587, 16.6967, 16.7356, 16.7753, 16.8159, 16.8573, 16.8997, 16.9429, 16.987,
         17.032, 17.078, 17.1249, 17.1727, 17.2216, 17.2714, 17.3223, 17.3742, 17.4272, 17.4812, 17.5364, 17.5927,
         17.6501, 17.7086, 17.7684, 17.8294, 17.8916, 17.9551, 18.0199, 18.086, 18.1534, 18.2223, 18.2926, 18.3644,
         18.4376, 18.5124, 18.5888, 18.6668, 18.7465, 18.8279, 18.9117, 18.9951, 19.078, 19.1605, 19.2426, 19.3244,
         19.4058, 19.4868, 19.5675, 19.6479, 19.7279, 19.8076, 19.8869, 19.966, 20.0447, 20.1231, 20.2012, 20.279,
         20.3564, 20.4336, 20.5104, 20.5868, 20.663, 20.7388, 20.8142, 20.8893, 20.964, 21.0384, 21.1123, 21.1859,
         21.259, 21.3317, 21.404, 21.4757, 21.547, 21.6178, 21.6881, 21.7578, 21.8269, 21.8955, 21.9633, 22.0306,
         22.0971, 22.1628, 22.2278, 22.2919, 22.3552, 22.4175, 22.4789, 22.5391, 22.5983, 22.6562, 22.7128, 22.7681,
         22.8236, 22.8758, 22.9262, 22.9747, 23.0211, 23.0653, 23.1071, 23.1461, 23.1821, 23.2148, 23.2437, 23.2685,
         23.2885, 23.303, 23.3113, 23.3123, 23.3048, 23.2869, 23.2566, 23.2107, 23.1449, 23.0531, 22.9251, 22.7442,
         22.478, 22.0516, 21.2081, 18.9299, 18.486, 19.0163, 21.8997, 22.8823, 23.4754, 23.8829, 24.1682, 24.3518,
         24.4274, 24.3464, 23.8847, 22.7717, 22.9072, 23.3293, 25.045, 25.8196, 26.3637, 26.7927, 27.1494, 27.4552,
         27.7223, 27.9584, 28.1689, 28.3576, 28.5278, 28.6828, 28.8248, 28.9556, 29.0766, 29.1891, 29.2938, 29.3916,
         29.4829, 29.5683, 29.6486, 29.7249, 29.7976, 29.8674, 29.9346, 29.9996, 30.0627, 30.1241, 30.1841, 30.2427,
         30.3002, 30.3566, 30.4122, 30.4668, 30.5207, 30.5739, 30.6265, 30.6784, 30.7298, 30.7807, 30.8312, 30.8811,
         30.9306, 30.9797, 31.0284, 31.0766, 31.1245, 31.172, 31.2192, 31.2659, 31.3123, 31.3583, 31.404, 31.4493,
         31.4942, 31.5387, 31.5829, 31.6266, 31.67, 31.713, 31.7555, 31.7977, 31.8394, 31.8807, 31.9216, 31.962, 32.002,
         32.0415, 32.0805, 32.1191, 32.1571, 32.1947, 32.2317, 32.2681, 32.304, 32.3394, 32.3741, 32.4082, 32.4417,
         32.4746, 32.5067, 32.5382, 32.5689, 32.5988, 32.628, 32.6563, 32.6837, 32.7102, 32.7357, 32.7601, 32.7835,
         32.8056, 32.8264, 32.8459, 32.8638, 32.88, 32.8944, 32.9068, 32.9169, 32.9243, 32.9288, 32.9298, 32.9266,
         32.9185, 32.9042, 32.8821, 32.8496, 32.8026, 32.7339, 32.6287, 32.4476, 31.9961, 31.7736, 31.788, 32.1302,
         32.5763, 32.8094, 32.9756, 33.1086, 33.2215, 33.321, 33.4107, 33.493, 33.5695, 33.6411, 33.7086, 33.7727,
         33.8336, 33.8917, 33.947, 33.9998, 34.0501, 34.0976, 34.1422, 34.1836, 34.2208, 34.2527, 34.2766, 34.2867,
         34.2633, 34.1682, 33.9986, 34.1968, 34.377, 34.4999, 34.5937, 34.675, 34.7494, 34.8192, 34.8858, 34.9499,
         35.0121, 35.0728, 35.1321, 35.1903, 35.2475, 35.3038, 35.3593, 35.4141, 35.4683, 35.5218, 35.5746, 35.6269,
         35.6786, 35.7298, 35.7803, 35.8302, 35.8795, 35.9281, 35.976, 36.023, 36.0692, 36.1143, 36.1583, 36.2009,
         36.2418, 36.2807, 36.3171, 36.3502, 36.3789, 36.4012, 36.4136, 36.4085, 36.3633, 36.1934, 36.0943, 36.2288,
         36.4238, 36.6121, 36.7424, 36.8509, 36.9478, 37.0377, 37.1227, 37.2042, 37.2831, 37.36, 37.4353, 37.5093,
         37.5821, 37.6541, 37.7252, 37.7957, 37.8656, 37.935, 38.004, 38.0725, 38.1407, 38.2086, 38.2763, 38.3436,
         38.4107, 38.4775, 38.5442, 38.6106, 38.6768, 38.7608, 38.8266, 38.8922, 38.9577, 39.023, 39.0881, 39.1531,
         39.2178, 39.2824, 39.3469, 39.401, 39.465, 39.5288, 39.5924, 39.6558, 39.719, 39.7821, 39.8449, 39.9075, 39.97,
         40.0322, 40.0942, 40.156, 40.2176, 40.2789, 40.3401, 40.4009, 40.4616, 40.522, 40.5822, 40.6421, 40.7018,
         40.7612, 40.8204, 40.8793, 40.9378, 40.996, 41.0538, 41.1113, 41.1684, 41.2252, 41.2815, 41.3375, 41.3932,
         41.4484, 41.5033, 41.5577, 41.6118, 41.6654, 41.7186, 41.7714, 41.8238, 41.8757, 41.9272, 41.9783, 42.0289,
         42.079, 42.1287, 42.1779, 42.2267, 42.2749, 42.3226, 42.3699, 42.4166, 42.4627, 42.5084, 42.5534, 42.5979,
         42.6419, 42.6853, 42.7281, 42.7703, 42.8119, 42.8529, 42.8933, 42.933, 42.9721, 43.0106, 43.0483, 43.0854,
         43.1217, 43.1574, 43.1923, 43.2266, 43.2601, 43.2929, 43.325, 43.3564, 43.387, 43.417, 43.4462, 43.4747,
         43.5024, 43.5294, 43.5557, 43.5813, 43.6062, 43.6303, 43.6537, 43.6764, 43.6984, 43.7197, 43.7404, 43.7606,
         43.7804, 43.8005, 43.8254, 44.0197, 44.0422, 44.0588, 44.0703, 44.0775, 44.081, 44.0811, 44.0781, 44.0722,
         44.0636, 44.0524, 44.0388, 44.0228, 44.0046, 43.9841, 43.9634, 43.9386, 43.9117, 43.8826, 43.8515, 43.8182,
         43.7828, 43.7453, 43.7057, 43.6639, 43.62, 43.5739, 43.5255, 43.4749, 43.4221, 43.3669, 43.3094, 43.2494,
         43.187, 43.122, 43.0545, 42.9844, 42.9115, 42.8359, 42.7573, 42.6759, 42.5914, 42.5047, 42.4138, 42.3196,
         42.2218, 42.1205, 42.0154, 41.9064, 41.7933, 41.6761, 41.5544, 41.4281, 41.297, 41.1609, 41.0194, 40.8724,
         40.7195, 40.5604, 40.3948, 40.2223, 40.0424, 39.8548, 39.6588, 39.4541, 39.2398, 39.0155, 38.7802, 38.5332,
         38.2736, 38.0001, 37.7117, 37.407, 37.0843, 36.7416, 36.377, 35.9879, 35.5713, 35.1237, 34.641, 34.118,
         33.5481, 32.9234, 32.2334, 31.4659, 30.5989, 29.6074, 28.4518, 27.0693, 25.3499, 23.0725, 19.6632, 12.3501,
         -3.75676, -4.09227, 12.8184, 18.7021, 21.0642, 22.1012, 22.0761, 20.2447, 11.1683, 11.121, 16.2781, 24.2105,
         27.553, 29.8847, 31.7276, 33.2704, 34.6057, 35.7863, 36.8459, 37.8077, 38.688, 39.4991, 40.2505, 40.9496,
         41.6024, 42.2135, 42.7872, 43.3266, 43.8346, 44.3134, 44.7651, 45.1914, 45.5935, 45.9728, 46.33, 46.666,
         46.9813, 47.276, 47.5504, 47.8043, 48.0371, 48.2481, 48.4357, 48.5981, 48.7323, 48.8337, 48.8955, 48.907,
         48.8495, 48.6876, 48.341, 47.5503, 45.4969, 39.5706, 45.5521, 48.0629, 49.3775, 50.2322, 50.8904, 51.4348,
         51.9021, 52.312, 52.6757, 52.9993, 53.2853, 53.5488, 53.7932, 54.0184, 54.2241, 54.4098, 54.5741, 54.7142,
         54.8252, 54.8972, 54.9095, 54.8064, 54.313, 53.9624, 54.0354, 54.6022, 55.4404, 55.9313, 56.3087, 56.6256,
         56.9029, 57.1509, 57.3751, 57.5785, 57.7621, 57.9287, 58.0841, 58.2269, 58.3553, 58.4665, 58.5554, 58.6112,
         58.6071, 58.4361, 58.292, 58.3177, 58.416, 59.0018, 59.3665, 59.651, 59.8968, 60.1188, 60.3246, 60.518,
         60.7018, 60.8776, 61.0466, 61.2107, 61.3691, 61.5223, 61.671, 61.8155, 61.9562, 62.0933, 62.2273, 62.3581,
         62.4862, 62.6115, 62.7344, 62.8549, 62.9732, 63.0894, 63.2036, 63.316, 63.4266, 63.5356, 63.6432, 63.7495,
         63.8548, 63.9593, 64.0632, 64.1671, 64.2727, 64.3872, 64.4921, 64.5929, 64.6902, 64.7842, 64.8752, 64.9635,
         65.0491, 65.1324, 65.2134, 65.2924, 65.3695, 65.6549, 65.7286, 65.7998, 65.8688, 65.9355, 66.0001, 66.2105,
         66.271, 66.3292, 66.3852, 66.4391, 66.491, 66.541, 66.5892, 66.6357, 66.6806, 66.7239, 66.7658, 66.8062,
         66.8452, 66.8829, 66.9193, 66.9545, 66.9885, 67.0214, 67.0532, 67.0839, 67.1136, 67.1423, 67.17, 67.1968,
         67.2226, 67.2475, 67.2716, 67.2948, 67.3171, 67.3387, 67.3595, 67.3796, 67.3989, 67.4176, 67.4355, 67.4528,
         67.4695, 67.4855, 67.501, 68.0705, 68.1253, 68.1421, 68.0331, 67.8818, 67.6534, 67.3736, 67.0389, 66.6357,
         66.1193, 65.4029, 64.2755, 61.522, 61.2237, 58.3103, 54.8774, 58.3353, 61.3582, 62.8874, 63.2255, 62.0344,
         61.4352, 60.3722, 62.1758, 63.8087, 64.2064, 64.1778, 63.4651, 64.525, 65.4276, 65.7342, 67.8323, 69.0599,
         69.8582, 70.4053, 70.7705, 71.0101, 71.1611, 71.3132, 71.3517, 71.3908, 71.399, 71.3572, 71.3068, 71.2484,
         71.165, 71.0701, 70.9678, 70.8598, 70.7462, 70.6252, 70.4918, 70.3391, 70.1506, 69.8941, 69.4707, 68.4517,
         68.0708, 67.3303, 65.9876, 67.3441, 68.5694, 69.508, 70.2671, 70.658, 70.9032, 71.0647, 71.1701, 71.2395,
         71.2841, 71.3112, 71.3261, 71.3602, 71.357, 71.3479, 71.3349, 71.3193, 71.3022, 71.2843, 71.266, 71.2477,
         71.2297, 71.2122, 71.195, 71.1787, 71.1639, 71.1504, 71.1379, 71.1263, 71.1157, 71.1058],
        [0.0, 0.0, 0.0, 0.41866, 0.40834, 0.27823, 0.2819, 0.2904, 0.30371, 0.32202, 0.3457, 0.37529, 0.41148, 0.45519,
         0.50748, 0.56964, 0.64316, 0.72979, 0.83149, 0.9505, 0.96715, 0.99751, 1.0057, 15.849, 15.393, 14.857, 13.092,
         11.446, 9.9275, 8.6395, 7.6209, 6.8706, 6.3673, 6.0817, 5.9838, 6.0153, 6.0412, 6.0469, 6.0493, 6.106, 6.1436,
         6.2959, 6.622, 7.054, 7.5802, 8.1914, 8.8798, 9.6388, 10.463, 10.906, 10.973, 11.039, 11.106, 11.173, 11.241,
         11.309, 11.377, 11.446, 11.514, 11.584, 11.653, 11.723, 11.793, 11.863, 11.934, 12.005, 12.076, 12.148, 12.219,
         12.292, 12.364, 12.437, 12.51, 12.583, 12.656, 12.73, 12.804, 12.879, 12.953, 13.028, 13.104, 13.179, 13.255,
         13.331, 13.407, 13.484, 13.561, 13.638, 13.715, 13.793, 13.871, 13.949, 14.027, 14.106, 14.185, 14.264, 14.344,
         14.423, 14.503, 14.583, 14.664, 14.742, 14.772, 14.803, 14.833, 14.863, 14.892, 14.921, 14.95, 14.978, 15.006,
         15.033, 15.06, 15.086, 15.112, 15.138, 15.163, 15.188, 15.213, 15.237, 15.26, 15.283, 15.306, 15.329, 15.35,
         15.372, 15.393, 15.413, 15.433, 15.453, 15.472, 15.491, 15.509, 15.527, 15.545, 15.562, 15.578, 15.594, 15.61,
         15.625, 15.639, 15.654, 15.667, 15.68, 15.693, 15.706, 15.717, 15.729, 15.74, 15.75, 15.76, 15.77, 15.779,
         15.787, 15.795, 15.803, 15.81, 15.817, 15.823, 15.829, 15.834, 15.839, 15.843, 15.847, 15.85, 15.853, 15.855,
         15.857, 15.859, 15.86, 15.86, 15.86, 15.86, 15.859, 15.858, 15.856, 15.853, 15.851, 15.847, 15.844, 15.84,
         15.835, 15.83, 15.826, 20.045, 20.037, 19.876, 19.713, 19.555, 19.403, 19.256, 19.114, 18.977, 18.844, 18.715,
         18.646, 21.463, 21.441, 21.211, 20.989, 20.774, 20.567, 20.367, 20.174, 19.988, 19.807, 19.633, 19.465, 19.305,
         19.152, 19.006, 18.866, 18.732, 18.604, 18.481, 18.362, 18.249, 18.14, 18.037, 17.939, 17.845, 17.756, 17.671,
         17.59, 17.512, 17.437, 17.365, 17.296, 17.23, 17.166, 17.104, 17.044, 16.986, 16.93, 16.875, 16.822, 16.771,
         16.72, 16.672, 16.624, 16.577, 16.532, 16.487, 16.443, 16.401, 16.359, 16.317, 16.277, 16.237, 16.198, 16.16,
         16.122, 16.084, 16.048, 16.011, 15.975, 15.94, 15.905, 15.871, 15.836, 15.803, 15.769, 15.736, 15.704, 15.672,
         15.64, 15.608, 15.577, 15.546, 15.515, 15.484, 15.454, 15.424, 15.395, 15.365, 15.336, 15.307, 15.279, 15.251,
         15.222, 15.195, 15.167, 15.14, 15.113, 15.086, 15.059, 15.033, 15.007, 14.981, 14.955, 14.93, 14.905, 14.88,
         14.855, 14.831, 14.806, 14.783, 14.759, 14.735, 14.712, 14.689, 14.666, 14.644, 14.622, 14.6, 14.578, 14.556,
         14.535, 14.514, 14.493, 14.489, 15.756, 15.75, 15.734, 15.718, 15.702, 15.686, 15.671, 15.656, 15.641, 15.627,
         15.612, 15.598, 15.584, 15.571, 15.557, 15.544, 15.531, 15.519, 15.506, 15.494, 15.482, 15.47, 15.459, 15.447,
         15.436, 15.425, 15.415, 15.407, 15.739, 15.737, 15.73, 15.722, 15.713, 15.705, 15.697, 15.689, 15.681, 15.674,
         15.666, 15.659, 15.652, 15.645, 15.638, 15.631, 15.624, 15.617, 15.611, 15.604, 15.598, 15.592, 15.586, 15.579,
         15.573, 15.567, 15.561, 15.555, 15.549, 15.543, 15.537, 15.531, 15.525, 15.519, 15.513, 15.507, 15.501, 15.495,
         15.488, 15.482, 15.476, 15.469, 15.463, 15.457, 15.456, 15.974, 15.971, 15.966, 15.96, 15.953, 15.947, 15.941,
         15.934, 15.927, 15.921, 15.913, 15.906, 15.899, 15.891, 15.883, 15.875, 15.867, 15.858, 15.85, 15.841, 15.831,
         15.822, 15.812, 15.802, 15.792, 15.782, 15.771, 15.76, 15.748, 15.736, 15.724, 15.712, 15.699, 15.686, 15.673,
         15.659, 15.645, 15.631, 15.616, 15.601, 15.586, 15.571, 15.555, 15.538, 15.521, 15.504, 15.487, 15.469, 15.451,
         15.433, 15.414, 15.395, 15.375, 15.355, 15.335, 15.315, 15.294, 15.272, 15.251, 15.229, 15.206, 15.184, 15.16,
         15.137, 15.113, 15.088, 15.063, 15.038, 15.012, 14.986, 14.96, 14.933, 14.906, 14.878, 14.851, 14.822, 14.794,
         14.765, 14.736, 14.707, 14.677, 14.647, 14.616, 14.586, 14.555, 14.523, 14.492, 14.46, 14.428, 14.395, 14.362,
         14.329, 14.295, 14.261, 14.227, 14.193, 14.158, 14.123, 14.088, 14.052, 14.016, 13.98, 13.943, 13.907, 13.87,
         13.832, 13.795, 13.757, 13.719, 13.681, 13.642, 13.603, 13.565, 13.526, 13.487, 13.447, 13.408, 13.368, 13.329,
         13.289, 13.249, 13.21, 13.17, 13.13, 13.09, 13.05, 13.01, 12.97, 12.93, 12.89, 12.85, 12.81, 12.77, 12.73,
         12.69, 12.65, 12.61, 12.556, 12.475, 12.394, 12.314, 12.235, 12.156, 12.078, 12.001, 11.924, 11.848, 11.773,
         11.698, 11.624, 11.551, 11.478, 11.405, 11.334, 11.263, 11.192, 11.122, 11.053, 10.984, 10.916, 10.848, 10.781,
         10.714, 10.648, 10.583, 10.518, 10.454, 10.39, 10.326, 10.263, 10.201, 10.139, 10.078, 10.017, 9.9568, 9.8969,
         9.8375, 9.7786, 9.7202, 9.6622, 9.6047, 9.5477, 9.4911, 9.4349, 9.3792, 9.324, 9.2692, 9.2148, 9.1609, 9.1073,
         9.0542, 9.0015, 8.9493, 8.8974, 8.846, 8.7949, 8.7443, 8.694, 8.6442, 8.5947, 8.5456, 8.4969, 8.4486, 8.4006,
         8.353, 8.3058, 8.259, 8.2125, 8.1664, 8.1206, 8.0741, 8.0274, 7.981, 7.935, 7.8893, 7.844, 7.7991, 7.7545,
         7.7102, 7.6663, 7.6227, 7.5794, 7.5365, 7.4939, 7.4516, 7.4096, 7.368, 7.3267, 7.2857, 7.245, 7.2278, 26.332,
         26.231, 26.034, 25.84, 25.646, 25.455, 25.265, 25.129, 37.61, 37.565, 37.278, 36.994, 36.712, 36.433, 36.155,
         35.88, 35.607, 35.337, 35.068, 34.801, 34.537, 34.275, 34.015, 33.757, 33.5, 33.246, 32.994, 32.744, 32.496,
         32.25, 32.006, 31.764, 31.524, 31.286, 31.049, 30.815, 30.582, 30.351, 30.122, 29.895, 29.67, 29.446, 29.224,
         29.004, 28.786, 28.569, 28.354, 28.141, 27.929, 27.72, 27.511, 27.352, 32.141, 32.081, 31.873, 31.608, 31.345,
         31.084, 30.823, 30.564, 30.308, 30.054, 29.801, 29.561, 29.338, 29.118, 28.901, 28.687, 28.475, 28.267, 28.062,
         27.859, 27.659, 27.461, 27.265, 27.072, 27.03, 28.855, 28.789, 28.574, 28.361, 28.151, 27.943, 27.737, 27.533,
         27.332, 27.133, 26.935, 26.752, 26.572, 26.395, 26.22, 26.047, 25.876, 25.707, 25.541, 25.376, 25.332, 26.38,
         26.366, 26.214, 26.049, 25.885, 25.724, 25.563, 25.404, 25.246, 25.089, 24.934, 24.781, 24.627, 24.472, 24.318,
         24.166, 24.014, 23.863, 23.714, 23.565, 23.418, 23.271, 23.125, 22.981, 22.837, 22.694, 22.552, 22.41, 22.27,
         22.13, 21.991, 21.853, 21.716, 21.579, 21.443, 21.307, 21.171, 21.037, 20.902, 20.751, 20.602, 20.453, 20.306,
         20.159, 20.014, 19.87, 19.727, 19.585, 19.444, 19.304, 19.161, 19.016, 18.873, 18.73, 18.589, 18.448, 18.308,
         18.165, 18.023, 17.883, 17.744, 17.606, 17.47, 17.335, 17.201, 17.068, 16.936, 16.806, 16.677, 16.549, 16.422,
         16.296, 16.172, 16.049, 15.926, 15.805, 15.685, 15.566, 15.448, 15.33, 15.213, 15.097, 14.982, 14.868, 14.755,
         14.644, 14.533, 14.423, 14.314, 14.206, 14.098, 13.991, 13.886, 13.781, 13.677, 13.574, 13.234, 11.926, 10.755,
         9.6944, 8.7414, 7.892, 7.1349, 6.4591, 5.8517, 5.2816, 4.7703, 4.3147, 3.8874, 3.8656, 3.762, 3.7351, 10.408,
         10.061, 9.5328, 8.651, 8.4114, 8.3769, 8.35, 11.623, 11.291, 11.091, 10.771, 10.689, 12.266, 12.075, 11.979,
         10.89, 9.8194, 8.8462, 7.9399, 7.1159, 6.3749, 5.7119, 5.1183, 4.5831, 4.1049, 3.6721, 3.2866, 2.9442, 2.6182,
         2.324, 2.0646, 1.8357, 1.6333, 1.4545, 1.2942, 1.1513, 1.0224, 0.90531, 0.80196, 0.71065, 0.63901, 0.63021,
         0.62183, 0.61737, 3.2538, 3.1814, 3.0182, 2.7105, 2.4307, 2.1793, 1.9462, 1.7376, 1.5515, 1.3855, 1.2375,
         1.1054, 0.98577, 0.8771, 0.78049, 0.69458, 0.61819, 0.55025, 0.48983, 0.43607, 0.38825, 0.3457, 0.30783,
         0.27414, 0.24552, 0.22016, 0.19742, 0.17705, 0.15879, 0.14242, 0.12775]],
    'Hf':                                                                                                         [
        [0.0049, 0.004975, 0.004995, 0.005025, 0.0051, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601,
         0.01492335, 0.01595306, 0.016758, 0.0170145, 0.01705382, 0.0170829, 0.0171855, 0.017442, 0.01823053,
         0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.029988, 0.030447,
         0.0305694, 0.030753, 0.03109002, 0.031212, 0.03323523, 0.03552846, 0.037338, 0.0379095, 0.03797993, 0.0380619,
         0.0382905, 0.038862, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959,
         0.063602, 0.0645755, 0.06477028, 0.0648351, 0.0652245, 0.066198, 0.06923942, 0.07401695, 0.07912411,
         0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775,
         0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827,
         0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598,
         0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083,
         0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327,
         0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419,
         0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502,
         0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766,
         0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462,
         0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894,
         0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427,
         0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489,
         0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574,
         0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244,
         0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131,
         0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946,
         0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475,
         0.21236128, 0.21342308, 0.21354015, 0.21385984, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228,
         0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22361559, 0.22398441, 0.22433757, 0.22545925, 0.22658655,
         0.22771948, 0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927,
         0.23817422, 0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959,
         0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942,
         0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171,
         0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044,
         0.28501845, 0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071,
         0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873,
         0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197,
         0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913,
         0.34107602, 0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022,
         0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665,
         0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.3799207, 0.38063135, 0.38087931, 0.3825345, 0.38444718,
         0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737,
         0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789,
         0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.4363751, 0.43762492,
         0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412,
         0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612,
         0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782,
         0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444,
         0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53724443, 0.53895558, 0.53967074,
         0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734,
         0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144,
         0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528,
         0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347,
         0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314,
         0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404,
         0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867,
         0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324,
         0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358,
         0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373,
         0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762,
         0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348,
         0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312,
         0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021,
         1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407,
         1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252,
         1.1234143, 1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909,
         1.1808659, 1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801,
         1.2412555, 1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423,
         1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345,
         1.3714577, 1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221,
         1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787,
         1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5770017, 1.5848867,
         1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6494027, 1.6576497, 1.6614142,
         1.6619858, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.7158508, 1.716545, 1.7169493,
         1.7251278, 1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294,
         1.813351, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672, 1.896603,
         1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955,
         2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483,
         2.1052605, 2.106026, 2.1099394, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519,
         2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809,
         2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3625852, 2.3682149, 2.3738278, 2.385697,
         2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4952257, 2.5077018,
         2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.5957502, 2.596799, 2.6060497, 2.6097829,
         2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476,
         2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376,
         2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021,
         3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008,
         3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408,
         3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061,
         3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299,
         3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602,
         3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467,
         5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.369486, 9.512897, 9.55114,
         9.608504, 9.653919, 9.751914, 10.32004, 10.52461, 10.6857, 10.72866, 10.7931, 10.95419, 11.03212, 11.04529,
         11.21435, 11.25943, 11.32705, 11.49611, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961,
         18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551,
         39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 64.04378, 65.02405, 65.28545,
         65.67755, 66.65782, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931,
         121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835,
         253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [8.07421, 7.62222, 7.09825, 7.62497, 8.07584, 8.92457, 9.03059, 9.15381, 9.28691, 9.41862, 9.53125, 9.60064,
         9.50328, 9.28984, 9.18348, 9.00587, 9.325, 9.6179, 9.90396, 10.0524, 10.0556, 9.94564, 9.70585, 9.2852,
         8.54989, 6.97692, 5.07695, 2.01609, -1.66293, 2.20774, 5.03434, 5.5809, 9.04873, 10.0316, 9.46532, 8.11001,
         7.61463, 6.34795, 8.26411, 10.0071, 11.6878, 12.7823, 13.2949, 13.4529, 13.3571, 13.1397, 12.8444, 12.6033,
         12.5128, 12.485, 12.4699, 12.4674, 12.4235, 12.2607, 12.0617, 11.9422, 11.9154, 11.9887, 12.171, 14.0652,
         14.0864, 14.1083, 14.1307, 14.1537, 14.1773, 14.2014, 14.226, 14.2512, 14.277, 14.3033, 14.3301, 14.3575,
         14.3854, 14.4139, 14.4429, 14.4724, 14.5025, 14.533, 14.5641, 14.5958, 14.6279, 14.6605, 14.6936, 14.7273,
         14.7614, 14.796, 14.8312, 14.8668, 14.9029, 14.9394, 14.9765, 15.014, 15.052, 15.0904, 15.1293, 15.1687,
         15.2085, 15.2488, 15.2895, 15.3306, 15.3722, 15.4142, 15.4566, 15.4994, 15.5427, 15.5863, 15.6304, 15.6748,
         15.7197, 15.7649, 15.8106, 15.8566, 15.903, 15.9497, 15.9968, 16.0443, 16.0921, 16.1403, 16.1888, 16.2377,
         16.2869, 16.3364, 16.3862, 16.4364, 16.4868, 16.5376, 16.5886, 16.64, 16.6916, 16.7435, 16.7957, 16.8482,
         16.9009, 16.9538, 17.007, 17.0605, 17.1142, 17.1681, 17.2222, 17.2765, 17.3311, 17.3858, 17.4407, 17.4958,
         17.5511, 17.6066, 17.6622, 17.7179, 17.7738, 17.8298, 17.8859, 17.9422, 17.9985, 18.055, 18.1115, 18.1681,
         18.2247, 18.2814, 18.3382, 18.3949, 18.4517, 18.5085, 18.5652, 18.6219, 18.6786, 18.7352, 18.7917, 18.8481,
         18.9044, 18.9605, 19.0165, 19.0723, 19.1279, 19.1832, 19.2383, 19.293, 19.3475, 19.4015, 19.4552, 19.5084,
         19.5611, 19.6133, 19.6649, 19.7158, 19.7659, 19.8153, 19.8638, 19.9113, 19.9577, 20.003, 20.0469, 20.0893,
         20.13, 20.171, 20.2078, 20.2422, 20.2739, 20.3025, 20.3275, 20.3483, 20.3642, 20.3743, 20.3772, 20.3713,
         20.3544, 20.3232, 20.2725, 20.1942, 20.0733, 19.8782, 19.5191, 18.4033, 17.9915, 18.0336, 19.3322, 20.0728,
         20.4815, 20.7598, 20.9582, 21.0913, 21.1533, 21.1048, 20.7351, 20.1824, 20.2635, 20.9271, 21.7506, 22.2159,
         22.5684, 22.8618, 23.1173, 23.3457, 23.5535, 23.7447, 23.9221, 24.0876, 24.2428, 24.3895, 24.5288, 24.6618,
         24.7893, 24.9118, 25.0299, 25.144, 25.2543, 25.3612, 25.4652, 25.5668, 25.6664, 25.7644, 25.8609, 25.9563,
         26.0507, 26.1443, 26.2373, 26.3297, 26.4216, 26.5133, 26.6048, 26.6961, 26.7874, 26.8787, 26.9702, 27.0617,
         27.1535, 27.2455, 27.3379, 27.4306, 27.5237, 27.6173, 27.7114, 27.806, 27.9012, 27.997, 28.0934, 28.1962,
         28.3021, 28.408, 28.514, 28.62, 28.7262, 28.8325, 28.9391, 29.046, 29.1532, 29.2608, 29.3689, 29.4773, 29.5883,
         29.7002, 29.8122, 29.9243, 30.0365, 30.149, 30.2617, 30.3746, 30.4878, 30.6016, 30.7163, 30.8286, 30.9386,
         31.0463, 31.1517, 31.2549, 31.3558, 31.4544, 31.5508, 31.645, 31.7368, 31.8263, 31.9135, 31.9982, 32.0804,
         32.16, 32.2369, 32.3109, 32.3819, 32.4497, 32.514, 32.5744, 32.6305, 32.6818, 32.7275, 32.7665, 32.7974,
         32.8179, 32.8248, 32.8122, 32.7692, 32.6703, 32.4286, 31.9507, 31.6709, 31.9886, 32.6859, 33.0324, 33.2722,
         33.4656, 33.6327, 33.7826, 33.9203, 34.0487, 34.1698, 34.2848, 34.3947, 34.5002, 34.6018, 34.6998, 34.7946,
         34.8862, 34.9748, 35.0605, 35.1431, 35.2226, 35.2986, 35.3706, 35.4378, 35.4985, 35.5496, 35.5832, 35.5686,
         35.5062, 35.5521, 35.5628, 35.7992, 35.9405, 36.0587, 36.1657, 36.266, 36.3617, 36.4539, 36.5433, 36.6305,
         36.7157, 36.7992, 36.8811, 36.9617, 37.0409, 37.119, 37.1959, 37.2717, 37.3465, 37.4203, 37.493, 37.5648,
         37.6356, 37.7053, 37.774, 37.8417, 37.9082, 37.9735, 38.0376, 38.1004, 38.1616, 38.2211, 38.2786, 38.3339,
         38.3864, 38.4355, 38.4801, 38.5185, 38.5477, 38.5615, 38.5434, 38.409, 38.3715, 38.4161, 38.5364, 38.7738,
         38.9261, 39.0511, 39.1623, 39.2652, 39.3625, 39.4556, 39.5456, 39.6331, 39.7186, 39.8024, 39.8847, 39.9658,
         40.0457, 40.1247, 40.2027, 40.28, 40.3565, 40.4323, 40.5074, 40.582, 40.656, 40.7295, 40.8024, 40.8749,
         40.9468, 41.0183, 41.0893, 41.1599, 41.2301, 41.2999, 41.3692, 41.4381, 41.5066, 41.5614, 41.629, 41.6963,
         41.7632, 41.8297, 41.8958, 41.9616, 42.0269, 42.0919, 42.1505, 42.2147, 42.2786, 42.3421, 42.4052, 42.468,
         42.5303, 42.5923, 42.654, 42.7152, 42.7761, 42.8366, 42.8967, 42.9565, 43.0159, 43.0749, 43.1336, 43.1919,
         43.2499, 43.3075, 43.3646, 43.4214, 43.4776, 43.5335, 43.5889, 43.644, 43.6985, 43.7527, 43.8064, 43.8597,
         43.9126, 43.9651, 44.0172, 44.0688, 44.12, 44.1708, 44.2213, 44.2713, 44.3209, 44.3701, 44.4189, 44.4674,
         44.5154, 44.5631, 44.6105, 44.6575, 44.7041, 44.7504, 44.7964, 44.8421, 44.8875, 44.9327, 44.9776, 45.0222,
         45.0666, 45.1108, 45.1549, 45.1988, 45.2426, 45.2863, 45.3301, 45.3739, 45.4177, 45.4617, 45.5058, 45.5503,
         45.5951, 45.6404, 45.6864, 45.7333, 45.7811, 45.8301, 45.8807, 45.933, 45.9876, 46.0449, 46.1055, 46.1702,
         46.2401, 46.3166, 46.374, 46.3772, 46.3782, 46.3771, 46.3742, 46.3696, 46.3632, 46.3551, 46.3454, 46.3341,
         46.3212, 46.3067, 46.2907, 46.2731, 46.2539, 46.2332, 46.2109, 46.1871, 46.1617, 46.1347, 46.1062, 46.076,
         46.0443, 46.011, 45.976, 45.9394, 45.9011, 45.8595, 45.8179, 45.7745, 45.7294, 45.6825, 45.6339, 45.5833,
         45.5309, 45.4766, 45.4203, 45.362, 45.3017, 45.2393, 45.1747, 45.108, 45.039, 44.9677, 44.894, 44.8179,
         44.7392, 44.6579, 44.574, 44.4873, 44.3977, 44.3052, 44.2095, 44.1107, 44.0095, 43.904, 43.7949, 43.6821,
         43.5654, 43.4447, 43.3197, 43.1903, 43.0563, 42.9174, 42.7733, 42.6239, 42.4689, 42.3078, 42.1404, 41.9663,
         41.7852, 41.5964, 41.3996, 41.1943, 40.9797, 40.7553, 40.5203, 40.2739, 40.0152, 39.7431, 39.4564, 39.1538,
         38.8338, 38.4945, 38.1339, 37.7496, 37.3385, 36.8973, 36.4219, 35.9073, 35.3473, 34.734, 34.0573, 33.3039,
         32.4556, 31.4868, 30.3613, 29.0148, 27.3439, 25.138, 21.8562, 14.9802, -0.922329, -1.24775, 14.6692, 20.6909,
         23.087, 24.1856, 24.3088, 22.9893, 13.4871, 8.18242, 13.4382, 25.2606, 28.8729, 31.2774, 33.1437, 34.6916,
         36.0234, 37.1964, 38.2463, 39.1971, 40.066, 40.8655, 41.6053, 42.2928, 42.9342, 43.5342, 44.0969, 44.6256,
         45.123, 45.5915, 46.033, 46.4492, 46.8414, 47.2106, 47.5578, 47.8837, 48.1885, 48.4726, 48.7359, 48.9779,
         49.198, 49.3949, 49.5668, 49.7109, 49.8232, 49.8973, 49.9234, 49.8846, 49.7497, 49.45, 48.7803, 46.5603,
         45.9823, 46.61, 48.8117, 50.2415, 51.131, 51.8076, 52.3662, 52.8464, 53.2687, 53.6453, 53.9832, 54.2854,
         54.5633, 54.8228, 55.0631, 55.2843, 55.4865, 55.6691, 55.8303, 55.9673, 56.0743, 56.1405, 56.1421, 56.0115,
         55.3232, 55.2231, 55.2961, 56.0536, 56.776, 57.236, 57.5983, 57.9062, 58.1776, 58.4214, 58.6426, 58.8438,
         59.0255, 59.1919, 59.3466, 59.4879, 59.614, 59.7214, 59.8036, 59.8462, 59.8088, 59.5217, 59.4512, 59.6441,
         59.8917, 60.3839, 60.7114, 60.9801, 61.2172, 61.4339, 61.6361, 61.8272, 62.0092, 62.1837, 62.3521, 62.5148,
         62.6724, 62.8253, 62.9741, 63.1191, 63.2608, 63.3993, 63.5351, 63.6683, 63.7992, 63.9282, 64.0556, 64.1816,
         64.307, 64.4323, 64.5588, 64.6888, 64.8273, 64.9674, 65.0948, 65.2135, 65.3258, 65.433, 65.5355, 65.6339,
         65.7287, 65.8203, 65.909, 65.9951, 66.0786, 66.1599, 66.239, 66.3161, 66.3913, 66.4647, 66.5365, 66.6066,
         66.6753, 66.9563, 67.022, 67.0856, 67.1473, 67.207, 67.2649, 67.4643, 67.519, 67.5714, 67.6219, 67.6704,
         67.7171, 67.7622, 67.8056, 67.8474, 67.8877, 67.9266, 67.9642, 68.0004, 68.0354, 68.0691, 68.1017, 68.1331,
         68.1635, 68.1928, 68.2211, 68.2484, 68.2748, 68.3002, 68.3248, 68.3485, 68.3714, 68.3935, 68.4148, 68.4354,
         68.4552, 68.4744, 68.9327, 69.1536, 69.1625, 69.1439, 69.0244, 68.8248, 68.5712, 68.2652, 67.8987, 67.4502,
         66.8549, 65.9896, 64.4545, 62.3361, 59.4352, 56.021, 59.4578, 60.9185, 62.4638, 64.5998, 64.3529, 63.1524,
         61.4934, 63.2855, 64.899, 65.218, 65.2568, 65.2382, 64.5312, 65.5849, 66.7877, 67.8684, 69.5052, 70.4863,
         71.1522, 71.6018, 71.8997, 72.0921, 72.2104, 72.3359, 72.3919, 72.4141, 72.3832, 72.3387, 72.2919, 72.2127,
         72.1207, 72.0209, 71.9153, 71.8046, 71.6879, 71.5613, 71.4197, 71.252, 71.0351, 70.7149, 70.0604, 69.4683,
         68.3536, 67.0188, 68.3677, 69.5858, 69.7049, 70.9895, 71.5015, 71.8021, 71.9969, 72.1242, 72.2082, 72.263,
         72.2974, 72.3173, 72.3272, 72.356, 72.3494, 72.3382, 72.3239, 72.3076, 72.2902, 72.2722, 72.2541, 72.2361,
         72.2185, 72.2012, 72.1845, 72.1691, 72.1552, 72.1423, 72.1305, 72.1195, 72.1094],
        [0.0, 0.0, 0.0, 1.0218, 1.0141, 1.9327, 2.0717, 2.1926, 2.2883, 2.353, 2.3829, 2.3763, 2.3483, 2.3358, 2.3338,
         2.3322, 2.9002, 2.8639, 2.7511, 2.5735, 2.4055, 2.2437, 2.0894, 1.9469, 1.8213, 1.7179, 1.6794, 1.6625, 1.6584,
         8.898, 8.7271, 8.6669, 7.7757, 6.9188, 6.2957, 6.1146, 6.0929, 6.0677, 9.5352, 9.3044, 8.6704, 7.8368, 7.0954,
         6.4926, 6.068, 5.8379, 5.8027, 5.8945, 5.9426, 5.9533, 5.9569, 6.0278, 6.0902, 6.3289, 6.7968, 7.3742, 8.0377,
         8.7649, 9.5362, 9.9402, 9.9998, 10.06, 10.119, 10.179, 10.239, 10.299, 10.359, 10.419, 10.479, 10.539, 10.599,
         10.659, 10.719, 10.779, 10.84, 10.9, 10.96, 11.02, 11.08, 11.139, 11.199, 11.259, 11.319, 11.379, 11.438,
         11.498, 11.557, 11.617, 11.676, 11.735, 11.794, 11.853, 11.912, 11.971, 12.03, 12.088, 12.147, 12.205, 12.263,
         12.321, 12.379, 12.437, 12.495, 12.552, 12.609, 12.667, 12.724, 12.78, 12.837, 12.894, 12.95, 13.006, 13.062,
         13.118, 13.173, 13.229, 13.284, 13.339, 13.394, 13.448, 13.503, 13.557, 13.611, 13.665, 13.718, 13.772, 13.825,
         13.878, 13.93, 13.983, 14.035, 14.087, 14.139, 14.191, 14.242, 14.293, 14.344, 14.395, 14.445, 14.495, 14.545,
         14.595, 14.644, 14.694, 14.743, 14.791, 14.84, 14.888, 14.936, 14.984, 15.032, 15.079, 15.126, 15.173, 15.22,
         15.266, 15.312, 15.358, 15.404, 15.449, 15.494, 15.539, 15.584, 15.628, 15.672, 15.716, 15.76, 15.803, 15.847,
         15.89, 15.932, 15.975, 16.017, 16.059, 16.101, 16.143, 16.184, 16.225, 16.266, 16.307, 16.347, 16.387, 16.427,
         16.467, 16.506, 16.546, 16.585, 16.624, 16.662, 16.701, 16.739, 16.777, 16.815, 16.852, 16.89, 16.927, 16.964,
         17.001, 17.037, 17.074, 17.11, 17.146, 17.182, 17.217, 17.253, 17.288, 17.323, 17.358, 17.392, 17.427, 17.461,
         17.495, 17.499, 19.932, 19.917, 19.891, 19.868, 19.845, 19.824, 19.803, 19.784, 19.766, 19.75, 19.744, 21.474,
         21.455, 21.396, 21.339, 21.284, 21.231, 21.18, 21.131, 21.084, 21.039, 20.995, 20.954, 20.915, 20.879, 20.846,
         20.816, 20.788, 20.762, 20.739, 20.718, 20.699, 20.682, 20.668, 20.657, 20.648, 20.642, 20.637, 20.635, 20.635,
         20.636, 20.639, 20.644, 20.65, 20.658, 20.667, 20.678, 20.69, 20.703, 20.717, 20.732, 20.748, 20.766, 20.784,
         20.803, 20.823, 20.845, 20.866, 20.889, 20.913, 20.937, 20.962, 20.979, 20.99, 21.003, 21.016, 21.029, 21.043,
         21.057, 21.072, 21.087, 21.102, 21.118, 21.135, 21.152, 21.161, 21.167, 21.173, 21.179, 21.186, 21.193, 21.2,
         21.207, 21.215, 21.216, 21.163, 21.109, 21.056, 21.003, 20.949, 20.896, 20.843, 20.79, 20.737, 20.684, 20.631,
         20.578, 20.525, 20.472, 20.42, 20.367, 20.315, 20.262, 20.21, 20.158, 20.106, 20.054, 20.002, 19.951, 19.899,
         19.848, 19.796, 19.745, 19.694, 19.644, 19.593, 19.543, 19.492, 19.461, 20.771, 20.765, 20.724, 20.678, 20.632,
         20.587, 20.541, 20.496, 20.451, 20.406, 20.361, 20.317, 20.273, 20.228, 20.185, 20.141, 20.097, 20.054, 20.011,
         19.968, 19.925, 19.883, 19.841, 19.799, 19.757, 19.715, 19.673, 19.632, 19.591, 19.574, 19.892, 19.891, 19.851,
         19.812, 19.774, 19.735, 19.696, 19.658, 19.62, 19.582, 19.544, 19.506, 19.469, 19.431, 19.394, 19.357, 19.32,
         19.283, 19.246, 19.209, 19.173, 19.136, 19.1, 19.063, 19.027, 18.991, 18.955, 18.919, 18.883, 18.847, 18.811,
         18.776, 18.74, 18.704, 18.668, 18.633, 18.597, 18.561, 18.526, 18.49, 18.455, 18.419, 18.383, 18.38, 18.884,
         18.874, 18.839, 18.805, 18.77, 18.735, 18.7, 18.665, 18.63, 18.595, 18.56, 18.524, 18.489, 18.454, 18.418,
         18.382, 18.347, 18.311, 18.275, 18.239, 18.202, 18.166, 18.13, 18.093, 18.056, 18.019, 17.982, 17.945, 17.907,
         17.87, 17.832, 17.794, 17.756, 17.718, 17.679, 17.641, 17.602, 17.563, 17.524, 17.484, 17.445, 17.405, 17.365,
         17.325, 17.285, 17.244, 17.204, 17.163, 17.122, 17.08, 17.039, 16.997, 16.956, 16.913, 16.871, 16.829, 16.786,
         16.744, 16.701, 16.657, 16.614, 16.571, 16.527, 16.483, 16.439, 16.394, 16.349, 16.304, 16.259, 16.213, 16.168,
         16.122, 16.076, 16.03, 15.983, 15.937, 15.89, 15.843, 15.796, 15.749, 15.702, 15.655, 15.607, 15.559, 15.511,
         15.463, 15.415, 15.367, 15.319, 15.27, 15.221, 15.173, 15.124, 15.075, 15.026, 14.976, 14.927, 14.877, 14.828,
         14.778, 14.728, 14.678, 14.628, 14.578, 14.528, 14.477, 14.427, 14.376, 14.325, 14.275, 14.224, 14.173, 14.122,
         14.071, 14.02, 13.969, 13.919, 13.868, 13.817, 13.767, 13.716, 13.666, 13.616, 13.566, 13.516, 13.453, 13.365,
         13.277, 13.191, 13.105, 13.02, 12.935, 12.851, 12.768, 12.686, 12.604, 12.523, 12.443, 12.364, 12.285, 12.206,
         12.129, 12.052, 11.976, 11.9, 11.825, 11.751, 11.677, 11.604, 11.531, 11.459, 11.388, 11.317, 11.247, 11.177,
         11.108, 11.04, 10.972, 10.905, 10.838, 10.772, 10.706, 10.641, 10.576, 10.512, 10.449, 10.386, 10.323, 10.261,
         10.199, 10.138, 10.078, 10.017, 9.9578, 9.8986, 9.8399, 9.7817, 9.7239, 9.6666, 9.6098, 9.5534, 9.4974, 9.4419,
         9.3869, 9.3322, 9.278, 9.2242, 9.1709, 9.118, 9.0654, 9.0133, 8.9616, 8.9103, 8.8594, 8.8089, 8.7588, 8.7091,
         8.6597, 8.6108, 8.5622, 8.514, 8.4662, 8.4187, 8.3716, 8.3249, 8.2785, 8.2325, 8.1868, 8.1415, 8.0962, 8.05,
         8.0041, 7.9586, 7.9134, 7.8686, 7.8241, 7.78, 7.7362, 7.6927, 7.6496, 7.6067, 7.5643, 7.5221, 7.4802, 7.4387,
         7.3975, 7.3566, 7.3381, 26.04, 25.949, 25.759, 25.57, 25.383, 25.198, 25.014, 24.846, 37.092, 37.079, 36.816,
         36.543, 36.272, 36.002, 35.734, 35.468, 35.204, 34.943, 34.683, 34.425, 34.169, 33.916, 33.664, 33.414, 33.166,
         32.92, 32.676, 32.434, 32.194, 31.956, 31.719, 31.485, 31.252, 31.021, 30.792, 30.564, 30.339, 30.115, 29.892,
         29.672, 29.453, 29.236, 29.021, 28.807, 28.595, 28.385, 28.176, 27.969, 27.763, 27.559, 27.372, 27.357, 32.023,
         31.865, 31.616, 31.369, 31.124, 30.88, 30.634, 30.39, 30.147, 29.907, 29.672, 29.456, 29.241, 29.027, 28.816,
         28.607, 28.401, 28.197, 27.995, 27.796, 27.599, 27.404, 27.211, 27.02, 27.011, 28.804, 28.704, 28.494, 28.286,
         28.08, 27.876, 27.674, 27.474, 27.276, 27.079, 26.886, 26.704, 26.526, 26.349, 26.175, 26.002, 25.832, 25.663,
         25.496, 25.344, 25.331, 26.371, 26.323, 26.156, 25.991, 25.828, 25.666, 25.505, 25.345, 25.186, 25.029, 24.873,
         24.718, 24.563, 24.408, 24.254, 24.102, 23.951, 23.8, 23.651, 23.503, 23.355, 23.209, 23.063, 22.919, 22.775,
         22.632, 22.49, 22.349, 22.209, 22.068, 21.91, 21.753, 21.597, 21.442, 21.288, 21.133, 20.98, 20.828, 20.678,
         20.528, 20.38, 20.232, 20.086, 19.941, 19.798, 19.655, 19.513, 19.373, 19.234, 19.096, 18.955, 18.811, 18.669,
         18.528, 18.388, 18.249, 18.111, 17.969, 17.829, 17.69, 17.553, 17.416, 17.281, 17.147, 17.015, 16.883, 16.753,
         16.624, 16.496, 16.369, 16.244, 16.119, 15.996, 15.874, 15.753, 15.633, 15.514, 15.397, 15.28, 15.164, 15.05,
         14.936, 14.824, 14.712, 14.602, 14.492, 14.384, 14.024, 12.659, 11.413, 10.286, 9.2735, 8.3649, 7.5559, 6.8346,
         6.1907, 5.6052, 5.0609, 4.5757, 4.1277, 3.8676, 3.7646, 3.7379, 10.373, 10.263, 10.031, 8.906, 8.5827, 8.3464,
         8.2858, 11.547, 11.216, 11.063, 11.037, 10.718, 10.636, 12.203, 11.917, 11.453, 10.335, 9.312, 8.3767, 7.513,
         6.7329, 6.0332, 5.4086, 4.8448, 4.3415, 3.8876, 3.4797, 3.1172, 2.7722, 2.4608, 2.1862, 1.9439, 1.7298, 1.5404,
         1.3723, 1.2211, 1.0864, 0.96347, 0.85374, 0.75663, 0.67096, 0.64276, 0.62552, 0.62105, 3.2419, 3.1695, 3.1561,
         2.8423, 2.5508, 2.2872, 2.0458, 1.8267, 1.6314, 1.4571, 1.3016, 1.1628, 1.039, 0.92499, 0.82342, 0.73307,
         0.65271, 0.5812, 0.51758, 0.46096, 0.41057, 0.36571, 0.32579, 0.29024, 0.25925, 0.23263, 0.20876, 0.18735,
         0.16815, 0.15093, 0.13548]],
    'Ta':                                                                                                         [
        [0.005586, 0.0056715, 0.0056943, 0.0057285, 0.005814, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.0245,
         0.024875, 0.024975, 0.025125, 0.02545001, 0.0255, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846,
         0.035672, 0.036218, 0.0363636, 0.036582, 0.037128, 0.03797993, 0.04060054, 0.04340198, 0.044002, 0.0446755,
         0.0448551, 0.0451245, 0.045798, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028,
         0.06923942, 0.069678, 0.0707445, 0.0710289, 0.0714555, 0.072522, 0.07401695, 0.07912411, 0.08458368,
         0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294,
         0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712,
         0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956,
         0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029,
         0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979,
         0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902,
         0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944,
         0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305,
         0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239,
         0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058,
         0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134,
         0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902,
         0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862,
         0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585,
         0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712,
         0.19509776, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961,
         0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128,
         0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109,
         0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948, 0.22885808, 0.22912551, 0.2294745, 0.23000237,
         0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422, 0.23936509, 0.24056191,
         0.24111348, 0.24148653, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893,
         0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567,
         0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747,
         0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845,
         0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381,
         0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873, 0.31178993,
         0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438,
         0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602,
         0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502,
         0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665, 0.37311293,
         0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718, 0.38636941, 0.38830126, 0.39024276,
         0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737, 0.4039782, 0.40410785, 0.40502181,
         0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789, 0.42266068,
         0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756, 0.43986595, 0.44206528,
         0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075,
         0.46412139, 0.46467255, 0.46547861, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815,
         0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782, 0.50076959,
         0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444, 0.52376021,
         0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691, 0.54508094, 0.54780635,
         0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56457826, 0.56642179, 0.56726958,
         0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325,
         0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526,
         0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253,
         0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045,
         0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641,
         0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322,
         0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656,
         0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515,
         0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084,
         0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881,
         0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765,
         0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959,
         0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606,
         1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579,
         1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143,
         1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659,
         1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555,
         1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335,
         1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577,
         1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942,
         1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176,
         1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5770017, 1.5848867, 1.5928111,
         1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6494027, 1.6576497, 1.665938, 1.6742677,
         1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278, 1.7337534, 1.7347877, 1.7354123, 1.7424222,
         1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7926172, 1.7937828, 1.7953526, 1.8043294, 1.813351,
         1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672, 1.896603, 1.906086,
         1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955, 2.0035635,
         2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.106026,
         2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561, 2.1963695, 2.2027149,
         2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3038428, 2.315362,
         2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699,
         2.4459388, 2.4581685, 2.4657375, 2.4704593, 2.4716624, 2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415,
         2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714,
         2.6756832, 2.6890617, 2.702507, 2.7027735, 2.7132264, 2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486,
         2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451,
         2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879,
         3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477,
         3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514,
         3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962,
         3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247,
         3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452,
         3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453,
         6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 9.683478, 9.831694, 9.871219, 9.930505,
         10.07872, 10.32004, 10.91338, 11.03212, 11.08042, 11.12496, 11.19178, 11.35882, 11.44787, 11.62309, 11.66982,
         11.73991, 11.79334, 11.91513, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215,
         21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992,
         44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.06807, 66.84318, 67.07932, 67.34898, 67.75348,
         68.76473, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669,
         139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869,
         290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [7.28675, 6.76355, 6.16326, 6.76103, 7.26809, 7.69658, 7.8067, 7.98392, 8.23109, 8.54464, 8.91402, 9.32207,
         9.74633, 10.186, 10.5634, 10.8749, 11.0871, 11.1318, 11.0153, 10.7494, 10.4085, 10.7805, 11.0837, 11.1091,
         11.3983, 11.2851, 10.8955, 10.1007, 7.89513, 7.57475, 5.03659, 1.99183, 5.1986, 7.98196, 9.52533, 11.1476,
         11.1433, 10.8095, 9.67052, 8.21964, 9.77292, 11.1684, 11.716, 12.9598, 13.4527, 13.5799, 13.4579, 13.168,
         12.7668, 12.723, 12.6034, 12.5498, 12.5391, 12.4678, 12.3489, 12.1364, 11.7681, 11.4742, 11.2899, 12.8748,
         12.8726, 12.8714, 12.8712, 12.8719, 12.8735, 12.8761, 12.8797, 12.8842, 12.8896, 12.896, 12.9034, 12.9116,
         12.9209, 12.931, 12.9422, 12.9542, 12.9673, 12.9802, 12.9951, 13.011, 13.0279, 13.0457, 13.0645, 13.0842,
         13.1049, 13.1265, 13.149, 13.1725, 13.1969, 13.2223, 13.2486, 13.2758, 13.3039, 13.333, 13.363, 13.3939,
         13.4257, 13.4584, 13.492, 13.5265, 13.562, 13.5983, 13.6354, 13.6735, 13.7124, 13.7522, 13.7929, 13.8344,
         13.8768, 13.92, 13.964, 14.0089, 14.0546, 14.1012, 14.1485, 14.1967, 14.2456, 14.2954, 14.3459, 14.3974,
         14.4494, 14.5023, 14.5559, 14.6102, 14.6653, 14.7211, 14.7776, 14.8348, 14.8928, 14.9514, 15.0108, 15.0708,
         15.1314, 15.1928, 15.2548, 15.3174, 15.3807, 15.4445, 15.509, 15.5741, 15.6398, 15.7061, 15.7729, 15.8404,
         15.9083, 15.9768, 16.0459, 16.1154, 16.1855, 16.2561, 16.3272, 16.3987, 16.4707, 16.5432, 16.6161, 16.6895,
         16.7632, 16.8374, 16.912, 16.987, 17.0623, 17.138, 17.2141, 17.2905, 17.3672, 17.4443, 17.5216, 17.5992,
         17.6771, 17.7552, 17.8336, 17.9123, 17.9911, 18.0701, 18.1494, 18.2288, 18.3083, 18.388, 18.4678, 18.5477,
         18.6277, 18.7078, 18.7879, 18.868, 18.9482, 19.0283, 19.1084, 19.1884, 19.2683, 19.3481, 19.4278, 19.5073,
         19.5866, 19.6657, 19.7444, 19.8229, 19.901, 19.9787, 20.0559, 20.1327, 20.2088, 20.2844, 20.3592, 20.4332,
         20.5063, 20.5785, 20.6495, 20.7192, 20.7876, 20.8543, 20.9192, 20.9841, 21.0445, 21.1022, 21.1565, 21.207,
         21.2528, 21.2929, 21.3258, 21.3495, 21.3608, 21.3548, 21.3227, 21.246, 21.0755, 20.5488, 20.1182, 20.1515,
         20.8776, 21.4396, 21.7556, 21.9858, 22.1673, 22.3129, 22.4251, 22.4973, 22.5048, 22.3329, 21.9165, 21.9736,
         22.345, 22.9759, 23.3313, 23.6106, 23.8518, 24.0694, 24.2706, 24.4594, 24.6386, 24.8097, 24.9737, 25.1317,
         25.2844, 25.4326, 25.5769, 25.7176, 25.8552, 25.9882, 26.1181, 26.2449, 26.369, 26.4904, 26.6096, 26.7268,
         26.8421, 26.9557, 27.0677, 27.1783, 27.2875, 27.3954, 27.5021, 27.6077, 27.7122, 27.8157, 27.9182, 28.0198,
         28.1205, 28.2203, 28.3193, 28.4174, 28.5149, 28.6115, 28.7074, 28.8026, 28.8971, 28.9909, 29.0841, 29.1766,
         29.2684, 29.3596, 29.4502, 29.5401, 29.6295, 29.7182, 29.8063, 29.8938, 29.9807, 30.067, 30.1527, 30.2378,
         30.3224, 30.4063, 30.4896, 30.5722, 30.6543, 30.7358, 30.8166, 30.8968, 30.9763, 31.0552, 31.1333, 31.2108,
         31.2876, 31.3637, 31.439, 31.5135, 31.5871, 31.66, 31.7319, 31.8029, 31.8729, 31.9419, 32.0097, 32.0764,
         32.1417, 32.2056, 32.268, 32.3287, 32.3875, 32.4442, 32.4985, 32.55, 32.5984, 32.6431, 32.6833, 32.7181,
         32.746, 32.7651, 32.7724, 32.7627, 32.727, 32.6455, 32.4609, 31.8647, 31.7442, 31.9057, 32.4501, 32.8876,
         33.1646, 33.3823, 33.5687, 33.7359, 33.89, 34.0346, 34.172, 34.3037, 34.4309, 34.5542, 34.6744, 34.7917,
         34.9065, 35.019, 35.1294, 35.2378, 35.3441, 35.4482, 35.55, 35.6489, 35.7443, 35.8349, 35.9182, 35.9887,
         36.0289, 35.9738, 35.8159, 36.0396, 36.2432, 36.437, 36.5981, 36.7442, 36.8813, 37.0123, 37.1385, 37.2609,
         37.38, 37.4963, 37.61, 37.7214, 37.8307, 37.9379, 38.0432, 38.1467, 38.2484, 38.3484, 38.4467, 38.5433,
         38.6383, 38.7317, 38.8234, 38.9134, 39.0017, 39.0882, 39.1728, 39.2553, 39.3356, 39.4135, 39.4885, 39.5603,
         39.6281, 39.691, 39.747, 39.7932, 39.8231, 39.8191, 39.6866, 39.6682, 39.7246, 39.8605, 40.108, 40.2747,
         40.4145, 40.5403, 40.6575, 40.7687, 40.8755, 40.9788, 41.0792, 41.1773, 41.2734, 41.3676, 41.4602, 41.5515,
         41.6414, 41.73, 41.8176, 41.9041, 41.9897, 42.0743, 42.158, 42.2409, 42.3229, 42.4041, 42.4846, 42.5643,
         42.6433, 42.7216, 42.7991, 42.876, 42.9523, 43.0278, 43.1027, 43.177, 43.2507, 43.3237, 43.3961, 43.4679,
         43.537, 43.6076, 43.6776, 43.7471, 43.8159, 43.8842, 43.9519, 44.019, 44.0855, 44.1515, 44.2237, 44.2886,
         44.3529, 44.4167, 44.4799, 44.5426, 44.6047, 44.6662, 44.7272, 44.7876, 44.8475, 44.9069, 44.9657, 45.0239,
         45.0817, 45.1389, 45.1956, 45.2517, 45.3072, 45.3622, 45.4165, 45.4703, 45.5234, 45.576, 45.628, 45.6794,
         45.7303, 45.7806, 45.8303, 45.8794, 45.928, 45.976, 46.0234, 46.0702, 46.1166, 46.1623, 46.2075, 46.2522,
         46.2963, 46.3398, 46.3829, 46.4254, 46.4674, 46.5089, 46.5499, 46.5903, 46.6304, 46.6699, 46.709, 46.7477,
         46.7859, 46.8237, 46.8612, 46.8983, 46.935, 46.9715, 47.0078, 47.0438, 47.0796, 47.1154, 47.1512, 47.1871,
         47.2233, 47.2599, 47.2974, 47.3377, 47.3679, 47.3922, 47.4135, 47.4322, 47.4487, 47.4631, 47.4754, 47.4857,
         47.494, 47.5005, 47.5051, 47.5079, 47.5088, 47.508, 47.5055, 47.5012, 47.4952, 47.4875, 47.4781, 47.467,
         47.4543, 47.44, 47.4239, 47.4063, 47.387, 47.366, 47.3434, 47.3191, 47.2932, 47.2657, 47.2364, 47.2055,
         47.1729, 47.1386, 47.1026, 47.0648, 47.0253, 46.984, 46.9387, 46.8938, 46.8471, 46.7984, 46.7478, 46.6953,
         46.6408, 46.5842, 46.5256, 46.4648, 46.4019, 46.3368, 46.2693, 46.1996, 46.1274, 46.0527, 45.9756, 45.8958,
         45.8132, 45.728, 45.6398, 45.5486, 45.4544, 45.3569, 45.2561, 45.1519, 45.0441, 44.9325, 44.8183, 44.6988,
         44.5751, 44.4469, 44.3141, 44.1763, 44.0335, 43.8852, 43.7312, 43.5713, 43.4049, 43.2318, 43.0516, 42.8638,
         42.6679, 42.4634, 42.2496, 42.0259, 41.7915, 41.5455, 41.2872, 41.0153, 40.7286, 40.4259, 40.1054, 39.7655,
         39.4038, 39.018, 38.6051, 38.1615, 37.6829, 37.1639, 36.5981, 35.977, 35.2899, 34.5223, 33.6544, 32.6576,
         31.4889, 30.0801, 28.2994, 25.8762, 22.0117, 10.0711, 1.51614, 1.19537, 19.342, 23.4233, 25.2767, 26.0669,
         25.9037, 23.9938, 15.3905, 15.3399, 20.5553, 27.87, 31.0235, 33.2274, 34.9701, 36.4297, 37.6932, 38.8107,
         39.8139, 40.7245, 41.558, 42.326, 43.0373, 43.699, 44.3166, 44.8947, 45.4369, 45.9464, 46.4258, 46.8771,
         47.3022, 47.7026, 48.0794, 48.4337, 48.7662, 49.0774, 49.3674, 49.6364, 49.884, 50.1095, 50.3117, 50.4889,
         50.6384, 50.7562, 50.8362, 50.8686, 50.8373, 50.7121, 50.4274, 49.7924, 47.3967, 47.5241, 49.6584, 51.1518,
         52.064, 52.7545, 53.3238, 53.8141, 54.2458, 54.631, 54.9771, 55.2874, 55.5725, 55.8396, 56.0885, 56.3185,
         56.53, 56.7226, 56.8952, 57.0457, 57.1701, 57.2608, 57.303, 57.2607, 57.0077, 56.3718, 56.1112, 56.4484,
         57.5794, 58.152, 58.5644, 58.9024, 59.1946, 59.4544, 59.6887, 59.9011, 60.0933, 60.2657, 60.4255, 60.5724,
         60.7044, 60.8183, 60.9079, 60.9602, 60.9393, 60.6585, 60.6437, 60.7657, 60.9564, 61.4815, 61.8198, 62.0959,
         62.3394, 62.5624, 62.7708, 62.9684, 63.1572, 63.3389, 63.5148, 63.6858, 63.8525, 64.0155, 64.1756, 64.3333,
         64.4893, 64.6444, 64.7995, 64.9561, 65.1254, 65.2708, 65.4014, 65.5258, 65.6455, 65.7613, 65.8737, 65.9828,
         66.0889, 66.1921, 66.2928, 66.3909, 66.4866, 66.5802, 66.6716, 66.7605, 66.8471, 66.9315, 67.0138, 67.0941,
         67.1725, 67.2491, 67.324, 67.3972, 67.4688, 67.5389, 67.6075, 67.6748, 67.7408, 67.8056, 68.0766, 68.1386,
         68.1987, 68.2569, 68.3133, 68.3681, 68.5614, 68.6131, 68.6628, 68.7107, 68.7567, 68.8009, 68.8436, 68.8847,
         68.9244, 68.9626, 68.9994, 69.035, 69.0693, 69.1024, 69.1343, 69.1651, 69.1948, 69.2235, 69.2511, 69.2778,
         69.3036, 69.3284, 69.7903, 69.9592, 70.1464, 70.1733, 70.0792, 69.9372, 69.7167, 69.4432, 69.114, 68.7163,
         68.2155, 67.5254, 66.4617, 63.714, 63.4252, 60.5401, 57.1434, 60.5654, 63.5612, 65.0977, 65.4822, 64.8825,
         64.305, 62.7014, 64.4029, 65.931, 66.2523, 66.2303, 65.5306, 66.5825, 67.0814, 67.7871, 69.7701, 71.0512,
         71.8606, 72.4049, 72.7659, 73.0023, 73.1523, 73.3039, 73.3452, 73.3888, 73.4025, 73.3713, 73.3311, 73.2561,
         73.1674, 73.0703, 72.9671, 72.8589, 72.7455, 72.6247, 72.4914, 72.3388, 72.1497, 71.8904, 71.4546, 70.4835,
         69.8055, 69.3757, 68.0495, 69.3893, 70.5993, 71.5926, 72.3062, 72.6821, 72.9153, 73.0695, 73.1707, 73.2373,
         73.2801, 73.306, 73.32, 73.3528, 73.3493, 73.3401, 73.3273, 73.3121, 73.2954, 73.2778, 73.2599, 73.242,
         73.2244, 73.2072, 73.1903, 73.1743, 73.1599, 73.1467, 73.1345, 73.1233, 73.113],
        [0.0, 0.0, 0.0, 1.1669, 1.1599, 2.5477, 2.8946, 3.2454, 3.5808, 3.8799, 4.1228, 4.2927, 4.3785, 4.3754, 4.2858,
         4.1184, 3.8864, 3.6051, 3.4725, 3.4002, 3.3809, 4.0323, 3.9475, 3.9346, 3.5119, 3.1071, 2.7577, 2.4597, 2.2126,
         2.1993, 2.151, 2.1387, 8.1125, 7.8708, 7.5184, 6.5983, 5.7736, 5.616, 5.4478, 5.4045, 8.2372, 8.0408, 7.8751,
         7.1262, 6.4845, 5.9403, 5.5463, 5.3333, 5.3146, 5.323, 5.3504, 5.3593, 5.4288, 5.473, 5.5495, 5.9225, 6.4758,
         7.1961, 8.0678, 8.5641, 8.6395, 8.7155, 8.7918, 8.8686, 8.9457, 9.0233, 9.1013, 9.1796, 9.2583, 9.3373, 9.4166,
         9.4962, 9.5762, 9.6566, 9.7375, 9.8187, 9.9001, 9.9818, 10.064, 10.146, 10.228, 10.31, 10.393, 10.476, 10.559,
         10.642, 10.725, 10.808, 10.891, 10.974, 11.058, 11.141, 11.225, 11.308, 11.391, 11.475, 11.558, 11.642, 11.725,
         11.808, 11.891, 11.975, 12.058, 12.141, 12.223, 12.306, 12.388, 12.471, 12.553, 12.635, 12.717, 12.799, 12.88,
         12.961, 13.042, 13.123, 13.203, 13.284, 13.364, 13.443, 13.523, 13.602, 13.681, 13.759, 13.837, 13.915, 13.993,
         14.07, 14.147, 14.223, 14.299, 14.375, 14.45, 14.525, 14.6, 14.674, 14.747, 14.821, 14.893, 14.966, 15.038,
         15.109, 15.18, 15.251, 15.321, 15.391, 15.46, 15.529, 15.597, 15.664, 15.732, 15.798, 15.865, 15.93, 15.996,
         16.06, 16.125, 16.188, 16.251, 16.314, 16.376, 16.438, 16.499, 16.559, 16.619, 16.679, 16.737, 16.796, 16.854,
         16.911, 16.967, 17.024, 17.079, 17.134, 17.189, 17.243, 17.296, 17.349, 17.401, 17.453, 17.504, 17.554, 17.604,
         17.654, 17.703, 17.751, 17.799, 17.846, 17.893, 17.939, 17.984, 18.03, 18.074, 18.118, 18.161, 18.204, 18.247,
         18.288, 18.33, 18.37, 18.41, 18.45, 18.489, 18.528, 18.566, 18.603, 18.64, 18.677, 18.713, 18.748, 18.783,
         18.818, 18.852, 18.885, 18.918, 18.951, 18.983, 19.014, 19.045, 19.076, 19.106, 19.136, 19.165, 19.194, 19.222,
         19.25, 19.256, 20.798, 20.801, 20.809, 20.816, 20.822, 20.829, 20.836, 20.842, 20.848, 20.854, 20.86, 20.862,
         21.999, 21.997, 21.985, 21.974, 21.963, 21.951, 21.94, 21.929, 21.918, 21.907, 21.895, 21.875, 21.856, 21.837,
         21.819, 21.801, 21.784, 21.767, 21.743, 21.719, 21.696, 21.673, 21.65, 21.629, 21.608, 21.587, 21.567, 21.548,
         21.529, 21.51, 21.492, 21.474, 21.457, 21.439, 21.422, 21.406, 21.389, 21.373, 21.357, 21.341, 21.325, 21.309,
         21.294, 21.278, 21.263, 21.248, 21.233, 21.218, 21.203, 21.188, 21.173, 21.159, 21.144, 21.129, 21.115, 21.1,
         21.086, 21.071, 21.057, 21.043, 21.028, 21.014, 21.0, 20.986, 20.971, 20.957, 20.943, 20.929, 20.915, 20.901,
         20.887, 20.873, 20.859, 20.845, 20.832, 20.818, 20.804, 20.791, 20.777, 20.764, 20.75, 20.737, 20.723, 20.71,
         20.697, 20.684, 20.67, 20.657, 20.644, 20.631, 20.619, 20.606, 20.593, 20.58, 20.568, 20.555, 20.543, 20.531,
         20.518, 20.506, 20.494, 20.482, 20.47, 20.458, 20.447, 20.446, 21.823, 21.819, 21.811, 21.803, 21.795, 21.788,
         21.78, 21.772, 21.765, 21.757, 21.75, 21.743, 21.736, 21.729, 21.721, 21.714, 21.707, 21.701, 21.694, 21.687,
         21.68, 21.673, 21.667, 21.66, 21.653, 21.647, 21.64, 21.633, 21.628, 21.627, 21.972, 21.969, 21.964, 21.915,
         21.864, 21.813, 21.762, 21.712, 21.661, 21.61, 21.559, 21.509, 21.458, 21.407, 21.357, 21.306, 21.256, 21.205,
         21.154, 21.104, 21.054, 21.003, 20.953, 20.902, 20.852, 20.801, 20.751, 20.701, 20.65, 20.6, 20.549, 20.499,
         20.448, 20.398, 20.347, 20.297, 20.246, 20.196, 20.145, 20.095, 20.092, 20.59, 20.575, 20.525, 20.475, 20.425,
         20.375, 20.325, 20.275, 20.225, 20.175, 20.125, 20.074, 20.024, 19.973, 19.923, 19.872, 19.822, 19.771, 19.72,
         19.669, 19.619, 19.568, 19.516, 19.465, 19.414, 19.363, 19.311, 19.259, 19.208, 19.156, 19.104, 19.052, 19.0,
         18.948, 18.895, 18.843, 18.79, 18.738, 18.685, 18.632, 18.579, 18.526, 18.472, 18.419, 18.365, 18.312, 18.258,
         18.204, 18.15, 18.096, 18.042, 17.988, 17.933, 17.879, 17.824, 17.77, 17.715, 17.66, 17.605, 17.55, 17.495,
         17.44, 17.385, 17.329, 17.274, 17.219, 17.163, 17.107, 17.051, 16.995, 16.938, 16.882, 16.825, 16.769, 16.712,
         16.656, 16.599, 16.542, 16.485, 16.428, 16.371, 16.314, 16.257, 16.2, 16.143, 16.086, 16.029, 15.971, 15.914,
         15.857, 15.799, 15.742, 15.685, 15.627, 15.57, 15.513, 15.455, 15.398, 15.341, 15.283, 15.226, 15.169, 15.111,
         15.054, 14.996, 14.939, 14.882, 14.824, 14.767, 14.709, 14.652, 14.595, 14.538, 14.481, 14.424, 14.355, 14.26,
         14.166, 14.073, 13.98, 13.888, 13.798, 13.707, 13.618, 13.53, 13.442, 13.355, 13.268, 13.183, 13.098, 13.014,
         12.93, 12.848, 12.766, 12.685, 12.604, 12.524, 12.445, 12.366, 12.288, 12.211, 12.134, 12.058, 11.983, 11.908,
         11.834, 11.761, 11.688, 11.616, 11.544, 11.473, 11.402, 11.332, 11.263, 11.194, 11.126, 11.058, 10.991, 10.925,
         10.859, 10.793, 10.728, 10.664, 10.6, 10.536, 10.473, 10.411, 10.349, 10.288, 10.227, 10.166, 10.106, 10.047,
         9.988, 9.9294, 9.8713, 9.8137, 9.7565, 9.6997, 9.6434, 9.5875, 9.5321, 9.4771, 9.4226, 9.3684, 9.3147, 9.2614,
         9.2086, 9.1561, 9.104, 9.0524, 9.0011, 8.9502, 8.8998, 8.8497, 8.8, 8.7507, 8.7017, 8.6532, 8.605, 8.5571,
         8.5097, 8.4626, 8.4158, 8.3694, 8.3234, 8.2777, 8.2324, 8.1874, 8.1427, 8.0984, 8.0544, 8.0094, 7.9646, 7.9201,
         7.876, 7.8322, 7.7887, 7.7455, 7.7027, 7.6602, 7.618, 7.5761, 7.5346, 7.4933, 7.4524, 7.4475, 25.774, 25.625,
         25.441, 25.259, 25.078, 24.899, 24.721, 24.598, 36.635, 36.588, 36.322, 36.057, 35.794, 35.534, 35.275, 35.019,
         34.764, 34.51, 34.259, 34.009, 33.761, 33.515, 33.271, 33.029, 32.788, 32.55, 32.313, 32.078, 31.845, 31.614,
         31.384, 31.157, 30.931, 30.706, 30.484, 30.263, 30.043, 29.826, 29.61, 29.396, 29.183, 28.972, 28.763, 28.555,
         28.349, 28.144, 27.941, 27.74, 27.54, 27.341, 32.008, 31.866, 31.621, 31.377, 31.136, 30.897, 30.658, 30.416,
         30.176, 29.937, 29.704, 29.489, 29.278, 29.066, 28.856, 28.648, 28.442, 28.239, 28.038, 27.84, 27.643, 27.449,
         27.256, 27.066, 26.949, 28.778, 28.758, 28.566, 28.356, 28.148, 27.942, 27.738, 27.536, 27.335, 27.137, 26.94,
         26.752, 26.572, 26.395, 26.22, 26.047, 25.876, 25.707, 25.54, 25.375, 25.372, 26.39, 26.356, 26.19, 26.026,
         25.863, 25.701, 25.541, 25.382, 25.224, 25.067, 24.911, 24.757, 24.602, 24.448, 24.295, 24.144, 23.993, 23.843,
         23.695, 23.547, 23.4, 23.253, 23.086, 22.921, 22.756, 22.593, 22.43, 22.269, 22.109, 21.95, 21.793, 21.636,
         21.481, 21.326, 21.173, 21.02, 20.868, 20.717, 20.567, 20.418, 20.271, 20.124, 19.979, 19.835, 19.692, 19.55,
         19.409, 19.27, 19.131, 18.994, 18.858, 18.716, 18.574, 18.434, 18.294, 18.156, 18.018, 17.881, 17.741, 17.603,
         17.466, 17.33, 17.195, 17.061, 16.929, 16.798, 16.668, 16.54, 16.412, 16.286, 16.161, 16.037, 15.914, 15.792,
         15.672, 15.552, 15.434, 15.317, 15.2, 14.818, 13.402, 12.084, 10.9, 9.8206, 8.855, 7.9928, 7.2248, 6.54,
         5.9283, 5.3635, 4.8481, 4.3729, 3.8954, 3.8744, 3.7718, 3.7453, 10.348, 10.006, 9.4836, 8.5087, 8.3416, 8.2758,
         8.216, 11.357, 11.07, 10.923, 10.644, 10.572, 12.137, 12.053, 11.867, 10.898, 9.8172, 8.8261, 7.9175, 7.0951,
         6.3589, 5.7019, 5.1142, 4.584, 4.1096, 3.6801, 3.2969, 2.932, 2.6027, 2.3123, 2.0559, 1.8295, 1.6292, 1.452,
         1.2929, 1.1512, 1.0236, 0.90721, 0.80445, 0.71341, 0.64647, 0.63316, 0.62919, 0.6247, 3.2286, 3.1573, 2.9775,
         2.6741, 2.3979, 2.1482, 1.9189, 1.714, 1.5312, 1.368, 1.2224, 1.0924, 0.97465, 0.86801, 0.77311, 0.68866,
         0.61349, 0.54657, 0.48699, 0.43395, 0.38672, 0.34465, 0.30719, 0.27382, 0.2457, 0.22066, 0.19819, 0.17802,
         0.15992, 0.14366]],
    'W':                                                                                                          [
        [0.005978, 0.0060695, 0.0060939, 0.0061305, 0.006222, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601,
         0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001,
         0.02720606, 0.02908327, 0.03109002, 0.032928, 0.03323523, 0.033432, 0.0335664, 0.033768, 0.034272, 0.034888,
         0.035422, 0.03552846, 0.0355644, 0.03577, 0.035778, 0.0363175, 0.0364635, 0.0366825, 0.03723, 0.03797993,
         0.04060054, 0.04340198, 0.045864, 0.04639671, 0.046566, 0.0467532, 0.047034, 0.047736, 0.04959809, 0.05302035,
         0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.075558, 0.0767145, 0.0770229, 0.0774855,
         0.078642, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505,
         0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862,
         0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722,
         0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071,
         0.11730431, 0.11789083, 0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942,
         0.12268982, 0.12330327, 0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416,
         0.12832258, 0.12896419, 0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621,
         0.13421395, 0.13488502, 0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774,
         0.14037579, 0.14107766, 0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007,
         0.14682052, 0.14755462, 0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715,
         0.15356113, 0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215,
         0.16061121, 0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922,
         0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314,
         0.17569726, 0.17657574, 0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937,
         0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409,
         0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422,
         0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745,
         0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228,
         0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948, 0.22885808,
         0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422, 0.23936509,
         0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24521055, 0.24540936, 0.24558945, 0.2466364, 0.24786959,
         0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25859581,
         0.25900419, 0.25924942, 0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604,
         0.2698027, 0.27115171, 0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557,
         0.2821895, 0.28360044, 0.28501845, 0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766,
         0.29514498, 0.29662071, 0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946,
         0.30869526, 0.31023873, 0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133,
         0.32286764, 0.32448197, 0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062,
         0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706,
         0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174,
         0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718,
         0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737,
         0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789,
         0.42266068, 0.42477398, 0.42477688, 0.42582312, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006,
         0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412,
         0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612,
         0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.4909216, 0.49227841, 0.49333254,
         0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172,
         0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074,
         0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734,
         0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144,
         0.59331325, 0.59410753, 0.59589253, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663,
         0.61439331, 0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345,
         0.64260046, 0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883,
         0.67210262, 0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194,
         0.70295924, 0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464,
         0.73523251, 0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165,
         0.76898746, 0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067,
         0.80429212, 0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248,
         0.84121764, 0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112,
         0.87983843, 0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405,
         0.92023232, 0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226,
         0.96248072, 0.96729312, 0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605,
         1.0066688, 1.0117021, 1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855,
         1.0581499, 1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302,
         1.1122639, 1.1178252, 1.1234143, 1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285,
         1.1691452, 1.1749909, 1.1808659, 1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213,
         1.2289354, 1.2350801, 1.2412555, 1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566,
         1.2917833, 1.2982423, 1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899,
         1.3578453, 1.3646345, 1.3714577, 1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848,
         1.4272857, 1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132,
         1.5002773, 1.5077787, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559,
         1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6494027,
         1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278, 1.7337534,
         1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.8088491, 1.809551,
         1.813351, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8709394, 1.8722607, 1.8777783,
         1.8871672, 1.896603, 1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081,
         1.9836772, 1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489,
         2.0851227, 2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519,
         2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.2786505, 2.280976,
         2.2833493, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697,
         2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4952257, 2.5077018,
         2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5716555, 2.5781443, 2.5838796, 2.596799, 2.6097829,
         2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476,
         2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8140455, 2.8251547, 2.8265806, 2.8407135, 2.8549171,
         2.8691917, 2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179,
         3.0159225, 3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853,
         3.1701572, 3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009,
         3.3322794, 3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663,
         3.5026927, 3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033,
         3.6818208, 3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554,
         3.8701096, 3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924,
         4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919,
         10.00266, 10.15577, 10.19659, 10.25783, 10.32004, 10.41094, 11.03212, 11.31312, 11.48628, 11.53246, 11.60172,
         11.77488, 11.79334, 11.8578, 12.0393, 12.0877, 12.1603, 12.3418, 12.60708, 13.47697, 14.40688, 15.40095,
         16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502,
         34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318,
         68.1345, 69.17738, 69.45548, 69.87263, 70.9155, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239,
         106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156,
         222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [6.6566, 6.08378, 5.43188, 6.07665, 6.61931, 6.56496, 6.58098, 6.68973, 6.90985, 7.25243, 7.7179, 8.29414,
         8.95658, 9.67031, 10.4305, 11.1203, 11.7349, 12.2377, 12.5975, 12.7802, 12.7425, 12.396, 11.6002, 11.3527,
         11.1252, 10.8065, 10.9013, 10.6426, 9.79398, 7.64986, 6.18367, 5.04927, 7.68767, 7.7649, 10.058, 10.2313,
         10.7991, 11.6701, 12.399, 13.6087, 13.8839, 13.1951, 12.5737, 12.1538, 10.8814, 12.2052, 13.3694, 14.3109,
         14.9342, 15.154, 15.105, 14.8547, 14.455, 13.9447, 13.7648, 13.6117, 13.5465, 13.5269, 13.4278, 13.3807,
         12.8282, 12.2717, 11.7538, 13.0562, 13.0233, 12.9096, 12.8777, 12.8465, 12.8158, 12.7857, 12.7562, 12.7273,
         12.699, 12.6714, 12.6445, 12.6183, 12.5927, 12.5679, 12.5437, 12.5204, 12.4977, 12.4759, 12.3657, 12.3454,
         12.3259, 12.3073, 12.2895, 12.2726, 12.2565, 12.2414, 12.2271, 12.2137, 12.2013, 12.1899, 12.1794, 12.17,
         12.1616, 12.1542, 12.1478, 12.1426, 12.1384, 12.1352, 12.1332, 12.1323, 12.1325, 12.1339, 12.1364, 12.1401,
         12.145, 12.1511, 12.1584, 12.167, 12.1768, 12.1878, 12.2002, 12.2138, 12.2287, 12.245, 12.2626, 12.2816,
         12.3019, 12.3237, 12.3468, 12.3714, 12.3974, 12.4248, 12.4537, 12.484, 12.5158, 12.5489, 12.5835, 12.6195,
         12.6583, 12.6972, 12.7375, 12.7792, 12.8224, 12.867, 12.913, 12.9605, 13.0094, 13.0597, 13.1114, 13.1645,
         13.219, 13.2749, 13.3321, 13.3907, 13.4505, 13.5117, 13.5742, 13.6379, 13.703, 13.7692, 13.8367, 13.9054,
         13.9754, 14.0465, 14.1188, 14.1922, 14.2668, 14.3426, 14.4194, 14.4973, 14.5763, 14.6564, 14.7375, 14.8197,
         14.9029, 14.987, 15.0721, 15.1582, 15.2453, 15.3332, 15.4221, 15.5118, 15.6025, 15.6939, 15.7862, 15.8794,
         15.9733, 16.0679, 16.1634, 16.2595, 16.3564, 16.454, 16.5522, 16.6511, 16.7507, 16.8508, 16.9515, 17.0528,
         17.1547, 17.257, 17.3599, 17.4633, 17.5671, 17.6713, 17.776, 17.881, 17.9864, 18.0922, 18.1983, 18.3046,
         18.4112, 18.5181, 18.6251, 18.7324, 18.8398, 18.9473, 19.0549, 19.1626, 19.2702, 19.3779, 19.4855, 19.5931,
         19.7004, 19.8077, 19.9147, 20.0214, 20.1277, 20.2337, 20.3392, 20.4442, 20.5485, 20.6521, 20.7549, 20.8567,
         20.9573, 21.0567, 21.1545, 21.2506, 21.3466, 21.4379, 21.5261, 21.6104, 21.6897, 21.7625, 21.8262, 21.8767,
         21.9062, 21.8968, 21.7913, 21.276, 20.2858, 21.3122, 22.0383, 22.3776, 22.6171, 22.8125, 22.9801, 23.1256,
         23.2494, 23.3463, 23.3987, 23.3312, 23.0534, 23.1065, 23.3386, 23.8455, 24.1448, 24.39, 24.6085, 24.8106,
         25.0014, 25.1835, 25.3587, 25.5282, 25.6928, 25.8531, 26.0099, 26.1634, 26.314, 26.4619, 26.6073, 26.7504,
         26.8914, 27.0301, 27.1668, 27.3016, 27.4346, 27.566, 27.6959, 27.8244, 27.9514, 28.0772, 28.2017, 28.325,
         28.4471, 28.5681, 28.6879, 28.8067, 28.9245, 29.0412, 29.1569, 29.2715, 29.3853, 29.498, 29.6098, 29.7206,
         29.8305, 29.9395, 30.0476, 30.1547, 30.2609, 30.3663, 30.4707, 30.5742, 30.6768, 30.7785, 30.8793, 30.9792,
         31.0782, 31.1763, 31.2735, 31.3697, 31.465, 31.5594, 31.6529, 31.7454, 31.837, 31.9276, 32.0171, 32.1057,
         32.1933, 32.2799, 32.3654, 32.4498, 32.533, 32.6152, 32.6962, 32.7759, 32.8544, 32.9316, 33.0075, 33.0818,
         33.1547, 33.226, 33.2956, 33.3634, 33.4292, 33.4929, 33.5543, 33.6132, 33.6692, 33.7221, 33.7712, 33.8162,
         33.8562, 33.8902, 33.9168, 33.934, 33.9387, 33.9257, 33.886, 33.7998, 33.6117, 32.9521, 32.9497, 32.9876,
         33.5375, 34.0037, 34.2898, 34.511, 34.6984, 34.8647, 35.0166, 35.158, 35.2914, 35.4183, 35.5398, 35.6569,
         35.7701, 35.8798, 35.9865, 36.0903, 36.1914, 36.2899, 36.3859, 36.4793, 36.5701, 36.6579, 36.7424, 36.8229,
         36.8983, 36.9663, 37.0224, 37.0537, 36.9815, 36.9762, 37.0276, 37.173, 37.3657, 37.5106, 37.6386, 37.7577,
         37.871, 37.9804, 38.0868, 38.1908, 38.2928, 38.3931, 38.492, 38.5895, 38.6859, 38.7811, 38.8754, 38.9686,
         39.0609, 39.1523, 39.2428, 39.3323, 39.4208, 39.5084, 39.5949, 39.6803, 39.7645, 39.8473, 39.9286, 40.0082,
         40.0856, 40.1605, 40.2323, 40.2998, 40.3616, 40.4149, 40.4542, 40.4654, 40.388, 40.3052, 40.3616, 40.4348,
         40.7326, 40.9169, 41.0698, 41.2078, 41.3369, 41.4602, 41.5795, 41.6956, 41.8095, 41.9215, 42.032, 42.1416,
         42.2496, 42.356, 42.461, 42.5646, 42.667, 42.7682, 42.8684, 42.9676, 43.0658, 43.1631, 43.2595, 43.3552, 43.45,
         43.5441, 43.6375, 43.7303, 43.8225, 43.9136, 44.0035, 44.0924, 44.1802, 44.267, 44.3529, 44.4378, 44.5218,
         44.6048, 44.6867, 44.7676, 44.8474, 44.9262, 45.0187, 45.0957, 45.1718, 45.2469, 45.3211, 45.3944, 45.4667,
         45.5382, 45.6088, 45.6786, 45.7586, 45.8268, 45.8941, 45.9606, 46.0263, 46.0912, 46.1553, 46.2186, 46.2811,
         46.3428, 46.4038, 46.464, 46.5235, 46.5823, 46.6403, 46.6975, 46.7539, 46.8096, 46.8645, 46.9187, 46.9721,
         47.0247, 47.0767, 47.1279, 47.1784, 47.2281, 47.2772, 47.3256, 47.3733, 47.4203, 47.4666, 47.5122, 47.5572,
         47.6016, 47.6453, 47.6884, 47.7309, 47.7727, 47.814, 47.8547, 47.8948, 47.9344, 47.9735, 48.0121, 48.0502,
         48.0878, 48.125, 48.1618, 48.1983, 48.2345, 48.2704, 48.6747, 48.7529, 48.8078, 48.8558, 48.8986, 48.9373,
         48.9722, 49.0039, 49.032, 49.0568, 49.0786, 49.0975, 49.1137, 49.1273, 49.1385, 49.1474, 49.154, 49.1585,
         49.1609, 49.1614, 49.1599, 49.1566, 49.1514, 49.1444, 49.1357, 49.1252, 49.1131, 49.0993, 49.0838, 49.0668,
         49.0481, 49.0278, 49.006, 48.9825, 48.9575, 48.9309, 48.9027, 48.873, 48.8417, 48.8088, 48.7743, 48.7382,
         48.7005, 48.6611, 48.6201, 48.5775, 48.5332, 48.4871, 48.4394, 48.392, 48.3407, 48.2876, 48.2326, 48.1757,
         48.117, 48.0562, 47.9934, 47.9286, 47.8617, 47.7926, 47.7213, 47.6477, 47.5717, 47.4934, 47.4125, 47.3291,
         47.243, 47.1542, 47.0625, 46.9679, 46.8702, 46.7693, 46.6652, 46.5576, 46.4465, 46.3316, 46.2129, 46.0901,
         45.9654, 45.8339, 45.6978, 45.5567, 45.4105, 45.2588, 45.1013, 44.9378, 44.7679, 44.5911, 44.4071, 44.2154,
         44.0154, 43.8066, 43.5884, 43.36, 43.1207, 42.8695, 42.6055, 42.3276, 42.0344, 41.7244, 41.3961, 41.0474,
         40.6759, 40.2791, 39.8536, 39.3956, 38.9003, 38.3617, 37.7723, 37.1225, 36.3998, 35.5869, 34.6597, 33.5823,
         32.2981, 30.7091, 28.6218, 25.541, 19.2952, 4.06674, 3.74869, 17.8305, 24.0826, 26.5264, 27.7107, 28.0311,
         27.2913, 23.2827, 17.6545, 17.6137, 26.6817, 31.0855, 33.678, 35.6113, 37.1838, 38.5216, 39.6913, 40.7328,
         41.6726, 42.5289, 43.315, 44.041, 44.7146, 45.3419, 45.9281, 46.4771, 46.9922, 47.4762, 47.9314, 48.3597,
         48.7627, 49.1417, 49.4977, 49.8314, 50.1433, 50.4338, 50.7027, 50.9498, 51.1743, 51.3749, 51.5496, 51.6957,
         51.8086, 51.8817, 51.9041, 51.8573, 51.7061, 51.3704, 50.5932, 48.3982, 41.3917, 48.4449, 51.101, 52.4327,
         53.3017, 53.9744, 54.5346, 55.0199, 55.4489, 55.8317, 56.1749, 56.4813, 56.7657, 57.0327, 57.2825, 57.5145,
         57.7286, 57.9246, 58.1017, 58.2584, 58.3915, 58.4954, 58.5591, 58.5592, 58.4289, 57.7597, 57.6629, 57.7438,
         58.4515, 59.1845, 59.6478, 60.0117, 60.3202, 60.5917, 60.8352, 61.0555, 61.2549, 61.4337, 61.5963, 61.747,
         61.8834, 62.0023, 62.0982, 62.159, 62.1531, 61.9324, 61.8632, 61.9917, 62.0919, 62.6619, 63.0133, 63.298,
         63.549, 63.7792, 63.9949, 64.2001, 64.3972, 64.5879, 64.7745, 64.961, 65.1549, 65.3159, 65.4708, 65.6203,
         65.7647, 65.9045, 66.04, 66.1714, 66.299, 66.4231, 66.5437, 66.661, 66.7752, 66.8864, 66.9948, 67.1004,
         67.2033, 67.3037, 67.4017, 67.4973, 67.5906, 67.6819, 67.7711, 67.8581, 67.9429, 68.0255, 68.1062, 68.1849,
         68.2617, 68.3368, 68.4102, 68.4819, 68.5521, 68.6208, 68.688, 68.7538, 68.8184, 68.8817, 69.1474, 69.2084,
         69.2674, 69.3244, 69.3798, 69.4334, 69.4855, 69.6769, 69.7259, 69.773, 69.8183, 69.8618, 69.9037, 69.9441,
         69.9829, 70.0204, 70.0565, 70.0913, 70.1248, 70.1571, 70.6313, 70.8697, 71.1122, 71.1475, 71.145, 71.0404,
         70.8546, 70.612, 70.3157, 69.9589, 69.5221, 68.9513, 68.1293, 66.5592, 64.5033, 61.6346, 58.2555, 61.6606,
         63.3883, 64.6451, 66.8651, 66.594, 65.4086, 63.8067, 65.5005, 67.0136, 67.0913, 67.302, 67.2878, 66.5917,
         67.6405, 68.8404, 69.7737, 71.4875, 72.491, 73.1546, 73.6002, 73.8944, 74.085, 74.2037, 74.3309, 74.3562,
         74.4178, 74.3985, 74.3669, 74.297, 74.2121, 74.1179, 74.0173, 73.9116, 73.8011, 73.6848, 73.5584, 73.4168,
         73.2486, 73.0295, 72.7015, 72.0009, 71.5004, 70.3996, 69.0815, 70.4134, 71.6162, 71.9078, 73.0529, 73.5353,
         73.8178, 74.0042, 74.1261, 74.2067, 74.2592, 74.292, 74.3109, 74.3475, 74.3477, 74.341, 74.3299, 74.3159, 74.3,
         74.283, 74.2654, 74.2477, 74.2302, 74.2129, 74.196, 74.1795, 74.1646, 74.1511, 74.1386, 74.1271, 74.1165],
        [0.0, 0.0, 0.0, 1.264, 1.2569, 2.8092, 3.3151, 3.8688, 4.4462, 5.0157, 5.5412, 5.9859, 6.3173, 6.5117, 6.5573,
         6.455, 6.2179, 5.8684, 5.4333, 4.9392, 4.4187, 3.8996, 3.47, 3.4028, 3.3604, 3.3318, 3.7405, 3.6194, 3.4773,
         3.3593, 3.3363, 3.3286, 8.4061, 8.4024, 8.1578, 8.0933, 8.3052, 8.0634, 7.7505, 6.7833, 5.8781, 5.204, 5.0734,
         5.033, 4.9889, 7.4381, 7.2554, 6.8159, 6.1523, 5.5407, 5.0115, 4.6086, 4.3611, 4.2864, 4.2998, 4.3209, 4.3281,
         4.4018, 4.4392, 4.4574, 4.7586, 5.2496, 5.9297, 6.3475, 6.4128, 6.4792, 6.5465, 6.6148, 6.6841, 6.7544, 6.8257,
         6.8979, 6.9712, 7.0454, 7.1206, 7.1967, 7.2738, 7.3518, 7.4307, 7.5106, 7.5914, 7.6732, 7.7558, 7.8393, 7.9238,
         8.0091, 8.0953, 8.1823, 8.2703, 8.359, 8.4486, 8.5396, 8.6315, 8.7242, 8.8177, 8.912, 9.007, 9.1028, 9.1994,
         9.2967, 9.3948, 9.4935, 9.593, 9.6932, 9.794, 9.8955, 9.9977, 10.1, 10.204, 10.308, 10.413, 10.518, 10.624,
         10.73, 10.837, 10.944, 11.052, 11.161, 11.269, 11.379, 11.489, 11.599, 11.709, 11.82, 11.932, 12.043, 12.155,
         12.266, 12.378, 12.49, 12.602, 12.714, 12.826, 12.938, 13.05, 13.162, 13.274, 13.386, 13.498, 13.61, 13.722,
         13.833, 13.944, 14.055, 14.165, 14.275, 14.385, 14.494, 14.603, 14.711, 14.819, 14.927, 15.034, 15.14, 15.246,
         15.352, 15.456, 15.561, 15.664, 15.767, 15.87, 15.972, 16.073, 16.173, 16.273, 16.372, 16.471, 16.568, 16.665,
         16.761, 16.857, 16.952, 17.045, 17.138, 17.231, 17.322, 17.413, 17.503, 17.591, 17.679, 17.767, 17.853, 17.938,
         18.023, 18.106, 18.189, 18.271, 18.352, 18.432, 18.511, 18.589, 18.666, 18.742, 18.817, 18.891, 18.965, 19.037,
         19.108, 19.179, 19.248, 19.316, 19.384, 19.45, 19.516, 19.58, 19.643, 19.706, 19.767, 19.828, 19.887, 19.946,
         20.003, 20.06, 20.115, 20.17, 20.223, 20.276, 20.327, 20.378, 20.427, 20.476, 20.524, 20.57, 20.616, 20.661,
         20.704, 20.747, 20.789, 20.83, 20.87, 20.909, 20.947, 20.984, 21.02, 21.056, 21.09, 21.124, 21.156, 21.188,
         21.219, 21.249, 21.278, 21.306, 21.328, 22.386, 22.389, 22.404, 22.417, 22.428, 22.439, 22.449, 22.457, 22.465,
         22.471, 22.476, 22.48, 22.481, 23.281, 23.281, 23.279, 23.275, 23.271, 23.265, 23.258, 23.251, 23.242, 23.232,
         23.222, 23.21, 23.199, 23.186, 23.173, 23.16, 23.145, 23.13, 23.115, 23.099, 23.082, 23.065, 23.048, 23.03,
         23.012, 22.994, 22.975, 22.957, 22.938, 22.918, 22.898, 22.878, 22.858, 22.837, 22.816, 22.795, 22.774, 22.752,
         22.729, 22.707, 22.684, 22.661, 22.638, 22.614, 22.59, 22.566, 22.541, 22.516, 22.491, 22.466, 22.44, 22.414,
         22.388, 22.362, 22.335, 22.308, 22.281, 22.254, 22.226, 22.199, 22.171, 22.143, 22.114, 22.086, 22.057, 22.029,
         22.0, 21.971, 21.941, 21.912, 21.882, 21.853, 21.823, 21.793, 21.763, 21.733, 21.703, 21.673, 21.642, 21.612,
         21.581, 21.551, 21.52, 21.489, 21.459, 21.428, 21.397, 21.366, 21.335, 21.304, 21.273, 21.242, 21.211, 21.18,
         21.149, 21.118, 21.087, 21.055, 21.024, 20.993, 20.962, 20.962, 22.384, 22.37, 22.343, 22.315, 22.288, 22.26,
         22.232, 22.205, 22.177, 22.15, 22.122, 22.095, 22.067, 22.04, 22.012, 21.985, 21.957, 21.93, 21.902, 21.875,
         21.847, 21.82, 21.793, 21.765, 21.737, 21.71, 21.682, 21.655, 21.627, 21.599, 21.599, 21.937, 21.926, 21.9,
         21.874, 21.848, 21.822, 21.796, 21.769, 21.743, 21.717, 21.69, 21.664, 21.637, 21.61, 21.583, 21.557, 21.53,
         21.503, 21.476, 21.448, 21.421, 21.394, 21.366, 21.338, 21.311, 21.283, 21.255, 21.227, 21.198, 21.17, 21.141,
         21.113, 21.084, 21.055, 21.026, 20.997, 20.967, 20.937, 20.908, 20.9, 21.414, 21.411, 21.381, 21.352, 21.322,
         21.292, 21.262, 21.232, 21.202, 21.171, 21.141, 21.11, 21.079, 21.036, 20.987, 20.937, 20.888, 20.839, 20.789,
         20.74, 20.69, 20.64, 20.59, 20.54, 20.49, 20.439, 20.389, 20.338, 20.287, 20.235, 20.172, 20.109, 20.046,
         19.983, 19.92, 19.857, 19.794, 19.73, 19.667, 19.603, 19.538, 19.474, 19.409, 19.344, 19.279, 19.214, 19.149,
         19.084, 19.019, 18.954, 18.889, 18.823, 18.758, 18.693, 18.628, 18.562, 18.497, 18.432, 18.366, 18.301, 18.236,
         18.17, 18.105, 18.04, 17.975, 17.909, 17.844, 17.779, 17.713, 17.648, 17.582, 17.517, 17.451, 17.386, 17.32,
         17.255, 17.19, 17.124, 17.059, 16.994, 16.929, 16.864, 16.799, 16.734, 16.669, 16.605, 16.54, 16.475, 16.411,
         16.346, 16.282, 16.218, 16.154, 16.09, 16.026, 15.962, 15.899, 15.835, 15.772, 15.709, 15.646, 15.583, 15.52,
         15.457, 15.395, 15.321, 15.226, 15.131, 15.038, 14.944, 14.852, 14.76, 14.667, 14.569, 14.473, 14.377, 14.282,
         14.188, 14.095, 14.003, 13.911, 13.821, 13.731, 13.642, 13.553, 13.466, 13.379, 13.293, 13.207, 13.123, 13.039,
         12.956, 12.873, 12.792, 12.711, 12.63, 12.551, 12.472, 12.394, 12.316, 12.239, 12.163, 12.087, 12.012, 11.938,
         11.864, 11.791, 11.719, 11.647, 11.576, 11.505, 11.435, 11.365, 11.297, 11.228, 11.161, 11.093, 11.027, 10.961,
         10.895, 10.83, 10.766, 10.702, 10.638, 10.575, 10.513, 10.451, 10.39, 10.329, 10.269, 10.209, 10.149, 10.091,
         10.032, 9.9742, 9.9168, 9.8598, 9.8032, 9.7471, 9.6915, 9.6362, 9.5814, 9.527, 9.473, 9.4195, 9.3664, 9.3137,
         9.2615, 9.2096, 9.1582, 9.1072, 9.0565, 9.0063, 8.9565, 8.907, 8.858, 8.8093, 8.761, 8.7131, 8.6655, 8.6183,
         8.5715, 8.525, 8.4789, 8.4332, 8.3878, 8.3428, 8.2981, 8.2537, 8.2097, 8.166, 8.1227, 8.0781, 8.0334, 7.989,
         7.945, 7.9014, 7.858, 7.815, 7.7723, 7.7299, 7.6878, 7.646, 7.6046, 7.5839, 25.626, 25.549, 25.369, 25.189,
         25.011, 24.835, 24.659, 24.485, 24.439, 36.298, 36.144, 35.884, 35.625, 35.369, 35.115, 34.862, 34.612, 34.363,
         34.117, 33.872, 33.628, 33.386, 33.146, 32.907, 32.67, 32.436, 32.202, 31.971, 31.742, 31.514, 31.288, 31.063,
         30.84, 30.619, 30.4, 30.182, 29.966, 29.752, 29.539, 29.328, 29.118, 28.91, 28.704, 28.499, 28.296, 28.094,
         27.893, 27.695, 27.497, 27.341, 27.301, 32.09, 31.891, 31.641, 31.393, 31.148, 30.904, 30.663, 30.417, 30.172,
         29.929, 29.696, 29.481, 29.27, 29.061, 28.85, 28.642, 28.436, 28.233, 28.033, 27.835, 27.639, 27.445, 27.253,
         27.064, 26.876, 26.867, 28.665, 28.571, 28.362, 28.154, 27.949, 27.745, 27.544, 27.344, 27.146, 26.95, 26.756,
         26.578, 26.402, 26.228, 26.057, 25.888, 25.72, 25.554, 25.39, 25.373, 26.383, 26.366, 26.201, 26.038, 25.876,
         25.715, 25.556, 25.397, 25.239, 25.082, 24.926, 24.772, 24.619, 24.466, 24.291, 24.117, 23.944, 23.773, 23.603,
         23.434, 23.266, 23.099, 22.934, 22.769, 22.606, 22.444, 22.283, 22.123, 21.964, 21.807, 21.65, 21.495, 21.34,
         21.187, 21.035, 20.884, 20.733, 20.583, 20.434, 20.286, 20.14, 19.994, 19.85, 19.707, 19.565, 19.424, 19.284,
         19.145, 19.007, 18.871, 18.735, 18.597, 18.456, 18.316, 18.177, 18.04, 17.904, 17.769, 17.631, 17.493, 17.357,
         17.222, 17.088, 16.955, 16.823, 16.693, 16.564, 16.436, 16.309, 16.184, 16.06, 15.65, 14.139, 12.784, 11.526,
         10.392, 9.3697, 8.4516, 7.6347, 6.9068, 6.2574, 5.6752, 5.132, 4.6283, 4.1268, 3.8823, 3.7802, 3.7538, 10.324,
         10.184, 9.985, 8.8485, 8.4442, 8.2142, 8.1551, 11.288, 11.001, 10.971, 10.868, 10.589, 10.516, 12.074, 11.804,
         11.43, 10.319, 9.2845, 8.343, 7.4814, 6.706, 6.0128, 5.3947, 4.8368, 4.3382, 3.8884, 3.4838, 3.0983, 2.7503,
         2.4435, 2.1727, 1.9334, 1.7219, 1.5346, 1.3682, 1.2184, 1.0851, 0.96347, 0.85449, 0.75806, 0.67279, 0.65025,
         0.63292, 0.62842, 3.2163, 3.145, 3.1091, 2.7986, 2.5097, 2.2497, 2.0139, 1.7992, 1.6076, 1.4366, 1.2839,
         1.1476, 1.0259, 0.91402, 0.81445, 0.72581, 0.64687, 0.57657, 0.51396, 0.45818, 0.4085, 0.36423, 0.32479,
         0.28963, 0.25917, 0.23293, 0.20937, 0.1882, 0.16919, 0.15211]],
    'Re':                                                                                                         [
        [0.005104943, 0.005183079, 0.005203916, 0.005235171, 0.005313308, 0.005941418, 0.006032358, 0.006056608,
         0.006092984, 0.006183924, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306,
         0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327,
         0.03109002, 0.03323523, 0.033908, 0.034427, 0.0345654, 0.034773, 0.035292, 0.03552846, 0.03797993, 0.039788,
         0.040397, 0.0405594, 0.04060054, 0.040803, 0.041412, 0.04340198, 0.044688, 0.045372, 0.0455544, 0.045828,
         0.04639671, 0.046512, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695,
         0.07912411, 0.081144, 0.082386, 0.0827172, 0.083214, 0.084456, 0.08458368, 0.09041995, 0.09665893, 0.1033284,
         0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709,
         0.2152655, 0.2301188, 0.245997, 0.254996, 0.258899, 0.2599398, 0.261501, 0.2629708, 0.265404, 0.268226,
         0.2723315, 0.2734263, 0.2750685, 0.279174, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405,
         0.4195189, 0.435512, 0.442178, 0.4439556, 0.446622, 0.4484657, 0.453288, 0.4794098, 0.5, 0.5025, 0.5050125,
         0.50753756, 0.51007525, 0.51262563, 0.51518875, 0.51717493, 0.5177647, 0.51862505, 0.52035352, 0.52295529,
         0.52557007, 0.52819792, 0.53083891, 0.5334931, 0.53616057, 0.53884137, 0.54153558, 0.54424325, 0.54696447,
         0.54969929, 0.55244779, 0.55521003, 0.55798608, 0.56077601, 0.56357989, 0.56639779, 0.56922978, 0.57207593,
         0.5749363, 0.57781099, 0.58070004, 0.58360354, 0.58652156, 0.58945417, 0.59240144, 0.59536345, 0.59834026,
         0.60133196, 0.60433862, 0.60736032, 0.61039712, 0.6134491, 0.61651635, 0.61959893, 0.62269693, 0.62404375,
         0.62581041, 0.62595625, 0.62893946, 0.63208416, 0.63524458, 0.6384208, 0.64161291, 0.64482097, 0.64804508,
         0.6512853, 0.65454173, 0.65781444, 0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508, 0.6777972,
         0.68118619, 0.68459212, 0.68801508, 0.69145515, 0.69491243, 0.69838699, 0.70187893, 0.70538832, 0.70891526,
         0.71245984, 0.71602214, 0.71960225, 0.72320026, 0.72681626, 0.73045034, 0.7341026, 0.73777311, 0.74146197,
         0.74516928, 0.74889513, 0.75263961, 0.7564028, 0.76018482, 0.76398574, 0.76780567, 0.7716447, 0.77550292,
         0.77938044, 0.78327734, 0.78719373, 0.79112969, 0.79508534, 0.79906077, 0.80305607, 0.80707135, 0.81110671,
         0.81516224, 0.81923806, 0.82333425, 0.82745092, 0.83158817, 0.83574611, 0.83992484, 0.84412447, 0.84834509,
         0.85258682, 0.85684975, 0.861134, 0.86543967, 0.86976687, 0.8741157, 0.87848628, 0.88287871, 0.8872931,
         0.89172957, 0.89618822, 0.90066916, 0.9051725, 0.90969837, 0.91424686, 0.91881809, 0.92341218, 0.92802924,
         0.93266939, 0.93733274, 0.9420194, 0.9467295, 0.95146315, 0.95622046, 0.96100156, 0.96580657, 0.9706356,
         0.97548878, 0.98036623, 0.98526806, 0.9901944, 0.99514537, 1.0001211, 1.0051217, 1.0101473, 1.015198, 1.020274,
         1.0253754, 1.0305023, 1.0356548, 1.0408331, 1.0460372, 1.0512674, 1.0565238, 1.0618064, 1.0671154, 1.072451,
         1.0778132, 1.0832023, 1.0886183, 1.0940614, 1.0995317, 1.1050294, 1.1105545, 1.1161073, 1.1216878, 1.1272963,
         1.1329328, 1.1385974, 1.1442904, 1.1500119, 1.1557619, 1.1615407, 1.1673484, 1.1731852, 1.1790511, 1.1849464,
         1.1908711, 1.1968254, 1.2028096, 1.2088236, 1.2148677, 1.2209421, 1.2270468, 1.233182, 1.2393479, 1.2455447,
         1.2517724, 1.2580312, 1.2643214, 1.270643, 1.2769962, 1.2833812, 1.2897981, 1.2962471, 1.3027283, 1.309242,
         1.3157882, 1.3223671, 1.328979, 1.3356239, 1.342302, 1.3490135, 1.3557586, 1.3625374, 1.36935, 1.3761968,
         1.3830778, 1.3899932, 1.3969431, 1.4039278, 1.4109475, 1.4180022, 1.4250922, 1.4322177, 1.4393788, 1.4465757,
         1.4538086, 1.4610776, 1.468383, 1.4757249, 1.4831035, 1.490519, 1.4979716, 1.5054615, 1.5129888, 1.5205537,
         1.5281565, 1.5357973, 1.5434763, 1.5511937, 1.5589496, 1.5667444, 1.5745781, 1.582451, 1.5903633, 1.5983151,
         1.6063066, 1.6143382, 1.6224099, 1.6305219, 1.6386745, 1.6468679, 1.6551022, 1.6633777, 1.6716946, 1.6800531,
         1.6884534, 1.6968956, 1.7053801, 1.713907, 1.7224766, 1.7310889, 1.7397444, 1.7484431, 1.7571853, 1.7659712,
         1.7748011, 1.7836751, 1.7925935, 1.8015565, 1.8105642, 1.8196171, 1.8287151, 1.8378587, 1.847048, 1.8562833,
         1.8655647, 1.8748925, 1.8825065, 1.8832935, 1.884267, 1.8936883, 1.9031567, 1.9126725, 1.9222359, 1.9318471,
         1.9415063, 1.9481516, 1.9496484, 1.9512138, 1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868,
         2.0205393, 2.030642, 2.0407952, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278, 2.1027895, 2.1133034,
         2.1238699, 2.1344893, 2.1451617, 2.1558875, 2.166667, 2.1775003, 2.1883878, 2.1993297, 2.2103264, 2.221378,
         2.2324849, 2.2436473, 2.2548656, 2.2661399, 2.2774706, 2.2888579, 2.3003022, 2.3118037, 2.3233628, 2.3349796,
         2.3466545, 2.3583878, 2.3649801, 2.36962, 2.3701797, 2.3820306, 2.3939407, 2.4059104, 2.41794, 2.4300297,
         2.4421798, 2.4543907, 2.4666627, 2.478996, 2.491391, 2.5038479, 2.5163672, 2.528949, 2.5415938, 2.5543017,
         2.5670732, 2.5799086, 2.5928082, 2.6057722, 2.6188011, 2.6318951, 2.6450545, 2.6582798, 2.6715712, 2.6780604,
         2.6849291, 2.6851398, 2.6983537, 2.7118455, 2.7254047, 2.7390317, 2.7527269, 2.7664905, 2.780323, 2.7942246,
         2.8081957, 2.8222367, 2.8363479, 2.8505296, 2.8647823, 2.8791062, 2.8935017, 2.9079692, 2.9225091, 2.9258366,
         2.9371216, 2.9375634, 2.9518072, 2.9665662, 2.9813991, 2.9963061, 3.0112876, 3.026344, 3.0414758, 3.0566831,
         3.0719666, 3.0873264, 3.102763, 3.1182768, 3.1338682, 3.1495376, 3.1652853, 3.1811117, 3.1970172, 3.2130023,
         3.2290673, 3.2452127, 3.2614387, 3.2777459, 3.2941347, 3.3106053, 3.3271584, 3.3437941, 3.3605131, 3.3773157,
         3.3942023, 3.4111733, 3.4282291, 3.4453703, 3.4625971, 3.4799101, 3.4973097, 3.5147962, 3.5323702, 3.5500321,
         3.5677822, 3.5856211, 3.6035492, 3.621567, 3.6396748, 3.6578732, 3.6761626, 3.6945434, 3.7130161, 3.7315812,
         3.7502391, 3.7689903, 3.7878352, 3.8067744, 3.8258083, 3.8449373, 3.864162, 3.8834828, 3.9029002, 3.9224147,
         3.9420268, 3.9617369, 3.9815456, 4.0014533, 4.0214606, 4.0415679, 4.0617757, 4.0820846, 4.102495, 4.1230075,
         4.1436226, 4.1643407, 4.1851624, 4.2060882, 4.2271186, 4.2482542, 4.2694955, 4.290843, 4.3122972, 4.3338587,
         4.355528, 4.3773056, 4.3991921, 4.4211881, 4.443294, 4.4655105, 4.4878381, 4.5102772, 4.5328286, 4.5554928,
         4.5782702, 4.6011616, 4.6241674, 4.6472882, 4.6705247, 4.6938773, 4.7173467, 4.7409334, 4.7646381, 4.7884613,
         4.8124036, 4.8364656, 4.8606479, 4.8849512, 4.9093759, 4.9339228, 4.9585924, 4.9833854, 5.0083023, 5.0333438,
         5.0585105, 5.0838031, 5.1092221, 5.1347682, 5.1604421, 5.1862443, 5.2121755, 5.2382364, 5.2644276, 5.2907497,
         5.3172034, 5.3437895, 5.3705084, 5.3973609, 5.4243477, 5.4514695, 5.4787268, 5.5061205, 5.5336511, 5.5613193,
         5.5891259, 5.6170716, 5.6451569, 5.6733827, 5.7017496, 5.7302584, 5.7589096, 5.7877042, 5.8166427, 5.8457259,
         5.8749546, 5.9043293, 5.933851, 5.9635202, 5.9933378, 6.0233045, 6.053421, 6.0836882, 6.1141066, 6.1446771,
         6.1754005, 6.2062775, 6.2373089, 6.2684954, 6.2998379, 6.3313371, 6.3629938, 6.3948088, 6.4267828, 6.4589167,
         6.4912113, 6.5236674, 6.5562857, 6.5890671, 6.6220125, 6.6551225, 6.6883981, 6.7218401, 6.7554493, 6.7892266,
         6.8231727, 6.8572886, 6.891575, 6.9260329, 6.9606631, 6.9954664, 7.0304437, 7.0655959, 7.1009239, 7.1364285,
         7.1721107, 7.2079712, 7.2440111, 7.2802311, 7.3166323, 7.3532155, 7.3899815, 7.4269314, 7.4640661, 7.5013864,
         7.5388934, 7.5765878, 7.6144708, 7.6525431, 7.6908058, 7.7292599, 7.7679062, 7.8067457, 7.8457794, 7.8850083,
         7.9244334, 7.9640555, 8.0038758, 8.0438952, 8.0841147, 8.1245352, 8.1651579, 8.2059837, 8.2470136, 8.2882487,
         8.3296899, 8.3713384, 8.4131951, 8.455261, 8.4975373, 8.540025, 9.030794, 9.653919, 10.32004, 10.32459,
         10.48262, 10.52476, 10.58798, 10.74601, 11.03212, 11.71953, 11.79334, 11.89891, 11.94674, 12.01849, 12.19787,
         12.27617, 12.46407, 12.51417, 12.58933, 12.60708, 12.77723, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961,
         18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551,
         39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 70.24287, 71.31802,
         71.45536, 71.60472, 72.03478, 73.10993, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931,
         121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835,
         253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [6.39581, 6.22399, 6.06267, 6.1935, 6.27314, 5.68875, 5.20729, 4.66114, 5.19845, 5.64768, 5.27266, 5.29226,
         5.41943, 5.67608, 6.0766, 6.62422, 7.32014, 8.11734, 9.03318, 9.93792, 10.825, 11.646, 12.356, 12.9157,
         13.2835, 13.4089, 13.1912, 12.1962, 11.3408, 9.48514, 7.26152, 9.56931, 11.5804, 12.012, 13.7977, 14.0851,
         13.8521, 13.4579, 12.3158, 13.9357, 14.3817, 14.6487, 14.2887, 13.4221, 12.3252, 13.4803, 14.4092, 14.5135,
         15.6927, 16.1494, 16.3094, 16.2441, 15.9999, 15.6151, 15.1211, 14.5397, 14.2945, 14.1235, 14.0506, 14.0293,
         13.9194, 13.9067, 13.2976, 12.672, 12.0734, 11.5404, 11.1085, 10.7184, 10.6211, 10.7502, 11.1382, 11.818,
         12.7984, 14.0334, 15.4684, 17.0427, 18.6854, 20.2842, 20.9838, 21.0168, 20.7081, 21.2542, 21.5754, 21.941,
         22.2642, 22.5202, 22.3395, 22.8457, 23.5829, 23.8558, 26.038, 27.8948, 29.5561, 31.0382, 32.3241, 33.3221,
         33.5331, 33.1448, 32.4487, 33.3164, 33.6747, 34.2307, 35.8103, 38.1737, 38.2614, 38.3446, 38.4222, 38.4914,
         38.5464, 38.5692, 38.4935, 38.3234, 38.5476, 38.7517, 38.9309, 39.0747, 39.2038, 39.3248, 39.4403, 39.552,
         39.6606, 39.7667, 39.8708, 39.9731, 40.0738, 40.173, 40.2708, 40.3674, 40.4628, 40.557, 40.6501, 40.742,
         40.8328, 40.9224, 41.0109, 41.0981, 41.184, 41.2685, 41.3514, 41.4327, 41.512, 41.5891, 41.6635, 41.7346,
         41.8015, 41.8628, 41.916, 41.9562, 41.9716, 41.9186, 41.8089, 41.8323, 41.8646, 42.1912, 42.3815, 42.5346,
         42.6708, 42.7972, 42.9171, 43.0325, 43.1444, 43.2535, 43.3605, 43.4656, 43.5692, 43.6714, 43.7725, 43.8725,
         43.9716, 44.0699, 44.1675, 44.2644, 44.3607, 44.4564, 44.5516, 44.6463, 44.7405, 44.8344, 44.9278, 45.0208,
         45.1135, 45.2059, 45.298, 45.3899, 45.4814, 45.5728, 45.664, 45.755, 45.8458, 45.9366, 46.027, 46.1171,
         46.2073, 46.2969, 46.3852, 46.4724, 46.5584, 46.6603, 46.7442, 46.8271, 46.9089, 46.9896, 47.0694, 47.1481,
         47.2259, 47.3028, 47.3787, 47.4642, 47.5385, 47.6119, 47.6846, 47.7564, 47.8274, 47.8977, 47.9672, 48.036,
         48.1042, 48.1717, 48.2386, 48.3049, 48.3706, 48.4356, 48.5001, 48.5641, 48.6275, 48.6905, 48.7531, 48.8152,
         48.8771, 48.9386, 48.9999, 49.061, 49.122, 49.183, 49.2439, 49.305, 49.3663, 49.4279, 49.4899, 49.5525,
         49.6158, 49.68, 49.7453, 49.8119, 49.8802, 49.9503, 50.0219, 50.061, 50.0969, 50.1305, 50.1623, 50.1926,
         50.2215, 50.2493, 50.2761, 50.3014, 50.3249, 50.3467, 50.3668, 50.3853, 50.4022, 50.4177, 50.4316, 50.4442,
         50.4554, 50.465, 50.4729, 50.479, 50.4833, 50.4859, 50.4869, 50.4862, 50.4839, 50.4801, 50.4747, 50.4678,
         50.4594, 50.4495, 50.4381, 50.4252, 50.4109, 50.3951, 50.3779, 50.3593, 50.3392, 50.3177, 50.2948, 50.2704,
         50.2446, 50.2173, 50.1886, 50.1584, 50.1268, 50.0936, 50.059, 50.0229, 49.9853, 49.9461, 49.9054, 49.863,
         49.8191, 49.7736, 49.7263, 49.6775, 49.6284, 49.5761, 49.522, 49.4661, 49.4083, 49.3487, 49.2871, 49.2235,
         49.1578, 49.09, 49.0201, 48.948, 48.8736, 48.7969, 48.7177, 48.636, 48.5518, 48.4648, 48.3751, 48.2826,
         48.1871, 48.0885, 47.9867, 47.8815, 47.7729, 47.6607, 47.5447, 47.4247, 47.3007, 47.1723, 47.0393, 46.9051,
         46.7624, 46.6145, 46.4609, 46.3015, 46.1358, 45.9636, 45.7843, 45.5976, 45.4029, 45.1997, 44.9874, 44.7653,
         44.5327, 44.2886, 44.0323, 43.7625, 43.4782, 43.1778, 42.8598, 42.5224, 42.1634, 41.7802, 41.3698, 40.9287,
         40.4524, 39.9355, 39.3712, 38.7506, 38.0624, 37.2913, 36.4161, 35.4057, 34.2121, 32.7551, 30.8827, 28.2448,
         23.6363, 6.3685, 6.05504, 13.0938, 24.4712, 27.5494, 29.0524, 29.6683, 29.4164, 27.4998, 19.6941, 19.6648,
         24.0511, 31.1633, 34.2046, 36.3252, 38.0003, 39.4024, 40.6159, 41.689, 42.6523, 43.5266, 44.3268, 45.0641,
         45.7469, 46.3818, 46.9742, 47.5283, 48.0476, 48.5352, 48.9933, 49.424, 49.829, 50.2095, 50.5667, 50.9012,
         51.2137, 51.5044, 51.7732, 52.0198, 52.2434, 52.4425, 52.6152, 52.7583, 52.867, 52.934, 52.9471, 52.8855,
         52.7075, 52.3133, 51.329, 49.4646, 49.5016, 49.8406, 52.5668, 53.7078, 54.5014, 55.1326, 55.667, 56.1356,
         56.5546, 56.9319, 57.2732, 57.5828, 57.8726, 58.1446, 58.3997, 58.6382, 58.8592, 59.0629, 59.2488, 59.4157,
         59.5611, 59.6808, 59.767, 59.8035, 59.7515, 59.4635, 58.9517, 58.9966, 59.0361, 60.1491, 60.6837, 61.0784,
         61.4054, 61.6901, 61.9444, 62.1744, 62.3834, 62.5725, 62.7423, 62.8995, 63.043, 63.1698, 63.2748, 63.3474,
         63.3605, 63.2012, 63.081, 63.1838, 63.2173, 63.8305, 64.2004, 64.4973, 64.7594, 64.9992, 65.2189, 65.4241,
         65.6181, 65.803, 65.98, 66.1492, 66.3114, 66.4675, 66.6181, 66.7636, 66.9043, 67.0407, 67.173, 67.3014,
         67.4261, 67.5473, 67.6653, 67.78, 67.8917, 68.0005, 68.1065, 68.2098, 68.3105, 68.4087, 68.5045, 68.598,
         68.6892, 68.7783, 68.8653, 68.9504, 69.0332, 69.1141, 69.1929, 69.2699, 69.3451, 69.4186, 69.4904, 69.5606,
         69.6293, 69.6965, 69.7623, 69.8267, 69.8899, 69.9518, 70.217, 70.2769, 70.3348, 70.3908, 70.4451, 70.4976,
         70.5487, 70.7387, 70.787, 70.8333, 70.8778, 70.9206, 70.9617, 71.0013, 71.0393, 71.076, 71.1113, 71.1453,
         71.178, 71.2096, 71.2399, 71.2692, 71.2974, 71.3246, 71.3507, 71.3759, 71.4002, 71.4236, 71.4461, 71.4677,
         71.4886, 71.5087, 71.528, 71.5466, 71.5645, 71.5817, 71.5983, 71.6142, 71.6295, 71.6443, 71.6585, 71.6722,
         71.6854, 71.6981, 71.7103, 71.7221, 71.8385, 71.8502, 71.8611, 71.871, 71.8802, 71.8887, 71.8964, 71.9035,
         71.9098, 71.9156, 71.9207, 71.9251, 71.929, 71.9324, 71.9352, 71.9375, 71.9392, 71.9406, 71.9414, 71.9417,
         71.9416, 71.9411, 71.9401, 71.9388, 71.937, 71.9807, 71.9786, 71.9759, 71.9727, 71.9689, 71.9646, 71.9598,
         71.9544, 71.9487, 71.9425, 71.9358, 71.9287, 71.9213, 71.9134, 71.9051, 71.8965, 71.8875, 71.8782, 71.8871,
         71.8773, 71.867, 71.8563, 71.8452, 71.8337, 71.8219, 71.8096, 71.7971, 71.7841, 71.7708, 71.7572, 71.7432,
         71.7289, 71.7143, 71.6994, 71.6841, 71.6685, 71.6526, 71.6363, 71.6198, 71.6029, 71.5857, 71.5683, 71.5505,
         71.5324, 71.5139, 71.4952, 71.4762, 71.4568, 71.4371, 71.4172, 71.3969, 71.3762, 71.3553, 71.334, 71.3124,
         71.2905, 71.2683, 71.2457, 71.2227, 71.1994, 71.1758, 71.1518, 71.1275, 71.1027, 71.0776, 71.0521, 71.0262,
         71.0, 70.9733, 70.9462, 70.9186, 70.8907, 70.8622, 70.8334, 70.804, 70.7742, 70.7439, 70.713, 70.6817, 70.6498,
         70.6173, 70.5843, 70.5507, 70.5164, 70.4816, 70.446, 70.4097, 70.3726, 70.3347, 70.2959, 70.2562, 70.2157,
         70.1741, 70.1315, 69.6381, 68.5353, 65.6674, 65.6244, 62.8399, 59.587, 62.814, 65.6471, 67.2448, 67.6542,
         67.3841, 66.4793, 64.8867, 66.573, 68.0807, 68.3474, 68.3508, 67.6623, 68.7093, 68.8899, 69.911, 71.8024,
         73.0764, 73.8716, 74.4047, 74.7592, 74.9938, 75.1456, 75.3012, 75.3469, 75.3954, 75.4193, 75.3939, 75.3316,
         75.252, 75.1615, 75.0638, 74.9608, 74.8531, 74.7403, 74.6201, 74.4871, 74.3343, 74.1439, 73.8796, 73.4235,
         72.5172, 71.4235, 71.0332, 70.1142, 71.4371, 72.632, 73.6992, 74.3552, 74.7028, 74.925, 75.0733, 75.1704,
         75.2342, 75.2751, 75.2997, 75.3128, 75.3443, 75.3404, 75.3313, 75.3187, 75.3038, 75.2875, 75.2704, 75.253,
         75.2356, 75.2184, 75.2015, 75.1849, 75.1693, 75.1553, 75.1425, 75.1308, 75.1199],
        [0.0, 0.0, 0.0, 0.29128, 0.29108, 0.29183, 0.29392, 0.2946, 1.353, 1.3515, 3.4278, 4.0421, 4.7143, 5.4183,
         6.1198, 6.7783, 7.3518, 7.8016, 8.0975, 8.2213, 8.169, 7.9498, 7.5848, 7.1023, 6.5331, 5.9161, 5.2858, 4.6699,
         4.4909, 4.3575, 4.3227, 8.6457, 8.4385, 8.3464, 7.4692, 6.8764, 6.6792, 6.6271, 7.4507, 7.3752, 7.1514, 6.459,
         6.0458, 5.8392, 5.7861, 7.8921, 7.7273, 7.6948, 6.9252, 6.224, 5.5605, 4.9727, 4.4941, 4.1483, 3.9512, 3.9137,
         3.9429, 3.9724, 3.9817, 4.0659, 4.1106, 4.1157, 4.4316, 4.9343, 5.6326, 6.5277, 7.6212, 8.9002, 10.339, 11.905,
         13.559, 15.249, 16.875, 18.361, 19.667, 20.765, 21.642, 22.298, 22.546, 22.617, 22.633, 23.451, 23.476, 23.512,
         23.548, 23.59, 23.599, 24.223, 24.248, 24.256, 24.224, 24.038, 23.74, 23.355, 22.909, 22.423, 22.138, 22.021,
         21.99, 23.44, 23.411, 23.334, 22.929, 22.62, 22.582, 22.545, 22.508, 22.471, 22.433, 22.396, 22.367, 22.358,
         22.706, 22.682, 22.646, 22.61, 22.574, 22.538, 22.502, 22.465, 22.429, 22.392, 22.356, 22.319, 22.282, 22.245,
         22.208, 22.171, 22.134, 22.096, 22.059, 22.021, 21.984, 21.946, 21.908, 21.87, 21.831, 21.793, 21.755, 21.716,
         21.677, 21.638, 21.599, 21.56, 21.521, 21.481, 21.442, 21.402, 21.362, 21.322, 21.304, 21.814, 21.813, 21.775,
         21.735, 21.696, 21.656, 21.616, 21.575, 21.535, 21.494, 21.453, 21.412, 21.371, 21.33, 21.288, 21.247, 21.205,
         21.163, 21.12, 21.078, 21.036, 20.993, 20.95, 20.907, 20.864, 20.82, 20.777, 20.733, 20.689, 20.645, 20.6,
         20.556, 20.511, 20.466, 20.421, 20.376, 20.33, 20.285, 20.238, 20.191, 20.144, 20.087, 20.016, 19.945, 19.874,
         19.803, 19.732, 19.661, 19.589, 19.518, 19.447, 19.376, 19.305, 19.233, 19.162, 19.091, 19.02, 18.949, 18.878,
         18.807, 18.736, 18.665, 18.594, 18.523, 18.452, 18.381, 18.311, 18.24, 18.169, 18.099, 18.028, 17.957, 17.887,
         17.816, 17.746, 17.676, 17.605, 17.535, 17.465, 17.395, 17.326, 17.256, 17.187, 17.117, 17.048, 16.979, 16.91,
         16.842, 16.773, 16.705, 16.637, 16.568, 16.501, 16.433, 16.365, 16.298, 16.208, 16.118, 16.03, 15.942, 15.854,
         15.767, 15.681, 15.595, 15.499, 15.404, 15.309, 15.215, 15.121, 15.029, 14.937, 14.846, 14.755, 14.666, 14.571,
         14.476, 14.382, 14.288, 14.195, 14.104, 14.013, 13.922, 13.833, 13.744, 13.656, 13.569, 13.483, 13.397, 13.312,
         13.228, 13.144, 13.062, 12.98, 12.898, 12.817, 12.737, 12.658, 12.579, 12.501, 12.424, 12.347, 12.271, 12.196,
         12.121, 12.047, 11.973, 11.9, 11.828, 11.756, 11.685, 11.615, 11.545, 11.475, 11.406, 11.338, 11.27, 11.203,
         11.137, 11.071, 11.005, 10.94, 10.876, 10.812, 10.748, 10.685, 10.623, 10.561, 10.5, 10.439, 10.378, 10.319,
         10.259, 10.2, 10.142, 10.084, 10.026, 9.9689, 9.9123, 9.8561, 9.8003, 9.745, 9.6901, 9.6356, 9.5816, 9.528,
         9.4747, 9.4219, 9.3695, 9.3174, 9.2658, 9.2146, 9.1638, 9.1134, 9.0634, 9.0138, 8.9645, 8.9156, 8.8671, 8.819,
         8.7712, 8.7238, 8.6768, 8.6301, 8.5838, 8.5379, 8.4922, 8.447, 8.402, 8.3574, 8.3132, 8.2693, 8.2243, 8.1791,
         8.1342, 8.0896, 8.0454, 8.0015, 7.9579, 7.9147, 7.8717, 7.8291, 7.7868, 7.7527, 25.555, 25.537, 25.357, 25.179,
         25.003, 24.828, 24.654, 24.481, 24.364, 36.07, 36.028, 35.771, 35.515, 35.262, 35.01, 34.76, 34.512, 34.266,
         34.022, 33.779, 33.539, 33.3, 33.063, 32.827, 32.593, 32.36, 32.129, 31.9, 31.673, 31.447, 31.223, 31.001,
         30.78, 30.561, 30.344, 30.128, 29.914, 29.701, 29.49, 29.281, 29.073, 28.867, 28.662, 28.459, 28.258, 28.058,
         27.859, 27.662, 27.466, 27.357, 32.0, 31.988, 31.753, 31.519, 31.287, 31.057, 30.829, 30.603, 30.374, 30.142,
         29.913, 29.695, 29.486, 29.28, 29.076, 28.872, 28.667, 28.465, 28.265, 28.066, 27.87, 27.676, 27.484, 27.293,
         27.104, 26.917, 26.826, 28.579, 28.576, 28.374, 28.171, 27.97, 27.77, 27.572, 27.375, 27.18, 26.986, 26.794,
         26.612, 26.436, 26.263, 26.093, 25.924, 25.757, 25.591, 25.427, 25.39, 26.391, 26.386, 26.225, 26.06, 25.896,
         25.733, 25.556, 25.376, 25.197, 25.02, 24.844, 24.667, 24.491, 24.316, 24.142, 23.969, 23.798, 23.628, 23.459,
         23.291, 23.125, 22.959, 22.795, 22.631, 22.469, 22.308, 22.148, 21.989, 21.832, 21.675, 21.519, 21.365, 21.211,
         21.059, 20.908, 20.758, 20.608, 20.459, 20.312, 20.165, 20.02, 19.875, 19.732, 19.59, 19.449, 19.309, 19.17,
         19.033, 18.896, 18.76, 18.626, 18.491, 18.351, 18.212, 18.074, 17.937, 17.802, 17.668, 17.533, 17.396, 17.26,
         17.126, 16.992, 16.86, 16.729, 16.6, 16.471, 16.344, 16.218, 16.093, 15.969, 15.847, 15.725, 15.605, 15.485,
         15.367, 15.25, 15.134, 15.019, 14.905, 14.792, 14.68, 14.57, 14.46, 14.351, 14.243, 14.136, 14.03, 13.925,
         13.821, 13.718, 13.616, 13.515, 13.415, 13.315, 13.217, 13.119, 13.021, 12.921, 12.821, 12.723, 12.625, 12.528,
         12.432, 12.336, 12.241, 12.147, 12.053, 11.961, 11.869, 11.778, 11.688, 11.598, 11.51, 11.421, 11.334, 11.247,
         11.161, 11.076, 10.991, 10.907, 10.824, 10.742, 10.658, 10.575, 10.493, 10.411, 10.33, 10.25, 10.171, 10.093,
         10.015, 9.9374, 9.8608, 9.785, 9.7098, 9.6353, 9.5614, 9.4882, 9.4157, 9.3434, 9.2714, 9.2, 9.1292, 9.059,
         8.9894, 8.9205, 8.8522, 8.7844, 8.7173, 8.6507, 8.5847, 8.5193, 8.4544, 8.3902, 8.3264, 8.2633, 8.2007, 8.1386,
         8.077, 8.016, 7.9556, 7.8956, 7.8362, 7.7772, 7.7188, 7.6609, 7.6035, 7.5466, 7.4901, 7.4342, 7.3787, 7.3237,
         7.2692, 7.2151, 7.1615, 7.1084, 7.0557, 7.0034, 6.9516, 6.9003, 6.8494, 6.7989, 6.7488, 6.6992, 6.65, 6.6011,
         6.5528, 6.5048, 6.4572, 6.41, 6.3632, 6.3169, 6.2709, 6.2252, 6.18, 6.1352, 6.0907, 6.0466, 6.0028, 5.9595,
         5.9165, 5.8738, 5.8315, 5.7896, 5.748, 5.7065, 5.6644, 5.6227, 5.5813, 5.5403, 5.4994, 5.4588, 5.4183, 5.3776,
         5.3372, 4.8913, 4.3617, 3.8942, 3.8912, 3.7895, 3.7631, 10.075, 9.8178, 9.3788, 8.4363, 8.3432, 8.2128, 8.1547,
         11.272, 10.988, 10.867, 10.586, 10.513, 12.059, 12.033, 11.785, 10.844, 9.7497, 8.7608, 7.8621, 7.0514, 6.3267,
         5.6795, 5.098, 4.5723, 4.1022, 3.6772, 3.2705, 2.9034, 2.5796, 2.2939, 2.0415, 1.8183, 1.6208, 1.4457, 1.2884,
         1.1483, 1.0222, 0.90681, 0.80487, 0.71433, 0.654, 0.63662, 0.63445, 0.63211, 3.2029, 3.1325, 2.9282, 2.6232,
         2.352, 2.1121, 1.8873, 1.6866, 1.5075, 1.3476, 1.2048, 1.0772, 0.96158, 0.85722, 0.76426, 0.68146, 0.60768,
         0.54194, 0.48335, 0.43114, 0.3846, 0.34311, 0.30612, 0.27314, 0.24564, 0.22097, 0.19879, 0.17886, 0.16093]],
    'Os':                                                                                                         [
        [0.005907383, 0.005997802, 0.006021914, 0.006058082, 0.006148501, 0.006911593, 0.007017383, 0.007045593,
         0.007087909, 0.007193699, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306,
         0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327,
         0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.044492, 0.045173, 0.045374, 0.045627,
         0.0460685, 0.0462537, 0.046308, 0.04639671, 0.0465315, 0.047226, 0.04959809, 0.05302035, 0.05667876, 0.05684,
         0.05771, 0.057942, 0.05829, 0.05916, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.082026,
         0.0832815, 0.0836163, 0.0841185, 0.08458368, 0.085374, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797,
         0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188,
         0.245997, 0.2629708, 0.267344, 0.271436, 0.2725272, 0.274164, 0.278256, 0.2811158, 0.283612, 0.287953,
         0.2891106, 0.290847, 0.295188, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657,
         0.458836, 0.465859, 0.4677318, 0.470541, 0.477564, 0.4794098, 0.5, 0.5025, 0.5050125, 0.50753756, 0.51007525,
         0.51262563, 0.51518875, 0.5177647, 0.52035352, 0.52295529, 0.52557007, 0.52819792, 0.53083891, 0.5334931,
         0.53616057, 0.53884137, 0.54153558, 0.54424325, 0.54571853, 0.54696447, 0.54728152, 0.54969929, 0.55244779,
         0.55521003, 0.55798608, 0.56077601, 0.56357989, 0.56639779, 0.56922978, 0.57207593, 0.5749363, 0.57781099,
         0.58070004, 0.58360354, 0.58652156, 0.58945417, 0.59240144, 0.59536345, 0.59834026, 0.60133196, 0.60433862,
         0.60736032, 0.61039712, 0.6134491, 0.61651635, 0.61959893, 0.62269693, 0.62581041, 0.62893946, 0.63208416,
         0.63524458, 0.6384208, 0.64161291, 0.64482097, 0.64804508, 0.6512853, 0.65327272, 0.65454173, 0.65532723,
         0.65781444, 0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508, 0.6777972, 0.68118619, 0.68459212,
         0.68801508, 0.69145515, 0.69491243, 0.69838699, 0.70187893, 0.70538832, 0.70891526, 0.71245984, 0.71602214,
         0.71960225, 0.72320026, 0.72681626, 0.73045034, 0.7341026, 0.73777311, 0.74146197, 0.74516928, 0.74889513,
         0.75263961, 0.7564028, 0.76018482, 0.76398574, 0.76780567, 0.7716447, 0.77550292, 0.77938044, 0.78327734,
         0.78719373, 0.79112969, 0.79508534, 0.79906077, 0.80305607, 0.80707135, 0.81110671, 0.81516224, 0.81923806,
         0.82333425, 0.82745092, 0.83158817, 0.83574611, 0.83992484, 0.84412447, 0.84834509, 0.85258682, 0.85684975,
         0.861134, 0.86543967, 0.86976687, 0.8741157, 0.87848628, 0.88287871, 0.8872931, 0.89172957, 0.89618822,
         0.90066916, 0.9051725, 0.90969837, 0.91424686, 0.91881809, 0.92341218, 0.92802924, 0.93266939, 0.93733274,
         0.9420194, 0.9467295, 0.95146315, 0.95622046, 0.96100156, 0.96580657, 0.9706356, 0.97548878, 0.98036623,
         0.98526806, 0.9901944, 0.99514537, 1.0001211, 1.0051217, 1.0101473, 1.015198, 1.020274, 1.0253754, 1.0305023,
         1.0356548, 1.0408331, 1.0460372, 1.0512674, 1.0565238, 1.0618064, 1.0671154, 1.072451, 1.0778132, 1.0832023,
         1.0886183, 1.0940614, 1.0995317, 1.1050294, 1.1105545, 1.1161073, 1.1216878, 1.1272963, 1.1329328, 1.1385974,
         1.1442904, 1.1500119, 1.1557619, 1.1615407, 1.1673484, 1.1731852, 1.1790511, 1.1849464, 1.1908711, 1.1968254,
         1.2028096, 1.2088236, 1.2148677, 1.2209421, 1.2270468, 1.233182, 1.2393479, 1.2455447, 1.2517724, 1.2580312,
         1.2643214, 1.270643, 1.2769962, 1.2833812, 1.2897981, 1.2962471, 1.3027283, 1.309242, 1.3157882, 1.3223671,
         1.328979, 1.3356239, 1.342302, 1.3490135, 1.3557586, 1.3625374, 1.36935, 1.3761968, 1.3830778, 1.3899932,
         1.3969431, 1.4039278, 1.4109475, 1.4180022, 1.4250922, 1.4322177, 1.4393788, 1.4465757, 1.4538086, 1.4610776,
         1.468383, 1.4757249, 1.4831035, 1.490519, 1.4979716, 1.5054615, 1.5129888, 1.5205537, 1.5281565, 1.5357973,
         1.5434763, 1.5511937, 1.5589496, 1.5667444, 1.5745781, 1.582451, 1.5903633, 1.5983151, 1.6063066, 1.6143382,
         1.6224099, 1.6305219, 1.6386745, 1.6468679, 1.6551022, 1.6633777, 1.6716946, 1.6800531, 1.6884534, 1.6968956,
         1.7053801, 1.713907, 1.7224766, 1.7310889, 1.7397444, 1.7484431, 1.7571853, 1.7659712, 1.7748011, 1.7836751,
         1.7925935, 1.8015565, 1.8105642, 1.8196171, 1.8287151, 1.8378587, 1.847048, 1.8562833, 1.8655647, 1.8748925,
         1.884267, 1.8936883, 1.9031567, 1.9126725, 1.9222359, 1.9318471, 1.9415063, 1.9512138, 1.959659, 1.9605411,
         1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868, 2.0205393, 2.0299512, 2.030642, 2.031649,
         2.0407952, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278, 2.1027895, 2.1133034, 2.1238699, 2.1344893,
         2.1451617, 2.1558875, 2.166667, 2.1775003, 2.1883878, 2.1993297, 2.2103264, 2.221378, 2.2324849, 2.2436473,
         2.2548656, 2.2661399, 2.2774706, 2.2888579, 2.3003022, 2.3118037, 2.3233628, 2.3349796, 2.3466545, 2.3583878,
         2.3701797, 2.3820306, 2.3939407, 2.4059104, 2.41794, 2.4300297, 2.4421798, 2.4543907, 2.454905, 2.4594951,
         2.4666627, 2.478996, 2.491391, 2.5038479, 2.5163672, 2.528949, 2.5415938, 2.5543017, 2.5670732, 2.5799086,
         2.5928082, 2.6057722, 2.6188011, 2.6318951, 2.6450545, 2.6582798, 2.6715712, 2.6849291, 2.6983537, 2.7118455,
         2.7254047, 2.7390317, 2.7527269, 2.7664905, 2.780323, 2.7883189, 2.7942246, 2.7960812, 2.8081957, 2.8222367,
         2.8363479, 2.8505296, 2.8647823, 2.8791062, 2.8935017, 2.9079692, 2.9225091, 2.9371216, 2.9518072, 2.9665662,
         2.9813991, 2.9963061, 3.0112876, 3.026344, 3.0414758, 3.0422811, 3.054719, 3.0566831, 3.0719666, 3.0873264,
         3.102763, 3.1182768, 3.1338682, 3.1495376, 3.1652853, 3.1811117, 3.1970172, 3.2130023, 3.2290673, 3.2452127,
         3.2614387, 3.2777459, 3.2941347, 3.3106053, 3.3271584, 3.3437941, 3.3605131, 3.3773157, 3.3942023, 3.4111733,
         3.4282291, 3.4453703, 3.4625971, 3.4799101, 3.4973097, 3.5147962, 3.5323702, 3.5500321, 3.5677822, 3.5856211,
         3.6035492, 3.621567, 3.6396748, 3.6578732, 3.6761626, 3.6945434, 3.7130161, 3.7315812, 3.7502391, 3.7689903,
         3.7878352, 3.8067744, 3.8258083, 3.8449373, 3.864162, 3.8834828, 3.9029002, 3.9224147, 3.9420268, 3.9617369,
         3.9815456, 4.0014533, 4.0214606, 4.0415679, 4.0617757, 4.0820846, 4.102495, 4.1230075, 4.1436226, 4.1643407,
         4.1851624, 4.2060882, 4.2271186, 4.2482542, 4.2694955, 4.290843, 4.3122972, 4.3338587, 4.355528, 4.3773056,
         4.3991921, 4.4211881, 4.443294, 4.4655105, 4.4878381, 4.5102772, 4.5328286, 4.5554928, 4.5782702, 4.6011616,
         4.6241674, 4.6472882, 4.6705247, 4.6938773, 4.7173467, 4.7409334, 4.7646381, 4.7884613, 4.8124036, 4.8364656,
         4.8606479, 4.8849512, 4.9093759, 4.9339228, 4.9585924, 4.9833854, 5.0083023, 5.0333438, 5.0585105, 5.0838031,
         5.1092221, 5.1347682, 5.1604421, 5.1862443, 5.2121755, 5.2382364, 5.2644276, 5.2907497, 5.3172034, 5.3437895,
         5.3705084, 5.3973609, 5.4243477, 5.4514695, 5.4787268, 5.5061205, 5.5336511, 5.5613193, 5.5891259, 5.6170716,
         5.6451569, 5.6733827, 5.7017496, 5.7302584, 5.7589096, 5.7877042, 5.8166427, 5.8457259, 5.8749546, 5.9043293,
         5.933851, 5.9635202, 5.9933378, 6.0233045, 6.053421, 6.0836882, 6.1141066, 6.1446771, 6.1754005, 6.2062775,
         6.2373089, 6.2684954, 6.2998379, 6.3313371, 6.3629938, 6.3948088, 6.4267828, 6.4589167, 6.4912113, 6.5236674,
         6.5562857, 6.5890671, 6.6220125, 6.6551225, 6.6883981, 6.7218401, 6.7554493, 6.7892266, 6.8231727, 6.8572886,
         6.891575, 6.9260329, 6.9606631, 6.9954664, 7.0304437, 7.0655959, 7.1009239, 7.1364285, 7.1721107, 7.2079712,
         7.2440111, 7.2802311, 7.3166323, 7.3532155, 7.3899815, 7.4269314, 7.4640661, 7.5013864, 7.5388934, 7.5765878,
         7.6144708, 7.6525431, 7.6908058, 7.7292599, 7.7679062, 7.8067457, 7.8457794, 7.8850083, 7.9244334, 7.9640555,
         8.0038758, 8.0438952, 8.0841147, 8.1245352, 8.1651579, 8.2059837, 8.2470136, 8.2882487, 8.3296899, 8.3713384,
         8.4131951, 8.455261, 8.4975373, 8.540025, 9.030794, 9.653919, 10.32004, 10.65348, 10.81655, 10.86003, 10.92525,
         11.03212, 11.08832, 11.79334, 12.1373, 12.32308, 12.37262, 12.44693, 12.60708, 12.6327, 12.70864, 12.90316,
         12.95503, 13.03284, 13.22736, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988,
         22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101,
         47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 72.39338, 73.50144, 73.79693, 74.24015,
         75.34821, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553,
         148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126,
         310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [5.43687, 5.15071, 4.85715, 5.12209, 5.31598, 4.82996, 4.35271, 3.81101, 4.34862, 4.79431, 4.06001, 3.8303,
         3.67817, 3.64823, 3.78702, 4.13658, 4.72647, 5.56591, 6.66196, 7.9237, 9.30795, 10.773, 12.1547, 13.4151,
         14.4901, 15.3372, 15.9315, 16.2636, 16.3346, 16.1358, 15.6027, 14.375, 13.2731, 11.3899, 8.51787, 11.3463,
         12.5223, 12.4059, 11.9946, 12.8348, 13.2592, 14.2971, 15.5895, 15.9956, 15.3856, 15.3069, 14.4436, 13.4254,
         14.4565, 15.3382, 15.8224, 16.2596, 16.3067, 16.1153, 15.7335, 15.4516, 15.298, 15.2257, 15.2156, 15.1878,
         15.1242, 14.6327, 13.9803, 13.2929, 12.6108, 11.9764, 11.4366, 11.0393, 10.8266, 10.8645, 11.1817, 11.8116,
         12.7716, 14.0558, 15.5949, 17.31, 19.1095, 20.8401, 21.1921, 21.326, 21.0971, 21.5895, 22.2684, 22.6139,
         22.8744, 23.1714, 23.0454, 23.497, 24.1977, 24.8701, 27.0645, 29.026, 30.8046, 32.3961, 33.7687, 34.775,
         34.8718, 34.4856, 33.7681, 34.6743, 35.6373, 35.7982, 38.4805, 38.6059, 38.7279, 38.8468, 38.9629, 39.0762,
         39.1868, 39.2949, 39.4002, 39.5028, 39.6023, 39.6985, 39.7909, 39.8784, 39.9595, 40.0312, 40.086, 40.0981,
         40.0302, 40.016, 40.0883, 40.3421, 40.5153, 40.6601, 40.792, 40.9163, 41.0353, 41.1504, 41.2625, 41.372,
         41.4793, 41.5847, 41.6883, 41.7903, 41.8908, 41.9898, 42.0874, 42.1836, 42.2784, 42.3719, 42.464, 42.5547,
         42.6439, 42.7315, 42.8174, 42.9014, 42.9834, 43.063, 43.1398, 43.2133, 43.2827, 43.3465, 43.4026, 43.4467,
         43.469, 43.4371, 43.3097, 43.0989, 43.3672, 43.646, 43.8496, 44.0079, 44.1467, 44.2746, 44.3953, 44.511,
         44.6228, 44.7317, 44.838, 44.9424, 45.0449, 45.1459, 45.2455, 45.344, 45.4413, 45.5376, 45.6329, 45.7275,
         45.8212, 45.9141, 46.0064, 46.098, 46.1889, 46.2792, 46.369, 46.4581, 46.5467, 46.6348, 46.7224, 46.8095,
         46.8961, 46.9823, 47.0681, 47.1535, 47.2384, 47.3231, 47.4074, 47.4912, 47.5745, 47.6574, 47.7398, 47.8217,
         47.9032, 48.0002, 48.0811, 48.1617, 48.2418, 48.3216, 48.4011, 48.4802, 48.5591, 48.6376, 48.7158, 48.7938,
         48.8715, 48.958, 49.0356, 49.1121, 49.1876, 49.262, 49.3355, 49.4081, 49.4797, 49.5505, 49.6204, 49.6895,
         49.7578, 49.8253, 49.8921, 49.9581, 50.0233, 50.0879, 50.1518, 50.2151, 50.2779, 50.3401, 50.4019, 50.4632,
         50.5242, 50.585, 50.6457, 50.7064, 50.7674, 50.8291, 50.8794, 50.9231, 50.9648, 51.0051, 51.0441, 51.0818,
         51.1182, 51.1535, 51.1875, 51.2205, 51.2523, 51.283, 51.3127, 51.3414, 51.3692, 51.3959, 51.4218, 51.4468,
         51.4702, 51.4919, 51.512, 51.5306, 51.5475, 51.563, 51.577, 51.5897, 51.6009, 51.6108, 51.6194, 51.6267,
         51.6322, 51.6359, 51.638, 51.6384, 51.6372, 51.6344, 51.63, 51.624, 51.6166, 51.6076, 51.5971, 51.5851,
         51.5716, 51.5566, 51.5402, 51.5223, 51.503, 51.4822, 51.4599, 51.4362, 51.411, 51.3844, 51.3562, 51.3266,
         51.2955, 51.2629, 51.2288, 51.1931, 51.1559, 51.1172, 51.0768, 51.0348, 50.9912, 50.9459, 50.899, 50.8503,
         50.7999, 50.7477, 50.6965, 50.6406, 50.5829, 50.5233, 50.4617, 50.398, 50.3322, 50.2643, 50.1942, 50.1218,
         50.0471, 49.97, 49.8904, 49.8083, 49.7235, 49.6359, 49.5455, 49.4522, 49.3559, 49.2563, 49.1535, 49.0472,
         48.9373, 48.8238, 48.7063, 48.5847, 48.4589, 48.3286, 48.1935, 48.0536, 47.9084, 47.7619, 47.6054, 47.4428,
         47.2738, 47.0978, 46.9144, 46.7232, 46.5237, 46.3152, 46.097, 45.8685, 45.6289, 45.3771, 45.1121, 44.8328,
         44.5378, 44.2255, 43.8942, 43.5416, 43.1655, 42.7627, 42.3298, 41.8625, 41.3555, 40.8023, 40.1943, 39.5206,
         38.7663, 37.9108, 36.9241, 35.7604, 34.3427, 32.527, 29.9862, 25.6313, 8.61191, 8.30119, 12.1007, 25.8504,
         29.0594, 30.6406, 31.3542, 31.2867, 29.9555, 21.723, 15.5705, 21.7027, 31.685, 35.1111, 37.3616, 39.0993,
         40.5368, 41.7719, 42.859, 43.8315, 44.7118, 45.516, 46.2557, 46.9397, 47.5751, 48.1673, 48.7207, 49.239,
         49.7251, 50.1815, 50.6101, 51.0126, 51.3903, 51.7444, 52.0754, 52.384, 52.6702, 52.934, 53.1748, 53.3915,
         53.5826, 53.7454, 53.8762, 53.9689, 54.0142, 53.9961, 53.8854, 53.6185, 53.0125, 50.7883, 50.4981, 50.5312,
         52.8129, 54.3202, 55.2373, 55.9333, 56.5092, 57.0078, 57.4511, 57.8515, 58.2143, 58.5432, 58.8474, 59.1334,
         59.4021, 59.6547, 59.8917, 60.1122, 60.3159, 60.5026, 60.6709, 60.8188, 60.942, 61.0334, 61.0781, 61.0415,
         60.801, 60.2693, 59.9526, 60.3609, 61.3624, 61.9197, 62.3245, 62.6585, 62.9495, 63.21, 63.4467, 63.663,
         63.8605, 64.0395, 64.2081, 64.3669, 64.5145, 64.6501, 64.731, 64.73, 64.499, 64.465, 64.5986, 64.7181, 65.2592,
         65.5995, 65.8751, 66.1167, 66.3365, 66.5407, 66.7329, 66.9155, 67.0899, 67.2567, 67.4166, 67.5705, 67.7188,
         67.862, 68.0005, 68.1346, 68.2647, 68.3908, 68.5133, 68.6322, 68.7479, 68.8603, 68.9697, 69.0762, 69.1798,
         69.2807, 69.379, 69.4748, 69.5681, 69.659, 69.7477, 69.8343, 69.9186, 70.001, 70.0814, 70.1598, 70.2365,
         70.3114, 70.3846, 70.4562, 70.5263, 70.5948, 70.662, 70.7278, 70.7923, 70.8555, 70.9176, 70.9786, 71.0386,
         71.3005, 71.3589, 71.4155, 71.4702, 71.5232, 71.5746, 71.6243, 71.8105, 71.8578, 71.9031, 71.9466, 71.9883,
         72.0284, 72.067, 72.1041, 72.1398, 72.1741, 72.2071, 72.239, 72.2696, 72.2991, 72.3275, 72.3548, 72.3811,
         72.4064, 72.4308, 72.4543, 72.4769, 72.4986, 72.5195, 72.5396, 72.559, 72.5776, 72.5954, 72.6126, 72.6291,
         72.645, 72.6603, 72.675, 72.6891, 72.7026, 72.7157, 72.7282, 72.7403, 72.7519, 72.7631, 72.8768, 72.8876,
         72.8976, 72.9067, 72.9151, 72.9227, 72.9297, 72.9361, 72.9418, 72.9469, 72.9513, 72.9552, 72.9585, 72.9613,
         72.9635, 72.9653, 72.9665, 72.9673, 72.9676, 72.9674, 72.9669, 72.9659, 72.9645, 72.9627, 72.9605, 73.0031,
         73.0006, 72.9975, 72.9938, 72.9896, 72.9849, 72.9797, 72.974, 72.9678, 72.9612, 72.9542, 72.9468, 72.9389,
         72.9307, 72.922, 72.913, 72.9037, 72.894, 72.9019, 72.8917, 72.881, 72.8699, 72.8585, 72.8466, 72.8345,
         72.8219, 72.809, 72.7958, 72.7822, 72.7683, 72.754, 72.7394, 72.7245, 72.7093, 72.6938, 72.6779, 72.6617,
         72.6452, 72.6284, 72.6113, 72.5939, 72.5762, 72.5582, 72.5398, 72.5212, 72.5023, 72.483, 72.4634, 72.4435,
         72.4233, 72.4028, 72.382, 72.3608, 72.3394, 72.3176, 72.2954, 72.2729, 72.2501, 72.227, 72.2035, 72.1796,
         72.1554, 72.1309, 72.1059, 72.0806, 72.0549, 72.0288, 72.0023, 71.9754, 71.948, 71.9203, 71.8921, 71.8635,
         71.8344, 71.8048, 71.7748, 71.7443, 71.7133, 71.6817, 71.6497, 71.6171, 71.5839, 71.5502, 71.516, 71.4811,
         71.4457, 71.0612, 70.2032, 68.5702, 66.7008, 63.9315, 60.6949, 63.9065, 66.1286, 66.7292, 69.0428, 68.7669,
         67.5864, 65.9983, 67.6734, 69.0535, 69.165, 69.4128, 69.4181, 68.733, 69.7742, 70.9684, 71.8031, 73.5317,
         74.5193, 75.1662, 75.6001, 75.8884, 76.0779, 76.1991, 76.3299, 76.36, 76.4321, 76.4168, 76.3631, 76.2893,
         76.2029, 76.1083, 76.0079, 75.9027, 75.7929, 75.6773, 75.5514, 75.4097, 75.2406, 75.0181, 74.6783, 73.9039,
         73.5326, 72.4458, 71.1446, 72.4596, 73.6472, 74.116, 75.1235, 75.5687, 75.834, 76.0122, 76.1284, 76.2052,
         76.2552, 76.2863, 76.304, 76.3392, 76.3387, 76.3318, 76.3209, 76.3072, 76.2917, 76.2751, 76.258, 76.2408,
         76.2237, 76.2068, 76.1903, 76.1742, 76.1597, 76.1466, 76.1345, 76.1234],
        [0.0, 0.0, 0.0, 0.54897, 0.54399, 0.51397, 0.5158, 0.51659, 1.566, 1.5545, 2.8563, 3.4898, 4.2589, 5.1556,
         6.1562, 7.2192, 8.2856, 9.2837, 10.137, 10.778, 11.152, 11.234, 11.025, 10.553, 9.8659, 9.0253, 8.0922, 7.1306,
         6.1929, 5.316, 4.5225, 3.8227, 3.587, 3.449, 3.4096, 7.4612, 7.2925, 7.2233, 8.0959, 8.0585, 8.0023, 7.721,
         6.8584, 5.8309, 4.9842, 4.952, 4.7851, 4.7425, 6.6712, 6.5044, 6.2525, 5.6534, 5.1344, 4.6965, 4.3797, 4.2706,
         4.2389, 4.232, 4.3005, 4.2938, 4.2852, 4.3116, 4.5235, 4.9436, 5.5827, 6.4502, 7.5436, 8.8536, 10.362, 12.028,
         13.805, 15.635, 17.455, 19.145, 20.628, 21.867, 22.842, 23.542, 23.659, 23.751, 23.772, 24.465, 24.553, 24.606,
         24.646, 24.704, 24.717, 25.243, 25.291, 25.334, 25.351, 25.183, 24.87, 24.446, 23.94, 23.377, 23.174, 23.037,
         23.0, 24.498, 24.371, 24.338, 23.97, 23.926, 23.881, 23.837, 23.792, 23.747, 23.702, 23.658, 23.612, 23.567,
         23.522, 23.476, 23.431, 23.385, 23.339, 23.293, 23.247, 23.2, 23.175, 23.52, 23.514, 23.475, 23.43, 23.385,
         23.34, 23.295, 23.249, 23.204, 23.158, 23.112, 23.066, 23.02, 22.974, 22.928, 22.881, 22.835, 22.788, 22.741,
         22.694, 22.647, 22.6, 22.553, 22.505, 22.458, 22.41, 22.362, 22.314, 22.266, 22.218, 22.169, 22.121, 22.072,
         22.023, 21.974, 21.925, 21.876, 21.846, 22.362, 22.35, 22.313, 22.264, 22.215, 22.166, 22.117, 22.068, 22.018,
         21.969, 21.919, 21.869, 21.819, 21.769, 21.719, 21.669, 21.618, 21.568, 21.517, 21.466, 21.415, 21.364, 21.313,
         21.261, 21.21, 21.158, 21.106, 21.054, 21.002, 20.95, 20.898, 20.845, 20.792, 20.74, 20.687, 20.634, 20.581,
         20.527, 20.474, 20.42, 20.366, 20.311, 20.256, 20.201, 20.146, 20.091, 20.035, 19.98, 19.924, 19.868, 19.812,
         19.756, 19.7, 19.644, 19.588, 19.532, 19.475, 19.418, 19.36, 19.284, 19.209, 19.133, 19.058, 18.982, 18.907,
         18.831, 18.756, 18.681, 18.606, 18.531, 18.456, 18.381, 18.307, 18.232, 18.157, 18.083, 18.008, 17.934, 17.86,
         17.787, 17.713, 17.64, 17.566, 17.493, 17.421, 17.348, 17.275, 17.18, 17.084, 16.99, 16.896, 16.803, 16.71,
         16.618, 16.526, 16.435, 16.345, 16.255, 16.166, 16.078, 15.99, 15.903, 15.816, 15.731, 15.64, 15.544, 15.45,
         15.356, 15.262, 15.17, 15.078, 14.987, 14.896, 14.807, 14.718, 14.63, 14.538, 14.444, 14.352, 14.26, 14.169,
         14.079, 13.989, 13.9, 13.812, 13.725, 13.639, 13.553, 13.468, 13.384, 13.3, 13.217, 13.135, 13.053, 12.972,
         12.892, 12.813, 12.734, 12.656, 12.578, 12.501, 12.425, 12.349, 12.274, 12.2, 12.126, 12.053, 11.98, 11.908,
         11.837, 11.766, 11.696, 11.626, 11.557, 11.488, 11.42, 11.353, 11.286, 11.219, 11.154, 11.088, 11.023, 10.959,
         10.895, 10.832, 10.769, 10.707, 10.645, 10.584, 10.523, 10.463, 10.403, 10.344, 10.285, 10.226, 10.168, 10.111,
         10.054, 9.9971, 9.9408, 9.885, 9.8297, 9.7747, 9.7202, 9.6661, 9.6124, 9.5591, 9.5062, 9.4538, 9.4017, 9.3501,
         9.2988, 9.2479, 9.1974, 9.1473, 9.0976, 9.0483, 8.9993, 8.9507, 8.9025, 8.8546, 8.8071, 8.76, 8.7132, 8.6667,
         8.6206, 8.5749, 8.5295, 8.4844, 8.4397, 8.3953, 8.3512, 8.307, 8.2616, 8.2166, 8.1719, 8.1275, 8.0835, 8.0397,
         7.9963, 7.9532, 7.9161, 25.515, 25.507, 25.329, 25.152, 24.976, 24.801, 24.628, 24.456, 24.297, 24.285, 35.899,
         35.668, 35.413, 35.16, 34.909, 34.66, 34.413, 34.168, 33.924, 33.683, 33.443, 33.205, 32.969, 32.735, 32.502,
         32.271, 32.041, 31.812, 31.586, 31.361, 31.138, 30.916, 30.696, 30.478, 30.261, 30.046, 29.833, 29.621, 29.411,
         29.202, 28.995, 28.789, 28.585, 28.383, 28.182, 27.983, 27.785, 27.588, 27.393, 27.385, 32.005, 31.869, 31.639,
         31.41, 31.183, 30.957, 30.733, 30.511, 30.287, 30.06, 29.836, 29.628, 29.422, 29.219, 29.017, 28.816, 28.614,
         28.414, 28.216, 28.02, 27.825, 27.633, 27.442, 27.253, 27.065, 26.879, 26.772, 28.526, 28.499, 28.323, 28.122,
         27.922, 27.724, 27.528, 27.332, 27.139, 26.946, 26.756, 26.574, 26.401, 26.231, 26.063, 25.896, 25.713, 25.525,
         25.339, 25.329, 26.294, 26.27, 26.085, 25.9, 25.717, 25.536, 25.356, 25.177, 24.999, 24.822, 24.646, 24.469,
         24.294, 24.119, 23.946, 23.774, 23.603, 23.433, 23.264, 23.096, 22.93, 22.765, 22.601, 22.438, 22.276, 22.115,
         21.955, 21.797, 21.64, 21.483, 21.328, 21.175, 21.022, 20.87, 20.72, 20.571, 20.423, 20.276, 20.13, 19.986,
         19.843, 19.7, 19.559, 19.42, 19.281, 19.143, 19.007, 18.871, 18.737, 18.604, 18.472, 18.34, 18.202, 18.065,
         17.929, 17.793, 17.659, 17.526, 17.395, 17.259, 17.124, 16.991, 16.859, 16.728, 16.598, 16.47, 16.342, 16.216,
         16.091, 15.967, 15.844, 15.723, 15.602, 15.483, 15.365, 15.247, 15.131, 15.016, 14.902, 14.789, 14.677, 14.566,
         14.456, 14.347, 14.239, 14.132, 14.026, 13.921, 13.817, 13.714, 13.611, 13.51, 13.409, 13.31, 13.211, 13.113,
         13.016, 12.917, 12.817, 12.719, 12.621, 12.524, 12.428, 12.333, 12.239, 12.145, 12.051, 11.959, 11.867, 11.776,
         11.685, 11.596, 11.507, 11.419, 11.332, 11.246, 11.161, 11.075, 10.991, 10.907, 10.824, 10.742, 10.66, 10.577,
         10.494, 10.413, 10.332, 10.252, 10.173, 10.094, 10.016, 9.9388, 9.8622, 9.7863, 9.7111, 9.6365, 9.5626, 9.4894,
         9.4168, 9.3449, 9.2732, 9.2019, 9.1312, 9.0611, 8.9917, 8.9228, 8.8546, 8.787, 8.7199, 8.6534, 8.5876, 8.5223,
         8.4575, 8.3934, 8.3297, 8.2667, 8.2042, 8.1422, 8.0808, 8.0199, 7.9595, 7.8996, 7.8403, 7.7815, 7.7232, 7.6653,
         7.608, 7.5512, 7.4949, 7.439, 7.3836, 7.3288, 7.2743, 7.2204, 7.1669, 7.1138, 7.0612, 7.0091, 6.9574, 6.9061,
         6.8553, 6.8049, 6.7549, 6.7054, 6.6563, 6.6076, 6.5593, 6.5114, 6.4639, 6.4168, 6.3701, 6.3238, 6.2779, 6.2324,
         6.1872, 6.1425, 6.0981, 6.0541, 6.0104, 5.9671, 5.9242, 5.8816, 5.8394, 5.7976, 5.756, 5.7149, 5.6739, 5.6323,
         5.1662, 4.6054, 4.114, 3.9003, 3.7989, 3.7726, 10.054, 9.8862, 9.7998, 8.8051, 8.3732, 8.1516, 8.094, 11.198,
         10.954, 10.915, 10.803, 10.524, 10.451, 11.989, 11.716, 11.38, 10.243, 9.2061, 8.2709, 7.421, 6.6588, 5.9775,
         5.3686, 4.8164, 4.3229, 3.8784, 3.4496, 3.0625, 2.7212, 2.4198, 2.1537, 1.9184, 1.7101, 1.5255, 1.3611, 1.2132,
         1.0816, 0.9614, 0.85345, 0.75785, 0.67312, 0.65775, 0.64032, 0.6358, 3.1906, 3.1202, 3.0566, 2.7456, 2.46,
         2.208, 1.978, 1.7681, 1.5807, 1.4134, 1.2639, 1.1304, 1.0107, 0.90147, 0.8041, 0.71732, 0.63996, 0.57101,
         0.50952, 0.4547, 0.40581, 0.36221, 0.32332, 0.28863, 0.2588, 0.23298, 0.20976, 0.18887, 0.17007]],
    'Ir':                                                                                                         [
        [0.006717466, 0.006820284, 0.006847702, 0.00688883, 0.006991648, 0.007901491, 0.008022432, 0.008054683,
         0.008103059, 0.008224, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306,
         0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327,
         0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04949, 0.04959809,
         0.0502475, 0.0504495, 0.0507525, 0.05151, 0.05302035, 0.05667876, 0.05929, 0.0601975, 0.0604395, 0.06058959,
         0.0608025, 0.06171, 0.06174, 0.062132, 0.062685, 0.062937, 0.063083, 0.0633366, 0.063717, 0.06426, 0.064668,
         0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.093296, 0.094724, 0.0951048,
         0.095676, 0.09665893, 0.097104, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005,
         0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.289002,
         0.2934255, 0.2946051, 0.2963745, 0.3005128, 0.300798, 0.305172, 0.309843, 0.3110886, 0.312957, 0.317628,
         0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.484414, 0.4918285, 0.4938057,
         0.4967715, 0.5, 0.5025, 0.5050125, 0.50753756, 0.51007525, 0.51262563, 0.51518875, 0.5177647, 0.52035352,
         0.52295529, 0.52557007, 0.52819792, 0.53083891, 0.5334931, 0.53616057, 0.53884137, 0.54153558, 0.54424325,
         0.54696447, 0.54969929, 0.55244779, 0.55521003, 0.55798608, 0.56077601, 0.56357989, 0.56639779, 0.56922978,
         0.57207593, 0.5749363, 0.57626318, 0.57781099, 0.57793677, 0.58070004, 0.58360354, 0.58652156, 0.58945417,
         0.59240144, 0.59536345, 0.59834026, 0.60133196, 0.60433862, 0.60736032, 0.61039712, 0.6134491, 0.61651635,
         0.61959893, 0.62269693, 0.62581041, 0.62893946, 0.63208416, 0.63524458, 0.6384208, 0.64161291, 0.64482097,
         0.64804508, 0.6512853, 0.65454173, 0.65781444, 0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508,
         0.6777972, 0.68118619, 0.68459212, 0.68801508, 0.68899585, 0.69120417, 0.69145515, 0.69491243, 0.69838699,
         0.70187893, 0.70538832, 0.70891526, 0.71245984, 0.71602214, 0.71960225, 0.72320026, 0.72681626, 0.73045034,
         0.7341026, 0.73777311, 0.74146197, 0.74516928, 0.74889513, 0.75263961, 0.7564028, 0.76018482, 0.76398574,
         0.76780567, 0.7716447, 0.77550292, 0.77938044, 0.78327734, 0.78719373, 0.79112969, 0.79508534, 0.79906077,
         0.80305607, 0.80707135, 0.81110671, 0.81516224, 0.81923806, 0.82333425, 0.82745092, 0.83158817, 0.83574611,
         0.83992484, 0.84412447, 0.84834509, 0.85258682, 0.85684975, 0.861134, 0.86543967, 0.86976687, 0.8741157,
         0.87848628, 0.88287871, 0.8872931, 0.89172957, 0.89618822, 0.90066916, 0.9051725, 0.90969837, 0.91424686,
         0.91881809, 0.92341218, 0.92802924, 0.93266939, 0.93733274, 0.9420194, 0.9467295, 0.95146315, 0.95622046,
         0.96100156, 0.96580657, 0.9706356, 0.97548878, 0.98036623, 0.98526806, 0.9901944, 0.99514537, 1.0001211,
         1.0051217, 1.0101473, 1.015198, 1.020274, 1.0253754, 1.0305023, 1.0356548, 1.0408331, 1.0460372, 1.0512674,
         1.0565238, 1.0618064, 1.0671154, 1.072451, 1.0778132, 1.0832023, 1.0886183, 1.0940614, 1.0995317, 1.1050294,
         1.1105545, 1.1161073, 1.1216878, 1.1272963, 1.1329328, 1.1385974, 1.1442904, 1.1500119, 1.1557619, 1.1615407,
         1.1673484, 1.1731852, 1.1790511, 1.1849464, 1.1908711, 1.1968254, 1.2028096, 1.2088236, 1.2148677, 1.2209421,
         1.2270468, 1.233182, 1.2393479, 1.2455447, 1.2517724, 1.2580312, 1.2643214, 1.270643, 1.2769962, 1.2833812,
         1.2897981, 1.2962471, 1.3027283, 1.309242, 1.3157882, 1.3223671, 1.328979, 1.3356239, 1.342302, 1.3490135,
         1.3557586, 1.3625374, 1.36935, 1.3761968, 1.3830778, 1.3899932, 1.3969431, 1.4039278, 1.4109475, 1.4180022,
         1.4250922, 1.4322177, 1.4393788, 1.4465757, 1.4538086, 1.4610776, 1.468383, 1.4757249, 1.4831035, 1.490519,
         1.4979716, 1.5054615, 1.5129888, 1.5205537, 1.5281565, 1.5357973, 1.5434763, 1.5511937, 1.5589496, 1.5667444,
         1.5745781, 1.582451, 1.5903633, 1.5983151, 1.6063066, 1.6143382, 1.6224099, 1.6305219, 1.6386745, 1.6468679,
         1.6551022, 1.6633777, 1.6716946, 1.6800531, 1.6884534, 1.6968956, 1.7053801, 1.713907, 1.7224766, 1.7310889,
         1.7397444, 1.7484431, 1.7571853, 1.7659712, 1.7748011, 1.7836751, 1.7925935, 1.8015565, 1.8105642, 1.8196171,
         1.8287151, 1.8378587, 1.847048, 1.8562833, 1.8655647, 1.8748925, 1.884267, 1.8936883, 1.9031567, 1.9126725,
         1.9222359, 1.9318471, 1.9415063, 1.9512138, 1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868,
         2.0205393, 2.030642, 2.0399144, 2.0407952, 2.0408856, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278,
         2.1027895, 2.1133034, 2.1153256, 2.1168746, 2.1238699, 2.1344893, 2.1451617, 2.1558875, 2.166667, 2.1775003,
         2.1883878, 2.1993297, 2.2103264, 2.221378, 2.2324849, 2.2436473, 2.2548656, 2.2661399, 2.2774706, 2.2888579,
         2.3003022, 2.3118037, 2.3233628, 2.3349796, 2.3466545, 2.3583878, 2.3701797, 2.3820306, 2.3939407, 2.4059104,
         2.41794, 2.4300297, 2.4421798, 2.4543907, 2.4666627, 2.478996, 2.491391, 2.5038479, 2.5163672, 2.528949,
         2.5415938, 2.5483176, 2.5530823, 2.5543017, 2.5670732, 2.5799086, 2.5928082, 2.6057722, 2.6188011, 2.6318951,
         2.6450545, 2.6582798, 2.6715712, 2.6849291, 2.6983537, 2.7118455, 2.7254047, 2.7390317, 2.7527269, 2.7664905,
         2.780323, 2.7942246, 2.8081957, 2.8222367, 2.8363479, 2.8505296, 2.8647823, 2.8791062, 2.8935017, 2.9045696,
         2.9079692, 2.9128303, 2.9225091, 2.9371216, 2.9518072, 2.9665662, 2.9813991, 2.9963061, 3.0112876, 3.026344,
         3.0414758, 3.0566831, 3.0719666, 3.0873264, 3.102763, 3.1182768, 3.1338682, 3.1495376, 3.1652853, 3.1671623,
         3.1802379, 3.1811117, 3.1970172, 3.2130023, 3.2290673, 3.2452127, 3.2614387, 3.2777459, 3.2941347, 3.3106053,
         3.3271584, 3.3437941, 3.3605131, 3.3773157, 3.3942023, 3.4111733, 3.4282291, 3.4453703, 3.4625971, 3.4799101,
         3.4973097, 3.5147962, 3.5323702, 3.5500321, 3.5677822, 3.5856211, 3.6035492, 3.621567, 3.6396748, 3.6578732,
         3.6761626, 3.6945434, 3.7130161, 3.7315812, 3.7502391, 3.7689903, 3.7878352, 3.8067744, 3.8258083, 3.8449373,
         3.864162, 3.8834828, 3.9029002, 3.9224147, 3.9420268, 3.9617369, 3.9815456, 4.0014533, 4.0214606, 4.0415679,
         4.0617757, 4.0820846, 4.102495, 4.1230075, 4.1436226, 4.1643407, 4.1851624, 4.2060882, 4.2271186, 4.2482542,
         4.2694955, 4.290843, 4.3122972, 4.3338587, 4.355528, 4.3773056, 4.3991921, 4.4211881, 4.443294, 4.4655105,
         4.4878381, 4.5102772, 4.5328286, 4.5554928, 4.5782702, 4.6011616, 4.6241674, 4.6472882, 4.6705247, 4.6938773,
         4.7173467, 4.7409334, 4.7646381, 4.7884613, 4.8124036, 4.8364656, 4.8606479, 4.8849512, 4.9093759, 4.9339228,
         4.9585924, 4.9833854, 5.0083023, 5.0333438, 5.0585105, 5.0838031, 5.1092221, 5.1347682, 5.1604421, 5.1862443,
         5.2121755, 5.2382364, 5.2644276, 5.2907497, 5.3172034, 5.3437895, 5.3705084, 5.3973609, 5.4243477, 5.4514695,
         5.4787268, 5.5061205, 5.5336511, 5.5613193, 5.5891259, 5.6170716, 5.6451569, 5.6733827, 5.7017496, 5.7302584,
         5.7589096, 5.7877042, 5.8166427, 5.8457259, 5.8749546, 5.9043293, 5.933851, 5.9635202, 5.9933378, 6.0233045,
         6.053421, 6.0836882, 6.1141066, 6.1446771, 6.1754005, 6.2062775, 6.2373089, 6.2684954, 6.2998379, 6.3313371,
         6.3629938, 6.3948088, 6.4267828, 6.4589167, 6.4912113, 6.5236674, 6.5562857, 6.5890671, 6.6220125, 6.6551225,
         6.6883981, 6.7218401, 6.7554493, 6.7892266, 6.8231727, 6.8572886, 6.891575, 6.9260329, 6.9606631, 6.9954664,
         7.0304437, 7.0655959, 7.1009239, 7.1364285, 7.1721107, 7.2079712, 7.2440111, 7.2802311, 7.3166323, 7.3532155,
         7.3899815, 7.4269314, 7.4640661, 7.5013864, 7.5388934, 7.5765878, 7.6144708, 7.6525431, 7.6908058, 7.7292599,
         7.7679062, 7.8067457, 7.8457794, 7.8850083, 7.9244334, 7.9640555, 8.0038758, 8.0438952, 8.0841147, 8.1245352,
         8.1651579, 8.2059837, 8.2470136, 8.2882487, 8.3296899, 8.3713384, 8.4131951, 8.455261, 8.4975373, 8.540025,
         9.030794, 9.653919, 10.32004, 10.9909, 11.03212, 11.15912, 11.20399, 11.27128, 11.4395, 11.79334, 12.56762,
         12.60708, 12.75998, 12.81128, 12.88822, 13.08058, 13.15013, 13.35141, 13.40508, 13.47697, 13.48559, 13.68687,
         14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676,
         30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927,
         62.5287, 66.84318, 71.45536, 74.58878, 75.73045, 76.03489, 76.38578, 76.49156, 77.63322, 81.6564, 87.29069,
         93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539,
         194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588,
         405.0001, 432.9451],
        [4.56877, 4.16587, 3.73576, 4.14282, 4.45737, 4.03188, 3.53288, 2.9688, 3.53226, 3.99314, 3.38848, 2.96561,
         2.55014, 2.18886, 1.94176, 1.88002, 2.07886, 2.6057, 3.50548, 4.78653, 6.44486, 8.33051, 10.3573, 12.4238,
         14.3236, 15.9807, 17.3146, 18.2867, 18.8911, 19.1469, 19.0841, 18.7149, 17.9644, 16.1569, 16.018, 14.4719,
         12.5153, 14.5315, 16.2312, 17.2269, 17.6944, 17.3548, 16.9764, 16.6584, 16.6908, 16.8392, 16.7342, 16.7231,
         16.527, 15.9261, 14.9598, 15.0907, 15.7433, 16.3888, 16.8506, 17.0671, 17.1121, 17.9097, 18.0316, 17.8796,
         17.5331, 17.0275, 16.7328, 16.5559, 16.4751, 16.4603, 16.3907, 16.3524, 15.7408, 14.9948, 14.1999, 13.3897,
         12.6056, 11.8996, 11.3326, 10.9631, 10.8566, 11.1168, 11.7275, 12.6646, 13.9679, 15.6081, 17.5168, 19.5218,
         20.2676, 20.4939, 20.3212, 20.7932, 21.4565, 21.4938, 22.0091, 22.3954, 22.3178, 22.7603, 23.4958, 23.9718,
         26.506, 28.8296, 30.9648, 32.8844, 34.5337, 35.6763, 35.7171, 35.3653, 34.6352, 35.591, 37.4872, 37.7853,
         38.0335, 38.2526, 38.4523, 38.6381, 38.8133, 38.9802, 39.1402, 39.2943, 39.4434, 39.588, 39.7286, 39.8656,
         39.9991, 40.1295, 40.2568, 40.3811, 40.5024, 40.6207, 40.7359, 40.8478, 40.9559, 41.0597, 41.1583, 41.2499,
         41.3313, 41.3942, 41.4089, 41.3485, 41.3893, 41.4134, 41.693, 41.8739, 42.0278, 42.1688, 42.302, 42.4297,
         42.5534, 42.6736, 42.7911, 42.906, 43.0188, 43.1295, 43.2383, 43.3453, 43.4505, 43.5541, 43.656, 43.7563,
         43.8549, 43.9518, 44.0471, 44.1405, 44.2321, 44.3216, 44.409, 44.4939, 44.5762, 44.6552, 44.7304, 44.8008,
         44.8648, 44.9197, 44.9601, 44.9722, 44.8994, 44.8169, 44.8764, 44.9183, 45.2283, 45.4135, 45.5652, 45.7008,
         45.8266, 45.9457, 46.06, 46.1705, 46.2779, 46.3828, 46.4855, 46.5862, 46.6852, 46.7827, 46.8787, 46.9735,
         47.067, 47.1594, 47.2507, 47.341, 47.4303, 47.5187, 47.6063, 47.6929, 47.7787, 47.8637, 47.9479, 48.0314,
         48.1141, 48.1961, 48.2773, 48.3579, 48.4378, 48.5171, 48.5957, 48.6737, 48.7511, 48.828, 48.9041, 48.9795,
         49.0541, 49.1281, 49.2014, 49.274, 49.346, 49.4173, 49.488, 49.558, 49.6275, 49.709, 49.7773, 49.845, 49.9121,
         49.9787, 50.0446, 50.11, 50.1748, 50.2391, 50.3029, 50.3661, 50.4365, 50.4988, 50.5606, 50.6219, 50.6828,
         50.7432, 50.8031, 50.8627, 50.922, 50.9808, 51.0392, 51.0974, 51.1553, 51.2133, 51.2831, 51.3507, 51.416,
         51.4793, 51.5405, 51.5998, 51.6573, 51.7131, 51.7671, 51.8196, 51.8705, 51.9199, 51.9679, 52.0145, 52.0598,
         52.1039, 52.1466, 52.1882, 52.2286, 52.2679, 52.3062, 52.3434, 52.3795, 52.4147, 52.449, 52.4825, 52.5149,
         52.5462, 52.5762, 52.6052, 52.6331, 52.6598, 52.6855, 52.7099, 52.7325, 52.7535, 52.7725, 52.7896, 52.805,
         52.8186, 52.8305, 52.8407, 52.8493, 52.8564, 52.8616, 52.8649, 52.8663, 52.8657, 52.8632, 52.859, 52.8529,
         52.845, 52.8354, 52.824, 52.8109, 52.7961, 52.7796, 52.7614, 52.7416, 52.7201, 52.6969, 52.672, 52.6455,
         52.6173, 52.5874, 52.5558, 52.5226, 52.4876, 52.4509, 52.4125, 52.3724, 52.3304, 52.2867, 52.2412, 52.1938,
         52.1445, 52.0934, 52.0403, 51.9901, 51.9331, 51.874, 51.8128, 51.7494, 51.6839, 51.6161, 51.546, 51.4735,
         51.3985, 51.3211, 51.241, 51.1583, 51.0728, 50.9844, 50.8931, 50.7987, 50.7011, 50.6002, 50.4959, 50.388,
         50.2763, 50.1608, 50.0412, 49.9173, 49.789, 49.656, 49.5181, 49.3751, 49.2266, 49.0723, 48.9119, 48.7495,
         48.5759, 48.395, 48.2064, 48.0095, 47.8037, 47.5885, 47.363, 47.1265, 46.878, 46.6166, 46.341, 46.0499,
         45.7419, 45.4151, 45.0674, 44.6965, 44.2995, 43.8729, 43.4125, 42.9132, 42.3686, 41.7703, 41.1078, 40.3666,
         39.5267, 38.5591, 37.4194, 36.0335, 34.2637, 31.8011, 27.6452, 10.7769, 9.32243, 10.4675, 27.3377, 30.6781,
         32.3347, 33.1343, 33.2153, 32.2773, 27.5966, 23.0704, 23.0261, 32.1225, 36.1133, 38.5261, 40.3384, 41.8173,
         43.0778, 44.1813, 45.1648, 46.0525, 46.8616, 47.6044, 48.2902, 48.9263, 49.5183, 50.071, 50.588, 51.0723,
         51.5265, 51.9525, 52.352, 52.7262, 53.0763, 53.4029, 53.7065, 53.987, 54.2442, 54.4774, 54.6854, 54.8659,
         55.016, 55.1307, 55.2025, 55.2192, 55.159, 54.979, 54.5741, 53.5405, 51.6624, 51.6985, 52.3543, 54.9291,
         56.0628, 56.8583, 57.4933, 58.0317, 58.5039, 58.9267, 59.3094, 59.6553, 59.9687, 60.2631, 60.5404, 60.8014,
         61.0473, 61.2786, 61.4945, 61.6946, 61.8786, 62.0453, 62.1927, 62.3171, 62.4121, 62.465, 62.4469, 62.267,
         61.6647, 60.6972, 61.7623, 62.6103, 63.2269, 63.6512, 63.9929, 64.2848, 64.5374, 64.7643, 64.973, 65.1638,
         65.3382, 65.4971, 65.6398, 65.7637, 65.8635, 65.928, 65.9274, 65.7257, 65.6566, 65.7879, 65.8414, 66.4097,
         66.7523, 67.027, 67.267, 67.485, 67.6875, 67.878, 68.0589, 68.2316, 68.3965, 68.5549, 68.7073, 68.8543,
         68.9964, 69.1339, 69.267, 69.3961, 69.5213, 69.6428, 69.7608, 69.8754, 69.9869, 70.0952, 70.2005, 70.3028,
         70.4024, 70.4993, 70.5935, 70.6851, 70.7742, 70.8609, 70.9451, 71.027, 71.1066, 71.184, 71.2596, 71.3337,
         71.4062, 71.4771, 71.5466, 71.6147, 71.6813, 71.7466, 71.8106, 71.8734, 71.9351, 71.9956, 72.055, 72.1135,
         72.3705, 72.4277, 72.483, 72.5366, 72.5884, 72.6385, 72.6871, 72.7343, 72.9168, 72.9612, 73.0036, 73.0444,
         73.0836, 73.1212, 73.1574, 73.1921, 73.2255, 73.2577, 73.2886, 73.3184, 73.347, 73.3745, 73.401, 73.4265,
         73.451, 73.4745, 73.4972, 73.519, 73.5399, 73.56, 73.5794, 73.598, 73.6158, 73.6329, 73.6494, 73.6652, 73.6803,
         73.6949, 73.7088, 73.7222, 73.7351, 73.7474, 73.7592, 73.7706, 73.7816, 73.8934, 73.9041, 73.914, 73.923,
         73.9313, 73.9388, 73.9457, 73.9518, 73.9574, 73.9623, 73.9667, 73.9705, 73.9737, 73.9764, 73.9787, 73.9804,
         73.9817, 73.9826, 73.983, 73.9829, 73.9824, 73.9814, 73.9801, 73.9783, 73.9762, 73.9737, 73.9709, 74.0126,
         74.0093, 74.0054, 74.001, 73.9962, 73.9908, 73.9849, 73.9786, 73.9718, 73.9646, 73.957, 73.949, 73.9406,
         73.9318, 73.9226, 73.9131, 73.9032, 73.9102, 73.8998, 73.8889, 73.8777, 73.8661, 73.8541, 73.8417, 73.829,
         73.816, 73.8026, 73.7889, 73.7748, 73.7604, 73.7457, 73.7307, 73.7153, 73.6996, 73.6836, 73.6673, 73.6507,
         73.6338, 73.6166, 73.599, 73.5812, 73.563, 73.5445, 73.5258, 73.5067, 73.4873, 73.4676, 73.4476, 73.4273,
         73.4066, 73.3857, 73.3644, 73.3428, 73.3208, 73.2986, 73.276, 73.253, 73.2297, 73.2061, 73.1821, 73.1578,
         73.1331, 73.108, 73.0826, 73.0567, 73.0305, 73.0039, 72.9768, 72.9494, 72.9216, 72.8933, 72.8646, 72.8354,
         72.8058, 72.7758, 72.7453, 72.7143, 72.3985, 71.7147, 70.5598, 67.7771, 67.3739, 65.0235, 61.803, 65.001,
         67.8144, 69.5633, 69.8713, 69.7514, 68.684, 67.1004, 68.7619, 70.2336, 70.4517, 70.4642, 69.7841, 70.7259,
         70.8202, 72.0088, 73.823, 75.094, 75.8828, 76.4106, 76.7621, 76.9951, 77.1466, 77.3024, 77.3502, 77.4048,
         77.4354, 77.3918, 77.3244, 77.2424, 77.151, 77.0532, 76.9504, 76.8433, 76.731, 76.6111, 76.4779, 76.3242,
         76.1313, 75.8591, 75.372, 74.5466, 73.4668, 72.1743, 73.2084, 73.4802, 74.6592, 75.803, 76.4034, 76.7318,
         76.9419, 77.0807, 77.1722, 77.2324, 77.2708, 77.2938, 77.3058, 77.3357, 77.3314, 77.3223, 77.3099, 77.2953,
         77.2794, 77.2627, 77.2457, 77.2287, 77.2119, 77.1954, 77.1791, 77.164, 77.1505, 77.1381, 77.1268],
        [0.0, 0.0, 0.0, 0.81569, 0.80003, 0.6995, 0.69891, 0.69931, 1.7893, 1.7635, 2.2596, 2.763, 3.4451, 4.3234,
         5.4058, 6.6815, 8.113, 9.6315, 11.138, 12.515, 13.638, 14.402, 14.736, 14.616, 14.069, 13.163, 11.994, 10.67,
         9.2918, 7.9469, 6.6989, 5.5846, 4.619, 3.8261, 3.8017, 3.6588, 3.6158, 7.3654, 7.078, 6.5492, 5.4755, 4.8462,
         4.6499, 4.5994, 5.0898, 5.0424, 4.8471, 4.8408, 4.7598, 4.6488, 4.5995, 6.4019, 6.3493, 6.6245, 6.5117, 6.4291,
         6.4087, 5.6306, 4.985, 4.4354, 3.9991, 3.696, 3.6047, 3.5729, 3.5659, 3.6404, 3.6286, 3.6245, 3.6506, 3.8583,
         4.2715, 4.9107, 5.7993, 6.9456, 8.3499, 9.9997, 11.853, 13.856, 15.936, 18.011, 19.993, 21.797, 23.315, 24.462,
         24.82, 24.987, 25.027, 25.669, 25.82, 25.829, 25.968, 26.095, 26.126, 26.615, 26.729, 26.805, 27.073, 27.057,
         26.807, 26.369, 25.788, 25.103, 24.989, 24.819, 24.774, 26.311, 26.241, 26.186, 26.131, 26.076, 26.02, 25.964,
         25.908, 25.852, 25.795, 25.738, 25.681, 25.624, 25.566, 25.508, 25.45, 25.392, 25.333, 25.274, 25.215, 25.156,
         25.097, 25.037, 24.977, 24.917, 24.857, 24.797, 24.736, 24.675, 24.614, 24.586, 24.925, 24.923, 24.866, 24.806,
         24.746, 24.686, 24.626, 24.566, 24.505, 24.444, 24.384, 24.323, 24.262, 24.2, 24.139, 24.078, 24.016, 23.954,
         23.892, 23.831, 23.768, 23.706, 23.644, 23.582, 23.519, 23.457, 23.394, 23.331, 23.268, 23.205, 23.142, 23.079,
         23.015, 22.952, 22.889, 22.825, 22.761, 22.743, 23.242, 23.237, 23.174, 23.111, 23.048, 22.985, 22.921, 22.858,
         22.794, 22.731, 22.667, 22.604, 22.54, 22.476, 22.412, 22.349, 22.285, 22.221, 22.157, 22.093, 22.029, 21.964,
         21.9, 21.836, 21.772, 21.707, 21.643, 21.578, 21.514, 21.449, 21.385, 21.32, 21.256, 21.191, 21.126, 21.062,
         20.997, 20.932, 20.867, 20.803, 20.737, 20.671, 20.605, 20.539, 20.474, 20.408, 20.342, 20.276, 20.21, 20.144,
         20.078, 20.012, 19.946, 19.88, 19.814, 19.749, 19.683, 19.617, 19.551, 19.485, 19.42, 19.354, 19.288, 19.223,
         19.157, 19.091, 19.026, 18.96, 18.894, 18.829, 18.764, 18.698, 18.632, 18.567, 18.501, 18.435, 18.349, 18.263,
         18.177, 18.092, 18.007, 17.922, 17.837, 17.753, 17.67, 17.586, 17.503, 17.42, 17.338, 17.256, 17.174, 17.093,
         17.012, 16.931, 16.851, 16.771, 16.692, 16.613, 16.534, 16.456, 16.378, 16.297, 16.211, 16.126, 16.041, 15.957,
         15.873, 15.79, 15.707, 15.616, 15.524, 15.427, 15.331, 15.235, 15.141, 15.047, 14.954, 14.861, 14.77, 14.679,
         14.583, 14.488, 14.393, 14.3, 14.207, 14.115, 14.023, 13.933, 13.843, 13.754, 13.666, 13.578, 13.492, 13.406,
         13.321, 13.236, 13.152, 13.069, 12.987, 12.905, 12.824, 12.744, 12.665, 12.586, 12.507, 12.43, 12.353, 12.277,
         12.201, 12.126, 12.052, 11.978, 11.905, 11.832, 11.76, 11.689, 11.618, 11.548, 11.478, 11.409, 11.341, 11.273,
         11.206, 11.139, 11.073, 11.007, 10.942, 10.877, 10.813, 10.749, 10.686, 10.624, 10.562, 10.5, 10.439, 10.378,
         10.318, 10.259, 10.2, 10.141, 10.083, 10.025, 9.9678, 9.911, 9.8546, 9.7987, 9.7432, 9.6882, 9.6336, 9.5794,
         9.5257, 9.4724, 9.4194, 9.3669, 9.3147, 9.263, 9.2116, 9.1607, 9.1101, 9.06, 9.0102, 8.9608, 8.9118, 8.8632,
         8.8149, 8.7671, 8.7195, 8.6724, 8.6256, 8.5791, 8.5331, 8.4873, 8.4413, 8.3943, 8.3477, 8.3014, 8.2555, 8.2099,
         8.1686, 25.629, 25.627, 25.448, 25.268, 25.09, 24.913, 24.737, 24.563, 24.39, 24.357, 35.877, 35.705, 35.448,
         35.193, 34.939, 34.688, 34.438, 34.191, 33.945, 33.701, 33.459, 33.219, 32.981, 32.744, 32.51, 32.277, 32.046,
         31.816, 31.588, 31.361, 31.136, 30.913, 30.691, 30.471, 30.252, 30.036, 29.821, 29.607, 29.395, 29.185, 28.976,
         28.769, 28.564, 28.36, 28.157, 27.956, 27.757, 27.559, 27.455, 32.14, 32.117, 31.877, 31.639, 31.402, 31.168,
         30.935, 30.704, 30.475, 30.244, 30.01, 29.791, 29.582, 29.376, 29.172, 28.972, 28.773, 28.571, 28.372, 28.175,
         27.98, 27.787, 27.595, 27.406, 27.218, 27.032, 26.847, 26.706, 26.663, 28.444, 28.302, 28.091, 27.881, 27.674,
         27.468, 27.264, 27.057, 26.853, 26.653, 26.455, 26.261, 26.07, 25.88, 25.692, 25.506, 25.321, 25.138, 25.117,
         26.078, 26.068, 25.885, 25.703, 25.523, 25.344, 25.166, 24.989, 24.814, 24.639, 24.464, 24.289, 24.115, 23.942,
         23.771, 23.6, 23.431, 23.262, 23.094, 22.928, 22.762, 22.597, 22.434, 22.271, 22.109, 21.949, 21.789, 21.631,
         21.473, 21.317, 21.161, 21.007, 20.854, 20.702, 20.551, 20.401, 20.254, 20.108, 19.964, 19.821, 19.679, 19.538,
         19.399, 19.26, 19.123, 18.986, 18.851, 18.717, 18.584, 18.453, 18.322, 18.192, 18.055, 17.919, 17.784, 17.649,
         17.516, 17.385, 17.254, 17.12, 16.987, 16.855, 16.723, 16.594, 16.465, 16.337, 16.211, 16.086, 15.962, 15.839,
         15.717, 15.596, 15.477, 15.358, 15.241, 15.125, 15.009, 14.895, 14.782, 14.67, 14.559, 14.449, 14.34, 14.231,
         14.124, 14.018, 13.913, 13.809, 13.705, 13.603, 13.501, 13.401, 13.301, 13.202, 13.104, 13.007, 12.91, 12.81,
         12.712, 12.614, 12.517, 12.422, 12.326, 12.232, 12.139, 12.046, 11.955, 11.864, 11.774, 11.684, 11.596, 11.508,
         11.421, 11.334, 11.248, 11.162, 11.078, 10.994, 10.91, 10.828, 10.746, 10.665, 10.585, 10.503, 10.422, 10.341,
         10.261, 10.182, 10.103, 10.025, 9.9478, 9.8712, 9.7953, 9.7201, 9.6456, 9.5718, 9.4985, 9.426, 9.3541, 9.2828,
         9.2118, 9.1412, 9.0712, 9.0018, 8.933, 8.8649, 8.7973, 8.7303, 8.6639, 8.5981, 8.5329, 8.4682, 8.4041, 8.3405,
         8.2775, 8.2151, 8.1532, 8.0918, 8.031, 7.9707, 7.9109, 7.8516, 7.7928, 7.7346, 7.6768, 7.6196, 7.5628, 7.5066,
         7.4508, 7.3955, 7.3406, 7.2863, 7.2324, 7.1789, 7.1259, 7.0734, 7.0213, 6.9697, 6.9185, 6.8677, 6.8174, 6.7675,
         6.718, 6.6689, 6.6203, 6.5721, 6.5242, 6.4768, 6.4298, 6.3831, 6.3369, 6.291, 6.2456, 6.2005, 6.1558, 6.1115,
         6.0675, 6.0239, 5.9807, 5.9378, 5.4576, 4.867, 4.346, 3.9125, 3.8882, 3.8127, 3.7864, 10.038, 9.7835, 9.2813,
         8.3062, 8.2608, 8.087, 8.03, 11.12, 10.842, 10.744, 10.468, 10.396, 11.938, 11.926, 11.656, 10.762, 9.6762,
         8.6962, 7.8074, 7.0052, 6.2881, 5.6474, 5.0712, 4.5513, 4.0864, 3.6367, 3.2288, 2.869, 2.5514, 2.2709, 2.0228,
         1.8034, 1.609, 1.4365, 1.2811, 1.143, 1.0186, 0.90442, 0.80341, 0.71368, 0.66151, 0.64402, 0.63949, 3.1835,
         3.1769, 3.1075, 2.874, 2.5766, 2.3102, 2.0719, 1.8524, 1.6564, 1.4813, 1.325, 1.1853, 1.0604, 0.94708, 0.84519,
         0.75434, 0.67332, 0.60105, 0.5366, 0.4791, 0.42779, 0.38202, 0.34117, 0.30471, 0.27235, 0.24539, 0.22112,
         0.19926, 0.17958]],
    'Pt':                                                                                                         [
        [0.006002872, 0.006094753, 0.006119254, 0.006156007, 0.006247887, 0.007291108, 0.007402706, 0.007432466,
         0.007477105, 0.007588704, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306,
         0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327,
         0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.050666,
         0.0514415, 0.0516483, 0.0519585, 0.052734, 0.05302035, 0.05667876, 0.06058959, 0.063994, 0.06477028, 0.0649735,
         0.0652347, 0.0656265, 0.066606, 0.06923942, 0.069678, 0.0707445, 0.0710289, 0.0714555, 0.072522, 0.072814,
         0.0739285, 0.07401695, 0.0742257, 0.0746715, 0.075786, 0.07912411, 0.08458368, 0.09041995, 0.09665893,
         0.099666, 0.1011915, 0.1015983, 0.1022085, 0.1033284, 0.103734, 0.1104581, 0.1180797, 0.1262272, 0.1349368,
         0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708,
         0.2811158, 0.3005128, 0.307034, 0.3117335, 0.3129867, 0.3148665, 0.319566, 0.3212482, 0.324184, 0.329146,
         0.3304692, 0.332454, 0.337416, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5, 0.5025,
         0.5050125, 0.50753756, 0.51007525, 0.51262563, 0.51518875, 0.5177647, 0.51833567, 0.51966431, 0.52035352,
         0.52295529, 0.52557007, 0.52819792, 0.53083891, 0.5334931, 0.53616057, 0.53884137, 0.54153558, 0.54424325,
         0.54696447, 0.54969929, 0.55244779, 0.55521003, 0.55798608, 0.56077601, 0.56357989, 0.56639779, 0.56922978,
         0.57207593, 0.5749363, 0.57781099, 0.58070004, 0.58360354, 0.58652156, 0.58945417, 0.59240144, 0.59536345,
         0.59834026, 0.60133196, 0.60433862, 0.60736032, 0.60832884, 0.61007116, 0.61039712, 0.6134491, 0.61651635,
         0.61959893, 0.62269693, 0.62581041, 0.62893946, 0.63208416, 0.63524458, 0.6384208, 0.64161291, 0.64482097,
         0.64804508, 0.6512853, 0.65454173, 0.65781444, 0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508,
         0.6777972, 0.68118619, 0.68459212, 0.68801508, 0.69145515, 0.69491243, 0.69838699, 0.70187893, 0.70538832,
         0.70891526, 0.71245984, 0.71602214, 0.71960225, 0.72085202, 0.72320026, 0.72681626, 0.73045034, 0.7341026,
         0.73777311, 0.74146197, 0.74516928, 0.74889513, 0.75263961, 0.7564028, 0.76018482, 0.76398574, 0.76780567,
         0.7716447, 0.77550292, 0.77938044, 0.78327734, 0.78719373, 0.79112969, 0.79508534, 0.79906077, 0.80305607,
         0.80707135, 0.81110671, 0.81516224, 0.81923806, 0.82333425, 0.82745092, 0.83158817, 0.83574611, 0.83992484,
         0.84412447, 0.84834509, 0.85258682, 0.85684975, 0.861134, 0.86543967, 0.86976687, 0.8741157, 0.87848628,
         0.88287871, 0.8872931, 0.89172957, 0.89618822, 0.90066916, 0.9051725, 0.90969837, 0.91424686, 0.91881809,
         0.92341218, 0.92802924, 0.93266939, 0.93733274, 0.9420194, 0.9467295, 0.95146315, 0.95622046, 0.96100156,
         0.96580657, 0.9706356, 0.97548878, 0.98036623, 0.98526806, 0.9901944, 0.99514537, 1.0001211, 1.0051217,
         1.0101473, 1.015198, 1.020274, 1.0253754, 1.0305023, 1.0356548, 1.0408331, 1.0460372, 1.0512674, 1.0565238,
         1.0618064, 1.0671154, 1.072451, 1.0778132, 1.0832023, 1.0886183, 1.0940614, 1.0995317, 1.1050294, 1.1105545,
         1.1161073, 1.1216878, 1.1272963, 1.1329328, 1.1385974, 1.1442904, 1.1500119, 1.1557619, 1.1615407, 1.1673484,
         1.1731852, 1.1790511, 1.1849464, 1.1908711, 1.1968254, 1.2028096, 1.2088236, 1.2148677, 1.2209421, 1.2270468,
         1.233182, 1.2393479, 1.2455447, 1.2517724, 1.2580312, 1.2643214, 1.270643, 1.2769962, 1.2833812, 1.2897981,
         1.2962471, 1.3027283, 1.309242, 1.3157882, 1.3223671, 1.328979, 1.3356239, 1.342302, 1.3490135, 1.3557586,
         1.3625374, 1.36935, 1.3761968, 1.3830778, 1.3899932, 1.3969431, 1.4039278, 1.4109475, 1.4180022, 1.4250922,
         1.4322177, 1.4393788, 1.4465757, 1.4538086, 1.4610776, 1.468383, 1.4757249, 1.4831035, 1.490519, 1.4979716,
         1.5054615, 1.5129888, 1.5205537, 1.5281565, 1.5357973, 1.5434763, 1.5511937, 1.5589496, 1.5667444, 1.5745781,
         1.582451, 1.5903633, 1.5983151, 1.6063066, 1.6143382, 1.6224099, 1.6305219, 1.6386745, 1.6468679, 1.6551022,
         1.6633777, 1.6716946, 1.6800531, 1.6884534, 1.6968956, 1.7053801, 1.713907, 1.7224766, 1.7310889, 1.7397444,
         1.7484431, 1.7571853, 1.7659712, 1.7748011, 1.7836751, 1.7925935, 1.8015565, 1.8105642, 1.8196171, 1.8287151,
         1.8378587, 1.847048, 1.8562833, 1.8655647, 1.8748925, 1.884267, 1.8936883, 1.9031567, 1.9126725, 1.9222359,
         1.9318471, 1.9415063, 1.9512138, 1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868, 2.0205393,
         2.030642, 2.0407952, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278, 2.1027895, 2.1133034, 2.1210653,
         2.1221346, 2.1238699, 2.1344893, 2.1451617, 2.1558875, 2.166667, 2.1775003, 2.1883878, 2.1993297, 2.2011954,
         2.2026046, 2.2103264, 2.221378, 2.2324849, 2.2436473, 2.2548656, 2.2661399, 2.2774706, 2.2888579, 2.3003022,
         2.3118037, 2.3233628, 2.3349796, 2.3466545, 2.3583878, 2.3701797, 2.3820306, 2.3939407, 2.4059104, 2.41794,
         2.4300297, 2.4421798, 2.4543907, 2.4666627, 2.478996, 2.491391, 2.5038479, 2.5163672, 2.528949, 2.5415938,
         2.5543017, 2.5670732, 2.5799086, 2.5928082, 2.6057722, 2.6188011, 2.6318951, 2.6429266, 2.6450545, 2.6478735,
         2.6582798, 2.6715712, 2.6849291, 2.6983537, 2.7118455, 2.7254047, 2.7390317, 2.7527269, 2.7664905, 2.780323,
         2.7942246, 2.8081957, 2.8222367, 2.8363479, 2.8505296, 2.8647823, 2.8791062, 2.8935017, 2.9079692, 2.9225091,
         2.9371216, 2.9518072, 2.9665662, 2.9813991, 2.9963061, 3.0112876, 3.0221418, 3.026344, 3.0308581, 3.0414758,
         3.0566831, 3.0719666, 3.0873264, 3.102763, 3.1182768, 3.1338682, 3.1495376, 3.1652853, 3.1811117, 3.1970172,
         3.2130023, 3.2290673, 3.2452127, 3.2614387, 3.2777459, 3.2891773, 3.2941347, 3.3028227, 3.3106053, 3.3271584,
         3.3437941, 3.3605131, 3.3773157, 3.3942023, 3.4111733, 3.4282291, 3.4453703, 3.4625971, 3.4799101, 3.4973097,
         3.5147962, 3.5323702, 3.5500321, 3.5677822, 3.5856211, 3.6035492, 3.621567, 3.6396748, 3.6578732, 3.6761626,
         3.6945434, 3.7130161, 3.7315812, 3.7502391, 3.7689903, 3.7878352, 3.8067744, 3.8258083, 3.8449373, 3.864162,
         3.8834828, 3.9029002, 3.9224147, 3.9420268, 3.9617369, 3.9815456, 4.0014533, 4.0214606, 4.0415679, 4.0617757,
         4.0820846, 4.102495, 4.1230075, 4.1436226, 4.1643407, 4.1851624, 4.2060882, 4.2271186, 4.2482542, 4.2694955,
         4.290843, 4.3122972, 4.3338587, 4.355528, 4.3773056, 4.3991921, 4.4211881, 4.443294, 4.4655105, 4.4878381,
         4.5102772, 4.5328286, 4.5554928, 4.5782702, 4.6011616, 4.6241674, 4.6472882, 4.6705247, 4.6938773, 4.7173467,
         4.7409334, 4.7646381, 4.7884613, 4.8124036, 4.8364656, 4.8606479, 4.8849512, 4.9093759, 4.9339228, 4.9585924,
         4.9833854, 5.0083023, 5.0333438, 5.0585105, 5.0838031, 5.1092221, 5.1347682, 5.1604421, 5.1862443, 5.2121755,
         5.2382364, 5.2644276, 5.2907497, 5.3172034, 5.3437895, 5.3705084, 5.3973609, 5.4243477, 5.4514695, 5.4787268,
         5.5061205, 5.5336511, 5.5613193, 5.5891259, 5.6170716, 5.6451569, 5.6733827, 5.7017496, 5.7302584, 5.7589096,
         5.7877042, 5.8166427, 5.8457259, 5.8749546, 5.9043293, 5.933851, 5.9635202, 5.9933378, 6.0233045, 6.053421,
         6.0836882, 6.1141066, 6.1446771, 6.1754005, 6.2062775, 6.2373089, 6.2684954, 6.2998379, 6.3313371, 6.3629938,
         6.3948088, 6.4267828, 6.4589167, 6.4912113, 6.5236674, 6.5562857, 6.5890671, 6.6220125, 6.6551225, 6.6883981,
         6.7218401, 6.7554493, 6.7892266, 6.8231727, 6.8572886, 6.891575, 6.9260329, 6.9606631, 6.9954664, 7.0304437,
         7.0655959, 7.1009239, 7.1364285, 7.1721107, 7.2079712, 7.2440111, 7.2802311, 7.3166323, 7.3532155, 7.3899815,
         7.4269314, 7.4640661, 7.5013864, 7.5388934, 7.5765878, 7.6144708, 7.6525431, 7.6908058, 7.7292599, 7.7679062,
         7.8067457, 7.8457794, 7.8850083, 7.9244334, 7.9640555, 8.0038758, 8.0438952, 8.0841147, 8.1245352, 8.1651579,
         8.2059837, 8.2470136, 8.2882487, 8.3296899, 8.3713384, 8.4131951, 8.455261, 8.4975373, 8.540025, 9.030794,
         9.653919, 10.32004, 11.03212, 11.33243, 11.50588, 11.55214, 11.62152, 11.79334, 11.79497, 12.60708, 13.00715,
         13.20624, 13.25933, 13.33896, 13.47697, 13.53805, 13.6023, 13.8105, 13.86602, 13.9493, 14.1575, 14.40688,
         15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405,
         32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287,
         66.84318, 71.45536, 76.38578, 76.8269, 78.00282, 78.3164, 78.78677, 79.96269, 81.6564, 87.29069, 93.31374,
         99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018,
         207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001,
         432.9451],
        [3.45968, 2.90784, 2.30428, 2.88178, 3.34662, 3.09785, 2.65794, 2.16631, 2.64967, 3.04264, 2.24208, 1.99002,
         1.81942, 1.77552, 1.9063, 2.25771, 2.86702, 3.75549, 4.92172, 6.40179, 8.01344, 9.74487, 11.5501, 13.2561,
         14.8194, 16.172, 17.2718, 18.0957, 18.6414, 18.922, 18.953, 18.7355, 18.2131, 17.0219, 16.1027, 14.2792,
         12.113, 14.3873, 16.3401, 16.6791, 18.2365, 18.3622, 17.6527, 17.0874, 16.7849, 15.784, 16.7772, 17.6018,
         18.0672, 18.0661, 17.8893, 17.5907, 17.9428, 18.2507, 18.2857, 18.2725, 18.2476, 18.0963, 18.3595, 18.635,
         18.9032, 18.875, 18.5797, 18.1081, 17.8325, 17.6603, 17.5791, 17.5688, 17.4993, 17.4683, 16.8687, 16.1244,
         15.3098, 14.4497, 13.5764, 12.7388, 12.0002, 11.4223, 11.0854, 11.0666, 11.4312, 12.1856, 13.3649, 14.9325,
         16.8186, 18.8722, 19.4815, 19.7467, 19.5919, 20.067, 20.7951, 21.0057, 21.3431, 21.7758, 21.7179, 22.1665,
         22.9359, 23.7157, 26.4497, 29.0098, 31.3791, 33.5086, 35.3128, 37.3774, 37.4426, 37.4938, 37.5258, 37.5295,
         37.4861, 37.3474, 36.8834, 36.5845, 36.6506, 37.0606, 37.7556, 38.1518, 38.4568, 38.7166, 38.9489, 39.1625,
         39.3625, 39.552, 39.733, 39.9071, 40.0751, 40.238, 40.3962, 40.5502, 40.7004, 40.8471, 40.9903, 41.1304,
         41.2673, 41.4011, 41.5319, 41.6595, 41.7837, 41.9044, 42.0212, 42.1333, 42.2398, 42.3387, 42.4263, 42.493,
         42.4988, 42.4477, 42.5165, 42.5675, 42.8395, 43.0235, 43.1834, 43.331, 43.4711, 43.6057, 43.7361, 43.863,
         43.9869, 44.1081, 44.227, 44.3436, 44.4581, 44.5706, 44.6811, 44.7897, 44.8964, 45.0012, 45.104, 45.2048,
         45.3036, 45.4002, 45.4944, 45.586, 45.6747, 45.7602, 45.8416, 45.9183, 45.9885, 46.0497, 46.0968, 46.1171,
         46.0602, 45.9688, 46.0399, 46.3737, 46.566, 46.723, 46.8632, 46.9933, 47.1166, 47.2348, 47.3492, 47.4603,
         47.5687, 47.6749, 47.7789, 47.8812, 47.9818, 48.0809, 48.1786, 48.275, 48.3702, 48.4642, 48.5571, 48.649,
         48.7399, 48.8298, 48.9187, 49.0068, 49.0939, 49.1802, 49.2657, 49.3504, 49.4342, 49.5173, 49.5997, 49.6813,
         49.7622, 49.8425, 49.9221, 50.0011, 50.0794, 50.1572, 50.2342, 50.3105, 50.3862, 50.4612, 50.5356, 50.6094,
         50.6826, 50.7553, 50.8275, 50.8992, 50.9705, 51.0415, 51.1122, 51.1945, 51.265, 51.3357, 51.4065, 51.478,
         51.5503, 51.624, 51.7, 51.7797, 51.8653, 51.9615, 52.0885, 52.2511, 52.3662, 52.4653, 52.5532, 52.6328,
         52.7062, 52.7744, 52.8385, 52.8989, 52.9562, 53.0109, 53.0631, 53.1132, 53.1614, 53.2077, 53.2524, 53.2955,
         53.3371, 53.3773, 53.4162, 53.4538, 53.4902, 53.5254, 53.5595, 53.5925, 53.6245, 53.6554, 53.6852, 53.7141,
         53.7421, 53.7691, 53.7952, 53.8205, 53.8448, 53.8683, 53.891, 53.9129, 53.9341, 53.9544, 53.9741, 53.993,
         54.0111, 54.0285, 54.0452, 54.0611, 54.0763, 54.0907, 54.1037, 54.1153, 54.1256, 54.1346, 54.1424, 54.149,
         54.1543, 54.1585, 54.1616, 54.1635, 54.1642, 54.1633, 54.161, 54.1568, 54.1508, 54.1431, 54.1337, 54.1225,
         54.1096, 54.0951, 54.0789, 54.061, 54.0413, 54.0197, 53.9962, 53.9709, 53.9438, 53.9148, 53.884, 53.8514,
         53.8169, 53.7805, 53.7423, 53.7022, 53.6602, 53.6163, 53.5704, 53.5226, 53.4728, 53.421, 53.3671, 53.3112,
         53.2599, 53.1997, 53.1373, 53.0726, 53.0056, 52.9363, 52.8645, 52.7902, 52.7134, 52.6339, 52.5517, 52.4667,
         52.3788, 52.2879, 52.1939, 52.0967, 51.9961, 51.8921, 51.7845, 51.6731, 51.5578, 51.4384, 51.3148, 51.1867,
         51.0538, 50.9161, 50.7731, 50.6247, 50.4705, 50.3102, 50.1434, 49.9698, 49.7898, 49.6011, 49.4042, 49.1983,
         48.9829, 48.7572, 48.5205, 48.2717, 48.0099, 47.7339, 47.4424, 47.1337, 46.8061, 46.4575, 46.0855, 45.687,
         45.2586, 44.796, 44.2939, 43.7457, 43.1428, 42.4742, 41.7247, 40.8734, 39.8895, 38.7253, 37.2998, 35.4583,
         32.8376, 28.1254, 12.8681, 12.5624, 20.5054, 29.7864, 32.6834, 34.1696, 34.877, 34.8926, 33.888, 28.8564,
         24.303, 24.2383, 33.9315, 37.7893, 40.1466, 41.9226, 43.3738, 44.6117, 45.6958, 46.6622, 47.5347, 48.3299,
         49.0598, 49.7337, 50.3585, 50.9399, 51.4823, 51.9894, 52.4641, 52.9089, 53.3257, 53.716, 54.0812, 54.4221,
         54.7392, 55.0328, 55.3029, 55.5489, 55.7698, 55.9639, 56.1284, 56.2593, 56.3501, 56.3905, 56.3628, 56.2333,
         55.9261, 55.2002, 52.9149, 50.0359, 52.9484, 55.6183, 56.9294, 57.7856, 58.452, 59.0107, 59.4983, 59.9343,
         60.3302, 60.6921, 61.0216, 61.329, 61.6185, 61.8915, 62.1491, 62.3923, 62.6218, 62.8365, 63.0361, 63.2201,
         63.3874, 63.5359, 63.662, 63.7592, 63.815, 63.8003, 63.6373, 63.0881, 61.266, 63.1851, 64.0249, 64.6111,
         65.0211, 65.354, 65.6406, 65.8946, 66.1231, 66.33, 66.517, 66.6847, 66.8356, 66.9692, 67.0817, 67.1661, 67.206,
         67.1514, 66.9216, 66.5163, 67.0492, 67.3904, 67.8095, 68.108, 68.3571, 68.578, 68.7799, 68.9679, 69.1449,
         69.313, 69.4729, 69.6255, 69.7719, 69.9126, 70.0482, 70.1792, 70.3058, 70.4284, 70.5473, 70.6627, 70.7749,
         70.8839, 70.99, 71.0934, 71.1941, 71.2923, 71.3882, 71.4818, 71.5732, 71.6626, 71.7501, 71.8357, 71.9197,
         72.002, 72.0829, 72.1624, 72.2406, 72.3169, 72.3912, 72.4637, 72.5346, 72.6038, 72.6716, 72.7379, 72.8028,
         72.8664, 72.9288, 72.9901, 73.0502, 73.1093, 73.1674, 73.4221, 73.4787, 73.5336, 73.5866, 73.6378, 73.6875,
         73.7357, 73.7825, 73.9631, 74.0071, 74.0492, 74.0897, 74.1286, 74.166, 74.2019, 74.2364, 74.2697, 74.3016,
         74.3324, 74.362, 74.3904, 74.4178, 74.4441, 74.4694, 74.4938, 74.5172, 74.5397, 74.5613, 74.5821, 74.602,
         74.6212, 74.6396, 74.6572, 74.6741, 74.6904, 74.7059, 74.7208, 74.7351, 74.7488, 74.7619, 74.7745, 74.7865,
         74.7981, 74.8091, 74.8198, 74.9308, 74.9408, 74.9499, 74.9583, 74.9659, 74.9728, 74.979, 74.9845, 74.9894,
         74.9937, 74.9974, 75.0005, 75.0031, 75.0052, 75.0067, 75.0078, 75.0084, 75.0085, 75.0082, 75.0075, 75.0063,
         75.0048, 75.0028, 75.0005, 74.9977, 74.9946, 75.0335, 75.0299, 75.0259, 75.0213, 75.0163, 75.0108, 75.0049,
         74.9985, 74.9918, 74.9845, 74.9769, 74.9689, 74.9605, 74.9517, 74.9426, 74.933, 74.9232, 74.913, 74.9187,
         74.9079, 74.8967, 74.8852, 74.8733, 74.861, 74.8484, 74.8355, 74.8222, 74.8085, 74.7946, 74.7803, 74.7657,
         74.7507, 74.7355, 74.7199, 74.7041, 74.6879, 74.6714, 74.6546, 74.6376, 74.6202, 74.6025, 74.5845, 74.5662,
         74.5476, 74.5287, 74.5095, 74.49, 74.4701, 74.45, 74.4296, 74.4089, 74.3878, 74.3664, 74.3448, 74.3228,
         74.3004, 74.2778, 74.2548, 74.2315, 74.2079, 74.1839, 74.1596, 74.135, 74.11, 74.0847, 74.059, 74.033, 74.0066,
         73.9799, 73.9529, 73.6951, 73.13, 72.2348, 70.5039, 68.8504, 66.1079, 62.8977, 66.0884, 68.8841, 68.8982,
         71.3032, 70.9797, 69.7834, 68.199, 69.8565, 71.0542, 71.3171, 71.5115, 71.5297, 70.8526, 71.8848, 73.0669,
         73.8451, 75.5654, 76.5401, 77.1783, 77.607, 77.8921, 78.0801, 78.2008, 78.3316, 78.3662, 78.4496, 78.4172,
         78.3568, 78.2796, 78.1915, 78.0962, 77.9955, 77.8905, 77.7808, 77.6651, 77.5387, 77.3958, 77.2241, 76.9955,
         76.6375, 75.7414, 75.5554, 74.4831, 73.1997, 74.4981, 75.6651, 76.2943, 77.1764, 77.6103, 77.8719, 78.0302,
         78.1365, 78.2074, 78.2536, 78.2822, 78.2982, 78.3315, 78.33, 78.3228, 78.3119, 78.2983, 78.2831, 78.2669,
         78.2503, 78.2334, 78.2167, 78.2003, 78.1841, 78.1683, 78.1543, 78.1417, 78.13],
        [0.0, 0.0, 0.0, 1.1551, 1.1481, 1.1299, 1.1443, 1.1487, 2.1018, 2.1026, 3.68, 4.4201, 5.3113, 6.3469, 7.5068,
         8.7543, 10.035, 11.28, 12.411, 13.349, 14.024, 14.387, 14.416, 14.117, 13.517, 12.675, 11.661, 10.543, 9.3903,
         8.2613, 7.1971, 6.2238, 5.3545, 4.5925, 4.3714, 4.22, 4.1809, 8.3732, 8.0731, 7.9662, 6.761, 5.7339, 5.0073,
         4.8606, 4.8232, 4.7758, 6.6487, 6.4648, 6.0159, 5.947, 5.786, 5.7446, 6.3025, 6.1304, 6.084, 5.9091, 5.8954,
         5.8631, 6.2059, 6.0247, 5.5118, 4.8128, 4.2658, 3.8676, 3.7348, 3.6809, 3.668, 3.7376, 3.7087, 3.6993, 3.625,
         3.7183, 4.0106, 4.5188, 5.2758, 6.307, 7.6233, 9.2248, 11.089, 13.17, 15.392, 17.665, 19.883, 21.941, 23.742,
         25.194, 25.567, 25.802, 25.86, 26.509, 26.733, 26.807, 26.93, 27.116, 27.161, 27.655, 27.824, 28.001, 28.433,
         28.517, 28.305, 27.854, 27.22, 26.748, 26.689, 26.629, 26.569, 26.508, 26.447, 26.385, 26.322, 26.308, 27.935,
         27.919, 27.859, 27.797, 27.736, 27.674, 27.611, 27.548, 27.485, 27.421, 27.357, 27.292, 27.227, 27.162, 27.096,
         27.03, 26.964, 26.897, 26.83, 26.763, 26.696, 26.628, 26.56, 26.492, 26.423, 26.354, 26.285, 26.216, 26.146,
         26.076, 26.006, 25.936, 25.865, 25.843, 26.181, 26.173, 26.104, 26.035, 25.965, 25.896, 25.826, 25.756, 25.685,
         25.615, 25.545, 25.474, 25.403, 25.333, 25.262, 25.19, 25.119, 25.048, 24.977, 24.905, 24.833, 24.762, 24.69,
         24.618, 24.546, 24.474, 24.402, 24.33, 24.257, 24.185, 24.113, 24.04, 23.968, 23.895, 23.823, 23.797, 24.286,
         24.214, 24.142, 24.07, 23.998, 23.926, 23.855, 23.783, 23.711, 23.639, 23.567, 23.495, 23.423, 23.351, 23.279,
         23.207, 23.135, 23.063, 22.991, 22.919, 22.847, 22.775, 22.703, 22.631, 22.559, 22.487, 22.415, 22.343, 22.271,
         22.199, 22.128, 22.056, 21.984, 21.912, 21.84, 21.769, 21.697, 21.625, 21.554, 21.482, 21.409, 21.337, 21.265,
         21.192, 21.12, 21.048, 20.976, 20.904, 20.832, 20.76, 20.688, 20.616, 20.544, 20.472, 20.401, 20.329, 20.258,
         20.186, 20.115, 20.044, 19.973, 19.901, 19.83, 19.76, 19.689, 19.617, 19.523, 19.429, 19.335, 19.242, 19.149,
         19.056, 18.963, 18.871, 18.779, 18.687, 18.596, 18.505, 18.414, 18.324, 18.234, 18.145, 18.056, 17.968, 17.88,
         17.792, 17.705, 17.619, 17.532, 17.447, 17.361, 17.276, 17.192, 17.108, 17.024, 16.941, 16.858, 16.776, 16.694,
         16.613, 16.532, 16.451, 16.371, 16.292, 16.213, 16.134, 16.055, 15.976, 15.898, 15.821, 15.744, 15.66, 15.574,
         15.489, 15.405, 15.321, 15.238, 15.155, 15.073, 14.992, 14.91, 14.83, 14.745, 14.659, 14.567, 14.476, 14.386,
         14.296, 14.208, 14.12, 14.032, 13.946, 13.858, 13.768, 13.679, 13.59, 13.502, 13.415, 13.328, 13.243, 13.158,
         13.074, 12.99, 12.908, 12.826, 12.744, 12.664, 12.584, 12.505, 12.426, 12.348, 12.271, 12.194, 12.119, 12.043,
         11.969, 11.895, 11.821, 11.749, 11.677, 11.605, 11.534, 11.464, 11.394, 11.325, 11.256, 11.188, 11.121, 11.054,
         10.988, 10.922, 10.857, 10.792, 10.728, 10.665, 10.602, 10.539, 10.477, 10.415, 10.354, 10.294, 10.234, 10.174,
         10.115, 10.057, 9.9984, 9.9408, 9.8836, 9.8269, 9.7706, 9.7148, 9.6594, 9.6045, 9.55, 9.496, 9.4424, 9.3891,
         9.3363, 9.2839, 9.2319, 9.1803, 9.1291, 9.0783, 9.0279, 8.9779, 8.9283, 8.8791, 8.8303, 8.7819, 8.7338, 8.6861,
         8.6388, 8.5908, 8.5423, 8.4942, 8.4464, 8.4116, 25.721, 25.691, 25.509, 25.328, 25.148, 24.97, 24.793, 24.618,
         24.444, 24.415, 35.85, 35.668, 35.41, 35.154, 34.9, 34.648, 34.398, 34.149, 33.903, 33.659, 33.416, 33.176,
         32.937, 32.7, 32.465, 32.231, 32.0, 31.77, 31.542, 31.316, 31.091, 30.868, 30.646, 30.425, 30.206, 29.989,
         29.774, 29.56, 29.348, 29.137, 28.928, 28.721, 28.515, 28.311, 28.108, 27.907, 27.708, 27.541, 27.51, 32.133,
         31.952, 31.724, 31.497, 31.272, 31.049, 30.827, 30.607, 30.389, 30.167, 29.949, 29.741, 29.537, 29.334, 29.134,
         28.936, 28.74, 28.541, 28.344, 28.148, 27.954, 27.761, 27.571, 27.381, 27.193, 27.007, 26.803, 26.653, 26.595,
         28.305, 28.149, 27.929, 27.711, 27.494, 27.279, 27.065, 26.853, 26.642, 26.433, 26.228, 26.029, 25.831, 25.636,
         25.442, 25.25, 25.06, 24.928, 24.871, 25.873, 25.784, 25.597, 25.411, 25.227, 25.045, 24.865, 24.686, 24.509,
         24.332, 24.155, 23.981, 23.807, 23.636, 23.466, 23.297, 23.13, 22.965, 22.801, 22.638, 22.477, 22.318, 22.159,
         22.002, 21.847, 21.693, 21.54, 21.388, 21.238, 21.089, 20.941, 20.795, 20.649, 20.505, 20.362, 20.221, 20.079,
         19.936, 19.795, 19.655, 19.516, 19.378, 19.241, 19.105, 18.97, 18.836, 18.704, 18.572, 18.441, 18.312, 18.183,
         18.053, 17.919, 17.785, 17.651, 17.519, 17.388, 17.258, 17.129, 16.997, 16.866, 16.735, 16.606, 16.477, 16.35,
         16.224, 16.099, 15.975, 15.853, 15.731, 15.61, 15.491, 15.373, 15.255, 15.139, 15.023, 14.909, 14.796, 14.684,
         14.572, 14.462, 14.353, 14.244, 14.137, 14.03, 13.925, 13.82, 13.716, 13.614, 13.512, 13.411, 13.311, 13.211,
         13.113, 13.016, 12.919, 12.819, 12.72, 12.622, 12.525, 12.429, 12.334, 12.239, 12.145, 12.053, 11.96, 11.869,
         11.779, 11.689, 11.6, 11.512, 11.425, 11.339, 11.253, 11.168, 11.084, 11.0, 10.917, 10.834, 10.752, 10.67,
         10.59, 10.51, 10.429, 10.349, 10.27, 10.191, 10.113, 10.036, 9.9587, 9.8823, 9.8066, 9.7316, 9.6573, 9.5836,
         9.5105, 9.4381, 9.3664, 9.2952, 9.2247, 9.1543, 9.0845, 9.0153, 8.9467, 8.8786, 8.8112, 8.7444, 8.6782, 8.6125,
         8.5474, 8.4829, 8.4189, 8.3555, 8.2926, 8.2303, 8.1686, 8.1073, 8.0466, 7.9864, 7.9268, 7.8676, 7.809, 7.7509,
         7.6933, 7.6361, 7.5795, 7.5233, 7.4677, 7.4125, 7.3577, 7.3035, 7.2497, 7.1964, 7.1435, 7.0911, 7.0391, 6.9875,
         6.9364, 6.8858, 6.8355, 6.7857, 6.7363, 6.6873, 6.6388, 6.5906, 6.5429, 6.4955, 6.4486, 6.4021, 6.3559, 6.3101,
         6.2647, 5.7619, 5.1487, 4.5951, 4.1092, 3.9307, 3.8327, 3.8063, 10.039, 9.786, 9.7837, 8.7112, 8.2482, 8.0311,
         7.9745, 11.061, 10.866, 10.781, 10.693, 10.415, 10.343, 11.865, 11.594, 11.283, 10.156, 9.1308, 8.2076, 7.3678,
         6.614, 5.9398, 5.3372, 4.7908, 4.3029, 3.8346, 3.4044, 3.0249, 2.6899, 2.394, 2.1323, 1.9008, 1.6959, 1.514,
         1.3516, 1.2057, 1.0758, 0.95706, 0.85033, 0.75579, 0.67191, 0.66514, 0.64764, 0.6431, 3.1616, 3.0867, 2.9959,
         2.7112, 2.4374, 2.1733, 1.9395, 1.7348, 1.5519, 1.3884, 1.2424, 1.1118, 0.99455, 0.88804, 0.79302, 0.70825,
         0.6326, 0.56508, 0.50482, 0.45103, 0.403, 0.36012, 0.32183, 0.28763, 0.25855, 0.2332, 0.21035, 0.18975]],
    'Au':                                                                                                         [
        [0.00665451, 0.006756365, 0.006783526, 0.006824268, 0.006926123, 0.008142217, 0.008266843, 0.008300076,
         0.008349926, 0.008474552, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306,
         0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327,
         0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.052626,
         0.05302035, 0.0534315, 0.0536463, 0.0539685, 0.054774, 0.05667876, 0.06058959, 0.06477028, 0.06923942,
         0.070266, 0.0713415, 0.0716283, 0.0720585, 0.073134, 0.07401695, 0.07912411, 0.081144, 0.082386, 0.0827172,
         0.083214, 0.084456, 0.08458368, 0.084672, 0.085968, 0.0863136, 0.086832, 0.088128, 0.09041995, 0.09665893,
         0.1033284, 0.105644, 0.107261, 0.1076922, 0.108339, 0.109956, 0.1104581, 0.1180797, 0.1262272, 0.1349368,
         0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708,
         0.2811158, 0.3005128, 0.3212482, 0.327222, 0.3322305, 0.3335661, 0.3355695, 0.340578, 0.3434143, 0.34496,
         0.35024, 0.351648, 0.35376, 0.35904, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5, 0.5025,
         0.5050125, 0.50753756, 0.51007525, 0.51262563, 0.51518875, 0.5177647, 0.52035352, 0.52295529, 0.52557007,
         0.52819792, 0.53083891, 0.5334931, 0.53616057, 0.53884137, 0.54153558, 0.54424325, 0.54469646, 0.54610359,
         0.54696447, 0.54969929, 0.55244779, 0.55521003, 0.55798608, 0.56077601, 0.56357989, 0.56639779, 0.56922978,
         0.57207593, 0.5749363, 0.57781099, 0.58070004, 0.58360354, 0.58652156, 0.58945417, 0.59240144, 0.59536345,
         0.59834026, 0.60133196, 0.60433862, 0.60736032, 0.61039712, 0.6134491, 0.61651635, 0.61959893, 0.62269693,
         0.62581041, 0.62893946, 0.63208416, 0.63524458, 0.6384208, 0.64161291, 0.64278595, 0.64461406, 0.64482097,
         0.64804508, 0.6512853, 0.65454173, 0.65781444, 0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508,
         0.6777972, 0.68118619, 0.68459212, 0.68801508, 0.69145515, 0.69491243, 0.69838699, 0.70187893, 0.70538832,
         0.70891526, 0.71245984, 0.71602214, 0.71960225, 0.72320026, 0.72681626, 0.73045034, 0.7341026, 0.73777311,
         0.74146197, 0.74516928, 0.74889513, 0.75263961, 0.7564028, 0.75759354, 0.76000652, 0.76018482, 0.76398574,
         0.76780567, 0.7716447, 0.77550292, 0.77938044, 0.78327734, 0.78719373, 0.79112969, 0.79508534, 0.79906077,
         0.80305607, 0.80707135, 0.81110671, 0.81516224, 0.81923806, 0.82333425, 0.82745092, 0.83158817, 0.83574611,
         0.83992484, 0.84412447, 0.84834509, 0.85258682, 0.85684975, 0.861134, 0.86543967, 0.86976687, 0.8741157,
         0.87848628, 0.88287871, 0.8872931, 0.89172957, 0.89618822, 0.90066916, 0.9051725, 0.90969837, 0.91424686,
         0.91881809, 0.92341218, 0.92802924, 0.93266939, 0.93733274, 0.9420194, 0.9467295, 0.95146315, 0.95622046,
         0.96100156, 0.96580657, 0.9706356, 0.97548878, 0.98036623, 0.98526806, 0.9901944, 0.99514537, 1.0001211,
         1.0051217, 1.0101473, 1.015198, 1.020274, 1.0253754, 1.0305023, 1.0356548, 1.0408331, 1.0460372, 1.0512674,
         1.0565238, 1.0618064, 1.0671154, 1.072451, 1.0778132, 1.0832023, 1.0886183, 1.0940614, 1.0995317, 1.1050294,
         1.1105545, 1.1161073, 1.1216878, 1.1272963, 1.1329328, 1.1385974, 1.1442904, 1.1500119, 1.1557619, 1.1615407,
         1.1673484, 1.1731852, 1.1790511, 1.1849464, 1.1908711, 1.1968254, 1.2028096, 1.2088236, 1.2148677, 1.2209421,
         1.2270468, 1.233182, 1.2393479, 1.2455447, 1.2517724, 1.2580312, 1.2643214, 1.270643, 1.2769962, 1.2833812,
         1.2897981, 1.2962471, 1.3027283, 1.309242, 1.3157882, 1.3223671, 1.328979, 1.3356239, 1.342302, 1.3490135,
         1.3557586, 1.3625374, 1.36935, 1.3761968, 1.3830778, 1.3899932, 1.3969431, 1.4039278, 1.4109475, 1.4180022,
         1.4250922, 1.4322177, 1.4393788, 1.4465757, 1.4538086, 1.4610776, 1.468383, 1.4757249, 1.4831035, 1.490519,
         1.4979716, 1.5054615, 1.5129888, 1.5205537, 1.5281565, 1.5357973, 1.5434763, 1.5511937, 1.5589496, 1.5667444,
         1.5745781, 1.582451, 1.5903633, 1.5983151, 1.6063066, 1.6143382, 1.6224099, 1.6305219, 1.6386745, 1.6468679,
         1.6551022, 1.6633777, 1.6716946, 1.6800531, 1.6884534, 1.6968956, 1.7053801, 1.713907, 1.7224766, 1.7310889,
         1.7397444, 1.7484431, 1.7571853, 1.7659712, 1.7748011, 1.7836751, 1.7925935, 1.8015565, 1.8105642, 1.8196171,
         1.8287151, 1.8378587, 1.847048, 1.8562833, 1.8655647, 1.8748925, 1.884267, 1.8936883, 1.9031567, 1.9126725,
         1.9222359, 1.9318471, 1.9415063, 1.9512138, 1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868,
         2.0205393, 2.030642, 2.0407952, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278, 2.1027895, 2.1133034,
         2.1238699, 2.1344893, 2.1451617, 2.1558875, 2.166667, 2.1775003, 2.1883878, 2.1993297, 2.2051132, 2.2062866,
         2.2103264, 2.221378, 2.2324849, 2.2436473, 2.2548656, 2.2661399, 2.2774706, 2.2888579, 2.2904585, 2.2917415,
         2.3003022, 2.3118037, 2.3233628, 2.3349796, 2.3466545, 2.3583878, 2.3701797, 2.3820306, 2.3939407, 2.4059104,
         2.41794, 2.4300297, 2.4421798, 2.4543907, 2.4666627, 2.478996, 2.491391, 2.5038479, 2.5163672, 2.528949,
         2.5415938, 2.5543017, 2.5670732, 2.5799086, 2.5928082, 2.6057722, 2.6188011, 2.6318951, 2.6450545, 2.6582798,
         2.6715712, 2.6849291, 2.6983537, 2.7118455, 2.7254047, 2.7390317, 2.7404353, 2.7455647, 2.7527269, 2.7664905,
         2.780323, 2.7942246, 2.8081957, 2.8222367, 2.8363479, 2.8505296, 2.8647823, 2.8791062, 2.8935017, 2.9079692,
         2.9225091, 2.9371216, 2.9518072, 2.9665662, 2.9813991, 2.9963061, 3.0112876, 3.026344, 3.0414758, 3.0566831,
         3.0719666, 3.0873264, 3.102763, 3.1182768, 3.1338682, 3.1431727, 3.1495376, 3.1524272, 3.1652853, 3.1811117,
         3.1970172, 3.2130023, 3.2290673, 3.2452127, 3.2614387, 3.2777459, 3.2941347, 3.3106053, 3.3271584, 3.3437941,
         3.3605131, 3.3773157, 3.3942023, 3.4111733, 3.417742, 3.4282291, 3.4320581, 3.4453703, 3.4625971, 3.4799101,
         3.4973097, 3.5147962, 3.5323702, 3.5500321, 3.5677822, 3.5856211, 3.6035492, 3.621567, 3.6396748, 3.6578732,
         3.6761626, 3.6945434, 3.7130161, 3.7315812, 3.7502391, 3.7689903, 3.7878352, 3.8067744, 3.8258083, 3.8449373,
         3.864162, 3.8834828, 3.9029002, 3.9224147, 3.9420268, 3.9617369, 3.9815456, 4.0014533, 4.0214606, 4.0415679,
         4.0617757, 4.0820846, 4.102495, 4.1230075, 4.1436226, 4.1643407, 4.1851624, 4.2060882, 4.2271186, 4.2482542,
         4.2694955, 4.290843, 4.3122972, 4.3338587, 4.355528, 4.3773056, 4.3991921, 4.4211881, 4.443294, 4.4655105,
         4.4878381, 4.5102772, 4.5328286, 4.5554928, 4.5782702, 4.6011616, 4.6241674, 4.6472882, 4.6705247, 4.6938773,
         4.7173467, 4.7409334, 4.7646381, 4.7884613, 4.8124036, 4.8364656, 4.8606479, 4.8849512, 4.9093759, 4.9339228,
         4.9585924, 4.9833854, 5.0083023, 5.0333438, 5.0585105, 5.0838031, 5.1092221, 5.1347682, 5.1604421, 5.1862443,
         5.2121755, 5.2382364, 5.2644276, 5.2907497, 5.3172034, 5.3437895, 5.3705084, 5.3973609, 5.4243477, 5.4514695,
         5.4787268, 5.5061205, 5.5336511, 5.5613193, 5.5891259, 5.6170716, 5.6451569, 5.6733827, 5.7017496, 5.7302584,
         5.7589096, 5.7877042, 5.8166427, 5.8457259, 5.8749546, 5.9043293, 5.933851, 5.9635202, 5.9933378, 6.0233045,
         6.053421, 6.0836882, 6.1141066, 6.1446771, 6.1754005, 6.2062775, 6.2373089, 6.2684954, 6.2998379, 6.3313371,
         6.3629938, 6.3948088, 6.4267828, 6.4589167, 6.4912113, 6.5236674, 6.5562857, 6.5890671, 6.6220125, 6.6551225,
         6.6883981, 6.7218401, 6.7554493, 6.7892266, 6.8231727, 6.8572886, 6.891575, 6.9260329, 6.9606631, 6.9954664,
         7.0304437, 7.0655959, 7.1009239, 7.1364285, 7.1721107, 7.2079712, 7.2440111, 7.2802311, 7.3166323, 7.3532155,
         7.3899815, 7.4269314, 7.4640661, 7.5013864, 7.5388934, 7.5765878, 7.6144708, 7.6525431, 7.6908058, 7.7292599,
         7.7679062, 7.8067457, 7.8457794, 7.8850083, 7.9244334, 7.9640555, 8.0038758, 8.0438952, 8.0841147, 8.1245352,
         8.1651579, 8.2059837, 8.2470136, 8.2882487, 8.3296899, 8.3713384, 8.4131951, 8.455261, 8.4975373, 8.540025,
         9.030794, 9.653919, 10.32004, 11.03212, 11.68033, 11.79334, 11.85911, 11.90678, 11.97829, 12.15707, 12.60708,
         13.45893, 13.47697, 13.66493, 13.71987, 13.80227, 14.00827, 14.06574, 14.28104, 14.33845, 14.40688, 14.42456,
         14.63986, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676,
         30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927,
         62.5287, 66.84318, 71.45536, 76.38578, 79.1104, 80.32127, 80.64417, 81.12852, 81.6564, 82.3394, 87.29069,
         93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539,
         194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588,
         405.0001, 432.9451],
        [2.88762, 2.24634, 1.53627, 2.22782, 2.79003, 2.53588, 2.0654, 1.54542, 2.05749, 2.46605, 1.80913, 1.37655,
         0.965328, 0.624303, 0.411793, 0.394079, 0.639962, 1.21194, 2.15504, 3.48533, 5.2549, 7.25321, 9.45427, 11.7727,
         13.9985, 16.0474, 17.8149, 19.2362, 20.284, 20.9586, 21.2841, 21.2906, 20.9863, 20.2798, 18.6073, 18.0425,
         16.8898, 14.8645, 16.9775, 18.7833, 20.0123, 20.6579, 20.5746, 19.8937, 19.541, 18.6908, 17.7435, 18.6642,
         19.4156, 19.6412, 19.8939, 19.7664, 19.4939, 19.1793, 19.4857, 19.7029, 19.7089, 19.712, 19.6317, 19.4433,
         19.6712, 19.8761, 19.9742, 19.8306, 19.4054, 19.2152, 19.0492, 18.9666, 18.9635, 18.8743, 18.8392, 18.219,
         17.4805, 16.655, 15.7662, 14.8392, 13.92, 13.0583, 12.332, 11.8252, 11.6285, 11.8101, 12.4275, 13.5101,
         15.0151, 16.8766, 18.9208, 19.4424, 19.7143, 19.5627, 20.0379, 20.7741, 21.1074, 21.276, 21.7325, 21.684,
         22.137, 22.9277, 23.9458, 26.8316, 29.5822, 32.1468, 34.4526, 36.8596, 36.9982, 37.1334, 37.265, 37.3927,
         37.516, 37.6344, 37.7473, 37.8538, 37.9528, 38.0427, 38.1212, 38.185, 38.2285, 38.2419, 38.2052, 38.0654,
         37.5543, 37.3074, 37.3821, 37.8633, 38.5583, 38.9711, 39.2936, 39.5706, 39.8197, 40.0498, 40.2659, 40.4711,
         40.6676, 40.8568, 41.0397, 41.2172, 41.3899, 41.5581, 41.7223, 41.8828, 42.0397, 42.1933, 42.3436, 42.4907,
         42.6347, 42.7755, 42.913, 43.0471, 43.1775, 43.3038, 43.4254, 43.5413, 43.6495, 43.7464, 43.8227, 43.8414,
         43.7886, 43.8618, 43.8949, 44.1878, 44.3826, 44.5518, 44.7084, 44.8569, 44.9998, 45.1382, 45.2729, 45.4044,
         45.5331, 45.6593, 45.783, 45.9045, 46.0238, 46.1409, 46.2559, 46.3689, 46.4797, 46.5884, 46.6948, 46.799,
         46.9006, 46.9995, 47.0954, 47.1878, 47.2762, 47.3596, 47.4364, 47.504, 47.5571, 47.5825, 47.5268, 47.4426,
         47.5088, 47.5372, 47.8657, 48.0626, 48.2251, 48.3711, 48.5071, 48.6363, 48.7605, 48.8808, 48.9978, 49.1121,
         49.2241, 49.3341, 49.4422, 49.5487, 49.6537, 49.7573, 49.8596, 49.9607, 50.0607, 50.1597, 50.2577, 50.3547,
         50.4508, 50.5461, 50.6405, 50.7342, 50.8271, 50.9193, 51.0108, 51.1017, 51.1919, 51.2816, 51.3708, 51.4595,
         51.5477, 51.6355, 51.723, 51.8101, 51.897, 51.9834, 52.0696, 52.1555, 52.2412, 52.3267, 52.4122, 52.4977,
         52.5833, 52.6691, 52.7551, 52.8415, 52.9284, 53.016, 53.1045, 53.1943, 53.2862, 53.3772, 53.4425, 53.5046,
         53.5648, 53.6233, 53.6804, 53.7361, 53.7905, 53.8437, 53.8957, 53.9595, 54.0092, 54.0578, 54.1054, 54.1518,
         54.1973, 54.2417, 54.285, 54.3271, 54.3681, 54.408, 54.4468, 54.4846, 54.5214, 54.5571, 54.5918, 54.6255,
         54.6582, 54.6899, 54.7207, 54.7505, 54.7793, 54.8073, 54.8343, 54.8604, 54.8856, 54.91, 54.9334, 54.956,
         54.9777, 54.9986, 55.0186, 55.0378, 55.0562, 55.0738, 55.0906, 55.1066, 55.1219, 55.1364, 55.1502, 55.1631,
         55.1753, 55.1866, 55.1972, 55.207, 55.2161, 55.2245, 55.2322, 55.2388, 55.244, 55.2479, 55.2505, 55.2518,
         55.2518, 55.2505, 55.248, 55.2443, 55.2394, 55.2333, 55.2256, 55.2163, 55.2055, 55.193, 55.179, 55.1634,
         55.1463, 55.1277, 55.1075, 55.0857, 55.0624, 55.0376, 55.0112, 54.9832, 54.9537, 54.9226, 54.8898, 54.8555,
         54.8194, 54.7818, 54.7424, 54.701, 54.6577, 54.6123, 54.5649, 54.5154, 54.4639, 54.4102, 54.3544, 54.304,
         54.2434, 54.1804, 54.1148, 54.0467, 53.9759, 53.9024, 53.8261, 53.747, 53.665, 53.5799, 53.4918, 53.4004,
         53.3057, 53.2076, 53.106, 53.0006, 52.8914, 52.7782, 52.6608, 52.5391, 52.4128, 52.2817, 52.1456, 52.0043,
         51.8574, 51.7047, 51.5457, 51.3803, 51.2079, 51.0281, 50.8404, 50.6444, 50.4395, 50.2249, 49.9998, 49.7636,
         49.5152, 49.2537, 48.9778, 48.6861, 48.377, 48.0488, 47.6993, 47.3259, 46.9257, 46.495, 46.0294, 45.5233,
         44.97, 44.3604, 43.6829, 42.9216, 42.0539, 41.0468, 39.8476, 38.3658, 36.4219, 33.5677, 27.8928, 14.718,
         14.4147, 25.6735, 32.0631, 34.5666, 35.8899, 36.5015, 36.4465, 35.3612, 29.7952, 25.3813, 25.2987, 35.6491,
         39.3788, 41.6868, 43.4321, 44.8607, 46.0806, 47.1495, 48.1028, 48.9635, 49.748, 50.468, 51.1326, 51.7487,
         52.3217, 52.8561, 53.3553, 53.8222, 54.2592, 54.6683, 55.0508, 55.4079, 55.7405, 56.049, 56.3336, 56.5938,
         56.829, 57.0376, 57.2174, 57.365, 57.4747, 57.538, 57.5399, 57.4535, 57.221, 56.6801, 54.8263, 54.232, 54.2566,
         56.2907, 57.7964, 58.6963, 59.3792, 59.9469, 60.4418, 60.8855, 61.2908, 61.6661, 62.0157, 62.3422, 62.6487,
         62.9375, 63.2102, 63.4683, 63.7128, 63.9446, 64.163, 64.3822, 64.5811, 64.7577, 64.9116, 65.0396, 65.1351,
         65.1847, 65.1563, 64.9396, 64.4455, 63.9561, 64.535, 65.4239, 65.9569, 66.3394, 66.6525, 66.9232, 67.1635,
         67.3798, 67.5756, 67.7524, 67.9105, 68.0521, 68.1757, 68.2767, 68.3466, 68.3634, 68.248, 68.0844, 67.9097,
         68.2092, 68.6908, 69.05, 69.3243, 69.5588, 69.7692, 69.963, 70.1445, 70.3163, 70.4792, 70.6344, 70.7828,
         70.9251, 71.0619, 71.1939, 71.3213, 71.4445, 71.5639, 71.6797, 71.7921, 71.9013, 72.0075, 72.1108, 72.2114,
         72.3095, 72.4051, 72.4984, 72.5895, 72.6785, 72.7655, 72.8506, 72.9338, 73.0154, 73.0954, 73.174, 73.2512,
         73.3271, 73.401, 73.473, 73.5433, 73.612, 73.6791, 73.7447, 73.809, 73.8719, 73.9335, 73.9939, 74.0532,
         74.1114, 74.1685, 74.2247, 74.4747, 74.5292, 74.582, 74.633, 74.6823, 74.7301, 74.7765, 74.8214, 74.9982,
         75.0404, 75.0809, 75.1197, 75.157, 75.1929, 75.2273, 75.2604, 75.2922, 75.3228, 75.3522, 75.3804, 75.4076,
         75.4337, 75.4588, 75.483, 75.5061, 75.5284, 75.5498, 75.5703, 75.59, 75.609, 75.6271, 75.6445, 75.6612,
         75.6772, 75.6925, 75.7071, 75.7212, 75.7346, 75.7475, 75.7598, 75.7716, 75.7828, 75.7936, 75.804, 75.9134,
         75.9232, 75.9322, 75.9404, 75.9478, 75.9546, 75.9606, 75.966, 75.9708, 75.975, 75.9785, 75.9816, 75.9841,
         75.986, 75.9875, 75.9884, 75.989, 75.989, 75.9886, 75.9878, 75.9865, 75.9849, 75.9829, 75.9805, 75.9777,
         75.9746, 75.9712, 76.0088, 76.0049, 76.0006, 75.9959, 75.9906, 75.9849, 75.9788, 75.9722, 75.9653, 75.9579,
         75.9502, 75.9421, 75.9337, 75.9248, 75.9156, 75.9061, 75.8961, 75.9023, 75.8919, 75.881, 75.8698, 75.8583,
         75.8463, 75.834, 75.8214, 75.8084, 75.7951, 75.7815, 75.7676, 75.7533, 75.7387, 75.7238, 75.7086, 75.6931,
         75.6773, 75.6611, 75.6447, 75.628, 75.611, 75.5937, 75.5761, 75.5582, 75.54, 75.5215, 75.5028, 75.4837,
         75.4644, 75.4447, 75.4248, 75.4046, 75.3841, 75.3633, 75.3422, 75.3208, 75.2992, 75.2772, 75.255, 75.2325,
         75.2097, 75.1867, 75.1634, 75.1399, 74.9382, 74.4523, 73.7229, 72.5078, 69.8967, 68.6327, 67.1655, 63.9647,
         67.1528, 69.9622, 71.8985, 72.0537, 72.0042, 70.849, 69.2676, 70.9132, 72.3549, 72.522, 72.5469, 71.8746,
         72.7129, 72.902, 74.0777, 75.8488, 77.0993, 77.8742, 78.3937, 78.7403, 78.9707, 79.1216, 79.2758, 79.3291,
         79.4002, 79.4096, 79.3581, 79.2868, 79.203, 79.1108, 79.0127, 78.91, 78.803, 78.6909, 78.5707, 78.4367,
         78.2813, 78.0842, 77.8014, 77.2704, 76.5488, 75.4855, 74.2123, 75.5407, 76.237, 76.7032, 77.9164, 78.4584,
         78.7653, 78.9609, 79.0922, 79.181, 79.2389, 79.2755, 79.2969, 79.3074, 79.3102, 79.3069, 79.299, 79.288,
         79.275, 79.2607, 79.2457, 79.2304, 79.2152, 79.2002, 79.1857, 79.1718, 79.1585, 79.1459, 79.134],
        [0.0, 0.0, 0.0, 1.3641, 1.3448, 1.2374, 1.2519, 1.2564, 2.2605, 2.2498, 2.9953, 3.6048, 4.406, 5.4098, 6.6185,
         8.0179, 9.5717, 11.217, 12.867, 14.413, 15.74, 16.739, 17.327, 17.457, 17.13, 16.382, 15.29, 13.958, 12.491,
         10.985, 9.5236, 8.1647, 6.9419, 5.8697, 5.044, 4.9482, 4.8509, 4.8011, 8.693, 8.3716, 7.675, 6.4803, 5.468,
         4.6215, 4.4554, 4.2912, 4.249, 6.0093, 5.8445, 5.7157, 5.0728, 4.8498, 4.7156, 4.6802, 5.2303, 5.0814, 5.0663,
         5.0559, 4.9054, 4.866, 5.2064, 5.0542, 4.7971, 4.2015, 3.7598, 3.6471, 3.5794, 3.5628, 3.6344, 3.5821, 3.5674,
         3.4351, 3.4634, 3.6848, 4.1139, 4.7809, 5.7275, 6.9748, 8.5341, 10.395, 12.519, 14.836, 17.247, 19.637, 21.884,
         23.873, 25.508, 25.888, 26.177, 26.249, 26.917, 27.197, 27.345, 27.421, 27.665, 27.726, 28.234, 28.458, 28.755,
         29.359, 29.557, 29.402, 28.958, 28.559, 28.506, 28.452, 28.398, 28.342, 28.286, 28.228, 28.17, 28.111, 28.051,
         27.99, 27.928, 27.866, 27.802, 27.738, 27.673, 27.608, 27.542, 27.531, 29.209, 29.188, 29.123, 29.058, 28.991,
         28.924, 28.856, 28.788, 28.72, 28.65, 28.581, 28.51, 28.439, 28.368, 28.296, 28.224, 28.152, 28.079, 28.005,
         27.931, 27.857, 27.783, 27.708, 27.632, 27.557, 27.481, 27.404, 27.328, 27.251, 27.174, 27.096, 27.018, 26.94,
         26.862, 26.833, 27.171, 27.166, 27.089, 27.012, 26.934, 26.857, 26.779, 26.701, 26.623, 26.545, 26.466, 26.388,
         26.309, 26.23, 26.151, 26.072, 25.993, 25.914, 25.834, 25.755, 25.675, 25.596, 25.516, 25.436, 25.356, 25.276,
         25.197, 25.117, 25.036, 24.956, 24.876, 24.796, 24.716, 24.636, 24.611, 25.095, 25.092, 25.012, 24.933, 24.854,
         24.775, 24.695, 24.616, 24.537, 24.458, 24.379, 24.3, 24.221, 24.141, 24.063, 23.984, 23.905, 23.826, 23.747,
         23.668, 23.59, 23.511, 23.433, 23.354, 23.276, 23.197, 23.119, 23.041, 22.963, 22.884, 22.806, 22.728, 22.651,
         22.573, 22.495, 22.417, 22.34, 22.262, 22.185, 22.108, 22.031, 21.953, 21.875, 21.797, 21.72, 21.643, 21.565,
         21.488, 21.411, 21.334, 21.257, 21.181, 21.104, 21.028, 20.952, 20.876, 20.799, 20.696, 20.593, 20.49, 20.388,
         20.286, 20.185, 20.084, 19.984, 19.884, 19.785, 19.686, 19.587, 19.49, 19.392, 19.296, 19.199, 19.103, 19.007,
         18.911, 18.816, 18.721, 18.627, 18.533, 18.44, 18.347, 18.255, 18.163, 18.071, 17.981, 17.89, 17.8, 17.711,
         17.622, 17.533, 17.446, 17.358, 17.271, 17.185, 17.099, 17.013, 16.928, 16.844, 16.759, 16.676, 16.593, 16.51,
         16.428, 16.347, 16.265, 16.185, 16.104, 16.024, 15.944, 15.865, 15.786, 15.707, 15.629, 15.552, 15.466, 15.381,
         15.296, 15.212, 15.128, 15.045, 14.963, 14.881, 14.799, 14.719, 14.636, 14.551, 14.466, 14.382, 14.298, 14.215,
         14.133, 14.051, 13.97, 13.889, 13.809, 13.73, 13.651, 13.573, 13.495, 13.418, 13.341, 13.265, 13.189, 13.114,
         13.037, 12.957, 12.878, 12.8, 12.722, 12.645, 12.569, 12.493, 12.418, 12.34, 12.262, 12.184, 12.108, 12.032,
         11.957, 11.882, 11.808, 11.735, 11.662, 11.59, 11.518, 11.447, 11.377, 11.307, 11.238, 11.17, 11.102, 11.035,
         10.968, 10.902, 10.836, 10.771, 10.706, 10.642, 10.579, 10.516, 10.453, 10.391, 10.33, 10.269, 10.209, 10.149,
         10.089, 10.03, 9.9719, 9.914, 9.8565, 9.7994, 9.7429, 9.6868, 9.6311, 9.5759, 9.5212, 9.4668, 9.4129, 9.3594,
         9.3063, 9.2537, 9.2015, 9.1496, 9.0983, 9.0473, 8.9967, 8.9465, 8.8967, 8.8473, 8.7983, 8.7497, 8.7003, 8.6506,
         8.6246, 25.848, 25.78, 25.595, 25.411, 25.228, 25.047, 24.867, 24.689, 24.512, 24.487, 35.886, 35.689, 35.427,
         35.168, 34.91, 34.654, 34.4, 34.148, 33.898, 33.65, 33.405, 33.16, 32.918, 32.678, 32.44, 32.203, 31.968,
         31.736, 31.504, 31.275, 31.048, 30.822, 30.598, 30.376, 30.155, 29.935, 29.717, 29.501, 29.286, 29.073, 28.862,
         28.652, 28.444, 28.238, 28.033, 27.83, 27.628, 27.607, 32.004, 31.894, 31.684, 31.476, 31.27, 31.064, 30.861,
         30.659, 30.458, 30.259, 30.055, 29.851, 29.649, 29.448, 29.249, 29.051, 28.854, 28.658, 28.46, 28.244, 28.023,
         27.805, 27.587, 27.372, 27.158, 26.945, 26.734, 26.525, 26.401, 28.058, 28.018, 27.839, 27.623, 27.408, 27.195,
         26.983, 26.773, 26.565, 26.358, 26.153, 25.953, 25.756, 25.562, 25.369, 25.179, 24.99, 24.802, 24.731, 25.703,
         25.662, 25.518, 25.335, 25.153, 24.973, 24.795, 24.618, 24.443, 24.269, 24.094, 23.92, 23.748, 23.577, 23.407,
         23.239, 23.073, 22.908, 22.744, 22.582, 22.421, 22.262, 22.104, 21.947, 21.792, 21.638, 21.485, 21.333, 21.183,
         21.034, 20.886, 20.74, 20.595, 20.451, 20.308, 20.166, 20.025, 19.884, 19.743, 19.603, 19.464, 19.326, 19.19,
         19.054, 18.919, 18.786, 18.653, 18.522, 18.391, 18.262, 18.133, 18.006, 17.876, 17.742, 17.61, 17.478, 17.347,
         17.218, 17.089, 16.962, 16.831, 16.701, 16.572, 16.444, 16.317, 16.191, 16.067, 15.943, 15.821, 15.7, 15.58,
         15.46, 15.342, 15.225, 15.109, 14.994, 14.881, 14.768, 14.656, 14.545, 14.435, 14.326, 14.218, 14.111, 14.005,
         13.899, 13.795, 13.692, 13.589, 13.488, 13.387, 13.288, 13.189, 13.091, 12.994, 12.897, 12.799, 12.701, 12.603,
         12.507, 12.411, 12.316, 12.222, 12.129, 12.036, 11.945, 11.854, 11.764, 11.675, 11.586, 11.499, 11.412, 11.326,
         11.24, 11.156, 11.072, 10.989, 10.907, 10.825, 10.744, 10.664, 10.584, 10.506, 10.427, 10.347, 10.268, 10.19,
         10.112, 10.035, 9.9592, 9.8836, 9.8088, 9.7346, 9.6608, 9.5874, 9.5146, 9.4424, 9.3709, 9.3, 9.2297, 9.16,
         9.0904, 9.0214, 8.953, 8.8852, 8.8181, 8.7515, 8.6855, 8.62, 8.5551, 8.4908, 8.4271, 8.3639, 8.3012, 8.2391,
         8.1776, 8.1165, 8.056, 7.9961, 7.9366, 7.8776, 7.8192, 7.7613, 7.7038, 7.6469, 7.5904, 7.5344, 7.4789, 7.4239,
         7.3693, 7.3152, 7.2616, 7.2084, 7.1557, 7.1035, 7.0516, 7.0002, 6.9493, 6.8988, 6.8487, 6.799, 6.7498, 6.7009,
         6.6525, 6.6045, 6.0726, 5.4359, 4.8556, 4.3394, 3.948, 3.8861, 3.8509, 3.8253, 10.042, 9.7808, 9.1691, 8.1755,
         8.1564, 7.9615, 7.9054, 10.981, 10.704, 10.629, 10.355, 10.284, 11.821, 11.798, 11.53, 10.657, 9.5849, 8.619,
         7.7427, 6.951, 6.2427, 5.6095, 5.0398, 4.5271, 4.0394, 3.5892, 3.1891, 2.8358, 2.5237, 2.2477, 2.0036, 1.7874,
         1.5957, 1.4256, 1.2719, 1.1355, 1.0126, 0.89999, 0.80018, 0.71163, 0.66924, 0.65138, 0.64651, 3.1459, 3.1142,
         3.074, 2.8038, 2.5207, 2.262, 2.0288, 1.8193, 1.6277, 1.456, 1.3024, 1.1649, 1.0421, 0.93205, 0.83281, 0.74421,
         0.66511, 0.59448, 0.5314, 0.47505, 0.42472, 0.37976, 0.33958, 0.30368, 0.2716, 0.24292, 0.21729, 0.19438]],
    'Hg':                                                                                                         [
        [0.006272, 0.006368, 0.0063936, 0.006432, 0.006528, 0.007559334, 0.007675038, 0.007705893, 0.007752174,
         0.007867878, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382,
         0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002,
         0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.056448,
         0.05667876, 0.057312, 0.0575424, 0.057888, 0.058752, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07889,
         0.07912411, 0.0800975, 0.0804195, 0.0809025, 0.08211, 0.08458368, 0.09041995, 0.09653, 0.09665893, 0.0980075,
         0.0984015, 0.0989925, 0.100156, 0.10047, 0.101689, 0.1020978, 0.102711, 0.1033284, 0.104244, 0.1104581,
         0.117894, 0.1180797, 0.1196985, 0.1201797, 0.1209015, 0.122706, 0.1262272, 0.1349368, 0.1442475, 0.1542005,
         0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128,
         0.3212482, 0.3434143, 0.352604, 0.358001, 0.3594402, 0.361599, 0.3671099, 0.370734, 0.3764085, 0.3779217,
         0.3801915, 0.385866, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5, 0.5025, 0.5050125, 0.50753756,
         0.51007525, 0.51262563, 0.51518875, 0.5177647, 0.52035352, 0.52295529, 0.52557007, 0.52819792, 0.53083891,
         0.5334931, 0.53616057, 0.53884137, 0.54153558, 0.54424325, 0.54696447, 0.54969929, 0.55244779, 0.55521003,
         0.55798608, 0.56077601, 0.56357989, 0.56639779, 0.56922978, 0.57028052, 0.57171944, 0.57207593, 0.5749363,
         0.57781099, 0.58070004, 0.58360354, 0.58652156, 0.58945417, 0.59240144, 0.59536345, 0.59834026, 0.60133196,
         0.60433862, 0.60736032, 0.61039712, 0.6134491, 0.61651635, 0.61959893, 0.62269693, 0.62581041, 0.62893946,
         0.63208416, 0.63524458, 0.6384208, 0.64161291, 0.64482097, 0.64804508, 0.6512853, 0.65454173, 0.65781444,
         0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508, 0.6759456, 0.6777972, 0.67785446, 0.68118619,
         0.68459212, 0.68801508, 0.69145515, 0.69491243, 0.69838699, 0.70187893, 0.70538832, 0.70891526, 0.71245984,
         0.71602214, 0.71960225, 0.72320026, 0.72681626, 0.73045034, 0.7341026, 0.73777311, 0.74146197, 0.74516928,
         0.74889513, 0.75263961, 0.7564028, 0.76018482, 0.76398574, 0.76780567, 0.7716447, 0.77550292, 0.77938044,
         0.78327734, 0.78719373, 0.79112969, 0.79508534, 0.79906077, 0.79906754, 0.80153246, 0.80305607, 0.80707135,
         0.81110671, 0.81516224, 0.81923806, 0.82333425, 0.82745092, 0.83158817, 0.83574611, 0.83992484, 0.84412447,
         0.84834509, 0.85258682, 0.85684975, 0.861134, 0.86543967, 0.86976687, 0.8741157, 0.87848628, 0.88287871,
         0.8872931, 0.89172957, 0.89618822, 0.90066916, 0.9051725, 0.90969837, 0.91424686, 0.91881809, 0.92341218,
         0.92802924, 0.93266939, 0.93733274, 0.9420194, 0.9467295, 0.95146315, 0.95622046, 0.96100156, 0.96580657,
         0.9706356, 0.97548878, 0.98036623, 0.98526806, 0.9901944, 0.99514537, 1.0001211, 1.0051217, 1.0101473,
         1.015198, 1.020274, 1.0253754, 1.0305023, 1.0356548, 1.0408331, 1.0460372, 1.0512674, 1.0565238, 1.0618064,
         1.0671154, 1.072451, 1.0778132, 1.0832023, 1.0886183, 1.0940614, 1.0995317, 1.1050294, 1.1105545, 1.1161073,
         1.1216878, 1.1272963, 1.1329328, 1.1385974, 1.1442904, 1.1500119, 1.1557619, 1.1615407, 1.1673484, 1.1731852,
         1.1790511, 1.1849464, 1.1908711, 1.1968254, 1.2028096, 1.2088236, 1.2148677, 1.2209421, 1.2270468, 1.233182,
         1.2393479, 1.2455447, 1.2517724, 1.2580312, 1.2643214, 1.270643, 1.2769962, 1.2833812, 1.2897981, 1.2962471,
         1.3027283, 1.309242, 1.3157882, 1.3223671, 1.328979, 1.3356239, 1.342302, 1.3490135, 1.3557586, 1.3625374,
         1.36935, 1.3761968, 1.3830778, 1.3899932, 1.3969431, 1.4039278, 1.4109475, 1.4180022, 1.4250922, 1.4322177,
         1.4393788, 1.4465757, 1.4538086, 1.4610776, 1.468383, 1.4757249, 1.4831035, 1.490519, 1.4979716, 1.5054615,
         1.5129888, 1.5205537, 1.5281565, 1.5357973, 1.5434763, 1.5511937, 1.5589496, 1.5667444, 1.5745781, 1.582451,
         1.5903633, 1.5983151, 1.6063066, 1.6143382, 1.6224099, 1.6305219, 1.6386745, 1.6468679, 1.6551022, 1.6633777,
         1.6716946, 1.6800531, 1.6884534, 1.6968956, 1.7053801, 1.713907, 1.7224766, 1.7310889, 1.7397444, 1.7484431,
         1.7571853, 1.7659712, 1.7748011, 1.7836751, 1.7925935, 1.8015565, 1.8105642, 1.8196171, 1.8287151, 1.8378587,
         1.847048, 1.8562833, 1.8655647, 1.8748925, 1.884267, 1.8936883, 1.9031567, 1.9126725, 1.9222359, 1.9318471,
         1.9415063, 1.9512138, 1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868, 2.0205393, 2.030642,
         2.0407952, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278, 2.1027895, 2.1133034, 2.1238699, 2.1344893,
         2.1451617, 2.1558875, 2.166667, 2.1775003, 2.1883878, 2.1993297, 2.2103264, 2.221378, 2.2324849, 2.2436473,
         2.2548656, 2.2661399, 2.2774706, 2.2888579, 2.2942849, 2.295515, 2.3003022, 2.3118037, 2.3233628, 2.3349796,
         2.3466545, 2.3583878, 2.3701797, 2.3820306, 2.3842276, 2.3855726, 2.3939407, 2.4059104, 2.41794, 2.4300297,
         2.4421798, 2.4543907, 2.4666627, 2.478996, 2.491391, 2.5038479, 2.5163672, 2.528949, 2.5415938, 2.5543017,
         2.5670732, 2.5799086, 2.5928082, 2.6057722, 2.6188011, 2.6318951, 2.6450545, 2.6582798, 2.6715712, 2.6849291,
         2.6983537, 2.7118455, 2.7254047, 2.7390317, 2.7527269, 2.7664905, 2.780323, 2.7942246, 2.8081957, 2.8222367,
         2.8363479, 2.8443469, 2.8498532, 2.8505296, 2.8647823, 2.8791062, 2.8935017, 2.9079692, 2.9225091, 2.9371216,
         2.9518072, 2.9665662, 2.9813991, 2.9963061, 3.0112876, 3.026344, 3.0414758, 3.0566831, 3.0719666, 3.0873264,
         3.102763, 3.1182768, 3.1338682, 3.1495376, 3.1652853, 3.1811117, 3.1970172, 3.2130023, 3.2290673, 3.2452127,
         3.2614387, 3.2736807, 3.2777459, 3.2833195, 3.2941347, 3.3106053, 3.3271584, 3.3437941, 3.3605131, 3.3773157,
         3.3942023, 3.4111733, 3.4282291, 3.4453703, 3.4625971, 3.4799101, 3.4973097, 3.5147962, 3.5323702, 3.5500321,
         3.554085, 3.5677822, 3.5691149, 3.5856211, 3.6035492, 3.621567, 3.6396748, 3.6578732, 3.6761626, 3.6945434,
         3.7130161, 3.7315812, 3.7502391, 3.7689903, 3.7878352, 3.8067744, 3.8258083, 3.8449373, 3.864162, 3.8834828,
         3.9029002, 3.9224147, 3.9420268, 3.9617369, 3.9815456, 4.0014533, 4.0214606, 4.0415679, 4.0617757, 4.0820846,
         4.102495, 4.1230075, 4.1436226, 4.1643407, 4.1851624, 4.2060882, 4.2271186, 4.2482542, 4.2694955, 4.290843,
         4.3122972, 4.3338587, 4.355528, 4.3773056, 4.3991921, 4.4211881, 4.443294, 4.4655105, 4.4878381, 4.5102772,
         4.5328286, 4.5554928, 4.5782702, 4.6011616, 4.6241674, 4.6472882, 4.6705247, 4.6938773, 4.7173467, 4.7409334,
         4.7646381, 4.7884613, 4.8124036, 4.8364656, 4.8606479, 4.8849512, 4.9093759, 4.9339228, 4.9585924, 4.9833854,
         5.0083023, 5.0333438, 5.0585105, 5.0838031, 5.1092221, 5.1347682, 5.1604421, 5.1862443, 5.2121755, 5.2382364,
         5.2644276, 5.2907497, 5.3172034, 5.3437895, 5.3705084, 5.3973609, 5.4243477, 5.4514695, 5.4787268, 5.5061205,
         5.5336511, 5.5613193, 5.5891259, 5.6170716, 5.6451569, 5.6733827, 5.7017496, 5.7302584, 5.7589096, 5.7877042,
         5.8166427, 5.8457259, 5.8749546, 5.9043293, 5.933851, 5.9635202, 5.9933378, 6.0233045, 6.053421, 6.0836882,
         6.1141066, 6.1446771, 6.1754005, 6.2062775, 6.2373089, 6.2684954, 6.2998379, 6.3313371, 6.3629938, 6.3948088,
         6.4267828, 6.4589167, 6.4912113, 6.5236674, 6.5562857, 6.5890671, 6.6220125, 6.6551225, 6.6883981, 6.7218401,
         6.7554493, 6.7892266, 6.8231727, 6.8572886, 6.891575, 6.9260329, 6.9606631, 6.9954664, 7.0304437, 7.0655959,
         7.1009239, 7.1364285, 7.1721107, 7.2079712, 7.2440111, 7.2802311, 7.3166323, 7.3532155, 7.3899815, 7.4269314,
         7.4640661, 7.5013864, 7.5388934, 7.5765878, 7.6144708, 7.6525431, 7.6908058, 7.7292599, 7.7679062, 7.8067457,
         7.8457794, 7.8850083, 7.9244334, 7.9640555, 8.0038758, 8.0438952, 8.0841147, 8.1245352, 8.1651579, 8.2059837,
         8.2470136, 8.2882487, 8.3296899, 8.3713384, 8.4131951, 8.455261, 8.4975373, 8.540025, 9.030794, 9.653919,
         10.32004, 11.03212, 11.79334, 12.03822, 12.22248, 12.27162, 12.34532, 12.52958, 12.60708, 13.47697, 13.92453,
         14.13766, 14.19449, 14.27974, 14.40688, 14.49287, 14.54251, 14.7651, 14.82446, 14.9135, 15.13609, 15.40095,
         16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502,
         34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318,
         71.45536, 76.38578, 81.44026, 81.6564, 82.68679, 83.0192, 83.51781, 84.76435, 87.29069, 93.31374, 99.75239,
         106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156,
         222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451],
        [2.49501, 1.42832, 0.200589, 1.44193, 2.48802, 3.1059, 2.74244, 2.33399, 2.73258, 3.05471, 2.45759, 2.16853,
         1.93957, 1.82849, 1.89424, 2.19117, 2.76201, 3.6308, 4.7973, 6.38775, 8.04416, 9.84804, 11.7169, 13.5693,
         15.3289, 16.915, 18.2727, 19.3757, 20.2196, 20.8155, 21.183, 21.3436, 21.3123, 21.0827, 20.5739, 19.2513,
         19.036, 17.9046, 16.3099, 17.9732, 19.4028, 20.3418, 20.982, 21.0514, 20.7897, 20.0015, 19.9183, 19.2918,
         18.4995, 19.2719, 19.9056, 20.2531, 20.3692, 20.0752, 20.0607, 19.8095, 19.5494, 19.7596, 19.864, 19.8637,
         19.7713, 19.6098, 19.7752, 19.8528, 19.9021, 19.8318, 19.4244, 19.4106, 19.2669, 19.1823, 19.1886, 19.1141,
         18.8983, 18.2729, 17.5385, 16.7188, 15.8389, 14.9425, 14.0719, 13.3063, 12.733, 12.4451, 12.5328, 13.0524,
         14.0382, 15.4764, 17.2942, 19.3207, 20.0658, 20.3115, 20.1357, 20.6264, 21.3794, 21.7622, 22.2111, 22.1524,
         22.6131, 23.4096, 24.1932, 27.1474, 30.0221, 32.7346, 35.5563, 35.7355, 35.9127, 36.0877, 36.2605, 36.4309,
         36.5988, 36.7641, 36.9267, 37.0863, 37.2427, 37.3958, 37.5452, 37.6906, 37.8316, 37.9677, 38.0981, 38.2222,
         38.3387, 38.4461, 38.5423, 38.624, 38.6861, 38.7198, 38.7072, 38.6046, 38.2315, 37.7853, 37.867, 38.1133,
         39.0033, 39.4715, 39.8291, 40.1339, 40.4073, 40.6595, 40.8963, 41.1213, 41.3368, 41.5444, 41.7452, 41.9402,
         42.13, 42.315, 42.4957, 42.6724, 42.8453, 43.0146, 43.1805, 43.343, 43.5022, 43.6582, 43.8108, 43.96, 44.1056,
         44.2475, 44.3851, 44.5179, 44.6448, 44.764, 44.8721, 44.9604, 44.9967, 44.9425, 45.011, 45.0209, 45.3418,
         45.5509, 45.7317, 45.899, 46.0577, 46.2104, 46.3584, 46.5024, 46.6431, 46.7807, 46.9156, 47.0479, 47.1777,
         47.3052, 47.4305, 47.5535, 47.6742, 47.7928, 47.9091, 48.0231, 48.1347, 48.2437, 48.3501, 48.4535, 48.5536,
         48.65, 48.7418, 48.828, 48.9068, 48.9748, 49.025, 49.0382, 48.8992, 48.8984, 48.9654, 49.1457, 49.4087,
         49.5963, 49.7572, 49.9039, 50.0417, 50.1731, 50.2998, 50.4226, 50.5422, 50.6591, 50.7736, 50.886, 50.9965,
         51.1052, 51.2124, 51.318, 51.4223, 51.5253, 51.627, 51.7276, 51.8271, 51.9256, 52.023, 52.1194, 52.2149,
         52.3095, 52.4032, 52.4961, 52.5882, 52.6796, 52.7702, 52.8601, 52.9495, 53.0382, 53.1263, 53.2139, 53.3011,
         53.3877, 53.4738, 53.5595, 53.6449, 53.73, 53.8151, 53.9003, 53.9836, 54.0644, 54.1431, 54.2195, 54.294,
         54.3665, 54.4372, 54.506, 54.5731, 54.6385, 54.7022, 54.7643, 54.8248, 54.8839, 54.9414, 55.0167, 55.0715,
         55.1249, 55.177, 55.2278, 55.2772, 55.3254, 55.3724, 55.4182, 55.4629, 55.5107, 55.5533, 55.5945, 55.6345,
         55.6733, 55.711, 55.7474, 55.7828, 55.817, 55.8501, 55.8821, 55.9131, 55.943, 55.9719, 55.9997, 56.0266,
         56.0524, 56.0772, 56.1011, 56.124, 56.146, 56.167, 56.187, 56.2061, 56.2244, 56.2417, 56.2581, 56.2736,
         56.2882, 56.302, 56.3149, 56.3269, 56.3381, 56.3485, 56.3581, 56.3668, 56.3746, 56.3815, 56.3876, 56.3927,
         56.397, 56.4005, 56.4031, 56.4049, 56.4059, 56.406, 56.4054, 56.404, 56.4015, 56.3975, 56.3921, 56.3854,
         56.3773, 56.3679, 56.3571, 56.3451, 56.3317, 56.3171, 56.3009, 56.283, 56.2635, 56.2423, 56.2193, 56.1947,
         56.1684, 56.1405, 56.1108, 56.0794, 56.0463, 56.0115, 55.975, 55.9367, 55.8966, 55.8546, 55.8109, 55.7653,
         55.7178, 55.6683, 55.6169, 55.5635, 55.508, 55.4504, 55.3995, 55.3376, 55.2734, 55.2068, 55.1379, 55.0665,
         54.9926, 54.916, 54.8367, 54.7546, 54.6696, 54.5816, 54.4904, 54.396, 54.2982, 54.1969, 54.092, 53.9831, 53.87,
         53.7525, 53.6305, 53.5037, 53.3719, 53.2348, 53.0921, 52.9435, 52.7886, 52.627, 52.4584, 52.2823, 52.0982,
         51.9057, 51.7041, 51.4927, 51.2709, 51.0388, 50.7935, 50.535, 50.2621, 49.9733, 49.6672, 49.3418, 48.995,
         48.6243, 48.2267, 47.7985, 47.3353, 46.8315, 46.2802, 45.6724, 44.9963, 44.2358, 43.3681, 42.3593, 41.1558,
         39.6644, 37.6989, 34.7858, 28.8037, 16.2146, 15.9129, 27.7369, 33.6852, 36.1133, 37.4118, 38.0194, 37.9796,
         36.9517, 32.0152, 26.9354, 26.8547, 36.8932, 40.7295, 43.0624, 44.8169, 46.2493, 47.4704, 48.5392, 49.4914,
         50.3506, 51.1332, 51.851, 52.5131, 53.1265, 53.6965, 54.2277, 54.7234, 55.1867, 55.6197, 56.0245, 56.4023,
         56.7544, 57.0814, 57.3837, 57.6613, 57.9137, 58.1399, 58.338, 58.5052, 58.6369, 58.7262, 58.7616, 58.7228,
         58.57, 58.2069, 57.2756, 55.4687, 55.5003, 55.8297, 58.4538, 59.5579, 60.3325, 60.9542, 61.4855, 61.9557,
         62.3814, 62.7725, 63.1359, 63.4754, 63.8311, 64.1655, 64.4728, 64.7575, 65.0223, 65.2691, 65.499, 65.7117,
         65.9074, 66.0857, 66.2456, 66.3851, 66.5007, 66.586, 66.6285, 66.6002, 66.4119, 65.8359, 64.8291, 65.9237,
         66.7125, 67.2914, 67.6869, 68.0037, 68.2737, 68.511, 68.7226, 68.9123, 69.0819, 69.2312, 69.3634, 69.4775,
         69.5685, 69.6263, 69.6255, 69.4622, 69.3485, 69.3913, 69.4698, 70.0065, 70.3407, 70.6015, 70.826, 71.028,
         71.2143, 71.3889, 71.5539, 71.7099, 71.8583, 72.0003, 72.1364, 72.2673, 72.3934, 72.5153, 72.6331, 72.7473,
         72.858, 72.9654, 73.0699, 73.1714, 73.2703, 73.3666, 73.4604, 73.552, 73.6414, 73.7287, 73.8141, 73.8976,
         73.9793, 74.0594, 74.1379, 74.2151, 74.2908, 74.3655, 74.439, 74.5107, 74.5805, 74.6485, 74.715, 74.7799,
         74.8435, 74.9056, 74.9665, 75.0261, 75.0846, 75.142, 75.1983, 75.2537, 75.3081, 75.5526, 75.6054, 75.6565,
         75.7058, 75.7535, 75.7997, 75.8445, 75.888, 76.0591, 76.0999, 76.139, 76.1766, 76.2126, 76.2472, 76.2804,
         76.3124, 76.3431, 76.3726, 76.4009, 76.4282, 76.4544, 76.4795, 76.5037, 76.5269, 76.5492, 76.5706, 76.5911,
         76.6108, 76.6297, 76.6478, 76.6652, 76.6818, 76.6977, 76.7129, 76.7275, 76.7414, 76.7548, 76.7675, 76.7797,
         76.7913, 76.8024, 76.813, 76.8231, 76.9308, 76.9406, 76.9495, 76.9576, 76.965, 76.9716, 76.9776, 76.9829,
         76.9876, 76.9916, 76.9951, 76.998, 77.0004, 77.0022, 77.0035, 77.0044, 77.0047, 77.0046, 77.0041, 77.0031,
         77.0017, 76.9999, 76.9976, 76.9951, 76.9921, 76.9888, 76.9852, 76.9812, 76.9769, 77.0119, 77.0071, 77.0019,
         76.9963, 76.9903, 76.9839, 76.9772, 76.97, 76.9625, 76.9546, 76.9463, 76.9377, 76.9288, 76.9195, 76.9099,
         76.8999, 76.9064, 76.8959, 76.8851, 76.8739, 76.8624, 76.8505, 76.8383, 76.8257, 76.8128, 76.7996, 76.786,
         76.7722, 76.758, 76.7435, 76.7287, 76.7137, 76.6983, 76.6827, 76.6667, 76.6505, 76.634, 76.6172, 76.6001,
         76.5828, 76.5652, 76.5473, 76.5292, 76.5108, 76.4921, 76.4732, 76.4541, 76.4347, 76.4151, 76.3952, 76.3752,
         76.3549, 76.3345, 76.1838, 75.7597, 75.1472, 74.2114, 72.3323, 70.976, 68.26, 65.0762, 68.2479, 71.0452,
         71.5833, 73.5382, 73.1608, 71.953, 70.3784, 72.01, 73.0797, 73.4317, 73.5707, 73.6042, 72.9374, 73.9597,
         75.1292, 75.8937, 77.5917, 78.5498, 79.1746, 79.5942, 79.8742, 80.0602, 80.2412, 80.3201, 80.3721, 80.4278,
         80.3867, 80.3222, 80.2429, 80.154, 80.0584, 79.9578, 79.853, 79.7436, 79.6279, 79.5009, 79.3567, 79.1821,
         78.9465, 78.566, 77.5656, 77.4618, 76.5087, 75.2427, 76.5634, 77.7188, 78.512, 79.2696, 79.651, 79.8848,
         80.0388, 80.1439, 80.2131, 80.2578, 80.2851, 80.2998, 80.3056, 80.3049, 80.299, 80.2894, 80.2774, 80.2639,
         80.2494, 80.2345, 80.2195, 80.2046, 80.1901, 80.1761, 80.1627, 80.15, 80.138],
        [0.0, 0.0, 0.0, 2.3873, 2.3365, 1.9852, 1.9863, 1.9879, 2.777, 2.7791, 4.1468, 4.8442, 5.7226, 6.7781, 7.9896,
         9.3163, 10.699, 12.063, 13.327, 14.409, 15.239, 15.767, 15.967, 15.841, 15.4, 14.68, 13.75, 12.683, 11.547,
         10.396, 9.2771, 8.22, 7.2453, 6.3634, 5.5774, 4.925, 4.8852, 4.7787, 4.7409, 7.8113, 7.5739, 7.1042, 6.1885,
         5.3921, 4.7069, 4.1481, 4.1242, 4.0276, 3.9966, 5.4765, 5.3527, 5.1173, 4.6406, 4.1848, 4.1755, 4.0799, 4.0524,
         4.4825, 4.4029, 4.3818, 4.3008, 4.274, 4.557, 4.5185, 4.4623, 4.1148, 3.8128, 3.8071, 3.7608, 3.7483, 3.8387,
         3.8085, 3.7697, 3.7829, 3.9599, 4.3288, 4.9248, 5.7859, 6.946, 8.4265, 10.226, 12.315, 14.627, 17.066, 19.513,
         21.838, 23.915, 25.639, 26.205, 26.499, 26.573, 27.286, 27.585, 27.768, 28.033, 28.099, 28.637, 28.891, 29.159,
         29.963, 30.316, 30.258, 30.041, 30.007, 29.972, 29.935, 29.896, 29.856, 29.814, 29.771, 29.726, 29.68, 29.632,
         29.583, 29.533, 29.481, 29.428, 29.374, 29.319, 29.262, 29.204, 29.146, 29.085, 29.024, 28.962, 28.899, 28.835,
         28.769, 28.703, 28.678, 30.411, 30.402, 30.336, 30.27, 30.202, 30.133, 30.064, 29.994, 29.923, 29.851, 29.779,
         29.705, 29.632, 29.557, 29.482, 29.406, 29.329, 29.252, 29.175, 29.097, 29.018, 28.939, 28.859, 28.779, 28.698,
         28.617, 28.535, 28.453, 28.37, 28.287, 28.204, 28.12, 28.036, 27.952, 27.867, 27.828, 28.169, 28.168, 28.086,
         28.002, 27.918, 27.833, 27.749, 27.664, 27.579, 27.493, 27.408, 27.322, 27.236, 27.15, 27.064, 26.977, 26.891,
         26.804, 26.717, 26.631, 26.544, 26.457, 26.369, 26.282, 26.195, 26.107, 26.02, 25.933, 25.845, 25.757, 25.67,
         25.582, 25.495, 25.407, 25.319, 25.319, 25.809, 25.776, 25.689, 25.602, 25.515, 25.428, 25.342, 25.255, 25.168,
         25.082, 24.995, 24.909, 24.822, 24.736, 24.65, 24.564, 24.478, 24.392, 24.306, 24.22, 24.135, 24.049, 23.964,
         23.878, 23.793, 23.708, 23.623, 23.538, 23.454, 23.369, 23.285, 23.2, 23.116, 23.032, 22.948, 22.865, 22.781,
         22.698, 22.615, 22.531, 22.447, 22.364, 22.281, 22.198, 22.115, 22.032, 21.918, 21.804, 21.692, 21.58, 21.468,
         21.358, 21.248, 21.138, 21.029, 20.921, 20.813, 20.706, 20.599, 20.493, 20.388, 20.283, 20.178, 20.074, 19.971,
         19.868, 19.766, 19.664, 19.563, 19.462, 19.362, 19.263, 19.164, 19.065, 18.966, 18.868, 18.77, 18.673, 18.577,
         18.481, 18.385, 18.29, 18.196, 18.102, 18.009, 17.916, 17.824, 17.732, 17.641, 17.551, 17.461, 17.371, 17.282,
         17.194, 17.106, 17.018, 16.931, 16.845, 16.759, 16.674, 16.589, 16.505, 16.421, 16.337, 16.255, 16.172, 16.09,
         16.008, 15.927, 15.846, 15.766, 15.686, 15.607, 15.528, 15.449, 15.371, 15.294, 15.217, 15.14, 15.056, 14.972,
         14.889, 14.807, 14.725, 14.644, 14.563, 14.483, 14.403, 14.324, 14.24, 14.157, 14.074, 13.992, 13.91, 13.83,
         13.749, 13.669, 13.59, 13.512, 13.434, 13.356, 13.279, 13.203, 13.127, 13.052, 12.977, 12.903, 12.829, 12.756,
         12.683, 12.611, 12.54, 12.469, 12.398, 12.328, 12.258, 12.189, 12.121, 12.053, 11.985, 11.918, 11.851, 11.785,
         11.719, 11.654, 11.589, 11.525, 11.461, 11.397, 11.331, 11.265, 11.199, 11.133, 11.068, 11.003, 10.939, 10.875,
         10.808, 10.743, 10.678, 10.613, 10.549, 10.486, 10.423, 10.361, 10.299, 10.238, 10.177, 10.117, 10.057, 9.9978,
         9.939, 9.8808, 9.823, 9.7657, 9.7088, 9.6524, 9.5965, 9.5411, 9.4861, 9.4315, 9.3774, 9.3238, 9.2706, 9.2178,
         9.1654, 9.1135, 9.0619, 9.0108, 8.9601, 8.9098, 8.859, 8.8346, 26.029, 25.949, 25.758, 25.568, 25.38, 25.194,
         25.009, 24.826, 24.644, 24.61, 35.97, 35.781, 35.513, 35.247, 34.984, 34.722, 34.463, 34.206, 33.951, 33.698,
         33.447, 33.198, 32.95, 32.705, 32.462, 32.221, 31.982, 31.744, 31.509, 31.275, 31.043, 30.813, 30.585, 30.