/*
Copyright (C) by Dmitry E. Oboukhov 2006, 2007

  This package is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This package is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this package; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
*/
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>

#include "unit.h"
#include "units_info.h"
#include "parse_input.h"
#include "version.h"
#include "sim.h"
#include "random.h"
#include "report.h"

int main(int argc, char **argv)
{
  sim_info * sim = parse_input(argc, argv);
  
  // инициализируем рандом-генератор числом
  // зависящим от текущего времени
  time_t t;
  srandom( time(&t) );
  sims_result * sres=simulator(sim);

  print_report(sres);

  free(sim); free(sres);
  return 0;
}
