/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.util.units;

import com.sourceforge.knecs.util.units.InvalidUnitConversionException;
import java.util.Hashtable;

public class UnitConverter {
    public static final String DYNE_CM2 = "dyne/cm2";
    public static final String ATM = "atm";
    public static final String BAR = "bar";
    public static final String K = "K";
    protected static Hashtable mFactors = new Hashtable();

    public UnitConverter() {
        if (mFactors.size() == 0) {
            mFactors.put("dyne/cm2atm", new Double(9.869232667160128E-7));
            mFactors.put("atmdyne/cm2", new Double(1013250.0));
            mFactors.put("dyne/cm2bar", new Double(1.0E-7));
            mFactors.put("baratm", new Double(0.986923267));
            mFactors.put("atmbar", new Double(1.0132499997084372));
        }
    }

    public double convert(String from, String to, double value) throws InvalidUnitConversionException {
        float f = (float)(value * this.getConversionFactor(from, to));
        return f;
    }

    public double getConversionFactor(String from, String to) throws InvalidUnitConversionException {
        Double ret = (Double)mFactors.get(from + to);
        if (ret != null) {
            return ret;
        }
        if (from.equals(to)) {
            return 1.0;
        }
        throw new InvalidUnitConversionException(from, to);
    }
}

