/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once


/////////////////////// Qt includes


/////////////////////// Local includes
#include "exportimportconfig.h"
#include "Ponderable.hpp"
#include "PolChemDefEntity.hpp"
#include "IonizeRule.hpp"

namespace MsXpS
{


namespace libXpertMass
{

class PolChemDef;
typedef std::shared_ptr<const PolChemDef> PolChemDefCstSPtr;


class DECLSPEC Ionizable : public PolChemDefEntity, public Ponderable
{
  public:
  Ionizable(PolChemDefCstSPtr,
            const QString    & = QString("NOT_SET"),
            const Ponderable & = Ponderable(),
            const IonizeRule & = IonizeRule(),
            bool               = false);

  Ionizable(const Ionizable &other);

  virtual ~Ionizable();

  const IonizeRule &ionizeRule() const;
  IonizeRule *ionizeRule();

  bool isIonized() const;
  int setCharge(int);
  virtual int charge() const;

  virtual int ionize();
  virtual int ionize(const IonizeRule &);
  static int ionize(Ionizable *, const IonizeRule &);

  virtual int deionize();
  static int deionize(Ionizable *);

  virtual double molecularMass(MassType);

  using PolChemDefEntity::validate;
  virtual bool validate();

  using PolChemDefEntity::operator=;
  using Ponderable::operator=;
  virtual Ionizable &operator=(const Ionizable &);

  using PolChemDefEntity::operator==;
  using Ponderable::operator==;
  virtual bool operator==(const Ionizable &) const;

  using PolChemDefEntity::operator!=;
  using Ponderable::operator!=;
  virtual bool operator!=(const Ionizable &) const;

  virtual bool calculateMasses() override;

  QString toString();

  protected:
  //! IonizeRule that is used to ionize \c this Ionizable.
  IonizeRule m_ionizeRule;

  //! Indicates if \c this Ionizable has been effectively ionized.
  bool m_isIonized;
};

} // namespace libXpertMass

} // namespace MsXpS
