package CParse::Declarator::Array;

use 5.6.0;
use strict;
use warnings;

use CType::Array;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;
    my $size = shift;
    my $restrict = shift;
    my $self = {declarator => undef,
                size => $size,
                restrict => $restrict,
               };
    bless $self, $class;
    return $self;
  }

sub set_declarator
  {
    my $self = shift;
    $self->{declarator} = shift;
  }

sub dump_c
  {
    my $self = shift;
    my $str = '';
    if ($self->{declarator})
      {
        $str .= $self->{declarator}->dump_c;
      }
    if (defined $self->{size})
      {
        my $size = $self->{size}->dump_c;
        $str .= "[$size]";
        return $str;
      }
    else
      {
        $str .= "[]";
        return $str;
      }
  }

sub get_identifier
  {
    my $self = shift;

    return undef unless $self->{declarator};
    return $self->{declarator}->get_identifier;
  }

sub get_type
  {
    my $self = shift;

    my $namespace = shift;
    my $base_type = shift;
    my $attributes = shift;

    my $size = $self->{size} ? $self->{size}->get_expr($namespace) : undef;
    my $type = new CType::Array $base_type, $size, $attributes;
    if ($self->{declarator})
      {
        $type = $self->{declarator}->get_type($namespace, $type, []);
      }
    return $type;
  }

1;
