/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.DefaultConfig;
import com.sun.deploy.config.Platform;
import com.sun.deploy.net.proxy.NSPreferences;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SearchPath;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.security.action.GetPropertyAction;

public class UnixPlatform
extends Platform {
    private String _userHome;
    private String _systemHome;
    private String _osHome;
    private static final int[] DEFAULT_SIZES = new int[]{32, 16, 48, 64};
    private UnixWebJavaSwitch javaSwitch = new UnixWebJavaSwitch();
    private static final int ARGS_LIST_CAPACITY = 32;
    private static final int ARG_CAPACITY = 64;
    private static final char BACKSLASH = '\\';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char TAB = '\t';
    private static final char LINEFEED = '\n';
    private static final char RETURN = '\r';
    private static final char SPACE = ' ';

    public UnixPlatform() {
        this.loadDeployNativeLib();
    }

    public void loadDeployNativeLib() {
        try {
            String string = System.getProperty("os.arch");
            if (string.equals("x86")) {
                string = "i386";
            }
            System.load(Environment.getJavaHome() + File.separator + "lib" + File.separator + string + File.separator + "libdeploy.so");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public String escapeBackslashAndQuoteString(String string) {
        return string;
    }

    public String getUserHome() {
        if (this._userHome == null) {
            String string = AccessController.doPrivileged(new GetPropertyAction("javaplugin.user.profile"));
            if (string == null || string.trim().equals("")) {
                string = AccessController.doPrivileged(new GetPropertyAction("user.home"));
            }
            this._userHome = string + (string.endsWith(File.separator) ? "" : File.separator) + ".java" + File.separator + "deployment";
        }
        return this._userHome;
    }

    public String getSystemHome() {
        if (this._systemHome == null) {
            this._systemHome = File.separator + "etc" + File.separator + ".java" + File.separator + "deployment";
        }
        return this._systemHome;
    }

    public String getOSHome() {
        if (this._osHome == null) {
            this._osHome = File.separator + "etc";
        }
        return this._osHome;
    }

    public void sendJFXPing(String string, String string2, String string3, String string4, String string5, int n, String string6) {
    }

    public boolean isBrowserFireFox() {
        return false;
    }

    public boolean isNativeModalDialogUp() {
        return false;
    }

    public boolean isPlatformWindowsVista() {
        return false;
    }

    public String getPlatformExtension() {
        return "";
    }

    public String getLibraryPrefix() {
        return "lib";
    }

    public String getLibrarySufix() {
        return ".so";
    }

    public int installShortcut(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return 0;
    }

    public boolean useAltFileSystemView() {
        return false;
    }

    public boolean isLocalInstallSupported() {
        return this.getEnv("GNOME_DESKTOP_SESSION_ID") != null || new File("/usr/share/gnome").exists() || this.getEnv("DBUS_SESSION_BUS_ADDRESS") != null || this.getEnv("_DBUS_SESSION_BUS_ADDRESS") != null;
    }

    public boolean systemLookAndFeelDefault() {
        return (this.getEnv("GNOME_DESKTOP_SESSION_ID") != null || new File("/usr/share/gnome").exists() || this.getEnv("DBUS_SESSION_BUS_ADDRESS") != null || this.getEnv("_DBUS_SESSION_BUS_ADDRESS") != null) && Config.isJavaVersionAtLeast15();
    }

    public String getSessionSpecificString() {
        String string = this.getEnv("DISPLAY");
        if (string != null) {
            return string;
        }
        return "";
    }

    public String getPlatformSpecificJavaName() {
        return "java";
    }

    public native String getEnv(String var1);

    public String getBrowserPath() {
        File file;
        String string = Config.getStringProperty("deployment.browser.path");
        if (string != null && string.length() > 0 && !(file = new File(string)).exists()) {
            string = null;
        }
        if ((string == null || string.length() == 0) && (file = SearchPath.findOne(this.getEnv("PATH"))) != null) {
            string = file.getAbsolutePath();
        }
        return string;
    }

    public String getFireFoxUserProfileDirectory() {
        return this.getMozillaUserProfileDirectory();
    }

    public String getMozillaUserProfileDirectory() {
        String string = null;
        try {
            String string2 = System.getProperty("user.home");
            File file = new File(string2 + "/.mozilla/appreg");
            if (file.exists()) {
                string = NSPreferences.getNS6UserProfileDirectory(file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public boolean showDocument(final String string) {
        Boolean bl = Boolean.FALSE;
        try {
            bl = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new Boolean(UnixPlatform.this._showDocument(string));
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignored(privilegedActionException.getCause());
        }
        return bl;
    }

    private boolean _showDocument(String string) {
        File file;
        String string2 = this.getBrowserPath();
        boolean bl = false;
        if (string2 != null && !string2.equals("") && (file = new File(string2)).exists()) {
            String[] stringArray = null;
            Process process = null;
            stringArray = this.getExtendedBrowserArgs(file, string);
            if (stringArray != null) {
                try {
                    Trace.println("Invoking browser with: \n     " + this.argsFromArray(stringArray), TraceLevel.BASIC);
                    process = Runtime.getRuntime().exec(stringArray);
                    int n = process.waitFor();
                    if (n == 0) {
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
                catch (InterruptedException interruptedException) {
                    Trace.ignoredException(interruptedException);
                }
            }
            if (!bl) {
                try {
                    stringArray = this.getBasicBrowserArgs(file, string);
                    Trace.println("Invoking browser with: \n     " + this.argsFromArray(stringArray), TraceLevel.BASIC);
                    process = Runtime.getRuntime().exec(stringArray);
                    bl = process != null;
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
            }
        }
        return bl;
    }

    public String argsFromArray(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(2048);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]).append(' ');
        }
        return stringBuffer.toString().trim();
    }

    public String[] argsFromString(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(32);
        StringBuffer stringBuffer = new StringBuffer(64);
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        String[] stringArray = new String[]{};
        if (string != null) {
            n = string.length();
        }
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    if (++i >= n) continue block6;
                    stringBuffer.append(string.charAt(i));
                    continue block6;
                }
                case '\'': {
                    if (bl) {
                        stringBuffer.append(c);
                    }
                    bl2 = !bl2;
                    continue block6;
                }
                case '\"': {
                    if (bl2) {
                        stringBuffer.append(c);
                    }
                    bl = !bl;
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (bl2 || bl) {
                        stringBuffer.append(c);
                        continue block6;
                    }
                    if (stringBuffer.length() <= 0) continue block6;
                    arrayList.add(stringBuffer.toString());
                    stringBuffer.delete(0, stringBuffer.length());
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList.toArray(stringArray);
    }

    private String[] getBasicBrowserArgs(File file, String string) {
        String[] stringArray = new String[]{file.getAbsolutePath(), string};
        return stringArray;
    }

    private String[] getExtendedBrowserArgs(File file, String string) {
        boolean bl = false;
        String[] stringArray = this.argsFromString(Config.getStringProperty("deployment.browser.args"));
        String[] stringArray2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            int n = 0;
            int n2 = -1;
            n2 = stringArray[i].indexOf("%u", n);
            while (n2 >= 0) {
                stringArray[i] = stringArray[i].substring(n, n2) + string + stringArray[i].substring(n2 + 2);
                n = n2 + 2;
                n2 = stringArray[i].indexOf("%u", n);
                bl = true;
            }
        }
        if (bl) {
            stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
            stringArray2[0] = file.getAbsolutePath();
        }
        return stringArray2;
    }

    public String getDebugJavaPath(String string) {
        return string;
    }

    public boolean isPlatformIconType(String string) {
        return this.isLocalInstallSupported() && (string.toLowerCase().endsWith(".png") || string.toLowerCase().endsWith(".ico"));
    }

    public Vector getInstalledJREList() {
        return this.getPublicJres();
    }

    public String getBrowserHomePath() {
        return System.getenv("MOZILLA_HOME");
    }

    public String getUserHomeOverride() {
        return null;
    }

    public void setUserHomeOverride(String string) {
    }

    public void init() {
    }

    public void onSave(Object object) {
    }

    public void onLoad(Object object) {
    }

    public void resetJavaHome() {
    }

    void setDefaultConfigProperties(DefaultConfig defaultConfig) {
        defaultConfig.setProperty("deployment.browser.path", "");
        defaultConfig.setProperty("deployment.browser.args", "-remote openURL(%u,new-window)");
    }

    public Vector getPublicJres() {
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("java.class.path");
        String string3 = System.getProperty("sun.boot.class.path");
        string2 = string2 == null ? string3 : string2 + File.pathSeparator + string3;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        String string4 = "";
        while (stringTokenizer.hasMoreElements() && !(string4 = (String)stringTokenizer.nextElement()).endsWith("rt.jar")) {
        }
        int n = string4.lastIndexOf(File.separatorChar);
        string4 = string4.substring(0, n);
        n = string4.lastIndexOf(File.separatorChar);
        string4 = string4.substring(0, n);
        String string5 = System.getProperty("java.version");
        int n2 = string5.lastIndexOf("-");
        Vector<String> vector = new Vector<String>();
        if (n2 != -1) {
            string5 = string5.substring(0, n2);
        }
        vector.addElement(string5);
        vector.addElement(string4);
        return vector;
    }

    public Vector getPublicJdks() {
        return new Vector();
    }

    public int applyBrowserSettings() {
        return 0;
    }

    public void initBrowserSettings() {
    }

    public boolean getJqsSettings() {
        return false;
    }

    public void setJqsSettings(boolean bl) {
    }

    public boolean getJavaPluginSettings() {
        return true;
    }

    public int setJavaPluginSettings(boolean bl) {
        return 2;
    }

    public String getLongPathName(String string) {
        return string;
    }

    public boolean samePaths(String string, String string2) {
        try {
            return new File(string).getCanonicalPath().equals(new File(string2).getCanonicalPath());
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean canBecomeAdmin() {
        return this.hasAdminPrivileges();
    }

    public boolean hasAdminPrivileges() {
        return false;
    }

    public void handleUserResponse(int n) {
    }

    public boolean shouldPromptForAutoCheck() {
        return false;
    }

    public String toExecArg(String string) {
        return string;
    }

    public boolean showURL(String string) {
        return false;
    }

    public int[] getIconSizes() {
        return DEFAULT_SIZES;
    }

    public int getSystemShortcutIconSize(boolean bl) {
        return bl ? 32 : 16;
    }

    public String getSystemJavawsPath() {
        return Environment.getJavawsCommand();
    }

    public long getNativePID() {
        return this.getPlatformPID();
    }

    public String getDefaultSystemCache() {
        return null;
    }

    public boolean canAutoDownloadJRE() {
        return true;
    }

    public void addRemoveProgramsAdd(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
    }

    public void addRemoveProgramsRemove(String string, boolean bl) {
    }

    public void notifyJREInstalled(String string) {
    }

    public void cacheSecurityBaseline(String string, String string2) {
    }

    public void cacheCurrentConfig(Properties properties) {
        try {
            File file = new File(System.getProperty("user.home"));
            File file2 = new File(file, ".java/deployment");
            File file3 = new File(file2, "config.cache");
            file2.mkdirs();
            file3.delete();
            PrintStream printStream = new PrintStream(file3, "UTF-8");
            printStream.println("#This file is autogenerated. Do not edit it manually.");
            printStream.println("#To update Java deployment configuration use jcontrol utility");
            printStream.println("# or update deployment.properties.");
            Iterator<Object> iterator = properties.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                printStream.println(string + "=" + properties.getProperty(string));
            }
            printStream.close();
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
    }

    public Platform.WebJavaSwitch getWebJavaSwitch() {
        return this.javaSwitch;
    }

    public native int getPlatformMaxCommandLineLength();

    protected native long getPlatformPID();

    public String getLoadedNativeLibPath(String string) {
        throw new UnsupportedOperationException("Not yet supported on Unix platform.");
    }

    public native boolean isGTKAvailable(int var1, int var2, int var3);

    public static final class UnixWebJavaSwitch
    extends Platform.WebJavaSwitch {
        private UnixWebJavaSwitch() {
        }

        protected boolean isSystemWebJavaEnabled() {
            return true;
        }

        protected void setSystemWebJavaEnabled(boolean bl) {
        }
    }
}

