/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.providers.scripted;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.profiler.attach.providers.AbstractIntegrationProvider;
import org.netbeans.modules.profiler.attach.providers.IntegrationCategorizer;
import org.netbeans.modules.profiler.attach.providers.ValidationResult;
import org.netbeans.modules.profiler.attach.providers.scripted.ProfilerScriptModifier;
import org.netbeans.modules.profiler.attach.providers.scripted.ScriptHeaderModifier;
import org.netbeans.modules.profiler.attach.providers.scripted.ScriptModificationException;
import org.netbeans.modules.profiler.attach.spi.ModificationException;
import org.netbeans.modules.profiler.attach.spi.RunException;
import org.netbeans.modules.profiler.attach.wizard.steps.NullWizardStep;
import org.openide.util.RequestProcessor;

public abstract class AbstractScriptIntegrationProvider
extends AbstractIntegrationProvider {
    private String installationPath = "";

    public AbstractScriptIntegrationProvider() {
        this.attachedWizard = new NullWizardStep();
    }

    public void setInstallationPath(String string) {
        this.installationPath = string;
    }

    public String getInstallationPath() {
        return this.installationPath;
    }

    @Override
    public void categorize(IntegrationCategorizer integrationCategorizer) {
        integrationCategorizer.addAppserver(this, this.getAttachWizardPriority());
    }

    @Override
    public void modify(AttachSettings attachSettings) throws ModificationException {
        try {
            this.modifyScriptForAttach(attachSettings);
        }
        catch (ScriptModificationException scriptModificationException) {
            throw new ModificationException(scriptModificationException);
        }
    }

    @Override
    public void run(AttachSettings attachSettings) throws RunException {
        if (attachSettings.isRemote()) {
            return;
        }
        boolean bl = attachSettings.isDirect();
        String string = attachSettings.getHostOS();
        Collection collection = this.prepareCommands(string);
        final String[] stringArray = collection.toArray(new String[0]);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(stringArray).getInputStream()));
                    while (bufferedReader.readLine() != null) {
                    }
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public abstract ValidationResult validateInstallation(String var1, String var2);

    protected abstract boolean isBackupRequired();

    protected abstract ScriptHeaderModifier getHeaderModifier(String var1);

    protected abstract String getModifiedScriptPath(String var1, boolean var2);

    protected abstract String getScriptPath(String var1, boolean var2);

    protected abstract String getWinConsoleString();

    protected abstract void generateCommands(String var1, Collection var2);

    protected abstract void modifyScriptFileForDirectAttach(String var1, int var2, boolean var3, StringBuffer var4);

    protected abstract void modifyScriptFileForDynamicAttach(String var1, int var2, boolean var3, StringBuffer var4);

    protected String getDefaultScriptEncoding() {
        return null;
    }

    protected final void modifyScript(String string, String string2, ProfilerScriptModifier profilerScriptModifier, AttachSettings attachSettings) throws ScriptModificationException {
        this.modifyScript(string, string2, profilerScriptModifier, attachSettings, null);
    }

    protected final void modifyScript(String string, String string2, ProfilerScriptModifier profilerScriptModifier, AttachSettings attachSettings, String string3) throws ScriptModificationException {
        String string4 = attachSettings.getHostOS();
        String string5 = IntegrationUtils.getLineBreak((String)string4);
        BufferedReader bufferedReader = null;
        File file = null;
        File file2 = null;
        try {
            String string6;
            file = new File(string);
            file2 = new File(string2);
            InputStreamReader inputStreamReader = null;
            inputStreamReader = string3 == null ? new InputStreamReader(new FileInputStream(file)) : new InputStreamReader((InputStream)new FileInputStream(file), string3);
            if (string3 == null) {
                string3 = inputStreamReader.getEncoding();
            }
            bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            while ((string6 = bufferedReader.readLine()) != null) {
                stringBuffer2.append(string6);
                profilerScriptModifier.lineRead(stringBuffer2);
                stringBuffer.append(stringBuffer2);
                stringBuffer.append(string5);
                stringBuffer2.delete(0, stringBuffer2.length());
            }
            profilerScriptModifier.readDone();
            bufferedReader.close();
            if (profilerScriptModifier.needsModification() && this.isBackupRequired() && !IntegrationUtils.backupFile((File)file)) {
                throw new ScriptModificationException("Can't backup script");
            }
            profilerScriptModifier.modifyScript(attachSettings, string5, stringBuffer);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8");
            outputStreamWriter.write(stringBuffer.toString());
            ((Writer)outputStreamWriter).flush();
            ((Writer)outputStreamWriter).close();
            if (!IntegrationUtils.isWindowsPlatform((String)string4)) {
                Runtime.getRuntime().exec("chmod a+x " + file2.getAbsolutePath());
            }
        }
        catch (IOException iOException) {
            if (this.isBackupRequired() && !IntegrationUtils.restoreFile((File)file)) {
                throw new ScriptModificationException("Restore corrupted");
            }
            throw new ScriptModificationException(iOException);
        }
        catch (ScriptModificationException scriptModificationException) {
            if (this.isBackupRequired() && !IntegrationUtils.restoreFile((File)file)) {
                throw new ScriptModificationException("Restore corrupted", scriptModificationException);
            }
            throw scriptModificationException;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
    }

    protected final void modifyScript(String string, ProfilerScriptModifier profilerScriptModifier, AttachSettings attachSettings) throws ScriptModificationException {
        this.modifyScript(string, string, profilerScriptModifier, attachSettings);
    }

    private void generateCompleteCommands(String string, Collection collection) {
        if (IntegrationUtils.isWindowsPlatform((String)string)) {
            collection.add("cmd.exe");
            collection.add("/K");
            collection.add("start");
            collection.add("\"" + this.getWinConsoleString() + "\"");
        } else {
            if (IntegrationUtils.PLATFORM_MAC_OS.equals(string)) {
                ArrayList arrayList = new ArrayList();
                StringBuffer stringBuffer = new StringBuffer(256);
                Iterator iterator = arrayList.iterator();
                this.generateCommands(string, arrayList);
                for (String string2 : arrayList) {
                    stringBuffer.append(string2);
                    stringBuffer.append(" ");
                }
                collection.add("/usr/bin/osascript");
                collection.add("-e");
                collection.add("tell Application \"Terminal\"");
                collection.add("-e");
                collection.add("do script \"" + stringBuffer + "\"");
                collection.add("-e");
                collection.add("end tell");
                return;
            }
            collection.add("xterm");
            collection.add("-sb");
            collection.add("-sl");
            collection.add("1000");
            collection.add("-e");
        }
        this.generateCommands(string, collection);
    }

    private void modifyScriptForAttach(AttachSettings attachSettings) throws ScriptModificationException {
        final String string = attachSettings.getHostOS();
        if (attachSettings.isDirect()) {
            this.modifyScript(this.getScriptPath(string, false), this.getModifiedScriptPath(string, false), new ProfilerScriptModifier(this.getHeaderModifier(string)){

                @Override
                public void onModification(AttachSettings attachSettings, String string2, StringBuffer stringBuffer) throws ScriptModificationException {
                    AbstractScriptIntegrationProvider.this.modifyScriptFileForDirectAttach(string, attachSettings.getPort(), false, stringBuffer);
                }

                @Override
                public void onLineRead(StringBuffer stringBuffer) {
                }
            }, attachSettings, this.getDefaultScriptEncoding());
        } else {
            this.modifyScript(this.getScriptPath(string, false), this.getModifiedScriptPath(string, false), new ProfilerScriptModifier(this.getHeaderModifier(string)){

                @Override
                public void onModification(AttachSettings attachSettings, String string2, StringBuffer stringBuffer) throws ScriptModificationException {
                    AbstractScriptIntegrationProvider.this.modifyScriptFileForDynamicAttach(string, attachSettings.getPort(), false, stringBuffer);
                }

                @Override
                public void onLineRead(StringBuffer stringBuffer) {
                }
            }, attachSettings, this.getDefaultScriptEncoding());
        }
    }

    private Collection prepareCommands(String string) {
        ArrayList arrayList = new ArrayList(15);
        this.generateCompleteCommands(string, arrayList);
        return arrayList;
    }
}

