/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

abstract class AbstractLongMap {
    private final int VALUE_SIZE;
    final int ENTRY_SIZE;
    private File tempFile;
    long fileSize;
    private long keys;
    final int KEY_SIZE;
    final int ID_SIZE;
    final int FOFFSET_SIZE;
    Data dumpBuffer;

    AbstractLongMap(int n, int n2, int n3, int n4) throws FileNotFoundException, IOException {
        assert (n2 == 4 || n2 == 8);
        assert (n3 == 4 || n3 == 8);
        this.keys = (long)n * 4L / 3L;
        this.ID_SIZE = n2;
        this.FOFFSET_SIZE = n3;
        this.KEY_SIZE = this.ID_SIZE;
        this.VALUE_SIZE = n4;
        this.ENTRY_SIZE = this.KEY_SIZE + this.VALUE_SIZE;
        this.fileSize = this.keys * (long)this.ENTRY_SIZE;
        this.tempFile = File.createTempFile("NBProfiler", ".map");
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.tempFile, "rw");
        if (Boolean.getBoolean("org.netbeans.lib.profiler.heap.zerofile")) {
            byte[] byArray = new byte[524288];
            while (randomAccessFile.length() < this.fileSize) {
                randomAccessFile.write(byArray);
            }
            randomAccessFile.write(byArray, 0, (int)(this.fileSize - randomAccessFile.length()));
        }
        randomAccessFile.setLength(this.fileSize);
        this.setDumpBuffer(randomAccessFile);
        this.tempFile.deleteOnExit();
    }

    protected void finalize() throws Throwable {
        this.tempFile.delete();
        super.finalize();
    }

    Entry get(long l) {
        long l2 = this.getIndex(l);
        long l3;
        while ((l3 = this.getID(l2)) != l) {
            if (l3 == 0L) {
                return null;
            }
            l2 = this.getNextIndex(l2);
        }
        return this.createEntry(l2);
    }

    Entry put(long l, long l2) {
        long l3 = this.getIndex(l);
        while (true) {
            if (this.getID(l3) == 0L) {
                this.putID(l3, l);
                return this.createEntry(l3, l2);
            }
            l3 = this.getNextIndex(l3);
        }
    }

    private void setDumpBuffer(RandomAccessFile randomAccessFile) throws IOException {
        long l = randomAccessFile.length();
        try {
            this.dumpBuffer = l > Integer.MAX_VALUE ? new LongMemoryMappedData(randomAccessFile, l) : new MemoryMappedData(randomAccessFile, l);
        }
        catch (IOException iOException) {
            if (iOException.getCause() instanceof OutOfMemoryError) {
                this.dumpBuffer = new FileData(randomAccessFile, l);
            }
            throw iOException;
        }
    }

    long getID(long l) {
        if (this.ID_SIZE == 4) {
            return (long)this.dumpBuffer.getInt(l) & 0xFFFFFFFFL;
        }
        return this.dumpBuffer.getLong(l);
    }

    void putID(long l, long l2) {
        if (this.ID_SIZE == 4) {
            this.dumpBuffer.putInt(l, (int)l2);
        } else {
            this.dumpBuffer.putLong(l, l2);
        }
    }

    long getFoffset(long l) {
        if (this.FOFFSET_SIZE == 4) {
            return this.dumpBuffer.getInt(l);
        }
        return this.dumpBuffer.getLong(l);
    }

    void putFoffset(long l, long l2) {
        if (this.FOFFSET_SIZE == 4) {
            this.dumpBuffer.putInt(l, (int)l2);
        } else {
            this.dumpBuffer.putLong(l, l2);
        }
    }

    private long getIndex(long l) {
        long l2 = l & Long.MAX_VALUE;
        return l2 % this.keys * (long)this.ENTRY_SIZE;
    }

    private long getNextIndex(long l) {
        if ((l += (long)this.ENTRY_SIZE) >= this.fileSize) {
            l = 0L;
        }
        return l;
    }

    abstract Entry createEntry(long var1);

    abstract Entry createEntry(long var1, long var3);

    private static class LongMemoryMappedData
    implements Data {
        private static int BUFFER_SIZE_BITS = 30;
        private static long BUFFER_SIZE = 1L << BUFFER_SIZE_BITS;
        private static int BUFFER_SIZE_MASK = (int)(BUFFER_SIZE - 1L);
        private static int BUFFER_EXT = 32768;
        private MappedByteBuffer[] dumpBuffer;

        LongMemoryMappedData(RandomAccessFile randomAccessFile, long l) throws IOException {
            FileChannel fileChannel = randomAccessFile.getChannel();
            this.dumpBuffer = new MappedByteBuffer[(int)((l + BUFFER_SIZE - 1L) / BUFFER_SIZE)];
            for (int i = 0; i < this.dumpBuffer.length; ++i) {
                long l2 = (long)i * BUFFER_SIZE;
                long l3 = Math.min(BUFFER_SIZE + (long)BUFFER_EXT, l - l2);
                this.dumpBuffer[i] = fileChannel.map(FileChannel.MapMode.READ_WRITE, l2, l3);
            }
            fileChannel.close();
        }

        @Override
        public byte getByte(long l) {
            return this.dumpBuffer[this.getBufferIndex(l)].get(this.getBufferOffset(l));
        }

        @Override
        public int getInt(long l) {
            return this.dumpBuffer[this.getBufferIndex(l)].getInt(this.getBufferOffset(l));
        }

        @Override
        public long getLong(long l) {
            return this.dumpBuffer[this.getBufferIndex(l)].getLong(this.getBufferOffset(l));
        }

        @Override
        public void putByte(long l, byte by) {
            this.dumpBuffer[this.getBufferIndex(l)].put(this.getBufferOffset(l), by);
        }

        @Override
        public void putInt(long l, int n) {
            this.dumpBuffer[this.getBufferIndex(l)].putInt(this.getBufferOffset(l), n);
        }

        @Override
        public void putLong(long l, long l2) {
            this.dumpBuffer[this.getBufferIndex(l)].putLong(this.getBufferOffset(l), l2);
        }

        private int getBufferIndex(long l) {
            return (int)(l >> BUFFER_SIZE_BITS);
        }

        private int getBufferOffset(long l) {
            return (int)(l & (long)BUFFER_SIZE_MASK);
        }
    }

    private static class MemoryMappedData
    implements Data {
        MappedByteBuffer buf;

        MemoryMappedData(RandomAccessFile randomAccessFile, long l) throws IOException {
            FileChannel fileChannel = randomAccessFile.getChannel();
            this.buf = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, l);
            fileChannel.close();
        }

        @Override
        public byte getByte(long l) {
            return this.buf.get((int)l);
        }

        @Override
        public int getInt(long l) {
            return this.buf.getInt((int)l);
        }

        @Override
        public long getLong(long l) {
            return this.buf.getLong((int)l);
        }

        @Override
        public void putByte(long l, byte by) {
            this.buf.put((int)l, by);
        }

        @Override
        public void putInt(long l, int n) {
            this.buf.putInt((int)l, n);
        }

        @Override
        public void putLong(long l, long l2) {
            this.buf.putLong((int)l, l2);
        }
    }

    private class FileData
    implements Data {
        RandomAccessFile file;
        byte[] buf;
        boolean bufferModified;
        long offset;
        static final int BUFFER_SIZE = 128;

        FileData(RandomAccessFile randomAccessFile, long l) throws IOException {
            this.file = randomAccessFile;
            this.buf = new byte[AbstractLongMap.this.ENTRY_SIZE * 128];
        }

        @Override
        public synchronized byte getByte(long l) {
            int n = this.loadBufferIfNeeded(l);
            return this.buf[n];
        }

        @Override
        public synchronized int getInt(long l) {
            int n = this.loadBufferIfNeeded(l);
            int n2 = this.buf[n++] & 0xFF;
            int n3 = this.buf[n++] & 0xFF;
            int n4 = this.buf[n++] & 0xFF;
            int n5 = this.buf[n] & 0xFF;
            return (n2 << 24) + (n3 << 16) + (n4 << 8) + (n5 << 0);
        }

        @Override
        public synchronized long getLong(long l) {
            int n = this.loadBufferIfNeeded(l);
            return ((long)this.buf[n++] << 56) + ((long)(this.buf[n++] & 0xFF) << 48) + ((long)(this.buf[n++] & 0xFF) << 40) + ((long)(this.buf[n++] & 0xFF) << 32) + ((long)(this.buf[n++] & 0xFF) << 24) + (long)((this.buf[n++] & 0xFF) << 16) + (long)((this.buf[n++] & 0xFF) << 8) + (long)((this.buf[n++] & 0xFF) << 0);
        }

        @Override
        public synchronized void putByte(long l, byte by) {
            int n = this.loadBufferIfNeeded(l);
            this.buf[n] = by;
            this.bufferModified = true;
        }

        @Override
        public synchronized void putInt(long l, int n) {
            int n2 = this.loadBufferIfNeeded(l);
            this.buf[n2++] = (byte)(n >>> 24);
            this.buf[n2++] = (byte)(n >>> 16);
            this.buf[n2++] = (byte)(n >>> 8);
            this.buf[n2++] = (byte)(n >>> 0);
            this.bufferModified = true;
        }

        @Override
        public synchronized void putLong(long l, long l2) {
            int n = this.loadBufferIfNeeded(l);
            this.buf[n++] = (byte)(l2 >>> 56);
            this.buf[n++] = (byte)(l2 >>> 48);
            this.buf[n++] = (byte)(l2 >>> 40);
            this.buf[n++] = (byte)(l2 >>> 32);
            this.buf[n++] = (byte)(l2 >>> 24);
            this.buf[n++] = (byte)(l2 >>> 16);
            this.buf[n++] = (byte)(l2 >>> 8);
            this.buf[n++] = (byte)(l2 >>> 0);
            this.bufferModified = true;
        }

        private int loadBufferIfNeeded(long l) {
            int n = (int)(l % (long)(AbstractLongMap.this.ENTRY_SIZE * 128));
            long l2 = l - (long)n;
            if (this.offset != l2) {
                try {
                    if (this.bufferModified) {
                        this.file.seek(this.offset);
                        this.file.write(this.buf, 0, this.getBufferSize(this.offset));
                        this.bufferModified = false;
                    }
                    this.file.seek(l2);
                    this.file.readFully(this.buf, 0, this.getBufferSize(l2));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.offset = l2;
            }
            return n;
        }

        private int getBufferSize(long l) {
            int n = this.buf.length;
            if (AbstractLongMap.this.fileSize - l < (long)this.buf.length) {
                n = (int)(AbstractLongMap.this.fileSize - l);
            }
            return n;
        }
    }

    static interface Data {
        public byte getByte(long var1);

        public int getInt(long var1);

        public long getLong(long var1);

        public void putByte(long var1, byte var3);

        public void putInt(long var1, int var3);

        public void putLong(long var1, long var3);
    }

    abstract class Entry {
        Entry() {
        }
    }
}

