/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.settings;

import java.io.IOException;
import java.util.Collections;
import java.util.EventListener;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.util.lookup.implspi.NamedServicesProvider;

public final class RecognizeInstanceObjects
extends NamedServicesProvider {
    private static final Logger LOG = Logger.getLogger(RecognizeInstanceObjects.class.getName());

    public <T> T lookupObject(String string, Class<T> clazz) {
        FileObject fileObject = FileUtil.getConfigFile((String)string);
        if (fileObject != null) {
            try {
                InstanceCookie instanceCookie = (InstanceCookie)DataObject.find((FileObject)fileObject).getLookup().lookup(InstanceCookie.class);
                Object object = instanceCookie != null ? instanceCookie.instanceCreate() : null;
                return clazz.isInstance(object) ? (T)clazz.cast(object) : null;
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Cannot create instance for " + string, iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.log(Level.INFO, "Cannot create instance for " + string, classNotFoundException);
            }
        }
        return null;
    }

    public Lookup create(String string) {
        return new OverObjects(string);
    }

    private static final class OverObjects
    extends ProxyLookup
    implements LookupListener,
    FileChangeListener {
        private static Lookup.Result<ClassLoader> CL = Lookup.getDefault().lookupResult(ClassLoader.class);
        private final String path;

        public OverObjects(String string) {
            block2: {
                super(OverObjects.delegates(string));
                this.path = string;
                CL.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), CL));
                try {
                    FileSystem fileSystem = FileUtil.getConfigRoot().getFileSystem();
                    fileSystem.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fileSystem));
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)fileStateInvalidException);
                }
            }
        }

        private static Lookup[] delegates(String string) {
            ClassLoader classLoader;
            Set<ClassLoader> set = CL.allInstances();
            LOG.log(Level.FINEST, "allCL: {0}", set);
            if (set.isEmpty()) {
                classLoader = Thread.currentThread().getContextClassLoader();
                LOG.log(Level.FINEST, "ccl: {0}", classLoader);
                if (classLoader != null) {
                    set = Collections.singleton(classLoader);
                }
            }
            if (set.isEmpty()) {
                set = Collections.singleton(RecognizeInstanceObjects.class.getClassLoader());
            }
            LOG.log(Level.FINER, "metaInfServices for {0}", set);
            classLoader = Lookups.metaInfServices((ClassLoader)((ClassLoader)set.iterator().next()), (String)("META-INF/namedservices/" + string));
            FileObject fileObject = FileUtil.getConfigFile((String)string);
            if (fileObject == null) {
                return new Lookup[]{classLoader};
            }
            String string2 = string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
            return new Lookup[]{new FolderLookup((DataObject.Container)DataFolder.findFolder((FileObject)fileObject), string2).getLookup(), classLoader};
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.setLookups(OverObjects.delegates(this.path));
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.ch(fileEvent);
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.ch(fileEvent);
        }

        public void fileChanged(FileEvent fileEvent) {
            this.ch(fileEvent);
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.ch(fileEvent);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.ch((FileEvent)fileRenameEvent);
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            this.ch((FileEvent)fileAttributeEvent);
        }

        private void ch(FileEvent fileEvent) {
            if ((fileEvent.getFile().getPath() + "/").startsWith(this.path)) {
                this.setLookups(OverObjects.delegates(this.path));
            }
        }
    }
}

