/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.progress.spi;

import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.progress.spi.InternalHandle;

public final class TaskModel {
    private DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
    private DefaultListModel model = new DefaultListModel();
    private InternalHandle explicit;

    public void addHandle(InternalHandle internalHandle) {
        this.model.addElement(internalHandle);
        this.updateSelection();
    }

    public void removeHandle(InternalHandle internalHandle) {
        if (this.explicit == internalHandle) {
            this.explicit = null;
        }
        this.model.removeElement(internalHandle);
        this.updateSelection();
    }

    void updateSelection() {
        if (this.explicit != null) {
            return;
        }
        InternalHandle internalHandle = this.getSelectedHandle();
        if (internalHandle != null && !internalHandle.isInSleepMode()) {
            return;
        }
        InternalHandle internalHandle2 = null;
        for (int i = 0; i < this.model.size(); ++i) {
            InternalHandle internalHandle3 = (InternalHandle)this.model.getElementAt(i);
            if (this.getSelectionRating(internalHandle3) < this.getSelectionRating(internalHandle2)) continue;
            internalHandle2 = internalHandle3;
        }
        if (internalHandle2 != null) {
            this.selectionModel.setSelectionInterval(this.model.indexOf(internalHandle2), this.model.indexOf(internalHandle2));
        } else {
            this.selectionModel.clearSelection();
        }
    }

    private int getSelectionRating(InternalHandle internalHandle) {
        int n = 0;
        if (internalHandle != null) {
            if (!internalHandle.isInSleepMode()) {
                n += 4;
            }
            if (internalHandle.isUserInitialized()) {
                n += 2;
            }
            ++n;
        }
        return n;
    }

    public void explicitlySelect(InternalHandle internalHandle) {
        this.explicit = internalHandle;
        int n = this.model.indexOf(this.explicit);
        if (n == -1) {
            // empty if block
        }
        this.selectionModel.setSelectionInterval(n, n);
    }

    public InternalHandle getExplicitSelection() {
        return this.explicit;
    }

    public int getSize() {
        return this.model.size();
    }

    public InternalHandle[] getHandles() {
        Object[] objectArray = new InternalHandle[this.model.size()];
        this.model.copyInto(objectArray);
        return objectArray;
    }

    public InternalHandle getSelectedHandle() {
        int n = this.selectionModel.getMinSelectionIndex();
        if (n != -1 && n >= 0 && n < this.model.size()) {
            return (InternalHandle)this.model.getElementAt(this.selectionModel.getMinSelectionIndex());
        }
        return null;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.selectionModel.addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.selectionModel.removeListSelectionListener(listSelectionListener);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.model.addListDataListener(listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.model.removeListDataListener(listDataListener);
    }
}

