/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.PrintStream;
import java.security.SecureRandom;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;

final class RandomCookie {
    byte[] random_bytes;

    RandomCookie(SecureRandom secureRandom) {
        long l = System.currentTimeMillis() / 1000L;
        int n = l < Integer.MAX_VALUE ? (int)l : Integer.MAX_VALUE;
        this.random_bytes = new byte[32];
        secureRandom.nextBytes(this.random_bytes);
        this.random_bytes[0] = (byte)(n >> 24);
        this.random_bytes[1] = (byte)(n >> 16);
        this.random_bytes[2] = (byte)(n >> 8);
        this.random_bytes[3] = (byte)n;
    }

    RandomCookie(HandshakeInStream handshakeInStream) throws IOException {
        this.random_bytes = new byte[32];
        handshakeInStream.read(this.random_bytes, 0, 32);
    }

    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        handshakeOutStream.write(this.random_bytes, 0, 32);
    }

    void print(PrintStream printStream) {
        int n = this.random_bytes[0] << 24;
        n += this.random_bytes[1] << 16;
        n += this.random_bytes[2] << 8;
        printStream.print("GMT: " + (n += this.random_bytes[3]) + " ");
        printStream.print("bytes = { ");
        for (int i = 4; i < 32; ++i) {
            if (i != 4) {
                printStream.print(", ");
            }
            printStream.print(this.random_bytes[i] & 0xFF);
        }
        printStream.println(" }");
    }
}

