/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.openide.filesystems.declmime.MIMEResolverImpl;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public abstract class MIMEResolver {
    private String[] resolvableMIMETypes = null;

    public MIMEResolver(String ... stringArray) {
        Parameters.notNull((CharSequence)"mimeTypes", (Object)stringArray);
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("The mimeTypes parameter cannot be empty array.");
        }
        for (String string : stringArray) {
            if (string != null && string.length() != 0) continue;
            throw new IllegalArgumentException("The item in mimeTypes parameter cannot be null nor empty String.");
        }
        this.resolvableMIMETypes = stringArray;
    }

    @Deprecated
    public MIMEResolver() {
    }

    public abstract String findMIMEType(FileObject var1);

    String[] getMIMETypes() {
        return this.resolvableMIMETypes;
    }

    public abstract class UIHelpers {
        protected UIHelpers() {
            if (this.getClass().getName().equals("org.netbeans.core.ui.options.filetypes.FileAssociationsModel")) {
                return;
            }
            throw new IllegalStateException();
        }

        protected final void storeUserDefinedResolver(Map<String, Set<String>> map) {
            MIMEResolverImpl.storeUserDefinedResolver(map);
        }

        protected final Collection<? extends FileObject> getOrderedResolvers() {
            return MIMEResolverImpl.getOrderedResolvers();
        }

        protected final boolean isUserDefined(FileObject fileObject) {
            return MIMEResolverImpl.isUserDefined(fileObject);
        }

        protected final Map<String, Set<String>> getMIMEToExtensions(FileObject fileObject) {
            return MIMEResolverImpl.getMIMEToExtensions(fileObject);
        }
    }
}

