/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.internal.toolkit.builders;

import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.PackageSummaryWriter;
import com.javafx.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.LayoutParser;
import com.javafx.tools.doclets.internal.toolkit.builders.XMLNode;
import com.javafx.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Tag;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class PackageSummaryBuilder
extends AbstractBuilder {
    public static final String ROOT = "PackageDoc";
    private PackageDoc packageDoc;
    private PackageSummaryWriter packageWriter;
    private Content contentTree;

    private PackageSummaryBuilder(Configuration configuration) {
        super(configuration);
    }

    public static PackageSummaryBuilder getInstance(Configuration configuration, PackageDoc pkg, PackageSummaryWriter packageWriter) {
        PackageSummaryBuilder builder = new PackageSummaryBuilder(configuration);
        builder.packageDoc = pkg;
        builder.packageWriter = packageWriter;
        return builder;
    }

    public void build() throws IOException {
        if (this.packageWriter == null) {
            return;
        }
        this.build(LayoutParser.getInstance(this.configuration).parseXML(ROOT), this.contentTree);
    }

    public String getName() {
        return ROOT;
    }

    public void buildPackageDoc(XMLNode node, Content contentTree) throws Exception {
        contentTree = this.packageWriter.getPackageHeader(Util.getPackageName(this.packageDoc));
        this.buildChildren(node, contentTree);
        this.packageWriter.addPackageFooter(contentTree);
        this.packageWriter.printDocument(contentTree);
        this.packageWriter.close();
        Util.copyDocFiles(this.configuration, Util.getPackageSourcePath(this.configuration, this.packageDoc), DirectoryManager.getDirectoryPath(this.packageDoc) + File.separator + "doc-files", true);
    }

    public void buildContent(XMLNode node, Content contentTree) {
        Content packageContentTree = this.packageWriter.getContentHeader();
        this.buildChildren(node, packageContentTree);
        contentTree.addContent(packageContentTree);
    }

    public void buildSummary(XMLNode node, Content packageContentTree) {
        Content summaryContentTree = this.packageWriter.getSummaryHeader();
        this.buildChildren(node, summaryContentTree);
        packageContentTree.addContent(summaryContentTree);
    }

    public void buildInterfaceSummary(XMLNode node, Content summaryContentTree) {
        String interfaceTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Interface_Summary"), this.configuration.getText("doclet.interfaces"));
        String[] interfaceTableHeader = new String[]{this.configuration.getText("doclet.Interface"), this.configuration.getText("doclet.Description")};
        ClassDoc[] interfaces = this.packageDoc.isIncluded() ? this.packageDoc.interfaces() : this.configuration.classDocCatalog.interfaces(Util.getPackageName(this.packageDoc));
        if ((interfaces = PackageSummaryBuilder.filterOutPrivateClasses(interfaces)).length > 0) {
            this.packageWriter.addClassesSummary(interfaces, this.configuration.getText("doclet.Interface_Summary"), interfaceTableSummary, interfaceTableHeader, summaryContentTree);
        }
    }

    public void buildClassSummary(XMLNode node, Content summaryContentTree) {
        String classTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Class_Summary"), this.configuration.getText("doclet.classes"));
        String[] classTableHeader = new String[]{this.configuration.getText("doclet.Class"), this.configuration.getText("doclet.Description")};
        ClassDoc[] classes = this.packageDoc.isIncluded() ? this.packageDoc.ordinaryClasses() : this.configuration.classDocCatalog.ordinaryClasses(Util.getPackageName(this.packageDoc));
        if ((classes = PackageSummaryBuilder.filterOutPrivateClasses(classes)).length > 0) {
            this.packageWriter.addClassesSummary(classes, this.configuration.getText("doclet.Class_Summary"), classTableSummary, classTableHeader, summaryContentTree);
        }
    }

    public void buildEnumSummary(XMLNode node, Content summaryContentTree) {
        String enumTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Enum_Summary"), this.configuration.getText("doclet.enums"));
        String[] enumTableHeader = new String[]{this.configuration.getText("doclet.Enum"), this.configuration.getText("doclet.Description")};
        ClassDoc[] enums = this.packageDoc.isIncluded() ? this.packageDoc.enums() : this.configuration.classDocCatalog.enums(Util.getPackageName(this.packageDoc));
        if ((enums = PackageSummaryBuilder.filterOutPrivateClasses(enums)).length > 0) {
            this.packageWriter.addClassesSummary(enums, this.configuration.getText("doclet.Enum_Summary"), enumTableSummary, enumTableHeader, summaryContentTree);
        }
    }

    public void buildExceptionSummary(XMLNode node, Content summaryContentTree) {
        String exceptionTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Exception_Summary"), this.configuration.getText("doclet.exceptions"));
        String[] exceptionTableHeader = new String[]{this.configuration.getText("doclet.Exception"), this.configuration.getText("doclet.Description")};
        ClassDoc[] exceptions = this.packageDoc.isIncluded() ? this.packageDoc.exceptions() : this.configuration.classDocCatalog.exceptions(Util.getPackageName(this.packageDoc));
        if ((exceptions = PackageSummaryBuilder.filterOutPrivateClasses(exceptions)).length > 0) {
            this.packageWriter.addClassesSummary(exceptions, this.configuration.getText("doclet.Exception_Summary"), exceptionTableSummary, exceptionTableHeader, summaryContentTree);
        }
    }

    public void buildErrorSummary(XMLNode node, Content summaryContentTree) {
        String errorTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Error_Summary"), this.configuration.getText("doclet.errors"));
        String[] errorTableHeader = new String[]{this.configuration.getText("doclet.Error"), this.configuration.getText("doclet.Description")};
        ClassDoc[] errors = this.packageDoc.isIncluded() ? this.packageDoc.errors() : this.configuration.classDocCatalog.errors(Util.getPackageName(this.packageDoc));
        if ((errors = PackageSummaryBuilder.filterOutPrivateClasses(errors)).length > 0) {
            this.packageWriter.addClassesSummary(errors, this.configuration.getText("doclet.Error_Summary"), errorTableSummary, errorTableHeader, summaryContentTree);
        }
    }

    public void buildAnnotationTypeSummary(XMLNode node, Content summaryContentTree) {
        String annotationtypeTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Annotation_Types_Summary"), this.configuration.getText("doclet.annotationtypes"));
        String[] annotationtypeTableHeader = new String[]{this.configuration.getText("doclet.AnnotationType"), this.configuration.getText("doclet.Description")};
        AnnotationTypeDoc[] annotationTypes = this.packageDoc.isIncluded() ? this.packageDoc.annotationTypes() : this.configuration.classDocCatalog.annotationTypes(Util.getPackageName(this.packageDoc));
        if ((annotationTypes = PackageSummaryBuilder.filterOutPrivateClasses((ClassDoc[])annotationTypes)).length > 0) {
            this.packageWriter.addClassesSummary((ClassDoc[])annotationTypes, this.configuration.getText("doclet.Annotation_Types_Summary"), annotationtypeTableSummary, annotationtypeTableHeader, summaryContentTree);
        }
    }

    public void buildPackageDescription(XMLNode node, Content packageContentTree) {
        if (this.configuration.nocomment) {
            return;
        }
        this.packageWriter.addPackageDescription(packageContentTree);
    }

    public void buildPackageTags(XMLNode node, Content packageContentTree) {
        if (this.configuration.nocomment) {
            return;
        }
        this.packageWriter.addPackageTags(packageContentTree);
    }

    public static ClassDoc[] filterOutPrivateClasses(ClassDoc[] classes) {
        if (!Configuration.javafxJavadoc) {
            return classes;
        }
        ArrayList<ClassDoc> filteredOutClasses = new ArrayList<ClassDoc>(classes.length);
        for (ClassDoc classDoc : classes) {
            Tag[] aspTags;
            if (classDoc.isPrivate() || classDoc.isPackagePrivate() || (aspTags = classDoc.tags("treatAsPrivate")) != null && aspTags.length > 0) continue;
            filteredOutClasses.add(classDoc);
        }
        return filteredOutClasses.toArray(new ClassDoc[0]);
    }
}

