/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.watcher;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.providers.AnnotationProvider;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.netbeans.modules.masterfs.watcher.FOFile;
import org.netbeans.modules.masterfs.watcher.Notifier;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class Watcher
extends AnnotationProvider {
    static final Logger LOG = Logger.getLogger(Watcher.class.getName());
    private static final Map<FileObject, int[]> MODIFIED = new WeakHashMap<FileObject, int[]>();
    private Ext<?> ext;
    private final Object lock = new Object();
    private Set<FileObject> pending;
    private static RequestProcessor RP = new RequestProcessor("Pending refresh", 1);
    private RequestProcessor.Task refreshTask = RP.create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Set set;
            Iterator iterator = Watcher.this.lock;
            synchronized (iterator) {
                set = Watcher.this.pending;
                Watcher.this.pending = null;
            }
            LOG.log(Level.FINE, "Refreshing {0} directories", set.size());
            for (FileObject fileObject : set) {
                if (Watcher.isLocked(fileObject)) {
                    Watcher.this.enqueue(fileObject);
                    continue;
                }
                LOG.log(Level.FINEST, "Refreshing {0}", fileObject);
                fileObject.refresh();
            }
            LOG.fine("Refresh finished");
        }
    });

    public Watcher() {
        if (Boolean.getBoolean("org.netbeans.modules.masterfs.watcher.disable")) {
            this.ext = null;
            return;
        }
        this.ext = this.make(Watcher.getNotifierForPlatform());
    }

    final void installNotifier(Notifier<?> notifier) {
        this.ext = this.make(notifier);
    }

    private static Ext<?> ext() {
        Watcher watcher = (Watcher)Lookup.getDefault().lookup(Watcher.class);
        return watcher == null ? null : watcher.ext;
    }

    public static boolean isEnabled() {
        return Watcher.ext() != null;
    }

    public static boolean isWatched(FileObject fileObject) {
        Ext<?> ext = Watcher.ext();
        if (ext == null) {
            return false;
        }
        if (fileObject.isData()) {
            fileObject = fileObject.getParent();
        }
        return ((Ext)ext).isWatched(fileObject);
    }

    public static void register(FileObject fileObject) {
        Ext<?> ext = Watcher.ext();
        if (ext == null) {
            return;
        }
        if (fileObject.isData()) {
            fileObject = fileObject.getParent();
        }
        ext.register(fileObject);
    }

    public static void unregister(FileObject fileObject) {
        Ext<?> ext = Watcher.ext();
        if (ext == null) {
            return;
        }
        if (fileObject.isData()) {
            fileObject = fileObject.getParent();
        }
        ext.unregister(fileObject);
    }

    public static File wrap(File file, FileObject fileObject) {
        if (file instanceof FOFile) {
            return file;
        }
        return new FOFile(file, fileObject);
    }

    @Override
    public String annotateName(String string, Set<? extends FileObject> set) {
        return null;
    }

    @Override
    public Image annotateIcon(Image image, int n, Set<? extends FileObject> set) {
        return null;
    }

    @Override
    public String annotateNameHtml(String string, Set<? extends FileObject> set) {
        return null;
    }

    @Override
    public Action[] actions(Set<? extends FileObject> set) {
        return null;
    }

    @Override
    public InterceptionListener getInterceptionListener() {
        return this.ext;
    }

    public void shutdown() {
        if (this.ext != null) {
            try {
                this.ext.shutdown();
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Error on shutdown", iOException);
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.INFO, "Error on shutdown", interruptedException);
            }
        }
    }

    private <KEY> Ext<KEY> make(Notifier<KEY> notifier) {
        return notifier == null ? null : new Ext<KEY>(notifier);
    }

    final void clearQueue() throws IOException {
        this.ext.clearQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(FileObject fileObject) {
        assert (fileObject != null);
        Object object = this.lock;
        synchronized (object) {
            if (this.pending == null) {
                this.refreshTask.schedule(1500);
                this.pending = new HashSet<FileObject>();
            }
            this.pending.add(fileObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueAll(Set<FileObject> set) {
        assert (set != null);
        assert (!set.contains(null)) : "No nulls";
        Object object = this.lock;
        synchronized (object) {
            if (this.pending == null) {
                this.refreshTask.schedule(1500);
                this.pending = new HashSet<FileObject>();
            }
            this.pending.addAll(set);
        }
    }

    private static Notifier<?> getNotifierForPlatform() {
        return null;
    }

    public static synchronized void lock(FileObject fileObject) {
        int[] nArray = MODIFIED.get(fileObject);
        if (nArray == null) {
            nArray = new int[]{0};
            MODIFIED.put(fileObject, nArray);
        }
        nArray[0] = nArray[0] + 1;
    }

    private static synchronized boolean isLocked(FileObject fileObject) {
        return MODIFIED.get(fileObject) != null;
    }

    public static synchronized void unlock(FileObject fileObject) {
        int[] nArray = MODIFIED.get(fileObject);
        if (nArray == null) {
            return;
        }
        nArray[0] = nArray[0] - 1;
        if (nArray[0] == 0) {
            MODIFIED.remove(fileObject);
        }
    }

    private class Ext<KEY>
    extends ProvidedExtensions
    implements Runnable {
        private final ReferenceQueue<FileObject> REF = new ReferenceQueue();
        private final Notifier<KEY> impl;
        private final Object LOCK = new Object();
        private final Set<Notifier.KeyRef> references = new HashSet<Notifier.KeyRef>();
        private final Thread watcher;
        private volatile boolean shutdown;

        public Ext(Notifier<KEY> notifier) {
            this.impl = notifier;
            this.watcher = new Thread((Runnable)this, "File Watcher");
            this.watcher.start();
        }

        @Override
        public long refreshRecursively(File file, long l, List<? super File> list) {
            assert (file instanceof FOFile);
            FileObject fileObject = ((FOFile)file).fo;
            if (fileObject == null && !file.exists()) {
                return -1L;
            }
            assert (fileObject != null) : "No fileobject for " + file;
            this.register(fileObject);
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isWatched(FileObject fileObject) {
            assert (fileObject.isFolder()) : "Should be a folder: " + fileObject;
            try {
                this.clearQueue();
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Exception while clearing the queue", iOException);
            }
            Object object = this.LOCK;
            synchronized (object) {
                Notifier<KEY> notifier = this.impl;
                notifier.getClass();
                Notifier.KeyRef keyRef = notifier.new Notifier.KeyRef(fileObject, null, null);
                return this.getReferences().contains(keyRef);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void register(FileObject fileObject) {
            if (fileObject.isValid()) assert (fileObject.isFolder()) : "Should be a folder: " + fileObject + " data: " + fileObject.isData();
            try {
                this.clearQueue();
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Exception while clearing the queue", iOException);
            }
            Object object = this.LOCK;
            synchronized (object) {
                Notifier<KEY> notifier = this.impl;
                notifier.getClass();
                Notifier.KeyRef keyRef = notifier.new Notifier.KeyRef(fileObject, null, null);
                if (this.getReferences().contains(keyRef)) {
                    return;
                }
                try {
                    Set<Notifier.KeyRef> set = this.getReferences();
                    Notifier<KEY> notifier2 = this.impl;
                    notifier2.getClass();
                    set.add(notifier2.new Notifier.KeyRef(fileObject, this.impl.addWatch(fileObject.getPath()), this.REF));
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, "Cannot add filesystem watch for {0}: {1}", new Object[]{fileObject.getPath(), iOException});
                    LOG.log(Level.FINE, null, iOException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void unregister(FileObject fileObject) {
            assert (fileObject.isFolder()) : "Should be a folder: " + fileObject;
            Object object = this.LOCK;
            synchronized (object) {
                final Notifier.KeyRef[] keyRefArray = new Notifier.KeyRef[1];
                Notifier<KEY> notifier = this.impl;
                notifier.getClass();
                Notifier.KeyRef keyRef = new Notifier.KeyRef(notifier, fileObject, null, null){
                    {
                        Notifier notifier2 = notifier;
                        notifier2.getClass();
                        super(fileObject, object, referenceQueue);
                    }

                    @Override
                    public boolean equals(Object object) {
                        if (super.equals(object)) {
                            keyRefArray[0] = (Notifier.KeyRef)object;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public int hashCode() {
                        return super.hashCode();
                    }
                };
                if (!this.references.contains(keyRef)) {
                    return;
                }
                assert (keyRefArray[0] != null);
                this.getReferences().remove(keyRefArray[0]);
                try {
                    keyRefArray[0].removeWatch();
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, "Cannot remove filesystem watch for {0}", fileObject.getPath());
                    LOG.log(Level.INFO, "Exception", iOException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void clearQueue() throws IOException {
            Notifier.KeyRef keyRef;
            while ((keyRef = (Notifier.KeyRef)this.REF.poll()) != null) {
                Object object = this.LOCK;
                synchronized (object) {
                    this.getReferences().remove(keyRef);
                    keyRef.removeWatch();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.shutdown) {
                try {
                    Object object;
                    Object object3;
                    Serializable serializable;
                    this.clearQueue();
                    String string = this.impl.nextEvent();
                    LOG.log(Level.FINEST, "nextEvent: {0}", string);
                    if (string == null) {
                        serializable = new HashSet();
                        object3 = this.LOCK;
                        synchronized (object3) {
                            for (Notifier.KeyRef keyRef : this.getReferences()) {
                                object = keyRef.get();
                                if (object == null) continue;
                                serializable.add(object);
                            }
                        }
                        Watcher.this.enqueueAll((Set)((Object)serializable));
                        continue;
                    }
                    serializable = new File(string);
                    object3 = FileObjectFactory.getInstance(serializable);
                    Object object4 = ((FileObjectFactory)object3).getCachedOnly((File)serializable);
                    if (object4 == null) {
                        object4 = ((FileObjectFactory)object3).getCachedOnly(((File)serializable).getParentFile());
                    }
                    if (object4 == null) continue;
                    Object object2 = this.LOCK;
                    synchronized (object2) {
                        Notifier<KEY> notifier = this.impl;
                        notifier.getClass();
                        object = notifier.new Notifier.KeyRef((FileObject)object4, null, null);
                        if (this.getReferences().contains(object)) {
                            Watcher.this.enqueue(object4);
                        }
                    }
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (InterruptedException interruptedException) {
                    if (this.shutdown) continue;
                    LOG.log(Level.INFO, "Interrupted", interruptedException);
                }
                catch (Throwable throwable) {
                    LOG.log(Level.INFO, "Error dispatching FS changes", throwable);
                }
            }
        }

        final void shutdown() throws IOException, InterruptedException {
            this.shutdown = true;
            this.watcher.interrupt();
            this.impl.stop();
            this.watcher.join(1000L);
        }

        private Set<Notifier.KeyRef> getReferences() {
            assert (Thread.holdsLock(this.LOCK));
            return this.references;
        }
    }
}

