/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.api.nodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.selector.api.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.api.nodes.ProjectLibrariesNode;
import org.netbeans.modules.profiler.selector.api.nodes.ProjectSourcesNode;
import org.netbeans.modules.profiler.selector.api.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.api.nodes.SelectorNode;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class ProjectNode
extends ContainerNode {
    private final Lookup.Provider project;

    public ProjectNode(Lookup.Provider provider, ContainerNode containerNode) {
        super(ProjectUtilities.getDisplayName((Lookup.Provider)provider), ProjectUtilities.getIcon((Lookup.Provider)provider), containerNode, (Lookup)new ProxyLookup(new Lookup[]{provider.getLookup(), Lookups.singleton((Object)provider)}));
        this.project = provider;
    }

    public ProjectNode(Lookup.Provider provider) {
        this(provider, null);
    }

    @Override
    public Collection<ClientUtils.SourceCodeSelection> getRootMethods(boolean bl) {
        ArrayList<ClientUtils.SourceCodeSelection> arrayList = new ArrayList<ClientUtils.SourceCodeSelection>();
        Enumeration enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            arrayList.addAll(((SelectorNode)((Object)enumeration.nextElement())).getRootMethods(bl));
        }
        return arrayList;
    }

    @Override
    protected SelectorChildren getChildren() {
        return new Children(false);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.project.equals(((ProjectNode)((Object)object)).project);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.project != null ? this.project.hashCode() : 0);
    }

    private static class Children
    extends SelectorChildren<ProjectNode> {
        private final boolean includeSubprojects;

        public Children(boolean bl) {
            this.includeSubprojects = bl;
        }

        @Override
        protected List<SelectorNode> prepareChildren(ProjectNode projectNode) {
            ArrayList<SelectorNode> arrayList = new ArrayList<SelectorNode>(2);
            arrayList.add(new ProjectSourcesNode(this.includeSubprojects, projectNode));
            arrayList.add(new ProjectLibrariesNode(this.includeSubprojects, projectNode));
            return arrayList;
        }
    }
}

