/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import java.io.File;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;

public class NativeLibLoader {
    private static final HashSet<String> loaded = new HashSet();
    private static boolean verbose = false;
    private static File libDir = null;
    private static String libPrefix = "";
    private static String libSuffix = "";
    private static String libSuffixAlt = null;

    public static synchronized void loadLibrary(String string) {
        if (!loaded.contains(string)) {
            NativeLibLoader.loadLibraryInternal(string);
            loaded.add(string);
        }
    }

    private static String[] initializePath(String string) {
        String string2 = System.getProperty(string, "");
        String string3 = File.pathSeparator;
        int n = string2.length();
        int n2 = string2.indexOf(string3);
        int n3 = 0;
        while (n2 >= 0) {
            ++n3;
            n2 = string2.indexOf(string3, n2 + 1);
        }
        String[] stringArray = new String[n3 + 1];
        n2 = 0;
        n3 = 0;
        int n4 = string2.indexOf(string3);
        while (n4 >= 0) {
            if (n4 - n2 > 0) {
                stringArray[n3++] = string2.substring(n2, n4);
            } else if (n4 - n2 == 0) {
                stringArray[n3++] = ".";
            }
            n2 = n4 + 1;
            n4 = string2.indexOf(string3, n2);
        }
        stringArray[n3] = string2.substring(n2, n);
        return stringArray;
    }

    private static void loadLibraryInternal(String string) {
        try {
            NativeLibLoader.loadLibraryFullPath(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String[] stringArray = NativeLibLoader.initializePath("java.library.path");
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    String string2 = stringArray[i];
                    if (!string2.endsWith(File.separator)) {
                        string2 = string2 + File.separator;
                    }
                    String string3 = System.mapLibraryName(string);
                    File file = new File(string2 + string3);
                    System.load(file.getAbsolutePath());
                    if (verbose) {
                        System.err.println("WARNING: " + unsatisfiedLinkError.toString());
                        System.err.println("    using System.loadLibrary(" + string + ") as a fallback");
                    }
                    return;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                    continue;
                }
            }
            try {
                System.loadLibrary(string);
                if (verbose) {
                    System.err.println("WARNING: " + unsatisfiedLinkError.toString());
                    System.err.println("    using System.loadLibrary(" + string + ") as a fallback");
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError3) {
                throw unsatisfiedLinkError;
            }
        }
    }

    private static void loadLibraryFullPath(String string) {
        block20: {
            try {
                Object object;
                Class<NativeLibLoader> clazz;
                if (libDir == null) {
                    clazz = NativeLibLoader.class;
                    object = "NativeLibLoader.class";
                    String string2 = clazz.getResource((String)object).toString();
                    if (!string2.startsWith("jar:file:") || string2.indexOf(33) == -1) {
                        throw new UnsatisfiedLinkError("Invalid URL for class: " + string2);
                    }
                    String string3 = string2.substring(4, string2.lastIndexOf(33));
                    int n = Math.max(string3.lastIndexOf(47), string3.lastIndexOf(92));
                    String string4 = System.getProperty("os.name");
                    boolean bl = System.getProperty("sun.arch.data.model", "").startsWith("64");
                    String string5 = null;
                    if (string4.startsWith("Windows")) {
                        string5 = "../bin";
                    } else if (string4.startsWith("Mac")) {
                        string5 = ".";
                    } else if (string4.startsWith("Linux")) {
                        string5 = bl ? "amd64" : "i386";
                    }
                    String string6 = string3.substring(0, n) + "/" + string5;
                    libDir = new File(new URI(string6).getPath());
                    if (string4.startsWith("Windows")) {
                        File file;
                        if (bl && (file = new File(libDir, "64bit")).isDirectory()) {
                            libDir = file;
                        }
                        libPrefix = "";
                        libSuffix = ".dll";
                    } else if (string4.startsWith("Mac")) {
                        libPrefix = "lib";
                        libSuffix = ".dylib";
                        libSuffixAlt = ".jnilib";
                    } else if (string4.startsWith("Linux")) {
                        libPrefix = "lib";
                        libSuffix = ".so";
                    }
                }
                object = new File(libDir, libPrefix + string + libSuffix);
                clazz = ((File)object).getCanonicalPath();
                try {
                    System.load((String)((Object)clazz));
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    if (libSuffixAlt != null) {
                        try {
                            object = new File(libDir, libPrefix + string + libSuffixAlt);
                            clazz = ((File)object).getAbsolutePath();
                            System.load((String)((Object)clazz));
                            break block20;
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                            throw unsatisfiedLinkError;
                        }
                    }
                    throw unsatisfiedLinkError;
                }
            }
            catch (Exception exception) {
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError().initCause(exception);
            }
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                verbose = Boolean.getBoolean("javafx.verbose");
                return null;
            }
        });
    }
}

