/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public final class HelpCtx {
    private static final Logger err = Logger.getLogger("org.openide.util.HelpCtx");
    public static final HelpCtx DEFAULT_HELP = new HelpCtx(HelpCtx.class.getName() + ".DEFAULT_HELP");
    private final URL helpCtx;
    private final String helpID;

    @Deprecated
    public HelpCtx(URL uRL) {
        this.helpCtx = uRL;
        this.helpID = null;
    }

    public HelpCtx(String string) {
        this.helpID = string;
        this.helpCtx = null;
    }

    public HelpCtx(Class clazz) {
        this(clazz.getName());
    }

    public URL getHelp() {
        return this.helpCtx;
    }

    public String getHelpID() {
        return this.helpID;
    }

    public int hashCode() {
        int n = HelpCtx.class.hashCode();
        if (this.helpCtx != null) {
            n ^= this.helpCtx.hashCode();
        }
        if (this.helpID != null) {
            n ^= this.helpID.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HelpCtx helpCtx = (HelpCtx)object;
        if (!(this.helpCtx == helpCtx.helpCtx || this.helpCtx != null && this.helpCtx.equals(helpCtx.helpCtx))) {
            return false;
        }
        return !(this.helpID == null ? helpCtx.helpID != null : !this.helpID.equals(helpCtx.helpID));
    }

    public String toString() {
        if (this.helpID != null) {
            return "HelpCtx[" + this.helpID + "]";
        }
        return "HelpCtx[" + this.helpCtx + "]";
    }

    public static void setHelpIDString(JComponent jComponent, String string) {
        err.log(Level.FINE, "setHelpIDString: {0} on {1}", new Object[]{string, jComponent});
        jComponent.putClientProperty("HelpID", string);
    }

    public static HelpCtx findHelp(Component component) {
        if (err.isLoggable(Level.FINEST)) {
            err.log(Level.FINEST, "findHelp on " + component, new Exception());
        } else {
            err.log(Level.FINE, "findHelp on {0}", component);
        }
        while (component != null) {
            String string;
            Object object;
            if (component instanceof Provider) {
                object = ((Provider)((Object)component)).getHelpCtx();
                err.log(Level.FINE, "found help {0} through HelpCtx.Provider interface", object);
                return object;
            }
            if (component instanceof JComponent && (string = (String)((JComponent)(object = (JComponent)component)).getClientProperty("HelpID")) != null) {
                err.log(Level.FINE, "found help {0} by client property", string);
                return new HelpCtx(string);
            }
            component = component.getParent();
            err.log(Level.FINE, "no luck, trying parent {0}", component);
        }
        err.fine("nothing found");
        return DEFAULT_HELP;
    }

    public static HelpCtx findHelp(Object object) {
        if (object instanceof Component) {
            return HelpCtx.findHelp((Component)object);
        }
        if (object instanceof Provider) {
            return ((Provider)object).getHelpCtx();
        }
        try {
            BeanDescriptor beanDescriptor = Introspector.getBeanInfo(object.getClass()).getBeanDescriptor();
            String string = (String)beanDescriptor.getValue("helpID");
            if (string != null) {
                return new HelpCtx(string);
            }
        }
        catch (IntrospectionException introspectionException) {
            err.log(Level.FINE, "findHelp on {0}: {1}", new Object[]{object, introspectionException});
        }
        return DEFAULT_HELP;
    }

    public static interface Provider {
        public HelpCtx getHelpCtx();
    }
}

