/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui.classbrowser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import sun.jvm.hotspot.asm.CPUHelper;
import sun.jvm.hotspot.asm.CallInstruction;
import sun.jvm.hotspot.asm.DirectAddress;
import sun.jvm.hotspot.asm.Disassembler;
import sun.jvm.hotspot.asm.DummySymbolFinder;
import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.InstructionVisitor;
import sun.jvm.hotspot.asm.PCRelativeAddress;
import sun.jvm.hotspot.asm.SymbolFinder;
import sun.jvm.hotspot.asm.amd64.AMD64Helper;
import sun.jvm.hotspot.asm.ia64.IA64Helper;
import sun.jvm.hotspot.asm.sparc.SPARCHelper;
import sun.jvm.hotspot.asm.x86.X86Helper;
import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.code.ConstantDoubleValue;
import sun.jvm.hotspot.code.ConstantIntValue;
import sun.jvm.hotspot.code.ConstantLongValue;
import sun.jvm.hotspot.code.ConstantOopReadValue;
import sun.jvm.hotspot.code.Location;
import sun.jvm.hotspot.code.LocationValue;
import sun.jvm.hotspot.code.MonitorValue;
import sun.jvm.hotspot.code.NMethod;
import sun.jvm.hotspot.code.ObjectValue;
import sun.jvm.hotspot.code.PCDesc;
import sun.jvm.hotspot.code.ScopeDesc;
import sun.jvm.hotspot.code.ScopeValue;
import sun.jvm.hotspot.code.Stub;
import sun.jvm.hotspot.code.StubQueue;
import sun.jvm.hotspot.code.VMRegImpl;
import sun.jvm.hotspot.compiler.OopMap;
import sun.jvm.hotspot.compiler.OopMapSet;
import sun.jvm.hotspot.compiler.OopMapStream;
import sun.jvm.hotspot.compiler.OopMapValue;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.interpreter.Bytecode;
import sun.jvm.hotspot.interpreter.BytecodeDisassembler;
import sun.jvm.hotspot.interpreter.BytecodeGetPut;
import sun.jvm.hotspot.interpreter.BytecodeInvoke;
import sun.jvm.hotspot.interpreter.BytecodeLoadConstant;
import sun.jvm.hotspot.interpreter.BytecodeNew;
import sun.jvm.hotspot.interpreter.BytecodeVisitor;
import sun.jvm.hotspot.interpreter.Interpreter;
import sun.jvm.hotspot.interpreter.InterpreterCodelet;
import sun.jvm.hotspot.oops.AccessFlags;
import sun.jvm.hotspot.oops.CheckedExceptionElement;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.Field;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.NamedFieldIdentifier;
import sun.jvm.hotspot.oops.ObjArray;
import sun.jvm.hotspot.oops.ObjArrayKlass;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.oops.TypeArrayKlass;
import sun.jvm.hotspot.runtime.ClassConstants;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.SignatureConverter;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.runtime.VMReg;
import sun.jvm.hotspot.tools.jcore.ClassWriter;
import sun.jvm.hotspot.utilities.Assert;

public class HTMLGenerator
implements ClassConstants {
    private static final String DUMP_KLASS_OUTPUT_DIR = ".";
    private static final int NATIVE_CODE_SIZE = 200;
    private final String spaces;
    private final String tab;
    private boolean genHTML = true;
    private static CPUHelper cpuHelper;

    public HTMLGenerator() {
        this(true);
    }

    public HTMLGenerator(boolean html) {
        this.genHTML = html;
        if (html) {
            this.spaces = "&nbsp;&nbsp;";
            this.tab = "&nbsp;&nbsp;&nbsp;&nbsp;";
        } else {
            this.spaces = "  ";
            this.tab = "    ";
        }
    }

    private static synchronized void initialize() {
        String cpu = VM.getVM().getCPU();
        if (cpu.equals("sparc")) {
            cpuHelper = new SPARCHelper();
        } else if (cpu.equals("x86")) {
            cpuHelper = new X86Helper();
        } else if (cpu.equals("amd64") || cpu.equals("x86_64")) {
            cpuHelper = new AMD64Helper();
        } else if (cpu.equals("ia64")) {
            cpuHelper = new IA64Helper();
        } else {
            throw new RuntimeException("cpu '" + cpu + "' is not yet supported!");
        }
    }

    protected static synchronized CPUHelper getCPUHelper() {
        return cpuHelper;
    }

    protected String escapeHTMLSpecialChars(String value) {
        if (!this.genHTML) {
            return value;
        }
        Formatter buf = new Formatter(this.genHTML);
        int len = value.length();
        block5: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    continue block5;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block5;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block5;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public String genHTMLForMessage(String message) {
        Formatter buf = new Formatter(this.genHTML);
        buf.genHTMLPrologue(message);
        buf.genHTMLEpilogue();
        return buf.toString();
    }

    public String genHTMLErrorMessage(Exception exp) {
        exp.printStackTrace();
        return this.genHTMLForMessage(exp.getClass().getName() + " : " + exp.getMessage());
    }

    public String genHTMLForWait(String message) {
        Formatter buf = new Formatter(this.genHTML);
        buf.genHTMLPrologue("Please wait ..");
        buf.h2(message);
        return buf.toString();
    }

    protected String genKlassTitle(InstanceKlass klass) {
        Formatter buf = new Formatter(this.genHTML);
        AccessFlags acc = klass.getAccessFlagsObj();
        if (acc.isPublic()) {
            buf.append("public ");
        } else if (acc.isProtected()) {
            buf.append("protected ");
        } else if (acc.isPrivate()) {
            buf.append("private ");
        }
        if (acc.isStatic()) {
            buf.append("static ");
        }
        if (acc.isAbstract()) {
            buf.append("abstract ");
        } else if (acc.isFinal()) {
            buf.append("final ");
        }
        if (acc.isStrict()) {
            buf.append("strict ");
        }
        if (acc.isEnum()) {
            buf.append("[enum] ");
        }
        if (acc.isSynthetic()) {
            buf.append("[synthetic] ");
        }
        if (klass.isInterface()) {
            buf.append("interface");
        } else {
            buf.append("class");
        }
        buf.append(' ');
        buf.append(klass.getName().asString().replace('/', '.'));
        Symbol genSig = klass.getGenericSignature();
        if (genSig != null) {
            buf.append(" [signature ");
            buf.append(this.escapeHTMLSpecialChars(genSig.asString()));
            buf.append("] ");
        } else {
            buf.append(' ');
        }
        buf.append('@');
        buf.append(klass.getHandle().toString());
        return buf.toString();
    }

    protected String genBaseHref() {
        return "";
    }

    protected String genKlassHref(InstanceKlass klass) {
        return this.genBaseHref() + "klass=" + klass.getHandle();
    }

    protected String genKlassLink(InstanceKlass klass) {
        Formatter buf = new Formatter(this.genHTML);
        buf.link(this.genKlassHref(klass), this.genKlassTitle(klass));
        return buf.toString();
    }

    protected String genMethodModifierString(AccessFlags acc) {
        Formatter buf = new Formatter(this.genHTML);
        if (acc.isPrivate()) {
            buf.append("private ");
        } else if (acc.isProtected()) {
            buf.append("protected ");
        } else if (acc.isPublic()) {
            buf.append("public ");
        }
        if (acc.isStatic()) {
            buf.append("static ");
        } else if (acc.isAbstract()) {
            buf.append("abstract ");
        } else if (acc.isFinal()) {
            buf.append("final ");
        }
        if (acc.isNative()) {
            buf.append("native ");
        }
        if (acc.isStrict()) {
            buf.append("strict ");
        }
        if (acc.isSynchronized()) {
            buf.append("synchronized ");
        }
        if (acc.isBridge()) {
            buf.append("[bridge] ");
        }
        if (acc.isSynthetic()) {
            buf.append("[synthetic] ");
        }
        if (acc.isVarArgs()) {
            buf.append("[varargs] ");
        }
        return buf.toString();
    }

    protected String genMethodNameAndSignature(Method method) {
        Formatter buf = new Formatter(this.genHTML);
        buf.append(this.genMethodModifierString(method.getAccessFlagsObj()));
        Symbol sig = method.getSignature();
        new SignatureConverter(sig, buf.getBuffer()).iterateReturntype();
        buf.append(" ");
        String methodName = method.getName().asString();
        buf.append(this.escapeHTMLSpecialChars(methodName));
        buf.append('(');
        new SignatureConverter(sig, buf.getBuffer()).iterateParameters();
        buf.append(')');
        Symbol genSig = method.getGenericSignature();
        if (genSig != null) {
            buf.append(" [signature ");
            buf.append(this.escapeHTMLSpecialChars(genSig.asString()));
            buf.append("] ");
        }
        return buf.toString().replace('/', '.');
    }

    protected String genMethodTitle(Method method) {
        Formatter buf = new Formatter(this.genHTML);
        buf.append(this.genMethodNameAndSignature(method));
        buf.append(' ');
        buf.append('@');
        buf.append(method.getHandle().toString());
        return buf.toString();
    }

    protected String genMethodHref(Method m) {
        return this.genBaseHref() + "method=" + m.getHandle();
    }

    protected String genMethodLink(Method m) {
        Formatter buf = new Formatter(this.genHTML);
        buf.link(this.genMethodHref(m), this.genMethodTitle(m));
        return buf.toString();
    }

    protected String genMethodAndKlassLink(Method m) {
        Formatter buf = new Formatter(this.genHTML);
        buf.append(this.genMethodLink(m));
        buf.append(" of ");
        buf.append(this.genKlassLink((InstanceKlass)m.getMethodHolder()));
        return buf.toString();
    }

    protected String genNMethodHref(NMethod nm) {
        return this.genBaseHref() + "nmethod=" + nm.getAddress();
    }

    public String genNMethodTitle(NMethod nmethod) {
        Formatter buf = new Formatter(this.genHTML);
        Method m = nmethod.getMethod();
        buf.append("Disassembly for compiled method [");
        buf.append(this.genMethodTitle(m));
        buf.append(" ] ");
        buf.append('@');
        buf.append(nmethod.getAddress().toString());
        return buf.toString();
    }

    protected String genNMethodLink(NMethod nm) {
        Formatter buf = new Formatter(this.genHTML);
        buf.link(this.genNMethodHref(nm), this.genNMethodTitle(nm));
        return buf.toString();
    }

    public String genCodeBlobTitle(CodeBlob blob) {
        Formatter buf = new Formatter(this.genHTML);
        buf.append("Disassembly for code blob " + blob.getName() + " [");
        buf.append(blob.getClass().getName());
        buf.append(" ] @");
        buf.append(blob.getAddress().toString());
        return buf.toString();
    }

    protected BytecodeDisassembler createBytecodeDisassembler(Method m) {
        return new BytecodeDisassembler(m);
    }

    private String genLowHighShort(int val) {
        Formatter buf = new Formatter(this.genHTML);
        buf.append('#');
        buf.append(Integer.toString(val & 0xFFFF));
        buf.append(" #");
        buf.append(Integer.toString(val >> 16 & 0xFFFF));
        return buf.toString();
    }

    private String genListOfShort(short[] values) {
        if (values == null || values.length == 0) {
            return "";
        }
        Formatter buf = new Formatter(this.genHTML);
        buf.append('[');
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                buf.append(' ');
            }
            buf.append('#');
            buf.append(Integer.toString(values[i]));
        }
        buf.append(']');
        return buf.toString();
    }

    protected String genHTMLTableForConstantPool(ConstantPool cpool) {
        Formatter buf = new Formatter(this.genHTML);
        buf.beginTable(1);
        buf.beginTag("tr");
        buf.headerCell("Index");
        buf.headerCell("Constant Type");
        buf.headerCell("Constant Value");
        buf.endTag("tr");
        int length = cpool.getLength();
        for (int index = 1; index < length; ++index) {
            buf.beginTag("tr");
            buf.cell(Integer.toString(index));
            byte ctag = cpool.getTags().getByteAt(index);
            switch (ctag) {
                case 3: {
                    buf.cell("JVM_CONSTANT_Integer");
                    buf.cell(Integer.toString(cpool.getIntAt(index)));
                    break;
                }
                case 4: {
                    buf.cell("JVM_CONSTANT_Float");
                    buf.cell(Float.toString(cpool.getFloatAt(index)));
                    break;
                }
                case 5: {
                    buf.cell("JVM_CONSTANT_Long");
                    buf.cell(Long.toString(cpool.getLongAt(index)));
                    ++index;
                    break;
                }
                case 6: {
                    buf.cell("JVM_CONSTANT_Double");
                    buf.cell(Double.toString(cpool.getDoubleAt(index)));
                    ++index;
                    break;
                }
                case 100: {
                    buf.cell("JVM_CONSTANT_UnresolvedClass");
                    buf.cell(cpool.getSymbolAt(index).asString());
                    break;
                }
                case 104: {
                    buf.cell("JVM_CONSTANT_UnresolvedClassInError");
                    buf.cell(cpool.getSymbolAt(index).asString());
                    break;
                }
                case 7: {
                    buf.cell("JVM_CONSTANT_Class");
                    Klass klass = (Klass)cpool.getObjAtRaw(index);
                    if (klass instanceof InstanceKlass) {
                        buf.cell(this.genKlassLink((InstanceKlass)klass));
                        break;
                    }
                    buf.cell(klass.getName().asString().replace('/', '.'));
                    break;
                }
                case 102: {
                    buf.cell("JVM_CONSTANT_UnresolvedString");
                    buf.cell("\"" + this.escapeHTMLSpecialChars(cpool.getSymbolAt(index).asString()) + "\"");
                    break;
                }
                case 1: {
                    buf.cell("JVM_CONSTANT_Utf8");
                    buf.cell("\"" + this.escapeHTMLSpecialChars(cpool.getSymbolAt(index).asString()) + "\"");
                    break;
                }
                case 8: {
                    buf.cell("JVM_CONSTANT_String");
                    buf.cell("\"" + this.escapeHTMLSpecialChars(OopUtilities.stringOopToString(cpool.getObjAtRaw(index))) + "\"");
                    break;
                }
                case 9: {
                    buf.cell("JVM_CONSTANT_Fieldref");
                    buf.cell(this.genLowHighShort(cpool.getIntAt(index)));
                    break;
                }
                case 10: {
                    buf.cell("JVM_CONSTANT_Methodref");
                    buf.cell(this.genLowHighShort(cpool.getIntAt(index)));
                    break;
                }
                case 11: {
                    buf.cell("JVM_CONSTANT_InterfaceMethodref");
                    buf.cell(this.genLowHighShort(cpool.getIntAt(index)));
                    break;
                }
                case 12: {
                    buf.cell("JVM_CONSTANT_NameAndType");
                    buf.cell(this.genLowHighShort(cpool.getIntAt(index)));
                    break;
                }
                case 101: {
                    buf.cell("JVM_CONSTANT_ClassIndex");
                    buf.cell(Integer.toString(cpool.getIntAt(index)));
                    break;
                }
                case 103: {
                    buf.cell("JVM_CONSTANT_StringIndex");
                    buf.cell(Integer.toString(cpool.getIntAt(index)));
                    break;
                }
                case 15: {
                    buf.cell("JVM_CONSTANT_MethodHandle");
                    buf.cell(this.genLowHighShort(cpool.getIntAt(index)));
                    break;
                }
                case 16: {
                    buf.cell("JVM_CONSTANT_MethodType");
                    buf.cell(Integer.toString(cpool.getIntAt(index)));
                    break;
                }
                case 18: {
                    buf.cell("JVM_CONSTANT_InvokeDynamic");
                    buf.cell(this.genLowHighShort(cpool.getIntAt(index)) + this.genListOfShort(cpool.getBootstrapSpecifierAt(index)));
                    break;
                }
                default: {
                    throw new InternalError("unknown tag: " + ctag);
                }
            }
            buf.endTag("tr");
        }
        buf.endTable();
        return buf.toString();
    }

    public String genHTML(ConstantPool cpool) {
        try {
            Formatter buf = new Formatter(this.genHTML);
            buf.genHTMLPrologue(this.genConstantPoolTitle(cpool));
            buf.h3("Holder Class");
            buf.append(this.genKlassLink((InstanceKlass)cpool.getPoolHolder()));
            buf.h3("Constants");
            buf.append(this.genHTMLTableForConstantPool(cpool));
            buf.genHTMLEpilogue();
            return buf.toString();
        }
        catch (Exception exp) {
            return this.genHTMLErrorMessage(exp);
        }
    }

    protected String genConstantPoolHref(ConstantPool cpool) {
        return this.genBaseHref() + "cpool=" + cpool.getHandle();
    }

    protected String genConstantPoolTitle(ConstantPool cpool) {
        Formatter buf = new Formatter(this.genHTML);
        buf.append("Constant Pool of [");
        buf.append(this.genKlassTitle((InstanceKlass)cpool.getPoolHolder()));
        buf.append("] @");
        buf.append(cpool.getHandle().toString());
        return buf.toString();
    }

    protected String genConstantPoolLink(ConstantPool cpool) {
        Formatter buf = new Formatter(this.genHTML);
        buf.link(this.genConstantPoolHref(cpool), this.genConstantPoolTitle(cpool));
        return buf.toString();
    }

    public String genHTML(Method method) {
        try {
            final Formatter buf = new Formatter(this.genHTML);
            buf.genHTMLPrologue(this.genMethodTitle(method));
            buf.h3("Holder Class");
            buf.append(this.genKlassLink((InstanceKlass)method.getMethodHolder()));
            NMethod nmethod = method.getNativeMethod();
            if (nmethod != null) {
                buf.h3("Compiled Code");
                buf.append(this.genNMethodLink(nmethod));
            }
            boolean hasThrows = method.hasCheckedExceptions();
            ConstantPool cpool = ((InstanceKlass)method.getMethodHolder()).getConstants();
            if (hasThrows) {
                buf.h3("Checked Exception(s)");
                CheckedExceptionElement[] exceptions = method.getCheckedExceptions();
                buf.beginTag("ul");
                for (int exp = 0; exp < exceptions.length; ++exp) {
                    short cpIndex = (short)exceptions[exp].getClassCPIndex();
                    ConstantPool.CPSlot obj = cpool.getSlotAt(cpIndex);
                    if (obj.isMetaData()) {
                        buf.li(obj.getSymbol().asString().replace('/', '.'));
                        continue;
                    }
                    buf.li(this.genKlassLink((InstanceKlass)obj.getOop()));
                }
                buf.endTag("ul");
            }
            if (method.isNative() || method.isAbstract()) {
                buf.genHTMLEpilogue();
                return buf.toString();
            }
            buf.h3("Bytecode");
            BytecodeDisassembler disasm = this.createBytecodeDisassembler(method);
            final boolean hasLineNumbers = method.hasLineNumberTable();
            disasm.decode(new BytecodeVisitor(){
                private Method method;

                @Override
                public void prologue(Method m) {
                    this.method = m;
                    buf.beginTable(0);
                    buf.beginTag("tr");
                    if (hasLineNumbers) {
                        buf.headerCell("line");
                    }
                    buf.headerCell("bci" + HTMLGenerator.this.spaces);
                    buf.headerCell("bytecode");
                    buf.endTag("tr");
                }

                @Override
                public void visit(Bytecode instr) {
                    int curBci = instr.bci();
                    buf.beginTag("tr");
                    if (hasLineNumbers) {
                        int lineNumber = this.method.getLineNumberFromBCI(curBci);
                        buf.cell(Integer.toString(lineNumber) + HTMLGenerator.this.spaces);
                    }
                    buf.cell(Integer.toString(curBci) + HTMLGenerator.this.spaces);
                    buf.beginTag("td");
                    String instrStr = null;
                    try {
                        instrStr = HTMLGenerator.this.escapeHTMLSpecialChars(instr.toString());
                    }
                    catch (RuntimeException re) {
                        buf.append("exception during bytecode processing");
                        buf.endTag("td");
                        buf.endTag("tr");
                        re.printStackTrace();
                        return;
                    }
                    if (instr instanceof BytecodeNew) {
                        BytecodeNew newBytecode = (BytecodeNew)instr;
                        InstanceKlass klass = newBytecode.getNewKlass();
                        if (klass != null) {
                            buf.link(HTMLGenerator.this.genKlassHref(klass), instrStr);
                        } else {
                            buf.append(instrStr);
                        }
                    } else if (instr instanceof BytecodeInvoke) {
                        BytecodeInvoke invokeBytecode = (BytecodeInvoke)instr;
                        Method m = invokeBytecode.getInvokedMethod();
                        if (m != null) {
                            buf.link(HTMLGenerator.this.genMethodHref(m), instrStr);
                            buf.append(" of ");
                            InstanceKlass klass = (InstanceKlass)m.getMethodHolder();
                            buf.link(HTMLGenerator.this.genKlassHref(klass), HTMLGenerator.this.genKlassTitle(klass));
                        } else {
                            buf.append(instrStr);
                        }
                    } else if (instr instanceof BytecodeGetPut) {
                        BytecodeGetPut getPut = (BytecodeGetPut)instr;
                        Field f = getPut.getField();
                        buf.append(instrStr);
                        if (f != null) {
                            InstanceKlass klass = f.getFieldHolder();
                            buf.append(" of ");
                            buf.link(HTMLGenerator.this.genKlassHref(klass), HTMLGenerator.this.genKlassTitle(klass));
                        }
                    } else if (instr instanceof BytecodeLoadConstant) {
                        BytecodeLoadConstant ldc = (BytecodeLoadConstant)instr;
                        if (ldc.isKlassConstant()) {
                            Object oop = ldc.getKlass();
                            if (oop instanceof Klass) {
                                buf.append("<a href='");
                                buf.append(HTMLGenerator.this.genKlassHref((InstanceKlass)oop));
                                buf.append("'>");
                                buf.append(instrStr);
                                buf.append("</a>");
                            } else {
                                buf.append(instrStr);
                            }
                        } else {
                            buf.append(instrStr);
                        }
                    } else {
                        buf.append(instrStr);
                    }
                    buf.endTag("td");
                    buf.endTag("tr");
                }

                @Override
                public void epilogue() {
                    buf.endTable();
                }
            });
            TypeArray exceptionTable = method.getExceptionTable();
            int numEntries = (int)exceptionTable.getLength() / 4;
            if (numEntries != 0) {
                buf.h4("Exception Table");
                buf.beginTable(1);
                buf.beginTag("tr");
                buf.headerCell("start bci");
                buf.headerCell("end bci");
                buf.headerCell("handler bci");
                buf.headerCell("catch type");
                buf.endTag("tr");
                for (int e = 0; e < numEntries; e += 4) {
                    ConstantPool.CPSlot obj;
                    buf.beginTag("tr");
                    buf.cell(Integer.toString(exceptionTable.getIntAt(e)));
                    buf.cell(Integer.toString(exceptionTable.getIntAt(e + 1)));
                    buf.cell(Integer.toString(exceptionTable.getIntAt(e + 2)));
                    short cpIndex = (short)exceptionTable.getIntAt(e + 3);
                    ConstantPool.CPSlot cPSlot = obj = cpIndex == 0 ? null : cpool.getSlotAt(cpIndex);
                    if (obj == null) {
                        buf.cell("Any");
                    } else if (obj.isMetaData()) {
                        buf.cell(obj.getSymbol().asString().replace('/', '.'));
                    } else {
                        buf.cell(this.genKlassLink((InstanceKlass)obj.getOop()));
                    }
                    buf.endTag("tr");
                }
                buf.endTable();
            }
            buf.h3("Constant Pool");
            buf.append(this.genConstantPoolLink(cpool));
            buf.genHTMLEpilogue();
            return buf.toString();
        }
        catch (Exception exp) {
            return this.genHTMLErrorMessage(exp);
        }
    }

    protected Disassembler createDisassembler(long startPc, byte[] code) {
        return HTMLGenerator.getCPUHelper().createDisassembler(startPc, code);
    }

    protected SymbolFinder createSymbolFinder() {
        return new DummySymbolFinder();
    }

    public String genHTMLForAddress(String addrStr) {
        return this.genHTML(this.parseAddress(addrStr));
    }

    public String genHTML(Address pc) {
        CodeBlob blob = null;
        try {
            blob = VM.getVM().getCodeCache().findBlobUnsafe(pc);
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (blob != null) {
            if (blob instanceof NMethod) {
                return this.genHTML((NMethod)blob);
            }
            Interpreter interp = VM.getVM().getInterpreter();
            if (interp.contains(pc)) {
                InterpreterCodelet codelet = interp.getCodeletContaining(pc);
                if (codelet == null) {
                    return "Unknown location in the Interpreter: " + pc;
                }
                return this.genHTML(codelet);
            }
            return this.genHTML(blob);
        }
        if (VM.getVM().getCodeCache().contains(pc)) {
            return "Unknown location in the CodeCache: " + pc;
        }
        try {
            Oop obj = this.getOopAtAddress(pc);
            if (obj != null) {
                if (obj instanceof Method) {
                    return this.genHTML((Method)obj);
                }
                if (obj instanceof InstanceKlass) {
                    return this.genHTML((InstanceKlass)obj);
                }
                if (obj instanceof ConstantPool) {
                    return this.genHTML((ConstantPool)obj);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.genHTMLForRawDisassembly(pc, null);
    }

    protected byte[] readBuffer(Address addr, int size) {
        byte[] buf = new byte[size];
        for (int b = 0; b < size; ++b) {
            buf[b] = addr.getJByteAt(b);
        }
        return buf;
    }

    public String genHTMLForRawDisassembly(Address startPc, int size) {
        try {
            return this.genHTMLForRawDisassembly(startPc, null, this.readBuffer(startPc, size));
        }
        catch (Exception exp) {
            return this.genHTMLErrorMessage(exp);
        }
    }

    protected String genHTMLForRawDisassembly(Address startPc, String prevPCs) {
        try {
            return this.genHTMLForRawDisassembly(startPc, prevPCs, this.readBuffer(startPc, 200));
        }
        catch (Exception exp) {
            return this.genHTMLErrorMessage(exp);
        }
    }

    protected String genPCHref(long targetPc) {
        return this.genBaseHref() + "pc=0x" + Long.toHexString(targetPc);
    }

    protected String genMultPCHref(String pcs) {
        StringBuffer buf = new StringBuffer(this.genBaseHref());
        buf.append("pc_multiple=");
        buf.append(pcs);
        return buf.toString();
    }

    protected String genPCHref(long currentPc, sun.jvm.hotspot.asm.Address addr) {
        String href = null;
        if (addr instanceof PCRelativeAddress) {
            PCRelativeAddress pcRelAddr = (PCRelativeAddress)addr;
            href = this.genPCHref(currentPc + pcRelAddr.getDisplacement());
        } else if (addr instanceof DirectAddress) {
            href = this.genPCHref(((DirectAddress)addr).getValue());
        }
        return href;
    }

    protected String genHTMLForRawDisassembly(Address addr, String prevPCs, byte[] code) {
        try {
            long startPc = this.addressToLong(addr);
            Disassembler disasm = this.createDisassembler(startPc, code);
            Formatter buf = new Formatter(this.genHTML);
            buf.genHTMLPrologue("Disassembly @0x" + Long.toHexString(startPc));
            if (prevPCs != null && this.genHTML) {
                buf.beginTag("p");
                buf.link(this.genMultPCHref(prevPCs), "show previous code ..");
                buf.endTag("p");
            }
            buf.h3("Code");
            RawCodeVisitor visitor = new RawCodeVisitor(buf);
            disasm.decode(visitor);
            if (this.genHTML) {
                buf.beginTag("p");
            }
            Formatter tmpBuf = new Formatter(this.genHTML);
            tmpBuf.append("0x");
            tmpBuf.append(Long.toHexString(startPc + (long)visitor.getInstructionSize()).toString());
            tmpBuf.append(",0x");
            tmpBuf.append(Long.toHexString(startPc));
            if (prevPCs != null) {
                tmpBuf.append(',');
                tmpBuf.append(prevPCs);
            }
            if (this.genHTML) {
                buf.link(this.genMultPCHref(tmpBuf.toString()), "show more code ..");
                buf.endTag("p");
            }
            buf.genHTMLEpilogue();
            return buf.toString();
        }
        catch (Exception exp) {
            return this.genHTMLErrorMessage(exp);
        }
    }

    protected String genSafepointInfo(NMethod nm, PCDesc pcDesc) {
        ScopeDesc sd = nm.getScopeDescAt(pcDesc.getRealPC(nm));
        Formatter buf = new Formatter(this.genHTML);
        Formatter tabs = new Formatter(this.genHTML);
        tabs.append(this.tab + this.tab + this.tab);
        buf.beginTag("pre");
        this.genScope(buf, tabs, sd);
        tabs = new Formatter(this.genHTML);
        tabs.append(this.tab + this.tab + this.tab);
        this.genScObjInfo(buf, tabs, sd);
        buf.endTag("pre");
        buf.append(this.genOopMapInfo(nm, pcDesc));
        return buf.toString();
    }

    protected void genScope(Formatter buf, Formatter tabs, ScopeDesc sd) {
        List monitors;
        List expressions;
        List locals;
        if (sd == null) {
            return;
        }
        this.genScope(buf, tabs, sd.sender());
        buf.append(tabs);
        Method m = sd.getMethod();
        buf.append(this.genMethodAndKlassLink(m));
        int bci = sd.getBCI();
        buf.append(" @ bci = ");
        buf.append(Integer.toString(bci));
        int line = m.getLineNumberFromBCI(bci);
        if (line != -1) {
            buf.append(", line = ");
            buf.append(Integer.toString(line));
        }
        if ((locals = sd.getLocals()) != null) {
            buf.br();
            buf.append(tabs);
            buf.append(this.genHTMLForLocals(sd, locals));
        }
        if ((expressions = sd.getExpressions()) != null) {
            buf.br();
            buf.append(tabs);
            buf.append(this.genHTMLForExpressions(sd, expressions));
        }
        if ((monitors = sd.getMonitors()) != null) {
            buf.br();
            buf.append(tabs);
            buf.append(this.genHTMLForMonitors(sd, monitors));
        }
        buf.br();
        tabs.append(this.tab);
    }

    protected void genScObjInfo(Formatter buf, Formatter tabs, ScopeDesc sd) {
        if (sd == null) {
            return;
        }
        List objects = sd.getObjects();
        if (objects == null) {
            return;
        }
        int length = objects.size();
        for (int i = 0; i < length; ++i) {
            Oop obj;
            buf.append(tabs);
            ObjectValue ov = (ObjectValue)objects.get(i);
            buf.append("ScObj" + i);
            ScopeValue sv = ov.getKlass();
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(sv.isConstantOop(), "scalar replaced object klass must be constant oop");
            }
            ConstantOopReadValue klv = (ConstantOopReadValue)sv;
            OopHandle klHandle = klv.getValue();
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(klHandle != null, "scalar replaced object klass must be not NULL");
            }
            if ((obj = VM.getVM().getObjectHeap().newOop(klHandle)) instanceof InstanceKlass) {
                InstanceKlass kls = (InstanceKlass)obj;
                buf.append(" " + kls.getName().asString() + "={");
                int flen = ov.fieldsSize();
                int klen = kls.getJavaFieldsCount();
                int findex = 0;
                for (int index = 0; index < klen; ++index) {
                    short accsFlags = kls.getFieldAccessFlags(index);
                    Symbol f_name = kls.getFieldName(index);
                    AccessFlags access = new AccessFlags(accsFlags);
                    if (access.isStatic()) continue;
                    ScopeValue svf = ov.getFieldAt(findex++);
                    String fstr = this.scopeValueAsString(sd, svf);
                    buf.append(" [" + f_name.asString() + " :" + index + "]=(#" + fstr + ")");
                }
                buf.append(" }");
            } else {
                buf.append(" ");
                int flen = ov.fieldsSize();
                if (obj instanceof TypeArrayKlass) {
                    TypeArrayKlass kls = (TypeArrayKlass)obj;
                    buf.append(kls.getElementTypeName() + "[" + flen + "]");
                } else if (obj instanceof ObjArrayKlass) {
                    ObjArrayKlass kls = (ObjArrayKlass)obj;
                    Klass elobj = kls.getBottomKlass();
                    if (elobj instanceof InstanceKlass) {
                        buf.append(elobj.getName().asString());
                    } else if (elobj instanceof TypeArrayKlass) {
                        TypeArrayKlass elkls = (TypeArrayKlass)elobj;
                        buf.append(elkls.getElementTypeName());
                    } else if (Assert.ASSERTS_ENABLED) {
                        Assert.that(false, "unknown scalar replaced object klass!");
                    }
                    buf.append("[" + flen + "]");
                    int ndim = (int)kls.getDimension();
                    while (--ndim > 0) {
                        buf.append("[]");
                    }
                } else if (Assert.ASSERTS_ENABLED) {
                    Assert.that(false, "unknown scalar replaced object klass!");
                }
                buf.append("={");
                for (int findex = 0; findex < flen; ++findex) {
                    ScopeValue svf = ov.getFieldAt(findex);
                    String fstr = this.scopeValueAsString(sd, svf);
                    buf.append(" [" + findex + "]=(#" + fstr + ")");
                }
                buf.append(" }");
            }
            buf.br();
        }
    }

    protected String genHTMLForOopMap(OopMap map) {
        final int stack0 = VMRegImpl.getStack0().getValue();
        Formatter buf = new Formatter(this.genHTML);
        buf.beginTable(0);
        final class OopMapValueIterator {
            OopMapValueIterator() {
            }

            final Formatter iterate(OopMapStream oms, String type, boolean printContentReg) {
                Formatter tmpBuf = new Formatter(HTMLGenerator.this.genHTML);
                boolean found = false;
                tmpBuf.beginTag("tr");
                tmpBuf.beginTag("td");
                tmpBuf.append(type);
                while (!oms.isDone()) {
                    OopMapValue omv = oms.getCurrent();
                    if (omv != null) {
                        found = true;
                        VMReg vmReg = omv.getReg();
                        int reg = vmReg.getValue();
                        if (reg < stack0) {
                            tmpBuf.append(VMRegImpl.getRegisterName(reg));
                        } else {
                            tmpBuf.append('[');
                            tmpBuf.append(Integer.toString((reg - stack0) * 4));
                            tmpBuf.append(']');
                        }
                        if (printContentReg) {
                            tmpBuf.append(" = ");
                            VMReg vmContentReg = omv.getContentReg();
                            int contentReg = vmContentReg.getValue();
                            if (contentReg < stack0) {
                                tmpBuf.append(VMRegImpl.getRegisterName(contentReg));
                            } else {
                                tmpBuf.append('[');
                                tmpBuf.append(Integer.toString((contentReg - stack0) * 4));
                                tmpBuf.append(']');
                            }
                        }
                        tmpBuf.append(HTMLGenerator.this.spaces);
                    }
                    oms.next();
                }
                tmpBuf.endTag("td");
                tmpBuf.endTag("tr");
                return found ? tmpBuf : new Formatter(HTMLGenerator.this.genHTML);
            }
        }
        OopMapValueIterator omvIterator = new OopMapValueIterator();
        OopMapStream oms = new OopMapStream(map, OopMapValue.OopTypes.OOP_VALUE);
        buf.append(omvIterator.iterate(oms, "Oops:", false));
        oms = new OopMapStream(map, OopMapValue.OopTypes.NARROWOOP_VALUE);
        buf.append(omvIterator.iterate(oms, "narrowOops:", false));
        oms = new OopMapStream(map, OopMapValue.OopTypes.VALUE_VALUE);
        buf.append(omvIterator.iterate(oms, "Values:", false));
        oms = new OopMapStream(map, OopMapValue.OopTypes.CALLEE_SAVED_VALUE);
        buf.append(omvIterator.iterate(oms, "Callee saved:", true));
        oms = new OopMapStream(map, OopMapValue.OopTypes.DERIVED_OOP_VALUE);
        buf.append(omvIterator.iterate(oms, "Derived oops:", true));
        buf.endTag("table");
        return buf.toString();
    }

    protected String genOopMapInfo(NMethod nmethod, PCDesc pcDesc) {
        OopMapSet mapSet = nmethod.getOopMaps();
        if (mapSet == null || mapSet.getSize() <= 0L) {
            return "";
        }
        int pcOffset = pcDesc.getPCOffset();
        OopMap map = mapSet.findMapAtOffset(pcOffset, VM.getVM().isDebugging());
        if (map == null) {
            throw new IllegalArgumentException("no oopmap at safepoint!");
        }
        return this.genOopMapInfo(map);
    }

    protected String genOopMapInfo(OopMap map) {
        Formatter buf = new Formatter(this.genHTML);
        buf.beginTag("pre");
        buf.append("OopMap: ");
        buf.br();
        buf.append(this.genHTMLForOopMap(map));
        buf.endTag("pre");
        return buf.toString();
    }

    protected String locationAsString(Location loc) {
        Formatter buf = new Formatter(this.genHTML);
        if (loc.isIllegal()) {
            buf.append("illegal");
        } else {
            Location.Where w = loc.getWhere();
            Location.Type type = loc.getType();
            if (w == Location.Where.ON_STACK) {
                buf.append("stack[" + loc.getStackOffset() + "]");
            } else if (w == Location.Where.IN_REGISTER) {
                boolean isFloat = type == Location.Type.FLOAT_IN_DBL || type == Location.Type.DBL;
                int regNum = loc.getRegisterNumber();
                VMReg vmReg = new VMReg(regNum);
                buf.append(VMRegImpl.getRegisterName(vmReg.getValue()));
            }
            buf.append(", ");
            if (type == Location.Type.NORMAL) {
                buf.append("normal");
            } else if (type == Location.Type.OOP) {
                buf.append("oop");
            } else if (type == Location.Type.NARROWOOP) {
                buf.append("narrowoop");
            } else if (type == Location.Type.INT_IN_LONG) {
                buf.append("int");
            } else if (type == Location.Type.LNG) {
                buf.append("long");
            } else if (type == Location.Type.FLOAT_IN_DBL) {
                buf.append("float");
            } else if (type == Location.Type.DBL) {
                buf.append("double");
            } else if (type == Location.Type.ADDR) {
                buf.append("address");
            } else if (type == Location.Type.INVALID) {
                buf.append("invalid");
            }
        }
        return buf.toString();
    }

    private String scopeValueAsString(ScopeDesc sd, ScopeValue sv) {
        Formatter buf = new Formatter(this.genHTML);
        if (sv.isConstantInt()) {
            buf.append("int ");
            ConstantIntValue intValue = (ConstantIntValue)sv;
            buf.append(Integer.toString(intValue.getValue()));
        } else if (sv.isConstantLong()) {
            buf.append("long ");
            ConstantLongValue longValue = (ConstantLongValue)sv;
            buf.append(Long.toString(longValue.getValue()));
            buf.append("L");
        } else if (sv.isConstantDouble()) {
            buf.append("double ");
            ConstantDoubleValue dblValue = (ConstantDoubleValue)sv;
            buf.append(Double.toString(dblValue.getValue()));
            buf.append("D");
        } else if (sv.isConstantOop()) {
            buf.append("oop ");
            ConstantOopReadValue oopValue = (ConstantOopReadValue)sv;
            OopHandle oopHandle = oopValue.getValue();
            if (oopHandle != null) {
                buf.append(oopHandle.toString());
            } else {
                buf.append("null");
            }
        } else if (sv.isLocation()) {
            LocationValue lvalue = (LocationValue)sv;
            Location loc = lvalue.getLocation();
            if (loc != null) {
                buf.append(this.locationAsString(loc));
            } else {
                buf.append("null");
            }
        } else if (sv.isObject()) {
            ObjectValue ov = (ObjectValue)sv;
            buf.append("#ScObj" + sd.getObjects().indexOf(ov));
        } else {
            buf.append("unknown scope value " + sv);
        }
        return buf.toString();
    }

    protected String genHTMLForScopeValues(ScopeDesc sd, boolean locals, List values) {
        int length = values.size();
        Formatter buf = new Formatter(this.genHTML);
        buf.append(locals ? "locals " : "expressions ");
        for (int i = 0; i < length; ++i) {
            ScopeValue sv = (ScopeValue)values.get(i);
            if (sv == null) continue;
            buf.append('(');
            if (locals) {
                Symbol name = sd.getMethod().getLocalVariableName(sd.getBCI(), i);
                if (name != null) {
                    buf.append("'");
                    buf.append(name.asString());
                    buf.append('\'');
                } else {
                    buf.append("[");
                    buf.append(Integer.toString(i));
                    buf.append(']');
                }
            } else {
                buf.append("[");
                buf.append(Integer.toString(i));
                buf.append(']');
            }
            buf.append(", ");
            buf.append(this.scopeValueAsString(sd, sv));
            buf.append(") ");
        }
        return buf.toString();
    }

    protected String genHTMLForLocals(ScopeDesc sd, List locals) {
        return this.genHTMLForScopeValues(sd, true, locals);
    }

    protected String genHTMLForExpressions(ScopeDesc sd, List expressions) {
        return this.genHTMLForScopeValues(sd, false, expressions);
    }

    protected String genHTMLForMonitors(ScopeDesc sd, List monitors) {
        int length = monitors.size();
        Formatter buf = new Formatter(this.genHTML);
        buf.append("monitors ");
        for (int i = 0; i < length; ++i) {
            MonitorValue mv = (MonitorValue)monitors.get(i);
            if (mv == null) continue;
            buf.append("(owner = ");
            ScopeValue owner = mv.owner();
            if (owner != null) {
                buf.append(this.scopeValueAsString(sd, owner));
            } else {
                buf.append("null");
            }
            buf.append(", lock = ");
            Location loc = mv.basicLock();
            if (loc != null) {
                buf.append(this.locationAsString(loc));
            } else {
                buf.append("null");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    public String genHTML(final NMethod nmethod) {
        try {
            final Formatter buf = new Formatter(this.genHTML);
            buf.genHTMLPrologue(this.genNMethodTitle(nmethod));
            buf.h3("Method");
            buf.append(this.genMethodAndKlassLink(nmethod.getMethod()));
            buf.h3("Compiled Code");
            Address instsBegin = nmethod.instsBegin();
            Address instsEnd = nmethod.instsEnd();
            int instsSize = nmethod.instsSize();
            long startPc = this.addressToLong(instsBegin);
            byte[] code = new byte[instsSize];
            for (int i = 0; i < code.length; ++i) {
                code[i] = instsBegin.getJByteAt(i);
            }
            final long verifiedEntryPoint = this.addressToLong(nmethod.getVerifiedEntryPoint());
            final long entryPoint = this.addressToLong(nmethod.getEntryPoint());
            final Map safepoints = nmethod.getSafepoints();
            final SymbolFinder symFinder = this.createSymbolFinder();
            Disassembler disasm = this.createDisassembler(startPc, code);
            class NMethodVisitor
            implements InstructionVisitor {
                NMethodVisitor() {
                }

                @Override
                public void prologue() {
                }

                @Override
                public void visit(long currentPc, Instruction instr) {
                    PCDesc pcDesc;
                    String href = null;
                    if (instr.isCall()) {
                        CallInstruction call = (CallInstruction)instr;
                        sun.jvm.hotspot.asm.Address addr = call.getBranchDestination();
                        href = HTMLGenerator.this.genPCHref(currentPc, addr);
                    }
                    if (currentPc == verifiedEntryPoint) {
                        buf.bold("Verified Entry Point");
                        buf.br();
                    }
                    if (currentPc == entryPoint) {
                        buf.bold(">Entry Point");
                        buf.br();
                    }
                    if ((pcDesc = (PCDesc)safepoints.get(HTMLGenerator.this.longToAddress(currentPc))) != null) {
                        buf.append(HTMLGenerator.this.genSafepointInfo(nmethod, pcDesc));
                    }
                    buf.append("0x");
                    buf.append(Long.toHexString(currentPc));
                    buf.append(':');
                    buf.append(HTMLGenerator.this.tab);
                    if (href != null) {
                        buf.link(href, instr.asString(currentPc, symFinder));
                    } else {
                        buf.append(instr.asString(currentPc, symFinder));
                    }
                    buf.br();
                }

                @Override
                public void epilogue() {
                }
            }
            disasm.decode(new NMethodVisitor());
            Address stubBegin = nmethod.stubBegin();
            if (stubBegin != null) {
                Address stubEnd = nmethod.stubEnd();
                buf.h3("Stub");
                long stubStartPc = this.addressToLong(stubBegin);
                long stubEndPc = this.addressToLong(stubEnd);
                int range = (int)(stubEndPc - stubStartPc);
                byte[] stubCode = this.readBuffer(stubBegin, range);
                Disassembler disasm2 = this.createDisassembler(stubStartPc, stubCode);
                disasm2.decode(new NMethodVisitor());
            }
            buf.genHTMLEpilogue();
            return buf.toString();
        }
        catch (Exception exp) {
            return this.genHTMLErrorMessage(exp);
        }
    }

    public String genHTML(final CodeBlob blob) {
        try {
            final Formatter buf = new Formatter(this.genHTML);
            buf.genHTMLPrologue(this.genCodeBlobTitle(blob));
            buf.h3("CodeBlob");
            buf.h3("Compiled Code");
            Address codeBegin = blob.codeBegin();
            int codeSize = blob.getCodeSize();
            final long startPc = this.addressToLong(codeBegin);
            byte[] code = new byte[codeSize];
            for (int i = 0; i < code.length; ++i) {
                code[i] = codeBegin.getJByteAt(i);
            }
            final SymbolFinder symFinder = this.createSymbolFinder();
            Disassembler disasm = this.createDisassembler(startPc, code);
            class CodeBlobVisitor
            implements InstructionVisitor {
                OopMapSet maps;
                OopMap curMap;
                int curMapIndex;
                long curMapOffset;

                CodeBlobVisitor() {
                }

                @Override
                public void prologue() {
                    this.maps = blob.getOopMaps();
                    if (this.maps != null && this.maps.getSize() > 0L) {
                        this.curMap = this.maps.getMapAt(0);
                        if (this.curMap != null) {
                            this.curMapOffset = this.curMap.getOffset();
                        }
                    }
                }

                @Override
                public void visit(long currentPc, Instruction instr) {
                    long curOffset;
                    String href = null;
                    if (instr.isCall()) {
                        CallInstruction call = (CallInstruction)instr;
                        sun.jvm.hotspot.asm.Address addr = call.getBranchDestination();
                        href = HTMLGenerator.this.genPCHref(currentPc, addr);
                    }
                    buf.append("0x");
                    buf.append(Long.toHexString(currentPc));
                    buf.append(':');
                    buf.append(HTMLGenerator.this.tab);
                    if (href != null) {
                        buf.link(href, instr.asString(currentPc, symFinder));
                    } else {
                        buf.append(instr.asString(currentPc, symFinder));
                    }
                    buf.br();
                    if (this.curMap != null && (curOffset = currentPc - startPc) == this.curMapOffset) {
                        buf.append(HTMLGenerator.this.genOopMapInfo(this.curMap));
                        if ((long)(++this.curMapIndex) >= this.maps.getSize()) {
                            this.curMap = null;
                        } else {
                            this.curMap = this.maps.getMapAt(this.curMapIndex);
                            if (this.curMap != null) {
                                this.curMapOffset = this.curMap.getOffset();
                            }
                        }
                    }
                }

                @Override
                public void epilogue() {
                }
            }
            disasm.decode(new CodeBlobVisitor());
            buf.genHTMLEpilogue();
            return buf.toString();
        }
        catch (Exception exp) {
            return this.genHTMLErrorMessage(exp);
        }
    }

    protected String genInterpreterCodeletTitle(InterpreterCodelet codelet) {
        Formatter buf = new Formatter(this.genHTML);
        buf.append("Interpreter codelet [");
        buf.append(codelet.codeBegin().toString());
        buf.append(',');
        buf.append(codelet.codeEnd().toString());
        buf.append(") - ");
        buf.append(codelet.getDescription());
        return buf.toString();
    }

    protected String genInterpreterCodeletLinkPageHref(StubQueue stubq) {
        return this.genBaseHref() + "interp_codelets";
    }

    public String genInterpreterCodeletLinksPage() {
        Formatter buf = new Formatter(this.genHTML);
        buf.genHTMLPrologue("Interpreter Codelets");
        buf.beginTag("ul");
        Interpreter interp = VM.getVM().getInterpreter();
        StubQueue code = interp.getCode();
        InterpreterCodelet stub = (InterpreterCodelet)code.getFirst();
        while (stub != null) {
            buf.beginTag("li");
            Address addr = stub.codeBegin();
            buf.link(this.genPCHref(this.addressToLong(addr)), stub.getDescription() + " @" + addr);
            buf.endTag("li");
            stub = (InterpreterCodelet)code.getNext(stub);
        }
        buf.endTag("ul");
        buf.genHTMLEpilogue();
        return buf.toString();
    }

    public String genHTML(InterpreterCodelet codelet) {
        Stub prev;
        Formatter buf = new Formatter(this.genHTML);
        buf.genHTMLPrologue(this.genInterpreterCodeletTitle(codelet));
        Interpreter interp = VM.getVM().getInterpreter();
        StubQueue stubq = interp.getCode();
        if (this.genHTML) {
            buf.beginTag("h3");
            buf.link(this.genInterpreterCodeletLinkPageHref(stubq), "View links for all codelets");
            buf.endTag("h3");
            buf.br();
        }
        if ((prev = stubq.getPrev(codelet)) != null) {
            if (this.genHTML) {
                buf.beginTag("h3");
                buf.link(this.genPCHref(this.addressToLong(prev.codeBegin())), "View Previous Codelet");
                buf.endTag("h3");
                buf.br();
            } else {
                buf.h3("Previous Codelet = 0x" + Long.toHexString(this.addressToLong(prev.codeBegin())));
            }
        }
        buf.h3("Code");
        long stubStartPc = this.addressToLong(codelet.codeBegin());
        long stubEndPc = this.addressToLong(codelet.codeEnd());
        int range = (int)(stubEndPc - stubStartPc);
        byte[] stubCode = this.readBuffer(codelet.codeBegin(), range);
        Disassembler disasm = this.createDisassembler(stubStartPc, stubCode);
        disasm.decode(new RawCodeVisitor(buf));
        Stub next = stubq.getNext(codelet);
        if (next != null) {
            if (this.genHTML) {
                buf.beginTag("h3");
                buf.link(this.genPCHref(this.addressToLong(next.codeBegin())), "View Next Codelet");
                buf.endTag("h3");
            } else {
                buf.h3("Next Codelet = 0x" + Long.toHexString(this.addressToLong(next.codeBegin())));
            }
        }
        buf.genHTMLEpilogue();
        return buf.toString();
    }

    protected String genDumpKlassesTitle(InstanceKlass[] klasses) {
        return klasses.length == 1 ? "Create .class for this class" : "Create .class for all classes";
    }

    protected String genDumpKlassesHref(InstanceKlass[] klasses) {
        StringBuffer buf = new StringBuffer(this.genBaseHref());
        buf.append("jcore_multiple=");
        for (int k = 0; k < klasses.length; ++k) {
            buf.append(klasses[k].getHandle().toString());
            buf.append(',');
        }
        return buf.toString();
    }

    protected String genDumpKlassesLink(InstanceKlass[] klasses) {
        if (!this.genHTML) {
            return "";
        }
        Formatter buf = new Formatter(this.genHTML);
        buf.link(this.genDumpKlassesHref(klasses), this.genDumpKlassesTitle(klasses));
        return buf.toString();
    }

    public String genHTMLForKlassNames(InstanceKlass[] klasses) {
        try {
            Formatter buf = new Formatter(this.genHTML);
            buf.genHTMLPrologue();
            buf.h3(this.genDumpKlassesLink(klasses));
            buf.append(this.genHTMLListForKlassNames(klasses));
            buf.genHTMLEpilogue();
            return buf.toString();
        }
        catch (Exception exp) {
            return this.genHTMLErrorMessage(exp);
        }
    }

    protected String genHTMLListForKlassNames(InstanceKlass[] klasses) {
        Formatter buf = new Formatter(this.genHTML);
        buf.beginTable(0);
        for (int i = 0; i < klasses.length; ++i) {
            InstanceKlass ik = klasses[i];
            buf.beginTag("tr");
            buf.cell(this.genKlassLink(ik));
            buf.endTag("tr");
        }
        buf.endTable();
        return buf.toString();
    }

    public String genHTMLForMethodNames(InstanceKlass klass) {
        try {
            Formatter buf = new Formatter(this.genHTML);
            buf.genHTMLPrologue();
            buf.append(this.genHTMLListForMethods(klass));
            buf.genHTMLEpilogue();
            return buf.toString();
        }
        catch (Exception exp) {
            return this.genHTMLErrorMessage(exp);
        }
    }

    protected String genHTMLListForMethods(InstanceKlass klass) {
        Formatter buf = new Formatter(this.genHTML);
        ObjArray methods = klass.getMethods();
        int numMethods = (int)methods.getLength();
        if (numMethods != 0) {
            buf.h3("Methods");
            buf.beginTag("ul");
            for (int m = 0; m < numMethods; ++m) {
                Method mtd = (Method)methods.getObjAt(m);
                buf.li(this.genMethodLink(mtd) + ";");
            }
            buf.endTag("ul");
        }
        return buf.toString();
    }

    protected String genHTMLListForInterfaces(InstanceKlass klass) {
        try {
            Formatter buf = new Formatter(this.genHTML);
            ObjArray interfaces = klass.getLocalInterfaces();
            int numInterfaces = (int)interfaces.getLength();
            if (numInterfaces != 0) {
                buf.h3("Interfaces");
                buf.beginTag("ul");
                for (int i = 0; i < numInterfaces; ++i) {
                    InstanceKlass inf = (InstanceKlass)interfaces.getObjAt(i);
                    buf.li(this.genKlassLink(inf));
                }
                buf.endTag("ul");
            }
            return buf.toString();
        }
        catch (Exception exp) {
            return this.genHTMLErrorMessage(exp);
        }
    }

    protected String genFieldModifierString(AccessFlags acc) {
        Formatter buf = new Formatter(this.genHTML);
        if (acc.isPrivate()) {
            buf.append("private ");
        } else if (acc.isProtected()) {
            buf.append("protected ");
        } else if (acc.isPublic()) {
            buf.append("public ");
        }
        if (acc.isStatic()) {
            buf.append("static ");
        }
        if (acc.isFinal()) {
            buf.append("final ");
        }
        if (acc.isVolatile()) {
            buf.append("volatile ");
        }
        if (acc.isTransient()) {
            buf.append("transient ");
        }
        if (acc.isSynthetic()) {
            buf.append("[synthetic] ");
        }
        return buf.toString();
    }

    public String genHTMLForFieldNames(InstanceKlass klass) {
        try {
            Formatter buf = new Formatter(this.genHTML);
            buf.genHTMLPrologue();
            buf.append(this.genHTMLListForFields(klass));
            buf.genHTMLEpilogue();
            return buf.toString();
        }
        catch (Exception exp) {
            return this.genHTMLErrorMessage(exp);
        }
    }

    protected String genHTMLListForFields(InstanceKlass klass) {
        Formatter buf = new Formatter(this.genHTML);
        int numFields = klass.getJavaFieldsCount();
        if (numFields != 0) {
            buf.h3("Fields");
            buf.beginList();
            for (int f = 0; f < numFields; ++f) {
                Field field = klass.getFieldByIndex(f);
                String f_name = ((NamedFieldIdentifier)field.getID()).getName();
                Symbol f_sig = field.getSignature();
                Symbol f_genSig = field.getGenericSignature();
                AccessFlags acc = field.getAccessFlagsObj();
                buf.beginListItem();
                buf.append(this.genFieldModifierString(acc));
                buf.append(' ');
                Formatter sigBuf = new Formatter(this.genHTML);
                new SignatureConverter(f_sig, sigBuf.getBuffer()).dispatchField();
                buf.append(sigBuf.toString().replace('/', '.'));
                buf.append(' ');
                buf.append(f_name);
                buf.append(';');
                if (f_genSig != null) {
                    buf.append(" [signature ");
                    buf.append(this.escapeHTMLSpecialChars(f_genSig.asString()));
                    buf.append("] ");
                }
                buf.append(" (offset = " + field.getOffset() + ")");
                buf.endListItem();
            }
            buf.endList();
        }
        return buf.toString();
    }

    protected String genKlassHierarchyHref(InstanceKlass klass) {
        return this.genBaseHref() + "hierarchy=" + klass.getHandle();
    }

    protected String genKlassHierarchyTitle(InstanceKlass klass) {
        Formatter buf = new Formatter(this.genHTML);
        buf.append("Class Hierarchy of ");
        buf.append(this.genKlassTitle(klass));
        return buf.toString();
    }

    protected String genKlassHierarchyLink(InstanceKlass klass) {
        Formatter buf = new Formatter(this.genHTML);
        buf.link(this.genKlassHierarchyHref(klass), this.genKlassHierarchyTitle(klass));
        return buf.toString();
    }

    protected String genHTMLListForSubKlasses(InstanceKlass klass) {
        Formatter buf = new Formatter(this.genHTML);
        Klass subklass = klass.getSubklassKlass();
        if (subklass != null) {
            buf.beginList();
            while (subklass != null) {
                if (subklass instanceof InstanceKlass) {
                    buf.li(this.genKlassLink((InstanceKlass)subklass));
                }
                subklass = subklass.getNextSiblingKlass();
            }
            buf.endList();
        }
        return buf.toString();
    }

    public String genHTMLForKlassHierarchy(InstanceKlass klass) {
        Formatter buf = new Formatter(this.genHTML);
        buf.genHTMLPrologue(this.genKlassHierarchyTitle(klass));
        buf.beginTag("pre");
        buf.append(this.genKlassLink(klass));
        buf.br();
        StringBuffer tabs = new StringBuffer(this.tab);
        InstanceKlass superKlass = klass;
        while ((superKlass = (InstanceKlass)superKlass.getSuper()) != null) {
            buf.append(tabs);
            buf.append(this.genKlassLink(superKlass));
            tabs.append(this.tab);
            buf.br();
        }
        buf.endTag("pre");
        Klass subklass = klass.getSubklassKlass();
        if (subklass != null) {
            buf.h3("Direct Subclasses");
            buf.append(this.genHTMLListForSubKlasses(klass));
        }
        buf.genHTMLEpilogue();
        return buf.toString();
    }

    protected String genDumpKlassHref(InstanceKlass klass) {
        return this.genBaseHref() + "jcore=" + klass.getHandle();
    }

    protected String genDumpKlassLink(InstanceKlass klass) {
        if (!this.genHTML) {
            return "";
        }
        Formatter buf = new Formatter(this.genHTML);
        buf.link(this.genDumpKlassHref(klass), "Create .class File");
        return buf.toString();
    }

    public String genHTML(InstanceKlass klass) {
        Formatter buf = new Formatter(this.genHTML);
        buf.genHTMLPrologue(this.genKlassTitle(klass));
        InstanceKlass superKlass = (InstanceKlass)klass.getSuper();
        if (this.genHTML) {
            buf.beginTag("h3");
            buf.link(this.genKlassHierarchyHref(klass), "View Class Hierarchy");
            buf.endTag("h3");
        }
        buf.h3(this.genDumpKlassLink(klass));
        if (superKlass != null) {
            buf.h3("Super Class");
            buf.append(this.genKlassLink(superKlass));
        }
        buf.append(this.genHTMLListForInterfaces(klass));
        buf.append(this.genHTMLListForFields(klass));
        buf.append(this.genHTMLListForMethods(klass));
        buf.h3("Constant Pool");
        buf.append(this.genConstantPoolLink(klass.getConstants()));
        buf.genHTMLEpilogue();
        return buf.toString();
    }

    protected Address parseAddress(String address) {
        VM vm = VM.getVM();
        Address addr = vm.getDebugger().parseAddress(address);
        return addr;
    }

    protected long addressToLong(Address addr) {
        return VM.getVM().getDebugger().getAddressValue(addr);
    }

    protected Address longToAddress(long addr) {
        return this.parseAddress("0x" + Long.toHexString(addr));
    }

    protected Oop getOopAtAddress(Address addr) {
        OopHandle oopHandle = addr.addOffsetToAsOopHandle(0L);
        return VM.getVM().getObjectHeap().newOop(oopHandle);
    }

    protected Oop getOopAtAddress(String address) {
        Address addr = this.parseAddress(address);
        return this.getOopAtAddress(addr);
    }

    private void dumpKlass(InstanceKlass kls) throws IOException {
        String klassName = kls.getName().asString();
        klassName = klassName.replace('/', File.separatorChar);
        int index = klassName.lastIndexOf(File.separatorChar);
        File dir = null;
        if (index != -1) {
            String dirName = klassName.substring(0, index);
            dir = new File(DUMP_KLASS_OUTPUT_DIR, dirName);
        } else {
            dir = new File(DUMP_KLASS_OUTPUT_DIR);
        }
        dir.mkdirs();
        File f = new File(dir, klassName.substring(klassName.lastIndexOf(File.separatorChar) + 1) + ".class");
        f.createNewFile();
        FileOutputStream fis = new FileOutputStream(f);
        ClassWriter cw = new ClassWriter(kls, fis);
        cw.write();
    }

    public String genDumpKlass(InstanceKlass kls) {
        try {
            this.dumpKlass(kls);
            Formatter buf = new Formatter(this.genHTML);
            buf.genHTMLPrologue(this.genKlassTitle(kls));
            buf.append(".class created for ");
            buf.append(this.genKlassLink(kls));
            buf.genHTMLEpilogue();
            return buf.toString();
        }
        catch (IOException exp) {
            return this.genHTMLErrorMessage(exp);
        }
    }

    protected String genJavaStackTraceTitle(JavaThread thread) {
        Formatter buf = new Formatter(this.genHTML);
        buf.append("Java Stack Trace for ");
        buf.append(thread.getThreadName());
        return buf.toString();
    }

    public String genHTMLForJavaStackTrace(JavaThread thread) {
        Formatter buf = new Formatter(this.genHTML);
        buf.genHTMLPrologue(this.genJavaStackTraceTitle(thread));
        buf.append("Thread state = ");
        buf.append(thread.getThreadState().toString());
        buf.br();
        buf.beginTag("pre");
        for (JavaVFrame vf = thread.getLastJavaVFrameDbg(); vf != null; vf = vf.javaSender()) {
            Address pc;
            Method method = vf.getMethod();
            buf.append(" - ");
            buf.append(this.genMethodLink(method));
            buf.append(" @bci = " + vf.getBCI());
            int lineNumber = method.getLineNumberFromBCI(vf.getBCI());
            if (lineNumber != -1) {
                buf.append(", line = ");
                buf.append(lineNumber);
            }
            if ((pc = vf.getFrame().getPC()) != null) {
                buf.append(", pc = ");
                buf.link(this.genPCHref(this.addressToLong(pc)), pc.toString());
            }
            if (vf.isCompiledFrame()) {
                buf.append(" (Compiled");
            } else if (vf.isInterpretedFrame()) {
                buf.append(" (Interpreted");
            }
            if (vf.mayBeImpreciseDbg()) {
                buf.append("; information may be imprecise");
            }
            buf.append(")");
            buf.br();
        }
        buf.endTag("pre");
        buf.genHTMLEpilogue();
        return buf.toString();
    }

    public String genHTMLForHyperlink(String href) {
        if (href.startsWith("klass=")) {
            href = href.substring(href.indexOf(61) + 1);
            Oop obj = this.getOopAtAddress(href);
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(obj instanceof InstanceKlass, "class= href with improper InstanceKlass!");
            }
            return this.genHTML((InstanceKlass)obj);
        }
        if (href.startsWith("method=")) {
            href = href.substring(href.indexOf(61) + 1);
            Oop obj = this.getOopAtAddress(href);
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(obj instanceof Method, "method= href with improper Method!");
            }
            return this.genHTML((Method)obj);
        }
        if (href.startsWith("nmethod=")) {
            String addr = href.substring(href.indexOf(61) + 1);
            Object obj = VMObjectFactory.newObject(NMethod.class, this.parseAddress(addr));
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(obj instanceof NMethod, "nmethod= href with improper NMethod!");
            }
            return this.genHTML((NMethod)obj);
        }
        if (href.startsWith("pc=")) {
            String address = href.substring(href.indexOf(61) + 1);
            return this.genHTML(this.parseAddress(address));
        }
        if (href.startsWith("pc_multiple=")) {
            int indexOfComma = href.indexOf(44);
            if (indexOfComma == -1) {
                String firstPC = href.substring(href.indexOf(61) + 1);
                return this.genHTMLForRawDisassembly(this.parseAddress(firstPC), null);
            }
            String firstPC = href.substring(href.indexOf(61) + 1, indexOfComma);
            return this.genHTMLForRawDisassembly(this.parseAddress(firstPC), href.substring(indexOfComma + 1));
        }
        if (href.startsWith("interp_codelets")) {
            return this.genInterpreterCodeletLinksPage();
        }
        if (href.startsWith("hierarchy=")) {
            href = href.substring(href.indexOf(61) + 1);
            Oop obj = this.getOopAtAddress(href);
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(obj instanceof InstanceKlass, "class= href with improper InstanceKlass!");
            }
            return this.genHTMLForKlassHierarchy((InstanceKlass)obj);
        }
        if (href.startsWith("cpool=")) {
            href = href.substring(href.indexOf(61) + 1);
            Oop obj = this.getOopAtAddress(href);
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(obj instanceof ConstantPool, "cpool= href with improper ConstantPool!");
            }
            return this.genHTML((ConstantPool)obj);
        }
        if (href.startsWith("jcore=")) {
            href = href.substring(href.indexOf(61) + 1);
            Oop obj = this.getOopAtAddress(href);
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(obj instanceof InstanceKlass, "jcore= href with improper InstanceKlass!");
            }
            return this.genDumpKlass((InstanceKlass)obj);
        }
        if (href.startsWith("jcore_multiple=")) {
            href = href.substring(href.indexOf(61) + 1);
            Formatter buf = new Formatter(this.genHTML);
            buf.genHTMLPrologue();
            StringTokenizer st = new StringTokenizer(href, ",");
            while (st.hasMoreTokens()) {
                Oop obj = this.getOopAtAddress(st.nextToken());
                if (Assert.ASSERTS_ENABLED) {
                    Assert.that(obj instanceof InstanceKlass, "jcore_multiple= href with improper InstanceKlass!");
                }
                InstanceKlass kls = (InstanceKlass)obj;
                try {
                    this.dumpKlass(kls);
                    buf.append(".class created for ");
                    buf.append(this.genKlassLink(kls));
                }
                catch (Exception exp) {
                    buf.bold("can't .class for " + this.genKlassTitle(kls) + " : " + exp.getMessage());
                }
                buf.br();
            }
            buf.genHTMLEpilogue();
            return buf.toString();
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(false, "unknown href link!");
        }
        return null;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                HTMLGenerator.initialize();
            }
        });
    }

    class RawCodeVisitor
    implements InstructionVisitor {
        private int instrSize = 0;
        private Formatter buf;
        private SymbolFinder symFinder = HTMLGenerator.this.createSymbolFinder();

        RawCodeVisitor(Formatter buf) {
            this.buf = buf;
        }

        public int getInstructionSize() {
            return this.instrSize;
        }

        @Override
        public void prologue() {
        }

        @Override
        public void visit(long currentPc, Instruction instr) {
            String href = null;
            if (instr.isCall()) {
                CallInstruction call = (CallInstruction)instr;
                sun.jvm.hotspot.asm.Address addr = call.getBranchDestination();
                href = HTMLGenerator.this.genPCHref(currentPc, addr);
            }
            this.instrSize += instr.getSize();
            this.buf.append("0x");
            this.buf.append(Long.toHexString(currentPc));
            this.buf.append(':');
            this.buf.append(HTMLGenerator.this.tab);
            if (href != null) {
                this.buf.link(href, instr.asString(currentPc, this.symFinder));
            } else {
                this.buf.append(instr.asString(currentPc, this.symFinder));
            }
            this.buf.br();
        }

        @Override
        public void epilogue() {
        }
    }

    static class Formatter {
        boolean html;
        StringBuffer buf = new StringBuffer();

        Formatter(boolean h) {
            this.html = h;
        }

        void append(String s) {
            this.buf.append(s);
        }

        void append(int s) {
            this.buf.append(s);
        }

        void append(char s) {
            this.buf.append(s);
        }

        void append(StringBuffer s) {
            this.buf.append(s);
        }

        void append(Formatter s) {
            this.buf.append(s);
        }

        StringBuffer getBuffer() {
            return this.buf;
        }

        public String toString() {
            return this.buf.toString();
        }

        void wrap(String tag, String text) {
            this.wrap(tag, tag, text);
        }

        void wrap(String before, String after, String text) {
            this.beginTag(before);
            this.append(text);
            this.endTag(after);
        }

        void h1(String s) {
            this.nl();
            this.wrap("h1", s);
            this.nl();
        }

        void h2(String s) {
            this.nl();
            this.wrap("h2", s);
            this.nl();
        }

        void h3(String s) {
            this.nl();
            this.wrap("h3", s);
            this.nl();
        }

        void h4(String s) {
            this.nl();
            this.wrap("h4", s);
            this.nl();
        }

        void beginList() {
            this.beginTag("ul");
            this.nl();
        }

        void endList() {
            this.endTag("ul");
            this.nl();
        }

        void beginListItem() {
            this.beginTag("li");
        }

        void endListItem() {
            this.endTag("li");
            this.nl();
        }

        void li(String s) {
            this.wrap("li", s);
            this.nl();
        }

        void beginTable(int border) {
            this.beginTag("table border='" + border + "'");
        }

        void cell(String s) {
            this.wrap("td", s);
        }

        void headerCell(String s) {
            this.wrap("th", s);
        }

        void endTable() {
            this.endTag("table");
        }

        void link(String href, String text) {
            this.wrap("a href='" + href + "'", "a", text);
        }

        void beginTag(String s) {
            if (this.html) {
                this.append("<");
                this.append(s);
                this.append(">");
            }
        }

        void endTag(String s) {
            if (this.html) {
                this.append("</");
                this.append(s);
                this.append(">");
            } else {
                if (s.equals("table") || s.equals("tr")) {
                    this.nl();
                }
                if (s.equals("td") || s.equals("th")) {
                    this.append(" ");
                }
            }
        }

        void bold(String s) {
            this.wrap("b", s);
        }

        void nl() {
            if (!this.html) {
                this.buf.append("\n");
            }
        }

        void br() {
            if (this.html) {
                this.append("<br>");
            } else {
                this.append("\n");
            }
        }

        void genEmptyHTML() {
            if (this.html) {
                this.append("<html></html>");
            }
        }

        void genHTMLPrologue() {
            if (this.html) {
                this.append("<html><body>");
            }
        }

        void genHTMLPrologue(String title) {
            if (this.html) {
                this.append("<html><head><title>");
                this.append(title);
                this.append("</title></head>");
                this.append("<body>");
            }
            this.h2(title);
        }

        void genHTMLEpilogue() {
            if (this.html) {
                this.append("</body></html>");
            }
        }
    }
}

