/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.Mark;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.runtime.Thread;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class ObjectMonitor
extends VMObject {
    private static ObjectHeap heap;
    private static long headerFieldOffset;
    private static long objectFieldOffset;
    private static long ownerFieldOffset;
    private static long FreeNextFieldOffset;
    private static CIntegerField countField;
    private static CIntegerField waitersField;
    private static CIntegerField recursionsField;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        heap = VM.getVM().getObjectHeap();
        Type type = db.lookupType("ObjectMonitor");
        Field f = type.getField("_header");
        headerFieldOffset = f.getOffset();
        f = type.getField("_object");
        objectFieldOffset = f.getOffset();
        f = type.getField("_owner");
        ownerFieldOffset = f.getOffset();
        f = type.getField("FreeNext");
        FreeNextFieldOffset = f.getOffset();
        countField = type.getCIntegerField("_count");
        waitersField = type.getCIntegerField("_waiters");
        recursionsField = type.getCIntegerField("_recursions");
    }

    public ObjectMonitor(Address addr) {
        super(addr);
    }

    public Mark header() {
        return new Mark(this.addr.addOffsetTo(headerFieldOffset));
    }

    public boolean isEntered(Thread current) {
        Address o = this.owner();
        return ((Object)current.threadObjectAddress()).equals(o) || current.isLockOwned(o);
    }

    public Address owner() {
        return this.addr.getAddressAt(ownerFieldOffset);
    }

    public long waiters() {
        return waitersField.getValue(this.addr);
    }

    public Address freeNext() {
        return this.addr.getAddressAt(FreeNextFieldOffset);
    }

    public long count() {
        return countField.getValue(this.addr);
    }

    public long recursions() {
        return recursionsField.getValue(this.addr);
    }

    public OopHandle object() {
        return this.addr.getOopHandleAt(objectFieldOffset);
    }

    public long contentions() {
        long count = this.count();
        if (VM.getVM().getOS().equals("win32")) {
            return count > 0L ? count - 1L : 0L;
        }
        return count;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ObjectMonitor.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

