/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.opto;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.ci.ciMethod;
import sun.jvm.hotspot.ci.ciObjectFactory;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.opto.JVMState;
import sun.jvm.hotspot.runtime.StaticBaseConstructor;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.GrowableArray;

public class InlineTree
extends VMObject {
    private static AddressField callerJvmsField;
    private static AddressField methodField;
    private static AddressField callerTreeField;
    private static AddressField subtreesField;
    private static StaticBaseConstructor inlineTreeConstructor;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("InlineTree");
        callerJvmsField = type.getAddressField("_caller_jvms");
        methodField = type.getAddressField("_method");
        callerTreeField = type.getAddressField("_caller_tree");
        subtreesField = type.getAddressField("_subtrees");
    }

    public InlineTree(Address addr) {
        super(addr);
    }

    public InlineTree callerTree() {
        Address addr = callerTreeField.getValue(this.getAddress());
        if (addr == null) {
            return null;
        }
        return new InlineTree(addr);
    }

    public ciMethod method() {
        return (ciMethod)ciObjectFactory.get(methodField.getValue(this.getAddress()));
    }

    public JVMState callerJvms() {
        return JVMState.create(callerJvmsField.getValue(this.getAddress()));
    }

    public int callerBci() {
        JVMState jvms = this.callerJvms();
        return jvms != null ? jvms.bci() : -1;
    }

    public GrowableArray<InlineTree> subtrees() {
        Address addr = this.getAddress().addOffsetTo(subtreesField.getOffset());
        return GrowableArray.create(addr, inlineTreeConstructor);
    }

    public void printImpl(PrintStream st, int indent) {
        for (int i = 0; i < indent; ++i) {
            st.print(" ");
        }
        st.printf(" @ %d ", this.callerBci());
        this.method().printShortName(st);
        st.println();
        GrowableArray<InlineTree> subt = this.subtrees();
        for (int i = 0; i < subt.length(); ++i) {
            subt.at(i).printImpl(st, indent + 2);
        }
    }

    public void print(PrintStream st) {
        this.printImpl(st, 2);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                InlineTree.initialize(VM.getVM().getTypeDataBase());
            }
        });
        inlineTreeConstructor = new StaticBaseConstructor<InlineTree>(InlineTree.class);
    }
}

