/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.x86;

import sun.jvm.hotspot.asm.LogicInstruction;
import sun.jvm.hotspot.asm.Operand;
import sun.jvm.hotspot.asm.SymbolFinder;
import sun.jvm.hotspot.asm.x86.X86Instruction;

public class X86LogicInstruction
extends X86Instruction
implements LogicInstruction {
    private final Operand operand1;
    private final Operand operand2;
    private final int operation;

    public X86LogicInstruction(String name, int operation, Operand op1, Operand op2, int size, int prefixes) {
        super(name, size, prefixes);
        this.operation = operation;
        this.operand1 = op1;
        this.operand2 = op2;
    }

    @Override
    public String asString(long currentPc, SymbolFinder symFinder) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getPrefixString());
        buf.append(this.getName());
        buf.append(spaces);
        buf.append(this.getOperandAsString(this.operand1));
        if (this.operand2 != null) {
            buf.append(comma);
            buf.append(this.getOperandAsString(this.operand2));
        }
        return buf.toString();
    }

    @Override
    public Operand getLogicDestination() {
        return this.operand1;
    }

    @Override
    public Operand[] getLogicSources() {
        return new Operand[]{this.operand2};
    }

    @Override
    public int getOperation() {
        return this.operation;
    }

    public boolean isLogic() {
        return true;
    }
}

