/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.PCRelativeAddress;
import sun.jvm.hotspot.asm.sparc.SPARCInstructionFactory;
import sun.jvm.hotspot.asm.sparc.SPARCV9InstructionFactory;
import sun.jvm.hotspot.asm.sparc.V9BranchDecoder;

abstract class V9CCBranchDecoder
extends V9BranchDecoder {
    V9CCBranchDecoder() {
    }

    abstract int getConditionFlag(int var1);

    @Override
    Instruction decode(int instruction, SPARCInstructionFactory factory) {
        SPARCV9InstructionFactory v9factory = (SPARCV9InstructionFactory)factory;
        int conditionFlag = this.getConditionFlag(instruction);
        boolean predictTaken = V9CCBranchDecoder.getPredictTaken(instruction);
        int conditionCode = V9CCBranchDecoder.getConditionCode(instruction);
        boolean annuled = V9CCBranchDecoder.getAnnuledBit(instruction);
        String name = this.getConditionName(conditionCode, annuled);
        PCRelativeAddress addr = new PCRelativeAddress(V9CCBranchDecoder.extractSignedIntFromNBits(instruction, 19) << 2);
        return v9factory.newV9BranchInstruction(name, addr, annuled, conditionCode, predictTaken, conditionFlag);
    }
}

